<?php
$page_security = 'SA_COMPLAINTENTRY';
$path_to_root = "..";
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Complaint Entry"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/CRM/includes/db/complaint_db.inc");
include_once($path_to_root . "/CRM/includes/db/complaint_type_db.inc");

simple_page_mode(true);
//----------------------------------------------------------------------------------------------------

function can_process($selected_id=-1){

	global $Refs;

	if(!$_POST['customer']){
		display_error(_("Customer must be selected"));
		set_focus('customer');
		return false;
	}
	if(!$_POST['complaint_type']){
		display_error(_("Complaint Type must be selected"));
		set_focus('customer_id');
		return false;
	}
	if(!strlen($_POST['cust_memo'])){
		display_error(_("Comments from customer can not be empty"));
		set_focus('cust_memo');
		return false;
	}
	$complaint_type = get_complaint_type($_POST['complaint_type']);
	if($complaint_type['order_compulsory'] && !$_POST['order_no']){
		display_error("Sales Order must be selected for selected complaint type");
		return false;
	}
	if(!check_reference(get_post('ref'), ST_COMPLAINT)){
		$_POST['ref'] = $Refs->get_next(ST_COMPLAINT);
		display_error("The Reference is auto updated and transaction can now be processed, 
		If it is not auto updated contact admin");
		set_focus('ref');
		return false;
	}
	return true;
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' && can_process()){
	$complaint_id = register_complain($_POST['ref'], $_POST['customer'], $_POST['order_no'], 
	$_POST['complaint_type'], $_POST['cust_memo']);
	if($complaint_id){
		display_notification('Your complaint successfully registered, Your complaint ID is '.
		$_POST['ref'].', <b><a href="'.$path_to_root.'/CRM/inquiry/complain_inquiry.php">
		Go to Complaint Inquiry</a></b>');
		$Refs->save(ST_COMPLAINT, $complaint_id, $_POST['ref']);
		$Mode = 'RESET';
	}
	else{
		display_notification(_("We could not register the complaint"));
	}
}

if ($Mode == 'RESET'){
	$selected_id = -1;
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

if(list_updated('order_no')){
	$Ajax->activate('_page_body');
}
//-------------------------------------------------------------------------
start_form();

start_table(TABLESTYLE6_BOX, "", 0, 0, 0, null, null, "3px solid #656E79;");

ref_row(_("Complaint ID:"), 'ref', '', $Refs->get_next(ST_COMPLAINT, null, array('date'=>Today())), 
false, ST_COMPLAINT, array(), 'readonly');
customer_list_row(_("Customer:"), 'customer', null, _("Select Customer"), true);
customer_order_list_row(_("Select Order:"), 'order_no', null, $_POST['customer'], true, true);
if($_POST['order_no']){
	$ref = get_reference(ST_SALESORDER, $_POST['order_no']);
	label_row(_("View Sales Order:"), get_customer_trans_view_str(ST_SALESORDER, $_POST['order_no'], 
	$ref, false, '', '', $path_to_root));
}
complaint_type_list_row(_("Complaint Type:"), 'complaint_type', null, false, false, true);
textarea_row(_("Comment From Customer:"), 'cust_memo', null, 35, 4);

end_table(1);
echo "<center>";
submit_add_or_update($selected_id == -1, false, false, false, "Register");
echo "</center>";

end_form();
end_page();


?>