<?php


function add_agreement_pricing($description, $payment_terms, $price,$opportunity_id=0)
{
	$sql = "INSERT INTO ".TB_PREF."agreement_pricing 
	(description, payment_terms, price,opportunity_id) VALUES 
	(".db_escape($description).",". db_escape($payment_terms)."," .db_escape($price)."," .db_escape($opportunity_id).")";

   	db_query($sql,"The Agreement Pricing could not be added");
   	$sql2 = "SELECT MAX(id) AS id FROM ".TB_PREF."agreement_pricing";
	$result2 = db_query($sql2);
	$myrow2 = db_fetch($result2);

	 add_audit_trail(SA_AGREEMENT_PRICING, $myrow2['id'], Today(), _("Create New Agreement Pricing"));
}

function update_agreement_pricing($selected_id, $description, $payment_terms, $price)
{
	$sql = "UPDATE ".TB_PREF."agreement_pricing SET description=".db_escape($description).", payment_terms =".db_escape($payment_terms)." 
	 , price =".db_escape($price)." 
	 WHERE id = ".db_escape($selected_id);

	 // display_error($sql);
	 // exit();
	 add_audit_trail(SA_AGREEMENT_PRICING, $selected_id, Today(), _("Update Agreement Pricing"));

   	db_query($sql,"The Agreement Pricing could not be updated");
}

function delete_agreement_pricing($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."agreement_pricing WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete Agreement Pricing");
	 add_audit_trail(SA_AGREEMENT_PRICING, $selected_id, Today(), _("Delete Agreement Pricing"));
}

function get_agreement_pricing($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."agreement_pricing";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY description";
	return db_query($sql,"could not get Agreement Pricing");
}

function get_agreements_pricing($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."agreement_pricing WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get Agreement Pricing");
	return db_fetch($result);
}

// function get_sales_group_name($group_no)
// {
// 	$sql = "SELECT description FROM ".TB_PREF."groups WHERE id = ".db_escape($group_no);
// 	$result = db_query($sql, "could not get group");
// 	$row = db_fetch($result);
// 	return $row[0];
// }


function get_agreement_pricing_opportunity($opportunity_id)
{
	$sql = "SELECT * FROM ".TB_PREF."agreement_pricing WHERE opportunity_id=".db_escape($opportunity_id);
	
	// display_error($sql);
	$result = db_query($sql, "could not get complaint agreement");
	
	return db_fetch($result);
}


