<?php
function register_complain($ref, $customer, $sales_order, $complaint_type, $cust_memo_){
	$user = $_SESSION['wa_current_user']->user;
	$date = date2sql(Today());
	$sql = "INSERT INTO ".TB_PREF."complaint 
	(reference, complaint_date, debtor_no, sales_order, complaint_type, cust_memo, user_id) 
	VALUES (".db_escape($ref).",".db_escape($date).",".db_escape($customer).",".db_escape($sales_order)
	.",".db_escape($complaint_type).",".db_escape($cust_memo_).",".db_escape($user).")";

	db_query($sql);

	$id = db_insert_id();
	if($id){
		add_audit_trail(SM_COMPLAINT, $id, Today(), _("New Complaint Registered"));
		return $id;
	}
	else{
		return false;
	}
}


function get_sql_for_complaint_inquiry($from, $to, $ref, $complaint_type, $customer, $status){
	$sql = "SELECT reference, complaint_date, debtor_no, sales_order, complaint_type, cust_memo, user_id,
	close_date, status, id FROM ".TB_PREF."complaint WHERE id<>0";

	if($ref){
		$sql .= " AND reference=".db_escape($ref);
	}
	else{
		$sql .= " AND complaint_date>=".db_escape(date2sql($from));
		$sql .= " AND complaint_date<=".db_escape(date2sql($to));

		if($complaint_type){
			$sql .= " AND complaint_type=".db_escape($complaint_type);
		}
		if($customer){
			$sql .= " AND debtor_no=".db_escape($customer);
		}
		if($status){
			$status--;
			$sql .= " AND status=".db_escape($status);
		}
	}
	$sql .= " ORDER BY id DESC";
	return $sql;
}

function get_count_for_complaint_inquiry($from, $to, $ref, $complaint_type, $customer, $status){
	$sql = "SELECT reference, complaint_date, debtor_no, sales_order, complaint_type, user_id,
	close_date, status, id FROM ".TB_PREF."complaint WHERE id<>0";

	if($ref){
		$sql .= " AND reference=".db_escape($ref);
	}
	else{
		$sql .= " AND complaint_date>=".db_escape(date2sql($from));
		$sql .= " AND complaint_date<=".db_escape(date2sql($to));

		if($complaint_type){
			$sql .= " AND complaint_type=".db_escape($complaint_type);
		}
		if($customer){
			$sql .= " AND debtor_no=".db_escape($customer);
		}
	}
	$res = db_query($sql);

	$open = $closed = 0;
	while($row = db_fetch($res)){
		if($row['status'])
			$closed++;
		else
			$open++;
	}

	$result = array();
	$result['open'] = $open;
	$result['closed'] = $closed;

	return $result;
}

?>