<?php

function add_complaint_type($complaint_type, $order_compulsory)
{
	$sql = "INSERT INTO ".TB_PREF."complaint_types (complaint_type, order_compulsory) 
	VALUES (".db_escape($complaint_type).",".db_escape($order_compulsory).")";
	db_query($sql, "could not add complaint type");	

	$sql2 = "SELECT MAX(id) AS id FROM ".TB_PREF."complaint_types";
	$result2 = db_query($sql2);
	$myrow2 = db_fetch($result2);

	add_audit_trail(SM_COMPLAINTTYPES, $myrow2['id'], Today(), _("Created New Complaint Type"));
}

function update_complaint_type($id, $complaint_type, $order_compulsory){

	$sql = "UPDATE ".TB_PREF."complaint_types SET complaint_type = ".db_escape($complaint_type).",
	order_compulsory =".db_escape($order_compulsory)." 
	WHERE id = ".db_escape($id);
	
	db_query($sql, "could not update complaint type");

	add_audit_trail(SM_COMPLAINTTYPES, $id, Today(), _("Updated Complaint Type"));					
}

function delete_complaint_type($id){

	$sql="DELETE FROM ".TB_PREF."complaint_types WHERE id=".db_escape($id);
	db_query($sql,"The Complaint type record could not be deleted");

	add_audit_trail(SM_COMPLAINTTYPES, $selected_id, Today(), _("Deleted Complaint Types"));
}


function get_all_complaint_types($all=false){
	$sql = "SELECT * FROM ".TB_PREF."complaint_types";
	if (!$all)
		$sql .= " WHERE !inactive";
	
	return db_query($sql, "could not get all complaint types");
} 

function get_complaint_type($id)
{
	$sql = "SELECT * FROM ".TB_PREF."complaint_types WHERE id=".db_escape($id);
	
	$result = db_query($sql, "could not get complaint type");
	
	return db_fetch($result);
}

function get_complaint_type_name($id)
{
	$sql = "SELECT complaint_type FROM ".TB_PREF."complaint_types WHERE id=".db_escape($id);
	
	$result = db_query($sql, "could not get complaint type");
	
	$row = db_fetch_row($result);
	return $row[0];
}


