<?php 

function add_crm_customer($cont_per='', $comp_name='', $desg='', $phone='', $sec_phone='', $email_addr='', $attach_front='', $attach_back='', $mobile = '', $mobile_1 = '', $fax = '',$postal_address = '' ,$web = '' ){
	$user = $_SESSION['wa_current_user']->user;
	$trans_date = date2sql(Today());

	$sql = "INSERT INTO ".TB_PREF."crm_contact_form(cont_per, 
			comp_name, 
			desg, 
			user, 
			trans_date,  
			phone, 
			sec_phone, 
			email_addr,
			mobile, 
			mobile_1, 
			fax, 
			postal_address,
			web,
		    attach_front, 
		    attach_back) VALUES (
		".db_escape($cont_per).",
		".db_escape($comp_name).",
		".db_escape($desg).",
		".db_escape($user).",
		".db_escape($trans_date).",
		".db_escape($phone).", 
		".db_escape($sec_phone).", 
		".db_escape($email_addr).",
		".db_escape($mobile).",
		".db_escape($mobile_1).",
		".db_escape($fax).",
		".db_escape($postal_address).",
		".db_escape($web).",
		".db_escape($attach_front).",
		".db_escape($attach_back)."
		)";
		
		db_query($sql,"");
		$ins_id = db_insert_id();

		add_audit_trail(ST_CONTACT_PERSON, $ins_id , date('Y-m-d'), _("Contact Person Created"));

		create_auto_customer($ins_id, $cont_per, $mobile, $email_addr, $postal_address);


		return $ins_id;
}

function update_contact_person($id,$cont_per='', $comp_name='', $desg='', $phone='', $sec_phone='', $email_addr='', $attach_front='', $attach_back='', $mobile = '', $mobile_1 = '', $fax = '',$postal_address = '', $web=''){
		$sql = "UPDATE ".TB_PREF."crm_contact_form SET
		cont_per=".db_escape($cont_per).",
		comp_name=".db_escape($comp_name).",
		desg=".db_escape($desg).", 
		phone=".db_escape($phone).", 
		sec_phone=".db_escape($sec_phone).", 
		email_addr='$email_addr',
		mobile='$mobile',
		mobile_1='$mobile_1',
		fax='$fax',
		postal_address='$postal_address',
		web='$web',
		attach_front='".$attach_front."',
		attach_back='".$attach_back."'
		WHERE cust_id = ".db_escape($id);
		db_query($sql,"");
		


		add_audit_trail(ST_CONTACT_PERSON, $id , date('Y-m-d'), _("Contact Person Updated"));
}



function add_crm_opportunity($cont_per, $oppr_list='', $remarks='', $status='',$attachment=''){
	$user = $_SESSION['wa_current_user']->user;
	$trans_date = date2sql(Today());
	$sql = "INSERT INTO ".TB_PREF."crm_opportunity(cont_per_id,oppr_list, remarks, status, user, trans_date, attach) VALUES (
		".db_escape($cont_per).",
		".db_escape($oppr_list).",
		".db_escape($remarks).",
		".db_escape($status).",
		'$user',
		'$trans_date',
		'$attachment'
		)";
		display_notification("Opportunity Has Been Registerd");
		return db_query($sql,"");
}



function get_crm_contact_person_inq($search_by = '', $search = '', $userid=false){
	$current_user = $_SESSION['wa_current_user']->user;
	$allow = get_user($current_user)['all_contact_person'];

	$sql = "SELECT 
			cust_id,
			cont_per,
			comp_name,
			desg,
			'',
			mobile,
			mobile_1,
			phone,
			sec_phone,
			email_addr,
			trans_date,
			user
	 FROM ".TB_PREF."crm_contact_form ";
	if($allow == 1){
			$sql .=" WHERE 1";						
	}else{
		$sql .=" WHERE user =".db_escape($current_user);	
	}

	 if($search_by == 'MOBILE')
		 $sql .=" AND mobile LIKE '%".$search."%'";

	 if($search_by == 'NAME')
		 $sql .=" AND cont_per LIKE '%".$search."%'";

	 if($search_by == 'PHONE')
		 $sql .=" AND phone LIKE '%".$search."%'";

	 if($search_by == 'EMAIL')
		 $sql .=" AND email_addr LIKE '%".$search."%'";

	 if($search_by == 'COMPANY')
		 $sql .=" AND comp_name LIKE '%".$search."%'";
	 if($userid)
	 	$sql .= " AND user = ".db_escape($userid);

	return $sql;
}

function get_crm_opportunity_inq($from='', $to='',$status=''){
	$sql = "SELECT 
			id,
			oppr_list,
			remarks,
			status,
			attach
	 FROM ".TB_PREF."crm_opportunity WHERE ";
	 
	  if($from != '' && $to != '')
		 $sql .=" trans_date >= ".db_escape(date2sql($from))."
		 		  AND trans_date <= ".db_escape(date2sql($to))." ";
	  if($status)
		 $sql .="AND status = ".$status;

	return $sql;
}

function get_crm_opportunity_by_person_id($id=''){

	$sql = "SELECT * FROM ".TB_PREF."projects WHERE !closed AND contact_person = ".db_escape($id);
	$result = db_query($sql);
	return $result;
}


function get_contact_person_id($id=''){
	$sql = "SELECT * FROM ".TB_PREF."crm_contact_form WHERE cust_id =".db_escape($id);
	$result = db_query($sql);
	return db_fetch($result);
}


function opportunities_count($id){
	$sql = "SELECT COUNT(*) as c FROM ".TB_PREF."projects WHERE !closed AND contact_person = ".$id;
	$result = db_query($sql);
	return db_fetch($result)['c'];
}


function delete_contact_person($id){
$sql = "DELETE FROM ".TB_PREF."crm_contact_form WHERE cust_id = ".$id;
db_query($sql);
}


function create_auto_customer($cp_id=null, $cust_name=null, $mobile=null, $email=null, $address=null){

		$cash_customer_row = get_cash_customer_data();

  		add_customer($cust_name, 
  		$cust_name, 
  		$address, 
  		$cash_customer_row['tax_id'], 
  		$cash_customer_row['curr_code'], 
  		null,
  		null,
  		$cash_customer_row['credit_status'],
  		$cash_customer_row['payment_terms'],
  		null,
  		null,
  		null,
  		$cash_customer_row['sales_type'], null, null, null, null, null, null, null, null, $cp_id);

  		$selected_customer= get_max_branch_id()['debtor_no'];
		 

		$cash_branch_row = get_branch_by_customer_id($cash_customer_row['debtor_no']);
		add_branch($selected_customer, $cust_name,
		$cust_name, 
		'', 
		$cash_branch_row['salesman'], 
		$cash_branch_row['area'], 
		$cash_branch_row['tax_group_id'], 
		$cash_branch_row['sales_account'],
		$cash_branch_row['sales_discount_account'], 
		$cash_branch_row['receivables_account'],
		$cash_branch_row['payment_discount_account'], 
		$cash_branch_row['default_location'],
		null,
		$cash_branch_row['group_no'],
		$cash_branch_row['default_ship_via']);

		$selected_branch = db_insert_id();
		$pers_id = add_crm_person($cust_name, $cust_name, $cust_name, $address, $mobile, null, null, $email);
		add_crm_contact('cust_branch', 'general', $selected_branch, $pers_id);
		add_crm_contact('customer', 'general', $selected_customer, $pers_id);

}

function CheckCustomerNameExist($debtor_name=null){
			$sql = " SELECT COUNT(*) as exist FROM  ".TB_PREF."debtors_master 
					 WHERE name = ".db_escape($debtor_name)." OR debtor_ref = ".db_escape($debtor_name);
			$result = db_query($sql);
			return db_fetch($result)['exist'];
}



?>