<?php 

function add_crm_real_estate_form($full_name='', $email= '', $phone ='', $person_type='', $note='' ){
	
	$sql = "INSERT INTO ".TB_PREF."real_estate_form(full_name, email, phone, person_type, note) 
	VALUES (".db_escape($full_name).",".db_escape($email).",".db_escape($phone).", ".db_escape($person_type).",
	".db_escape($note).")";
	db_query($sql);
	return db_insert_id();
}


function add_crm_real_estate_buyer($id, $looking_for='', $property_type= '', $community_pref ='', $phase_pref='', $layout='', $no_of_br='', $single_row= '', $availability_type ='', $payment_pref='', $bank='', $specific_req ='', $days='', 
	$budget='' , $source=0, $looking_type=0 ,$serious_client=0,$source_text=''){
	
	$sql = "INSERT INTO ".TB_PREF."real_estate_buyer(looking_for, property_type, community_pref, phase_pref, layout, no_of_br,
	single_row, availability_type, payment_pref, bank, specific_req, days, budget, real_estate_id, sources,looking_type , serious_client,source_text) 
	VALUES (".db_escape($looking_for).",".db_escape($property_type).",".db_escape($community_pref).",".db_escape($phase_pref).
	",".db_escape($layout).",".db_escape($no_of_br).",".db_escape($single_row).",".db_escape($availability_type).","
	.db_escape($payment_pref).",".db_escape($bank).",".db_escape($specific_req).",".db_escape($days).","
	.db_escape($budget).",".db_escape($id).","
	.db_escape($source).",".db_escape($looking_type).",".db_escape($serious_client).","
	.db_escape($source_text).")";
	

	db_query($sql);
	$record_id = db_insert_id();
	set_audit_trail(ST_REALESTATE, $id, date('Y-m-d'), _("Buyer Record Created"));
}

function add_crm_real_estate_seller($id, $offer_type='', $property_category= '', $br ='', $community='', $phase='', 
	$location_detail='', $bua= '', $plot ='', $view='', $availability_status='', $rent_amount ='', $expiry_date='', 
	$vaastu_compliant='', $financial_status ='', $mortgage_amount='', $submit_doc='' ){
	
	$sql = "INSERT INTO ".TB_PREF."real_estate_seller(offer_type, property_category, br, community, phase, location_detail,
	bua, plot, view, availability_status, rent_amount, expiry_date, vaastu_compliant, financial_status, mortgage_amount,
	submit_doc, real_estate_id) 
	VALUES (".db_escape($offer_type).",".db_escape($property_category).",".db_escape($br).", ".db_escape($community).","
	.db_escape($phase).",".db_escape($location_detail).",".db_escape($bua).",".db_escape($plot).",".db_escape($view).","
	.db_escape($availability_status).",".db_escape($rent_amount).",".db_escape(date2sql($expiry_date)).","
	.db_escape($vaastu_compliant).",".db_escape($financial_status).",".db_escape($mortgage_amount).",".db_escape($submit_doc).","
	.db_escape($id).")";
	db_query($sql);
	$record_id = db_insert_id();
	set_audit_trail(ST_REALESTATE, $id, date('Y-m-d'), _("Seller Record Created"));
}


function update_crm_real_estate_form($selected_id,$full_name='', $email= '', $phone ='', $person_type='', $note='' )
{
	$sql ="UPDATE ".TB_PREF."real_estate_form SET 
	full_name=".db_escape($full_name).",
	email=".db_escape($email).",
	phone=".db_escape($phone).",
	person_type=".db_escape($person_type).",
	note=".db_escape($note)."
	WHERE id=".db_escape($selected_id);
	// display_error($sql);exit();
	db_query($sql);
}


function update_crm_real_estate_buyer($selected_id, $looking_for='', $property_type= '', $community_pref ='', $phase_pref='', $layout='', $no_of_br='', $single_row= '', $availability_type ='', $payment_pref='', $bank='', $specific_req ='', $days='', $budget='' , $sources=0, $looking_type=0 ,$serious_client=0,$source_text=''){


	$sql="UPDATE ".TB_PREF."real_estate_buyer SET 
	looking_for=".db_escape($looking_for).",
	property_type=".db_escape($property_type).",
	community_pref=".db_escape($community_pref).",
	phase_pref=".db_escape($phase_pref).",
	layout=".db_escape($layout).",
	no_of_br=".db_escape($no_of_br).",
	single_row=".db_escape($single_row).",
	availability_type=".db_escape($availability_type).",
	payment_pref=".db_escape($payment_pref).",
	bank=".db_escape($bank).",
	specific_req=".db_escape($specific_req).",
	days=".db_escape($days).",
	budget=".db_escape($budget).",
	looking_type=".db_escape($looking_type).",
	sources=".db_escape($sources).",
	serious_client=".db_escape($serious_client).",
	source_text=".db_escape($source_text)."

	WHERE id=".db_escape($selected_id);
	
	db_query($sql);
	set_audit_trail(ST_REALESTATE, $selected_id, date('Y-m-d'), _("Buyer Record Updated"));
}


function update_crm_real_estate_seller($id, $offer_type='', $property_category= '', $br ='', $community='', $phase='', 
	$location_detail='', $bua= '', $plot ='', $view='', $availability_status='', $rent_amount ='', $expiry_date='', 
	$vaastu_compliant='', $financial_status ='', $mortgage_amount='', $submit_doc='' )
{
	

	$sql= "UPDATE ".TB_PREF."real_estate_seller SET
	offer_type=".db_escape($offer_type).",
	property_category=".db_escape($property_category).",
	br=".db_escape($br).",
	community=".db_escape($community).",
	phase=".db_escape($phase).",
	location_detail=".db_escape($location_detail).",
	bua=".db_escape($bua).",
	plot=".db_escape($plot).",
	view=".db_escape($view).",
	availability_status=".db_escape($availability_status).",
	rent_amount=".db_escape($rent_amount).",
	expiry_date=".db_escape(date2sql($expiry_date)).",
	vaastu_compliant=".db_escape($vaastu_compliant).",
	financial_status=".db_escape($financial_status).",
	mortgage_amount=".db_escape($mortgage_amount).",
	submit_doc= ".db_escape($submit_doc)."

	WHERE id=".db_escape($id);

	db_query($sql);
	set_audit_trail(ST_REALESTATE, $id, date('Y-m-d'), _("Seller Record Updated"));
}

//function update_crm_real_estate_follow_up($reminder_note=''){
// 	$sql = "UPDATE ".TB_PREF."followup SET 
// 	type=".db_escape(ST_REALESTATE).",
// 	trans_no=".db_escape($id).",
// 	user=".db_escape($_SESSION['wa_current_user']->user).",
// 	date_=".db_escape(date("Y-m-d H:i:s")).",
// 	comment=".db_escape($reminder_note)."
// 
	
// 	 WHERE id-".db_escape($looking_for);	
// }

// function update_crm_real_estate_events(){
// $sql ="UPDATE 0_events SET
// user_id=
// user_role=
// title=
// color=
// start_event=
// end_event=
// status=
// comment_id=

//  WHERE real_estate_id"


//------------------------------------------------------------------------------------------------------------


function get_sql_for_real_estate_buyer($full_name ='', $email = '', $looking_for = 0, $availability_type = 0, $payment_pref = 0, $community_pref="", $phase_pref="", $no_of_br=0, $single_row="", $bank="", $specific_req="", $days=0, $budget=0, $phone=0, $looking_type=0, $sources=0,$serious_client= 0){
	$sql = "SELECT re.id AS trans_id, '' as NUll1, '' as NUll2, re.full_name, re.email, re.phone, reb.* FROM ".TB_PREF."real_estate_form AS re 
	LEFT JOIN ".TB_PREF."real_estate_buyer AS reb ON reb.real_estate_id=re.id
	WHERE re.person_type=".ST_BUYER ;

	if($full_name)
		$sql .= " AND re.full_name LIKE ".db_escape("%".$full_name."%");
	if($email)
		$sql .= " AND re.email LIKE ".db_escape("%".$email."%");
	if($phone)
		$sql .= " AND re.phone LIKE ".db_escape("%".$phone."%");
	if($phone)
		$sql .= " AND re.phone LIKE ".db_escape("%".$phone."%");
	if($looking_for)
		$sql .= " AND reb.looking_for=".db_escape($looking_for);
	if($availability_type)
		$sql .= " AND reb.availability_type=".db_escape($availability_type);
	if($payment_pref)
		$sql .= " AND reb.payment_pref=".db_escape($payment_pref);
	if($community_pref)
		$sql .= " AND reb.community_pref LIKE ".db_escape("%".$community_pref."%");;
	if($phase_pref)
		$sql .= " AND reb.phase_pref LIKE ".db_escape("%".$phase_pref."%");;
	if($no_of_br)
		$sql .= " AND reb.no_of_br=".db_escape($no_of_br);
	if($single_row)
		$sql .= " AND reb.single_row LIKE ".db_escape("%".$single_row."%");;
	if($bank)
		$sql .= " AND reb.bank LIKE ".db_escape("%".$bank."%");;
	if($specific_req)
		$sql .= " AND reb.specific_req LIKE ".db_escape("%".$specific_req."%");;
	if($days)
		$sql .= " AND reb.days=".db_escape($days);
	if($looking_type != 0)
		$sql .= " AND reb.looking_type=".db_escape($looking_type);
	if($sources != 0)
		$sql .= " AND reb.sources=".db_escape($sources);
	if($serious_client != 0)
		$sql .= " AND reb.serious_client=".db_escape($serious_client);
	

	return $sql;
}


function get_sql_for_real_estate_seller($full_name ='', $email = '', $offer_type = 0, $property_category = 0, $availability_status = 0, 
	$br=0, $community="", $phase="", $location_detail="", $bua="", $plot="", $vaastu_compliant="", $financial_status=0, $mortgage_amount=0,
	$view="", $rent_amount=0, $expiry_date_from="", $expiry_date_to="", $phone=""){
	$sql = "SELECT re.id AS trans_id, '' as NUll1, '' as NUll2, re.full_name, re.email, re.phone, res.* 
	FROM ".TB_PREF."real_estate_form AS re 
	LEFT JOIN ".TB_PREF."real_estate_seller AS res ON res.real_estate_id=re.id
	WHERE re.person_type=".ST_SELLER;

	if($full_name)
		$sql .= " AND re.full_name LIKE ".db_escape("%".$full_name."%");
	
	if($email)
		$sql .= " AND re.email LIKE ".db_escape("%".$email."%");
	if($phone)
		$sql .= " AND re.phone LIKE ".db_escape("%".$phone."%");

	if($offer_type)
		$sql .= " AND res.offer_type=".db_escape($offer_type);

	if($property_category)
		$sql .= " AND res.property_category=".db_escape($property_category);

	if($availability_status)
		$sql .= " AND res.availability_status=".db_escape($availability_status);

	if($br)
		$sql .= " AND res.br=".db_escape($br);

	if($community)
		$sql .= " AND res.community LIKE ".db_escape("%".$community."%");
	if($phase)
		$sql .= " AND res.phase LIKE ".db_escape("%".$phase."%");
	if($location_detail)
		$sql .= " AND res.location_detail LIKE ".db_escape("%".$location_detail."%");
	if($bua)
		$sql .= " AND res.bua LIKE ".db_escape("%".$bua."%");
	if($view)
		$sql .= " AND res.view LIKE ".db_escape("%".$view."%");
	if($plot)
		$sql .= " AND res.plot LIKE ".db_escape("%".$plot."%");
	if($vaastu_compliant)
		$sql .= " AND res.vaastu_compliant LIKE ".db_escape("%".$vaastu_compliant."%");
	if($financial_status)
		$sql .= " AND res.financial_status=".db_escape($financial_status);
	if($mortgage_amount)
		$sql .= " AND res.mortgage_amount=".db_escape($mortgage_amount);
	if($rent_amount)
		$sql .= " AND res.rent_amount=".db_escape($rent_amount);
	if($expiry_date_from)
		$sql .= " AND res.expiry_date>=".db_escape(date2sql($expiry_date_from));
	if($expiry_date_to)
		$sql .= " AND res.expiry_date<=".db_escape(date2sql($expiry_date_to));

	return $sql;
}

function get_modal_real_estate_buyer($selected_id){
	$sql = "SELECT re.id AS trans_id, re.full_name, re.email, re.phone, re.note, reb.* FROM ".TB_PREF."real_estate_form AS re 
	LEFT JOIN ".TB_PREF."real_estate_buyer AS reb ON reb.real_estate_id=re.id
	WHERE re.person_type=".ST_BUYER. " AND re.id = ".db_escape($selected_id);
  // display_error($sql);
	return $sql;
}

function get_modal_real_estate_seller($selected_id){
	$sql = "SELECT re.id AS trans_id, re.full_name, re.email, re.phone, re.note, res.* 
	FROM ".TB_PREF."real_estate_form AS re 
	LEFT JOIN ".TB_PREF."real_estate_seller AS res ON res.real_estate_id=re.id
	WHERE re.person_type=".ST_SELLER. " 
	AND re.id = ".db_escape($selected_id);

	return $sql;
} 

function add_real_estate_document($real_estate_id=0, $doc_name="", $file="", $fname=""){
	$sql = "INSERT INTO ".TB_PREF."real_estate_doc (real_estate_id, doc_name, file, f_name) 
	VALUES (".db_escape($real_estate_id).",".db_escape($doc_name).", ".db_escape($file).", ".db_escape($fname).")";
	db_query($sql);
}

function update_real_estate_document($doc_id=0, $doc_name="", $file="", $fname=""){
	$sql = "UPDATE ".TB_PREF."real_estate_doc SET 
	doc_name =".db_escape($doc_name);
	if($file && $fname){
		$sql .= ", file=".db_escape($file).", f_name=".db_escape($fname);
	}
	$sql .= " WHERE id=".db_escape($doc_id);
	db_query($sql);
}

function get_real_estate_docs($real_estate_id){
	$sql = "SELECT * FROM ".TB_PREF."real_estate_doc WHERE real_estate_id=".db_escape($real_estate_id);
	return db_query($sql);
}

function get_real_estate_doc($doc_id){
	$sql = "SELECT * FROM ".TB_PREF."real_estate_doc WHERE id=".db_escape($doc_id);
	return db_fetch(db_query($sql));
}

function get_real_estate_all_buyer(){
	$sql = "SELECT * FROM ".TB_PREF."real_estate_buyer ";
	return $sql;
	// return db_fetch(db_query($sql));
}

function get_real_estate_all_seller(){
	$sql = "SELECT * FROM ".TB_PREF."real_estate_seller ";
	return $sql;
	// return db_fetch(db_query($sql));
}


function get_real_estate_buyer_selected($selected_id=0){
	$sql = "SELECT * FROM ".TB_PREF."real_estate_buyer
	 LEFT JOIN ".TB_PREF."real_estate_form ON
	 ".TB_PREF."real_estate_buyer.real_estate_id = ".TB_PREF."real_estate_form.id 
	 WHERE ".TB_PREF."real_estate_buyer.id=".db_escape($selected_id);

	 // display_error($sql);
	return db_fetch(db_query($sql));
}

function get_real_estate_seller_selected($selected_id=0){
	$sql = "SELECT * FROM ".TB_PREF."real_estate_seller
	 LEFT JOIN ".TB_PREF."real_estate_form ON
	 ".TB_PREF."real_estate_seller.real_estate_id = ".TB_PREF."real_estate_form.id 
	 WHERE ".TB_PREF."real_estate_seller.id=".db_escape($selected_id);

	 // display_error($sql);
	return db_fetch(db_query($sql));
}



function delete_real_estate_form($real_estate_id,$selected_id ,$type=0){


	if ($type == ST_BUYER) {
		set_audit_trail(ST_REALESTATE, $real_estate_id, date('Y-m-d'), _("Buyer Form Deleted"));

		$sql = "DELETE FROM ".TB_PREF."real_estate_buyer WHERE id=".db_escape($selected_id);
		db_query($sql);
	}

	if ($type == ST_SELLER) {
		set_audit_trail(ST_REALESTATE, $real_estate_id, date('Y-m-d'), _("Seller Form Deleted"));

		$sql = "DELETE FROM ".TB_PREF."real_estate_seller WHERE id=".db_escape($selected_id);
		db_query($sql);
	}

	$sql = "DELETE FROM ".TB_PREF."real_estate_form WHERE id=".db_escape($real_estate_id);
	db_query($sql);
}




function exists_real_state_form($id)
{
	$sql = "SELECT id FROM ".TB_PREF."real_estate_form WHERE voided=0 and id=".db_escape($id);
	$result = db_query($sql, "Cannot retreive real estate form");

    return (db_num_rows($result) > 0);
}


//----------------------------------------------------------------------------------------

function void_real_state_form($type, $type_no, $use_transaction=true)
{

	$sql = "UPDATE ".TB_PREF."real_estate_form SET voided=1
		WHERE  id=".db_escape($type_no);

	db_query($sql, "could not void journal transaction for type=$type and trans_no=$type_no");


}

