<?php 
$path_to_root = "../..";

include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$page_security = 'SA_CLIENTDASHBOARD';

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_("Client Management Dashboard"), false, false, "", $js);


//-----------------------------------------------------------------------------
//Helper Function
function sales_area($row){
    return get_area_name($row['area']);
}

function customer_name($row){
    return get_customer_name($row['debtor_no']);
}

function branch_name($row){
    return get_branch_name($row['branch_code']);
}


function get_phone_no($row){
    $sql = "SELECT cp.phone FROM ".TB_PREF."crm_contacts AS cc 
    LEFT JOIN ".TB_PREF."crm_persons AS cp ON cp.id=cc.person_id  
    WHERE cc.type= 'cust_branch' 
    AND cc.entity_id = ".db_escape($row['branch_code'])." 
    ORDER BY cp.id DESC";
    $res = db_query($sql);
    //Iterate until a record is found
    while($row = db_fetch($res)){
        $phone = $row['phone'];
        if($phone)
            return $phone;
    }
    if(!$phone){
        $phone = 'N/A';
    }
    return $phone;
}

function get_order_count($row){
    global $path_to_root;
    if($row['ord_count'])
        return get_customer_trans_view_str(SM_CUSTOMER, $row['debtor_no'].'-'.$row['branch_code'], 
        number_format2($row['ord_count'], 0), false, '', '', $path_to_root);
    else
        return "N/A";
}

function comment_link($row){
    return '<a class="" href=javascript:modal_viewer_comment("'.$row['debtor_no'].'","'.
    $row['branch_code'].'")>'.
    set_icon(ICON_COMMENT).'</a>';
}

function last_comment($row){
    $sql = "SELECT comment FROM ".TB_PREF."crm_comments 
    WHERE debtor_no=".$row['debtor_no']." AND branch_code=".$row['branch_code']." 
    ORDER BY timestamp DESC LIMIT 1";
    return db_fetch(db_query($sql))['comment'];
}

function comment_user($row){
    $sql = "SELECT user FROM ".TB_PREF."crm_comments 
    WHERE debtor_no=".$row['debtor_no']." AND branch_code=".$row['branch_code']." 
    ORDER BY timestamp DESC LIMIT 1";
    $user = db_fetch(db_query($sql))['user'];
    return get_user($user)['real_name'];
}

function comment_datetime($row){
    $sql = "SELECT timestamp FROM ".TB_PREF."crm_comments 
    WHERE debtor_no=".$row['debtor_no']." AND branch_code=".$row['branch_code']." 
    ORDER BY timestamp DESC LIMIT 1";
    $date = db_fetch(db_query($sql))['timestamp'];
    if($date){
        $date = new DateTime();
        return $date->format('l d/m/Y h:i A');
    }
}

function comment_after($row){
    $sql = "SELECT timestamp FROM ".TB_PREF."crm_comments 
    WHERE debtor_no=".$row['debtor_no']." AND branch_code=".$row['branch_code']." 
    ORDER BY timestamp DESC LIMIT 1";
    $date = db_fetch(db_query($sql))['timestamp'];
    if($date){
        $date = new DateTime();
        $date = $date->format('Y-m-d');
        if($date>=$row['order_date'])
            return true;
    }
    else
        return false;
}

start_form();

?>
<div class="container-fluid">
    <div class="modal fade" id="ComModal" role="dialog">
        <div class="modal-dialog" style="width: 50%;">
            <div class="modal-content">
                <div class="modal-header">
                    <a class="close" data-dismiss="modal">&times;</a>
                    <h4 class="modal-title">Line Comments</h4>
                    <br>
                </div>
                <div class="modal-body" style="text-align: center;">
                    <label id="notification" style="display:none;"></label>
                    <table class="table table-striped" id="com_table" name="com_table" 
                    style="width: 100% !important;">
                        <thead>
                            <th>S. No.</th>
                            <th>Comment</th>
                            <th>User</th>
                            <th>Time Stamp</th>
                        </thead>
                        <tbody id="com_body" name="com_body">
                        </tbody>
                    </table>
                    <br>
                    <hr>
                    <label>Enter Comment: &nbsp;</label><br>
                    <textarea id="comment" name="comment" rows="4" cols="50">
                    </textarea>                    
                    <br>
                    <br>
                    <a href="javascript:process_comment()" class='btn btn-success'>Add Comment</a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.bg-custom {
  background-color: #afca62;
}
</style>
<?php

if(isset($_POST['SearchOrders'])){
    $Ajax->activate('_page_body');
    $Ajax->activate('filters');
}

if(isset($_POST['ClearFilter'])){
    unset($_POST);
    $Ajax->activate('_page_body');
    $Ajax->activate('filters');
}

div_start('filters');

start_table(TABLESTYLE_NOBORDER);

customer_list_cells(_("Select a customer: "), 'customer', null, true, true);
label_cells(_("Branch:"), branches_list('branch', null, false,
$_POST['customer'], _("Select Branch"), false));
sales_types_list_cells(_("Sales Channel"), "sales_type", null, false, true);
end_table();

start_table(TABLESTYLE_NOBORDER);
date_cells(_("Order From:"), 'fromdate', '', null);
date_cells(_("Order To:"), 'todate', '', null);


hidden('debtor_no', '');
hidden('branch_code', '');

echo "<td>".client_dashboard_print(
_("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"),
true, SM_CUSTOMER, null, '', '', $_POST['customer'], $_POST['branch'], 
$_POST['sales_type'], $_POST['fromdate'], $_POST['todate'], 0) ."</td>"; 

echo "<td>".client_dashboard_print(
_("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme().
"/images/excel.png>"), true, SM_CUSTOMER, null, '', '', $_POST['customer'],
$_POST['branch'], $_POST['sales_type'], $_POST['fromdate'], 
$_POST['todate'], 1) ."</td>"; 



submit_cells('SearchOrders', _("Search"), '',_('Select documents'), 'default');
submit_cells('ClearFilter', _("Clear Filters"), '',_('Clear All Filters'), 'default');
end_table(1);

div_end();

$cols = array(
	_("Customer Name") => array('fun'=>'customer_name'),
	_("Branch Name") => array('fun'=>'branch_name'),
	_("Mobile No"),
	_("Email Address"), 
	_("Total Orders") => array('fun'=>'get_order_count'),
	_("Last Order Date") => array('type'=>'date'),
	_("Total Order Amount") => array('type'=>'amount'),
    _("Last Comment") => array('fun'=>'last_comment'),
    _("Comment By") => array('fun'=>'comment_user'),
    _("Comment Time") => array('fun'=>'comment_datetime'),
);
array_append($cols, array(array('insert'=>true, 'fun'=>'comment_link')));

$sql = get_sql_for_client_dashboard($_POST['customer'], $_POST['branch'],
$_POST['sales_type'], $_POST['fromdate'], $_POST['todate']);


$table =& new_db_pager('client_tbl', $sql, $cols);
$table->width = "80% !important";
$table->page_len = 20;
$table->set_marker('comment_after', "Marked Rows have comment after the last order date", 'bg-custom');
display_db_pager($table);
end_form();
end_page();
?>

<script type="text/javascript">
function modal_viewer_comment(debtor_no, branch_code){
    $('#ComModal').modal('show');
    $('#change').show();
    document.getElementsByName('debtor_no')[0].value=debtor_no;
    document.getElementsByName('branch_code')[0].value=branch_code;
    reset_modal_comment(debtor_no, branch_code, 0);
}

function process_comment(){
    var debtor_no = document.getElementsByName("debtor_no")[0].value;
    var branch_code = document.getElementsByName("branch_code")[0].value;
    var comment = $("#comment").val();
        
    $.ajax({
        url:"../includes/add_comments.php",
        method:"POST",
        data:{debtor_no:debtor_no, branch_code:branch_code, comment:comment},
        dataType:"JSON",
        success:function(result){
            var label = document.getElementById('notification');
            if(result==1){
                label.style.color = "green";
                label.innerHTML = 'Comment Entered';
            }
            else{
                label.style.color = "red";
                label.innerHTML = 'Failed to enter Comment';
            }
            label.style.display = "block";
            reset_modal_comment(debtor_no, branch_code, 1);
        }
    });
}


function reset_modal_comment(debtor_no, branch_code, note){
    //Unset The list
    document.getElementById('comment').value = "";

    if(note == 0){
        var label = document.getElementById('notification');
        label.style.display = "none";
    }

    //Now fetch the data if presents
    $.ajax({
        url:"../includes/get_comments.php",
        method:"POST",
        data:{debtor_no:debtor_no, branch_code:branch_code},
        dataType:"JSON",
        success:function(output){
            //First Remove All the rows
            $("#com_body").empty();
            //Now Create New
            for(var i=0; i<output.length; i++){
                $('#com_table > tbody:last-child').append('<tr><td>'+output[i].serial+
                '</td><td>'+output[i].comment+'</td><td>'+output[i].user+'</td><td>'+
                output[i].stamp+'</td></tr>');
            }
        }
    });
}
</script>