<?php
$page_security = 'SA_COMPLAINTENTRY';
$path_to_root = "../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Complaint Inquiry"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/CRM/includes/db/complaint_db.inc");
include_once($path_to_root . "/CRM/includes/db/complaint_type_db.inc");

//--------------------------------------------------------------------------
function customer_name($row){
	return get_customer_name($row['debtor_no']);
}
function complaint_type($row){
	return get_complaint_type_name($row['complaint_type']);
}
function complaint_status($row){
	if($row['status'])
		return "Closed";
	else
		return "Open";
}
function view_link($row){
	global $path_to_root;
	if($row['sales_order']){
		$ref = get_reference(ST_SALESORDER, $row['sales_order']);
		return  get_customer_trans_view_str(ST_SALESORDER, $row['sales_order'], $ref, false, '', '', 
		$path_to_root);
	}
	else{
		return "N/A";
	}
}

function user_name($row){
	return get_user($row['user_id'])['real_name'];
}

function reaction_link($row){
	return '<a class="" href=javascript:modal_viewer_reaction("'.$row['id'].'")>'.
	set_icon(ICON_COMMENT).'</a>';
}
function close_date($row){
	if($row['close_date'] == '0000-00-00')
		return "N/A";
	else
		return sql2date($row['close_date']);
}
//--------------------------------------------------------------------------
start_form();
?>

<div class="container-fluid">
  	<div class="modal fade" id="ReactionModal" role="dialog">
    	<div class="modal-dialog" style="width: 50%;">
	      	<div class="modal-content">
	        	<div class="modal-header">
	          		<a class="close" data-dismiss="modal">&times;</a>
	          		<h4 class="modal-title">Complaint Reaction / Result</h4>
	        	</div>
	        	<div class="modal-body" style="text-align: left; font-weight:bold;">
	        	    <label id="notification" style="display:none; text-align: center;"></label>
	        	    <table class="table table-striped" style="width: 100% !important;">
	        	    	<tr>
	        	    		<td>Responsible Person Name:</td>
	        	    		<td>
	        	    			<textarea rows="1" cols="50" id="person_name" name="person_name"></textarea>
	        	    		</td>
	        	    	</tr>
	        	    	<tr>
	        	    		<td>Responsible Person Comment:</td>
	        	    		<td>
	        	    			<textarea rows="4" cols="50" id="person_com" name="person_com"></textarea>
	        	    		</td>
	        	    	</tr>
	        	    	<tr>
	        	    		<td>Management Decision:</td>
	        	    		<td>
	        	    			<textarea rows="4" cols="50" id="decision" name="decision"></textarea>
	        	    		</td>
	        	    	</tr>
	        	    	<tr>
	        	    		<td>Close Complaint:</td>
	        	    		<td>
	        	    			<select class="selectpicker" data-style="btn-info" 
                    			data-live-search="true" name="close" style="width:40%;" 
                    			class="form-control" id="close">
                    				<option value="0">No</option>
                    				<option value="1">Yes</option>
                    			</select>
	        	    		</td>
	        	    	</tr>
                    </table>
                    <br>
                    <center>
	          		<a href="javascript:process_complaint()" class='btn btn-success' id="process"
	          		style="display: block; width:14%;">Process</a>
	          		</center>
	        	</div>
	      	</div>
		</div>
  	</div>
</div>

<?php

if(isset($_POST['SearchOrders'])){
    $Ajax->activate('_page_body');
}

if(isset($_POST['ClearFilter'])){
	unset($_POST);
    $Ajax->activate('_page_body');
}

start_table(TABLESTYLE_NOBORDER);
date_cells(_("From:"), 'fromdate', '', null, -user_transaction_days(), 0, 0, null, false);
date_cells(_("To:"), 'todate', '', null, 1);
ref_cells(_("Complaint ID"), 'ref', '', null, '', false);
complaint_type_list_cells("Complaint Type", 'complaint_type', null, true, false, true);
customer_list_cells(_("Select a customer: "), 'customer', null, _('Select customer'), false, false);
generic_list_cells(_("Complaint Status"), 'status', array("Open", "Closed"), null, _("Show All"),false);
submit_cells('SearchOrders', _("Search"), '',_('Search Complaints'), 'default');
submit_cells('ClearFilter', _("Clear Filters"), '',_('Clear All Filters'), 'default');

hidden('complain_id', 0);
end_table(1);

$value = get_count_for_complaint_inquiry($_POST['fromdate'], $_POST['todate'], $_POST['ref'], 
$_POST['complaint_type'], $_POST['customer'], $_POST['status']);

?>
<div class = "row" style="margin-left:45%;">
	<div class="table-responsive">
        <table class="table table-bordered" style="font-size: 18px; 
        color: white; background: #2f323edb; border: 1px solid black;">
          	<thead>
                <tr>
                  <th colspan="2" style="text-align: center;border: 1px solid black;">Total Complaints</th>
                </tr>
                <tr style = "color: #512f81; background: #dee2e6;">
                  <th style="text-align: center; border: 1px solid black;">Open</th>
                  <th style="text-align: center; border: 1px solid black;">Closed</th>
                </tr>
                <tr style = "color: #512f81; background: white;">
                  <th style="text-align: center; border: 1px solid black;"><?php echo $value['open']?>
                  </th>
                  <th style="text-align: center; border: 1px solid black;"><?php echo $value['closed']?></th>
                </tr>
          	</thead>
        </table>
    </div>
</div>

<?php

$cols = array(
	_("Complaint ID"),
	_("Complaint Date") => array('type'=>'date'),
	_("Customer Name") => array('fun'=>'customer_name'),
	_("Order #") => array('fun'=>'view_link', 'align'=>'left'),
	_("Complaint Type") => array('fun' => 'complaint_type'),
	_("Comment From Customer"),
	_("Registered By") => array('fun' => 'user_name'),
	_("Complaint Closing Date") => array('fun'=>'close_date'),
	_("Complaint Status") => array('fun'=>'complaint_status'),
	_("Reaction / Result") => array('fun'=>'reaction_link'),
);


$sql = get_sql_for_complaint_inquiry($_POST['fromdate'], $_POST['todate'], 
	$_POST['ref'], $_POST['complaint_type'], $_POST['customer'], $_POST['status']);

$table =& new_db_pager('complaint_tbl', $sql, $cols);
display_db_pager($table);

end_form();

end_page();
?>
<script type="text/javascript">

function modal_viewer_reaction(complain_id){
	$('#ReactionModal').modal('show');
	$('#change').show();
	document.getElementsByName('complain_id')[0].value=complain_id;
	reset_modal(complain_id, true)
}

function reset_modal(complain_id, hide_note){
	//Unset The list
	if(hide_note == true){
	    var label = document.getElementById('notification');
    	label.style.display = "none";
	}

	//Now fetch the data if presents
	var fetch = 1;
	$.ajax({
        url:"../complain_process.php",
        method:"POST",
        data:{complain_id:complain_id, fetch:fetch},
        dataType:"JSON",
        success:function(output){
        	document.getElementById('person_name').value = output.r_name;
        	document.getElementById('person_com').value = output.r_com;
        	document.getElementById('decision').value = output.decision;
        	$("#close").val(output.status);
        	if(output.status==1){
        		document.getElementById('person_name').disabled=true;
        		document.getElementById('person_com').disabled=true;
        		document.getElementById('decision').disabled=true;
        		document.getElementById('close').disabled=true;
        		document.getElementById('process').style.display="none";
        	}
        	else{
        		document.getElementById('person_name').disabled=false;
        		document.getElementById('person_com').disabled=false;
        		document.getElementById('decision').disabled=false;
        		document.getElementById('close').disabled=false;
        		document.getElementById('process').style.display="block";
        	}
        }
	});
}

function process_complaint(){
	var person_name = document.getElementById('person_name').value;
	var person_com = document.getElementById('person_com').value;
	var decision = document.getElementById('decision').value;
	var status =  $("#close").val();
	var label = document.getElementById('notification');
	var complain_id = document.getElementsByName('complain_id')[0].value;

	//check data
	if(status == 1 && (person_name == "" || person_com == "" || decision=="")){
    	label.innerHTML = 'All information must be filled to close complaint';
    	label.style.color = "red";
    	label.style.display = "block";

    	return false;
	}

	$.ajax({
    url:"../complain_process.php",
    method:"POST",
    data:{complain_id:complain_id, person_name:person_name, person_com:person_com,
    decision:decision, status:status},
    dataType:"JSON",
    success:function(result){
    	if(result==true){
    		label.innerHTML = 'Complaint Processed';
				label.style.color = "green";
				label.style.display = "block";
				$('#ReactionModal').modal('hide');
				JsHttpRequest.request("SearchOrders", this.form);
    	}
    	else{
    		label.innerHTML = 'Complaint can not be processed';
				label.style.color = "red";
				label.style.display = "block";
    	}
    }
	});
}

</script>