<?php
$page_security = 'SA_REALESTATEINQUIRY';
$path_to_root = "../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Buyer Inquiry"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/CRM/includes/db/crm_real_estate_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/CRM/includes/db/source_record_db.inc");

//--------------------------------------------------------------------------

if(isset($_POST['add_header'])){
	$user_id = $_SESSION['wa_current_user']->user;
	$sql_delete = "DELETE FROM ".TB_PREF."buyer_header WHERE user_id = ".db_escape($user_id);
	db_query($sql_delete);

	$sql_master = "SELECT id, header_name FROM ".TB_PREF."buyer_header_master";
	$res_master = db_query($sql_master);
	while($row_master = db_fetch($res_master)){
		$id = $row_master['id'];
		$name = $row_master['header_name'];
		if($_POST['check'.$id] == 1){
			$sql = "INSERT INTO ".TB_PREF."buyer_header (header_id, header_name, user_id)
					VALUES (".db_escape($id).",".db_escape($name).",".db_escape($user_id).")";
			db_query($sql);
		}
	}
	meta_forward($_SERVER['PHP_SELF']);
}


//--------------------------------------------------------------------------
//Helper Functions
function get_header(){
	$user_id = $_SESSION['wa_current_user']->user;
	$sql = "SELECT header_name FROM ".TB_PREF."buyer_header 
	WHERE user_id=".db_escape($user_id)." ORDER BY header_id";
	return db_query($sql);
}


function sources($row){

	if(!$row['sources'])
		return 'Other';

	return get_source_record_name($row['sources']);
	
	// return $sources[$row['sources']];
}

function source_text($row){

	return $row['source_text'];
	
}

function looking_type($row){
	global $looking_type;

	return $looking_type[$row['looking_type']];
}

function looking_for($row){
	global $looking_for;

	return $looking_for[$row['looking_for']];
}

function property_type($row){
	global $property_type;

	return $property_type[$row['property_type']];
}
function community_pref($row){
	return $row['community_pref'];
}
function phase_pref($row){
	return $row['phase_pref'];
}
function no_br($row){
	return number_format2($row['no_of_br'], 0);
}
function bk_single_row($row){
	return $row['single_row'];
}
function avail_type($row){
	global $availability_type;

	return $availability_type[$row['availability_type']];
}
function pay_pref($row){
	global $payment_pref;

	return $payment_pref[$row['payment_pref']];
}
function bank($row){
	return $row['bank'];
}

function other_req($row){
	return $row['specific_req'];
}
function req_in_days($row){
	// return number_format2($row['days'], 0);
	return $row['days'];
}
function budget($row){
	return $row['budget'];
}

function layouts($row){
	return $row['layout'];
}

function serious_client($row){
	global $serious_client;

	return $serious_client[$row['serious_client']];
}
function audit_trail($row){
	
	$my_row=db_fetch(get_audit_trail_all(ST_BUYER,$row['id'] , 'ASC'));

	$date_old = $my_row['stamp']; 
	$date_for_database = date('d/m/Y H:i a', strtotime($date_old));
	return $date_for_database;
}



function view_modal($row){
	return crm_real_estate_modal(ST_BUYER, $row['trans_id']);
}
function reminder_chk($row){
	global $path_to_root;
	$style = 'style="width:30px; height:30px; border-radius:200px;"';
	$image = '<center><img '.$style.' src="'.$path_to_root.'/themes/'.user_theme().'/images/'.ICON_REMINDER.'"/></center>';
    return '<a class="" href=javascript:modal_viewer('.$row['trans_id'].')>'.$image.'</a>';
}

function edit_link($row) {
    global $path_to_root;
	return '<a  href="'.$path_to_root.'/CRM/crm_real_estate_form.php?ID='.$row["id"].'" target="_blank"><i class="fa fa-pencil"></i></a>';
    // return button('edit_'.$row['id'], _('Edit this Buyer'), false, ICON_EDIT);
}
//--------------------------------------------------------------------------

foreach (db_query(get_real_estate_all_buyer(false, true)) as $proj) {

    if(isset($_POST['edit_'.$proj['id']]))
        meta_forward($path_to_root.'/CRM/crm_real_estate_form.php', 'ID='.$proj['id']);
    // echo "<meta http-equiv='refresh' content='3;url=../../CRM/crm_real_estate_form.php', 'ID='.$proj['id']'>";
}


start_form();

?>
<div class="container-fluid">
	<div class="modal fade" id="allocModal" role="dialog">
  	<div class="modal-dialog" style="width: 315px;">
    	<div class="modal-content">
      	<div class="modal-header">
      		<a class="close" data-dismiss="modal">&times;</a>
      		<h4 class="modal-title">Notes Reminder</h4>
      		<br>
      	</div>
    		<div class="modal-body">
      		<label id="notification" style="display:none;"></label>
					<center>
					<a href="../../admin/calendar.php" id="already_reminder" style="color: green;display: none;">You have pinned Reminder for selected Comment: &nbsp <i class="fa fa-mouse-pointer"></i> <span style="color:red;">Click to Show</span></a>
					<br>
					
					<label>Date &nbsp;</label>
					<br>
					<input type="text" id="alloc_date">
      		<br>
      		<br>

      		<label>Reminder Notification</label>
					<br>
      		<select class="selectpicker" data-style="btn-info" data-live-search="true" name="rem_not" class="form-control" id="rem_not">
	        	<option value="0">No Notification</option>
	        	<option value="1">Email Notification</option>
	        	<option value="2">SMS Notification</option>
	        	<option value="3">Both Notification</option>
	      	</select>
      		<br>
      		<br>

      		<label>Reminder Title</label>
    			<br>
					<textarea id="note" name="note" rows="4" cols="50"></textarea>
					
					</center>

      	</div>
      	<div class="modal-footer" style="text-align: center;">
    	    <label id="error" style="display:none;"></label>
      		<a href="javascript:process_data()" id='process' class='btn btn-success'>Add Reminder</a>
      		<br>
      		<br>
      		<a href="../calendar.php" id="show_reminder" style="position:absolute; right:2%; bottom:2%; color:red; display:none;">
      		Show Reminders</a>
      	</div>
    	</div>
		</div>
	</div>
</div>

<div class="container-fluid">
  <!-- Modal -->
	<div class="modal fade" id="myModal" role="dialog">
		<div class="modal-dialog">
    	<!-- Modal content-->
			<div class="modal-content" style="width: 70%; margin-right: auto; margin-left: auto;">
    		<div class="modal-header">
    			<a class="close" data-dismiss="modal">&times;</a>
        	<h4 class="modal-title">Choose Table Header</h4>
    		</div>
        		
    		<div class="modal-body">
					<table class="table table-hover" style=" margin-right: auto; margin-left: auto;">
      			<thead>
      				<tr>
       					<th>Header Name</th>
	            	<th>Choose Header</th>  
      				</tr>
      			</thead>
      			<tbody>
							<?php 
							$user_id = $_SESSION["wa_current_user"]->user;
							$sql = "SELECT bm.id as bm_id, 
							bm.header_name as headerName,
							IF(ISNULL(bh.id), 0, 1) AS value
							FROM 0_buyer_header_master as bm 
							LEFT JOIN 0_buyer_header AS bh ON bh.header_id = bm.id
							AND bh.user_id=".db_escape($user_id)." 
							ORDER BY bm.id";
							$res=db_query($sql,"");
							while($row = db_fetch($res)){
								$header_name = $row['headerName'];
								echo "<tr><td>$header_name</td><td style='text-align: center'>"
								.checkbox(_(null), 'check'.$row['bm_id'], $row['value'], false)."</td></tr>";
							}
							$Ajax->activate('_page_body');			
							?>
      			</tbody>
    			</table>
    		</div>

    		<div class="modal-footer">
   				<?php submit_center_first('add_header', _("Add Header"),'',_('Add Header'), 'default', "data-dismiss='modal'"); ?>
    		</div>
  		</div>
  	</div>
	</div>
</div>

<?php


if(isset($_POST['SearchOrders'])){
    $Ajax->activate('_page_body');
}

if(isset($_POST['ClearFilter'])){
	unset($_POST);
  $Ajax->activate('_page_body');
}

hidden('selected_del', 0);

start_table(TABLESTYLE_NOBORDER);

ref_cells(_("Full Name:"),'full_name' , 50);
ref_cells(_("Email"), 'email', 50);
ref_cells(_("Phone"),'phone_no' , 50);
crm_looking_type_cells(_("Looking Type"), 'looking_type','' ,_("Select Looking Type"), true);
crm_looking_for_cells(_("Looking For"), 'looking_for','' ,_("Select Looking For"), true);
start_row();
crm_availability_type_cells(_("Availability Type"), 'availability_type', '', ST_OWNEROCCUPIED,_("Select Availability Type"), true);
crm_payment_reference_cells(_("Payment Preference"), 'payment_pref', '', _("Select Payment Preference"), true);

if($_POST['AdvanceSearch']){
	crm_property_type_cells(_("Property Type"), 'property_type','' ,"Select Property Type");
	ref_cells(_("Community Preference"),'community_pref' , 50);
	ref_cells(_("Phase Preference"),'phase_pref' , 50);
	end_row();
	ref_cells(_("No Of BR"),'no_of_br' , 50);
	ref_cells(_("Bk or bk or Single Row"),'single_row' , 50);
	ref_cells(_("Bank"),'bank' , 50);


	ref_cells(_("Other specific requirement"),'specific_req' , 50);
	end_row();
	ref_cells(_("Required (In Days)"),'days' , 50);
	ref_cells(_("Budget"),'budget' , 50);
	ref_cells(_("Client Seriousness"),'serious_client' , 50);
	source_record_list_row("Source Record",'sources',null,true,"Other");


}

submit_cells('SearchOrders', _("Search"), '',_('Search Complaints'), 'default');
submit_cells('ClearFilter', _("Clear Filters"), '',_('Clear All Filters'), 'default');
echo "<td> 
		<a class='' data-target='#myModal' data-toggle='modal'> 
			<i style='color:#2962ff;  margin-top:1px; font-size: 22px;' title='Select Table Header' 
			class='fa fa-plus-circle fa-1x'></i>
		</a>";
echo "</td>";

echo  "<td>".print_crm_buyer_inquriy(_("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, 
ST_BUYER, null, '', '', $_POST['full_name'], $_POST['email'], $_POST['looking_for'], $_POST['availability_type'], 
$_POST['payment_pref'], $_POST['community_pref'], $_POST['phase_pref'], $_POST['no_of_br'], $_POST['single_row'], $_POST['bank'], 
$_POST['specific_req'], $_POST['days'], $_POST['budget'], $_POST['phone_no'], 1) ."</td>"; 

end_table(1);
echo "<center>";
check_row(_('Advance Search: &nbsp;&nbsp;&nbsp;'), 'AdvanceSearch', null, true);
echo "</center>";

br();

$sql = get_sql_for_real_estate_buyer($_POST['full_name'], $_POST['email'], $_POST['looking_for'], $_POST['availability_type'], 
$_POST['payment_pref'], $_POST['community_pref'], $_POST['phase_pref'], $_POST['no_of_br'], $_POST['single_row'], $_POST['bank'], 
$_POST['specific_req'], $_POST['days'], $_POST['budget'], $_POST['phone_no'], $_POST['looking_type'], $_POST['sources'], $_POST['serious_client']);

$cols = array(
	_("ID") => array('fun'=> 'view_modal'),
	 _('Edit') => array('fun'=>'edit_link','align'=>'center'),
	 _('Creation Date/time') => array('fun'=>'audit_trail','align'=>'center'),
	_("Full Name"),
	_("Email"),
	_("Phone"),
);

$header = get_header();

while($row = db_fetch($header)){
	
	if($row['header_name'] == 'Sources'){
    array_append($cols, array(_("Sources") => array('fun' => 'sources')));
	}
	if($row['header_name'] == 'Source Record Detail'){
    array_append($cols, array(_("Source Record Detail") => array('fun' => 'source_text')));
	}
	// if($row['header_name'] == 'Looking Type'){
    array_append($cols, array(_("Looking Type") => array('fun' => 'looking_type')));
	// }
	if($row['header_name'] == 'Looking For'){
    array_append($cols, array(_("Looking For") => array('fun' => 'looking_for')));
	}
	if($row['header_name'] == 'Property Type'){
    array_append($cols, array(_("Property Type") => array('fun' => 'property_type')));
	}
	if($row['header_name'] == 'Community Preference'){
    array_append($cols, array(_("Community Preference") => array('fun' => 'community_pref')));
	}
	if($row['header_name'] == 'Phase Preference'){
    array_append($cols, array(_("Phase Preference") => array('fun' => 'phase_pref')));
	}
	if($row['header_name'] == 'Seen any layouts'){
    array_append($cols, array(_("Seen any layouts") => array('fun' => 'layouts')));
	}
	if($row['header_name'] == 'No of BR'){
    array_append($cols, array(_("No of BR") => array('fun' => 'no_br')));
	}
	if($row['header_name'] == 'Bk or bk or Single Row'){
    array_append($cols, array(_("Bk or bk or Single Row") => array('fun' => 'bk_single_row')));
	}
	if($row['header_name'] == 'Availability Type'){
    array_append($cols, array(_("Availability Type") => array('fun' => 'avail_type')));
	}
	if($row['header_name'] == 'Payment Preference'){
    array_append($cols, array(_("Payment Preference") => array('fun' => 'pay_pref')));
	}
	if($row['header_name'] == 'Bank'){
    array_append($cols, array(_("Bank") => array('fun' => 'bank')));
	}
	if($row['header_name'] == 'Other specific requirement'){
    array_append($cols, array(_("Other specific requirement") => array('fun' => 'other_req')));
	}
	if($row['header_name'] == 'Required (In Days)'){
    array_append($cols, array(_("Required (In Days)") => array('fun' => 'req_in_days', 'type'=>'collapse')));
	}
	if($row['header_name'] == 'Budget'){
    array_append($cols, array(_("Budget") => array('fun' => 'budget', 'type'=>'collapse')));
	}
	if($row['header_name'] == 'Client Seriousness'){
    array_append($cols, array(_("Client Seriousness") => array('fun' => 'serious_client')));
	}
	
}

array_append($cols, array(_("Reminder") => array('fun'=>'reminder_chk','align'=>'center')));



$table =& new_db_pager('complaint_tbl', $sql, $cols);
display_db_pager($table);

end_form();

end_page();
?>
<script type="text/javascript">

function reset_modal(trans_no){

	$("#alloc_date").val('');
	$("select option").prop("selected", 0);
	//Now fetch the data if presents
	var call = 1;
	$.ajax({
        url:"../reminder_real_estate.php",
        method:"POST",
        data:{trans_no:trans_no,call:call},
        dataType:"JSON",
        success:function(output){
        	if(output.start != ''){
      			document.getElementById('already_reminder').style.display = "block";
      		}
      		else{
      			document.getElementById('already_reminder').style.display = "none";
      		}

        	$("#alloc_date").val(output.start);
        	$("#note").val(output.note);
        	$("select option").prop("selected", output.notification);
        }
	});
}

function modal_viewer(trans_no){
	document.getElementsByName('selected_del')[0].value=trans_no;
	reset_modal(trans_no);
	$('#allocModal').modal('show');
	$('#alloc_date').datepicker({
		autoclose: true
	});
	$('#change').show();
}

function process_data(){
	var trans_no = document.getElementsByName("selected_del")[0].value;
	var alloc_date = $('#alloc_date').val();
	var note = $('#note').val();
	var rem_not = $('#rem_not').val();

	if(alloc_date == "" || alloc_date == '00/00/0000'){
		alert("Reminder Date must be selected to Process");
	}
	else{

		$.ajax({
      url:"../reminder_real_estate.php",
      method:"POST",
      data:{trans_no:trans_no,alloc_date:alloc_date,rem_not:rem_not,note:note},
      dataType:"JSON",
      success:function(data){
  			document.getElementById('already_reminder').style.display = "block";
      }
		});
	}
}

$('#alloc_date').datepicker({
	autoclose: true
});

</script>