<?php
$page_security = 'SA_REALESTATEINQUIRY';
$path_to_root = "../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Seller Inquiry"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/CRM/includes/db/crm_real_estate_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

//--------------------------------------------------------------------------

if(isset($_POST['add_header'])){
	$user_id = $_SESSION['wa_current_user']->user;
	$sql_delete = "DELETE FROM ".TB_PREF."seller_header WHERE user_id = ".db_escape($user_id);
	db_query($sql_delete);

	$sql_master = "SELECT id, header_name FROM ".TB_PREF."seller_header_master";
	$res_master = db_query($sql_master);
	while($row_master = db_fetch($res_master)){
		$id = $row_master['id'];
		$name = $row_master['header_name'];
		if($_POST['check'.$id] == 1){
			$sql = "INSERT INTO ".TB_PREF."seller_header (header_id, header_name, user_id)
					VALUES (".db_escape($id).",".db_escape($name).",".db_escape($user_id).")";
			db_query($sql);
		}
	}
	meta_forward($_SERVER['PHP_SELF']);
}


//--------------------------------------------------------------------------
//Helper Functions
function get_header(){
	$user_id = $_SESSION['wa_current_user']->user;
	$sql = "SELECT header_name FROM ".TB_PREF."seller_header 
	WHERE user_id=".db_escape($user_id)." ORDER BY header_id";

	return db_query($sql);
}


function offer_type($row){
	global $offer_type;

	return $offer_type[$row['offer_type']];
}
function property_category($row){
	global $looking_for;
	return $looking_for[$row['property_category']];
}
function community($row){
	return $row['community'];
}
function phase($row){
	return $row['phase'];
}
function no_br($row){
	return number_format2($row['br'], 0);
}
function loc_details($row){
	return $row['location_detail'];
}
function bua($row){
	return $row['bua'];
}
function view($row){
	return $row['view'];
}
function plot($row){
	return $row['plot'];
}
function availability_status($row){
	global $availability_type;

	return $availability_type[$row['availability_status']];
}
function rent_amt($row){
	return number_format2($row['rent_amount'], user_price_dec());
}
function exp_date($row){
	return sql2date($row['expiry_date']);
}
function vaastu($row){
	if(!$row['vaastu_compliant'])
		return 'N/A';

	return $row['vaastu_compliant'];
}
function financial_status($row){
	global $financial_status;

	return $financial_status[$row['financial_status']];
}
function mortgage_amount($row){
	return number_format2($row['mortgage_amount'], user_price_dec());
}
function view_modal($row){
	return crm_real_estate_modal(ST_SELLER, $row['trans_id']);
}

function doc_attachment($row){
	global $path_to_root;
	if($row['submit_doc']){
		return pager_link(_("Link Document"), $path_to_root."/real_estate_seller_docs.php?id=".$row['trans_id'], ICON_ATTACH);
	}
	else{
		return "";
	}
}

function reminder_chk($row){
	global $path_to_root;
	$style = 'style="width:30px; height:30px; border-radius:200px;"';
	$image = '<center><img '.$style.' src="'.$path_to_root.'/themes/'.user_theme().'/images/'.ICON_REMINDER.'"/></center>';
    return '<a class="" href=javascript:modal_viewer('.$row['trans_id'].')>'.$image.'</a>';
}

function edit_link($row) {
    global $path_to_root;
	return '<a  href="'.$path_to_root.'/CRM/crm_real_estate_form.php?ID='.$row["id"].'&seller=2" target="_blank"><i class="fa fa-pencil"></i></a>';
    // return button('edit_'.$row['id'], _('Edit this Seller'), false, ICON_EDIT);
}

function audit_trail($row){
	
	$my_row=db_fetch(get_audit_trail_all(ST_SELLER,$row['id'] , 'ASC'));

	$date_old = $my_row['stamp']; 
	$date_for_database = date('d/m/Y H:i a', strtotime($date_old));
	return $date_for_database;
}


//--------------------------------------------------------------------------


//--------------------------------------------------------------------------
start_form();

?>
<div class="container-fluid">
	<div class="modal fade" id="allocModal" role="dialog">
  	<div class="modal-dialog" style="width: 315px;">
    	<div class="modal-content">
      	<div class="modal-header">
      		<a class="close" data-dismiss="modal">&times;</a>
      		<h4 class="modal-title">Notes Reminder</h4>
      		<br>
      	</div>
    		<div class="modal-body">
      		<label id="notification" style="display:none;"></label>
					<center>
					<a href="../../admin/calendar.php" id="already_reminder" style="color: green;display: none;">You have pinned Reminder for selected Comment: &nbsp <i class="fa fa-mouse-pointer"></i> <span style="color:red;">Click to Show</span></a>
					<br>
					
					<label>Date &nbsp;</label>
					<br>
					<input type="text" id="alloc_date">
      		<br>
      		<br>

      		<label>Reminder Notification</label>
					<br>
      		<select class="selectpicker" data-style="btn-info" data-live-search="true" name="rem_not" class="form-control" id="rem_not">
	        	<option value="0">No Notification</option>
	        	<option value="1">Email Notification</option>
	        	<option value="2">SMS Notification</option>
	        	<option value="3">Both Notification</option>
	      	</select>
      		<br>
      		<br>

      		<label>Reminder Title</label>
    			<br>
					<textarea id="note" name="note" rows="4" cols="50"></textarea>
					
					</center>

      	</div>
      	<div class="modal-footer" style="text-align: center;">
    	    <label id="error" style="display:none;"></label>
      		<a href="javascript:process_data()" id='process' class='btn btn-success'>Add Reminder</a>
      		<br>
      		<br>
      		<a href="../calendar.php" id="show_reminder" style="position:absolute; right:2%; bottom:2%; color:red; display:none;">
      		Show Reminders</a>
      	</div>
    	</div>
		</div>
	</div>
</div>

<div class="container-fluid">
  <!-- Modal -->
	<div class="modal fade" id="myModal" role="dialog">
		<div class="modal-dialog">
    	<!-- Modal content-->
			<div class="modal-content" style="width: 70%; margin-right: auto; margin-left: auto;">
    		<div class="modal-header">
    			<a class="close" data-dismiss="modal">&times;</a>
        	<h4 class="modal-title">Choose Table Header</h4>
    		</div>
        		
    		<div class="modal-body">
					<table class="table table-hover" style=" margin-right: auto; margin-left: auto;">
      			<thead>
      				<tr>
       					<th>Header Name</th>
	            	<th>Choose Header</th>  
      				</tr>
      			</thead>
      			<tbody>
							<?php 
							$user_id = $_SESSION["wa_current_user"]->user;
							$sql = "SELECT bm.id as bm_id, 
							bm.header_name as headerName,
							IF(ISNULL(bh.id), 0, 1) AS value
							FROM 0_seller_header_master as bm 
							LEFT JOIN 0_seller_header AS bh ON bh.header_id = bm.id
							AND bh.user_id=".db_escape($user_id)." 
							ORDER BY bm.id";
							$res=db_query($sql,"");
							while($row = db_fetch($res)){
								$header_name = $row['headerName'];
								echo "<tr><td>$header_name</td><td style='text-align: center'>"
								.checkbox(_(null), 'check'.$row['bm_id'], $row['value'], false)."</td></tr>";
							}
							$Ajax->activate('_page_body');			
							?>
      			</tbody>
    			</table>
    		</div>

    		<div class="modal-footer">
   				<?php submit_center_first('add_header', _("Add Header"),'',_('Add Header'), 'default', "data-dismiss='modal'"); ?>
    		</div>
  		</div>
  	</div>
	</div>
</div>

<?php

hidden('selected_del', 0);

start_table(TABLESTYLE_NOBORDER);
start_row();



ref_cells(_("Full Name"), 'full_name', '',null, '', true);
ref_cells(_("Email"), 'email', '',null, '', true);
ref_cells(_("Phone"), 'phone_no', '',null, '', true);
crm_offer_type_cells(_("Offer Type:"), 'offer_type','' , _("Select Offer Type"), true);
crm_looking_for_cells(_("Property Category"), 'property_category','' ,_("Select Property Category"), true);
crm_payment_reference_cells(_("Payment Preference"), 'payment_pref', '', false, true);
crm_availability_type_cells(_("Availability Status:"), 'availability_status', '', ST_NOPREFERNCE,_("Select Availability Status"), true);

submit_cells('SearchOrders', _("Search"), '',_('Search Complaints'), 'default');
submit_cells('ClearFilter', _("Clear Filters"), '',_('Clear All Filters'), 'default');
echo "<td> 
		<a class='' data-target='#myModal' data-toggle='modal'> 
			<i style='color:#2962ff;  margin-top:1px; font-size: 22px;' title='Select Table Header' 
			class='fa fa-plus-circle fa-1x'></i>
		</a>";
echo "</td>";

echo  "<td>".print_crm_seller_inquriy(_("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, 
ST_SELLER, null, '', '', $_POST['full_name'], $_POST['email'], $_POST['offer_type'], $_POST['property_category'], $_POST['availability_status'], $_POST['br'], $_POST['community'], $_POST['phase'], $_POST['location_detail'], $_POST['bua'], $_POST['plot'], 
	$_POST['vaastu_compliant'], $_POST['financial_status'], $_POST['mortgage_amount'], $_POST['view'], $_POST['rent_amount'], 
	$_POST['expiry_date_from'], $_POST['expiry_date_to'], $_POST['phone_no'], 1) ."</td>"; 


if($_POST['AdvanceSearch']){
	end_row();
	ref_cells(_("#BR"), 'br', '',null, '', true);
	ref_cells(_("Community"), 'community', '',null, '', true);
	ref_cells(_("Phase"), 'phase', '',null, '', true);
	ref_cells(_("Location Details"), 'location_detail', '',null, '', true);
	ref_cells(_("BUA"), 'bua', '',null, '', true);
	ref_cells(_("Plot"), 'plot', '',null, '', true);
	ref_cells(_("View"), 'view', '',null, '', true);
	ref_cells(_("Vaastu Compliant"), 'vaastu_compliant', '',null, '', true);
	end_row();
	qty_cells(_("Rent Amount "), 'rent_amount', null, null, null, user_price_dec());
	date_cells('Tenency Expiry Date From', 'expiry_date_from', null, null, 0, 0, 0, null, false, 1);
	date_cells('Tenency Expiry Date To', 'expiry_date_to', null, null, 0, 0, 0, null, false, 1);
	crm_financial_status_cells(_("Financial Status:"), 'financial_status', '', "Select Financial Status", true);
	ref_cells(_("Mortgage Amount"), 'mortgage_amount', '',null, '', true);
}
end_table(1);

echo "<center>";
check_row(_('Advance Search: &nbsp;&nbsp;&nbsp;'), 'AdvanceSearch', null, true);
echo "</center>";
br();

if(isset($_POST['SearchOrders'])){
    $Ajax->activate('_page_body');
}

if(isset($_POST['ClearFilter'])){
	unset($_POST);
    $Ajax->activate('_page_body');
}



$sql = get_sql_for_real_estate_seller($_POST['full_name'], $_POST['email'], $_POST['offer_type'], $_POST['property_category'], $_POST['availability_status'], $_POST['br'], $_POST['community'], $_POST['phase'], $_POST['location_detail'], $_POST['bua'], $_POST['plot'], 
	$_POST['vaastu_compliant'], $_POST['financial_status'], $_POST['mortgage_amount'], $_POST['view'], $_POST['rent_amount'], 
	$_POST['expiry_date_from'], $_POST['expiry_date_to'], $_POST['phone_no']);
// display_error($sql);
$cols = array(
	_("ID") => array('fun'=> 'view_modal'),
	_('Edit') => array('fun'=>'edit_link','align'=>'center'),
	_('Creation Date/time') => array('fun'=>'audit_trail','align'=>'center'),
	_("Full Name"),
	_("Email"),
	_("Phone"),
);

$header = get_header();

while($row = db_fetch($header)){
	
	if($row['header_name'] == 'Offer Type'){
    array_append($cols, array(_("Offer Type") => array('fun' => 'offer_type')));
	}
	if($row['header_name'] == 'Property Category'){
    array_append($cols, array(_("Property Category") => array('fun' => 'property_category')));
	}
	if($row['header_name'] == '# BR'){
    array_append($cols, array(_("# BR") => array('fun' => 'no_br')));
	}
	if($row['header_name'] == 'Community'){
    array_append($cols, array(_("Community") => array('fun' => 'community')));
	}
	if($row['header_name'] == 'Phase'){
    array_append($cols, array(_("Phase") => array('fun' => 'phase')));
	}
	if($row['header_name'] == 'Location Details'){
    array_append($cols, array(_("Location Details") => array('fun' => 'loc_details')));
	}
	if($row['header_name'] == 'BUA'){
    array_append($cols, array(_("BUA") => array('fun' => 'bua')));
	}
	if($row['header_name'] == 'Plot'){
    array_append($cols, array(_("Plot") => array('fun' => 'plot')));
	}
	if($row['header_name'] == 'View'){
    array_append($cols, array(_("View") => array('fun' => 'view')));
	}
	if($row['header_name'] == 'Availability Status'){
    array_append($cols, array(_("Availability Status") => array('fun' => 'availability_status')));
	}
	if($row['header_name'] == 'Rent Amount'){
    array_append($cols, array(_("Rent Amount") => array('fun' => 'rent_amt')));
	}
	if($row['header_name'] == 'Expiry Date'){
    array_append($cols, array(_("Expiry Date") => array('fun' => 'exp_date')));
	}
	if($row['header_name'] == 'Vaastu Compliant'){
    array_append($cols, array(_("Vaastu Compliant") => array('fun' => 'vaastu')));
	}
	if($row['header_name'] == 'Financial Status'){
    array_append($cols, array(_("Financial Status") => array('fun' => 'financial_status')));
	}
	if($row['header_name'] == 'Mortgage Amount'){
    array_append($cols, array(_("Mortgage Amount") => array('fun' => 'mortgage_amount')));
	}
}

array_append($cols, array(_("Doc Attach.") => array('fun' => 'doc_attachment')));
array_append($cols, array(_("Reminder") => array('fun'=>'reminder_chk','align'=>'center')));


$table =& new_db_pager('complaint_tbl', $sql, $cols);
display_db_pager($table);

end_form();

end_page();
?>
<script type="text/javascript">

function reset_modal(trans_no){

	$("#alloc_date").val('');
	$("select option").prop("selected", 0);
	//Now fetch the data if presents
	var call = 1;
	$.ajax({
        url:"../reminder_real_estate.php",
        method:"POST",
        data:{trans_no:trans_no,call:call},
        dataType:"JSON",
        success:function(output){
        	if(output.start != ''){
      			document.getElementById('already_reminder').style.display = "block";
      		}
      		else{
      			document.getElementById('already_reminder').style.display = "none";
      		}

        	$("#alloc_date").val(output.start);
        	$("#note").val(output.note);
        	$("select option").prop("selected", output.notification);
        }
	});
}

function modal_viewer(trans_no){
	document.getElementsByName('selected_del')[0].value=trans_no;
	reset_modal(trans_no);
	$('#allocModal').modal('show');
	$('#alloc_date').datepicker({
		autoclose: true
	});
	$('#change').show();
}

function process_data(){
	var trans_no = document.getElementsByName("selected_del")[0].value;
	var alloc_date = $('#alloc_date').val();
	var note = $('#note').val();
	var rem_not = $('#rem_not').val();

	if(alloc_date == "" || alloc_date == '00/00/0000'){
		alert("Reminder Date must be selected to Process");
	}
	else{

		$.ajax({
      url:"../reminder_real_estate.php",
      method:"POST",
      data:{trans_no:trans_no,alloc_date:alloc_date,rem_not:rem_not,note:note},
      dataType:"JSON",
      success:function(data){
  			document.getElementById('already_reminder').style.display = "block";
      }
		});
	}
}

$('#alloc_date').datepicker({
	autoclose: true
});

</script>
