<?php 
$path_to_root = "../..";

include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$page_security = 'SA_RETENTIONDASHBOARD';

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_("Retention Management Dashboard"), false, false, "", $js);


//-----------------------------------------------------------------------------
//Helper Function
function customer_name($row){
    return get_customer_name($row['debtor_no']);
}

function branch_name($row){
    return get_branch_name($row['branch_code']);
}

function send_sms($row){
    if(!$row['phone'])
        return '';
    
    return '<a class="" href="javascript:modal_viewer(\''.$row['phone'].'\', 
    \''.$row['name'].'\',1)">SMS</i></a>';
}

function send_email($row){
    if(!$row['email'])
        return '';
    
    return '<a class="" href="javascript:modal_viewer(\''.$row['email'].'\', 
    \''.$row['name'].'\',2)">E-Mail</i></a>';
}

function comment_link($row){
    return '<a class="" href=javascript:modal_viewer_comment("'.$row['debtor_no'].'","'.
    $row['branch_code'].'")>'.
    set_icon(ICON_COMMENT).'</a>';
}

function get_order_count($row){
    global $path_to_root;
    if($row['ord_count'])
        return get_customer_trans_view_str(SM_CUSTOMER, $row['debtor_no'].'-'.$row['branch_code'], 
        number_format2($row['ord_count'], 0), false, '', '', $path_to_root);
    else
        return "N/A";
}

function bulksms_check($row){
    if($row['phone']){
        $name = "phone".$row['phone'];
        return checkbox(null, $name, null, false, _('Select this customer for bulk SMS')).
        "<input name='Sel_[".$row['phone']."]' type='hidden' value='".$row['phone']."'>\n";
    }
    else{
        return '';
    }
}

if(isset($_POST['SendSMS'])){
    if($_POST['sms_content']){
        foreach($_POST['Sel_'] as $number){
            if($_POST['phone'.$number]){
                send_sms($_POST['sms_content'], $number);
                $count++;
            }
        }
        if($count)
            display_notification("SMS sent to selected customers");
        else
            display_warning(_("No customers selected for bulk SMS"));
    }
    else{
        display_warning(_("Can not send empty text"));
    }
}

start_form();


?>
<div class="container-fluid">
  	<div class="modal fade" id="EmailModal" role="dialog">
    	<div class="modal-dialog" style="width: 30%;">
	      	<div class="modal-content">
	        	<div class="modal-header">
	          		<a class="close" data-dismiss="modal">&times;</a>
	          		<h4 class="modal-title">Send Email</h4>
	          		<br>
	        	</div>
	        	<div class="modal-body" style="text-align: center;">
	        	    <label id="noti_email" style="display:none;"></label>
	        	    <label>Subject:</label>
					<textarea id="subject_email" name="subject_email" rows="2"
					cols="50"></textarea>
	          		<br>
                    <label>Message:</label>
					<textarea id="message_email" name="message_email" rows="4"
					cols="50"></textarea>
	          		<br>
	          		<br>
	          		<a href="javascript:send_email()" class='btn btn-success'>
	          		Send
	          		</a>
	        	</div>
	      	</div>
		</div>
  	</div>
</div>


<div class="container-fluid">
  	<div class="modal fade" id="SMSModal" role="dialog">
    	<div class="modal-dialog" style="width: 30%;">
	      	<div class="modal-content">
	        	<div class="modal-header">
	          		<a class="close" data-dismiss="modal">&times;</a>
	          		<h4 class="modal-title">Send SMS</h4>
	          		<br>
	        	</div>
	        	<div class="modal-body" style="text-align: center;">
	        	    <label id="noti_sms" style="display:none;"></label>
                    <label>Message:</label>
					<textarea id="message_sms" name="message_sms" rows="4" 
					cols="50"></textarea>
	          		<br>
	          		<br>
	          		<a href="javascript:send_sms()" class='btn btn-success'>
	          		Send
	          		</a>
	        	</div>
	      	</div>
		</div>
  	</div>
</div>
<div class="container-fluid">
    <div class="modal fade" id="ComModal" role="dialog">
        <div class="modal-dialog" style="width: 50%;">
            <div class="modal-content">
                <div class="modal-header">
                    <a class="close" data-dismiss="modal">&times;</a>
                    <h4 class="modal-title">Line Comments</h4>
                    <br>
                </div>
                <div class="modal-body" style="text-align: center;">
                    <label id="notification" style="display:none;"></label>
                    <table class="table table-striped" id="com_table" name="com_table" style="width: 100% !important;">
                        <thead>
                            <th>S. No.</th>
                            <th>Comment</th>
                            <th>User</th>
                            <th>Time Stamp</th>
                        </thead>
                        <tbody id="com_body" name="com_body">
                        </tbody>
                    </table>
                    <br>
                    <hr>
                    <label>Enter Comment: &nbsp;</label><br>
                    <textarea id="comment" name="comment" rows="4" cols="50">
                    </textarea>                    
                    <br>
                    <br>
                    <a href="javascript:process_comment()" class='btn btn-success'>Add Comment</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

hidden('phone', '');
hidden('email', '');
hidden('name', '');
hidden('debtor_no', '');
hidden('branch_code', '');

if(isset($_POST['SearchOrders'])){
    $Ajax->activate('_page_body');
    $Ajax->activate('filters');
}

if(isset($_POST['ClearFilter'])){
    unset($_POST);
    $Ajax->activate('_page_body');
    $Ajax->activate('filters');
}



div_start('filters');

start_table(TABLESTYLE_NOBORDER);

customer_list_cells(_("Select a customer: "), 'customer', null, true, true);
label_cells(_("Branch:"), branches_list('branch', null, false,
$_POST['customer'], _("Select Branch"), false));
sales_areas_list_cells(_("Sales Area"), 'sales_area', null, _("Select Area"));
sales_types_list_cells(_("Sales Channel"), "sales_type", null, false, true);
end_table();

start_table(TABLESTYLE_NOBORDER);
date_cells(_("Last Order Before:"), 'ord_date', '', null, 0, 0, 0, null, false, true);
amount_cells_ex(_("Last Order Before"), 'days_before', 7, 12, null, null, null, 0);
small_amount_cells(_("Min. Order Amount"), 'amount', null);
sales_items_list_cells("Select Item",'stock_id', null, true);

echo "<td>".retention_dashboard_print(
_("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"),
true, SM_CUSTOMER, null, '', '', $_POST['customer'], $_POST['branch'], $_POST['sales_type'], $_POST['ord_date'], 
input_num('amount'), $_POST['stock_id'], 
input_num('days_before'), 0) ."</td>"; 

echo "<td>".retention_dashboard_print(
_("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme().
"/images/excel.png>"), true, SM_CUSTOMER, null, '', '', $_POST['customer'], $_POST['branch'], 
$_POST['sales_type'], $_POST['ord_date'], input_num('amount'), 
$_POST['stock_id'], input_num('days_before'),1) ."</td>"; 



submit_cells('SearchOrders', _("Search"), '',_('Select documents'), 'default');
submit_cells('ClearFilter', _("Clear Filters"), '',_('Clear All Filters'), 'default');
end_table();

start_table(TABLESTYLE_NOBORDER);
textarea_cells("SMS Content:", 'sms_content', null, 40, 20);
submit_cells('SendSMS', _("Send Bulk SMS"), '',_('Send Bulk SMS'), 'default');
end_table(1);
div_end();


$cols = array(
		_("Customer Name") => array('fun'=>'customer_name'),
		_("Branch Name") => array('fun'=>'branch_name'),
		_("Mobile No"),
		_("Email Address"), 
		_("Total Orders") => array('fun'=>'get_order_count'),
		_("Last Order Date") => array('type'=>'date'),
		_("Total Order Amount") => array('type'=>'amount'),
	);
array_append($cols, array(
    array('insert'=>true, 'fun'=>'bulksms_check'),
    array('insert'=>true, 'fun'=>'comment_link'),
    array('insert'=>true, 'fun'=>'send_sms'), 
    array('insert'=>true, 'fun'=>'send_email')));


$sql = get_sql_for_retention_dashboard($_POST['customer'], $_POST['branch'], $_POST['sales_type'], $_POST['ord_date'],
input_num('amount'), $_POST['stock_id'], input_num('days_before'));

$table =& new_db_pager('client_tbl', $sql, $cols);
$table->width = "80% !important";
$table->page_len = 20;
display_db_pager($table);
end_form();
end_page();
?>

<script>

function reset_modal(note){
    if(note != 1){
	    var label1 = document.getElementById('noti_email');
	    var label2 = document.getElementById('noti_sms');
    	label1.style.display = "none";
    	label2.style.display = "none";
	}
	document.getElementById('message_email').value = "";
	document.getElementById('subject_email').value = "";
	document.getElementById('message_sms').value = "";
}


function modal_viewer(contact, name, type){
	
	if(type==1){
	    document.getElementsByName('phone')[0].value=contact;
	    $('#SMSModal').modal('show');
	}
	else if(type==2){
	    document.getElementsByName('email')[0].value=contact;
	    $('#EmailModal').modal('show');
	}
	document.getElementsByName('name')[0].value=name;
	$('#change').show();
	reset_modal();    
}

function send_email(){
    var message = document.getElementById('message_email').value;
    var subject = document.getElementById('subject_email').value;
    var name = document.getElementsByName('name')[0].value;
    var email = document.getElementsByName('email')[0].value;
    
    if(subject == '' || message == ''){
        var label = document.getElementById('noti_email');
        label.style.color = "red";
    	label.innerHTML = 'Subject and Message must be entered.';
    	label.style.display = "block";
    	return 0;
    }
    
    $.ajax({
        url:"../includes/send_email.php",
        method:"POST",
        data:{message:message,email:email,subject:subject, name:name},
        dataType:"JSON",
        success:function(output){
            var label = document.getElementById('noti_email');
            if(output==1){
                label.style.color = "green";
            	label.innerHTML = 'Email Sent';
            	reset_modal(1);
            }
            else{
            	label.style.color = "red";
            	label.innerHTML = 'Failed to send Email.';
            }
        	label.style.display = "block";
        }
	});
}

function send_sms(){
    var message = document.getElementById('message_sms').value;
    var name = document.getElementsByName('name')[0].value;
    var phone = document.getElementsByName('phone')[0].value;
    
    if(message == ''){
        var label = document.getElementById('noti_sms');
        label.style.color = "red";
    	label.innerHTML = 'Message must be entered.';
    	label.style.display = "block";
    	return 0;
    }
    
    $.ajax({
        url:"../includes/send_sms.php",
        method:"POST",
        data:{message:message,phone:phone,name:name},
        dataType:"text",
        success:function(output){
            var label = document.getElementById('noti_sms');
            if(output==1){
                label.style.color = "green";
            	label.innerHTML = 'SMS sent successfully';
            	reset_modal(1);
            }
            else{
            	label.style.color = "red";
            	label.innerHTML = 'Failed to send SMS.';
            }
        	label.style.display = "block";
        }
	});
}

function modal_viewer_comment(debtor_no, branch_code){
    $('#ComModal').modal('show');
    $('#change').show();
    document.getElementsByName('debtor_no')[0].value=debtor_no;
    document.getElementsByName('branch_code')[0].value=branch_code;
    reset_modal_comment(debtor_no, branch_code, 0);
}

function process_comment(){
    var debtor_no = document.getElementsByName("debtor_no")[0].value;
    var branch_code = document.getElementsByName("branch_code")[0].value;
    var comment = $("#comment").val();
        
    $.ajax({
        url:"../includes/add_comments.php",
        method:"POST",
        data:{debtor_no:debtor_no, branch_code:branch_code, comment:comment},
        dataType:"JSON",
        success:function(result){
            var label = document.getElementById('notification');
            if(result==1){
                label.style.color = "green";
                label.innerHTML = 'Comment Entered';
            }
            else{
                label.style.color = "red";
                label.innerHTML = 'Failed to enter Comment';
            }
            label.style.display = "block";
            reset_modal_comment(debtor_no, branch_code, 1);
        }
    });
}


function reset_modal_comment(debtor_no, branch_code, note){
    //Unset The list
    document.getElementById('comment').value = "";

    if(note == 0){
        var label = document.getElementById('notification');
        label.style.display = "none";
    }

    //Now fetch the data if presents
    $.ajax({
        url:"../includes/get_comments.php",
        method:"POST",
        data:{debtor_no:debtor_no, branch_code:branch_code},
        dataType:"JSON",
        success:function(output){
            //First Remove All the rows
            $("#com_body").empty();
            //Now Create New
            for(var i=0; i<output.length; i++){
                $('#com_table > tbody:last-child').append('<tr><td>'+output[i].serial+
                '</td><td>'+output[i].comment+'</td><td>'+output[i].user+'</td><td>'+
                output[i].stamp+'</td></tr>');
            }
        }
    });
}
</script>