<?php

$page_security = 'SA_OPEN';
$path_to_root = "..";
// include($path_to_root . "/includes/session.inc");

page(_($help_context = "Agreement Pricing"));

include($path_to_root . "/includes/ui.inc");
include($path_to_root . "/CRM/includes/db/agreement_pricing_db.inc");
simple_page_mode(true);



//-------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if ($_POST['opportunity_id'] !=0) {
		$opportunity_id = $_POST['opportunity_id'];
	}elseif ($_POST['agreement_id'] != 0) {
		$opportunity_id =$_POST['agreement_id'];
	}

	if (strlen($_POST['description']) == 0) 
	{
		$input_error = 1;
		display_error(_("The sales group description cannot be empty."));
		set_focus('description');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_agreement_pricing($selected_id, $_POST['description'], $_POST['payment_terms'], $_POST['price']);
			$note = _('Selected agreement pricing has been updated');
    	} 
    	else 
    	{
    		add_agreement_pricing($_POST['description'], $_POST['payment_terms'], $_POST['price'],$opportunity_id);
			$note = _('New agreement pricing has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	if (key_in_foreign_table($selected_id, 'cust_branch', 'group_no'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this agreement pricing because customers have been created using this agreement pricing."));
	} 
	if ($cancel_delete == 0) 
	{
		delete_agreement_pricing($selected_id);
		display_notification(_('Selected agreement pricing has been deleted'));
	} //end if Delete group
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	if ($sav) $_POST['show_inactive'] = 1;
}
//-------------------------------------------------------------------------------------------------

$result = get_agreement_pricing(check_value('show_inactive'));

start_form();

if ($_POST['agreement_id'] != 0) {

	$myrow=	get_agreement_pricing_opportunity($_POST['agreement_id']);
			$_POST['id'] =  $myrow['id'];
		$_POST['description'] =  $myrow['description'];
		$_POST['payment_terms'] =  $myrow['payment_terms'];
		$_POST['price'] =  $myrow['price'];

	global $Ajax;
	$Ajax->activate('_page_body');
}







start_table(TABLESTYLE5_BOX,"",0,0,0,null,"50%","2px solid #2CABE3;");
// start_table(TABLESTYLE4, "width='30%'");
$th = array(_("ID"), _("Description"), _("Payment Terms"), _("AED"), "", "",);
inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
		
	label_cell($myrow["id"], "nowrap align='right'");
	label_cell($myrow["description"]);
	label_cell($myrow["payment_terms"]);
	label_cell(($myrow["price"]). '/-');
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'agreement_pricing', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE5_BOX,"",0,0,0,null,"30%","3px solid #656E79;");
// start_table(TABLESTYLE2,"style='width:50%'");

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing group
		$myrow = get_agreements_pricing($selected_id);

		$_POST['description']  = $myrow["description"];
		$_POST['payment_terms']  = $myrow["payment_terms"];
		$_POST['price']  = $myrow["price"];
	}
	hidden("selected_id", $selected_id);
	label_row(_("ID"), $myrow["id"]);
} 

text_row_ex(_("Description:"), 'description', 100);
text_row_ex(_("Payment Terms:"), 'payment_terms', 30);  
text_row_ex(_("AED:"), 'price', 30);  

end_table(1);

if ($_POST['id']) {
		$selected_id=$_POST['id'];
		hidden('selected_id',$selected_id);
		// display_error($selected_id);
	}
submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
