<?php

$page_security = 'SA_COMPLAINTTYPE';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Complaint Types"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/CRM/includes/db/complaint_type_db.inc");

simple_page_mode(true);
//----------------------------------------------------------------------------------------------------

function can_process($selected_id=-1){

	if (strlen($_POST['complaint_type']) == 0){
		display_error(_("The complaint type description cannot be empty."));
		set_focus('complaint_type');
		return false;
	}
	return true;
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' && can_process()){
	add_complaint_type($_POST['complaint_type'], check_value('order_compulsory'));
	display_notification(_('New sales type has been added'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='UPDATE_ITEM' && can_process($selected_id)){

	update_complaint_type($selected_id, $_POST['complaint_type'], check_value('order_compulsory'));
	display_notification(_('Selected complaint type has been updated'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	// PREVENT DELETES IF DEPENDENT RECORDS IN 'complaints'
	if(false){
		display_error(_("Cannot delete this sale type because customers are currently set up to use this sales type."));
	}
	else{
		delete_complaint_type($selected_id);
		display_notification(_('Selected sales type has been deleted'));
		$Mode == 'RESET';
	}
}

if ($Mode == 'RESET'){
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}
//----------------------------------------------------------------------------------------------------

$result = get_all_complaint_types(check_value('show_inactive'));

start_form();

start_table(TABLESTYLE5_BOX,"",0,0,0,null,"40%","3px solid #656E79;");

$th = array (_('Type Name'), _('Order Compulsory'), '', '');
inactive_control_column($th);
table_header($th);
$k = 0;

while ($myrow = db_fetch($result)){
    
    alt_table_row_color($k);
	
	label_cell($myrow["complaint_type"]);

	label_cell($myrow["order_compulsory"] ? _('Yes'):_('No'), 'align=center');
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'complaint_types', 'id');
 	edit_button_cell("Edit".$myrow['id'], _("Edit"));
 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
	end_row();
}
inactive_control_row($th);
end_table();

br();
//----------------------------------------------------------------------------------------------------

start_table(TABLESTYLE6_BOX,"",0,0,0,null,"30%","3px solid #656E79;");

if ($selected_id != -1){

 	if ($Mode == 'Edit') {
		$myrow = get_complaint_type($selected_id);

		$_POST['complaint_type']  = $myrow["complaint_type"];
		$_POST['order_compulsory']  = $myrow["order_compulsory"];
	}
	hidden('selected_id', $selected_id);
} 
else {
	$_POST['factor']  = number_format2(1,4);
}

text_row_ex(_("Complaint Type Name").':', 'complaint_type', 24);
check_row(_("Order Number Compulsory").':', 'order_compulsory', $_POST['order_compulsory']);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

