<?php

$page_security = 'SA_INQUIRYTYPE';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Inquiry Type"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/CRM/includes/db/inquiry_type_db.inc");

simple_page_mode(true);
//----------------------------------------------------------------------------------------------------

function can_process($selected_id=-1){

	if (strlen($_POST['inquiry_type']) == 0){
		display_error(_("The Source Record Name cannot be empty."));
		set_focus('inquiry_type');
		return false;
	}
	return true;
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' && can_process()){
	add_inquiry_type($_POST['inquiry_type']);
	display_notification(_('New Source Record has been added'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='UPDATE_ITEM' && can_process($selected_id)){

	update_inquiry_type($selected_id, $_POST['inquiry_type']);
	display_notification(_('Selected Source Record has been updated'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	// PREVENT DELETES IF DEPENDENT RECORDS IN 'complaints'


	// if (key_in_foreign_table($selected_id, 'real_estate_buyer', 'source'))
	// {
	// 	$cancel_delete = 1;
	// 	display_error(_("Cannot delete this Source Record because customers are currently set up to use this Source Record."));
	// } 

	// else{
		delete_inquiry_type($selected_id);
		display_notification(_('Selected Source Record has been deleted'));
		$Mode == 'RESET';
	// }
}

if ($Mode == 'RESET'){
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}
//----------------------------------------------------------------------------------------------------

$result = get_all_inquiry_type(check_value('show_inactive'));

start_form();

start_table(TABLESTYLE5_BOX,"",0,0,0,null,"40%","3px solid #656E79;");

$th = array (_('Id'), _('Inquiry Type'), '', '');
inactive_control_column($th);
table_header($th);
$k = 0;

while ($myrow = db_fetch($result)){
    
    alt_table_row_color($k);
	
	label_cell($myrow["id"]);

	label_cell($myrow["inquiry_type"] , 'align=center');
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'source_records', 'id');
 	edit_button_cell("Edit".$myrow['id'], _("Edit"));
 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
	end_row();
}
inactive_control_row($th);
end_table();

br();
//----------------------------------------------------------------------------------------------------

start_table(TABLESTYLE6_BOX,"",0,0,0,null,"30%","3px solid #656E79;");

if ($selected_id != -1){

 	if ($Mode == 'Edit') {
		$myrow = get_inquiry_type($selected_id);

		$_POST['id']  = $myrow["id"];
		$_POST['inquiry_type']  = $myrow["inquiry_type"];
		// $_POST['order_compulsory']  = $myrow["order_compulsory"];
	}
	hidden('selected_id', $selected_id);
} 

text_row_ex(_("Inquiry Type").':', 'inquiry_type');


end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

