<?php
/**********************************************************************
Copyright (C) FrontAccounting, LLC.
Released under the terms of the GNU General Public License, GPL, 
as published by the Free Software Foundation, either version 3 
of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$path_to_root="..";
$page_security = 'SA_ATTACHINQUIRY';

include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/admin/db/attach_inquiry_db.inc");
include_once($path_to_root . "/admin/db/transactions_db.inc");



$js = "";
if ($SysPrefs->use_popup_windows)
$js .= get_js_open_window(800, 500);



page(_($help_context = "Attach Documents (New)"), false, false, "", $js);

simple_page_mode(true);
// $attachment_array = array();


//----------------------------------------------------------------------------------------
// ini_set('post_max_size', '128M');
// ini_set('upload_max_filesize', '128M');

if (isset($_GET['NEW'])) {
	if (count($_SESSION['attach_obj']) > 0) {
	$dir = company_path()."/attachments/attachments_inquiry/temp";
	foreach ($_SESSION['attach_obj'] as $key => $value) {
		if ($_SESSION['attach_obj'][$key]['curr_user'] == $_SESSION['wa_current_user']->user) {
			if (file_exists($dir."/".basename($_SESSION['attach_obj'][$key]['temp_name']))) {
				unlink($dir."/".basename($_SESSION['attach_obj'][$key]['temp_name']));
			}
		}
	}
}
	$_SESSION['attach_obj'] = array();
	$_SESSION['line_no'] = 0;
}

function handle_new_item($line_no,$name,$temp_name,$type,$size,$discription, $sh_discription){
	$_SESSION['attach_obj'][$line_no] = array(
		'name' => $name,
		'temp_name' => $temp_name,
		'type' => $type,
		'size' => $size,
		'description' => $discription,
		'short_description' => $sh_discription,
		'curr_user' => $_SESSION['wa_current_user']->user
	);
	
}

$_SESSION['line_no'] = ((isset($_SESSION['line_no'])) ? $_SESSION['line_no'] : 0);
$dir = company_path()."/attachments/attachments_inquiry/temp";

if (isset($_POST['submit_att']) || $Mode == 'UPDATE_ITEM')
{
$allowed_image_extension = array("png","jpg","jpeg","pdf","doc","docx","xlsx","xls","PNG");
$file_extension = pathinfo($_FILES['filename']['name'], PATHINFO_EXTENSION);


if ($_POST['submit_att'] && empty($_POST['description']))
display_error(_("Fill the description."));
elseif($_POST['submit_att'] && !in_array($file_extension, $allowed_image_extension))
display_error(_("File format not supported."));
elseif ($_POST['submit_att'] && !isset($_FILES['filename']))
display_error(_("Select attachment file."));
elseif ($_POST['submit_att'] && $_FILES['filename']['size'] > '157286400')
display_error(_("File size must be less than or equal to 150 mb."));
elseif ($_POST['submit_att'] && ($_FILES['filename']['error'] > 0)) {
if ($_FILES['filename']['error'] == UPLOAD_ERR_INI_SIZE) 
display_error(_("The file size is over the maximum allowed."));
else
display_error(_("Select attachment file."));
}
else {

	$name =	$_FILES['filename']['name'];
	$temp_name = $_FILES['filename']['tmp_name'];
	$size = $_FILES['filename']['size'];
	$type = $_FILES['filename']['type'];
	$discription = $_POST['description'];
	$sh_discription = $_POST['short_description'];
   
	 handle_new_item($_SESSION['line_no'],$name,$temp_name,$type,$size,$discription, $sh_discription);
	$_SESSION['line_no']++;

$tmpname = $_FILES['filename']['tmp_name'];

if (!file_exists($dir))
{
mkdir ($dir,0777);
$index_file = "<?php\nheader(\"Location: ../index.php\");\n";
$fp = fopen($dir."/index.php", "w");
fwrite($fp, $index_file);
fclose($fp);
}

$filename = basename($_FILES['filename']['name']);


//save the file
$format = substr($_FILES['filename']['name'], strpos($_FILES['filename']['name'], ".") + 1); 
move_uploaded_file($tmpname, $dir."/".basename($tmpname));



// $Ajax->activate('_page_body');
$Mode = 'RESET';
}
// refresh_pager('trans_tbl');
}


if (isset($_POST['process_inquiry'])) {

	if ($_POST['opportunity_id'] !=0) {
		$opportunity_id = $_POST['opportunity_id'];
	}elseif ($_POST['agreement_id'] != 0) {
		$opportunity_id =$_POST['agreement_id'];
	}


	$permenent_dir = company_path()."/attachments/attachments_inquiry";
	if (count($_SESSION['attach_obj']) <= 0) {
		display_error("Please add atleast one record");
	}else{
		$attach_id = add_attachment_inquiry_header($_SESSION['wa_current_user']->user,$opportunity_id);
		foreach ($_SESSION['attach_obj'] as $key => $value) {

			$format = substr($_SESSION['attach_obj'][$key]['name'], strpos($_SESSION['attach_obj'][$key]['name'], ".") + 1);
			// $unique_name = random_id().".".$format;
			$unique_name = $attach_id."_".date('Y_m_d_h_i_s',strtotime('now'))."_".rand(10,100).".".$format;
			if (file_exists($dir."/".basename($_SESSION['attach_obj'][$key]['temp_name']))) {
			rename($dir."/".basename($_SESSION['attach_obj'][$key]['temp_name']),$permenent_dir."/".$unique_name);
			add_attachment_inquiry($attach_id, $_SESSION['attach_obj'][$key]['description'],$_SESSION['attach_obj'][$key]['name'], $unique_name, $_SESSION['attach_obj'][$key]['size'], $_SESSION['attach_obj'][$key]['type'],$_SESSION['attach_obj'][$key]['short_description']);
			}
			
			
			
		}
		add_audit_trail(SM_ATTACHDOC,$attach_id,null,'Attachment Added');
		$Mode = 'RESET';
		$_SESSION['attach_obj'] = array();
		display_notification(_("Inquiry has been inserted.")); 
		$Ajax->activate('_page_body');
	}
}


if ($Mode == 'RESET')
{
unset($_POST['trans_no']);
unset($_POST['description']);
unset($_POST['short_description']);
$selected_id = -1;
}

function download_link($row)
{ global $path_to_root;
$format = substr($row['filename'], strpos($row['filename'], ".") + 1);
return "<a href=".company_path(). "/attachments/".$row['unique_name'].".".$format." download><img src='".$path_to_root."/themes/synergy/images/download.gif' style='vertical-align:middle;width:16px;height:16px;border:0;'></a>";

}


$delete_id =find_submit('Delete');
if ($delete_id != -1) {
	if (file_exists($dir."/".basename($_SESSION['attach_obj'][$delete_id]['temp_name']))) {
	unlink($dir."/".basename($_SESSION['attach_obj'][$delete_id]['temp_name']));
	unset($_SESSION['attach_obj'][$delete_id]);
	}
	$Ajax->activate('_page_body');
	$Mode = 'RESET';
}

function display_rows($attach_obj)
{

	$headers = array("",_("File Name"),_("Type"),_("Size"),_("Description"),_("Short Description"));
	start_table(TABLESTYLE2);
	db_table_header($headers,'font-weight: normal;font-size:15px;background:#f2f2f2;border:1px solid #dee2e6;');

	foreach ($_SESSION['attach_obj'] as $key => $value) {
	start_row();
	label_cell(button('Delete'.$key, ("Delete"), ("Delete"), ICON_DELETE));
	label_cell($_SESSION['attach_obj'][$key]['name']);
	label_cell($_SESSION['attach_obj'][$key]['type']);
	label_cell($_SESSION['attach_obj'][$key]['size']);
	label_cell($_SESSION['attach_obj'][$key]['description']);
	label_cell($_SESSION['attach_obj'][$key]['short_description']);
	end_row();

	}
	end_table(1);

}

//----------------------------------------------------------------------------------------

start_form(true);


if ($_POST['agreement_id'] != 0) {
	$myrow =get_agreement_attachment_opportunity($_POST['agreement_id']);
	$_POST['id'] =  $myrow['id'];
	$_POST['description'] =  $myrow['description'];
	$_POST['short_description'] =  $myrow['short_description'];
	$_FILES['filename'] =  $myrow['filename'];
	// display_error( $_POST['id'] );

	global $Ajax;
	$Ajax->activate('_page_body');
}
// viewing_controls();

start_table(TABLESTYLE2);

text_row_ex(_("Description").':', 'description', 40);
text_row_ex(_("Short Description").':', 'short_description', 40);
label_row(_(" "),$_FILES['filename'] );
file_row(_("Attached File (MAX 150mb):"), 'filename', 'filename');
// start_row();
echo "<tr><td></td><td>";

submit('submit_att', _("Add new"), true, '', true);
echo "</td></tr>";

// end_row();
end_table(1);
echo"<center>";
submit_row('process_inquiry',_('Process'), true,"", false, true);
echo"</center>";


br(2);
display_rows($_SESSION['attach_obj']);


end_form();

end_page();
