<?php

function write_project($id=false, $proj_name='', $desc='', $type='', $created_date='', $closed_date=null, $begin_date='', $end_date='', $owner='', $closed=0, $contact_person='', $oppor='', $status='',$attach='',$amount=0,$deliver=0, $delivery_date, $enq_date='', $job_date='', $source='', $name='', $mobile='', $email='', $postal_address='', $attach_front='', $attach_back='', $inquiry_type='') {
    if(!$id) {  
    	if(!empty($closed) && is_date($created_date))
    		$sql = "INSERT INTO ".TB_PREF."projects(proj_name, proj_description, proj_type, created_date, closed_date, begin_date, end_date, owner_id, closed, contact_person, opportunity, status, attachment, amount, deliver, delivery_date, enq_date, job_date, source, name , mobile,  email, postal_address, attach_front, attach_back, inquiry_type ) VALUES(".db_escape($proj_name).", ".db_escape($desc).", ".db_escape($type).", '".date2sql($created_date)."', '".date2sql($closed_date)."', '".date2sql($begin_date)."', '".date2sql($end_date)."', ".db_escape($owner).", ".db_escape($closed).", ".db_escape($contact_person).", ".db_escape($oppor).", ".db_escape($status).", ".db_escape($attach).", ".db_escape($amount).", ".db_escape($deliver).", ".db_escape($delivery_date).",".db_escape(date2sql($enq_date)).",".db_escape(date2sql($job_date)).", ".db_escape($source).", ".db_escape($name).", ".db_escape($mobile).", ".db_escape($email).", ".db_escape($postal_address).", '".$attach_front."', '".$attach_back."', '".$inquiry_type."')";
    	else
    		$sql = "INSERT INTO ".TB_PREF."projects(proj_name, proj_description, proj_type, created_date, begin_date, end_date, owner_id, closed, contact_person, opportunity, status, attachment, amount, deliver, delivery_date, enq_date, job_date, source, name , mobile,  email, postal_address, attach_front, attach_back, inquiry_type) VALUES(".db_escape($proj_name).", ".db_escape($desc).", ".db_escape($type).", '".date2sql($created_date)."', '".date2sql($begin_date)."', '".date2sql($end_date)."', ".db_escape($owner).", ".db_escape($closed).", ".db_escape($contact_person).", ".db_escape($oppor).", ".db_escape($status).", ".db_escape($attach).", ".db_escape($amount).", ".db_escape($deliver).", ".db_escape($delivery_date).", '".date2sql($enq_date)."', '".date2sql($job_date)."', ".db_escape($source).", ".db_escape($name).", ".db_escape($mobile).", ".db_escape($email).", ".db_escape($postal_address).", '".$attach_front."', '".$attach_back."', '".$inquiry_type."')";
    }
	else {
		if(!empty($closed) && is_date($created_date)){
			$sql = "UPDATE ".TB_PREF."projects SET deliver = ".db_escape($deliver).", delivery_date = ".db_escape($delivery_date).", proj_name = ".db_escape($proj_name).", proj_description = ".db_escape($desc).", proj_type = ".db_escape($type).", created_date = '".date2sql($created_date)."', closed_date = '".date2sql($closed_date)."', begin_date = '".date2sql($begin_date)."', end_date = '".date2sql($end_date)."', owner_id = ".db_escape($owner).", closed = ".db_escape($closed)." , contact_person = ".db_escape($contact_person).", opportunity = ".db_escape($oppor).", status = ".db_escape($status)." , amount = ".db_escape($amount)." , attachment = ".db_escape($attach).", enq_date = '".date2sql($enq_date)."', job_date = '".date2sql($job_date)."',source = ".db_escape($source).", name = ".db_escape($name)." , mobile = ".db_escape($mobile)." , email = ".db_escape($email)." , postal_address = ".db_escape($postal_address).", attach_front='".$attach_front."' ,attach_back='".$attach_back."' ,inquiry_type='".$inquiry_type."' WHERE proj_id = ".db_escape($id);

			 

		}
		else
			$sql = "UPDATE ".TB_PREF."projects SET deliver = ".db_escape($deliver).", delivery_date = ".db_escape($delivery_date).", proj_name = ".db_escape($proj_name).", proj_description = ".db_escape($desc).", proj_type = ".db_escape($type).", created_date = '".date2sql($created_date)."', begin_date = '".date2sql($begin_date)."', end_date = '".date2sql($end_date)."', owner_id = ".db_escape($owner).", closed = ".db_escape($closed).", contact_person = ".db_escape($contact_person).", opportunity = ".db_escape($oppor).", status = ".db_escape($status)." ,amount = ".db_escape($amount)." , attachment = ".db_escape($attach).", enq_date = '".date2sql($enq_date)."',job_date = '".date2sql($job_date)."', source = ".db_escape($source).", name = ".db_escape($name)." , mobile = ".db_escape($mobile)." , email = ".db_escape($email)." , postal_address = ".db_escape($postal_address).", attach_front='".$attach_front."', attach_back='".$attach_back."' ,inquiry_type='".$inquiry_type."' WHERE proj_id = ".db_escape($id);
	}
 // display_error($sql);exit();
	db_query($sql, _('could not write project data'));
	
	if(!$id){
		$desc =	"Opportunity Created";
		$ins_id = db_insert_id();
	}
	if($closed){
		$desc =	"Opportunity Closed";
		$ins_id = $id;
	}
	if($id){
		$desc =	"Opportunity Updated";
		$ins_id = $id;		
	}

	
	
	add_audit_trail(ST_OPPORTUNITY, $ins_id , date('Y-m-d'), $desc);
	// update_opportunity_file($contact_person);

}


//--------------------------------------------------------------------------
function update_opportunity_file($contact_person){
/*Updating File*/
$sql = "SELECT 
		pro.proj_name as title,
		pro.proj_description as content,
		pro.proj_id as id,
		pro.owner_id as responsible,
		pro.status as state,
		pro.status as color,
		pro.opportunity as comment,
		pro.amount as amt,
		pro.opportunity as opp,
		pro.owner_id as user_name,
		pro.created_date as trans_date,
		pro.contact_person as person,
		cf.comp_name
		FROM ".TB_PREF."projects as pro
		LEFT JOIN ".TB_PREF."crm_contact_form as cf
		ON pro.contact_person  = cf.cust_id
	 	WHERE !closed AND contact_person = ".$contact_person;
		$result  = db_query($sql);

while($row = db_fetch_assoc($result)) {
	$row['opp'] = get_items_name_description($row['opp'])['description'];
	$row['user_name'] = get_user($row['user_name'])['real_name'];
	$row['comment'] = "";
	$row['trans_date'] = sql2date($row['trans_date']);
	$row['amt'] = number_format($row['amt'],2);
	$row['color'] = $row['state'];

	$data[$row['id']] = $row;
}
define('DATA_FILE_C', company_path().'/kanban_data/'.$contact_person);
// if(file_exists(DATA_FILE_C)){
  $f = fopen(DATA_FILE_C, 'w') or die ("could not open file");
  fwrite($f, json_encode($data, null, 4) );
  fclose($f);
// }else{
  // $f = fopen(DATA_FILE_C, 'w') or die ("could not open file");
  // fwrite($f, json_encode($data, null, 4) );
  // fclose($f);
// }

/*Updating File*/
}
//--------------------------------------------------------------------------

function get_projects($id = false, $all = false, $type = false, $db_pager='no',$status='',$user='', $project_name='' , $opportunity='',$from_date='' , $to_date='', $remarks='', $contact_person=null) {

  
	$current_user = $_SESSION['wa_current_user']->user;
	$allow = get_user($current_user)['all_opportunities'];
	if($db_pager == 'no'){
		$sql = "SELECT * FROM ".TB_PREF."projects";
	}else{
		$sql = "SELECT proj_id,
					   '' AS 'NULL', 
					   proj_name,
					   opportunity,
					   amount,
					   proj_description,
					   -- proj_type,
					   status,
					   deliver,
					   created_date,
					   closed_date,
					   owner_id,
					   attachment,
					   contact_person
		 FROM ".TB_PREF."projects ";
	}
	$where = array();

	if($allow == 1){
			$where[] = "  1 ";						
	}else{
		$where[] = "owner_id=".db_escape($current_user);
	}
	if(!$all && !$id)
		$where[] = "!closed";

	if($contact_person)
		$where[] = "contact_person=".db_escape($contact_person);

	if($id)
		$where[] = "proj_id=".db_escape($id);
	if($status)
		$where[] = "status=".db_escape($status);
	if($project_name)
		$where[] = "proj_name LIKE '%$project_name%'";
	if($remarks)
		$where[] = "proj_description LIKE '%$remarks%'";
	if($opportunity)
		$where[] = "opportunity LIKE ('%".$opportunity."%')";
	if($user)
		$where[] = "owner_id=".db_escape($user);

  	if($from_date != '' && $to_date != '')
		$where[] =" created_date >= ".db_escape(date2sql($from_date))."
				    AND created_date <= ".db_escape(date2sql($to_date))." ";
	
	if($type === 0 || $type === 1)
		$where[] = "proj_type = ".db_escape($type);
		
if(count($where))
		$sql .= ' WHERE '.implode(' AND ', $where);
	else
		$sql .= ' WHERE 1';


	$result = db_query($sql, _('Could not get project data.'));

	if($id)
		return db_fetch($result);
	else
		return $sql;
}

//--------------------------------------------------------------------------

function delete_project($id) {
    $sql = "DELETE FROM ".TB_PREF."projects WHERE proj_id = ".db_escape($id);
    db_query($sql, _('could not delete project data'));
    add_audit_trail(ST_OPPORTUNITY, $id , date('Y-m-d'), _("Opportunity Deleted"));
}

//--------------------------------------------------------------------------

function get_last_project() {
	$sql = "SELECT MAX(proj_id) FROM ".TB_PREF."projects WHERE !closed";
	$result = db_query($sql, _('could not get project data.'));
	 return db_fetch($result);
}

//--------------------------------------------------------------------------


function get_opportunity_byid($id) {
	$sql = "SELECT * FROM ".TB_PREF."projects WHERE !closed AND proj_id = ".db_escape($id); 
	$result = db_query($sql, _('could not get project data.'));
	return db_fetch($result);
}

// //--------------------------------------------------------------------------
 

//--------------------------------------------------------------------------


function get_opportunity_bystatus($status, $user='',$opportunity='',$project='', $type = '', $all = false, $from_date='' , $to_date='', $contact_person='',$amount=false) {
	$current_user = $_SESSION['wa_current_user']->user;
	$allow = get_user($current_user)['all_opportunities'];
	
	$sql = "SELECT count(*) as c , SUM(amount) as amt FROM ".TB_PREF."projects WHERE status = ".db_escape($status); 

	if($allow != 1){
			$sql .=" AND owner_id = ".db_escape($current_user);
	}else{
		if($user != '')
			$sql .=" AND owner_id = ".db_escape($user);
		}

	if($opportunity)
		$sql .=" AND opportunity = ".db_escape($opportunity);

	if($contact_person)
		$sql .=" AND contact_person = ".db_escape($contact_person);

	if($project)
		$sql .=" AND proj_id = ".db_escape($project);

// 	if($type === 0 || $type === 1)
// 		$sql .=" AND proj_type = ".db_escape($type);

  	if($from_date != '' && $to_date != '')
		$sql .=" AND created_date >= ".db_escape(date2sql($from_date))."
				 AND created_date <= ".db_escape(date2sql($to_date))." ";
	if(!$all)
		$sql .=" AND !closed";
	
	global $Ajax;
	$Ajax->activate('count_table');
	$result = db_query($sql, _('could not get project data.'));

	if($amount)
		return db_fetch($result)['amt'];
	else
		return db_fetch($result)['c'];

}

//--------------------------------------------------------------------------


function add_project_data_file($id) {
    global $path_to_root;

    if(!file_exists(company_path().'/kanban_data'))
        mkdir(company_path().'/kanban_data');

	$content = "{}";
    $fp = fopen(company_path().'/kanban_data/'.$id, "wb");
    fwrite($fp, $content);
    fclose($fp);

    if(file_exists(company_path().'/kanban_data/'.$id))
        return true;
    else
        return false;
}


//--------------------------------------------------------------------------
function get_opportunity_detail_by_contact_person($contact_person){

$sql = "SELECT 
		pro.proj_name as title,
		pro.proj_description as content,
		pro.proj_id as id,
		pro.owner_id as responsible,
		pro.status as state,
		pro.status as color,
		pro.opportunity as comment,
		pro.amount as amt,
		pro.opportunity as opp,
		pro.owner_id as user_name,
		pro.created_date as trans_date,
		pro.contact_person as person,
		cf.comp_name as company,
		cf.phone as phone
		FROM ".TB_PREF."projects as pro
		LEFT JOIN ".TB_PREF."crm_contact_form as cf
		ON pro.contact_person  = cf.cust_id
	 	WHERE !closed
	 	AND pro.contact_person = ".$contact_person;

		$result  = db_query($sql);

		return db_fetch($result);
	}
	
	
function get_deliver_count(){
    $sql = "SELECT COUNT(*) as c FROM ".TB_PREF."projects WHERE deliver != '' AND deliver != '0.00'";
    $result = db_query($sql);
    return db_fetch($result)['c'];
}

function get_deliver_sum(){
    $sql = "SELECT SUM(deliver) as s FROM ".TB_PREF."projects WHERE deliver != '' AND deliver != '0.00'";
    $result = db_query($sql);
    return db_fetch($result)['s'];
}
	

function update_opportunity_status($opp_id=null, $status=null){
	$sql = " UPDATE ".TB_PREF."projects SET status = ".db_escape($status)." WHERE proj_id = ".db_escape($opp_id);
	db_query($sql);

	if($status == 2)
		$desc = "Proposal Created";
	if($status == 3)
		$desc = "Deal Created";
	add_audit_trail(ST_OPPORTUNITY, $opp_id, date('Y-m-d'), $desc);

}
	
	
function check_quotation_against_opp($opp_id){
	$sql = " SELECT COUNT(*) as count FROM ".TB_PREF."sales_orders 
			 WHERE opp_id =".db_escape($opp_id)."
			 AND trans_type = ".db_escape(ST_SALESQUOTE);
	$result = db_query($sql);
	return db_fetch($result)['count'];
}