<?php

$page_security = 'SA_OPEN';
$path_to_root = "..";
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/CRM/includes/db/crm_real_estate_db.inc");
include($path_to_root . "/includes/ui.inc");

global $Ajax;

page(_($help_context = "Real Estate Form")); 

if($_GET['id']){
	$_POST['real_estate_id'] = $_GET['id'];
}

simple_page_mode(true);

if($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM'){
    $input_error = 0;

    if(!$_FILES['doc_file']['name'] && $Mode== "ADD_ITEM"){
        display_error(_("File must be attached."));
        set_focus('doc_file');
        $input_error = 1;
    }

    if(!$input_error){
        //Add function
        if($Mode=="ADD_ITEM"){
            $unique_name = random_id().".".pathinfo($_FILES['doc_file']['name'], PATHINFO_EXTENSION);
            add_real_estate_document($_POST['real_estate_id'], $_POST['doc_name'], $unique_name, $_FILES['doc_file']['name']);

            $dir = company_path()."/attachments/crm_real_estate";
            if (!file_exists($dir)){
                mkdir ($dir,0777);
                $index_file = "<?php\nheader(\"Location: ../index.php\");\n";
                $fp = fopen($dir."/index.php", "w");
                fwrite($fp, $index_file);
                fclose($fp);
            }
            move_uploaded_file($_FILES['doc_file']['tmp_name'], $dir."/".$unique_name);

            display_notification(_("Document attached"));
            $Ajax->activate('doc_table');
            $Mode = "RESET";
        }
        elseif($Mode == "UPDATE_ITEM"){
            $unique_name = random_id().".".pathinfo($_FILES['doc_file']['name'], PATHINFO_EXTENSION);
            update_real_estate_document($_POST['doc_id'], $_POST['doc_name'], $unique_name, $_FILES['doc_file']['name']);

            if($_FILES['doc_file']['tmp_name']){
                $dir = company_path()."/attachments/crm_real_estate";
                if (!file_exists($dir)){
                    mkdir ($dir,0777);
                    $index_file = "<?php\nheader(\"Location: ../index.php\");\n";
                    $fp = fopen($dir."/index.php", "w");
                    fwrite($fp, $index_file);
                    fclose($fp);
                }
                move_uploaded_file($_FILES['doc_file']['tmp_name'], $dir."/".$unique_name);
            }

            display_notification(_("Document updated"));
            $Mode = "RESET";
        }
    }
}

if($Mode == "RESET"){
    $real_estate_id = $_POST['real_estate_id'];
    unset($_POST);
    $_POST['real_estate_id'] = $real_estate_id;
}

start_form(true);

start_table(TABLESTYLE5_BOX,"",0,0,0,null,"50%","2px solid #2CABE3;");

$th = array(_("Name"), _("File Name"), _("View"), "", "");

table_header($th);
$k = 0; 

$result = get_real_estate_docs($_POST['real_estate_id']);
while ($myrow = db_fetch($result)) {
    
    alt_table_row_color($k);
        
    label_cell($myrow["doc_name"]);
    label_cell($myrow["f_name"]);
    label_cell("<a href='".company_path()."/attachments/crm_real_estate/".$myrow['file']."' target='_blank'> View Document</a>");
    edit_button_cell("Edit".$myrow["id"], _("Edit"));
    delete_button_cell("Delete".$myrow["id"], _("Delete"));
    end_row();
}

end_table(1);


if($selected_id!=-1){
    $row = get_real_estate_doc($selected_id);
    $_POST['doc_name'] = $row['doc_name'];
    $_POST['f_name'] = $row['f_name'];
    hidden('doc_id', $selected_id);
}

start_table(TABLESTYLE5_BOX, "", 0, 0, 0, null, "30%", "3px solid #656E79;");

hidden('real_estate_id', $_POST['real_estate_id']);

text_row("Description", 'doc_name', $_POST['doc_name']);

if($_POST['f_name']){
    label_row("Attached File", $_POST['f_name']);
}

file_row('Attach File', "doc_file");

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

?>