<?php
$page_security = 'SA_SUBAGREEMENT';
$path_to_root = "..";
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/CRM/includes/db/subscription_agreement_db.inc");
include($path_to_root . "/includes/ui.inc");
include($path_to_root . "/reporting/includes/reporting.inc");


global $Ajax;

page(_($help_context = "Subscription Agreement ")); 

simple_page_mode(true);


if (isset($_GET['id'])) 
	$_POST['opportunity_id'] = $_GET['id'];

//----------------------------------------------------------------------------------------------------

function can_process()
{

	global  $Refs;

	if(!$_POST['title']){
		display_error(_("title must be entered"));
		set_focus('title');
		return false;
	}
	if(!$_POST['provider']){
		display_error(_("provider must be entered"));
		set_focus('provider');
		return false;
	}
	if(!$_POST['client']){
		display_error(_("client must be entered"));
		set_focus('client');
		return false;
	}

	if (!$Refs->is_valid($_POST['reference'], ST_AGREEMENT)) {
		display_error(_("You must enter a reference."));
		set_focus('reference');
		return false;
	}

	if ($_POST['opportunity_id'] !=0) {
		$opportunity_id = $_POST['opportunity_id'];
	}elseif ($_POST['agreement_id'] != 0) {
		$opportunity_id =$_POST['agreement_id'];
	}


	return true;
}

//--------------------------------------------------------------------------------------------


if ($Mode=='ADD_ITEM' && can_process()){



	$subscription_id =add_subscription_agreement($_POST['title'],$_POST['date'],$_POST['provider'], $_POST['provider_representative'], $_POST['provider_email'], $_POST['provider_address'], $_POST['provider_desgination'], $_POST['client'], $_POST['client_representative'], $_POST['client_email'], $_POST['client_address'], $_POST['client_designation'], $opportunity_id, $_POST['reference']);

	if($subscription_id){
		display_notification('Your Subscription Agreement successfully registered');
		$Mode = 'RESET';
	}
	else{
		display_notification(_("We could not register the Subscription Agreement"));
	}
}
//--------------------------------------------------------------------------------------------


if ($Mode=='UPDATE_ITEM' && can_process() ){

	
	$subscription_id =update_subscription_agreement($_POST['selected_id'],$_POST['title'],$_POST['date'],$_POST['provider'], $_POST['provider_representative'], $_POST['provider_email'], $_POST['provider_address'], $_POST['provider_desgination'], $_POST['client'], $_POST['client_representative'], $_POST['client_email'], $_POST['client_address'], $_POST['client_designation'], $_POST['reference']);
	
	if($subscription_id){
		display_notification('Your Subscription Agreement successfully registered');
		$Mode = 'RESET';
	}
	else{
		display_notification(_("We could not register the Subscription Agreement"));
	}
}
//-------------------------------------------------------------------------------------------- 

if (isset($_POST['delete'])) 
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtor_trans'
	if (key_in_foreign_table($selected_id, 'debtor_trans', 'debtor_no'))
	{
		$cancel_delete = 1;
		display_error(_("This Customer cannot be deleted because there are transactions that refer to it."));
	} 
	
	if ($cancel_delete == 0) 
	{ 	//ie not cancelled the delete as a result of above tests
	
		delete_subscription($selected_id);

		display_notification(_("Selected Customer has been deleted."));
		unset($_POST['customer_id']);
		$selected_id = '';
		$Ajax->activate('_page_body');
	} //end if Delete Customer
}

function basic_deatils($selected_id ,$agreement_id=0) 
{
	

	global $Refs;
	
	

start_form(true);
 start_table(TABLESTYLE_NOBORDER);


if ($agreement_id != 0 ) {
	$myrow=get_subscription_agreement_opportunity($agreement_id);

		$_POST['id'] =  $myrow['id'];
		$_POST['reference'] =  $myrow['reference'];
		$_POST['title'] =  $myrow['title'];
		$_POST['dates'] =  $myrow['dates'];

		$_POST['provider'] =  $myrow['provider'];
		$_POST['provider_representative'] =  $myrow['provider_representative'];
		$_POST['provider_email'] =  $myrow['provider_email'];
		$_POST['provider_address'] =  $myrow['provider_address'];
		$_POST['provider_desgination'] =  $myrow['provider_desgination'];

		$_POST['client'] =  $myrow['client'];
		$_POST['client_representative'] =  $myrow['client_representative'];
		$_POST['client_email'] =  $myrow['client_email'];
		$_POST['client_address'] =  $myrow['client_address'];
		$_POST['client_desgination'] =  $myrow['client_desgination'];


		global $Ajax;
	$Ajax->activate('_page_body');
}
		

// display_error($_POST['id']);


	br();
	br();

	if(!$_POST['reference'])
		$_POST['reference'] = $Refs->get_next(ST_AGREEMENT);


	ref_row(_("Reference").':', 'reference', _('Reference number unique for this document type'), null, '', 
	ST_AGREEMENT);
	text_row(_("Title:"), 'title');
	date_cells('Date','date');
	end_table();
	

	start_outer_table(TABLESTYLE5_BOX,'');
	table_section(1);
	
	table_section_title(_("Provider Tab"));

	text_row(_("Provider:"), 'provider');
	text_row(_("Representative:"), 'provider_representative');	
	email_row(_("E-mail:"), 'provider_email', null, 35, 55);
	text_row(_("Address:"), 'provider_address', null, 35, 55);
	text_row(_("Designation:"), 'provider_desgination', null, 35, 55);
	// currencies_list_row(_("Customer's Currency:"), 'curr_code', $_POST['curr_code']);

	
	table_section(2);

	table_section_title(_("Client Tab"));

	text_row(_("Client:"), 'client');
	text_row(_("Representative:"), 'client_representative');
	email_row(_("E-mail:"), 'client_email', null, 35, 55);
	text_row(_("Address:"), 'client_address', null, 35, 55);
	text_row(_("Designation:"), 'client_designation', null, 35, 55);
	// currencies_list_row(_("Customer's Currency:"), 'curr_code', $_POST['curr_code']);
	
	end_outer_table(1);

	if ($_POST['id']) {
		$selected_id=$_POST['id'];
		hidden('selected_id',$selected_id);
		// display_error($selected_id);
	}
	echo "<center>";
	submit_add_or_update($selected_id == -1, false, false, false, "Register");
	echo "</center>";
	div_end();
}

//--------------------------------------------------------------------------------------------
start_form(true);
hidden('opportunity_id', $_GET['id']);

start_table(TABLESTYLE_NOBORDER);
get_opportunity_list_cells("Previous Agreements", 'agreement_id', $_POST['opportunity_id'], true, true);



echo  "<td>". print_document_access_link2( 0, _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, 10001, null,'','',0,0,'A4',0,$_POST['id'] , $_POST['opportunity_id']) ."</td>"; 
	


end_table();


if (!$selected_id)
	unset($_POST['_tabs_sel']); // force settings tab for new customer

tabbed_content_start('tabs', array(
		'basic' => array(_('&Basic Details '), $selected_id),
		'scope' => array(_('&Scope Of Work'), $selected_id),
		'price_details' => array(_('&Price Details'),  $selected_id ),
		'salient' => array(_('Salient features'),  $selected_id ),
	));
	
	switch (get_post('_tabs_sel')) {
		default:
		case 'basic':
			basic_deatils($selected_id, $_POST['agreement_id']); 
			break;
		case 'scope':
			$_POST['opportunity_id'];
			$_POST['agreement_id'];
			include_once($path_to_root."/CRM/maintenance/scope_of_work.php");
			break;
		case 'price_details':
			$_POST['opportunity_id'];
			$_POST['agreement_id'];
			include_once($path_to_root."/CRM/maintenance/agreement_pricing.php");
			break;
		case 'salient':
			$_POST['opportunity_id'];
			$_POST['agreement_id'];
			include_once($path_to_root."/admin/security_roles_agreement.php");
			break;

	};
br();
tabbed_content_end();


end_form(1);
end_form(2);
end_page();

