<?php
/**********************************************************************
Copyright (C) FrontAccounting, LLC.
Released under the terms of the GNU General Public License, GPL, 
as published by the Free Software Foundation, either version 3 
of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$path_to_root="..";
$page_security = 'SA_ATTACHINQUIRY';

include_once($path_to_root . "/admin/includes/attach_cart.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/admin/db/attach_inquiry_db.inc");
include_once($path_to_root . "/admin/db/transactions_db.inc");



$js = "";
if ($SysPrefs->use_popup_windows)
$js .= get_js_open_window(800, 500);
page(_($help_context = "Link Transactions"), false, false, "", $js);

simple_page_mode(true);
// $attachment_array = array();
//----------------------------------------------------------------------------------------
// if (isset($_GET['Attach']) || $_POST['attached']) {
// 	$attach_id = $_GET['Attach']?$_GET['Attach']:$_POST['attached'];
//   $linked = new attach_cart($attach_id);
// }
if (isset($_GET['Attach'])) {
	$attach_id = $_GET['Attach'];
  $_SESSION['linked'] = new attach_cart($attach_id);
}
function update_attach_status($id,$type,$trans_no){
	$sql = "UPDATE `0_attach_inquiry` SET `trans_no`= '$trans_no', `trans_type` = '$type' WHERE `id` = '$id'";
// 	display_error($sql);
	$result = db_query($sql);
	if ($result) {
		display_notification("Document successfully Attached");
	}
}
function get_trans_and_type($id){
	$sql = "SELECT trans_no,trans_type FROM `0_attach_inquiry`  WHERE `id` = '$id'";
	$result = db_query($sql);
	return db_fetch($result);
}
function get_refrence($trans_no,$trans_type){
	$sql = "SELECT ref.reference FROM 0_refs AS ref LEFT JOIN 0_voided AS v ON v.id = ref.id AND v.type = ref.type WHERE ref.type = $trans_type AND ISNULL(v.id) AND ref.id = $trans_no";
	// display_error($sql);
	$result = db_query($sql);
	return db_fetch($result)[0];
}
function is_already_in_line_detail($Type, $trans_no,$link_details){
	foreach ($link_details as $key => $value) {
		if ($value->trans_no == $trans_no && $value->trans_type == $Type) {
			return true;
		}
	}
	return false;
}
function display_rows($attachment)
{
	global $systypes_array;
	div_start('table_div');
	$headers = array("","ID","Type","Refrence");
	start_table(TABLESTYLE2);
	db_table_header($headers,'font-weight: normal;font-size:15px;background:#f2f2f2;border:1px solid #dee2e6;');

	// $result = get_attachment_inquiry_link_detail_by_id($attachment_id); 
		
	if ($attachment->link_details != null) {
			foreach ($attachment->link_details as $key => $value) {
				$attach_str = $systypes_array[$value->trans_type];
				// display_error($key);
				start_row();
				$approve_status = check_approved_transaction($value->trans_no, $value->trans_type)['approve_status'];
				if($approve_status==0)
					label_cell(button('Delete'.$key, ("Delete"), ("Delete"), ICON_DELETE));
				else
					label_cell();
				label_cell($value->trans_no);
				label_cell($attach_str);
				label_cell(get_refrence($value->trans_no,$value->trans_type));
				end_row();
			}
		}
	// while ($row = db_fetch($result)) {
	// 	        $attach_str = $systypes_array[$row['trans_type']];
	// start_row();
	// label_cell(button('Delete'.$row['id'], ("Delete"), ("Delete"), ICON_DELETE));
	// label_cell($row['trans_no']);
	// label_cell($attach_str);
	// label_cell(get_refrence($row['trans_no'],$row['trans_type']));
	// end_row();

	// }
	end_table(1);
		div_end();

}

if (isset($_POST['process_attach'])) {
	$attachment_id = $_POST['attached'];
	// $trans_no_array = array();
	// $type_array = array();
	// display_error($_POST['trans_no']);exit;
	// if ($_POST['Type'] <= -1) {
	// 	display_error("Select Type.");
	// }else if ($_POST['trans_no'] == null) {
	// 	display_error("Select Document.");
	// }else if (is_already_linked($_POST['Type'], $_POST['trans_no']) > 0) {
	// 	display_error("Document already linked");
	// }else{
		delete_attachment_inquiry_link_detail_by_attach_id($attachment_id);
		foreach ($_SESSION['linked']->link_details as $key => $value) {
			// display_error($value->trans_no."===".$value->trans_type."===".$attachment_id);
		add_attachment_inquiry_link_detail($attachment_id , $value->trans_no, $value->trans_type);
		}
		add_audit_trail(SM_ATTACHDOC,$attachment_id,null,'Linked Document With Attachment');
		meta_forward($path_to_root."/admin/inquiry/attach_inquiry_dashboard.php?Attached=$attachment_id");
	// }


}

if (isset($_POST['link'])) {
	if ($_POST['Type'] <= -1) {
		display_error("Select Type.");
	}else if ($_POST['trans_no'] == null) {
		display_error("Select Document.");
	}else if (is_already_linked($_POST['Type'], $_POST['trans_no']) > 0) {
		display_error("Document already linked");
	}else if (is_already_in_line_detail($_POST['Type'], $_POST['trans_no'],$_SESSION['linked']->link_details)) {
		display_error("Document already in line items.");
	}else{
		$_SESSION['linked']->add_linked_trans($_POST['trans_no'], $_POST['Type'], $_POST['attached']);
		$Ajax->activate('table_div');
	}
}

$deleted_id =find_submit('Delete');

if ($deleted_id != -1) {
	unset($_SESSION['linked']->link_details[$deleted_id]);
	// delete_attachment_inquiry_link_detail_by_id($deleted_id);
	// display_notification('Unlink Document');
	$Ajax->activate('table_div');
}
start_form(true);

// viewing_controls();

// display_rows($_SESSION['edit_attach_obj']);

start_table(TABLESTYLE2);
echo "<tr>";
date_cells2(_("Date Filter From:"), 'date_filter_from', '', null, 0,0,0,null,true);
echo "</tr>";
date_cells2(_("Date Filter To:"), 'date_filter_to', '', null, 0,0,0,null,true);
systypes_list_row(_("Type:"), 'Type', null, true);
// display_error($_POST['date_filter']);
all_trans_doc_list_row(_("Document:"), 'trans_no',null,true ,false, true,$_POST['Type'],$_POST['date_filter_from'],$_POST['date_filter_to']);
// textarea_row(_("Notes:"), "notes", null, 31, 5);
hidden('attached',$_GET['Attach']);
echo "<td></td>";
submit_cells('link', _("Link"),'',_('Select documents'), 'default');
end_table(1);
echo"<center>";
submit_row('process_attach',_('Process'), true,"", false, true);
echo"</center>";


br(2);
// print_r($_SESSION['linked']);
display_rows($_SESSION['linked']);

end_form();

end_page();