<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_AUTO_EMAIL_REPORT';
$path_to_root = "..";
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/admin/includes/auto_email_ui.inc");
include_once($path_to_root . "/admin/db/auto_email_db.inc");
//include_once($path_to_root . "/includes/db/inventory_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();



page("Auto Email Report", false, false, "", $js);

//--------------------------------------------------------------------------------------------------

function line_start_focus() {
  global $Ajax;
  $Ajax->activate('email_table');
  set_focus('Payroll');
}
//-----------------------------------------------------------------------------------------------

function handle_new_order()
{
	if (isset($_SESSION['transfer_items']))
	{
		$_SESSION['transfer_items']->clear_items();
		unset ($_SESSION['transfer_items']);
	}

	$_SESSION['transfer_items'] = new items_cart(ST_LOCTRANSFER);
}

//-----------------------------------------------------------------------------------------------
if (isset($_GET['AddedID'])) 
{

display_notification_centered(_("Auto Email Has Been Successfully Assigned"));
}

if (isset($_POST['Process']))
{

	$tr = &$_SESSION['transfer_items'];
	$input_error = 0;

	if (count($tr->line_items) == 0)	{
		display_error(_("You must enter at least one non empty item line."));
		set_focus('Payroll');
		$input_error = 1;
	}	

	if ($input_error == 1)
		unset($_POST['Process']);
}

//-------------------------------------------------------------------------------

if (isset($_POST['Process']))
{
	foreach ($_SESSION['transfer_items']->line_items as $line_no=>$stock_item)
	{		
		$rep_name = $stock_item->Payrollmselect;
		add_auto_email($rep_name, $stock_item->Payrollmselect, $stock_item->email, $stock_item->e_time, $stock_item->type, $stock_item->weekend, $stock_item->subject, $stock_item->email_body);
		//insert data 		
	}

	$_SESSION['transfer_items']->clear_items();
	unset($_SESSION['transfer_items']);	
   	meta_forward($_SERVER['PHP_SELF'],'AddedID=1');   	
	exit;
} 

//-----------------------------------------------------------------------------------------------

function check_item_data()
{	
   
	if ($_POST['Payroll'] == 0) {
		display_error(_("Please Select Report First"));
		return false;
	}
		if ($_POST['subject'] == '') {
		display_error(_("Subject Cannot be Empty"));
		return false;
	}
		if ($_POST['email_body'] == '') {
		display_error(_("Email Message Cannot be Empty"));
		return false;
	}

	if ($_POST['email'] == "") {
		display_error(_("Please Enter Valid Email"));
		return false;
	}
	
	



   	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
	$id = $_POST['LineNo'];
	
	$_SESSION['transfer_items']->update_add_auto_email_cart($id,$_POST['Payroll'],$_POST['email'],$_POST['e_time'],$_POST['type'],$_POST['subject'],$_POST['email_body']);
	unset($_POST);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['transfer_items']->remove_from_cart($id);
	unset($_POST);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_new_item()
{		
    // display_error($_POST['Payroll']);
	add_to_order($_SESSION['transfer_items'], $_POST['Payroll'], $_POST['email'], $_POST['e_time'], $_POST['type'], $_POST['weekend'], $_POST['subject'], $_POST['email_body']);	
	unset($_POST);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)	
	handle_delete_item($id);
	
if (isset($_POST['AddItem']) && check_item_data())
{	if ($_POST['type'] =='')
	{
		display_error(_("Please Select Setting"));
		set_focus('type');
		
	}elseif($_POST['type']=='Weekly' && $_POST['weekend']=="")
	{
	    display_error(_("Please Select Weekend if you selecting weekly "));
		set_focus('type');
	}
	else
    handle_new_item();}

if (isset($_POST['UpdateItem']) && check_item_data())
	handle_update_item();

if (isset($_POST['CancelItemChanges'])) {
    unset($_POST);
	line_start_focus();
}
//-----------------------------------------------------------------------------------------------

if (isset($_GET['NewTransfer']) || !isset($_SESSION['transfer_items']))
{
	handle_new_order();
}

//-----------------------------------------------------------------------------------------------
start_form();
// display_order_header($_SESSION['transfer_items']);
start_table(TABLESTYLE, "width='70%'", 10);
start_row();
echo "<td>";
display_transfer_items(_(""), $_SESSION['transfer_items']);
echo "</td>";
end_row();
echo "<center>";
// end_row();
end_table(1);
submit_center_first('Process', _("Process"), '',  'default');
// submit_center_first('Update', _("Update"), '', null);
echo '</br>' ;
echo '</br>' ;
end_form();
end_page();