<?php
$page_security = 'SA_BACKUP';
$path_to_root="..";
include_once($path_to_root . "/includes/session.inc");
$check = 1;
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/admin/db/maintenance_db.inc");

if (get_post('view')) {
	if (!get_post('backups')) {
		display_error(_('Select backup file first.'));
	} else {
		$filename = $SysPrefs->backup_dir() . clean_file_name(get_post('backups'));
		if (in_ajax()) 
			$Ajax->popup( $filename );
		else {
			header('Content-type: text/plain');
			header('Content-Length: '.filesize($filename));
			header("Content-Disposition: inline; filename=".basename($filename));
			if (substr($filename, -3, 3) == '.gz')
				header("Content-Encoding: gzip");

			if (substr($filename, -4, 4) == '.zip')
				echo db_unzip('', $filename);
			else
				readfile($filename);
			exit();
		}
	}
};

if (get_post('download')) {
	if (get_post('backups')) {
		download_file($SysPrefs->backup_dir().clean_file_name(get_post('backups')));
		exit;
	} else
		display_error(_("Select backup file first."));
}
if (get_post('download_attachments')) {
	if (get_post('backups_attachments')) {
		 download_file_attachment($SysPrefs->backup_attachments_dir().clean_file_name(get_post('backups_attachments')));
		exit;
	} else
		display_error(_("Select backup file first."));
}
page(_($help_context = "Backup and Restore Database"), false, false, '', '');

check_paths();

function check_paths()
{
  global $SysPrefs;

	if (!file_exists($SysPrefs->backup_dir())) {
		display_error (_("Backup paths have not been set correctly.") 
			._("Please contact System Administrator.")."<br>" 
			. _("cannot find backup directory") . " - " . $SysPrefs->backup_dir() . "<br>");
		end_page();
		exit;
	}
}

function generate_backup($conn, $ext='no', $comm='')
{
	global $SysPrefs;

	$filename = db_backup($conn, $ext, $comm, $SysPrefs->backup_dir());
	if ($filename)
		display_notification(_("Backup successfully generated."). ' '
			. _("Filename") . ": " . $filename);
	else
		display_error(_("Database backup failed."));

	return $filename;
}


function get_backup_file_combo()
{
	global $path_to_root, $Ajax, $SysPrefs;
	
	$ar_files = array();
    default_focus('backups');
    $dh = opendir($SysPrefs->backup_dir());
	while (($file = readdir($dh)) !== false)
		$ar_files[] = $file;
	closedir($dh);

    rsort($ar_files);
	$opt_files = "";
    foreach ($ar_files as $file)
		if (preg_match("/.sql(.zip|.gz)?$/", $file))
    		$opt_files .= "<option value='$file'>$file</option>";

	$selector = "<select name='backups' size=2 style='height:160px;min-width:230px'>$opt_files</select>";

	$Ajax->addUpdate('backups', "_backups_sel", $selector);
	$selector = "<span id='_backups_sel'>".$selector."</span>\n";

	return $selector;
}

function get_attachments_backup_file_combo()
{
	global $path_to_root, $Ajax, $SysPrefs;
	
	$ar_files = array();
    default_focus('backups_attachments');
    $dh = opendir($SysPrefs->backup_attachments_dir());
	while (($file = readdir($dh)) !== false)
		$ar_files[] = $file;
	closedir($dh);

    rsort($ar_files);
	$opt_files = "";
    foreach ($ar_files as $file)
		if (preg_match("/.zip?$/", $file))
    		$opt_files .= "<option value='$file'>$file</option>";

	$selector = "<select name='backups_attachments' size=2 style='height:160px;min-width:230px'>$opt_files</select>";

	$Ajax->addUpdate('backups_attachments', "_backups_attachments_sel", $selector);
	$selector = "<span id='_backups_attachments_sel'>".$selector."</span>\n";

	return $selector;
}

function compress_list_row($label, $name, $value=null)
{
	$ar_comps = array('no'=>_("No"));

    if (function_exists("gzcompress"))
    	$ar_comps['zip'] = "zip";
    if (function_exists("gzopen"))
    	$ar_comps['gzip'] = "gzip";

	echo "<tr><td class=''>$label</td><td>";
	echo array_selector('comp', $value, $ar_comps);
	echo "</td></tr>";
}

function download_file($filename)
{
    if (empty($filename) || !file_exists($filename))
    {
		display_error(_('Select backup file first.'));
        return false;
    }
    $saveasname = basename($filename);
    header('Content-type: application/octet-stream');
   	header('Content-Length: '.filesize($filename));
   	header('Content-Disposition: attachment; filename="'.$saveasname.'"');
    readfile($filename);

    return true;
}
function download_file_attachment($filename)
{
    if (empty($filename) || !file_exists($filename))
    {
		display_error(_('Select backup file first.'));
        return false;
    }
    $saveasname = basename($filename);
     header('Content-Type: application/zip');
     header('Content-Disposition: attachment; filename="'.$saveasname.'"');
     header("Pragma: no-cache"); 
	 header("Expires: 0");
     // header('Content-Length: ' . filesize($filename));

     ob_end_clean(); 
     readfile($filename);
    echo '<script type="text/javascript" >document.getElementById("ajaxmark").style.display = "none";<script>';
    return true;
}
$conn = $db_connections[user_company()];
$backup_name = clean_file_name(get_post('backups'));
$backup_name_attachments = clean_file_name(get_post('backups_attachments'));
$backup_path = $SysPrefs->backup_dir() . $backup_name;
$backup_path_attachments = $SysPrefs->backup_attachments_dir() . $backup_name_attachments;

if (get_post('creat')) {
			// Get real path for our folder
		$rootPath = company_path()."/attachments";
		$path = realpath($rootPath);
		// display_error($path);exit;

		$zip = new ZipArchive();
		$zip->open(company_path().'/backup/attachments/archive_'.date("Ymd_His").'.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

		$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path));

		foreach ($files as $name => $file)
		{
			if ($file->isDir()) {
				echo $name . "\n";
				flush();
				continue;
			}
			
			$filePath = $file->getRealPath();
		    $relativePath = substr($filePath, strlen($path) + 1);
			
		    $zip->addFile($filePath, $relativePath);
		}

		$zip->close();

	// exit;
	generate_backup($conn, get_post('comp'), get_post('comments'));
	$Ajax->activate('backups');
	$Ajax->activate('backups_attachments');
	$SysPrefs->refresh(); // re-read system setup
};

if (get_post('restore')) {
	if ($backup_name) {
		if (db_import($backup_path, $conn, true, false, check_value('protected')))
			display_notification(_("Restore backup completed."));
		$SysPrefs->refresh(); // re-read system setup
	} else
		display_error(_("Select backup file first."));
}
if (get_post('restore_attachments')) {
	if ($backup_name_attachments) {
		$zip = new ZipArchive;
		$res = $zip->open($backup_path_attachments);
	// display_error($res);exit;
		if ($res === TRUE) {
		  $zip->extractTo(company_path().'/attachments');
		  $zip->close();
		display_notification(_("Restore backup completed."));
		} else {
		  display_error(_("Restore backup Fail"));
		}
		$SysPrefs->refresh(); // re-read system setup
	} else
		display_error(_("Select backup file first."));
}

if (get_post('deldump')) {
	if ($backup_name) {
		if (unlink($backup_path)) {
			display_notification(_("File successfully deleted.")." "
					. _("Filename") . ": " . $backup_name);
			$Ajax->activate('backups');
		}
		else
			display_error(_("Can't delete backup file."));
	} else
		display_error(_("Select backup file first."));
}

if (get_post('deldump_attachment')) {
	// display_error($backup_path_attachments);exit;
	if ($backup_name_attachments) {
		if (unlink($backup_path_attachments)) {
			display_notification(_("File successfully deleted.")." "
					. _("Filename") . ": " . $backup_name_attachments);
			$Ajax->activate('backups_attachments');
		}
		else
			display_error(_("Can't delete backup file."));
	} else
		display_error(_("Select backup file first."));
}

if (get_post('upload'))
{
	
	$tmpname = $_FILES['uploadfile']['tmp_name'];
	$fname = trim(basename($_FILES['uploadfile']['name']));

	if ($fname) {
		if (!preg_match("/\.sql(\.zip|\.gz)?$/", $fname))
			display_error(_("You can only upload *.sql backup files"));
		elseif ($fname != clean_file_name($fname))
			display_error(_("Filename contains forbidden chars. Please rename file and try again."));
		elseif (is_uploaded_file($tmpname)) {
			rename($tmpname, $SysPrefs->backup_dir() . $fname);
			display_notification(_("File uploaded to backup directory"));
			$Ajax->activate('backups');
		} else
			display_error(_("File was not uploaded into the system."));
	} else
		display_error(_("Select backup file first."));

}

if (get_post('upload_attachments'))
{
	$tmpname = $_FILES['uploadfileattachments']['tmp_name'];
	$fname = trim(basename($_FILES['uploadfileattachments']['name']));
	// display_error($fname);exit;
	if ($fname) {
		if (!preg_match("/\.zip?$/", $fname))
			display_error(_("You can only upload *.zip backup files"));
		elseif ($fname != clean_file_name($fname))
			display_error(_("Filename contains forbidden chars. Please rename file and try again."));
		elseif (is_uploaded_file($tmpname)) {
			rename($tmpname, $SysPrefs->backup_attachments_dir() . $fname);
			display_notification(_("File uploaded to backup directory"));
			$Ajax->activate('backups_attachments');
		} else
			display_error(_("File was not uploaded into the system."));
	} else
		display_error(_("Select backup file first."));

}
//-------------------------------------------------------------------------------
start_form(true, true);
start_outer_table();
echo "<tr>";
echo "<td>";
start_outer_table(TABLESTYLE2);
table_section(1);
table_section_title(_("Create backup"));
	textarea_row(_("Comments:"), 'comments', null, 30, 8);
	compress_list_row(_("Compression:"),'comp');
	vertical_space("height='20px'");
	echo "<td><br><br><br><br>";echo "</td>";
	submit_row('creat',_("Create Backup"), false, "colspan=2 align='center'", '', 'process');

end_outer_table();
echo "</td>";
echo "<td>";
start_outer_table(TABLESTYLE2);
table_section(1);
table_section_title(_("Backup scripts maintenance"));

	start_row();
	echo "<td style='padding-left:20px' align='left'>".get_backup_file_combo()."</td>";
	// echo "<td style='padding-left:20px' align='left'>".get_attachments_backup_file_combo()."</td>";
	echo "<td style='padding-left:20px' valign='top'>";
	start_table();

	submit_row('view',_("View Backup"), false, '', '', false,'7px','100%');
	submit_row('download',_("Download Backup"), false, '', '', 'download','7px','100%');
	
	submit_row('restore',_("Restore Backup"), false, '','', 'process','7px','100%');
	submit_js_confirm('restore',_("You are about to restore database from backup file.\nDo you want to continue?"));

	submit_row('deldump', _("Delete Backup"), false, '','', true,'7px','100%');
	// don't use 'delete' name or IE js errors appear
	submit_js_confirm('deldump', sprintf(_("You are about to remove selected backup file.\nDo you want to continue ?")));
	end_table();
	echo "</td>";
	end_row();
start_row();
	echo "<td style='padding-left:20px'  cspan=2>"
	. radio(_('Update security settings'), 'protect', 0) . '<br>'
	. radio(_('Protect security settings'), 'protect', 1, true) . "</td>";
end_row();
start_row();
	echo "<td style='padding-left:20px' align='left'><input name='uploadfile' type='file'></td>";
	submit_cells('upload',_("Upload file"),"style='padding-left:20px'", '', true);
end_row();
end_outer_table();
echo "</td>";

//===============================================================================================
echo "<td>";
start_outer_table(TABLESTYLE2);
table_section(1);
table_section_title(_("Attachments Backup"));

	start_row();
	// echo "<td style='padding-left:20px' align='left'>".get_backup_file_combo()."</td>";
	echo "<td style='padding-left:20px' align='left'>".get_attachments_backup_file_combo()."</td>";
	echo "<td style='padding-left:20px' valign='top'>";
	start_table();

	// submit_row('view',_("View Backup"), false, '', '', false,'7px','100%');
	submit_row('download_attachments',_("Download Backup"), false, '', '', 'download','7px','100%');
    
//     echo '<tr><td><a class="inputsubmitbtn btn-sm btn-info btn-flat" type="submit" style="/* margin-top:0; *//* margin-bottom: 36px; */width:100%;float:;background:;/* margin: 0px; */border:none;padding: 0px;" aspect="download" name="download_attachments" id="download_attachments" value="Download Backup" \'\'=""><span>Download Backup</span></a>
// </td>
// </tr>';
	
	submit_row('restore_attachments',_("Restore Backup"), false, '','', 'process','7px','100%');
	submit_js_confirm('restore',_("You are about to restore database from backup file.\nDo you want to continue?"));

	submit_row('deldump_attachment', _("Delete Backup"), false, '','', true,'7px','100%');
	// don't use 'delete' name or IE js errors appear
	submit_js_confirm('deldump_attachment', sprintf(_("You are about to remove selected backup file.\nDo you want to continue ?")));
	end_table();
	echo "</td>";
	end_row();
start_row();
echo "<td><br><br>";echo "</td>";
// echo "<td>";echo "</td>";
	/*echo "<td style='padding-left:20px'  cspan=2>"
	. radio(_('Update security settings'), 'protect', 0) . '<br>'
	. radio(_('Protect security settings'), 'protect', 1, true) . "</td>";*/
	
end_row();
start_row();
	echo "<td style='padding-left:20px' align='left'><input name='uploadfileattachments' type='file'></td>";
	submit_cells('upload_attachments',_("Upload file"),"style='padding-left:20px'", '', true);
	// echo '<button class="btn btn-sm btn-info btn-flat" type="submit" style="margin-top:0;  margin-bottom:0; width:;  float:; background:; border:none;" name="upload_attachments" id="upload_attachments" value="Upload file" ><span>Upload file</span></button>';
end_row();
end_outer_table();
echo "</td>";
//=======================================================================================
echo "</tr>";
end_outer_table();
end_form();

end_page();
