<?php


//----------------------------------------------------------------------------------------

function add_attachment($filterType, $trans_no, $description,
	$filename, $unique_name, $filesize, $filetype)
{
	$date = date2sql(Today());
	$sql = "INSERT INTO ".TB_PREF."attachments (type_no, trans_no, description, filename, unique_name,
		filesize, filetype, tran_date) VALUES (".db_escape($filterType).","
		.db_escape($trans_no).",".db_escape($description).", "
		.db_escape($filename).", ".db_escape($unique_name).", ".db_escape($filesize)
		.", ".db_escape($filetype).", '$date')";
	db_query($sql, "Attachment could not be inserted");	
	return db_insert_id();	
}
//----------------------------------------------------------------------------------------

function update_attachment($selected_id, $filterType, $trans_no, $description,
	$filename, $unique_name, $filesize, $filetype)
{
	$date = date2sql(Today());
	$sql = "UPDATE ".TB_PREF."attachments SET
		type_no=".db_escape($filterType).",
		trans_no=".db_escape($trans_no).",
		description=".db_escape($description).", ";
	if ($filename != "")
	{
		$sql .= "filename=".db_escape($filename).",
		unique_name=".db_escape($unique_name).",
		filesize=".db_escape($filesize).",
		filetype=".db_escape($filetype).",";
	}	
	$sql .= "tran_date='$date' WHERE id=".db_escape($selected_id);
	db_query($sql, "Attachment could not be updated");		
}

//----------------------------------------------------------------------------------------

function delete_attachment($id)
{
	$sql = "DELETE FROM ".TB_PREF."attachments WHERE id = ".db_escape($id);
	db_query($sql, "Could not delete attachment");
}

//----------------------------------------------------------------------------------------

function get_attachment_string($type, $id, $path_to_root=null)
{
    if($path_to_root == null)
	    global $path_to_root;
    $str_return = "";    
    $sql = "SELECT * FROM ".TB_PREF."attachments WHERE type_no=".db_escape($type)." AND trans_no=".db_escape($id)." ORDER BY trans_no";
    $return = db_query($sql, "Could not retrieve attachments");
    while ($attachment = db_fetch($return))
    {
        if (strlen($str_return))
            $str_return = $str_return . " \n";    
        // $str_return .= _("Attached File:")." <a href='$path_to_root/admin/attachments.php?vw=".$attachment["id"]." ' target='blanc_'> ". 
        // 	$attachment["id"] . " " . $attachment["description"]. " - ". $attachment["filename"]."</a><br>";
        $format = substr($attachment["filename"], strrpos($attachment["filename"], ".") + 1); 
         $str_return .= "<a href='".company_path(null,$path_to_root)."/attachments/".$attachment['unique_name'].".".$format."' target='blanc_'>  ". 
        	$attachment["id"] . " " . $attachment["description"]. " - ". $attachment["filename"]."</a><br>"; 	
    }
    return "<center>".$str_return . "</center><br>";
}

//----------------------------------------------------------------------------------------

function get_attached_documents($type)
{
	$sql = "SELECT * FROM ".TB_PREF."attachments WHERE type_no=".db_escape($type)
	." ORDER BY trans_no";
	return db_query($sql, "Could not retrieve attachments");
}

function get_attachment($id)
{
	$sql = "SELECT * FROM ".TB_PREF."attachments WHERE id=".db_escape($id);
	$result = db_query($sql, "Could not retrieve attachments");
	return db_fetch($result);
}

function has_attachment($type, $id)
{
	$sql = "SELECT DISTINCT * FROM ".TB_PREF."attachments WHERE type_no=".db_escape($type)." AND trans_no=".db_escape($id);
	$result = db_query($sql, "Could not retrieve attachments");
	$myrow = db_fetch($result);
	if ($myrow === false)
		return 0;
	else
		return $myrow['id'];
}

function get_sql_for_attached_documents($type)
{
	return "SELECT trans_no, description, filename, filesize, filetype, tran_date, id, type_no,unique_name FROM ".TB_PREF."attachments WHERE type_no=".db_escape($type)
	." ORDER BY trans_no DESC";
}

function move_trans_attachments($type, $trans_from, $trans_to)
{
	$sql = "UPDATE ".TB_PREF."attachments SET trans_no=".db_escape($trans_to)
		." WHERE type_no=".db_escape($type)." AND trans_no=".db_escape($trans_from);
	db_query($sql, 'cannot move atachments');
}



function add_attach_inquiry_and_details($trans_no,$trans_type,$attach_id,$timestamp, $title, $file_name){
	$sql = "INSERT INTO ".TB_PREF."attach_inquiry (by_user) VALUES (".db_escape($_SESSION['wa_current_user']->user).")";
	$result = db_query($sql);
	$attach_id = db_insert_id();

	$sql = "INSERT INTO ".TB_PREF."attach_inquiry_link_detail(trans_no, trans_type, attach_id, `timestamp`) VALUES ('$trans_no','$trans_type','$attach_id','$timestamp')";
	$result = db_query($sql);

	$sql = "INSERT INTO ".TB_PREF."attach_inquiry_detail(description, short_description, type_no, trans_no, unique_name, tran_date, filename, attach_id) 
			VALUES (".db_escape($title).",
			".db_escape($title).",
			".db_escape($trans_type).",
			".db_escape($trans_no).",
			".db_escape($file_name).",
			".db_escape(date('Y-m-d')).",
			".db_escape($file_name).",
			".db_escape($attach_id)."
		)";
	$result = db_query($sql);
 
}


function get_attachmen_by_trans_no($trans_no, $type=null){
	$sql =" SELECT * FROM ".TB_PREF."attachments 
		    WHERE type_no = ".db_escape($type)."
		    AND trans_no = ".db_escape($trans_no);
	return db_query($sql);
}