<?php

//--------------------------------------------------------------------------------------------------

function get_security_role_agreement($id)
{
	$sql = "SELECT * FROM ".TB_PREF."agreements_modules WHERE id=".(int)$id;
	$ret = db_query($sql, "could not retrieve security roles");
	// display_error($sql);
	// exit();
	$row = db_fetch($ret);
	if ($row != false) {
		$row['areas'] = explode(';', $row['areas']);
		$row['sections'] = explode(';', $row['sections']);
	}
	return $row;
}

//--------------------------------------------------------------------------------------------------

function add_security_role_agreement($name, $description, $sections, $areas,$opportunity_id=0)
{
	$sql = "INSERT INTO ".TB_PREF."agreements_modules (role, description, sections, areas,opportunity_id)
	VALUES ("
	.db_escape($name).","
	.db_escape($description).","
	.db_escape(implode(';', $sections)).","
	.db_escape(implode(';', $areas)).","
	.db_escape($opportunity_id).")";

	// display_error($sql);
	// exit();
	db_query($sql, "could not add new security role");
	add_audit_trail(SS_MODULE, db_insert_id(), date('Y-m-d'), _("Access Given"));
}

//--------------------------------------------------------------------------------------------------

function update_security_role_agreement($id, $name, $description, $sections, $areas)
{
    	$sql = "UPDATE ".TB_PREF."agreements_modules SET role=".db_escape($name)
    	.",description=".db_escape($description)
    	.",sections=".db_escape(implode(';', $sections))
    	.",areas=".db_escape(implode(';', $areas))
    	." WHERE id=".(int)$id;
    	// display_error($sql);
    	// exit();
    	db_query($sql, "could not update role");
    	add_audit_trail(SS_MODULE, $id, date('Y-m-d'), _("Access updated"));
}
//--------------------------------------------------------------------------------------------------

function delete_security_role_agreement($id)
{
	$sql = "DELETE FROM ".TB_PREF."agreements_modules WHERE id=".(int)$id;

	db_query($sql, "could not delete role");
	add_audit_trail(SS_MODULE, $id, date('Y-m-d'), _("Access deleted"));
}
//--------------------------------------------------------------------------------------------------

function check_role_agreement_used($id) {
	$sql = "SELECT count(*) FROM ".TB_PREF."users WHERE role_id=".(int)$id;
	$ret = db_query($sql, 'cannot check role usage');
	$row = db_fetch($ret);
	return $row[0];
}

//--------------------------------------------------------------------------------------------------

function get_security_role_agreement_by_opportunity($opportunity_id)
{
	$sql = "SELECT * FROM ".TB_PREF."agreements_modules WHERE opportunity_id=".db_escape($opportunity_id);
	$ret = db_query($sql, "could not retrieve security roles");
	// display_error($sql);
	// exit();
	$row = db_fetch($ret);
	if ($row != false) {
		$row['areas'] = explode(';', $row['areas']);
		$row['sections'] = explode(';', $row['sections']);
	}
	return $row;
}

