<?php 
$myrow = get_company_prefs();

function can_process_gl_def(){


if (!is_account_balancesheet(get_post('retained_earnings_act')) || is_account_balancesheet(get_post('profit_loss_year_act')))
	{
		display_error(_("The Retained Earnings Account should be a Balance Account or the Profit and Loss Year Account should be an Expense Account (preferred the last one in the Expense Class)"));
		return false;
	}
	
	if (!check_num('past_due_days', 0, 100))
	{
		display_error(_("The past due days interval allowance must be between 0 and 100."));
		set_focus('past_due_days');
		return false;
	}

	return true;

}

if (isset($_POST['display_gl_submit']) && can_process_gl_def())
{
	
	update_company_prefs( get_post( array( 'retained_earnings_act', 'profit_loss_year_act',
	'exchange_diff_act', 'bank_charge_act','past_due_days', 'tax_algorithm','accounts_alpha', 
	)));
	
		display_notification(_("The general GL setup has been updated."));
	

}

table_section(1);
table_section_title(_("GL Defaults"));

text_row(_("Past Due Days Interval:"), 'past_due_days', $myrow['past_due_days'], 6, 6, '', "", _("days"));

accounts_type_list_row(_("Accounts Type:"), 'accounts_alpha', $myrow['accounts_alpha']); 

gl_all_accounts_list_row(_("Retained Earnings:"), 'retained_earnings_act', $myrow['retained_earnings_act']);

gl_all_accounts_list_row(_("Profit/Loss Year:"), 'profit_loss_year_act', $myrow['profit_loss_year_act']);

gl_all_accounts_list_row(_("Exchange Variances Account:"), 'exchange_diff_act', $myrow['exchange_diff_act']);

gl_all_accounts_list_row(_("Bank Charges Account:"), 'bank_charge_act', $myrow['bank_charge_act']);

tax_algorithm_list_row(_("Tax Algorithm:"), 'tax_algorithm', $myrow['tax_algorithm']);





end_outer_table(1);

submit_center('display_gl_submit', _("Update"), true, '', 'default');

?>
