 <?php 

$myrow = get_company_prefs();

function can_process_gl_purch(){

if (!check_num('po_over_charge', 0, 100))
	{
		display_error(_("The invoice over-charge allowance must be between 0 and 100."));
		set_focus('po_over_charge');
		return false;
	}

if (!check_num('po_over_receive', 0, 100))
	{
		display_error(_("The delivery over-receive allowance must be between 0 and 100."));
		set_focus('po_over_receive');
		return false;
	}

	$grn_act = get_company_pref('grn_clearing_act');
	$post_grn_act = get_post('grn_clearing_act');
	if ($post_grn_act == null)
		$post_grn_act = 0;
	if (($post_grn_act != $grn_act) && db_num_rows(get_grn_items(0, '', true)))
	{
		display_error(_("Before GRN Clearing Account can be changed all GRNs have to be invoiced"));
		$_POST['grn_clearing_act'] = $grn_act;
		set_focus('grn_clearing_account');
		return false;
	}



return true;	
}

if (isset($_POST['display_gl_purchase']) && can_process_gl_purch())
{
update_company_prefs( get_post( array( 'po_over_receive', 'po_over_charge',
'creditors_act', 'creditors_pdc_act','pyt_discount_act', 'grn_clearing_act','default_receival_required', 'show_po_item_codes')));

	display_notification(_("The general GL setup has been updated."));

}



table_section(1);

table_section_title(_("Suppliers and Purchasing"));

percent_row(_("Delivery Over-Receive Allowance:"), 'po_over_receive' , percent_format($myrow['po_over_receive']));

percent_row(_("Invoice Over-Charge Allowance:"), 'po_over_charge' , percent_format($myrow['po_over_charge']));

table_section_title(_("Suppliers and Purchasing Defaults"));

gl_all_accounts_list_row(_("Payable Account:"), 'creditors_act', $myrow['creditors_act']);

gl_all_accounts_list_row(_("PDC Issue:"), 'creditors_pdc_act', $myrow['creditors_pdc_act']);	//PDC Issue


gl_all_accounts_list_row(_("Purchase Discount Account:"), 'pyt_discount_act', $myrow['pyt_discount_act']);

gl_all_accounts_list_row(_("GRN Clearing Account:"), 'grn_clearing_act', get_post('grn_clearing_act'), true, false, _("No postings on GRN"));

text_row(_("Receival Required By:"), 'default_receival_required', $myrow['default_receival_required'], 6, 6, '', "", _("days"));

check_row(_("Show PO item codes:"), 'show_po_item_codes', $myrow['show_po_item_codes']);




end_outer_table(1);

submit_center('display_gl_purchase', _("Update"), true, '', 'default');


 ?>