<?php

//Helper function
function can_process_general($new){
	global $SysPrefs;
	if(strlen($_POST['user_id']) < 4){
		display_error( _("The user login entered must be at least 4 characters long."));
		set_focus('user_id');
		return false;
	}

	if(!$new && ($_POST['password'] != "")){
    	
    	if(strlen($_POST['password']) < 4){
    		display_error( _("The password entered must be at least 4 characters long."));
			set_focus('password');
    		return false;
    	}
    	if (strstr($_POST['password'], $_POST['user_id']) != false){
    		display_error( _("The password cannot contain the user login."));
			set_focus('password');
    		return false;
    	}
	}
	
	if(strlen($_POST['email']) && !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)){
		display_error( _("Invalid Email Address."));
		set_focus('email');
		return false;
	}

	if($_FILES['user_img_in']['name']){
		$extension = pathinfo($_FILES['user_img_in']['name'], PATHINFO_EXTENSION);

		if(!in_array($extension, array('jpg','JPG','png','PNG'))){
			display_error(_('Only jpg and png files are supported'));
			return false;
		}
		if($_FILES['user_img_in']['size'] > ($SysPrefs->max_image_size * 1024)){ 
			//File Size Check
			display_error(_('The file size is over the maximum allowed. 
				The maximum size allowed in KB is').' '.$SysPrefs->max_image_size);
			return false;
		}
	}
	return true;
}
//-------------------------------------------------------------------------------------------------- 
function user_settings($selected_id){
	global $Ajax;

	start_table(TABLESTYLE6_BOX,"",0,0,0,null,"50%","3px solid #656E79;");
	table_section_title(_("General Tab"));

	if ($selected_id != -1){
		$Ajax->activate('_page_body');
		$myrow = get_user($selected_id);
		$_POST['role_id'] = $myrow["role_id"];
		$_POST['language'] = $myrow["language"];
		$_POST['technician'] = $myrow["technician"];
		$_POST['pos'] = $myrow["pos"];
		$_POST['user_id'] = $myrow["user_id"];
		$_POST['real_name'] = $myrow["real_name"];
		$_POST['phone'] = $myrow["phone"];
		$_POST['email'] = $myrow["email"];
		$_POST['user_img'] = $myrow['user_img'];
		
		label_row(_("User login:"), $_POST['user_id']);
		hidden('user_id', $_POST['user_id']);
	}
	else{
		text_row(_("User Login:"), "user_id",  null, 22, 20);
		// hidden('language', user_language());
		hidden('print_profile', user_print_profile());
	}

	if ($selected_id == -1){
		$_POST['password'] = "";
		password_row(_("Password:"), 'password', $_POST['password']);
	}

	if ($selected_id != -1){//For existing user edit button
		table_section_title(_("Enter a new password to change, leave empty to keep current."));
		password_row(_("Password:"), 'password', $_POST['password']);
	}

	text_row_ex(_("Full Name").":", 'real_name',  50);
	text_row_ex(_("Contact #:"), 'phone', 30);
	email_row_ex(_("Email Address:"), 'email', 50);

	security_roles_list_row(_("Access Level:"), 'role_id', null); 
	languages_list_row(_("Language:"), 'language', null);
	technician_list_row(_("Technician: "), 'technician', null, _("All Technician"));
	pos_list_row(_("User's POS"). ':', 'pos', null);
	

	if($_POST['user_img']){
		label_row(_("User Image").":", $_POST['user_img']);
		hidden('user_img', $_POST['user_img']);
		check_row(_("Delete Image:"), 'del_image');
	}
	else{
		file_row(_("User Image").":", 'user_img_in', 'user_img_in');
	}
	
	hidden('user_img', $_POST['user_img']);

	if($selected_id!=-1  && !file_exists(company_path().'/images/user-'.$selected_id.".jpg"))
		label_row('Write signature', viewer_link(_(" Signature Pad"), "admin/user_sign.php?user_id=".$selected_id));

	$sign_img_link = "";
	$check_remove_image = false;
	
	if(isset($selected_id) && file_exists(company_path().'/images/user-'.$selected_id.".jpg")) {
	 	//rand() call is necessary here to avoid caching problems.
		$sign_img_link .= "<img id='item_img' alt='[".$selected_id.".jpg"."]' 
		src='".company_path().'/images/user-'.$selected_id.".jpg?nocache=".rand()."'"." 
		height='".$SysPrefs->pic_height."' border='0'>";
		$check_remove_image = true;
	} 
	else{
		$sign_img_link .= _("No Signature image");
	}

	label_row("&nbsp;", $sign_img_link);
	if($check_remove_image)
		check_row(_("Delete Signature:"), 'del_sign');

	end_table(1);

	div_start('controls');

	if($selected_id == -1){
		submit_center('submit_gen', _("Add New User"), true, '', 'default');
	} 
	else{
		submit_center_first('submit_gen', _("Update User"), _('Update User Data'), true);
		submit_center_last('Cancel', _("Cancel Update"), _('Cancel Update'), true);
	}
	div_end();
}
// Access Level , User’s POS, Create Employee , Auto GL & Bank Account , Printing Profile, Use popup window for reports, Language

function user_assoc($selected_id){
	global $Ajax;


	start_table(TABLESTYLE6_BOX,"",0,0,0,null,"50%","3px solid #656E79;");
	table_section_title(_("Assocaiton Tab"));

	if ($selected_id != -1){
		if(!list_updated('customer_id')){
			$Ajax->activate('_page_body');
			//editing an existing User
			$myrow = get_user($selected_id);
			$_POST['dimension'] = $myrow["dimension"];
			$_POST['rep_popup'] = $myrow["rep_popup"];
			$_POST['customer_id']=$myrow["customer_id"];
			$_POST['branch_id']=$myrow["branch_id"];
		/*Miscell*/
			$_POST['print_profile'] = $myrow["print_profile"];
			$_POST['rep_popup'] = $myrow["rep_popup"];
			$_POST['owner'] = $myrow["owner"];
			$_POST['all_contact_person'] = $myrow["all_contact_person"];
			$_POST['all_opportunities'] = $myrow["all_opportunities"];
			$_POST['first_approval'] = $myrow["first_approval"];
			$_POST['second_approval'] = $myrow["second_approval"];			
		}
	}

	customer_list_row(_('Customer:'), 'customer_id', null,'Select Customer', true);

	if(get_post('customer_id'))
		customer_branches_list_row(_("Branch:"), $_POST['customer_id'], 'branch_id', null, 
		'Select', true, false, true);

	dimensions_list_row(_("Dimension:"), 'dimension',  null, 'Select Dimension', null, false, 1, 
	false);


	check_row(_("Owner"),'owner', null);
	print_profiles_list_row(_("Printing profile"). ':', 'print_profile', null,
	_('Browser printing support'));
	check_row(_("Use popup window for reports:"), 'rep_popup', $_POST['rep_popup'],
	false, _('Set this option to on if your browser directly supports pdf files'));

	$sql = get_employees(false,  false,  false,$selected_id);
	$row = db_fetch(db_query($sql));
	if($row)
		label_row(_("Employee : "),$row['emp_id']." - ".$row['name']);
	else
		check_row(_("Create Employee"), 'create_emp', null, true);

	if(isset($_POST['create_emp'])){
		table_section_title(_('Employee Personal Information'));

		gender_radio_row(_('Gender').':', 'EmpGender', null);
		date_row(_('Birth Date').':', 'EmpBirthDate', null, null, 0, 0, -13);
		date_row(_('Hire Date').':', 'EmpHireDate', null, null, 0, 0, 1001);
		department_list_row(_('Department').':', 'DepartmentId', null, _('Select department'));
		salaryscale_list_row(_('Designation').':', 'EmpSalary', null, _('Select Designation'));
		amount_cells(_("Employee Salary:"), 'salary', $_POST['salary']);
	}

	$row = get_bank_account_user_id($selected_id);
	if($row)
		label_row("GL Account & Bank Account :", $row['account_code']."-".$row['bank_account_name']);
	else
		check_row(_("Create Auto GL & Bank Account"),'emp_gl_and_bank_acc', null, false, 
		_(" Auto create GL and bank account for this user"));

	check_row(_("Can access to its own Contacts only"),'all_contact_person', null, false, 
		_("By Check on It User Can See all Contact Forms"));

	check_row(_("Can access to its own Opportunities only"),'all_opportunities', null, false, 
		_("By Check on It User Can See all Opportunities"));

	check_row(_("First Approval On Transaction"),'first_approval', null, false, 
		_("First Approval On Transaction"));

	check_row(_("Second Approval On Transaction"),'second_approval', null, false, 
		_("Second Approval On Transaction"));	

	end_table(1);

	div_start();
	submit_center_first('submit_assoc', _("Update User"), _('Update User Data'), true);
	submit_center_last('Cancel', _("Cancel Update"), _('Cancel Update'), true);
	div_end();
}


function user_misc($selected_id){
	global $Ajax;

	start_table(TABLESTYLE6_BOX,"",0,0,0,null,"50%","3px solid #656E79;");
	table_section_title(_("Miscellaneous Tab"));

	// if ($selected_id != -1){
	// 	$Ajax->activate('_page_body');
	// 	//editing an existing User
	// 	$myrow = get_user($selected_id);

	// 	$_POST['print_profile'] = $myrow["print_profile"];
	// 	$_POST['rep_popup'] = $myrow["rep_popup"];
	// 	$_POST['owner'] = $myrow["owner"];
	// }

	// check_row(_("Owner"),'owner', null);
	// print_profiles_list_row(_("Printing profile"). ':', 'print_profile', null,
	// _('Browser printing support'));
	// check_row(_("Use popup window for reports:"), 'rep_popup', $_POST['rep_popup'],
	// false, _('Set this option to on if your browser directly supports pdf files'));

	end_table(1);

	div_start('controls');
	submit_center_first('submit_misc', _("Update User"), _('Update User Data'), true);
	submit_center_last('Cancel', _("Cancel Update"), _('Cancel Update'), true);
	div_end();
}

?>