<?php

$page_security = 'SA_MULTISETUPCOMPANY';
$path_to_root = "..";
include($path_to_root . "/includes/session.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();


  $_SESSION['page_title'] = _($help_context = "Multiple Company Setup");


page($_SESSION['page_title'], false, false, "", $js);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/admin/db/multicompany_db.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/fixed_assets/includes/fixed_assets_db.inc");

$user_comp = user_company();
$new_item = get_post('Dimension_id')=='' || get_post('cancel') || get_post('clone'); 
//------------------------------------------------------------------------------------

if (isset($_GET['Dimension_id']))
{
	$_POST['Dimension_id'] = $_GET['Dimension_id'];
}
$Dimension_id = get_post('Dimension_id');
if (list_updated('Dimension_id')) {
	$_POST['Dimension_id'] = $Dimension_id = get_post('Dimension_id');
    clear_data();
	$Ajax->activate('details');
	$Ajax->activate('controls');
}


$upload_file = "";
if (isset($_FILES['pic']) && $_FILES['pic']['name'] != '') 
{
    
	$Dimension_id = $_POST['Dimension_id'];
	$result = $_FILES['pic']['error'];
 	$upload_file = 'Yes'; //Assume all is well to start off with
	$filename = company_path().'/images';
	if (!file_exists($filename))
	{
		mkdir($filename);
	}	
	$filename .= "/".clean_file_name($_FILES['pic']['name']);;

  if ($_FILES['pic']['error'] == UPLOAD_ERR_INI_SIZE) {
    display_error(_('The file size is over the maximum allowed.'));
		$upload_file ='No';
  }
  elseif ($_FILES['pic']['error'] > 0) {
		display_error(_('Error uploading file.'));
		$upload_file ='No';
  }
	
	//But check for the worst 
	if ((list($width, $height, $type, $attr) = getimagesize($_FILES['pic']['tmp_name'])) !== false)
		$imagetype = $type;
	else
		$imagetype = false;

	if ($imagetype != IMAGETYPE_GIF && $imagetype != IMAGETYPE_JPEG && $imagetype != IMAGETYPE_PNG)
	{	//File type Check
		display_warning( _('Only graphics files can be uploaded'));
		$upload_file ='No';
	}
	elseif (!in_array(strtoupper(substr(trim($_FILES['pic']['name']), strlen($_FILES['pic']['name']) - 3)), array('JPG','PNG','GIF')))
	{
		display_warning(_('Only graphics files are supported - a file extension of .jpg, .png or .gif is expected'));
		$upload_file ='No';
	} 
	elseif ( $_FILES['pic']['size'] > ($SysPrefs->max_image_size * 1024)) 
	{ //File Size Check
		display_warning(_('The file size is over the maximum allowed. The maximum size allowed in KB is') . ' ' . $SysPrefs->max_image_size);
		$upload_file ='No';
	} 
	elseif ( $_FILES['pic']['type'] == "text/plain" ) 
	{  //File type Check
		display_warning( _('Only graphics files can be uploaded'));
        $upload_file ='No';
	} 
	elseif (file_exists($filename))
	{
		$result = unlink($filename);
		if (!$result) 
		{
			display_error(_('The existing image could not be removed'));
			$upload_file ='No';
		}
	}
	
	if ($upload_file == 'Yes')
	{
		$result  =  move_uploaded_file($_FILES['pic']['tmp_name'], $filename);
	}
	$Ajax->activate('details');
 /* EOF Add Image upload for New Item  - by Ori */
}



function clear_data()
{
		unset($_POST['coy_name']);
		unset($_POST['postal_address']);	
		unset($_POST['domicile']);	
		unset($_POST['phone']);	
		unset($_POST['fax']);
		unset($_POST['email']); 
		unset($_POST['gst_no']); 
}

//------------------------------------------------------------------------------------

if (isset($_POST['addupdate'])) 
{

	$input_error = 0;
	if ($upload_file == 'No')
		$input_error = 1;
	if (strlen($_POST['coy_name']) == 0) 
	{
		$input_error = 1;
		display_error( _('The company name must be entered.'));
		set_focus('coy_name');
	} 
	 if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) ) {
		      display_error( _(" Invalid email format. "));
			set_focus('cust_email');
			return false;
    }

	if ($input_error != 1)
	{
	    // display_error($_POST['coy_name']);
		$_POST['pic'] = clean_file_name($_FILES['pic']['name']);
	    // display_error($_POST['pic']);
	    // die;

		add_multicompany_pref($_POST['Dimension_id'],$_POST['coy_name'], $_POST['postal_address'], $_POST['domicile'], $_POST['phone'], $_POST['email'], $_POST['fax'], $_POST['gst_no'], $_POST['pic']);
		display_notification(" Company information is inserted ");

		$Ajax->activate('_page_body');
	}
}

if (get_post('clone')) {
	unset($_POST['Dimension_id']);
	$Dimension_id = '';
	unset($_POST['inactive']);
	set_focus('Dimension_id');
	$Ajax->activate('_page_body');
}

//------------------------------------------------------------------------------------

function check_usage($Dimension_id, $dispmsg=true)
{
	$msg = item_in_foreign_codes($Dimension_id);

	if ($msg != '')	{
		if($dispmsg) display_error($msg);
		return false;
	}
	return true;
}

//------------------------------------------------------------------------------------

if (isset($_POST['delete']) && strlen($_POST['delete']) > 1) 
{

	if (check_usage($_POST['Dimension_id'])) {

		$Dimension_id = $_POST['Dimension_id'];
		delete_item($Dimension_id);
		$filename = company_path().'/images/'.clean_file_name($_FILES['pic']['name']);
		if (file_exists($filename))
			unlink($filename);
		display_notification(_("Selected item has been deleted."));
		$_POST['Dimension_id'] = '';
		clear_data();
		set_focus('Dimension_id');
		$new_item = true;
		$Ajax->activate('_page_body');
	}
}

function item_settings(&$Dimension_id, $new_item) 
{
	global $SysPrefs, $path_to_root, $page_nested, $depreciation_methods;

	start_outer_table(TABLESTYLE2,"style='width:100% !important;'");

	table_section(1);

	table_section_title(_("General Settings"));

	//------------------------------------------------------------------------------------
	if ($new_item) 
	{
		$tmpCodeID=null;
		$post_label = null;
		if (!empty($SysPrefs->prefs['barcodes_on_stock']))
		{
			$post_label = '<button class="ajaxsubmit" type="submit" aspect=\'default\'  name="generateBarcode"  id="generateBarcode" value="Generate Barcode EAN8"> '._("Generate EAN-8 Barcode").' </button>';
			if (isset($_POST['generateBarcode']))
			{
				$tmpCodeID=generateBarcode();
				$_POST['NewStockID'] = $tmpCodeID;
			}
		}	
	
		$_POST['inactive'] = 0;
	} 
	else 
	{ // Must be modifying an existing item
		if (get_post('Dimension_id') || get_post('addupdate')) { // first item display

			$_POST['Dimension_id'] = $_POST['Dimension_id'];

		$result = get_multicompany_pref($_POST['Dimension_id']);
		$myrow= db_fetch($result);
			$_POST['coy_name']  = $myrow["coy_name"];
		$_POST['postal_address']  = $myrow["postal_address"];
		$_POST['domicile']  = $myrow["domicile"];
		$_POST['phone']  = $myrow["phone"];
		$_POST['fax']  = $myrow["fax"];
		$_POST['email'] = $myrow["email"];
		// $_POST['bcc_email'] = $myrow["bcc_email"];
		$_POST['pic'] = $myrow["pic"];
			$_POST['gst_no'] = $myrow["gst_no"];

			
		}
	hidden('NewDimension_id', $_POST['Dimension_id']);
		set_focus('coy_name');
	}


	text_row(_("Name:"), 'coy_name', null, 52, 200);

	textarea_row(_('Address:'), 'postal_address', null, 42, 3);

text_row(_("Domicle:"), 'domicile', null, 52, 200);
text_row(_("Phone Number:"), 'phone', null, 52, 200);
text_row(_("Fax:"), 'fax', null, 52, 200);
text_row(_("Email Address:"), 'email', null, 52, 200);
$tax_label = $_SESSION['SysPrefs']->prefs['tax_label'];
text_row(_($tax_label.":"), 'gst_no', null, 52, 200);
	
	
	table_section_title(_("Other"));

	// Add image upload for New Item  - by Joe
	file_row(_("Image File (.jpg)") . ":", 'pic', 'pic');
	// Add Image upload for New Item  - by Joe
	$stock_img_link = "";
	$check_remove_image = false;

	if (isset($_POST['Dimension_id']) && file_exists(company_path().'/images/'
		.dim_img_name($_POST['Dimension_id']) )  && dim_img_name($_POST['Dimension_id'])!=""  )
	{
	   
	  
		$nocache=rand();
		$img_name=dim_img_name($_POST['Dimension_id']);
		// var_dump($img_name);
	 // 31/08/08 - rand() call is necessary here to avoid caching problems.
		$stock_img_link .= "<a href='../company/0/images/".$img_name."?nocache=".$nocache." ' download> <img id='item_img' alt = '[".dim_img_name($_POST['Dimension_id']).
			"]' src='".company_path().'/images/'.$img_name.
			"?nocache=".$nocache."'"." height='".$SysPrefs->pic_height."' border='0'></a>";
			$check_remove_image = true;


//$imagecontent =DownloadImageFromUrl("http://localhost/ehomes/company/0/images/002.jpg?nocache=23854g");
// $savefile = fopen('myimage.png', 'r');
// fread($savefile, $imagecontent);
// fclose($savefile);
	} 
	else 
	{
		$stock_img_link .= _("No image");
	}

	label_row("&nbsp;", $stock_img_link);
	if ($check_remove_image)
		check_row(_("Delete Image:"), 'del_image');

	
	end_outer_table(1);
	div_start('controls');
	if (@$_REQUEST['popup']) hidden('popup', 1);
	if (!isset($_POST['NewStockID']) || $new_item) 
	{
		submit_center('addupdate', _("Insert Company Information"), true, '', 'default');
	} 
	else 
	{
	    display_error(33);
		submit_center_first('addupdate', _("Update Company Information"), '', 
			$page_nested ? true : 'default');
	}

	div_end();
}

//-------------------------------------------------------------------------------------------- 

start_form(true);

if (db_has_stock_items()) 
{
	start_table(TABLESTYLE_NOBORDER);
	start_row();
    dimensions_list_row(_("Select an Dimension:"), 'Dimension_id', null,false,null,
	false, 0,true);

	end_row();
	end_table();

	if (get_post('_show_inactive_update')) {
		$Ajax->activate('Dimension_id');
		set_focus('Dimension_id');
	}
}
else
{
	hidden('Dimension_id', get_post('Dimension_id'));
}

div_start('details');

$Dimension_id = get_post('Dimension_id');
if (!$Dimension_id)
	unset($_POST['_tabs_sel']); // force settings tab for new customer

$tabs = (get_post('fixed_asset'))
	? array(
		'settings' => array(_('&General settings'), $Dimension_id),
		'movement' => array(_('&Transactions'), $Dimension_id) )
	: array(
		'settings' => array(_('&General settings'), $Dimension_id),
	);

tabbed_content_start('tabs', $tabs);

	switch (get_post('_tabs_sel')) {
		default:
		case 'settings':
			item_settings($Dimension_id, $new_item); 
			break;
	
	};

br();
tabbed_content_end();

div_end();

hidden('fixed_asset', get_post('fixed_asset'));

if (get_post('fixed_asset'))
	hidden('mb_flag', 'F');

end_form();

//------------------------------------------------------------------------------------

end_page();

function generateBarcode() {
	$tmpBarcodeID = "";
	$tmpCountTrys = 0;
	while ($tmpBarcodeID == "")	{
		srand ((double) microtime( )*1000000);
		$random_1  = rand(1,9);
		$random_2  = rand(0,9);
		$random_3  = rand(0,9);
		$random_4  = rand(0,9);
		$random_5  = rand(0,9);
		$random_6  = rand(0,9);
		$random_7  = rand(0,9);
		//$random_8  = rand(0,9);

			// http://stackoverflow.com/questions/1136642/ean-8-how-to-calculate-checksum-digit
		$sum1 = $random_2 + $random_4 + $random_6; 
		$sum2 = 3 * ($random_1  + $random_3  + $random_5  + $random_7 );
		$checksum_value = $sum1 + $sum2;

		$checksum_digit = 10 - ($checksum_value % 10);
		if ($checksum_digit == 10) 
			$checksum_digit = 0;

		$random_8  = $checksum_digit;

		$tmpBarcodeID = $random_1 . $random_2 . $random_3 . $random_4 . $random_5 . $random_6 . $random_7 . $random_8;

		// LETS CHECK TO SEE IF THIS NUMBER HAS EVER BEEN USED
		$query = "SELECT Dimension_id FROM ".TB_PREF."stock_master WHERE Dimension_id='" . $tmpBarcodeID . "'";
		$arr_stock = db_fetch(db_query($query));
  
		if (  !$arr_stock['Dimension_id'] ) {
			return $tmpBarcodeID;
		}
		$tmpBarcodeID = "";	 
	}
}
