<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

$page_security = 'QUICK_ACCESS';
$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");
add_access_extensions();
include_once($path_to_root . "/includes/ui.inc");

simple_page_mode(true);
page(_($help_context = "Quick Access"));


//----------------------------------------------------------------------------------------------------


if(count($label2)>0)
{
	unset($label2);
	unset($link2);
}


$label2 = array();
$link2  = array();
$applications2 = $_SESSION['App']->applications;

foreach($applications2 as $app){
	foreach ($app->modules as $module){
		if (count($module->lappfunctions) > 0) {
			foreach ($module->lappfunctions as $appfunction)
				$apps[] = $appfunction;
		}
		foreach ($module->rappfunctions as $appfunction)
			$apps[] = $appfunction;
	}
}
$application = array();	
foreach ($apps as $application)	
{
	if ($_SESSION["wa_current_user"]->can_access_page($application->access))
   {
	  if($application->label != ''){
    	array_push($label2, $application->label);
     	array_push($link2, $application->link);      
	   }
	}
	else
	continue;	
}


function get_data($name){
      $sql = "SELECT * FROM ".TB_PREF."quick_access WHERE UPPER(name) = ".db_escape($name)." AND user_id = ".db_escape($_SESSION["wa_current_user"]->user)."  ";

  // $sql = "SELECT * FROM ".TB_PREF."quick_access WHERE UPPER(name) = '$name' AND user_id == ".db_escape($user_id).";
  $res = db_query($sql);
  if(db_num_rows($res) > 0)
	return db_fetch($res);
  else
  	return 0;
}
function get_icon($name){
    if(get_user($_SESSION['wa_current_user']->user)['language'] == 'ar_EG'){
           $sql = " SELECT * FROM ".TB_PREF."icon where arabic_icon_title= ".db_escape($name);
          }else{
            $sql = " SELECT * FROM ".TB_PREF."icon where icon_title= ".db_escape($name);
          }
    
    $result = db_query($sql , "no data found");

    if(db_num_rows($result) == 1){
     $myrow = db_fetch($result);
     return $myrow['icon_img'];
    }
    else{
     $myrow = db_fetch($result);
     return $myrow['icon_img'];
    }
}
function can_process()
{
	global $label2;

	$count = 0;

	foreach ($label2 as $key => $value) {
		if($_POST['active'.$key])
			$count++;
	}

	if($count > 13){
		display_error("You can only select 14 Quick Entries");
		return false;
	}
 
 	return true;
}


//----------------------------------------------------------------------------------------------------


if ($Mode=='ADD_ITEM' && can_process())
{

	$user_id = $_SESSION['wa_current_user']->user;

	// $sql = "TRUNCATE ".TB_PREF."quick_access";
	$sql = "DELETE FROM ".TB_PREF."quick_access WHERE user_id = ".db_escape($_SESSION['wa_current_user']->user)." ";

	$res = db_query($sql);

$i=0;
	foreach ($label2 as $key => $value) {
		if($value == 'Import CSV Customer' || $value == 'Import CSV Supplier' || $value == 'Import CSV Items' )
		continue;// this condition is false to print imports pages which is comes from hooks.php
	++$i;
	
		$name = str_replace('&','',$value);
		$icon = $_POST['icon'.$key];
		$active = $_POST['active'.$key];
		$url = $link2[$key];
		// display_error($_POST['active'.$i]."====".$i."====".$name."====".$url);
		if(isset($_POST['active'.$i])){

			$sql = "INSERT INTO  ".TB_PREF."quick_access (name, link, icon, active, user_id) VALUES( ".db_escape($name).", ".db_escape($url).",
			 ".db_escape($icon).", ".db_escape('1').", ".db_escape($_SESSION['wa_current_user']->user).") ";


			$res = db_query($sql);			
		}

	}
	display_notification(_('Quick Access has been added'));
		$Mode = 'RESET';

}
if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
     meta_forward($_SERVER['PHP_SELF'], null, 3000);
}



start_form();
// start_table(TABLESTYLE2,"id='quick_access_table'",0,0,0,null,"40%","3px solid #656E79;");

submit_add_or_update_center($selected_id == -1, '', 'both');
echo "<br>";
echo '<center><table class="table tablestyle2" style="width: 36% !important;border: 3px solid #d2d2d2;
        box-shadow: 10px 10px 10px -9px #505b67;" id="quick_access_table" cellpadding="0" cellspacing="0">';
// start_table(TABLESTYLE2,'style=""');
$th = array ('S.No', _('Page Name') ,_('Active'));
//------ add this , _("Font Awesome Icons") to $th --------
inactive_control_column($th);
// table_header($th);

echo ' <thead>
        <tr>
            <th>'._('S.No').'</th>
            <th>'._('Page Name').'</th>
            <th>'._('Active').'</th>
        </tr>
    </thead>';

// ________22_______________36______________50 _______________120

$cc_key = 0;
	foreach ($label2 as $key => $value)
    {

	if($value == 'Import CSV Customer' || $value == 'Import CSV Supplier' || $value == 'Import CSV Items' )
		continue;// this condition is false to print imports pages which is comes from hooks.php

	$name = str_replace('&','',$value);
	$data = get_data(strtoupper($name));
	if($data != 0){
		$_POST['icon'.$key] = $data['icon'];
		$_POST['active'.$key] = 1;
	}
	else
	{
		$icon_name = get_icon($name);
        $_POST['icon'.$key] = 'menu-icon '.$icon_name.' bg-light-blue';
		$_POST['active'.$key] = 0;
	}

	label_cell(++$cc_key); // this is the serial number
	label_cell(str_replace('&','',$value));  // this is name to print

		//------unhide this -----------
	// text_cells(null,'icon'.$key,null, "", "",false, 
	// "","","",true);
	hidden('icon'.$key);

	check_cells(null, 'active'.$cc_key, $_POST['active'.$key], false);  // this is the check box to print
	end_row();
}

end_table(1);


end_form();
?>
<script type="text/javascript">
	$(document).ready(function() {
    $('#quick_access_table').DataTable({
    	 "paging":   false,
        "ordering": false,
        "info":     false
    });

    $('#quick_access_table_filter > label > input[type="search"]').keyup(function(){
		var val = $('#quick_access_table_filter > label > input[type="search"]').val();
		if (val != '') {
			$('#ADD_ITEM').hide();
					
		}else{
			$('#ADD_ITEM').show();
				
		}
	});

} );
</script>
<style type="text/css">
	div#quick_access_table_filter {
    float: left;
    /* margin-left: 0rem; */
	}
</style>
<?php
end_page();
?>