<?php

$path_to_root = "..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/types.inc"); // For tag constants
include_once($path_to_root . "/admin/db/tags_db.inc");
include($path_to_root . "/includes/ui.inc");

// Set up page security based on what type of tags we're working with
if (@$_GET['type'] == "account" || get_post('type') == TAG_ACCOUNT) {
	$page_security = 'SA_GLACCOUNTTAGS';
} else if(@$_GET['type'] == "dimension" || get_post('type') == TAG_DIMENSION) {
	$page_security = 'SA_DIMTAGS';
}

// We use $_POST['type'] throughout this script, so convert $_GET vars
// if $_POST['type'] is not set.
if (!isset($_POST['type'])) {
	if ($_GET['type'] == "account")
		$_POST['type'] = TAG_ACCOUNT;
	elseif ($_GET['type'] == "dimension")
		$_POST['type'] = TAG_DIMENSION;
	else
		die(_("Unspecified tag type"));
}

// Set up page based on what type of tags we're working with
switch ($_POST['type']) {
	case TAG_ACCOUNT:
		// Account tags
		$_SESSION['page_title'] = _($help_context = "Account Tags");
		break;
	case TAG_DIMENSION:
		// Dimension tags
		$_SESSION['page_title'] = _($help_context = "Dimension Tags");
}

page($_SESSION['page_title']);

simple_page_mode(true);

//-----------------------------------------------------------------------------------

function can_process() 
{
	if (strlen($_POST['name']) == 0) 
	{
		display_error( _("The tag name cannot be empty."));
		set_focus('name');
		return false;
	}
	return true;
}

//-----------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	if (can_process()) 
	{
    	if ($selected_id != -1) 
    	{
    		if( $ret = update_tag($selected_id, $_POST['name'], $_POST['description'],null,$_POST['name_arabic']))
    			$inserted_id = $selected_id;
    			if ($_POST['type'] == TAG_ACCOUNT ) {
				add_audit_trail(SM_TAG_ACCOUNT, $inserted_id, today(),'Account Tag Updated');
    			}else{
    			add_audit_trail(SM_TAG_DIMENSION, $inserted_id, today(),'Dimension Tag Updated');	
    			}

				display_notification(_('Selected tag settings have been updated'));

    	} 
    	else 
    	{
    		if( $ret = add_tag($_POST['type'], $_POST['name'], $_POST['description'],$_POST['name_arabic']))
    			$inserted_id = db_insert_id();
    			if ($_POST['type'] == TAG_ACCOUNT ) {
				add_audit_trail(SM_TAG_ACCOUNT,$inserted_id, today(),'Account Tag Added');
    			}else{
    			add_audit_trail(SM_TAG_DIMENSION,$inserted_id, today(),'Dimension Tag Added');	
    			}

				display_notification(_('New tag has been added'));
    	}
		if ($ret) $Mode = 'RESET';
	}
}

//-----------------------------------------------------------------------------------

function can_delete($selected_id)
{
	if ($selected_id == -1)
		return false;
	$result = get_records_associated_with_tag($selected_id);
	
	if (db_num_rows($result) > 0)	
	{
		display_error(_("Cannot delete this tag because records have been created referring to it."));
		return false;
	}

	return true;
}


//-----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	if (can_delete($selected_id))
	{
		delete_tag($selected_id);
		// add_audit_trail(2, $_POST['name'], today(),'Dimension Tag Deleted');
			if ($_POST['type'] == TAG_ACCOUNT ) {
			add_audit_trail(SM_TAG_ACCOUNT,$selected_id, today(),'Account Tag Deleted');
			}else{
			add_audit_trail(SM_TAG_DIMENSION,$selected_id, today(),'Dimension Tag Deleted');	
			}
		display_notification(_('Selected tag has been deleted'));
	}
	$Mode = 'RESET';
}

//-----------------------------------------------------------------------------------

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$_POST['name'] = $_POST['description']  =$_POST['name_arabic'] = '';
}

//-----------------------------------------------------------------------------------

$result = get_tags($_POST['type'], check_value('show_inactive'));

start_form();
//start_table(TABLESTYLE4);
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"40%","1px solid #656E79;");

$th = array(_("Tag Name"),_("Tag Name(In Arabic)"), _("Tag Description"), "", "");
inactive_control_column($th);
table_header($th);

$k = 0;
while ($myrow = db_fetch($result)) 
{
	alt_table_row_color($k);

	label_cell($myrow['name']);
	label_cell($myrow['name_arabic']);
	label_cell($myrow['description']);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'tags', 'id');
	edit_button_cell("Edit".$myrow["id"], _("Edit"));
	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//-----------------------------------------------------------------------------------

//start_table(TABLESTYLE2,"style=''");
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"40%","3px solid #656E79;");


if ($selected_id != -1) // We've selected a tag 
{
	if ($Mode == 'Edit') {
		// Editing an existing tag
		$myrow = get_tag($selected_id);
	
		$_POST['name'] = $myrow["name"];
		$_POST['description'] = $myrow["description"];
		$_POST['name_arabic'] = $myrow["name_arabic"];
	}
	// Note the selected tag
	hidden('selected_id', $selected_id);
}
	
text_row_ex(_("Tag Name:"), 'name', 15, 30);
text_row_arabic(_("Tag Name (In Arabic):"), 'name_arabic', 30, 50 ,null,null,null,null,1);

text_row_ex(_("Tag Description:"), 'description', 40, 60);
hidden('type');

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

//------------------------------------------------------------------------------------
echo '</br>';
end_page();

