<?php

$page_security = 'SA_USERS';
$path_to_root = "..";
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Users"));

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");

include_once($path_to_root . "/admin/db/users_db.inc");
include_once($path_to_root . "/admin/includes/users_ui.inc");
include_once($path_to_root . "/dimensions/includes/dimensions_db.inc");

include_once($path_to_root.'/modules/FrontHrm/includes/ui/employee_ui.inc');
include_once($path_to_root.'/modules/FrontHrm/includes/ui/department_ui.inc');
include_once($path_to_root.'/modules/FrontHrm/includes/ui/salary_scale_ui.inc');
include_once($path_to_root.'/modules/FrontHrm/includes/db/employee_db.inc');

//-------------------------------------------------------------------------------------------------

function attach($id){
	global $path_to_root;
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return '<a href="'.$path_to_root.'/admin/attachments.php?filterType='.ST_USER.'&trans_no='.$id.'">
		<img style="width:20px;height:20px;" src="../themes/'.user_theme().'/images/'.ICON_ATTACH.'"/></a>'; 
}



$delete = find_submit('Delete');
if ($delete != -1 && check_csrf_token()){

	$cancel_delete = 0;

    if(key_in_foreign_table($delete, 'audit_trail', 'user')){
        $cancel_delete = 1;
        display_error(_("Cannot delete this user because entries are associated with this user."));
    }
    if($cancel_delete == 0){
    	delete_user($delete);
    	display_notification_centered(_("User has been deleted."));
    } //end if Delete group

		unset($_POST);
		$Ajax->activate('_page_body');
}

//-------------------------------------------------------------------------------------------------
//General Tab button calls
if(isset($_POST['submit_gen'])){
	$new = ($_POST['selected_id']==-1);
	if(can_process_general($new)){

		if($new){
			$_POST['selected_id'] = add_user_general($_POST['user_id'], $_POST['real_name'], 
			md5($_POST['password']), $_POST['phone'], $_POST['email'], $_POST['role_id'], user_pos(), $_POST['language'], $_POST['technician']);

			$prefs = $_SESSION['wa_current_user']->prefs->get_all();
			update_user_prefs($_POST['selected_id'], 
			array_merge($prefs, get_post(array('print_profile', 'rep_popup' => 0, 'language','role_id', 'pos', 'all_contact_person', 'all_opportunities', 'first_approval', 'second_approval'))));
		}
		else{
			update_user_prefs($_POST['selected_id'],
			get_post(array('user_id','real_name','phone','email', 'role_id', 'pos', 'language', 'all_contact_person', 'all_opportunities', 'technician', 'first_approval', 'second_approval')));

    		if ($_POST['password'] != "")
    			update_user_password($_POST['selected_id'], $_POST['user_id'], 
    			md5($_POST['password']));
    	}
    	//Now Image Work
    	if (check_value('del_sign')){
			$filename = company_path().'/images/user-'.$_POST['selected_id'].".jpg";
			if (file_exists($filename))
				unlink($filename);
		}
		if (check_value('del_image')){
			$filename = company_path().'/images/user_img/'.$_POST['user_img'];
			if (file_exists($filename))
				$result = unlink($filename);
			if($result){
				$remove_img = "UPDATE ".TB_PREF."users SET user_img= '' 
				WHERE id = ".$_POST['selected_id'];
				db_query($remove_img);
			}
		}


		//User Profile Image
		if($_FILES['user_img_in']['name']){

			$filename = company_path()."/images/user_img";
			if(!file_exists($filename)){
				mkdir($filename);
			}

			$extension = pathinfo($_FILES['user_img_in']['name'], PATHINFO_EXTENSION);
			$filename .= "/".$_POST['selected_id'].".".$extension;

			if(file_exists($filename))
				unlink($filename);

			$img_name = $_POST['selected_id'].".".$extension;
			$result = move_uploaded_file($_FILES['user_img_in']['tmp_name'], $filename);
			if($result){
				$upload_img = "UPDATE ".TB_PREF."users SET user_img=".db_escape($img_name)."
				WHERE id = ".$_POST['selected_id'];
				db_query($upload_img);
			}
		}

		if($new){
			add_audit_trail(ST_USER, $_POST['selected_id'], date('d/m/Y'), "Inserted User");
			display_notification_centered(_("A new user has been added."));
		}
		else{
			add_audit_trail(ST_USER, $_POST['selected_id'], date('d/m/Y'), "Updated User");
    		display_notification_centered(_("The selected user has been updated."));
		}
		unset($_POST);
		$Ajax->activate('_page_body');
	}
}

if(isset($_POST['submit_assoc'])){
	if(isset($_POST['create_emp'])){
    	$user_id = $_POST['selected_id'];  
		$user_row = get_user($user_id);
   		$name = explode(' ', $user_row['real_name']);

		for($i=1; $i<=count($name); $i++)
	       $last.=$name[$i]." ";

		$_POST['EmpFirstName']=$name[0];
		$_POST['EmpLastName']=$last;

		if(!key_in_foreign_table($user_id, 'employee', 'user_id')){
			// display_error($user_row['role_id']);
			// exit;
			write_employee(false, $_POST['EmpFirstName'], $_POST['EmpLastName'], $_POST['EmpGender'],
			$_POST['EmpAddress'], $user_row['phone'], $user_row['email'], $_POST['EmpBirthDate'],
			$_POST['EmpNotes'], $_POST['EmpHireDate'], $_POST['DepartmentId'], $_POST['EmpSalary'],
			$_POST['EmpReleaseDate'], $_POST['EmpInactive'], $user_row['role_id'], $user_id, 
			input_num('salary'));
		}
	}

	if(isset($_POST['emp_gl_and_bank_acc'])){
		
		$user_id = $_POST['selected_id'];
		$user_row = get_user($user_id); 

	    if(!key_in_foreign_table($user_id, 'bank_accounts', 'user_id')){
            $name = ($user_row['real_name']) ? $user_row['real_name'] : $user_row['user_id'];
            $_POST['account_name']= $name." Cash In Hand";
            // # default gl account create
            $company_record = get_company_prefs();
			$_POST['emp_bank_gl_min']=$company_record['emp_bank_gl_min'];
            $emp_gl_code=get_next_emp_gl_account($company_record['emp_bank_gl_min'], 
            $company_record['emp_bank_gl_max']); 

            add_gl_account($emp_gl_code, $_POST['account_name'], $company_record['emp_account_type'], $_POST['account_code2'], $_POST['account_name_arabic'], $_POST['payment_gl']);
            add_audit_trail(SM_GL_ACCOUNT, $emp_gl_code, date('Y-m-d'),'Account Data Added');
			
			$_POST['bank_charge_act'] = $company_record['emp_bank_charge_act'];
	            
            add_bank_account($emp_gl_code, $company_record['emp_bank_account_type'], 
            $_POST['account_name'], $_POST['bank_name'], $_POST['bank_account_number'], 
           	$_POST['bank_address'], get_company_Pref('curr_default'), $emp_gl_code, 
          	$_POST['bank_charge_act'], $_POST['bank_account_arabic'], $user_id);
		        
		    add_audit_trail(3, $emp_gl_code, date('Y-m-d'),'Bank Account Created');
	    }            
    }
    // 'role_id', 'language', 'pos',
	update_user_prefs($_POST['selected_id'], get_post(array('customer_id', 'branch_id', 'dimension','owner', 'print_profile','rep_popup' => 0, 'all_contact_person', 'all_opportunities', 'first_approval', 'second_approval')));
	display_notification_centered(_("The selected user has been updated."));
	unset($_POST);
	$Ajax->activate('_page_body');
}

if(isset($_POST['submit_misc'])){
	// update_user_prefs($_POST['selected_id'], get_post(array()));
	// display_notification_centered(_("The selected user has been updated."));
	// unset($_POST);
	// $Ajax->activate('_page_body');
}

if(isset($_POST['Cancel'])){
	unset($_POST);
	$Ajax->activate('_page_body');
}
//--------------------------------------------------------------------------------------------------
$selected_id = find_submit('Edit');

if($_POST['selected_id']!=-1 && $_POST['selected_id'] && $selected_id==-1){
	$selected_id = $_POST['selected_id'];
}

start_form(true);

start_table(TABLESTYLE5_BOX,"",0,0,0,null,"25%","1px solid #656E79;");

$th = array(_("User login"), _("Full Name"), _("Phone"), _("E-mail"), _("Dimension"), 
	_("Last Visit"), _("Technician"), _("Access Level"),  _("Edit"), _("Delete"), _(""));

inactive_control_column($th);
table_header($th);	

$k = 0; //row colour counter

if(@$_GET['user_id']){

	$record = get_user($_GET['user_id']);
	
	alt_table_row_color($k);

	$last_visit_date = sql2date($record["last_visit_date"]);

	/*The security_headings array is defined in config.php */
	$not_me = strcasecmp($record["user_id"], $_SESSION["wa_current_user"]->username);

	label_cell($record["user_id"]);
	label_cell($record["real_name"]);
	label_cell($record["phone"]);
	email_cell($record["email"]);
	label_cell($record["dimension"]?get_dimension($record["dimension"])['name']:'');
	label_cell($last_visit_date, "nowrap");
	label_cell($record["technician"]);
	label_cell($record["role"]);
	

	
    if ($not_me)
		inactive_control_cell($record["id"], $record["inactive"], 'users', 'id');
	elseif (check_value('show_inactive'))
		label_cell('');

	edit_button_cell("Edit".$record["id"], _("Edit"));
    if ($not_me)
 		delete_button_cell("Delete".$record["id"], _("Delete"));
	else
		label_cell('');

	label_cell(attach($record["id"]));
	end_row();

}
else{
	$result = get_users(check_value('show_inactive'));
	while ($myrow = db_fetch($result)){

		alt_table_row_color($k);
		$last_visit_date = sql2date($myrow["last_visit_date"]);
		
		/*The security_headings array is defined in config.php */
		$not_me = strcasecmp($myrow["user_id"], $_SESSION["wa_current_user"]->username);

		label_cell($myrow["user_id"]);
		label_cell($myrow["real_name"]);
		label_cell($myrow["phone"]);
		email_cell($myrow["email"]);
		label_cell($myrow["dimension"]?get_dimension($myrow["dimension"])['name']:'');
		label_cell($last_visit_date, "nowrap");
		label_cell(get_technician($myrow["technician"])['name']);
		label_cell($myrow["role"]);
		
		
	    if ($not_me)
			inactive_control_cell($myrow["id"], $myrow["inactive"], 'users', 'id');
		elseif (check_value('show_inactive'))
			label_cell('');

		edit_button_cell("Edit".$myrow["id"], _("Edit"));
	    if ($not_me)
	 		delete_button_cell("Delete".$myrow["id"], _("Delete"));
		else
			label_cell('');

		label_cell(attach($myrow["id"]));
		end_row();
	}
}

inactive_control_row($th);
end_table(1);



tabbed_content_start('tabs', array(
		'general' => array(_('&General'), $selected_id),
		'assoc' => array(_('&Assocation'), $selected_id!=-1),
		// 'misc' => array(_('&Miscellaneous'), $selected_id!=-1),
	));
	
switch (get_post('_tabs_sel')){
	default:
	case 'general':
		user_settings($selected_id); 
		break;
	case 'assoc':
		user_assoc($selected_id);
		break;
	// case 'misc':
	// 	user_misc($selected_id);
	// 	break;
};

br();
hidden('selected_id', $selected_id);
tabbed_content_end();

end_form();
end_page();

