<?php


ini_set("display_errors", 1);


require_once('tcpdf_include.php');
require_once('../includes/types.inc');
require_once('../db_connection.inc');


function getTaxTransactions($from, $to, $tax_id)
{
  

    $sql = "SELECT d.debtor_no, d.name AS cust_name, d.tax_id, dt.type, dt.trans_no,  
            CASE WHEN dt.type=".ST_CUSTCREDIT." THEN (ov_amount+ov_freight+ov_discount)*-1 
            ELSE (ov_amount+ov_freight+ov_discount) END *dt.rate AS total
        FROM ".TB_PREF."debtor_trans dt
            LEFT JOIN ".TB_PREF."debtors_master d ON d.debtor_no=dt.debtor_no
        WHERE (dt.type=".ST_SALESINVOICE." OR dt.type=".ST_CUSTCREDIT.") ";
    if ($tax_id)
        $sql .= "AND tax_id<>'' ";
    $sql .= "AND dt.tran_date >='".$from."' AND dt.tran_date<='".$to."'
        ORDER BY d.debtor_no";
       
    return db_query($sql);
}

function getTaxes($type, $trans_no)
{  

    
    
    $sql = "SELECT included_in_price, SUM(CASE WHEN trans_type=".ST_CUSTCREDIT." THEN -amount ELSE amount END * ex_rate) AS tax
        FROM ".TB_PREF."trans_tax_details WHERE trans_type=$type AND trans_no=$trans_no GROUP BY included_in_price";

    $result = db_query($sql);
    if ($result !== false)
        return mysqli_fetch_assoc($result);
    else
        return null;
}    
/**
*  
*/


// Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {



    function get_current_fiscal()
    {
     
         $sql="SELECT fy.begin  as begin_fy ,fy.end as end_fy FROM `".TB_PREF."sys_prefs` sp JOIN ".TB_PREF."fiscal_year fy on fy.id=sp.value where name='f_year'";
         $result=db_query($sql);
         $res = mysqli_fetch_row($result);
         return $res;
    }

    //Page header
    public function Header() {
        $fiscal_year = $this->get_current_fiscal();
        $begin_fy = date('d/m/Y',strtotime($fiscal_year[0]));
        $end_fy = date('d/m/Y',strtotime($fiscal_year[1]));

       $report_name = "Sales Summary Report";
       $company_name = "WayZ ERP ";
       $period = $begin_fy." - ".date('d/m/Y');// "01/11/2018 - 30/11/2018";
       $fiscal_year = $begin_fy." - ".$end_fy." (Active)";
       $server_name = $_SERVER['SERVER_NAME'];
       $user_role ="Administrator";
       $now = date("r");




        // Logo
        $image_file = 'images/tcpdf_logo.jpg'; // *** Very IMP: make sure this image is available on given path on your server
        $this->Image($image_file,175,6,30);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        $this->SetTextColor(128,128,128);
        $this->Ln(3.5);        
        $this->Cell(80, 0, $report_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetTextColor();
           // $this->Ln();
        // $this->Cell(80, 0,'aaa', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'B', 9);
        $this->Ln(12);        
        $this->Cell(23, 3," Print Out Date:" , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(50, 3,$now , 0, false, 'C', 0, '', 0, false, 'M', 'M');

        $this->SetFont('helvetica', 'B', 9);
        $this->ln();
        $this->Cell(19, 0,"Fiscal Year:", 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(56, 0,$fiscal_year , 0, false, 'C', 0, '', 0, false, 'M', 'M');

        $this->SetFont('helvetica', 'B', 9);
        $this->ln();
        $this->Cell(12, 0,"Period:" , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(59, 0,$period , 0, false, 'C', 0, '', 0, false, 'M', 'M');


        $this->SetXY(15, 20);
        $this->SetFont('helvetica', 'B', 15);
        $this->SetTextColor(128,128,128);
        $this->Cell(347, 0,$company_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetTextColor();
        $this->SetFont('helvetica', 'B', 9);
        // $this->Ln(); 


        // We need to adjust the x and y positions of this text ... first two parameters

        $this->ln(); 
        $this->Cell(355, 0,$server_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->ln(); 
        $this->Cell(362, 0,$user_role, 0, false, 'C', 0, '', 0, false, 'M', 'M');






$header = array('Customer', 'Tax Id', 'Total Excluding Tax', 'Tax');   
$align = array('L', 'L', 'R', 'R');           

$this->Line(5, 36,206, 36);
$this->Line(5, 42,206, 42);
 $w = array(73, 40, 40, 47);
        $num_headers = count($header);
         $this->Ln(5); 
        for($i = 0; $i < $num_headers; ++$i) {
            $this->Cell($w[$i], 7, $header[$i], 0, 0,$align[$i], 0);
          // $this->Cell($w[$i],0,$header[$i], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        }
        $this->Ln();
        
       
    }

    // Page footer
    public function Footer() {
        // Position at 25 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        
        $this->Cell(0, 0, 'Product Company - ABC test company, Phone : +91 1122 3344 55, TIC : TESTTEST', 0, 0, 'C');
        $this->Ln();
        $this->Cell(0,0,'www.clientsite.com - T : +91 1 123 45 64 - E : info@clientsite.com', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
    
}

///////////////// End of class ////////////////////////////

//////////////////////////////////
//
//
// Create new PDF document
//
//
//////////////////////////////////
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Syed Zohaib Ali Alvi');
$pdf->SetTitle('Sales Summary Report');
$pdf->SetSubject('Sales Summary Report');
$pdf->SetKeywords('PDF, Sales Summary Report');


// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins
// $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetMargins(5, 43, 5);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
// $pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10); 
// *** Very IMP: Please use times font, so that if you send this pdf file in gmail as attachment and if user
//opens it in google document, then all the text within the pdf would be visible properly.

// add a page
$pdf->AddPage();

// create some HTML content
$now = date("r");
$company_name = 'ABC test company';

$user_name = 'Mr. Lorel Ispum';
$invoice_ref_id = '2013/12/03/0001';

// *** IMP: The value of $html and $html_terms can come from db
// But, If these values contain, other language special characters, then
// PDF is not getting generated. in that case should find such invalid charactes and 
// make use of its htmlentity substitute 
// for ex. If copyright is invalid character then use &copy; in html content


// $html on page 1 of PDF and $html_terms are on page 2 of PDF

            // <tr>
            //     <td colspan="2" align="center"><u><h1 style="color:gray;">Sales Summary Report </b></h1></td>
            // </tr>

$html = '';

            // <tr>
            //     <td colspan="3">Invoice # {invoice_ref_id}</td>            
            // </tr>
 // border="1" 
$fiscal_year = $pdf->get_current_fiscal();
// print_r($fiscal_year[0]) ;
// exit;
$html .= '<table  cellpadding="2">';
 $from = $fiscal_year[0];//"2000-11-01";//date2sql($from);
    $to = date('Y-m-d');//"2018-12-27";//date2sql($to);
    $tax_id=0;

$transactions = getTaxTransactions($from, $to, $tax_id);
    $totalnet = 0.0;
    $totaltax = 0.0;
$custno = 0;
    $tax = $total = 0;
    $custname = $tax_id = "";
while ($myrow = mysqli_fetch_assoc($transactions)) 
{

    if ($custno != $myrow['debtor_no'])
        {
            if ($custno != 0)
            {

          $html .= '   <tr>   <td style="width:35%;" align="left">'.$custname.'</td>
                <td style="width:15%;" align="left">'.$tax_id.'</td>
                <td align="right">'.number_format($total,2).'</td>
                 <td align="right">'.number_format($tax,2).'</td>
                  </tr>';

                  $totalnet += $total;
                $totaltax += $tax;
                $total = $tax = 0;

             }

          $custno = $myrow['debtor_no'];
            $custname = $myrow['cust_name'];
            $tax_id = $myrow['tax_id'];   
        }

        $taxes = getTaxes($myrow['type'], $myrow['trans_no']);
        if ($taxes != null)
        {
            if ($taxes['included_in_price'])
                $myrow['total'] -= $taxes['tax'];
            $tax += $taxes['tax'];
        }   
        $total += $myrow['total']; 
        }  
           
           if ($custno != 0)
    {
        $html .= '   <tr>   <td align="left">'.$custname.'</td>
                <td align="left">'.$tax_id.'</td>
                <td align="right">'.number_format($total,2).'</td>
                 <td align="right">'.number_format($tax,2).'</td>
                  </tr>';
        $totalnet += $total;
        $totaltax += $tax;
        
    }



  $html .= '         
            <tr>
            <td style="border-top: 1px solid black; border-bottom: 1px solid black;">Total</td>
            <td style="border-top: 1px solid black; border-bottom: 1px solid black;" colspan="2" align="right" ><b> '.number_format($totalnet,2).'</b></td>
                <td style="border-top: 1px solid black; border-bottom: 1px solid black;" colspan="3" align="right" ><b> '.number_format($totaltax,2).'</b></td>
            </tr>
         </table>';

// $html .= '<br><br>Some more text can come here...';

// $html = str_replace('{now}',$now, $html);
// $html = str_replace('{company_name}',$company_name, $html);
// $html = str_replace('{user_name}',$user_name, $html);




// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// add a page
// $pdf->AddPage();

// $html_terms = '
//         <table>
//             <tr>
//                 <td colspan="2"><u><b>Terms & Conditions</b></u></td>
//             </tr>
            
//             <tr>
//                 <td colspan="2" align="right">
//                 <ul>
//                     <li>Point one</li>
//                     <li>Point two</li>
//                     <li>Point three</li>
//                     <li>Point four</li>
//                     <li>Point five</li>
//                     <li>Point six</li>
//                     <li>Point seven</li>
//                     <li>Point eight</li>
//                     <li>Point nine</li>
//                     <li>Point ten</li>
//                 </ul>
//                 </td>
//             </tr>

//         </table>
//         ';
// output the HTML content
// $pdf->writeHTML($html_terms, true, false, true, false, '');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// reset pointer to the last page
$pdf->lastPage();

// ---------------------------------------------------------
$rep_id=114;
$rep_name='Sales Summary Report';
$dir1 = "../crons_images";
$cron_pdf_path = $dir1.'/'.date('H-i-s').'='.$rep_name.'.pdf';
// ---------------------------------------------------------

// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output($cron_pdf_path, 'F',$rep_id);
// $pdf->Output($cron_pdf_path, 'I',$rep_id);

//============================================================+
// END OF FILE                                                
//============================================================+
?>
