<?php


ini_set("display_errors", 1);

// Include the main TCPDF library (search for installation path).
require_once('../db_connection.inc');
require_once('tcpdf_include.php');
require_once('../includes/types.inc');
require_once('../includes/banking.inc');


function getTransactions($supplier_id, $from, $to)
{
    

	$from =date('Y-m-d',strtotime($from));
	$to = date('Y-m-d',strtotime($to));
	
 	$sql = "SELECT *,
				(ov_amount + ov_gst + ov_discount) AS TotalAmount,
				alloc AS Allocated,
				((type = ".ST_SUPPINVOICE.") AND due_date < '$to') AS OverDue
   			FROM ".TB_PREF."supp_trans
   			WHERE tran_date >= '$from' AND tran_date <= '$to' 
    			AND supplier_id = '$supplier_id' AND ov_amount!=0
    				ORDER BY tran_date";

    return  db_query($sql);
}

function get_open_balance($debtorno, $to)
{

	$sql = "SELECT
    	SUM(IF(type IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."), (ov_amount + ov_gst + ov_discount), 0)) AS charges,
    	SUM(IF(type NOT IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."), (ov_amount + ov_gst + ov_discount), 0)) AS credits,
		SUM(IF(type NOT IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."),alloc * -1, alloc)) AS Allocated,
		SUM(IF(type IN(".ST_SUPPINVOICE.",".ST_BANKDEPOSIT."), (ov_amount + ov_gst + ov_discount - alloc),
				(ov_amount + ov_gst + ov_discount + alloc))) AS OutStanding
		FROM ".TB_PREF."supp_trans
    	WHERE tran_date < '$to'
		AND supplier_id = '$supplier_id' GROUP BY supplier_id";

    $result = db_query($sql);
    return mysqli_fetch_assoc($result);
}



function getTaxes2($type, $trans_no)
{  

  
    
    $sql = "SELECT included_in_price, SUM(CASE WHEN trans_type=".ST_CUSTCREDIT." THEN -amount ELSE amount END * ex_rate) AS tax
        FROM ".TB_PREF."trans_tax_details WHERE trans_type=$type AND trans_no=$trans_no GROUP BY included_in_price";

    $result = db_query($sql);
    if ($result !== false)
        return mysqli_fetch_assoc($result);
    else
        return null;
}    
/**
*  
*/


// Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {



    function get_current_fiscal()
    {
        
         $sql="SELECT fy.begin  as begin_fy ,fy.end as end_fy FROM `".TB_PREF."sys_prefs` sp JOIN ".TB_PREF."fiscal_year fy on fy.id=sp.value where name='f_year'";
         $result=db_query($sql);
         $res = mysqli_fetch_row($result);
         return $res;
    }

    //Page header
    public function Header() {
        $fiscal_year = $this->get_current_fiscal();
        $begin_fy = date('d/m/Y',strtotime($fiscal_year[0]));
        $end_fy = date('d/m/Y',strtotime($fiscal_year[1]));

       $report_name = "Supplier Balances";
       $company_name = "WayZ ERP ";
       $period = $begin_fy." - ".date('d/m/Y');// "01/11/2018 - 30/11/2018";
       $fiscal_year = $begin_fy." - ".$end_fy." (Active)";
       $server_name = $_SERVER['SERVER_NAME'];
       $user_role ="Administrator";
       $now = date("r");




        // Logo
        $image_file = 'images/tcpdf_logo.jpg'; // *** Very IMP: make sure this image is available on given path on your server
        $this->Image($image_file,175,6,30);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        $this->SetTextColor(128,128,128);
        $this->Ln(3.5);        
        $this->Cell(67, 0, $report_name, 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $this->SetTextColor();
           // $this->Ln();
        // $this->Cell(80, 0,'aaa', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'B', 9);
        $this->Ln(12);        
        $this->Cell(23, 3," Print Out Date:" , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(50, 3,$now , 0, false, 'C', 0, '', 0, false, 'M', 'M');

        $this->SetFont('helvetica', 'B', 9);
        $this->ln();
        $this->Cell(19, 0,"Fiscal Year:", 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(56, 0,$fiscal_year , 0, false, 'C', 0, '', 0, false, 'M', 'M');

        $this->SetFont('helvetica', 'B', 9);
        $this->ln();
        $this->Cell(12, 0,"Period:" , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(59, 0,$period , 0, false, 'C', 0, '', 0, false, 'M', 'M');


        $this->SetXY(15, 20);
        $this->SetFont('helvetica', 'B', 15);
        $this->SetTextColor(128,128,128);
        $this->Cell(347, 0,$company_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetTextColor();
        $this->SetFont('helvetica', 'B', 9);
        // $this->Ln(); 


        // We need to adjust the x and y positions of this text ... first two parameters

        $this->ln(); 
        $this->Cell(355, 0,$server_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->ln(); 
        $this->Cell(362, 0,$user_role, 0, false, 'C', 0, '', 0, false, 'M', 'M');





	// $header = array(_('Trans Type'), _('#'), _('Date'), _('Due Date'), _('Charges'), _('Credits'),

	$header = array(_('Trans Type'), _('#'), _('Date'), _('Due Date'), _('Charges'), _('Credits'),
		_('Allocated'), _('Balance'));
$align = array('L', 'L', 'R', 'R','C', 'L', 'R', 'R');           

$this->Line(5, 36,206, 36);
$this->Line(5, 42,206, 42);
 $w = array(35, 15, 10, 30,35, 20, 20, 24);
        $num_headers = count($header);
         $this->Ln(5); 
        for($i = 0; $i < $num_headers; ++$i) {
            $this->Cell($w[$i], 7, $header[$i], 0, 0,$align[$i], 0);
          // $this->Cell($w[$i],0,$header[$i], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        }
        $this->Ln();
        
       
    }

    // Page footer
    public function Footer() {
        // Position at 25 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        
        $this->Cell(0, 0, '1111111111111111111111111111, Phone : +91 1122 3344 55, TIC : TESTTEST', 0, 0, 'C');
        $this->Ln();
        $this->Cell(0,0,'www.clientsite.com - T : +91 1 123 45 64 - E : info@clientsite.com', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
    
}

///////////////// End of class ////////////////////////////

//////////////////////////////////
//
//
// Create new PDF document
//
//
//////////////////////////////////
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Prem Kumar Advani');
$pdf->SetTitle('Supplier Balances');
$pdf->SetSubject('Supplier Balances');
$pdf->SetKeywords('PDF, Supplier Balances');


// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins
// $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetMargins(5, 43, 5);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
// $pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10); 
// *** Very IMP: Please use times font, so that if you send this pdf file in gmail as attachment and if user
//opens it in google document, then all the text within the pdf would be visible properly.

// add a page
$pdf->AddPage();

// create some HTML content
$now = date("r");
$company_name = 'ABC test company';

$user_name = 'Mr. Lorel Ispum';
$invoice_ref_id = '2013/12/03/0001';



$html = '';

          
$fiscal_year = $pdf->get_current_fiscal();

$html .= '<table  cellpadding="2">';
 $from = $fiscal_year[0];//"2000-11-01";//date2sql($from);
    $to = date('Y-m-d');//"2018-12-27";//date2sql($to);
   
	$sql = "SELECT supplier_id, supp_name AS name, curr_code FROM ".TB_PREF."suppliers";

	$sql .= " ORDER BY supp_name";
	$result = db_query($sql);





// $transactions = getTaxTransactions2($from, $to, $tax_id);
  $convert = 1;
  $show_balance=1;
  $no_zeros =0;
  $grandtotal = array(0,0,0,0);
  $currency = _('Balances in Home Currency');
while ($myrow = mysqli_fetch_assoc($result)) 
{
		if (!$convert && $currency != $myrow['curr_code'])
			continue;

		$accumulate = 0;
		$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], date('d/m/Y')) : 1;
		$bal = get_open_balance($myrow['supplier_id'], $from);
		$init[0] = $init[1] = 0.0;
		$init[0] = abs($bal['charges']*$rate);
		$init[1] = Abs($bal['credits']*$rate);
		$init[2] = $bal['Allocated']*$rate;

		if ($show_balance)
		{
			$init[3] = $init[0] - $init[1];
			$accumulate += $init[3];
		}	
		else	
			$init[3] = round2($bal['OutStanding']*$rate, $dec);
        // start
		$res = getTransactions($myrow['supplier_id'], date('d/m/Y',strtotime($from)),date('d/m/Y',strtotime($to)));
		if ($no_zeros && db_num_rows($res) == 0) continue;



          $html .= '   <tr> ';  
		          $html .= '<td style="width:20%;  border-bottom: 1px solid black;" align="left"><b>'.$myrow['name'].'</b></td>
		          <td style="width:6%; border-bottom: 1px solid black;" align="left"></td>     ';


		if ($convert)
		          $html .= '<td style="width:7%; border-bottom: 1px solid black;" align="left"><b>'.$myrow['curr_code'].'</b></td>';


               $html .= '
          <td style="width:13%; border-bottom: 1px solid black;" align="right">Open Balance</td>
          <td style="width:13%; border-bottom: 1px solid black;" align="center">'. number_format($init[0],2).'</td>
          <td  style="width:9%; border-bottom: 1px solid black;" align="right">'. number_format($init[1],2).'</td>
          <td style="width:11%; border-bottom: 1px solid black;"  align="right">'. number_format($init[2],2).'</td>
          <td style="width:20%; border-bottom: 1px solid black;"  align="right">'. number_format($init[3],2).'</td>

                  </tr>';

             $total = array(0,0,0,0);
		for ($i = 0; $i < 4; $i++)
		{
			$total[$i] += $init[$i];
			$grandtotal[$i] += $init[$i];
			
		}     	


			while ($trans =mysqli_fetch_assoc($res) )
		{
            if ($no_zeros && floatcmp(abs($trans['TotalAmount']), $trans['Allocated']) == 0) continue;    
            
            $html .= '   <tr> ';  

            $html .= '<td style="width:17%; " align="left">'.$systypes_array[$trans['type']].'</td>';

            $html .= '<td style="width:9%; " align="left">'.$trans['reference'].'</td>';

            $html .= '<td style="width:11%; " align="left">'.date('d/m/Y',strtotime($trans['tran_date'])).'</td>';

       		if ($trans['type'] == ST_SUPPINVOICE)
       				$html .= '<td style="width:13%; " align="left">'.date('d/m/Y',strtotime($trans['due_date'])).'</td>';
   			else
   				$html .= '<td style="width:13%; " align="left"></td>';

		    $item[0] = $item[1] = 0.0;
		    if ($trans['TotalAmount'] > 0.0)
			{
				$item[0] = abs($trans['TotalAmount']) * $rate;
				$html .= '<td>'.number_format($item[0],2).'</td>';
				$html .= '<td style="width:13%; " align="left"></td>';
				//$rep->AmountCol(4, 5, $item[0], $dec);
				$accumulate += $item[0];
				$item[2] = $trans['Allocated'] * $rate;
			}
		    else
			{
				$item[1] = abs($trans['TotalAmount']) * $rate;
					$html .= '<td style="width:13%; " align="left"></td>';
				$html .= '<td>'.number_format($item[1],2).'</td>';
				//$rep->AmountCol(5, 6, $item[1], $dec);
				$accumulate -= $item[1];
				$item[2] = ($trans['Allocated'] * $rate) * -1;
			}
		    $html .= '<td style="width:12%; ">'.number_format($item[2],2).'</td>';
		    if ($trans['TotalAmount'] > 0.0)
				$item[3] = $item[0] - $item[2];
			else	
				$item[3] = -$item[1] - $item[2];
			
			if ($show_balance)
			    $html .= '<td>'.number_format($accumulate,2).'</td>';
			else
			    $html .= '<td>'.number_format($item[3],2).'</td>';
		    
			if ($trans['type'] == ST_CUSTCREDIT || $trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKDEPOSIT)
				$trans['TotalAmount'] *= -1;

            for ($i = 0; $i < 4; $i++)
			{
				$total[$i] += $item[$i];
				$grandtotal[$i] += $item[$i];
			}
			if ($show_balance)
				$total[3] = $total[0] - $total[1];
            $html .= '</tr>';
            // for supplier invoice
            if ($show_items != 0 && $trans['type']==ST_SUPPINVOICE) {
				//$rep->Line($rep->row - 8);
				//$rep->NewLine(2);
		        
				$result2 = get_supp_invoice_items(ST_SUPPINVOICE, $trans['trans_no']);
				while ($myrow2 = db_fetch($result2)) {
                    $html .= '<tr>';
		            $html .= '<td>'.$myrow2["stock_id"].'</td>';
                    $html .= '<td>'.$myrow2["description"].'</td>';
                    $html .= '<td>'.number_format($myrow2["qty_recd"],2).'</td>';
                    $html .= '<td>'.number_format($myrow2["FullUnitPrice"],2).'</td>';
                    $html .= '<td>'.number_format($myrow2["qty_recd"]*$myrow2["FullUnitPrice"],2).'</td>';
                    
                    $html .='</tr>';
					
					//$rep->NewLine(1);
				} //end while
				// 	$rep->Line($rep->row  - 4);
				// 	$rep->NewLine(1);
				$html .='<tr></tr>';
	
			}
		
// for supplier invoice
			if ($show_items != 0 && $trans['type']==ST_SUPPCREDIT) {
				// $rep->Line($rep->row - 8);
				// $rep->NewLine(2);
			 //   $html .='<tr></tr>';
			    
				$result3 = 	 get_supp_invoice_items(ST_SUPPCREDIT, $trans['trans_no']);
				while ($myrow3 = db_fetch($result3)) {
                    $html .='<tr>';
    		            $html .= '<td>'.$myrow3["stock_id"].'</td>';
    		            $html .= '<td>'.$myrow3["description"].'</td>';
    		            $html .= '<td>'.number_format($myrow3["qty_recd"],2).'</td>';
    		            $html .= '<td>'.number_format($myrow3["FullUnitPrice"],2).'</td>';
    		            $html .= '<td>'.number_format($myrow3["qty_recd"]*$myrow3["FullUnitPrice"],2).'</td>';
                    $html .='</tr>';
					
				} //end while
					$html .='<tr></tr>';
	
			}  //end if			
			
            
         }


$html .= '         
        <tr>
            <td style="border-top: 1px solid black; border-bottom: 1px solid black;">Total</td>
            <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:32%;"  align="left" ></td>
            


            <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:14%;"  align="left" ><b> '.number_format($total[0],2).'</b></td>
             <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:13%;"  align="left" ><b> '.number_format($total[1],2).'</b></td>
             <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:11%;" align="left" ><b> '.number_format($total[2],2).'</b></td>
             <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:12%;"  align="left" ><b> '.number_format($total[3],2).'</b></td>


        </tr>';

           }  
           
 

if ($show_balance)
		$grandtotal[3] = $grandtotal[0] - $grandtotal[1];


  $html .= '         
            <tr>
            <td style="border-top: 1px solid black; border-bottom: 1px solid black;">Grand Total</td>
            <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:32%;"  align="left" ></td>
            


    <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:14%;"  align="left" ><b> '.number_format($grandtotal[0],2).'</b></td>
         <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:13%;"  align="left" ><b> '.number_format($grandtotal[1],2).'</b></td>
         <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:10%;" align="left" ><b> '.number_format($grandtotal[2],2).'</b></td>
         <td style="border-top: 1px solid black; border-bottom: 1px solid black;width:13%;"  align="left" ><b> '.number_format($grandtotal[3],2).'</b></td>


            </tr>












         </table>';





// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// reset pointer to the last page
$pdf->lastPage();

// ---------------------------------------------------------
$rep_id=201;
$rep_name='Supplier Balance';
$dir1 = "../crons_images";
$cron_pdf_path = $dir1.'/'.date('H-i-s').'='.$rep_name.'.pdf';
// ---------------------------------------------------------

// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output($cron_pdf_path, 'F',$rep_id);
// $pdf->Output($cron_pdf_path, 'I',$rep_id);

//============================================================+
// END OF FILE                                                
//============================================================+
?>
