<?php


ini_set("display_errors", 1);


require_once('tcpdf_include.php');
require_once('../includes/types.inc');
require_once('../includes/manufacturing_db.inc');
require_once('../db_connection.inc');


function getTransactions($category, $location, $item_like)
{
  $sql = "SELECT item.category_id,
			category.description AS cat_description,
			item.stock_id, item.units,
			item.description, item.inactive,
			IF(move.stock_id IS NULL, '', move.loc_code) AS loc_code,
			SUM(IF(move.stock_id IS NULL,0,move.qty)) AS QtyOnHand
		FROM ("
			.TB_PREF."stock_master item,"
			.TB_PREF."stock_category category)
			LEFT JOIN ".TB_PREF."stock_moves move ON item.stock_id=move.stock_id
		WHERE item.category_id=category.category_id
		AND (item.mb_flag='B' OR item.mb_flag='M')";
	if ($category != 0)
		$sql .= " AND item.category_id = '".$category."'";
	if ($location != 'all')
		$sql .= " AND IF(move.stock_id IS NULL, '1=1',move.loc_code = '".$location."')";
  if($item_like)
  {
    $regexp = null;

    if(sscanf($item_like, "/%s", $regexp)==1)
      $sql .= " AND item.stock_id RLIKE '".$regexp."'";
    else
      $sql .= " AND item.stock_id LIKE '".$item_like."'";
  }
	$sql .= " GROUP BY item.category_id,
		category.description,
		item.stock_id,
		item.description
		ORDER BY item.category_id,
		item.stock_id";



    return db_query($sql);
       
   
}
  
/**
*  
*/


// Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {



    function get_current_fiscal()
    {
     
         $sql="SELECT fy.begin  as begin_fy ,fy.end as end_fy FROM `".TB_PREF."sys_prefs` sp JOIN ".TB_PREF."fiscal_year fy on fy.id=sp.value where name='f_year'";
         $result=db_query($sql);
         $res = mysqli_fetch_row($result);
         return $res;
    }

    //Page header
    public function Header() {
        $fiscal_year = $this->get_current_fiscal();
        $begin_fy = date('d/m/Y',strtotime($fiscal_year[0]));
        $end_fy = date('d/m/Y',strtotime($fiscal_year[1]));

       $report_name = "Stock Check Sheets";
       $company_name = "WayZ ERP ";
       $period = $begin_fy." - ".date('d/m/Y');// "01/11/2018 - 30/11/2018";
       $fiscal_year = $begin_fy." - ".$end_fy." (Active)";
       $server_name = $_SERVER['SERVER_NAME'];
       $user_role ="Administrator";
       $now = date("r");




        // Logo
        $image_file = 'images/tcpdf_logo.jpg'; // *** Very IMP: make sure this image is available on given path on your server
        $this->Image($image_file,175,6,30);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        $this->SetTextColor(128,128,128);
        $this->Ln(3.5);        
        $this->Cell(70, 0, $report_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetTextColor();
           // $this->Ln();
        // $this->Cell(80, 0,'aaa', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'B', 9);
        $this->Ln(12);        
        $this->Cell(23, 3," Print Out Date:" , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(50, 3,$now , 0, false, 'C', 0, '', 0, false, 'M', 'M');

        $this->SetFont('helvetica', 'B', 9);
        $this->ln();
        $this->Cell(19, 0,"Fiscal Year:", 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(56, 0,$fiscal_year , 0, false, 'C', 0, '', 0, false, 'M', 'M');

        $this->SetFont('helvetica', 'B', 9);
        $this->ln();
        $this->Cell(12, 0,"Period:" , 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetFont('helvetica', 'C', 9);
        $this->Cell(59, 0,$period , 0, false, 'C', 0, '', 0, false, 'M', 'M');


        $this->SetXY(15, 20);
        $this->SetFont('helvetica', 'B', 15);
        $this->SetTextColor(128,128,128);
        $this->Cell(347, 0,$company_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->SetTextColor();
        $this->SetFont('helvetica', 'B', 9);
        // $this->Ln(); 


        // We need to adjust the x and y positions of this text ... first two parameters

        $this->ln(); 
        $this->Cell(355, 0,$server_name, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->ln(); 
        $this->Cell(362, 0,$user_role, 0, false, 'C', 0, '', 0, false, 'M', 'M');




// filter
$shortage =1;
if ($shortage)
  {
    $short = _('Yes');
    $available = _('Shortage');
  }
  else
  {
    $short = _('No');
    $available = _('Available');
  }

  
$header = array(_('Stock ID'), _('Description'), _('UOM'), _('Quantity'), _('Demand'), $available, _('On Order'));

$align = array('L', 'L', 'L', 'R', 'R', 'R', 'R');           

$this->Line(5, 36,206, 36);
$this->Line(5, 42,206, 42);
 $w = array(20, 50, 15, 20,30,30,35);
        $num_headers = count($header);
         $this->Ln(5); 
        for($i = 0; $i < $num_headers; ++$i) {
            $this->Cell($w[$i], 7, $header[$i], 0, 0,$align[$i], 0);
          
        }
        $this->Ln();
        
       
    }

    // Page footer
    public function Footer() {
        // Position at 25 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        
        $this->Cell(0, 0, 'Product Company - ABC test company, Phone : +91 1122 3344 55, TIC : TESTTEST', 0, 0, 'C');
        $this->Ln();
        $this->Cell(0,0,'www.clientsite.com - T : +91 1 123 45 64 - E : info@clientsite.com', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
    
}

///////////////// End of class ////////////////////////////

//////////////////////////////////
//
//
// Create new PDF document
//
//
//////////////////////////////////
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Syed Zohaib Ali Alvi');
$pdf->SetTitle('Stock Check Sheets');
$pdf->SetSubject('Stock Check Sheets');
$pdf->SetKeywords('PDF, Stock Check Sheets');


// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins
// $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetMargins(5, 43, 5);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
// $pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10); 
// *** Very IMP: Please use times font, so that if you send this pdf file in gmail as attachment and if user
//opens it in google document, then all the text within the pdf would be visible properly.

// add a page
$pdf->AddPage();

// create some HTML content
$now = date("r");
$company_name = 'ABC test company';

$user_name = 'Mr. Lorel Ispum';
$invoice_ref_id = '2013/12/03/0001';

$html = '';

$fiscal_year = $pdf->get_current_fiscal();

$html .= '<table  cellpadding="2" >';
 $from = $fiscal_year[0];
    $to = date('Y-m-d');
// filter
 $category=0; 
 $location='all'; 
 $like="";
 $no_zeros=0;
$shortage=1;

 
 $catt = '';

$transactions = getTransactions($category, $location, $like);
  

while ($trans = mysqli_fetch_assoc($transactions)) 
{
        
        	if ($location == 'all')
			$loc_code = "";
		else
			$loc_code = $location;
        $demandqty = get_demand_qty($trans['stock_id'], $loc_code);
		$demandqty += get_demand_asm_qty($trans['stock_id'], $loc_code);
		$onorder = get_on_porder_qty($trans['stock_id'], $loc_code);
		$flag = get_mb_flag($trans['stock_id']);
		if ($flag == 'M')
			$onorder += get_on_worder_qty($trans['stock_id'], $loc_code);
		if ($no_zeros && $trans['QtyOnHand'] == 0 && $demandqty == 0 && $onorder == 0)
			continue;
		if ($shortage && $trans['QtyOnHand'] - $demandqty >= 0)
			continue;
         
         if ($catt != $trans['cat_description'])
		{
		 $html .= '   <tr> ';
      $html .='<td style="width:10%;" align="left">'.$trans['category_id'].'</td>';
        $html .='<td style="width:25%;" align="left">'.$trans['cat_description'].'</td>';
			$catt = $trans['cat_description'];
			$html .="<br>";
		 $html .= '   </tr> ';	
		}
  
          $html .= '   <tr > ';
            $html .='<td style="width:10%;" align="left">'.$trans['stock_id'].'</td>';
            $html .='<td style="width:25%;" align="left">'.$trans['description'].($trans['inactive']==1 ? " ("._("Inactive").")" : "").'</td>';
            $html .='<td style="width:10%;" align="left">'.$trans['units'].'</td>';
            $html .='<td style="width:15%;" align="left">'.number_format($trans['QtyOnHand'],2).'</td>';
            $html .='<td style="width:15%;" align="left">'.number_format($demandqty,2).'</td>';
            $html .='<td style="width:10%;" align="left">'.number_format($trans['QtyOnHand'] - $demandqty,2).'</td>';
            $html .='<td style="width:15%;" align="right">'.number_format($onorder,2).'</td>';
              
           $html .= '   </tr> ';
         
         


      

        }  
           
   

  $html .= '         
           
         </table>';


// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// reset pointer to the last page
$pdf->lastPage();

// ---------------------------------------------------------
$rep_id=303;
$rep_name='Stock Check Sheets';
$dir1 = "../crons_images";
$cron_pdf_path = $dir1.'/'.date('H-i-s').'='.$rep_name.'.pdf';
// ---------------------------------------------------------

// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output($cron_pdf_path, 'F',$rep_id);
$pdf->Output($cron_pdf_path, 'I',$rep_id);

//============================================================+
// END OF FILE                                                
//============================================================+
?>
