<?php
$bom_list = array(); 
$qoh_stock = NULL;
function get_demand_qty($stock_id, $location)
{
	$sql = "SELECT SUM(line.quantity - line.qty_sent) AS QtyDemand
			FROM ".TB_PREF."sales_order_details line,
				".TB_PREF."sales_orders sorder
				WHERE line.order_no=sorder.order_no AND sorder.trans_type=".ST_SALESORDER
				." AND sorder.trans_type=line.trans_type"
				." AND line.stk_code = '".$stock_id."'";
	if ($location != "")
		$sql .= " AND sorder.from_stk_loc ='".$location."'";

    $result = db_query($sql);
	$row = mysqli_fetch_assoc($result);
	if ($row === false)
		return 0;
	return $row['QtyDemand'];
}
function get_demand_asm_qty($stock_id, $location) 
{
	$demand_qty = 0.0;
	$sql = "SELECT line.stk_code, SUM(line.quantity-line.qty_sent) AS Demmand
		   FROM ".TB_PREF."sales_order_details line,
				".TB_PREF."sales_orders sorder,
				".TB_PREF."stock_master item
		   WHERE sorder.order_no = line.order_no
		   		AND sorder.trans_type=".ST_SALESORDER
		   	 ." AND sorder.trans_type=line.trans_type
				AND line.quantity-line.qty_sent > 0
				AND item.stock_id=line.stk_code
				AND item.mb_flag='M'";
	if ($location != "")
		$sql .= " AND sorder.from_stk_loc ='".$location."'";
	$sql .= " GROUP BY line.stk_code";
    $result = db_query($sql);
	while ($row = mysqli_fetch_row($result)) {
		$demand_qty += stock_demand_manufacture($row[0], $row[1], $stock_id, $location);
	}
	return $demand_qty;
}
function stock_demand_manufacture($stock_id, $qty, $demand_id, $location, $level=0) 
{
	global $bom_list, $qoh_stock;

	$demand = 0.0;
	if ($level > 10) {
		display_warning("BOM Too many Manufacturing levels deep $level");
		return $demand;
	}
	// Load all stock levels (stock moves) into $qoh_stock
	if ($qoh_stock == NULL)
		$qoh_stock = load_stock_levels($location);

	if (empty($qoh_stock[$stock_id]))
		$stock_qty = 0;
	else
		$stock_qty = $qoh_stock[$stock_id];

	if ($qty <= $stock_qty)
		return $demand;
	$bom = @$bom_list[$stock_id];
	if ($bom == NULL) {
		$sql = "SELECT parent, component, quantity FROM "
			.TB_PREF."bom WHERE parent = '".$stock_id."'";
		if ($location != "") $sql .= " AND loc_code = '".$location."'";
		$result = db_query($sql);
		$bom = array();
		// Even if we get no results, remember that fact 
		$bom[] = array($stock_id, '', 0); 
		while ($row = mysqli_fetch_row($result)) {
			$bom[] = array($row[0], $row[1], $row[2]);
		}
		mysqli_free_result($result);
		$bom_list[$stock_id] = $bom;
	}
	$len = count($bom);
	$i = 0;
	while ($i < $len) {
		$row = $bom[$i];
		$i++; 
		// Ignore the dummy entry
		if ($row[1] == '') continue;
		$q = $qty * $row[2];
		if ($row[1] == $demand_id) $demand += $q;
		$demand += stock_demand_manufacture($row[1], $q, $demand_id, $location, $level+1);
	}
	return $demand;
}
function load_stock_levels($location)
{
	$date = Date('Y-m-d');

	$qoh_stock = array();
	$sql = "SELECT stock_id, SUM(qty)
		FROM ".TB_PREF."stock_moves
		WHERE tran_date <= '$date'";
	if ($location != '')
		$sql .= " AND loc_code = '".$location."'";
	$sql .= " GROUP BY stock_id";

	$result = db_query($sql);
	while ($row = mysqli_fetch_row($result))
		$qoh_stock[$row[0]] = $row[1];

	return $qoh_stock;
}
function get_on_porder_qty($stock_id, $location)
{
	$sql = "SELECT SUM(line.quantity_ordered - line.quantity_received) AS qoo
		FROM ".TB_PREF."purch_order_details line 
			INNER JOIN ".TB_PREF."purch_orders po ON line.order_no=po.order_no
		WHERE line.item_code='".$stock_id."'";
	if ($location != "")
		$sql .= " AND po.into_stock_location='".$location."'";
	$sql .= " AND line.item_code='".$stock_id."'";
	$qoo_result = db_query($sql);

	if (mysqli_num_rows($qoo_result) == 1)
	{
		$qoo_row = mysqli_fetch_row($qoo_result);
		$qoo =  $qoo_row[0];
	}
	else
	{
		$qoo = 0;
	}
	return $qoo;
}

function get_on_worder_qty($stock_id, $location)
{
	$sql = "SELECT SUM((wo.units_reqd-wo.units_issued) * (req.units_req-req.units_issued)) AS qoo
		FROM ".TB_PREF."wo_requirements req
			INNER JOIN ".TB_PREF."workorders wo	ON req.workorder_id=wo.id
		WHERE req.stock_id='".$stock_id."'
		AND wo.released=1";
	if ($location != "")
		$sql .= " AND req.loc_code='".$location."'";

	$qoo_result = db_query($sql);
	if (mysqli_num_rows($qoo_result) == 1)
	{
		$qoo_row = mysqli_fetch_row($qoo_result);
		$qoo =  $qoo_row[0];
	}
	else
		$qoo = 0.0;
	$flag = get_mb_flag($stock_id);
	if ($flag == 'M')
	{
		$sql = "SELECT SUM((units_reqd-units_issued)) AS qoo
			FROM ".TB_PREF."workorders
			WHERE stock_id='".$stock_id."'
			AND released=1";

		if ($location != "")
			$sql .= " AND loc_code='".$location."'";

		$qoo_result = db_query($sql);
		if (mysqli_num_rows($qoo_result) == 1)
		{
			$qoo_row = mysqli_fetch_row($qoo_result);
			$qoo +=  $qoo_row[0];
		}
	}
	return $qoo;
}
function get_mb_flag($stock_id)
{
	$sql = "SELECT mb_flag FROM ".TB_PREF."stock_master
		WHERE stock_id = '".$stock_id."'";
	$result = db_query($sql);
	
	if (mysqli_num_rows($result) == 0)
		return -1;

	$myrow = mysqli_fetch_row($result);
	return $myrow[0];
}

?>