# MySQL dump of database 'bindhahiwayzerp_mrxpert' on host 'localhost'
# Backup Date and Time: 2024-01-18 10:01
# Built by Wayz Consulting 2.4.3
# http://frontaccounting.com
# Company: Mr Xperts
# User: Company Admin

# Compatibility: 2.4.1

# Comment:
# Backup Before Delete and Re-Importing The Items


SET NAMES utf8;


### Structure of table `0_agreement_pricing` ###

DROP TABLE IF EXISTS `0_agreement_pricing`;

CREATE TABLE `0_agreement_pricing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(500) NOT NULL,
  `payment_terms` varchar(100) NOT NULL,
  `price` int(20) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreement_pricing` ###


### Structure of table `0_agreements` ###

DROP TABLE IF EXISTS `0_agreements`;

CREATE TABLE `0_agreements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `dates` date NOT NULL,
  `provider` varchar(150) NOT NULL,
  `provider_representative` varchar(150) NOT NULL,
  `provider_email` varchar(150) NOT NULL,
  `provider_address` varchar(150) NOT NULL,
  `provider_desgination` varchar(150) NOT NULL,
  `client` varchar(150) NOT NULL,
  `client_representative` varchar(150) NOT NULL,
  `client_email` varchar(150) NOT NULL,
  `client_address` varchar(150) NOT NULL,
  `client_designation` varchar(150) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  `reference` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements` ###


### Structure of table `0_agreements_matters` ###

DROP TABLE IF EXISTS `0_agreements_matters`;

CREATE TABLE `0_agreements_matters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agreement_no` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `agreement_matter` mediumtext NOT NULL,
  `template` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements_matters` ###


### Structure of table `0_agreements_modules` ###

DROP TABLE IF EXISTS `0_agreements_modules`;

CREATE TABLE `0_agreements_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) NOT NULL,
  `sections` text NOT NULL,
  `areas` text NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements_modules` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('5', 'Dubai', '0'),
('6', 'Sharjah', '0'),
('7', 'Ras Al Khaima', '0'),
('8', 'Umm Al Quwain', '0'),
('9', 'Default', '0'),
('10', 'Abu Dhabi', '0'),
('11', 'Fujairah', '0'),
('12', 'Ajman', '0');

### Structure of table `0_attach_inquiry` ###

DROP TABLE IF EXISTS `0_attach_inquiry`;

CREATE TABLE `0_attach_inquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `by_user` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted` tinyint(1) NOT NULL,
  `edited` int(11) NOT NULL,
  `notes` text NOT NULL,
  `flagged` tinyint(1) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_attach_inquiry` ###


### Structure of table `0_attach_inquiry_detail` ###

DROP TABLE IF EXISTS `0_attach_inquiry_detail`;

CREATE TABLE `0_attach_inquiry_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `short_description` varchar(200) NOT NULL,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  `attach_id` int(11) NOT NULL,
  `note` text NOT NULL,
  `flagged` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attach_inquiry_detail` ###


### Structure of table `0_attach_inquiry_link_detail` ###

DROP TABLE IF EXISTS `0_attach_inquiry_link_detail`;

CREATE TABLE `0_attach_inquiry_link_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL,
  `trans_type` int(11) NOT NULL,
  `attach_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_attach_inquiry_link_detail` ###


### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `short_description` varchar(200) NOT NULL,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_attendance` ###

DROP TABLE IF EXISTS `0_attendance`;

CREATE TABLE `0_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `overtime_id` int(11) NOT NULL,
  `hours_no` float NOT NULL DEFAULT 0,
  `rate` float NOT NULL DEFAULT 1,
  `att_date` date NOT NULL,
  `is_leave` int(1) NOT NULL,
  `from_leave` date NOT NULL,
  `to_leave` date NOT NULL,
  `reason` varchar(255) NOT NULL,
  `time` varchar(70) NOT NULL,
  `time_out` varchar(50) NOT NULL,
  `in_out` int(11) NOT NULL,
  `leave_type` int(11) NOT NULL,
  `approved` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attendance` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  `notification_status` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=687 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '1028', '1', '25', '2024-01-12 10:31:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('2', '1028', '2', '25', '2024-01-12 22:29:59', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('3', '1028', '1067', '25', '2024-01-12 10:32:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('4', '1028', '12', '25', '2024-01-12 10:32:58', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('5', '1028', '1205', '25', '2024-01-12 10:33:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('6', '1028', '980', '25', '2024-01-12 10:33:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('7', '1028', '1520', '25', '2024-01-12 10:33:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('8', '1028', '1540', '25', '2024-01-12 10:34:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('9', '1028', '1550', '25', '2024-01-12 10:34:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('10', '1028', '1820', '25', '2024-01-12 10:34:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('11', '1028', '1821', '25', '2024-01-12 10:34:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('12', '1028', '1830', '25', '2024-01-12 10:34:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('13', '1028', '1840', '25', '2024-01-12 10:35:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('14', '1028', '1850', '25', '2024-01-12 10:35:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('15', '1028', '2101', '25', '2024-01-12 10:35:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('16', '1028', '2110', '25', '2024-01-12 10:35:43', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('17', '1028', '2120', '25', '2024-01-12 10:35:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('18', '1028', '2130', '25', '2024-01-12 10:36:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('19', '1028', '2140', '25', '2024-01-12 10:36:11', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('20', '1028', '2160', '25', '2024-01-12 10:36:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('21', '1028', '2210', '25', '2024-01-12 10:36:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('22', '1028', '2230', '25', '2024-01-12 10:36:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('23', '1028', '2240', '25', '2024-01-12 10:36:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('24', '1028', '2320', '25', '2024-01-12 10:37:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('25', '1028', '2340', '25', '2024-01-12 10:37:22', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('26', '1028', '2350', '25', '2024-01-12 10:37:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('27', '1028', '2360', '25', '2024-01-12 10:37:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('28', '1028', '2380', '25', '2024-01-12 10:37:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('29', '1028', '2680', '25', '2024-01-12 10:38:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('30', '1028', '2620', '25', '2024-01-12 10:38:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('31', '1028', '3580', '25', '2024-01-12 10:38:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('32', '1028', '2040', '25', '2024-01-12 10:39:09', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('33', '1028', '2031', '25', '2024-01-12 10:39:28', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('34', '1028', '2032', '25', '2024-01-12 10:39:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('35', '1028', '2033', '25', '2024-01-12 10:39:55', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('36', '1028', '4011', '25', '2024-01-12 10:40:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('37', '1028', '4012', '25', '2024-01-12 10:40:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('38', '1028', '4440', '25', '2024-01-12 10:40:45', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('39', '1028', '10002', '25', '2024-01-12 10:41:13', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('40', '1028', '5440', '25', '2024-01-12 10:41:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('41', '1028', '5450', '25', '2024-01-12 10:42:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('42', '1028', '5460', '25', '2024-01-12 10:42:11', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('43', '1028', '5470', '25', '2024-01-12 10:42:23', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('44', '1028', '5510', '25', '2024-01-12 10:42:40', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('45', '1028', '5520', '25', '2024-01-12 10:42:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('46', '1028', '5530', '25', '2024-01-12 10:43:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('47', '1028', '5540', '25', '2024-01-12 10:43:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('48', '1028', '5550', '25', '2024-01-12 10:43:19', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('49', '1028', '5560', '25', '2024-01-12 10:43:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('50', '1028', '5410', '25', '2024-01-12 10:43:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('51', '1028', '5610', '25', '2024-01-12 10:43:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('52', '1028', '5615', '25', '2024-01-12 10:44:24', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('53', '1028', '5616', '25', '2024-01-12 10:44:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('54', '1028', '5617', '25', '2024-01-12 10:44:37', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('55', '1028', '5618', '25', '2024-01-12 10:44:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('56', '1028', '5619', '25', '2024-01-12 10:44:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('57', '1028', '5700', '25', '2024-01-12 10:45:07', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('58', '1028', '5760', '25', '2024-01-12 10:45:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('59', '1028', '5785', '25', '2024-01-12 10:45:33', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('60', '1028', '5790', '25', '2024-01-12 10:45:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('61', '1028', '5795', '25', '2024-01-12 10:45:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('62', '1028', '5800', '25', '2024-01-12 10:46:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('63', '1028', '5810', '25', '2024-01-12 10:46:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('64', '1028', '5820', '25', '2024-01-12 10:46:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('65', '1028', '10001', '25', '2024-01-12 10:46:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('66', '1028', '5425', '25', '2024-01-12 20:29:16', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('67', '1028', '5426', '25', '2024-01-12 20:30:30', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('68', '1028', '5428', '25', '2024-01-12 10:48:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('69', '1028', '5430', '25', '2024-01-12 10:49:17', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('70', '1028', '1913', '25', '2024-01-12 10:49:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('71', '1028', '1915', '25', '2024-01-12 20:26:54', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('72', '1028', '1880', '25', '2024-01-12 10:50:15', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('73', '1028', '1882', '25', '2024-01-12 10:50:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('74', '1028', '1883', '25', '2024-01-12 10:50:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('75', '1028', '1884', '25', '2024-01-12 10:50:49', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('76', '1028', '1885', '25', '2024-01-12 10:51:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('77', '1028', '1887', '25', '2024-01-12 10:51:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('78', '1028', '1889', '25', '2024-01-12 10:52:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('79', '1028', '1890', '25', '2024-01-12 10:52:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('80', '1028', '1891', '25', '2024-01-12 10:53:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('81', '1028', '1892', '25', '2024-01-12 10:53:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('82', '1028', '1893', '25', '2024-01-12 10:54:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('83', '1028', '1894', '25', '2024-01-12 10:54:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('84', '1028', '1895', '25', '2024-01-12 10:54:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('85', '1028', '1896', '25', '2024-01-12 10:54:52', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('86', '1028', '1898', '25', '2024-01-12 10:54:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('87', '1028', '1899', '25', '2024-01-12 10:55:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('88', '1028', '1900', '25', '2024-01-12 10:55:05', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('89', '1028', '1901', '25', '2024-01-12 10:58:13', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('90', '1028', '1902', '25', '2024-01-12 10:58:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('91', '1028', '1903', '25', '2024-01-12 10:58:19', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('92', '1028', '1904', '25', '2024-01-12 10:58:21', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('93', '1028', '1906', '25', '2024-01-12 10:58:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('94', '1028', '1907', '25', '2024-01-12 10:58:34', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('95', '1028', '1908', '25', '2024-01-12 10:58:38', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('96', '1028', '1909', '25', '2024-01-12 10:58:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('97', '1028', '1910', '25', '2024-01-12 10:58:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('98', '1028', '1911', '25', '2024-01-12 10:58:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('99', '1028', '1912', '25', '2024-01-12 10:59:01', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('100', '1028', '1920', '25', '2024-01-12 11:00:38', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('101', '1028', '1921', '25', '2024-01-12 11:00:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('102', '1028', '1922', '25', '2024-01-12 11:00:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('103', '1028', '1923', '25', '2024-01-12 11:00:52', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('104', '1028', '1924', '25', '2024-01-12 11:00:55', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('105', '1028', '1926', '25', '2024-01-12 11:00:58', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('106', '1028', '1925', '25', '2024-01-12 11:01:02', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('107', '1028', '1927', '25', '2024-01-12 11:01:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('108', '1028', '1928', '25', '2024-01-12 11:01:09', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('109', '1028', '1929', '25', '2024-01-12 11:01:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('110', '1028', '5422', '25', '2024-01-12 20:28:02', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('111', '1028', '5561', '25', '2024-01-12 11:01:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('112', '1028', '5620', '25', '2024-01-12 11:01:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('113', '1028', '5685', '25', '2024-01-12 11:01:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('114', '1028', '5765', '25', '2024-01-12 11:02:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('115', '1028', '1801', '25', '2024-01-12 11:02:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('116', '1028', '3350', '25', '2024-01-12 11:02:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('117', '1028', '3581', '25', '2024-01-12 11:02:57', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('118', '1028', '2021', '25', '2024-01-12 11:03:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('119', '1028', '2023', '25', '2024-01-12 11:03:26', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('120', '1028', '5020', '25', '2024-01-12 20:40:55', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('121', '1028', '5030', '25', '2024-01-12 20:49:14', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('122', '1028', '5050', '25', '2024-01-12 20:50:41', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('123', '1028', '5100', '25', '2024-01-12 11:07:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('124', '1028', '1236', '25', '2024-01-12 11:07:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('125', '1028', '1234', '25', '2024-01-12 11:07:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('126', '1028', '1235', '25', '2024-01-12 11:07:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('127', '1028', '901', '25', '2024-01-12 11:08:08', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('128', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('129', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('130', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('131', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('132', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('133', '1028', '1065', '25', '2024-01-12 12:09:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('134', '1028', '1066', '25', '2024-01-12 12:10:01', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('135', '1028', '960', '25', '2024-01-12 12:11:39', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('136', '1028', '960', '25', '2024-01-12 23:37:43', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('137', '1029', '2', '1', '2024-01-12 14:24:33', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('138', '1029', '2', '1', '2024-01-12 23:22:29', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('139', '1029', '15', '1', '2024-01-12 14:25:32', 'Bank Account Deleted', '13', '2024-01-12', '0', '0', '0'),
('140', '1029', '14', '1', '2024-01-12 14:25:35', 'Bank Account Deleted', '13', '2024-01-12', '0', '0', '0'),
('141', '1029', '9', '1', '2024-01-12 14:25:58', 'Account Type Updated', '13', '2024-01-12', '0', '0', '0'),
('142', '1028', '1905', '1', '2024-01-12 16:06:05', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('143', '1028', '5660', '1', '2024-01-12 19:17:31', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('144', '1028', '5040', '1', '2024-01-12 16:09:19', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('145', '1029', '21', '1', '2024-01-12 16:16:37', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('146', '1028', '210101', '1', '2024-01-12 16:15:52', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('147', '1028', '5780', '1', '2024-01-12 16:15:36', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('148', '1028', '5780', '1', '2024-01-12 16:15:36', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('149', '1028', '210101', '1', '2024-01-12 16:15:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('150', '1029', '21', '1', '2024-01-13 00:27:34', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('151', '1028', '9990', '1', '2024-01-12 16:18:28', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('152', '1028', '21001', '1', '2024-01-12 16:20:36', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('153', '1028', '21002', '1', '2024-01-12 16:21:20', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('154', '1028', '21003', '1', '2024-01-13 00:27:00', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('155', '1028', '21004', '1', '2024-01-12 16:23:06', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('156', '1028', '21005', '1', '2024-01-12 20:20:52', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('157', '1028', '21006', '1', '2024-01-13 00:25:35', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('158', '1028', '21007', '1', '2024-01-12 16:25:10', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('159', '1028', '21008', '1', '2024-01-13 00:24:04', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('160', '1028', '21009', '1', '2024-01-12 16:51:50', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('161', '1028', '21010', '1', '2024-01-12 16:52:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('162', '1028', '21011', '1', '2024-01-13 00:34:24', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('163', '1028', '21012', '1', '2024-01-13 00:12:46', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('164', '1028', '21013', '1', '2024-01-12 19:00:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('165', '1028', '21014', '1', '2024-01-12 19:14:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('166', '1028', '21015', '1', '2024-01-12 19:14:53', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('167', '1028', '21016', '1', '2024-01-16 10:29:23', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('168', '1028', '21017', '1', '2024-01-12 19:16:31', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('169', '1028', '21018', '1', '2024-01-12 19:17:15', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('170', '1028', '5660', '1', '2024-01-12 19:17:31', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('171', '1028', '21019', '1', '2024-01-12 19:18:08', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('172', '1028', '21020', '1', '2024-01-12 20:08:43', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('173', '1028', '21021', '1', '2024-01-12 20:10:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('174', '1028', '21022', '1', '2024-01-13 00:36:31', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('175', '1028', '21023', '1', '2024-01-12 20:14:31', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('176', '1028', '21024', '1', '2024-01-12 20:17:44', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('177', '1028', '21025', '1', '2024-01-12 20:18:07', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('178', '1028', '21026', '1', '2024-01-12 20:18:41', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('179', '1028', '21027', '1', '2024-01-12 20:19:19', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('180', '1028', '21005', '1', '2024-01-12 20:20:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('181', '1028', '21028', '1', '2024-01-12 20:21:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('182', '1028', '21029', '1', '2024-01-12 20:22:02', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('183', '1028', '21030', '1', '2024-01-17 10:04:41', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('184', '1028', '21031', '1', '2024-01-17 10:04:26', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('185', '1028', '21032', '1', '2024-01-12 20:24:27', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('186', '1028', '21033', '1', '2024-01-12 20:24:57', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('187', '1028', '21034', '1', '2024-01-17 10:08:15', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('188', '1028', '1915', '1', '2024-01-12 20:26:54', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('189', '1028', '5422', '1', '2024-01-12 20:28:02', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('190', '1028', '5425', '1', '2024-01-12 20:29:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('191', '1028', '5426', '1', '2024-01-12 20:30:30', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('192', '1028', '5421', '1', '2024-01-12 20:31:17', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('193', '1028', '21035', '1', '2024-01-12 20:32:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('194', '1028', '4500', '1', '2024-01-12 20:34:05', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('195', '1028', '5060', '1', '2024-01-12 20:37:39', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('196', '1028', '5020', '1', '2024-01-12 20:40:55', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('197', '1028', '5030', '1', '2024-01-12 20:49:14', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('198', '1028', '5050', '1', '2024-01-12 20:50:41', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('199', '1028', '5070', '1', '2024-01-12 20:51:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('200', '1028', '4009', '1', '2024-01-12 20:51:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('201', '1028', '4430', '1', '2024-01-12 22:16:38', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('202', '1028', '4010', '1', '2024-01-12 22:17:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('203', '1028', '2034', '1', '2024-01-12 22:21:03', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('204', '1030', '10', '1', '2024-01-12 22:25:27', 'Account Class Added', '13', '2024-01-12', '0', '0', '0'),
('205', '1029', '24', '1', '2024-01-12 22:33:23', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('206', '1028', '2', '1', '2024-01-12 22:29:59', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('207', '1028', '20001', '1', '2024-01-12 22:30:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('208', '1029', '24', '1', '2024-01-12 22:40:05', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('209', '1028', '24001', '1', '2024-01-12 22:35:25', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('210', '1028', '24002', '1', '2024-01-12 22:36:07', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('211', '1028', '24003', '1', '2024-01-12 22:36:42', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('212', '1028', '24004', '1', '2024-01-12 22:37:19', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('213', '1028', '24005', '1', '2024-01-12 22:37:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('214', '1028', '24006', '1', '2024-01-12 22:38:26', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('215', '1029', '24', '1', '2024-01-12 22:49:56', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('216', '1028', '24007', '1', '2024-01-12 22:41:00', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('217', '1028', '24008', '1', '2024-01-12 22:41:48', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('218', '1028', '24009', '1', '2024-01-12 22:42:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('219', '1028', '24010', '1', '2024-01-12 22:43:35', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('220', '1029', '24', '1', '2024-01-12 22:50:41', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('221', '1029', '24', '1', '2024-01-12 22:50:54', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('222', '1029', '24', '1', '2024-01-12 22:51:03', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('223', '1029', '24', '1', '2024-01-12 22:51:12', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('224', '1029', '24', '1', '2024-01-12 23:21:43', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('225', '1028', '3', '1', '2024-01-12 22:52:22', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('226', '1009', '97', '1', '2024-01-15 15:37:31', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('227', '1009', '98', '1', '2024-01-15 15:37:49', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('228', '1028', '24012', '1', '2024-01-12 22:58:15', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('229', '1009', '132', '1', '2024-01-15 15:38:03', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('230', '1009', '99', '1', '2024-01-15 15:38:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('231', '1009', '100', '1', '2024-01-16 10:53:53', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('232', '1028', '24013', '1', '2024-01-12 23:01:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('233', '1009', '101', '1', '2024-01-16 10:57:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('234', '1028', '24014', '1', '2024-01-12 23:03:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('235', '1009', '102', '1', '2024-01-16 10:57:33', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('236', '1028', '24015', '1', '2024-01-12 23:05:20', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('237', '1009', '94', '1', '2024-01-16 10:57:53', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('238', '1028', '24016', '1', '2024-01-12 23:07:23', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('239', '1028', '24017', '1', '2024-01-12 23:07:55', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('240', '1028', '24018', '1', '2024-01-12 23:08:28', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('241', '1009', '103', '1', '2024-01-16 10:58:09', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('242', '1009', '104', '1', '2024-01-16 10:58:35', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('243', '1009', '105', '1', '2024-01-16 10:59:00', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('244', '1028', '24019', '1', '2024-01-12 23:11:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('245', '1009', '106', '1', '2024-01-16 10:59:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('246', '1028', '24021', '1', '2024-01-12 23:13:08', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('247', '1009', '107', '1', '2024-01-16 10:59:30', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('248', '1028', '24022', '1', '2024-01-12 23:14:35', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('249', '1009', '108', '1', '2024-01-16 10:59:51', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('250', '1028', '24023', '1', '2024-01-12 23:15:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('251', '1009', '109', '1', '2024-01-16 11:00:08', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('252', '1028', '24025', '1', '2024-01-12 23:19:39', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('253', '1028', '24026', '1', '2024-01-12 23:20:39', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('254', '1029', '24', '1', '2024-01-12 23:23:19', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('255', '1029', '2', '1', '2024-01-12 23:22:29', 'Account Type Updated', '13', '2024-01-12', '0', '0', '0'),
('256', '1029', '24', '1', '2024-01-12 23:24:52', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('257', '1029', '24', '1', '2024-01-12 23:25:32', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('258', '1029', '24', '1', '2024-01-12 23:52:19', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('259', '1028', '24027', '1', '2024-01-12 23:26:44', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('260', '1028', '24028', '1', '2024-01-12 23:27:25', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('261', '1028', '24029', '1', '2024-01-12 23:28:26', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('262', '1028', '24030', '1', '2024-01-12 23:29:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('263', '1028', '24031', '1', '2024-01-12 23:30:18', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('264', '1028', '24032', '1', '2024-01-12 23:31:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('265', '1028', '24033', '1', '2024-01-12 23:31:51', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('266', '1028', '24034', '1', '2024-01-12 23:32:22', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('267', '1028', '24035', '1', '2024-01-12 23:32:49', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('268', '1028', '24036', '1', '2024-01-12 23:33:12', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('269', '1028', '24037', '1', '2024-01-12 23:36:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('270', '1028', '24038', '1', '2024-01-12 23:37:12', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('271', '1028', '960', '1', '2024-01-12 23:37:43', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('272', '1028', '970', '1', '2024-01-12 23:37:49', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('273', '1028', '4450', '1', '2024-01-12 23:41:46', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('274', '114', '1', '1', '2024-01-12 23:48:22', 'Account Tag Added', '13', '2024-01-12', '0', '0', '0'),
('275', '1028', '240038', '1', '2024-01-12 23:52:36', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('276', '1029', '24', '1', '2024-01-13 00:14:51', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('277', '1028', '240038', '1', '2024-01-12 23:52:44', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('278', '1028', '240038', '1', '2024-01-12 23:52:44', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('279', '1028', '21036', '1', '2024-01-12 23:53:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('280', '1028', '21037', '1', '2024-01-12 23:53:47', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('281', '1028', '21038', '1', '2024-01-13 00:07:07', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('282', '1028', '21039', '1', '2024-01-13 00:07:36', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('283', '1028', '21040', '1', '2024-01-13 00:07:56', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('284', '1028', '21041', '1', '2024-01-13 00:08:28', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('285', '1028', '21042', '1', '2024-01-13 00:09:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('286', '1028', '21043', '1', '2024-01-13 00:10:03', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('287', '1028', '21044', '1', '2024-01-13 00:10:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('288', '1028', '21045', '1', '2024-01-13 00:11:01', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('289', '1028', '21012', '1', '2024-01-13 00:12:46', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('290', '1029', '24', '1', '2024-01-13 00:20:01', 'Account Type Added', '13', '2024-01-13', NULL, '0', '0'),
('291', '1028', '21046', '1', '2024-01-13 00:16:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('292', '1028', '21047', '1', '2024-01-13 00:16:30', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('293', '1028', '21048', '1', '2024-01-13 00:17:05', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('294', '1028', '21049', '1', '2024-01-13 00:17:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('295', '1028', '21050', '1', '2024-01-13 00:18:03', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('296', '1029', '24', '1', '2024-01-13 00:20:01', 'Account Type Added', '13', '2024-01-13', '0', '0', '0'),
('297', '1028', '21051', '1', '2024-01-13 00:20:35', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('298', '1028', '21052', '1', '2024-01-13 00:21:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('299', '1028', '21053', '1', '2024-01-13 00:21:27', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('300', '1028', '21054', '1', '2024-01-13 00:21:50', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('301', '1028', '21055', '1', '2024-01-17 09:59:46', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('302', '1028', '21056', '1', '2024-01-13 00:22:34', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('303', '1028', '21057', '1', '2024-01-13 00:23:01', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('304', '1028', '21058', '1', '2024-01-13 00:23:46', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('305', '1028', '21008', '1', '2024-01-13 00:24:04', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('306', '1028', '21006', '1', '2024-01-13 00:25:35', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('307', '1028', '21059', '1', '2024-01-13 00:26:06', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('308', '1028', '21003', '1', '2024-01-13 00:27:00', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('309', '1029', '21', '1', '2024-01-13 00:27:34', 'Account Type Added', '13', '2024-01-13', '0', '0', '0'),
('310', '1028', '21060', '1', '2024-01-13 00:28:31', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('311', '1028', '21061', '1', '2024-01-13 00:28:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('312', '1028', '21062', '1', '2024-01-13 00:29:13', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('313', '1028', '21063', '1', '2024-01-17 09:46:28', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('314', '1028', '21064', '1', '2024-01-13 00:29:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('315', '1028', '21065', '1', '2024-01-13 00:30:12', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('316', '1028', '21066', '1', '2024-01-13 00:30:28', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('317', '1028', '21067', '1', '2024-01-17 09:47:01', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('318', '1028', '21068', '1', '2024-01-13 00:31:07', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('319', '1028', '21069', '1', '2024-01-13 00:31:39', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('320', '1028', '21070', '1', '2024-01-13 00:31:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('321', '1028', '21071', '1', '2024-01-13 00:32:12', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('322', '1028', '21072', '1', '2024-01-13 00:32:35', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('323', '1028', '21073', '1', '2024-01-13 00:32:51', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('324', '1028', '21074', '1', '2024-01-13 00:33:46', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('325', '1028', '21011', '1', '2024-01-13 00:34:24', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('326', '1028', '21075', '1', '2024-01-13 00:35:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('327', '1028', '21022', '1', '2024-01-13 00:36:31', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('328', '0', '1', '1', '2024-01-13 10:36:28', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('329', '0', '1', '1', '2024-01-13 10:36:28', 'Voided.\nDocument reentered.', '13', '2024-01-13', '0', '0', '0'),
('330', '0', '2', '1', '2024-01-13 10:36:28', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('331', '0', '3', '1', '2024-01-14 23:02:52', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('332', '1002', '17', '1', '2024-01-15 16:37:53', 'Update Branch', '13', '2024-01-14', NULL, '0', '0'),
('333', '1028', '21076', '1', '2024-01-14 23:14:55', 'Account Data Added', '13', '2024-01-14', '0', '0', '0'),
('334', '0', '4', '1', '2024-01-15 15:46:39', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('335', '1001', '247', '1', '2024-01-15 15:28:37', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('336', '1002', '243', '1', '2024-01-15 15:28:37', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('337', '1001', '249', '1', '2024-01-15 15:34:22', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('338', '1002', '244', '1', '2024-01-15 15:34:22', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('339', '1001', '250', '1', '2024-01-15 15:36:33', 'Create New Customer', '13', '2024-01-15', NULL, '0', '0'),
('340', '1002', '245', '1', '2024-01-15 15:36:03', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('341', '1001', '250', '1', '2024-01-15 15:36:33', 'Update Customer', '13', '2024-01-15', '0', '0', '0'),
('342', '1009', '97', '1', '2024-01-16 10:56:13', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('343', '1009', '98', '1', '2024-01-16 10:52:47', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('344', '1009', '132', '1', '2024-01-15 15:39:16', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('345', '1009', '99', '1', '2024-01-15 15:38:18', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('346', '1009', '99', '1', '2024-01-15 15:38:26', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('347', '1009', '99', '1', '2024-01-15 15:38:38', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('348', '1009', '99', '1', '2024-01-15 15:38:45', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('349', '1009', '99', '1', '2024-01-15 15:38:48', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('350', '1009', '99', '1', '2024-01-15 15:38:57', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('351', '1001', '251', '1', '2024-01-15 15:38:50', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('352', '1002', '246', '1', '2024-01-15 15:38:50', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('353', '1009', '99', '1', '2024-01-15 15:44:38', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('354', '1009', '132', '1', '2024-01-15 15:39:40', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('355', '1009', '132', '1', '2024-01-15 15:44:00', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('356', '1009', '132', '1', '2024-01-15 15:44:29', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('357', '1009', '132', '1', '2024-01-16 10:56:34', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('358', '1009', '99', '1', '2024-01-15 15:48:40', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('359', '0', '4', '1', '2024-01-15 15:46:39', 'Voided.\nDocument reentered.', '13', '2024-01-15', '0', '0', '0'),
('360', '0', '5', '1', '2024-01-16 10:37:32', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('361', '1009', '99', '1', '2024-01-15 15:48:45', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('362', '1009', '99', '1', '2024-01-15 15:48:49', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('363', '1009', '99', '1', '2024-01-15 15:48:53', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('364', '1009', '99', '1', '2024-01-15 15:49:12', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('365', '1009', '99', '1', '2024-01-16 07:57:18', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('366', '1002', '9', '1', '2024-01-15 15:52:30', 'Delete Branch', '13', '2024-01-15', '0', '0', '0'),
('367', '1001', '10', '1', '2024-01-15 15:52:54', 'Delete Customer', '13', '2024-01-15', '0', '0', '0'),
('368', '1002', '17', '25', '2024-01-15 16:46:25', 'Update Branch', '13', '2024-01-15', NULL, '0', '0'),
('369', '1002', '17', '25', '2024-01-15 16:46:58', 'Update Branch', '13', '2024-01-15', NULL, '0', '0'),
('370', '1002', '17', '25', '2024-01-15 16:46:58', 'Update Branch', '13', '2024-01-15', '0', '0', '0'),
('371', '0', '6', '1', '2024-01-15 18:19:30', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('372', '1009', '99', '1', '2024-01-16 08:01:28', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('373', '1009', '99', '1', '2024-01-16 10:48:49', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('374', '1010', '0', '1', '2024-01-16 09:50:02', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('375', '1011', '607', '1', '2024-01-16 09:55:18', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('376', '1010', '0', '1', '2024-01-16 09:50:39', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('377', '1010', '0', '1', '2024-01-16 09:51:58', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('378', '1010', '0', '1', '2024-01-16 09:52:51', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('379', '1010', '0', '1', '2024-01-16 09:53:30', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('380', '1010', '0', '1', '2024-01-16 09:54:01', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('381', '1010', '0', '1', '2024-01-16 09:55:18', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('382', '1010', '0', '1', '2024-01-16 09:55:42', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('383', '1011', '607', '1', '2024-01-16 09:55:42', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('384', '1010', '0', '1', '2024-01-16 09:56:07', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('385', '1011', '607', '1', '2024-01-16 09:56:07', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('386', '1010', '0', '1', '2024-01-16 09:58:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('387', '1011', '607', '1', '2024-01-16 09:58:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('388', '1010', '0', '1', '2024-01-16 09:58:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('389', '1011', '607', '1', '2024-01-16 09:58:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('390', '1010', '0', '1', '2024-01-16 09:59:16', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('391', '1011', '607', '1', '2024-01-16 09:59:16', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('392', '1010', '0', '1', '2024-01-16 09:59:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('393', '1011', '607', '1', '2024-01-16 09:59:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('394', '1010', '0', '1', '2024-01-16 10:00:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('395', '1011', '607', '1', '2024-01-16 10:00:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('396', '1010', '0', '1', '2024-01-16 10:01:19', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('397', '1011', '607', '1', '2024-01-16 10:01:19', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('398', '1010', '0', '1', '2024-01-16 10:01:35', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('399', '1011', '607', '1', '2024-01-16 10:01:35', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('400', '1010', '0', '1', '2024-01-16 10:02:28', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('401', '1011', '607', '1', '2024-01-16 10:02:28', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('402', '1010', '0', '1', '2024-01-16 10:03:29', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('403', '1011', '607', '1', '2024-01-16 10:03:29', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('404', '1010', '0', '1', '2024-01-16 10:03:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('405', '1011', '607', '1', '2024-01-16 10:03:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('406', '1010', '0', '1', '2024-01-16 10:04:09', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('407', '1011', '607', '1', '2024-01-16 10:04:09', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('408', '1010', '0', '1', '2024-01-16 10:04:38', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('409', '1011', '607', '1', '2024-01-16 10:04:38', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('410', '1010', '0', '1', '2024-01-16 10:05:05', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('411', '1011', '607', '1', '2024-01-16 10:05:05', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('412', '1010', '0', '1', '2024-01-16 10:05:23', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('413', '1011', '607', '1', '2024-01-16 10:05:23', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('414', '1010', '0', '1', '2024-01-16 10:05:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('415', '1011', '607', '1', '2024-01-16 10:05:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('416', '1010', '0', '1', '2024-01-16 10:06:22', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('417', '1011', '607', '1', '2024-01-16 10:06:22', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('418', '1010', '0', '1', '2024-01-16 10:06:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('419', '1011', '607', '1', '2024-01-16 10:06:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('420', '1010', '0', '1', '2024-01-16 10:06:51', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('421', '1011', '607', '1', '2024-01-16 10:06:51', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('422', '1010', '0', '1', '2024-01-16 10:06:59', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('423', '1011', '607', '1', '2024-01-16 10:06:59', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('424', '1010', '0', '1', '2024-01-16 10:07:08', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('425', '1011', '607', '1', '2024-01-16 10:07:08', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('426', '1010', '0', '1', '2024-01-16 10:07:36', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('427', '1011', '607', '1', '2024-01-16 10:07:36', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('428', '1010', '0', '1', '2024-01-16 10:07:46', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('429', '1011', '607', '1', '2024-01-16 10:07:46', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('430', '1010', '0', '1', '2024-01-16 10:08:10', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('431', '1011', '607', '1', '2024-01-16 10:08:10', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('432', '1010', '0', '1', '2024-01-16 10:08:49', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('433', '1011', '607', '1', '2024-01-16 10:08:49', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('434', '1010', '0', '1', '2024-01-16 10:09:15', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('435', '1011', '607', '1', '2024-01-16 10:09:15', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('436', '1010', '0', '1', '2024-01-16 10:09:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('437', '1011', '607', '1', '2024-01-16 10:09:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('438', '1010', '0', '1', '2024-01-16 10:09:53', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('439', '1011', '607', '1', '2024-01-16 10:09:53', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('440', '1010', '0', '1', '2024-01-16 10:10:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('441', '1011', '607', '1', '2024-01-16 10:11:18', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('442', '1010', '0', '1', '2024-01-16 10:11:18', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('443', '1010', '0', '1', '2024-01-16 10:11:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('444', '1011', '607', '1', '2024-01-16 10:11:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('445', '1010', '0', '1', '2024-01-16 10:11:51', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('446', '1011', '607', '1', '2024-01-16 10:12:03', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('447', '1010', '0', '1', '2024-01-16 10:12:03', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('448', '1010', '0', '1', '2024-01-16 10:12:09', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('449', '1011', '607', '1', '2024-01-16 10:12:09', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('450', '1010', '0', '1', '2024-01-16 10:12:40', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('451', '1011', '607', '1', '2024-01-16 10:12:40', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('452', '1010', '0', '1', '2024-01-16 16:14:07', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('453', '1011', '607', '1', '2024-01-16 16:14:07', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('454', '1028', '21016', '1', '2024-01-16 10:29:23', 'Account Data Deleted', '13', '2024-01-16', '0', '0', '0'),
('455', '0', '5', '1', '2024-01-16 10:37:32', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('456', '0', '7', '1', '2024-01-16 10:41:24', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('457', '0', '7', '1', '2024-01-16 10:41:24', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('458', '0', '8', '1', '2024-01-16 11:00:38', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('459', '1', '2', '1', '2024-01-16 15:27:58', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('460', '1009', '99', '1', '2024-01-16 10:50:14', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('461', '1009', '99', '25', '2024-01-16 10:51:43', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('462', '1009', '99', '25', '2024-01-16 10:51:53', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('463', '1009', '99', '25', '2024-01-16 10:52:21', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('464', '1009', '99', '1', '2024-01-16 10:52:21', 'Update Supplier', '13', '2024-01-16', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('465', '1009', '98', '1', '2024-01-16 10:52:47', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('466', '1009', '89', '1', '2024-01-16 10:53:26', 'Delete Supplier', '13', '2024-01-16', '0', '0', '0'),
('467', '1009', '100', '1', '2024-01-16 10:53:53', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('468', '1009', '97', '1', '2024-01-16 10:56:13', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('469', '1009', '132', '1', '2024-01-16 10:56:34', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('470', '1009', '101', '1', '2024-01-16 10:57:14', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('471', '1009', '102', '1', '2024-01-16 10:57:33', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('472', '1009', '94', '1', '2024-01-16 10:57:53', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('473', '1009', '103', '1', '2024-01-16 10:58:09', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('474', '1009', '104', '1', '2024-01-16 10:58:35', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('475', '1009', '105', '1', '2024-01-16 10:59:00', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('476', '1009', '106', '1', '2024-01-16 10:59:14', 'Delete Supplier', '13', '2024-01-16', '0', '0', '0'),
('477', '1009', '107', '1', '2024-01-16 10:59:30', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('478', '1009', '108', '1', '2024-01-16 10:59:51', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('479', '1009', '109', '1', '2024-01-16 11:00:08', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('480', '0', '8', '1', '2024-01-16 11:00:38', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('481', '0', '9', '1', '2024-01-16 11:05:55', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('482', '0', '9', '1', '2024-01-16 11:05:55', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('483', '0', '10', '1', '2024-01-16 11:16:55', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('484', '0', '10', '1', '2024-01-16 11:16:55', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('485', '0', '11', '1', '2024-01-16 13:04:27', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('486', '0', '11', '1', '2024-01-16 13:04:27', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('487', '0', '12', '1', '2024-01-16 15:18:07', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('488', '0', '12', '1', '2024-01-16 15:18:07', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('489', '0', '13', '1', '2024-01-16 15:22:38', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('490', '3', '20001', '1', '2024-01-16 15:28:55', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('491', '0', '13', '1', '2024-01-16 15:22:38', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('492', '0', '14', '1', '2024-01-16 15:30:17', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('493', '3', '21076', '1', '2024-01-16 15:28:32', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('494', '1', '2', '1', '2024-01-16 15:27:58', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('495', '3', '21076', '1', '2024-01-16 15:28:32', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('496', '3', '20001', '1', '2024-01-16 15:28:55', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('497', '0', '14', '1', '2024-01-16 15:30:17', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('498', '0', '15', '1', '2024-01-16 15:30:17', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('499', '1010', '0', '1', '2024-01-16 16:15:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('500', '1011', '607', '1', '2024-01-16 16:15:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('501', '1010', '0', '1', '2024-01-16 16:16:12', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('502', '1011', '607', '1', '2024-01-16 16:16:12', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('503', '1010', '0', '1', '2024-01-16 16:16:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('504', '1011', '607', '1', '2024-01-16 16:16:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('505', '1010', '0', '1', '2024-01-16 16:18:01', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('506', '1011', '607', '1', '2024-01-16 16:18:01', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('507', '1010', '0', '1', '2024-01-16 16:18:21', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('508', '1011', '607', '1', '2024-01-16 16:18:21', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('509', '1010', '0', '1', '2024-01-16 16:19:25', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('510', '1011', '607', '1', '2024-01-16 16:19:25', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('511', '1010', '0', '1', '2024-01-16 16:30:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('512', '1011', '607', '1', '2024-01-16 16:30:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('513', '1010', '0', '1', '2024-01-16 16:31:17', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('514', '1011', '607', '1', '2024-01-16 16:31:17', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('515', '1010', '0', '1', '2024-01-16 16:34:24', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('516', '1011', '607', '1', '2024-01-16 16:34:24', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('517', '1010', '0', '1', '2024-01-16 16:34:50', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('518', '1011', '607', '1', '2024-01-16 16:34:50', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('519', '1010', '0', '1', '2024-01-16 16:35:02', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('520', '1011', '607', '1', '2024-01-16 16:35:02', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('521', '1010', '0', '1', '2024-01-16 16:35:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('522', '1011', '607', '1', '2024-01-16 16:35:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('523', '1010', '0', '1', '2024-01-16 16:39:01', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('524', '1011', '607', '1', '2024-01-16 16:39:01', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('525', '1010', '0', '1', '2024-01-16 16:41:00', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('526', '1011', '607', '1', '2024-01-16 16:41:00', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('527', '1010', '0', '1', '2024-01-16 16:41:21', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('528', '1011', '607', '1', '2024-01-16 16:41:21', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('529', '1010', '0', '1', '2024-01-16 16:42:00', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('530', '1011', '607', '1', '2024-01-16 16:42:00', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('531', '1010', '0', '1', '2024-01-16 16:43:28', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('532', '1011', '607', '1', '2024-01-16 16:43:28', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('533', '1010', '0', '1', '2024-01-16 16:44:41', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('534', '1011', '607', '1', '2024-01-16 16:44:41', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('535', '1010', '0', '1', '2024-01-16 16:46:55', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('536', '1011', '607', '1', '2024-01-16 16:46:55', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('537', '1010', '0', '1', '2024-01-16 16:47:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('538', '1011', '607', '1', '2024-01-16 16:47:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('539', '1010', '0', '1', '2024-01-16 16:47:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('540', '1011', '607', '1', '2024-01-16 16:47:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('541', '1010', '0', '1', '2024-01-16 16:48:19', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('542', '1011', '607', '1', '2024-01-16 16:48:19', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('543', '1010', '0', '1', '2024-01-16 16:50:25', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('544', '1011', '607', '1', '2024-01-16 16:50:25', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('545', '1010', '0', '1', '2024-01-16 16:50:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('546', '1011', '607', '1', '2024-01-16 16:50:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('547', '1010', '0', '1', '2024-01-16 16:50:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('548', '1011', '607', '1', '2024-01-16 16:50:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('549', '1010', '0', '1', '2024-01-16 16:51:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('550', '1011', '607', '1', '2024-01-16 16:51:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('551', '1010', '0', '1', '2024-01-16 16:56:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('552', '1011', '607', '1', '2024-01-16 16:56:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('553', '1010', '0', '1', '2024-01-16 16:57:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('554', '1011', '607', '1', '2024-01-16 16:57:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('555', '1010', '0', '1', '2024-01-16 16:58:15', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('556', '1011', '607', '1', '2024-01-16 16:58:15', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('557', '1010', '0', '1', '2024-01-16 16:58:49', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('558', '1011', '607', '1', '2024-01-16 16:58:49', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('559', '1010', '0', '1', '2024-01-16 16:59:04', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('560', '1011', '607', '1', '2024-01-16 16:59:04', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('561', '1010', '0', '1', '2024-01-16 16:59:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('562', '1011', '607', '1', '2024-01-16 16:59:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('563', '1010', '0', '1', '2024-01-17 08:44:10', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('564', '1011', '607', '1', '2024-01-17 08:44:10', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('565', '1010', '0', '1', '2024-01-17 08:48:55', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('566', '1011', '607', '1', '2024-01-17 08:48:55', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('567', '1010', '0', '1', '2024-01-17 08:49:14', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('568', '1011', '607', '1', '2024-01-17 08:49:14', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('569', '1010', '0', '1', '2024-01-17 08:51:58', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('570', '1011', '607', '1', '2024-01-17 08:51:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('571', '1010', '0', '1', '2024-01-17 08:52:20', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('572', '1011', '607', '1', '2024-01-17 08:52:20', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('573', '1010', '0', '1', '2024-01-17 08:52:34', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('574', '1011', '607', '1', '2024-01-17 08:52:34', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('575', '1010', '0', '1', '2024-01-17 08:52:54', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('576', '1011', '607', '1', '2024-01-17 08:52:54', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('577', '1010', '0', '1', '2024-01-17 08:53:12', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('578', '1011', '607', '1', '2024-01-17 08:53:12', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('579', '1010', '0', '1', '2024-01-17 08:53:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('580', '1011', '607', '1', '2024-01-17 08:53:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('581', '1010', '0', '1', '2024-01-17 08:54:01', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('582', '1011', '607', '1', '2024-01-17 08:54:01', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('583', '1010', '0', '1', '2024-01-17 08:54:29', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('584', '1011', '607', '1', '2024-01-17 08:54:29', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('585', '1010', '0', '1', '2024-01-17 08:58:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('586', '1011', '607', '1', '2024-01-17 08:58:19', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('587', '1010', '0', '1', '2024-01-17 08:59:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('588', '1011', '607', '1', '2024-01-17 08:59:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('589', '1010', '0', '1', '2024-01-17 09:00:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('590', '1011', '607', '1', '2024-01-17 09:00:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('591', '1010', '0', '1', '2024-01-17 09:30:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('592', '1011', '607', '1', '2024-01-17 09:07:13', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('593', '1010', '1', '1', '2024-01-17 14:55:30', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('594', '1011', '607', '1', '2024-01-17 09:30:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('595', '1010', '0', '1', '2024-01-17 09:31:22', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('596', '1011', '607', '1', '2024-01-17 09:31:22', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('597', '1010', '0', '1', '2024-01-17 09:31:43', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('598', '1011', '607', '1', '2024-01-17 09:31:43', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('599', '1010', '0', '1', '2024-01-17 09:33:05', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('600', '1011', '607', '1', '2024-01-17 09:33:05', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('601', '1010', '0', '1', '2024-01-17 09:33:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('602', '1011', '607', '1', '2024-01-17 09:33:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('603', '1010', '0', '1', '2024-01-17 09:34:15', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('604', '1011', '607', '1', '2024-01-17 09:34:15', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('605', '1010', '0', '1', '2024-01-17 09:36:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('606', '1011', '607', '1', '2024-01-17 09:37:39', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('607', '1010', '0', '1', '2024-01-17 09:37:00', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('608', '1010', '0', '1', '2024-01-17 09:37:26', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('609', '1010', '0', '1', '2024-01-17 09:37:39', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('610', '1010', '0', '1', '2024-01-17 09:38:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('611', '1011', '607', '1', '2024-01-17 09:38:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('612', '1010', '0', '1', '2024-01-17 09:39:09', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('613', '1011', '607', '1', '2024-01-17 09:39:09', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('614', '1010', '0', '1', '2024-01-17 09:39:45', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('615', '1011', '607', '1', '2024-01-17 09:39:45', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('616', '1010', '0', '1', '2024-01-17 09:50:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('617', '1011', '607', '1', '2024-01-17 09:50:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('618', '1028', '21063', '1', '2024-01-17 09:46:28', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('619', '1028', '21067', '1', '2024-01-17 09:47:01', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('620', '1010', '0', '1', '2024-01-17 09:52:27', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('621', '1011', '607', '1', '2024-01-17 09:50:50', 'Update Item Codes', '13', '2024-01-17', '0', '0', '0'),
('622', '1011', '608', '1', '2024-01-17 09:53:12', 'Create Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('623', '1010', '0', '1', '2024-01-17 09:53:12', 'Create New Item', '13', '2024-01-17', NULL, '0', '0'),
('624', '1010', '0', '1', '2024-01-17 09:53:58', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('625', '1011', '608', '1', '2024-01-17 09:53:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('626', '1010', '0', '1', '2024-01-17 09:54:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('627', '1011', '608', '1', '2024-01-17 09:54:19', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('628', '1010', '0', '1', '2024-01-17 09:54:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('629', '1011', '608', '1', '2024-01-17 09:54:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('630', '1010', '0', '1', '2024-01-17 09:54:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('631', '1011', '608', '1', '2024-01-17 09:54:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('632', '1010', '0', '1', '2024-01-17 09:56:39', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('633', '1011', '608', '1', '2024-01-17 09:56:39', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('634', '1010', '0', '1', '2024-01-17 09:57:32', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('635', '1011', '608', '1', '2024-01-17 09:57:32', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('636', '1010', '0', '1', '2024-01-17 09:58:06', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('637', '1011', '608', '1', '2024-01-17 09:58:06', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('638', '1010', '0', '1', '2024-01-17 10:02:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('639', '1011', '608', '1', '2024-01-17 10:02:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('640', '1028', '21055', '1', '2024-01-17 09:59:46', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('641', '1028', '21077', '1', '2024-01-17 10:01:36', 'Account Data Added', '13', '2024-01-17', '0', '0', '0'),
('642', '1010', '0', '1', '2024-01-17 10:02:54', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('643', '1011', '608', '1', '2024-01-17 10:02:54', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('644', '1010', '0', '1', '2024-01-17 10:05:09', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('645', '1011', '608', '1', '2024-01-17 10:05:09', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('646', '1028', '21031', '1', '2024-01-17 10:04:26', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('647', '1028', '21030', '1', '2024-01-17 10:04:41', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('648', '1010', '0', '1', '2024-01-17 10:06:43', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('649', '1011', '608', '1', '2024-01-17 10:06:43', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('650', '1010', '0', '1', '2024-01-17 10:07:12', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('651', '1011', '608', '1', '2024-01-17 10:07:12', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('652', '1010', '0', '1', '2024-01-17 10:07:45', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('653', '1011', '608', '1', '2024-01-17 10:07:45', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('654', '1010', '0', '1', '2024-01-17 10:13:26', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('655', '1011', '608', '1', '2024-01-17 10:14:18', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('656', '1028', '21034', '1', '2024-01-17 10:08:15', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('657', '1010', '0', '1', '2024-01-17 10:14:18', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('658', '1010', '0', '1', '2024-01-17 10:15:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('659', '1011', '608', '1', '2024-01-17 10:15:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('660', '1010', '0', '1', '2024-01-17 10:15:51', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('661', '1011', '608', '1', '2024-01-17 10:15:51', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('662', '1010', '0', '1', '2024-01-17 10:17:27', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('663', '1011', '608', '1', '2024-01-17 10:17:27', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('664', '1010', '0', '1', '2024-01-17 10:17:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('665', '1011', '608', '1', '2024-01-17 10:17:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('666', '1010', '0', '1', '2024-01-17 10:18:40', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('667', '1011', '608', '1', '2024-01-17 10:20:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('668', '1010', '0', '1', '2024-01-17 10:19:35', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('669', '1010', '0', '1', '2024-01-17 10:20:10', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('670', '1010', '0', '1', '2024-01-17 10:20:58', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('671', '1010', '0', '1', '2024-01-17 10:21:38', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('672', '1011', '608', '1', '2024-01-17 10:21:38', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('673', '1010', '0', '1', '2024-01-17 10:21:42', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('674', '1011', '608', '1', '2024-01-17 10:21:42', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('675', '1010', '0', '1', '2024-01-17 10:22:07', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('676', '1011', '608', '1', '2024-01-17 10:22:07', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('677', '1010', '0', '1', '2024-01-17 14:54:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('678', '1011', '608', '1', '2024-01-17 10:22:07', 'Update Item Codes', '13', '2024-01-17', '0', '0', '0'),
('679', '1011', '609', '25', '2024-01-17 11:57:02', 'Create Foreign Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('680', '1011', '609', '25', '2024-01-17 14:54:19', 'Update Foreign Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('681', '1010', '0', '1', '2024-01-17 14:54:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('682', '1011', '609', '1', '2024-01-17 14:54:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('683', '1010', '0', '1', '2024-01-17 14:54:36', 'Update Item', '13', '2024-01-17', '0', '0', '0'),
('684', '1011', '609', '1', '2024-01-17 14:55:30', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('685', '1010', '1', '1', '2024-01-17 14:55:30', 'Update Item', '13', '2024-01-17', '0', '0', '0'),
('686', '1011', '609', '1', '2024-01-17 14:55:30', 'Update Item Codes', '13', '2024-01-17', '0', '0', '0');

### Structure of table `0_auto_email` ###

DROP TABLE IF EXISTS `0_auto_email`;

CREATE TABLE `0_auto_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rep_name` varchar(100) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `email` varchar(50) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `email_body` longtext NOT NULL,
  `time` varchar(50) NOT NULL,
  `date` varchar(11) NOT NULL,
  `weekend` varchar(15) NOT NULL,
  `cur_time` time NOT NULL,
  `cur_date` date NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_auto_email` ###

INSERT INTO `0_auto_email` VALUES
('1', 'Purchase Summary Report', '206', 'kamran@mrxpert.ae', 'Purchase Report', 'Daily Purchase report', '18-00', 'Daily', '', '11:26:46', '2023-08-15', '0', '0'),
('2', 'Customer Balance', '101', 'kamran@mrxpert.ae', 'Customer Balance', 'Daily Customer Balance report', '11-30', 'Daily', '', '11:26:46', '2023-08-15', '0', '0');

### Structure of table `0_auto_mail` ###

DROP TABLE IF EXISTS `0_auto_mail`;

CREATE TABLE `0_auto_mail` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `hours` varchar(50) NOT NULL,
  `minutes` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `days` varchar(50) DEFAULT NULL,
  `inactive` tinyint(10) NOT NULL DEFAULT 0,
  `deleted` tinyint(11) NOT NULL DEFAULT 0,
  `rep_id` int(100) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_auto_mail` ###


### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `bank_account_arabic` varchar(100) NOT NULL,
  `iban` varchar(1000) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('000002', '1', 'Habib Bank AG Zurich', '0201010203111050870595', 'Habib Bank AG Zurich', NULL, 'AED', '1', '6', '5690', '0000-00-00 00:00:00', '0', '', 'AE100290120311105870595', '0', '0'),
('20001', '3', 'cash in hand', '', 'cash in hand', NULL, 'AED', '0', '7', '5690', '0000-00-00 00:00:00', '0', '', '', '0', '0'),
('21076', '3', 'Petty cash office', '', 'Petty cash office', NULL, 'AED', '0', '8', '5690', '0000-00-00 00:00:00', '0', '', '', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `emp_id` int(11) NOT NULL,
  `reconciled` date DEFAULT NULL,
  `approved` int(11) NOT NULL,
  `alloc` double NOT NULL,
  `refund` int(11) NOT NULL,
  `invoice` int(11) NOT NULL,
  `pdcStatus` tinyint(1) NOT NULL,
  `pdcDate` date NOT NULL,
  `transfered` tinyint(1) NOT NULL,
  `previous_bank` int(11) NOT NULL,
  `bounce_cheque` tinyint(1) NOT NULL,
  `transfered_from_bank` varchar(255) NOT NULL,
  `advance_salary` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '0', '9', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('2', '0', '10', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('3', '0', '11', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('4', '0', '12', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('5', '0', '13', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('6', '0', '14', '7', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('7', '0', '14', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('8', '0', '15', '7', 'JV-03', '2023-12-31', '35.5', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('9', '0', '15', '8', 'JV-03', '2023-12-31', '-14050.62', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('10', '0', '15', '6', 'JV-03', '2023-12-31', '37388.93', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0');

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###


### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `memo_` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_buyer_header` ###

DROP TABLE IF EXISTS `0_buyer_header`;

CREATE TABLE `0_buyer_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_id` int(11) NOT NULL,
  `header_name` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_buyer_header` ###


### Structure of table `0_buyer_header_master` ###

DROP TABLE IF EXISTS `0_buyer_header_master`;

CREATE TABLE `0_buyer_header_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_buyer_header_master` ###


### Structure of table `0_charge_group` ###

DROP TABLE IF EXISTS `0_charge_group`;

CREATE TABLE `0_charge_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(250) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_charge_group` ###

INSERT INTO `0_charge_group` VALUES
('1', 'Test Group', '0'),
('2', 'Test Group - 1', '0'),
('3', 'Test Group - 2', '0');

### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `name_arabic` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '', '0'),
('10', 'Current Assets', '1', '', '0'),
('2', 'Liabilities', '2', '', '0'),
('3', 'Income', '4', '', '0'),
('4', 'Admin and General Expense', '6', '', '0'),
('5', 'Equity', '3', '', '0'),
('6', 'Cost of goods sold', '5', '', '0'),
('7', 'Non Current Assets', '1', '', '0'),
('8', 'Bank Borrowings', '2', '', '0'),
('9', 'FIxed Assets', '1', '', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `account_name_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('000002', '', 'Habib Bank AG Zurich', '24-01', '', '0'),
('0003', '', 'Loans &amp; Advances (Asset)', '01', '', '1'),
('1060', '', 'Opening Account', '01', '', '0'),
('1200', '', 'Sundry Debtors', '01', '', '0'),
('1510', '', 'Inventory', '2', '', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '', '0'),
('1881', '', 'Fuel &amp; Transportation Expense', '21', '', '0'),
('1886', '', 'Repair Maintenance Expenses-Vehicles', '21', '', '0'),
('1888', '', 'Traffic Fines and Payments', '21', '', '0'),
('1897', '', 'General Expense', '21', '', '0'),
('1905', '', 'Paid Leaves', '16', '', '0'),
('1914', '', 'PENALITIES TO EMPLOYEES', '20', '', '0'),
('1915', '', 'Purchase Discount', '20', '', '0'),
('20001', '', 'Cash In Hand', '24-01', '', '0'),
('2022', '', 'Purchases Cash- Taxable', '10', '', '0'),
('2034', '', 'Discount Received', '20', '', '0'),
('2100', '', 'Sundry Creditors', '4', '', '0'),
('21001', '', 'Commission on contract', '21', '', '0'),
('21002', '', 'Commission on Referral', '21', '', '0'),
('21004', '', 'Membership and Renewal Expense', '21', '', '0'),
('21005', '', 'Office Maintenance Expense Taxable', '21', '', '0'),
('21006', '', 'Office Supplies and Stationary Expenses Taxable', '21', '', '0'),
('21007', '', 'Rental Expense', '21', '', '0'),
('21009', '', 'Selling &amp; Marketing Expenses', '21', '', '0'),
('21010', '', 'Traffic Fines and Payments', '21', '', '0'),
('210101', '', 'Electricity Expense', '21', '', '0'),
('21011', '', 'Vehicle Insurance &amp; Registration Expenses taxable', '21', '', '0'),
('21013', '', 'AGENCY FEE TAXABLE', '21', '', '0'),
('21014', '', 'Air Tickets Expenses', '21', '', '0'),
('21015', '', 'Bad Debts', '21', '', '0'),
('21017', '', 'Carriage Inward', '21', '', '0'),
('21018', '', 'Delivery Charges Non Taxable', '21', '', '0'),
('21019', '', 'Ejari Expense', '21', '', '0'),
('21020', '', 'Employee&#039;s Accommodation Expense', '21', '', '0'),
('21021', '', 'Exchange Commission Expenses', '21', '', '0'),
('21022', '', 'Fuel Expense - P-25757 (Arslan) Non Taxable', '21-11', '', '0'),
('21023', '', 'IT Services Expense', '21', '', '0'),
('21024', '', 'Loading Unloading Charges', '21', '', '0'),
('21025', '', 'Medical Expenses', '21', '', '0'),
('21026', '', 'Network Charges Expense', '21', '', '0'),
('21027', '', 'Office Maintenance Non Taxable', '21', '', '0'),
('21028', '', 'Post Office Expense Non Taxable', '21', '', '0'),
('21029', '', 'PRINTING &amp; STATIONARY', '21', '', '0'),
('21030', '', 'Sponsorship Fee Taxable', '21', '', '0'),
('21031', '', 'Sponsorship Fee Non Taxable', '21', '', '0'),
('21032', '', 'Subscription Fees - Taxable', '21', '', '0'),
('21033', '', 'Trade License&#039;s Expenses', '21', '', '0'),
('21034', '', 'Vehicle Renewal Expense Non Taxable', '21', '', '0'),
('21035', '', 'Administration Expenses', '21', '', '0'),
('21036', '', 'Visa Processing Charges - Taxable', '24-08', '', '0'),
('21037', '', 'Visa &amp; Renewables - Abdulla Nepali  MXTS', '24-08', '', '0'),
('21038', '', 'Visa &amp; Renewables - Abid MXTS', '24-08', '', '0'),
('21039', '', 'Visa &amp; Renewables - Afaq Mxts', '24-08', '', '0'),
('21040', '', 'Visa &amp; Renewables - Akbar MXT', '24-08', '', '0'),
('21041', '', 'Visa &amp; Renewables - Arslan MXTS', '24-08', '', '0'),
('21042', '', 'Visa &amp; Renewables Exp-Bir Singh', '24-08', '', '0'),
('21043', '', 'Visa &amp; Renewables - Imran MXTS', '24-08', '', '0'),
('21044', '', 'Visa &amp; Renewables - Shakeel Ahmed MXT', '24-08', '', '0'),
('21045', '', 'Visa &amp; Renewables - Usama MXTS', '24-08', '', '0'),
('21046', '', 'DEWA Expense Taxable', '24-09', '', '0'),
('21047', '', 'Dewa Expense Non Taxable', '24-09', '', '0'),
('21048', '', 'Etisalat Expense Taxable', '24-09', '', '0'),
('21049', '', 'Etisalat Expense Non Taxable', '24-09', '', '0'),
('2105', '', 'Deferred Income', '4', '', '0'),
('21050', '', 'Mobile Expenses', '24-09', '', '0'),
('21051', '', 'Repair MaintenanceP-25757 -Vehicles', '24-10', '', '0'),
('21052', '', 'Repair MaintenanceP-25757 -Vehicles Taxable', '24-10', '', '0'),
('21053', '', 'Repair Maintenance(P-26138) -Vehicles', '24-10', '', '0'),
('21054', '', 'Repair Maintenance(P-26138) -Vehicles Taxable', '24-10', '', '0'),
('21055', '', 'Repair MaintenanceP-56609 -Vehicles Non Taxable', '24-10', '', '0'),
('21056', '', 'Repair Maintenance R-45327 -Vehicles', '24-10', '', '0'),
('21057', '', 'Repair Maintenance R-45327 -Vehicles Taxable', '24-10', '', '0'),
('21058', '', 'Repair Maintenance Vehicle Taxable', '24-10', '', '0'),
('21059', '', 'Office Supplies &amp; Stationery Non Taxable', '21', '', '0'),
('21060', '', 'Salik Expenses', '21-11', '', '0'),
('21061', '', 'Cafu Expenses Taxable', '21-11', '', '0'),
('21062', '', 'Carriage Outward Non Taxable', '21-11', '', '0'),
('21063', '', 'Fuel Expense - G-56609 (Imran) Taxable', '21-11', '', '0'),
('21064', '', 'Fuel Expense - G-56609 (Imran) Non Taxable', '21-11', '', '0'),
('21065', '', 'Fuel Expense JAC S -77609 Non Taxable', '21-11', '', '0'),
('21066', '', 'Fuel Expense JAC S -77609  Taxable', '21-11', '', '0'),
('21067', '', 'Fuel Expense - P-25757 (Arslan) Taxable', '21-11', '', '0'),
('21068', '', 'Fuel Expense P-26138 (Van) Non Taxable', '21-11', '', '0'),
('21069', '', 'Fuel Expense P-26138 (Van) Taxable', '21-11', '', '0'),
('21070', '', 'Fuel Expense R-45327 Non Taxable', '21-11', '', '0'),
('21071', '', 'Fuel Expense R-45327 Taxable', '21-11', '', '0'),
('21072', '', 'Parking Fees', '21-11', '', '0'),
('21073', '', 'Taxi Pick Up Expense', '21-11', '', '0'),
('21074', '', 'Transportation Expenses', '21-11', '', '0'),
('21075', '', 'Vehicle Insurance &amp; Registration Expenses Non Taxable', '21', '', '0'),
('21076', '', 'Petty Cash ', '24-01', '', '0'),
('21077', '', 'Repair MaintenanceP-56609 -Vehicles Taxable', '24-10', '', '0'),
('2150', '', 'VAT', '4', '', '0'),
('2390', '', 'Duties and Taxes', '4', '', '0'),
('2391', '', 'Excise Tax 100%', '4', '', '0'),
('24001', '', 'Advance to Abid Hussain', '24-02', '', '0'),
('24002', '', 'Advance to Akbar (driver)', '24-02', '', '0'),
('24003', '', 'Advance to Arslan Nadeem', '24-02', '', '0'),
('24004', '', 'Advance to Ghulam Abass', '24-02', '', '0'),
('24005', '', 'Advance to Muhammad Adeel', '24-02', '', '0'),
('24006', '', 'Advance to Mustafa Saidu', '24-02', '', '0'),
('24007', '', 'DEWA Security', '24-03', '', '0'),
('24008', '', 'Employee&#039;s Accommodation Rental Security', '24-03', '', '0'),
('24009', '', 'Rental Security', '24-03', '', '0'),
('24010', '', 'Development Planning Account', '24-03', '', '0'),
('24012', '', 'Advance to AFAQ MAHMOOD MAHMOOD AHMAD ', '24-02', '', '0'),
('24013', '', 'Advance to Bir Singh', '24-02', '', '0'),
('24014', '', 'Advance to Durgalal Nepali', '24-02', '', '0'),
('24015', '', 'Advance to Imran Qasim', '24-02', '', '0'),
('24016', '', 'Advance to Muhammad Akhtar', '24-02', '', '0'),
('24017', '', 'Advance to Muhammad Usama', '24-02', '', '0'),
('24018', '', 'Advance to Muhammad Ibrar', '24-02', '', '0'),
('24019', '', 'Advance to Shahid Farooq', '24-02', '', '0'),
('24021', '', 'Advance to Shakeel Ahmed', '24-02', '', '0'),
('24022', '', 'Advance to Tauheed Ahmed', '24-02', '', '0'),
('24023', '', 'Advance to Zeeshan Ali', '24-02', '', '0'),
('24025', '', 'Prepaid Employees Accommodation Expense', '24-04', '', '0'),
('24026', '', 'Prepaid Rent', '24-04', '', '0'),
('24027', '', 'Vehicle 26138', '24-05', '', '0'),
('24028', '', 'Vehicle 60936', '24-05', '', '0'),
('24029', '', 'Vehicle G-56609', '24-05', '', '0'),
('24030', '', 'Vehicle Mitsubishi Lancer R 45327', '24-05', '', '0'),
('24031', '', 'vehicle P25757', '24-05', '', '0'),
('24032', '', 'Accumulated Depreciation Vehicle 26138', '24-07', '', '0'),
('24033', '', 'Accumulated Depreciation Vehicle 60936', '24-07', '', '0'),
('24034', '', 'Accumulated Depreciation Vehicle G-56609', '24-07', '', '0'),
('24035', '', 'Accumulated Depreciation Vehicle P25757', '24-07', '', '0'),
('24036', '', 'Other Tools', '24-06', '', '0'),
('24037', '', 'Loan From Directors', '4', '', '0'),
('24038', '', 'Director Expenses', '6', '', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '', '0'),
('4010', '', 'Sales Paint job', '8', '', '0'),
('4430', '', 'Shipping &amp; Handling Expense', '21', '', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '', '1'),
('4500', '', 'Discount Received ', '9', '', '1'),
('4510', '', 'Discounts Allowed Taxable', '16', '', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '', '0'),
('5020', '', 'Miscellaneous  Cash purchase item Taxable', '10', '', '0'),
('5030', '', 'Purchase Expenses Bindhahi', '10', '', '0'),
('5040', '', 'Purchase price Variance', '10', '', '0'),
('5050', '', 'Purchases', '10', '', '0'),
('5060', '', 'Discounts Received', '10', '', '1'),
('5070', '', 'Unregistered Purchases', '10', '', '0'),
('5420', '', 'Overtime', '16', '', '0'),
('5421', '', 'Discount Allowed Non-Taxable', '16', '', '0'),
('5422', '', 'Site Maintenance Expense Non Taxable', '16', '', '0'),
('5423', '', 'Basic Salary', '16', '', '0'),
('5424', '', 'Home Allowance', '16', '', '0'),
('5425', '', 'Outside Labour', '16', '', '0'),
('5426', '', 'Meals and Entertainment Expense', '16', '', '0'),
('5427', '', 'Rewards and Benefits', '16', '', '0'),
('5429', '', 'Unpaid Leaves', '16', '', '0'),
('5660', '', 'Depreciation Expense', '21', '', '0'),
('5690', '', 'Bank Charges', '21', '', '0'),
('5780', '', 'Telephone', '21', '', '0'),
('9990', '', 'Year Profit/Loss', '12', '', '1');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `name_arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('01', 'Current Assets', '1', '', '', '0'),
('10', 'Purchase Account ', '6', '', '', '0'),
('11', 'Payroll Expenses', '4', '', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '', '0'),
('13', 'Short term loan', '8', '', '', '0'),
('16', 'Direct Expenses', '4', '', '', '0'),
('19', 'Direct Income', '3', '', '', '0'),
('2', 'Inventory Assets', '1', '01', '', '0'),
('20', 'Indirect Income', '4', '', '', '0'),
('21', 'Indirect Expenses', '4', '', '', '0'),
('21-11', 'Fuel And Transportation Expense', '4', '21', '', '0'),
('24-01', 'Cash and Bank', '1', '01', '', '0'),
('24-02', 'Loans and Advances (Assets)', '1', '01', '', '0'),
('24-03', 'Deposits and Securities', '1', '01', '', '0'),
('24-04', 'Prepayments', '1', '01', '', '0'),
('24-05', 'Vehicles', '1', '3', '', '0'),
('24-06', 'Machinery and Tools', '1', '3', '', '0'),
('24-07', 'Accumulated Depriciation', '1', '3', '', '0'),
('24-08', 'VISA EXPENSES', '4', '21', '', '0'),
('24-09', 'Utility Expenses', '4', '21', '', '0'),
('24-10', 'Repair and Maintenance Vehicles', '4', '21', '', '0'),
('3', 'Fixed Assets', '1', '', '', '0'),
('4', 'Current Liabilities', '2', '', '', '0'),
('5', 'Long Term Liabilities', '2', '', '', '0'),
('6', 'Capital Account', '5', '', '', '0'),
('7', 'Retained Earnings', '2', '', '', '0'),
('8', 'Sales Account', '3', '', '', '0'),
('9', 'Other Income', '3', '', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###


### Structure of table `0_company_header` ###

DROP TABLE IF EXISTS `0_company_header`;

CREATE TABLE `0_company_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coy_name` varchar(255) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `postal_address` varchar(255) NOT NULL,
  `domicile` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `fax` varchar(255) NOT NULL,
  `gst_no` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `pic` varchar(255) NOT NULL,
  `del_coy_logo` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_company_header` ###

INSERT INTO `0_company_header` VALUES
('1', 'Company 1', '1', 'Company 1', 'Company 1', '(654) 6-455-6456', 'Company 1', 'Company Test', 'sindh_branch@gmail.com', '', '0'),
('2', 'WayZ Consulting Dubai', '2', 'Ehome Smart Technology Teneral Trading L.L.', 'domicile-ehome', '(971) 1-234-56777', 'fax - ehome', 'GST NO EHOMES', 'ehome@ehome.com', 'wayz_logo.jpg', '0'),
('3', '3 EXPO SHARJAH', '3', 'abu-dhabhi\r\nabu-dhabhi', '3 EXPO SHARJAH', '3 EXPO SHARJAH', '3 EXPO SHARJAH', '3 EXPO SHARJAH', 'expo@gmail.com', 'theonedolce-and-gabbana-the-one-EDP-perfume-women_v3.png', '0'),
('4', 'Company 4', '4', 'Company 4', 'Company 4', '(222) 2-222-4444', '2332323', '33232', 'Company_4@gmail.com', '', '0'),
('5', 'XYZ INC', '7', 'XYZZ', 'Abu Dhabi.', '(314) 2-089-451_', '3142089451', '100212275000003', 'raza789j@gmail.com', 'PP-100X100.png', '0');

### Structure of table `0_complaint` ###

DROP TABLE IF EXISTS `0_complaint`;

CREATE TABLE `0_complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) NOT NULL,
  `complaint_date` date NOT NULL,
  `debtor_no` int(11) NOT NULL,
  `sales_order` int(11) NOT NULL,
  `complaint_type` int(11) NOT NULL,
  `cust_memo` varchar(1000) NOT NULL,
  `user_id` int(11) NOT NULL,
  `responsible_person_name` varchar(1000) NOT NULL,
  `responsible_person_comment` varchar(1000) NOT NULL,
  `decision` varchar(1000) NOT NULL,
  `status` int(11) NOT NULL,
  `close_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_complaint` ###


### Structure of table `0_complaint_types` ###

DROP TABLE IF EXISTS `0_complaint_types`;

CREATE TABLE `0_complaint_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(500) NOT NULL,
  `order_compulsory` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_complaint_types` ###


### Structure of table `0_contact_person` ###

DROP TABLE IF EXISTS `0_contact_person`;

CREATE TABLE `0_contact_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `contact` varchar(100) NOT NULL,
  `contract_type` int(11) NOT NULL,
  `authority` int(11) NOT NULL,
  `sales_type` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_contact_person` ###


### Structure of table `0_countries` ###

DROP TABLE IF EXISTS `0_countries`;

CREATE TABLE `0_countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortname` varchar(3) NOT NULL,
  `name` varchar(150) NOT NULL,
  `phonecode` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_countries` ###

INSERT INTO `0_countries` VALUES
('1', 'AF', 'Afghanistan', '93'),
('2', 'AL', 'Albania', '355'),
('3', 'DZ', 'Algeria', '213'),
('4', 'AS', 'American Samoa', '1684'),
('5', 'AD', 'Andorra', '376'),
('6', 'AO', 'Angola', '244'),
('7', 'AI', 'Anguilla', '1264'),
('8', 'AQ', 'Antarctica', '0'),
('9', 'AG', 'Antigua And Barbuda', '1268'),
('10', 'AR', 'Argentina', '54'),
('11', 'AM', 'Armenia', '374'),
('12', 'AW', 'Aruba', '297'),
('13', 'AU', 'Australia', '61'),
('14', 'AT', 'Austria', '43'),
('15', 'AZ', 'Azerbaijan', '994'),
('16', 'BS', 'Bahamas The', '1242'),
('17', 'BH', 'Bahrain', '973'),
('18', 'BD', 'Bangladesh', '880'),
('19', 'BB', 'Barbados', '1246'),
('20', 'BY', 'Belarus', '375'),
('21', 'BE', 'Belgium', '32'),
('22', 'BZ', 'Belize', '501'),
('23', 'BJ', 'Benin', '229'),
('24', 'BM', 'Bermuda', '1441'),
('25', 'BT', 'Bhutan', '975'),
('26', 'BO', 'Bolivia', '591'),
('27', 'BA', 'Bosnia and Herzegovina', '387'),
('28', 'BW', 'Botswana', '267'),
('29', 'BV', 'Bouvet Island', '0'),
('30', 'BR', 'Brazil', '55'),
('31', 'IO', 'British Indian Ocean Territory', '246'),
('32', 'BN', 'Brunei', '673'),
('33', 'BG', 'Bulgaria', '359'),
('34', 'BF', 'Burkina Faso', '226'),
('35', 'BI', 'Burundi', '257'),
('36', 'KH', 'Cambodia', '855'),
('37', 'CM', 'Cameroon', '237'),
('38', 'CA', 'Canada', '1'),
('39', 'CV', 'Cape Verde', '238'),
('40', 'KY', 'Cayman Islands', '1345'),
('41', 'CF', 'Central African Republic', '236'),
('42', 'TD', 'Chad', '235'),
('43', 'CL', 'Chile', '56'),
('44', 'CN', 'China', '86'),
('45', 'CX', 'Christmas Island', '61'),
('46', 'CC', 'Cocos (Keeling) Islands', '672'),
('47', 'CO', 'Colombia', '57'),
('48', 'KM', 'Comoros', '269'),
('49', 'CG', 'Republic Of The Congo', '242'),
('50', 'CD', 'Democratic Republic Of The Congo', '242'),
('51', 'CK', 'Cook Islands', '682'),
('52', 'CR', 'Costa Rica', '506'),
('53', 'CI', 'Cote D&#039;Ivoire (Ivory Coast)', '225'),
('54', 'HR', 'Croatia (Hrvatska)', '385'),
('55', 'CU', 'Cuba', '53'),
('56', 'CY', 'Cyprus', '357'),
('57', 'CZ', 'Czech Republic', '420'),
('58', 'DK', 'Denmark', '45'),
('59', 'DJ', 'Djibouti', '253'),
('60', 'DM', 'Dominica', '1767'),
('61', 'DO', 'Dominican Republic', '1809'),
('62', 'TP', 'East Timor', '670'),
('63', 'EC', 'Ecuador', '593'),
('64', 'EG', 'Egypt', '20'),
('65', 'SV', 'El Salvador', '503'),
('66', 'GQ', 'Equatorial Guinea', '240'),
('67', 'ER', 'Eritrea', '291'),
('68', 'EE', 'Estonia', '372'),
('69', 'ET', 'Ethiopia', '251'),
('70', 'XA', 'External Territories of Australia', '61'),
('71', 'FK', 'Falkland Islands', '500'),
('72', 'FO', 'Faroe Islands', '298'),
('73', 'FJ', 'Fiji Islands', '679'),
('74', 'FI', 'Finland', '358'),
('75', 'FR', 'France', '33'),
('76', 'GF', 'French Guiana', '594'),
('77', 'PF', 'French Polynesia', '689'),
('78', 'TF', 'French Southern Territories', '0'),
('79', 'GA', 'Gabon', '241'),
('80', 'GM', 'Gambia The', '220'),
('81', 'GE', 'Georgia', '995'),
('82', 'DE', 'Germany', '49'),
('83', 'GH', 'Ghana', '233'),
('84', 'GI', 'Gibraltar', '350'),
('85', 'GR', 'Greece', '30'),
('86', 'GL', 'Greenland', '299'),
('87', 'GD', 'Grenada', '1473'),
('88', 'GP', 'Guadeloupe', '590'),
('89', 'GU', 'Guam', '1671'),
('90', 'GT', 'Guatemala', '502'),
('91', 'XU', 'Guernsey and Alderney', '44'),
('92', 'GN', 'Guinea', '224'),
('93', 'GW', 'Guinea-Bissau', '245'),
('94', 'GY', 'Guyana', '592'),
('95', 'HT', 'Haiti', '509'),
('96', 'HM', 'Heard and McDonald Islands', '0'),
('97', 'HN', 'Honduras', '504'),
('98', 'HK', 'Hong Kong S.A.R.', '852'),
('99', 'HU', 'Hungary', '36'),
('100', 'IS', 'Iceland', '354'),
('101', 'IN', 'India', '91'),
('102', 'ID', 'Indonesia', '62'),
('103', 'IR', 'Iran', '98'),
('104', 'IQ', 'Iraq', '964'),
('105', 'IE', 'Ireland', '353'),
('106', 'IL', 'Israel', '972'),
('107', 'IT', 'Italy', '39'),
('108', 'JM', 'Jamaica', '1876'),
('109', 'JP', 'Japan', '81'),
('110', 'XJ', 'Jersey', '44'),
('111', 'JO', 'Jordan', '962'),
('112', 'KZ', 'Kazakhstan', '7'),
('113', 'KE', 'Kenya', '254'),
('114', 'KI', 'Kiribati', '686'),
('115', 'KP', 'Korea North', '850'),
('116', 'KR', 'Korea South', '82'),
('117', 'KW', 'Kuwait', '965'),
('118', 'KG', 'Kyrgyzstan', '996'),
('119', 'LA', 'Laos', '856'),
('120', 'LV', 'Latvia', '371'),
('121', 'LB', 'Lebanon', '961'),
('122', 'LS', 'Lesotho', '266'),
('123', 'LR', 'Liberia', '231'),
('124', 'LY', 'Libya', '218'),
('125', 'LI', 'Liechtenstein', '423'),
('126', 'LT', 'Lithuania', '370'),
('127', 'LU', 'Luxembourg', '352'),
('128', 'MO', 'Macau S.A.R.', '853'),
('129', 'MK', 'Macedonia', '389'),
('130', 'MG', 'Madagascar', '261'),
('131', 'MW', 'Malawi', '265'),
('132', 'MY', 'Malaysia', '60'),
('133', 'MV', 'Maldives', '960'),
('134', 'ML', 'Mali', '223'),
('135', 'MT', 'Malta', '356'),
('136', 'XM', 'Man (Isle of)', '44'),
('137', 'MH', 'Marshall Islands', '692'),
('138', 'MQ', 'Martinique', '596'),
('139', 'MR', 'Mauritania', '222'),
('140', 'MU', 'Mauritius', '230'),
('141', 'YT', 'Mayotte', '269'),
('142', 'MX', 'Mexico', '52'),
('143', 'FM', 'Micronesia', '691'),
('144', 'MD', 'Moldova', '373'),
('145', 'MC', 'Monaco', '377'),
('146', 'MN', 'Mongolia', '976'),
('147', 'MS', 'Montserrat', '1664'),
('148', 'MA', 'Morocco', '212'),
('149', 'MZ', 'Mozambique', '258'),
('150', 'MM', 'Myanmar', '95'),
('151', 'NA', 'Namibia', '264'),
('152', 'NR', 'Nauru', '674'),
('153', 'NP', 'Nepal', '977'),
('154', 'AN', 'Netherlands Antilles', '599'),
('155', 'NL', 'Netherlands The', '31'),
('156', 'NC', 'New Caledonia', '687'),
('157', 'NZ', 'New Zealand', '64'),
('158', 'NI', 'Nicaragua', '505'),
('159', 'NE', 'Niger', '227'),
('160', 'NG', 'Nigeria', '234'),
('161', 'NU', 'Niue', '683'),
('162', 'NF', 'Norfolk Island', '672'),
('163', 'MP', 'Northern Mariana Islands', '1670'),
('164', 'NO', 'Norway', '47'),
('165', 'OM', 'Oman', '968'),
('166', 'PK', 'Pakistan', '92'),
('167', 'PW', 'Palau', '680'),
('168', 'PS', 'Palestinian Territory Occupied', '970'),
('169', 'PA', 'Panama', '507'),
('170', 'PG', 'Papua new Guinea', '675'),
('171', 'PY', 'Paraguay', '595'),
('172', 'PE', 'Peru', '51'),
('173', 'PH', 'Philippines', '63'),
('174', 'PN', 'Pitcairn Island', '0'),
('175', 'PL', 'Poland', '48'),
('176', 'PT', 'Portugal', '351'),
('177', 'PR', 'Puerto Rico', '1787'),
('178', 'QA', 'Qatar', '974'),
('179', 'RE', 'Reunion', '262'),
('180', 'RO', 'Romania', '40'),
('181', 'RU', 'Russia', '70'),
('182', 'RW', 'Rwanda', '250'),
('183', 'SH', 'Saint Helena', '290'),
('184', 'KN', 'Saint Kitts And Nevis', '1869'),
('185', 'LC', 'Saint Lucia', '1758'),
('186', 'PM', 'Saint Pierre and Miquelon', '508'),
('187', 'VC', 'Saint Vincent And The Grenadines', '1784'),
('188', 'WS', 'Samoa', '684'),
('189', 'SM', 'San Marino', '378'),
('190', 'ST', 'Sao Tome and Principe', '239'),
('191', 'SA', 'Saudi Arabia', '966'),
('192', 'SN', 'Senegal', '221'),
('193', 'RS', 'Serbia', '381'),
('194', 'SC', 'Seychelles', '248'),
('195', 'SL', 'Sierra Leone', '232'),
('196', 'SG', 'Singapore', '65'),
('197', 'SK', 'Slovakia', '421'),
('198', 'SI', 'Slovenia', '386'),
('199', 'XG', 'Smaller Territories of the UK', '44'),
('200', 'SB', 'Solomon Islands', '677'),
('201', 'SO', 'Somalia', '252'),
('202', 'ZA', 'South Africa', '27'),
('203', 'GS', 'South Georgia', '0'),
('204', 'SS', 'South Sudan', '211'),
('205', 'ES', 'Spain', '34'),
('206', 'LK', 'Sri Lanka', '94'),
('207', 'SD', 'Sudan', '249'),
('208', 'SR', 'Suriname', '597'),
('209', 'SJ', 'Svalbard And Jan Mayen Islands', '47'),
('210', 'SZ', 'Swaziland', '268'),
('211', 'SE', 'Sweden', '46'),
('212', 'CH', 'Switzerland', '41'),
('213', 'SY', 'Syria', '963'),
('214', 'TW', 'Taiwan', '886'),
('215', 'TJ', 'Tajikistan', '992'),
('216', 'TZ', 'Tanzania', '255'),
('217', 'TH', 'Thailand', '66'),
('218', 'TG', 'Togo', '228'),
('219', 'TK', 'Tokelau', '690'),
('220', 'TO', 'Tonga', '676'),
('221', 'TT', 'Trinidad And Tobago', '1868'),
('222', 'TN', 'Tunisia', '216'),
('223', 'TR', 'Turkey', '90'),
('224', 'TM', 'Turkmenistan', '7370'),
('225', 'TC', 'Turks And Caicos Islands', '1649'),
('226', 'TV', 'Tuvalu', '688'),
('227', 'UG', 'Uganda', '256'),
('228', 'UA', 'Ukraine', '380'),
('229', 'AE', 'United Arab Emirates', '971'),
('230', 'GB', 'United Kingdom', '44'),
('231', 'US', 'United States', '1'),
('232', 'UM', 'United States Minor Outlying Islands', '1'),
('233', 'UY', 'Uruguay', '598'),
('234', 'UZ', 'Uzbekistan', '998'),
('235', 'VU', 'Vanuatu', '678'),
('236', 'VA', 'Vatican City State (Holy See)', '39'),
('237', 'VE', 'Venezuela', '58'),
('238', 'VN', 'Vietnam', '84'),
('239', 'VG', 'Virgin Islands (British)', '1284'),
('240', 'VI', 'Virgin Islands (US)', '1340'),
('241', 'WF', 'Wallis And Futuna Islands', '681'),
('242', 'EH', 'Western Sahara', '212'),
('243', 'YE', 'Yemen', '967'),
('244', 'YU', 'Yugoslavia', '38'),
('245', 'ZM', 'Zambia', '260'),
('246', 'ZW', 'Zimbabwe', '263');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('6', 'Active', '0', '0'),
('7', 'Inactive', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` tinytext NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_comments` ###

DROP TABLE IF EXISTS `0_crm_comments`;

CREATE TABLE `0_crm_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL,
  `branch_code` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `comment` varchar(5000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_crm_comments` ###


### Structure of table `0_crm_contact_form` ###

DROP TABLE IF EXISTS `0_crm_contact_form`;

CREATE TABLE `0_crm_contact_form` (
  `cust_id` int(11) NOT NULL AUTO_INCREMENT,
  `cont_per` varchar(100) NOT NULL,
  `comp_name` varchar(100) NOT NULL,
  `desg` varchar(100) NOT NULL,
  `user` int(11) NOT NULL,
  `trans_date` varchar(100) NOT NULL,
  `web` varchar(200) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `sec_phone` varchar(100) NOT NULL,
  `email_addr` varchar(100) NOT NULL,
  `mobile` varchar(100) NOT NULL,
  `mobile_1` varchar(100) NOT NULL,
  `fax` varchar(100) NOT NULL,
  `postal_address` varchar(200) NOT NULL,
  `attach_front` varchar(300) NOT NULL,
  `attach_back` varchar(300) NOT NULL,
  PRIMARY KEY (`cust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_crm_contact_form` ###


### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `entity_id` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=633 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'supplier', 'general', '1'),
('4', '3', 'cust_branch', 'general', '2'),
('5', '3', 'customer', 'general', '3'),
('6', '4', 'cust_branch', 'general', '3'),
('7', '4', 'customer', 'general', '4'),
('8', '5', 'cust_branch', 'general', '4'),
('9', '5', 'customer', 'general', '5'),
('10', '6', 'cust_branch', 'general', '5'),
('11', '6', 'customer', 'general', '6'),
('12', '7', 'cust_branch', 'general', '6'),
('13', '7', 'customer', 'general', '7'),
('14', '8', 'cust_branch', 'general', '7'),
('15', '8', 'customer', 'general', '8'),
('16', '9', 'cust_branch', 'general', '8'),
('17', '9', 'customer', 'general', '9'),
('20', '11', 'cust_branch', 'general', '10'),
('21', '11', 'customer', 'general', '11'),
('22', '12', 'cust_branch', 'general', '11'),
('23', '12', 'customer', 'general', '12'),
('24', '13', 'cust_branch', 'general', '12'),
('25', '13', 'customer', 'general', '13'),
('26', '14', 'cust_branch', 'general', '13'),
('27', '14', 'customer', 'general', '14'),
('28', '15', 'cust_branch', 'general', '14'),
('29', '15', 'customer', 'general', '15'),
('30', '16', 'cust_branch', 'general', '15'),
('31', '16', 'customer', 'general', '16'),
('32', '17', 'cust_branch', 'general', '16'),
('33', '17', 'customer', 'general', '17'),
('34', '18', 'cust_branch', 'general', '17'),
('35', '18', 'customer', 'general', '18'),
('36', '19', 'cust_branch', 'general', '18'),
('37', '19', 'customer', 'general', '19'),
('38', '20', 'cust_branch', 'general', '19'),
('39', '20', 'customer', 'general', '20'),
('40', '21', 'cust_branch', 'general', '20'),
('41', '21', 'customer', 'general', '21'),
('42', '22', 'cust_branch', 'general', '21'),
('43', '22', 'customer', 'general', '22'),
('44', '23', 'cust_branch', 'general', '22'),
('45', '23', 'customer', 'general', '23'),
('46', '24', 'cust_branch', 'general', '23'),
('47', '24', 'customer', 'general', '24'),
('48', '25', 'cust_branch', 'general', '24'),
('49', '25', 'customer', 'general', '25'),
('50', '26', 'cust_branch', 'general', '25'),
('51', '26', 'customer', 'general', '26'),
('52', '27', 'cust_branch', 'general', '26'),
('53', '27', 'customer', 'general', '27'),
('54', '28', 'cust_branch', 'general', '27'),
('55', '28', 'customer', 'general', '28'),
('56', '29', 'cust_branch', 'general', '28'),
('57', '29', 'customer', 'general', '29'),
('58', '30', 'cust_branch', 'general', '29'),
('59', '30', 'customer', 'general', '30'),
('60', '31', 'cust_branch', 'general', '30'),
('61', '31', 'customer', 'general', '31'),
('62', '32', 'cust_branch', 'general', '31'),
('63', '32', 'customer', 'general', '32'),
('64', '33', 'cust_branch', 'general', '32'),
('65', '33', 'customer', 'general', '33'),
('66', '34', 'cust_branch', 'general', '33'),
('67', '34', 'customer', 'general', '34'),
('68', '35', 'cust_branch', 'general', '34'),
('69', '35', 'customer', 'general', '35'),
('70', '36', 'cust_branch', 'general', '35'),
('71', '36', 'customer', 'general', '36'),
('72', '37', 'cust_branch', 'general', '36'),
('73', '37', 'customer', 'general', '37'),
('74', '38', 'cust_branch', 'general', '37'),
('75', '38', 'customer', 'general', '38'),
('76', '39', 'cust_branch', 'general', '38'),
('77', '39', 'customer', 'general', '39'),
('78', '40', 'cust_branch', 'general', '39'),
('79', '40', 'customer', 'general', '40'),
('80', '41', 'cust_branch', 'general', '40'),
('81', '41', 'customer', 'general', '41'),
('82', '42', 'cust_branch', 'general', '41'),
('83', '42', 'customer', 'general', '42'),
('84', '43', 'cust_branch', 'general', '42'),
('85', '43', 'customer', 'general', '43'),
('86', '44', 'cust_branch', 'general', '43'),
('87', '44', 'customer', 'general', '44'),
('88', '45', 'cust_branch', 'general', '44'),
('89', '45', 'customer', 'general', '45'),
('90', '46', 'cust_branch', 'general', '45'),
('91', '46', 'customer', 'general', '46'),
('92', '47', 'cust_branch', 'general', '46'),
('93', '47', 'customer', 'general', '47'),
('94', '48', 'cust_branch', 'general', '47'),
('95', '48', 'customer', 'general', '48'),
('96', '49', 'cust_branch', 'general', '48'),
('97', '49', 'customer', 'general', '49'),
('98', '50', 'cust_branch', 'general', '49'),
('99', '50', 'customer', 'general', '50'),
('100', '51', 'cust_branch', 'general', '50'),
('101', '51', 'customer', 'general', '51'),
('102', '52', 'cust_branch', 'general', '51'),
('103', '52', 'customer', 'general', '52'),
('104', '53', 'cust_branch', 'general', '52'),
('105', '53', 'customer', 'general', '53'),
('106', '54', 'cust_branch', 'general', '53'),
('107', '54', 'customer', 'general', '54'),
('108', '55', 'cust_branch', 'general', '54'),
('109', '55', 'customer', 'general', '55'),
('110', '56', 'cust_branch', 'general', '55'),
('111', '56', 'customer', 'general', '56'),
('112', '57', 'cust_branch', 'general', '56'),
('114', '58', 'cust_branch', 'general', '57'),
('115', '58', 'customer', 'general', '58'),
('116', '59', 'cust_branch', 'general', '58'),
('117', '59', 'customer', 'general', '59'),
('118', '60', 'cust_branch', 'general', '59'),
('119', '60', 'customer', 'general', '60'),
('120', '61', 'cust_branch', 'general', '60'),
('121', '61', 'customer', 'general', '61'),
('122', '62', 'cust_branch', 'general', '61'),
('123', '62', 'customer', 'general', '62'),
('124', '63', 'cust_branch', 'general', '62'),
('125', '63', 'customer', 'general', '63'),
('126', '64', 'cust_branch', 'general', '63'),
('127', '64', 'customer', 'general', '64'),
('128', '65', 'cust_branch', 'general', '64'),
('129', '65', 'customer', 'general', '65'),
('130', '66', 'cust_branch', 'general', '65'),
('131', '66', 'customer', 'general', '66'),
('132', '67', 'cust_branch', 'general', '66'),
('133', '67', 'customer', 'general', '67'),
('134', '68', 'cust_branch', 'general', '67'),
('135', '68', 'customer', 'general', '68'),
('136', '69', 'cust_branch', 'general', '68'),
('137', '69', 'customer', 'general', '69'),
('138', '70', 'cust_branch', 'general', '69'),
('139', '70', 'customer', 'general', '70'),
('140', '71', 'cust_branch', 'general', '70'),
('141', '71', 'customer', 'general', '71'),
('142', '72', 'cust_branch', 'general', '71'),
('143', '72', 'customer', 'general', '72'),
('144', '73', 'supplier', 'general', '2'),
('145', '74', 'supplier', 'general', '3'),
('146', '75', 'supplier', 'general', '4'),
('147', '76', 'supplier', 'general', '5'),
('148', '77', 'supplier', 'general', '6'),
('149', '78', 'supplier', 'general', '7'),
('150', '79', 'supplier', 'general', '8'),
('151', '80', 'supplier', 'general', '9'),
('152', '81', 'supplier', 'general', '10'),
('153', '82', 'supplier', 'general', '11'),
('154', '83', 'supplier', 'general', '12'),
('155', '84', 'supplier', 'general', '13'),
('156', '85', 'supplier', 'general', '14'),
('157', '86', 'supplier', 'general', '15'),
('158', '87', 'supplier', 'general', '16'),
('159', '88', 'supplier', 'general', '17'),
('160', '89', 'supplier', 'general', '18'),
('161', '90', 'supplier', 'general', '19'),
('162', '91', 'supplier', 'general', '20'),
('163', '92', 'supplier', 'general', '21'),
('164', '93', 'supplier', 'general', '22'),
('165', '94', 'supplier', 'general', '23'),
('166', '95', 'supplier', 'general', '24'),
('167', '96', 'supplier', 'general', '25'),
('168', '97', 'supplier', 'general', '26'),
('169', '98', 'supplier', 'general', '27'),
('170', '99', 'supplier', 'general', '28'),
('171', '100', 'supplier', 'general', '29'),
('172', '101', 'supplier', 'general', '30'),
('173', '102', 'supplier', 'general', '31'),
('174', '103', 'supplier', 'general', '32'),
('175', '104', 'supplier', 'general', '33'),
('176', '105', 'supplier', 'general', '34'),
('177', '106', 'cust_branch', 'general', '72'),
('178', '106', 'customer', 'general', '73'),
('179', '107', 'supplier', 'general', '35'),
('180', '108', 'cust_branch', 'general', '73'),
('181', '108', 'customer', 'general', '74'),
('182', '109', 'supplier', 'general', '36'),
('183', '110', 'cust_branch', 'general', '74'),
('184', '110', 'customer', 'general', '75'),
('185', '111', 'cust_branch', 'general', '75'),
('186', '111', 'customer', 'general', '78'),
('187', '112', 'cust_branch', 'general', '76'),
('188', '112', 'customer', 'general', '79'),
('189', '113', 'supplier', 'general', '37'),
('190', '114', 'supplier', 'general', '38'),
('191', '115', 'supplier', 'general', '39'),
('192', '116', 'supplier', 'general', '40'),
('193', '117', 'supplier', 'general', '41'),
('194', '118', 'supplier', 'general', '42'),
('195', '119', 'supplier', 'general', '43'),
('196', '120', 'cust_branch', 'general', '77'),
('197', '120', 'customer', 'general', '80'),
('198', '121', 'supplier', 'general', '44'),
('199', '122', 'supplier', 'general', '45'),
('200', '123', 'cust_branch', 'general', '78'),
('201', '123', 'customer', 'general', '81'),
('202', '124', 'supplier', 'general', '46'),
('203', '125', 'supplier', 'general', '47'),
('204', '126', 'cust_branch', 'general', '79'),
('205', '126', 'customer', 'general', '82'),
('206', '127', 'supplier', 'general', '48'),
('207', '128', 'supplier', 'general', '49'),
('208', '129', 'supplier', 'general', '50'),
('209', '130', 'supplier', 'general', '51'),
('210', '131', 'supplier', 'general', '52'),
('211', '132', 'supplier', 'general', '53'),
('212', '133', 'cust_branch', 'general', '80'),
('213', '133', 'customer', 'general', '83'),
('214', '134', 'supplier', 'general', '54'),
('215', '135', 'supplier', 'general', '55'),
('216', '136', 'cust_branch', 'general', '81'),
('217', '136', 'customer', 'general', '84'),
('218', '137', 'supplier', 'general', '56'),
('219', '138', 'cust_branch', 'general', '82'),
('220', '138', 'customer', 'general', '85'),
('221', '139', 'supplier', 'general', '57'),
('222', '140', 'supplier', 'general', '58'),
('223', '141', 'cust_branch', 'general', '83'),
('224', '141', 'customer', 'general', '86'),
('225', '142', 'supplier', 'general', '59'),
('226', '143', 'cust_branch', 'general', '84'),
('227', '143', 'customer', 'general', '87'),
('228', '144', 'supplier', 'general', '60'),
('229', '145', 'supplier', 'general', '61'),
('230', '146', 'cust_branch', 'general', '85'),
('231', '146', 'customer', 'general', '88'),
('232', '147', 'supplier', 'general', '62'),
('233', '148', 'cust_branch', 'general', '86'),
('234', '148', 'customer', 'general', '89'),
('235', '149', 'cust_branch', 'general', '87'),
('236', '149', 'customer', 'general', '90'),
('237', '150', 'cust_branch', 'general', '88'),
('238', '150', 'customer', 'general', '91'),
('239', '151', 'cust_branch', 'general', '89'),
('240', '151', 'customer', 'general', '92'),
('241', '152', 'supplier', 'general', '63'),
('242', '153', 'supplier', 'general', '64'),
('243', '154', 'cust_branch', 'general', '90'),
('244', '154', 'customer', 'general', '93'),
('245', '155', 'supplier', 'general', '65'),
('246', '156', 'supplier', 'general', '66'),
('247', '157', 'supplier', 'general', '67'),
('248', '158', 'supplier', 'general', '68'),
('249', '159', 'supplier', 'general', '69'),
('250', '160', 'supplier', 'general', '70'),
('251', '161', 'supplier', 'general', '71'),
('252', '162', 'supplier', 'general', '72'),
('253', '163', 'supplier', 'general', '73'),
('254', '164', 'supplier', 'general', '74'),
('255', '165', 'supplier', 'general', '75'),
('256', '166', 'supplier', 'general', '76'),
('257', '167', 'supplier', 'general', '77'),
('258', '168', 'supplier', 'general', '78'),
('259', '169', 'supplier', 'general', '79'),
('260', '170', 'supplier', 'general', '80'),
('261', '171', 'supplier', 'general', '81'),
('262', '172', 'supplier', 'general', '82'),
('263', '173', 'cust_branch', 'general', '91'),
('264', '173', 'customer', 'general', '94'),
('265', '174', 'cust_branch', 'general', '92'),
('266', '174', 'customer', 'general', '95'),
('267', '175', 'supplier', 'general', '83'),
('268', '176', 'cust_branch', 'general', '93'),
('269', '176', 'customer', 'general', '96'),
('270', '177', 'cust_branch', 'general', '94'),
('271', '177', 'customer', 'general', '97'),
('272', '178', 'cust_branch', 'general', '95'),
('273', '178', 'customer', 'general', '98'),
('274', '179', 'cust_branch', 'general', '96'),
('275', '179', 'customer', 'general', '99'),
('276', '180', 'supplier', 'general', '84'),
('277', '181', 'supplier', 'general', '85'),
('278', '182', 'supplier', 'general', '86'),
('279', '183', 'cust_branch', 'general', '97'),
('280', '183', 'customer', 'general', '100'),
('281', '184', 'cust_branch', 'general', '98'),
('282', '184', 'customer', 'general', '101'),
('283', '185', 'cust_branch', 'general', '99'),
('284', '185', 'customer', 'general', '102'),
('285', '186', 'supplier', 'general', '87'),
('286', '187', 'cust_branch', 'general', '100'),
('287', '187', 'customer', 'general', '103'),
('288', '188', 'cust_branch', 'general', '101'),
('289', '188', 'customer', 'general', '104'),
('290', '189', 'cust_branch', 'general', '102'),
('291', '189', 'customer', 'general', '105'),
('292', '57', 'customer', 'general', '57'),
('293', '190', 'supplier', 'general', '88'),
('294', '191', 'supplier', 'general', '89'),
('295', '192', 'cust_branch', 'general', '103'),
('297', '192', 'customer', 'general', '106'),
('298', '193', 'cust_branch', 'general', '104'),
('299', '193', 'customer', 'general', '107'),
('300', '194', 'cust_branch', 'general', '105'),
('301', '194', 'customer', 'general', '108'),
('302', '195', 'cust_branch', 'general', '106'),
('303', '195', 'customer', 'general', '109'),
('304', '196', 'supplier', 'general', '90'),
('305', '197', 'cust_branch', 'general', '107'),
('306', '197', 'customer', 'general', '110'),
('307', '198', 'cust_branch', 'general', '108'),
('308', '198', 'customer', 'general', '111'),
('309', '199', 'cust_branch', 'general', '109'),
('310', '199', 'customer', 'general', '112'),
('311', '200', 'cust_branch', 'general', '110'),
('312', '200', 'customer', 'general', '113'),
('313', '201', 'supplier', 'general', '91'),
('314', '202', 'supplier', 'general', '92'),
('315', '203', 'supplier', 'general', '93'),
('316', '204', 'cust_branch', 'general', '111'),
('317', '204', 'customer', 'general', '114'),
('318', '205', 'cust_branch', 'general', '112'),
('319', '205', 'customer', 'general', '115'),
('321', '206', 'customer', 'general', '116'),
('322', '207', 'supplier', 'general', '94'),
('323', '208', 'cust_branch', 'general', '114'),
('324', '208', 'customer', 'general', '117'),
('325', '209', 'cust_branch', 'general', '115'),
('326', '209', 'customer', 'general', '118'),
('327', '210', 'cust_branch', 'general', '116'),
('328', '210', 'customer', 'general', '119'),
('329', '211', 'supplier', 'general', '95'),
('330', '212', 'supplier', 'general', '96'),
('331', '213', 'supplier', 'general', '97'),
('332', '214', 'supplier', 'general', '98'),
('333', '215', 'cust_branch', 'general', '117'),
('334', '215', 'customer', 'general', '120'),
('335', '216', 'cust_branch', 'general', '118'),
('336', '216', 'customer', 'general', '121'),
('337', '217', 'supplier', 'general', '99'),
('338', '218', 'supplier', 'general', '100'),
('339', '219', 'supplier', 'general', '101'),
('340', '220', 'supplier', 'general', '102'),
('341', '221', 'supplier', 'general', '103'),
('342', '222', 'supplier', 'general', '104'),
('343', '223', 'supplier', 'general', '105'),
('344', '224', 'supplier', 'general', '106'),
('345', '225', 'supplier', 'general', '107'),
('346', '226', 'supplier', 'general', '108'),
('347', '227', 'supplier', 'general', '109'),
('348', '228', 'supplier', 'general', '110'),
('349', '229', 'cust_branch', 'general', '119'),
('350', '229', 'customer', 'general', '123'),
('352', '231', 'supplier', 'general', '111'),
('353', '232', 'supplier', 'general', '112'),
('354', '233', 'cust_branch', 'general', '121'),
('355', '233', 'customer', 'general', '124'),
('356', '234', 'cust_branch', 'general', '122'),
('357', '234', 'customer', 'general', '125'),
('358', '235', 'supplier', 'general', '113'),
('359', '236', 'cust_branch', 'general', '123'),
('360', '236', 'customer', 'general', '126'),
('361', '237', 'supplier', 'general', '114'),
('363', '206', 'cust_branch', 'general', '113'),
('364', '239', 'cust_branch', 'general', '125'),
('365', '239', 'customer', 'general', '127'),
('366', '240', 'cust_branch', 'general', '126'),
('367', '240', 'customer', 'general', '128'),
('368', '241', 'cust_branch', 'general', '127'),
('369', '241', 'customer', 'general', '130'),
('370', '242', 'cust_branch', 'general', '128'),
('371', '242', 'customer', 'general', '131'),
('372', '243', 'cust_branch', 'general', '129'),
('373', '243', 'customer', 'general', '132'),
('374', '244', 'cust_branch', 'general', '130'),
('375', '244', 'customer', 'general', '133'),
('376', '245', 'cust_branch', 'general', '131'),
('377', '245', 'customer', 'general', '134'),
('378', '246', 'cust_branch', 'general', '132'),
('379', '246', 'customer', 'general', '135'),
('380', '247', 'cust_branch', 'general', '133'),
('381', '247', 'customer', 'general', '136'),
('382', '248', 'supplier', 'general', '115'),
('383', '249', 'cust_branch', 'general', '134'),
('384', '249', 'customer', 'general', '137'),
('385', '250', 'cust_branch', 'general', '135'),
('386', '250', 'customer', 'general', '138'),
('387', '251', 'cust_branch', 'general', '136'),
('388', '251', 'customer', 'general', '139'),
('391', '253', 'supplier', 'general', '116'),
('392', '254', 'cust_branch', 'general', '138'),
('393', '254', 'customer', 'general', '141'),
('394', '255', 'supplier', 'general', '117'),
('395', '256', 'cust_branch', 'general', '139'),
('396', '256', 'customer', 'general', '142'),
('397', '257', 'supplier', 'general', '118'),
('398', '258', 'supplier', 'general', '119'),
('399', '259', 'cust_branch', 'general', '140'),
('400', '259', 'customer', 'general', '143'),
('401', '260', 'cust_branch', 'general', '141'),
('402', '260', 'customer', 'general', '144'),
('403', '261', 'cust_branch', 'general', '142'),
('404', '261', 'customer', 'general', '145'),
('405', '262', 'supplier', 'general', '120'),
('406', '263', 'supplier', 'general', '121'),
('407', '264', 'supplier', 'general', '122'),
('408', '265', 'supplier', 'general', '123'),
('409', '266', 'cust_branch', 'general', '143'),
('410', '266', 'customer', 'general', '146'),
('411', '267', 'supplier', 'general', '124'),
('412', '268', 'cust_branch', 'general', '144'),
('413', '268', 'customer', 'general', '147'),
('414', '269', 'supplier', 'general', '125'),
('415', '270', 'supplier', 'general', '126'),
('416', '271', 'supplier', 'general', '127'),
('417', '272', 'supplier', 'general', '128'),
('418', '273', 'supplier', 'general', '129'),
('419', '274', 'cust_branch', 'general', '145'),
('420', '274', 'customer', 'general', '148'),
('421', '275', 'cust_branch', 'general', '146'),
('422', '275', 'customer', 'general', '149'),
('423', '276', 'cust_branch', 'general', '147'),
('424', '276', 'customer', 'general', '150'),
('425', '277', 'cust_branch', 'general', '148'),
('426', '277', 'customer', 'general', '151'),
('427', '278', 'cust_branch', 'general', '149'),
('428', '278', 'customer', 'general', '152'),
('429', '279', 'cust_branch', 'general', '150'),
('430', '279', 'customer', 'general', '153'),
('431', '280', 'cust_branch', 'general', '151'),
('432', '280', 'customer', 'general', '154'),
('433', '281', 'cust_branch', 'general', '152'),
('434', '281', 'customer', 'general', '155'),
('435', '282', 'cust_branch', 'general', '153'),
('436', '282', 'customer', 'general', '156'),
('437', '283', 'cust_branch', 'general', '154'),
('438', '283', 'customer', 'general', '157'),
('439', '284', 'cust_branch', 'general', '155'),
('440', '284', 'customer', 'general', '158'),
('441', '285', 'supplier', 'general', '130'),
('442', '286', 'cust_branch', 'general', '156'),
('443', '286', 'customer', 'general', '159'),
('444', '287', 'cust_branch', 'general', '157'),
('445', '287', 'customer', 'general', '160'),
('446', '288', 'cust_branch', 'general', '158'),
('447', '288', 'customer', 'general', '161'),
('448', '289', 'cust_branch', 'general', '159'),
('449', '289', 'customer', 'general', '162'),
('450', '290', 'cust_branch', 'general', '160'),
('451', '290', 'customer', 'general', '163'),
('452', '291', 'cust_branch', 'general', '161'),
('453', '291', 'customer', 'general', '164'),
('454', '292', 'cust_branch', 'general', '162'),
('455', '292', 'customer', 'general', '165'),
('456', '293', 'cust_branch', 'general', '163'),
('457', '293', 'customer', 'general', '166'),
('458', '294', 'cust_branch', 'general', '164'),
('459', '294', 'customer', 'general', '167'),
('460', '295', 'cust_branch', 'general', '165'),
('461', '295', 'customer', 'general', '168'),
('462', '296', 'cust_branch', 'general', '166'),
('463', '296', 'customer', 'general', '169'),
('464', '297', 'cust_branch', 'general', '167'),
('465', '297', 'customer', 'general', '170'),
('466', '298', 'cust_branch', 'general', '168'),
('467', '298', 'customer', 'general', '171'),
('468', '299', 'cust_branch', 'general', '169'),
('469', '299', 'customer', 'general', '172'),
('470', '300', 'cust_branch', 'general', '170'),
('471', '300', 'customer', 'general', '173'),
('472', '301', 'cust_branch', 'general', '171'),
('473', '301', 'customer', 'general', '174'),
('474', '302', 'cust_branch', 'general', '172'),
('475', '302', 'customer', 'general', '175'),
('476', '303', 'cust_branch', 'general', '173'),
('477', '303', 'customer', 'general', '176'),
('478', '304', 'cust_branch', 'general', '174'),
('479', '304', 'customer', 'general', '177'),
('480', '305', 'cust_branch', 'general', '175'),
('481', '305', 'customer', 'general', '179'),
('482', '306', 'cust_branch', 'general', '176'),
('483', '306', 'customer', 'general', '180'),
('484', '307', 'cust_branch', 'general', '177'),
('485', '307', 'customer', 'general', '181'),
('486', '308', 'cust_branch', 'general', '178'),
('487', '308', 'customer', 'general', '182'),
('488', '309', 'cust_branch', 'general', '179'),
('489', '309', 'customer', 'general', '183'),
('490', '310', 'cust_branch', 'general', '180'),
('491', '310', 'customer', 'general', '184'),
('492', '311', 'cust_branch', 'general', '181'),
('493', '311', 'customer', 'general', '185'),
('494', '312', 'cust_branch', 'general', '182'),
('495', '312', 'customer', 'general', '186'),
('496', '313', 'cust_branch', 'general', '183'),
('497', '313', 'customer', 'general', '187'),
('498', '314', 'cust_branch', 'general', '184'),
('499', '314', 'customer', 'general', '188'),
('500', '315', 'cust_branch', 'general', '185'),
('501', '315', 'customer', 'general', '189'),
('502', '316', 'cust_branch', 'general', '186'),
('503', '316', 'customer', 'general', '190'),
('504', '317', 'cust_branch', 'general', '187'),
('505', '317', 'customer', 'general', '191'),
('506', '318', 'cust_branch', 'general', '188'),
('507', '318', 'customer', 'general', '192'),
('508', '319', 'cust_branch', 'general', '189'),
('509', '319', 'customer', 'general', '193'),
('510', '320', 'cust_branch', 'general', '190'),
('511', '320', 'customer', 'general', '194'),
('512', '321', 'cust_branch', 'general', '191'),
('513', '321', 'customer', 'general', '195'),
('514', '322', 'cust_branch', 'general', '192'),
('515', '322', 'customer', 'general', '196'),
('516', '323', 'cust_branch', 'general', '193'),
('517', '323', 'customer', 'general', '197'),
('518', '324', 'cust_branch', 'general', '194'),
('519', '324', 'customer', 'general', '198'),
('520', '325', 'cust_branch', 'general', '195'),
('521', '325', 'customer', 'general', '199'),
('522', '326', 'cust_branch', 'general', '196'),
('523', '326', 'customer', 'general', '200'),
('524', '327', 'cust_branch', 'general', '197'),
('525', '327', 'customer', 'general', '201'),
('526', '328', 'cust_branch', 'general', '198'),
('527', '328', 'customer', 'general', '202'),
('528', '329', 'cust_branch', 'general', '199'),
('529', '329', 'customer', 'general', '203'),
('530', '330', 'cust_branch', 'general', '200'),
('531', '330', 'customer', 'general', '204'),
('532', '331', 'cust_branch', 'general', '201'),
('533', '331', 'customer', 'general', '205'),
('534', '332', 'cust_branch', 'general', '202'),
('535', '332', 'customer', 'general', '206'),
('536', '333', 'cust_branch', 'general', '203'),
('537', '333', 'customer', 'general', '207'),
('538', '334', 'supplier', 'general', '131'),
('539', '335', 'cust_branch', 'general', '204'),
('540', '335', 'customer', 'general', '208'),
('541', '336', 'cust_branch', 'general', '205'),
('542', '336', 'customer', 'general', '209'),
('543', '337', 'cust_branch', 'general', '206'),
('546', '337', 'customer', 'general', '210'),
('547', '338', 'cust_branch', 'general', '207'),
('549', '338', 'customer', 'general', '211'),
('550', '339', 'cust_branch', 'general', '208'),
('551', '339', 'customer', 'general', '212'),
('552', '340', 'cust_branch', 'general', '209'),
('553', '340', 'customer', 'general', '213'),
('554', '341', 'cust_branch', 'general', '210'),
('555', '341', 'customer', 'general', '214'),
('556', '342', 'cust_branch', 'general', '211'),
('557', '342', 'customer', 'general', '215'),
('558', '343', 'cust_branch', 'general', '212'),
('559', '343', 'customer', 'general', '216'),
('560', '344', 'cust_branch', 'general', '213'),
('561', '344', 'customer', 'general', '217'),
('562', '345', 'cust_branch', 'general', '214'),
('563', '345', 'customer', 'general', '218'),
('564', '346', 'cust_branch', 'general', '215'),
('565', '346', 'customer', 'general', '219'),
('566', '347', 'cust_branch', 'general', '216'),
('567', '347', 'customer', 'general', '220'),
('568', '348', 'cust_branch', 'general', '217'),
('569', '348', 'customer', 'general', '221'),
('570', '349', 'cust_branch', 'general', '218'),
('571', '349', 'customer', 'general', '222'),
('572', '350', 'cust_branch', 'general', '219'),
('573', '350', 'customer', 'general', '223'),
('574', '351', 'cust_branch', 'general', '220'),
('575', '351', 'customer', 'general', '224'),
('576', '352', 'cust_branch', 'general', '221'),
('577', '352', 'customer', 'general', '225'),
('578', '353', 'cust_branch', 'general', '222'),
('579', '353', 'customer', 'general', '226'),
('580', '354', 'cust_branch', 'general', '223'),
('581', '354', 'customer', 'general', '227'),
('582', '355', 'supplier', 'general', '132'),
('583', '356', 'cust_branch', 'general', '224'),
('584', '356', 'customer', 'general', '228'),
('585', '357', 'cust_branch', 'general', '225'),
('586', '357', 'customer', 'general', '229'),
('587', '358', 'cust_branch', 'general', '226'),
('588', '358', 'customer', 'general', '230'),
('589', '359', 'cust_branch', 'general', '227'),
('590', '359', 'customer', 'general', '231'),
('591', '360', 'cust_branch', 'general', '228'),
('592', '361', 'cust_branch', 'general', '229'),
('593', '361', 'customer', 'general', '232'),
('594', '362', 'cust_branch', 'general', '230'),
('595', '362', 'customer', 'general', '233'),
('596', '363', 'cust_branch', 'general', '231'),
('597', '363', 'customer', 'general', '234'),
('598', '364', 'cust_branch', 'general', '232'),
('599', '364', 'customer', 'general', '235'),
('600', '365', 'cust_branch', 'general', '233'),
('601', '365', 'customer', 'general', '236'),
('602', '366', 'cust_branch', 'general', '234'),
('603', '366', 'customer', 'general', '237'),
('604', '367', 'cust_branch', 'general', '235'),
('605', '367', 'customer', 'general', '238'),
('606', '368', 'cust_branch', 'general', '236'),
('607', '368', 'customer', 'general', '239'),
('608', '369', 'cust_branch', 'general', '237'),
('609', '369', 'customer', 'general', '240'),
('610', '370', 'cust_branch', 'general', '238'),
('611', '370', 'customer', 'general', '241'),
('612', '371', 'cust_branch', 'general', '239'),
('613', '371', 'customer', 'general', '242'),
('614', '372', 'cust_branch', 'general', '240'),
('615', '372', 'customer', 'general', '243'),
('616', '373', 'supplier', 'general', '133'),
('617', '374', 'supplier', 'general', '134'),
('618', '375', 'cust_branch', 'general', '241'),
('619', '375', 'customer', 'general', '244'),
('620', '376', 'supplier', 'general', '135'),
('621', '377', 'cust_branch', 'general', '242'),
('622', '377', 'customer', 'general', '245'),
('623', '378', 'cust_branch', 'general', '243'),
('624', '378', 'customer', 'general', '246'),
('625', '379', 'cust_branch', 'general', '244'),
('626', '379', 'customer', 'general', '247'),
('627', '380', 'cust_branch', 'general', '245'),
('628', '380', 'customer', 'general', '249'),
('629', '381', 'cust_branch', 'general', '246'),
('630', '381', 'customer', 'general', '250'),
('631', '382', 'cust_branch', 'general', '247'),
('632', '382', 'customer', 'general', '251');

### Structure of table `0_crm_opportunity` ###

DROP TABLE IF EXISTS `0_crm_opportunity`;

CREATE TABLE `0_crm_opportunity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cont_per_id` int(11) NOT NULL COMMENT 'This id relate to the contact Person Table Contact Form',
  `oppr_list` varchar(200) NOT NULL,
  `remarks` varchar(200) NOT NULL,
  `status` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `trans_date` varchar(100) NOT NULL,
  `attach` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_crm_opportunity` ###


### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `name` varchar(60) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=383 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'A. A. A. Shuhail Alqahta', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'A. W. Building Material', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'A. M &amp; COMMUNICATION', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'Antique Style', 'Antique Style', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'A.Purgos', 'Arnesto Purgos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'B.P.EMIRATES LTD CO ', 'BERGER PAINTS EMIRATES LTD CO (LLC)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'B.C.LLC', 'BIC Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'Bindhahi Trading LLC', 'Bindhahi Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'C.B.DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'C. E. Interior Decorat LLC', 'Core Elements Interior Decoration LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'Decortser Portal', 'Decortser Portal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'D.G.Contracting Co LLC', 'Discovery  General Contracting Co LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'Dr. Laya', 'Dr. Laya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'Dr. Rehmina', 'Dr. Rehmina', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'I. Abdul Rahim Shaaban Mohamed', 'Ismail Abdul Rahim Shaaban Mohamed', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'Jalal Merchant', 'Jalal Merchant', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'KOA R.E.DEVELOPMENT LLC', 'KOA REAL ESTATE DEVELOPMENT LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'Mr. AD', 'Mr. AD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'Mr. Alaa', 'Mr. Alaa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'Mr . Amit', 'Mr . Amit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'Mr Ashok', 'Mr Ashok', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('31', 'Mr.Dinesh', 'Mr.Dinesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('33', 'Mr. Haresh', 'Mr. Haresh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'Mr Hasan', 'Mr Hasan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'Mr. Ibrahim', 'Mr. Ibrahim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'Mr. James', 'Mr. James', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('41', 'Mr.Neeraj', 'Mr.Neeraj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('42', 'Mr. Prabhat', 'Mr. Prabhat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'Mr.Rajesh', 'Mr.Rajesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'Mr. Saqlain', 'Mr. Saqlain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('49', 'Ms. Ahiliya', 'Ms. Ahiliya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'Ms. Loulwa', 'Ms. Loulwa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('53', 'Ms. Roda', 'Ms. Roda', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'Ms.Swarn', 'Ms.Swarn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'Ms. Thanuja', 'Ms. Thanuja', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('56', 'Ms. Yogitha', 'Ms. Yogitha', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', NULL, 'Dubai', '(971) 5-037-42446__', NULL, NULL, 'lh@koa.ae', NULL, '', '0'),
('58', 'NATURAL TRENDY TIL&amp;FLOOR M', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'QEXPRESS', 'QEXPRESS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'R. H. REAL ESTATE BROKERS', 'RIGHT HOMES REAL ESTATE BROKERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('68', 'Sajith Ansar', 'Sajith Ansar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('69', 'Sustainable Builders', 'Sustainable Builders', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'Techforce Technical Services', 'Techforce Technical Services', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'Al Anfaal Garage EST.', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('74', 'Fine Tools Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('75', 'F. C. I. Decoration LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('76', 'Hidayath Trading Company LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'H. G. T. EST (Branch)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'JIHAN BLDG. MAT. &amp; PAINTS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('79', 'K.A.N. Technical Services LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('80', 'N. A. S.BUILDING MATERIALS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'P. B. Materials Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'Q. A.H. Aljadeed Gen.Trdg .LLc', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'R. A.B. Technical Services LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('84', 'Risala Furniture LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'R.A.B. Materials  Tradinf LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'S. ALJAZEERA AUTO REPAIRING', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'Spectrum Tent Manufacturing', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'Y. E. R. &amp; REPAIRING LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('89', 'AAFOQ Islamic Finance', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('90', 'A. Business Center (Tasheel)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('91', 'BALGHANI STORES LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('92', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'Emirates Driving Institute', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'Glare Technologies', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('95', 'Lex Consortia FZ LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('96', 'N. A. M. Trading (L.L.C) Br', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('97', 'SHADMAN TENTS IND LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('98', 'Souq.Com FZ LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('99', 'SUPER GENERAL COMPANY LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('100', 'The Excelerate Enterprises DMC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('101', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('102', 'D. E. &amp; WATER AUTHORITY', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('103', 'D. I. I. &amp;RE INSURANCE CO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('104', 'E.T G. Company (Etisalat)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('105', 'Purchase Bills to Come', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('106', 'Cash Customer', 'Cash Customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('107', 'Bindhahi Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('108', 'HAMMER BUILDING MAINTENANCE LL', 'HAMMER BUILDING MAINTENANCE LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('109', 'Emirates Telecommunications Gr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('110', 'BERGER PAINTS EMIRATES LTD CO', 'BERGER PAINTS EMIRATES LTD CO (LLC)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('111', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('112', 'Naga Lakshmi', 'Naga Lakshmi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('113', 'Good Steam Auto Center', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('114', 'NOOR TAKAFUL GENERAL (PJSC)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('115', 'Al Sharq Media LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('116', 'Modern Seal Insulation Contrac', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('117', 'Alanas Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('118', 'Chittagong Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('119', 'Emirates Post Group', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('120', 'Abdelaziz Abdelrahman Abdelazi', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('121', 'Broadway Building Materials LL', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('122', 'RTA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('123', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('124', 'Big Foot Koncepts LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('125', 'ROYAL GRAND BUILDING MATERIALS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('126', 'ADSS MARKETING &amp; COMMUNICA', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('127', 'He BEI Gao Yang Qi Chang Texti', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('128', 'EPIC TRAVEL LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('129', 'Saif Al Burhan Traders LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('130', 'SAFINAT AL BAHAR BUILDING MATE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('131', 'Arabian Business Center (Tashe', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('132', 'Fine Tools Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('133', 'AFRICA INTERNET GENERAL TRADIN', 'AFRICA INTERNET GENERAL TRADING LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('134', 'Al Anfaal Garage EST.', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('135', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('136', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('137', 'Fine Tools Equipment Repairing', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('138', '&quot;Aevolve Beauty Saloon &amp;q', '&quot;Aevolve Beauty Saloon &quot;', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('139', 'Mega City Building Materilas T', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('140', 'YASMAC EQUIPMENT RENTAL &amp; ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('141', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('142', 'Ghulam Mustafa Construction Eq', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('143', 'Vijaya Chikermane', 'Vijaya Chikermane', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('144', 'Team One Glass &amp; Aluminum ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('145', 'Bawabt Al Hemreya Car Seat Uph', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('146', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('147', 'Al Barsha Tyres &amp; Battery ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('148', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('149', 'Angel Cakes', 'Angel Cakes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('150', 'AQS Management Consultancy', 'AQS Management Consultancy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('151', 'Naresh Mohnani', 'Naresh Mohnani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('152', 'ARABIAN SAND WASHING LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('153', 'Smooth Solution Building Mater', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('154', 'Luigi Dsouza', 'Luigi Dsouza', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('155', 'Jumeirah Carpenter BR', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('156', 'Mega Fix Tyres &amp; Auto Care', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('157', 'IN Focus Glass and Aluminium W', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('158', 'Shades General Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('159', 'Progress Profiles Middle East ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('160', 'Nasser Al Matrooshi Trading (L', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('161', 'O.U.N Building Materials LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('162', 'MOHD AL QAMA CERAMICS TRADING ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('163', 'Al Burhan Prints LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('164', 'Wayz Consulting', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('165', 'MAS PAINTS &amp; CHEMICALS IND', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('166', 'GULF PAINTS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('167', 'NAJRAN GENERAL TRADING', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('168', 'Jai Electricals LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('169', 'DUKE STEEL TRADING CO (L.L.C)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('170', 'BAB AL SAFA CAR ACCESSORIES AN', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('171', 'SALAHALDIN CAR ACCESSORIES FIX', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('172', 'Al Aksa Technical &amp;Cleanin', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('173', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('174', 'Ms. Alita', 'Ms. Alita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('175', 'Ish Stars Technical Services', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('176', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('177', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('178', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('179', 'Mr Tahir', 'Mr Tahir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('180', 'Led Corner Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('181', 'RUI KANG TRADING FZCO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('182', 'Tools R Us LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('183', 'salim lokhand.', 'Salim Lokhandwala', NULL, 'Dubai Hills\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('184', 'Bridge Forth &amp; Signature', 'Bridge Forth &amp; Signature Contracting Co. LLC', NULL, 'PO BOX 99856\nDUBAI', '044-413-886__', NULL, NULL, NULL, NULL, '', '0'),
('185', 'nour', 'Ms. Nour', NULL, 'Springs 11, street 2, villa 36\nDubai', '971-503-40686', NULL, NULL, NULL, NULL, '', '0'),
('186', 'Al Anas Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('187', 'Milad Interior Design', 'Milad Interior Design', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('188', 'Majid Al Falasi', 'Majid Al Falasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('189', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', NULL, NULL, '971-543-03879', NULL, NULL, NULL, NULL, '', '0'),
('190', 'Miscellaneous Supplier', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('191', 'Advance to Abdullah Nepali', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('192', 'Clear View Interiors', 'Clear View Interiors', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, 'Mr. Taha Ahmed', '0'),
('193', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', NULL, 'Dubai', '971-553-75555', NULL, NULL, NULL, NULL, '', '0'),
('194', 'Suzena', 'Suzena', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('195', 'Akhil Vinayak', 'Akhil Vinayak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('196', 'Hussain General Trading EST. ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('197', 'Fatma Al Rais', 'Ms. Fatma Al Rais', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('198', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('199', 'PAVIMENTO GENERAL TRDG LLC', 'PAVIMENTO GENERAL TRADING L.L.C', NULL, 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '971-568-19654', NULL, NULL, NULL, NULL, '', '0'),
('200', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', NULL, 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '971-555-80234', NULL, NULL, NULL, NULL, '', '0'),
('201', 'Al fly Trading FZCO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('202', 'Otaly Trading FZCO ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('203', 'Grand al khail auto garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('204', 'Yogesh', 'Yogesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('205', 'I 2 D Interiors', 'I 2 D Interiors', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('206', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('207', 'Imran Qasim (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('208', 'The international school of ch', 'The international school of choueifat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('209', 'RALTS CONTRACTING', 'RALTS CONTRACTING', NULL, NULL, '042-383-353__', NULL, NULL, NULL, NULL, '', '0'),
('210', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('211', 'Star brothers auto repairing', '', NULL, NULL, '050-829-2384_', NULL, NULL, NULL, NULL, '', '0'),
('212', 'Johns Paints Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('213', 'Muhammed Adeel ( Employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('214', 'Abid Hussain ( Employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('215', 'Colart Publishing &amp; Adv. L', 'Colart Publishing &amp; Advertising LLC', NULL, 'PO Box 49652\nDUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('216', 'Ms. Arpita', 'Ms. Arpita', NULL, NULL, '971-557-92060', NULL, NULL, NULL, NULL, '', '0'),
('217', 'AKBAR ALI KHAN  ALI KHAN (empl', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('218', 'ARSLAN NADEEM NADEEM MAZHAR (e', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('219', 'BIR SINGH (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('220', 'DURGALAL NEPALI (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('221', 'MUHAMMAD AKHTAR (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('222', 'MUHAMMAD IBRAR (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('223', 'MUHAMMAD USAMA (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('224', 'SHAHID FAROOQ  (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('225', 'SHAKEEL AHMED ( employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('226', 'TAUHEED AHMED (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('227', 'ZEESHAN ALI  ( employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('228', 'Mr. Jamal Al Ali', '', NULL, 'ajman', NULL, NULL, NULL, NULL, NULL, '', '0'),
('229', 'Turnkey fitout solutions', 'Turnkey fitout solutions', NULL, 'po box # 47862\nDubai', '(045) 8-065-53_____', NULL, NULL, NULL, NULL, '', '0'),
('230', 'horeb parmar', 'horeb parmar', NULL, NULL, '(054) 7-929-474____', NULL, NULL, NULL, NULL, '', '0'),
('231', 'Latif Musa Air Condition Rpr &amp;', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('232', 'TIAN FA STONE MATERIAL TRADING', '', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('233', 'kalyan chakravarthy', 'kalyan chakravarthy', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('234', 'Harun Sultan', 'Harun Sultan', NULL, 'Ajman', NULL, NULL, NULL, NULL, NULL, '', '0'),
('235', 'Al Zujaj Al Azraq Aluminium &amp;a', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('236', 'VERVE INTERIOR  DECORATION L.L', 'VERVE INTERIOR  DECORATION L.L.C', NULL, 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '042-400-119__', NULL, NULL, NULL, NULL, '', '0'),
('237', 'Royal Hammer Trading LLC', '', NULL, NULL, '04_-399-1753_', NULL, NULL, NULL, NULL, '', '0'),
('238', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('239', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('240', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', NULL, 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '(971) 5-662-54662__', NULL, NULL, NULL, NULL, '', '0'),
('241', 'Kitchenscape Domestic Kitchens', 'Kitchenscape Domestic Kitchens LLC', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('242', 'GREEN TERRA TECHNICAL SERVICES', 'GREEN TERRA TECHNICAL SERVICES LLC', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('243', 'Ms. Serena', 'Ms. Serena', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('244', 'Highrise Owners Association Ma', 'Highrise Owners Association Management (HOAM)', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('245', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', NULL, 'Po Box # 60288\nDIP\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('246', 'Beenish Haider', 'Beenish Haider', NULL, NULL, '055-117-5311_', NULL, NULL, NULL, NULL, '', '0'),
('247', 'Meherz Kreation LLC', 'Meherz Kreation LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('248', 'Pioneer Insurance Broker LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('249', 'WASL PROPERTIES', 'WASL PROPERTIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('250', 'Modern Seal Insulation Soln', 'Modern Seal Insulation Solutions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('251', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('252', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('253', 'Shandong Hele( Middle East) In', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('254', 'Mr. Rajiv', 'Mr. Rajiv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('255', 'shaikh saeed mohammed Hasher A', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('256', 'Fincirc International Manageme', 'Fincirc International Management', NULL, 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '045-126-800__', NULL, NULL, NULL, NULL, '', '0'),
('257', 'faqihi Enterprises LLC (BR)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('258', 'Laspinas Building Materials Tr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('259', 'Ms. Shweta', 'Ms. Shweta', NULL, 'Dubai', '971-505-54754', NULL, NULL, NULL, NULL, '', '0'),
('260', 'Pooja Shah Mulani', 'Pooja Shah Mulani', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('261', 'MXTS office Jebel Ali								', 'Mr Xpert technical Services New Office Jebel Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('262', 'Panache Building Materials Tra', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('263', 'Mohd. Al Qama General Trading ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('264', 'Technos Multiline LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('265', 'Ibrahim Abbas Ali Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('266', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', NULL, 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '(065) 7-743-111____', NULL, NULL, NULL, NULL, '', '0'),
('267', 'DUBAI ELECTRICITY &amp; WATER ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('268', 'Sanqour advertising service', 'Sanqour advertising service', NULL, 'Al Zahiya, Abu Dhabi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('269', 'Al Dhaw Al Wahaj Electrical &amp;a', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('270', 'Romana Water Industries LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('271', 'Faizal system fixing contracti', '', NULL, NULL, '(050) 9-275-773____', NULL, NULL, NULL, NULL, '', '0'),
('272', 'Noor Al Fajr Elect. Devices Tr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('273', 'Mohd.AL Qama Building Materila', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('274', 'EL TEAM', 'EL TEAM LTD FZE - Sharjah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('275', 'Wool Craft  Trading', 'Wool Craft  Trading', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('276', 'Afaq Al Waseqh Electromech', 'Afaq Al Waseqh Electromechanical Services LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('277', 'MR. YU', 'MR. YU', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('278', 'Astro properties', 'Astro properties', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('279', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', NULL, 'P.O. Box – 48746,\nDubai, UAE\n', '971-433-26233', NULL, NULL, 'info@bfmatech.com ', NULL, '', '0'),
('280', 'Mr. Hadisfer', 'Mr. Hadisfer', NULL, 'Villa 47 Hattan One Arabian Ranches', '052-815-4488_', NULL, NULL, NULL, NULL, '', '0'),
('281', 'JAMTS Tech LLC', 'JAMTS Tech LLC', NULL, 'PO Box 71893', '(055) 2-975-999____', NULL, NULL, NULL, NULL, '', '0'),
('282', 'Sofitel Dubai The Palm', 'Sofitel Dubai The Palm', NULL, 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '971-445-55471', NULL, NULL, NULL, NULL, '', '0'),
('283', 'Rahul Ranbhare', 'Rahul Ranbhare', NULL, 'G05, Fortunato 1, JVC', '971-558-12606', NULL, NULL, NULL, NULL, '', '0'),
('284', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', NULL, 'Villa 349 Hayat townhouses', '971-565-65944', NULL, NULL, NULL, NULL, '', '0'),
('285', 'Dubai Coast Trading  [LLC]', '', NULL, NULL, '042-212-766__', NULL, '042270025', NULL, NULL, '', '0'),
('286', 'HOAM Highrise Owners ', 'HOAM Highrise Owners Association Management', NULL, '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '971-433-95558', NULL, NULL, NULL, NULL, '', '0'),
('287', 'Al Hai Motors', 'Al Hai Motors', NULL, 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '055-555-6656_', NULL, NULL, NULL, NULL, '', '0'),
('288', 'Noma Design House', 'Noma Design House', NULL, 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '971-523-29615', NULL, NULL, NULL, NULL, '', '0'),
('289', 'Ms. Nissreen', 'Ms. Nissreen', NULL, 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('290', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', NULL, 'Villa 127 Picadilly Green Damac Hills', '054-582-2614_', NULL, NULL, NULL, NULL, '', '0'),
('291', 'La Stella productions', 'La Stella productions', NULL, 'Al Qouz Dubai\n', '055-984-3848_', NULL, NULL, NULL, NULL, '', '0'),
('292', 'Mr. Habib Nahra', 'Mr. Habib Nahra', NULL, NULL, '058-591-2469_', NULL, NULL, NULL, NULL, '', '0'),
('293', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', NULL, 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '(050) 8-771-798____', NULL, NULL, NULL, NULL, '', '0'),
('294', 'One Laundry', 'One Laundry', NULL, '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '043-247-680__', NULL, NULL, NULL, NULL, '', '0'),
('295', 'ALI FARHAN TECHNICAL SERVICES ', 'ALI FARHAN TECHNICAL SERVICES LLC', NULL, 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '055-427-0717_', '(050) 78-558-05___', NULL, NULL, NULL, '', '0'),
('296', 'Mr. Hisham', 'Mr. Hisham', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('297', 'Mrs.Sumeira', 'Mrs.Sumeira', NULL, 'Villa F 41 Golf Course Villas', '052-176-4340_', NULL, NULL, NULL, NULL, '', '0'),
('298', 'Dinesh Sanghvi', 'Dinesh Sanghvi', NULL, NULL, '971-504-54946', NULL, NULL, NULL, NULL, '', '0'),
('299', 'Unitra International LLC', 'Unitra International LLC', NULL, 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '971-470-24700', NULL, NULL, 'Murad.Alashhab@mezzan.com ', NULL, '', '0'),
('300', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('301', 'GDM Interiors LLC', 'GDM Interiors LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('302', 'Vishesh Singhania ', 'Vishesh Singhania ', NULL, NULL, '052-749-3357_', NULL, NULL, NULL, NULL, '', '0'),
('303', 'Imperial Avenue', 'Imperial Avenue', NULL, 'Dubai -UAE', '971-559-39446', NULL, NULL, NULL, NULL, '', '0'),
('304', 'Shaul Nagawkar ', 'Shaul Nagawkar ', NULL, 'Apt 705 Tower F Executive Tower - Business Bay', '971-554-03407', NULL, NULL, NULL, NULL, '', '0'),
('305', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', NULL, ' Al Ain Road', '050-753-5444_', NULL, NULL, NULL, NULL, '', '0'),
('306', 'ABDULLA DARWISH GHULOOM AHMED ', 'ABDULLA DARWISH GHULOOM AHMED BAQER', NULL, 'Villa 32 Al Warqa', '971-505-54500', NULL, NULL, NULL, NULL, '', '0'),
('307', 'Rabia Ahmed ', 'Rabia Ahmed ', NULL, NULL, '971-585-06107', NULL, NULL, NULL, NULL, '', '0'),
('308', 'Kakul Technical Services', 'Kakul Technical Services', NULL, 'DUBAI', '056-822-5649_', NULL, NULL, NULL, NULL, '', '0'),
('309', 'Riham AlAli', 'Riham AlAli', NULL, 'Villa 102,Al Barsha,dubai', '971-521-38404', NULL, NULL, NULL, NULL, '', '0'),
('310', 'Blacksmith Coffee', 'Blacksmith Coffee', NULL, 'dubai', '050-899-1223_', NULL, NULL, NULL, NULL, '', '0'),
('311', 'Sangeet Jain', 'Sangeet Jain', NULL, 'Villa 33 Al Naseem Mudon', '971-567-33689', NULL, NULL, NULL, NULL, '', '0'),
('312', 'Stone House Real Estate Broker', 'Stone House Real Estate Brokerage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('313', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', NULL, '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '971-553-47587', NULL, NULL, NULL, NULL, '', '0'),
('314', 'Warriors Aluminum and Glass', 'Warriors Aluminum and Glass Cont. LLC ', NULL, 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '971-554-15254', NULL, NULL, 'info@warriorslandscape.ae ', NULL, '', '0'),
('315', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', NULL, 'PO Box 2748 Sharjah', '065-344-379__', NULL, NULL, NULL, NULL, '', '0'),
('316', 'High Power Services', 'High Power Services', NULL, 'PO Box 57467 Dubai.\n', '056-505-8126_', NULL, NULL, NULL, NULL, '', '0'),
('317', 'Ms. Charu', 'Ms. Charu', NULL, 'Karama,DUBAI', '971-506-34851', NULL, NULL, NULL, NULL, '', '0'),
('318', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', NULL, 'Villa 1, Ary Building Dubai Marina', '050-928-8744_', NULL, NULL, NULL, NULL, '', '0'),
('319', 'Star Revive Medical Center', 'Star Revive Medical Center', NULL, 'jumeirah', '(043) 3-344-61_____', NULL, NULL, NULL, NULL, '', '0'),
('320', 'Phoenix Middle East', 'Phoenix Middle East', NULL, 'DIP 2 ,Dubai', '050-106-4845_', NULL, NULL, NULL, NULL, '', '0'),
('321', 'MENAWATT TECHNICAL SERVICES ', 'MENAWATT TECHNICAL SERVICES EST.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('322', 'Mond Trading Services', 'Mond Trading Services', NULL, 'warehouse 141', '056-787-8070_', NULL, NULL, NULL, NULL, '', '0'),
('323', 'Jean Paul Schmidt', 'Jean Paul Schmidt', NULL, 'Emaar South Villa 213', '971-566-89875', NULL, NULL, NULL, NULL, '', '0'),
('324', 'Frederic de Melker', 'Frederic de Melker', NULL, 'City Walk Building 10, app 309', '971-551-09783', NULL, NULL, NULL, NULL, '', '0'),
('325', 'GULFLINE CONST. METALIC PARTS ', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', NULL, 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '971-652-82233', NULL, NULL, NULL, NULL, '', '0'),
('326', 'Abu Dhabi Entertainment ', 'Abu Dhabi Entertainment Company ', NULL, 'P.O. Box 862, Abu Dhabi, UAE', '971-240-34200', '(971) 56-651-8131_', NULL, 'mohammed.ashif@adecmanagement.ae', NULL, '', '0'),
('327', 'Mrs. Marie', 'Mrs. Marie', NULL, 'Villa 205, Maeen 4, The Lakes', '056-992-3062_', NULL, NULL, NULL, NULL, '', '0'),
('328', 'Best Choice Trading LLC', 'Best Choice Trading LLC', NULL, NULL, '043-396-669__', NULL, NULL, NULL, NULL, '', '0'),
('329', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', NULL, 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '971-568-51047', NULL, NULL, NULL, NULL, '', '0'),
('330', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', NULL, 'Jumeirh Park Dubai', '055-815-7066_', NULL, NULL, NULL, NULL, '', '0'),
('331', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', NULL, '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '971-545-81932', NULL, NULL, NULL, NULL, '', '0'),
('332', 'Yashin Lalloo', 'Yashin Lalloo', NULL, 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('333', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', NULL, 'Al Qouz Villa 7', '050-657-6567_', NULL, NULL, NULL, NULL, '', '0'),
('334', 'Suitecase Holidays FZE LLC', '', NULL, NULL, '052-729-2815_', NULL, NULL, NULL, NULL, '', '0'),
('335', 'Waht Alhams Technical services', 'Waht Alhams Technical services EST', NULL, NULL, '(050) 4-213-305____', NULL, NULL, NULL, NULL, '', '0'),
('336', 'Mrs. Anna', 'Mrs. Anna', NULL, 'Villa 17 Trixis, Damac Hills 2 Akoya', '052-765-5584_', NULL, NULL, NULL, NULL, '', '0'),
('337', 'Aztec Shipping LLC', 'Aztec Shipping LLC', NULL, 'NAVEEN BNI GLADITOR', '(052) 6-866-960____', NULL, NULL, 'naveen@groupe-global.net', NULL, '', '0'),
('338', 'priyanka chugh', 'priyanka chugh', NULL, 'palm jumeirah', '(054) 4-766-556____', NULL, NULL, 'priyaankachugh@gmail.com', NULL, '', '0'),
('339', 'InsideOut Casa Technical ', 'InsideOut Casa Technical Services', NULL, NULL, '050-367-7125_', NULL, NULL, NULL, NULL, '', '0'),
('340', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', NULL, NULL, '971-526-86696', NULL, NULL, 'naveen@groupe-global.net', NULL, '', '0'),
('341', 'Ms.Priya Motiani', 'Ms.Priya Motiani', NULL, NULL, '971-554-25544', NULL, NULL, NULL, NULL, '', '0'),
('342', 'Mr. Dipak Main', 'Mr. Dipak Main', NULL, 'Villa 118 Trixis Damac 2', '971-504-95174', NULL, NULL, NULL, NULL, '', '0'),
('343', 'Design Evolution Technical Ser', 'Design Evolution Technical Service Co.', NULL, 'AL Awir', '(___) _-___-_______', '(052) 69-372-90___', NULL, NULL, NULL, '', '0'),
('344', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', NULL, 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '043-342-121__', NULL, NULL, NULL, NULL, '', '0'),
('345', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', NULL, 'PO Box 81456 Dubai UAE', '042-978-870__', NULL, NULL, NULL, NULL, '', '0'),
('346', 'English Language Private Schoo', 'English Language Private School', NULL, ' Oud Metha', '971-567-83590', NULL, NULL, NULL, NULL, '', '0'),
('347', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', NULL, 'P.O BOX 31671,DUBAI - UAE', '048-326-4400_', '(037) 05-452-4____', NULL, NULL, NULL, '', '0'),
('348', 'Mr. Chari', 'Mr. Chari', NULL, 'Villa 240 Pacifica Damac 2', '(971) 5-087-73932__', NULL, NULL, NULL, NULL, '', '0'),
('349', 'Mr. Prabhu', 'Mr. Prabhu', NULL, NULL, '(971) 5-453-46262__', NULL, NULL, NULL, NULL, '', '0'),
('350', 'Kings Speciality Restaurant LL', 'Kings Speciality Restaurant LLC', NULL, 'downtown', '(050) 9-605-266____', NULL, NULL, NULL, NULL, '', '0'),
('351', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', NULL, 'La Quinta Dubai.', '(056) 1-743-039____', NULL, NULL, NULL, NULL, '', '0'),
('352', 'Al Ghussun Advertising', 'Al Ghussun Advertising', NULL, 'PO Box 2748 Sharjah UAE', '(065) 3-443-76_____', NULL, NULL, NULL, NULL, '', '0'),
('353', 'Al Ameemi Intl Trdg LLC', 'Al Ameemi International Trading L.L.C', NULL, '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '043-351-222__', NULL, NULL, NULL, NULL, '', '0'),
('354', 'Mr. Sanjiv Soori', 'Mr. Sanjiv Soori', NULL, 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '055-726-5338_', NULL, NULL, NULL, NULL, '', '0'),
('355', 'AFAQ MAHMOOD MAHMOOD AHMAD (Em', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('356', 'IBECE ENEGY', 'IBECE ENEGY', NULL, NULL, '043-540-789__', '(056) 24-809-11___', NULL, 'mohannad.ashhab@ibecegroup.com ', NULL, '', '0'),
('357', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', NULL, 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '971-551-03723', NULL, NULL, NULL, NULL, '', '0'),
('358', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', NULL, 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('359', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', NULL, 'Villa 3704 Greens Community West', '050-561-9411_', NULL, NULL, NULL, NULL, '', '0'),
('360', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('361', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', NULL, 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '050-326-3650_', '(043) 70-988-1____', NULL, NULL, NULL, '', '0'),
('362', 'Mr. Antonio', 'Mr. Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('363', 'Mobeen Javed', 'Mobeen Javed', NULL, NULL, '971-522-36939', NULL, NULL, NULL, NULL, '', '0'),
('364', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('365', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', NULL, '14B Street Umm Ramool Rashidiya, Dubai ', '054-781-5935_', NULL, NULL, NULL, NULL, '', '0'),
('366', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', NULL, NULL, '971-567-84790', NULL, NULL, NULL, NULL, '', '0'),
('367', 'Suntac General Trading LLC', 'Suntac General Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('368', 'Wasl LLC', 'Wasl LLC', NULL, 'DUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('369', 'Mr. Brian Howarth', 'Mr. Brian Howarth', NULL, 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '(050) 1-005-462____', NULL, NULL, NULL, NULL, '', '0'),
('370', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', NULL, NULL, '971-528-61907', NULL, NULL, NULL, NULL, '', '0'),
('371', 'Hermen Thomas ', 'Hermen Thomas ', NULL, 'G 003 \nNew bridge hills 3 \nUptown motor city', '(971) 5-019-71488__', NULL, NULL, NULL, NULL, '', '0'),
('372', 'Deepak Panchariya', 'Deepak Panchariya', NULL, 'Gardenia, Wasl gate, TH 80', '971-566-83851', NULL, NULL, NULL, NULL, '', '0'),
('373', 'SERVICE FIRST GENERAL TRADING ', '', NULL, NULL, '052-496-17360', '(048) 89-569-1____', NULL, NULL, NULL, '', '0'),
('374', 'Hi Tech Pack and Trans LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('375', 'Nirav Patel', 'Nirav Patel', NULL, NULL, '971-554-09938', NULL, NULL, '‎nirav.patel@fincirc.com', NULL, '', '0'),
('376', 'Grand City Auto Services', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('377', 'Atlas Advertising', 'Atlas Advertising', NULL, NULL, '065-423-775__', NULL, NULL, NULL, NULL, '', '0'),
('378', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', NULL, 'Meadows 6 Dubai', '050-474-0506_', NULL, NULL, NULL, NULL, '', '0'),
('379', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', NULL, 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', NULL, NULL, NULL, NULL, NULL, '', '0'),
('380', 'HAMMER BUILDING MAINTENANCE LL', 'HAMMER BUILDING MAINTENANCE LLC', NULL, 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('381', 'Discovery  General Contracting', 'Discovery  General Contracting Co LLC', NULL, 'ABU DHAHBI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('382', 'BIC Contracting LLC', 'BIC Contracting LLC', NULL, 'PO Box # 10869 Dubai', '(971) 4-285-7551___', '(050) 54-609-49___', NULL, NULL, NULL, '', '0');

### Structure of table `0_cron_record` ###

DROP TABLE IF EXISTS `0_cron_record`;

CREATE TABLE `0_cron_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pdf_name` varchar(50) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `time` varchar(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cron_record` ###


### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `CurrencyName_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('UAE Dirhams', 'AED', 'AED', 'United Arab Emirates', 'Fils', '1', '', '0'),
('UK Pounds', 'GBP', '£', 'United Kingdom', 'Pence', '1', '', '0'),
('Indian Rupees', 'INR', '₹', 'India', 'Paisas', '1', '', '0'),
('Jordanian Dinar', 'JOD', 'JOD', 'Jordan', 'Cents', '1', 'دينار أردني', '0'),
('Omani Riyal', 'OMR', 'OMR', 'Oman', 'bz', '1', '', '0'),
('Pak Rupee(s)', 'PKR', 'Rs.', 'Pakistan', 'Paisa', '1', '', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` bigint(100) NOT NULL DEFAULT 0,
  `br_name` varchar(60) NOT NULL DEFAULT '',
  `branch_ref` varchar(30) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `CustName_arabic` varchar(100) NOT NULL,
  `cust_ref_arabic` varchar(100) NOT NULL,
  `br_name_arabic` varchar(100) NOT NULL,
  `br_ref_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `cust_gcc` tinyint(1) NOT NULL,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=248 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'A. A. A. Shuhail Alqahta', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('2', '3', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'A. M &amp; COMMUNICATION', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('3', '4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('4', '5', 'Antique Style', 'Antique Style', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('5', '6', 'Arnesto Purgos', 'A.Purgos', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('6', '7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('7', '8', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'B.P.EMIRATES LTD CO ', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('8', '9', 'BIC Contracting LLC', 'B.C.LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('10', '11', 'CAESARS BLUEWATERS DUBAI L.L.C', 'C.B.DUBAI L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('11', '12', 'Core Elements Interior Decoration LLC', 'C. E. Interior Decorat LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('12', '13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('13', '14', 'Decortser Portal', 'Decortser Portal', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('14', '15', 'Discovery  General Contracting Co LLC', 'D.G.Contracting Co LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('15', '16', 'Dr. Laya', 'Dr. Laya', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('16', '17', 'Dr. Rehmina', 'Dr. Rehmina', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('17', '18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('18', '19', 'Ismail Abdul Rahim Shaaban Mohamed', 'I. Abdul Rahim Shaaban Mohamed', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('19', '20', 'Jalal Merchant', 'Jalal Merchant', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('20', '21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('21', '22', 'KOA REAL ESTATE DEVELOPMENT LLC', 'KOA R.E.DEVELOPMENT LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('22', '23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('23', '24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('24', '25', 'Mr. AD', 'Mr. AD', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('25', '26', 'Mr. Alaa', 'Mr. Alaa', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('26', '27', 'Mr . Amit', 'Mr . Amit', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('27', '28', 'Mr Ashok', 'Mr Ashok', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('28', '29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('29', '30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('30', '31', 'Mr.Dinesh', 'Mr.Dinesh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('31', '32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('32', '33', 'Mr. Haresh', 'Mr. Haresh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('33', '34', 'Mr Hasan', 'Mr Hasan', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('34', '35', 'Mr. Ibrahim', 'Mr. Ibrahim', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('35', '36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('36', '37', 'Mr. James', 'Mr. James', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('37', '38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('38', '39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('39', '40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('40', '41', 'Mr.Neeraj', 'Mr.Neeraj', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('41', '42', 'Mr. Prabhat', 'Mr. Prabhat', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('42', '43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('43', '44', 'Mr.Rajesh', 'Mr.Rajesh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('44', '45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('45', '46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('46', '47', 'Mr. Saqlain', 'Mr. Saqlain', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('47', '48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('48', '49', 'Ms. Ahiliya', 'Ms. Ahiliya', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('49', '50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('50', '51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('51', '52', 'Ms. Loulwa', 'Ms. Loulwa', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('52', '53', 'Ms. Roda', 'Ms. Roda', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('53', '54', 'Ms.Swarn', 'Ms.Swarn', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('54', '55', 'Ms. Thanuja', 'Ms. Thanuja', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('55', '56', 'Ms. Yogitha', 'Ms. Yogitha', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('56', '57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('57', '58', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', 'NATURAL TRENDY TIL&amp;FLOOR M', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('58', '59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('59', '60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('60', '61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('61', '62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('62', '63', 'QEXPRESS', 'QEXPRESS', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('63', '64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('64', '65', 'RIGHT HOMES REAL ESTATE BROKERS', 'R. H. REAL ESTATE BROKERS', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('65', '66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('66', '67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('67', '68', 'Sajith Ansar', 'Sajith Ansar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('68', '69', 'Sustainable Builders', 'Sustainable Builders', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('69', '70', 'Techforce Technical Services', 'Techforce Technical Services', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('70', '71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('71', '72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('72', '73', 'Cash Customer', 'Cash Customer', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('73', '74', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('74', '75', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'BERGER PAINTS EMIRATES LTD CO', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('75', '78', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('76', '79', 'Naga Lakshmi', 'Naga Lakshmi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('77', '80', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'Abdelaziz Abdelrahman Abdelazi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('78', '81', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('79', '82', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'ADSS MARKETING &amp; COMMUNICA', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('80', '83', 'AFRICA INTERNET GENERAL TRADING LLC', 'AFRICA INTERNET GENERAL TRADIN', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('81', '84', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('82', '85', 'Aevolve Beauty Saloon ', 'Aevolve Beauty Saloon &amp;a', '', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('83', '86', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('84', '87', 'Vijaya Chikermane', 'Vijaya Chikermane', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('85', '88', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('86', '89', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', 'AL QUOZ IND 4 , DUBAI', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('87', '90', 'Angel Cakes', 'Angel Cakes', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('88', '91', 'AQS Management Consultancy', 'AQS Management Consultancy', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('89', '92', 'Naresh Mohnani', 'Naresh Mohnani', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('90', '93', 'Luigi Dsouza', 'Luigi Dsouza', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('91', '94', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('92', '95', 'Ms. Alita', 'Ms. Alita', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('93', '96', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('94', '97', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('95', '98', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('96', '99', 'Mr Tahir', 'Mr Tahir', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('97', '100', 'Salim Lokhandwala', 'salim lokhand.', 'Dubai Hills\nDubai', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai Hills\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('98', '101', 'Bridge Forth &amp; Signature Contracting Co. LLC', 'Bridge Forth &amp; Signature', 'PO BOX 99856\nDUBAI', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'PO BOX 99856\nDUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('99', '102', 'Ms. Nour', 'nour', 'Springs 11, street 2, villa 36\nDubai', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'Springs 11, street 2, villa 36\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('100', '103', 'Milad Interior Design', 'Milad Interior Design', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('101', '104', 'Majid Al Falasi', 'Majid Al Falasi', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('102', '105', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('103', '106', 'NEW CLEARVIEW DECORATION DESIGN &amp; IMPLEMENTATION', 'NEW CLEARVIEW DECORATION DESIG', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('104', '107', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', 'Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('105', '108', 'Suzena', 'Suzena', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('106', '109', 'Akhil Vinayak', 'Akhil Vinayak', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('107', '110', 'Ms. Fatma Al Rais', 'Fatma Al Rais', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('108', '111', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', 'dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('109', '112', 'PAVIMENTO GENERAL TRADING L.L.C', 'PAVIMENTO GENERAL TRDG LLC', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('110', '113', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('111', '114', 'Yogesh', 'Yogesh', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('112', '115', 'I 2 D Interiors', 'I 2 D Interiors', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('113', '116', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', 'po box 83010\nBur Dubai', '5', '2', '001', '1', '', '4510', '1200', '4510', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('114', '117', 'The international school of choueifat', 'The international school of ch', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('115', '118', 'RATLS CONTRACTING', 'RATLS CONTRACTING', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('116', '119', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('117', '120', 'Colart Publishing &amp; Advertising LLC', 'Colart Publishing &amp; Adv. L', 'PO Box 49652\nDUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 49652\nDUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('118', '121', 'Ms. Arpita', 'Ms. Arpita', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('119', '123', 'Turnkey fitout solutions', 'Turnkey fitout solutions', 'po box # 47862\nDubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'po box # 47862\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('121', '124', 'kalyan chakravarthy', 'kalyan chakravarthy', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('122', '125', 'Harun Sultan', 'Harun Sultan', 'Ajman', '12', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Ajman', '0', '', NULL, '', '', '', '', '0', '0'),
('123', '126', 'VERVE INTERIOR  DECORATION L.L.C', 'VERVE INTERIOR  DECORATION L.L', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '0', '', NULL, '', '', '', '', '0', '0'),
('125', '127', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', 'Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('126', '128', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('127', '130', 'Kitchenscape Domestic Kitchens LLC', 'Kitchenscape Domestic Kitchens', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('128', '131', 'GREEN TERRA TECHNICAL SERVICES LLC', 'GREEN TERRA TECHNICAL SERVICES', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('129', '132', 'Ms. Serena', 'Ms. Serena', 'dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('130', '133', 'Highrise Owners Association Management (HOAM)', 'Highrise Owners Association Ma', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('131', '134', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', 'Po Box # 60288\nDIP\nDubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Po Box # 60288\nDIP\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('132', '135', 'Beenish Haider', 'Beenish Haider', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('133', '136', 'Meherz Kreation LLC', 'Meherz Kreation LLC', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('134', '137', 'WASL PROPERTIES', 'WASL PROPERTIES', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('135', '138', 'Modern Seal Insulation Solutions', 'Modern Seal Insulation Soln', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('136', '139', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('138', '141', 'Mr. Rajiv', 'Mr. Rajiv', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('139', '142', 'Fincirc International Management', 'Fincirc International Manageme', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('140', '143', 'Ms. Shweta', 'Ms. Shweta', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('141', '144', 'Pooja Shah Mulani', 'Pooja Shah Mulani', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('142', '145', 'Mr Xpert technical Services New Office Jebel Ali', 'MXTS office Jebel Ali								', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('143', '146', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '0', '', NULL, '', '', '', '', '0', '0'),
('144', '147', 'Sanqour advertising service', 'Sanqour advertising service', 'Al Zahiya, Abu Dhabi', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Zahiya, Abu Dhabi', '0', '', NULL, '', '', '', '', '0', '0'),
('145', '148', 'EL TEAM LTD FZE - Sharjah', 'EL TEAM', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('146', '149', 'Wool Craft  Trading', 'Wool Craft  Trading', '', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('147', '150', 'Afaq Al Waseqh Electromechanical Services LLC', 'Afaq Al Waseqh Electromech', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('148', '151', 'MR. YU', 'MR. YU', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('149', '152', 'Astro properties', 'Astro properties', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('150', '153', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', 'P.O. Box – 48746,\nDubai, UAE\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box – 48746,\nDubai, UAE\n', '0', '', NULL, '', '', '', '', '0', '0'),
('151', '154', 'Mr. Hadisfer', 'Mr. Hadisfer', 'Villa 47 Hattan One Arabian Ranches', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 47 Hattan One Arabian Ranches', '0', '', NULL, '', '', '', '', '0', '0'),
('152', '155', 'JAMTS Tech LLC', 'JAMTS Tech LLC', 'PO Box 71893', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 71893', '0', 'Mr. Inaam', NULL, '', '', '', '', '0', '0'),
('153', '156', 'Sofitel Dubai The Palm', 'Sofitel Dubai The Palm', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('154', '157', 'Rahul Ranbhare', 'Rahul Ranbhare', 'G05, Fortunato 1, JVC', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'G05, Fortunato 1, JVC', '0', '', NULL, '', '', '', '', '0', '0'),
('155', '158', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', 'Villa 349 Hayat townhouses', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 349 Hayat townhouses', '0', '', NULL, '', '', '', '', '0', '0'),
('156', '159', 'HOAM Highrise Owners Association Management', 'HOAM Highrise Owners ', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '0', '', NULL, '', '', '', '', '0', '0'),
('157', '160', 'Al Hai Motors', 'Al Hai Motors', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('158', '161', 'Noma Design House', 'Noma Design House', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '0', '', NULL, '', '', '', '', '0', '0'),
('159', '162', 'Ms. Nissreen', 'Ms. Nissreen', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '0', '', NULL, '', '', '', '', '0', '0'),
('160', '163', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', 'Villa 127 Picadilly Green Damac Hills', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 127 Picadilly Green Damac Hills', '0', '', NULL, '', '', '', '', '0', '0'),
('161', '164', 'La Stella productions', 'La Stella productions', 'Al Qouz Dubai\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Al Qouz Dubai\n', '0', '', NULL, '', '', '', '', '0', '0'),
('162', '165', 'Mr. Habib Nahra', 'Mr. Habib Nahra', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('163', '166', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '8', '3', '001', '1', '', '4510', '1200', '4500', '1', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '0', '', NULL, '', '', '', '', '0', '0'),
('164', '167', 'One Laundry', 'One Laundry', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('165', '168', 'ALI FARHAN TECHNICAL SERVICES LLC', 'ALI FARHAN TECHNICAL SERVICES ', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('166', '169', 'Mr. Hisham', 'Mr. Hisham', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('167', '170', 'Mrs.Sumeira', 'Mrs.Sumeira', 'Villa F 41 Golf Course Villas', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa F 41 Golf Course Villas', '0', '', NULL, '', '', '', '', '0', '0'),
('168', '171', 'Dinesh Sanghvi', 'Dinesh Sanghvi', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('169', '172', 'Unitra International LLC', 'Unitra International LLC', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '0', '', NULL, '', '', '', '', '0', '0'),
('170', '173', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('171', '174', 'GDM Interiors LLC', 'GDM Interiors LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('172', '175', 'Vishesh Singhania ', 'Vishesh Singhania ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('173', '176', 'Imperial Avenue', 'Imperial Avenue', 'Dubai -UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai -UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('174', '177', 'Shaul Nagawkar ', 'Shaul Nagawkar ', 'Apt 705 Tower F Executive Tower - Business Bay', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Apt 705 Tower F Executive Tower - Business Bay', '0', '', NULL, '', '', '', '', '0', '0'),
('175', '179', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', ' Al Ain Road', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', ' Al Ain Road', '0', '', NULL, '', '', '', '', '0', '0'),
('176', '180', 'ABDULLA DARWISH GHULOOM AHMED BAQER', 'ABDULLA DARWISH GHULOOM AHMED ', 'Villa 32 Al Warqa', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 32 Al Warqa', '0', '', NULL, '', '', '', '', '0', '0'),
('177', '181', 'Rabia Ahmed ', 'Rabia Ahmed ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('178', '182', 'Kakul Technical Services', 'Kakul Technical Services', 'DUBAI', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('179', '183', 'Riham AlAli', 'Riham AlAli', 'Villa 102,Al Barsha,dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 102,Al Barsha,dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('180', '184', 'Blacksmith Coffee', 'Blacksmith Coffee', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('181', '185', 'Sangeet Jain', 'Sangeet Jain', 'Villa 33 Al Naseem Mudon', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 33 Al Naseem Mudon', '0', '', NULL, '', '', '', '', '0', '0'),
('182', '186', 'Stone House Real Estate Brokerage', 'Stone House Real Estate Broker', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('183', '187', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('184', '188', 'Warriors Aluminum and Glass Cont. LLC ', 'Warriors Aluminum and Glass', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('185', '189', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', 'PO Box 2748 Sharjah', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 2748 Sharjah', '0', '', NULL, '', '', '', '', '0', '0'),
('186', '190', 'High Power Services', 'High Power Services', 'PO Box 57467 Dubai.\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 57467 Dubai.\n', '0', '', NULL, '', '', '', '', '0', '0'),
('187', '191', 'Ms. Charu', 'Ms. Charu', 'Karama,DUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Karama,DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('188', '192', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', 'Villa 1, Ary Building Dubai Marina', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 1, Ary Building Dubai Marina', '0', '', NULL, '', '', '', '', '0', '0'),
('189', '193', 'Star Revive Medical Center', 'Star Revive Medical Center', 'jumeirah', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'jumeirah', '0', '', NULL, '', '', '', '', '0', '0'),
('190', '194', 'Phoenix Middle East', 'Phoenix Middle East', 'DIP 2 ,Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'DIP 2 ,Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('191', '195', 'MENAWATT TECHNICAL SERVICES EST.', 'MENAWATT TECHNICAL SERVICES ', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('192', '196', 'Mond Trading Services', 'Mond Trading Services', 'warehouse 141', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'warehouse 141', '0', '', NULL, '', '', '', '', '0', '0'),
('193', '197', 'Jean Paul Schmidt', 'Jean Paul Schmidt', 'Emaar South Villa 213', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Emaar South Villa 213', '0', '', NULL, '', '', '', '', '0', '0'),
('194', '198', 'Frederic de Melker', 'Frederic de Melker', 'City Walk Building 10, app 309', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'City Walk Building 10, app 309', '0', '', NULL, '', '', '', '', '0', '0'),
('195', '199', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', 'GULFLINE CONST. METALIC PARTS ', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '0', '', NULL, '', '', '', '', '0', '0'),
('196', '200', 'Abu Dhabi Entertainment Company ', 'Abu Dhabi Entertainment ', 'P.O. Box 862, Abu Dhabi, UAE', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box 862, Abu Dhabi, UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('197', '201', 'Mrs. Marie', 'Mrs. Marie', 'Villa 205, Maeen 4, The Lakes', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 205, Maeen 4, The Lakes', '0', '', NULL, '', '', '', '', '0', '0'),
('198', '202', 'Best Choice Trading LLC', 'Best Choice Trading LLC', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', 'Mr. Mozim Ahamed 052 644 7971', NULL, '', '', '', '', '0', '0'),
('199', '203', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '0', '', NULL, '', '', '', '', '0', '0'),
('200', '204', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', 'Jumeirh Park Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Jumeirh Park Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('201', '205', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('202', '206', 'Yashin Lalloo', 'Yashin Lalloo', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('203', '207', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', 'Al Qouz Villa 7', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Qouz Villa 7', '0', '', NULL, '', '', '', '', '0', '0'),
('204', '208', 'Waht Alhams Technical services EST', 'Waht Alhams Technical services', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('205', '209', 'Mrs. Anna', 'Mrs. Anna', 'Villa 17 Trixis, Damac Hills 2 Akoya', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 17 Trixis, Damac Hills 2 Akoya', '0', '', NULL, '', '', '', '', '0', '0'),
('206', '210', 'Aztec Shipping LLC', 'Aztec Shipping LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('207', '211', 'priyanka chugh', 'priyanka chugh', 'palm jumeirah', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'palm jumeirah', '0', '', NULL, '', '', '', '', '0', '0'),
('208', '212', 'InsideOut Casa Technical Services', 'InsideOut Casa Technical ', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('209', '213', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('210', '214', 'Ms.Priya Motiani', 'Ms.Priya Motiani', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('211', '215', 'Mr. Dipak Main', 'Mr. Dipak Main', 'Villa 118 Trixis Damac 2', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 118 Trixis Damac 2', '0', '', NULL, '', '', '', '', '0', '0'),
('212', '216', 'Design Evolution Technical Service Co.', 'Design Evolution Technical Ser', 'AL Awir', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'AL Awir', '0', '', NULL, '', '', '', '', '0', '0'),
('213', '217', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('214', '218', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', 'PO Box 81456 Dubai UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 81456 Dubai UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('215', '219', 'English Language Private School', 'English Language Private Schoo', ' Oud Metha', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', ' Oud Metha', '0', '', NULL, '', '', '', '', '0', '0'),
('216', '220', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', 'P.O BOX 31671,DUBAI - UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'P.O BOX 31671,DUBAI - UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('217', '221', 'Mr. Chari', 'Mr. Chari', 'Villa 240 Pacifica Damac 2', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 240 Pacifica Damac 2', '0', '', NULL, '', '', '', '', '0', '0'),
('218', '222', 'Mr. Prabhu', 'Mr. Prabhu', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('219', '223', 'Kings Speciality Restaurant LLC', 'Kings Speciality Restaurant LL', 'downtown', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'downtown', '0', '', NULL, '', '', '', '', '0', '0'),
('220', '224', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', 'La Quinta Dubai.', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'La Quinta Dubai.', '0', '', NULL, '', '', '', '', '0', '0'),
('221', '225', 'Al Ghussun Advertising', 'Al Ghussun Advertising', 'PO Box 2748 Sharjah UAE', '6', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 2748 Sharjah UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('222', '226', 'Al Ameemi International Trading L.L.C', 'Al Ameemi Intl Trdg LLC', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '0', '', NULL, '', '', '', '', '0', '0'),
('223', '227', 'Mr. Sanjiv Soori', 'Mr. Sanjiv Soori', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('224', '228', 'IBECE ENEGY', 'IBECE ENEGY', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('225', '229', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '0', '', NULL, '', '', '', '', '0', '0'),
('226', '230', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('227', '231', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', 'Villa 3704 Greens Community West', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 3704 Greens Community West', '0', '', NULL, '', '', '', '', '0', '0'),
('228', '231', 'Mrs. Zsuzsanna', ' 0505619411', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('229', '232', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '0', '', NULL, '', '', '', '', '0', '0'),
('230', '233', 'Mr. Antonio', 'Mr. Antonio', '', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('231', '234', 'Mobeen Javed', 'Mobeen Javed', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('232', '235', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('233', '236', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', '14B Street Umm Ramool Rashidiya, Dubai ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '14B Street Umm Ramool Rashidiya, Dubai ', '0', '', NULL, '', '', '', '', '0', '0'),
('234', '237', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('235', '238', 'Suntac General Trading LLC', 'Suntac General Trading LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('236', '239', 'Wasl LLC', 'Wasl LLC', 'DUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('237', '240', 'Mr. Brian Howarth', 'Mr. Brian Howarth', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '0', '', NULL, '', '', '', '', '0', '0'),
('238', '241', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('239', '242', 'Hermen Thomas ', 'Hermen Thomas ', 'G 003 \nNew bridge hills 3 \nUptown motor city', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'G 003 \nNew bridge hills 3 \nUptown motor city', '0', '', NULL, '', '', '', '', '0', '0'),
('240', '243', 'Deepak Panchariya', 'Deepak Panchariya', 'Gardenia, Wasl gate, TH 80', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Gardenia, Wasl gate, TH 80', '0', '', NULL, '', '', '', '', '0', '0'),
('241', '244', 'Nirav Patel', 'Nirav Patel', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('242', '245', 'Atlas Advertising', 'Atlas Advertising', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('243', '246', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', 'Meadows 6 Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Meadows 6 Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('244', '247', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('245', '249', 'HAMMER BUILDING MAINTENANCE LLC', 'HAMMER BUILDING MAINTENANCE LL', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '0', '', NULL, '', '', '', '', '0', '0'),
('246', '250', 'Discovery  General Contracting Co LLC', 'Discovery  General Contracting', 'ABU DHAHBI', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'ABU DHAHBI', '0', '', NULL, '', '', '', '', '0', '0'),
('247', '251', 'BIC Contracting LLC', 'BIC Contracting LLC', 'PO Box # 10869 Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box # 10869 Dubai', '0', '', NULL, '', '', '', '', '0', '0');

### Structure of table `0_dashboard` ###

DROP TABLE IF EXISTS `0_dashboard`;

CREATE TABLE `0_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard` ###

INSERT INTO `0_dashboard` VALUES
('1', 'Bank Information', '1', '0'),
('2', 'Prev. Year Revenue Comparison', '1', '0'),
('3', 'Prev. Year Expense Comparison', '1', '0'),
('4', 'Prev. Year COGS Comparison', '1', '0'),
('5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('6', 'Expense Break Down for Fiscal Year', '1', '0'),
('7', 'COGS Break Down for Fiscal Year', '1', '0'),
('8', 'Top 10 Customers', '2', '0'),
('9', 'Top 10 Selling Items', '2', '0'),
('10', 'Prev. Year Revenue Comparison', '2', '0'),
('11', 'Sales Aging', '2', '0'),
('12', 'Top 10 Open Quotations', '2', '0'),
('13', 'Top 10 Overdue Orders', '2', '0'),
('14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('15', 'Top 10 Purchase Items', '3', '0'),
('16', 'Supplier Aging', '3', '0'),
('17', 'Overdue Purchase Orders', '3', '0'),
('18', 'Overdue Invoices', '3', '0'),
('19', 'Top 10 Vendors', '3', '0'),
('20', 'Top 10 Selling Items', '4', '0'),
('21', 'Top 10 Purchase Items', '4', '0'),
('22', 'Inventory Value Locations', '4', '0'),
('23', 'Standard Rated Graph', '5', '0'),
('24', 'Zero Rated Graph', '5', '0'),
('25', 'Exempt Graph', '5', '0'),
('26', 'Excise Graph', '5', '0'),
('27', 'Total Sales', '6', '0'),
('28', 'Receivable', '7', '0'),
('29', 'Payable', '8', '0'),
('30', 'Profit', '9', '0');

### Structure of table `0_dashboard_language` ###

DROP TABLE IF EXISTS `0_dashboard_language`;

CREATE TABLE `0_dashboard_language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `deleted` tinyint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard_language` ###

INSERT INTO `0_dashboard_language` VALUES
('89', '002', '1', '5', '0'),
('90', '002', '3', '5', '0'),
('91', '002', '1', '3', '0'),
('133', '002', '3', '1', '0'),
('143', '002', '4', '1', '0'),
('148', '002', '2', '1', '0'),
('162', '002', '5', '1', '0'),
('165', '002', '5', '5', '0'),
('172', '002', '1', '1', '0'),
('173', '002', '5', '27', '0');

### Structure of table `0_dashboard_reminders` ###

DROP TABLE IF EXISTS `0_dashboard_reminders`;

CREATE TABLE `0_dashboard_reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `next_date` date NOT NULL,
  `description` text DEFAULT NULL,
  `frequency` varchar(20) NOT NULL,
  `param` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_dashboard_reminders` ###


### Structure of table `0_dashboard_tables` ###

DROP TABLE IF EXISTS `0_dashboard_tables`;

CREATE TABLE `0_dashboard_tables` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(11) NOT NULL,
  `widget_id` int(11) NOT NULL,
  `widget_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1339 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard_tables` ###

INSERT INTO `0_dashboard_tables` VALUES
('9', '2', '1', 'Bank Information', '1', '0'),
('10', '2', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('11', '2', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('12', '2', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('18', '2', '8', 'Top 10 Customers', '2', '0'),
('19', '2', '9', 'Top 10 Selling Items', '2', '0'),
('20', '2', '10', 'Prev. Year Revenue Comparison', '2', '0'),
('21', '2', '11', 'Sales Aging', '2', '0'),
('22', '2', '12', 'Top 10 Open Quotations', '2', '0'),
('23', '2', '13', 'Top 10 Overdue Orders', '2', '0'),
('24', '2', '14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('30', '2', '20', 'Top 10 Selling Items', '4', '0'),
('31', '2', '21', 'Top 10 Purchase Items', '4', '0'),
('32', '2', '15', 'Top 10 Purchase Items', '3', '0'),
('33', '2', '16', 'Supplier Aging', '3', '0'),
('34', '2', '17', 'Overdue Purchase Orders', '3', '0'),
('35', '2', '18', 'Overdue Invoices', '3', '0'),
('36', '2', '19', 'Top 10 Vendors', '3', '0'),
('731', '5', '1', 'Bank Information', '1', '0'),
('732', '5', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('733', '5', '3', 'Prev. Year Expense Comparison', '1', '0'),
('734', '5', '4', 'Prev. Year COGS Comparison', '1', '0'),
('735', '5', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('736', '5', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('737', '5', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('738', '5', '15', 'Top 10 Purchase Items', '3', '0'),
('739', '5', '16', 'Supplier Aging', '3', '0'),
('740', '5', '17', 'Overdue Purchase Orders', '3', '0'),
('741', '5', '18', 'Overdue Invoices', '3', '0'),
('742', '5', '19', 'Top 10 Vendors', '3', '0'),
('743', '3', '1', 'Bank Information', '1', '0'),
('744', '3', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('745', '3', '3', 'Prev. Year Expense Comparison', '1', '0'),
('746', '3', '4', 'Prev. Year COGS Comparison', '1', '0'),
('747', '3', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('748', '3', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('749', '3', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('1114', '1', '15', 'Top 10 Purchase Items', '3', '0'),
('1115', '1', '16', 'Supplier Aging', '3', '0'),
('1116', '1', '17', 'Overdue Purchase Orders', '3', '0'),
('1117', '1', '18', 'Overdue Invoices', '3', '0'),
('1118', '1', '19', 'Top 10 Vendors', '3', '0'),
('1187', '1', '20', 'Top 10 Selling Items', '4', '0'),
('1188', '1', '21', 'Top 10 Purchase Items', '4', '0'),
('1189', '1', '22', 'Inventory Value Locations', '4', '0'),
('1225', '1', '8', 'Top 10 Customers', '2', '0'),
('1226', '1', '9', 'Top 10 Selling Items', '2', '0'),
('1227', '1', '10', 'Prev. Year Revenue Comparison', '2', '0'),
('1228', '1', '11', 'Sales Aging', '2', '0'),
('1229', '1', '12', 'Top 10 Open Quotations', '2', '0'),
('1230', '1', '13', 'Top 10 Overdue Orders', '2', '0'),
('1231', '1', '14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('1236', '1', '23', 'Standard Rated Graph', '5', '0'),
('1237', '1', '24', 'Zero Rated Graph', '5', '0'),
('1238', '1', '25', 'Exempt Graph', '5', '0'),
('1239', '1', '26', 'Excise Graph', '5', '0'),
('1321', '2', '22', 'Total Sales', '6', '0'),
('1322', '2', '23', 'Receivable', '7', '0'),
('1323', '2', '24', 'Payable', '8', '0'),
('1324', '2', '25', 'Profit', '9', '0'),
('1332', '1', '1', 'Bank Information', '1', '0'),
('1333', '1', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('1334', '1', '3', 'Prev. Year Expense Comparison', '1', '0'),
('1335', '1', '4', 'Prev. Year COGS Comparison', '1', '0'),
('1336', '1', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('1337', '1', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('1338', '1', '7', 'COGS Break Down for Fiscal Year', '1', '0');

### Structure of table `0_dashboard_widgets` ###

DROP TABLE IF EXISTS `0_dashboard_widgets`;

CREATE TABLE `0_dashboard_widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `app` varchar(50) NOT NULL,
  `column_id` int(11) NOT NULL,
  `sort_no` int(11) NOT NULL,
  `collapsed` tinyint(4) NOT NULL,
  `widget` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `param` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_dashboard_widgets` ###

INSERT INTO `0_dashboard_widgets` VALUES
('1', '1', 'AP', '1', '1', '0', 'weeklysales', 'Top 10 Sales Weeks', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;desc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;}'),
('2', '1', 'AP', '1', '0', '0', 'weeklysales', 'Weekly Sales', '{&quot;top&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;Week End&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('3', '1', 'AP', '2', '1', '0', 'weeklysales', 'Lowest weeks sales', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('6', '1', 'AP', '2', '0', '0', 'dailysales', 'Daily Sales', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;}'),
('7', '1', 'orders', '1', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('9', '1', 'orders', '1', '1', '0', 'salesinvoices', 'Overdue invoices', '{&quot;data_filter&quot;:&quot;&quot;}'),
('10', '1', 'AP', '1', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('11', '1', 'AP', '2', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('12', '1', 'GL', '2', '1', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('13', '1', 'GL', '2', '0', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('14', '1', 'stock', '1', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('15', '1', 'stock', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('16', '1', 'manuf', '1', '0', '0', 'items', 'Top 10 items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('17', '1', 'manuf', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('18', '1', 'orders', '2', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('19', '1', 'GL', '2', '2', '0', 'bankbalances', 'Bank Balances', '{&quot;data_filter&quot;:&quot;&quot;}'),
('20', '1', 'GL', '1', '1', '0', 'dailybankbalances', 'Daily Current Account Balance', '{&quot;days_past&quot;:&quot;&quot;,&quot;days_future&quot;:&quot;&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('21', '1', 'GL', '1', '0', '0', 'banktransactions', 'Current Account Transactions', '{&quot;days_past&quot;:&quot;15&quot;,&quot;days_future&quot;:&quot;15&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('22', '2', 'AP', '1', '1', '0', 'weeklysales', 'Top 10 Sales Weeks', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;desc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;}'),
('23', '2', 'AP', '1', '0', '0', 'weeklysales', 'Weekly Sales', '{&quot;top&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;Week End&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('24', '2', 'AP', '2', '1', '0', 'weeklysales', 'Lowest weeks sales', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('25', '2', 'AP', '2', '0', '0', 'dailysales', 'Daily Sales', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;}'),
('26', '2', 'orders', '1', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('27', '2', 'orders', '1', '1', '0', 'salesinvoices', 'Overdue invoices', '{&quot;data_filter&quot;:&quot;&quot;}'),
('28', '2', 'AP', '1', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('29', '2', 'AP', '2', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('30', '2', 'GL', '2', '1', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('31', '2', 'GL', '2', '0', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('32', '2', 'stock', '1', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('33', '2', 'stock', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('34', '2', 'manuf', '1', '0', '0', 'items', 'Top 10 items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('35', '2', 'manuf', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('36', '2', 'orders', '2', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('37', '2', 'GL', '2', '2', '0', 'bankbalances', 'Bank Balances', '{&quot;data_filter&quot;:&quot;&quot;}'),
('38', '2', 'GL', '1', '1', '0', 'dailybankbalances', 'Daily Current Account Balance', '{&quot;days_past&quot;:&quot;&quot;,&quot;days_future&quot;:&quot;&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('39', '2', 'GL', '1', '0', '0', 'banktransactions', 'Current Account Transactions', '{&quot;days_past&quot;:&quot;15&quot;,&quot;days_future&quot;:&quot;15&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;data_filter&quot;:&quot;&quot;}');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` bigint(11) unsigned NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `notification_status` int(11) NOT NULL,
  `refund` int(11) NOT NULL,
  `cons_full_name` varchar(255) NOT NULL,
  `cons_address` varchar(255) NOT NULL,
  `cons_phone1` varchar(255) NOT NULL,
  `cons_phone2` varchar(255) NOT NULL,
  `country` varchar(50) NOT NULL,
  `amount_recived` double NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `master_order` int(11) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `deliver_to` varchar(100) NOT NULL,
  `technician` int(11) NOT NULL,
  `draft` int(11) NOT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###

INSERT INTO `0_debtor_trans` VALUES
('4', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '18', '17', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '5212.96', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '128', '126', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '1155', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '230', '226', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '1700.21', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '249', '245', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '3675', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '250', '246', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '7350', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '251', '247', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '-3390.41', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0');
INSERT INTO `0_debtor_trans` VALUES
('10', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '770', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1050', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3350', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '472.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '503.01', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '33780', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '-100', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '325', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3502.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '42058.16', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '9636', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '16682.46', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '17955', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2625', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '15767.99', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1075', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '892.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3675', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3937.71', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '37250', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '12904.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2498', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '-231.74', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3150', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3055', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1050', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2636', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '8400', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3675', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1141.3', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1600.2', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3167.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '600.08', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '19581.25', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2342.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '5775', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1680', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '5820', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1050', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '899.85', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '499.65', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '262.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '525', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0');

### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(255) NOT NULL,
  `item_specs` varchar(100) NOT NULL,
  `spec_description` varchar(1000) NOT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) DEFAULT NULL,
  `sale_kit_id` varchar(50) NOT NULL,
  `line_ref` varchar(200) NOT NULL,
  `line_date` date NOT NULL,
  `stock_out` int(11) NOT NULL COMMENT '1=Stock Out From Inventory',
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` bigint(100) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) NOT NULL,
  `address` tinytext DEFAULT NULL,
  `tax_id` varchar(55) NOT NULL DEFAULT '',
  `curr_code` char(3) NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount_criteria` int(11) NOT NULL COMMENT '1=discount in percentage, 2=discount in fixed amoun',
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext NOT NULL,
  `cust_ref_arabic` varchar(100) NOT NULL,
  `CustName_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_of_users` int(11) NOT NULL,
  `company` varchar(100) NOT NULL,
  `pass` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_cash_cust` tinyint(1) NOT NULL,
  `cp_id` int(11) NOT NULL COMMENT 'Contact Person Created By CRM Module\r\n',
  `emirates_id` varchar(200) NOT NULL COMMENT 'Emirates ID Image(File-Name)',
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'A. A. A. Shuhail Alqahta', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('3', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'A. M &amp; COMMUNICATION', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('5', 'Antique Style', 'Antique Style', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('6', 'Arnesto Purgos', 'A.Purgos', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('8', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'B.P.EMIRATES LTD CO ', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('9', 'BIC Contracting LLC', 'B.C.LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('11', 'CAESARS BLUEWATERS DUBAI L.L.C', 'C.B.DUBAI L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('12', 'Core Elements Interior Decoration LLC', 'C. E. Interior Decorat LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('14', 'Decortser Portal', 'Decortser Portal', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('15', 'Discovery  General Contracting Co LLC', 'D.G.Contracting Co LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('16', 'Dr. Laya', 'Dr. Laya', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('17', 'Dr. Rehmina', 'Dr. Rehmina', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('19', 'Ismail Abdul Rahim Shaaban Mohamed', 'I. Abdul Rahim Shaaban Mohamed', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('20', 'Jalal Merchant', 'Jalal Merchant', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('22', 'KOA REAL ESTATE DEVELOPMENT LLC', 'KOA R.E.DEVELOPMENT LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('25', 'Mr. AD', 'Mr. AD', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('26', 'Mr. Alaa', 'Mr. Alaa', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('27', 'Mr . Amit', 'Mr . Amit', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('28', 'Mr Ashok', 'Mr Ashok', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('31', 'Mr.Dinesh', 'Mr.Dinesh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('33', 'Mr. Haresh', 'Mr. Haresh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('34', 'Mr Hasan', 'Mr Hasan', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('35', 'Mr. Ibrahim', 'Mr. Ibrahim', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('37', 'Mr. James', 'Mr. James', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('41', 'Mr.Neeraj', 'Mr.Neeraj', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('42', 'Mr. Prabhat', 'Mr. Prabhat', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('44', 'Mr.Rajesh', 'Mr.Rajesh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('47', 'Mr. Saqlain', 'Mr. Saqlain', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('49', 'Ms. Ahiliya', 'Ms. Ahiliya', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('52', 'Ms. Loulwa', 'Ms. Loulwa', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('53', 'Ms. Roda', 'Ms. Roda', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('54', 'Ms.Swarn', 'Ms.Swarn', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('55', 'Ms. Thanuja', 'Ms. Thanuja', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('56', 'Ms. Yogitha', 'Ms. Yogitha', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', 'Al barari , Dubai', '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('58', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', 'NATURAL TRENDY TIL&amp;FLOOR M', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('63', 'QEXPRESS', 'QEXPRESS', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('65', 'RIGHT HOMES REAL ESTATE BROKERS', 'R. H. REAL ESTATE BROKERS', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('68', 'Sajith Ansar', 'Sajith Ansar', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('69', 'Sustainable Builders', 'Sustainable Builders', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('70', 'Techforce Technical Services', 'Techforce Technical Services', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('73', 'Cash Customer', 'Cash Customer', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '1', '0', ''),
('74', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', NULL, '100593452400003', 'AED', '1', '0', '0', '6', '5', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('75', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'BERGER PAINTS EMIRATES LTD CO', NULL, '', 'AED', '1', '0', '0', '6', '7', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('78', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('79', 'Naga Lakshmi', 'Naga Lakshmi', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('80', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'Abdelaziz Abdelrahman Abdelazi', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('81', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('82', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'ADSS MARKETING &amp; COMMUNICA', NULL, '100332927100003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('83', 'AFRICA INTERNET GENERAL TRADING LLC', 'AFRICA INTERNET GENERAL TRADIN', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('84', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('85', 'Aevolve Beauty Saloon', 'Aevolve Beauty Saloon', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('86', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('87', 'Vijaya Chikermane', 'Vijaya Chikermane', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('88', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('89', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', NULL, '', 'AED', '1', '0', '0', '6', '8', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('90', 'Angel Cakes', 'Angel Cakes', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('91', 'AQS Management Consultancy', 'AQS Management Consultancy', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('92', 'Naresh Mohnani', 'Naresh Mohnani', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('93', 'Luigi Dsouza', 'Luigi Dsouza', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('94', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', NULL, '100588356400003', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('95', 'Ms. Alita', 'Ms. Alita', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('96', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('97', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('98', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('99', 'Mr Tahir', 'Mr Tahir', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('100', 'Salim Lokhandwala', 'salim lokhand.', 'Dubai Hills\nDubai', '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('101', 'Bridge Forth &amp; Signature Contracting Co. LLC', 'Bridge Forth &amp; Signature', 'PO BOX 99856\nDUBAI', '100399834900003', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('102', 'Ms. Nour', 'Ms. Nour', 'Springs 11, street 2, villa 36\nDubai', '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('103', 'Milad Interior Design', 'Milad Interior Design', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('104', 'Majid Al Falasi', 'Majid Al Falasi', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('105', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', NULL, '100232267300003', 'AED', '1', '0', '0', '6', '9', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('106', 'NEW CLEARVIEW DECORATION DESIGN &amp; IMPLEMENTATION', 'NEW CLEARVIEW DECORATION DESIG', 'Dubai', '100473164000003', 'AED', '1', '0', '0', '6', '6', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('107', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', 'Dubai', '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('108', 'Suzena', 'Suzena', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('109', 'Akhil Vinayak', 'Akhil Vinayak', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('110', 'Ms. Fatma Al Rais', 'Fatma Al Rais', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('111', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('112', 'PAVIMENTO GENERAL TRADING L.L.C', 'PAVIMENTO GENERAL TRDG LLC', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '100541804900003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('113', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '100449949500003', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('114', 'Yogesh', 'Yogesh', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('115', 'I 2 D Interiors', 'I 2 D Interiors', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('116', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', NULL, '100621145000003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('117', 'The international school of choueifat', 'The international school of ch', NULL, '100355326800003', 'AED', '1', '0', '0', '6', '5', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('118', 'RATLS CONTRACTING', 'RATLS CONTRACTING', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('119', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('120', 'Colart Publishing &amp; Advertising LLC', 'Colart Publishing &amp; Adv. L', 'PO Box 49652\nDUBAI', '100333677100003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('121', 'Ms. Arpita', 'Ms. Arpita', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('123', 'Turnkey fitout solutions', 'Turnkey fitout solutions', 'po box # 47862\nDubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('124', 'kalyan chakravarthy', 'kalyan chakravarthy', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('125', 'Harun Sultan', 'Harun Sultan', 'Ajman', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('126', 'VERVE INTERIOR  DECORATION L.L.C', 'VERVE INTERIOR  DECORATION L.L', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '100368853600003', 'AED', '1', '0', '0', '6', '7', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('127', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', 'Dubai', '', 'AED', '1', '0', '0', '6', '5', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('128', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '100579896000003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('130', 'Kitchenscape Domestic Kitchens LLC', 'Kitchenscape Domestic Kitchens', 'Dubai', '100514227600003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('131', 'GREEN TERRA TECHNICAL SERVICES LLC', 'GREEN TERRA TECHNICAL SERVICES', 'Dubai', '100346872300003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('132', 'Ms. Serena', 'Ms. Serena', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('133', 'Highrise Owners Association Management (HOAM)', 'Highrise Owners Association Ma', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('134', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', 'Po Box # 60288\nDIP\nDubai', '100374958500003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('135', 'Beenish Haider', 'Beenish Haider', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('136', 'Meherz Kreation LLC', 'Meherz Kreation LLC', NULL, '100468664600003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('137', 'WASL PROPERTIES', 'WASL PROPERTIES', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('138', 'Modern Seal Insulation Solutions', 'Modern Seal Insulation Soln', NULL, '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('139', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('141', 'Mr. Rajiv', 'Mr. Rajiv', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('142', 'Fincirc International Management', 'Fincirc International Manageme', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '100002805800003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('143', 'Ms. Shweta', 'Ms. Shweta', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('144', 'Pooja Shah Mulani', 'Pooja Shah Mulani', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('145', 'Mr Xpert technical Services New Office Jebel Ali', 'MXTS office Jebel Ali								', NULL, '', 'AED', '1', '0', '0', '6', '1', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('146', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '100025884600003', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('147', 'Sanqour advertising service', 'Sanqour advertising service', 'Al Zahiya, Abu Dhabi', '', 'AED', '1', '0', '0', '6', '5', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('148', 'EL TEAM LTD FZE - Sharjah', 'EL TEAM LTD FZE - Sharjah', 'Office 08A Ground Floor LOB 2\nHamriya Free Zone, Sharjah', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('149', 'Wool Craft  Trading', 'Wool Craft  Trading', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('150', 'Afaq Al Waseqh Electromechanical Services LLC', 'Afaq Al Waseqh Electromech', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('151', 'MR. YU', 'MR. YU', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('152', 'Astro properties', 'Astro properties', 'E504, Burj Khalifa, Dubai, برج خليفة مكتب رقم\nDubai, United Arab Emirates, 0000,', '100434680300003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '+971557468871', '', '', '0', '0', '', '', '0', '0', '0', ''),
('153', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', 'P.O. Box – 48746,\nDubai, UAE\n', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('154', 'Mr. Hadisfer', 'Mr. Hadisfer', 'Villa 47 Hattan One Arabian Ranches', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('155', 'JAMTS Tech LLC', 'JAMTS Tech LLC', 'PO Box 71893', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', 'Mr. Inaam', '', '', '0', '0', '', '', '0', '0', '0', ''),
('156', 'SOFITEL THE PALM FZCO ', 'Sofitel Dubai The Palm', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '100056298100003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('157', 'Rahul Ranbhare', 'Rahul Ranbhare', 'G05, Fortunato 1, JVC', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('158', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', 'Villa 349 Hayat townhouses', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('159', 'HOAM Highrise Owners Association Management', 'HOAM Highrise Owners ', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('160', 'Al Hai Motors', 'Al Hai Motors', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('161', 'Noma Design House', 'Noma Design House', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('162', 'Ms. Nissreen', 'Ms. Nissreen', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('163', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', 'Villa 127 Picadilly Green Damac Hills', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('164', 'La Stella productions', 'La Stella productions', 'Al Qouz Dubai\n', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('165', 'Mr. Habib Nahra', 'Mr. Habib Nahra', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('166', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '100231971100003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('167', 'One Laundry', 'One Laundry', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('168', 'ALI FARHAN TECHNICAL SERVICES LLC', 'ALI FARHAN TECHNICAL SERVICES ', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('169', 'Mr. Hisham', 'Mr. Hisham', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('170', 'Mrs.Sumeira', 'Mrs.Sumeira', 'Villa F 41 Golf Course Villas', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('171', 'Dinesh Sanghvi', 'Dinesh Sanghvi', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('172', 'Unitra International LLC', 'Unitra International LLC', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '100271258400003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('173', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', 'Villa 4, Street 110, Barsha South One', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('174', 'GDM Interiors LLC', 'GDM Interiors LLC', NULL, '100027925500003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('175', 'Vishesh Singhania ', 'Vishesh Singhania ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('176', 'Imperial Avenue', 'Imperial Avenue', 'Dubai -UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('177', 'Shaul Nagawkar ', 'Shaul Nagawkar ', 'Apt 705 Tower F Executive Tower - Business Bay', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('179', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', ' Al Ain Road', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('180', 'ABDULLA DARWISH GHULOOM AHMED BAQER', 'ABDULLA DARWISH GHULOOM AHMED ', 'Villa 32 Al Warqa', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('181', 'Rabia Ahmed ', 'Rabia Ahmed ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('182', 'Kakul Technical Services', 'Kakul Technical Services', 'DUBAI', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('183', 'Riham AlAli', 'Riham AlAli', 'Villa 102,Al Barsha,dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('184', 'Blacksmith Coffee', 'Blacksmith Coffee', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('185', 'Sangeet Jain', 'Sangeet Jain', 'Villa 33 Al Naseem Mudon', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('186', 'Stone House Real Estate Brokerage', 'Stone House Real Estate Broker', 'office 1110, the citadel tower, business Bay\n+971 55 981 0126', '100069298600003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('187', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('188', 'Warriors Aluminum and Glass Cont. LLC ', 'Warriors Aluminum and Glass', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('189', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', 'PO Box 2748 Sharjah', '100529873000003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('190', 'High Power Services', 'High Power Services', 'PO Box 57467 Dubai.\n', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('191', 'Ms. Charu', 'Ms. Charu', 'Karama,DUBAI', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('192', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', 'Villa 1, Ary Building Dubai Marina', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('193', 'Star Revive Medical Center', 'Star Revive Medical Center', 'jumeirah', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('194', 'Phoenix Middle East', 'Phoenix Middle East', 'DIP 2 ,Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('195', 'MENAWATT TECHNICAL SERVICES EST.', 'MENAWATT TECHNICAL SERVICES ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('196', 'Mond Trading Services', 'Mond Trading Services', 'warehouse 141', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('197', 'Jean Paul Schmidt', 'Jean Paul Schmidt', 'Emaar South Villa 213', '', 'AED', '1', '0', '0', '6', '4', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('198', 'Frederic de Melker', 'Frederic de Melker', 'City Walk Building 10, app 309', '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('199', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', 'GULFLINE CONST. METALIC PARTS ', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('200', 'Abu Dhabi Entertainment Company ', 'Abu Dhabi Entertainment ', 'P.O. Box 862, Abu Dhabi, UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('201', 'Mrs. Marie', 'Mrs. Marie', 'Villa 205, Maeen 4, The Lakes', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('202', 'Best Choice Trading LLC', 'Best Choice Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', 'Mr. Mozim Ahamed 052 644 7971', '', '', '0', '0', '', '', '0', '0', '0', ''),
('203', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', 'Mag 218 tower, aprt 2509', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('204', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', 'Jumeirh Park Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('205', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('206', 'Yashin Lalloo', 'Yashin Lalloo', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('207', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', 'Al Qouz Villa 7', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('208', 'Waht Alhams Technical services EST', 'Waht Alhams Technical services', NULL, '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('209', 'Mrs. Anna', 'Mrs. Anna', 'Villa 17 Trixis, Damac Hills 2 Akoya', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('210', 'Aztec Shipping LLC', 'Aztec Shipping LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('211', 'priyanka chugh', 'priyanka chugh', 'palm jumeirah', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('212', 'InsideOut Casa Technical Services', 'InsideOut Casa Technical ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('213', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('214', 'Ms.Priya Motiani', 'Ms.Priya Motiani', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('215', 'Mr. Dipak Main', 'Mr. Dipak Main', 'Villa 118 Trixis Damac 2', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('216', 'Design Evolution Technical Service Co.', 'Design Evolution Technical Ser', 'AL Awir', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('217', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('218', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', 'PO Box 81456 Dubai UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('219', 'English Language Private School', 'English Language Private Schoo', ' Oud Metha', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('220', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', 'P.O BOX 31671,DUBAI - UAE', '100314693100003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('221', 'Mr. Chari', 'Mr. Chari', 'Villa 240 Pacifica Damac 2', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('222', 'Mr. Prabhu', 'Mr. Prabhu', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('223', 'Kings Speciality Restaurant LLC', 'Kings Speciality Restaurant LL', 'Jun&#039;s Dubai, VRDT-GR-01, Vida Residence, Downtown Boulevard Road, Downtown, Dubai', '104021543400003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('224', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', 'La Quinta Dubai.', '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('225', 'Al Ghussun Advertising', 'Al Ghussun Advertising', 'PO Box 2748 Sharjah UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('226', 'Al Ameemi International Trading L.L.C', 'Al Ameemi Intl Trdg LLC', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('227', 'Mr. Sanjeev Suri', 'Mr. Sanjeev Suri', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('228', 'IBECE ENEGY', 'IBECE ENEGY', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('229', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '100059624500003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('230', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '100376644900003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('231', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', 'Villa 3704 Greens Community West', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('232', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('233', 'Mr. Antonio', 'Mr. Antonio', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('234', 'Mobeen Javed', 'Mobeen Javed', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('235', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', NULL, '100259304200003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('236', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', '14B Street Umm Ramool Rashidiya, Dubai ', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('237', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('238', 'Suntac General Trading LLC', 'Suntac General Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('239', 'Wasl LLC', 'Wasl LLC', 'DUBAI', '100314979400003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('240', 'Mr. Brian Howarth', 'Mr. Brian Howarth', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('241', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('242', 'Hermen Thomas ', 'Hermen Thomas ', 'G 003 \nNew bridge hills 3 \nUptown motor city', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('243', 'Deepak Panchariya', 'Deepak Panchariya', 'Gardenia, Wasl gate, TH 80', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('244', 'Nirav Patel', 'Nirav Patel', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('245', 'Atlas Advertising', 'Atlas Advertising', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('246', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', 'Meadows 6 Dubai', '', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('247', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '100579896000003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('249', 'HAMMER BUILDING MAINTENANCE LLC', 'HAMMER BUILDING MAINTENANCE LL', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '100593452400003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('250', 'Discovery  General Contracting Co LLC', 'Discovery  General Contracting', 'ABU DHAHBI', '100334239900003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('251', 'BIC Contracting LLC', 'BIC Contracting LLC', 'PO Box # 10869 Dubai', '100259779500003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', '');

### Structure of table `0_department` ###

DROP TABLE IF EXISTS `0_department`;

CREATE TABLE `0_department` (
  `dept_id` int(11) NOT NULL AUTO_INCREMENT,
  `dept_name` tinytext NOT NULL,
  `basic_account` varchar(15) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_department` ###


### Structure of table `0_designation` ###

DROP TABLE IF EXISTS `0_designation`;

CREATE TABLE `0_designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_designation` ###


### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `project_amount` double NOT NULL,
  `profit_margin` int(11) NOT NULL,
  `exclude_from_sales` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###


### Structure of table `0_document_types` ###

DROP TABLE IF EXISTS `0_document_types`;

CREATE TABLE `0_document_types` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(100) NOT NULL,
  `notify_before` smallint(5) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_document_types` ###


### Structure of table `0_emp_payslip_trans` ###

DROP TABLE IF EXISTS `0_emp_payslip_trans`;

CREATE TABLE `0_emp_payslip_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `basic_salary` double NOT NULL,
  `allowance` double NOT NULL,
  `deduction` double NOT NULL,
  `gross_salary` double NOT NULL,
  `overtime_hrs` int(11) NOT NULL,
  `ot_salary` double NOT NULL,
  `normal_days` int(11) NOT NULL,
  `nd_salary` double NOT NULL,
  `upl` int(11) NOT NULL COMMENT 'un paid leave',
  `pl` int(11) NOT NULL,
  `pl_amount` double NOT NULL,
  `month_id` int(11) NOT NULL,
  `year_id` int(11) NOT NULL,
  `total_salary` double NOT NULL,
  `alloc_amount` double NOT NULL,
  `emp_approved` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_emp_payslip_trans` ###


### Structure of table `0_emp_payslip_trans_detail` ###

DROP TABLE IF EXISTS `0_emp_payslip_trans_detail`;

CREATE TABLE `0_emp_payslip_trans_detail` (
  `trans_id` int(11) NOT NULL,
  `All_ded_leave_id` int(11) NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `leave_type` int(11) NOT NULL,
  `type` int(11) NOT NULL COMMENT '''1'' is allowance ,''2'' is deductioen ,''3'' is leave'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_emp_payslip_trans_detail` ###


### Structure of table `0_employee` ###

DROP TABLE IF EXISTS `0_employee`;

CREATE TABLE `0_employee` (
  `emp_id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_first_name` varchar(100) DEFAULT NULL,
  `emp_last_name` varchar(100) DEFAULT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT 0,
  `emp_address` tinytext DEFAULT NULL,
  `emp_mobile` varchar(30) DEFAULT NULL,
  `emp_email` varchar(100) DEFAULT NULL,
  `emp_birthdate` date NOT NULL,
  `emp_notes` tinytext NOT NULL,
  `emp_hiredate` date DEFAULT NULL,
  `department_id` int(11) NOT NULL,
  `salary_scale_id` int(11) NOT NULL DEFAULT 0,
  `emp_salary` varchar(30) NOT NULL,
  `emp_releasedate` date DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  `role` int(11) NOT NULL,
  `work_permit` varchar(25) NOT NULL,
  `bank_name` varchar(50) NOT NULL,
  `bank_account` varchar(30) NOT NULL,
  `iban` varchar(30) NOT NULL,
  PRIMARY KEY (`emp_id`),
  KEY `salary_scale_id` (`salary_scale_id`),
  KEY `department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee` ###


### Structure of table `0_employee_advance` ###

DROP TABLE IF EXISTS `0_employee_advance`;

CREATE TABLE `0_employee_advance` (
  `emp_trans_no` int(11) NOT NULL,
  `emp_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_advance` ###


### Structure of table `0_employee_advance_allocation` ###

DROP TABLE IF EXISTS `0_employee_advance_allocation`;

CREATE TABLE `0_employee_advance_allocation` (
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `amount` double unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_advance_allocation` ###


### Structure of table `0_employee_docs` ###

DROP TABLE IF EXISTS `0_employee_docs`;

CREATE TABLE `0_employee_docs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `description` varchar(60) NOT NULL DEFAULT '',
  `issue_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `alert` tinyint(1) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_docs` ###


### Structure of table `0_employee_payment_receipt_allocation` ###

DROP TABLE IF EXISTS `0_employee_payment_receipt_allocation`;

CREATE TABLE `0_employee_payment_receipt_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `gl_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_payment_receipt_allocation` ###


### Structure of table `0_employee_trans` ###

DROP TABLE IF EXISTS `0_employee_trans`;

CREATE TABLE `0_employee_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `trans_type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `payslip_no` int(11) NOT NULL DEFAULT 0,
  `pay_date` date NOT NULL,
  `to_the_order_of` varchar(255) NOT NULL,
  `pay_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_trans` ###


### Structure of table `0_events` ###

DROP TABLE IF EXISTS `0_events`;

CREATE TABLE `0_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_role` int(11) NOT NULL,
  `title` text NOT NULL,
  `arabic_title` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `color` varchar(20) NOT NULL,
  `start_event` datetime NOT NULL,
  `end_event` datetime NOT NULL,
  `status` int(1) NOT NULL,
  `notification` int(1) NOT NULL,
  `comment_id` int(100) NOT NULL COMMENT 'This Data is in the relation with Followup Comments',
  `real_estate_id` int(11) NOT NULL,
  `reminder_status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_events` ###


### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('55', 'INR', '20.22', '20.22', '2021-06-29'),
('56', 'PKR', '43.03', '43.03', '2021-06-29'),
('57', 'AED', '43.23', '43.23', '2021-07-07'),
('58', 'AED', '43.23', '43.23', '2021-07-13'),
('59', 'AED', '43.23', '43.23', '2021-08-02'),
('60', 'USD', '200', '200', '2021-10-30'),
('61', 'USD', '1.2', '1.2', '2022-04-18');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('8', '2021-01-01', '2021-12-31', '0'),
('9', '2020-01-01', '2020-12-31', '0'),
('10', '2019-01-01', '2019-12-31', '0'),
('11', '2022-01-01', '2022-12-31', '0'),
('12', '2023-01-01', '2023-12-31', '0'),
('13', '2024-01-01', '2024-12-31', '0');

### Structure of table `0_followup` ###

DROP TABLE IF EXISTS `0_followup`;

CREATE TABLE `0_followup` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `type` int(100) NOT NULL,
  `trans_no` int(100) NOT NULL,
  `user` int(100) NOT NULL,
  `date_` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `comment` longtext NOT NULL,
  `reminder_date` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_followup` ###


### Structure of table `0_forms_feilds` ###

DROP TABLE IF EXISTS `0_forms_feilds`;

CREATE TABLE `0_forms_feilds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(30) NOT NULL,
  `name` varchar(30) NOT NULL,
  `type` int(11) NOT NULL,
  `view` varchar(10) NOT NULL,
  `status_pc` int(1) NOT NULL DEFAULT 1,
  `status_mbl` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_forms_feilds` ###

INSERT INTO `0_forms_feilds` VALUES
('1', 'Customer', 'customer_id_checkbox', '10', 'mbl', '1', '1'),
('2', 'Branch', 'branch_id_checkbox', '10', 'mbl', '1', '1'),
('3', 'Reference', 'reference_checkbox', '10', 'mbl', '1', '1'),
('4', 'Current Credit', 'current_credit_checkbox', '10', 'mbl', '1', '0'),
('5', 'Customer Discount', 'customer_discount_checkbox', '10', 'mbl', '1', '0'),
('6', 'Payment', 'payment_checkbox', '10', 'mbl', '1', '0'),
('7', 'Price List', 'price_list_checkbox', '10', 'mbl', '1', '0'),
('8', 'Date', 'date_checkbox', '10', 'mbl', '1', '1'),
('9', 'Dimension', 'dimension_checkbox', '10', 'mbl', '1', '0'),
('10', 'Dimension 2', 'dimension_2_checkbox', '10', 'mbl', '1', '0'),
('11', 'Exchange Rate', 'exchange_rate_checkbox', '10', 'mbl', '1', '0'),
('12', 'Customer', 'customer_id_checkbox', '11', 'mbl', '1', '1'),
('13', 'Branch', 'branch_id_checkbox', '11', 'mbl', '1', '1'),
('14', 'Reference', 'reference_checkbox', '11', 'mbl', '1', '1'),
('15', 'Exchange Rate', 'exchange_rate_checkbox', '11', 'mbl', '1', '0'),
('16', 'Current Credit', 'current_credit_checkbox', '11', 'mbl', '1', '0'),
('17', 'Customer Discount', 'customer_discount_checkbox', '11', 'mbl', '1', '0'),
('18', 'Payment', 'payment_checkbox', '11', 'mbl', '1', '0'),
('19', 'Price List', 'price_list_checkbox', '11', 'mbl', '1', '0'),
('20', 'Date', 'date_checkbox', '11', 'mbl', '1', '1'),
('21', 'Dimension', 'dimension_checkbox', '11', 'mbl', '1', '0'),
('22', 'Dimension 2', 'dimension_2_checkbox', '11', 'mbl', '1', '0'),
('34', 'Customer Currency', 'customer_currency_checkbox', '11', 'mbl', '1', '1'),
('35', 'Shipping Company', 'shipping_company_checkbox', '11', 'mbl', '1', '1');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  `import` int(11) NOT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=616 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '0', '1', '2023-12-31', '24038', '', '0', '0', '0', NULL, NULL, '0'),
('2', '0', '1', '2023-12-31', '2390', '', '0', '0', '0', NULL, NULL, '0'),
('3', '0', '1', '2023-12-31', '2100', '', '0', '0', '0', '3', '2', '0'),
('4', '0', '1', '2023-12-31', '1060', '', '0', '0', '0', '3', '97', '0'),
('5', '0', '2', '2023-12-31', '24038', '', '7390.99', '0', '0', NULL, NULL, '0'),
('6', '0', '2', '2023-12-31', '2390', '', '-85508.43', '0', '0', NULL, NULL, '0'),
('7', '0', '2', '2023-12-31', '2100', '', '-1260', '0', '0', '3', '2', '0'),
('8', '0', '2', '2023-12-31', '1060', '', '79377.44', '0', '0', '3', '97', '0'),
('9', '0', '3', '2023-12-31', '24038', '', '-250618.7', '0', '0', NULL, NULL, '0'),
('10', '0', '3', '2023-12-31', '2390', '', '-85462.34', '0', '0', NULL, NULL, '0'),
('11', '0', '3', '2023-12-31', '2100', '', '-50002', '0', '0', '3', '117', '0'),
('12', '0', '3', '2023-12-31', '2100', '', '-7.5', '0', '0', '3', '58', '0'),
('13', '0', '3', '2023-12-31', '2100', '', '734.68', '0', '0', '3', '52', '0'),
('14', '0', '3', '2023-12-31', '2100', '', '-443.86', '0', '0', '3', '124', '0'),
('15', '0', '3', '2023-12-31', '2100', '', '1417.5', '0', '0', '3', '115', '0'),
('16', '0', '3', '2023-12-31', '2100', '', '-7450', '0', '0', '3', '45', '0'),
('17', '0', '3', '2023-12-31', '24032', '', '-48319.2', '0', '0', NULL, NULL, '0'),
('18', '0', '3', '2023-12-31', '24034', '', '-1897.76', '0', '0', NULL, NULL, '0'),
('19', '0', '3', '2023-12-31', '24035', '', '-40330', '0', '0', NULL, NULL, '0'),
('20', '0', '3', '2023-12-31', '24027', '', '78000', '0', '0', NULL, NULL, '0'),
('21', '0', '3', '2023-12-31', '24029', '', '17080', '0', '0', NULL, NULL, '0'),
('22', '0', '3', '2023-12-31', '24030', '', '10000', '0', '0', NULL, NULL, '0'),
('23', '0', '3', '2023-12-31', '24031', '', '40330', '0', '0', NULL, NULL, '0'),
('24', '0', '3', '2023-12-31', '24036', '', '1870', '0', '0', NULL, NULL, '0'),
('25', '0', '3', '2023-12-31', '24010', '', '75000', '0', '0', NULL, NULL, '0'),
('26', '0', '3', '2023-12-31', '24001', '', '5900', '0', '0', '3', '98', '0'),
('27', '0', '3', '2023-12-31', '24002', '', '62', '0', '0', '3', '99', '0'),
('28', '0', '3', '2023-12-31', '24003', '', '12930.4', '0', '0', '3', '100', '0'),
('29', '0', '3', '2023-12-31', '24005', '', '1000', '0', '0', '3', '97', '0'),
('30', '0', '3', '2023-12-31', '3590', '', '240206.78', '0', '0', NULL, NULL, '0'),
('31', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('32', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('33', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('34', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('35', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('36', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('37', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('38', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('39', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('40', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('41', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('42', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('43', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('44', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('45', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('46', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('47', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('48', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('49', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('50', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('51', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('52', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('53', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('54', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('55', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('56', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('57', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('58', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('59', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('60', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('61', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('62', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('63', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('64', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('65', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('66', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('67', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('68', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('69', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('70', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('71', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('72', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('73', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('74', '0', '4', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('75', '0', '4', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('76', '0', '4', '2023-12-31', '000002', '', '0', '0', '0', '3', '97', '0'),
('77', '0', '4', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('78', '0', '4', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('79', '0', '4', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('80', '0', '4', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('81', '0', '4', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('82', '0', '4', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('83', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('84', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('85', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('86', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('87', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('88', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('89', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('90', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('91', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('92', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('93', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('94', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('95', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('96', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('97', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('98', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('99', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('100', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('101', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('102', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('103', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('104', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('105', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('106', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('107', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('108', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('109', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('110', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('111', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('112', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('113', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('114', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('115', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('116', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('117', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('118', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('119', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('120', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('121', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('122', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('123', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('124', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('125', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('126', '0', '5', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('127', '0', '5', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('128', '0', '5', '2023-12-31', '000002', '', '0', '0', '0', '3', '97', '0'),
('129', '0', '5', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('130', '0', '5', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('131', '0', '5', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('132', '0', '5', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('133', '0', '5', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('134', '0', '5', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('135', '0', '6', '2023-12-31', '2100', '', '-1526399.03', '0', '0', '3', '35', '0'),
('136', '0', '6', '2023-12-31', '1200', '', '-3390.41', '0', '0', '2', '251', '0'),
('137', '0', '6', '2023-12-31', '1200', '', '7350', '0', '0', '2', '250', '0'),
('138', '0', '6', '2023-12-31', '1200', '', '5212.96', '0', '0', '2', '18', '0'),
('139', '0', '6', '2023-12-31', '1200', '', '3675', '0', '0', '2', '249', '0'),
('140', '0', '6', '2023-12-31', '1200', '', '1700.21', '0', '0', '2', '230', '0'),
('141', '0', '6', '2023-12-31', '1200', '', '1155', '0', '0', '2', '128', '0'),
('142', '0', '6', '2023-12-31', '3590', '', '7481832.18', '0', '0', NULL, NULL, '0'),
('143', '0', '6', '2023-12-31', '3590', '', '-5971135.91', '0', '0', NULL, NULL, '0'),
('144', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('145', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('146', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('147', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('148', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('149', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('150', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('151', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('152', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('153', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('154', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('155', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('156', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('157', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('158', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('159', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('160', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('161', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('162', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('163', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('164', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('165', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('166', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('167', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('168', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('169', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('170', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('171', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('172', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('173', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('174', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('175', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('176', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('177', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('178', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('179', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('180', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('181', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('182', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('183', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('184', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('185', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('186', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('187', '0', '7', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('188', '0', '7', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('189', '0', '7', '2023-12-31', '000002', '', '0', '0', '0', '3', '97', '0'),
('190', '0', '7', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('191', '0', '7', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('192', '0', '7', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('193', '0', '7', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('194', '0', '7', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('195', '0', '7', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('196', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('197', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('198', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('199', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('200', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('201', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('202', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('203', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('204', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('205', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('206', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('207', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('208', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('209', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('210', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('211', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('212', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('213', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('214', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('215', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('216', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('217', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('218', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('219', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('220', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('221', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('222', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('223', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('224', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('225', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('226', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('227', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('228', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('229', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('230', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('231', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('232', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('233', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('234', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('235', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('236', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('237', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('238', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('239', '0', '8', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('240', '0', '8', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('241', '0', '8', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('242', '0', '8', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('243', '0', '8', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('244', '0', '8', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('245', '0', '8', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('246', '0', '8', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('247', '0', '8', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('248', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('249', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('250', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('251', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('252', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('253', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('254', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('255', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('256', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('257', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('258', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('259', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('260', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('261', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('262', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('263', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('264', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('265', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('266', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('267', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('268', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('269', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('270', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('271', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('272', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('273', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('274', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('275', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('276', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('277', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('278', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('279', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('280', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('281', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('282', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('283', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('284', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('285', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('286', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('287', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('288', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('289', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('290', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('291', '0', '9', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('292', '0', '9', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('293', '0', '9', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('294', '0', '9', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('295', '0', '9', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('296', '0', '9', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('297', '0', '9', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('298', '0', '9', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('299', '0', '9', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('300', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('301', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('302', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('303', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('304', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('305', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('306', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('307', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('308', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('309', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('310', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('311', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('312', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('313', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('314', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('315', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('316', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('317', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('318', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('319', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('320', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('321', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('322', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('323', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('324', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('325', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('326', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('327', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('328', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('329', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('330', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('331', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('332', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('333', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('334', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('335', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('336', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('337', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('338', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('339', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('340', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('341', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('342', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('343', '0', '10', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('344', '0', '10', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('345', '0', '10', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('346', '0', '10', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('347', '0', '10', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('348', '0', '10', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('349', '0', '10', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('350', '0', '10', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('351', '0', '10', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('352', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('353', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('354', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('355', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('356', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('357', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('358', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('359', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('360', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('361', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('362', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('363', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('364', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('365', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('366', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('367', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('368', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('369', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('370', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('371', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('372', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('373', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('374', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('375', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('376', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('377', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('378', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('379', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('380', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('381', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('382', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('383', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('384', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('385', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('386', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('387', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('388', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('389', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('390', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('391', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('392', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('393', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('394', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('395', '0', '11', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('396', '0', '11', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('397', '0', '11', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('398', '0', '11', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('399', '0', '11', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('400', '0', '11', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('401', '0', '11', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('402', '0', '11', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('403', '0', '11', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('404', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('405', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('406', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('407', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('408', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('409', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('410', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('411', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('412', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('413', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('414', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('415', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('416', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('417', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('418', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('419', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('420', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('421', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('422', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('423', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('424', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('425', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('426', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('427', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('428', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('429', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('430', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('431', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('432', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('433', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('434', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('435', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('436', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('437', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('438', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('439', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('440', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('441', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('442', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('443', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('444', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('445', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('446', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('447', '0', '12', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('448', '0', '12', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('449', '0', '12', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('450', '0', '12', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('451', '0', '12', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('452', '0', '12', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('453', '0', '12', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('454', '0', '12', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('455', '0', '12', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('456', '0', '12', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('457', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('458', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('459', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('460', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('461', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('462', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('463', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('464', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('465', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('466', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('467', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('468', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('469', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('470', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('471', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('472', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('473', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('474', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('475', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('476', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('477', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('478', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('479', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('480', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('481', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('482', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('483', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('484', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('485', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('486', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('487', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('488', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('489', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('490', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('491', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('492', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('493', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('494', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('495', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('496', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('497', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('498', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('499', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('500', '0', '13', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('501', '0', '13', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('502', '0', '13', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('503', '0', '13', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('504', '0', '13', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('505', '0', '13', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('506', '0', '13', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('507', '0', '13', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('508', '0', '13', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('509', '0', '13', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('510', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('511', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('512', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('513', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('514', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('515', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('516', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('517', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('518', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('519', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('520', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('521', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('522', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('523', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('524', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('525', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('526', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('527', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('528', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('529', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('530', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('531', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('532', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('533', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('534', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('535', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('536', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('537', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('538', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('539', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('540', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('541', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('542', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('543', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('544', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('545', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('546', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('547', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('548', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('549', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('550', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('551', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('552', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('553', '0', '14', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('554', '0', '14', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('555', '0', '14', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('556', '0', '14', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('557', '0', '14', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('558', '0', '14', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('559', '0', '14', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('560', '0', '14', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('561', '0', '14', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('562', '0', '14', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('563', '0', '15', '2023-12-31', '1200', '', '3055', '0', '0', '2', '136', '0'),
('564', '0', '15', '2023-12-31', '1200', '', '2498', '0', '0', '2', '111', '0'),
('565', '0', '15', '2023-12-31', '1200', '', '15767.99', '0', '0', '2', '80', '0'),
('566', '0', '15', '2023-12-31', '1200', '', '1075', '0', '0', '2', '82', '0'),
('567', '0', '15', '2023-12-31', '1200', '', '1141.3', '0', '0', '2', '168', '0'),
('568', '0', '15', '2023-12-31', '1200', '', '8400', '0', '0', '2', '152', '0'),
('569', '0', '15', '2023-12-31', '1200', '', '2625', '0', '0', '2', '75', '0'),
('570', '0', '15', '2023-12-31', '1200', '', '1050', '0', '0', '2', '146', '0'),
('571', '0', '15', '2023-12-31', '1200', '', '3150', '0', '0', '2', '134', '0'),
('572', '0', '15', '2023-12-31', '1200', '', '3675', '0', '0', '2', '89', '0'),
('573', '0', '15', '2023-12-31', '1200', '', '37250', '0', '0', '2', '105', '0'),
('574', '0', '15', '2023-12-31', '1200', '', '2342.5', '0', '0', '2', '198', '0'),
('575', '0', '15', '2023-12-31', '1200', '', '5775', '0', '0', '2', '199', '0'),
('576', '0', '15', '2023-12-31', '1200', '', '17955', '0', '0', '2', '74', '0'),
('577', '0', '15', '2023-12-31', '1200', '', '19581.25', '0', '0', '2', '197', '0'),
('578', '0', '15', '2023-12-31', '1200', '', '770', '0', '0', '2', '22', '0'),
('579', '0', '15', '2023-12-31', '1200', '', '600.08', '0', '0', '2', '195', '0'),
('580', '0', '15', '2023-12-31', '1200', '', '525', '0', '0', '2', '234', '0'),
('581', '0', '15', '2023-12-31', '1200', '', '1050', '0', '0', '2', '25', '0'),
('582', '0', '15', '2023-12-31', '1200', '', '3350', '0', '0', '2', '27', '0'),
('583', '0', '15', '2023-12-31', '1200', '', '472.5', '0', '0', '2', '32', '0'),
('584', '0', '15', '2023-12-31', '1200', '', '503.01', '0', '0', '2', '33', '0'),
('585', '0', '15', '2023-12-31', '1200', '', '33780', '0', '0', '2', '36', '0'),
('586', '0', '15', '2023-12-31', '1200', '', '899.85', '0', '0', '2', '207', '0'),
('587', '0', '15', '2023-12-31', '1200', '', '5820', '0', '0', '2', '204', '0'),
('588', '0', '15', '2023-12-31', '1200', '', '-100', '0', '0', '2', '48', '0'),
('589', '0', '15', '2023-12-31', '1200', '', '2636', '0', '0', '2', '151', '0'),
('590', '0', '15', '2023-12-31', '1200', '', '325', '0', '0', '2', '50', '0'),
('591', '0', '15', '2023-12-31', '1200', '', '3937.71', '0', '0', '2', '102', '0'),
('592', '0', '15', '2023-12-31', '1200', '', '262.5', '0', '0', '2', '214', '0'),
('593', '0', '15', '2023-12-31', '1200', '', '1680', '0', '0', '2', '203', '0'),
('594', '0', '15', '2023-12-31', '1200', '', '3502.5', '0', '0', '2', '57', '0'),
('595', '0', '15', '2023-12-31', '1200', '', '12904.5', '0', '0', '2', '106', '0'),
('596', '0', '15', '2023-12-31', '1200', '', '-231.74', '0', '0', '2', '112', '0'),
('597', '0', '15', '2023-12-31', '1200', '', '3167.5', '0', '0', '2', '187', '0'),
('598', '0', '15', '2023-12-31', '1200', '', '892.5', '0', '0', '2', '88', '0'),
('599', '0', '15', '2023-12-31', '1200', '', '1600.2', '0', '0', '2', '181', '0'),
('600', '0', '15', '2023-12-31', '1200', '', '3675', '0', '0', '2', '156', '0'),
('601', '0', '15', '2023-12-31', '1200', '', '42058.16', '0', '0', '2', '69', '0'),
('602', '0', '15', '2023-12-31', '1200', '', '9636', '0', '0', '2', '70', '0'),
('603', '0', '15', '2023-12-31', '1200', '', '499.65', '0', '0', '2', '208', '0'),
('604', '0', '15', '2023-12-31', '1200', '', '1050', '0', '0', '2', '206', '0'),
('605', '0', '15', '2023-12-31', '1200', '', '16682.46', '0', '0', '2', '72', '0'),
('606', '0', '15', '2023-12-31', '20001', '', '35.5', '0', '0', NULL, NULL, '0'),
('607', '0', '15', '2023-12-31', '21076', '', '-14050.62', '0', '0', NULL, NULL, '0'),
('608', '0', '15', '2023-12-31', '000002', '', '37388.93', '0', '0', NULL, NULL, '0'),
('609', '0', '15', '2023-12-31', '24025', '', '90795', '0', '0', NULL, NULL, '0'),
('610', '0', '15', '2023-12-31', '24026', '', '-9537.5', '0', '0', NULL, NULL, '0'),
('611', '0', '15', '2023-12-31', '24008', '', '4660', '0', '0', NULL, NULL, '0'),
('612', '0', '15', '2023-12-31', '24007', '', '4000', '0', '0', NULL, NULL, '0'),
('613', '0', '15', '2023-12-31', '24009', '', '10000', '0', '0', NULL, NULL, '0'),
('614', '0', '15', '2023-12-31', '3590', '', '-428681.97', '0', '0', NULL, NULL, '0'),
('615', '0', '15', '2023-12-31', '3590', '', '28101.24', '0', '0', NULL, NULL, '0');

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) DEFAULT NULL,
  `charge_group` int(11) NOT NULL,
  `rate` double DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(1000) NOT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('7', 'No Sales Group', '0');

### Structure of table `0_icon` ###

DROP TABLE IF EXISTS `0_icon`;

CREATE TABLE `0_icon` (
  `icon_id` int(255) NOT NULL AUTO_INCREMENT,
  `icon_title` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `icon_img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `icon_img_arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `arabic_icon_title` varchar(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`icon_id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci ;

### Data of table `0_icon` ###

INSERT INTO `0_icon` VALUES
('1', 'Sales Quotation Entry', 'glyphicon glyphicon-pencil', '', 'إدخال خطاب تسعير مبيعات جديد'),
('2', 'Sales Order Entry', 'glyphicon glyphicon-file', '', 'إدخال أمر مبيعات'),
('3', 'Direct Delivery', 'glyphicon glyphicon-random', '', 'التسليم المباشرة'),
('4', 'Direct Invoice', 'glyphicon glyphicon-paste ', '', 'الفاتورة المباشرة'),
('5', 'Delivery Against Sales Orders', 'glyphicon glyphicon-retweet', '', 'التسليم مقابل أوامر المبيعات'),
('6', 'Invoice Against Sales Delivery', 'glyphicon glyphicon-save-file', '', 'فاتورة مقابل تسليم المبيعات'),
('7', 'Invoice Prepaid Orders', 'glyphicon glyphicon-edit', '', 'فاتورة أوامر الدفع المسبق'),
('8', 'Template Delivery', 'glyphicon glyphicon-inbox', '', 'تسليم النموذج'),
('9', 'Template Invoice', 'glyphicon glyphicon-copy', '', 'فاتورة النموذج'),
('10', 'Create and Print Recurrent Invoices', 'glyphicon glyphicon-print', '', 'إنشاء و طباعة الفواتير المتكررة'),
('11', 'Customer Payments', 'glyphicon glyphicon-usd', '', 'مدفوعات العملاء'),
('12', 'Customer Credit Notes', 'glyphicon glyphicon-open-file', '', 'إشعارات ائتمان العميل'),
('13', 'Allocate Customer Payments or Credit Notes', 'glyphicon glyphicon-ok-circle', '', 'تخصيص مدفوعات العميل أو إشعارات الائتمان'),
('14', 'Sales Quotation Inquiry', 'glyphicon glyphicon-refresh', '', 'استعلام عن عروض أسعار المبيعات'),
('15', 'Sales Order Inquiry', 'glyphicon glyphicon-book', '', 'استعلام عن طلب المبيعات'),
('16', 'Customer Transaction Inquiry', 'glyphicon glyphicon-cloud-download', '', 'استعلام عن مدفوعات العملاء'),
('17', 'Customer Allocation Inquiry', 'glyphicon glyphicon-credit-card', '', 'استعلام عن تخصيص العملاء'),
('18', 'Customer and Sales Reports', 'fa fa-files-o', '', 'تقارير العملاء والمبيعات'),
('19', 'Add and Manage Customers', 'ionicons ion-android-person-add', '', 'إضافة و إدارة العملاء'),
('20', 'Customer Branches', 'fa fa-building-o', '', 'فروع العملاء'),
('21', 'Sales Groups', 'fa fa-users', '', 'مجموعات المبيعات'),
('22', 'Recurrent Invoices', 'fa fa-wpforms', '', 'الفواتير المتكررة'),
('23', 'Sales Types', 'fa fa-clone', '', 'أنواع المبيعات'),
('24', 'Sales Persons', 'fa fa-male fa-lg', '', 'مندوبي المبيعات'),
('25', 'Sales Areas', 'fa fa-area-chart', '', 'مناطق المبيعات'),
('26', 'Credit Status Setup', 'fa fa-cogs', '', 'إعداد حالة الآئتمان'),
('27', 'Purchase Order Entry', 'fa fa-shopping-cart', '', 'إدخال أمر الشراء'),
('28', 'Outstanding Purchase Orders Maintenance', 'fa fa-recycle', '', 'صيانة أوامر الشراء المعلقة'),
('29', 'Direct GRN', 'glyphicon glyphicon-list-alt', '', 'GRN المباشر'),
('30', 'Direct Supplier Invoice', 'glyphicon glyphicon-duplicate', '', 'فاتورة المورد المباشرة'),
('31', 'Payments to Suppliers', 'ionicons ion-cash', '', 'المدفوعات للموردين'),
('32', 'Supplier Invoices', 'glyphicon glyphicon-duplicate', '', 'فواتير الموردين'),
('33', 'Supplier Credit Notes', 'fa fa-calendar-check-o', '', 'إشعارات ائتمان المورد'),
('34', 'Allocate Supplier Payments or Credit Notes', 'ionicons ion-android-done-all', '', 'تخصيص مدفوعات المورد أو إشعارات الائتمان'),
('35', 'Purchase Orders Inquiry', 'fa fa-check-square-o', '', 'الإستعلام عن أوامر الشراء'),
('36', 'Supplier Transaction Inquiry', 'ionicons ion-archive', '', 'استعلام عن معاملات المورد'),
('37', 'Supplier Allocation Inquiry', 'fa fa-pie-chart', '', 'الإستعلام عن حركات تخصيص الدفعات و الإشعارات الدائنة للمورد '),
('38', 'Supplier and Purchasing Reports', 'ionicons ion-android-cart', '', 'تقارير الموردين و المشتريات'),
('39', 'Suppliers', 'ionicons ion-android-contacts', '', 'الموردين'),
('40', 'Inventory Location Transfers', 'glyphicon glyphicon-map-marker', '', 'التحويلات المخزنية من و إلى مواقع التخزين'),
('41', 'Inventory Adjustments', 'fa fa-sliders', '', 'قيود التعديل مخزنية'),
('42', 'Inventory Item Movements', 'ionicons ion-cube', '', 'حركات بنود المخزون'),
('43', 'Inventory Reports', 'fa fa-clipboard', '', 'تقارير المخزون'),
('44', 'Inventory Item Status', 'fa fa-bar-chart', '', 'حالة بنود المخزون'),
('45', 'Items', 'fa fa-cubes', '', 'البنود المخزنية'),
('46', 'Foreign Item Codes', 'fa fa-barcode', '', 'أكواد البنود المخزنية الأجنبية'),
('47', 'Sales Kits', 'fa fa-dropbox', '', 'أدوات البيع'),
('48', 'Item Categories', 'fa fa-sitemap', '', 'تصنيفات بنود المخزون'),
('49', 'Inventory Locations', 'fa fa-map-o', '', 'مواقع التخزين للمخزون'),
('50', 'Units of Measure', 'ionicons ion-ios-speedometer', '', 'وحدات القياس'),
('51', 'Reorder Levels', 'fa fa-exchange', '', 'مستويات إعادة الطلب'),
('52', 'Sales Pricing', 'glyphicon glyphicon-tags', '', 'التسعير البيعي'),
('53', 'Purchasing Pricing', 'glyphicon glyphicon-gbp', '', 'التسعير الشرائي'),
('54', 'Standard Costs', 'fa fa-money', '', 'التكاليف المعيارية'),
('55', 'Work Order Entry', 'ionicons ion-ios-compose', '', 'إدخال أوامر التشغيل'),
('56', 'Outstanding Work Orders', 'fa fa-hourglass-end', '', 'أوامر التشغيل المتأخرة'),
('57', 'Costed Bill Of Material Inquiry', 'fa fa-file-text-o', '', 'الإستعلام عن تكاليف قائمة تركيبة المواد'),
('58', 'Inventory Item Where Used Inquiry', 'fa fa-file-archive-o', '', 'الإستعلام عن البنود المخزنية التي تم أستخدامها'),
('59', 'fa fa-refresh', 'Work Order Inquiry', '', 'fa fa تحديث'),
('60', 'Manufacturing Reports', 'fa fa-folder-open', '', 'تقارير العمليات التصنيعية'),
('61', 'Work Order Inquiry', 'glyphicon glyphicon-briefcase', '', 'الاستعلام عن أوامر التشغيل'),
('62', 'Bills Of Material', 'fa fa-file-excel-o', '', 'قائمة تركيبة المواد للبنود المخزنية المصنعة'),
('63', 'Work Centres', 'fa fa-hospital-o', '', 'مراكز التكلفة'),
('64', 'Fixed Assets Purchase', 'fa fa-car', '', 'شراء الأصول الثابتة'),
('65', 'Fixed Assets Location Transfers', 'fa fa-home', '', 'تحويلات موقع الأصول الثابتة'),
('66', 'Fixed Assets Disposal', 'glyphicon glyphicon-trash', '', 'التصرف في الأصول الثابتة'),
('67', 'Fixed Assets Sale', 'fa fa-tag', '', 'بيع الأصول الثابتة'),
('68', 'Process Depreciation', 'fa fa-line-chart', '', 'إهلاك العملية'),
('69', 'Fixed Assets Movements', 'fa fa-tasks', '', 'حركات الأصول الثابتة'),
('70', 'Fixed Assets Inquiry', 'fa fa-search', '', 'استعلام عن الأصول الثابتة'),
('71', 'Fixed Assets Reports', 'fa fa-archive', '', 'تقارير الأصول الثابتة'),
('72', 'Fixed Assets', 'fa fa-building', '', 'الأصول'),
('73', 'Fixed Assets Locations', 'fa fa-map-signs', '', 'مواقع الأصول الثابتة'),
('74', 'Fixed Assets Categories', 'glyphicon glyphicon-th-list', '', 'فئات الأصول الثابتة'),
('75', 'Fixed Assets Classes', 'fa fa-sort-amount-asc', '', 'فئات الأصول الثابتة'),
('76', 'Dimension Entry', 'glyphicon glyphicon-blackboard', '', 'إدخال القطاع التحليلي'),
('77', 'Outstanding Dimensions', 'glyphicon glyphicon-thumbs-down', '', 'القطاعات التحليلية المنتهية'),
('78', 'Dimension Inquiry', 'glyphicon glyphicon-zoom-in', '', 'الإستعلام عن القطاعات التحليلية'),
('79', 'Dimension Reports', 'glyphicon glyphicon-copy', '', 'تقارير القطاعات التحليلية'),
('80', 'Dimension Tags', 'ionicons ion-ios-pricetags', '', 'القطاعات التحليلية و الكلمات الدلالية'),
('81', 'Payments', 'fa fa-credit-card', '', 'الدفعات'),
('82', 'Deposits', 'fa fa-check-square-o', '', 'الإيداعات'),
('83', 'Bank Account Transfers', 'fa fa-university', '', 'التحويل بين الحسابات البنكية'),
('84', 'Journal Entry', 'fa fa-pencil-square-o', '', 'إدخال قيود اليومية العامة'),
('85', 'Budget Entry', 'fa fa-repeat', '', 'إدخال الموازنات'),
('86', 'Reconcile Bank Account', 'fa fa-handshake-o', '', 'تسوية الحساب البنكي'),
('87', 'Revenue / Costs Accruals', 'fa fa-area-chart', '', 'الإيرادات / المصروفات المستحقة'),
('88', 'Journal Inquiry', 'fa fa-comments', '', 'الاستعلام عن دفتر اليومية'),
('89', 'GL Inquiry', 'fa fa-share-square-o', '', 'الاستعلام عن الأستاذ العام'),
('90', 'Bank Account Inquiry', 'fa fa-reply-all', '', 'الإستعلام عن الحسابات البنكية'),
('91', 'Tax Inquiry', 'fa fa-calendar-check-o', '', 'الأستعلام عن الضريبة'),
('92', 'Trial Balance', 'glyphicon glyphicon-repeat', '', 'ميزان المراجعة'),
('93', 'Balance Sheet Drilldown', 'glyphicon glyphicon-menu-down', '', 'القائمة المختصرة للميزانية العمومية'),
('94', 'Profit and Loss Drilldown', 'ionicons ion-stats-bars', '', 'القائمة المختصرة للأرباح و الخسائر'),
('95', 'Banking Reports', 'fa fa-print', '', 'التقارير البنكية'),
('96', 'General Ledger Reports', 'ionicons ion-android-clipboard', '', 'تقارير الأستاذ العام'),
('97', 'Bank Accounts', 'icomoon icon-library', '', 'الحسابات البنكية'),
('98', 'Quick Entries', 'icomoon icon-point-right', '', 'الإدخالات السريعة'),
('99', 'Account Tags', 'icomoon icon-tags', '', 'الكلمات الدلالية للحساب'),
('100', 'Currencies', 'icomoon icon-coin', '', 'العملات'),
('101', 'Exchange Rates', 'icomoon icon-loop-3', '', 'معدل تبادل العملات'),
('102', 'GL Accounts', 'icomoon icon-drawer-2', '', 'حسابات GL'),
('103', 'GL Account Groups', 'fi-page-multiple', '', 'مجموعات حساب GL'),
('104', 'GL Account Classes', 'icomoon icon-table-2', '', 'فئات حساب دفتر الأستاذ العام'),
('105', 'Closing GL Transactions', 'icomoon icon-drawer-3', '', 'إغلاق معاملات دفتر الأستاذ العام'),
('106', 'Revaluation of Currency Accounts', 'glyphicon glyphicon-euro', '', 'إعادة تقييم حسابات العملات'),
('107', 'Import CSV Items', 'glyphicon glyphicon-import', '', 'استيراد عناصر CSV'),
('108', 'Company Setup', 'ionicons ion-android-settings', 'إدخال أمر الشراء', 'إعدادات الشركة'),
('109', 'Quick Access', 'glyphicon glyphicon-th', '', 'الوصول السريع'),
('110', 'User Accounts Setup', 'icomoon icon-user-4', '', 'إعدادات حسابات المستخدمين'),
('111', 'Access Setup', 'glyphicon glyphicon-download-alt', '', 'إعدادات الوصول'),
('112', 'Display Setup', 'fa fa-cogs', '', 'إعدادات العرض'),
('113', 'Transaction References', 'fa fa-random', '', 'مراجع المعاملات'),
('114', 'Taxes', 'icomoon icon-file-css', '', 'الضرائب'),
('115', 'Tax Groups', 'icomoon icon-expand', '', 'المجموعات الضريبية'),
('116', 'Item Tax Types', 'icomoon icon-checkbox-partial', '', 'أنواع ضريبة العنصر'),
('117', 'System and General GL Setup', 'icomoon icon-address-book', '', 'النظام وإعداد GL العام'),
('118', 'Fiscal Years', 'fa fa-calendar', '', 'السنوات المالية'),
('119', 'Print Profiles', 'fa fa-clipboard', '', 'طباعة التشكيلات'),
('120', 'Payment Terms', 'icomoon icon-file-powerpoint', '', 'شروط الدفع'),
('121', 'Shipping Company', 'ionicons ion-android-boat', '', 'شركة الشحن'),
('122', 'Points of Sale', 'icomoon icon-stats', '', 'نقاط البيع'),
('123', 'Printers', 'icomoon icon-print', '', 'طابعات'),
('124', 'Void a Transaction', 'icomoon icon-redo', '', 'صفقة باطلة'),
('125', 'View or Print Transactions', 'icomoon icon-profile', '', ' عرض أو طباعة المعاملات'),
('126', 'Attach Documents', 'icomoon icon-attachment', '', 'أرفاق المستندات'),
('127', 'System Diagnostics', 'icomoon icon-laptop', '', 'تشخيصات النظام'),
('128', 'Backup and Restore', 'fi-archive', '', 'النسخ الاحتياطي واستعادة'),
('129', 'Create/Update Companies', 'glyphicon glyphicon-transfer', '', 'إنشاء و تحديث الشركات'),
('130', 'Install/Activate Themes', 'icomoon icon-indent-increase', '', 'تثبيت / تنشيط السمات'),
('131', 'Install/Activate Chart of Accounts', 'icomoon icon-bars', '', 'تثبيت / تنشيط مخطط الحسابات'),
('132', 'Software Upgrade', 'icomoon icon-loop-2', '', 'تحديث البرنامج'),
('133', 'Install/Update Languages', 'fa fa-language', '', 'تثبيت / تحديث اللغات'),
('134', 'Install/Activate Extensions', 'fa fa-usb', '', 'تثبيت أو تفعيل الأمتدادات '),
('137', 'Import CSV Customer', 'glyphicon glyphicon-import', '', 'استيراد عميل CSV'),
('138', 'Material Requisitions', '', '', 'طلبات المواد'),
('139', 'Purchase Requisitions', '', '', 'طلبات الشراء'),
('140', 'Supplier RFQ', '', '', 'المورد RFQ'),
('141', 'Material Requisition Dashboard', '', '', 'لوحة معلومات طلب المواد'),
('142', 'Purchase Requisition Dashboard', '', '', 'لوحة معلومات طلب الشراء'),
('143', 'Comparision Report Dashboard', '', '', 'لوحة معلومات تقرير المقارنة'),
('144', 'Import CSV Supplier', '', '', 'استيراد مورد CSV'),
('145', 'Adjustments and Transfer inquiry', '', '', 'استعلام عن التعديلات والتحويلات'),
('146', 'PDC Management', '', '', 'إدارة PDC'),
('147', 'Attendances', '', '', 'الحضور'),
('148', 'Leave', '', '', 'غادر'),
('149', 'Payroll Allocation', '', '', 'تخصيص الرواتب'),
('150', 'Document Expiration', '', '', 'انتهاء صلاحية المستند'),
('151', 'Employee Advances', '', '', 'سلف الموظف'),
('152', 'Timesheet', '', '', 'ورقة التوقيت'),
('153', 'Leave  Inquiry', '', '', 'استعلام عن الإجازة'),
('154', 'Payroll Dashboard', '', '', 'لوحة تحكم الرواتب'),
('155', 'Employee Document Inquiry', '', '', 'استعلام عن مستندات الموظف'),
('156', 'Employee Reports', '', '', 'تقارير الموظفين'),
('157', 'Employees', '', '', 'الموظفين'),
('158', 'Document Type', '', '', 'نوع الوثيقة'),
('159', 'Departments', '', '', 'الإدارات'),
('160', 'Manage Overtime', '', '', 'إدارة الوقت الإضافي'),
('161', 'Default Settings', '', '', 'الإعدادات الافتراضية'),
('162', 'Designation', '', '', 'تعيين'),
('163', 'Salary Structure', '', '', 'هيكلية الرواتب'),
('164', 'Create Allowance', '', '', 'إنشاء بدل'),
('165', 'Create Deduction', '', '', 'إنشاء خصم'),
('166', 'Overtime And Weekends', '', '', 'العمل الإضافي وعطلات نهاية الأسبوع'),
('167', 'Holidays', '', '', 'العطل'),
('168', 'Transactions', '', '', 'الحركات'),
('169', 'Inquiries and Reports', '', '', 'الإستعلامات و التقارير'),
('170', 'Maintenance', '', '', 'نماذج الأدخال الأساسية'),
('171', 'Pricing and Costs', '', '', 'التسعير البيعي و التكاليفي'),
('172', 'Loyality Point Features', '', '', 'ميزات نقطة الولاء'),
('173', 'Auto Email Reports', '', '', 'تقارير تلقائية بالبريد الإلكتروني'),
('174', 'Auto Email Reports Dashboard', '', '', 'لوحة معلومات تقارير البريد الإلكتروني التلقائي'),
('175', 'Signature', '', '', 'التوقيع'),
('176', 'Signature Dashboard', '', '', 'لوحة التوقيع'),
('177', 'Report Format', '', '', 'شكل التقرير'),
('178', 'Reports Shorctut', '', '', 'اختصار التقارير'),
('179', 'Multiple Company Setup', '', '', 'إعداد شركة متعددة'),
('180', 'Send SMS', '', '', 'أرسل رسالة نصية قصيرة'),
('181', 'Mail sending setup', '', '', 'إعداد إرسال البريد'),
('182', 'Miscellaneous', '', '', 'متنوعة'),
('183', 'Contact Categories', '', '', 'تصنيفات الاتصالات'),
('184', 'Attach Documents (New)', '', '', 'إرفاق المستندات (جديد)'),
('185', 'Document Attachment Inquiry', '', '', 'استعلام عن مرفق الوثيقة'),
('187', 'Reports Shortcut', '', '', 'اختصار التقارير'),
('188', 'Transaction ', '', '', 'عملية تجارية\r\n'),
('189', 'Search Item Hot Key', '', '', 'مفتاح البحث السريع لعنصر البحث'),
('190', 'New Sale', '', '', 'بيع جديد'),
('191', 'Import Attendances', '', '', 'حضور الاستيراد'),
('192', 'check In', '', '', 'تحقق في');

### Structure of table `0_inquiry_type` ###

DROP TABLE IF EXISTS `0_inquiry_type`;

CREATE TABLE `0_inquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inquiry_type` varchar(150) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_inquiry_type` ###

INSERT INTO `0_inquiry_type` VALUES
('1', 'Government', '0'),
('2', 'Residential', '0'),
('3', 'Retail', '0'),
('4', 'Commercial', '0');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `description` varchar(200) NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=610 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', '01', '01', 'Item', '2', '1', '0', '0'),
('2', 'IP001', 'IP001', 'Internal Painting (sqm) ', '2', '1', '0', '0'),
('3', 'IP002', 'IP002', 'Internal Painting (Job)', '2', '1', '0', '0'),
('4', 'EP001', 'EP001', 'External Painting (sqm)', '2', '1', '0', '0'),
('5', 'EP002', 'EP002', 'External Painting (Job)', '2', '1', '0', '0'),
('6', 'SI001', 'SI001', 'Supply &amp; Installation (sqm)', '2', '1', '0', '0'),
('7', 'SI002', 'SI002', 'Supply &amp; Installation (Job)', '2', '1', '0', '0'),
('8', 'SA001', 'SA001', 'Supply &amp; Apply (sqm)', '2', '1', '0', '0'),
('9', 'SA002', 'SA002', 'Supply &amp; Apply (Job)', '2', '1', '0', '0'),
('10', 'EW001', 'EW001', 'Electrical Work (Job)', '2', '1', '0', '0'),
('11', 'MW001', 'MW001', 'Maintenance Work (Job)', '2', '1', '0', '0'),
('12', 'WI001', 'WI001', 'Wallpaper Installation (Job)', '2', '1', '0', '0'),
('13', 'WI002', 'WI002', 'Wallpaper Installation (sqm)', '2', '1', '0', '0'),
('14', 'LAI001', 'LAI001', 'llaza Awning Installation(Job)', '2', '1', '0', '0'),
('15', 'I-001', 'I-001', ' S T G Pvc Trunking 25 X 16 m', '2', '1', '0', '0'),
('16', 'I-002', 'I-002', '13A 2 Gang Single Pole Swith Double Socket -Clad', '2', '1', '0', '0'),
('17', 'I-003', 'I-003', 'National Steel Putty 1.5kg', '2', '1', '0', '0'),
('18', 'I-004', 'I-004', 'Jotun fenomastic Matt 0486 1Ltr', '2', '1', '0', '0'),
('19', 'I-005', 'I-005', 'Jotun fenomastic Matt 5489 1Ltr', '2', '1', '0', '0'),
('20', 'I-006', 'I-006', 'Jotun fenomastic Matt S055 Y10', '2', '1', '0', '0'),
('21', 'I-007', 'I-007', 'Aluminium Extension Rod 2mtr', '2', '1', '0', '0'),
('22', 'I-008', 'I-008', 'Brass Reducer Bush 1/2 x 3/4', '2', '1', '0', '0'),
('23', 'I-009', 'I-009', 'Denim Brush Wood SB-L03', '2', '1', '0', '0'),
('24', 'I-010', 'I-010', 'Dewalt SDS Plus Drill Bit - 12mm x 150mm x 200mm', '2', '1', '0', '0'),
('25', 'I-011', 'I-011', 'DW00736-AE', '2', '1', '0', '0'),
('26', 'I-012', 'I-012', 'Fevicol Dr. Fixit Crack X Powder (Pkt)', '2', '1', '0', '0'),
('27', 'I-0013', 'I-0013', 'Gazelle Curved Claw Hammer 20 oz G80167', '2', '1', '0', '0'),
('28', 'I-014', 'I-014', 'Gazelle Platform Trolley - Steel Bed W/ Folding Hsndle 720 x 490 mm G2501', '2', '1', '0', '0'),
('29', 'I-015', 'I-015', 'Gazelle Voltage Tester G80365', '2', '1', '0', '0'),
('30', 'I-016', 'I-016', 'Jotun Jota Floor Epoxy Paint Ral 9010 (1USG)', '2', '1', '0', '0'),
('31', 'I-017', 'I-017', 'Llaza Awning Complete PRO 350 3.00 x 2.5 mtr', '2', '1', '0', '0'),
('32', 'I-018', 'I-018', 'Llaza Awning Complete PRO 350 4.30 x 2.5mtr', '2', '1', '0', '0'),
('33', 'I-019', 'I-019', 'Makita SDS plus Drill Bit - 14mm 260mm x 200mm D-00664', '2', '1', '0', '0'),
('34', 'I-020', 'I-020', 'Xpert Stretch Wrapping Film Clear (1.8KG)', '2', '1', '0', '0'),
('35', 'I-021', 'I-021', 'Xpert Paint Brush Wooden Handle 4 (2100)', '2', '1', '0', '0'),
('36', 'I-022', 'I-022', 'Xpert Decor Yarn Tool # YT1515/SB-P03', '2', '1', '0', '0'),
('37', 'I-023', 'I-023', 'Xpert Decor Plastic Trowel SB-PT-1', '2', '1', '0', '0'),
('38', 'I-024', 'I-024', ' Xpert Decor Plastic Trowel 26x7cm # SB-PT-B', '2', '1', '0', '0'),
('39', 'I-025', 'I-025', 'Water Proof Paper Captain Grit-100', '2', '1', '0', '0'),
('40', 'I-026', 'I-026', 'UPVC Y 2', '2', '1', '0', '0'),
('41', 'I-027', 'I-027', 'Upvc Tee 2', '2', '1', '0', '0'),
('42', 'I-028', 'I-028', 'Universal Classic Paint Tray 9 UCPT9', '2', '1', '0', '0'),
('43', 'I-029', 'I-029', 'Trowel 4', '2', '1', '0', '0'),
('44', 'I-030', 'I-030', 'Tower HD Gross Foam Texture Roller Refil 4', '2', '1', '0', '0'),
('45', 'I-031', 'I-031', 'Terminator Terminal Connector Block 20A #TTB20A', '2', '1', '0', '0'),
('46', 'I-032', 'I-032', 'STANLEY STANDARD SCREWDRIVER 1X100 MM STHT 60805-8', '2', '1', '0', '0'),
('47', 'I-033', 'I-033', 'Stanley Standard Screwdriver (-) 100mm STHT65187', '2', '1', '0', '0'),
('48', 'I-034', 'I-034', 'Stanley Combination Wrench 13MM #STMT80223-8B', '2', '1', '0', '0'),
('49', 'I-035', 'I-035', 'Socket Wrench 1/4', '2', '1', '0', '0'),
('50', 'I-036', 'I-036', 'SEGMENTED DIAMOND BLADE 115MM DW47452HP', '2', '1', '0', '0'),
('51', 'I-037', 'I-037', 'Segmented Diamond Blade 115mm DW 47451 HP', '2', '1', '0', '0'),
('52', 'I-038', 'I-038', 'Scrapper 3', '2', '1', '0', '0'),
('53', 'I-039', 'I-039', 'Scrapper 2', '2', '1', '0', '0'),
('54', 'I-040', 'I-040', 'Ruko HSS Ground Tin Coated Drill Bit 8mm 250080T', '2', '1', '0', '0'),
('55', 'I-041', 'I-041', 'Ruko HSS Ground Tin Coated Drill Bit 9mm 250090T', '2', '1', '0', '0'),
('56', 'I-042', 'I-042', 'Ruko HSS Drill Bit (214150) 15.0mm', '2', '1', '0', '0'),
('57', 'I-043', 'I-043', 'Ruko HSS Drill Bit (214105) 10.5mm', '2', '1', '0', '0'),
('58', 'I-044', 'I-044', 'Ruko HSS Drill Bit (214090) 9.00mm', '2', '1', '0', '0'),
('59', 'I-045', 'I-045', 'Ruko HSS Drill Bit (214060) 6.0mm', '2', '1', '0', '0'),
('60', 'I-046', 'I-046', 'PVC Tee 3/4', '2', '1', '0', '0'),
('61', 'I-047', 'I-047', 'PVC Tee 1 1/2', '2', '1', '0', '0'),
('62', 'I-048', 'I-048', 'PVC Tee 1', '2', '1', '0', '0'),
('63', 'I-049', 'I-049', 'PVC Solvent Cement (Nos)', '2', '1', '0', '0'),
('64', 'I-050', 'I-050', 'PVC Reducer Bush 1 x 1/2', '2', '1', '0', '0'),
('65', 'I-051', 'I-051', 'PVC Pipe  3/4', '2', '1', '0', '0'),
('66', 'I-052', 'I-052', 'PVC Pipe 1', '2', '1', '0', '0'),
('67', 'I-053', 'I-053', 'PVC Female Socket 3/4', '2', '1', '0', '0'),
('68', 'I-054', 'I-054', 'MOP', '2', '1', '0', '0'),
('69', 'I-055', 'I-055', 'Milano Flat Chisal 12 with guard', '2', '1', '0', '0'),
('70', 'I-056', 'I-056', 'Milano Eagle Angle Valve 140800300221', '2', '1', '0', '0'),
('71', 'I-057', 'I-057', 'Milano 13A2 gang single poles with Double socket-clad V4060', '2', '1', '0', '0'),
('72', 'I-058', 'I-058', 'Milano 13A 1 Gang Switched Socket,Single Pole White V4050', '2', '1', '0', '0'),
('73', 'I-059', 'I-059', '3X3 PVC SQUARE COVER WHITE', '2', '1', '0', '0'),
('74', 'I-060', 'I-060', 'extensible hose 1-1/4&quot;(w/o rosete)1.0-80 160pcs/ctn', '2', '1', '0', '0'),
('75', 'I-061', 'I-061', 'Mal Mal 15 Yard', '2', '1', '0', '0'),
('76', 'I-062', 'I-062', 'Milano 2 Gang 2 Way 210800100035 W/p', '2', '1', '0', '0'),
('77', 'I-O63', 'I-O63', 'CSK Screw 5/8x6', '2', '1', '0', '0'),
('78', 'I-064', 'I-064', 'Disposable PE Shoe Cover Blue (100 Pcs/Pkt)', '2', '1', '0', '0'),
('79', 'I-065', 'I-065', 'DQ Steel Nail 1-1/2 (40mm)', '2', '1', '0', '0'),
('80', 'I-066', 'I-066', 'Gypsum Screw 4 x 10 (Pkt)', '2', '1', '0', '0'),
('81', 'I-067', 'I-067', 'Tile Spacer', '2', '1', '0', '0'),
('82', 'I-068', 'I-068', 'Tile Spacer 2mm', '2', '1', '0', '0'),
('83', 'I-069', 'I-069', 'Feet Guard Safety Shoes 402 High Ankle #41', '2', '1', '0', '0'),
('84', 'I-070', 'I-070', 'Safety Shoes Executive M003 # 40', '2', '1', '0', '0'),
('85', 'I-071', 'I-071', 'Safety Shoes Executive M003 # 41', '2', '1', '0', '0'),
('86', 'I-072', 'I-072', 'Bitumen sheet 4mm x 1.3 meter x 10meter', '2', '1', '0', '0'),
('87', 'I-073', 'I-073', 'Bubble Sheet', '2', '1', '0', '0'),
('88', 'I-074', 'I-074', 'Cotton Rope 12mm x 40yd', '2', '1', '0', '0'),
('89', 'I-075', 'I-075', 'DD Corrugated/Flexible Conduit Black 20mm x 50Mtr', '2', '1', '0', '0'),
('90', 'I-076', 'I-076', 'Kedder 8mm 200mtr', '2', '1', '0', '0'),
('91', 'I-077', 'I-077', 'LED strip Light D/L - Selex 50 mtr', '2', '1', '0', '0'),
('92', 'I-078', 'I-078', 'Line Dori Red Colour', '2', '1', '0', '0'),
('93', 'I-079', 'I-079', 'Line Dori White', '2', '1', '0', '0'),
('94', 'I-080', 'I-080', 'Synthesis Commercial 95 Desert Sand 3m x 40m', '2', '1', '0', '0'),
('95', 'I-081', 'I-081', 'Hand Tape', '2', '1', '0', '0'),
('96', 'I-082', 'I-082', 'Llaza Splenbox 400 Grey (3 Mtr Projection)', '2', '1', '0', '0'),
('97', 'I-083', 'I-083', 'Xpert Decor Artist Brush Set (18 Pcs) # AB18', '2', '1', '0', '0'),
('98', 'I-084', 'I-084', 'Xpert Decor Scrapper Set WHSS (50+80+100+120 MM)', '2', '1', '0', '0'),
('99', 'I-085', 'I-085', 'AP Berger Bitumen Emulsion 15k', '2', '1', '0', '0'),
('100', 'I086', 'I086', 'Berger Acrylic Spray Compond White', '2', '1', '0', '0'),
('101', 'I-087', 'I-087', 'AP Berger Bitumen Emulsion 15kg', '2', '1', '0', '0'),
('103', 'I-089', 'I-089', 'Berger Tuff Exterior W1 Base 27kg', '2', '1', '0', '0'),
('104', 'I-090', 'I-090', 'Berger Value Gypsum Joint Compound 25 Kgs/Drum', '2', '1', '0', '0'),
('105', 'I-091', 'I-091', 'Acid', '2', '1', '0', '0'),
('106', 'I-092', 'I-092', 'A P Berger A R Primer  1 USG', '2', '1', '0', '0'),
('107', 'I-093', 'I-093', 'Berger Royale Matt Emulsion Black (Gal)', '2', '1', '0', '0'),
('108', 'I-094', 'I-094', 'Berger Select All in One Enamel White 000 (3.5 Ltr)', '2', '1', '0', '0'),
('109', 'I-095', 'I-095', 'Berger Special Value Red Oxide Prime(1USG)', '2', '1', '0', '0'),
('110', 'I-096', 'I-096', 'Jotun fenomastic matt S0550 - Y10R', '2', '1', '0', '0'),
('111', 'I-097', 'I-097', 'Jotun Hardtop Coat XP S 4050-Y80R (1USG)', '2', '1', '0', '0'),
('112', 'I-098', 'I-098', 'Jotun pen guard top coat black', '2', '1', '0', '0'),
('113', 'I-099', 'I-099', 'Jotun Pen Guard Top Coat S4050-Y80 R (1 USG)', '2', '1', '0', '0'),
('114', 'I-100', 'I-100', 'Thinner Berger Universal E55', '2', '1', '0', '0'),
('115', 'I-101', 'I-101', 'Dr.Fixit Silicone Sealant 501 S.S GPS-WH (280GM)', '2', '1', '0', '0'),
('116', 'I-102', 'I-102', 'Italian Stucco White Xpressions (5 Kgs)', '2', '1', '0', '0'),
('117', 'I-103', 'I-103', 'Berger Royale Matt Emulsion Base W0 (Ltr)', '2', '1', '0', '0'),
('118', 'I-104', 'I-104', 'Berger Select All in One Enamel White 000 (1 Ltr)', '2', '1', '0', '0'),
('119', 'I-105', 'I-105', '13 Amp Single Switch Socket', '2', '1', '0', '0'),
('120', 'I-106', 'I-106', '20A DP Switch for FCU (Relite)', '2', '1', '0', '0'),
('121', 'I-107', 'I-107', '2G 1W Switch', '2', '1', '0', '0'),
('122', 'I-108', 'I-108', 'Bosch Grinding Wheel 2608603181', '2', '1', '0', '0'),
('123', 'I-109', 'I-109', 'Cargo Lashing 2x10mtr', '2', '1', '0', '0'),
('124', 'I-110', 'I-110', 'Cusbor Bonded Red Polyester Thread', '2', '1', '0', '0'),
('125', 'I-111', 'I-111', 'Cutting Disc Metal 4-1/2', '2', '1', '0', '0'),
('126', 'I-112', 'I-112', 'Fevicol Super Glue (3 Grm)', '2', '1', '0', '0'),
('127', 'I-113', 'I-113', 'Fischer Chemical FIS VS Low', '2', '1', '0', '0'),
('128', 'I-114', 'I-114', 'Gazelle Plastic Snap- off Knife G 80105', '2', '1', '0', '0'),
('129', 'I-115', 'I-115', 'Half Round File 6', '2', '1', '0', '0'),
('130', 'I-116', 'I-116', 'Milano Deluxe White Shattaf Set 140200100223', '2', '1', '0', '0'),
('131', 'I-117', 'I-117', 'MTX Tile Drill Bit #728149 Size 4MM', '2', '1', '0', '0'),
('132', 'I-118', 'I-118', 'MTX Tile Drill Bit #728169 Size 6MM', '2', '1', '0', '0'),
('133', 'I-119', 'I-119', 'Paint Brush Harris 1.5', '2', '1', '0', '0'),
('134', 'I-120', 'I-120', 'Plumb Bob', '2', '1', '0', '0'),
('135', 'I-121', 'I-121', 'PVC Box 3X3', '2', '1', '0', '0'),
('136', 'I-122', 'I-122', 'Safety Helmet Per4mer 141 Yellow', '2', '1', '0', '0'),
('137', 'I-123', 'I-123', 'Safety Vest Net Typr Yellow/green Per4mer VMT01 L', '2', '1', '0', '0'),
('138', 'I-124', 'I-124', 'Scissors', '2', '1', '0', '0'),
('139', 'I-125', 'I-125', 'Silicone Gun', '2', '1', '0', '0'),
('140', 'I-126', 'I-126', 'Soft Broom', '2', '1', '0', '0'),
('141', 'I-127', 'I-127', 'Teflon Tape White 1', '2', '1', '0', '0'),
('142', 'I-128', 'I-128', 'Tester', '2', '1', '0', '0'),
('143', 'I-129', 'I-129', 'Universal Classic Paint Tray 9 UCPT9', '2', '1', '0', '0'),
('144', 'I-130', 'I-130', 'W/C Seat Cover', '2', '1', '0', '0'),
('145', 'I-131', 'I-131', 'WD-40 Aerosol 330ml', '2', '1', '0', '0'),
('146', 'I-132', 'I-132', 'Garbage Bag (Pkt)', '2', '1', '0', '0'),
('147', 'I-133', 'I-133', 'Safety Shoes Executive M003 # 43', '2', '1', '0', '0'),
('148', 'I-134', 'I-134', 'APBerger Smart Care Waterproofing Damp block 2K 3kg', '2', '1', '0', '0'),
('149', 'I-135', 'I-135', 'Cement OPC / Black', '2', '1', '0', '0'),
('150', 'I-136', 'I-136', 'A P Berger Marmorino Smooth A643 20kg', '2', '1', '0', '0'),
('152', 'I-138', 'I-138', 'A P Berger Bariq Almas Silver 4 KG', '2', '1', '0', '0'),
('153', 'I-139', 'I-139', 'Berger Hi-Gloss Enamel Base W0 1 USG', '2', '1', '0', '0'),
('154', 'I-140', 'I-140', 'Berger Royale Play Najam Silver Base 3.6 LTR', '2', '1', '0', '0'),
('155', 'I-141', 'I-141', 'Gi Nut 10mm Kg', '2', '1', '0', '0'),
('156', 'I-142', 'I-142', 'Cotton Rags White Unstitched', '2', '1', '0', '0'),
('157', 'I-143', 'I-143', 'Spray Paint White', '2', '1', '0', '0'),
('158', 'I-144', 'I-144', 'Berger Universal Thinner E55 Clear 0.9 Ltr', '2', '1', '0', '0'),
('159', 'I-145', 'I-145', 'DEWALT 115MM DIAMOND BLADE TILE DX3121', '2', '1', '0', '0'),
('160', 'I-146', 'I-146', 'Terminator Terminal Connector Block 10A #TTB10A', '2', '1', '0', '0'),
('161', 'I-147', 'I-147', 'UPVC Pipe 2', '2', '1', '0', '0'),
('162', 'I-148', 'I-148', 'Upvc Socket 2', '2', '1', '0', '0'),
('163', 'I-149', 'I-149', 'Corrugated Paper Roll', '2', '1', '0', '0'),
('164', 'I-150', 'I-150', 'Tile Grout APS (Bag)', '2', '1', '0', '0'),
('165', 'I-151', 'I-151', 'Jotun pen guard primer gallon', '2', '1', '0', '0'),
('166', 'I-152', 'I-152', 'Berger Tuff Exterior Wo Base Ltr', '2', '1', '0', '0'),
('167', 'I-153', 'I-153', 'Aluminum Profile 1669 Single 6 Mtr', '2', '1', '0', '0'),
('168', 'I-154', 'I-154', 'Connector APS', '2', '1', '0', '0'),
('169', 'I-155', 'I-155', 'Holder', '2', '1', '0', '0'),
('170', 'I-156', 'I-156', 'Milano Deluxe Chrome Shattaf Set 140200100224', '2', '1', '0', '0'),
('171', 'I-157', 'I-157', 'MTX Tile Drill Bit #728159 Size 5MM', '2', '1', '0', '0'),
('172', 'I-158', 'I-158', 'PVC Box 3 x 6', '2', '1', '0', '0'),
('173', 'I-159', 'I-159', 'PVC Elbow 3/4', '2', '1', '0', '0'),
('174', 'I-160', 'I-160', 'Xpert Paint Brush Reg. Blue Handle 4 (1100)', '2', '1', '0', '0'),
('175', 'I-161', 'I-161', 'Self bracket white 10x12', '2', '1', '0', '0'),
('176', 'I-162', 'I-162', 'Opp tape clear 2x80 yard', '2', '1', '0', '0'),
('177', 'I-163', 'I-163', 'Teflon Tape Stower 1', '2', '1', '0', '0'),
('178', 'I-164', 'I-164', 'Safety Specticles SP1401 Hook Tinted', '2', '1', '0', '0'),
('179', 'I-165', 'I-165', 'Berger Tuff Exterior Wo Base-5KG', '2', '1', '0', '0'),
('180', 'I-166', 'I-166', 'Berger Value Stucco Extra Mix (3.5 Ltr)', '2', '1', '0', '0'),
('181', 'I-167', 'I-167', 'Fevicol HeatX (3.8L)', '2', '1', '0', '0'),
('182', 'I-168', 'I-168', 'Berger Universal Thinner (E55) Clear 1usg', '2', '1', '0', '0'),
('183', 'I-169', 'I-169', 'A P Berger silicon Sealent G P Clear 280 ml', '2', '1', '0', '0'),
('184', 'I-170', 'I-170', 'Insulation Tape Black', '2', '1', '0', '0'),
('185', 'I-171', 'I-171', 'Magnetic Ballast 36 W', '2', '1', '0', '0'),
('186', 'I-172', 'I-172', 'Paint Filter', '2', '1', '0', '0'),
('187', 'I-173', 'I-173', 'PVC Elbow 1', '2', '1', '0', '0'),
('188', 'I-174', 'I-174', 'Silicon Dow Corning 799 Clear 310 ml', '2', '1', '0', '0'),
('189', 'I-175', 'I-175', 'Star Drill Bit 2', '2', '1', '0', '0'),
('190', 'I-176', 'I-176', 'Synthesis Commercial 95 deep ochere 3x40 Mtr.', '2', '1', '0', '0'),
('191', 'I-177', 'I-177', 'Cement White  kg', '2', '1', '0', '0'),
('192', 'I-178', 'I-178', 'Anchore Bolt 6 12mm', '2', '1', '0', '0'),
('193', 'I-179', 'I-179', 'PVC Bend 2', '2', '1', '0', '0'),
('194', 'I-180', 'I-180', 'Xpert Polythene Sheet 500g (1.3KG Green)', '2', '1', '0', '0'),
('195', 'I-181', 'I-181', 'AP Berger Tile Glue General Purpose White 20 Kg', '2', '1', '0', '0'),
('196', 'I-182', 'I-182', 'Berger Tuff Exterior Matt - White (27Kg)', '2', '1', '0', '0'),
('197', 'I-183', 'I-183', 'Berger Royale Matt Emulsion White (Gal)', '2', '1', '0', '0'),
('198', 'I-184', 'I-184', 'hook bolt M10X70MM', '2', '1', '0', '0'),
('199', 'I-185', 'I-185', 'hook bolt M12X90MM', '2', '1', '0', '0'),
('200', 'I-186', 'I-186', 'Paint Roller Cristin Mini Complete 4&quot;', '2', '1', '0', '0'),
('201', 'I-187', 'I-187', 'Terminator LED Bulb 5W E27 Day Light #TLEDB-5W', '2', '1', '0', '0'),
('202', 'I-188', 'I-188', 'Berger Royale Smart clean WO Base 1 LTR', '2', '1', '0', '0'),
('203', 'I-189', 'I-189', 'LED Spot Light Fitting 7W-D/L MR 16', '2', '1', '0', '0'),
('204', 'I-190', 'I-190', 'MTX Tile Drill Bit #728139 Size 3MM', '2', '1', '0', '0'),
('205', 'I-191', 'I-191', 'Cabinet Hydraulic Hinges A Type', '2', '1', '0', '0'),
('206', 'I-192', 'I-192', 'SS hose 60cm red and blue line', '2', '1', '0', '0'),
('207', 'I-193', 'I-193', 'Berger Royale Matt Emulsion Base N 3.6 (Gal)', '2', '1', '0', '0'),
('209', 'I-195', 'I-195', 'PVC Bucket (Nos)', '2', '1', '0', '0'),
('210', 'I-196', 'I-196', 'Terminator Top Plug with Fited TTP -13AB', '2', '1', '0', '0'),
('211', 'I-197', 'I-197', 'Gypsum Powder(Pkt)', '2', '1', '0', '0'),
('212', 'I-198', 'I-198', 'Uken Tighter Bit U1575 PH2x 50mm', '2', '1', '0', '0'),
('213', 'I-199', 'I-199', 'Water Proof Paper Captain Grit-220', '2', '1', '0', '0'),
('214', 'I-200', 'I-200', 'Nut+ Bolt', '2', '1', '0', '0'),
('215', 'I-201', 'I-201', 'Bison Kit 650ml / Can', '2', '1', '0', '0'),
('216', 'I-202', 'I-202', 'Black Cat Paint Roller Handle 9&quot; BC9H1.75SG', '2', '1', '0', '0'),
('217', 'I-203', 'I-203', 'Ceiling Tile 600x600 APS', '2', '1', '0', '0'),
('218', 'I-204', 'I-204', 'L Bracket 1-1/2', '2', '1', '0', '0'),
('219', 'I-205', 'I-205', 'Sand Paper 120', '2', '1', '0', '0'),
('220', 'I-206', 'I-206', 'Tube Light Starter-S2', '2', '1', '0', '0'),
('221', 'I-207', 'I-207', 'Tube Rod 2', '2', '1', '0', '0'),
('222', 'I-208', 'I-208', 'Water Proof Paper Captain Grit-400', '2', '1', '0', '0'),
('223', 'I-209', 'I-209', 'Xpert Decor Sanding Disc with Holes 7 Grit 120', '2', '1', '0', '0'),
('224', 'I-210', 'I-210', 'Xpert Decor velour paint roller mini sleeves 4', '2', '1', '0', '0'),
('225', 'I-211', 'I-211', 'Yellow Bucket', '2', '1', '0', '0'),
('226', 'I-212', 'I-212', 'Through Bolts (Wedge Achors) 8x60', '2', '1', '0', '0'),
('227', 'I-213', 'I-213', 'Sauleda Acrylic Canvas #2687 ( Colour : Vanilla)', '2', '1', '0', '0'),
('228', 'I-214', 'I-214', 'Width 120 cm.', '2', '1', '0', '0'),
('229', 'I-215', 'I-215', 'Fix Bolt 12mm', '2', '1', '0', '0'),
('230', 'I-216', 'I-216', 'Anchor Bolt (As Per Sample)', '2', '1', '0', '0'),
('231', 'I-217', 'I-217', 'Bosch SS Cutting Disc 1MM X 4.5 Inch2608603169', '2', '1', '0', '0'),
('232', 'I-218', 'I-218', 'CSK self drilling screw 8x1', '2', '1', '0', '0'),
('233', 'I-219', 'I-219', 'Fix Bolt 10mm', '2', '1', '0', '0'),
('234', 'I-220', 'I-220', 'Gazelle 8x11 In. Waterproof Sandpaper Sheets, 120 Grit GWP 120', '2', '1', '0', '0'),
('235', 'I-221', 'I-221', 'Masking tape 2 x 30 yard', '2', '1', '0', '0'),
('236', 'I-222', 'I-222', 'MS Nut M4', '2', '1', '0', '0'),
('237', 'I-223', 'I-223', 'P P Guny Bag 60x100 Cm', '2', '1', '0', '0'),
('238', 'I-224', 'I-224', 'Xpert Decor Acrylic Paint Roller Mini Sleeves 4', '2', '1', '0', '0'),
('239', 'I-225', 'I-225', 'Fevicol HeatX (650ML)', '2', '1', '0', '0'),
('240', 'I-226', 'I-226', 'Xpert Polythene Sheet 200g (0.8KG Yellow)', '2', '1', '0', '0'),
('241', 'I-227', 'I-227', 'hex head self drilling screw 14x2', '2', '1', '0', '0'),
('242', 'I-228', 'I-228', 'gypsum screw 6x1.1/2', '2', '1', '0', '0'),
('243', 'I-229', 'I-229', 'Tuff-fix gypsum screw DSF8x3', '2', '1', '0', '0'),
('244', 'I-230', 'I-230', 'gypsum screw 6x2', '2', '1', '0', '0'),
('245', 'I-231', 'I-231', 'gypsum screw 8x3/4', '2', '1', '0', '0'),
('246', 'I-232', 'I-232', 'gypsum screw 8x2.1/2', '2', '1', '0', '0'),
('247', 'I-233', 'I-233', 'Hex Head Self Drilling Screw 14x1', '2', '1', '0', '0'),
('248', 'I-234', 'I-234', 'CSK self drilling screw 8x.05', '2', '1', '0', '0'),
('249', 'I-235', 'I-235', 'Gypsum Screw 8x1.1/2', '2', '1', '0', '0'),
('251', 'I-237', 'I-237', 'gypsum screw 8x2', '2', '1', '0', '0'),
('252', 'I-238', 'I-238', 'Painting Job', '2', '1', '0', '0'),
('255', 'I-241', 'I-241', 'Etisalat Expense- Taxable', '1', '1', '0', '0'),
('256', 'I-242', 'I-242', 'Repair MaintenanceP-25757 -Vehicle taxable', '1', '1', '0', '0'),
('257', 'I-243', 'I-243', 'Vehicle Insurance Expenses - Taxable', '1', '1', '0', '0'),
('258', 'I-244', 'I-244', 'Marketing Expense-Taxable', '1', '1', '0', '0'),
('259', 'I-245', 'I-245', 'Purchases Cash- Taxable', '2', '1', '0', '0'),
('261', 'I-247', 'I-247', 'Al Baraa Nov2022(2022-16)', '2', '1', '0', '1'),
('263', 'I-249', 'I-249', 'Repair MaintenanceP-56609 -Vehicles Taxable', '1', '1', '0', '0'),
('264', 'I-250', 'I-250', 'Caesars Palace INV 2890 ( JAN ', '2', '1', '0', '1'),
('265', 'I-251', 'I-251', 'Post Office Expense Non Taxable', '1', '1', '0', '0'),
('266', 'I-252', 'I-252', 'Sofitel -Awning Oct 2022 (2022', '2', '1', '0', '1'),
('267', 'I-253', 'I-253', 'Traffic Fines', '1', '1', '0', '0'),
('268', 'I-254', 'I-254', 'Abdul Aziz Jan 23(2023-001)', '2', '1', '0', '1'),
('269', 'I-255', 'I-255', 'Hammer ( Owners Apartment ) De', '2', '1', '0', '1'),
('270', 'I-256', 'I-256', 'Universal Paint Brush Single 3 UP1.75', '2', '1', '0', '0'),
('272', 'I-260', 'I-260', 'Office Supplies &amp; Stationery Taxable', '1', '1', '0', '0'),
('273', 'I-261', 'I-261', 'Africa Online Jan 2023( 2023-0', '2', '1', '0', '1'),
('274', 'I-262', 'I-262', 'Black Cat Sleeve Extra Rough 9&quot; BC9ER1.75', '2', '1', '0', '0'),
('275', 'I-263', 'I-263', 'Dimple variation Oct 2022 (202', '2', '1', '0', '1'),
('276', 'I-264', 'I-264', 'BEREGER ROYAL MATT EMULSION W2 Base 1USG', '2', '1', '0', '0'),
('278', 'I-266', 'I-266', 'Nasab Office Paint Jan 23( 202', '2', '1', '0', '1'),
('279', 'I-267', 'I-267', 'Hammer Jumeirah Bay Nov 22 (20', '2', '1', '0', '1'),
('280', 'I-268', 'I-268', 'Aparna Varma Oct 22', '2', '1', '0', '1'),
('281', 'I-269', 'I-269', 'Air Tickets Expenses', '1', '1', '0', '0'),
('282', 'I-270', 'I-270', 'Al Baraa (Palm Jumeirah) Nov 2', '2', '1', '0', '1'),
('283', 'I-271', 'I-271', 'salik expense -34004496', '1', '1', '0', '0'),
('285', 'I-273', 'I-273', 'Visa Processing Charges - Taxable', '1', '1', '0', '0'),
('286', 'I-274', 'I-274', 'Universal Mini Paint Roller Handle 4 UPHM', '2', '1', '0', '0'),
('287', 'I-275', 'I-275', 'Cafu Expenses Taxable', '2', '1', '0', '1'),
('288', 'I-276', 'I-276', 'Sachan Kumar Feb 23 ( 2023-008', '2', '1', '0', '1'),
('293', 'I-281', 'I-281', 'Mrs. Asma Kanchwala nov 22( 20', '2', '1', '0', '1'),
('294', 'I-282', 'I-282', 'Mr Ala Damac Hills 2 ( Dec 22)', '2', '1', '0', '1'),
('295', 'I-284', 'I-284', 'Hammer  Ignite School Classpai', '2', '1', '0', '1'),
('296', 'I-285', 'I-285', 'Abdul Aziz Nov22 ( 2022-25)', '2', '1', '0', '1'),
('297', 'I-286', 'I-286', 'Villa Nova March 23 (2023-017)', '2', '1', '0', '1'),
('298', 'I-287', 'I-287', 'Dubai Coast (Awning Damac 2) D', '2', '1', '0', '1'),
('299', 'I-288', 'I-288', 'Pavan Soni March 23 (2023-22)', '2', '1', '0', '1'),
('301', 'I-290', 'I-290', 'Mr Khan (Hanguly) April 23 (20', '2', '1', '0', '1'),
('302', 'I-283', 'I-283', 'Kamran Home Dec22 (2022-39)', '2', '1', '0', '1'),
('303', 'I-291', 'I-291', '111 Immigration April-21', '2', '1', '0', '1'),
('304', 'I-292', 'I-292', 'Tahir March 23 (2023-23)', '2', '1', '0', '1'),
('305', 'I-293', 'I-293', 'Clear Channel March 23 ( 2023-', '2', '1', '0', '1'),
('306', 'I-294', 'I-294', 'Office Maintenance Expense-Taxable', '1', '1', '0', '0'),
('307', 'I-295', 'I-295', 'Subsription Fees - Taxable', '1', '1', '0', '0'),
('308', 'I-296', 'I-296', 'Ms. Nagalakshmi Arabian Ranhes', '2', '1', '0', '1'),
('309', 'I-297', 'I-297', 'Xpert Decor Swirl Tool SW', '2', '1', '0', '0'),
('310', 'I-298', 'I-298', 'Riva Furniture March 23( 2023-', '2', '1', '0', '1'),
('311', 'I-299', 'I-299', 'Gypsum Powder (Bag)', '2', '1', '0', '0'),
('312', 'I-300', 'I-300', 'Al Baraa Car Parking March 23 ', '2', '1', '0', '1'),
('313', 'I-301', 'I-301', 'Berger Value Dry Stucco 20 Kgs', '2', '1', '0', '0'),
('314', 'I-302', 'I-302', 'Berger Acrylic AR Primer (5 USG)', '2', '1', '0', '0'),
('315', 'I-303', 'I-303', 'Aseem Doshi Feb 23 ( 2023-011)', '2', '1', '0', '1'),
('316', 'I-305', 'I-305', 'Dr.Fixit Silicone Sealant 501 S.S GPS-Clear (280GM)', '2', '1', '0', '0'),
('317', 'I-306', 'I-306', 'Xpert Decor Sponge for Canvas Effect # SCE', '2', '1', '0', '0'),
('318', 'I-308', 'I-308', 'Cotton Rags Colour Unstitched', '2', '1', '0', '0'),
('319', 'I-309', 'I-309', 'Dx Garage Mosque on Wheels(Mar', '2', '1', '0', '1'),
('320', 'I-310', 'I-310', 'ADSS- Urbana 2 (Feb 23 ) 2023-', '2', '1', '0', '1'),
('321', 'I-311', 'I-311', 'Berger Royale Play Bariq Silver 14Kg', '2', '1', '0', '0'),
('322', 'I-312', 'I-312', 'BDT Awning March 23 (2023-025)', '2', '1', '0', '1'),
('323', 'I-313', 'I-313', 'Berger Royale Play Bariq Silver 4 Kg', '2', '1', '0', '0'),
('324', 'I-314', 'I-314', 'Repair Maintenance R-45327 -Vehicles Taxable', '1', '1', '0', '0'),
('325', 'I-315', 'I-315', 'Repair Maintenance(P-26138) Vehicles Taxable', '1', '1', '0', '0'),
('326', 'I-3016', 'I-3016', 'Wood Stick', '2', '1', '0', '0'),
('327', 'I-317', 'I-317', 'KOA  NASAB (AL Barari 101 &amp;102', '2', '1', '0', '1'),
('328', 'I-3018', 'I-3018', 'Al Baraa Additional Canopy(Mar', '2', '1', '0', '1'),
('329', 'I-316', 'I-316', 'Visa &amp; Renewables - Shakeel Ahmed ', '1', '1', '0', '0'),
('330', 'I-318', 'I-318', 'Visa &amp; Renewables Exp-Bir Sing', '1', '1', '0', '0'),
('331', 'I-319', 'I-319', 'Milano Flat Chisal 12 with guard', '2', '1', '0', '0'),
('332', 'I-320', 'I-320', 'Discount Allowed non taxable', '1', '1', '0', '0'),
('333', 'I-0049', 'I-0049', 'TOA Sand paper Grit 220', '2', '1', '0', '0'),
('334', 'I-0050', 'I-0050', 'Mal Mal', '2', '1', '0', '0'),
('335', 'I-0051', 'I-0051', 'Berger royal atmos health shield  WO Base 3.6 Ltr', '2', '1', '0', '0'),
('336', 'I-0052', 'I-0052', 'BERGER ROYALE ATMOS WO BASE 17.5LTR', '2', '1', '0', '0'),
('337', 'I-0054', 'I-0054', 'Berger Royale Matt Emulsion White (Drm)', '2', '1', '0', '0'),
('338', 'I-0053', 'I-0053', 'Berger Allinone Hi-Gloss 555N Nobel Green 0.9L', '2', '1', '0', '0'),
('339', 'I-0055', 'I-0055', 'DUNET Shade Net Green 73% China 3 x 50 Mtr', '2', '1', '0', '0'),
('340', 'I-0056', 'I-0056', 'Gypsum screw 6x1', '2', '1', '0', '0'),
('341', 'I-0057', 'I-0057', 'Gypsum Screw 6x1.1/4', '2', '1', '0', '0'),
('342', 'I-0058', 'I-0058', 'Gypsum screw 8x1', '2', '1', '0', '0'),
('343', 'I-0059', 'I-0059', 'Gypsum Sheet (4x8 ft)', '2', '1', '0', '0'),
('344', 'I-0060', 'I-0060', 'Jotun Enamel Matt Ral 9016 (Ltr)', '2', '1', '0', '0'),
('345', 'I-0061', 'I-0061', 'PVA Primer White Bergercoat (5 USG)', '2', '1', '0', '0'),
('346', 'I-0062', 'I-0062', 'Safety Shoes Executive M003 # 40', '2', '1', '0', '0'),
('347', 'I-0063', 'I-0063', 'XPERT MASKING TAPE 2 &quot; 30YRD', '2', '1', '0', '0'),
('348', 'I-0064', 'I-0064', 'Xpert Paint Brush Reg. Blue Handle 3&quot; (1070)', '2', '1', '0', '0'),
('349', 'I-0065', 'I-0065', 'Berger Royale smart clean W0 Base 18 ltr', '2', '1', '0', '0'),
('350', 'I-0066', 'I-0066', 'Milano Tarki Shower Mixer + Shower 140100100231', '2', '1', '0', '0'),
('352', 'I-0067', 'I-0067', 'Expansion Plug Green  1.5&quot; x 7mm  25pcs/set', '2', '1', '0', '0'),
('353', 'I-0068', 'I-0068', 'Repair Maintenance R-45327 -Vehicles Non Taxable', '1', '1', '0', '0'),
('354', 'I-0069', 'I-0069', 'Repair MaintenanceP-56609 -Vehicles Non Taxable', '1', '1', '0', '0'),
('355', 'I-0070', 'I-0070', 'Painting  Work (SQM)', '2', '1', '0', '0'),
('356', 'I-0071', 'I-0071', 'Joint Tape', '2', '1', '0', '0'),
('357', 'I-0072', 'I-0072', 'Boral Joint Compound', '2', '1', '0', '0'),
('358', 'I-0073', 'I-0073', 'Berger Special Value Red Oxide Primer(1ltr)', '2', '1', '0', '0'),
('359', 'I-0074', 'I-0074', 'METAL CUTTING WHEEL 100X3X16 T27 DWA4520IA-AE', '2', '1', '0', '0'),
('360', 'I-0075', 'I-0075', 'Miscellaneous  Cash purchase item Taxable', '2', '1', '0', '0'),
('361', 'I-0076', 'I-0076', 'Caparol Capa Ultra Matt  (Gal)', '2', '1', '0', '0'),
('362', 'I-0077', 'I-0077', 'Scrapper 4&quot;', '2', '1', '0', '0'),
('363', 'I-0078', 'I-0078', 'Touchwood Wood Stain Mahogany (1 Ltr)', '2', '1', '0', '0'),
('364', 'I-0079', 'I-0079', 'Deer Paint Remover 400ml', '2', '1', '0', '0'),
('365', 'I-0080', 'I-0080', 'TOA Sand Paper Grit # 120', '2', '1', '0', '0'),
('366', 'I-0081', 'I-0081', 'Xpert Paint Brush Reg. Blue Handle 2&quot; (1050)', '2', '1', '0', '0'),
('367', 'I-0082', 'I-0082', 'Masking Tape 2&quot;', '2', '1', '0', '0'),
('370', 'I-0085', 'I-0085', 'A P  Berger Royale Marmorino Fine R4074A (CW 9455) Cement Finish) 20 kg', '2', '1', '0', '0'),
('371', 'I-0086', 'I-0086', 'Berger Royale Matt Emulsion Base W0 18Ltr (Drm)', '2', '1', '0', '0'),
('372', 'I-0087', 'I-0087', 'Xpert SS Decor Trowel 240 x 90mm # SB405-B', '2', '1', '0', '0'),
('373', 'I-0088', 'I-0088', 'Water Proof Paper Captain Grit-220 ', '2', '1', '0', '0'),
('374', 'I-0089', 'I-0089', 'Water Proof Paper Captain Grit-120', '2', '1', '0', '0'),
('375', 'I-0090', 'I-0090', 'A P Berger Royale play Rust Protective Clear Coat ( Ltr)', '2', '1', '0', '0'),
('376', 'I-0091', 'I-0091', 'A P Berger  Royale play Artistica Clay White  20kg', '2', '1', '0', '0'),
('377', 'I-0092', 'I-0092', 'LLAZA Awning Complete Pro 350', '2', '1', '0', '0'),
('378', 'I-0093', 'I-0093', 'Berger Royale play najam silver 1 kg', '2', '1', '0', '0'),
('379', 'I-0094', 'I-0094', 'Vaultex  Safety vest fabric ORB Yellow  L', '2', '1', '0', '0'),
('380', 'I-0095', 'I-0095', 'Berger Royale Matt Emulsion Base W1 (Ltr)', '2', '1', '0', '0'),
('381', 'I-0096', 'I-0096', 'PVA Primer White Bergercoat (1 USG)', '2', '1', '0', '0'),
('383', 'I-0098', 'I-0098', 'Select Medium Texture White 5 Usg', '2', '1', '0', '0'),
('384', 'I-0099', 'I-0099', 'Dr. Fixit  Sausage silicon 600 gm White', '2', '1', '0', '0'),
('385', 'I-0100', 'I-0100', 'Terminator Terminal Connector Block 20A #TTB20A  ', '2', '1', '0', '1'),
('386', 'I-0101', 'I-0101', 'Teflon Tape White 1&quot; ', '2', '1', '0', '0'),
('387', 'I-0102', 'I-0102', 'Expansion Plug Green  1.5&quot; x 7mm  25pcs/set', '2', '1', '0', '0'),
('388', 'I-0103', 'I-0103', 'Gypsum Screw 8x1.1/2 (pkt)', '2', '1', '0', '0'),
('389', 'I-0104', 'I-0104', 'Gazelle 4.5 In. Metal Cutting Disc (115mm), Ultra Thin GTD115-HD', '2', '1', '0', '0'),
('390', 'I-0105', 'I-0105', 'Safety Shoes Vaultex M003 43&quot;', '2', '1', '0', '0'),
('391', 'I-0106', 'I-0106', 'SS Drill Bit 12mm', '2', '1', '0', '0'),
('392', 'I-0107', 'I-0107', 'GIFFEX JUNCTION BOX 100X100X50 IP65', '2', '1', '0', '0'),
('393', 'I-0108', 'I-0108', 'SDS Drill Bit 12mm', '2', '1', '0', '0'),
('394', 'I-0109', 'I-0109', 'Safety Specticles SP1401 Tinted', '2', '1', '0', '0'),
('395', 'I-0110', 'I-0110', 'Berger Royale Silk Emulsion White (Drm) ', '2', '1', '0', '0'),
('396', 'I-0111', 'I-0111', 'Sauleda Acrylic Canvas 2038 Beige 120CM', '2', '1', '0', '0'),
('397', 'I-0112', 'I-0112', 'Florence Panle Light  White  595 x 595', '2', '1', '0', '0'),
('398', 'I-0113', 'I-0113', 'Stanley Screw Driver 3X50 (Tester) 66119  ', '2', '1', '0', '0'),
('399', 'I-0114', 'I-0114', 'SS Flex Hose 60cm', '2', '1', '0', '0'),
('400', 'I-0115', 'I-0115', 'Sponsorship fee  Non Taxable', '1', '1', '0', '0'),
('401', 'I-0116', 'I-0116', 'Webber Premix SP 33 50kg', '2', '1', '0', '0'),
('402', 'I-0117', 'I-0117', 'Vehicle Renewal Expense Non Taxable', '1', '1', '0', '0'),
('403', 'I-0118', 'I-0118', 'Network Charges Expense', '1', '1', '0', '0'),
('404', 'I-0119', 'I-0119', 'Pe Tarpaulin 280 Gsm  MTR', '2', '1', '0', '0'),
('405', 'T-001', 'T-001', 'Cafu Expenses Taxable', '1', '1', '0', '0'),
('406', 'T-002', 'T-002', 'Fuel Expense - G-56609 (Imran) Taxable', '1', '1', '0', '0'),
('407', 'T-003', 'T-003', 'Fuel Expense - P-25757 (Arslan) Taxable', '1', '1', '0', '0'),
('408', 'T-004', 'T-004', 'Fuel Expense P-26138 (Van) Taxable', '1', '1', '0', '0'),
('409', 'T-005', 'T-005', 'Fuel Expense R-45327 Taxable', '1', '1', '0', '0'),
('410', 'I-0120', 'I-0120', 'Aluminum Extension Rod 3mtr', '2', '1', '0', '0'),
('412', 'I-0121', 'I-0121', 'A P Berger Robbiathane Matt  RAL 4005 Blaulila 20 Ltr', '2', '1', '0', '0'),
('413', 'I-0122', 'I-0122', 'Terminator Terminal Connector Block 20A #TTB20A ', '2', '1', '0', '1'),
('414', 'I-0123', 'I-0123', 'Insulation Tape White', '2', '1', '0', '0'),
('415', 'I-0124', 'I-0124', 'Round Light APS', '2', '1', '0', '0'),
('416', 'I-0125', 'I-0125', 'Battery 9V', '2', '1', '0', '0'),
('417', 'I-0126', 'I-0126', 'Door Lock APS', '2', '1', '0', '0'),
('418', 'I-248', 'I-248', 'Vehicle Insurance Expense Non Taxable', '1', '1', '0', '0'),
('419', 'I-0127', 'I-0127', 'Thinner Berger Solvalux 7-45 (5 USG) ', '2', '1', '0', '0'),
('420', 'I-0128', 'I-0128', 'Jubliee Hose Clip # 00', '2', '1', '0', '0'),
('421', 'I-0129', 'I-0129', 'MAPEI MAPESET WHITE TILE GLUE 20KG ', '2', '1', '0', '0'),
('422', 'I-0130', 'I-0130', 'A P Berger Road Marking Paint White  18 LTR', '2', '1', '0', '0'),
('423', 'I-0131', 'I-0131', 'Yato Spray Gun with Metal Cup 1 Ltr (YT-2346)', '2', '1', '0', '0'),
('424', 'D-001', 'D-001', 'Delivery Charges Non Taxable', '1', '1', '0', '0'),
('425', 'I-0132', 'I-0132', 'Fuerza pad lock crome plated PC PGL 75', '2', '1', '0', '0'),
('426', 'I-0133', 'I-0133', 'Berger Epoxy Putty with Hardner (5L) ', '2', '1', '0', '0'),
('427', 'I-0134', 'I-0134', 'Paint Roller Refil &#039;Cristin&#039; Velour 9&quot;', '2', '1', '0', '0'),
('428', 'T-006', 'T-006', 'Fuel Expense JAC S -77609  Taxable', '1', '1', '0', '0'),
('429', 'E-0100', 'E-0100', 'Etisalat Expense Non taxable', '1', '1', '0', '0'),
('430', 'I-0135', 'I-0135', 'Milano W/C with tank  trap white ( code 1058)', '2', '1', '0', '0'),
('431', 'I-0136', 'I-0136', 'Brass Reducer Bush 1/2&quot; x 3/8&quot;', '2', '1', '0', '0'),
('432', 'I-0137', 'I-0137', 'Berger Value Stucco Extra Mix (18 Ltr)', '2', '1', '0', '0'),
('433', 'I-0138', 'I-0138', 'Relite Flexible cable Turkey  1.5mm x 3 Core  Mtr', '2', '1', '0', '0'),
('434', 'I-0139', 'I-0139', 'National S/C Wire Red 2.5MM', '2', '1', '0', '0'),
('435', 'I-0140', 'I-0140', 'National S/C Wire Black 2.5MM ', '2', '1', '0', '0'),
('436', 'I-0141', 'I-0141', 'National S/C Wire Y/G 2.5MM 95mtr ', '2', '1', '0', '0'),
('439', 'I-0144', 'I-0144', 'National S/C Wire Y/G 4MM ', '2', '1', '0', '0'),
('440', 'I-0145', 'I-0145', 'National S/C Wire BLACK 4MM  ', '2', '1', '0', '0'),
('441', 'I-0146', 'I-0146', 'National S/C Wire RED 4MM', '2', '1', '0', '0'),
('442', 'I-0147', 'I-0147', 'Bandex Cable Ties White 300 x 3.6', '2', '1', '0', '0'),
('443', 'I-0142', 'I-0142', '3X6 GI BOX INDIA H/D', '2', '1', '0', '0'),
('444', 'I-0143', 'I-0143', '3X3 GI BOX INDIA', '2', '1', '0', '0'),
('445', 'I-0148', 'I-0148', 'Wire Puller ', '2', '1', '0', '0'),
('446', 'I-0149', 'I-0149', 'DD Female Adaptor 20mm Black #DFA2', '2', '1', '0', '0'),
('447', 'I-0150', 'I-0150', '20MM PVC SLIP TYPE BEND DD DLB2 ', '2', '1', '0', '0'),
('448', 'I-0151', 'I-0151', '20MM PVC COUPLER DD DNC2 ', '2', '1', '0', '0'),
('449', 'I-0152', 'I-0152', 'DD Spacer Saddle 20mm #DSB2', '2', '1', '0', '0'),
('450', 'I-0153', 'I-0153', 'Spring Bender', '2', '1', '0', '0'),
('451', 'I-0154', 'I-0154', '20MM PVC COMDUIT PIPE DD 1.6 DCH2   ', '2', '1', '0', '0'),
('452', 'I-0155', 'I-0155', 'A P  Berger  Value Super emulsion  off white   20 kg', '2', '1', '0', '0'),
('453', 'I-0156', 'I-0156', 'National S/C Wire Blue 2.5MM ', '2', '1', '0', '0'),
('454', 'I-0157', 'I-0157', 'A P Berger W/Coat Stone Shield  White 23 kg', '2', '1', '0', '0'),
('460', 'I-0158', 'I-0158', '25MM PVC CONDUITE DD 1.8 DCH3 ', '2', '1', '0', '0'),
('461', 'I-0159', 'I-0159', 'DD Spacer Saddle 25mm #DSB3 ', '2', '1', '0', '0'),
('462', 'I-0160', 'I-0160', 'DD Female Adaptor 25mm Black #DFA3', '2', '1', '0', '0'),
('463', 'I-0161', 'I-0161', '25MM PVC COUPLER DD DNC3 ', '2', '1', '0', '0'),
('464', 'I-0162', 'I-0162', '25MM 4 WAY PVC J/BOX DD DJF3', '2', '1', '0', '0'),
('465', 'I-0163', 'I-0163', 'Pvc Junction box 25mm   3 Way', '2', '1', '0', '0'),
('466', 'I-0164', 'I-0164', 'Ap Berger Royale Play Artistica Concrete 20kg', '2', '1', '0', '0'),
('467', 'I-0165', 'I-0165', ' Ap Berger Royale Play Artistica  Clay  20kg', '2', '1', '0', '0'),
('468', 'I-0166', 'I-0166', ' Ap Berger Royale Play Artistica Rust - Base Coat 1 LTR', '2', '1', '0', '0'),
('469', 'I-0167', 'I-0167', 'Ap Berger Royale Play Artistica Copper Breeze - Base coat 1 LTR', '2', '1', '0', '0'),
('470', 'I-0168', 'I-0168', 'Ap Berger Royale Play Artistica Rust Topcoat 1 LTR', '2', '1', '0', '0'),
('471', 'I-0169', 'I-0169', 'Ap Berger Royale Play Artistica Copper Breeze - Topcoat  0.5 LTR', '2', '1', '0', '0'),
('472', 'I-0170', 'I-0170', 'AP Berger Royale Play Artistica Rust Protective Coat 1 LTR', '2', '1', '0', '0'),
('473', 'I-0171', 'I-0171', 'AP Berger Royale Play Artistica Protective Coat / Colour Wash 1 LTR', '2', '1', '0', '0'),
('474', 'I-0172', 'I-0172', 'Ap Berger Royale Play Artistica Metallica 0.5kg ', '2', '1', '0', '0'),
('475', 'I-0173', 'I-0173', 'Xpert Decor File Scrapper FS10 10&quot;', '2', '1', '0', '0'),
('476', 'I-0174', 'I-0174', 'A P Berger Tuff AR Primer Clear  23kg', '2', '1', '0', '0'),
('477', 'I-0175', 'I-0175', 'A P Berger Marmorino Fine White 20 Kg', '2', '1', '0', '0'),
('478', 'I-0176', 'I-0176', 'Industrial  Welding Goggle B/G ', '2', '1', '0', '0'),
('479', 'I-0177', 'I-0177', 'VERMONT GRIT 120', '2', '1', '0', '0'),
('480', 'I-0178', 'I-0178', 'Berger Royale Matt Emulsion Base W1 (GAL)', '2', '1', '0', '0'),
('481', 'I-0179', 'I-0179', 'Xpert Decor blue foam paint roller mini sleeves 4&quot;', '2', '1', '0', '0'),
('482', 'I-0180', 'I-0180', 'Paint Roller Refil &#039;Cristin&#039; Toptex 9&quot;', '2', '1', '0', '0'),
('483', 'I-0181', 'I-0181', 'A P Berger Royal Matt Emulsion W2 Base 18 Ltr', '2', '1', '0', '0'),
('484', 'I-0182', 'I-0182', 'Terraco Gypsum Joint Compound (28KG)', '2', '1', '0', '0'),
('485', 'I-0183', 'I-0183', 'LLAZA AWNING REPAIR', '2', '1', '0', '0'),
('486', 'I-0184', 'I-0184', 'Switch Two Way  gang', '2', '1', '0', '0'),
('488', 'I-0186', 'I-0186', 'Switch 4  gang', '2', '1', '0', '0'),
('489', 'I-0187', 'I-0187', 'Relite LED Ceiling light white  60x60', '2', '1', '0', '0'),
('490', 'I-0188', 'I-0188', 'CSK self drilling screw 6x1.25', '2', '1', '0', '0'),
('491', 'I-0189', 'I-0189', 'CSK self drilling screw 6x1   1000 pkt', '2', '1', '0', '0'),
('492', 'I-0190', 'I-0190', '100 x  100 x 50 mm Waterproof Box ', '2', '1', '0', '0'),
('493', 'I-0191', 'I-0191', 'Connector stop 10mm', '2', '1', '0', '0'),
('494', 'I-0192', 'I-0192', 'Connector stop 16mm ', '2', '1', '0', '0'),
('495', 'I-0193', 'I-0193', 'Italian Stucco Xpressions W1 Base (1.4 Kgs) ', '2', '1', '0', '0'),
('496', 'I-0194', 'I-0194', 'Italian Stucco Xpressions W1 Base (14 Kg)', '2', '1', '0', '0'),
('497', 'I-0195', 'I-0195', 'Robustline Lever Handle  Narrow White LW-246 ', '2', '1', '0', '0'),
('498', 'I-0196', 'I-0196', 'Berger Tuff Exterior - White (5 Kgs)', '2', '1', '0', '0'),
('499', 'I-0197', 'I-0197', 'JOTUN JOTASHIELD COLORLAST MATT 10394 16.20 LTR', '2', '1', '0', '0'),
('500', 'I-0198', 'I-0198', 'Dunet Commercial 95 Desert Sand Roll 3 x 50 meter', '2', '1', '0', '0'),
('501', 'I-0199', 'I-0199', 'PVC Curtain Strip 200 x 2 mm (50 Mtr / Roll)', '2', '1', '0', '0'),
('502', 'I-0200', 'I-0200', 'A Stainless Steel Hanger 1020mm (Pcs)', '2', '1', '0', '0'),
('503', 'I-0201', 'I-0201', 'B Stainless Steel Plate 200mm', '2', '1', '0', '0'),
('504', 'I-0202', 'I-0202', 'Jotun Fenomastic Matt 18LTR', '2', '1', '0', '0'),
('505', 'I-0203', 'I-0203', 'Universal Sleeve Semi Smooth 9&quot; # UP9SS1.75', '2', '1', '0', '0'),
('506', 'I-0204', 'I-0204', 'Ap Berger Wood Primer  Gln', '2', '1', '0', '0'),
('507', 'I-0205', 'I-0205', 'Weathercoat stone sheild  primer 18LTR', '2', '1', '0', '0'),
('508', 'I-0206', 'I-0206', 'Berger Royale Matt Emulsion WO Base. Gal', '2', '1', '0', '0'),
('509', 'I-0207', 'I-0207', 'Steel Eyelet #3 (12mm) Turkey 500 Pcs/Pkt', '2', '1', '0', '0'),
('510', 'I-0208', 'I-0208', 'PP Webbing 2&quot; x 50m Pakistan', '2', '1', '0', '0'),
('511', 'I-0209', 'I-0209', 'Hole Punch 13mm', '2', '1', '0', '0'),
('512', 'I-0210', 'I-0210', 'Eyelet Die #3 (12mm) Turkey', '2', '1', '0', '0'),
('513', 'I-0211', 'I-0211', 'AP Berger Apcolite Advanced DRUM', '2', '1', '0', '0'),
('514', 'I-0212', 'I-0212', 'Cusbor Polyester HT T20 250 Gr', '2', '1', '0', '0'),
('515', 'I-0213', 'I-0213', 'Fix Bolt 6mm Box', '2', '1', '0', '0'),
('516', 'I-0214', 'I-0214', 'A P Royale Luxury Matt RED GAL', '2', '1', '0', '0'),
('517', 'I-0215', 'I-0215', 'LLAZA Awning Monobloc 350 ', '2', '1', '0', '0'),
('518', 'I-0216', 'I-0216', 'LLAZA Awning Storbox 300 Grey', '2', '1', '0', '0'),
('519', 'I-0217', 'I-0217', 'Ispat Leather Safety Shoes Executive ASG1 #42', '2', '1', '0', '0'),
('520', 'I-0218', 'I-0218', 'Ispat Leather Safety Shoes Executive ASG1 #43', '2', '1', '0', '0'),
('521', 'I-0219', 'I-0219', 'Safety Vest Fabric Type Yellow/green Per4mer L', '2', '1', '0', '0'),
('522', 'I-0220', 'I-0220', '56089090 Dunet Bird Net Black 5 x 100 meters Roll', '2', '1', '0', '0'),
('523', 'I-0221', 'I-0221', 'Dunet Bird Net White 5 x 100 meters Roll', '2', '1', '0', '0'),
('524', 'I-0222', 'I-0222', 'DUNET Shade Netting 90% Monofilament Green Vietnam 3 x 50 Mtr', '2', '1', '0', '0'),
('525', 'I-0223', 'I-0223', 'Stitching Job', '2', '1', '0', '0'),
('526', 'I-0224', 'I-0224', 'BERGER ROYALE MATT EMULSION BASE N(LTR)', '2', '1', '0', '0'),
('527', 'I-0225', 'I-0225', 'Berger Tuff Exterior W1 Base Ltr', '2', '1', '0', '0'),
('528', 'I-0226', 'I-0226', 'AP Berger Smart Care Waterproofing Damp block 2K 15kg', '2', '1', '0', '0'),
('529', 'I-0227', 'I-0227', 'Llaza Arond-350 Support Set #20110000001', '2', '1', '0', '0'),
('530', 'i-0228', 'i-0228', 'Select Fine Texture White (18 Ltr)', '2', '1', '0', '0'),
('531', 'I-0229', 'I-0229', 'LLAZA A/S Onyx-400 2.5M #10002250001', '2', '1', '0', '0'),
('532', 'I-0230', 'I-0230', 'LLAZA A/S Onyx-400 1.5M #10002150001', '2', '1', '0', '0'),
('533', 'I-0231', 'I-0231', 'LLAZA A/S Onyx-400 3.0M #1000230001', '2', '1', '0', '0'),
('534', 'I-0232', 'I-0232', 'LLAZA A/S Onyx-400 3.0 #1000230001', '2', '1', '0', '0'),
('535', 'I-0233', 'I-0233', 'LLAZA Universe 280 front profile 6 Mtrs', '2', '1', '0', '0'),
('536', 'I-0234', 'I-0234', 'LLAZA U280 Plastic Caps Kit #14003010001', '2', '1', '0', '0'),
('537', 'I-0235', 'I-0235', 'LLAZA Front Profile Connectors #19002021001', '2', '1', '0', '0'),
('538', 'I-0236', 'I-0236', 'LLAZA MB-9 Gearbox L-130 #21008016001', '2', '1', '0', '0'),
('539', 'I-0237', 'I-0237', 'LLAZA Crank ST 1.70m #13006170001', '2', '1', '0', '0'),
('540', 'I-0238', 'I-0238', 'LLAZA P-801 Rolling Tube 80x1.2 7.00 GV #31080700044', '2', '1', '0', '0'),
('541', 'I-0239', 'I-0239', 'LLAZA Gear End Bearing Axis 35MM/80 #12080009000', '2', '1', '0', '0'),
('542', 'I-0240', 'I-0240', 'LLAZA Idle Side Bearing 80mm #12080003000', '2', '1', '0', '0'),
('543', 'I-0241', 'I-0241', 'LLAZA Storbox 300 Support Set Grey #20001001909', '2', '1', '0', '0'),
('544', 'I-0242', 'I-0242', 'LLAZA Storbox 300 3 Profiles 6M Grey #39086600909', '2', '1', '0', '0'),
('545', 'I-0243', 'I-0243', 'LLAZA Art350 Arms 2.5M Grey #10045250909', '2', '1', '0', '0'),
('546', 'I-0244', 'I-0244', 'LLAZA Art 350 Arms 3.00M Grey #10045300909', '2', '1', '0', '0'),
('547', 'I-0245', 'I-0245', 'LLAZA Onyx-400 Arms Grey #1000240090', '2', '1', '0', '0'),
('548', 'I-0246', 'I-0246', 'LLAZA Storbox 3000 Gearbox grey #20051033909', '2', '1', '0', '0'),
('549', 'I-0247', 'I-0247', 'Dooya Tubular Motor DM45R/SF 50NM + DD2700H Remote', '2', '1', '0', '0'),
('550', 'I-0248', 'I-0248', 'Berger Royale Smart clean WO Base 3.6LTR', '2', '1', '0', '0'),
('551', 'i-0249', 'i-0249', 'DUTARP PVC Coated Tarpaulin #FR2219 (72&quot; x 50Y)', '2', '1', '0', '0'),
('552', 'I-0250', 'I-0250', 'Berger Tuff Exterior WO base Drum', '2', '1', '0', '0'),
('553', 'I-0251', 'I-0251', 'PVC Pipe 2&quot;', '2', '1', '0', '0'),
('554', 'I-0252', 'I-0252', 'PVC Adaptor 50mm', '2', '1', '0', '0'),
('555', 'I-0253', 'I-0253', 'Multi Meter', '2', '1', '0', '0'),
('556', 'I-0254', 'I-0254', 'Promax W/P Fiber Mesh 1 x 25 Meters White', '2', '1', '0', '0'),
('557', 'I-0255', 'I-0255', 'Blades LB 10', '2', '1', '0', '0'),
('558', 'I-0256', 'I-0256', 'PVC Made Adaptor 1/2&quot; PPR Male Plug', '2', '1', '0', '0'),
('559', 'I-0257', 'I-0257', 'PVC Pipe 1&quot; PPR pipe 20mm x 4 Meter', '2', '1', '0', '0'),
('560', 'I-0258', 'I-0258', 'PVC Female socket 1&quot; PPR Socket 20 x 1/2&quot;', '2', '1', '0', '0'),
('561', 'I-0259', 'I-0259', 'PPR Elbow 20mm x 90', '2', '1', '0', '0'),
('562', 'I-0260', 'I-0260', 'PPR Socket 20mm', '2', '1', '0', '0'),
('563', 'I-0261', 'I-0261', 'PPR Elbow Female Elbow 20mm x 1/2&quot;', '2', '1', '0', '0'),
('564', 'I-0262', 'I-0262', 'UPVC Tee 1- 1/2&quot;', '2', '1', '0', '0'),
('565', 'I-0263', 'I-0263', 'UPVC Reducer Brush 2&quot; x  1 1/2&quot;', '2', '1', '0', '0'),
('566', 'I-0264', 'I-0264', 'UPVC Bend 1.1/2&quot; (90 Degree)', '2', '1', '0', '0'),
('567', 'I-0265', 'I-0265', 'Ducab Wire 4 mm 100 Yds Roll - Black', '2', '1', '0', '0'),
('568', 'I-0266', 'I-0266', 'Ducab Wire 4 mm 100 Yds Roll- Red', '2', '1', '0', '0'),
('569', 'I-0267', 'I-0267', 'JOTUN FENOMASTIC EML MYHOME RICH MATT BASE A 3.6L 9003', '2', '1', '0', '0'),
('570', 'I-0268', 'I-0268', 'Schneider Flex Outlet SW 13A + Neon +Fuse', '2', '1', '0', '0'),
('571', 'I-0269', 'I-0269', 'Schneider Switch 1G 1 Way Avatar 16A White', '2', '1', '0', '0'),
('572', 'I-0270', 'I-0270', 'CP Extension Nipple 1/2&quot; x 10mm Len  ', '2', '1', '0', '0'),
('573', 'I-0271', 'I-0271', 'Schneider Switch Socket 13A Single Avatar White', '2', '1', '0', '0'),
('574', 'I-0272', 'I-0272', 'Schneider Switch Socket 13A double Avatar White', '2', '1', '0', '0'),
('575', 'I-0273', 'I-0273', 'Asmaco Spray Paint Black Matt 400 ml ', '2', '1', '0', '0'),
('576', 'I-0274', 'I-0274', 'Stanley 9 Pcs Hexkey Set 92619-8 ', '2', '1', '0', '0'),
('577', 'I-0275', 'I-0275', 'Cut Resistant Gloves Grey Per4mer N10555', '2', '1', '0', '0'),
('578', 'I-0276', 'I-0276', 'ACCESS PANEL 40x40cm', '2', '1', '0', '0'),
('579', 'I-0277', 'I-0277', 'Duct Tape', '2', '1', '0', '0'),
('580', 'I-0278', 'I-0278', 'Safety Specticles SP5501 Clear', '2', '1', '0', '0'),
('581', 'I-0279', 'I-0279', 'Dunet Comm. 95 Natural 3m x 50m', '2', '1', '0', '0'),
('582', 'i-0280', 'i-0280', 'Berger Floor Guard Epoxy Topcoat Minerva Grey 295N 20L', '2', '1', '0', '0'),
('583', 'I-0281', 'I-0281', 'Thinner Berger Solvalux 7-45 (1 USG)', '2', '1', '0', '0'),
('584', 'I-0282', 'I-0282', 'Caparol Capa Ultra Matt-Tundra 60   (Ltr)', '2', '1', '0', '0'),
('585', 'I-0283', 'I-0283', 'Caparol Capa Ultra Palazzo 145 (Ltr)', '2', '1', '0', '0'),
('586', 'I-0284', 'I-0284', 'Caparol CapaPlus Matt White (5 G)', '2', '1', '0', '0'),
('587', 'I-0285', 'I-0285', 'Machine Screw M4 x 20mm CSK  (Pkt)', '2', '1', '0', '0'),
('588', 'I-0286', 'I-0286', 'LLAZA Arond-350 Support Set #20110000001', '2', '1', '0', '0'),
('589', 'I-0287', 'I-0287', 'LLAZA A/S Onyx - 400 2.50M #10002250001', '2', '1', '0', '0'),
('590', 'I-0288', 'I-0288', 'LLAZA A/S Onyx - 400 1.5M #10002150001', '2', '1', '0', '0'),
('591', 'I-0289', 'I-0289', 'LLAZA A/S Onyx - 400 3.0M #1000230001', '2', '1', '0', '0'),
('592', 'I-0290', 'I-0290', 'LLAZA A/S Onyx - 400 3.5M #10002350001', '2', '1', '0', '0'),
('593', 'I-0291', 'I-0291', 'Sauleda Acrylic Canvas #2235 ( Colour : Azul Real)', '2', '1', '0', '0'),
('594', 'i-0292', 'i-0292', 'Llaza Slender Stick 5.8mm (11005002001)', '2', '1', '0', '0'),
('595', 'I-0293', 'I-0293', 'Brighto Texo Compound 18LTR', '2', '1', '0', '0'),
('596', 'I-0294', 'I-0294', 'Brighto Acrylic Primer DRM 18 Ltr', '2', '1', '0', '0'),
('597', 'I-0295', 'I-0295', 'Brighto Acrylic Rock Top Coat  3.6 Ltr', '2', '1', '0', '0'),
('598', 'I-0296', 'I-0296', 'Stanley Measuring Tape 5Mtr    STHT 36194', '2', '1', '0', '0'),
('599', 'I-0297', 'I-0297', 'Berger Select All in One Enamel (Drum)', '2', '1', '0', '0'),
('600', 'I-0298', 'I-0298', 'Dr.Fixit Raincoat UltraFlex White  18ltr ', '2', '1', '0', '0'),
('601', 'I-0299', 'I-0299', 'DR Fixit Uniproof 4000 Water Proofing White (20KG) ', '2', '1', '0', '0'),
('602', 'i-0300', 'i-0300', 'Gazelle Long Arm Imperial Hex Key Set G80133 ', '2', '1', '0', '0'),
('603', 'I-0301', 'I-0301', 'Texture Gun', '2', '1', '0', '0'),
('604', 'I-0302', 'I-0302', 'Jotun Jotashield eterna 1 Ltr', '2', '1', '0', '0'),
('605', 'I-0303', 'I-0303', 'ROBUSTLINE GALVANISED ANGLE BRKT 40MMX40MMX15MMX1. 5MM', '2', '1', '0', '0'),
('606', 'I-0304', 'I-0304', 'LLAZA ROLLING TUBE 80MM, 7M 31080700044 AWNING PROFILES', '2', '1', '0', '0'),
('607', 'I-0305', 'I-0305', '2 meter threaded rod 10mm', '2', '1', '0', '0'),
('608', 'T-007', 'T-007', 'Fuel Expense - G-56609 (Imran) Non Taxable', '1', '1', '0', '0'),
('609', 'EXP-001', 'D-001', 'Delivery Charges Non Taxable', '1', '1', '1', '0');

### Structure of table `0_item_links` ###

DROP TABLE IF EXISTS `0_item_links`;

CREATE TABLE `0_item_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Item` varchar(30) NOT NULL,
  `link_item` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_item_links` ###

INSERT INTO `0_item_links` VALUES
('3', 'EP001', 'I-0013');

### Structure of table `0_item_specs` ###

DROP TABLE IF EXISTS `0_item_specs`;

CREATE TABLE `0_item_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(100) NOT NULL,
  `spec` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ;

### Data of table `0_item_specs` ###


### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###

INSERT INTO `0_item_tax_type_exemptions` VALUES
('1', '2'),
('1', '3'),
('1', '4'),
('1', '5');

### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `tax_code` varchar(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Taxable', '0', '0', 'ER'),
('2', 'Tax Exempt', '1', '0', 'TB');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('Bag', 'Bag', '1', '0'),
('Bale', 'Bale', '0', '0'),
('Can', 'Can', '0', '0'),
('Drum', 'Drm', '1', '0'),
('GLN', 'Gln', '1', '0'),
('Job', 'Job', '-1', '0'),
('Killogram', 'Kgs', '2', '0'),
('Lgth', 'Lgth', '0', '0'),
('Liter', 'Ltr', '0', '0'),
('Meter', 'Mtr', '0', '0'),
('NOS', 'Nos', '0', '0'),
('Packet', 'Pkt', '0', '0'),
('Pieces', 'Pcs', '0', '0'),
('PRS', 'Prs', '0', '0'),
('QTY', 'Quantity', '-1', '0'),
('Roll', 'Roll', '0', '0'),
('SQM', 'SQM', '-1', '0'),
('ST', 'ST', '0', '0'),
('yards', 'Yds', '-1', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `source_ref` varchar(60) NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###

INSERT INTO `0_journal` VALUES
('0', '1', '2023-12-31', '01', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '2', '2023-12-31', '01', '', '2023-12-31', '2023-12-31', 'AED', '86768.43', '1'),
('0', '3', '2023-12-31', 'JV-02', '', '2023-12-31', '2023-12-31', 'AED', '484531.36', '1'),
('0', '4', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '5', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '6', '2023-12-31', 'JV-04', '', '2023-12-31', '2023-12-31', 'AED', '7500925.35', '1'),
('0', '7', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '8', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '9', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '10', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '11', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '12', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '13', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '14', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '15', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '452601.83', '1');

### Structure of table `0_language` ###

DROP TABLE IF EXISTS `0_language`;

CREATE TABLE `0_language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_eng` text NOT NULL,
  `language_arb` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_language` ###

INSERT INTO `0_language` VALUES
('1', 'Sales', 'مبيعات'),
('2', 'Purchases', 'المشتريات'),
('3', 'Items and Inventory', 'العناصر والمخزون'),
('4', 'Manufacturing', 'تصنيع'),
('5', 'Fixed Assets', 'أصول ثابتة'),
('6', 'Dimensions', 'الأبعاد'),
('7', 'General Ledger', 'دفتر الأستاذ العام'),
('8', 'System Setup', 'إعداد النظام');

### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) NOT NULL DEFAULT '',
  `stock_id` char(20) NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('001', '01', '0'),
('001', 'D-001', '0'),
('001', 'E-0100', '0'),
('001', 'EP001', '0'),
('001', 'EP002', '0'),
('001', 'EW001', '0'),
('001', 'I-001', '0'),
('001', 'I-0013', '0'),
('001', 'I-002', '0'),
('001', 'I-003', '0'),
('001', 'I-004', '0'),
('001', 'I-0049', '0'),
('001', 'I-005', '0'),
('001', 'I-0050', '0'),
('001', 'I-0051', '0'),
('001', 'I-0052', '0'),
('001', 'I-0053', '0'),
('001', 'I-0054', '0'),
('001', 'I-0055', '0'),
('001', 'I-0056', '0'),
('001', 'I-0057', '0'),
('001', 'I-0058', '0'),
('001', 'I-0059', '0'),
('001', 'I-006', '0'),
('001', 'I-0060', '0'),
('001', 'I-0061', '0'),
('001', 'I-0062', '0'),
('001', 'I-0063', '0'),
('001', 'I-0064', '0'),
('001', 'I-0065', '0'),
('001', 'I-0066', '0'),
('001', 'I-0067', '0'),
('001', 'I-0068', '0'),
('001', 'I-0069', '0'),
('001', 'I-007', '0'),
('001', 'I-0070', '0'),
('001', 'I-0071', '0'),
('001', 'I-0072', '0'),
('001', 'I-0073', '0'),
('001', 'I-0074', '0'),
('001', 'I-0075', '0'),
('001', 'I-0076', '0'),
('001', 'I-0077', '0'),
('001', 'I-0078', '0'),
('001', 'I-0079', '0'),
('001', 'I-008', '0'),
('001', 'I-0080', '0'),
('001', 'I-0081', '0'),
('001', 'I-0082', '0'),
('001', 'I-0085', '0'),
('001', 'I-0086', '0'),
('001', 'I-0087', '0'),
('001', 'I-0088', '0'),
('001', 'I-0089', '0'),
('001', 'I-009', '0'),
('001', 'I-0090', '0'),
('001', 'I-0091', '0'),
('001', 'I-0092', '0'),
('001', 'I-0093', '0'),
('001', 'I-0094', '0'),
('001', 'I-0095', '0'),
('001', 'I-0096', '0'),
('001', 'I-0098', '0'),
('001', 'I-0099', '0'),
('001', 'I-010', '0'),
('001', 'I-0100', '0'),
('001', 'I-0101', '0'),
('001', 'I-0102', '0'),
('001', 'I-0103', '0'),
('001', 'I-0104', '0'),
('001', 'I-0105', '0'),
('001', 'I-0106', '0'),
('001', 'I-0107', '0'),
('001', 'I-0108', '0'),
('001', 'I-0109', '0'),
('001', 'I-011', '0'),
('001', 'I-0110', '0'),
('001', 'I-0111', '0'),
('001', 'I-0112', '0'),
('001', 'I-0113', '0'),
('001', 'I-0114', '0'),
('001', 'I-0115', '0'),
('001', 'I-0116', '0'),
('001', 'I-0117', '0'),
('001', 'I-0118', '0'),
('001', 'I-0119', '0'),
('001', 'I-012', '0'),
('001', 'I-0120', '0'),
('001', 'I-0121', '0'),
('001', 'I-0122', '0'),
('001', 'I-0123', '0'),
('001', 'I-0124', '0'),
('001', 'I-0125', '0'),
('001', 'I-0126', '0'),
('001', 'I-0127', '0'),
('001', 'I-0128', '0'),
('001', 'I-0129', '0'),
('001', 'I-0130', '0'),
('001', 'I-0131', '0'),
('001', 'I-0132', '0'),
('001', 'I-0133', '0'),
('001', 'I-0134', '0'),
('001', 'I-0135', '0'),
('001', 'I-0136', '0'),
('001', 'I-0137', '0'),
('001', 'I-0138', '0'),
('001', 'I-0139', '0'),
('001', 'I-014', '0'),
('001', 'I-0140', '0'),
('001', 'I-0141', '0'),
('001', 'I-0142', '0'),
('001', 'I-0143', '0'),
('001', 'I-0144', '0'),
('001', 'I-0145', '0'),
('001', 'I-0146', '0'),
('001', 'I-0147', '0'),
('001', 'I-0148', '0'),
('001', 'I-0149', '0'),
('001', 'I-015', '0'),
('001', 'I-0150', '0'),
('001', 'I-0151', '0'),
('001', 'I-0152', '0'),
('001', 'I-0153', '0'),
('001', 'I-0154', '0'),
('001', 'I-0155', '0'),
('001', 'I-0156', '0'),
('001', 'I-0157', '0'),
('001', 'I-0158', '0'),
('001', 'I-0159', '0'),
('001', 'I-016', '0'),
('001', 'I-0160', '0'),
('001', 'I-0161', '0'),
('001', 'I-0162', '0'),
('001', 'I-0163', '0'),
('001', 'I-0164', '0'),
('001', 'I-0165', '0'),
('001', 'I-0166', '0'),
('001', 'I-0167', '0'),
('001', 'I-0168', '0'),
('001', 'I-0169', '0'),
('001', 'I-017', '0'),
('001', 'I-0170', '0'),
('001', 'I-0171', '0'),
('001', 'I-0172', '0'),
('001', 'I-0173', '0'),
('001', 'I-0174', '0'),
('001', 'I-0175', '0'),
('001', 'I-0176', '0'),
('001', 'I-0177', '0'),
('001', 'I-0178', '0'),
('001', 'I-0179', '0'),
('001', 'I-018', '0'),
('001', 'I-0180', '0'),
('001', 'I-0181', '0'),
('001', 'I-0182', '0'),
('001', 'I-0183', '0'),
('001', 'I-0184', '0'),
('001', 'I-0186', '0'),
('001', 'I-0187', '0'),
('001', 'I-0188', '0'),
('001', 'I-0189', '0'),
('001', 'I-019', '0'),
('001', 'I-0190', '0'),
('001', 'I-0191', '0'),
('001', 'I-0192', '0'),
('001', 'I-0193', '0'),
('001', 'I-0194', '0'),
('001', 'I-0195', '0'),
('001', 'I-0196', '0'),
('001', 'I-0197', '0'),
('001', 'I-0198', '0'),
('001', 'I-0199', '0'),
('001', 'I-020', '0'),
('001', 'I-0200', '0'),
('001', 'I-0201', '0'),
('001', 'I-0202', '0'),
('001', 'I-0203', '0'),
('001', 'I-0204', '0'),
('001', 'I-0205', '0'),
('001', 'I-0206', '0'),
('001', 'I-0207', '0'),
('001', 'I-0208', '0'),
('001', 'I-0209', '0'),
('001', 'I-021', '0'),
('001', 'I-0210', '0'),
('001', 'I-0211', '0'),
('001', 'I-0212', '0'),
('001', 'I-0213', '0'),
('001', 'I-0214', '0'),
('001', 'I-0215', '0'),
('001', 'I-0216', '0'),
('001', 'I-0217', '0'),
('001', 'I-0218', '0'),
('001', 'I-0219', '0'),
('001', 'I-022', '0'),
('001', 'I-0220', '0'),
('001', 'I-0221', '0'),
('001', 'I-0222', '0'),
('001', 'I-0223', '0'),
('001', 'I-0224', '0'),
('001', 'I-0225', '0'),
('001', 'I-0226', '0'),
('001', 'I-0227', '0'),
('001', 'i-0228', '0'),
('001', 'I-0229', '0'),
('001', 'I-023', '0'),
('001', 'I-0230', '0'),
('001', 'I-0231', '0'),
('001', 'I-0232', '0'),
('001', 'I-0233', '0'),
('001', 'I-0234', '0'),
('001', 'I-0235', '0'),
('001', 'I-0236', '0'),
('001', 'I-0237', '0'),
('001', 'I-0238', '0'),
('001', 'I-0239', '0'),
('001', 'I-024', '0'),
('001', 'I-0240', '0'),
('001', 'I-0241', '0'),
('001', 'I-0242', '0'),
('001', 'I-0243', '0'),
('001', 'I-0244', '0'),
('001', 'I-0245', '0'),
('001', 'I-0246', '0'),
('001', 'I-0247', '0'),
('001', 'I-0248', '0'),
('001', 'i-0249', '0'),
('001', 'I-025', '0'),
('001', 'I-0250', '0'),
('001', 'I-0251', '0'),
('001', 'I-0252', '0'),
('001', 'I-0253', '0'),
('001', 'I-0254', '0'),
('001', 'I-0255', '0'),
('001', 'I-0256', '0'),
('001', 'I-0257', '0'),
('001', 'I-0258', '0'),
('001', 'I-0259', '0'),
('001', 'I-026', '0'),
('001', 'I-0260', '0'),
('001', 'I-0261', '0'),
('001', 'I-0262', '0'),
('001', 'I-0263', '0'),
('001', 'I-0264', '0'),
('001', 'I-0265', '0'),
('001', 'I-0266', '0'),
('001', 'I-0267', '0'),
('001', 'I-0268', '0'),
('001', 'I-0269', '0'),
('001', 'I-027', '0'),
('001', 'I-0270', '0'),
('001', 'I-0271', '0'),
('001', 'I-0272', '0'),
('001', 'I-0273', '0'),
('001', 'I-0274', '0'),
('001', 'I-0275', '0'),
('001', 'I-0276', '0'),
('001', 'I-0277', '0'),
('001', 'I-0278', '0'),
('001', 'I-0279', '0'),
('001', 'I-028', '0'),
('001', 'i-0280', '0'),
('001', 'I-0281', '0'),
('001', 'I-0282', '0'),
('001', 'I-0283', '0'),
('001', 'I-0284', '0'),
('001', 'I-0285', '0'),
('001', 'I-0286', '0'),
('001', 'I-0287', '0'),
('001', 'I-0288', '0'),
('001', 'I-0289', '0'),
('001', 'I-029', '0'),
('001', 'I-0290', '0'),
('001', 'I-0291', '0'),
('001', 'i-0292', '0'),
('001', 'I-0293', '0'),
('001', 'I-0294', '0'),
('001', 'I-0295', '0'),
('001', 'I-0296', '0'),
('001', 'I-0297', '0'),
('001', 'I-0298', '0'),
('001', 'I-0299', '0'),
('001', 'I-030', '0'),
('001', 'i-0300', '0'),
('001', 'I-0301', '0'),
('001', 'I-0302', '0'),
('001', 'I-0303', '0'),
('001', 'I-0304', '0'),
('001', 'I-0305', '0'),
('001', 'I-031', '0'),
('001', 'I-032', '0'),
('001', 'I-033', '0'),
('001', 'I-034', '0'),
('001', 'I-035', '0'),
('001', 'I-036', '0'),
('001', 'I-037', '0'),
('001', 'I-038', '0'),
('001', 'I-039', '0'),
('001', 'I-040', '0'),
('001', 'I-041', '0'),
('001', 'I-042', '0'),
('001', 'I-043', '0'),
('001', 'I-044', '0'),
('001', 'I-045', '0'),
('001', 'I-046', '0'),
('001', 'I-047', '0'),
('001', 'I-048', '0'),
('001', 'I-049', '0'),
('001', 'I-050', '0'),
('001', 'I-051', '0'),
('001', 'I-052', '0'),
('001', 'I-053', '0'),
('001', 'I-054', '0'),
('001', 'I-055', '0'),
('001', 'I-056', '0'),
('001', 'I-057', '0'),
('001', 'I-058', '0'),
('001', 'I-059', '0'),
('001', 'I-060', '0'),
('001', 'I-061', '0'),
('001', 'I-062', '0'),
('001', 'I-064', '0'),
('001', 'I-065', '0'),
('001', 'I-066', '0'),
('001', 'I-067', '0'),
('001', 'I-068', '0'),
('001', 'I-069', '0'),
('001', 'I-070', '0'),
('001', 'I-071', '0'),
('001', 'I-072', '0'),
('001', 'I-073', '0'),
('001', 'I-074', '0'),
('001', 'I-075', '0'),
('001', 'I-076', '0'),
('001', 'I-077', '0'),
('001', 'I-078', '0'),
('001', 'I-079', '0'),
('001', 'I-080', '0'),
('001', 'I-081', '0'),
('001', 'I-082', '0'),
('001', 'I-083', '0'),
('001', 'I-084', '0'),
('001', 'I-085', '0'),
('001', 'I-087', '0'),
('001', 'I-089', '0'),
('001', 'I-090', '0'),
('001', 'I-091', '0'),
('001', 'I-092', '0'),
('001', 'I-093', '0'),
('001', 'I-094', '0'),
('001', 'I-095', '0'),
('001', 'I-096', '0'),
('001', 'I-097', '0'),
('001', 'I-098', '0'),
('001', 'I-099', '0'),
('001', 'I-100', '0'),
('001', 'I-101', '0'),
('001', 'I-102', '0'),
('001', 'I-103', '0'),
('001', 'I-104', '0'),
('001', 'I-105', '0'),
('001', 'I-106', '0'),
('001', 'I-107', '0'),
('001', 'I-108', '0'),
('001', 'I-109', '0'),
('001', 'I-110', '0'),
('001', 'I-111', '0'),
('001', 'I-112', '0'),
('001', 'I-113', '0'),
('001', 'I-114', '0'),
('001', 'I-115', '0'),
('001', 'I-116', '0'),
('001', 'I-117', '0'),
('001', 'I-118', '0'),
('001', 'I-119', '0'),
('001', 'I-120', '0'),
('001', 'I-121', '0'),
('001', 'I-122', '0'),
('001', 'I-123', '0'),
('001', 'I-124', '0'),
('001', 'I-125', '0'),
('001', 'I-126', '0'),
('001', 'I-127', '0'),
('001', 'I-128', '0'),
('001', 'I-129', '0'),
('001', 'I-130', '0'),
('001', 'I-131', '0'),
('001', 'I-132', '0'),
('001', 'I-133', '0'),
('001', 'I-134', '0'),
('001', 'I-135', '0'),
('001', 'I-136', '0'),
('001', 'I-138', '0'),
('001', 'I-139', '0'),
('001', 'I-140', '0'),
('001', 'I-141', '0'),
('001', 'I-142', '0'),
('001', 'I-143', '0'),
('001', 'I-144', '0'),
('001', 'I-145', '0'),
('001', 'I-146', '0'),
('001', 'I-147', '0'),
('001', 'I-148', '0'),
('001', 'I-149', '0'),
('001', 'I-150', '0'),
('001', 'I-151', '0'),
('001', 'I-152', '0'),
('001', 'I-153', '0'),
('001', 'I-154', '0'),
('001', 'I-155', '0'),
('001', 'I-156', '0'),
('001', 'I-157', '0'),
('001', 'I-158', '0'),
('001', 'I-159', '0'),
('001', 'I-160', '0'),
('001', 'I-161', '0'),
('001', 'I-162', '0'),
('001', 'I-163', '0'),
('001', 'I-164', '0'),
('001', 'I-165', '0'),
('001', 'I-166', '0'),
('001', 'I-167', '0'),
('001', 'I-168', '0'),
('001', 'I-169', '0'),
('001', 'I-170', '0'),
('001', 'I-171', '0'),
('001', 'I-172', '0'),
('001', 'I-173', '0'),
('001', 'I-174', '0'),
('001', 'I-175', '0'),
('001', 'I-176', '0'),
('001', 'I-177', '0'),
('001', 'I-178', '0'),
('001', 'I-179', '0'),
('001', 'I-180', '0'),
('001', 'I-181', '0'),
('001', 'I-182', '0'),
('001', 'I-183', '0'),
('001', 'I-184', '0'),
('001', 'I-185', '0'),
('001', 'I-186', '0'),
('001', 'I-187', '0'),
('001', 'I-188', '0'),
('001', 'I-189', '0'),
('001', 'I-190', '0'),
('001', 'I-191', '0'),
('001', 'I-192', '0'),
('001', 'I-193', '0'),
('001', 'I-195', '0'),
('001', 'I-196', '0'),
('001', 'I-197', '0'),
('001', 'I-198', '0'),
('001', 'I-199', '0'),
('001', 'I-200', '0'),
('001', 'I-201', '0'),
('001', 'I-202', '0'),
('001', 'I-203', '0'),
('001', 'I-204', '0'),
('001', 'I-205', '0'),
('001', 'I-206', '0'),
('001', 'I-207', '0'),
('001', 'I-208', '0'),
('001', 'I-209', '0'),
('001', 'I-210', '0'),
('001', 'I-211', '0'),
('001', 'I-212', '0'),
('001', 'I-213', '0'),
('001', 'I-214', '0'),
('001', 'I-215', '0'),
('001', 'I-216', '0'),
('001', 'I-217', '0'),
('001', 'I-218', '0'),
('001', 'I-219', '0'),
('001', 'I-220', '0'),
('001', 'I-221', '0'),
('001', 'I-222', '0'),
('001', 'I-223', '0'),
('001', 'I-224', '0'),
('001', 'I-225', '0'),
('001', 'I-226', '0'),
('001', 'I-227', '0'),
('001', 'I-228', '0'),
('001', 'I-229', '0'),
('001', 'I-230', '0'),
('001', 'I-231', '0'),
('001', 'I-232', '0'),
('001', 'I-233', '0'),
('001', 'I-234', '0'),
('001', 'I-235', '0'),
('001', 'I-237', '0'),
('001', 'I-238', '0'),
('001', 'I-241', '0'),
('001', 'I-242', '0'),
('001', 'I-243', '0'),
('001', 'I-244', '0'),
('001', 'I-245', '0'),
('001', 'I-247', '0'),
('001', 'I-248', '0'),
('001', 'I-249', '0'),
('001', 'I-250', '0'),
('001', 'I-251', '0'),
('001', 'I-252', '0'),
('001', 'I-253', '0'),
('001', 'I-254', '0'),
('001', 'I-255', '0'),
('001', 'I-256', '0'),
('001', 'I-260', '0'),
('001', 'I-261', '0'),
('001', 'I-262', '0'),
('001', 'I-263', '0'),
('001', 'I-264', '0'),
('001', 'I-266', '0'),
('001', 'I-267', '0'),
('001', 'I-268', '0'),
('001', 'I-269', '0'),
('001', 'I-270', '0'),
('001', 'I-271', '0'),
('001', 'I-273', '0'),
('001', 'I-274', '0'),
('001', 'I-275', '0'),
('001', 'I-276', '0'),
('001', 'I-281', '0'),
('001', 'I-282', '0'),
('001', 'I-283', '0'),
('001', 'I-284', '0'),
('001', 'I-285', '0'),
('001', 'I-286', '0'),
('001', 'I-287', '0'),
('001', 'I-288', '0'),
('001', 'I-290', '0'),
('001', 'I-291', '0'),
('001', 'I-292', '0'),
('001', 'I-293', '0'),
('001', 'I-294', '0'),
('001', 'I-295', '0'),
('001', 'I-296', '0'),
('001', 'I-297', '0'),
('001', 'I-298', '0'),
('001', 'I-299', '0'),
('001', 'I-300', '0'),
('001', 'I-301', '0'),
('001', 'I-3016', '0'),
('001', 'I-3018', '0'),
('001', 'I-302', '0'),
('001', 'I-303', '0'),
('001', 'I-305', '0'),
('001', 'I-306', '0'),
('001', 'I-308', '0'),
('001', 'I-309', '0'),
('001', 'I-310', '0'),
('001', 'I-311', '0'),
('001', 'I-312', '0'),
('001', 'I-313', '0'),
('001', 'I-314', '0'),
('001', 'I-315', '0'),
('001', 'I-316', '0'),
('001', 'I-317', '0'),
('001', 'I-318', '0'),
('001', 'I-319', '0'),
('001', 'I-320', '0'),
('001', 'I-O63', '0'),
('001', 'I086', '0'),
('001', 'IP001', '0'),
('001', 'IP002', '0'),
('001', 'LAI001', '0'),
('001', 'MW001', '0'),
('001', 'SA001', '0'),
('001', 'SA002', '0'),
('001', 'SI001', '0'),
('001', 'SI002', '0'),
('001', 'T-001', '0'),
('001', 'T-002', '0'),
('001', 'T-003', '0'),
('001', 'T-004', '0'),
('001', 'T-005', '0'),
('001', 'T-006', '0'),
('001', 'T-007', '0'),
('001', 'WI001', '0'),
('001', 'WI002', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `location_name` varchar(60) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `location_name_arabic` varchar(100) NOT NULL,
  `main_store` int(1) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `excise_tax` tinyint(1) NOT NULL,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Default ', '', '', '', '', '', '', '0', '', '0', '0', '0');

### Structure of table `0_loyality_points` ###

DROP TABLE IF EXISTS `0_loyality_points`;

CREATE TABLE `0_loyality_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `redeem` double NOT NULL,
  `points` double NOT NULL,
  `debtor_no` int(11) NOT NULL,
  `trans_no` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `used` int(1) NOT NULL,
  `cust_name` varchar(100) NOT NULL,
  `country_code` int(5) NOT NULL,
  `cust_phone` varchar(20) NOT NULL,
  `cust_email` varchar(100) NOT NULL,
  `branch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_loyality_points` ###


### Structure of table `0_mail_signature` ###

DROP TABLE IF EXISTS `0_mail_signature`;

CREATE TABLE `0_mail_signature` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `designation` varchar(50) NOT NULL,
  `address` varchar(50) NOT NULL,
  `phone` int(50) NOT NULL,
  `fax` int(50) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `web_link` varchar(100) NOT NULL,
  `fb_link` varchar(100) NOT NULL,
  `twitter_link` varchar(100) NOT NULL,
  `linkedin_link` varchar(100) NOT NULL,
  `google_plus_link` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `signature_type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_mail_signature` ###


### Structure of table `0_maintenance_form` ###

DROP TABLE IF EXISTS `0_maintenance_form`;

CREATE TABLE `0_maintenance_form` (
  `#` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL,
  `Email` varchar(100) NOT NULL,
  `Phone` varchar(100) NOT NULL,
  `Factor` int(11) NOT NULL,
  `Authority` int(11) NOT NULL,
  `Inactive` int(11) NOT NULL,
  `dropdown` varchar(100) NOT NULL,
  PRIMARY KEY (`#`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_maintenance_form` ###


### Structure of table `0_material_req_details` ###

DROP TABLE IF EXISTS `0_material_req_details`;

CREATE TABLE `0_material_req_details` (
  `material_req_detail_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `material_req_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `lpo_id` int(11) NOT NULL,
  `order_quantity` int(11) NOT NULL,
  `estimate_price` double NOT NULL,
  `quantity` double NOT NULL,
  `price` double NOT NULL,
  `purpose` varchar(320) NOT NULL,
  PRIMARY KEY (`material_req_detail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_material_req_details` ###


### Structure of table `0_material_requisition` ###

DROP TABLE IF EXISTS `0_material_requisition`;

CREATE TABLE `0_material_requisition` (
  `material_req_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) NOT NULL,
  `narrative` varchar(240) NOT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed` tinyint(4) NOT NULL,
  `inactive` tinyint(4) NOT NULL,
  `transfered` int(11) NOT NULL,
  `transaction_date` date NOT NULL,
  `user_name` varchar(30) NOT NULL COMMENT 'to username',
  `user_location` varchar(30) NOT NULL COMMENT 'tp locattion',
  `from_user` int(11) NOT NULL,
  `from_location` varchar(30) NOT NULL,
  `stock_moves_id` int(11) NOT NULL,
  `details` varchar(100) NOT NULL,
  PRIMARY KEY (`material_req_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_material_requisition` ###


### Structure of table `0_modules` ###

DROP TABLE IF EXISTS `0_modules`;

CREATE TABLE `0_modules` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `module` varchar(100) NOT NULL COMMENT 'Main Module',
  `submodule` varchar(100) NOT NULL COMMENT 'Sub Module',
  `screen` varchar(100) NOT NULL COMMENT 'Original Screen Name',
  `name` varchar(100) NOT NULL COMMENT 'Change Module Name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_modules` ###


### Structure of table `0_otp_code` ###

DROP TABLE IF EXISTS `0_otp_code`;

CREATE TABLE `0_otp_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL,
  `code` varchar(50) NOT NULL,
  `used` int(1) NOT NULL,
  `cust_phone` varchar(50) NOT NULL,
  `country_code` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_otp_code` ###


### Structure of table `0_overtime` ###

DROP TABLE IF EXISTS `0_overtime`;

CREATE TABLE `0_overtime` (
  `overtime_id` int(11) NOT NULL,
  `overtime_name` varchar(100) NOT NULL,
  `overtime_rate` float NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`overtime_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_overtime` ###


### Structure of table `0_overtime_weekend` ###

DROP TABLE IF EXISTS `0_overtime_weekend`;

CREATE TABLE `0_overtime_weekend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `days` varchar(80) NOT NULL,
  `ot_factor` float NOT NULL,
  `is_weekend` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_overtime_weekend` ###


### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'Due on Presentation', '1', '0', '0'),
('2', 'Cash Only', '0', '0', '0'),
('3', '75% Advance &amp; Balance Upon Completion', '1', '0', '0'),
('4', 'Advance', '1', '0', '0'),
('5', '50 % Advance &amp; Balance Upon Completion', '1', '0', '0'),
('6', '50%adv,30% on 50% of  com. &amp; 20% on com.', '1', '0', '0'),
('7', '100 % Upon Completion', '1', '0', '0'),
('8', 'Customer 60 days', '60', '0', '0'),
('9', '50%adv,25% on 50% of  com. &amp; bal on com.', '1', '0', '0');

### Structure of table `0_payroll_account` ###

DROP TABLE IF EXISTS `0_payroll_account`;

CREATE TABLE `0_payroll_account` (
  `account_id` int(11) NOT NULL,
  `account_code` varchar(15) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_account` ###


### Structure of table `0_payroll_allocations` ###

DROP TABLE IF EXISTS `0_payroll_allocations`;

CREATE TABLE `0_payroll_allocations` (
  `id` int(11) NOT NULL,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_allocations` ###


### Structure of table `0_payroll_allowances` ###

DROP TABLE IF EXISTS `0_payroll_allowances`;

CREATE TABLE `0_payroll_allowances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `allowances` varchar(100) NOT NULL,
  `inactive` int(1) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `payroll_exp` varchar(50) NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_payroll_allowances` ###


### Structure of table `0_payroll_allowances_deductions` ###

DROP TABLE IF EXISTS `0_payroll_allowances_deductions`;

CREATE TABLE `0_payroll_allowances_deductions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(11) NOT NULL,
  `allow_deduct_id` varchar(100) NOT NULL,
  `amount` float NOT NULL,
  `remarks` text NOT NULL,
  `is_allowances` enum('1','2') NOT NULL COMMENT '1=> allownaces, 2=> deductions',
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_payroll_allowances_deductions` ###


### Structure of table `0_payroll_deductions` ###

DROP TABLE IF EXISTS `0_payroll_deductions`;

CREATE TABLE `0_payroll_deductions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `deductions` varchar(100) NOT NULL,
  `inactive` int(1) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `payroll_exp` varchar(15) NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_payroll_deductions` ###


### Structure of table `0_payroll_email` ###

DROP TABLE IF EXISTS `0_payroll_email`;

CREATE TABLE `0_payroll_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(100) NOT NULL,
  `email_text` longtext NOT NULL,
  `subject` varchar(100) NOT NULL,
  `from_user_id` varchar(100) NOT NULL,
  `trans_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `mail_attachment` varchar(200) NOT NULL,
  `read_status` tinyint(11) NOT NULL COMMENT 'read =1 and unread =0',
  `notification_status` int(11) NOT NULL DEFAULT 0,
  `deleted` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  `trash` tinyint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT ;

### Data of table `0_payroll_email` ###


### Structure of table `0_payroll_holidays` ###

DROP TABLE IF EXISTS `0_payroll_holidays`;

CREATE TABLE `0_payroll_holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `holidays` varchar(50) NOT NULL,
  `description` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `inactive` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_payroll_holidays` ###


### Structure of table `0_payroll_structure` ###

DROP TABLE IF EXISTS `0_payroll_structure`;

CREATE TABLE `0_payroll_structure` (
  `salary_scale_id` int(11) NOT NULL,
  `payroll_rule` text NOT NULL,
  KEY `salary_scale_id` (`salary_scale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_structure` ###


### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###


### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) NOT NULL,
  `report` varchar(5) DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###


### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(60) NOT NULL,
  `queue` varchar(20) NOT NULL,
  `host` varchar(40) NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###


### Structure of table `0_project_module_name` ###

DROP TABLE IF EXISTS `0_project_module_name`;

CREATE TABLE `0_project_module_name` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `placement` int(100) NOT NULL COMMENT 'User Define Serial#',
  `col_name` varchar(100) NOT NULL COMMENT 'Updated Column Name',
  `col_color` varchar(100) NOT NULL COMMENT 'Color Coded',
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_project_module_name` ###


### Structure of table `0_project_task` ###

DROP TABLE IF EXISTS `0_project_task`;

CREATE TABLE `0_project_task` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `task_desc` text NOT NULL,
  `demo` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_project_task` ###


### Structure of table `0_projects` ###

DROP TABLE IF EXISTS `0_projects`;

CREATE TABLE `0_projects` (
  `proj_id` int(11) NOT NULL AUTO_INCREMENT,
  `proj_name` varchar(100) NOT NULL,
  `contact_person` int(11) NOT NULL,
  `opportunity` varchar(200) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `proj_description` varchar(100) DEFAULT NULL,
  `proj_type` tinyint(1) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL,
  `created_date` date NOT NULL,
  `delivery_date` varchar(100) NOT NULL,
  `closed_date` date DEFAULT NULL,
  `begin_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `owner_id` int(11) NOT NULL,
  `attachment` varchar(1000) NOT NULL,
  `deliver` varchar(100) NOT NULL,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `enq_date` date NOT NULL,
  `job_date` date NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `mobile` int(20) NOT NULL,
  `email` varchar(150) NOT NULL,
  `postal_address` varchar(300) NOT NULL,
  `attach_front` varchar(300) NOT NULL,
  `attach_back` varchar(300) NOT NULL,
  `inquiry_type` varchar(100) NOT NULL,
  PRIMARY KEY (`proj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_projects` ###


### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###


### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(1000) NOT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `exp_date` date NOT NULL,
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `discount_perc` double NOT NULL,
  `discount` double NOT NULL,
  `charge_amount` double NOT NULL,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `charge_group` int(11) NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `approved` tinyint(1) NOT NULL,
  `dimension_id` int(100) NOT NULL,
  `dimension2_id` int(100) NOT NULL,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_purchase_material_req_details` ###

DROP TABLE IF EXISTS `0_purchase_material_req_details`;

CREATE TABLE `0_purchase_material_req_details` (
  `material_req_detail_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `material_req_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `lpo_id` int(11) NOT NULL,
  `order_quantity` int(11) NOT NULL,
  `estimate_price` double NOT NULL,
  `quantity` double NOT NULL,
  `price` double NOT NULL,
  `purpose` varchar(320) NOT NULL,
  PRIMARY KEY (`material_req_detail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_purchase_material_req_details` ###


### Structure of table `0_purchase_material_requisition` ###

DROP TABLE IF EXISTS `0_purchase_material_requisition`;

CREATE TABLE `0_purchase_material_requisition` (
  `material_req_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) NOT NULL,
  `narrative` varchar(240) NOT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed` tinyint(4) NOT NULL,
  `inactive` tinyint(4) NOT NULL,
  `transfered` int(11) NOT NULL,
  `transaction_date` date NOT NULL,
  `user_name` varchar(30) NOT NULL COMMENT 'to username',
  `user_location` varchar(30) NOT NULL COMMENT 'tp locattion',
  `from_user` int(11) NOT NULL,
  `from_location` varchar(30) NOT NULL,
  `stock_moves_id` int(11) NOT NULL,
  `details` varchar(100) NOT NULL,
  PRIMARY KEY (`material_req_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_purchase_material_requisition` ###


### Structure of table `0_quick_access` ###

DROP TABLE IF EXISTS `0_quick_access`;

CREATE TABLE `0_quick_access` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `active` varchar(255) NOT NULL,
  `user_id` int(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_access` ###

INSERT INTO `0_quick_access` VALUES
('60', 'Sales Quotation Entry', 'sales/sales_order_entry.php?NewQuotation=Yes', 'menu-icon glyphicon glyphicon-pencil bg-light-blue', '1', '27'),
('52', 'Bank Account Transfers', 'gl/bank_transfer.php?', 'menu-icon fa fa-university bg-light-blue', '1', '1'),
('53', 'Journal Inquiry', 'gl/inquiry/journal_inquiry.php?', 'menu-icon fa fa-comments bg-light-blue', '1', '1'),
('51', 'Deposits', 'gl/gl_bank.php?NewDeposit=Yes', 'menu-icon fa fa-check-square-o bg-light-blue', '1', '1'),
('48', 'Payments to Suppliers', 'purchasing/supplier_payment.php?', 'menu-icon ionicons ion-cash bg-light-blue', '1', '1'),
('49', 'Dimension Inquiry', 'dimensions/inquiry/search_dimensions.php?', 'menu-icon glyphicon glyphicon-zoom-in bg-light-blue', '1', '1'),
('6', 'Sales Quotation Entry', 'sales/sales_order_entry.php?NewQuotation=Yes', 'menu-icon glyphicon glyphicon-pencil bg-light-blue', '1', '20'),
('7', 'Direct Invoice', 'sales/sales_order_entry.php?NewInvoice=0', 'menu-icon glyphicon glyphicon-paste  bg-light-blue', '1', '20'),
('8', 'Schedule Against Sales Orders', 'sales/inquiry/schedule_against_so.php?', 'menu-icon  bg-light-blue', '1', '20'),
('9', 'Invoice Against Sales Delivery', 'sales/inquiry/sales_deliveries_view.php?OutstandingOnly=1', 'menu-icon glyphicon glyphicon-save-file bg-light-blue', '1', '20'),
('10', 'Customer Payments', 'sales/customer_payments.php?', 'menu-icon glyphicon glyphicon-usd bg-light-blue', '1', '20'),
('11', 'Sales Quotation Inquiry', 'sales/inquiry/sales_orders_view.php?type=32', 'menu-icon glyphicon glyphicon-refresh bg-light-blue', '1', '20'),
('12', 'Customer Transaction Inquiry', 'sales/inquiry/customer_inquiry.php?', 'menu-icon glyphicon glyphicon-cloud-download bg-light-blue', '1', '20'),
('13', 'Add and Manage Customers', 'sales/manage/customers.php?', 'menu-icon ionicons ion-android-person-add bg-light-blue', '1', '20'),
('14', 'Customer Branches', 'sales/manage/customer_branches.php?', 'menu-icon fa fa-building-o bg-light-blue', '1', '20'),
('15', 'Items', 'inventory/manage/items.php?', 'menu-icon fa fa-cubes bg-light-blue', '1', '20'),
('16', 'Create Enquiry', 'CRM/pages/manage/add_project.php', 'menu-icon  bg-light-blue', '1', '20'),
('17', 'Opportunity Inquiry', 'CRM/pages/manage/projects.php', 'menu-icon  bg-light-blue', '1', '20'),
('50', 'Payments', 'gl/gl_bank.php?NewPayment=Yes', 'menu-icon fa fa-credit-card bg-light-blue', '1', '1'),
('47', 'Direct Supplier Invoice', 'purchasing/po_entry_items.php?NewInvoice=Yes', 'menu-icon glyphicon glyphicon-duplicate bg-light-blue', '1', '1'),
('45', 'Invoice Against Sales Delivery', 'sales/inquiry/sales_deliveries_view.php?OutstandingOnly=1', 'menu-icon glyphicon glyphicon-save-file bg-light-blue', '1', '1'),
('46', 'Customer Payments', 'sales/customer_payments.php?', 'menu-icon glyphicon glyphicon-usd bg-light-blue', '1', '1'),
('43', 'Sales Order Entry', 'sales/sales_order_entry.php?NewOrder=Yes', 'menu-icon glyphicon glyphicon-file bg-light-blue', '1', '1'),
('44', 'Direct Invoice', 'sales/sales_order_entry.php?NewInvoice=0', 'menu-icon glyphicon glyphicon-paste  bg-light-blue', '1', '1'),
('42', 'Sales Quotation Entry', 'sales/sales_order_entry.php?NewQuotation=Yes', 'menu-icon glyphicon glyphicon-pencil bg-light-blue', '1', '1'),
('61', 'Sales Order Entry', 'sales/sales_order_entry.php?NewOrder=Yes', 'menu-icon glyphicon glyphicon-file bg-light-blue', '1', '27'),
('62', 'Schedule Against Sales Orders', 'sales/inquiry/schedule_against_so.php?', 'menu-icon  bg-light-blue', '1', '27'),
('63', 'Sales Quotation Inquiry', 'sales/inquiry/sales_quotation_inquiry.php', 'menu-icon glyphicon glyphicon-refresh bg-light-blue', '1', '27'),
('64', 'Sales Order Inquiry', 'sales/inquiry/sales_orders_view.php?type=30', 'menu-icon glyphicon glyphicon-book bg-light-blue', '1', '27'),
('65', 'Schedule  Inquiry', 'sales/inquiry/schedule_inquiry.php?', 'menu-icon  bg-light-blue', '1', '27'),
('66', 'Purchase Order Entry', 'purchasing/po_entry_items.php?NewOrder=Yes', 'menu-icon fa fa-shopping-cart bg-light-blue', '1', '27'),
('103', 'Dimension Inquiry', 'dimensions/inquiry/search_dimensions.php?', 'menu-icon glyphicon glyphicon-zoom-in bg-light-blue', '1', '22'),
('102', 'Purchase Orders Inquiry', 'purchasing/inquiry/po_search_completed.php?', 'menu-icon fa fa-check-square-o bg-light-blue', '1', '22'),
('98', 'Schedule  Inquiry', 'sales/inquiry/schedule_inquiry.php?', 'menu-icon  bg-light-blue', '1', '22'),
('99', 'Customer Transaction Inquiry', 'sales/inquiry/customer_inquiry.php?', 'menu-icon glyphicon glyphicon-cloud-download bg-light-blue', '1', '22'),
('100', 'Customer Allocation Inquiry', 'sales/inquiry/customer_allocation_inquiry.php?', 'menu-icon glyphicon glyphicon-credit-card bg-light-blue', '1', '22'),
('101', 'Supplier Invoices', 'purchasing/supplier_invoice.php?New=1', 'menu-icon glyphicon glyphicon-duplicate bg-light-blue', '1', '22'),
('97', 'Sales Order Inquiry', 'sales/inquiry/sales_orders_view.php?type=30', 'menu-icon glyphicon glyphicon-book bg-light-blue', '1', '22'),
('96', 'Sales Quotation Inquiry', 'sales/inquiry/sales_quotation_inquiry.php', 'menu-icon glyphicon glyphicon-refresh bg-light-blue', '1', '22'),
('95', 'Customer Payments', 'sales/customer_payments.php?', 'menu-icon glyphicon glyphicon-usd bg-light-blue', '1', '22'),
('104', 'Journal Inquiry', 'gl/inquiry/journal_inquiry.php?', 'menu-icon fa fa-comments bg-light-blue', '1', '22');

### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `description` varchar(60) NOT NULL,
  `usage` varchar(120) DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT 0,
  `base_desc` varchar(60) DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###

INSERT INTO `0_quick_entries` VALUES
('1', '3', 'Month Salary', 'Payroll', '10000', '0001', '0');

### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT 0,
  `memo` tinytext NOT NULL,
  `action` varchar(2) NOT NULL,
  `dest_id` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###

INSERT INTO `0_quick_entry_lines` VALUES
('1', '1', '0', 'Month salary', '=', '5423', '0', '0'),
('2', '1', '0', 'Month salary', '=', '0003', '0', '0'),
('3', '1', '0', 'Month salary', '=', '1905', '0', '0'),
('4', '1', '0', 'Month salary', '=', '1888', '0', '0'),
('5', '1', '0', 'Month salary', '=', '5424', '0', '0'),
('6', '1', '0', 'Month salary', '=', '5427', '0', '0');

### Structure of table `0_real_estate_buyer` ###

DROP TABLE IF EXISTS `0_real_estate_buyer`;

CREATE TABLE `0_real_estate_buyer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `real_estate_id` int(11) NOT NULL,
  `looking_for` int(11) NOT NULL,
  `property_type` int(11) NOT NULL,
  `community_pref` varchar(500) NOT NULL,
  `phase_pref` varchar(500) NOT NULL,
  `layout` varchar(500) NOT NULL,
  `no_of_br` int(11) NOT NULL,
  `single_row` varchar(200) NOT NULL,
  `availability_type` int(11) NOT NULL,
  `payment_pref` int(11) NOT NULL,
  `bank` varchar(200) NOT NULL,
  `specific_req` varchar(500) NOT NULL,
  `days` varchar(300) NOT NULL,
  `budget` varchar(300) NOT NULL,
  `looking_type` int(11) NOT NULL,
  `sources` int(11) NOT NULL,
  `serious_client` int(11) NOT NULL,
  `source_text` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_real_estate_buyer` ###


### Structure of table `0_real_estate_doc` ###

DROP TABLE IF EXISTS `0_real_estate_doc`;

CREATE TABLE `0_real_estate_doc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `real_estate_id` int(11) NOT NULL,
  `doc_name` varchar(200) NOT NULL,
  `f_name` varchar(200) NOT NULL,
  `file` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_real_estate_doc` ###


### Structure of table `0_real_estate_form` ###

DROP TABLE IF EXISTS `0_real_estate_form`;

CREATE TABLE `0_real_estate_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(200) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `person_type` int(11) NOT NULL,
  `note` varchar(500) NOT NULL,
  `voided` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_real_estate_form` ###


### Structure of table `0_real_estate_seller` ###

DROP TABLE IF EXISTS `0_real_estate_seller`;

CREATE TABLE `0_real_estate_seller` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `real_estate_id` int(11) NOT NULL,
  `offer_type` int(11) NOT NULL,
  `property_category` int(11) NOT NULL,
  `br` varchar(200) NOT NULL,
  `community` varchar(200) NOT NULL,
  `phase` varchar(200) NOT NULL,
  `location_detail` varchar(500) NOT NULL,
  `bua` varchar(200) NOT NULL,
  `plot` varchar(200) NOT NULL,
  `view` varchar(200) NOT NULL,
  `availability_status` int(11) NOT NULL,
  `rent_amount` float NOT NULL,
  `expiry_date` date NOT NULL,
  `vaastu_compliant` varchar(200) NOT NULL,
  `financial_status` int(11) NOT NULL,
  `mortgage_amount` double NOT NULL,
  `submit_doc` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_real_estate_seller` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT 0,
  `monthly` int(11) NOT NULL DEFAULT 0,
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) NOT NULL DEFAULT '',
  `pattern` varchar(35) NOT NULL DEFAULT '1',
  `description` varchar(60) NOT NULL DEFAULT '',
  `change_name` varchar(100) NOT NULL COMMENT 'Type Name Change By The User',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '32', '', 'SQ-0265', '', '', '1', '0'),
('2', '0', '', 'JV-05', '', '', '1', '0'),
('3', '1', '', 'BP-01', '', '', '1', '0'),
('4', '4', '', 'CV-01', '', '', '1', '0'),
('5', '10', '', 'INV3102', '', '', '1', '0'),
('6', '11', '', 'CN02', '', '', '1', '0'),
('7', '12', '', 'pdc-r-01', '', '', '1', '0'),
('8', '13', '', 'DN-0136', '', '', '1', '0'),
('9', '16', '', '1', '', '', '1', '0'),
('10', '17', '', '001', '', '', '1', '0'),
('11', '18', '', 'PO-01', '', '', '1', '0'),
('12', '20', '', 'INV3102', '', '', '1', '0'),
('13', '21', '', '01', '', '', '1', '0'),
('14', '22', '', 'PV-01', '', '', '1', '0'),
('15', '25', '', 'POD-01', '', '', '1', '0'),
('16', '26', '', '1', '', '', '1', '0'),
('17', '28', '', '1', '', '', '1', '0'),
('18', '29', '', '1', '', '', '1', '0'),
('19', '30', '', 'SO-155', '', '', '1', '0'),
('20', '35', '', '01', '', '', '1', '0'),
('21', '40', '', '0218', '', '', '1', '0'),
('22', '1010', '', 'I-00001', '', '', '1', '0'),
('23', '2', '', 'BD-01', '', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###

INSERT INTO `0_refs` VALUES
('1', '0', '01'),
('2', '0', '01'),
('3', '0', 'JV-02'),
('4', '0', 'JV-03'),
('5', '0', 'JV-03'),
('7', '0', 'JV-03'),
('8', '0', 'JV-03'),
('9', '0', 'JV-03'),
('10', '0', 'JV-03'),
('11', '0', 'JV-03'),
('12', '0', 'JV-03'),
('13', '0', 'JV-03'),
('14', '0', 'JV-03'),
('15', '0', 'JV-03'),
('6', '0', 'JV-04');

### Structure of table `0_report_sign` ###

DROP TABLE IF EXISTS `0_report_sign`;

CREATE TABLE `0_report_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(100) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `signature1` varchar(50) NOT NULL,
  `signature2` varchar(50) NOT NULL,
  `signature3` varchar(50) NOT NULL,
  `policy_desc` longtext NOT NULL,
  `is_policy_text` int(1) NOT NULL,
  `is_policy_image` int(1) NOT NULL,
  `unique_name` varchar(60) NOT NULL,
  `filename` varchar(60) NOT NULL,
  `filesize` int(11) NOT NULL,
  `filetype` varchar(60) NOT NULL,
  `is_deleted` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_report_sign` ###


### Structure of table `0_reports` ###

DROP TABLE IF EXISTS `0_reports`;

CREATE TABLE `0_reports` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) NOT NULL,
  `report_id` int(50) NOT NULL,
  `active` tinyint(11) NOT NULL DEFAULT 0,
  `email_status` tinyint(11) NOT NULL DEFAULT 0,
  `deleted` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_reports` ###

INSERT INTO `0_reports` VALUES
('1', 'Customer Balances', '101', '1', '1', '0'),
('2', 'Invoice Wise Report', '10001', '1', '0', '0'),
('3', 'Aged Customer Analysis', '102', '1', '1', '0'),
('4', 'Customer Detail Listing', '103', '1', '1', '0'),
('5', 'Sales Summary Report', '114', '1', '1', '0'),
('6', 'Price Listing', '104', '1', '0', '0'),
('7', 'Order Status Listing', '105', '1', '0', '0'),
('8', 'Salesman Listing', '106', '1', '0', '0'),
('9', 'Print Invoices', '107', '1', '0', '0'),
('10', 'Print VAT Invoices', '1071', '1', '0', '0'),
('11', 'Print Credit Notes', '113', '0', '0', '0'),
('12', 'Print Deliveries', '110', '0', '0', '0'),
('13', 'Print Statements', '108', '0', '0', '0'),
('14', 'Print Sales Orders', '109', '0', '0', '0'),
('15', 'Print Sales Quotations', '111', '0', '0', '0'),
('16', 'Print Receipts', '112', '0', '0', '0'),
('17', 'Supplier Balances', '201', '0', '0', '0'),
('18', 'Supplier Invoice Wise Report', '2001', '0', '0', '0'),
('19', 'Supplier Balances - Detailed', '2012', '0', '0', '0'),
('20', 'Aged Supplier Analyses', '202', '0', '0', '0'),
('21', 'Payment Report', '203', '0', '0', '0'),
('22', 'Outstanding GRNs Report', '204', '0', '0', '0'),
('23', 'Supplier Detail Listing', '205', '0', '0', '0'),
('24', 'Print Purchase Orders', '209', '0', '0', '0'),
('25', 'Print Remittances', '210', '0', '0', '0'),
('26', 'Inventory Valuation Report', '301', '0', '0', '0'),
('27', 'Inventory Planning Report', '302', '0', '0', '0'),
('28', 'Stock Check Sheets', '303', '0', '0', '0'),
('29', 'Inventory Sales Report', '304', '0', '0', '0'),
('30', 'GRN Valuation Report', '305', '0', '0', '0'),
('31', 'Inventory Purchasing Report', '306', '0', '0', '0'),
('32', 'Inventory Movement Report', '307', '0', '0', '0'),
('33', 'Costed Inventory Movement Report', '308', '0', '0', '0'),
('34', 'Item Sales Summary Report', '309', '0', '0', '0'),
('35', 'Bill of Material Listing', '401', '0', '0', '0'),
('36', 'Work Order Listing', '402', '0', '0', '0'),
('37', 'Print Work Orders', '409', '0', '0', '0'),
('38', 'Fixed Assets Valuation', '451', '0', '0', '0'),
('39', 'Bank Statement', '601', '0', '0', '0'),
('40', 'Bank Statement w/ Reconcile', '602', '0', '0', '0'),
('41', 'Chart of Accounts', '701', '0', '0', '0'),
('42', 'List of Journal Entries', '702', '0', '0', '0'),
('43', 'GL Account Transactions', '704', '0', '0', '0'),
('44', 'Annual Expense Breakdown', '705', '0', '0', '0'),
('45', 'Balance Sheet', '706', '0', '0', '0'),
('46', 'Profit and Loss Statement', '707', '0', '0', '0'),
('47', 'Trial Balance', '708', '0', '0', '0'),
('48', 'Tax Report', '709', '0', '0', '0'),
('49', 'Audit Trail', '710', '0', '0', '0'),
('50', 'Void Transaction', '971', '0', '0', '0');

### Structure of table `0_reports_shortcuts` ###

DROP TABLE IF EXISTS `0_reports_shortcuts`;

CREATE TABLE `0_reports_shortcuts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `link` varchar(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  `active` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_reports_shortcuts` ###

INSERT INTO `0_reports_shortcuts` VALUES
('1', 'Aged Customer Analysis', 'reporting/reports_main.php?Class=0&amp;REP_ID=102', '', '1', '1'),
('2', 'Print Invoices', 'reporting/reports_main.php?Class=0&amp;REP_ID=107', '', '1', '1'),
('3', 'Print Credit Notes', 'reporting/reports_main.php?Class=0&amp;REP_ID=113', '', '1', '1');

### Structure of table `0_review` ###

DROP TABLE IF EXISTS `0_review`;

CREATE TABLE `0_review` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_name` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `address` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `requirments` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `updated_id` int(1) NOT NULL,
  `previous_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` int(1) NOT NULL DEFAULT 1,
  `rem_date` date NOT NULL,
  `inactive` int(1) NOT NULL DEFAULT 0,
  `unique_id` int(11) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `designation` varchar(50) NOT NULL,
  `company_name` varchar(50) NOT NULL,
  `mobile_number` varchar(20) NOT NULL,
  `service_require` varchar(50) NOT NULL,
  `source` varchar(20) NOT NULL,
  `status` int(1) NOT NULL,
  `currency` float NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `country` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `website` varchar(50) NOT NULL,
  `skype_id` varchar(50) NOT NULL,
  `reminder_date` date NOT NULL,
  `no_of_users` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_review` ###


### Structure of table `0_rfq` ###

DROP TABLE IF EXISTS `0_rfq`;

CREATE TABLE `0_rfq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_id` int(11) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `settle` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_rfq` ###


### Structure of table `0_rfq_details` ###

DROP TABLE IF EXISTS `0_rfq_details`;

CREATE TABLE `0_rfq_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_id` int(11) NOT NULL,
  `rfq_id` int(11) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `qty` double NOT NULL,
  `price` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_rfq_details` ###


### Structure of table `0_salary_structure` ###

DROP TABLE IF EXISTS `0_salary_structure`;

CREATE TABLE `0_salary_structure` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `salary_scale_id` int(11) NOT NULL,
  `pay_rule_id` varchar(15) NOT NULL,
  `pay_amount` double NOT NULL,
  `type` tinyint(1) NOT NULL COMMENT '0 for credit, 1 for debit',
  `is_basic` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salary_structure` ###


### Structure of table `0_salaryscale` ###

DROP TABLE IF EXISTS `0_salaryscale`;

CREATE TABLE `0_salaryscale` (
  `scale_id` int(11) NOT NULL AUTO_INCREMENT,
  `scale_name` text NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `pay_basis` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 = monthly, 1 = daily',
  PRIMARY KEY (`scale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salaryscale` ###


### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `stk_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(255) NOT NULL,
  `qty_sent` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `invoiced` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `sale_kit_id` varchar(50) NOT NULL,
  `item_specs` varchar(100) NOT NULL,
  `spec_description` varchar(5000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###


### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `debtor_no` bigint(11) NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  `customer_ref` tinytext NOT NULL,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT 0,
  `ship_via` int(11) NOT NULL DEFAULT 0,
  `delivery_address` tinytext NOT NULL,
  `contact_phone` varchar(30) DEFAULT NULL,
  `contact_email` varchar(100) DEFAULT NULL,
  `deliver_to` tinytext NOT NULL,
  `freight_cost` double NOT NULL DEFAULT 0,
  `from_stk_loc` varchar(5) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `approved` tinyint(1) NOT NULL,
  `country` varchar(50) NOT NULL,
  `ov_discount` double NOT NULL,
  `cust_name` varchar(150) NOT NULL,
  `country_code` int(5) NOT NULL,
  `cust_phone` varchar(20) NOT NULL,
  `cust_email` varchar(100) NOT NULL,
  `branch` int(11) NOT NULL,
  `shopify_id` varchar(100) NOT NULL,
  `inq_status` int(100) NOT NULL,
  `draft_pos` int(100) NOT NULL,
  `opp_id` int(11) NOT NULL COMMENT 'Opportunity ID: Created By CRM ',
  `quote_id` int(11) NOT NULL COMMENT 'Quotation ID ',
  `user` int(11) NOT NULL COMMENT 'Login User ID',
  `inquiry_type` int(11) NOT NULL COMMENT 'Inquiry Type: Create Inquiry Form',
  `dimension_id` int(11) NOT NULL,
  `dimension2_id` int(11) NOT NULL,
  `ord_cancel` int(11) NOT NULL,
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###


### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '0', '1', '001', '0', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Retail', '0', '1', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) NOT NULL DEFAULT '',
  `salesman_phone` char(30) NOT NULL DEFAULT '',
  `salesman_fax` char(30) NOT NULL DEFAULT '',
  `salesman_email` varchar(100) NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT 0,
  `break_pt` double NOT NULL DEFAULT 0,
  `provision2` double NOT NULL DEFAULT 0,
  `salesman_name_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'No Sales Person', '', '', '', '0', '0', '0', '', '0'),
('2', 'Arslan Nadeem', '056-403-1783_', '', 'arslan@mrxpert.ae', '0', '0', '0', '', '0'),
('3', 'Shakeel Ahmed', '(050) 4-848-203____', '', 'shakeel@mrxpert.ae', '0', '0', '0', '', '0');

### Structure of table `0_schedules` ###

DROP TABLE IF EXISTS `0_schedules`;

CREATE TABLE `0_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `soline` int(11) NOT NULL,
  `date` date NOT NULL,
  `end_date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `location` varchar(500) NOT NULL,
  `loc_cordinates` varchar(100) NOT NULL,
  `type` int(11) NOT NULL,
  `technician` varchar(200) NOT NULL,
  `remarks` varchar(400) NOT NULL,
  `status` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `delivery` int(11) NOT NULL,
  `ov_time` double NOT NULL,
  `approved` int(11) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `order_no` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_schedules` ###


### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) DEFAULT NULL,
  `sections` text DEFAULT NULL,
  `areas` text DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '3072;5632', '513;514;515;516;517;518;519;520;522;523;524;3073;3075;3076;3077;5633;5640;7937;7938;7939;7940;10497;15617;15618;15619;15620;15621;15624;15622;15623;15625;15626', '1'),
('2', 'System Administrator', 'System Administrator', '512;3072;5632;7936;9472;10496;76800;76800;76800;76800;77056;77056;77056;77056;77056;77056;77056;77056;77056;77056;77056;77312;77312;77312;77312;77312;13056;15616;20736;20992;21248;91136;156672;91392;91648', '3074;3075;3076;3077;3078;3079;3083;3085;3096;3090;3091;3092;3093;3094;3095;3086;3087;3088;3089;3114;3159;3165;3167;3163;3125;3156;3154;3155;3157;3158;514;515;516;517;518;519;520;522;523;551;524;526;527;565;529;530;531;532;563;533;539;540;541;542;543;544;546;547;548;549;553;556;557;558;562;561;559;537;535;536;552;3101;3102;3103;3104;3106;3107;3108;3109;3110;3111;3112;3113;3115;3116;3117;3118;3119;3160;3161;3137;3138;3133;3128;3129;3130;3131;3098;3166;3168;3134;3135;3150;3142;3143;3144;3145;3146;3147;3176;3148;3149;3097;3122;3169;5638;5639;5640;5641;5642;5643;5644;5645;5650;5652;5653;5651;5648;5637;5649;5675;5676;5678;5681;5682;5683;5684;5655;5657;5658;5659;5660;5661;5662;5663;5664;5667;5671;5672;5666;5687;5680;5679;5654;7938;7939;7958;7981;7982;7942;7943;7944;7945;7946;7947;7948;7949;7950;7951;7952;7986;7987;7954;7955;7957;7956;7980;7964;7965;7966;7967;7968;7969;7970;7972;7973;7974;7976;7977;7978;7961;7962;9474;9475;9487;9497;9499;9498;9478;9479;9480;9481;9482;9483;9489;9484;9485;9486;9490;9491;9493;9494;9495;10499;10500;10501;10510;10511;10498;10512;10513;10504;10506;10507;10508;10514;10502;76821;76831;76832;77058;77059;77060;77062;77063;77064;77066;77070;77073;77074;77314;77315;77321;77324;13058;13059;13060;13061;13062;13063;13064;13071;13065;13068;13069;13133;13134;13066;13129;13130;13131;13132;13096;13127;13103;13227;13228;13074;13075;13076;13077;13078;13079;13080;13081;13082;13083;13084;13085;13086;13089;13104;13106;13107;13091;13092;13093;13137;13094;13095;13097;13098;13135;13136;13109;13110;13111;13112;13113;13114;13115;13116;13117;13118;13119;13120;13121;13122;13123;13125;13105;15618;15619;15627;15621;15624;15622;15623;15628;15626;20737;20738;20739;20994;20995;20996;20997;20999;21000;21001;21002;21004;21005;21006;21007;21008;21026;21027;21028;21029;21021;21022;21023;21024;21015;21016;21017;21018;21036;21037;21038;21039;21031;21032;21034;21035;21252;21249;21250;21254;21251;21253;91236;156773;156774;156775;156776;156777;156778;156779;156782;156783;156784;156785;156786;156788;156789;156790;156791;156792;156793;156794;156795;156797;156798;156799;156800;156801;156802;156803;156804;156805;25957;91493;91750', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;3072;5632;15616', '5633;5635;5636;5638;5639;5640;5641;5642;5643;5644;5645;5648;5637;5649', '1'),
('9', 'Accountant', 'Accountant', '512;3072;5632;76800;76800;76800;76800;15616;20992', '20994;20995;20996;20997;20999;21000;21001;21002;21004;21005;21006;21007;523;524;531;3077;3079;3080;3083;3085;3091;3093;3094;3095;3086;3088;3167;3125;3156;3154;3155;3157;3158;3101;3102;3103;3104;3106;3107;3115;3116;3130;3131;3098;3166;3142;3143;3122;5638;5639;5640;5641;5642;5643;5644;5645;5650;5652;5653;5651;5648;5637;5649;5675;5676;5678;5681;5682;5683;5684;5657;5658;5659;5660;5661;5667;5671;5672;5666;5687;5680;7938;7939;7958;7981;7982;7942;7943;7944;7945;7946;7947;7948;7949;7950;7951;7952;7986;7987;7954;7955;7957;7956;7964;7965;7966;7967;7968;7969;7970;7972;7973;7974;7976;7977;7978;7961;7962;10497;76821;76831;76832;13058;13059;13060;13061;13062;13063;13064;13071;13065;13068;13069;13133;13134;13066;13129;13130;13131;13132;13096;13127;13103;13227;13228;13074;13075;13076;13077;13078;13079;13080;13081;13082;13083;13084;13085;13086;13089;13104;13106;13107;13091;13092;13093;13137;13094;13095;13097;13098;13135;13136;13109;13110;13111;13112;13113;13114;13115;13116;13117;13118;13119;13120;13121;13122;13123;13125;13105;15617;15618;21026;21027;21028;21029;21032;21034;21035', '0'),
('11', 'Transactions', ' Add only', '512;3072;5632;7936;13056;20736;20992;21248;156672', '515;517;520;522;523;524;527;529;530;531;532;533;559;560;3074;3075;3076;3077;3078;3079;3080;3081;3082;3083;3084;3085;3096;3090;3091;3092;3093;3094;3095;3086;3087;3088;3089;3114;3159;3163;3125;3156;3154;3155;3157;3158;3101;3102;3103;3104;3106;3107;3108;3109;3110;3111;3112;3113;3115;3116;3117;3118;3119;3160;3161;3137;3138;3133;3128;3129;3130;3131;3098;3134;3135;3150;3142;3143;3144;3145;3146;3147;3148;3149;3097;3122;3139;5634;5635;5636;5638;5639;5640;5641;5642;5643;5644;5645;5650;5652;5653;5651;5648;5637;5649;5675;5676;5678;5681;5682;5683;5684;5655;5657;5658;5659;5660;5661;5662;5663;5664;5667;5668;5669;5670;5671;5672;5666;5687;5680;5679;5654;7958;7981;7982;7942;7943;7944;7945;7946;7947;7948;7949;7950;7951;7952;7986;7987;7954;7955;7957;7956;7964;7965;7966;7967;7968;7969;7970;7972;7973;7974;7976;7977;7978;7961;7962;10497;10499;10500;10501;10498;13057;13058;13060;13061;13062;13063;13064;13071;13065;13068;13069;13066;15617;15618;20737;20738;20993;20994;20995;20999;21001;21252;21249;21250;21251;156781;156782;156783;156784;156785;156786;156787', '1'),
('12', 'Inquiries and Reports', 'only view dashboard &amp; internal view', NULL, '3074;3075;3076;3077;3078;3079;3080;3081;3082;3083;3084;3085;3096;3090;3091;3092;3093;3094;3095;3086;3087;3088;3089;3114;3159;3163;3125;3156;3154;3155;3157;3158;3106;3107;3108;3109;3110;3111;3112;3113;3115;3116;3117;3118;3119;3160;3161;3137;3138;3133;13058;13059;13060;13061;13062;13096;13127;13103;13227;13091;13092;13093;13094;20994;20995;20996;20997;21010;21011;21012;21013;21015;21016;21017', '1'),
('13', 'Maintenance', 'all maintenance forms', NULL, '3074;3075;3076;3077;3078;3079;3080;3081;3082;3083;3084;3085;3096;3090;3091;3092;3093;3094;3095;3086;3087;3088;3089;3114;3159;3163;3125;3156;3154;3155;3157;3158;3101;3102;3103;3104;3106;3107;3108;3109;3110;3111;3112;3113;3115;3116;3117;3118;3119;3160;3161;3137;3138;3133;3128;3129;3130;3131;3098;3134;3135;3150;3142;3143;3144;3145;3146;3147;3148;3149;3097;3122;3139;5634;5635;5636;5638;5639;5640;5641;5642;5643;5644;5645;5650;5652;5653;5651;5648;5637;5649;5675;5676;5678;5681;5682;5683;5684;5655;5657;5658;5659;5660;5661;5662;5663;5664;5667;5668;5669;5670;5671;5672;5666;5687;5680;5679;5654;7938;7939;7958;7981;7982;7942;7943;7944;7945;7946;7947;7948;7949;7950;7951;7952;7986;7987;7954;7955;7957;7956;7964;7965;7966;7967;7968;7969;7970;7972;7973;7974;7976;7977;7978;7961;7962', '1'),
('14', 'Reports', 'reports only', NULL, '15618', '1'),
('21', 'Junior Accountant', 'Junior Accountant', NULL, '13058;13059;13060;13061;13063;13064;13133;13074;13109;13110', '1'),
('25', 'CRM', 'CRM', '512;3072;5632;7936;77056;77056;77056;77056;77056;13056;20736;20992;21248;156672', '552;77058;77059;77061;77062;21036;21037;21038;21039;21255', '1'),
('26', 'Consultant trainee', 'Consultant trainee', NULL, NULL, '1'),
('29', 'Sales Manager ', 'Sales Manager ', '512;3072;5632;7936;9472;10496;76800;76800;76800;76800;77056;77056;77056;77056;77056;77056;77056;77056;77056;77056;77056;77312;77312;77312;77312;77312;13056;15616;20736;20992;21248;91136;156672;91392;91648', '3074;3075;3076;3077;3078;3079;3083;3085;3096;3086;3087;3088;3089;3114;3159;3165;3167;3163;3125;3156;3154;3155;3157;3158;514;515;516;517;518;519;520;522;523;551;524;526;527;565;529;530;531;532;563;533;539;540;541;542;543;544;546;547;548;549;553;556;557;558;562;561;559;537;535;536;552;3101;3102;3103;3104;3106;3107;3108;3109;3110;3111;3112;3113;3115;3116;3117;3118;3119;3160;3161;3137;3138;3133;3128;3129;3130;3131;3098;3166;3168;3134;3135;3150;3142;3143;3144;3145;3146;3147;3176;3148;3149;3097;3122;5638;5639;5640;5641;5642;5643;5644;5645;5648;5637;5649;5675;5676;5678;5681;5682;5683;5684;5655;5657;5658;5659;5660;5661;5662;5663;5664;5667;5671;5672;5666;5687;5680;5679;5654;7938;7939;7958;7981;7982;7942;7943;7944;7945;7946;7947;7948;7949;7950;7951;7952;7986;7987;7954;7955;7957;7956;7980;7964;7965;7966;7967;7968;7969;7970;7972;7973;7974;7976;7977;7978;7961;7962;9474;9475;9487;9497;9499;9498;9478;9479;9480;9481;9482;9483;9489;9484;9485;9486;9490;9491;9493;9494;9495;10499;10500;10501;10510;10511;10498;10512;10513;10504;10506;10507;10508;10514;10502;76821;76831;76832;77058;77059;77060;77062;77063;77064;77066;77070;77073;77074;77314;77315;77321;77324;13058;13059;13060;13061;13062;13063;13064;13071;13065;13066;13129;13130;13131;13132;13096;13127;13103;13227;13228;13074;13075;13076;13077;13078;13079;13080;13081;13082;13083;13084;13085;13086;13089;13104;13106;13107;13091;13092;13093;13137;13094;13095;13097;13098;13135;13136;13109;13110;13111;13112;13113;13114;13115;13116;13117;13118;13119;13120;13121;13122;13123;13125;13105;15618;15619;15621;15624;15622;15623;15628;15626;20737;20738;20739;20994;20995;20996;20997;20999;21000;21001;21002;21004;21005;21006;21007;21008;21021;21022;21023;21024;21036;21037;21038;21039;21032;21034;21035;21252;21249;21250;21254;21251;21253;91236;156773;156774;156775;156776;156777;156778;156779;156782;156783;156784;156785;156786;156788;156789;156790;156791;156792;156793;156794;156795;156797;156798;156799;156800;156801;156802;156803;156804;156805;25957;91493;91750', '0'),
('37', 'SM', 'SM', '512;3072;5632;7936;9472;10496;76800;76800;76800;76800;77056;77056;77056;77056;77056;77056;77056;77056;77056;77056;77056;77312;77312;77312;77312;77312;13056;15616;20736;20992;21248;91136;156672;91392;91648', '13058;13059;13060;13061;13062;13063;13064;13071;13065;13066;13129;13130;13131;13132;514;515;516;517;518;519;520;522;523;551;524;526;527;565;529;530;531;532;563;533;539;540;541;542;543;544;546;547;548;549;553;556;557;558;562;561;559;537;535;536;552;3074;3075;3076;3077;3078;3079;3083;3085;3096;3086;3087;3088;3089;3114;3159;3165;3167;3163;3125;3156;3154;3155;3157;3158;3101;3102;3103;3104;3106;3107;3108;3109;3110;3111;3112;3113;3115;3116;3117;3118;3119;3160;3161;3137;3138;3133;3128;3129;3130;3131;3098;3166;3168;3134;3135;3150;3142;3143;3144;3145;3146;3147;3176;3148;3149;3097;3122;5638;5639;5640;5641;5642;5643;5644;5645;5648;5637;5649;5675;5676;5678;5681;5682;5683;5684;5655;5657;5658;5659;5660;5661;5662;5663;5664;5667;5671;5672;5666;5687;5680;5679;5654;7938;7939;7958;7981;7982;7942;7943;7944;7945;7946;7947;7948;7949;7950;7951;7952;7986;7987;7954;7955;7957;7956;7980;7964;7965;7966;7967;7968;7969;7970;7972;7973;7974;7976;7977;7978;7961;7962;9474;9475;9487;9497;9499;9498;9478;9479;9480;9481;9482;9483;9489;9484;9485;9486;9490;9491;9493;9494;9495;10499;10500;10501;10510;10511;10498;10512;10513;10504;10506;10507;10508;10514;10502;76821;76831;76832;77058;77059;77060;77062;77063;77064;77066;77070;77073;77074;77314;77315;77321;77324;13096;13127;13103;13227;13228;13074;13075;13076;13077;13078;13079;13080;13081;13082;13083;13084;13085;13086;13089;13104;13106;13107;13091;13092;13093;13137;13094;13095;13097;13098;13135;13136;13109;13110;13111;13112;13113;13114;13115;13116;13117;13118;13119;13120;13121;13122;13123;13125;13105;15618;15619;15627;15621;15624;15622;15623;15628;15626;20737;20738;20739;20994;20995;20996;20997;20999;21000;21001;21002;21004;21005;21006;21007;21008;21021;21022;21023;21024;21036;21037;21038;21039;21032;21034;21035;21252;21249;21250;21254;21251;21253;91236;156773;156774;156775;156776;156777;156778;156779;156782;156783;156784;156785;156786;156788;156789;156790;156791;156792;156793;156794;156795;156797;156798;156799;156800;156801;156802;156803;156804;156805;25957;91493;91750', '0');

### Structure of table `0_seller_header` ###

DROP TABLE IF EXISTS `0_seller_header`;

CREATE TABLE `0_seller_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_id` int(11) NOT NULL,
  `header_name` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_seller_header` ###


### Structure of table `0_seller_header_master` ###

DROP TABLE IF EXISTS `0_seller_header_master`;

CREATE TABLE `0_seller_header_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_seller_header_master` ###


### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `contact` tinytext NOT NULL,
  `address` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_source_record` ###

DROP TABLE IF EXISTS `0_source_record`;

CREATE TABLE `0_source_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source_record` varchar(150) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_source_record` ###


### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT 1,
  `dflt_units` varchar(20) NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `description_arabic` varchar(100) NOT NULL,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Admin and General Expenses', '1', 'QTY', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', ''),
('2', 'Service Items', '1', 'QTY', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '1', '');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `parent_id` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###


### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `units` varchar(20) NOT NULL DEFAULT 'each',
  `mb_flag` char(1) NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `cogs_account` varchar(15) NOT NULL DEFAULT '',
  `inventory_account` varchar(15) NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) NOT NULL DEFAULT '',
  `wip_account` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT 0,
  `material_cost` double NOT NULL DEFAULT 0,
  `labour_cost` double NOT NULL DEFAULT 0,
  `overhead_cost` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `editable` tinyint(1) NOT NULL DEFAULT 0,
  `depreciation_method` char(1) NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `depreciation_factor` double NOT NULL DEFAULT 0,
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `show_item_in_invoice` int(1) NOT NULL,
  `serial_num` int(100) NOT NULL,
  `description_arabic` varchar(100) NOT NULL,
  `hot_key` int(11) NOT NULL,
  `inc_crm` int(11) NOT NULL,
  `inq_type` varchar(100) NOT NULL,
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('01', '2', '1', 'Item', '', 'NOS', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '120', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('D-001', '1', '2', 'Delivery Charges Non Taxable', '', 'QTY', 'D', '21018', '5010', '1510', '5040', '1530', '0', '0', '180', '180', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('E-0100', '1', '2', 'Etisalat Expense Non taxable', '', 'QTY', 'D', '21049', '21049', '1510', '5040', '1530', '0', '0', '144.8', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('EP001', '2', '1', 'External Painting (sqm)', '', 'SQM', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('EP002', '2', '1', 'External Painting (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('EW001', '2', '1', 'Electrical Work (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('I-001', '2', '1', ' S T G Pvc Trunking 25 X 16 m', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0013', '2', '1', 'Gazelle Curved Claw Hammer 20 oz G80167', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '200', '193.26923076923', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-002', '2', '1', '13A 2 Gang Single Pole Swith Double Socket -Clad', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '500', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-003', '2', '1', 'National Steel Putty 1.5kg', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '22', '22', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-004', '2', '1', 'Jotun fenomastic Matt 0486 1Ltr', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '57', '49.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0049', '2', '1', 'TOA Sand paper Grit 220', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-005', '2', '1', 'Jotun fenomastic Matt 5489 1Ltr', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '53', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0050', '2', '1', 'Mal Mal', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0051', '2', '1', 'Berger royal atmos health shield  WO Base 3.6 Ltr', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '135', '135', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0052', '2', '1', 'BERGER ROYALE ATMOS WO BASE 17.5LTR', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0053', '2', '1', 'Berger Allinone Hi-Gloss 555N Nobel Green 0.9L', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '18', '18', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0054', '2', '1', 'Berger Royale Matt Emulsion White (Drm)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '272', '272.23333333333', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0055', '2', '1', 'DUNET Shade Net Green 73% China 3 x 50 Mtr', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '340', '340', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0056', '2', '1', 'Gypsum screw 6x1', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0057', '2', '1', 'Gypsum Screw 6x1.1/4', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0058', '2', '1', 'Gypsum screw 8x1', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0059', '2', '1', 'Gypsum Sheet (4x8 ft)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-006', '2', '1', 'Jotun fenomastic Matt S055 Y10', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '160', '108.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0060', '2', '1', 'Jotun Enamel Matt Ral 9016 (Ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '57', '57', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0061', '2', '1', 'PVA Primer White Bergercoat (5 USG)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0062', '2', '1', 'Safety Shoes Executive M003 # 40', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0063', '2', '1', 'XPERT MASKING TAPE 2 &quot; 30YRD', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '2.78', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0064', '2', '1', 'Xpert Paint Brush Reg. Blue Handle 3&quot; (1070)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '4.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0065', '2', '1', 'Berger Royale smart clean W0 Base 18 ltr', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '310', '311.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0066', '2', '1', 'Milano Tarki Shower Mixer + Shower 140100100231', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '145', '145', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0067', '2', '1', 'Expansion Plug Green  1.5&quot; x 7mm  25pcs/set', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0068', '1', '2', 'Repair Maintenance R-45327 -Vehicles Non Taxable', '', 'QTY', 'D', '21056', '5010', '1510', '5040', '1530', '0', '0', '100', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0069', '1', '2', 'Repair MaintenanceP-56609 -Vehicles Non Taxable', '', 'QTY', 'D', '21055', '5010', '1510', '5040', '1530', '0', '0', '470', '-15', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-007', '2', '1', 'Aluminium Extension Rod 2mtr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '25', '25', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0070', '2', '1', 'Painting  Work (SQM)', '', 'SQM', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0071', '2', '1', 'Joint Tape', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0072', '2', '1', 'Boral Joint Compound', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0073', '2', '1', 'Berger Special Value Red Oxide Primer(1ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '9.9', '9.9', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0074', '2', '1', 'METAL CUTTING WHEEL 100X3X16 T27 DWA4520IA-AE', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0075', '2', '1', 'Miscellaneous  Cash purchase item Taxable', '', 'QTY', 'B', '5020', '5010', '2022', '5040', '1530', '0', '0', '40', '176.75625', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0076', '2', '1', 'Caparol Capa Ultra Matt  (Gal)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '78', '78', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0077', '2', '1', 'Scrapper 4&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4', '4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0078', '2', '1', 'Touchwood Wood Stain Mahogany (1 Ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '31.5', '31.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0079', '2', '1', 'Deer Paint Remover 400ml', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10', '10', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-008', '2', '1', 'Brass Reducer Bush 1/2 x 3/4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '7.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0080', '2', '1', 'TOA Sand Paper Grit # 120', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0081', '2', '1', 'Xpert Paint Brush Reg. Blue Handle 2&quot; (1050)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0082', '2', '1', 'Masking Tape 2&quot;', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2.85', '2.85', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0085', '2', '1', 'A P  Berger Royale Marmorino Fine R4074A (CW 9455) Cement Finish) 20 kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '261.9', '261.9', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0086', '2', '1', 'Berger Royale Matt Emulsion Base W0 18Ltr (Drm)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0087', '2', '1', 'Xpert SS Decor Trowel 240 x 90mm # SB405-B', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '45', '45', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0088', '2', '1', 'Water Proof Paper Captain Grit-220 ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0089', '2', '1', 'Water Proof Paper Captain Grit-120', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-009', '2', '1', 'Denim Brush Wood SB-L03', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0090', '2', '1', 'A P Berger Royale play Rust Protective Clear Coat ( Ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0091', '2', '1', 'A P Berger  Royale play Artistica Clay White  20kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0092', '2', '1', 'LLAZA Awning Complete Pro 350', '', 'QTY', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '2600', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0093', '2', '1', 'Berger Royale play najam silver 1 kg', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '10.8', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0094', '2', '1', 'Vaultex  Safety vest fabric ORB Yellow  L', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0095', '2', '1', 'Berger Royale Matt Emulsion Base W1 (Ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '35', '17.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0096', '2', '1', 'PVA Primer White Bergercoat (1 USG)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '13.95', '13.95', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0098', '2', '1', 'Select Medium Texture White 5 Usg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '32.4', '90.2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0099', '2', '1', 'Dr. Fixit  Sausage silicon 600 gm White', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '10.428571428571', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-010', '2', '1', 'Dewalt SDS Plus Drill Bit - 12mm x 150mm x 200mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '13', '13', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0100', '2', '1', 'Terminator Terminal Connector Block 20A #TTB20A  ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0101', '2', '1', 'Teflon Tape White 1&quot; ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.25', '1.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0102', '2', '1', 'Expansion Plug Green  1.5&quot; x 7mm  25pcs/set', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0103', '2', '1', 'Gypsum Screw 8x1.1/2 (pkt)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0104', '2', '1', 'Gazelle 4.5 In. Metal Cutting Disc (115mm), Ultra Thin GTD115-HD', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2.5', '2.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0105', '2', '1', 'Safety Shoes Vaultex M003 43&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '55', '55', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0106', '2', '1', 'SS Drill Bit 12mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0107', '2', '1', 'GIFFEX JUNCTION BOX 100X100X50 IP65', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '8', '8', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0108', '2', '1', 'SDS Drill Bit 12mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20', '20', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0109', '2', '1', 'Safety Specticles SP1401 Tinted', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-011', '2', '1', 'DW00736-AE', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '25', '25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0110', '2', '1', 'Berger Royale Silk Emulsion White (Drm) ', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '309', '309', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0111', '2', '1', 'Sauleda Acrylic Canvas 2038 Beige 120CM', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '70', '70', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0112', '2', '1', 'Florence Panle Light  White  595 x 595', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '55', '55', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0113', '2', '1', 'Stanley Screw Driver 3X50 (Tester) 66119  ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0114', '2', '1', 'SS Flex Hose 60cm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6.5', '6.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0115', '1', '2', 'Sponsorship fee  Non Taxable', '', 'QTY', 'D', '21031', '5010', '1510', '5040', '1530', '0', '0', '15000', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0116', '2', '1', 'Webber Premix SP 33 50kg', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '34', '34', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0117', '1', '2', 'Vehicle Renewal Expense Non Taxable', '', 'QTY', 'D', '21034', '5010', '1510', '5040', '1530', '0', '0', '410', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0118', '1', '2', 'Network Charges Expense', '', 'QTY', 'D', '21026', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0119', '2', '1', 'Pe Tarpaulin 280 Gsm  MTR', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-012', '2', '1', 'Fevicol Dr. Fixit Crack X Powder (Pkt)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10', '10', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0120', '2', '1', 'Aluminum Extension Rod 3mtr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '30', '30', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0121', '2', '1', 'A P Berger Robbiathane Matt  RAL 4005 Blaulila 20 Ltr', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '590.4', '590.4', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0122', '2', '1', 'Terminator Terminal Connector Block 20A #TTB20A ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0123', '2', '1', 'Insulation Tape White', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.25', '1.25', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0124', '2', '1', 'Round Light APS', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '14', '14', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0125', '2', '1', 'Battery 9V', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5.5', '5.5', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0126', '2', '1', 'Door Lock APS', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '32', '32', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0127', '2', '1', 'Thinner Berger Solvalux 7-45 (5 USG) ', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '251', '251', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0128', '2', '1', 'Jubliee Hose Clip # 00', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.25', '1.25', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0129', '2', '1', 'MAPEI MAPESET WHITE TILE GLUE 20KG ', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15.5', '15.5', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0130', '2', '1', 'A P Berger Road Marking Paint White  18 LTR', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0131', '2', '1', 'Yato Spray Gun with Metal Cup 1 Ltr (YT-2346)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0132', '2', '1', 'Fuerza pad lock crome plated PC PGL 75', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0133', '2', '1', 'Berger Epoxy Putty with Hardner (5L) ', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0134', '2', '1', 'Paint Roller Refil &#039;Cristin&#039; Velour 9&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0135', '2', '1', 'Milano W/C with tank  trap white ( code 1058)', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '280', '280', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0136', '2', '1', 'Brass Reducer Bush 1/2&quot; x 3/8&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2.5', '2.5', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0137', '2', '1', 'Berger Value Stucco Extra Mix (18 Ltr)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0138', '2', '1', 'Relite Flexible cable Turkey  1.5mm x 3 Core  Mtr', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0139', '2', '1', 'National S/C Wire Red 2.5MM', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-014', '2', '1', 'Gazelle Platform Trolley - Steel Bed W/ Folding Hsndle 720 x 490 mm G2501', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '300', '300', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0140', '2', '1', 'National S/C Wire Black 2.5MM ', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0141', '2', '1', 'National S/C Wire Y/G 2.5MM 95mtr ', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0142', '2', '1', '3X6 GI BOX INDIA H/D', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0143', '2', '1', '3X3 GI BOX INDIA', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0144', '2', '1', 'National S/C Wire Y/G 4MM ', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0145', '2', '1', 'National S/C Wire BLACK 4MM  ', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0146', '2', '1', 'National S/C Wire RED 4MM', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0147', '2', '1', 'Bandex Cable Ties White 300 x 3.6', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0148', '2', '1', 'Wire Puller ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', 'ًهقث ؛عممثق ', '0', '0', ''),
('I-0149', '2', '1', 'DD Female Adaptor 20mm Black #DFA2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-015', '2', '1', 'Gazelle Voltage Tester G80365', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5.5', '5.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0150', '2', '1', '20MM PVC SLIP TYPE BEND DD DLB2 ', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0151', '2', '1', '20MM PVC COUPLER DD DNC2 ', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0152', '2', '1', 'DD Spacer Saddle 20mm #DSB2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0153', '2', '1', 'Spring Bender', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0154', '2', '1', '20MM PVC COMDUIT PIPE DD 1.6 DCH2   ', '', 'Lgth', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0155', '2', '1', 'A P  Berger  Value Super emulsion  off white   20 kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0156', '2', '1', 'National S/C Wire Blue 2.5MM ', '', 'yards', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0157', '2', '1', 'A P Berger W/Coat Stone Shield  White 23 kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0158', '2', '1', '25MM PVC CONDUITE DD 1.8 DCH3 ', '', 'Lgth', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0159', '2', '1', 'DD Spacer Saddle 25mm #DSB3 ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-016', '2', '1', 'Jotun Jota Floor Epoxy Paint Ral 9010 (1USG)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '245', '245', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0160', '2', '1', 'DD Female Adaptor 25mm Black #DFA3', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0161', '2', '1', '25MM PVC COUPLER DD DNC3 ', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0162', '2', '1', '25MM 4 WAY PVC J/BOX DD DJF3', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0163', '2', '1', 'Pvc Junction box 25mm   3 Way', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0164', '2', '1', 'Ap Berger Royale Play Artistica Concrete 20kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0165', '2', '1', ' Ap Berger Royale Play Artistica  Clay  20kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0166', '2', '1', ' Ap Berger Royale Play Artistica Rust - Base Coat 1 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0167', '2', '1', 'Ap Berger Royale Play Artistica Copper Breeze - Base coat 1 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0168', '2', '1', 'Ap Berger Royale Play Artistica Rust Topcoat 1 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0169', '2', '1', 'Ap Berger Royale Play Artistica Copper Breeze - Topcoat  0.5 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-017', '2', '1', 'Llaza Awning Complete PRO 350 3.00 x 2.5 mtr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2300', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0170', '2', '1', 'AP Berger Royale Play Artistica Rust Protective Coat 1 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0171', '2', '1', 'AP Berger Royale Play Artistica Protective Coat / Colour Wash 1 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0172', '2', '1', 'Ap Berger Royale Play Artistica Metallica 0.5kg ', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0173', '2', '1', 'Xpert Decor File Scrapper FS10 10&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0174', '2', '1', 'A P Berger Tuff AR Primer Clear  23kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0175', '2', '1', 'A P Berger Marmorino Fine White 20 Kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0176', '2', '1', 'Industrial  Welding Goggle B/G ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0177', '2', '1', 'VERMONT GRIT 120', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0178', '2', '1', 'Berger Royale Matt Emulsion Base W1 (GAL)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0179', '2', '1', 'Xpert Decor blue foam paint roller mini sleeves 4&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-018', '2', '1', 'Llaza Awning Complete PRO 350 4.30 x 2.5mtr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2450', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0180', '2', '1', 'Paint Roller Refil &#039;Cristin&#039; Toptex 9&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0181', '2', '1', 'A P Berger Royal Matt Emulsion W2 Base 18 Ltr', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0182', '2', '1', 'Terraco Gypsum Joint Compound (28KG)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0183', '2', '1', 'LLAZA AWNING REPAIR', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0184', '2', '1', 'Switch Two Way  gang', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0186', '2', '1', 'Switch 4  gang', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0187', '2', '1', 'Relite LED Ceiling light white  60x60', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0188', '2', '1', 'CSK self drilling screw 6x1.25', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0189', '2', '1', 'CSK self drilling screw 6x1   1000 pkt', '', 'Packet', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-019', '2', '1', 'Makita SDS plus Drill Bit - 14mm 260mm x 200mm D-00664', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '14', '14', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0190', '2', '1', '100 x  100 x 50 mm Waterproof Box ', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0191', '2', '1', 'Connector stop 10mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0192', '2', '1', 'Connector stop 16mm ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0193', '2', '1', 'Italian Stucco Xpressions W1 Base (1.4 Kgs) ', '', 'Can', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0194', '2', '1', 'Italian Stucco Xpressions W1 Base (14 Kg)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0195', '2', '1', 'Robustline Lever Handle  Narrow White LW-246 ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0196', '2', '1', 'Berger Tuff Exterior - White (5 Kgs)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0197', '2', '1', 'JOTUN JOTASHIELD COLORLAST MATT 10394 16.20 LTR', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0198', '2', '1', 'Dunet Commercial 95 Desert Sand Roll 3 x 50 meter', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0199', '2', '1', 'PVC Curtain Strip 200 x 2 mm (50 Mtr / Roll)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-020', '2', '1', 'Xpert Stretch Wrapping Film Clear (1.8KG)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0200', '2', '1', 'A Stainless Steel Hanger 1020mm (Pcs)', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0201', '2', '1', 'B Stainless Steel Plate 200mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0202', '2', '1', 'Jotun Fenomastic Matt 18LTR', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0203', '2', '1', 'Universal Sleeve Semi Smooth 9&quot; # UP9SS1.75', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0204', '2', '1', 'Ap Berger Wood Primer  Gln', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0205', '2', '1', 'Weathercoat stone sheild  primer 18LTR', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0206', '2', '1', 'Berger Royale Matt Emulsion WO Base. Gal', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0207', '2', '1', 'Steel Eyelet #3 (12mm) Turkey 500 Pcs/Pkt', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0208', '2', '1', 'PP Webbing 2&quot; x 50m Pakistan', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0209', '2', '1', 'Hole Punch 13mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-021', '2', '1', 'Xpert Paint Brush Wooden Handle 4 (2100)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0210', '2', '1', 'Eyelet Die #3 (12mm) Turkey', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0211', '2', '1', 'AP Berger Apcolite Advanced DRUM', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0212', '2', '1', 'Cusbor Polyester HT T20 250 Gr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0213', '2', '1', 'Fix Bolt 6mm Box', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0214', '2', '1', 'A P Royale Luxury Matt RED GAL', '', 'GLN', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0215', '2', '1', 'LLAZA Awning Monobloc 350 ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0216', '2', '1', 'LLAZA Awning Storbox 300 Grey', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0217', '2', '1', 'Ispat Leather Safety Shoes Executive ASG1 #42', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0218', '2', '1', 'Ispat Leather Safety Shoes Executive ASG1 #43', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0219', '2', '1', 'Safety Vest Fabric Type Yellow/green Per4mer L', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-022', '2', '1', 'Xpert Decor Yarn Tool # YT1515/SB-P03', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '35', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0220', '2', '1', '56089090 Dunet Bird Net Black 5 x 100 meters Roll', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0221', '2', '1', 'Dunet Bird Net White 5 x 100 meters Roll', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0222', '2', '1', 'DUNET Shade Netting 90% Monofilament Green Vietnam 3 x 50 Mtr', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0223', '2', '1', 'Stitching Job', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0224', '2', '1', 'BERGER ROYALE MATT EMULSION BASE N(LTR)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0225', '2', '1', 'Berger Tuff Exterior W1 Base Ltr', '', 'Liter', 'B', '5050', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0226', '2', '1', 'AP Berger Smart Care Waterproofing Damp block 2K 15kg', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0227', '2', '1', 'Llaza Arond-350 Support Set #20110000001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('i-0228', '2', '1', 'Select Fine Texture White (18 Ltr)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0229', '2', '1', 'LLAZA A/S Onyx-400 2.5M #10002250001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-023', '2', '1', 'Xpert Decor Plastic Trowel SB-PT-1', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0230', '2', '1', 'LLAZA A/S Onyx-400 1.5M #10002150001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '');
INSERT INTO `0_stock_master` VALUES
('I-0231', '2', '1', 'LLAZA A/S Onyx-400 3.0M #1000230001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0232', '2', '1', 'LLAZA A/S Onyx-400 3.0 #1000230001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0233', '2', '1', 'LLAZA Universe 280 front profile 6 Mtrs', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0234', '2', '1', 'LLAZA U280 Plastic Caps Kit #14003010001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0235', '2', '1', 'LLAZA Front Profile Connectors #19002021001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0236', '2', '1', 'LLAZA MB-9 Gearbox L-130 #21008016001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0237', '2', '1', 'LLAZA Crank ST 1.70m #13006170001', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0238', '2', '1', 'LLAZA P-801 Rolling Tube 80x1.2 7.00 GV #31080700044', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0239', '2', '1', 'LLAZA Gear End Bearing Axis 35MM/80 #12080009000', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-024', '2', '1', ' Xpert Decor Plastic Trowel 26x7cm # SB-PT-B', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '12', '12.6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0240', '2', '1', 'LLAZA Idle Side Bearing 80mm #12080003000', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0241', '2', '1', 'LLAZA Storbox 300 Support Set Grey #20001001909', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0242', '2', '1', 'LLAZA Storbox 300 3 Profiles 6M Grey #39086600909', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0243', '2', '1', 'LLAZA Art350 Arms 2.5M Grey #10045250909', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0244', '2', '1', 'LLAZA Art 350 Arms 3.00M Grey #10045300909', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0245', '2', '1', 'LLAZA Onyx-400 Arms Grey #1000240090', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0246', '2', '1', 'LLAZA Storbox 3000 Gearbox grey #20051033909', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0247', '2', '1', 'Dooya Tubular Motor DM45R/SF 50NM + DD2700H Remote', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0248', '2', '1', 'Berger Royale Smart clean WO Base 3.6LTR', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('i-0249', '2', '1', 'DUTARP PVC Coated Tarpaulin #FR2219 (72&quot; x 50Y)', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-025', '2', '1', 'Water Proof Paper Captain Grit-100', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0250', '2', '1', 'Berger Tuff Exterior WO base Drum', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0251', '2', '1', 'PVC Pipe 2&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0252', '2', '1', 'PVC Adaptor 50mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0253', '2', '1', 'Multi Meter', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0254', '2', '1', 'Promax W/P Fiber Mesh 1 x 25 Meters White', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0255', '2', '1', 'Blades LB 10', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0256', '2', '1', 'PVC Made Adaptor 1/2&quot; PPR Male Plug', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0257', '2', '1', 'PVC Pipe 1&quot; PPR pipe 20mm x 4 Meter', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0258', '2', '1', 'PVC Female socket 1&quot; PPR Socket 20 x 1/2&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0259', '2', '1', 'PPR Elbow 20mm x 90', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-026', '2', '1', 'UPVC Y 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '7.25', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0260', '2', '1', 'PPR Socket 20mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0261', '2', '1', 'PPR Elbow Female Elbow 20mm x 1/2&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0262', '2', '1', 'UPVC Tee 1- 1/2&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0263', '2', '1', 'UPVC Reducer Brush 2&quot; x  1 1/2&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0264', '2', '1', 'UPVC Bend 1.1/2&quot; (90 Degree)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0265', '2', '1', 'Ducab Wire 4 mm 100 Yds Roll - Black', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0266', '2', '1', 'Ducab Wire 4 mm 100 Yds Roll- Red', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0267', '2', '1', 'JOTUN FENOMASTIC EML MYHOME RICH MATT BASE A 3.6L 9003', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0268', '2', '1', 'Schneider Flex Outlet SW 13A + Neon +Fuse', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0269', '2', '1', 'Schneider Switch 1G 1 Way Avatar 16A White', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-027', '2', '1', 'Upvc Tee 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '7.25', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0270', '2', '1', 'CP Extension Nipple 1/2&quot; x 10mm Len  ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0271', '2', '1', 'Schneider Switch Socket 13A Single Avatar White', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0272', '2', '1', 'Schneider Switch Socket 13A double Avatar White', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0273', '2', '1', 'Asmaco Spray Paint Black Matt 400 ml ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0274', '2', '1', 'Stanley 9 Pcs Hexkey Set 92619-8 ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0275', '2', '1', 'Cut Resistant Gloves Grey Per4mer N10555', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0276', '2', '1', 'ACCESS PANEL 40x40cm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0277', '2', '1', 'Duct Tape', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '1', ''),
('I-0278', '2', '1', 'Safety Specticles SP5501 Clear', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0279', '2', '1', 'Dunet Comm. 95 Natural 3m x 50m', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-028', '2', '1', 'Universal Classic Paint Tray 9 UCPT9', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('i-0280', '2', '1', 'Berger Floor Guard Epoxy Topcoat Minerva Grey 295N 20L', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0281', '2', '1', 'Thinner Berger Solvalux 7-45 (1 USG)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0282', '2', '1', 'Caparol Capa Ultra Matt-Tundra 60   (Ltr)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0283', '2', '1', 'Caparol Capa Ultra Palazzo 145 (Ltr)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0284', '2', '1', 'Caparol CapaPlus Matt White (5 G)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0285', '2', '1', 'Machine Screw M4 x 20mm CSK  (Pkt)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0286', '2', '1', 'LLAZA Arond-350 Support Set #20110000001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0287', '2', '1', 'LLAZA A/S Onyx - 400 2.50M #10002250001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0288', '2', '1', 'LLAZA A/S Onyx - 400 1.5M #10002150001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0289', '2', '1', 'LLAZA A/S Onyx - 400 3.0M #1000230001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-029', '2', '1', 'Trowel 4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0290', '2', '1', 'LLAZA A/S Onyx - 400 3.5M #10002350001', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0291', '2', '1', 'Sauleda Acrylic Canvas #2235 ( Colour : Azul Real)', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('i-0292', '2', '1', 'Llaza Slender Stick 5.8mm (11005002001)', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0293', '2', '1', 'Brighto Texo Compound 18LTR', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0294', '2', '1', 'Brighto Acrylic Primer DRM 18 Ltr', '', 'Drum', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0295', '2', '1', 'Brighto Acrylic Rock Top Coat  3.6 Ltr', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0296', '2', '1', 'Stanley Measuring Tape 5Mtr    STHT 36194', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0297', '2', '1', 'Berger Select All in One Enamel (Drum)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0298', '2', '1', 'Dr.Fixit Raincoat UltraFlex White  18ltr ', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0299', '2', '1', 'DR Fixit Uniproof 4000 Water Proofing White (20KG) ', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-030', '2', '1', 'Tower HD Gross Foam Texture Roller Refil 4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2.1', '2.1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('i-0300', '2', '1', 'Gazelle Long Arm Imperial Hex Key Set G80133 ', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0301', '2', '1', 'Texture Gun', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0302', '2', '1', 'Jotun Jotashield eterna 1 Ltr', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0303', '2', '1', 'ROBUSTLINE GALVANISED ANGLE BRKT 40MMX40MMX15MMX1. 5MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0304', '2', '1', 'LLAZA ROLLING TUBE 80MM, 7M 31080700044 AWNING PROFILES', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-0305', '2', '1', '2 meter threaded rod 10mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-031', '2', '1', 'Terminator Terminal Connector Block 20A #TTB20A', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-032', '2', '1', 'STANLEY STANDARD SCREWDRIVER 1X100 MM STHT 60805-8', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10.5', '10.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-033', '2', '1', 'Stanley Standard Screwdriver (-) 100mm STHT65187', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '10.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-034', '2', '1', 'Stanley Combination Wrench 13MM #STMT80223-8B', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-035', '2', '1', 'Socket Wrench 1/4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '13', '13', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-036', '2', '1', 'SEGMENTED DIAMOND BLADE 115MM DW47452HP', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '22', '22', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-037', '2', '1', 'Segmented Diamond Blade 115mm DW 47451 HP', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20', '20', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-038', '2', '1', 'Scrapper 3', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4', '4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-039', '2', '1', 'Scrapper 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4', '4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-040', '2', '1', 'Ruko HSS Ground Tin Coated Drill Bit 8mm 250080T', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '13.666666666667', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-041', '2', '1', 'Ruko HSS Ground Tin Coated Drill Bit 9mm 250090T', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-042', '2', '1', 'Ruko HSS Drill Bit (214150) 15.0mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '30.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-043', '2', '1', 'Ruko HSS Drill Bit (214105) 10.5mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '25', '26', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-044', '2', '1', 'Ruko HSS Drill Bit (214090) 9.00mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '20', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-045', '2', '1', 'Ruko HSS Drill Bit (214060) 6.0mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-046', '2', '1', 'PVC Tee 3/4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-047', '2', '1', 'PVC Tee 1 1/2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '4.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-048', '2', '1', 'PVC Tee 1', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3.75', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-049', '2', '1', 'PVC Solvent Cement (Nos)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '22', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-050', '2', '1', 'PVC Reducer Bush 1 x 1/2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '4', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-051', '2', '1', 'PVC Pipe  3/4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '8.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-052', '2', '1', 'PVC Pipe 1', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '8.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-053', '2', '1', 'PVC Female Socket 3/4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2.75', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-054', '2', '1', 'MOP', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-055', '2', '1', 'Milano Flat Chisal 12 with guard', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '18', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-056', '2', '1', 'Milano Eagle Angle Valve 140800300221', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-057', '2', '1', 'Milano 13A2 gang single poles with Double socket-clad V4060', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-058', '2', '1', 'Milano 13A 1 Gang Switched Socket,Single Pole White V4050', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '9', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-059', '2', '1', '3X3 PVC SQUARE COVER WHITE', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-060', '2', '1', 'extensible hose 1-1/4&quot;(w/o rosete)1.0-80 160pcs/ctn', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-061', '2', '1', 'Mal Mal 15 Yard', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20', '20', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-062', '2', '1', 'Milano 2 Gang 2 Way 210800100035 W/p', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '15', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-064', '2', '1', 'Disposable PE Shoe Cover Blue (100 Pcs/Pkt)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-065', '2', '1', 'DQ Steel Nail 1-1/2 (40mm)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-066', '2', '1', 'Gypsum Screw 4 x 10 (Pkt)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '40', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-067', '2', '1', 'Tile Spacer', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-068', '2', '1', 'Tile Spacer 2mm', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-069', '2', '1', 'Feet Guard Safety Shoes 402 High Ankle #41', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '57.2', '57.2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-070', '2', '1', 'Safety Shoes Executive M003 # 40', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '55', '53.6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-071', '2', '1', 'Safety Shoes Executive M003 # 41', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '55', '55', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-072', '2', '1', 'Bitumen sheet 4mm x 1.3 meter x 10meter', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '144', '144', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-073', '2', '1', 'Bubble Sheet', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '45', '45', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-074', '2', '1', 'Cotton Rope 12mm x 40yd', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '30', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-075', '2', '1', 'DD Corrugated/Flexible Conduit Black 20mm x 50Mtr', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '75', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-076', '2', '1', 'Kedder 8mm 200mtr', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '700', '700', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-077', '2', '1', 'LED strip Light D/L - Selex 50 mtr', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '225', '225', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-078', '2', '1', 'Line Dori Red Colour', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-079', '2', '1', 'Line Dori White', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-080', '2', '1', 'Synthesis Commercial 95 Desert Sand 3m x 40m', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1875', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-081', '2', '1', 'Hand Tape', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20', '20', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-082', '2', '1', 'Llaza Splenbox 400 Grey (3 Mtr Projection)', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5500', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-083', '2', '1', 'Xpert Decor Artist Brush Set (18 Pcs) # AB18', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '30', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-084', '2', '1', 'Xpert Decor Scrapper Set WHSS (50+80+100+120 MM)', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '12', '11.8', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-085', '2', '1', 'AP Berger Bitumen Emulsion 15k', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '36.9', '36.9', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-087', '2', '1', 'AP Berger Bitumen Emulsion 15kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '272', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-089', '2', '1', 'Berger Tuff Exterior W1 Base 27kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '270', '309', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-090', '2', '1', 'Berger Value Gypsum Joint Compound 25 Kgs/Drum', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '48.6', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-091', '2', '1', 'Acid', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '20', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-092', '2', '1', 'A P Berger A R Primer  1 USG', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20.7', '86.625', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-093', '2', '1', 'Berger Royale Matt Emulsion Black (Gal)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '72', '91.725', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-094', '2', '1', 'Berger Select All in One Enamel White 000 (3.5 Ltr)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '61.8', '51.45', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-095', '2', '1', 'Berger Special Value Red Oxide Prime(1USG)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '31.5', '31.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-096', '2', '1', 'Jotun fenomastic matt S0550 - Y10R', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '160', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-097', '2', '1', 'Jotun Hardtop Coat XP S 4050-Y80R (1USG)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '210', '210', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-098', '2', '1', 'Jotun pen guard top coat black', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '240', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-099', '2', '1', 'Jotun Pen Guard Top Coat S4050-Y80 R (1 USG)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '240', '224', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-100', '2', '1', 'Thinner Berger Universal E55', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '38.7', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-101', '2', '1', 'Dr.Fixit Silicone Sealant 501 S.S GPS-WH (280GM)', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '7', '6.5769230769231', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-102', '2', '1', 'Italian Stucco White Xpressions (5 Kgs)', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '70.2', '70.2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-103', '2', '1', 'Berger Royale Matt Emulsion Base W0 (Ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '43', '30.83', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-104', '2', '1', 'Berger Select All in One Enamel White 000 (1 Ltr)', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '18', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-105', '2', '1', '13 Amp Single Switch Socket', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-106', '2', '1', '20A DP Switch for FCU (Relite)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '55', '55', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-107', '2', '1', '2G 1W Switch', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-108', '2', '1', 'Bosch Grinding Wheel 2608603181', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-109', '2', '1', 'Cargo Lashing 2x10mtr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '30', '30', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-110', '2', '1', 'Cusbor Bonded Red Polyester Thread', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '85', '85', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-111', '2', '1', 'Cutting Disc Metal 4-1/2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10', '10', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-112', '2', '1', 'Fevicol Super Glue (3 Grm)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.25', '1.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-113', '2', '1', 'Fischer Chemical FIS VS Low', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '62', '62', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-114', '2', '1', 'Gazelle Plastic Snap- off Knife G 80105', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-115', '2', '1', 'Half Round File 6', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-116', '2', '1', 'Milano Deluxe White Shattaf Set 140200100223', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '24', '24', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-117', '2', '1', 'MTX Tile Drill Bit #728149 Size 4MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3.5', '3.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-118', '2', '1', 'MTX Tile Drill Bit #728169 Size 6MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-119', '2', '1', 'Paint Brush Harris 1.5', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3.5', '3.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-120', '2', '1', 'Plumb Bob', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-121', '2', '1', 'PVC Box 3X3', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-122', '2', '1', 'Safety Helmet Per4mer 141 Yellow', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '8', '10', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-123', '2', '1', 'Safety Vest Net Typr Yellow/green Per4mer VMT01 L', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-124', '2', '1', 'Scissors', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '13', '13', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-125', '2', '1', 'Silicone Gun', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-126', '2', '1', 'Soft Broom', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10', '10', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-127', '2', '1', 'Teflon Tape White 1', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-128', '2', '1', 'Tester', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4', '4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-129', '2', '1', 'Universal Classic Paint Tray 9 UCPT9', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-130', '2', '1', 'W/C Seat Cover', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '95', '95', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-131', '2', '1', 'WD-40 Aerosol 330ml', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '12', '12', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-132', '2', '1', 'Garbage Bag (Pkt)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-133', '2', '1', 'Safety Shoes Executive M003 # 43', '', 'PRS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '51.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-134', '2', '1', 'APBerger Smart Care Waterproofing Damp block 2K 3kg', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '27', '27', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-135', '2', '1', 'Cement OPC / Black', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '13.5', '14.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-136', '2', '1', 'A P Berger Marmorino Smooth A643 20kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '280.8', '280.8', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-138', '2', '1', 'A P Berger Bariq Almas Silver 4 KG', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '108', '108.51428571429', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-139', '2', '1', 'Berger Hi-Gloss Enamel Base W0 1 USG', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '76.5', '76.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-140', '2', '1', 'Berger Royale Play Najam Silver Base 3.6 LTR', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '104.4', '104.4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-141', '2', '1', 'Gi Nut 10mm Kg', '', 'Killogram', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '14.117647058824', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-142', '2', '1', 'Cotton Rags White Unstitched', '', 'Bale', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '60', '55.556666666667', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-143', '2', '1', 'Spray Paint White', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-144', '2', '1', 'Berger Universal Thinner E55 Clear 0.9 Ltr', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10.8', '11.07', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-145', '2', '1', 'DEWALT 115MM DIAMOND BLADE TILE DX3121', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '49', '49', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-146', '2', '1', 'Terminator Terminal Connector Block 10A #TTB10A', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4', '3.8571428571429', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-147', '2', '1', 'UPVC Pipe 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '16', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-148', '2', '1', 'Upvc Socket 2', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-149', '2', '1', 'Corrugated Paper Roll', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '40', '40', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-150', '2', '1', 'Tile Grout APS (Bag)', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '105', '75', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-151', '2', '1', 'Jotun pen guard primer gallon', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '204', '204', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-152', '2', '1', 'Berger Tuff Exterior Wo Base Ltr', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '22.5', '24.16888888889', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-153', '2', '1', 'Aluminum Profile 1669 Single 6 Mtr', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '35', '35', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-154', '2', '1', 'Connector APS', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6.25', '6.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-155', '2', '1', 'Holder', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-156', '2', '1', 'Milano Deluxe Chrome Shattaf Set 140200100224', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '28', '28', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-157', '2', '1', 'MTX Tile Drill Bit #728159 Size 5MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-158', '2', '1', 'PVC Box 3 x 6', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3.3333333333333', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-159', '2', '1', 'PVC Elbow 3/4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2.75', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-160', '2', '1', 'Xpert Paint Brush Reg. Blue Handle 4 (1100)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '4.1636363636364', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-161', '2', '1', 'Self bracket white 10x12', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-162', '2', '1', 'Opp tape clear 2x80 yard', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '');
INSERT INTO `0_stock_master` VALUES
('I-163', '2', '1', 'Teflon Tape Stower 1', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.25', '1.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-164', '2', '1', 'Safety Specticles SP1401 Hook Tinted', '', 'ST', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15', '15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-165', '2', '1', 'Berger Tuff Exterior Wo Base-5KG', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '67.5', '191.37857142857', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-166', '2', '1', 'Berger Value Stucco Extra Mix (3.5 Ltr)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15.3', '19.95', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-167', '2', '1', 'Fevicol HeatX (3.8L)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '105', '105', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-168', '2', '1', 'Berger Universal Thinner (E55) Clear 1usg', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '38.7', '34.788461538462', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-169', '2', '1', 'A P Berger silicon Sealent G P Clear 280 ml', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '7', '7.7333333333333', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-170', '2', '1', 'Insulation Tape Black', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.25', '1.1666666666666', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-171', '2', '1', 'Magnetic Ballast 36 W', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '14', '14', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-172', '2', '1', 'Paint Filter', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.6', '0.6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-173', '2', '1', 'PVC Elbow 1', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3.3', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-174', '2', '1', 'Silicon Dow Corning 799 Clear 310 ml', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '30', '30', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-175', '2', '1', 'Star Drill Bit 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2.5', '2.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-176', '2', '1', 'Synthesis Commercial 95 deep ochere 3x40 Mtr.', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1500', '1500', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-177', '2', '1', 'Cement White  kg', '', 'Killogram', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-178', '2', '1', 'Anchore Bolt 6 12mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3.7', '3.7', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-179', '2', '1', 'PVC Bend 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3.83', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-180', '2', '1', 'Xpert Polythene Sheet 500g (1.3KG Green)', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '7', '13.12625', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-181', '2', '1', 'AP Berger Tile Glue General Purpose White 20 Kg', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '13.5', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-182', '2', '1', 'Berger Tuff Exterior Matt - White (27Kg)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '269.1', '269.1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-183', '2', '1', 'Berger Royale Matt Emulsion White (Gal)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '72', '169.82916666667', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-184', '2', '1', 'hook bolt M10X70MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-185', '2', '1', 'hook bolt M12X90MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3.25', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-186', '2', '1', 'Paint Roller Cristin Mini Complete 4&quot;', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-187', '2', '1', 'Terminator LED Bulb 5W E27 Day Light #TLEDB-5W', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6.5', '6.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-188', '2', '1', 'Berger Royale Smart clean WO Base 1 LTR', '', 'Liter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '11.25', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-189', '2', '1', 'LED Spot Light Fitting 7W-D/L MR 16', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '13', '13', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-190', '2', '1', 'MTX Tile Drill Bit #728139 Size 3MM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-191', '2', '1', 'Cabinet Hydraulic Hinges A Type', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '7.5', '7.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-192', '2', '1', 'SS hose 60cm red and blue line', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6', '6', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-193', '2', '1', 'Berger Royale Matt Emulsion Base N 3.6 (Gal)', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '75.83', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-195', '2', '1', 'PVC Bucket (Nos)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5.8140740740741', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-196', '2', '1', 'Terminator Top Plug with Fited TTP -13AB', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-197', '2', '1', 'Gypsum Powder(Pkt)', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '2.8333333333334', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-198', '2', '1', 'Uken Tighter Bit U1575 PH2x 50mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.5', '1.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-199', '2', '1', 'Water Proof Paper Captain Grit-220', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-200', '2', '1', 'Nut+ Bolt', '', 'Killogram', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '12.67', '13.03135734072', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-201', '2', '1', 'Bison Kit 650ml / Can', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '18', '18', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-202', '2', '1', 'Black Cat Paint Roller Handle 9&quot; BC9H1.75SG', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '4.9137931034483', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-203', '2', '1', 'Ceiling Tile 600x600 APS', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4.75', '4.75', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-204', '2', '1', 'L Bracket 1-1/2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-205', '2', '1', 'Sand Paper 120', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-206', '2', '1', 'Tube Light Starter-S2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1.55', '1.55', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-207', '2', '1', 'Tube Rod 2', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3.75', '3.75', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-208', '2', '1', 'Water Proof Paper Captain Grit-400', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-209', '2', '1', 'Xpert Decor Sanding Disc with Holes 7 Grit 120', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-210', '2', '1', 'Xpert Decor velour paint roller mini sleeves 4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '2.7138888888889', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-211', '2', '1', 'Yellow Bucket', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '8', '8.0816326530612', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-212', '2', '1', 'Through Bolts (Wedge Achors) 8x60', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-213', '2', '1', 'Sauleda Acrylic Canvas #2687 ( Colour : Vanilla)', '', 'Meter', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '40', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-214', '2', '1', 'Width 120 cm.', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1.1316666666667', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-215', '2', '1', 'Fix Bolt 12mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1.58', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-216', '2', '1', 'Anchor Bolt (As Per Sample)', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1.63', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-217', '2', '1', 'Bosch SS Cutting Disc 1MM X 4.5 Inch2608603169', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-218', '2', '1', 'CSK self drilling screw 8x1', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.04', '0.04', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-219', '2', '1', 'Fix Bolt 10mm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '35', '1.5384615384616', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-220', '2', '1', 'Gazelle 8x11 In. Waterproof Sandpaper Sheets, 120 Grit GWP 120', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20', '1.0940594059406', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-221', '2', '1', 'Masking tape 2 x 30 yard', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '2.7216603773584', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-222', '2', '1', 'MS Nut M4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.25', '0.25', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-223', '2', '1', 'P P Guny Bag 60x100 Cm', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1.1275', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-224', '2', '1', 'Xpert Decor Acrylic Paint Roller Mini Sleeves 4', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1.1066176470588', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-225', '2', '1', 'Fevicol HeatX (650ML)', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '17', '17', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-226', '2', '1', 'Xpert Polythene Sheet 200g (0.8KG Yellow)', '', 'Roll', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '8', '8', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-227', '2', '1', 'hex head self drilling screw 14x2', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.18', '0.18', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-228', '2', '1', 'gypsum screw 6x1.1/2', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0.1', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-229', '2', '1', 'Tuff-fix gypsum screw DSF8x3', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.11', '0.11', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-230', '2', '1', 'gypsum screw 6x2', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '0.04550499445061', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-231', '2', '1', 'gypsum screw 8x3/4', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.08', '0.12430632630411', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-232', '2', '1', 'gypsum screw 8x2.1/2', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.05', '0.05', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-233', '2', '1', 'Hex Head Self Drilling Screw 14x1', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.15', '0.15', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-234', '2', '1', 'CSK self drilling screw 8x.05', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.03', '0.03', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-235', '2', '1', 'Gypsum Screw 8x1.1/2', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.05', '0.05', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-237', '2', '1', 'gypsum screw 8x2', '', 'Pieces', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0.05', '0.05', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-238', '2', '1', 'Painting Job', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-241', '1', '1', 'Etisalat Expense- Taxable', '', 'QTY', 'D', '21048', '5010', '1510', '5040', '1530', '0', '0', '133.4', '93.139393939397', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-242', '1', '1', 'Repair MaintenanceP-25757 -Vehicle taxable', '', 'QTY', 'D', '21052', '5010', '1510', '5040', '1530', '0', '0', '40.01', '244.3775', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-243', '1', '1', 'Vehicle Insurance Expenses - Taxable', '', 'QTY', 'D', '21011', '5010', '1510', '5040', '1530', '0', '0', '780', '799.5', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-244', '1', '1', 'Marketing Expense-Taxable', '', 'QTY', 'D', '21009', '5010', '1510', '5040', '1530', '0', '0', '600', '600', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-245', '2', '1', 'Purchases Cash- Taxable', '', 'QTY', 'B', '2022', '5010', '1510', '5040', '1530', '0', '0', '100.1', '1393.0355555555', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-247', '2', '1', 'Al Baraa Nov2022(2022-16)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-248', '1', '2', 'Vehicle Insurance Expense Non Taxable', '', 'QTY', 'D', '21075', '5010', '1510', '5040', '1530', '0', '0', '1092', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-249', '1', '1', 'Repair MaintenanceP-56609 -Vehicles Taxable', '', 'QTY', 'D', '21077', '5010', '1510', '5040', '1530', '0', '0', '125', '125', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-250', '2', '1', 'Caesars Palace INV 2890 ( JAN ', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1', '1', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-251', '1', '2', 'Post Office Expense Non Taxable', '', 'QTY', 'D', '21028', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-252', '2', '1', 'Sofitel -Awning Oct 2022 (2022', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '15.4', '15.4', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-253', '1', '2', 'Traffic Fines', '', 'QTY', 'D', '1888', '5010', '1510', '5040', '1530', '0', '0', '100', '150', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-254', '2', '1', 'Abdul Aziz Jan 23(2023-001)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-255', '2', '1', 'Hammer ( Owners Apartment ) De', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-256', '2', '1', 'Universal Paint Brush Single 3 UP1.75', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4', '4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-260', '1', '1', 'Office Supplies &amp; Stationery Taxable', '', 'QTY', 'B', '21006', '5010', '1510', '5040', '1530', '0', '0', '50', '735', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-261', '2', '1', 'Africa Online Jan 2023( 2023-0', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '66.67', '47.62', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-262', '2', '1', 'Black Cat Sleeve Extra Rough 9&quot; BC9ER1.75', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5', '5.0004', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-263', '2', '1', 'Dimple variation Oct 2022 (202', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-264', '2', '1', 'BEREGER ROYAL MATT EMULSION W2 Base 1USG', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '90', '78.75', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-266', '2', '1', 'Nasab Office Paint Jan 23( 202', '', 'QTY', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-267', '2', '1', 'Hammer Jumeirah Bay Nov 22 (20', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '310', '564.5', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-268', '2', '1', 'Aparna Varma Oct 22', '', 'QTY', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-269', '1', '2', 'Air Tickets Expenses', '', 'QTY', 'D', '21014', '5010', '1510', '5040', '1530', '0', '0', '1780', '1177.5', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-270', '2', '1', 'Al Baraa (Palm Jumeirah) Nov 2', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20.95', '605.095', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-271', '1', '1', 'salik expense -34004496', '', 'QTY', 'D', '21060', '5010', '1510', '5040', '1530', '0', '0', '200', '200', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-273', '1', '1', 'Visa Processing Charges - Taxable', '', 'QTY', 'B', '21036', '5010', '1510', '5040', '1530', '0', '0', '300', '300', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-274', '2', '1', 'Universal Mini Paint Roller Handle 4 UPHM', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3.1666666666667', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-275', '2', '1', 'Cafu Expenses Taxable', '', 'QTY', 'D', '1881', '5010', '1510', '5040', '1530', '0', '0', '7.25', '382.48', '0', '0', '1', '1', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-276', '2', '1', 'Sachan Kumar Feb 23 ( 2023-008', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '32', '32', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-281', '2', '1', 'Mrs. Asma Kanchwala nov 22( 20', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '40', '50', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-282', '2', '1', 'Mr Ala Damac Hills 2 ( Dec 22)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '120', '120', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-283', '2', '1', 'Kamran Home Dec22 (2022-39)', '', 'QTY', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '56', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-284', '2', '1', 'Hammer  Ignite School Classpai', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '80', '80', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-285', '2', '1', 'Abdul Aziz Nov22 ( 2022-25)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '240', '200', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-286', '2', '1', 'Villa Nova March 23 (2023-017)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '76', '114', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-287', '2', '1', 'Dubai Coast (Awning Damac 2) D', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '60', '60', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-288', '2', '1', 'Pavan Soni March 23 (2023-22)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-290', '2', '1', 'Mr Khan (Hanguly) April 23 (20', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '714', '714', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-291', '2', '1', '111 Immigration April-21', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-292', '2', '1', 'Tahir March 23 (2023-23)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '330', '222.145', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-293', '2', '1', 'Clear Channel March 23 ( 2023-', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '48.5', '171.87', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-294', '1', '1', 'Office Maintenance Expense-Taxable', '', 'QTY', 'B', '21005', '5010', '1510', '5040', '1530', '0', '0', '5000', '5000', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-295', '1', '1', 'Subsription Fees - Taxable', '', 'QTY', 'B', '21032', '5010', '1510', '5040', '1530', '0', '0', '1500', '1500', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-296', '2', '1', 'Ms. Nagalakshmi Arabian Ranhes', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '350', '350', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-297', '2', '1', 'Xpert Decor Swirl Tool SW', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '25', '24.375', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-298', '2', '1', 'Riva Furniture March 23( 2023-', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-299', '2', '1', 'Gypsum Powder (Bag)', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '10', '9', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-300', '2', '1', 'Al Baraa Car Parking March 23 ', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '75.24', '75.24', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-301', '2', '1', 'Berger Value Dry Stucco 20 Kgs', '', 'Bag', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '50.4', '50.4', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-3016', '2', '1', 'Wood Stick', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2', '2.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-3018', '2', '1', 'Al Baraa Additional Canopy(Mar', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '400', '1305.3333333333', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-302', '2', '1', 'Berger Acrylic AR Primer (5 USG)', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '87', '79.95', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-303', '2', '1', 'Aseem Doshi Feb 23 ( 2023-011)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5.71', '40.523333333333', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-305', '2', '1', 'Dr.Fixit Silicone Sealant 501 S.S GPS-Clear (280GM)', '', 'Can', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '6.5', '6.5', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-306', '2', '1', 'Xpert Decor Sponge for Canvas Effect # SCE', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3', '3', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-308', '2', '1', 'Cotton Rags Colour Unstitched', '', 'Bale', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '20', '20', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-309', '2', '1', 'Dx Garage Mosque on Wheels(Mar', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '152', '152', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-310', '2', '1', 'ADSS- Urbana 2 (Feb 23 ) 2023-', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '225', '225', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-311', '2', '1', 'Berger Royale Play Bariq Silver 14Kg', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '342', '342', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-312', '2', '1', 'BDT Awning March 23 (2023-025)', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-313', '2', '1', 'Berger Royale Play Bariq Silver 4 Kg', '', 'GLN', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '104', '91.2', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-314', '1', '1', 'Repair Maintenance R-45327 -Vehicles Taxable', '', 'QTY', 'D', '21057', '1886', '1510', '5040', '1530', '0', '0', '30', '135', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-315', '1', '1', 'Repair Maintenance(P-26138) Vehicles Taxable', '', 'QTY', 'D', '21054', '5010', '1510', '5040', '1530', '0', '0', '170', '170', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-316', '1', '1', 'Visa &amp; Renewables - Shakeel Ahmed ', '', 'QTY', 'B', '21044', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-317', '2', '1', 'KOA  NASAB (AL Barari 101 &amp;102', '', 'QTY', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-318', '1', '1', 'Visa &amp; Renewables Exp-Bir Sing', '', 'QTY', 'B', '21042', '5010', '1510', '5040', '1530', '0', '0', '5183.75', '5183.75', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-319', '2', '1', 'Milano Flat Chisal 12 with guard', '', 'NOS', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '18', '18', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-320', '1', '2', 'Discount Allowed non taxable', '', 'QTY', 'D', '5421', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I-O63', '2', '1', 'CSK Screw 5/8x6', '', 'Packet', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '8', '8', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('I086', '2', '1', 'Berger Acrylic Spray Compond White', '', 'Drum', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '108', '108', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('IP001', '2', '1', 'Internal Painting (sqm) ', '', 'SQM', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('IP002', '2', '1', 'Internal Painting (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('LAI001', '2', '1', 'llaza Awning Installation(Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('MW001', '2', '1', 'Maintenance Work (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('SA001', '2', '1', 'Supply &amp; Apply (sqm)', '', 'SQM', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('SA002', '2', '1', 'Supply &amp; Apply (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('SI001', '2', '1', 'Supply &amp; Installation (sqm)', '', 'SQM', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('SI002', '2', '1', 'Supply &amp; Installation (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('T-001', '1', '1', 'Cafu Expenses Taxable', '', 'QTY', 'D', '21061', '1881', '1510', '5040', '1530', '0', '0', '41.82', '0', '0', '0', '0', '1', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('T-002', '1', '1', 'Fuel Expense - G-56609 (Imran) Taxable', '', 'QTY', 'D', '21063', '1881', '1510', '5040', '1530', '0', '0', '702.57', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('T-003', '1', '1', 'Fuel Expense - P-25757 (Arslan) Taxable', '', 'QTY', 'D', '1881', '1881', '1510', '5040', '1530', '0', '0', '932.9', '0', '0', '0', '0', '1', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('T-004', '1', '1', 'Fuel Expense P-26138 (Van) Taxable', '', 'QTY', 'D', '21069', '1881', '1510', '5040', '1530', '0', '0', '970.27', '0', '0', '0', '0', '1', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('T-005', '1', '1', 'Fuel Expense R-45327 Taxable', '', 'QTY', 'D', '21071', '1881', '1510', '5040', '1530', '0', '0', '735.52', '0', '0', '0', '0', '1', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('T-006', '1', '1', 'Fuel Expense JAC S -77609  Taxable', '', 'QTY', 'D', '21066', '5010', '1510', '5040', '1530', '0', '0', '1735.62', '1385.65', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('T-007', '1', '1', 'Fuel Expense - G-56609 (Imran) Non Taxable', '', 'QTY', 'D', '21064', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', ''),
('WI001', '2', '1', 'Wallpaper Installation (Job)', '', 'Job', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1'),
('WI002', '2', '1', 'Wallpaper Installation (sqm)', '', 'SQM', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '0', '', '0', '0', '4,3,2,1');

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT 0,
  `reference` char(40) NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT 1,
  `standard_cost` double NOT NULL DEFAULT 0,
  `item_specs` varchar(100) NOT NULL,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_moves` ###


### Structure of table `0_subscription` ###

DROP TABLE IF EXISTS `0_subscription`;

CREATE TABLE `0_subscription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `contact` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `designation` varchar(50) NOT NULL,
  `version` varchar(60) NOT NULL,
  `trans_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_subscription` ###


### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_allocations` ###


### Structure of table `0_supp_charges` ###

DROP TABLE IF EXISTS `0_supp_charges`;

CREATE TABLE `0_supp_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `description` varchar(50) NOT NULL,
  `formula` varchar(100) NOT NULL,
  `impact` int(11) NOT NULL COMMENT '1=Add in Line Total 0=Subtract from line total',
  `gl_account` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_charges` ###


### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(1000) NOT NULL,
  `exp_date` date NOT NULL,
  `quantity` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `charge_amount` double NOT NULL,
  `unit_tax` double NOT NULL DEFAULT 0,
  `memo_` tinytext DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_invoice_items` ###


### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `supplier_id` int(11) unsigned NOT NULL DEFAULT 0,
  `reference` tinytext NOT NULL,
  `supp_reference` varchar(100) NOT NULL,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `charge_group` int(11) NOT NULL,
  `ov_amount` double NOT NULL DEFAULT 0,
  `import_amount` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `import` int(11) NOT NULL,
  `notification_status` int(11) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `dimension2_id` int(11) NOT NULL,
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_trans` ###

INSERT INTO `0_supp_trans` VALUES
('1', '0', '2', '01', '', '2023-12-31', '0000-00-00', '0', '0', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('1', '0', '97', '01', '', '2023-12-31', '0000-00-00', '0', '0', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('2', '0', '2', '01', '', '2023-12-31', '0000-00-00', '0', '1260', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('2', '0', '97', '01', '', '2023-12-31', '0000-00-00', '0', '-79377.44', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '45', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '7450', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '52', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '-734.68', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '58', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '7.5', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '97', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '-1000', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '98', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '-5900', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '99', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '-62', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '100', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '-12930.4', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '115', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '-1417.5', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '117', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '50002', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('3', '0', '124', 'JV-02', '', '2023-12-31', '0000-00-00', '0', '443.86', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('4', '0', '97', 'JV-03', '', '2023-12-31', '0000-00-00', '0', '0', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('5', '0', '97', 'JV-03', '', '2023-12-31', '0000-00-00', '0', '0', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('6', '0', '35', 'JV-04', '', '2023-12-31', '0000-00-00', '0', '1526399.03', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0'),
('7', '0', '97', 'JV-03', '', '2023-12-31', '0000-00-00', '0', '0', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0');

### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(100) NOT NULL,
  `supp_ref` varchar(30) NOT NULL DEFAULT '',
  `address` tinytext NOT NULL,
  `supp_address` tinytext NOT NULL,
  `gst_no` varchar(25) NOT NULL DEFAULT '',
  `contact` varchar(60) NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `bank_account` varchar(60) NOT NULL DEFAULT '',
  `curr_code` char(3) DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT 0,
  `purchase_account` varchar(15) NOT NULL DEFAULT '',
  `payable_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `notes` tinytext NOT NULL,
  `charge_group` int(11) NOT NULL,
  `supp_name_arabic` varchar(100) NOT NULL,
  `supp_ref_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `designated_zone` tinyint(1) NOT NULL,
  `is_employee` int(11) NOT NULL,
  `cp_acc1` varchar(15) NOT NULL,
  `cp_acc2` varchar(15) NOT NULL,
  `cp_acc3` varchar(15) NOT NULL,
  `cp_acc4` varchar(30) NOT NULL,
  `cp_acc5` varchar(30) NOT NULL,
  `cp_acc6` varchar(30) NOT NULL,
  `cp_acc7` varchar(30) NOT NULL,
  `cp_acc8` varchar(30) NOT NULL,
  `cp_acc9` varchar(30) NOT NULL,
  `cp_acc10` varchar(30) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('1', 'Advanced Way Building Materials Trading ', 'A. W. Building Material', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('2', 'Al Anfaal Garage EST.', 'Al Anfaal Garage EST.', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('3', 'Fine Tools Trading LLC', 'Fine Tools Trading LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('4', 'Future Craft Interior Decoration LLC', 'F. C. I. Decoration LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('5', 'Hidayath Trading Company LLC', 'Hidayath Trading Company LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('6', 'Hussain General Trading EST (Branch)', 'H. G. T. EST (Branch)', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('7', 'JIHAN BLDG. MAT. &amp; PAINTS', 'JIHAN BLDG. MAT. &amp; PAINTS', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('8', 'Kabir Al Najoom Technical Services LLC', 'K.A.N. Technical Services LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('9', 'NOOR AL SAMAA BUILDING MATERIALS', 'N. A. S.BUILDING MATERIALS', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('10', 'Panache Building Materials Trading LLC', 'P. B. Materials Trading LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('11', 'Qamar Al Huda Aljadeed Gen. Trdg. LLC', 'Q. A.H. Aljadeed Gen.Trdg .LLc', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('12', 'Rawa Al Benaa Technical Services LLC', 'R. A.B. Technical Services LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('13', 'Risala Furniture LLC', 'Risala Furniture LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('14', 'Royal Apex Building Materials Tradinf LL', 'R.A.B. Materials  Tradinf LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('15', 'SHAHEEN ALJAZEERA AUTO REPAIRING', 'S. ALJAZEERA AUTO REPAIRING', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('16', 'Spectrum Tent Manufacturing', 'Spectrum Tent Manufacturing', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('17', 'YASMAC EQUIPMENT RENTAL &amp; REPAIRING LLC', 'Y. E. R. &amp; REPAIRING LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('18', 'AAFOQ Islamic Finance', 'AAFOQ Islamic Finance', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('19', 'Arabian Business Center (Tasheel)', 'A. Business Center (Tasheel)', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('20', 'BALGHANI STORES LLC', 'BALGHANI STORES LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('21', 'CAFU APP TECHNOLOGIES FZE', 'CAFU APP TECHNOLOGIES FZE', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('22', 'Emirates Driving Institute', 'Emirates Driving Institute', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('23', 'Glare Technologies', 'Glare Technologies', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('24', 'Lex Consortia FZ LLC', 'Lex Consortia FZ LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('25', 'Nasser Al Matrooshi Trading (L.L.C) Br', 'N. A. M. Trading (L.L.C) Br', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('26', 'SHADMAN TENTS IND LLC', 'SHADMAN TENTS IND LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('27', 'Souq.Com FZ LLC', 'Souq.Com FZ LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('28', 'SUPER GENERAL COMPANY LLC', 'SUPER GENERAL COMPANY LLC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('29', 'The Excelerate Enterprises DMCC', 'The Excelerate Enterprises DMC', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('31', 'DUBAI ELECTRICITY &amp; WATER AUTHORITY', 'D. E. &amp; WATER AUTHORITY', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('32', 'D.I.I.&amp;RE INSURANCE COMANY (AMAN)-(PJSC)', 'D. I. I. &amp;RE INSURANCE CO', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('33', 'E.Telecommunica Group Company (Etisalat)', 'E.T G. Company (Etisalat)', '', '', '', '', '', '', '', 'AED', '0', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('34', 'Purchase Bills to Come', 'Purchase Bills to Come', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('35', 'Bin Dhahi Trading LLC', 'Bin Dhahi Trading LLC', '', 'AL QUOZ IND 1\nDUBAI', '100241217700003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('36', 'Emirates Telecommunications Group Company(Etisalat)', 'Emirates Telecommunications Gr', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('37', 'Good Steam Auto Center', 'Good Steam Auto Center', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('38', 'NOOR TAKAFUL GENERAL (PJSC)', 'NOOR TAKAFUL GENERAL (PJSC)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('39', 'Al Sharq Media LLC', 'Al Sharq Media LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('40', 'Modern Seal Insulation Contracting LLC', 'Modern Seal Insulation Contrac', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('41', 'Alanas Garage LLC', 'Alanas Garage LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('42', 'Chittagong Garage LLC', 'Chittagong Garage LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('43', 'Emirates Post Group', 'Emirates Post Group', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('44', 'Broadway Building Materials LLC', 'Broadway Building Materials LL', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('45', 'RTA', 'RTA', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('46', 'Big Foot Koncepts LLC', 'Big Foot Koncepts LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('47', 'ROYAL GRAND BUILDING MATERIALS TRADING L', 'ROYAL GRAND BUILDING MATERIALS', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('48', 'He BEI Gao Yang Qi Chang Textile FZCO', 'He BEI Gao Yang Qi Chang Texti', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('49', 'EPIC TRAVEL LLC', 'EPIC TRAVEL LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('50', 'Saif Al Burhan Traders LLC', 'Saif Al Burhan Traders LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('51', 'SAFINAT AL BAHAR BUILDING MATERIALS LLC', 'SAFINAT AL BAHAR BUILDING MATE', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('52', 'Arabian Business Center (Tasheel)', 'Arabian Business Center (Tashe', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('56', 'Fine Tools Equipment Repairing LLC', 'Fine Tools Equipment Repairing', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('57', 'Mega City Building Materilas Trading LLC', 'Mega City Building Materilas T', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('58', 'YASMAC EQUIPMENT RENTAL &amp; REPAIRING LLC', 'YASMAC EQUIPMENT RENTAL &amp; ', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('59', 'Ghulam Mustafa Construction Equipment &amp; ', 'Ghulam Mustafa Construction Eq', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('60', 'Team One Glass &amp; Aluminum Installation L', 'Team One Glass &amp; Aluminum ', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('61', 'Bawabt Al Hemreya Car Seat Upholstery LL', 'Bawabt Al Hemreya Car Seat Uph', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('62', 'Al Barsha Tyres &amp; Battery Trading LLC', 'Al Barsha Tyres &amp; Battery ', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('63', 'ARABIAN SAND WASHING LLC', 'ARABIAN SAND WASHING LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('64', 'Smooth Solution Building Materials Tradi', 'Smooth Solution Building Mater', 'PO BOX # 112469\ndubai', '', '100008641100003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('65', 'Jumeirah Carpenter BR', 'Jumeirah Carpenter BR', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('66', 'Mega Fix Tyres &amp; Auto Care Center', 'Mega Fix Tyres &amp; Auto Care', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('67', 'IN Focus Glass and Aluminium Works LLC', 'IN Focus Glass and Aluminium W', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('68', 'Shades General Trading LLC', 'Shades General Trading LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('69', 'Progress Profiles Middle East LLC', 'Progress Profiles Middle East ', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('70', 'Nasser Al Matrooshi Trading (L.L.C) Br', 'Nasser Al Matrooshi Trading (L', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('71', 'O.U.N Building Materials LLC', 'O.U.N Building Materials LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('72', 'MOHD AL QAMA CERAMICS TRADING LLC', 'MOHD AL QAMA CERAMICS TRADING ', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('73', 'Al Burhan Prints LLC', 'Al Burhan Prints LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('74', 'Wayz Consulting', 'Wayz Consulting', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('75', 'MAS PAINTS &amp; CHEMICALS IND', 'MAS PAINTS &amp; CHEMICALS IND', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('76', 'GULF PAINTS', 'GULF PAINTS', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('77', 'NAJRAN GENERAL TRADING', 'NAJRAN GENERAL TRADING', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('78', 'Jai Electricals LLC', 'Jai Electricals LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('79', 'DUKE STEEL TRADING CO (L.L.C)', 'DUKE STEEL TRADING CO (L.L.C)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('80', 'BAB AL SAFA CAR ACCESSORIES AND UPHOLSTE', 'BAB AL SAFA CAR ACCESSORIES AN', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('81', 'SALAHALDIN CAR ACCESSORIES FIXING LLC', 'SALAHALDIN CAR ACCESSORIES FIX', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('82', 'Al Aksa Technical &amp;Cleaning Services', 'Al Aksa Technical &amp;Cleanin', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('83', 'Ish Stars Technical Services', 'Ish Stars Technical Services', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('84', 'Led Corner Trading LLC', 'Led Corner Trading LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('85', 'RUI KANG TRADING FZCO', 'RUI KANG TRADING FZCO', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('86', 'Tools R Us LLC', 'Tools R Us LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('87', 'Al Anas Garage LLC', 'Al Anas Garage LLC', '', 'Dubai', '', '', '', '', '', 'AED', '2', '1', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('88', 'Miscellaneous Supplier', 'Miscellaneous Supplier', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('90', 'Hussain General Trading EST. ', 'Hussain General Trading EST. ', '', '', '', '', '100031073800003', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('91', 'Al fly Trading FZCO', 'Al fly Trading FZCO', '', 'Dragon mart 1, dubai', '', '', '100041020700003', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '2034', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('92', 'Otaly Trading FZCO ', 'Otaly Trading FZCO ', '', 'Dragon mart , dubai', '', '', '100380295400003', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('93', 'Grand al khail auto garage LLC', 'Grand al khail auto garage LLC', '', 'AL QUOZ IND 2\nDubai', '', '', '104039659800003', '', '', 'AED', '3', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('94', 'Imran Qasim (employee)', 'Imran Qasim (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24015', '5423', '5424', '', '0', '', '', '0', '0', '1', '1905', '5429', '5420', '5427', '1914', '24015', '5424', '21014', '1060', '1060'),
('95', 'Star brothers auto repairing', 'Star brothers auto repairing', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('96', 'Johns Paints Trading LLC', 'Johns Paints Trading LLC', '', '', '100245326200003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('97', ' Adeel Bashir Ahmad ( Employee)', ' Adeel Bashir Ahma ( Employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24005', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5424', '5427', '5420', '1914', '24005', '1905', '21014', '1060', '1060'),
('98', 'Abid Hussain ( Employee)', 'Abid Hussain ( Employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24001', '5423', '5424', '', '0', '', '', '0', '0', '1', '5429', '1905', '5427', '1914', '24001', '5424', '5420', '21014', '1060', '1060'),
('99', 'AKBAR ALI KHAN   (employee)', 'AKBAR ALI KHAN   (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24002', '5423', '5424', '', '0', '', '', '0', '0', '1', '5429', '1905', '5427', '5420', '1914', '24002', '5424', '21014', '1060', '1060'),
('100', 'ARSLAN NADEEM  (employee)', 'ARSLAN NADEEM  (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24003', '5423', '5429', '', '0', '', '', '0', '0', '1', '1905', '5427', '5420', '5424', '1914', '24003', '5429', '21014', '1060', '1060'),
('101', 'BIR SINGH (employee)', 'BIR SINGH (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24013', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24013', '1905', '21014', '1060', '1060'),
('102', 'DURGALAL NEPALI (employee)', 'DURGALAL NEPALI (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24014', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24014', '1905', '21014', '1060', '1060'),
('103', 'MUHAMMAD AKHTAR (employee)', 'MUHAMMAD AKHTAR (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24016', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24016', '1905', '21014', '1060', '1060'),
('104', 'MUHAMMAD IBRAR (employee)', 'MUHAMMAD IBRAR (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24018', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24018', '1905', '21014', '1060', '1060'),
('105', 'MUHAMMAD USAMA (employee)', 'MUHAMMAD USAMA (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24017', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24017', '1905', '21014', '1060', '1060'),
('107', 'SHAKEEL AHMED ( employee)', 'SHAKEEL AHMED ( employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24021', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24021', '1905', '21014', '1060', '1060'),
('108', 'TAUHEED AHMED (employee)', 'TAUHEED AHMED (employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24022', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24022', '1905', '21014', '1060', '1060'),
('109', 'ZEESHAN ALI  ( employee)', 'ZEESHAN ALI  ( employee)', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '24023', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24023', '1905', '21014', '1060', '1060'),
('110', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', 'ajman', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('111', 'Latif Musa Air Condition Rpr &amp; Mntnc EST', 'Latif Musa Air Condition Rpr &amp;', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('112', 'TIAN FA STONE MATERIAL TRADING FZCO', 'TIAN FA STONE MATERIAL TRADING', 'Dubai', '', '100535811200003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('113', 'Al Zujaj Al Azraq AlumN &amp; Glass Fixing', 'Al Zujaj Al Azraq Aluminium &amp;a', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('114', 'Royal Hammer Trading LLC', 'Royal Hammer Trading LLC', '', '', '100235913900003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('115', 'Pioneer Insurance Broker LLC', 'Pioneer Insurance Broker LLC', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('116', 'Shandong Hele(Middle East) Invstmnt FZC0', 'Shandong Hele( Middle East) In', '', 'Dubai', '100254562000003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('117', 'shaikh saeed mohammed Hasher Al maktoum', 'shaikh saeed mohammed Hasher A', '', 'Sheikh Zayed Road, Dubai', '100317321600003', '', '', '', '', 'AED', '1', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('118', 'faqihi Enterprises LLC (BR)', 'faqihi Enterprises LLC (BR)', '', '', '100381535200003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('119', 'Laspinas Building Materials Trading LLC', 'Laspinas Building Materials Tr', '', 'DUBAI', '100205476300003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('120', 'Panache Building Materials Trading LLC', 'Panache Building Materials Tra', '', '', '100047727100003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('121', 'Mohd. Al Qama General Trading Co. LLC', 'Mohd. Al Qama General Trading ', '', 'dubai', '100064202300003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('122', 'Technos Multiline LLC', 'Technos Multiline LLC', '', 'DUBAI', '100227318100003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('123', 'Ibrahim Abbas Ali Trading LLC', 'Ibrahim Abbas Ali Trading LLC', '', 'DUBAI', '100244262000003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('124', 'DUBAI ELECTRICITY &amp; WATER AUTHORITY', 'DUBAI ELECTRICITY &amp; WATER ', '', '', '100027620200003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('125', 'Al Dhaw Al Wahaj Electrical &amp; Sanitary Ware Tr.', 'Al Dhaw Al Wahaj Electrical &amp;a', '', 'Sharjah', '100351016900003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('126', 'Romana Water Industries LLC', 'Romana Water Industries LLC', '', 'DIP 2 , JEBEL ALI', '100231220300003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('127', 'Faizal system fixing contracting', 'Faizal system fixing contracti', '', 'Ajman', '100326604400003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('128', 'Noor Al Fajr Elect. Devices Trading', 'Noor Al Fajr Elect. Devices Tr', '', 'Sharjah', '100241494200003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('129', 'Mohd.AL Qama Building Materials Trdg.LLC Br.', 'Mohd.AL Qama Building Material', '', 'dubai', '100064202300003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('130', 'Dubai Coast Trading  LLC', 'Dubai Coast Trading  [LLC]', '', '', '100241217700003', '', '', '', '', 'AED', '7', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('131', 'Suitecase Holidays FZE LLC', 'Suitecase Holidays FZE LLC', '', 'SHARJAH , UAE', '', '', '', '', '', 'AED', '2', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('132', 'AFAQ MAHMOOD MAHMOOD AHMAD (Employee)', 'AFAQ MAHMOOD MAHMOOD AHMAD (Em', '', '', '', '', '', '', '', 'AED', '7', '0', '0', '0', '1', '0', '24012', '5423', '1905', '', '0', '', '', '0', '0', '1', '5429', '5427', '5420', '5424', '1914', '24012', '1905', '21014', '1060', '1060'),
('133', 'SERVICE FIRST GENERAL TRADING LLC', 'SERVICE FIRST GENERAL TRADING ', '', 'JEBEL ALI INDUSTRIAL AREA-1', '100532171400003', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('134', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', '', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', ''),
('135', 'Grand City Auto Services', 'Grand City Auto Services', '', '', '', '', '', '', '', 'AED', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0', '', '', '0', '0', '0', '', '', '', '', '', '', '', '', '', '');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) NOT NULL DEFAULT '',
  `category` varchar(30) DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', ''),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1'),
('allowance', 'glsetup.general', 'tinyint', '1', '1205'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('arabic_coy_name', 'setup.company', 'varchar', '60', ''),
('area', 'setup.company', 'varchar', '100', 'Jebel Ali Ind 1'),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('backup_delete', 'system', 'varchar', '11', ''),
('backup_email1', 'glsetup.general', 'varchar', '70', 'testing@gmail.com'),
('backup_email2', 'glsetup.general', 'varchar', '70', 'testing@gmail.com'),
('backup_time', 'system', 'time', '4', '14:00'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690'),
('barcodes_on_stock', 'setup.company', 'tinyint', '1', '0'),
('base_sales', 'setup.company', 'int', '11', '0'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('build_name', 'setup.company', 'varchar', '100', 'WH #77'),
('charges_on_net', 'setup.company', 'int', '1', '1'),
('city', 'setup.company', 'varchar', '100', 'Jebeal Ali Ind 1'),
('company_logo_report', 'setup.company', 'tinyint', '1', '0'),
('country', 'setup.company', 'varchar', '100', '229'),
('coy_hd_logo', 'setup.company', 'varchar', '100', 'Xpert_Company_Logo.png'),
('coy_logo', 'setup.company', 'varchar', '100', 'Xpert_Company_Logo.png'),
('coy_name', 'setup.company', 'varchar', '60', 'Mr. Xpert Technical Services'),
('coy_no', 'setup.company', 'varchar', '25', '+971 4 227 1155'),
('coy_sm_logo', 'setup.company', 'varchar', '100', 'Xpert_Company_Logo.png'),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('creditors_pdc_act', 'glsetup.purchase', 'varchar', '20', '970'),
('curr_default', 'setup.company', 'char', '3', 'AED'),
('customer_loyality_check', 'setup.company', 'int', '1', ''),
('days_in_a_year', 'setup.company', 'smallint', '6', '365'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('debtors_pdc_act', 'glsetup.sales', 'varchar', '20', '960'),
('dec_arabic_name', 'setup.company', 'varchar', '100', ''),
('dec_count_code', 'setup.company', 'varchar', '100', '+971'),
('dec_email', 'setup.company', 'varchar', '100', ''),
('dec_emirate_id', 'setup.company', 'varchar', '100', '1234567890'),
('dec_mobile', 'setup.company', 'varchar', '100', ''),
('dec_name', 'setup.company', 'varchar', '100', 'OWAIS'),
('dec_pass_no', 'setup.company', 'varchar', '100', '0987654321'),
('declare_y_n', 'setup.company', 'tinyint', '1', '1'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '30'),
('default_dim_required', 'glsetup.dims', 'int', '11', '30'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660'),
('default_loyality_discount_act', 'glsetup.sales', 'varchar', '15', '4009'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '30'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '30'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', '2105'),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '0'),
('dim_profit_margin', 'glsetup.sales', 'varchar', '15', '50'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', 'info@mrxpert.ae'),
('emirate', 'setup.company', 'varchar', '100', 'Dubai'),
('emp_account_type', 'glsetup.general', 'varchar', '5', '11'),
('emp_bank_account_type', 'glsetup.general', 'varchar', '11', '3'),
('emp_bank_charge_act', 'glsetup.general', 'varchar', '11', '5410'),
('emp_bank_gl_max', 'glsetup.general', 'varchar', '11', '20000'),
('emp_bank_gl_min', 'glsetup.general', 'varchar', '11', '10000'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '12'),
('fax', 'setup.company', 'varchar', '30', '55459'),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gl_closing_date', 'setup.closing_date', 'date', '8', '2021-01-31'),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', ''),
('gst_no', 'setup.company', 'varchar', '25', '100269274500003'),
('is_sms', 'setup.company', 'int', '1', '1'),
('is_sms_marketing', 'setup.company', 'tinyint', '1', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('liability', 'glsetup.general', 'tinyint', '1', '2100'),
('loan', 'glsetup.general', 'tinyint', '1', '2620'),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '1500'),
('loyality_dec', 'setup.company', 'int', '11', '0'),
('loyality_points_amount', 'setup.company', 'int', '11', ''),
('loyality_points_ratio', 'setup.company', 'int', '11', ''),
('loyality_points_tax', 'setup.company', 'int', '1', ''),
('loyality_points_value', 'setup.company', 'int', '11', ''),
('mail_type', 'system.mail', 'varchar', '10', 'SMTP'),
('marketing_sms', 'setup.company', 'text', '0', 'Nothing'),
('mobile_no', 'setup.company', 'varchar', '100', '+971 56 403 1783'),
('new_sales_style', 'setup.company', 'varchar', '3', 'NEW'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('notification_time', 'glsetup.general', 'varchar', '1', '01:43'),
('online_arabic_name', 'setup.company', 'varchar', '100', ''),
('online_name', 'setup.company', 'varchar', '100', 'OWAIS'),
('online_y_n', 'setup.company', 'tinyint', '1', '1'),
('overtime', 'glsetup.general', 'tinyint', '1', '5420'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('payroll_deductleave_act', NULL, 'varchar', '15', ''),
('payroll_dept_based', NULL, 'tinyint', '1', ''),
('payroll_month_work_days', NULL, 'float', NULL, '30'),
('payroll_overtime_act', NULL, 'varchar', '15', ''),
('payroll_payable_act', NULL, 'varchar', '15', ''),
('payroll_work_hours', NULL, 'float', NULL, '8'),
('phone', 'setup.company', 'varchar', '30', '(971) 4-227-1155___'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10.00'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10.00'),
('postal_address', 'setup.company', 'tinytext', '0', 'P.O. Box 55459, Dubai, United Arab Emirates'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('rep_style', 'setup.company', 'varchar', '3', 'OLD'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('round_to', 'setup.company', 'int', '5', '1'),
('salary_expense', 'glsetup.general', 'tinyint', '1', '5010'),
('shortname_name_in_list', 'setup.company', 'tinyint', '1', '0'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', '1'),
('smtp_host', 'system.mail', 'varchar', '60', 'mail.xpert.ae'),
('smtp_password', 'system.mail', 'varchar', '60', 'Xpert@2022'),
('smtp_port', 'system.mail', 'int', '11', '465'),
('smtp_secure', 'system.mail', 'varchar', '10', 'ssl'),
('smtp_username', 'system.mail', 'varchar', '60', 'accounts@mrxpert.ae'),
('street', 'setup.company', 'varchar', '100', 'Saeed Al Maktoum Com'),
('sub_date', 'setup.company', 'Date', '100', '31/03/2021'),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('taan', 'setup.company', 'varchar', '20', ''),
('tan', 'setup.company', 'varchar', '20', '123456789'),
('tax_agency_name', 'setup.company', 'varchar', '100', 'Tax Agency '),
('tax_agent_name', 'setup.company', 'varchar', '100', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_label', 'setup.company', 'varchar', '60', 'VAT No'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '1'),
('use_dimension', 'setup.company', 'tinyint', '1', '1'),
('use_dimension_label1', 'setup.company', 'varchar', '100', 'Project'),
('use_dimension_label2', 'setup.company', 'varchar', '100', 'Not Set'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_sys_types` ###

DROP TABLE IF EXISTS `0_sys_types`;

CREATE TABLE `0_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 1,
  `next_reference` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_types` ###

INSERT INTO `0_sys_types` VALUES
('0', '17', '1'),
('1', '7', '1'),
('2', '4', '1'),
('4', '3', '1'),
('10', '16', '1'),
('11', '2', '1'),
('12', '6', '1'),
('13', '1', '1'),
('16', '2', '1'),
('17', '2', '1'),
('18', '1', '1'),
('20', '6', '1'),
('21', '1', '1'),
('22', '3', '1'),
('25', '1', '1'),
('26', '1', '1'),
('28', '1', '1'),
('29', '1', '1'),
('30', '0', '1'),
('32', '0', '1'),
('35', '1', '1'),
('40', '1', '1');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  `name_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tags` ###

INSERT INTO `0_tags` VALUES
('1', '1', 'Visa Expenses', NULL, '', '0');

### Structure of table `0_tasks` ###

DROP TABLE IF EXISTS `0_tasks`;

CREATE TABLE `0_tasks` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `user_id` int(255) NOT NULL,
  `header_title` varchar(255) NOT NULL,
  `header_style` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `due_date` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_tasks` ###


### Structure of table `0_tasks_dashboard` ###

DROP TABLE IF EXISTS `0_tasks_dashboard`;

CREATE TABLE `0_tasks_dashboard` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `user_id` int(255) NOT NULL,
  `task_name` varchar(255) NOT NULL,
  `task_description` varchar(255) NOT NULL,
  `due_date` varchar(255) NOT NULL,
  `doing` tinyint(1) NOT NULL,
  `done` tinyint(1) NOT NULL,
  `priority` varchar(255) NOT NULL,
  `trans_date` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_tasks_dashboard` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_shipping` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_group_items` ###

INSERT INTO `0_tax_group_items` VALUES
('1', '1', '0'),
('2', '2', '0'),
('3', '1', '0'),
('3', '3', '0'),
('4', '1', '0'),
('4', '4', '0'),
('5', '5', '0');

### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0'),
('3', 'Excise tax', '0'),
('4', 'Excise tax 100%', '0'),
('5', 'KSA VAT', '0'),
('6', 'Taxable', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT 0,
  `sales_gl_code` varchar(15) NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `tax_code` varchar(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('1', '5', '2150', '2150', 'VAT', '0', ''),
('2', '0', '1060', '1060', 'Zero Rated', '0', ''),
('3', '50', '2390', '2390', 'Excise Tax', '1', ''),
('4', '100', '2391', '2391', 'Excise Tax 100%', '1', ''),
('5', '5', '000002', '000002', 'KSA VAT', '1', '');

### Structure of table `0_technician` ###

DROP TABLE IF EXISTS `0_technician`;

CREATE TABLE `0_technician` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `salary` double NOT NULL,
  `ov_salary` double NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_technician` ###

INSERT INTO `0_technician` VALUES
('1', 'Muhammad Adeel', '9.1666666666667', '10', '0'),
('2', 'Abdulla Nepali', '9.1666666666667', '10', '0'),
('3', 'Imran Qasim', '10.416666666667', '10', '0'),
('4', 'Ibrar Shah', '8.75', '10', '0'),
('5', 'Tauheed Ahmed', '8.75', '10', '0'),
('6', 'Usama', '7.0833333333333', '10', '0'),
('7', 'Zeeshan', '7.0833333333333', '10', '0'),
('8', 'Akhtar', '8.3333333333333', '10', '0'),
('9', 'Bir Singh', '8.3333333333333', '10', '0'),
('10', 'Muhammad Akbar', '10.416666666667', '0', '0'),
('11', 'Abid Hussain', '9.5833333333333', '10', '0'),
('12', 'Shahid Farooq', '0', '0', '0'),
('13', 'ADEEL BASHIR  AHMAD', '8.3333333333333', '10', '0'),
('14', 'AFAQ MAHMOOD', '6.25', '10', '0');

### Structure of table `0_testing_table` ###

DROP TABLE IF EXISTS `0_testing_table`;

CREATE TABLE `0_testing_table` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `name` varchar(30) NOT NULL,
  `pass` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `company` varchar(30) NOT NULL,
  `no_of_users` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_testing_table` ###


### Structure of table `0_tickets` ###

DROP TABLE IF EXISTS `0_tickets`;

CREATE TABLE `0_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `contact_no` int(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `question` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_tickets` ###


### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 0,
  `ex_rate` double NOT NULL DEFAULT 1,
  `included_in_price` tinyint(1) NOT NULL DEFAULT 0,
  `net_amount` double NOT NULL DEFAULT 0,
  `amount` double NOT NULL DEFAULT 0,
  `memo` tinytext DEFAULT NULL,
  `reg_type` tinyint(1) DEFAULT NULL,
  `excise_tax_type` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trans_tax_details` ###

INSERT INTO `0_trans_tax_details` VALUES
('1', '0', '12', '2023-12-31', '5', '0', '1', '0', '0', '0', NULL, '1', '0');

### Structure of table `0_transaction_sms` ###

DROP TABLE IF EXISTS `0_transaction_sms`;

CREATE TABLE `0_transaction_sms` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `trans_type` int(200) NOT NULL,
  `sms_body` varchar(200) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_transaction_sms` ###


### Structure of table `0_trial_subscription` ###

DROP TABLE IF EXISTS `0_trial_subscription`;

CREATE TABLE `0_trial_subscription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) NOT NULL,
  `url` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(50) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `designation` varchar(20) NOT NULL,
  `country` varchar(50) NOT NULL,
  `product` varchar(100) NOT NULL,
  `package` varchar(100) NOT NULL,
  `type` varchar(30) DEFAULT NULL,
  `trans_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `inactive` tinyint(4) NOT NULL,
  `deleted` tinyint(4) NOT NULL,
  `is_installed` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trial_subscription` ###


### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(255) NOT NULL,
  `timestamp` int(15) NOT NULL DEFAULT 0,
  `ip` varchar(40) NOT NULL DEFAULT '',
  `file` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=3028 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_useronline` ###

INSERT INTO `0_useronline` VALUES
('3025', '25', '1705557590', '144.48.128.134', '/mrxpert/index.php'),
('3026', '25', '1705557631', '144.48.128.134', '/mrxpert/index.php'),
('3027', '25', '1705557638', '144.48.128.134', '/mrxpert/admin/backups.php');

### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `real_name` varchar(100) NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT 1,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) DEFAULT NULL,
  `technician` int(11) NOT NULL,
  `language` varchar(20) DEFAULT NULL,
  `dropdown_language` int(1) NOT NULL,
  `user_location` varchar(5) NOT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT 0,
  `date_sep` tinyint(1) NOT NULL DEFAULT 0,
  `tho_sep` tinyint(1) NOT NULL DEFAULT 0,
  `dec_sep` tinyint(1) NOT NULL DEFAULT 0,
  `theme` varchar(20) NOT NULL DEFAULT 'default',
  `page_size` varchar(20) NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT 2,
  `qty_dec` smallint(6) NOT NULL DEFAULT 2,
  `rates_dec` smallint(6) NOT NULL DEFAULT 4,
  `percent_dec` smallint(6) NOT NULL DEFAULT 1,
  `show_gl` tinyint(1) NOT NULL DEFAULT 1,
  `show_codes` tinyint(1) NOT NULL DEFAULT 0,
  `show_hints` tinyint(1) NOT NULL DEFAULT 0,
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT 10,
  `graphic_links` tinyint(1) DEFAULT 1,
  `pos` smallint(6) DEFAULT 1,
  `print_profile` varchar(30) NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT 1,
  `sticky_doc_date` tinyint(1) DEFAULT 0,
  `startup_tab` varchar(20) NOT NULL DEFAULT '',
  `transaction_days` int(6) NOT NULL DEFAULT 30 COMMENT 'Transaction days',
  `quote_notify` int(11) NOT NULL,
  `save_report_selections` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Save Report Selection Days',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Use Date Picker for all Date Values',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Default Report Destination',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Default Report Orientation',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `employee_type` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `loan_updation` int(11) NOT NULL,
  `customer_id` int(255) NOT NULL,
  `branch_id` int(255) NOT NULL,
  `company_dash` int(11) NOT NULL,
  `sales_dash` int(11) NOT NULL,
  `purchase_dash` int(11) NOT NULL,
  `items_inventory_dash` int(11) NOT NULL,
  `owner` int(1) NOT NULL,
  `user_img` varchar(100) NOT NULL,
  `dimension` int(11) NOT NULL,
  `sq_comment` int(11) NOT NULL COMMENT '1 = User Can Comment On Sale Quotation',
  `all_contact_person` int(100) NOT NULL COMMENT 'User Can See All Contact Forms in CRM',
  `all_opportunities` int(100) NOT NULL COMMENT 'User Can See All Opportunities in CRM',
  `elev_dashboard` varchar(100) NOT NULL COMMENT 'This Option will show you Startup Dashboard',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', '7653c44312469738ad361c63c8622e82', 'Administrator', '2', '(551) 5-566-51515__', NULL, '0', 'C', '1', '', '1', '0', '0', '0', 'synergy-purple', 'A4', '2', '2', '2', '2', '1', '1', '1', '2024-01-18 09:26:53', '255', '1', '1', '', '1', '0', 'dashboard', '50', '30', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1', '1', '0', '0', ''),
('22', 'kamran', 'a065cca1e5a6283a20e9de8173ecb8a7', 'Mr. Kamran Ahmed', '2', '', NULL, '0', 'C', '0', '', '1', '0', '0', '0', 'synergy-purple', 'A4', '2', '2', '2', '2', '1', '1', '1', '2024-01-18 08:31:53', '255', '1', '1', '', '0', '0', 'dashboard', '30', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0', '0', ''),
('25', 'CompanyAdmin', '81dc9bdb52d04dc20036dbd8313ed055', 'Company Admin', '2', '', NULL, '2', 'C', '0', '', '1', '0', '0', '0', 'synergy-purple', 'A4', '2', '2', '2', '2', '1', '1', '1', '2024-01-18 09:37:13', '255', '1', '1', '', '0', '0', 'dashboard', '30', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0', '0', ''),
('26', 'Shakeel', '81dc9bdb52d04dc20036dbd8313ed055', 'Shakeel', '29', '', NULL, '0', 'C', '0', '', '1', '0', '0', '0', 'synergy-purple', 'A4', '2', '2', '2', '2', '1', '1', '1', '2024-01-15 11:09:00', '255', '1', '0', '', '0', '0', 'dashboard', '30', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', ''),
('27', 'Arsalan', '81dc9bdb52d04dc20036dbd8313ed055', 'Arsalan', '37', '', NULL, '0', 'C', '0', '', '1', '0', '0', '0', 'synergy-purple', 'A4', '2', '2', '2', '2', '1', '1', '1', '2024-01-15 13:23:01', '255', '1', '1', '', '0', '0', 'dashboard', '30', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '0', '');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_voided` ###

INSERT INTO `0_voided` VALUES
('0', '1', '2024-01-13', 'Document reentered.'),
('0', '4', '2024-01-15', 'Document reentered.'),
('0', '5', '2024-01-16', 'Document reentered.'),
('0', '7', '2024-01-16', 'Document reentered.'),
('0', '8', '2024-01-16', 'Document reentered.'),
('0', '9', '2024-01-16', 'Document reentered.'),
('0', '10', '2024-01-16', 'Document reentered.'),
('0', '11', '2024-01-16', 'Document reentered.'),
('0', '12', '2024-01-16', 'Document reentered.'),
('0', '13', '2024-01-16', 'Document reentered.'),
('0', '14', '2024-01-16', 'Document reentered.');

### Structure of table `0_widgets` ###

DROP TABLE IF EXISTS `0_widgets`;

CREATE TABLE `0_widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` smallint(6) NOT NULL,
  `column_id` int(11) NOT NULL,
  `sort_no` int(11) NOT NULL,
  `collapsed` tinyint(4) NOT NULL,
  `url` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(50) NOT NULL,
  `width` varchar(50) NOT NULL,
  `height` varchar(50) NOT NULL,
  `is_system` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` varchar(150) NOT NULL,
  `dt_created` datetime NOT NULL,
  `updated_by` varchar(150) DEFAULT NULL,
  `dt_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_bin ;

### Data of table `0_widgets` ###

INSERT INTO `0_widgets` VALUES
('1', '2', '2', '0', '0', 'editor.php', 'Editor', 'editorchart', '100%', '400px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('2', '2', '1', '0', '0', 'line.php', 'Line Chart', 'linechart', '100%', '400px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('3', '2', '2', '0', '0', 'pie.php', 'Pie Chart', 'piechart', '100%', '400px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('4', '2', '2', '0', '0', 'bar.php', 'Bar Chart', 'barchart', '100%', '400px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('5', '2', '2', '0', '0', 'bar-option.php', 'Bar Option Chart', 'bartoptionchart', '100%', '400px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('6', '2', '1', '0', '0', 'bar-table.php', 'Bar Table Chart', 'bartablechart', '100%', '600px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('7', '2', '1', '0', '0', 'motion.php', 'Motion Chart', 'motionchart', '100%', '600px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('10', '1', '1', '0', '0', 'top-10-recent-sales-invoices.php', 'Top 10 Recent Sales Invoices', 'top10recentsalesinvoice', '100%', '300px', '1', '1', '2017-07-05 08:12:12', NULL, NULL),
('11', '1', '1', '0', '0', 'top-10-recent-sales-invoices.php', 'Top 10 Recent Sales Invoices', 'top10recentsalesinvoice', '100%', '300px', '1', '1', '2018-01-08 08:09:55', NULL, NULL);

### Structure of table `0_widgets_template` ###

DROP TABLE IF EXISTS `0_widgets_template`;

CREATE TABLE `0_widgets_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_id` int(11) NOT NULL,
  `sort_no` int(11) NOT NULL,
  `collapsed` tinyint(4) NOT NULL,
  `url` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(50) NOT NULL,
  `width` varchar(50) NOT NULL,
  `height` varchar(50) NOT NULL,
  `is_system` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` varchar(150) NOT NULL,
  `dt_created` datetime NOT NULL,
  `updated_by` varchar(150) DEFAULT NULL,
  `dt_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_widgets_template` ###

INSERT INTO `0_widgets_template` VALUES
('1', '2', '0', '0', 'top-10-customer-in-fiscal-year.php', 'Top 10 customers in fiscal year', 'top10customerinfiscalyear', '100%', '630px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('2', '2', '0', '0', 'top-10-supplier-in-fiscal-year.php', 'Top 10 suppliers in fiscal year', 'top10supplierinfiscalyear', '100%', '630px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('3', '2', '0', '0', 'top-10-stock-in-fiscal-year.php', 'Top 10 Sold Items in fiscal year', 'top10iteminfiscalyear', '100%', '630px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('4', '2', '0', '0', 'top-10-dimension-in-fiscal-year.php', 'Top 10 Dimensions in fiscal year', 'top10dimensionfiscalyear', '100%', '370px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('5', '2', '0', '0', 'top-10-overdue-sales-invoices.php', 'Top 10 Overdue Sales Invoices', 'top10overduesalesinvoice', '100%', '300px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('6', '2', '0', '0', 'top-10-overdue-purchase-invoices.php', 'Top 10 Overdue Purchase Invoices', 'top10overduepurchaseinvoice', '100%', '300px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('7', '2', '0', '0', 'gl-in-fiscal-year.php', 'Profit and Loss', 'glfiscalyear', '100%', '370px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('8', '2', '0', '0', 'top-10-recent-sales-order.php', 'Top 10 Recent Sales Order', 'top10recentsalesorder', '100%', '300px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18'),
('9', '2', '0', '0', 'top-10-recent-sales-invoices.php', 'Top 10 Recent Sales Invoices', 'top10recentsalesinvoice', '100%', '300px', '1', 'system', '2017-07-05 08:07:18', 'system', '2017-07-05 08:07:18');

### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `cost_type` tinyint(1) NOT NULL DEFAULT 0,
  `trans_type` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_costing` ###


### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issue_items` ###


### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issues` ###


### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_manufacture` ###


### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT 0,
  `units_req` double NOT NULL DEFAULT 1,
  `unit_cost` double NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_requirements` ###


### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) NOT NULL DEFAULT '',
  `description` char(50) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workcentres` ###


### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) NOT NULL DEFAULT '',
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT 1,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT 0,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `released` tinyint(1) NOT NULL DEFAULT 0,
  `additional_costs` double NOT NULL DEFAULT 0,
  `order_id` int(11) NOT NULL,
  `order_detail_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workorders` ###
