# MySQL dump of database 'bindhahiwayzerp_mrxpert' on host 'localhost'
# Backup Date and Time: 2024-01-18 10:28
# Built by Wayz Consulting 2.4.3
# http://frontaccounting.com
# Company: Mr Xperts
# User: Company Admin

# Compatibility: 2.4.1

# Comment:
# Backup After Importing The Items, 


SET NAMES utf8;


### Structure of table `0_agreement_pricing` ###

DROP TABLE IF EXISTS `0_agreement_pricing`;

CREATE TABLE `0_agreement_pricing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(500) NOT NULL,
  `payment_terms` varchar(100) NOT NULL,
  `price` int(20) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreement_pricing` ###


### Structure of table `0_agreements` ###

DROP TABLE IF EXISTS `0_agreements`;

CREATE TABLE `0_agreements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `dates` date NOT NULL,
  `provider` varchar(150) NOT NULL,
  `provider_representative` varchar(150) NOT NULL,
  `provider_email` varchar(150) NOT NULL,
  `provider_address` varchar(150) NOT NULL,
  `provider_desgination` varchar(150) NOT NULL,
  `client` varchar(150) NOT NULL,
  `client_representative` varchar(150) NOT NULL,
  `client_email` varchar(150) NOT NULL,
  `client_address` varchar(150) NOT NULL,
  `client_designation` varchar(150) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  `reference` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements` ###


### Structure of table `0_agreements_matters` ###

DROP TABLE IF EXISTS `0_agreements_matters`;

CREATE TABLE `0_agreements_matters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agreement_no` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `agreement_matter` mediumtext NOT NULL,
  `template` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements_matters` ###


### Structure of table `0_agreements_modules` ###

DROP TABLE IF EXISTS `0_agreements_modules`;

CREATE TABLE `0_agreements_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) NOT NULL,
  `sections` text NOT NULL,
  `areas` text NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements_modules` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('5', 'Dubai', '0'),
('6', 'Sharjah', '0'),
('7', 'Ras Al Khaima', '0'),
('8', 'Umm Al Quwain', '0'),
('9', 'Default', '0'),
('10', 'Abu Dhabi', '0'),
('11', 'Fujairah', '0'),
('12', 'Ajman', '0');

### Structure of table `0_attach_inquiry` ###

DROP TABLE IF EXISTS `0_attach_inquiry`;

CREATE TABLE `0_attach_inquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `by_user` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted` tinyint(1) NOT NULL,
  `edited` int(11) NOT NULL,
  `notes` text NOT NULL,
  `flagged` tinyint(1) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_attach_inquiry` ###


### Structure of table `0_attach_inquiry_detail` ###

DROP TABLE IF EXISTS `0_attach_inquiry_detail`;

CREATE TABLE `0_attach_inquiry_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `short_description` varchar(200) NOT NULL,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  `attach_id` int(11) NOT NULL,
  `note` text NOT NULL,
  `flagged` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attach_inquiry_detail` ###


### Structure of table `0_attach_inquiry_link_detail` ###

DROP TABLE IF EXISTS `0_attach_inquiry_link_detail`;

CREATE TABLE `0_attach_inquiry_link_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL,
  `trans_type` int(11) NOT NULL,
  `attach_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_attach_inquiry_link_detail` ###


### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `short_description` varchar(200) NOT NULL,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_attendance` ###

DROP TABLE IF EXISTS `0_attendance`;

CREATE TABLE `0_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `overtime_id` int(11) NOT NULL,
  `hours_no` float NOT NULL DEFAULT 0,
  `rate` float NOT NULL DEFAULT 1,
  `att_date` date NOT NULL,
  `is_leave` int(1) NOT NULL,
  `from_leave` date NOT NULL,
  `to_leave` date NOT NULL,
  `reason` varchar(255) NOT NULL,
  `time` varchar(70) NOT NULL,
  `time_out` varchar(50) NOT NULL,
  `in_out` int(11) NOT NULL,
  `leave_type` int(11) NOT NULL,
  `approved` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attendance` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  `notification_status` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=4252 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '1028', '1', '25', '2024-01-12 10:31:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('2', '1028', '2', '25', '2024-01-12 22:29:59', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('3', '1028', '1067', '25', '2024-01-12 10:32:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('4', '1028', '12', '25', '2024-01-12 10:32:58', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('5', '1028', '1205', '25', '2024-01-12 10:33:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('6', '1028', '980', '25', '2024-01-12 10:33:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('7', '1028', '1520', '25', '2024-01-12 10:33:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('8', '1028', '1540', '25', '2024-01-12 10:34:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('9', '1028', '1550', '25', '2024-01-12 10:34:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('10', '1028', '1820', '25', '2024-01-12 10:34:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('11', '1028', '1821', '25', '2024-01-12 10:34:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('12', '1028', '1830', '25', '2024-01-12 10:34:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('13', '1028', '1840', '25', '2024-01-12 10:35:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('14', '1028', '1850', '25', '2024-01-12 10:35:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('15', '1028', '2101', '25', '2024-01-12 10:35:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('16', '1028', '2110', '25', '2024-01-12 10:35:43', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('17', '1028', '2120', '25', '2024-01-12 10:35:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('18', '1028', '2130', '25', '2024-01-12 10:36:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('19', '1028', '2140', '25', '2024-01-12 10:36:11', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('20', '1028', '2160', '25', '2024-01-12 10:36:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('21', '1028', '2210', '25', '2024-01-12 10:36:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('22', '1028', '2230', '25', '2024-01-12 10:36:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('23', '1028', '2240', '25', '2024-01-12 10:36:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('24', '1028', '2320', '25', '2024-01-12 10:37:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('25', '1028', '2340', '25', '2024-01-12 10:37:22', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('26', '1028', '2350', '25', '2024-01-12 10:37:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('27', '1028', '2360', '25', '2024-01-12 10:37:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('28', '1028', '2380', '25', '2024-01-12 10:37:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('29', '1028', '2680', '25', '2024-01-12 10:38:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('30', '1028', '2620', '25', '2024-01-12 10:38:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('31', '1028', '3580', '25', '2024-01-12 10:38:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('32', '1028', '2040', '25', '2024-01-12 10:39:09', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('33', '1028', '2031', '25', '2024-01-12 10:39:28', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('34', '1028', '2032', '25', '2024-01-12 10:39:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('35', '1028', '2033', '25', '2024-01-12 10:39:55', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('36', '1028', '4011', '25', '2024-01-12 10:40:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('37', '1028', '4012', '25', '2024-01-12 10:40:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('38', '1028', '4440', '25', '2024-01-12 10:40:45', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('39', '1028', '10002', '25', '2024-01-12 10:41:13', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('40', '1028', '5440', '25', '2024-01-12 10:41:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('41', '1028', '5450', '25', '2024-01-12 10:42:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('42', '1028', '5460', '25', '2024-01-12 10:42:11', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('43', '1028', '5470', '25', '2024-01-12 10:42:23', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('44', '1028', '5510', '25', '2024-01-12 10:42:40', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('45', '1028', '5520', '25', '2024-01-12 10:42:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('46', '1028', '5530', '25', '2024-01-12 10:43:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('47', '1028', '5540', '25', '2024-01-12 10:43:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('48', '1028', '5550', '25', '2024-01-12 10:43:19', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('49', '1028', '5560', '25', '2024-01-12 10:43:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('50', '1028', '5410', '25', '2024-01-12 10:43:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('51', '1028', '5610', '25', '2024-01-12 10:43:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('52', '1028', '5615', '25', '2024-01-12 10:44:24', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('53', '1028', '5616', '25', '2024-01-12 10:44:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('54', '1028', '5617', '25', '2024-01-12 10:44:37', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('55', '1028', '5618', '25', '2024-01-12 10:44:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('56', '1028', '5619', '25', '2024-01-12 10:44:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('57', '1028', '5700', '25', '2024-01-12 10:45:07', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('58', '1028', '5760', '25', '2024-01-12 10:45:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('59', '1028', '5785', '25', '2024-01-12 10:45:33', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('60', '1028', '5790', '25', '2024-01-12 10:45:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('61', '1028', '5795', '25', '2024-01-12 10:45:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('62', '1028', '5800', '25', '2024-01-12 10:46:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('63', '1028', '5810', '25', '2024-01-12 10:46:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('64', '1028', '5820', '25', '2024-01-12 10:46:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('65', '1028', '10001', '25', '2024-01-12 10:46:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('66', '1028', '5425', '25', '2024-01-12 20:29:16', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('67', '1028', '5426', '25', '2024-01-12 20:30:30', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('68', '1028', '5428', '25', '2024-01-12 10:48:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('69', '1028', '5430', '25', '2024-01-12 10:49:17', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('70', '1028', '1913', '25', '2024-01-12 10:49:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('71', '1028', '1915', '25', '2024-01-12 20:26:54', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('72', '1028', '1880', '25', '2024-01-12 10:50:15', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('73', '1028', '1882', '25', '2024-01-12 10:50:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('74', '1028', '1883', '25', '2024-01-12 10:50:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('75', '1028', '1884', '25', '2024-01-12 10:50:49', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('76', '1028', '1885', '25', '2024-01-12 10:51:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('77', '1028', '1887', '25', '2024-01-12 10:51:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('78', '1028', '1889', '25', '2024-01-12 10:52:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('79', '1028', '1890', '25', '2024-01-12 10:52:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('80', '1028', '1891', '25', '2024-01-12 10:53:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('81', '1028', '1892', '25', '2024-01-12 10:53:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('82', '1028', '1893', '25', '2024-01-12 10:54:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('83', '1028', '1894', '25', '2024-01-12 10:54:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('84', '1028', '1895', '25', '2024-01-12 10:54:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('85', '1028', '1896', '25', '2024-01-12 10:54:52', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('86', '1028', '1898', '25', '2024-01-12 10:54:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('87', '1028', '1899', '25', '2024-01-12 10:55:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('88', '1028', '1900', '25', '2024-01-12 10:55:05', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('89', '1028', '1901', '25', '2024-01-12 10:58:13', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('90', '1028', '1902', '25', '2024-01-12 10:58:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('91', '1028', '1903', '25', '2024-01-12 10:58:19', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('92', '1028', '1904', '25', '2024-01-12 10:58:21', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('93', '1028', '1906', '25', '2024-01-12 10:58:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('94', '1028', '1907', '25', '2024-01-12 10:58:34', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('95', '1028', '1908', '25', '2024-01-12 10:58:38', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('96', '1028', '1909', '25', '2024-01-12 10:58:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('97', '1028', '1910', '25', '2024-01-12 10:58:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('98', '1028', '1911', '25', '2024-01-12 10:58:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('99', '1028', '1912', '25', '2024-01-12 10:59:01', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('100', '1028', '1920', '25', '2024-01-12 11:00:38', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('101', '1028', '1921', '25', '2024-01-12 11:00:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('102', '1028', '1922', '25', '2024-01-12 11:00:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('103', '1028', '1923', '25', '2024-01-12 11:00:52', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('104', '1028', '1924', '25', '2024-01-12 11:00:55', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('105', '1028', '1926', '25', '2024-01-12 11:00:58', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('106', '1028', '1925', '25', '2024-01-12 11:01:02', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('107', '1028', '1927', '25', '2024-01-12 11:01:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('108', '1028', '1928', '25', '2024-01-12 11:01:09', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('109', '1028', '1929', '25', '2024-01-12 11:01:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('110', '1028', '5422', '25', '2024-01-12 20:28:02', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('111', '1028', '5561', '25', '2024-01-12 11:01:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('112', '1028', '5620', '25', '2024-01-12 11:01:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('113', '1028', '5685', '25', '2024-01-12 11:01:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('114', '1028', '5765', '25', '2024-01-12 11:02:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('115', '1028', '1801', '25', '2024-01-12 11:02:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('116', '1028', '3350', '25', '2024-01-12 11:02:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('117', '1028', '3581', '25', '2024-01-12 11:02:57', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('118', '1028', '2021', '25', '2024-01-12 11:03:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('119', '1028', '2023', '25', '2024-01-12 11:03:26', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('120', '1028', '5020', '25', '2024-01-12 20:40:55', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('121', '1028', '5030', '25', '2024-01-12 20:49:14', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('122', '1028', '5050', '25', '2024-01-12 20:50:41', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('123', '1028', '5100', '25', '2024-01-12 11:07:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('124', '1028', '1236', '25', '2024-01-12 11:07:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('125', '1028', '1234', '25', '2024-01-12 11:07:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('126', '1028', '1235', '25', '2024-01-12 11:07:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('127', '1028', '901', '25', '2024-01-12 11:08:08', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('128', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('129', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('130', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('131', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('132', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('133', '1028', '1065', '25', '2024-01-12 12:09:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('134', '1028', '1066', '25', '2024-01-12 12:10:01', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('135', '1028', '960', '25', '2024-01-12 12:11:39', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('136', '1028', '960', '25', '2024-01-12 23:37:43', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('137', '1029', '2', '1', '2024-01-12 14:24:33', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('138', '1029', '2', '1', '2024-01-12 23:22:29', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('139', '1029', '15', '1', '2024-01-12 14:25:32', 'Bank Account Deleted', '13', '2024-01-12', '0', '0', '0'),
('140', '1029', '14', '1', '2024-01-12 14:25:35', 'Bank Account Deleted', '13', '2024-01-12', '0', '0', '0'),
('141', '1029', '9', '1', '2024-01-12 14:25:58', 'Account Type Updated', '13', '2024-01-12', '0', '0', '0'),
('142', '1028', '1905', '1', '2024-01-12 16:06:05', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('143', '1028', '5660', '1', '2024-01-12 19:17:31', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('144', '1028', '5040', '1', '2024-01-12 16:09:19', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('145', '1029', '21', '1', '2024-01-12 16:16:37', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('146', '1028', '210101', '1', '2024-01-12 16:15:52', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('147', '1028', '5780', '1', '2024-01-12 16:15:36', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('148', '1028', '5780', '1', '2024-01-12 16:15:36', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('149', '1028', '210101', '1', '2024-01-12 16:15:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('150', '1029', '21', '1', '2024-01-13 00:27:34', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('151', '1028', '9990', '1', '2024-01-12 16:18:28', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('152', '1028', '21001', '1', '2024-01-12 16:20:36', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('153', '1028', '21002', '1', '2024-01-12 16:21:20', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('154', '1028', '21003', '1', '2024-01-13 00:27:00', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('155', '1028', '21004', '1', '2024-01-12 16:23:06', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('156', '1028', '21005', '1', '2024-01-12 20:20:52', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('157', '1028', '21006', '1', '2024-01-13 00:25:35', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('158', '1028', '21007', '1', '2024-01-12 16:25:10', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('159', '1028', '21008', '1', '2024-01-13 00:24:04', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('160', '1028', '21009', '1', '2024-01-12 16:51:50', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('161', '1028', '21010', '1', '2024-01-12 16:52:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('162', '1028', '21011', '1', '2024-01-13 00:34:24', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('163', '1028', '21012', '1', '2024-01-13 00:12:46', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('164', '1028', '21013', '1', '2024-01-12 19:00:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('165', '1028', '21014', '1', '2024-01-12 19:14:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('166', '1028', '21015', '1', '2024-01-12 19:14:53', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('167', '1028', '21016', '1', '2024-01-16 10:29:23', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('168', '1028', '21017', '1', '2024-01-12 19:16:31', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('169', '1028', '21018', '1', '2024-01-12 19:17:15', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('170', '1028', '5660', '1', '2024-01-12 19:17:31', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('171', '1028', '21019', '1', '2024-01-12 19:18:08', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('172', '1028', '21020', '1', '2024-01-12 20:08:43', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('173', '1028', '21021', '1', '2024-01-12 20:10:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('174', '1028', '21022', '1', '2024-01-13 00:36:31', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('175', '1028', '21023', '1', '2024-01-12 20:14:31', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('176', '1028', '21024', '1', '2024-01-12 20:17:44', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('177', '1028', '21025', '1', '2024-01-12 20:18:07', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('178', '1028', '21026', '1', '2024-01-12 20:18:41', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('179', '1028', '21027', '1', '2024-01-12 20:19:19', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('180', '1028', '21005', '1', '2024-01-12 20:20:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('181', '1028', '21028', '1', '2024-01-12 20:21:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('182', '1028', '21029', '1', '2024-01-12 20:22:02', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('183', '1028', '21030', '1', '2024-01-17 10:04:41', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('184', '1028', '21031', '1', '2024-01-17 10:04:26', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('185', '1028', '21032', '1', '2024-01-12 20:24:27', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('186', '1028', '21033', '1', '2024-01-12 20:24:57', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('187', '1028', '21034', '1', '2024-01-17 10:08:15', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('188', '1028', '1915', '1', '2024-01-12 20:26:54', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('189', '1028', '5422', '1', '2024-01-12 20:28:02', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('190', '1028', '5425', '1', '2024-01-12 20:29:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('191', '1028', '5426', '1', '2024-01-12 20:30:30', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('192', '1028', '5421', '1', '2024-01-12 20:31:17', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('193', '1028', '21035', '1', '2024-01-12 20:32:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('194', '1028', '4500', '1', '2024-01-12 20:34:05', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('195', '1028', '5060', '1', '2024-01-12 20:37:39', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('196', '1028', '5020', '1', '2024-01-12 20:40:55', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('197', '1028', '5030', '1', '2024-01-12 20:49:14', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('198', '1028', '5050', '1', '2024-01-12 20:50:41', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('199', '1028', '5070', '1', '2024-01-12 20:51:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('200', '1028', '4009', '1', '2024-01-12 20:51:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('201', '1028', '4430', '1', '2024-01-12 22:16:38', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('202', '1028', '4010', '1', '2024-01-12 22:17:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('203', '1028', '2034', '1', '2024-01-12 22:21:03', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('204', '1030', '10', '1', '2024-01-12 22:25:27', 'Account Class Added', '13', '2024-01-12', '0', '0', '0'),
('205', '1029', '24', '1', '2024-01-12 22:33:23', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('206', '1028', '2', '1', '2024-01-12 22:29:59', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('207', '1028', '20001', '1', '2024-01-12 22:30:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('208', '1029', '24', '1', '2024-01-12 22:40:05', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('209', '1028', '24001', '1', '2024-01-12 22:35:25', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('210', '1028', '24002', '1', '2024-01-12 22:36:07', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('211', '1028', '24003', '1', '2024-01-12 22:36:42', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('212', '1028', '24004', '1', '2024-01-12 22:37:19', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('213', '1028', '24005', '1', '2024-01-12 22:37:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('214', '1028', '24006', '1', '2024-01-12 22:38:26', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('215', '1029', '24', '1', '2024-01-12 22:49:56', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('216', '1028', '24007', '1', '2024-01-12 22:41:00', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('217', '1028', '24008', '1', '2024-01-12 22:41:48', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('218', '1028', '24009', '1', '2024-01-12 22:42:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('219', '1028', '24010', '1', '2024-01-12 22:43:35', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('220', '1029', '24', '1', '2024-01-12 22:50:41', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('221', '1029', '24', '1', '2024-01-12 22:50:54', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('222', '1029', '24', '1', '2024-01-12 22:51:03', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('223', '1029', '24', '1', '2024-01-12 22:51:12', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('224', '1029', '24', '1', '2024-01-12 23:21:43', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('225', '1028', '3', '1', '2024-01-12 22:52:22', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('226', '1009', '97', '1', '2024-01-15 15:37:31', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('227', '1009', '98', '1', '2024-01-15 15:37:49', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('228', '1028', '24012', '1', '2024-01-12 22:58:15', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('229', '1009', '132', '1', '2024-01-15 15:38:03', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('230', '1009', '99', '1', '2024-01-15 15:38:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('231', '1009', '100', '1', '2024-01-16 10:53:53', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('232', '1028', '24013', '1', '2024-01-12 23:01:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('233', '1009', '101', '1', '2024-01-16 10:57:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('234', '1028', '24014', '1', '2024-01-12 23:03:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('235', '1009', '102', '1', '2024-01-16 10:57:33', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('236', '1028', '24015', '1', '2024-01-12 23:05:20', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('237', '1009', '94', '1', '2024-01-16 10:57:53', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('238', '1028', '24016', '1', '2024-01-12 23:07:23', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('239', '1028', '24017', '1', '2024-01-12 23:07:55', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('240', '1028', '24018', '1', '2024-01-12 23:08:28', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('241', '1009', '103', '1', '2024-01-16 10:58:09', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('242', '1009', '104', '1', '2024-01-16 10:58:35', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('243', '1009', '105', '1', '2024-01-16 10:59:00', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('244', '1028', '24019', '1', '2024-01-12 23:11:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('245', '1009', '106', '1', '2024-01-16 10:59:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('246', '1028', '24021', '1', '2024-01-12 23:13:08', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('247', '1009', '107', '1', '2024-01-16 10:59:30', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('248', '1028', '24022', '1', '2024-01-12 23:14:35', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('249', '1009', '108', '1', '2024-01-16 10:59:51', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('250', '1028', '24023', '1', '2024-01-12 23:15:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('251', '1009', '109', '1', '2024-01-16 11:00:08', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('252', '1028', '24025', '1', '2024-01-12 23:19:39', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('253', '1028', '24026', '1', '2024-01-12 23:20:39', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('254', '1029', '24', '1', '2024-01-12 23:23:19', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('255', '1029', '2', '1', '2024-01-12 23:22:29', 'Account Type Updated', '13', '2024-01-12', '0', '0', '0'),
('256', '1029', '24', '1', '2024-01-12 23:24:52', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('257', '1029', '24', '1', '2024-01-12 23:25:32', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('258', '1029', '24', '1', '2024-01-12 23:52:19', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('259', '1028', '24027', '1', '2024-01-12 23:26:44', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('260', '1028', '24028', '1', '2024-01-12 23:27:25', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('261', '1028', '24029', '1', '2024-01-12 23:28:26', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('262', '1028', '24030', '1', '2024-01-12 23:29:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('263', '1028', '24031', '1', '2024-01-12 23:30:18', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('264', '1028', '24032', '1', '2024-01-12 23:31:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('265', '1028', '24033', '1', '2024-01-12 23:31:51', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('266', '1028', '24034', '1', '2024-01-12 23:32:22', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('267', '1028', '24035', '1', '2024-01-12 23:32:49', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('268', '1028', '24036', '1', '2024-01-12 23:33:12', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('269', '1028', '24037', '1', '2024-01-12 23:36:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('270', '1028', '24038', '1', '2024-01-12 23:37:12', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('271', '1028', '960', '1', '2024-01-12 23:37:43', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('272', '1028', '970', '1', '2024-01-12 23:37:49', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('273', '1028', '4450', '1', '2024-01-12 23:41:46', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('274', '114', '1', '1', '2024-01-12 23:48:22', 'Account Tag Added', '13', '2024-01-12', '0', '0', '0'),
('275', '1028', '240038', '1', '2024-01-12 23:52:36', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('276', '1029', '24', '1', '2024-01-13 00:14:51', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('277', '1028', '240038', '1', '2024-01-12 23:52:44', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('278', '1028', '240038', '1', '2024-01-12 23:52:44', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('279', '1028', '21036', '1', '2024-01-12 23:53:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('280', '1028', '21037', '1', '2024-01-12 23:53:47', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('281', '1028', '21038', '1', '2024-01-13 00:07:07', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('282', '1028', '21039', '1', '2024-01-13 00:07:36', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('283', '1028', '21040', '1', '2024-01-13 00:07:56', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('284', '1028', '21041', '1', '2024-01-13 00:08:28', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('285', '1028', '21042', '1', '2024-01-13 00:09:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('286', '1028', '21043', '1', '2024-01-13 00:10:03', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('287', '1028', '21044', '1', '2024-01-13 00:10:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('288', '1028', '21045', '1', '2024-01-13 00:11:01', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('289', '1028', '21012', '1', '2024-01-13 00:12:46', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('290', '1029', '24', '1', '2024-01-13 00:20:01', 'Account Type Added', '13', '2024-01-13', NULL, '0', '0'),
('291', '1028', '21046', '1', '2024-01-13 00:16:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('292', '1028', '21047', '1', '2024-01-13 00:16:30', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('293', '1028', '21048', '1', '2024-01-13 00:17:05', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('294', '1028', '21049', '1', '2024-01-13 00:17:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('295', '1028', '21050', '1', '2024-01-13 00:18:03', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('296', '1029', '24', '1', '2024-01-13 00:20:01', 'Account Type Added', '13', '2024-01-13', '0', '0', '0'),
('297', '1028', '21051', '1', '2024-01-13 00:20:35', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('298', '1028', '21052', '1', '2024-01-13 00:21:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('299', '1028', '21053', '1', '2024-01-13 00:21:27', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('300', '1028', '21054', '1', '2024-01-13 00:21:50', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('301', '1028', '21055', '1', '2024-01-17 09:59:46', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('302', '1028', '21056', '1', '2024-01-13 00:22:34', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('303', '1028', '21057', '1', '2024-01-13 00:23:01', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('304', '1028', '21058', '1', '2024-01-13 00:23:46', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('305', '1028', '21008', '1', '2024-01-13 00:24:04', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('306', '1028', '21006', '1', '2024-01-13 00:25:35', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('307', '1028', '21059', '1', '2024-01-13 00:26:06', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('308', '1028', '21003', '1', '2024-01-13 00:27:00', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('309', '1029', '21', '1', '2024-01-13 00:27:34', 'Account Type Added', '13', '2024-01-13', '0', '0', '0'),
('310', '1028', '21060', '1', '2024-01-13 00:28:31', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('311', '1028', '21061', '1', '2024-01-13 00:28:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('312', '1028', '21062', '1', '2024-01-13 00:29:13', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('313', '1028', '21063', '1', '2024-01-17 09:46:28', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('314', '1028', '21064', '1', '2024-01-13 00:29:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('315', '1028', '21065', '1', '2024-01-13 00:30:12', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('316', '1028', '21066', '1', '2024-01-13 00:30:28', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('317', '1028', '21067', '1', '2024-01-17 09:47:01', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('318', '1028', '21068', '1', '2024-01-13 00:31:07', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('319', '1028', '21069', '1', '2024-01-13 00:31:39', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('320', '1028', '21070', '1', '2024-01-13 00:31:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('321', '1028', '21071', '1', '2024-01-13 00:32:12', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('322', '1028', '21072', '1', '2024-01-13 00:32:35', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('323', '1028', '21073', '1', '2024-01-13 00:32:51', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('324', '1028', '21074', '1', '2024-01-13 00:33:46', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('325', '1028', '21011', '1', '2024-01-13 00:34:24', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('326', '1028', '21075', '1', '2024-01-13 00:35:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('327', '1028', '21022', '1', '2024-01-13 00:36:31', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('328', '0', '1', '1', '2024-01-13 10:36:28', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('329', '0', '1', '1', '2024-01-13 10:36:28', 'Voided.\nDocument reentered.', '13', '2024-01-13', '0', '0', '0'),
('330', '0', '2', '1', '2024-01-13 10:36:28', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('331', '0', '3', '1', '2024-01-14 23:02:52', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('332', '1002', '17', '1', '2024-01-15 16:37:53', 'Update Branch', '13', '2024-01-14', NULL, '0', '0'),
('333', '1028', '21076', '1', '2024-01-14 23:14:55', 'Account Data Added', '13', '2024-01-14', '0', '0', '0'),
('334', '0', '4', '1', '2024-01-15 15:46:39', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('335', '1001', '247', '1', '2024-01-15 15:28:37', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('336', '1002', '243', '1', '2024-01-15 15:28:37', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('337', '1001', '249', '1', '2024-01-15 15:34:22', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('338', '1002', '244', '1', '2024-01-15 15:34:22', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('339', '1001', '250', '1', '2024-01-15 15:36:33', 'Create New Customer', '13', '2024-01-15', NULL, '0', '0'),
('340', '1002', '245', '1', '2024-01-15 15:36:03', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('341', '1001', '250', '1', '2024-01-15 15:36:33', 'Update Customer', '13', '2024-01-15', '0', '0', '0'),
('342', '1009', '97', '1', '2024-01-16 10:56:13', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('343', '1009', '98', '1', '2024-01-16 10:52:47', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('344', '1009', '132', '1', '2024-01-15 15:39:16', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('345', '1009', '99', '1', '2024-01-15 15:38:18', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('346', '1009', '99', '1', '2024-01-15 15:38:26', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('347', '1009', '99', '1', '2024-01-15 15:38:38', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('348', '1009', '99', '1', '2024-01-15 15:38:45', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('349', '1009', '99', '1', '2024-01-15 15:38:48', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('350', '1009', '99', '1', '2024-01-15 15:38:57', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('351', '1001', '251', '1', '2024-01-15 15:38:50', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('352', '1002', '246', '1', '2024-01-15 15:38:50', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('353', '1009', '99', '1', '2024-01-15 15:44:38', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('354', '1009', '132', '1', '2024-01-15 15:39:40', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('355', '1009', '132', '1', '2024-01-15 15:44:00', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('356', '1009', '132', '1', '2024-01-15 15:44:29', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('357', '1009', '132', '1', '2024-01-16 10:56:34', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('358', '1009', '99', '1', '2024-01-15 15:48:40', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('359', '0', '4', '1', '2024-01-15 15:46:39', 'Voided.\nDocument reentered.', '13', '2024-01-15', '0', '0', '0'),
('360', '0', '5', '1', '2024-01-16 10:37:32', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('361', '1009', '99', '1', '2024-01-15 15:48:45', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('362', '1009', '99', '1', '2024-01-15 15:48:49', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('363', '1009', '99', '1', '2024-01-15 15:48:53', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('364', '1009', '99', '1', '2024-01-15 15:49:12', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('365', '1009', '99', '1', '2024-01-16 07:57:18', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('366', '1002', '9', '1', '2024-01-15 15:52:30', 'Delete Branch', '13', '2024-01-15', '0', '0', '0'),
('367', '1001', '10', '1', '2024-01-15 15:52:54', 'Delete Customer', '13', '2024-01-15', '0', '0', '0'),
('368', '1002', '17', '25', '2024-01-15 16:46:25', 'Update Branch', '13', '2024-01-15', NULL, '0', '0'),
('369', '1002', '17', '25', '2024-01-15 16:46:58', 'Update Branch', '13', '2024-01-15', NULL, '0', '0'),
('370', '1002', '17', '25', '2024-01-15 16:46:58', 'Update Branch', '13', '2024-01-15', '0', '0', '0'),
('371', '0', '6', '1', '2024-01-15 18:19:30', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('372', '1009', '99', '1', '2024-01-16 08:01:28', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('373', '1009', '99', '1', '2024-01-16 10:48:49', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('374', '1010', '0', '1', '2024-01-16 09:50:02', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('375', '1011', '607', '1', '2024-01-16 09:55:18', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('376', '1010', '0', '1', '2024-01-16 09:50:39', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('377', '1010', '0', '1', '2024-01-16 09:51:58', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('378', '1010', '0', '1', '2024-01-16 09:52:51', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('379', '1010', '0', '1', '2024-01-16 09:53:30', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('380', '1010', '0', '1', '2024-01-16 09:54:01', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('381', '1010', '0', '1', '2024-01-16 09:55:18', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('382', '1010', '0', '1', '2024-01-16 09:55:42', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('383', '1011', '607', '1', '2024-01-16 09:55:42', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('384', '1010', '0', '1', '2024-01-16 09:56:07', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('385', '1011', '607', '1', '2024-01-16 09:56:07', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('386', '1010', '0', '1', '2024-01-16 09:58:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('387', '1011', '607', '1', '2024-01-16 09:58:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('388', '1010', '0', '1', '2024-01-16 09:58:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('389', '1011', '607', '1', '2024-01-16 09:58:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('390', '1010', '0', '1', '2024-01-16 09:59:16', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('391', '1011', '607', '1', '2024-01-16 09:59:16', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('392', '1010', '0', '1', '2024-01-16 09:59:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('393', '1011', '607', '1', '2024-01-16 09:59:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('394', '1010', '0', '1', '2024-01-16 10:00:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('395', '1011', '607', '1', '2024-01-16 10:00:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('396', '1010', '0', '1', '2024-01-16 10:01:19', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('397', '1011', '607', '1', '2024-01-16 10:01:19', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('398', '1010', '0', '1', '2024-01-16 10:01:35', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('399', '1011', '607', '1', '2024-01-16 10:01:35', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('400', '1010', '0', '1', '2024-01-16 10:02:28', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('401', '1011', '607', '1', '2024-01-16 10:02:28', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('402', '1010', '0', '1', '2024-01-16 10:03:29', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('403', '1011', '607', '1', '2024-01-16 10:03:29', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('404', '1010', '0', '1', '2024-01-16 10:03:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('405', '1011', '607', '1', '2024-01-16 10:03:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('406', '1010', '0', '1', '2024-01-16 10:04:09', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('407', '1011', '607', '1', '2024-01-16 10:04:09', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('408', '1010', '0', '1', '2024-01-16 10:04:38', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('409', '1011', '607', '1', '2024-01-16 10:04:38', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('410', '1010', '0', '1', '2024-01-16 10:05:05', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('411', '1011', '607', '1', '2024-01-16 10:05:05', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('412', '1010', '0', '1', '2024-01-16 10:05:23', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('413', '1011', '607', '1', '2024-01-16 10:05:23', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('414', '1010', '0', '1', '2024-01-16 10:05:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('415', '1011', '607', '1', '2024-01-16 10:05:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('416', '1010', '0', '1', '2024-01-16 10:06:22', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('417', '1011', '607', '1', '2024-01-16 10:06:22', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('418', '1010', '0', '1', '2024-01-16 10:06:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('419', '1011', '607', '1', '2024-01-16 10:06:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('420', '1010', '0', '1', '2024-01-16 10:06:51', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('421', '1011', '607', '1', '2024-01-16 10:06:51', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('422', '1010', '0', '1', '2024-01-16 10:06:59', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('423', '1011', '607', '1', '2024-01-16 10:06:59', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('424', '1010', '0', '1', '2024-01-16 10:07:08', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('425', '1011', '607', '1', '2024-01-16 10:07:08', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('426', '1010', '0', '1', '2024-01-16 10:07:36', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('427', '1011', '607', '1', '2024-01-16 10:07:36', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('428', '1010', '0', '1', '2024-01-16 10:07:46', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('429', '1011', '607', '1', '2024-01-16 10:07:46', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('430', '1010', '0', '1', '2024-01-16 10:08:10', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('431', '1011', '607', '1', '2024-01-16 10:08:10', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('432', '1010', '0', '1', '2024-01-16 10:08:49', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('433', '1011', '607', '1', '2024-01-16 10:08:49', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('434', '1010', '0', '1', '2024-01-16 10:09:15', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('435', '1011', '607', '1', '2024-01-16 10:09:15', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('436', '1010', '0', '1', '2024-01-16 10:09:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('437', '1011', '607', '1', '2024-01-16 10:09:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('438', '1010', '0', '1', '2024-01-16 10:09:53', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('439', '1011', '607', '1', '2024-01-16 10:09:53', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('440', '1010', '0', '1', '2024-01-16 10:10:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('441', '1011', '607', '1', '2024-01-16 10:11:18', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('442', '1010', '0', '1', '2024-01-16 10:11:18', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('443', '1010', '0', '1', '2024-01-16 10:11:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('444', '1011', '607', '1', '2024-01-16 10:11:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('445', '1010', '0', '1', '2024-01-16 10:11:51', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('446', '1011', '607', '1', '2024-01-16 10:12:03', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('447', '1010', '0', '1', '2024-01-16 10:12:03', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('448', '1010', '0', '1', '2024-01-16 10:12:09', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('449', '1011', '607', '1', '2024-01-16 10:12:09', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('450', '1010', '0', '1', '2024-01-16 10:12:40', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('451', '1011', '607', '1', '2024-01-16 10:12:40', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('452', '1010', '0', '1', '2024-01-16 16:14:07', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('453', '1011', '607', '1', '2024-01-16 16:14:07', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('454', '1028', '21016', '1', '2024-01-16 10:29:23', 'Account Data Deleted', '13', '2024-01-16', '0', '0', '0'),
('455', '0', '5', '1', '2024-01-16 10:37:32', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('456', '0', '7', '1', '2024-01-16 10:41:24', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('457', '0', '7', '1', '2024-01-16 10:41:24', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('458', '0', '8', '1', '2024-01-16 11:00:38', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('459', '1', '2', '1', '2024-01-16 15:27:58', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('460', '1009', '99', '1', '2024-01-16 10:50:14', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('461', '1009', '99', '25', '2024-01-16 10:51:43', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('462', '1009', '99', '25', '2024-01-16 10:51:53', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('463', '1009', '99', '25', '2024-01-16 10:52:21', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('464', '1009', '99', '1', '2024-01-16 10:52:21', 'Update Supplier', '13', '2024-01-16', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('465', '1009', '98', '1', '2024-01-16 10:52:47', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('466', '1009', '89', '1', '2024-01-16 10:53:26', 'Delete Supplier', '13', '2024-01-16', '0', '0', '0'),
('467', '1009', '100', '1', '2024-01-16 10:53:53', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('468', '1009', '97', '1', '2024-01-16 10:56:13', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('469', '1009', '132', '1', '2024-01-16 10:56:34', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('470', '1009', '101', '1', '2024-01-16 10:57:14', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('471', '1009', '102', '1', '2024-01-16 10:57:33', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('472', '1009', '94', '1', '2024-01-16 10:57:53', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('473', '1009', '103', '1', '2024-01-16 10:58:09', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('474', '1009', '104', '1', '2024-01-16 10:58:35', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('475', '1009', '105', '1', '2024-01-16 10:59:00', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('476', '1009', '106', '1', '2024-01-16 10:59:14', 'Delete Supplier', '13', '2024-01-16', '0', '0', '0'),
('477', '1009', '107', '1', '2024-01-16 10:59:30', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('478', '1009', '108', '1', '2024-01-16 10:59:51', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('479', '1009', '109', '1', '2024-01-16 11:00:08', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('480', '0', '8', '1', '2024-01-16 11:00:38', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('481', '0', '9', '1', '2024-01-16 11:05:55', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('482', '0', '9', '1', '2024-01-16 11:05:55', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('483', '0', '10', '1', '2024-01-16 11:16:55', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('484', '0', '10', '1', '2024-01-16 11:16:55', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('485', '0', '11', '1', '2024-01-16 13:04:27', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('486', '0', '11', '1', '2024-01-16 13:04:27', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('487', '0', '12', '1', '2024-01-16 15:18:07', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('488', '0', '12', '1', '2024-01-16 15:18:07', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('489', '0', '13', '1', '2024-01-16 15:22:38', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('490', '3', '20001', '1', '2024-01-16 15:28:55', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('491', '0', '13', '1', '2024-01-16 15:22:38', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('492', '0', '14', '1', '2024-01-16 15:30:17', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('493', '3', '21076', '1', '2024-01-16 15:28:32', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('494', '1', '2', '1', '2024-01-16 15:27:58', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('495', '3', '21076', '1', '2024-01-16 15:28:32', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('496', '3', '20001', '1', '2024-01-16 15:28:55', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('497', '0', '14', '1', '2024-01-16 15:30:17', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('498', '0', '15', '1', '2024-01-16 15:30:17', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('499', '1010', '0', '1', '2024-01-16 16:15:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('500', '1011', '607', '1', '2024-01-16 16:15:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('501', '1010', '0', '1', '2024-01-16 16:16:12', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('502', '1011', '607', '1', '2024-01-16 16:16:12', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('503', '1010', '0', '1', '2024-01-16 16:16:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('504', '1011', '607', '1', '2024-01-16 16:16:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('505', '1010', '0', '1', '2024-01-16 16:18:01', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('506', '1011', '607', '1', '2024-01-16 16:18:01', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('507', '1010', '0', '1', '2024-01-16 16:18:21', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('508', '1011', '607', '1', '2024-01-16 16:18:21', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('509', '1010', '0', '1', '2024-01-16 16:19:25', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('510', '1011', '607', '1', '2024-01-16 16:19:25', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('511', '1010', '0', '1', '2024-01-16 16:30:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('512', '1011', '607', '1', '2024-01-16 16:30:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('513', '1010', '0', '1', '2024-01-16 16:31:17', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('514', '1011', '607', '1', '2024-01-16 16:31:17', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('515', '1010', '0', '1', '2024-01-16 16:34:24', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('516', '1011', '607', '1', '2024-01-16 16:34:24', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('517', '1010', '0', '1', '2024-01-16 16:34:50', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('518', '1011', '607', '1', '2024-01-16 16:34:50', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('519', '1010', '0', '1', '2024-01-16 16:35:02', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('520', '1011', '607', '1', '2024-01-16 16:35:02', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('521', '1010', '0', '1', '2024-01-16 16:35:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('522', '1011', '607', '1', '2024-01-16 16:35:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('523', '1010', '0', '1', '2024-01-16 16:39:01', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('524', '1011', '607', '1', '2024-01-16 16:39:01', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('525', '1010', '0', '1', '2024-01-16 16:41:00', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('526', '1011', '607', '1', '2024-01-16 16:41:00', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('527', '1010', '0', '1', '2024-01-16 16:41:21', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('528', '1011', '607', '1', '2024-01-16 16:41:21', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('529', '1010', '0', '1', '2024-01-16 16:42:00', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('530', '1011', '607', '1', '2024-01-16 16:42:00', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('531', '1010', '0', '1', '2024-01-16 16:43:28', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('532', '1011', '607', '1', '2024-01-16 16:43:28', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('533', '1010', '0', '1', '2024-01-16 16:44:41', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('534', '1011', '607', '1', '2024-01-16 16:44:41', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('535', '1010', '0', '1', '2024-01-16 16:46:55', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('536', '1011', '607', '1', '2024-01-16 16:46:55', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('537', '1010', '0', '1', '2024-01-16 16:47:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('538', '1011', '607', '1', '2024-01-16 16:47:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('539', '1010', '0', '1', '2024-01-16 16:47:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('540', '1011', '607', '1', '2024-01-16 16:47:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('541', '1010', '0', '1', '2024-01-16 16:48:19', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('542', '1011', '607', '1', '2024-01-16 16:48:19', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('543', '1010', '0', '1', '2024-01-16 16:50:25', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('544', '1011', '607', '1', '2024-01-16 16:50:25', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('545', '1010', '0', '1', '2024-01-16 16:50:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('546', '1011', '607', '1', '2024-01-16 16:50:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('547', '1010', '0', '1', '2024-01-16 16:50:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('548', '1011', '607', '1', '2024-01-16 16:50:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('549', '1010', '0', '1', '2024-01-16 16:51:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('550', '1011', '607', '1', '2024-01-16 16:51:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('551', '1010', '0', '1', '2024-01-16 16:56:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('552', '1011', '607', '1', '2024-01-16 16:56:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('553', '1010', '0', '1', '2024-01-16 16:57:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('554', '1011', '607', '1', '2024-01-16 16:57:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('555', '1010', '0', '1', '2024-01-16 16:58:15', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('556', '1011', '607', '1', '2024-01-16 16:58:15', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('557', '1010', '0', '1', '2024-01-16 16:58:49', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('558', '1011', '607', '1', '2024-01-16 16:58:49', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('559', '1010', '0', '1', '2024-01-16 16:59:04', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('560', '1011', '607', '1', '2024-01-16 16:59:04', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('561', '1010', '0', '1', '2024-01-16 16:59:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('562', '1011', '607', '1', '2024-01-16 16:59:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('563', '1010', '0', '1', '2024-01-17 08:44:10', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('564', '1011', '607', '1', '2024-01-17 08:44:10', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('565', '1010', '0', '1', '2024-01-17 08:48:55', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('566', '1011', '607', '1', '2024-01-17 08:48:55', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('567', '1010', '0', '1', '2024-01-17 08:49:14', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('568', '1011', '607', '1', '2024-01-17 08:49:14', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('569', '1010', '0', '1', '2024-01-17 08:51:58', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('570', '1011', '607', '1', '2024-01-17 08:51:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('571', '1010', '0', '1', '2024-01-17 08:52:20', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('572', '1011', '607', '1', '2024-01-17 08:52:20', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('573', '1010', '0', '1', '2024-01-17 08:52:34', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('574', '1011', '607', '1', '2024-01-17 08:52:34', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('575', '1010', '0', '1', '2024-01-17 08:52:54', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('576', '1011', '607', '1', '2024-01-17 08:52:54', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('577', '1010', '0', '1', '2024-01-17 08:53:12', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('578', '1011', '607', '1', '2024-01-17 08:53:12', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('579', '1010', '0', '1', '2024-01-17 08:53:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('580', '1011', '607', '1', '2024-01-17 08:53:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('581', '1010', '0', '1', '2024-01-17 08:54:01', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('582', '1011', '607', '1', '2024-01-17 08:54:01', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('583', '1010', '0', '1', '2024-01-17 08:54:29', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('584', '1011', '607', '1', '2024-01-17 08:54:29', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('585', '1010', '0', '1', '2024-01-17 08:58:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('586', '1011', '607', '1', '2024-01-17 08:58:19', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('587', '1010', '0', '1', '2024-01-17 08:59:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('588', '1011', '607', '1', '2024-01-17 08:59:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('589', '1010', '0', '1', '2024-01-17 09:00:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('590', '1011', '607', '1', '2024-01-17 09:00:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('591', '1010', '0', '1', '2024-01-17 09:30:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('592', '1011', '607', '1', '2024-01-17 09:07:13', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('593', '1010', '1', '1', '2024-01-17 14:55:30', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('594', '1011', '607', '1', '2024-01-17 09:30:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('595', '1010', '0', '1', '2024-01-17 09:31:22', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('596', '1011', '607', '1', '2024-01-17 09:31:22', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('597', '1010', '0', '1', '2024-01-17 09:31:43', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('598', '1011', '607', '1', '2024-01-17 09:31:43', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('599', '1010', '0', '1', '2024-01-17 09:33:05', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('600', '1011', '607', '1', '2024-01-17 09:33:05', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('601', '1010', '0', '1', '2024-01-17 09:33:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('602', '1011', '607', '1', '2024-01-17 09:33:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('603', '1010', '0', '1', '2024-01-17 09:34:15', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('604', '1011', '607', '1', '2024-01-17 09:34:15', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('605', '1010', '0', '1', '2024-01-17 09:36:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('606', '1011', '607', '1', '2024-01-17 09:37:39', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('607', '1010', '0', '1', '2024-01-17 09:37:00', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('608', '1010', '0', '1', '2024-01-17 09:37:26', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('609', '1010', '0', '1', '2024-01-17 09:37:39', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('610', '1010', '0', '1', '2024-01-17 09:38:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('611', '1011', '607', '1', '2024-01-17 09:38:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('612', '1010', '0', '1', '2024-01-17 09:39:09', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('613', '1011', '607', '1', '2024-01-17 09:39:09', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('614', '1010', '0', '1', '2024-01-17 09:39:45', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('615', '1011', '607', '1', '2024-01-17 09:39:45', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('616', '1010', '0', '1', '2024-01-17 09:50:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('617', '1011', '607', '1', '2024-01-17 09:50:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('618', '1028', '21063', '1', '2024-01-17 09:46:28', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('619', '1028', '21067', '1', '2024-01-17 09:47:01', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('620', '1010', '0', '1', '2024-01-17 09:52:27', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('621', '1011', '607', '1', '2024-01-17 09:50:50', 'Update Item Codes', '13', '2024-01-17', '0', '0', '0'),
('622', '1011', '608', '1', '2024-01-17 09:53:12', 'Create Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('623', '1010', '0', '1', '2024-01-17 09:53:12', 'Create New Item', '13', '2024-01-17', NULL, '0', '0'),
('624', '1010', '0', '1', '2024-01-17 09:53:58', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('625', '1011', '608', '1', '2024-01-17 09:53:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('626', '1010', '0', '1', '2024-01-17 09:54:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('627', '1011', '608', '1', '2024-01-17 09:54:19', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('628', '1010', '0', '1', '2024-01-17 09:54:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('629', '1011', '608', '1', '2024-01-17 09:54:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('630', '1010', '0', '1', '2024-01-17 09:54:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('631', '1011', '608', '1', '2024-01-17 09:54:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('632', '1010', '0', '1', '2024-01-17 09:56:39', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('633', '1011', '608', '1', '2024-01-17 09:56:39', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('634', '1010', '0', '1', '2024-01-17 09:57:32', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('635', '1011', '608', '1', '2024-01-17 09:57:32', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('636', '1010', '0', '1', '2024-01-17 09:58:06', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('637', '1011', '608', '1', '2024-01-17 09:58:06', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('638', '1010', '0', '1', '2024-01-17 10:02:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('639', '1011', '608', '1', '2024-01-17 10:02:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('640', '1028', '21055', '1', '2024-01-17 09:59:46', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('641', '1028', '21077', '1', '2024-01-17 10:01:36', 'Account Data Added', '13', '2024-01-17', '0', '0', '0'),
('642', '1010', '0', '1', '2024-01-17 10:02:54', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('643', '1011', '608', '1', '2024-01-17 10:02:54', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('644', '1010', '0', '1', '2024-01-17 10:05:09', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('645', '1011', '608', '1', '2024-01-17 10:05:09', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('646', '1028', '21031', '1', '2024-01-17 10:04:26', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('647', '1028', '21030', '1', '2024-01-17 10:04:41', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('648', '1010', '0', '1', '2024-01-17 10:06:43', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('649', '1011', '608', '1', '2024-01-17 10:06:43', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('650', '1010', '0', '1', '2024-01-17 10:07:12', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('651', '1011', '608', '1', '2024-01-17 10:07:12', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('652', '1010', '0', '1', '2024-01-17 10:07:45', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('653', '1011', '608', '1', '2024-01-17 10:07:45', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('654', '1010', '0', '1', '2024-01-17 10:13:26', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('655', '1011', '608', '1', '2024-01-17 10:14:18', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('656', '1028', '21034', '1', '2024-01-17 10:08:15', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('657', '1010', '0', '1', '2024-01-17 10:14:18', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('658', '1010', '0', '1', '2024-01-17 10:15:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('659', '1011', '608', '1', '2024-01-17 10:15:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('660', '1010', '0', '1', '2024-01-17 10:15:51', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('661', '1011', '608', '1', '2024-01-17 10:15:51', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('662', '1010', '0', '1', '2024-01-17 10:17:27', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('663', '1011', '608', '1', '2024-01-17 10:17:27', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('664', '1010', '0', '1', '2024-01-17 10:17:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('665', '1011', '608', '1', '2024-01-17 10:17:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('666', '1010', '0', '1', '2024-01-17 10:18:40', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('667', '1011', '608', '1', '2024-01-17 10:20:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('668', '1010', '0', '1', '2024-01-17 10:19:35', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('669', '1010', '0', '1', '2024-01-17 10:20:10', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('670', '1010', '0', '1', '2024-01-17 10:20:58', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('671', '1010', '0', '1', '2024-01-17 10:21:38', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('672', '1011', '608', '1', '2024-01-17 10:21:38', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('673', '1010', '0', '1', '2024-01-17 10:21:42', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('674', '1011', '608', '1', '2024-01-17 10:21:42', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('675', '1010', '0', '1', '2024-01-17 10:22:07', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('676', '1011', '608', '1', '2024-01-17 10:22:07', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('677', '1010', '0', '1', '2024-01-17 14:54:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('678', '1011', '608', '1', '2024-01-17 10:22:07', 'Update Item Codes', '13', '2024-01-17', '0', '0', '0'),
('679', '1011', '609', '25', '2024-01-17 11:57:02', 'Create Foreign Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('680', '1011', '609', '25', '2024-01-17 14:54:19', 'Update Foreign Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('681', '1010', '0', '1', '2024-01-17 14:54:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('682', '1011', '609', '1', '2024-01-17 14:54:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('683', '1010', '0', '1', '2024-01-17 14:54:36', 'Update Item', '13', '2024-01-17', '0', '0', '0'),
('684', '1011', '609', '1', '2024-01-17 14:55:30', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('685', '1010', '1', '1', '2024-01-17 14:55:30', 'Update Item', '13', '2024-01-17', '0', '0', '0'),
('686', '1011', '609', '1', '2024-01-17 14:55:30', 'Update Item Codes', '13', '2024-01-17', '0', '0', '0'),
('687', '1015', '0', '25', '2024-01-18 10:22:08', 'Create Units ', '13', '2024-01-18', '0', '0', '0'),
('688', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('689', '1012', '1', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('690', '1017', '1', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('691', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('692', '1012', '2', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('693', '1017', '2', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('694', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('695', '1012', '3', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('696', '1017', '3', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('697', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('698', '1012', '4', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('699', '1017', '4', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('700', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('701', '1012', '5', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('702', '1017', '5', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('703', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('704', '1012', '6', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('705', '1017', '6', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('706', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('707', '1012', '7', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('708', '1017', '7', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('709', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('710', '1012', '8', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('711', '1017', '8', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('712', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('713', '1012', '9', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('714', '1017', '9', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('715', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('716', '1012', '10', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('717', '1017', '10', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('718', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('719', '1012', '11', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('720', '1017', '11', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('721', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('722', '1012', '12', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('723', '1017', '12', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('724', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('725', '1012', '13', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('726', '1017', '13', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('727', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('728', '1012', '14', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('729', '1017', '14', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('730', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('731', '1012', '15', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('732', '1017', '15', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('733', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('734', '1012', '16', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('735', '1017', '16', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('736', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('737', '1012', '17', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('738', '1017', '17', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('739', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('740', '1012', '18', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('741', '1017', '18', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('742', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('743', '1012', '19', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('744', '1017', '19', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('745', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('746', '1012', '19', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('747', '1017', '20', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('748', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('749', '1012', '20', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('750', '1017', '21', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('751', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('752', '1012', '21', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('753', '1017', '22', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('754', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('755', '1012', '22', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('756', '1017', '23', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('757', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('758', '1012', '23', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('759', '1017', '24', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('760', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('761', '1012', '24', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('762', '1017', '25', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('763', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('764', '1012', '25', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('765', '1017', '26', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('766', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('767', '1012', '26', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('768', '1017', '27', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('769', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('770', '1012', '27', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('771', '1017', '28', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('772', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('773', '1012', '28', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('774', '1017', '29', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('775', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('776', '1012', '29', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('777', '1017', '30', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('778', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('779', '1012', '30', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('780', '1017', '31', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('781', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('782', '1012', '31', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('783', '1017', '32', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('784', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('785', '1012', '32', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('786', '1017', '33', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('787', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('788', '1012', '33', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('789', '1017', '34', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('790', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('791', '1012', '34', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('792', '1017', '35', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('793', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('794', '1012', '35', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('795', '1017', '36', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('796', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('797', '1012', '36', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('798', '1017', '37', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('799', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('800', '1012', '37', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('801', '1017', '38', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('802', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('803', '1012', '38', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('804', '1017', '39', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('805', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('806', '1012', '39', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('807', '1017', '40', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('808', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('809', '1012', '40', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('810', '1017', '41', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('811', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('812', '1012', '41', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('813', '1017', '42', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('814', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('815', '1012', '42', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('816', '1017', '43', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('817', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('818', '1012', '43', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('819', '1017', '44', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('820', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('821', '1012', '44', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('822', '1017', '45', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('823', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('824', '1012', '45', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('825', '1017', '46', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('826', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('827', '1012', '46', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('828', '1017', '47', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('829', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('830', '1012', '47', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('831', '1017', '48', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('832', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('833', '1012', '48', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('834', '1017', '49', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('835', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('836', '1012', '49', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('837', '1017', '50', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('838', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('839', '1012', '50', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('840', '1017', '51', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('841', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('842', '1012', '51', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('843', '1017', '52', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('844', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('845', '1012', '52', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('846', '1017', '53', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('847', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('848', '1012', '53', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('849', '1017', '54', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('850', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('851', '1012', '54', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('852', '1017', '55', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('853', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('854', '1012', '55', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('855', '1017', '56', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('856', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('857', '1012', '56', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('858', '1017', '57', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('859', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('860', '1012', '57', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('861', '1017', '58', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('862', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('863', '1012', '58', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('864', '1017', '59', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('865', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('866', '1012', '59', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('867', '1017', '60', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('868', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('869', '1012', '60', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('870', '1017', '61', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('871', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('872', '1012', '61', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('873', '1017', '62', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('874', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('875', '1012', '62', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('876', '1017', '63', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('877', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('878', '1012', '63', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('879', '1017', '64', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('880', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('881', '1012', '64', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('882', '1017', '65', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('883', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('884', '1012', '65', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('885', '1017', '66', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('886', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('887', '1012', '66', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('888', '1017', '67', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('889', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('890', '1012', '66', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('891', '1017', '68', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('892', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('893', '1012', '67', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('894', '1017', '69', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('895', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('896', '1012', '68', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('897', '1017', '70', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('898', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('899', '1012', '69', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('900', '1017', '71', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('901', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('902', '1012', '70', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('903', '1017', '72', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('904', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('905', '1012', '71', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('906', '1017', '73', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('907', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('908', '1012', '72', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('909', '1017', '74', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('910', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('911', '1012', '73', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('912', '1017', '75', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('913', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('914', '1012', '74', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('915', '1017', '76', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('916', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('917', '1012', '75', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('918', '1017', '77', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('919', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('920', '1012', '76', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('921', '1017', '78', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('922', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('923', '1012', '77', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('924', '1017', '79', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('925', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('926', '1012', '78', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('927', '1017', '80', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('928', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('929', '1012', '79', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('930', '1017', '81', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('931', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('932', '1012', '80', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('933', '1017', '82', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('934', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('935', '1012', '81', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('936', '1017', '83', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('937', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('938', '1012', '82', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('939', '1017', '84', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('940', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('941', '1012', '83', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('942', '1017', '85', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('943', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('944', '1012', '84', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('945', '1017', '86', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('946', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('947', '1012', '85', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('948', '1017', '87', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('949', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('950', '1012', '86', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('951', '1017', '88', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('952', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('953', '1012', '87', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('954', '1017', '89', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('955', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('956', '1012', '88', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('957', '1017', '90', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('958', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('959', '1012', '89', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('960', '1017', '91', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('961', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('962', '1012', '90', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('963', '1017', '92', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('964', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('965', '1012', '91', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('966', '1017', '93', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('967', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('968', '1012', '92', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('969', '1017', '94', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('970', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('971', '1012', '93', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('972', '1017', '95', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('973', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('974', '1012', '94', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('975', '1017', '96', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('976', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('977', '1012', '95', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('978', '1017', '97', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('979', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('980', '1012', '96', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('981', '1017', '98', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('982', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('983', '1012', '97', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('984', '1017', '99', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('985', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('986', '1012', '98', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('987', '1017', '100', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('988', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('989', '1012', '99', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('990', '1017', '101', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('991', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('992', '1012', '100', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('993', '1017', '102', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('994', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('995', '1012', '101', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('996', '1017', '103', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('997', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('998', '1012', '102', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('999', '1017', '104', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1000', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1001', '1012', '103', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1002', '1017', '105', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1003', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1004', '1012', '104', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1005', '1017', '106', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1006', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1007', '1012', '105', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1008', '1017', '107', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1009', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1010', '1012', '106', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1011', '1017', '108', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1012', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1013', '1012', '107', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1014', '1017', '109', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1015', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1016', '1012', '108', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1017', '1017', '110', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1018', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1019', '1012', '109', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1020', '1017', '111', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1021', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1022', '1012', '110', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1023', '1017', '112', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1024', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1025', '1012', '111', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1026', '1017', '113', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1027', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1028', '1012', '112', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1029', '1017', '114', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1030', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1031', '1012', '113', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1032', '1017', '115', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1033', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1034', '1012', '114', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1035', '1017', '116', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1036', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1037', '1012', '115', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1038', '1017', '117', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1039', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1040', '1012', '116', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1041', '1017', '118', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1042', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1043', '1012', '117', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1044', '1017', '119', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1045', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1046', '1012', '118', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1047', '1017', '120', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1048', '1010', '0', '25', '2024-01-18 10:22:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1049', '1012', '119', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1050', '1017', '121', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1051', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1052', '1012', '120', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1053', '1017', '122', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1054', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1055', '1012', '121', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1056', '1017', '123', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1057', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1058', '1012', '122', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1059', '1017', '124', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1060', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1061', '1012', '123', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1062', '1017', '125', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1063', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1064', '1012', '124', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1065', '1017', '126', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1066', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1067', '1012', '125', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1068', '1017', '127', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1069', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1070', '1012', '126', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1071', '1017', '128', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1072', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1073', '1012', '127', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1074', '1017', '129', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1075', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1076', '1012', '128', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1077', '1017', '130', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1078', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1079', '1012', '129', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1080', '1017', '131', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1081', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1082', '1012', '130', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1083', '1017', '132', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1084', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1085', '1012', '131', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1086', '1017', '133', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1087', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1088', '1012', '132', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1089', '1017', '134', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1090', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1091', '1012', '133', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1092', '1017', '135', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1093', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1094', '1012', '134', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1095', '1017', '136', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1096', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1097', '1012', '135', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1098', '1017', '137', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1099', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1100', '1012', '136', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1101', '1017', '138', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1102', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1103', '1012', '137', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1104', '1017', '139', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1105', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1106', '1012', '138', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1107', '1017', '140', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1108', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1109', '1012', '139', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1110', '1017', '141', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1111', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1112', '1012', '140', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1113', '1017', '142', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1114', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1115', '1012', '141', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1116', '1017', '143', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1117', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1118', '1012', '142', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1119', '1017', '144', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1120', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1121', '1012', '143', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1122', '1017', '145', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1123', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1124', '1012', '144', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1125', '1017', '146', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1126', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1127', '1012', '145', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1128', '1017', '147', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1129', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1130', '1012', '146', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1131', '1017', '148', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1132', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1133', '1012', '147', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1134', '1017', '149', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1135', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1136', '1012', '148', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1137', '1017', '150', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1138', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1139', '1012', '149', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1140', '1017', '151', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1141', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1142', '1012', '150', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1143', '1017', '152', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1144', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1145', '1012', '151', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1146', '1017', '153', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1147', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1148', '1012', '152', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1149', '1017', '154', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1150', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1151', '1012', '153', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1152', '1017', '155', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1153', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1154', '1012', '154', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1155', '1017', '156', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1156', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1157', '1012', '155', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1158', '1017', '157', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1159', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1160', '1012', '156', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1161', '1017', '158', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1162', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1163', '1012', '157', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1164', '1017', '159', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1165', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1166', '1012', '158', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1167', '1017', '160', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1168', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1169', '1012', '159', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1170', '1017', '161', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1171', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1172', '1012', '160', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1173', '1017', '162', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1174', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1175', '1012', '161', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1176', '1017', '163', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1177', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1178', '1012', '162', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1179', '1017', '164', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1180', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1181', '1012', '163', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1182', '1017', '165', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1183', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1184', '1012', '164', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1185', '1017', '166', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1186', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1187', '1012', '165', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1188', '1017', '167', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1189', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1190', '1012', '166', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1191', '1017', '168', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1192', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1193', '1012', '167', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1194', '1017', '169', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1195', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1196', '1012', '168', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1197', '1017', '170', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1198', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1199', '1012', '169', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1200', '1017', '171', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1201', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1202', '1012', '170', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1203', '1017', '172', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1204', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1205', '1012', '171', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1206', '1017', '173', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1207', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1208', '1012', '172', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1209', '1017', '174', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1210', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1211', '1012', '173', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1212', '1017', '175', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1213', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1214', '1012', '174', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1215', '1017', '176', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1216', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1217', '1012', '175', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1218', '1017', '177', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1219', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1220', '1012', '176', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1221', '1017', '178', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1222', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1223', '1012', '177', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1224', '1017', '179', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1225', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1226', '1012', '178', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1227', '1017', '180', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1228', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1229', '1012', '179', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1230', '1017', '181', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1231', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1232', '1012', '180', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1233', '1017', '182', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1234', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1235', '1012', '181', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1236', '1017', '183', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1237', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1238', '1012', '182', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1239', '1017', '184', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1240', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1241', '1012', '183', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1242', '1017', '185', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1243', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1244', '1012', '184', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1245', '1017', '186', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1246', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1247', '1012', '185', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1248', '1017', '187', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1249', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1250', '1012', '186', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1251', '1017', '188', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1252', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1253', '1012', '187', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1254', '1017', '189', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1255', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1256', '1012', '188', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1257', '1017', '190', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1258', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1259', '1012', '189', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1260', '1017', '191', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1261', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1262', '1012', '190', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1263', '1017', '192', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1264', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1265', '1012', '191', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1266', '1017', '193', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1267', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1268', '1012', '192', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1269', '1017', '194', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1270', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1271', '1012', '193', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1272', '1017', '195', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1273', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1274', '1012', '194', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1275', '1017', '196', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1276', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1277', '1012', '195', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1278', '1017', '197', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1279', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1280', '1012', '196', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1281', '1017', '198', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1282', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1283', '1012', '197', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1284', '1017', '199', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1285', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1286', '1012', '198', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1287', '1017', '200', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1288', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1289', '1012', '199', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1290', '1017', '201', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1291', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1292', '1012', '200', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1293', '1017', '202', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1294', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1295', '1012', '201', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1296', '1017', '203', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1297', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1298', '1012', '202', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1299', '1017', '204', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1300', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1301', '1012', '203', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1302', '1017', '205', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1303', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1304', '1012', '204', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1305', '1017', '206', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1306', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1307', '1012', '205', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1308', '1017', '207', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1309', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1310', '1012', '206', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1311', '1017', '208', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1312', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1313', '1012', '207', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1314', '1017', '209', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1315', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1316', '1012', '208', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1317', '1017', '210', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1318', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1319', '1012', '209', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1320', '1017', '211', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1321', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1322', '1012', '210', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1323', '1017', '212', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1324', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1325', '1012', '211', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1326', '1017', '213', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1327', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1328', '1012', '212', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1329', '1017', '214', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1330', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1331', '1012', '213', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1332', '1017', '215', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1333', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1334', '1012', '214', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1335', '1017', '216', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1336', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1337', '1012', '215', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1338', '1017', '217', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1339', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1340', '1012', '216', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1341', '1017', '218', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1342', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1343', '1012', '217', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1344', '1017', '219', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1345', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1346', '1012', '218', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1347', '1017', '220', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1348', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1349', '1012', '219', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1350', '1017', '221', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1351', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1352', '1012', '220', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1353', '1017', '222', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1354', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1355', '1012', '221', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1356', '1017', '223', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1357', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1358', '1012', '222', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1359', '1017', '224', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1360', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1361', '1012', '223', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1362', '1017', '225', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1363', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1364', '1012', '224', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1365', '1017', '226', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1366', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1367', '1012', '225', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1368', '1017', '227', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1369', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1370', '1012', '226', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1371', '1017', '228', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1372', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1373', '1012', '227', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1374', '1017', '229', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1375', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1376', '1012', '228', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1377', '1017', '230', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1378', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1379', '1012', '229', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1380', '1017', '231', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1381', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1382', '1012', '230', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1383', '1017', '232', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1384', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1385', '1012', '231', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1386', '1017', '233', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1387', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('1388', '1012', '232', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1389', '1017', '234', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1390', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1391', '1012', '233', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1392', '1017', '235', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1393', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1394', '1012', '234', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1395', '1017', '236', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1396', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1397', '1012', '235', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1398', '1017', '237', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1399', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1400', '1012', '236', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1401', '1017', '238', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1402', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1403', '1012', '237', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1404', '1017', '239', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1405', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1406', '1012', '238', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1407', '1017', '240', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1408', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1409', '1012', '239', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1410', '1017', '241', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1411', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1412', '1012', '240', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1413', '1017', '242', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1414', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1415', '1012', '241', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1416', '1017', '243', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1417', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1418', '1012', '242', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1419', '1017', '244', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1420', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1421', '1012', '243', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1422', '1017', '245', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1423', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1424', '1012', '244', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1425', '1017', '246', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1426', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1427', '1012', '245', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1428', '1017', '247', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1429', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1430', '1012', '246', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1431', '1017', '248', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1432', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1433', '1012', '247', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1434', '1017', '249', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1435', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1436', '1012', '248', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1437', '1017', '250', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1438', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1439', '1012', '249', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1440', '1017', '251', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1441', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1442', '1012', '250', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1443', '1017', '252', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1444', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1445', '1012', '251', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1446', '1017', '253', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1447', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1448', '1012', '252', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1449', '1017', '254', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1450', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1451', '1012', '253', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1452', '1017', '255', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1453', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1454', '1012', '254', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1455', '1017', '256', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1456', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1457', '1012', '255', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1458', '1017', '257', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1459', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1460', '1012', '256', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1461', '1017', '258', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1462', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1463', '1012', '257', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1464', '1017', '259', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1465', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1466', '1012', '258', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1467', '1017', '260', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1468', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1469', '1012', '259', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1470', '1017', '261', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1471', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1472', '1012', '260', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1473', '1017', '262', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1474', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1475', '1012', '261', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1476', '1017', '263', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1477', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1478', '1012', '262', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1479', '1017', '264', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1480', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1481', '1012', '263', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1482', '1017', '265', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1483', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1484', '1012', '264', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1485', '1017', '266', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1486', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1487', '1012', '265', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1488', '1017', '267', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1489', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1490', '1012', '266', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1491', '1017', '268', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1492', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1493', '1012', '267', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1494', '1017', '269', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1495', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1496', '1012', '268', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1497', '1017', '270', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1498', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1499', '1012', '269', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1500', '1017', '271', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1501', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1502', '1012', '270', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1503', '1017', '272', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1504', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1505', '1012', '271', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1506', '1017', '273', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1507', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1508', '1012', '272', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1509', '1017', '274', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1510', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1511', '1012', '273', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1512', '1017', '275', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1513', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1514', '1012', '274', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1515', '1017', '276', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1516', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1517', '1012', '275', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1518', '1017', '277', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1519', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1520', '1012', '276', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1521', '1017', '278', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1522', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1523', '1012', '277', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1524', '1017', '279', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1525', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1526', '1012', '278', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1527', '1017', '280', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1528', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1529', '1012', '279', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1530', '1017', '281', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1531', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1532', '1012', '280', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1533', '1017', '282', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1534', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1535', '1012', '281', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1536', '1017', '283', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1537', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1538', '1012', '282', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1539', '1017', '284', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1540', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1541', '1012', '283', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1542', '1017', '285', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1543', '1010', '0', '25', '2024-01-18 10:22:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1544', '1012', '284', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1545', '1017', '286', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1546', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1547', '1012', '285', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1548', '1017', '287', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1549', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1550', '1012', '286', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1551', '1017', '288', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1552', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1553', '1012', '287', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1554', '1017', '289', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1555', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1556', '1012', '288', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1557', '1017', '290', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1558', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1559', '1012', '289', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1560', '1017', '291', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1561', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1562', '1012', '290', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1563', '1017', '292', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1564', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1565', '1012', '291', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1566', '1017', '293', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1567', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1568', '1012', '292', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1569', '1017', '294', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1570', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1571', '1012', '293', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1572', '1017', '295', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1573', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1574', '1012', '294', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1575', '1017', '296', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1576', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1577', '1012', '295', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1578', '1017', '297', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1579', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1580', '1012', '296', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1581', '1017', '298', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1582', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1583', '1012', '297', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1584', '1017', '299', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1585', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1586', '1012', '298', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1587', '1017', '300', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1588', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1589', '1012', '299', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1590', '1017', '301', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1591', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1592', '1012', '300', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1593', '1017', '302', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1594', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1595', '1012', '301', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1596', '1017', '303', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1597', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1598', '1012', '302', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1599', '1017', '304', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1600', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1601', '1012', '303', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1602', '1017', '305', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1603', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1604', '1012', '304', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1605', '1017', '306', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1606', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1607', '1012', '305', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1608', '1017', '307', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1609', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1610', '1012', '306', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1611', '1017', '308', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1612', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1613', '1012', '307', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1614', '1017', '309', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1615', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1616', '1012', '308', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1617', '1017', '310', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1618', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1619', '1012', '309', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1620', '1017', '311', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1621', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1622', '1012', '310', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1623', '1017', '312', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1624', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1625', '1012', '311', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1626', '1017', '313', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1627', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1628', '1012', '312', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1629', '1017', '314', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1630', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1631', '1012', '313', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1632', '1017', '315', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1633', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1634', '1012', '314', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1635', '1017', '316', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1636', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1637', '1012', '315', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1638', '1017', '317', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1639', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1640', '1012', '316', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1641', '1017', '318', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1642', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1643', '1012', '317', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1644', '1017', '319', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1645', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1646', '1012', '318', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1647', '1017', '320', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1648', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1649', '1012', '319', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1650', '1017', '321', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1651', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1652', '1012', '320', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1653', '1017', '322', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1654', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1655', '1012', '321', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1656', '1017', '323', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1657', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1658', '1012', '322', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1659', '1017', '324', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1660', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1661', '1012', '323', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1662', '1017', '325', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1663', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1664', '1012', '324', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1665', '1017', '326', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1666', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1667', '1012', '325', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1668', '1017', '327', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1669', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1670', '1012', '326', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1671', '1017', '328', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1672', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1673', '1012', '327', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1674', '1017', '329', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1675', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1676', '1012', '328', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1677', '1017', '330', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1678', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1679', '1012', '329', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1680', '1017', '331', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1681', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1682', '1012', '330', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1683', '1017', '332', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1684', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1685', '1012', '331', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1686', '1017', '333', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1687', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1688', '1012', '332', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1689', '1017', '334', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1690', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1691', '1012', '333', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1692', '1017', '335', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1693', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1694', '1012', '334', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1695', '1017', '336', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1696', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1697', '1012', '335', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1698', '1017', '337', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1699', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1700', '1012', '336', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1701', '1017', '338', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1702', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1703', '1012', '337', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1704', '1017', '339', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1705', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1706', '1012', '338', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1707', '1017', '340', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1708', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1709', '1012', '339', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1710', '1017', '341', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1711', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1712', '1012', '340', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1713', '1017', '342', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1714', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1715', '1012', '341', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1716', '1017', '343', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1717', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1718', '1012', '342', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1719', '1017', '344', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1720', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1721', '1012', '343', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1722', '1017', '345', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1723', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1724', '1012', '344', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1725', '1017', '346', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1726', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1727', '1012', '345', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1728', '1017', '347', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1729', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1730', '1012', '346', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1731', '1017', '348', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1732', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1733', '1012', '347', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1734', '1017', '349', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1735', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1736', '1012', '348', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1737', '1017', '350', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1738', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1739', '1012', '349', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1740', '1017', '351', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1741', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1742', '1012', '350', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1743', '1017', '352', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1744', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1745', '1012', '351', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1746', '1017', '353', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1747', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1748', '1012', '352', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1749', '1017', '354', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1750', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1751', '1012', '353', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1752', '1017', '355', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1753', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1754', '1012', '354', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1755', '1017', '356', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1756', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1757', '1012', '355', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1758', '1017', '357', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1759', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1760', '1012', '356', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1761', '1017', '358', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1762', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1763', '1012', '357', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1764', '1017', '359', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1765', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1766', '1012', '358', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1767', '1017', '360', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1768', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1769', '1012', '359', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1770', '1017', '361', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1771', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1772', '1012', '360', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1773', '1017', '362', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1774', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1775', '1012', '361', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1776', '1017', '363', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1777', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1778', '1012', '362', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1779', '1017', '364', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1780', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1781', '1012', '363', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1782', '1017', '365', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1783', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1784', '1012', '364', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1785', '1017', '366', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1786', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1787', '1012', '365', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1788', '1017', '367', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1789', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1790', '1012', '366', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1791', '1017', '368', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1792', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1793', '1012', '367', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1794', '1017', '369', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1795', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1796', '1012', '368', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1797', '1017', '370', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1798', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1799', '1012', '369', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1800', '1017', '371', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1801', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1802', '1012', '370', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1803', '1017', '372', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1804', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1805', '1012', '371', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1806', '1017', '373', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1807', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1808', '1012', '372', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1809', '1017', '374', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1810', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1811', '1012', '373', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1812', '1017', '375', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1813', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1814', '1012', '374', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1815', '1017', '376', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1816', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1817', '1012', '375', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1818', '1017', '377', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1819', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1820', '1012', '376', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1821', '1017', '378', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1822', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1823', '1012', '377', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1824', '1017', '379', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1825', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1826', '1012', '378', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1827', '1017', '380', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1828', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1829', '1012', '379', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1830', '1017', '381', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1831', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1832', '1012', '380', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1833', '1017', '382', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1834', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1835', '1012', '381', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1836', '1017', '383', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1837', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1838', '1012', '382', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1839', '1017', '384', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('1840', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1841', '1012', '383', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1842', '1017', '385', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1843', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1844', '1012', '384', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1845', '1017', '386', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1846', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1847', '1012', '385', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1848', '1017', '387', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1849', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1850', '1012', '386', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1851', '1017', '388', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1852', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1853', '1012', '387', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1854', '1017', '389', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1855', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1856', '1012', '388', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1857', '1017', '390', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1858', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1859', '1012', '389', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1860', '1017', '391', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1861', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1862', '1012', '390', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1863', '1017', '392', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1864', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1865', '1012', '391', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1866', '1017', '393', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1867', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1868', '1012', '392', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1869', '1017', '394', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1870', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1871', '1012', '393', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1872', '1017', '395', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1873', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1874', '1012', '394', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1875', '1017', '396', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1876', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1877', '1012', '395', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1878', '1017', '397', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1879', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1880', '1012', '396', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1881', '1017', '398', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1882', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1883', '1012', '397', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1884', '1017', '399', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1885', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1886', '1012', '398', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1887', '1017', '400', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1888', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1889', '1012', '399', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1890', '1017', '401', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1891', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1892', '1012', '400', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1893', '1017', '402', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1894', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1895', '1012', '401', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1896', '1017', '403', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1897', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1898', '1012', '402', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1899', '1017', '404', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1900', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1901', '1012', '403', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1902', '1017', '405', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1903', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1904', '1012', '404', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1905', '1017', '406', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1906', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1907', '1012', '405', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1908', '1017', '407', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1909', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1910', '1012', '406', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1911', '1017', '408', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1912', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1913', '1012', '406', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1914', '1017', '409', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1915', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1916', '1012', '406', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1917', '1017', '410', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1918', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1919', '1012', '407', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1920', '1017', '411', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1921', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1922', '1012', '408', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1923', '1017', '412', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1924', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1925', '1012', '409', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1926', '1017', '413', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1927', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1928', '1012', '410', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1929', '1017', '414', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1930', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1931', '1012', '411', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1932', '1017', '415', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1933', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1934', '1012', '412', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1935', '1017', '416', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1936', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1937', '1012', '413', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1938', '1017', '417', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1939', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1940', '1012', '414', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1941', '1017', '418', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1942', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1943', '1012', '415', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1944', '1017', '419', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1945', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1946', '1012', '416', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1947', '1017', '420', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1948', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1949', '1012', '417', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1950', '1017', '421', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1951', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1952', '1012', '418', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1953', '1017', '422', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1954', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1955', '1012', '419', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1956', '1017', '423', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1957', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1958', '1012', '420', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1959', '1017', '424', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1960', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1961', '1012', '421', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1962', '1017', '425', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1963', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1964', '1012', '422', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1965', '1017', '426', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1966', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1967', '1012', '423', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1968', '1017', '427', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1969', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1970', '1012', '424', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1971', '1017', '428', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1972', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1973', '1012', '425', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1974', '1017', '429', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1975', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1976', '1012', '426', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1977', '1017', '430', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1978', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1979', '1012', '427', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1980', '1017', '431', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1981', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1982', '1012', '428', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1983', '1017', '432', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1984', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1985', '1012', '429', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1986', '1017', '433', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1987', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1988', '1012', '430', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1989', '1017', '434', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1990', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1991', '1012', '431', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1992', '1017', '435', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1993', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1994', '1012', '432', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1995', '1017', '436', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1996', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('1997', '1012', '433', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1998', '1017', '437', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1999', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2000', '1012', '434', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2001', '1017', '438', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2002', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2003', '1012', '435', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2004', '1017', '439', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2005', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2006', '1012', '436', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2007', '1017', '440', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2008', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2009', '1012', '437', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2010', '1017', '441', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2011', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2012', '1012', '438', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2013', '1017', '442', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2014', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2015', '1012', '439', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2016', '1017', '443', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2017', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2018', '1012', '440', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2019', '1017', '444', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2020', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2021', '1012', '441', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2022', '1017', '445', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2023', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2024', '1012', '442', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2025', '1017', '446', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2026', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2027', '1012', '443', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2028', '1017', '447', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2029', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2030', '1012', '444', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2031', '1017', '448', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2032', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2033', '1012', '445', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2034', '1017', '449', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2035', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2036', '1012', '446', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2037', '1017', '450', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2038', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2039', '1012', '447', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2040', '1017', '451', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2041', '1010', '0', '25', '2024-01-18 10:22:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2042', '1012', '448', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2043', '1017', '452', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2044', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2045', '1012', '449', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2046', '1017', '453', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2047', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2048', '1012', '450', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2049', '1017', '454', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2050', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2051', '1012', '451', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2052', '1017', '455', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2053', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2054', '1012', '452', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2055', '1017', '456', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2056', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2057', '1012', '453', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2058', '1017', '457', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2059', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2060', '1012', '454', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2061', '1017', '458', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2062', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2063', '1012', '455', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2064', '1017', '459', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2065', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2066', '1012', '456', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2067', '1017', '460', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2068', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2069', '1012', '457', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2070', '1017', '461', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2071', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2072', '1012', '458', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2073', '1017', '462', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2074', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2075', '1012', '459', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2076', '1017', '463', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2077', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2078', '1012', '460', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2079', '1017', '464', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2080', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2081', '1012', '461', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2082', '1017', '465', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2083', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2084', '1012', '462', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2085', '1017', '466', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2086', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2087', '1012', '463', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2088', '1017', '467', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2089', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2090', '1012', '464', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2091', '1017', '468', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2092', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2093', '1012', '465', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2094', '1017', '469', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2095', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2096', '1012', '466', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2097', '1017', '470', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2098', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2099', '1012', '467', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2100', '1017', '471', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2101', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2102', '1012', '468', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2103', '1017', '472', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2104', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2105', '1012', '469', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2106', '1017', '473', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2107', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2108', '1012', '470', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2109', '1017', '474', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2110', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2111', '1012', '471', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2112', '1017', '475', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2113', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2114', '1012', '472', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2115', '1017', '476', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2116', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2117', '1012', '473', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2118', '1017', '477', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2119', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2120', '1012', '474', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2121', '1017', '478', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2122', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2123', '1012', '475', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2124', '1017', '479', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2125', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2126', '1012', '476', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2127', '1017', '480', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2128', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2129', '1012', '477', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2130', '1017', '481', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2131', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2132', '1012', '478', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2133', '1017', '482', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2134', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2135', '1012', '479', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2136', '1017', '483', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2137', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2138', '1012', '480', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2139', '1017', '484', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2140', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2141', '1012', '481', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2142', '1017', '485', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2143', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2144', '1012', '482', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2145', '1017', '486', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2146', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2147', '1012', '483', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2148', '1017', '487', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2149', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2150', '1012', '484', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2151', '1017', '488', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2152', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2153', '1012', '485', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2154', '1017', '489', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2155', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2156', '1012', '486', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2157', '1017', '490', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2158', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2159', '1012', '487', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2160', '1017', '491', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2161', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2162', '1012', '488', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2163', '1017', '492', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2164', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2165', '1012', '489', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2166', '1017', '493', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2167', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2168', '1012', '490', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2169', '1017', '494', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2170', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2171', '1012', '491', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2172', '1017', '495', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2173', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2174', '1012', '492', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2175', '1017', '496', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2176', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2177', '1012', '493', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2178', '1017', '497', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2179', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2180', '1012', '494', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2181', '1017', '498', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2182', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2183', '1012', '495', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2184', '1017', '499', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2185', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2186', '1012', '496', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2187', '1017', '500', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2188', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2189', '1012', '497', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2190', '1017', '501', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2191', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2192', '1012', '498', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2193', '1017', '502', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2194', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2195', '1012', '499', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2196', '1017', '503', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2197', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2198', '1012', '500', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2199', '1017', '504', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2200', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2201', '1012', '501', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2202', '1017', '505', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2203', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2204', '1012', '502', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2205', '1017', '506', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2206', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2207', '1012', '503', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2208', '1017', '507', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2209', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2210', '1012', '504', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2211', '1017', '508', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2212', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2213', '1012', '505', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2214', '1017', '509', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2215', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2216', '1012', '506', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2217', '1017', '510', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2218', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2219', '1012', '507', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2220', '1017', '511', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2221', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2222', '1012', '508', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2223', '1017', '512', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2224', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2225', '1012', '509', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2226', '1017', '513', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2227', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2228', '1012', '510', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2229', '1017', '514', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2230', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2231', '1012', '511', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2232', '1017', '515', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2233', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2234', '1012', '512', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2235', '1017', '516', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2236', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2237', '1012', '513', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2238', '1017', '517', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2239', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2240', '1012', '514', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2241', '1017', '518', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2242', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2243', '1012', '515', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2244', '1017', '519', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2245', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2246', '1012', '516', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2247', '1017', '520', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2248', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2249', '1012', '517', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2250', '1017', '521', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2251', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2252', '1012', '518', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2253', '1017', '522', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2254', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2255', '1012', '519', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2256', '1017', '523', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2257', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2258', '1012', '520', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2259', '1017', '524', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2260', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2261', '1012', '521', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2262', '1017', '525', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2263', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2264', '1012', '522', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2265', '1017', '526', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2266', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2267', '1012', '523', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2268', '1017', '527', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2269', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2270', '1012', '524', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2271', '1017', '528', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2272', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2273', '1012', '525', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2274', '1017', '529', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2275', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2276', '1012', '526', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2277', '1017', '530', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2278', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2279', '1012', '527', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2280', '1017', '531', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2281', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2282', '1012', '528', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2283', '1017', '532', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2284', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2285', '1012', '529', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2286', '1017', '533', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2287', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2288', '1012', '530', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2289', '1017', '534', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2290', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2291', '1012', '531', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('2292', '1017', '535', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2293', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2294', '1012', '532', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2295', '1017', '536', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2296', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2297', '1012', '533', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2298', '1017', '537', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2299', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2300', '1012', '534', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2301', '1017', '538', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2302', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2303', '1012', '535', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2304', '1017', '539', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2305', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2306', '1012', '536', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2307', '1017', '540', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2308', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2309', '1012', '537', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2310', '1017', '541', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2311', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2312', '1012', '538', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2313', '1017', '542', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2314', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2315', '1012', '539', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2316', '1017', '543', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2317', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2318', '1012', '540', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2319', '1017', '544', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2320', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2321', '1012', '541', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2322', '1017', '545', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2323', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2324', '1012', '542', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2325', '1017', '546', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2326', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2327', '1012', '543', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2328', '1017', '547', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2329', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2330', '1012', '544', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2331', '1017', '548', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2332', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2333', '1012', '545', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2334', '1017', '549', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2335', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2336', '1012', '546', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2337', '1017', '550', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2338', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2339', '1012', '547', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2340', '1017', '551', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2341', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2342', '1012', '548', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2343', '1017', '552', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2344', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2345', '1012', '549', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2346', '1017', '553', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2347', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2348', '1012', '550', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2349', '1017', '554', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2350', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2351', '1012', '551', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2352', '1017', '555', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2353', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2354', '1012', '552', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2355', '1017', '556', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2356', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2357', '1012', '553', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2358', '1017', '557', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2359', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2360', '1012', '554', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2361', '1017', '558', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2362', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2363', '1012', '555', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2364', '1017', '559', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2365', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2366', '1012', '556', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2367', '1017', '560', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2368', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2369', '1012', '557', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2370', '1017', '561', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2371', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2372', '1012', '558', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2373', '1017', '562', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2374', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2375', '1012', '559', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2376', '1017', '563', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2377', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2378', '1012', '560', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2379', '1017', '564', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2380', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2381', '1012', '561', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2382', '1017', '565', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2383', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2384', '1012', '562', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2385', '1017', '566', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2386', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2387', '1012', '563', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2388', '1017', '567', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2389', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2390', '1012', '564', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2391', '1017', '568', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2392', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2393', '1012', '565', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2394', '1017', '569', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2395', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2396', '1012', '566', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2397', '1017', '570', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2398', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2399', '1012', '567', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2400', '1017', '571', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2401', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2402', '1012', '568', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2403', '1017', '572', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2404', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2405', '1012', '569', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2406', '1017', '573', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2407', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2408', '1012', '570', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2409', '1017', '574', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2410', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2411', '1012', '571', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2412', '1017', '575', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2413', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2414', '1012', '572', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2415', '1017', '576', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2416', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2417', '1012', '573', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2418', '1017', '577', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2419', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2420', '1012', '574', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2421', '1017', '578', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2422', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2423', '1012', '575', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2424', '1017', '579', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2425', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2426', '1012', '576', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2427', '1017', '580', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2428', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2429', '1012', '577', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2430', '1017', '581', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2431', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2432', '1012', '578', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2433', '1017', '582', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2434', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2435', '1012', '579', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2436', '1017', '583', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2437', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2438', '1012', '580', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2439', '1017', '584', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2440', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2441', '1012', '581', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2442', '1017', '585', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2443', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2444', '1012', '582', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2445', '1017', '586', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2446', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2447', '1012', '583', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2448', '1017', '587', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2449', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2450', '1012', '584', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2451', '1017', '588', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2452', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2453', '1012', '585', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2454', '1017', '589', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2455', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2456', '1012', '586', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2457', '1017', '590', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2458', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2459', '1012', '587', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2460', '1017', '591', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2461', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2462', '1012', '588', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2463', '1017', '592', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2464', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2465', '1012', '589', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2466', '1017', '593', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2467', '1010', '0', '25', '2024-01-18 10:22:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2468', '1012', '590', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2469', '1017', '594', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2470', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2471', '1012', '1', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2472', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2473', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2474', '1012', '2', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2475', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2476', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2477', '1012', '3', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2478', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2479', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2480', '1012', '4', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2481', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2482', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2483', '1012', '5', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2484', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2485', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2486', '1012', '6', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2487', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2488', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2489', '1012', '7', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2490', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2491', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2492', '1012', '8', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2493', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2494', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2495', '1012', '9', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2496', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2497', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2498', '1012', '10', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2499', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2500', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2501', '1012', '11', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2502', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2503', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2504', '1012', '12', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2505', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2506', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2507', '1012', '13', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2508', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2509', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2510', '1012', '14', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2511', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2512', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2513', '1012', '15', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2514', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2515', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2516', '1012', '16', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2517', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2518', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2519', '1012', '17', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2520', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2521', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2522', '1012', '18', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2523', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2524', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2525', '1012', '19', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2526', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2527', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2528', '1012', '19', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2529', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2530', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2531', '1012', '20', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2532', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2533', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2534', '1012', '21', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2535', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2536', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2537', '1012', '22', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2538', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2539', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2540', '1012', '23', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2541', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2542', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2543', '1012', '24', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2544', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2545', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2546', '1012', '25', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2547', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2548', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2549', '1012', '26', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2550', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2551', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2552', '1012', '27', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2553', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2554', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2555', '1012', '28', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2556', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2557', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2558', '1012', '29', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2559', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2560', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2561', '1012', '30', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2562', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2563', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2564', '1012', '31', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2565', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2566', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2567', '1012', '32', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2568', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2569', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2570', '1012', '33', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2571', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2572', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2573', '1012', '34', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2574', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2575', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2576', '1012', '35', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2577', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2578', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2579', '1012', '36', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2580', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2581', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2582', '1012', '37', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2583', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2584', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2585', '1012', '38', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2586', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2587', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2588', '1012', '39', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2589', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2590', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2591', '1012', '40', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2592', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2593', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2594', '1012', '41', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2595', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2596', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2597', '1012', '42', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2598', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2599', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2600', '1012', '43', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2601', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2602', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2603', '1012', '44', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2604', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2605', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2606', '1012', '45', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2607', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2608', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2609', '1012', '46', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2610', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2611', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2612', '1012', '47', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2613', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2614', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2615', '1012', '48', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2616', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2617', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2618', '1012', '49', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2619', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2620', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2621', '1012', '50', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2622', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2623', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2624', '1012', '51', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2625', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2626', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2627', '1012', '52', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2628', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2629', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2630', '1012', '53', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2631', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2632', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2633', '1012', '54', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2634', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2635', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2636', '1012', '55', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2637', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2638', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2639', '1012', '56', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2640', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2641', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2642', '1012', '57', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2643', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2644', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2645', '1012', '58', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2646', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2647', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2648', '1012', '59', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2649', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2650', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2651', '1012', '60', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2652', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2653', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2654', '1012', '61', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2655', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2656', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2657', '1012', '62', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2658', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2659', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2660', '1012', '63', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2661', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2662', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2663', '1012', '64', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2664', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2665', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2666', '1012', '65', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2667', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2668', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2669', '1012', '66', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2670', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2671', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2672', '1012', '66', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2673', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2674', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2675', '1012', '67', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2676', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2677', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2678', '1012', '68', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2679', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2680', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2681', '1012', '69', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2682', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2683', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2684', '1012', '70', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2685', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2686', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2687', '1012', '71', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2688', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2689', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2690', '1012', '72', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2691', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2692', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2693', '1012', '73', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2694', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2695', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2696', '1012', '74', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2697', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2698', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2699', '1012', '75', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2700', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2701', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2702', '1012', '76', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2703', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2704', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2705', '1012', '77', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2706', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2707', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2708', '1012', '78', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2709', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2710', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2711', '1012', '79', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2712', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2713', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2714', '1012', '80', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2715', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2716', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2717', '1012', '81', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2718', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2719', '1010', '0', '25', '2024-01-18 10:26:20', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2720', '1012', '82', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2721', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2722', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2723', '1012', '83', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2724', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2725', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2726', '1012', '84', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2727', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2728', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2729', '1012', '85', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2730', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2731', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2732', '1012', '86', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2733', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2734', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2735', '1012', '87', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2736', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2737', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2738', '1012', '88', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2739', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2740', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2741', '1012', '89', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2742', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2743', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2744', '1012', '90', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('2745', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2746', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2747', '1012', '91', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2748', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2749', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2750', '1012', '92', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2751', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2752', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2753', '1012', '93', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2754', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2755', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2756', '1012', '94', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2757', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2758', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2759', '1012', '95', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2760', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2761', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2762', '1012', '96', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2763', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2764', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2765', '1012', '97', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2766', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2767', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2768', '1012', '98', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2769', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2770', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2771', '1012', '99', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2772', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2773', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2774', '1012', '100', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2775', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2776', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2777', '1012', '101', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2778', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2779', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2780', '1012', '102', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2781', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2782', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2783', '1012', '103', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2784', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2785', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2786', '1012', '104', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2787', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2788', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2789', '1012', '105', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2790', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2791', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2792', '1012', '106', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2793', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2794', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2795', '1012', '107', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2796', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2797', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2798', '1012', '108', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2799', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2800', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2801', '1012', '109', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2802', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2803', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2804', '1012', '110', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2805', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2806', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2807', '1012', '111', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2808', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2809', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2810', '1012', '112', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2811', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2812', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2813', '1012', '113', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2814', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2815', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2816', '1012', '114', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2817', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2818', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2819', '1012', '115', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2820', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2821', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2822', '1012', '116', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2823', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2824', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2825', '1012', '117', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2826', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2827', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2828', '1012', '118', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2829', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2830', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2831', '1012', '119', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2832', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2833', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2834', '1012', '120', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2835', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2836', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2837', '1012', '121', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2838', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2839', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2840', '1012', '122', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2841', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2842', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2843', '1012', '123', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2844', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2845', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2846', '1012', '124', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2847', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2848', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2849', '1012', '125', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2850', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2851', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2852', '1012', '126', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2853', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2854', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2855', '1012', '127', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2856', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2857', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2858', '1012', '128', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2859', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2860', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2861', '1012', '129', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2862', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2863', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2864', '1012', '130', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2865', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2866', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2867', '1012', '131', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2868', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2869', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2870', '1012', '132', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2871', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2872', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2873', '1012', '133', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2874', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2875', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2876', '1012', '134', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2877', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2878', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2879', '1012', '135', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2880', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2881', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2882', '1012', '136', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2883', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2884', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2885', '1012', '137', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2886', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2887', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2888', '1012', '138', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2889', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2890', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2891', '1012', '139', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2892', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2893', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2894', '1012', '140', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2895', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2896', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2897', '1012', '141', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2898', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2899', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2900', '1012', '142', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2901', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2902', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2903', '1012', '143', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2904', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2905', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2906', '1012', '144', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2907', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2908', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2909', '1012', '145', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2910', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2911', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2912', '1012', '146', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2913', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2914', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2915', '1012', '147', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2916', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2917', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2918', '1012', '148', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2919', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2920', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2921', '1012', '149', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2922', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2923', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2924', '1012', '150', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2925', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2926', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2927', '1012', '151', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2928', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2929', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2930', '1012', '152', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2931', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2932', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2933', '1012', '153', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2934', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2935', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2936', '1012', '154', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2937', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2938', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2939', '1012', '155', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2940', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2941', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2942', '1012', '156', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2943', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2944', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2945', '1012', '157', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2946', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2947', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2948', '1012', '158', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2949', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2950', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2951', '1012', '159', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2952', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2953', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2954', '1012', '160', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2955', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2956', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2957', '1012', '161', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2958', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2959', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2960', '1012', '162', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2961', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2962', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2963', '1012', '163', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2964', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2965', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2966', '1012', '164', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2967', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2968', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2969', '1012', '165', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2970', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2971', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2972', '1012', '166', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2973', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2974', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2975', '1012', '167', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2976', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2977', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2978', '1012', '168', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2979', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2980', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2981', '1012', '169', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2982', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2983', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2984', '1012', '170', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2985', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2986', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2987', '1012', '171', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2988', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2989', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2990', '1012', '172', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2991', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2992', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2993', '1012', '173', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2994', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2995', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2996', '1012', '174', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2997', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2998', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('2999', '1012', '175', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3000', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3001', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3002', '1012', '176', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3003', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3004', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3005', '1012', '177', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3006', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3007', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3008', '1012', '178', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3009', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3010', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3011', '1012', '179', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3012', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3013', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3014', '1012', '180', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3015', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3016', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3017', '1012', '181', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3018', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3019', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3020', '1012', '182', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3021', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3022', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3023', '1012', '183', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3024', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3025', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3026', '1012', '184', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3027', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3028', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3029', '1012', '185', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3030', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3031', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3032', '1012', '186', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3033', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3034', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3035', '1012', '187', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3036', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3037', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3038', '1012', '188', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3039', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3040', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3041', '1012', '189', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3042', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3043', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3044', '1012', '190', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3045', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3046', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3047', '1012', '191', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3048', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3049', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3050', '1012', '192', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3051', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3052', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3053', '1012', '193', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3054', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3055', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3056', '1012', '194', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3057', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3058', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3059', '1012', '195', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3060', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3061', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3062', '1012', '196', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3063', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3064', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3065', '1012', '197', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3066', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3067', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3068', '1012', '198', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3069', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3070', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3071', '1012', '199', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3072', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3073', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3074', '1012', '200', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3075', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3076', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3077', '1012', '201', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3078', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3079', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3080', '1012', '202', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3081', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3082', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3083', '1012', '203', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3084', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3085', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3086', '1012', '204', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3087', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3088', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3089', '1012', '205', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3090', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3091', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3092', '1012', '206', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3093', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3094', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3095', '1012', '207', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3096', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3097', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3098', '1012', '208', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3099', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3100', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3101', '1012', '209', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3102', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3103', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3104', '1012', '210', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3105', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3106', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3107', '1012', '211', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3108', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3109', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3110', '1012', '212', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3111', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3112', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3113', '1012', '213', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3114', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3115', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3116', '1012', '214', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3117', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3118', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3119', '1012', '215', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3120', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3121', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3122', '1012', '216', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3123', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3124', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3125', '1012', '217', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3126', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3127', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3128', '1012', '218', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3129', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3130', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3131', '1012', '219', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3132', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3133', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3134', '1012', '220', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3135', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3136', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3137', '1012', '221', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3138', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3139', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3140', '1012', '222', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3141', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3142', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3143', '1012', '223', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3144', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3145', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3146', '1012', '224', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3147', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3148', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3149', '1012', '225', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3150', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3151', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3152', '1012', '226', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3153', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3154', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3155', '1012', '227', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3156', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3157', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3158', '1012', '228', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3159', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3160', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3161', '1012', '229', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3162', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3163', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3164', '1012', '230', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3165', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3166', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3167', '1012', '231', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3168', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3169', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3170', '1012', '232', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3171', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3172', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3173', '1012', '233', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3174', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3175', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3176', '1012', '234', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3177', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3178', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3179', '1012', '235', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3180', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3181', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3182', '1012', '236', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3183', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3184', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3185', '1012', '237', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3186', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3187', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3188', '1012', '238', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3189', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3190', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3191', '1012', '239', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3192', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3193', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3194', '1012', '240', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3195', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3196', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('3197', '1012', '241', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3198', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3199', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3200', '1012', '242', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3201', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3202', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3203', '1012', '243', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3204', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3205', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3206', '1012', '244', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3207', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3208', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3209', '1012', '245', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3210', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3211', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3212', '1012', '246', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3213', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3214', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3215', '1012', '247', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3216', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3217', '1010', '0', '25', '2024-01-18 10:26:21', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3218', '1012', '248', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3219', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3220', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3221', '1012', '249', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3222', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3223', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3224', '1012', '250', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3225', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3226', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3227', '1012', '251', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3228', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3229', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3230', '1012', '252', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3231', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3232', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3233', '1012', '253', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3234', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3235', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3236', '1012', '254', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3237', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3238', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3239', '1012', '255', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3240', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3241', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3242', '1012', '256', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3243', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3244', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3245', '1012', '257', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3246', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3247', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3248', '1012', '258', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3249', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3250', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3251', '1012', '259', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3252', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3253', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3254', '1012', '260', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3255', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3256', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3257', '1012', '261', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3258', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3259', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3260', '1012', '262', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3261', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3262', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3263', '1012', '263', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3264', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3265', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3266', '1012', '264', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3267', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3268', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3269', '1012', '265', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3270', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3271', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3272', '1012', '266', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3273', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3274', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3275', '1012', '267', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3276', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3277', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3278', '1012', '268', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3279', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3280', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3281', '1012', '269', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3282', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3283', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3284', '1012', '270', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3285', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3286', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3287', '1012', '271', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3288', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3289', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3290', '1012', '272', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3291', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3292', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3293', '1012', '273', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3294', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3295', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3296', '1012', '274', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3297', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3298', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3299', '1012', '275', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3300', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3301', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3302', '1012', '276', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3303', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3304', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3305', '1012', '277', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3306', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3307', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3308', '1012', '278', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3309', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3310', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3311', '1012', '279', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3312', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3313', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3314', '1012', '280', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3315', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3316', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3317', '1012', '281', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3318', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3319', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3320', '1012', '282', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3321', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3322', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3323', '1012', '283', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3324', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3325', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3326', '1012', '284', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3327', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3328', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3329', '1012', '285', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3330', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3331', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3332', '1012', '286', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3333', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3334', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3335', '1012', '287', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3336', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3337', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3338', '1012', '288', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3339', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3340', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3341', '1012', '289', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3342', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3343', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3344', '1012', '290', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3345', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3346', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3347', '1012', '291', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3348', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3349', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3350', '1012', '292', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3351', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3352', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3353', '1012', '293', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3354', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3355', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3356', '1012', '294', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3357', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3358', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3359', '1012', '295', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3360', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3361', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3362', '1012', '296', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3363', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3364', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3365', '1012', '297', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3366', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3367', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3368', '1012', '298', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3369', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3370', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3371', '1012', '299', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3372', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3373', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3374', '1012', '300', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3375', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3376', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3377', '1012', '301', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3378', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3379', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3380', '1012', '302', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3381', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3382', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3383', '1012', '303', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3384', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3385', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3386', '1012', '304', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3387', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3388', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3389', '1012', '305', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3390', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3391', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3392', '1012', '306', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3393', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3394', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3395', '1012', '307', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3396', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3397', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3398', '1012', '308', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3399', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3400', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3401', '1012', '309', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3402', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3403', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3404', '1012', '310', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3405', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3406', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3407', '1012', '311', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3408', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3409', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3410', '1012', '312', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3411', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3412', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3413', '1012', '313', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3414', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3415', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3416', '1012', '314', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3417', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3418', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3419', '1012', '315', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3420', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3421', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3422', '1012', '316', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3423', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3424', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3425', '1012', '317', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3426', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3427', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3428', '1012', '318', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3429', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3430', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3431', '1012', '319', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3432', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3433', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3434', '1012', '320', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3435', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3436', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3437', '1012', '321', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3438', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3439', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3440', '1012', '322', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3441', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3442', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3443', '1012', '323', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3444', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3445', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3446', '1012', '324', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3447', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3448', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3449', '1012', '325', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3450', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3451', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3452', '1012', '326', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3453', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3454', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3455', '1012', '327', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3456', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3457', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3458', '1012', '328', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3459', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3460', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3461', '1012', '329', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3462', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3463', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3464', '1012', '330', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3465', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3466', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3467', '1012', '331', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3468', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3469', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3470', '1012', '332', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3471', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3472', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3473', '1012', '333', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3474', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3475', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3476', '1012', '334', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3477', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3478', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3479', '1012', '335', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3480', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3481', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3482', '1012', '336', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3483', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3484', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3485', '1012', '337', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3486', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3487', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3488', '1012', '338', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3489', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3490', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3491', '1012', '339', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3492', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3493', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3494', '1012', '340', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3495', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3496', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3497', '1012', '341', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3498', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3499', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3500', '1012', '342', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3501', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3502', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3503', '1012', '343', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3504', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3505', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3506', '1012', '344', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3507', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3508', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3509', '1012', '345', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3510', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3511', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3512', '1012', '346', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3513', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3514', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3515', '1012', '347', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3516', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3517', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3518', '1012', '348', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3519', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3520', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3521', '1012', '349', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3522', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3523', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3524', '1012', '350', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3525', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3526', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3527', '1012', '351', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3528', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3529', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3530', '1012', '352', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3531', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3532', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3533', '1012', '353', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3534', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3535', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3536', '1012', '354', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3537', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3538', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3539', '1012', '355', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3540', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3541', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3542', '1012', '356', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3543', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3544', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3545', '1012', '357', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3546', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3547', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3548', '1012', '358', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3549', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3550', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3551', '1012', '359', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3552', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3553', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3554', '1012', '360', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3555', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3556', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3557', '1012', '361', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3558', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3559', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3560', '1012', '362', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3561', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3562', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3563', '1012', '363', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3564', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3565', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3566', '1012', '364', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3567', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3568', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3569', '1012', '365', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3570', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3571', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3572', '1012', '366', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3573', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3574', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3575', '1012', '367', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3576', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3577', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3578', '1012', '368', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3579', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3580', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3581', '1012', '369', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3582', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3583', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3584', '1012', '370', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3585', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3586', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3587', '1012', '371', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3588', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3589', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3590', '1012', '372', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3591', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3592', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3593', '1012', '373', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3594', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3595', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3596', '1012', '374', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3597', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3598', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3599', '1012', '375', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3600', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3601', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3602', '1012', '376', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3603', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3604', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3605', '1012', '377', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3606', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3607', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3608', '1012', '378', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3609', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3610', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3611', '1012', '379', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3612', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3613', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3614', '1012', '380', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3615', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3616', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3617', '1012', '381', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3618', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3619', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3620', '1012', '382', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3621', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3622', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3623', '1012', '383', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3624', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3625', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3626', '1012', '384', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3627', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3628', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3629', '1012', '385', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3630', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3631', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3632', '1012', '386', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3633', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3634', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3635', '1012', '387', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3636', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3637', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3638', '1012', '388', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3639', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3640', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3641', '1012', '389', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3642', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3643', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3644', '1012', '390', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3645', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3646', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3647', '1012', '391', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3648', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('3649', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3650', '1012', '392', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3651', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3652', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3653', '1012', '393', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3654', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3655', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3656', '1012', '394', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3657', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3658', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3659', '1012', '395', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3660', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3661', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3662', '1012', '396', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3663', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3664', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3665', '1012', '397', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3666', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3667', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3668', '1012', '398', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3669', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3670', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3671', '1012', '399', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3672', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3673', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3674', '1012', '400', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3675', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3676', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3677', '1012', '401', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3678', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3679', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3680', '1012', '402', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3681', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3682', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3683', '1012', '403', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3684', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3685', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3686', '1012', '404', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3687', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3688', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3689', '1012', '405', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3690', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3691', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3692', '1012', '406', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3693', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3694', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3695', '1012', '406', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3696', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3697', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3698', '1012', '406', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3699', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3700', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3701', '1012', '407', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3702', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3703', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3704', '1012', '408', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3705', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3706', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3707', '1012', '409', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3708', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3709', '1010', '0', '25', '2024-01-18 10:26:22', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3710', '1012', '410', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3711', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3712', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3713', '1012', '411', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3714', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3715', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3716', '1012', '412', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3717', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3718', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3719', '1012', '413', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3720', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3721', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3722', '1012', '414', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3723', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3724', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3725', '1012', '415', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3726', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3727', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3728', '1012', '416', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3729', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3730', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3731', '1012', '417', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3732', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3733', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3734', '1012', '418', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3735', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3736', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3737', '1012', '419', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3738', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3739', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3740', '1012', '420', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3741', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3742', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3743', '1012', '421', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3744', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3745', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3746', '1012', '422', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3747', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3748', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3749', '1012', '423', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3750', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3751', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3752', '1012', '424', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3753', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3754', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3755', '1012', '425', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3756', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3757', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3758', '1012', '426', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3759', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3760', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3761', '1012', '427', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3762', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3763', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3764', '1012', '428', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3765', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3766', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3767', '1012', '429', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3768', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3769', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3770', '1012', '430', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3771', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3772', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3773', '1012', '431', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3774', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3775', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3776', '1012', '432', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3777', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3778', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3779', '1012', '433', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3780', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3781', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3782', '1012', '434', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3783', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3784', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3785', '1012', '435', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3786', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3787', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3788', '1012', '436', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3789', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3790', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3791', '1012', '437', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3792', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3793', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3794', '1012', '438', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3795', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3796', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3797', '1012', '439', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3798', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3799', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3800', '1012', '440', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3801', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3802', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3803', '1012', '441', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3804', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3805', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3806', '1012', '442', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3807', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3808', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3809', '1012', '443', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3810', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3811', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3812', '1012', '444', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3813', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3814', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3815', '1012', '445', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3816', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3817', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3818', '1012', '446', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3819', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3820', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3821', '1012', '447', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3822', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3823', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3824', '1012', '448', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3825', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3826', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3827', '1012', '449', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3828', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3829', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3830', '1012', '450', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3831', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3832', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3833', '1012', '451', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3834', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3835', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3836', '1012', '452', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3837', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3838', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3839', '1012', '453', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3840', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3841', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3842', '1012', '454', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3843', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3844', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3845', '1012', '455', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3846', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3847', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3848', '1012', '456', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3849', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3850', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3851', '1012', '457', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3852', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3853', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3854', '1012', '458', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3855', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3856', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3857', '1012', '459', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3858', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3859', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3860', '1012', '460', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3861', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3862', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3863', '1012', '461', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3864', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3865', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3866', '1012', '462', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3867', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3868', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3869', '1012', '463', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3870', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3871', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3872', '1012', '464', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3873', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3874', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3875', '1012', '465', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3876', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3877', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3878', '1012', '466', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3879', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3880', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3881', '1012', '467', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3882', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3883', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3884', '1012', '468', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3885', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3886', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3887', '1012', '469', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3888', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3889', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3890', '1012', '470', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3891', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3892', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3893', '1012', '471', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3894', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3895', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3896', '1012', '472', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3897', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3898', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3899', '1012', '473', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3900', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3901', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3902', '1012', '474', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3903', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3904', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3905', '1012', '475', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3906', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3907', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3908', '1012', '476', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3909', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3910', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3911', '1012', '477', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3912', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3913', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3914', '1012', '478', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3915', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3916', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3917', '1012', '479', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3918', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3919', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3920', '1012', '480', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3921', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3922', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3923', '1012', '481', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3924', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3925', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3926', '1012', '482', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3927', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3928', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3929', '1012', '483', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3930', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3931', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3932', '1012', '484', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3933', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3934', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3935', '1012', '485', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3936', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3937', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3938', '1012', '486', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3939', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3940', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3941', '1012', '487', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3942', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3943', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3944', '1012', '488', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3945', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3946', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3947', '1012', '489', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3948', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3949', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3950', '1012', '490', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3951', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3952', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3953', '1012', '491', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3954', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3955', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3956', '1012', '492', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3957', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3958', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3959', '1012', '493', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3960', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3961', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3962', '1012', '494', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3963', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3964', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3965', '1012', '495', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3966', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3967', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3968', '1012', '496', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3969', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3970', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3971', '1012', '497', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3972', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3973', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3974', '1012', '498', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3975', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3976', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3977', '1012', '499', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3978', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3979', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3980', '1012', '500', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3981', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3982', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3983', '1012', '501', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3984', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3985', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3986', '1012', '502', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3987', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3988', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3989', '1012', '503', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3990', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3991', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3992', '1012', '504', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3993', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3994', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3995', '1012', '505', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3996', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3997', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('3998', '1012', '506', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3999', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4000', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4001', '1012', '507', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4002', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4003', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4004', '1012', '508', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4005', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4006', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4007', '1012', '509', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4008', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4009', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4010', '1012', '510', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4011', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4012', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4013', '1012', '511', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4014', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4015', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4016', '1012', '512', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4017', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4018', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4019', '1012', '513', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4020', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4021', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4022', '1012', '514', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4023', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4024', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4025', '1012', '515', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4026', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4027', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4028', '1012', '516', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4029', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4030', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4031', '1012', '517', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4032', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4033', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4034', '1012', '518', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4035', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4036', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4037', '1012', '519', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4038', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4039', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4040', '1012', '520', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4041', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4042', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4043', '1012', '521', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4044', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4045', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4046', '1012', '522', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4047', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4048', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4049', '1012', '523', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4050', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4051', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4052', '1012', '524', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4053', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4054', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4055', '1012', '525', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4056', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4057', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4058', '1012', '526', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4059', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4060', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4061', '1012', '527', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4062', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4063', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4064', '1012', '528', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4065', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4066', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4067', '1012', '529', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4068', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4069', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4070', '1012', '530', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4071', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4072', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4073', '1012', '531', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4074', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4075', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4076', '1012', '532', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4077', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4078', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4079', '1012', '533', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4080', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4081', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4082', '1012', '534', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4083', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4084', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4085', '1012', '535', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4086', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4087', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4088', '1012', '536', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4089', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4090', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4091', '1012', '537', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4092', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4093', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4094', '1012', '538', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4095', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4096', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4097', '1012', '539', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4098', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4099', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4100', '1012', '540', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('4101', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4102', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4103', '1012', '541', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4104', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4105', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4106', '1012', '542', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4107', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4108', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4109', '1012', '543', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4110', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4111', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4112', '1012', '544', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4113', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4114', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4115', '1012', '545', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4116', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4117', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4118', '1012', '546', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4119', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4120', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4121', '1012', '547', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4122', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4123', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4124', '1012', '548', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4125', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4126', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4127', '1012', '549', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4128', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4129', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4130', '1012', '550', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4131', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4132', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4133', '1012', '551', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4134', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4135', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4136', '1012', '552', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4137', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4138', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4139', '1012', '553', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4140', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4141', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4142', '1012', '554', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4143', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4144', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4145', '1012', '555', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4146', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4147', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4148', '1012', '556', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4149', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4150', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4151', '1012', '557', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4152', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4153', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4154', '1012', '558', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4155', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4156', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4157', '1012', '559', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4158', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4159', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4160', '1012', '560', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4161', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4162', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4163', '1012', '561', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4164', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4165', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4166', '1012', '562', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4167', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4168', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4169', '1012', '563', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4170', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4171', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4172', '1012', '564', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4173', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4174', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4175', '1012', '565', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4176', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4177', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4178', '1012', '566', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4179', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4180', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4181', '1012', '567', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4182', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4183', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4184', '1012', '568', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4185', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4186', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4187', '1012', '569', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4188', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4189', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4190', '1012', '570', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4191', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4192', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4193', '1012', '571', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4194', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4195', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4196', '1012', '572', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4197', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4198', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4199', '1012', '573', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4200', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4201', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4202', '1012', '574', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4203', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4204', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4205', '1012', '575', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4206', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4207', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4208', '1012', '576', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4209', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4210', '1010', '0', '25', '2024-01-18 10:26:23', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4211', '1012', '577', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4212', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4213', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4214', '1012', '578', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4215', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4216', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4217', '1012', '579', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4218', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4219', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4220', '1012', '580', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4221', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4222', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4223', '1012', '581', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4224', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4225', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4226', '1012', '582', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4227', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4228', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4229', '1012', '583', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4230', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4231', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4232', '1012', '584', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4233', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4234', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4235', '1012', '585', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4236', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4237', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4238', '1012', '586', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4239', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4240', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4241', '1012', '587', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4242', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4243', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4244', '1012', '588', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4245', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4246', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4247', '1012', '589', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4248', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4249', '1010', '0', '25', '2024-01-18 10:26:24', 'Create New Item', '0', '2024-01-18', NULL, '0', '0'),
('4250', '1012', '590', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4251', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');

### Structure of table `0_auto_email` ###

DROP TABLE IF EXISTS `0_auto_email`;

CREATE TABLE `0_auto_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rep_name` varchar(100) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `email` varchar(50) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `email_body` longtext NOT NULL,
  `time` varchar(50) NOT NULL,
  `date` varchar(11) NOT NULL,
  `weekend` varchar(15) NOT NULL,
  `cur_time` time NOT NULL,
  `cur_date` date NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_auto_email` ###

INSERT INTO `0_auto_email` VALUES
('1', 'Purchase Summary Report', '206', 'kamran@mrxpert.ae', 'Purchase Report', 'Daily Purchase report', '18-00', 'Daily', '', '11:26:46', '2023-08-15', '0', '0'),
('2', 'Customer Balance', '101', 'kamran@mrxpert.ae', 'Customer Balance', 'Daily Customer Balance report', '11-30', 'Daily', '', '11:26:46', '2023-08-15', '0', '0');

### Structure of table `0_auto_mail` ###

DROP TABLE IF EXISTS `0_auto_mail`;

CREATE TABLE `0_auto_mail` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `hours` varchar(50) NOT NULL,
  `minutes` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `days` varchar(50) DEFAULT NULL,
  `inactive` tinyint(10) NOT NULL DEFAULT 0,
  `deleted` tinyint(11) NOT NULL DEFAULT 0,
  `rep_id` int(100) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_auto_mail` ###


### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `bank_account_arabic` varchar(100) NOT NULL,
  `iban` varchar(1000) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('000002', '1', 'Habib Bank AG Zurich', '0201010203111050870595', 'Habib Bank AG Zurich', NULL, 'AED', '1', '6', '5690', '0000-00-00 00:00:00', '0', '', 'AE100290120311105870595', '0', '0'),
('20001', '3', 'cash in hand', '', 'cash in hand', NULL, 'AED', '0', '7', '5690', '0000-00-00 00:00:00', '0', '', '', '0', '0'),
('21076', '3', 'Petty cash office', '', 'Petty cash office', NULL, 'AED', '0', '8', '5690', '0000-00-00 00:00:00', '0', '', '', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `emp_id` int(11) NOT NULL,
  `reconciled` date DEFAULT NULL,
  `approved` int(11) NOT NULL,
  `alloc` double NOT NULL,
  `refund` int(11) NOT NULL,
  `invoice` int(11) NOT NULL,
  `pdcStatus` tinyint(1) NOT NULL,
  `pdcDate` date NOT NULL,
  `transfered` tinyint(1) NOT NULL,
  `previous_bank` int(11) NOT NULL,
  `bounce_cheque` tinyint(1) NOT NULL,
  `transfered_from_bank` varchar(255) NOT NULL,
  `advance_salary` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '0', '9', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('2', '0', '10', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('3', '0', '11', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('4', '0', '12', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('5', '0', '13', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('6', '0', '14', '7', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('7', '0', '14', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('8', '0', '15', '7', 'JV-03', '2023-12-31', '35.5', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('9', '0', '15', '8', 'JV-03', '2023-12-31', '-14050.62', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0'),
('10', '0', '15', '6', 'JV-03', '2023-12-31', '37388.93', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '0', '0', '0', '', '0');

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###


### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `memo_` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_buyer_header` ###

DROP TABLE IF EXISTS `0_buyer_header`;

CREATE TABLE `0_buyer_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_id` int(11) NOT NULL,
  `header_name` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_buyer_header` ###


### Structure of table `0_buyer_header_master` ###

DROP TABLE IF EXISTS `0_buyer_header_master`;

CREATE TABLE `0_buyer_header_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_buyer_header_master` ###


### Structure of table `0_charge_group` ###

DROP TABLE IF EXISTS `0_charge_group`;

CREATE TABLE `0_charge_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(250) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_charge_group` ###

INSERT INTO `0_charge_group` VALUES
('1', 'Test Group', '0'),
('2', 'Test Group - 1', '0'),
('3', 'Test Group - 2', '0');

### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `name_arabic` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '', '0'),
('10', 'Current Assets', '1', '', '0'),
('2', 'Liabilities', '2', '', '0'),
('3', 'Income', '4', '', '0'),
('4', 'Admin and General Expense', '6', '', '0'),
('5', 'Equity', '3', '', '0'),
('6', 'Cost of goods sold', '5', '', '0'),
('7', 'Non Current Assets', '1', '', '0'),
('8', 'Bank Borrowings', '2', '', '0'),
('9', 'FIxed Assets', '1', '', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `account_name_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('000002', '', 'Habib Bank AG Zurich', '24-01', '', '0'),
('0003', '', 'Loans &amp; Advances (Asset)', '01', '', '1'),
('1060', '', 'Opening Account', '01', '', '0'),
('1200', '', 'Sundry Debtors', '01', '', '0'),
('1510', '', 'Inventory', '2', '', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '', '0'),
('1881', '', 'Fuel &amp; Transportation Expense', '21', '', '0'),
('1886', '', 'Repair Maintenance Expenses-Vehicles', '21', '', '0'),
('1888', '', 'Traffic Fines and Payments', '21', '', '0'),
('1897', '', 'General Expense', '21', '', '0'),
('1905', '', 'Paid Leaves', '16', '', '0'),
('1914', '', 'PENALITIES TO EMPLOYEES', '20', '', '0'),
('1915', '', 'Purchase Discount', '20', '', '0'),
('20001', '', 'Cash In Hand', '24-01', '', '0'),
('2022', '', 'Purchases Cash- Taxable', '10', '', '0'),
('2034', '', 'Discount Received', '20', '', '0'),
('2100', '', 'Sundry Creditors', '4', '', '0'),
('21001', '', 'Commission on contract', '21', '', '0'),
('21002', '', 'Commission on Referral', '21', '', '0'),
('21004', '', 'Membership and Renewal Expense', '21', '', '0'),
('21005', '', 'Office Maintenance Expense Taxable', '21', '', '0'),
('21006', '', 'Office Supplies and Stationary Expenses Taxable', '21', '', '0'),
('21007', '', 'Rental Expense', '21', '', '0'),
('21009', '', 'Selling &amp; Marketing Expenses', '21', '', '0'),
('21010', '', 'Traffic Fines and Payments', '21', '', '0'),
('210101', '', 'Electricity Expense', '21', '', '0'),
('21011', '', 'Vehicle Insurance &amp; Registration Expenses taxable', '21', '', '0'),
('21013', '', 'AGENCY FEE TAXABLE', '21', '', '0'),
('21014', '', 'Air Tickets Expenses', '21', '', '0'),
('21015', '', 'Bad Debts', '21', '', '0'),
('21017', '', 'Carriage Inward', '21', '', '0'),
('21018', '', 'Delivery Charges Non Taxable', '21', '', '0'),
('21019', '', 'Ejari Expense', '21', '', '0'),
('21020', '', 'Employee&#039;s Accommodation Expense', '21', '', '0'),
('21021', '', 'Exchange Commission Expenses', '21', '', '0'),
('21022', '', 'Fuel Expense - P-25757 (Arslan) Non Taxable', '21-11', '', '0'),
('21023', '', 'IT Services Expense', '21', '', '0'),
('21024', '', 'Loading Unloading Charges', '21', '', '0'),
('21025', '', 'Medical Expenses', '21', '', '0'),
('21026', '', 'Network Charges Expense', '21', '', '0'),
('21027', '', 'Office Maintenance Non Taxable', '21', '', '0'),
('21028', '', 'Post Office Expense Non Taxable', '21', '', '0'),
('21029', '', 'PRINTING &amp; STATIONARY', '21', '', '0'),
('21030', '', 'Sponsorship Fee Taxable', '21', '', '0'),
('21031', '', 'Sponsorship Fee Non Taxable', '21', '', '0'),
('21032', '', 'Subscription Fees - Taxable', '21', '', '0'),
('21033', '', 'Trade License&#039;s Expenses', '21', '', '0'),
('21034', '', 'Vehicle Renewal Expense Non Taxable', '21', '', '0'),
('21035', '', 'Administration Expenses', '21', '', '0'),
('21036', '', 'Visa Processing Charges - Taxable', '24-08', '', '0'),
('21037', '', 'Visa &amp; Renewables - Abdulla Nepali  MXTS', '24-08', '', '0'),
('21038', '', 'Visa &amp; Renewables - Abid MXTS', '24-08', '', '0'),
('21039', '', 'Visa &amp; Renewables - Afaq Mxts', '24-08', '', '0'),
('21040', '', 'Visa &amp; Renewables - Akbar MXT', '24-08', '', '0'),
('21041', '', 'Visa &amp; Renewables - Arslan MXTS', '24-08', '', '0'),
('21042', '', 'Visa &amp; Renewables Exp-Bir Singh', '24-08', '', '0'),
('21043', '', 'Visa &amp; Renewables - Imran MXTS', '24-08', '', '0'),
('21044', '', 'Visa &amp; Renewables - Shakeel Ahmed MXT', '24-08', '', '0'),
('21045', '', 'Visa &amp; Renewables - Usama MXTS', '24-08', '', '0'),
('21046', '', 'DEWA Expense Taxable', '24-09', '', '0'),
('21047', '', 'Dewa Expense Non Taxable', '24-09', '', '0'),
('21048', '', 'Etisalat Expense Taxable', '24-09', '', '0'),
('21049', '', 'Etisalat Expense Non Taxable', '24-09', '', '0'),
('2105', '', 'Deferred Income', '4', '', '0'),
('21050', '', 'Mobile Expenses', '24-09', '', '0'),
('21051', '', 'Repair MaintenanceP-25757 -Vehicles', '24-10', '', '0'),
('21052', '', 'Repair MaintenanceP-25757 -Vehicles Taxable', '24-10', '', '0'),
('21053', '', 'Repair Maintenance(P-26138) -Vehicles', '24-10', '', '0'),
('21054', '', 'Repair Maintenance(P-26138) -Vehicles Taxable', '24-10', '', '0'),
('21055', '', 'Repair MaintenanceP-56609 -Vehicles Non Taxable', '24-10', '', '0'),
('21056', '', 'Repair Maintenance R-45327 -Vehicles', '24-10', '', '0'),
('21057', '', 'Repair Maintenance R-45327 -Vehicles Taxable', '24-10', '', '0'),
('21058', '', 'Repair Maintenance Vehicle Taxable', '24-10', '', '0'),
('21059', '', 'Office Supplies &amp; Stationery Non Taxable', '21', '', '0'),
('21060', '', 'Salik Expenses', '21-11', '', '0'),
('21061', '', 'Cafu Expenses Taxable', '21-11', '', '0'),
('21062', '', 'Carriage Outward Non Taxable', '21-11', '', '0'),
('21063', '', 'Fuel Expense - G-56609 (Imran) Taxable', '21-11', '', '0'),
('21064', '', 'Fuel Expense - G-56609 (Imran) Non Taxable', '21-11', '', '0'),
('21065', '', 'Fuel Expense JAC S -77609 Non Taxable', '21-11', '', '0'),
('21066', '', 'Fuel Expense JAC S -77609  Taxable', '21-11', '', '0'),
('21067', '', 'Fuel Expense - P-25757 (Arslan) Taxable', '21-11', '', '0'),
('21068', '', 'Fuel Expense P-26138 (Van) Non Taxable', '21-11', '', '0'),
('21069', '', 'Fuel Expense P-26138 (Van) Taxable', '21-11', '', '0'),
('21070', '', 'Fuel Expense R-45327 Non Taxable', '21-11', '', '0'),
('21071', '', 'Fuel Expense R-45327 Taxable', '21-11', '', '0'),
('21072', '', 'Parking Fees', '21-11', '', '0'),
('21073', '', 'Taxi Pick Up Expense', '21-11', '', '0'),
('21074', '', 'Transportation Expenses', '21-11', '', '0'),
('21075', '', 'Vehicle Insurance &amp; Registration Expenses Non Taxable', '21', '', '0'),
('21076', '', 'Petty Cash ', '24-01', '', '0'),
('21077', '', 'Repair MaintenanceP-56609 -Vehicles Taxable', '24-10', '', '0'),
('2150', '', 'VAT', '4', '', '0'),
('2390', '', 'Duties and Taxes', '4', '', '0'),
('2391', '', 'Excise Tax 100%', '4', '', '0'),
('24001', '', 'Advance to Abid Hussain', '24-02', '', '0'),
('24002', '', 'Advance to Akbar (driver)', '24-02', '', '0'),
('24003', '', 'Advance to Arslan Nadeem', '24-02', '', '0'),
('24004', '', 'Advance to Ghulam Abass', '24-02', '', '0'),
('24005', '', 'Advance to Muhammad Adeel', '24-02', '', '0'),
('24006', '', 'Advance to Mustafa Saidu', '24-02', '', '0'),
('24007', '', 'DEWA Security', '24-03', '', '0'),
('24008', '', 'Employee&#039;s Accommodation Rental Security', '24-03', '', '0'),
('24009', '', 'Rental Security', '24-03', '', '0'),
('24010', '', 'Development Planning Account', '24-03', '', '0'),
('24012', '', 'Advance to AFAQ MAHMOOD MAHMOOD AHMAD ', '24-02', '', '0'),
('24013', '', 'Advance to Bir Singh', '24-02', '', '0'),
('24014', '', 'Advance to Durgalal Nepali', '24-02', '', '0'),
('24015', '', 'Advance to Imran Qasim', '24-02', '', '0'),
('24016', '', 'Advance to Muhammad Akhtar', '24-02', '', '0'),
('24017', '', 'Advance to Muhammad Usama', '24-02', '', '0'),
('24018', '', 'Advance to Muhammad Ibrar', '24-02', '', '0'),
('24019', '', 'Advance to Shahid Farooq', '24-02', '', '0'),
('24021', '', 'Advance to Shakeel Ahmed', '24-02', '', '0'),
('24022', '', 'Advance to Tauheed Ahmed', '24-02', '', '0'),
('24023', '', 'Advance to Zeeshan Ali', '24-02', '', '0'),
('24025', '', 'Prepaid Employees Accommodation Expense', '24-04', '', '0'),
('24026', '', 'Prepaid Rent', '24-04', '', '0'),
('24027', '', 'Vehicle 26138', '24-05', '', '0'),
('24028', '', 'Vehicle 60936', '24-05', '', '0'),
('24029', '', 'Vehicle G-56609', '24-05', '', '0'),
('24030', '', 'Vehicle Mitsubishi Lancer R 45327', '24-05', '', '0'),
('24031', '', 'vehicle P25757', '24-05', '', '0'),
('24032', '', 'Accumulated Depreciation Vehicle 26138', '24-07', '', '0'),
('24033', '', 'Accumulated Depreciation Vehicle 60936', '24-07', '', '0'),
('24034', '', 'Accumulated Depreciation Vehicle G-56609', '24-07', '', '0'),
('24035', '', 'Accumulated Depreciation Vehicle P25757', '24-07', '', '0'),
('24036', '', 'Other Tools', '24-06', '', '0'),
('24037', '', 'Loan From Directors', '4', '', '0'),
('24038', '', 'Director Expenses', '6', '', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '', '0'),
('4010', '', 'Sales Paint job', '8', '', '0'),
('4430', '', 'Shipping &amp; Handling Expense', '21', '', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '', '1'),
('4500', '', 'Discount Received ', '9', '', '1'),
('4510', '', 'Discounts Allowed Taxable', '16', '', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '', '0'),
('5020', '', 'Miscellaneous  Cash purchase item Taxable', '10', '', '0'),
('5030', '', 'Purchase Expenses Bindhahi', '10', '', '0'),
('5040', '', 'Purchase price Variance', '10', '', '0'),
('5050', '', 'Purchases', '10', '', '0'),
('5060', '', 'Discounts Received', '10', '', '1'),
('5070', '', 'Unregistered Purchases', '10', '', '0'),
('5420', '', 'Overtime', '16', '', '0'),
('5421', '', 'Discount Allowed Non-Taxable', '16', '', '0'),
('5422', '', 'Site Maintenance Expense Non Taxable', '16', '', '0'),
('5423', '', 'Basic Salary', '16', '', '0'),
('5424', '', 'Home Allowance', '16', '', '0'),
('5425', '', 'Outside Labour', '16', '', '0'),
('5426', '', 'Meals and Entertainment Expense', '16', '', '0'),
('5427', '', 'Rewards and Benefits', '16', '', '0'),
('5429', '', 'Unpaid Leaves', '16', '', '0'),
('5660', '', 'Depreciation Expense', '21', '', '0'),
('5690', '', 'Bank Charges', '21', '', '0'),
('5780', '', 'Telephone', '21', '', '0'),
('9990', '', 'Year Profit/Loss', '12', '', '1');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `name_arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('01', 'Current Assets', '1', '', '', '0'),
('10', 'Purchase Account ', '6', '', '', '0'),
('11', 'Payroll Expenses', '4', '', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '', '0'),
('13', 'Short term loan', '8', '', '', '0'),
('16', 'Direct Expenses', '4', '', '', '0'),
('19', 'Direct Income', '3', '', '', '0'),
('2', 'Inventory Assets', '1', '01', '', '0'),
('20', 'Indirect Income', '4', '', '', '0'),
('21', 'Indirect Expenses', '4', '', '', '0'),
('21-11', 'Fuel And Transportation Expense', '4', '21', '', '0'),
('24-01', 'Cash and Bank', '1', '01', '', '0'),
('24-02', 'Loans and Advances (Assets)', '1', '01', '', '0'),
('24-03', 'Deposits and Securities', '1', '01', '', '0'),
('24-04', 'Prepayments', '1', '01', '', '0'),
('24-05', 'Vehicles', '1', '3', '', '0'),
('24-06', 'Machinery and Tools', '1', '3', '', '0'),
('24-07', 'Accumulated Depriciation', '1', '3', '', '0'),
('24-08', 'VISA EXPENSES', '4', '21', '', '0'),
('24-09', 'Utility Expenses', '4', '21', '', '0'),
('24-10', 'Repair and Maintenance Vehicles', '4', '21', '', '0'),
('3', 'Fixed Assets', '1', '', '', '0'),
('4', 'Current Liabilities', '2', '', '', '0'),
('5', 'Long Term Liabilities', '2', '', '', '0'),
('6', 'Capital Account', '5', '', '', '0'),
('7', 'Retained Earnings', '2', '', '', '0'),
('8', 'Sales Account', '3', '', '', '0'),
('9', 'Other Income', '3', '', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###


### Structure of table `0_company_header` ###

DROP TABLE IF EXISTS `0_company_header`;

CREATE TABLE `0_company_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coy_name` varchar(255) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `postal_address` varchar(255) NOT NULL,
  `domicile` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `fax` varchar(255) NOT NULL,
  `gst_no` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `pic` varchar(255) NOT NULL,
  `del_coy_logo` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_company_header` ###

INSERT INTO `0_company_header` VALUES
('1', 'Company 1', '1', 'Company 1', 'Company 1', '(654) 6-455-6456', 'Company 1', 'Company Test', 'sindh_branch@gmail.com', '', '0'),
('2', 'WayZ Consulting Dubai', '2', 'Ehome Smart Technology Teneral Trading L.L.', 'domicile-ehome', '(971) 1-234-56777', 'fax - ehome', 'GST NO EHOMES', 'ehome@ehome.com', 'wayz_logo.jpg', '0'),
('3', '3 EXPO SHARJAH', '3', 'abu-dhabhi\r\nabu-dhabhi', '3 EXPO SHARJAH', '3 EXPO SHARJAH', '3 EXPO SHARJAH', '3 EXPO SHARJAH', 'expo@gmail.com', 'theonedolce-and-gabbana-the-one-EDP-perfume-women_v3.png', '0'),
('4', 'Company 4', '4', 'Company 4', 'Company 4', '(222) 2-222-4444', '2332323', '33232', 'Company_4@gmail.com', '', '0'),
('5', 'XYZ INC', '7', 'XYZZ', 'Abu Dhabi.', '(314) 2-089-451_', '3142089451', '100212275000003', 'raza789j@gmail.com', 'PP-100X100.png', '0');

### Structure of table `0_complaint` ###

DROP TABLE IF EXISTS `0_complaint`;

CREATE TABLE `0_complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) NOT NULL,
  `complaint_date` date NOT NULL,
  `debtor_no` int(11) NOT NULL,
  `sales_order` int(11) NOT NULL,
  `complaint_type` int(11) NOT NULL,
  `cust_memo` varchar(1000) NOT NULL,
  `user_id` int(11) NOT NULL,
  `responsible_person_name` varchar(1000) NOT NULL,
  `responsible_person_comment` varchar(1000) NOT NULL,
  `decision` varchar(1000) NOT NULL,
  `status` int(11) NOT NULL,
  `close_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_complaint` ###


### Structure of table `0_complaint_types` ###

DROP TABLE IF EXISTS `0_complaint_types`;

CREATE TABLE `0_complaint_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(500) NOT NULL,
  `order_compulsory` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_complaint_types` ###


### Structure of table `0_contact_person` ###

DROP TABLE IF EXISTS `0_contact_person`;

CREATE TABLE `0_contact_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `contact` varchar(100) NOT NULL,
  `contract_type` int(11) NOT NULL,
  `authority` int(11) NOT NULL,
  `sales_type` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_contact_person` ###


### Structure of table `0_countries` ###

DROP TABLE IF EXISTS `0_countries`;

CREATE TABLE `0_countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortname` varchar(3) NOT NULL,
  `name` varchar(150) NOT NULL,
  `phonecode` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_countries` ###

INSERT INTO `0_countries` VALUES
('1', 'AF', 'Afghanistan', '93'),
('2', 'AL', 'Albania', '355'),
('3', 'DZ', 'Algeria', '213'),
('4', 'AS', 'American Samoa', '1684'),
('5', 'AD', 'Andorra', '376'),
('6', 'AO', 'Angola', '244'),
('7', 'AI', 'Anguilla', '1264'),
('8', 'AQ', 'Antarctica', '0'),
('9', 'AG', 'Antigua And Barbuda', '1268'),
('10', 'AR', 'Argentina', '54'),
('11', 'AM', 'Armenia', '374'),
('12', 'AW', 'Aruba', '297'),
('13', 'AU', 'Australia', '61'),
('14', 'AT', 'Austria', '43'),
('15', 'AZ', 'Azerbaijan', '994'),
('16', 'BS', 'Bahamas The', '1242'),
('17', 'BH', 'Bahrain', '973'),
('18', 'BD', 'Bangladesh', '880'),
('19', 'BB', 'Barbados', '1246'),
('20', 'BY', 'Belarus', '375'),
('21', 'BE', 'Belgium', '32'),
('22', 'BZ', 'Belize', '501'),
('23', 'BJ', 'Benin', '229'),
('24', 'BM', 'Bermuda', '1441'),
('25', 'BT', 'Bhutan', '975'),
('26', 'BO', 'Bolivia', '591'),
('27', 'BA', 'Bosnia and Herzegovina', '387'),
('28', 'BW', 'Botswana', '267'),
('29', 'BV', 'Bouvet Island', '0'),
('30', 'BR', 'Brazil', '55'),
('31', 'IO', 'British Indian Ocean Territory', '246'),
('32', 'BN', 'Brunei', '673'),
('33', 'BG', 'Bulgaria', '359'),
('34', 'BF', 'Burkina Faso', '226'),
('35', 'BI', 'Burundi', '257'),
('36', 'KH', 'Cambodia', '855'),
('37', 'CM', 'Cameroon', '237'),
('38', 'CA', 'Canada', '1'),
('39', 'CV', 'Cape Verde', '238'),
('40', 'KY', 'Cayman Islands', '1345'),
('41', 'CF', 'Central African Republic', '236'),
('42', 'TD', 'Chad', '235'),
('43', 'CL', 'Chile', '56'),
('44', 'CN', 'China', '86'),
('45', 'CX', 'Christmas Island', '61'),
('46', 'CC', 'Cocos (Keeling) Islands', '672'),
('47', 'CO', 'Colombia', '57'),
('48', 'KM', 'Comoros', '269'),
('49', 'CG', 'Republic Of The Congo', '242'),
('50', 'CD', 'Democratic Republic Of The Congo', '242'),
('51', 'CK', 'Cook Islands', '682'),
('52', 'CR', 'Costa Rica', '506'),
('53', 'CI', 'Cote D&#039;Ivoire (Ivory Coast)', '225'),
('54', 'HR', 'Croatia (Hrvatska)', '385'),
('55', 'CU', 'Cuba', '53'),
('56', 'CY', 'Cyprus', '357'),
('57', 'CZ', 'Czech Republic', '420'),
('58', 'DK', 'Denmark', '45'),
('59', 'DJ', 'Djibouti', '253'),
('60', 'DM', 'Dominica', '1767'),
('61', 'DO', 'Dominican Republic', '1809'),
('62', 'TP', 'East Timor', '670'),
('63', 'EC', 'Ecuador', '593'),
('64', 'EG', 'Egypt', '20'),
('65', 'SV', 'El Salvador', '503'),
('66', 'GQ', 'Equatorial Guinea', '240'),
('67', 'ER', 'Eritrea', '291'),
('68', 'EE', 'Estonia', '372'),
('69', 'ET', 'Ethiopia', '251'),
('70', 'XA', 'External Territories of Australia', '61'),
('71', 'FK', 'Falkland Islands', '500'),
('72', 'FO', 'Faroe Islands', '298'),
('73', 'FJ', 'Fiji Islands', '679'),
('74', 'FI', 'Finland', '358'),
('75', 'FR', 'France', '33'),
('76', 'GF', 'French Guiana', '594'),
('77', 'PF', 'French Polynesia', '689'),
('78', 'TF', 'French Southern Territories', '0'),
('79', 'GA', 'Gabon', '241'),
('80', 'GM', 'Gambia The', '220'),
('81', 'GE', 'Georgia', '995'),
('82', 'DE', 'Germany', '49'),
('83', 'GH', 'Ghana', '233'),
('84', 'GI', 'Gibraltar', '350'),
('85', 'GR', 'Greece', '30'),
('86', 'GL', 'Greenland', '299'),
('87', 'GD', 'Grenada', '1473'),
('88', 'GP', 'Guadeloupe', '590'),
('89', 'GU', 'Guam', '1671'),
('90', 'GT', 'Guatemala', '502'),
('91', 'XU', 'Guernsey and Alderney', '44'),
('92', 'GN', 'Guinea', '224'),
('93', 'GW', 'Guinea-Bissau', '245'),
('94', 'GY', 'Guyana', '592'),
('95', 'HT', 'Haiti', '509'),
('96', 'HM', 'Heard and McDonald Islands', '0'),
('97', 'HN', 'Honduras', '504'),
('98', 'HK', 'Hong Kong S.A.R.', '852'),
('99', 'HU', 'Hungary', '36'),
('100', 'IS', 'Iceland', '354'),
('101', 'IN', 'India', '91'),
('102', 'ID', 'Indonesia', '62'),
('103', 'IR', 'Iran', '98'),
('104', 'IQ', 'Iraq', '964'),
('105', 'IE', 'Ireland', '353'),
('106', 'IL', 'Israel', '972'),
('107', 'IT', 'Italy', '39'),
('108', 'JM', 'Jamaica', '1876'),
('109', 'JP', 'Japan', '81'),
('110', 'XJ', 'Jersey', '44'),
('111', 'JO', 'Jordan', '962'),
('112', 'KZ', 'Kazakhstan', '7'),
('113', 'KE', 'Kenya', '254'),
('114', 'KI', 'Kiribati', '686'),
('115', 'KP', 'Korea North', '850'),
('116', 'KR', 'Korea South', '82'),
('117', 'KW', 'Kuwait', '965'),
('118', 'KG', 'Kyrgyzstan', '996'),
('119', 'LA', 'Laos', '856'),
('120', 'LV', 'Latvia', '371'),
('121', 'LB', 'Lebanon', '961'),
('122', 'LS', 'Lesotho', '266'),
('123', 'LR', 'Liberia', '231'),
('124', 'LY', 'Libya', '218'),
('125', 'LI', 'Liechtenstein', '423'),
('126', 'LT', 'Lithuania', '370'),
('127', 'LU', 'Luxembourg', '352'),
('128', 'MO', 'Macau S.A.R.', '853'),
('129', 'MK', 'Macedonia', '389'),
('130', 'MG', 'Madagascar', '261'),
('131', 'MW', 'Malawi', '265'),
('132', 'MY', 'Malaysia', '60'),
('133', 'MV', 'Maldives', '960'),
('134', 'ML', 'Mali', '223'),
('135', 'MT', 'Malta', '356'),
('136', 'XM', 'Man (Isle of)', '44'),
('137', 'MH', 'Marshall Islands', '692'),
('138', 'MQ', 'Martinique', '596'),
('139', 'MR', 'Mauritania', '222'),
('140', 'MU', 'Mauritius', '230'),
('141', 'YT', 'Mayotte', '269'),
('142', 'MX', 'Mexico', '52'),
('143', 'FM', 'Micronesia', '691'),
('144', 'MD', 'Moldova', '373'),
('145', 'MC', 'Monaco', '377'),
('146', 'MN', 'Mongolia', '976'),
('147', 'MS', 'Montserrat', '1664'),
('148', 'MA', 'Morocco', '212'),
('149', 'MZ', 'Mozambique', '258'),
('150', 'MM', 'Myanmar', '95'),
('151', 'NA', 'Namibia', '264'),
('152', 'NR', 'Nauru', '674'),
('153', 'NP', 'Nepal', '977'),
('154', 'AN', 'Netherlands Antilles', '599'),
('155', 'NL', 'Netherlands The', '31'),
('156', 'NC', 'New Caledonia', '687'),
('157', 'NZ', 'New Zealand', '64'),
('158', 'NI', 'Nicaragua', '505'),
('159', 'NE', 'Niger', '227'),
('160', 'NG', 'Nigeria', '234'),
('161', 'NU', 'Niue', '683'),
('162', 'NF', 'Norfolk Island', '672'),
('163', 'MP', 'Northern Mariana Islands', '1670'),
('164', 'NO', 'Norway', '47'),
('165', 'OM', 'Oman', '968'),
('166', 'PK', 'Pakistan', '92'),
('167', 'PW', 'Palau', '680'),
('168', 'PS', 'Palestinian Territory Occupied', '970'),
('169', 'PA', 'Panama', '507'),
('170', 'PG', 'Papua new Guinea', '675'),
('171', 'PY', 'Paraguay', '595'),
('172', 'PE', 'Peru', '51'),
('173', 'PH', 'Philippines', '63'),
('174', 'PN', 'Pitcairn Island', '0'),
('175', 'PL', 'Poland', '48'),
('176', 'PT', 'Portugal', '351'),
('177', 'PR', 'Puerto Rico', '1787'),
('178', 'QA', 'Qatar', '974'),
('179', 'RE', 'Reunion', '262'),
('180', 'RO', 'Romania', '40'),
('181', 'RU', 'Russia', '70'),
('182', 'RW', 'Rwanda', '250'),
('183', 'SH', 'Saint Helena', '290'),
('184', 'KN', 'Saint Kitts And Nevis', '1869'),
('185', 'LC', 'Saint Lucia', '1758'),
('186', 'PM', 'Saint Pierre and Miquelon', '508'),
('187', 'VC', 'Saint Vincent And The Grenadines', '1784'),
('188', 'WS', 'Samoa', '684'),
('189', 'SM', 'San Marino', '378'),
('190', 'ST', 'Sao Tome and Principe', '239'),
('191', 'SA', 'Saudi Arabia', '966'),
('192', 'SN', 'Senegal', '221'),
('193', 'RS', 'Serbia', '381'),
('194', 'SC', 'Seychelles', '248'),
('195', 'SL', 'Sierra Leone', '232'),
('196', 'SG', 'Singapore', '65'),
('197', 'SK', 'Slovakia', '421'),
('198', 'SI', 'Slovenia', '386'),
('199', 'XG', 'Smaller Territories of the UK', '44'),
('200', 'SB', 'Solomon Islands', '677'),
('201', 'SO', 'Somalia', '252'),
('202', 'ZA', 'South Africa', '27'),
('203', 'GS', 'South Georgia', '0'),
('204', 'SS', 'South Sudan', '211'),
('205', 'ES', 'Spain', '34'),
('206', 'LK', 'Sri Lanka', '94'),
('207', 'SD', 'Sudan', '249'),
('208', 'SR', 'Suriname', '597'),
('209', 'SJ', 'Svalbard And Jan Mayen Islands', '47'),
('210', 'SZ', 'Swaziland', '268'),
('211', 'SE', 'Sweden', '46'),
('212', 'CH', 'Switzerland', '41'),
('213', 'SY', 'Syria', '963'),
('214', 'TW', 'Taiwan', '886'),
('215', 'TJ', 'Tajikistan', '992'),
('216', 'TZ', 'Tanzania', '255'),
('217', 'TH', 'Thailand', '66'),
('218', 'TG', 'Togo', '228'),
('219', 'TK', 'Tokelau', '690'),
('220', 'TO', 'Tonga', '676'),
('221', 'TT', 'Trinidad And Tobago', '1868'),
('222', 'TN', 'Tunisia', '216'),
('223', 'TR', 'Turkey', '90'),
('224', 'TM', 'Turkmenistan', '7370'),
('225', 'TC', 'Turks And Caicos Islands', '1649'),
('226', 'TV', 'Tuvalu', '688'),
('227', 'UG', 'Uganda', '256'),
('228', 'UA', 'Ukraine', '380'),
('229', 'AE', 'United Arab Emirates', '971'),
('230', 'GB', 'United Kingdom', '44'),
('231', 'US', 'United States', '1'),
('232', 'UM', 'United States Minor Outlying Islands', '1'),
('233', 'UY', 'Uruguay', '598'),
('234', 'UZ', 'Uzbekistan', '998'),
('235', 'VU', 'Vanuatu', '678'),
('236', 'VA', 'Vatican City State (Holy See)', '39'),
('237', 'VE', 'Venezuela', '58'),
('238', 'VN', 'Vietnam', '84'),
('239', 'VG', 'Virgin Islands (British)', '1284'),
('240', 'VI', 'Virgin Islands (US)', '1340'),
('241', 'WF', 'Wallis And Futuna Islands', '681'),
('242', 'EH', 'Western Sahara', '212'),
('243', 'YE', 'Yemen', '967'),
('244', 'YU', 'Yugoslavia', '38'),
('245', 'ZM', 'Zambia', '260'),
('246', 'ZW', 'Zimbabwe', '263');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('6', 'Active', '0', '0'),
('7', 'Inactive', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` tinytext NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_comments` ###

DROP TABLE IF EXISTS `0_crm_comments`;

CREATE TABLE `0_crm_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL,
  `branch_code` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `comment` varchar(5000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_crm_comments` ###


### Structure of table `0_crm_contact_form` ###

DROP TABLE IF EXISTS `0_crm_contact_form`;

CREATE TABLE `0_crm_contact_form` (
  `cust_id` int(11) NOT NULL AUTO_INCREMENT,
  `cont_per` varchar(100) NOT NULL,
  `comp_name` varchar(100) NOT NULL,
  `desg` varchar(100) NOT NULL,
  `user` int(11) NOT NULL,
  `trans_date` varchar(100) NOT NULL,
  `web` varchar(200) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `sec_phone` varchar(100) NOT NULL,
  `email_addr` varchar(100) NOT NULL,
  `mobile` varchar(100) NOT NULL,
  `mobile_1` varchar(100) NOT NULL,
  `fax` varchar(100) NOT NULL,
  `postal_address` varchar(200) NOT NULL,
  `attach_front` varchar(300) NOT NULL,
  `attach_back` varchar(300) NOT NULL,
  PRIMARY KEY (`cust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_crm_contact_form` ###


### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `entity_id` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=633 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'supplier', 'general', '1'),
('4', '3', 'cust_branch', 'general', '2'),
('5', '3', 'customer', 'general', '3'),
('6', '4', 'cust_branch', 'general', '3'),
('7', '4', 'customer', 'general', '4'),
('8', '5', 'cust_branch', 'general', '4'),
('9', '5', 'customer', 'general', '5'),
('10', '6', 'cust_branch', 'general', '5'),
('11', '6', 'customer', 'general', '6'),
('12', '7', 'cust_branch', 'general', '6'),
('13', '7', 'customer', 'general', '7'),
('14', '8', 'cust_branch', 'general', '7'),
('15', '8', 'customer', 'general', '8'),
('16', '9', 'cust_branch', 'general', '8'),
('17', '9', 'customer', 'general', '9'),
('20', '11', 'cust_branch', 'general', '10'),
('21', '11', 'customer', 'general', '11'),
('22', '12', 'cust_branch', 'general', '11'),
('23', '12', 'customer', 'general', '12'),
('24', '13', 'cust_branch', 'general', '12'),
('25', '13', 'customer', 'general', '13'),
('26', '14', 'cust_branch', 'general', '13'),
('27', '14', 'customer', 'general', '14'),
('28', '15', 'cust_branch', 'general', '14'),
('29', '15', 'customer', 'general', '15'),
('30', '16', 'cust_branch', 'general', '15'),
('31', '16', 'customer', 'general', '16'),
('32', '17', 'cust_branch', 'general', '16'),
('33', '17', 'customer', 'general', '17'),
('34', '18', 'cust_branch', 'general', '17'),
('35', '18', 'customer', 'general', '18'),
('36', '19', 'cust_branch', 'general', '18'),
('37', '19', 'customer', 'general', '19'),
('38', '20', 'cust_branch', 'general', '19'),
('39', '20', 'customer', 'general', '20'),
('40', '21', 'cust_branch', 'general', '20'),
('41', '21', 'customer', 'general', '21'),
('42', '22', 'cust_branch', 'general', '21'),
('43', '22', 'customer', 'general', '22'),
('44', '23', 'cust_branch', 'general', '22'),
('45', '23', 'customer', 'general', '23'),
('46', '24', 'cust_branch', 'general', '23'),
('47', '24', 'customer', 'general', '24'),
('48', '25', 'cust_branch', 'general', '24'),
('49', '25', 'customer', 'general', '25'),
('50', '26', 'cust_branch', 'general', '25'),
('51', '26', 'customer', 'general', '26'),
('52', '27', 'cust_branch', 'general', '26'),
('53', '27', 'customer', 'general', '27'),
('54', '28', 'cust_branch', 'general', '27'),
('55', '28', 'customer', 'general', '28'),
('56', '29', 'cust_branch', 'general', '28'),
('57', '29', 'customer', 'general', '29'),
('58', '30', 'cust_branch', 'general', '29'),
('59', '30', 'customer', 'general', '30'),
('60', '31', 'cust_branch', 'general', '30'),
('61', '31', 'customer', 'general', '31'),
('62', '32', 'cust_branch', 'general', '31'),
('63', '32', 'customer', 'general', '32'),
('64', '33', 'cust_branch', 'general', '32'),
('65', '33', 'customer', 'general', '33'),
('66', '34', 'cust_branch', 'general', '33'),
('67', '34', 'customer', 'general', '34'),
('68', '35', 'cust_branch', 'general', '34'),
('69', '35', 'customer', 'general', '35'),
('70', '36', 'cust_branch', 'general', '35'),
('71', '36', 'customer', 'general', '36'),
('72', '37', 'cust_branch', 'general', '36'),
('73', '37', 'customer', 'general', '37'),
('74', '38', 'cust_branch', 'general', '37'),
('75', '38', 'customer', 'general', '38'),
('76', '39', 'cust_branch', 'general', '38'),
('77', '39', 'customer', 'general', '39'),
('78', '40', 'cust_branch', 'general', '39'),
('79', '40', 'customer', 'general', '40'),
('80', '41', 'cust_branch', 'general', '40'),
('81', '41', 'customer', 'general', '41'),
('82', '42', 'cust_branch', 'general', '41'),
('83', '42', 'customer', 'general', '42'),
('84', '43', 'cust_branch', 'general', '42'),
('85', '43', 'customer', 'general', '43'),
('86', '44', 'cust_branch', 'general', '43'),
('87', '44', 'customer', 'general', '44'),
('88', '45', 'cust_branch', 'general', '44'),
('89', '45', 'customer', 'general', '45'),
('90', '46', 'cust_branch', 'general', '45'),
('91', '46', 'customer', 'general', '46'),
('92', '47', 'cust_branch', 'general', '46'),
('93', '47', 'customer', 'general', '47'),
('94', '48', 'cust_branch', 'general', '47'),
('95', '48', 'customer', 'general', '48'),
('96', '49', 'cust_branch', 'general', '48'),
('97', '49', 'customer', 'general', '49'),
('98', '50', 'cust_branch', 'general', '49'),
('99', '50', 'customer', 'general', '50'),
('100', '51', 'cust_branch', 'general', '50'),
('101', '51', 'customer', 'general', '51'),
('102', '52', 'cust_branch', 'general', '51'),
('103', '52', 'customer', 'general', '52'),
('104', '53', 'cust_branch', 'general', '52'),
('105', '53', 'customer', 'general', '53'),
('106', '54', 'cust_branch', 'general', '53'),
('107', '54', 'customer', 'general', '54'),
('108', '55', 'cust_branch', 'general', '54'),
('109', '55', 'customer', 'general', '55'),
('110', '56', 'cust_branch', 'general', '55'),
('111', '56', 'customer', 'general', '56'),
('112', '57', 'cust_branch', 'general', '56'),
('114', '58', 'cust_branch', 'general', '57'),
('115', '58', 'customer', 'general', '58'),
('116', '59', 'cust_branch', 'general', '58'),
('117', '59', 'customer', 'general', '59'),
('118', '60', 'cust_branch', 'general', '59'),
('119', '60', 'customer', 'general', '60'),
('120', '61', 'cust_branch', 'general', '60'),
('121', '61', 'customer', 'general', '61'),
('122', '62', 'cust_branch', 'general', '61'),
('123', '62', 'customer', 'general', '62'),
('124', '63', 'cust_branch', 'general', '62'),
('125', '63', 'customer', 'general', '63'),
('126', '64', 'cust_branch', 'general', '63'),
('127', '64', 'customer', 'general', '64'),
('128', '65', 'cust_branch', 'general', '64'),
('129', '65', 'customer', 'general', '65'),
('130', '66', 'cust_branch', 'general', '65'),
('131', '66', 'customer', 'general', '66'),
('132', '67', 'cust_branch', 'general', '66'),
('133', '67', 'customer', 'general', '67'),
('134', '68', 'cust_branch', 'general', '67'),
('135', '68', 'customer', 'general', '68'),
('136', '69', 'cust_branch', 'general', '68'),
('137', '69', 'customer', 'general', '69'),
('138', '70', 'cust_branch', 'general', '69'),
('139', '70', 'customer', 'general', '70'),
('140', '71', 'cust_branch', 'general', '70'),
('141', '71', 'customer', 'general', '71'),
('142', '72', 'cust_branch', 'general', '71'),
('143', '72', 'customer', 'general', '72'),
('144', '73', 'supplier', 'general', '2'),
('145', '74', 'supplier', 'general', '3'),
('146', '75', 'supplier', 'general', '4'),
('147', '76', 'supplier', 'general', '5'),
('148', '77', 'supplier', 'general', '6'),
('149', '78', 'supplier', 'general', '7'),
('150', '79', 'supplier', 'general', '8'),
('151', '80', 'supplier', 'general', '9'),
('152', '81', 'supplier', 'general', '10'),
('153', '82', 'supplier', 'general', '11'),
('154', '83', 'supplier', 'general', '12'),
('155', '84', 'supplier', 'general', '13'),
('156', '85', 'supplier', 'general', '14'),
('157', '86', 'supplier', 'general', '15'),
('158', '87', 'supplier', 'general', '16'),
('159', '88', 'supplier', 'general', '17'),
('160', '89', 'supplier', 'general', '18'),
('161', '90', 'supplier', 'general', '19'),
('162', '91', 'supplier', 'general', '20'),
('163', '92', 'supplier', 'general', '21'),
('164', '93', 'supplier', 'general', '22'),
('165', '94', 'supplier', 'general', '23'),
('166', '95', 'supplier', 'general', '24'),
('167', '96', 'supplier', 'general', '25'),
('168', '97', 'supplier', 'general', '26'),
('169', '98', 'supplier', 'general', '27'),
('170', '99', 'supplier', 'general', '28'),
('171', '100', 'supplier', 'general', '29'),
('172', '101', 'supplier', 'general', '30'),
('173', '102', 'supplier', 'general', '31'),
('174', '103', 'supplier', 'general', '32'),
('175', '104', 'supplier', 'general', '33'),
('176', '105', 'supplier', 'general', '34'),
('177', '106', 'cust_branch', 'general', '72'),
('178', '106', 'customer', 'general', '73'),
('179', '107', 'supplier', 'general', '35'),
('180', '108', 'cust_branch', 'general', '73'),
('181', '108', 'customer', 'general', '74'),
('182', '109', 'supplier', 'general', '36'),
('183', '110', 'cust_branch', 'general', '74'),
('184', '110', 'customer', 'general', '75'),
('185', '111', 'cust_branch', 'general', '75'),
('186', '111', 'customer', 'general', '78'),
('187', '112', 'cust_branch', 'general', '76'),
('188', '112', 'customer', 'general', '79'),
('189', '113', 'supplier', 'general', '37'),
('190', '114', 'supplier', 'general', '38'),
('191', '115', 'supplier', 'general', '39'),
('192', '116', 'supplier', 'general', '40'),
('193', '117', 'supplier', 'general', '41'),
('194', '118', 'supplier', 'general', '42'),
('195', '119', 'supplier', 'general', '43'),
('196', '120', 'cust_branch', 'general', '77'),
('197', '120', 'customer', 'general', '80'),
('198', '121', 'supplier', 'general', '44'),
('199', '122', 'supplier', 'general', '45'),
('200', '123', 'cust_branch', 'general', '78'),
('201', '123', 'customer', 'general', '81'),
('202', '124', 'supplier', 'general', '46'),
('203', '125', 'supplier', 'general', '47'),
('204', '126', 'cust_branch', 'general', '79'),
('205', '126', 'customer', 'general', '82'),
('206', '127', 'supplier', 'general', '48'),
('207', '128', 'supplier', 'general', '49'),
('208', '129', 'supplier', 'general', '50'),
('209', '130', 'supplier', 'general', '51'),
('210', '131', 'supplier', 'general', '52'),
('211', '132', 'supplier', 'general', '53'),
('212', '133', 'cust_branch', 'general', '80'),
('213', '133', 'customer', 'general', '83'),
('214', '134', 'supplier', 'general', '54'),
('215', '135', 'supplier', 'general', '55'),
('216', '136', 'cust_branch', 'general', '81'),
('217', '136', 'customer', 'general', '84'),
('218', '137', 'supplier', 'general', '56'),
('219', '138', 'cust_branch', 'general', '82'),
('220', '138', 'customer', 'general', '85'),
('221', '139', 'supplier', 'general', '57'),
('222', '140', 'supplier', 'general', '58'),
('223', '141', 'cust_branch', 'general', '83'),
('224', '141', 'customer', 'general', '86'),
('225', '142', 'supplier', 'general', '59'),
('226', '143', 'cust_branch', 'general', '84'),
('227', '143', 'customer', 'general', '87'),
('228', '144', 'supplier', 'general', '60'),
('229', '145', 'supplier', 'general', '61'),
('230', '146', 'cust_branch', 'general', '85'),
('231', '146', 'customer', 'general', '88'),
('232', '147', 'supplier', 'general', '62'),
('233', '148', 'cust_branch', 'general', '86'),
('234', '148', 'customer', 'general', '89'),
('235', '149', 'cust_branch', 'general', '87'),
('236', '149', 'customer', 'general', '90'),
('237', '150', 'cust_branch', 'general', '88'),
('238', '150', 'customer', 'general', '91'),
('239', '151', 'cust_branch', 'general', '89'),
('240', '151', 'customer', 'general', '92'),
('241', '152', 'supplier', 'general', '63'),
('242', '153', 'supplier', 'general', '64'),
('243', '154', 'cust_branch', 'general', '90'),
('244', '154', 'customer', 'general', '93'),
('245', '155', 'supplier', 'general', '65'),
('246', '156', 'supplier', 'general', '66'),
('247', '157', 'supplier', 'general', '67'),
('248', '158', 'supplier', 'general', '68'),
('249', '159', 'supplier', 'general', '69'),
('250', '160', 'supplier', 'general', '70'),
('251', '161', 'supplier', 'general', '71'),
('252', '162', 'supplier', 'general', '72'),
('253', '163', 'supplier', 'general', '73'),
('254', '164', 'supplier', 'general', '74'),
('255', '165', 'supplier', 'general', '75'),
('256', '166', 'supplier', 'general', '76'),
('257', '167', 'supplier', 'general', '77'),
('258', '168', 'supplier', 'general', '78'),
('259', '169', 'supplier', 'general', '79'),
('260', '170', 'supplier', 'general', '80'),
('261', '171', 'supplier', 'general', '81'),
('262', '172', 'supplier', 'general', '82'),
('263', '173', 'cust_branch', 'general', '91'),
('264', '173', 'customer', 'general', '94'),
('265', '174', 'cust_branch', 'general', '92'),
('266', '174', 'customer', 'general', '95'),
('267', '175', 'supplier', 'general', '83'),
('268', '176', 'cust_branch', 'general', '93'),
('269', '176', 'customer', 'general', '96'),
('270', '177', 'cust_branch', 'general', '94'),
('271', '177', 'customer', 'general', '97'),
('272', '178', 'cust_branch', 'general', '95'),
('273', '178', 'customer', 'general', '98'),
('274', '179', 'cust_branch', 'general', '96'),
('275', '179', 'customer', 'general', '99'),
('276', '180', 'supplier', 'general', '84'),
('277', '181', 'supplier', 'general', '85'),
('278', '182', 'supplier', 'general', '86'),
('279', '183', 'cust_branch', 'general', '97'),
('280', '183', 'customer', 'general', '100'),
('281', '184', 'cust_branch', 'general', '98'),
('282', '184', 'customer', 'general', '101'),
('283', '185', 'cust_branch', 'general', '99'),
('284', '185', 'customer', 'general', '102'),
('285', '186', 'supplier', 'general', '87'),
('286', '187', 'cust_branch', 'general', '100'),
('287', '187', 'customer', 'general', '103'),
('288', '188', 'cust_branch', 'general', '101'),
('289', '188', 'customer', 'general', '104'),
('290', '189', 'cust_branch', 'general', '102'),
('291', '189', 'customer', 'general', '105'),
('292', '57', 'customer', 'general', '57'),
('293', '190', 'supplier', 'general', '88'),
('294', '191', 'supplier', 'general', '89'),
('295', '192', 'cust_branch', 'general', '103'),
('297', '192', 'customer', 'general', '106'),
('298', '193', 'cust_branch', 'general', '104'),
('299', '193', 'customer', 'general', '107'),
('300', '194', 'cust_branch', 'general', '105'),
('301', '194', 'customer', 'general', '108'),
('302', '195', 'cust_branch', 'general', '106'),
('303', '195', 'customer', 'general', '109'),
('304', '196', 'supplier', 'general', '90'),
('305', '197', 'cust_branch', 'general', '107'),
('306', '197', 'customer', 'general', '110'),
('307', '198', 'cust_branch', 'general', '108'),
('308', '198', 'customer', 'general', '111'),
('309', '199', 'cust_branch', 'general', '109'),
('310', '199', 'customer', 'general', '112'),
('311', '200', 'cust_branch', 'general', '110'),
('312', '200', 'customer', 'general', '113'),
('313', '201', 'supplier', 'general', '91'),
('314', '202', 'supplier', 'general', '92'),
('315', '203', 'supplier', 'general', '93'),
('316', '204', 'cust_branch', 'general', '111'),
('317', '204', 'customer', 'general', '114'),
('318', '205', 'cust_branch', 'general', '112'),
('319', '205', 'customer', 'general', '115'),
('321', '206', 'customer', 'general', '116'),
('322', '207', 'supplier', 'general', '94'),
('323', '208', 'cust_branch', 'general', '114'),
('324', '208', 'customer', 'general', '117'),
('325', '209', 'cust_branch', 'general', '115'),
('326', '209', 'customer', 'general', '118'),
('327', '210', 'cust_branch', 'general', '116'),
('328', '210', 'customer', 'general', '119'),
('329', '211', 'supplier', 'general', '95'),
('330', '212', 'supplier', 'general', '96'),
('331', '213', 'supplier', 'general', '97'),
('332', '214', 'supplier', 'general', '98'),
('333', '215', 'cust_branch', 'general', '117'),
('334', '215', 'customer', 'general', '120'),
('335', '216', 'cust_branch', 'general', '118'),
('336', '216', 'customer', 'general', '121'),
('337', '217', 'supplier', 'general', '99'),
('338', '218', 'supplier', 'general', '100'),
('339', '219', 'supplier', 'general', '101'),
('340', '220', 'supplier', 'general', '102'),
('341', '221', 'supplier', 'general', '103'),
('342', '222', 'supplier', 'general', '104'),
('343', '223', 'supplier', 'general', '105'),
('344', '224', 'supplier', 'general', '106'),
('345', '225', 'supplier', 'general', '107'),
('346', '226', 'supplier', 'general', '108'),
('347', '227', 'supplier', 'general', '109'),
('348', '228', 'supplier', 'general', '110'),
('349', '229', 'cust_branch', 'general', '119'),
('350', '229', 'customer', 'general', '123'),
('352', '231', 'supplier', 'general', '111'),
('353', '232', 'supplier', 'general', '112'),
('354', '233', 'cust_branch', 'general', '121'),
('355', '233', 'customer', 'general', '124'),
('356', '234', 'cust_branch', 'general', '122'),
('357', '234', 'customer', 'general', '125'),
('358', '235', 'supplier', 'general', '113'),
('359', '236', 'cust_branch', 'general', '123'),
('360', '236', 'customer', 'general', '126'),
('361', '237', 'supplier', 'general', '114'),
('363', '206', 'cust_branch', 'general', '113'),
('364', '239', 'cust_branch', 'general', '125'),
('365', '239', 'customer', 'general', '127'),
('366', '240', 'cust_branch', 'general', '126'),
('367', '240', 'customer', 'general', '128'),
('368', '241', 'cust_branch', 'general', '127'),
('369', '241', 'customer', 'general', '130'),
('370', '242', 'cust_branch', 'general', '128'),
('371', '242', 'customer', 'general', '131'),
('372', '243', 'cust_branch', 'general', '129'),
('373', '243', 'customer', 'general', '132'),
('374', '244', 'cust_branch', 'general', '130'),
('375', '244', 'customer', 'general', '133'),
('376', '245', 'cust_branch', 'general', '131'),
('377', '245', 'customer', 'general', '134'),
('378', '246', 'cust_branch', 'general', '132'),
('379', '246', 'customer', 'general', '135'),
('380', '247', 'cust_branch', 'general', '133'),
('381', '247', 'customer', 'general', '136'),
('382', '248', 'supplier', 'general', '115'),
('383', '249', 'cust_branch', 'general', '134'),
('384', '249', 'customer', 'general', '137'),
('385', '250', 'cust_branch', 'general', '135'),
('386', '250', 'customer', 'general', '138'),
('387', '251', 'cust_branch', 'general', '136'),
('388', '251', 'customer', 'general', '139'),
('391', '253', 'supplier', 'general', '116'),
('392', '254', 'cust_branch', 'general', '138'),
('393', '254', 'customer', 'general', '141'),
('394', '255', 'supplier', 'general', '117'),
('395', '256', 'cust_branch', 'general', '139'),
('396', '256', 'customer', 'general', '142'),
('397', '257', 'supplier', 'general', '118'),
('398', '258', 'supplier', 'general', '119'),
('399', '259', 'cust_branch', 'general', '140'),
('400', '259', 'customer', 'general', '143'),
('401', '260', 'cust_branch', 'general', '141'),
('402', '260', 'customer', 'general', '144'),
('403', '261', 'cust_branch', 'general', '142'),
('404', '261', 'customer', 'general', '145'),
('405', '262', 'supplier', 'general', '120'),
('406', '263', 'supplier', 'general', '121'),
('407', '264', 'supplier', 'general', '122'),
('408', '265', 'supplier', 'general', '123'),
('409', '266', 'cust_branch', 'general', '143'),
('410', '266', 'customer', 'general', '146'),
('411', '267', 'supplier', 'general', '124'),
('412', '268', 'cust_branch', 'general', '144'),
('413', '268', 'customer', 'general', '147'),
('414', '269', 'supplier', 'general', '125'),
('415', '270', 'supplier', 'general', '126'),
('416', '271', 'supplier', 'general', '127'),
('417', '272', 'supplier', 'general', '128'),
('418', '273', 'supplier', 'general', '129'),
('419', '274', 'cust_branch', 'general', '145'),
('420', '274', 'customer', 'general', '148'),
('421', '275', 'cust_branch', 'general', '146'),
('422', '275', 'customer', 'general', '149'),
('423', '276', 'cust_branch', 'general', '147'),
('424', '276', 'customer', 'general', '150'),
('425', '277', 'cust_branch', 'general', '148'),
('426', '277', 'customer', 'general', '151'),
('427', '278', 'cust_branch', 'general', '149'),
('428', '278', 'customer', 'general', '152'),
('429', '279', 'cust_branch', 'general', '150'),
('430', '279', 'customer', 'general', '153'),
('431', '280', 'cust_branch', 'general', '151'),
('432', '280', 'customer', 'general', '154'),
('433', '281', 'cust_branch', 'general', '152'),
('434', '281', 'customer', 'general', '155'),
('435', '282', 'cust_branch', 'general', '153'),
('436', '282', 'customer', 'general', '156'),
('437', '283', 'cust_branch', 'general', '154'),
('438', '283', 'customer', 'general', '157'),
('439', '284', 'cust_branch', 'general', '155'),
('440', '284', 'customer', 'general', '158'),
('441', '285', 'supplier', 'general', '130'),
('442', '286', 'cust_branch', 'general', '156'),
('443', '286', 'customer', 'general', '159'),
('444', '287', 'cust_branch', 'general', '157'),
('445', '287', 'customer', 'general', '160'),
('446', '288', 'cust_branch', 'general', '158'),
('447', '288', 'customer', 'general', '161'),
('448', '289', 'cust_branch', 'general', '159'),
('449', '289', 'customer', 'general', '162'),
('450', '290', 'cust_branch', 'general', '160'),
('451', '290', 'customer', 'general', '163'),
('452', '291', 'cust_branch', 'general', '161'),
('453', '291', 'customer', 'general', '164'),
('454', '292', 'cust_branch', 'general', '162'),
('455', '292', 'customer', 'general', '165'),
('456', '293', 'cust_branch', 'general', '163'),
('457', '293', 'customer', 'general', '166'),
('458', '294', 'cust_branch', 'general', '164'),
('459', '294', 'customer', 'general', '167'),
('460', '295', 'cust_branch', 'general', '165'),
('461', '295', 'customer', 'general', '168'),
('462', '296', 'cust_branch', 'general', '166'),
('463', '296', 'customer', 'general', '169'),
('464', '297', 'cust_branch', 'general', '167'),
('465', '297', 'customer', 'general', '170'),
('466', '298', 'cust_branch', 'general', '168'),
('467', '298', 'customer', 'general', '171'),
('468', '299', 'cust_branch', 'general', '169'),
('469', '299', 'customer', 'general', '172'),
('470', '300', 'cust_branch', 'general', '170'),
('471', '300', 'customer', 'general', '173'),
('472', '301', 'cust_branch', 'general', '171'),
('473', '301', 'customer', 'general', '174'),
('474', '302', 'cust_branch', 'general', '172'),
('475', '302', 'customer', 'general', '175'),
('476', '303', 'cust_branch', 'general', '173'),
('477', '303', 'customer', 'general', '176'),
('478', '304', 'cust_branch', 'general', '174'),
('479', '304', 'customer', 'general', '177'),
('480', '305', 'cust_branch', 'general', '175'),
('481', '305', 'customer', 'general', '179'),
('482', '306', 'cust_branch', 'general', '176'),
('483', '306', 'customer', 'general', '180'),
('484', '307', 'cust_branch', 'general', '177'),
('485', '307', 'customer', 'general', '181'),
('486', '308', 'cust_branch', 'general', '178'),
('487', '308', 'customer', 'general', '182'),
('488', '309', 'cust_branch', 'general', '179'),
('489', '309', 'customer', 'general', '183'),
('490', '310', 'cust_branch', 'general', '180'),
('491', '310', 'customer', 'general', '184'),
('492', '311', 'cust_branch', 'general', '181'),
('493', '311', 'customer', 'general', '185'),
('494', '312', 'cust_branch', 'general', '182'),
('495', '312', 'customer', 'general', '186'),
('496', '313', 'cust_branch', 'general', '183'),
('497', '313', 'customer', 'general', '187'),
('498', '314', 'cust_branch', 'general', '184'),
('499', '314', 'customer', 'general', '188'),
('500', '315', 'cust_branch', 'general', '185'),
('501', '315', 'customer', 'general', '189'),
('502', '316', 'cust_branch', 'general', '186'),
('503', '316', 'customer', 'general', '190'),
('504', '317', 'cust_branch', 'general', '187'),
('505', '317', 'customer', 'general', '191'),
('506', '318', 'cust_branch', 'general', '188'),
('507', '318', 'customer', 'general', '192'),
('508', '319', 'cust_branch', 'general', '189'),
('509', '319', 'customer', 'general', '193'),
('510', '320', 'cust_branch', 'general', '190'),
('511', '320', 'customer', 'general', '194'),
('512', '321', 'cust_branch', 'general', '191'),
('513', '321', 'customer', 'general', '195'),
('514', '322', 'cust_branch', 'general', '192'),
('515', '322', 'customer', 'general', '196'),
('516', '323', 'cust_branch', 'general', '193'),
('517', '323', 'customer', 'general', '197'),
('518', '324', 'cust_branch', 'general', '194'),
('519', '324', 'customer', 'general', '198'),
('520', '325', 'cust_branch', 'general', '195'),
('521', '325', 'customer', 'general', '199'),
('522', '326', 'cust_branch', 'general', '196'),
('523', '326', 'customer', 'general', '200'),
('524', '327', 'cust_branch', 'general', '197'),
('525', '327', 'customer', 'general', '201'),
('526', '328', 'cust_branch', 'general', '198'),
('527', '328', 'customer', 'general', '202'),
('528', '329', 'cust_branch', 'general', '199'),
('529', '329', 'customer', 'general', '203'),
('530', '330', 'cust_branch', 'general', '200'),
('531', '330', 'customer', 'general', '204'),
('532', '331', 'cust_branch', 'general', '201'),
('533', '331', 'customer', 'general', '205'),
('534', '332', 'cust_branch', 'general', '202'),
('535', '332', 'customer', 'general', '206'),
('536', '333', 'cust_branch', 'general', '203'),
('537', '333', 'customer', 'general', '207'),
('538', '334', 'supplier', 'general', '131'),
('539', '335', 'cust_branch', 'general', '204'),
('540', '335', 'customer', 'general', '208'),
('541', '336', 'cust_branch', 'general', '205'),
('542', '336', 'customer', 'general', '209'),
('543', '337', 'cust_branch', 'general', '206'),
('546', '337', 'customer', 'general', '210'),
('547', '338', 'cust_branch', 'general', '207'),
('549', '338', 'customer', 'general', '211'),
('550', '339', 'cust_branch', 'general', '208'),
('551', '339', 'customer', 'general', '212'),
('552', '340', 'cust_branch', 'general', '209'),
('553', '340', 'customer', 'general', '213'),
('554', '341', 'cust_branch', 'general', '210'),
('555', '341', 'customer', 'general', '214'),
('556', '342', 'cust_branch', 'general', '211'),
('557', '342', 'customer', 'general', '215'),
('558', '343', 'cust_branch', 'general', '212'),
('559', '343', 'customer', 'general', '216'),
('560', '344', 'cust_branch', 'general', '213'),
('561', '344', 'customer', 'general', '217'),
('562', '345', 'cust_branch', 'general', '214'),
('563', '345', 'customer', 'general', '218'),
('564', '346', 'cust_branch', 'general', '215'),
('565', '346', 'customer', 'general', '219'),
('566', '347', 'cust_branch', 'general', '216'),
('567', '347', 'customer', 'general', '220'),
('568', '348', 'cust_branch', 'general', '217'),
('569', '348', 'customer', 'general', '221'),
('570', '349', 'cust_branch', 'general', '218'),
('571', '349', 'customer', 'general', '222'),
('572', '350', 'cust_branch', 'general', '219'),
('573', '350', 'customer', 'general', '223'),
('574', '351', 'cust_branch', 'general', '220'),
('575', '351', 'customer', 'general', '224'),
('576', '352', 'cust_branch', 'general', '221'),
('577', '352', 'customer', 'general', '225'),
('578', '353', 'cust_branch', 'general', '222'),
('579', '353', 'customer', 'general', '226'),
('580', '354', 'cust_branch', 'general', '223'),
('581', '354', 'customer', 'general', '227'),
('582', '355', 'supplier', 'general', '132'),
('583', '356', 'cust_branch', 'general', '224'),
('584', '356', 'customer', 'general', '228'),
('585', '357', 'cust_branch', 'general', '225'),
('586', '357', 'customer', 'general', '229'),
('587', '358', 'cust_branch', 'general', '226'),
('588', '358', 'customer', 'general', '230'),
('589', '359', 'cust_branch', 'general', '227'),
('590', '359', 'customer', 'general', '231'),
('591', '360', 'cust_branch', 'general', '228'),
('592', '361', 'cust_branch', 'general', '229'),
('593', '361', 'customer', 'general', '232'),
('594', '362', 'cust_branch', 'general', '230'),
('595', '362', 'customer', 'general', '233'),
('596', '363', 'cust_branch', 'general', '231'),
('597', '363', 'customer', 'general', '234'),
('598', '364', 'cust_branch', 'general', '232'),
('599', '364', 'customer', 'general', '235'),
('600', '365', 'cust_branch', 'general', '233'),
('601', '365', 'customer', 'general', '236'),
('602', '366', 'cust_branch', 'general', '234'),
('603', '366', 'customer', 'general', '237'),
('604', '367', 'cust_branch', 'general', '235'),
('605', '367', 'customer', 'general', '238'),
('606', '368', 'cust_branch', 'general', '236'),
('607', '368', 'customer', 'general', '239'),
('608', '369', 'cust_branch', 'general', '237'),
('609', '369', 'customer', 'general', '240'),
('610', '370', 'cust_branch', 'general', '238'),
('611', '370', 'customer', 'general', '241'),
('612', '371', 'cust_branch', 'general', '239'),
('613', '371', 'customer', 'general', '242'),
('614', '372', 'cust_branch', 'general', '240'),
('615', '372', 'customer', 'general', '243'),
('616', '373', 'supplier', 'general', '133'),
('617', '374', 'supplier', 'general', '134'),
('618', '375', 'cust_branch', 'general', '241'),
('619', '375', 'customer', 'general', '244'),
('620', '376', 'supplier', 'general', '135'),
('621', '377', 'cust_branch', 'general', '242'),
('622', '377', 'customer', 'general', '245'),
('623', '378', 'cust_branch', 'general', '243'),
('624', '378', 'customer', 'general', '246'),
('625', '379', 'cust_branch', 'general', '244'),
('626', '379', 'customer', 'general', '247'),
('627', '380', 'cust_branch', 'general', '245'),
('628', '380', 'customer', 'general', '249'),
('629', '381', 'cust_branch', 'general', '246'),
('630', '381', 'customer', 'general', '250'),
('631', '382', 'cust_branch', 'general', '247'),
('632', '382', 'customer', 'general', '251');

### Structure of table `0_crm_opportunity` ###

DROP TABLE IF EXISTS `0_crm_opportunity`;

CREATE TABLE `0_crm_opportunity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cont_per_id` int(11) NOT NULL COMMENT 'This id relate to the contact Person Table Contact Form',
  `oppr_list` varchar(200) NOT NULL,
  `remarks` varchar(200) NOT NULL,
  `status` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `trans_date` varchar(100) NOT NULL,
  `attach` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_crm_opportunity` ###


### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `name` varchar(60) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=383 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'A. A. A. Shuhail Alqahta', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'A. W. Building Material', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'A. M &amp; COMMUNICATION', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'Antique Style', 'Antique Style', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'A.Purgos', 'Arnesto Purgos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'B.P.EMIRATES LTD CO ', 'BERGER PAINTS EMIRATES LTD CO (LLC)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'B.C.LLC', 'BIC Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'Bindhahi Trading LLC', 'Bindhahi Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'C.B.DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'C. E. Interior Decorat LLC', 'Core Elements Interior Decoration LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'Decortser Portal', 'Decortser Portal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'D.G.Contracting Co LLC', 'Discovery  General Contracting Co LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'Dr. Laya', 'Dr. Laya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'Dr. Rehmina', 'Dr. Rehmina', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'I. Abdul Rahim Shaaban Mohamed', 'Ismail Abdul Rahim Shaaban Mohamed', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'Jalal Merchant', 'Jalal Merchant', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'KOA R.E.DEVELOPMENT LLC', 'KOA REAL ESTATE DEVELOPMENT LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'Mr. AD', 'Mr. AD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'Mr. Alaa', 'Mr. Alaa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'Mr . Amit', 'Mr . Amit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'Mr Ashok', 'Mr Ashok', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('31', 'Mr.Dinesh', 'Mr.Dinesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('33', 'Mr. Haresh', 'Mr. Haresh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'Mr Hasan', 'Mr Hasan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'Mr. Ibrahim', 'Mr. Ibrahim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'Mr. James', 'Mr. James', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('41', 'Mr.Neeraj', 'Mr.Neeraj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('42', 'Mr. Prabhat', 'Mr. Prabhat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'Mr.Rajesh', 'Mr.Rajesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'Mr. Saqlain', 'Mr. Saqlain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('49', 'Ms. Ahiliya', 'Ms. Ahiliya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'Ms. Loulwa', 'Ms. Loulwa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('53', 'Ms. Roda', 'Ms. Roda', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'Ms.Swarn', 'Ms.Swarn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'Ms. Thanuja', 'Ms. Thanuja', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('56', 'Ms. Yogitha', 'Ms. Yogitha', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', NULL, 'Dubai', '(971) 5-037-42446__', NULL, NULL, 'lh@koa.ae', NULL, '', '0'),
('58', 'NATURAL TRENDY TIL&amp;FLOOR M', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'QEXPRESS', 'QEXPRESS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'R. H. REAL ESTATE BROKERS', 'RIGHT HOMES REAL ESTATE BROKERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('68', 'Sajith Ansar', 'Sajith Ansar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('69', 'Sustainable Builders', 'Sustainable Builders', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'Techforce Technical Services', 'Techforce Technical Services', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'Al Anfaal Garage EST.', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('74', 'Fine Tools Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('75', 'F. C. I. Decoration LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('76', 'Hidayath Trading Company LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'H. G. T. EST (Branch)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'JIHAN BLDG. MAT. &amp; PAINTS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('79', 'K.A.N. Technical Services LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('80', 'N. A. S.BUILDING MATERIALS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'P. B. Materials Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'Q. A.H. Aljadeed Gen.Trdg .LLc', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'R. A.B. Technical Services LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('84', 'Risala Furniture LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'R.A.B. Materials  Tradinf LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'S. ALJAZEERA AUTO REPAIRING', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'Spectrum Tent Manufacturing', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'Y. E. R. &amp; REPAIRING LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('89', 'AAFOQ Islamic Finance', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('90', 'A. Business Center (Tasheel)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('91', 'BALGHANI STORES LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('92', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'Emirates Driving Institute', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'Glare Technologies', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('95', 'Lex Consortia FZ LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('96', 'N. A. M. Trading (L.L.C) Br', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('97', 'SHADMAN TENTS IND LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('98', 'Souq.Com FZ LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('99', 'SUPER GENERAL COMPANY LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('100', 'The Excelerate Enterprises DMC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('101', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('102', 'D. E. &amp; WATER AUTHORITY', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('103', 'D. I. I. &amp;RE INSURANCE CO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('104', 'E.T G. Company (Etisalat)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('105', 'Purchase Bills to Come', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('106', 'Cash Customer', 'Cash Customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('107', 'Bindhahi Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('108', 'HAMMER BUILDING MAINTENANCE LL', 'HAMMER BUILDING MAINTENANCE LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('109', 'Emirates Telecommunications Gr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('110', 'BERGER PAINTS EMIRATES LTD CO', 'BERGER PAINTS EMIRATES LTD CO (LLC)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('111', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('112', 'Naga Lakshmi', 'Naga Lakshmi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('113', 'Good Steam Auto Center', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('114', 'NOOR TAKAFUL GENERAL (PJSC)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('115', 'Al Sharq Media LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('116', 'Modern Seal Insulation Contrac', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('117', 'Alanas Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('118', 'Chittagong Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('119', 'Emirates Post Group', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('120', 'Abdelaziz Abdelrahman Abdelazi', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('121', 'Broadway Building Materials LL', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('122', 'RTA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('123', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('124', 'Big Foot Koncepts LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('125', 'ROYAL GRAND BUILDING MATERIALS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('126', 'ADSS MARKETING &amp; COMMUNICA', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('127', 'He BEI Gao Yang Qi Chang Texti', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('128', 'EPIC TRAVEL LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('129', 'Saif Al Burhan Traders LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('130', 'SAFINAT AL BAHAR BUILDING MATE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('131', 'Arabian Business Center (Tashe', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('132', 'Fine Tools Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('133', 'AFRICA INTERNET GENERAL TRADIN', 'AFRICA INTERNET GENERAL TRADING LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('134', 'Al Anfaal Garage EST.', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('135', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('136', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('137', 'Fine Tools Equipment Repairing', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('138', '&quot;Aevolve Beauty Saloon &amp;q', '&quot;Aevolve Beauty Saloon &quot;', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('139', 'Mega City Building Materilas T', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('140', 'YASMAC EQUIPMENT RENTAL &amp; ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('141', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('142', 'Ghulam Mustafa Construction Eq', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('143', 'Vijaya Chikermane', 'Vijaya Chikermane', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('144', 'Team One Glass &amp; Aluminum ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('145', 'Bawabt Al Hemreya Car Seat Uph', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('146', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('147', 'Al Barsha Tyres &amp; Battery ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('148', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('149', 'Angel Cakes', 'Angel Cakes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('150', 'AQS Management Consultancy', 'AQS Management Consultancy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('151', 'Naresh Mohnani', 'Naresh Mohnani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('152', 'ARABIAN SAND WASHING LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('153', 'Smooth Solution Building Mater', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('154', 'Luigi Dsouza', 'Luigi Dsouza', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('155', 'Jumeirah Carpenter BR', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('156', 'Mega Fix Tyres &amp; Auto Care', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('157', 'IN Focus Glass and Aluminium W', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('158', 'Shades General Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('159', 'Progress Profiles Middle East ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('160', 'Nasser Al Matrooshi Trading (L', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('161', 'O.U.N Building Materials LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('162', 'MOHD AL QAMA CERAMICS TRADING ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('163', 'Al Burhan Prints LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('164', 'Wayz Consulting', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('165', 'MAS PAINTS &amp; CHEMICALS IND', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('166', 'GULF PAINTS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('167', 'NAJRAN GENERAL TRADING', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('168', 'Jai Electricals LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('169', 'DUKE STEEL TRADING CO (L.L.C)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('170', 'BAB AL SAFA CAR ACCESSORIES AN', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('171', 'SALAHALDIN CAR ACCESSORIES FIX', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('172', 'Al Aksa Technical &amp;Cleanin', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('173', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('174', 'Ms. Alita', 'Ms. Alita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('175', 'Ish Stars Technical Services', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('176', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('177', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('178', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('179', 'Mr Tahir', 'Mr Tahir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('180', 'Led Corner Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('181', 'RUI KANG TRADING FZCO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('182', 'Tools R Us LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('183', 'salim lokhand.', 'Salim Lokhandwala', NULL, 'Dubai Hills\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('184', 'Bridge Forth &amp; Signature', 'Bridge Forth &amp; Signature Contracting Co. LLC', NULL, 'PO BOX 99856\nDUBAI', '044-413-886__', NULL, NULL, NULL, NULL, '', '0'),
('185', 'nour', 'Ms. Nour', NULL, 'Springs 11, street 2, villa 36\nDubai', '971-503-40686', NULL, NULL, NULL, NULL, '', '0'),
('186', 'Al Anas Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('187', 'Milad Interior Design', 'Milad Interior Design', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('188', 'Majid Al Falasi', 'Majid Al Falasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('189', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', NULL, NULL, '971-543-03879', NULL, NULL, NULL, NULL, '', '0'),
('190', 'Miscellaneous Supplier', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('191', 'Advance to Abdullah Nepali', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('192', 'Clear View Interiors', 'Clear View Interiors', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, 'Mr. Taha Ahmed', '0'),
('193', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', NULL, 'Dubai', '971-553-75555', NULL, NULL, NULL, NULL, '', '0'),
('194', 'Suzena', 'Suzena', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('195', 'Akhil Vinayak', 'Akhil Vinayak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('196', 'Hussain General Trading EST. ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('197', 'Fatma Al Rais', 'Ms. Fatma Al Rais', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('198', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('199', 'PAVIMENTO GENERAL TRDG LLC', 'PAVIMENTO GENERAL TRADING L.L.C', NULL, 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '971-568-19654', NULL, NULL, NULL, NULL, '', '0'),
('200', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', NULL, 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '971-555-80234', NULL, NULL, NULL, NULL, '', '0'),
('201', 'Al fly Trading FZCO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('202', 'Otaly Trading FZCO ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('203', 'Grand al khail auto garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('204', 'Yogesh', 'Yogesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('205', 'I 2 D Interiors', 'I 2 D Interiors', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('206', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('207', 'Imran Qasim (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('208', 'The international school of ch', 'The international school of choueifat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('209', 'RALTS CONTRACTING', 'RALTS CONTRACTING', NULL, NULL, '042-383-353__', NULL, NULL, NULL, NULL, '', '0'),
('210', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('211', 'Star brothers auto repairing', '', NULL, NULL, '050-829-2384_', NULL, NULL, NULL, NULL, '', '0'),
('212', 'Johns Paints Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('213', 'Muhammed Adeel ( Employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('214', 'Abid Hussain ( Employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('215', 'Colart Publishing &amp; Adv. L', 'Colart Publishing &amp; Advertising LLC', NULL, 'PO Box 49652\nDUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('216', 'Ms. Arpita', 'Ms. Arpita', NULL, NULL, '971-557-92060', NULL, NULL, NULL, NULL, '', '0'),
('217', 'AKBAR ALI KHAN  ALI KHAN (empl', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('218', 'ARSLAN NADEEM NADEEM MAZHAR (e', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('219', 'BIR SINGH (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('220', 'DURGALAL NEPALI (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('221', 'MUHAMMAD AKHTAR (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('222', 'MUHAMMAD IBRAR (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('223', 'MUHAMMAD USAMA (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('224', 'SHAHID FAROOQ  (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('225', 'SHAKEEL AHMED ( employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('226', 'TAUHEED AHMED (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('227', 'ZEESHAN ALI  ( employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('228', 'Mr. Jamal Al Ali', '', NULL, 'ajman', NULL, NULL, NULL, NULL, NULL, '', '0'),
('229', 'Turnkey fitout solutions', 'Turnkey fitout solutions', NULL, 'po box # 47862\nDubai', '(045) 8-065-53_____', NULL, NULL, NULL, NULL, '', '0'),
('230', 'horeb parmar', 'horeb parmar', NULL, NULL, '(054) 7-929-474____', NULL, NULL, NULL, NULL, '', '0'),
('231', 'Latif Musa Air Condition Rpr &amp;', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('232', 'TIAN FA STONE MATERIAL TRADING', '', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('233', 'kalyan chakravarthy', 'kalyan chakravarthy', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('234', 'Harun Sultan', 'Harun Sultan', NULL, 'Ajman', NULL, NULL, NULL, NULL, NULL, '', '0'),
('235', 'Al Zujaj Al Azraq Aluminium &amp;a', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('236', 'VERVE INTERIOR  DECORATION L.L', 'VERVE INTERIOR  DECORATION L.L.C', NULL, 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '042-400-119__', NULL, NULL, NULL, NULL, '', '0'),
('237', 'Royal Hammer Trading LLC', '', NULL, NULL, '04_-399-1753_', NULL, NULL, NULL, NULL, '', '0'),
('238', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('239', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('240', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', NULL, 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '(971) 5-662-54662__', NULL, NULL, NULL, NULL, '', '0'),
('241', 'Kitchenscape Domestic Kitchens', 'Kitchenscape Domestic Kitchens LLC', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('242', 'GREEN TERRA TECHNICAL SERVICES', 'GREEN TERRA TECHNICAL SERVICES LLC', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('243', 'Ms. Serena', 'Ms. Serena', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('244', 'Highrise Owners Association Ma', 'Highrise Owners Association Management (HOAM)', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('245', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', NULL, 'Po Box # 60288\nDIP\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('246', 'Beenish Haider', 'Beenish Haider', NULL, NULL, '055-117-5311_', NULL, NULL, NULL, NULL, '', '0'),
('247', 'Meherz Kreation LLC', 'Meherz Kreation LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('248', 'Pioneer Insurance Broker LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('249', 'WASL PROPERTIES', 'WASL PROPERTIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('250', 'Modern Seal Insulation Soln', 'Modern Seal Insulation Solutions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('251', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('252', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('253', 'Shandong Hele( Middle East) In', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('254', 'Mr. Rajiv', 'Mr. Rajiv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('255', 'shaikh saeed mohammed Hasher A', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('256', 'Fincirc International Manageme', 'Fincirc International Management', NULL, 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '045-126-800__', NULL, NULL, NULL, NULL, '', '0'),
('257', 'faqihi Enterprises LLC (BR)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('258', 'Laspinas Building Materials Tr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('259', 'Ms. Shweta', 'Ms. Shweta', NULL, 'Dubai', '971-505-54754', NULL, NULL, NULL, NULL, '', '0'),
('260', 'Pooja Shah Mulani', 'Pooja Shah Mulani', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('261', 'MXTS office Jebel Ali								', 'Mr Xpert technical Services New Office Jebel Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('262', 'Panache Building Materials Tra', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('263', 'Mohd. Al Qama General Trading ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('264', 'Technos Multiline LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('265', 'Ibrahim Abbas Ali Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('266', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', NULL, 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '(065) 7-743-111____', NULL, NULL, NULL, NULL, '', '0'),
('267', 'DUBAI ELECTRICITY &amp; WATER ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('268', 'Sanqour advertising service', 'Sanqour advertising service', NULL, 'Al Zahiya, Abu Dhabi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('269', 'Al Dhaw Al Wahaj Electrical &amp;a', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('270', 'Romana Water Industries LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('271', 'Faizal system fixing contracti', '', NULL, NULL, '(050) 9-275-773____', NULL, NULL, NULL, NULL, '', '0'),
('272', 'Noor Al Fajr Elect. Devices Tr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('273', 'Mohd.AL Qama Building Materila', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('274', 'EL TEAM', 'EL TEAM LTD FZE - Sharjah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('275', 'Wool Craft  Trading', 'Wool Craft  Trading', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('276', 'Afaq Al Waseqh Electromech', 'Afaq Al Waseqh Electromechanical Services LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('277', 'MR. YU', 'MR. YU', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('278', 'Astro properties', 'Astro properties', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('279', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', NULL, 'P.O. Box – 48746,\nDubai, UAE\n', '971-433-26233', NULL, NULL, 'info@bfmatech.com ', NULL, '', '0'),
('280', 'Mr. Hadisfer', 'Mr. Hadisfer', NULL, 'Villa 47 Hattan One Arabian Ranches', '052-815-4488_', NULL, NULL, NULL, NULL, '', '0'),
('281', 'JAMTS Tech LLC', 'JAMTS Tech LLC', NULL, 'PO Box 71893', '(055) 2-975-999____', NULL, NULL, NULL, NULL, '', '0'),
('282', 'Sofitel Dubai The Palm', 'Sofitel Dubai The Palm', NULL, 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '971-445-55471', NULL, NULL, NULL, NULL, '', '0'),
('283', 'Rahul Ranbhare', 'Rahul Ranbhare', NULL, 'G05, Fortunato 1, JVC', '971-558-12606', NULL, NULL, NULL, NULL, '', '0'),
('284', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', NULL, 'Villa 349 Hayat townhouses', '971-565-65944', NULL, NULL, NULL, NULL, '', '0'),
('285', 'Dubai Coast Trading  [LLC]', '', NULL, NULL, '042-212-766__', NULL, '042270025', NULL, NULL, '', '0'),
('286', 'HOAM Highrise Owners ', 'HOAM Highrise Owners Association Management', NULL, '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '971-433-95558', NULL, NULL, NULL, NULL, '', '0'),
('287', 'Al Hai Motors', 'Al Hai Motors', NULL, 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '055-555-6656_', NULL, NULL, NULL, NULL, '', '0'),
('288', 'Noma Design House', 'Noma Design House', NULL, 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '971-523-29615', NULL, NULL, NULL, NULL, '', '0'),
('289', 'Ms. Nissreen', 'Ms. Nissreen', NULL, 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('290', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', NULL, 'Villa 127 Picadilly Green Damac Hills', '054-582-2614_', NULL, NULL, NULL, NULL, '', '0'),
('291', 'La Stella productions', 'La Stella productions', NULL, 'Al Qouz Dubai\n', '055-984-3848_', NULL, NULL, NULL, NULL, '', '0'),
('292', 'Mr. Habib Nahra', 'Mr. Habib Nahra', NULL, NULL, '058-591-2469_', NULL, NULL, NULL, NULL, '', '0'),
('293', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', NULL, 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '(050) 8-771-798____', NULL, NULL, NULL, NULL, '', '0'),
('294', 'One Laundry', 'One Laundry', NULL, '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '043-247-680__', NULL, NULL, NULL, NULL, '', '0'),
('295', 'ALI FARHAN TECHNICAL SERVICES ', 'ALI FARHAN TECHNICAL SERVICES LLC', NULL, 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '055-427-0717_', '(050) 78-558-05___', NULL, NULL, NULL, '', '0'),
('296', 'Mr. Hisham', 'Mr. Hisham', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('297', 'Mrs.Sumeira', 'Mrs.Sumeira', NULL, 'Villa F 41 Golf Course Villas', '052-176-4340_', NULL, NULL, NULL, NULL, '', '0'),
('298', 'Dinesh Sanghvi', 'Dinesh Sanghvi', NULL, NULL, '971-504-54946', NULL, NULL, NULL, NULL, '', '0'),
('299', 'Unitra International LLC', 'Unitra International LLC', NULL, 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '971-470-24700', NULL, NULL, 'Murad.Alashhab@mezzan.com ', NULL, '', '0'),
('300', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('301', 'GDM Interiors LLC', 'GDM Interiors LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('302', 'Vishesh Singhania ', 'Vishesh Singhania ', NULL, NULL, '052-749-3357_', NULL, NULL, NULL, NULL, '', '0'),
('303', 'Imperial Avenue', 'Imperial Avenue', NULL, 'Dubai -UAE', '971-559-39446', NULL, NULL, NULL, NULL, '', '0'),
('304', 'Shaul Nagawkar ', 'Shaul Nagawkar ', NULL, 'Apt 705 Tower F Executive Tower - Business Bay', '971-554-03407', NULL, NULL, NULL, NULL, '', '0'),
('305', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', NULL, ' Al Ain Road', '050-753-5444_', NULL, NULL, NULL, NULL, '', '0'),
('306', 'ABDULLA DARWISH GHULOOM AHMED ', 'ABDULLA DARWISH GHULOOM AHMED BAQER', NULL, 'Villa 32 Al Warqa', '971-505-54500', NULL, NULL, NULL, NULL, '', '0'),
('307', 'Rabia Ahmed ', 'Rabia Ahmed ', NULL, NULL, '971-585-06107', NULL, NULL, NULL, NULL, '', '0'),
('308', 'Kakul Technical Services', 'Kakul Technical Services', NULL, 'DUBAI', '056-822-5649_', NULL, NULL, NULL, NULL, '', '0'),
('309', 'Riham AlAli', 'Riham AlAli', NULL, 'Villa 102,Al Barsha,dubai', '971-521-38404', NULL, NULL, NULL, NULL, '', '0'),
('310', 'Blacksmith Coffee', 'Blacksmith Coffee', NULL, 'dubai', '050-899-1223_', NULL, NULL, NULL, NULL, '', '0'),
('311', 'Sangeet Jain', 'Sangeet Jain', NULL, 'Villa 33 Al Naseem Mudon', '971-567-33689', NULL, NULL, NULL, NULL, '', '0'),
('312', 'Stone House Real Estate Broker', 'Stone House Real Estate Brokerage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('313', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', NULL, '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '971-553-47587', NULL, NULL, NULL, NULL, '', '0'),
('314', 'Warriors Aluminum and Glass', 'Warriors Aluminum and Glass Cont. LLC ', NULL, 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '971-554-15254', NULL, NULL, 'info@warriorslandscape.ae ', NULL, '', '0'),
('315', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', NULL, 'PO Box 2748 Sharjah', '065-344-379__', NULL, NULL, NULL, NULL, '', '0'),
('316', 'High Power Services', 'High Power Services', NULL, 'PO Box 57467 Dubai.\n', '056-505-8126_', NULL, NULL, NULL, NULL, '', '0'),
('317', 'Ms. Charu', 'Ms. Charu', NULL, 'Karama,DUBAI', '971-506-34851', NULL, NULL, NULL, NULL, '', '0'),
('318', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', NULL, 'Villa 1, Ary Building Dubai Marina', '050-928-8744_', NULL, NULL, NULL, NULL, '', '0'),
('319', 'Star Revive Medical Center', 'Star Revive Medical Center', NULL, 'jumeirah', '(043) 3-344-61_____', NULL, NULL, NULL, NULL, '', '0'),
('320', 'Phoenix Middle East', 'Phoenix Middle East', NULL, 'DIP 2 ,Dubai', '050-106-4845_', NULL, NULL, NULL, NULL, '', '0'),
('321', 'MENAWATT TECHNICAL SERVICES ', 'MENAWATT TECHNICAL SERVICES EST.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('322', 'Mond Trading Services', 'Mond Trading Services', NULL, 'warehouse 141', '056-787-8070_', NULL, NULL, NULL, NULL, '', '0'),
('323', 'Jean Paul Schmidt', 'Jean Paul Schmidt', NULL, 'Emaar South Villa 213', '971-566-89875', NULL, NULL, NULL, NULL, '', '0'),
('324', 'Frederic de Melker', 'Frederic de Melker', NULL, 'City Walk Building 10, app 309', '971-551-09783', NULL, NULL, NULL, NULL, '', '0'),
('325', 'GULFLINE CONST. METALIC PARTS ', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', NULL, 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '971-652-82233', NULL, NULL, NULL, NULL, '', '0'),
('326', 'Abu Dhabi Entertainment ', 'Abu Dhabi Entertainment Company ', NULL, 'P.O. Box 862, Abu Dhabi, UAE', '971-240-34200', '(971) 56-651-8131_', NULL, 'mohammed.ashif@adecmanagement.ae', NULL, '', '0'),
('327', 'Mrs. Marie', 'Mrs. Marie', NULL, 'Villa 205, Maeen 4, The Lakes', '056-992-3062_', NULL, NULL, NULL, NULL, '', '0'),
('328', 'Best Choice Trading LLC', 'Best Choice Trading LLC', NULL, NULL, '043-396-669__', NULL, NULL, NULL, NULL, '', '0'),
('329', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', NULL, 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '971-568-51047', NULL, NULL, NULL, NULL, '', '0'),
('330', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', NULL, 'Jumeirh Park Dubai', '055-815-7066_', NULL, NULL, NULL, NULL, '', '0'),
('331', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', NULL, '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '971-545-81932', NULL, NULL, NULL, NULL, '', '0'),
('332', 'Yashin Lalloo', 'Yashin Lalloo', NULL, 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('333', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', NULL, 'Al Qouz Villa 7', '050-657-6567_', NULL, NULL, NULL, NULL, '', '0'),
('334', 'Suitecase Holidays FZE LLC', '', NULL, NULL, '052-729-2815_', NULL, NULL, NULL, NULL, '', '0'),
('335', 'Waht Alhams Technical services', 'Waht Alhams Technical services EST', NULL, NULL, '(050) 4-213-305____', NULL, NULL, NULL, NULL, '', '0'),
('336', 'Mrs. Anna', 'Mrs. Anna', NULL, 'Villa 17 Trixis, Damac Hills 2 Akoya', '052-765-5584_', NULL, NULL, NULL, NULL, '', '0'),
('337', 'Aztec Shipping LLC', 'Aztec Shipping LLC', NULL, 'NAVEEN BNI GLADITOR', '(052) 6-866-960____', NULL, NULL, 'naveen@groupe-global.net', NULL, '', '0'),
('338', 'priyanka chugh', 'priyanka chugh', NULL, 'palm jumeirah', '(054) 4-766-556____', NULL, NULL, 'priyaankachugh@gmail.com', NULL, '', '0'),
('339', 'InsideOut Casa Technical ', 'InsideOut Casa Technical Services', NULL, NULL, '050-367-7125_', NULL, NULL, NULL, NULL, '', '0'),
('340', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', NULL, NULL, '971-526-86696', NULL, NULL, 'naveen@groupe-global.net', NULL, '', '0'),
('341', 'Ms.Priya Motiani', 'Ms.Priya Motiani', NULL, NULL, '971-554-25544', NULL, NULL, NULL, NULL, '', '0'),
('342', 'Mr. Dipak Main', 'Mr. Dipak Main', NULL, 'Villa 118 Trixis Damac 2', '971-504-95174', NULL, NULL, NULL, NULL, '', '0'),
('343', 'Design Evolution Technical Ser', 'Design Evolution Technical Service Co.', NULL, 'AL Awir', '(___) _-___-_______', '(052) 69-372-90___', NULL, NULL, NULL, '', '0'),
('344', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', NULL, 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '043-342-121__', NULL, NULL, NULL, NULL, '', '0'),
('345', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', NULL, 'PO Box 81456 Dubai UAE', '042-978-870__', NULL, NULL, NULL, NULL, '', '0'),
('346', 'English Language Private Schoo', 'English Language Private School', NULL, ' Oud Metha', '971-567-83590', NULL, NULL, NULL, NULL, '', '0'),
('347', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', NULL, 'P.O BOX 31671,DUBAI - UAE', '048-326-4400_', '(037) 05-452-4____', NULL, NULL, NULL, '', '0'),
('348', 'Mr. Chari', 'Mr. Chari', NULL, 'Villa 240 Pacifica Damac 2', '(971) 5-087-73932__', NULL, NULL, NULL, NULL, '', '0'),
('349', 'Mr. Prabhu', 'Mr. Prabhu', NULL, NULL, '(971) 5-453-46262__', NULL, NULL, NULL, NULL, '', '0'),
('350', 'Kings Speciality Restaurant LL', 'Kings Speciality Restaurant LLC', NULL, 'downtown', '(050) 9-605-266____', NULL, NULL, NULL, NULL, '', '0'),
('351', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', NULL, 'La Quinta Dubai.', '(056) 1-743-039____', NULL, NULL, NULL, NULL, '', '0'),
('352', 'Al Ghussun Advertising', 'Al Ghussun Advertising', NULL, 'PO Box 2748 Sharjah UAE', '(065) 3-443-76_____', NULL, NULL, NULL, NULL, '', '0'),
('353', 'Al Ameemi Intl Trdg LLC', 'Al Ameemi International Trading L.L.C', NULL, '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '043-351-222__', NULL, NULL, NULL, NULL, '', '0'),
('354', 'Mr. Sanjiv Soori', 'Mr. Sanjiv Soori', NULL, 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '055-726-5338_', NULL, NULL, NULL, NULL, '', '0'),
('355', 'AFAQ MAHMOOD MAHMOOD AHMAD (Em', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('356', 'IBECE ENEGY', 'IBECE ENEGY', NULL, NULL, '043-540-789__', '(056) 24-809-11___', NULL, 'mohannad.ashhab@ibecegroup.com ', NULL, '', '0'),
('357', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', NULL, 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '971-551-03723', NULL, NULL, NULL, NULL, '', '0'),
('358', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', NULL, 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('359', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', NULL, 'Villa 3704 Greens Community West', '050-561-9411_', NULL, NULL, NULL, NULL, '', '0'),
('360', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('361', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', NULL, 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '050-326-3650_', '(043) 70-988-1____', NULL, NULL, NULL, '', '0'),
('362', 'Mr. Antonio', 'Mr. Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('363', 'Mobeen Javed', 'Mobeen Javed', NULL, NULL, '971-522-36939', NULL, NULL, NULL, NULL, '', '0'),
('364', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('365', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', NULL, '14B Street Umm Ramool Rashidiya, Dubai ', '054-781-5935_', NULL, NULL, NULL, NULL, '', '0'),
('366', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', NULL, NULL, '971-567-84790', NULL, NULL, NULL, NULL, '', '0'),
('367', 'Suntac General Trading LLC', 'Suntac General Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('368', 'Wasl LLC', 'Wasl LLC', NULL, 'DUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('369', 'Mr. Brian Howarth', 'Mr. Brian Howarth', NULL, 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '(050) 1-005-462____', NULL, NULL, NULL, NULL, '', '0'),
('370', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', NULL, NULL, '971-528-61907', NULL, NULL, NULL, NULL, '', '0'),
('371', 'Hermen Thomas ', 'Hermen Thomas ', NULL, 'G 003 \nNew bridge hills 3 \nUptown motor city', '(971) 5-019-71488__', NULL, NULL, NULL, NULL, '', '0'),
('372', 'Deepak Panchariya', 'Deepak Panchariya', NULL, 'Gardenia, Wasl gate, TH 80', '971-566-83851', NULL, NULL, NULL, NULL, '', '0'),
('373', 'SERVICE FIRST GENERAL TRADING ', '', NULL, NULL, '052-496-17360', '(048) 89-569-1____', NULL, NULL, NULL, '', '0'),
('374', 'Hi Tech Pack and Trans LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('375', 'Nirav Patel', 'Nirav Patel', NULL, NULL, '971-554-09938', NULL, NULL, '‎nirav.patel@fincirc.com', NULL, '', '0'),
('376', 'Grand City Auto Services', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('377', 'Atlas Advertising', 'Atlas Advertising', NULL, NULL, '065-423-775__', NULL, NULL, NULL, NULL, '', '0'),
('378', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', NULL, 'Meadows 6 Dubai', '050-474-0506_', NULL, NULL, NULL, NULL, '', '0'),
('379', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', NULL, 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', NULL, NULL, NULL, NULL, NULL, '', '0'),
('380', 'HAMMER BUILDING MAINTENANCE LL', 'HAMMER BUILDING MAINTENANCE LLC', NULL, 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('381', 'Discovery  General Contracting', 'Discovery  General Contracting Co LLC', NULL, 'ABU DHAHBI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('382', 'BIC Contracting LLC', 'BIC Contracting LLC', NULL, 'PO Box # 10869 Dubai', '(971) 4-285-7551___', '(050) 54-609-49___', NULL, NULL, NULL, '', '0');

### Structure of table `0_cron_record` ###

DROP TABLE IF EXISTS `0_cron_record`;

CREATE TABLE `0_cron_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pdf_name` varchar(50) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `time` varchar(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cron_record` ###


### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `CurrencyName_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('UAE Dirhams', 'AED', 'AED', 'United Arab Emirates', 'Fils', '1', '', '0'),
('UK Pounds', 'GBP', '£', 'United Kingdom', 'Pence', '1', '', '0'),
('Indian Rupees', 'INR', '₹', 'India', 'Paisas', '1', '', '0'),
('Jordanian Dinar', 'JOD', 'JOD', 'Jordan', 'Cents', '1', 'دينار أردني', '0'),
('Omani Riyal', 'OMR', 'OMR', 'Oman', 'bz', '1', '', '0'),
('Pak Rupee(s)', 'PKR', 'Rs.', 'Pakistan', 'Paisa', '1', '', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` bigint(100) NOT NULL DEFAULT 0,
  `br_name` varchar(60) NOT NULL DEFAULT '',
  `branch_ref` varchar(30) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `CustName_arabic` varchar(100) NOT NULL,
  `cust_ref_arabic` varchar(100) NOT NULL,
  `br_name_arabic` varchar(100) NOT NULL,
  `br_ref_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `cust_gcc` tinyint(1) NOT NULL,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=248 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'A. A. A. Shuhail Alqahta', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('2', '3', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'A. M &amp; COMMUNICATION', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('3', '4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('4', '5', 'Antique Style', 'Antique Style', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('5', '6', 'Arnesto Purgos', 'A.Purgos', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('6', '7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('7', '8', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'B.P.EMIRATES LTD CO ', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('8', '9', 'BIC Contracting LLC', 'B.C.LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('10', '11', 'CAESARS BLUEWATERS DUBAI L.L.C', 'C.B.DUBAI L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('11', '12', 'Core Elements Interior Decoration LLC', 'C. E. Interior Decorat LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('12', '13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('13', '14', 'Decortser Portal', 'Decortser Portal', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('14', '15', 'Discovery  General Contracting Co LLC', 'D.G.Contracting Co LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('15', '16', 'Dr. Laya', 'Dr. Laya', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('16', '17', 'Dr. Rehmina', 'Dr. Rehmina', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('17', '18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('18', '19', 'Ismail Abdul Rahim Shaaban Mohamed', 'I. Abdul Rahim Shaaban Mohamed', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('19', '20', 'Jalal Merchant', 'Jalal Merchant', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('20', '21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('21', '22', 'KOA REAL ESTATE DEVELOPMENT LLC', 'KOA R.E.DEVELOPMENT LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('22', '23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('23', '24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('24', '25', 'Mr. AD', 'Mr. AD', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('25', '26', 'Mr. Alaa', 'Mr. Alaa', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('26', '27', 'Mr . Amit', 'Mr . Amit', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('27', '28', 'Mr Ashok', 'Mr Ashok', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('28', '29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('29', '30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('30', '31', 'Mr.Dinesh', 'Mr.Dinesh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('31', '32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('32', '33', 'Mr. Haresh', 'Mr. Haresh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('33', '34', 'Mr Hasan', 'Mr Hasan', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('34', '35', 'Mr. Ibrahim', 'Mr. Ibrahim', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('35', '36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('36', '37', 'Mr. James', 'Mr. James', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('37', '38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('38', '39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('39', '40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('40', '41', 'Mr.Neeraj', 'Mr.Neeraj', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('41', '42', 'Mr. Prabhat', 'Mr. Prabhat', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('42', '43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('43', '44', 'Mr.Rajesh', 'Mr.Rajesh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('44', '45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('45', '46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('46', '47', 'Mr. Saqlain', 'Mr. Saqlain', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('47', '48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('48', '49', 'Ms. Ahiliya', 'Ms. Ahiliya', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('49', '50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('50', '51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('51', '52', 'Ms. Loulwa', 'Ms. Loulwa', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('52', '53', 'Ms. Roda', 'Ms. Roda', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('53', '54', 'Ms.Swarn', 'Ms.Swarn', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('54', '55', 'Ms. Thanuja', 'Ms. Thanuja', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('55', '56', 'Ms. Yogitha', 'Ms. Yogitha', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('56', '57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('57', '58', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', 'NATURAL TRENDY TIL&amp;FLOOR M', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('58', '59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('59', '60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('60', '61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('61', '62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('62', '63', 'QEXPRESS', 'QEXPRESS', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('63', '64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('64', '65', 'RIGHT HOMES REAL ESTATE BROKERS', 'R. H. REAL ESTATE BROKERS', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('65', '66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('66', '67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('67', '68', 'Sajith Ansar', 'Sajith Ansar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('68', '69', 'Sustainable Builders', 'Sustainable Builders', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('69', '70', 'Techforce Technical Services', 'Techforce Technical Services', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('70', '71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('71', '72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('72', '73', 'Cash Customer', 'Cash Customer', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('73', '74', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('74', '75', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'BERGER PAINTS EMIRATES LTD CO', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('75', '78', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('76', '79', 'Naga Lakshmi', 'Naga Lakshmi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('77', '80', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'Abdelaziz Abdelrahman Abdelazi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('78', '81', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('79', '82', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'ADSS MARKETING &amp; COMMUNICA', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('80', '83', 'AFRICA INTERNET GENERAL TRADING LLC', 'AFRICA INTERNET GENERAL TRADIN', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('81', '84', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('82', '85', 'Aevolve Beauty Saloon ', 'Aevolve Beauty Saloon &amp;a', '', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('83', '86', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('84', '87', 'Vijaya Chikermane', 'Vijaya Chikermane', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('85', '88', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('86', '89', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', 'AL QUOZ IND 4 , DUBAI', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('87', '90', 'Angel Cakes', 'Angel Cakes', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('88', '91', 'AQS Management Consultancy', 'AQS Management Consultancy', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('89', '92', 'Naresh Mohnani', 'Naresh Mohnani', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('90', '93', 'Luigi Dsouza', 'Luigi Dsouza', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('91', '94', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('92', '95', 'Ms. Alita', 'Ms. Alita', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('93', '96', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('94', '97', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('95', '98', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('96', '99', 'Mr Tahir', 'Mr Tahir', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('97', '100', 'Salim Lokhandwala', 'salim lokhand.', 'Dubai Hills\nDubai', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai Hills\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('98', '101', 'Bridge Forth &amp; Signature Contracting Co. LLC', 'Bridge Forth &amp; Signature', 'PO BOX 99856\nDUBAI', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'PO BOX 99856\nDUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('99', '102', 'Ms. Nour', 'nour', 'Springs 11, street 2, villa 36\nDubai', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'Springs 11, street 2, villa 36\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('100', '103', 'Milad Interior Design', 'Milad Interior Design', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('101', '104', 'Majid Al Falasi', 'Majid Al Falasi', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('102', '105', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('103', '106', 'NEW CLEARVIEW DECORATION DESIGN &amp; IMPLEMENTATION', 'NEW CLEARVIEW DECORATION DESIG', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('104', '107', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', 'Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('105', '108', 'Suzena', 'Suzena', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('106', '109', 'Akhil Vinayak', 'Akhil Vinayak', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('107', '110', 'Ms. Fatma Al Rais', 'Fatma Al Rais', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('108', '111', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', 'dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('109', '112', 'PAVIMENTO GENERAL TRADING L.L.C', 'PAVIMENTO GENERAL TRDG LLC', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('110', '113', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('111', '114', 'Yogesh', 'Yogesh', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('112', '115', 'I 2 D Interiors', 'I 2 D Interiors', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('113', '116', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', 'po box 83010\nBur Dubai', '5', '2', '001', '1', '', '4510', '1200', '4510', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('114', '117', 'The international school of choueifat', 'The international school of ch', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('115', '118', 'RATLS CONTRACTING', 'RATLS CONTRACTING', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('116', '119', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('117', '120', 'Colart Publishing &amp; Advertising LLC', 'Colart Publishing &amp; Adv. L', 'PO Box 49652\nDUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 49652\nDUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('118', '121', 'Ms. Arpita', 'Ms. Arpita', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('119', '123', 'Turnkey fitout solutions', 'Turnkey fitout solutions', 'po box # 47862\nDubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'po box # 47862\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('121', '124', 'kalyan chakravarthy', 'kalyan chakravarthy', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('122', '125', 'Harun Sultan', 'Harun Sultan', 'Ajman', '12', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Ajman', '0', '', NULL, '', '', '', '', '0', '0'),
('123', '126', 'VERVE INTERIOR  DECORATION L.L.C', 'VERVE INTERIOR  DECORATION L.L', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '0', '', NULL, '', '', '', '', '0', '0'),
('125', '127', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', 'Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('126', '128', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('127', '130', 'Kitchenscape Domestic Kitchens LLC', 'Kitchenscape Domestic Kitchens', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('128', '131', 'GREEN TERRA TECHNICAL SERVICES LLC', 'GREEN TERRA TECHNICAL SERVICES', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('129', '132', 'Ms. Serena', 'Ms. Serena', 'dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('130', '133', 'Highrise Owners Association Management (HOAM)', 'Highrise Owners Association Ma', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('131', '134', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', 'Po Box # 60288\nDIP\nDubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Po Box # 60288\nDIP\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('132', '135', 'Beenish Haider', 'Beenish Haider', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('133', '136', 'Meherz Kreation LLC', 'Meherz Kreation LLC', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('134', '137', 'WASL PROPERTIES', 'WASL PROPERTIES', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('135', '138', 'Modern Seal Insulation Solutions', 'Modern Seal Insulation Soln', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('136', '139', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('138', '141', 'Mr. Rajiv', 'Mr. Rajiv', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('139', '142', 'Fincirc International Management', 'Fincirc International Manageme', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('140', '143', 'Ms. Shweta', 'Ms. Shweta', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('141', '144', 'Pooja Shah Mulani', 'Pooja Shah Mulani', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('142', '145', 'Mr Xpert technical Services New Office Jebel Ali', 'MXTS office Jebel Ali								', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('143', '146', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '0', '', NULL, '', '', '', '', '0', '0'),
('144', '147', 'Sanqour advertising service', 'Sanqour advertising service', 'Al Zahiya, Abu Dhabi', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Zahiya, Abu Dhabi', '0', '', NULL, '', '', '', '', '0', '0'),
('145', '148', 'EL TEAM LTD FZE - Sharjah', 'EL TEAM', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('146', '149', 'Wool Craft  Trading', 'Wool Craft  Trading', '', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('147', '150', 'Afaq Al Waseqh Electromechanical Services LLC', 'Afaq Al Waseqh Electromech', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('148', '151', 'MR. YU', 'MR. YU', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('149', '152', 'Astro properties', 'Astro properties', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('150', '153', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', 'P.O. Box – 48746,\nDubai, UAE\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box – 48746,\nDubai, UAE\n', '0', '', NULL, '', '', '', '', '0', '0'),
('151', '154', 'Mr. Hadisfer', 'Mr. Hadisfer', 'Villa 47 Hattan One Arabian Ranches', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 47 Hattan One Arabian Ranches', '0', '', NULL, '', '', '', '', '0', '0'),
('152', '155', 'JAMTS Tech LLC', 'JAMTS Tech LLC', 'PO Box 71893', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 71893', '0', 'Mr. Inaam', NULL, '', '', '', '', '0', '0'),
('153', '156', 'Sofitel Dubai The Palm', 'Sofitel Dubai The Palm', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('154', '157', 'Rahul Ranbhare', 'Rahul Ranbhare', 'G05, Fortunato 1, JVC', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'G05, Fortunato 1, JVC', '0', '', NULL, '', '', '', '', '0', '0'),
('155', '158', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', 'Villa 349 Hayat townhouses', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 349 Hayat townhouses', '0', '', NULL, '', '', '', '', '0', '0'),
('156', '159', 'HOAM Highrise Owners Association Management', 'HOAM Highrise Owners ', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '0', '', NULL, '', '', '', '', '0', '0'),
('157', '160', 'Al Hai Motors', 'Al Hai Motors', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('158', '161', 'Noma Design House', 'Noma Design House', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '0', '', NULL, '', '', '', '', '0', '0'),
('159', '162', 'Ms. Nissreen', 'Ms. Nissreen', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '0', '', NULL, '', '', '', '', '0', '0'),
('160', '163', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', 'Villa 127 Picadilly Green Damac Hills', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 127 Picadilly Green Damac Hills', '0', '', NULL, '', '', '', '', '0', '0'),
('161', '164', 'La Stella productions', 'La Stella productions', 'Al Qouz Dubai\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Al Qouz Dubai\n', '0', '', NULL, '', '', '', '', '0', '0'),
('162', '165', 'Mr. Habib Nahra', 'Mr. Habib Nahra', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('163', '166', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '8', '3', '001', '1', '', '4510', '1200', '4500', '1', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '0', '', NULL, '', '', '', '', '0', '0'),
('164', '167', 'One Laundry', 'One Laundry', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('165', '168', 'ALI FARHAN TECHNICAL SERVICES LLC', 'ALI FARHAN TECHNICAL SERVICES ', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('166', '169', 'Mr. Hisham', 'Mr. Hisham', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('167', '170', 'Mrs.Sumeira', 'Mrs.Sumeira', 'Villa F 41 Golf Course Villas', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa F 41 Golf Course Villas', '0', '', NULL, '', '', '', '', '0', '0'),
('168', '171', 'Dinesh Sanghvi', 'Dinesh Sanghvi', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('169', '172', 'Unitra International LLC', 'Unitra International LLC', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '0', '', NULL, '', '', '', '', '0', '0'),
('170', '173', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('171', '174', 'GDM Interiors LLC', 'GDM Interiors LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('172', '175', 'Vishesh Singhania ', 'Vishesh Singhania ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('173', '176', 'Imperial Avenue', 'Imperial Avenue', 'Dubai -UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai -UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('174', '177', 'Shaul Nagawkar ', 'Shaul Nagawkar ', 'Apt 705 Tower F Executive Tower - Business Bay', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Apt 705 Tower F Executive Tower - Business Bay', '0', '', NULL, '', '', '', '', '0', '0'),
('175', '179', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', ' Al Ain Road', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', ' Al Ain Road', '0', '', NULL, '', '', '', '', '0', '0'),
('176', '180', 'ABDULLA DARWISH GHULOOM AHMED BAQER', 'ABDULLA DARWISH GHULOOM AHMED ', 'Villa 32 Al Warqa', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 32 Al Warqa', '0', '', NULL, '', '', '', '', '0', '0'),
('177', '181', 'Rabia Ahmed ', 'Rabia Ahmed ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('178', '182', 'Kakul Technical Services', 'Kakul Technical Services', 'DUBAI', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('179', '183', 'Riham AlAli', 'Riham AlAli', 'Villa 102,Al Barsha,dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 102,Al Barsha,dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('180', '184', 'Blacksmith Coffee', 'Blacksmith Coffee', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('181', '185', 'Sangeet Jain', 'Sangeet Jain', 'Villa 33 Al Naseem Mudon', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 33 Al Naseem Mudon', '0', '', NULL, '', '', '', '', '0', '0'),
('182', '186', 'Stone House Real Estate Brokerage', 'Stone House Real Estate Broker', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('183', '187', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('184', '188', 'Warriors Aluminum and Glass Cont. LLC ', 'Warriors Aluminum and Glass', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('185', '189', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', 'PO Box 2748 Sharjah', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 2748 Sharjah', '0', '', NULL, '', '', '', '', '0', '0'),
('186', '190', 'High Power Services', 'High Power Services', 'PO Box 57467 Dubai.\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 57467 Dubai.\n', '0', '', NULL, '', '', '', '', '0', '0'),
('187', '191', 'Ms. Charu', 'Ms. Charu', 'Karama,DUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Karama,DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('188', '192', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', 'Villa 1, Ary Building Dubai Marina', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 1, Ary Building Dubai Marina', '0', '', NULL, '', '', '', '', '0', '0'),
('189', '193', 'Star Revive Medical Center', 'Star Revive Medical Center', 'jumeirah', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'jumeirah', '0', '', NULL, '', '', '', '', '0', '0'),
('190', '194', 'Phoenix Middle East', 'Phoenix Middle East', 'DIP 2 ,Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'DIP 2 ,Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('191', '195', 'MENAWATT TECHNICAL SERVICES EST.', 'MENAWATT TECHNICAL SERVICES ', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('192', '196', 'Mond Trading Services', 'Mond Trading Services', 'warehouse 141', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'warehouse 141', '0', '', NULL, '', '', '', '', '0', '0'),
('193', '197', 'Jean Paul Schmidt', 'Jean Paul Schmidt', 'Emaar South Villa 213', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Emaar South Villa 213', '0', '', NULL, '', '', '', '', '0', '0'),
('194', '198', 'Frederic de Melker', 'Frederic de Melker', 'City Walk Building 10, app 309', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'City Walk Building 10, app 309', '0', '', NULL, '', '', '', '', '0', '0'),
('195', '199', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', 'GULFLINE CONST. METALIC PARTS ', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '0', '', NULL, '', '', '', '', '0', '0'),
('196', '200', 'Abu Dhabi Entertainment Company ', 'Abu Dhabi Entertainment ', 'P.O. Box 862, Abu Dhabi, UAE', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box 862, Abu Dhabi, UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('197', '201', 'Mrs. Marie', 'Mrs. Marie', 'Villa 205, Maeen 4, The Lakes', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 205, Maeen 4, The Lakes', '0', '', NULL, '', '', '', '', '0', '0'),
('198', '202', 'Best Choice Trading LLC', 'Best Choice Trading LLC', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', 'Mr. Mozim Ahamed 052 644 7971', NULL, '', '', '', '', '0', '0'),
('199', '203', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '0', '', NULL, '', '', '', '', '0', '0'),
('200', '204', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', 'Jumeirh Park Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Jumeirh Park Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('201', '205', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('202', '206', 'Yashin Lalloo', 'Yashin Lalloo', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('203', '207', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', 'Al Qouz Villa 7', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Qouz Villa 7', '0', '', NULL, '', '', '', '', '0', '0'),
('204', '208', 'Waht Alhams Technical services EST', 'Waht Alhams Technical services', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('205', '209', 'Mrs. Anna', 'Mrs. Anna', 'Villa 17 Trixis, Damac Hills 2 Akoya', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 17 Trixis, Damac Hills 2 Akoya', '0', '', NULL, '', '', '', '', '0', '0'),
('206', '210', 'Aztec Shipping LLC', 'Aztec Shipping LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('207', '211', 'priyanka chugh', 'priyanka chugh', 'palm jumeirah', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'palm jumeirah', '0', '', NULL, '', '', '', '', '0', '0'),
('208', '212', 'InsideOut Casa Technical Services', 'InsideOut Casa Technical ', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('209', '213', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('210', '214', 'Ms.Priya Motiani', 'Ms.Priya Motiani', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('211', '215', 'Mr. Dipak Main', 'Mr. Dipak Main', 'Villa 118 Trixis Damac 2', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 118 Trixis Damac 2', '0', '', NULL, '', '', '', '', '0', '0'),
('212', '216', 'Design Evolution Technical Service Co.', 'Design Evolution Technical Ser', 'AL Awir', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'AL Awir', '0', '', NULL, '', '', '', '', '0', '0'),
('213', '217', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('214', '218', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', 'PO Box 81456 Dubai UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 81456 Dubai UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('215', '219', 'English Language Private School', 'English Language Private Schoo', ' Oud Metha', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', ' Oud Metha', '0', '', NULL, '', '', '', '', '0', '0'),
('216', '220', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', 'P.O BOX 31671,DUBAI - UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'P.O BOX 31671,DUBAI - UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('217', '221', 'Mr. Chari', 'Mr. Chari', 'Villa 240 Pacifica Damac 2', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 240 Pacifica Damac 2', '0', '', NULL, '', '', '', '', '0', '0'),
('218', '222', 'Mr. Prabhu', 'Mr. Prabhu', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('219', '223', 'Kings Speciality Restaurant LLC', 'Kings Speciality Restaurant LL', 'downtown', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'downtown', '0', '', NULL, '', '', '', '', '0', '0'),
('220', '224', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', 'La Quinta Dubai.', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'La Quinta Dubai.', '0', '', NULL, '', '', '', '', '0', '0'),
('221', '225', 'Al Ghussun Advertising', 'Al Ghussun Advertising', 'PO Box 2748 Sharjah UAE', '6', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 2748 Sharjah UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('222', '226', 'Al Ameemi International Trading L.L.C', 'Al Ameemi Intl Trdg LLC', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '0', '', NULL, '', '', '', '', '0', '0'),
('223', '227', 'Mr. Sanjiv Soori', 'Mr. Sanjiv Soori', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('224', '228', 'IBECE ENEGY', 'IBECE ENEGY', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('225', '229', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '0', '', NULL, '', '', '', '', '0', '0'),
('226', '230', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('227', '231', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', 'Villa 3704 Greens Community West', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 3704 Greens Community West', '0', '', NULL, '', '', '', '', '0', '0'),
('228', '231', 'Mrs. Zsuzsanna', ' 0505619411', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('229', '232', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '0', '', NULL, '', '', '', '', '0', '0'),
('230', '233', 'Mr. Antonio', 'Mr. Antonio', '', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('231', '234', 'Mobeen Javed', 'Mobeen Javed', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('232', '235', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('233', '236', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', '14B Street Umm Ramool Rashidiya, Dubai ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '14B Street Umm Ramool Rashidiya, Dubai ', '0', '', NULL, '', '', '', '', '0', '0'),
('234', '237', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('235', '238', 'Suntac General Trading LLC', 'Suntac General Trading LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('236', '239', 'Wasl LLC', 'Wasl LLC', 'DUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('237', '240', 'Mr. Brian Howarth', 'Mr. Brian Howarth', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '0', '', NULL, '', '', '', '', '0', '0'),
('238', '241', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('239', '242', 'Hermen Thomas ', 'Hermen Thomas ', 'G 003 \nNew bridge hills 3 \nUptown motor city', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'G 003 \nNew bridge hills 3 \nUptown motor city', '0', '', NULL, '', '', '', '', '0', '0'),
('240', '243', 'Deepak Panchariya', 'Deepak Panchariya', 'Gardenia, Wasl gate, TH 80', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Gardenia, Wasl gate, TH 80', '0', '', NULL, '', '', '', '', '0', '0'),
('241', '244', 'Nirav Patel', 'Nirav Patel', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('242', '245', 'Atlas Advertising', 'Atlas Advertising', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('243', '246', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', 'Meadows 6 Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Meadows 6 Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('244', '247', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('245', '249', 'HAMMER BUILDING MAINTENANCE LLC', 'HAMMER BUILDING MAINTENANCE LL', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '0', '', NULL, '', '', '', '', '0', '0'),
('246', '250', 'Discovery  General Contracting Co LLC', 'Discovery  General Contracting', 'ABU DHAHBI', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'ABU DHAHBI', '0', '', NULL, '', '', '', '', '0', '0'),
('247', '251', 'BIC Contracting LLC', 'BIC Contracting LLC', 'PO Box # 10869 Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box # 10869 Dubai', '0', '', NULL, '', '', '', '', '0', '0');

### Structure of table `0_dashboard` ###

DROP TABLE IF EXISTS `0_dashboard`;

CREATE TABLE `0_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard` ###

INSERT INTO `0_dashboard` VALUES
('1', 'Bank Information', '1', '0'),
('2', 'Prev. Year Revenue Comparison', '1', '0'),
('3', 'Prev. Year Expense Comparison', '1', '0'),
('4', 'Prev. Year COGS Comparison', '1', '0'),
('5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('6', 'Expense Break Down for Fiscal Year', '1', '0'),
('7', 'COGS Break Down for Fiscal Year', '1', '0'),
('8', 'Top 10 Customers', '2', '0'),
('9', 'Top 10 Selling Items', '2', '0'),
('10', 'Prev. Year Revenue Comparison', '2', '0'),
('11', 'Sales Aging', '2', '0'),
('12', 'Top 10 Open Quotations', '2', '0'),
('13', 'Top 10 Overdue Orders', '2', '0'),
('14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('15', 'Top 10 Purchase Items', '3', '0'),
('16', 'Supplier Aging', '3', '0'),
('17', 'Overdue Purchase Orders', '3', '0'),
('18', 'Overdue Invoices', '3', '0'),
('19', 'Top 10 Vendors', '3', '0'),
('20', 'Top 10 Selling Items', '4', '0'),
('21', 'Top 10 Purchase Items', '4', '0'),
('22', 'Inventory Value Locations', '4', '0'),
('23', 'Standard Rated Graph', '5', '0'),
('24', 'Zero Rated Graph', '5', '0'),
('25', 'Exempt Graph', '5', '0'),
('26', 'Excise Graph', '5', '0'),
('27', 'Total Sales', '6', '0'),
('28', 'Receivable', '7', '0'),
('29', 'Payable', '8', '0'),
('30', 'Profit', '9', '0');

### Structure of table `0_dashboard_language` ###

DROP TABLE IF EXISTS `0_dashboard_language`;

CREATE TABLE `0_dashboard_language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `deleted` tinyint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard_language` ###

INSERT INTO `0_dashboard_language` VALUES
('89', '002', '1', '5', '0'),
('90', '002', '3', '5', '0'),
('91', '002', '1', '3', '0'),
('133', '002', '3', '1', '0'),
('143', '002', '4', '1', '0'),
('148', '002', '2', '1', '0'),
('162', '002', '5', '1', '0'),
('165', '002', '5', '5', '0'),
('172', '002', '1', '1', '0'),
('173', '002', '5', '27', '0');

### Structure of table `0_dashboard_reminders` ###

DROP TABLE IF EXISTS `0_dashboard_reminders`;

CREATE TABLE `0_dashboard_reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `next_date` date NOT NULL,
  `description` text DEFAULT NULL,
  `frequency` varchar(20) NOT NULL,
  `param` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_dashboard_reminders` ###


### Structure of table `0_dashboard_tables` ###

DROP TABLE IF EXISTS `0_dashboard_tables`;

CREATE TABLE `0_dashboard_tables` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(11) NOT NULL,
  `widget_id` int(11) NOT NULL,
  `widget_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1339 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard_tables` ###

INSERT INTO `0_dashboard_tables` VALUES
('9', '2', '1', 'Bank Information', '1', '0'),
('10', '2', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('11', '2', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('12', '2', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('18', '2', '8', 'Top 10 Customers', '2', '0'),
('19', '2', '9', 'Top 10 Selling Items', '2', '0'),
('20', '2', '10', 'Prev. Year Revenue Comparison', '2', '0'),
('21', '2', '11', 'Sales Aging', '2', '0'),
('22', '2', '12', 'Top 10 Open Quotations', '2', '0'),
('23', '2', '13', 'Top 10 Overdue Orders', '2', '0'),
('24', '2', '14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('30', '2', '20', 'Top 10 Selling Items', '4', '0'),
('31', '2', '21', 'Top 10 Purchase Items', '4', '0'),
('32', '2', '15', 'Top 10 Purchase Items', '3', '0'),
('33', '2', '16', 'Supplier Aging', '3', '0'),
('34', '2', '17', 'Overdue Purchase Orders', '3', '0'),
('35', '2', '18', 'Overdue Invoices', '3', '0'),
('36', '2', '19', 'Top 10 Vendors', '3', '0'),
('731', '5', '1', 'Bank Information', '1', '0'),
('732', '5', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('733', '5', '3', 'Prev. Year Expense Comparison', '1', '0'),
('734', '5', '4', 'Prev. Year COGS Comparison', '1', '0'),
('735', '5', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('736', '5', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('737', '5', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('738', '5', '15', 'Top 10 Purchase Items', '3', '0'),
('739', '5', '16', 'Supplier Aging', '3', '0'),
('740', '5', '17', 'Overdue Purchase Orders', '3', '0'),
('741', '5', '18', 'Overdue Invoices', '3', '0'),
('742', '5', '19', 'Top 10 Vendors', '3', '0'),
('743', '3', '1', 'Bank Information', '1', '0'),
('744', '3', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('745', '3', '3', 'Prev. Year Expense Comparison', '1', '0'),
('746', '3', '4', 'Prev. Year COGS Comparison', '1', '0'),
('747', '3', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('748', '3', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('749', '3', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('1114', '1', '15', 'Top 10 Purchase Items', '3', '0'),
('1115', '1', '16', 'Supplier Aging', '3', '0'),
('1116', '1', '17', 'Overdue Purchase Orders', '3', '0'),
('1117', '1', '18', 'Overdue Invoices', '3', '0'),
('1118', '1', '19', 'Top 10 Vendors', '3', '0'),
('1187', '1', '20', 'Top 10 Selling Items', '4', '0'),
('1188', '1', '21', 'Top 10 Purchase Items', '4', '0'),
('1189', '1', '22', 'Inventory Value Locations', '4', '0'),
('1225', '1', '8', 'Top 10 Customers', '2', '0'),
('1226', '1', '9', 'Top 10 Selling Items', '2', '0'),
('1227', '1', '10', 'Prev. Year Revenue Comparison', '2', '0'),
('1228', '1', '11', 'Sales Aging', '2', '0'),
('1229', '1', '12', 'Top 10 Open Quotations', '2', '0'),
('1230', '1', '13', 'Top 10 Overdue Orders', '2', '0'),
('1231', '1', '14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('1236', '1', '23', 'Standard Rated Graph', '5', '0'),
('1237', '1', '24', 'Zero Rated Graph', '5', '0'),
('1238', '1', '25', 'Exempt Graph', '5', '0'),
('1239', '1', '26', 'Excise Graph', '5', '0'),
('1321', '2', '22', 'Total Sales', '6', '0'),
('1322', '2', '23', 'Receivable', '7', '0'),
('1323', '2', '24', 'Payable', '8', '0'),
('1324', '2', '25', 'Profit', '9', '0'),
('1332', '1', '1', 'Bank Information', '1', '0'),
('1333', '1', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('1334', '1', '3', 'Prev. Year Expense Comparison', '1', '0'),
('1335', '1', '4', 'Prev. Year COGS Comparison', '1', '0'),
('1336', '1', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('1337', '1', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('1338', '1', '7', 'COGS Break Down for Fiscal Year', '1', '0');

### Structure of table `0_dashboard_widgets` ###

DROP TABLE IF EXISTS `0_dashboard_widgets`;

CREATE TABLE `0_dashboard_widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `app` varchar(50) NOT NULL,
  `column_id` int(11) NOT NULL,
  `sort_no` int(11) NOT NULL,
  `collapsed` tinyint(4) NOT NULL,
  `widget` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `param` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_dashboard_widgets` ###

INSERT INTO `0_dashboard_widgets` VALUES
('1', '1', 'AP', '1', '1', '0', 'weeklysales', 'Top 10 Sales Weeks', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;desc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;}'),
('2', '1', 'AP', '1', '0', '0', 'weeklysales', 'Weekly Sales', '{&quot;top&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;Week End&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('3', '1', 'AP', '2', '1', '0', 'weeklysales', 'Lowest weeks sales', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('6', '1', 'AP', '2', '0', '0', 'dailysales', 'Daily Sales', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;}'),
('7', '1', 'orders', '1', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('9', '1', 'orders', '1', '1', '0', 'salesinvoices', 'Overdue invoices', '{&quot;data_filter&quot;:&quot;&quot;}'),
('10', '1', 'AP', '1', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('11', '1', 'AP', '2', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('12', '1', 'GL', '2', '1', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('13', '1', 'GL', '2', '0', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('14', '1', 'stock', '1', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('15', '1', 'stock', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('16', '1', 'manuf', '1', '0', '0', 'items', 'Top 10 items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('17', '1', 'manuf', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('18', '1', 'orders', '2', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('19', '1', 'GL', '2', '2', '0', 'bankbalances', 'Bank Balances', '{&quot;data_filter&quot;:&quot;&quot;}'),
('20', '1', 'GL', '1', '1', '0', 'dailybankbalances', 'Daily Current Account Balance', '{&quot;days_past&quot;:&quot;&quot;,&quot;days_future&quot;:&quot;&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('21', '1', 'GL', '1', '0', '0', 'banktransactions', 'Current Account Transactions', '{&quot;days_past&quot;:&quot;15&quot;,&quot;days_future&quot;:&quot;15&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('22', '2', 'AP', '1', '1', '0', 'weeklysales', 'Top 10 Sales Weeks', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;desc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;}'),
('23', '2', 'AP', '1', '0', '0', 'weeklysales', 'Weekly Sales', '{&quot;top&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;Week End&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('24', '2', 'AP', '2', '1', '0', 'weeklysales', 'Lowest weeks sales', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('25', '2', 'AP', '2', '0', '0', 'dailysales', 'Daily Sales', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;}'),
('26', '2', 'orders', '1', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('27', '2', 'orders', '1', '1', '0', 'salesinvoices', 'Overdue invoices', '{&quot;data_filter&quot;:&quot;&quot;}'),
('28', '2', 'AP', '1', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('29', '2', 'AP', '2', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('30', '2', 'GL', '2', '1', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('31', '2', 'GL', '2', '0', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('32', '2', 'stock', '1', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('33', '2', 'stock', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('34', '2', 'manuf', '1', '0', '0', 'items', 'Top 10 items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('35', '2', 'manuf', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('36', '2', 'orders', '2', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('37', '2', 'GL', '2', '2', '0', 'bankbalances', 'Bank Balances', '{&quot;data_filter&quot;:&quot;&quot;}'),
('38', '2', 'GL', '1', '1', '0', 'dailybankbalances', 'Daily Current Account Balance', '{&quot;days_past&quot;:&quot;&quot;,&quot;days_future&quot;:&quot;&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('39', '2', 'GL', '1', '0', '0', 'banktransactions', 'Current Account Transactions', '{&quot;days_past&quot;:&quot;15&quot;,&quot;days_future&quot;:&quot;15&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;data_filter&quot;:&quot;&quot;}');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` bigint(11) unsigned NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `notification_status` int(11) NOT NULL,
  `refund` int(11) NOT NULL,
  `cons_full_name` varchar(255) NOT NULL,
  `cons_address` varchar(255) NOT NULL,
  `cons_phone1` varchar(255) NOT NULL,
  `cons_phone2` varchar(255) NOT NULL,
  `country` varchar(50) NOT NULL,
  `amount_recived` double NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `master_order` int(11) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `deliver_to` varchar(100) NOT NULL,
  `technician` int(11) NOT NULL,
  `draft` int(11) NOT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###

INSERT INTO `0_debtor_trans` VALUES
('4', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('4', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('5', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '18', '17', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '5212.96', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '128', '126', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '1155', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '230', '226', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '1700.21', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '249', '245', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '3675', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '250', '246', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '7350', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('6', '0', '0', '251', '247', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '-3390.41', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('7', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('8', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('9', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0');
INSERT INTO `0_debtor_trans` VALUES
('10', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('10', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('11', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('12', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('13', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('14', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '770', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1050', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3350', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '472.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '503.01', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '33780', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '-100', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '325', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3502.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '42058.16', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '9636', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '16682.46', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '17955', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2625', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '15767.99', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1075', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '892.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3675', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3937.71', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '37250', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '12904.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2498', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '-231.74', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3150', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3055', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1050', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2636', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '8400', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3675', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1141.3', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1600.2', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '3167.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '600.08', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '19581.25', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '2342.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '5775', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1680', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '5820', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '1050', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '899.85', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '499.65', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '262.5', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0'),
('15', '0', '0', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '525', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0');

### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(255) NOT NULL,
  `item_specs` varchar(100) NOT NULL,
  `spec_description` varchar(1000) NOT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) DEFAULT NULL,
  `sale_kit_id` varchar(50) NOT NULL,
  `line_ref` varchar(200) NOT NULL,
  `line_date` date NOT NULL,
  `stock_out` int(11) NOT NULL COMMENT '1=Stock Out From Inventory',
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` bigint(100) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) NOT NULL,
  `address` tinytext DEFAULT NULL,
  `tax_id` varchar(55) NOT NULL DEFAULT '',
  `curr_code` char(3) NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount_criteria` int(11) NOT NULL COMMENT '1=discount in percentage, 2=discount in fixed amoun',
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext NOT NULL,
  `cust_ref_arabic` varchar(100) NOT NULL,
  `CustName_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_of_users` int(11) NOT NULL,
  `company` varchar(100) NOT NULL,
  `pass` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_cash_cust` tinyint(1) NOT NULL,
  `cp_id` int(11) NOT NULL COMMENT 'Contact Person Created By CRM Module\r\n',
  `emirates_id` varchar(200) NOT NULL COMMENT 'Emirates ID Image(File-Name)',
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'A. A. A. Shuhail Alqahta', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('3', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'A. M &amp; COMMUNICATION', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('5', 'Antique Style', 'Antique Style', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('6', 'Arnesto Purgos', 'A.Purgos', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('8', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'B.P.EMIRATES LTD CO ', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('9', 'BIC Contracting LLC', 'B.C.LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('11', 'CAESARS BLUEWATERS DUBAI L.L.C', 'C.B.DUBAI L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('12', 'Core Elements Interior Decoration LLC', 'C. E. Interior Decorat LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('14', 'Decortser Portal', 'Decortser Portal', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('15', 'Discovery  General Contracting Co LLC', 'D.G.Contracting Co LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('16', 'Dr. Laya', 'Dr. Laya', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('17', 'Dr. Rehmina', 'Dr. Rehmina', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('19', 'Ismail Abdul Rahim Shaaban Mohamed', 'I. Abdul Rahim Shaaban Mohamed', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('20', 'Jalal Merchant', 'Jalal Merchant', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('22', 'KOA REAL ESTATE DEVELOPMENT LLC', 'KOA R.E.DEVELOPMENT LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('25', 'Mr. AD', 'Mr. AD', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('26', 'Mr. Alaa', 'Mr. Alaa', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('27', 'Mr . Amit', 'Mr . Amit', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('28', 'Mr Ashok', 'Mr Ashok', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('31', 'Mr.Dinesh', 'Mr.Dinesh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('33', 'Mr. Haresh', 'Mr. Haresh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('34', 'Mr Hasan', 'Mr Hasan', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('35', 'Mr. Ibrahim', 'Mr. Ibrahim', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('37', 'Mr. James', 'Mr. James', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('41', 'Mr.Neeraj', 'Mr.Neeraj', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('42', 'Mr. Prabhat', 'Mr. Prabhat', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('44', 'Mr.Rajesh', 'Mr.Rajesh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('47', 'Mr. Saqlain', 'Mr. Saqlain', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('49', 'Ms. Ahiliya', 'Ms. Ahiliya', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('52', 'Ms. Loulwa', 'Ms. Loulwa', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('53', 'Ms. Roda', 'Ms. Roda', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('54', 'Ms.Swarn', 'Ms.Swarn', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('55', 'Ms. Thanuja', 'Ms. Thanuja', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('56', 'Ms. Yogitha', 'Ms. Yogitha', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', 'Al barari , Dubai', '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('58', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', 'NATURAL TRENDY TIL&amp;FLOOR M', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('63', 'QEXPRESS', 'QEXPRESS', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('65', 'RIGHT HOMES REAL ESTATE BROKERS', 'R. H. REAL ESTATE BROKERS', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('68', 'Sajith Ansar', 'Sajith Ansar', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('69', 'Sustainable Builders', 'Sustainable Builders', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('70', 'Techforce Technical Services', 'Techforce Technical Services', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('73', 'Cash Customer', 'Cash Customer', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '1', '0', ''),
('74', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', NULL, '100593452400003', 'AED', '1', '0', '0', '6', '5', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('75', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'BERGER PAINTS EMIRATES LTD CO', NULL, '', 'AED', '1', '0', '0', '6', '7', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('78', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('79', 'Naga Lakshmi', 'Naga Lakshmi', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('80', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'Abdelaziz Abdelrahman Abdelazi', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('81', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('82', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'ADSS MARKETING &amp; COMMUNICA', NULL, '100332927100003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('83', 'AFRICA INTERNET GENERAL TRADING LLC', 'AFRICA INTERNET GENERAL TRADIN', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('84', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('85', 'Aevolve Beauty Saloon', 'Aevolve Beauty Saloon', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('86', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('87', 'Vijaya Chikermane', 'Vijaya Chikermane', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('88', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('89', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', NULL, '', 'AED', '1', '0', '0', '6', '8', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('90', 'Angel Cakes', 'Angel Cakes', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('91', 'AQS Management Consultancy', 'AQS Management Consultancy', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('92', 'Naresh Mohnani', 'Naresh Mohnani', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('93', 'Luigi Dsouza', 'Luigi Dsouza', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('94', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', NULL, '100588356400003', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('95', 'Ms. Alita', 'Ms. Alita', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('96', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('97', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('98', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('99', 'Mr Tahir', 'Mr Tahir', NULL, '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('100', 'Salim Lokhandwala', 'salim lokhand.', 'Dubai Hills\nDubai', '', 'AED', '1', '0', '0', '6', '2', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('101', 'Bridge Forth &amp; Signature Contracting Co. LLC', 'Bridge Forth &amp; Signature', 'PO BOX 99856\nDUBAI', '100399834900003', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('102', 'Ms. Nour', 'Ms. Nour', 'Springs 11, street 2, villa 36\nDubai', '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('103', 'Milad Interior Design', 'Milad Interior Design', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('104', 'Majid Al Falasi', 'Majid Al Falasi', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('105', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', NULL, '100232267300003', 'AED', '1', '0', '0', '6', '9', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('106', 'NEW CLEARVIEW DECORATION DESIGN &amp; IMPLEMENTATION', 'NEW CLEARVIEW DECORATION DESIG', 'Dubai', '100473164000003', 'AED', '1', '0', '0', '6', '6', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('107', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', 'Dubai', '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('108', 'Suzena', 'Suzena', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('109', 'Akhil Vinayak', 'Akhil Vinayak', NULL, '', 'AED', '1', '0', '0', '6', '1', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('110', 'Ms. Fatma Al Rais', 'Fatma Al Rais', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('111', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('112', 'PAVIMENTO GENERAL TRADING L.L.C', 'PAVIMENTO GENERAL TRDG LLC', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '100541804900003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('113', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '100449949500003', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('114', 'Yogesh', 'Yogesh', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('115', 'I 2 D Interiors', 'I 2 D Interiors', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('116', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', NULL, '100621145000003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('117', 'The international school of choueifat', 'The international school of ch', NULL, '100355326800003', 'AED', '1', '0', '0', '6', '5', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('118', 'RATLS CONTRACTING', 'RATLS CONTRACTING', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('119', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('120', 'Colart Publishing &amp; Advertising LLC', 'Colart Publishing &amp; Adv. L', 'PO Box 49652\nDUBAI', '100333677100003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('121', 'Ms. Arpita', 'Ms. Arpita', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('123', 'Turnkey fitout solutions', 'Turnkey fitout solutions', 'po box # 47862\nDubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('124', 'kalyan chakravarthy', 'kalyan chakravarthy', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('125', 'Harun Sultan', 'Harun Sultan', 'Ajman', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('126', 'VERVE INTERIOR  DECORATION L.L.C', 'VERVE INTERIOR  DECORATION L.L', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '100368853600003', 'AED', '1', '0', '0', '6', '7', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('127', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', 'Dubai', '', 'AED', '1', '0', '0', '6', '5', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('128', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '100579896000003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('130', 'Kitchenscape Domestic Kitchens LLC', 'Kitchenscape Domestic Kitchens', 'Dubai', '100514227600003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('131', 'GREEN TERRA TECHNICAL SERVICES LLC', 'GREEN TERRA TECHNICAL SERVICES', 'Dubai', '100346872300003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('132', 'Ms. Serena', 'Ms. Serena', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('133', 'Highrise Owners Association Management (HOAM)', 'Highrise Owners Association Ma', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('134', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', 'Po Box # 60288\nDIP\nDubai', '100374958500003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('135', 'Beenish Haider', 'Beenish Haider', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('136', 'Meherz Kreation LLC', 'Meherz Kreation LLC', NULL, '100468664600003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('137', 'WASL PROPERTIES', 'WASL PROPERTIES', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('138', 'Modern Seal Insulation Solutions', 'Modern Seal Insulation Soln', NULL, '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('139', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('141', 'Mr. Rajiv', 'Mr. Rajiv', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('142', 'Fincirc International Management', 'Fincirc International Manageme', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '100002805800003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('143', 'Ms. Shweta', 'Ms. Shweta', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('144', 'Pooja Shah Mulani', 'Pooja Shah Mulani', 'Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('145', 'Mr Xpert technical Services New Office Jebel Ali', 'MXTS office Jebel Ali								', NULL, '', 'AED', '1', '0', '0', '6', '1', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('146', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '100025884600003', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('147', 'Sanqour advertising service', 'Sanqour advertising service', 'Al Zahiya, Abu Dhabi', '', 'AED', '1', '0', '0', '6', '5', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('148', 'EL TEAM LTD FZE - Sharjah', 'EL TEAM LTD FZE - Sharjah', 'Office 08A Ground Floor LOB 2\nHamriya Free Zone, Sharjah', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('149', 'Wool Craft  Trading', 'Wool Craft  Trading', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('150', 'Afaq Al Waseqh Electromechanical Services LLC', 'Afaq Al Waseqh Electromech', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('151', 'MR. YU', 'MR. YU', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('152', 'Astro properties', 'Astro properties', 'E504, Burj Khalifa, Dubai, برج خليفة مكتب رقم\nDubai, United Arab Emirates, 0000,', '100434680300003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '1000', '+971557468871', '', '', '0', '0', '', '', '0', '0', '0', ''),
('153', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', 'P.O. Box – 48746,\nDubai, UAE\n', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('154', 'Mr. Hadisfer', 'Mr. Hadisfer', 'Villa 47 Hattan One Arabian Ranches', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('155', 'JAMTS Tech LLC', 'JAMTS Tech LLC', 'PO Box 71893', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', 'Mr. Inaam', '', '', '0', '0', '', '', '0', '0', '0', ''),
('156', 'SOFITEL THE PALM FZCO ', 'Sofitel Dubai The Palm', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '100056298100003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('157', 'Rahul Ranbhare', 'Rahul Ranbhare', 'G05, Fortunato 1, JVC', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('158', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', 'Villa 349 Hayat townhouses', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('159', 'HOAM Highrise Owners Association Management', 'HOAM Highrise Owners ', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('160', 'Al Hai Motors', 'Al Hai Motors', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('161', 'Noma Design House', 'Noma Design House', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('162', 'Ms. Nissreen', 'Ms. Nissreen', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('163', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', 'Villa 127 Picadilly Green Damac Hills', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('164', 'La Stella productions', 'La Stella productions', 'Al Qouz Dubai\n', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('165', 'Mr. Habib Nahra', 'Mr. Habib Nahra', NULL, '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('166', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '100231971100003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('167', 'One Laundry', 'One Laundry', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('168', 'ALI FARHAN TECHNICAL SERVICES LLC', 'ALI FARHAN TECHNICAL SERVICES ', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('169', 'Mr. Hisham', 'Mr. Hisham', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('170', 'Mrs.Sumeira', 'Mrs.Sumeira', 'Villa F 41 Golf Course Villas', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('171', 'Dinesh Sanghvi', 'Dinesh Sanghvi', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('172', 'Unitra International LLC', 'Unitra International LLC', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '100271258400003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('173', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', 'Villa 4, Street 110, Barsha South One', '', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('174', 'GDM Interiors LLC', 'GDM Interiors LLC', NULL, '100027925500003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('175', 'Vishesh Singhania ', 'Vishesh Singhania ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('176', 'Imperial Avenue', 'Imperial Avenue', 'Dubai -UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('177', 'Shaul Nagawkar ', 'Shaul Nagawkar ', 'Apt 705 Tower F Executive Tower - Business Bay', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('179', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', ' Al Ain Road', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('180', 'ABDULLA DARWISH GHULOOM AHMED BAQER', 'ABDULLA DARWISH GHULOOM AHMED ', 'Villa 32 Al Warqa', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('181', 'Rabia Ahmed ', 'Rabia Ahmed ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('182', 'Kakul Technical Services', 'Kakul Technical Services', 'DUBAI', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('183', 'Riham AlAli', 'Riham AlAli', 'Villa 102,Al Barsha,dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('184', 'Blacksmith Coffee', 'Blacksmith Coffee', 'dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('185', 'Sangeet Jain', 'Sangeet Jain', 'Villa 33 Al Naseem Mudon', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('186', 'Stone House Real Estate Brokerage', 'Stone House Real Estate Broker', 'office 1110, the citadel tower, business Bay\n+971 55 981 0126', '100069298600003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('187', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('188', 'Warriors Aluminum and Glass Cont. LLC ', 'Warriors Aluminum and Glass', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('189', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', 'PO Box 2748 Sharjah', '100529873000003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('190', 'High Power Services', 'High Power Services', 'PO Box 57467 Dubai.\n', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('191', 'Ms. Charu', 'Ms. Charu', 'Karama,DUBAI', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('192', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', 'Villa 1, Ary Building Dubai Marina', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('193', 'Star Revive Medical Center', 'Star Revive Medical Center', 'jumeirah', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('194', 'Phoenix Middle East', 'Phoenix Middle East', 'DIP 2 ,Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('195', 'MENAWATT TECHNICAL SERVICES EST.', 'MENAWATT TECHNICAL SERVICES ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('196', 'Mond Trading Services', 'Mond Trading Services', 'warehouse 141', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('197', 'Jean Paul Schmidt', 'Jean Paul Schmidt', 'Emaar South Villa 213', '', 'AED', '1', '0', '0', '6', '4', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('198', 'Frederic de Melker', 'Frederic de Melker', 'City Walk Building 10, app 309', '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('199', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', 'GULFLINE CONST. METALIC PARTS ', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('200', 'Abu Dhabi Entertainment Company ', 'Abu Dhabi Entertainment ', 'P.O. Box 862, Abu Dhabi, UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('201', 'Mrs. Marie', 'Mrs. Marie', 'Villa 205, Maeen 4, The Lakes', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('202', 'Best Choice Trading LLC', 'Best Choice Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', 'Mr. Mozim Ahamed 052 644 7971', '', '', '0', '0', '', '', '0', '0', '0', ''),
('203', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', 'Mag 218 tower, aprt 2509', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('204', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', 'Jumeirh Park Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('205', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('206', 'Yashin Lalloo', 'Yashin Lalloo', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('207', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', 'Al Qouz Villa 7', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('208', 'Waht Alhams Technical services EST', 'Waht Alhams Technical services', NULL, '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('209', 'Mrs. Anna', 'Mrs. Anna', 'Villa 17 Trixis, Damac Hills 2 Akoya', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('210', 'Aztec Shipping LLC', 'Aztec Shipping LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('211', 'priyanka chugh', 'priyanka chugh', 'palm jumeirah', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('212', 'InsideOut Casa Technical Services', 'InsideOut Casa Technical ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('213', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('214', 'Ms.Priya Motiani', 'Ms.Priya Motiani', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('215', 'Mr. Dipak Main', 'Mr. Dipak Main', 'Villa 118 Trixis Damac 2', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('216', 'Design Evolution Technical Service Co.', 'Design Evolution Technical Ser', 'AL Awir', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('217', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('218', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', 'PO Box 81456 Dubai UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('219', 'English Language Private School', 'English Language Private Schoo', ' Oud Metha', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('220', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', 'P.O BOX 31671,DUBAI - UAE', '100314693100003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('221', 'Mr. Chari', 'Mr. Chari', 'Villa 240 Pacifica Damac 2', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('222', 'Mr. Prabhu', 'Mr. Prabhu', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('223', 'Kings Speciality Restaurant LLC', 'Kings Speciality Restaurant LL', 'Jun&#039;s Dubai, VRDT-GR-01, Vida Residence, Downtown Boulevard Road, Downtown, Dubai', '104021543400003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('224', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', 'La Quinta Dubai.', '', 'AED', '1', '0', '0', '6', '3', '0', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('225', 'Al Ghussun Advertising', 'Al Ghussun Advertising', 'PO Box 2748 Sharjah UAE', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('226', 'Al Ameemi International Trading L.L.C', 'Al Ameemi Intl Trdg LLC', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('227', 'Mr. Sanjeev Suri', 'Mr. Sanjeev Suri', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('228', 'IBECE ENEGY', 'IBECE ENEGY', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('229', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '100059624500003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('230', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '100376644900003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('231', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', 'Villa 3704 Greens Community West', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('232', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('233', 'Mr. Antonio', 'Mr. Antonio', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('234', 'Mobeen Javed', 'Mobeen Javed', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('235', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', NULL, '100259304200003', 'AED', '1', '0', '0', '6', '2', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('236', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', '14B Street Umm Ramool Rashidiya, Dubai ', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('237', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('238', 'Suntac General Trading LLC', 'Suntac General Trading LLC', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('239', 'Wasl LLC', 'Wasl LLC', 'DUBAI', '100314979400003', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('240', 'Mr. Brian Howarth', 'Mr. Brian Howarth', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('241', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('242', 'Hermen Thomas ', 'Hermen Thomas ', 'G 003 \nNew bridge hills 3 \nUptown motor city', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('243', 'Deepak Panchariya', 'Deepak Panchariya', 'Gardenia, Wasl gate, TH 80', '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('244', 'Nirav Patel', 'Nirav Patel', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('245', 'Atlas Advertising', 'Atlas Advertising', NULL, '', 'AED', '1', '0', '0', '6', '3', '1', '0', '0', '0', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('246', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', 'Meadows 6 Dubai', '', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('247', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '100579896000003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('249', 'HAMMER BUILDING MAINTENANCE LLC', 'HAMMER BUILDING MAINTENANCE LL', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '100593452400003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('250', 'Discovery  General Contracting Co LLC', 'Discovery  General Contracting', 'ABU DHAHBI', '100334239900003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', ''),
('251', 'BIC Contracting LLC', 'BIC Contracting LLC', 'PO Box # 10869 Dubai', '100259779500003', 'AED', '1', '0', '0', '6', '7', '0', '0', '0', '1000', '', '', '', '0', '0', '', '', '0', '0', '0', '');

### Structure of table `0_department` ###

DROP TABLE IF EXISTS `0_department`;

CREATE TABLE `0_department` (
  `dept_id` int(11) NOT NULL AUTO_INCREMENT,
  `dept_name` tinytext NOT NULL,
  `basic_account` varchar(15) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_department` ###


### Structure of table `0_designation` ###

DROP TABLE IF EXISTS `0_designation`;

CREATE TABLE `0_designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_designation` ###


### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `project_amount` double NOT NULL,
  `profit_margin` int(11) NOT NULL,
  `exclude_from_sales` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###


### Structure of table `0_document_types` ###

DROP TABLE IF EXISTS `0_document_types`;

CREATE TABLE `0_document_types` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(100) NOT NULL,
  `notify_before` smallint(5) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_document_types` ###


### Structure of table `0_emp_payslip_trans` ###

DROP TABLE IF EXISTS `0_emp_payslip_trans`;

CREATE TABLE `0_emp_payslip_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `basic_salary` double NOT NULL,
  `allowance` double NOT NULL,
  `deduction` double NOT NULL,
  `gross_salary` double NOT NULL,
  `overtime_hrs` int(11) NOT NULL,
  `ot_salary` double NOT NULL,
  `normal_days` int(11) NOT NULL,
  `nd_salary` double NOT NULL,
  `upl` int(11) NOT NULL COMMENT 'un paid leave',
  `pl` int(11) NOT NULL,
  `pl_amount` double NOT NULL,
  `month_id` int(11) NOT NULL,
  `year_id` int(11) NOT NULL,
  `total_salary` double NOT NULL,
  `alloc_amount` double NOT NULL,
  `emp_approved` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_emp_payslip_trans` ###


### Structure of table `0_emp_payslip_trans_detail` ###

DROP TABLE IF EXISTS `0_emp_payslip_trans_detail`;

CREATE TABLE `0_emp_payslip_trans_detail` (
  `trans_id` int(11) NOT NULL,
  `All_ded_leave_id` int(11) NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `leave_type` int(11) NOT NULL,
  `type` int(11) NOT NULL COMMENT '''1'' is allowance ,''2'' is deductioen ,''3'' is leave'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_emp_payslip_trans_detail` ###


### Structure of table `0_employee` ###

DROP TABLE IF EXISTS `0_employee`;

CREATE TABLE `0_employee` (
  `emp_id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_first_name` varchar(100) DEFAULT NULL,
  `emp_last_name` varchar(100) DEFAULT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT 0,
  `emp_address` tinytext DEFAULT NULL,
  `emp_mobile` varchar(30) DEFAULT NULL,
  `emp_email` varchar(100) DEFAULT NULL,
  `emp_birthdate` date NOT NULL,
  `emp_notes` tinytext NOT NULL,
  `emp_hiredate` date DEFAULT NULL,
  `department_id` int(11) NOT NULL,
  `salary_scale_id` int(11) NOT NULL DEFAULT 0,
  `emp_salary` varchar(30) NOT NULL,
  `emp_releasedate` date DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  `role` int(11) NOT NULL,
  `work_permit` varchar(25) NOT NULL,
  `bank_name` varchar(50) NOT NULL,
  `bank_account` varchar(30) NOT NULL,
  `iban` varchar(30) NOT NULL,
  PRIMARY KEY (`emp_id`),
  KEY `salary_scale_id` (`salary_scale_id`),
  KEY `department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee` ###


### Structure of table `0_employee_advance` ###

DROP TABLE IF EXISTS `0_employee_advance`;

CREATE TABLE `0_employee_advance` (
  `emp_trans_no` int(11) NOT NULL,
  `emp_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_advance` ###


### Structure of table `0_employee_advance_allocation` ###

DROP TABLE IF EXISTS `0_employee_advance_allocation`;

CREATE TABLE `0_employee_advance_allocation` (
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `amount` double unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_advance_allocation` ###


### Structure of table `0_employee_docs` ###

DROP TABLE IF EXISTS `0_employee_docs`;

CREATE TABLE `0_employee_docs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `description` varchar(60) NOT NULL DEFAULT '',
  `issue_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `alert` tinyint(1) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_docs` ###


### Structure of table `0_employee_payment_receipt_allocation` ###

DROP TABLE IF EXISTS `0_employee_payment_receipt_allocation`;

CREATE TABLE `0_employee_payment_receipt_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `gl_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_payment_receipt_allocation` ###


### Structure of table `0_employee_trans` ###

DROP TABLE IF EXISTS `0_employee_trans`;

CREATE TABLE `0_employee_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `trans_type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `payslip_no` int(11) NOT NULL DEFAULT 0,
  `pay_date` date NOT NULL,
  `to_the_order_of` varchar(255) NOT NULL,
  `pay_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_employee_trans` ###


### Structure of table `0_events` ###

DROP TABLE IF EXISTS `0_events`;

CREATE TABLE `0_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_role` int(11) NOT NULL,
  `title` text NOT NULL,
  `arabic_title` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `color` varchar(20) NOT NULL,
  `start_event` datetime NOT NULL,
  `end_event` datetime NOT NULL,
  `status` int(1) NOT NULL,
  `notification` int(1) NOT NULL,
  `comment_id` int(100) NOT NULL COMMENT 'This Data is in the relation with Followup Comments',
  `real_estate_id` int(11) NOT NULL,
  `reminder_status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_events` ###


### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('55', 'INR', '20.22', '20.22', '2021-06-29'),
('56', 'PKR', '43.03', '43.03', '2021-06-29'),
('57', 'AED', '43.23', '43.23', '2021-07-07'),
('58', 'AED', '43.23', '43.23', '2021-07-13'),
('59', 'AED', '43.23', '43.23', '2021-08-02'),
('60', 'USD', '200', '200', '2021-10-30'),
('61', 'USD', '1.2', '1.2', '2022-04-18');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('8', '2021-01-01', '2021-12-31', '0'),
('9', '2020-01-01', '2020-12-31', '0'),
('10', '2019-01-01', '2019-12-31', '0'),
('11', '2022-01-01', '2022-12-31', '0'),
('12', '2023-01-01', '2023-12-31', '0'),
('13', '2024-01-01', '2024-12-31', '0');

### Structure of table `0_followup` ###

DROP TABLE IF EXISTS `0_followup`;

CREATE TABLE `0_followup` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `type` int(100) NOT NULL,
  `trans_no` int(100) NOT NULL,
  `user` int(100) NOT NULL,
  `date_` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `comment` longtext NOT NULL,
  `reminder_date` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_followup` ###


### Structure of table `0_forms_feilds` ###

DROP TABLE IF EXISTS `0_forms_feilds`;

CREATE TABLE `0_forms_feilds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(30) NOT NULL,
  `name` varchar(30) NOT NULL,
  `type` int(11) NOT NULL,
  `view` varchar(10) NOT NULL,
  `status_pc` int(1) NOT NULL DEFAULT 1,
  `status_mbl` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_forms_feilds` ###

INSERT INTO `0_forms_feilds` VALUES
('1', 'Customer', 'customer_id_checkbox', '10', 'mbl', '1', '1'),
('2', 'Branch', 'branch_id_checkbox', '10', 'mbl', '1', '1'),
('3', 'Reference', 'reference_checkbox', '10', 'mbl', '1', '1'),
('4', 'Current Credit', 'current_credit_checkbox', '10', 'mbl', '1', '0'),
('5', 'Customer Discount', 'customer_discount_checkbox', '10', 'mbl', '1', '0'),
('6', 'Payment', 'payment_checkbox', '10', 'mbl', '1', '0'),
('7', 'Price List', 'price_list_checkbox', '10', 'mbl', '1', '0'),
('8', 'Date', 'date_checkbox', '10', 'mbl', '1', '1'),
('9', 'Dimension', 'dimension_checkbox', '10', 'mbl', '1', '0'),
('10', 'Dimension 2', 'dimension_2_checkbox', '10', 'mbl', '1', '0'),
('11', 'Exchange Rate', 'exchange_rate_checkbox', '10', 'mbl', '1', '0'),
('12', 'Customer', 'customer_id_checkbox', '11', 'mbl', '1', '1'),
('13', 'Branch', 'branch_id_checkbox', '11', 'mbl', '1', '1'),
('14', 'Reference', 'reference_checkbox', '11', 'mbl', '1', '1'),
('15', 'Exchange Rate', 'exchange_rate_checkbox', '11', 'mbl', '1', '0'),
('16', 'Current Credit', 'current_credit_checkbox', '11', 'mbl', '1', '0'),
('17', 'Customer Discount', 'customer_discount_checkbox', '11', 'mbl', '1', '0'),
('18', 'Payment', 'payment_checkbox', '11', 'mbl', '1', '0'),
('19', 'Price List', 'price_list_checkbox', '11', 'mbl', '1', '0'),
('20', 'Date', 'date_checkbox', '11', 'mbl', '1', '1'),
('21', 'Dimension', 'dimension_checkbox', '11', 'mbl', '1', '0'),
('22', 'Dimension 2', 'dimension_2_checkbox', '11', 'mbl', '1', '0'),
('34', 'Customer Currency', 'customer_currency_checkbox', '11', 'mbl', '1', '1'),
('35', 'Shipping Company', 'shipping_company_checkbox', '11', 'mbl', '1', '1');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  `import` int(11) NOT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=616 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '0', '1', '2023-12-31', '24038', '', '0', '0', '0', NULL, NULL, '0'),
('2', '0', '1', '2023-12-31', '2390', '', '0', '0', '0', NULL, NULL, '0'),
('3', '0', '1', '2023-12-31', '2100', '', '0', '0', '0', '3', '2', '0'),
('4', '0', '1', '2023-12-31', '1060', '', '0', '0', '0', '3', '97', '0'),
('5', '0', '2', '2023-12-31', '24038', '', '7390.99', '0', '0', NULL, NULL, '0'),
('6', '0', '2', '2023-12-31', '2390', '', '-85508.43', '0', '0', NULL, NULL, '0'),
('7', '0', '2', '2023-12-31', '2100', '', '-1260', '0', '0', '3', '2', '0'),
('8', '0', '2', '2023-12-31', '1060', '', '79377.44', '0', '0', '3', '97', '0'),
('9', '0', '3', '2023-12-31', '24038', '', '-250618.7', '0', '0', NULL, NULL, '0'),
('10', '0', '3', '2023-12-31', '2390', '', '-85462.34', '0', '0', NULL, NULL, '0'),
('11', '0', '3', '2023-12-31', '2100', '', '-50002', '0', '0', '3', '117', '0'),
('12', '0', '3', '2023-12-31', '2100', '', '-7.5', '0', '0', '3', '58', '0'),
('13', '0', '3', '2023-12-31', '2100', '', '734.68', '0', '0', '3', '52', '0'),
('14', '0', '3', '2023-12-31', '2100', '', '-443.86', '0', '0', '3', '124', '0'),
('15', '0', '3', '2023-12-31', '2100', '', '1417.5', '0', '0', '3', '115', '0'),
('16', '0', '3', '2023-12-31', '2100', '', '-7450', '0', '0', '3', '45', '0'),
('17', '0', '3', '2023-12-31', '24032', '', '-48319.2', '0', '0', NULL, NULL, '0'),
('18', '0', '3', '2023-12-31', '24034', '', '-1897.76', '0', '0', NULL, NULL, '0'),
('19', '0', '3', '2023-12-31', '24035', '', '-40330', '0', '0', NULL, NULL, '0'),
('20', '0', '3', '2023-12-31', '24027', '', '78000', '0', '0', NULL, NULL, '0'),
('21', '0', '3', '2023-12-31', '24029', '', '17080', '0', '0', NULL, NULL, '0'),
('22', '0', '3', '2023-12-31', '24030', '', '10000', '0', '0', NULL, NULL, '0'),
('23', '0', '3', '2023-12-31', '24031', '', '40330', '0', '0', NULL, NULL, '0'),
('24', '0', '3', '2023-12-31', '24036', '', '1870', '0', '0', NULL, NULL, '0'),
('25', '0', '3', '2023-12-31', '24010', '', '75000', '0', '0', NULL, NULL, '0'),
('26', '0', '3', '2023-12-31', '24001', '', '5900', '0', '0', '3', '98', '0'),
('27', '0', '3', '2023-12-31', '24002', '', '62', '0', '0', '3', '99', '0'),
('28', '0', '3', '2023-12-31', '24003', '', '12930.4', '0', '0', '3', '100', '0'),
('29', '0', '3', '2023-12-31', '24005', '', '1000', '0', '0', '3', '97', '0'),
('30', '0', '3', '2023-12-31', '3590', '', '240206.78', '0', '0', NULL, NULL, '0'),
('31', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('32', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('33', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('34', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('35', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('36', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('37', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('38', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('39', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('40', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('41', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('42', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('43', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('44', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('45', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('46', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('47', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('48', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('49', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('50', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('51', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('52', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('53', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('54', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('55', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('56', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('57', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('58', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('59', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('60', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('61', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('62', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('63', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('64', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('65', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('66', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('67', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('68', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('69', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('70', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('71', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('72', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('73', '0', '4', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('74', '0', '4', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('75', '0', '4', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('76', '0', '4', '2023-12-31', '000002', '', '0', '0', '0', '3', '97', '0'),
('77', '0', '4', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('78', '0', '4', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('79', '0', '4', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('80', '0', '4', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('81', '0', '4', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('82', '0', '4', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('83', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('84', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('85', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('86', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('87', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('88', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('89', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('90', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('91', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('92', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('93', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('94', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('95', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('96', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('97', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('98', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('99', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('100', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('101', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('102', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('103', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('104', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('105', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('106', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('107', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('108', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('109', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('110', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('111', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('112', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('113', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('114', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('115', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('116', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('117', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('118', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('119', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('120', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('121', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('122', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('123', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('124', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('125', '0', '5', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('126', '0', '5', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('127', '0', '5', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('128', '0', '5', '2023-12-31', '000002', '', '0', '0', '0', '3', '97', '0'),
('129', '0', '5', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('130', '0', '5', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('131', '0', '5', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('132', '0', '5', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('133', '0', '5', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('134', '0', '5', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('135', '0', '6', '2023-12-31', '2100', '', '-1526399.03', '0', '0', '3', '35', '0'),
('136', '0', '6', '2023-12-31', '1200', '', '-3390.41', '0', '0', '2', '251', '0'),
('137', '0', '6', '2023-12-31', '1200', '', '7350', '0', '0', '2', '250', '0'),
('138', '0', '6', '2023-12-31', '1200', '', '5212.96', '0', '0', '2', '18', '0'),
('139', '0', '6', '2023-12-31', '1200', '', '3675', '0', '0', '2', '249', '0'),
('140', '0', '6', '2023-12-31', '1200', '', '1700.21', '0', '0', '2', '230', '0'),
('141', '0', '6', '2023-12-31', '1200', '', '1155', '0', '0', '2', '128', '0'),
('142', '0', '6', '2023-12-31', '3590', '', '7481832.18', '0', '0', NULL, NULL, '0'),
('143', '0', '6', '2023-12-31', '3590', '', '-5971135.91', '0', '0', NULL, NULL, '0'),
('144', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('145', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('146', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('147', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('148', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('149', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('150', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('151', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('152', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('153', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('154', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('155', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('156', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('157', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('158', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('159', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('160', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('161', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('162', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('163', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('164', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('165', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('166', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('167', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('168', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('169', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('170', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('171', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('172', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('173', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('174', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('175', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('176', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('177', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('178', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('179', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('180', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('181', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('182', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('183', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('184', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('185', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('186', '0', '7', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('187', '0', '7', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('188', '0', '7', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('189', '0', '7', '2023-12-31', '000002', '', '0', '0', '0', '3', '97', '0'),
('190', '0', '7', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('191', '0', '7', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('192', '0', '7', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('193', '0', '7', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('194', '0', '7', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('195', '0', '7', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('196', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('197', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('198', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('199', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('200', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('201', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('202', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('203', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('204', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('205', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('206', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('207', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('208', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('209', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('210', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('211', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('212', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('213', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('214', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('215', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('216', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('217', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('218', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('219', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('220', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('221', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('222', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('223', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('224', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('225', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('226', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('227', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('228', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('229', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('230', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('231', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('232', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('233', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('234', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('235', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('236', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('237', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('238', '0', '8', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('239', '0', '8', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('240', '0', '8', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('241', '0', '8', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('242', '0', '8', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('243', '0', '8', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('244', '0', '8', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('245', '0', '8', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('246', '0', '8', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('247', '0', '8', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('248', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('249', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('250', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('251', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('252', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('253', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('254', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('255', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('256', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('257', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('258', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('259', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('260', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('261', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('262', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('263', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('264', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('265', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('266', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('267', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('268', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('269', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('270', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('271', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('272', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('273', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('274', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('275', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('276', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('277', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('278', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('279', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('280', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('281', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('282', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('283', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('284', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('285', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('286', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('287', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('288', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('289', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('290', '0', '9', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('291', '0', '9', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('292', '0', '9', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('293', '0', '9', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('294', '0', '9', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('295', '0', '9', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('296', '0', '9', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('297', '0', '9', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('298', '0', '9', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('299', '0', '9', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('300', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('301', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('302', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('303', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('304', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('305', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('306', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('307', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('308', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('309', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('310', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('311', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('312', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('313', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('314', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('315', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('316', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('317', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('318', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('319', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('320', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('321', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('322', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('323', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('324', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('325', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('326', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('327', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('328', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('329', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('330', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('331', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('332', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('333', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('334', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('335', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('336', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('337', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('338', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('339', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('340', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('341', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('342', '0', '10', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('343', '0', '10', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('344', '0', '10', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('345', '0', '10', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('346', '0', '10', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('347', '0', '10', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('348', '0', '10', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('349', '0', '10', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('350', '0', '10', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('351', '0', '10', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('352', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('353', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('354', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('355', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('356', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('357', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('358', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('359', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('360', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('361', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('362', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('363', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('364', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('365', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('366', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('367', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('368', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('369', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('370', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('371', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('372', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('373', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('374', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('375', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('376', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('377', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('378', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('379', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('380', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('381', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('382', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('383', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('384', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('385', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('386', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('387', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('388', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('389', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('390', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('391', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('392', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('393', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('394', '0', '11', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('395', '0', '11', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('396', '0', '11', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('397', '0', '11', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('398', '0', '11', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('399', '0', '11', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('400', '0', '11', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('401', '0', '11', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('402', '0', '11', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('403', '0', '11', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('404', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('405', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('406', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('407', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('408', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('409', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('410', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('411', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('412', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('413', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('414', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('415', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('416', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('417', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('418', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('419', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('420', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('421', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('422', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('423', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('424', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('425', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('426', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('427', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('428', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('429', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('430', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('431', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('432', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('433', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('434', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('435', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('436', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('437', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('438', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('439', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('440', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('441', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('442', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('443', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('444', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('445', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('446', '0', '12', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('447', '0', '12', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('448', '0', '12', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('449', '0', '12', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('450', '0', '12', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('451', '0', '12', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('452', '0', '12', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('453', '0', '12', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('454', '0', '12', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('455', '0', '12', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('456', '0', '12', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('457', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('458', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('459', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('460', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('461', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('462', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('463', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('464', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('465', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('466', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('467', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('468', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('469', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('470', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('471', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('472', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('473', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('474', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('475', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('476', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('477', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('478', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('479', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('480', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('481', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('482', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('483', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('484', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('485', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('486', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('487', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('488', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('489', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('490', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('491', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('492', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('493', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('494', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('495', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('496', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('497', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('498', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('499', '0', '13', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('500', '0', '13', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('501', '0', '13', '2023-12-31', '21076', '', '0', '0', '0', NULL, NULL, '0'),
('502', '0', '13', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('503', '0', '13', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('504', '0', '13', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('505', '0', '13', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('506', '0', '13', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('507', '0', '13', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('508', '0', '13', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('509', '0', '13', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('510', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '136', '0'),
('511', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '111', '0'),
('512', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '80', '0'),
('513', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '82', '0'),
('514', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '168', '0'),
('515', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '152', '0'),
('516', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '75', '0'),
('517', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '146', '0'),
('518', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '134', '0'),
('519', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '89', '0'),
('520', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '105', '0'),
('521', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '198', '0'),
('522', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '199', '0'),
('523', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '74', '0'),
('524', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '197', '0'),
('525', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '22', '0'),
('526', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '195', '0'),
('527', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '234', '0'),
('528', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '25', '0'),
('529', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '27', '0'),
('530', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '32', '0'),
('531', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '33', '0'),
('532', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '36', '0'),
('533', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '207', '0'),
('534', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '204', '0'),
('535', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '48', '0'),
('536', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '151', '0'),
('537', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '50', '0'),
('538', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '102', '0'),
('539', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '214', '0'),
('540', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '203', '0'),
('541', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '57', '0'),
('542', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '106', '0'),
('543', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '112', '0'),
('544', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '187', '0'),
('545', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '88', '0'),
('546', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '181', '0'),
('547', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '156', '0'),
('548', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '69', '0'),
('549', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '70', '0'),
('550', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '208', '0'),
('551', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '206', '0'),
('552', '0', '14', '2023-12-31', '1200', '', '0', '0', '0', '2', '72', '0'),
('553', '0', '14', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('554', '0', '14', '2023-12-31', '20001', '', '0', '0', '0', NULL, NULL, '0'),
('555', '0', '14', '2023-12-31', '000002', '', '0', '0', '0', NULL, NULL, '0'),
('556', '0', '14', '2023-12-31', '24025', '', '0', '0', '0', NULL, NULL, '0'),
('557', '0', '14', '2023-12-31', '24026', '', '0', '0', '0', NULL, NULL, '0'),
('558', '0', '14', '2023-12-31', '24008', '', '0', '0', '0', NULL, NULL, '0'),
('559', '0', '14', '2023-12-31', '24007', '', '0', '0', '0', NULL, NULL, '0'),
('560', '0', '14', '2023-12-31', '24009', '', '0', '0', '0', NULL, NULL, '0'),
('561', '0', '14', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('562', '0', '14', '2023-12-31', '3590', '', '0', '0', '0', NULL, NULL, '0'),
('563', '0', '15', '2023-12-31', '1200', '', '3055', '0', '0', '2', '136', '0'),
('564', '0', '15', '2023-12-31', '1200', '', '2498', '0', '0', '2', '111', '0'),
('565', '0', '15', '2023-12-31', '1200', '', '15767.99', '0', '0', '2', '80', '0'),
('566', '0', '15', '2023-12-31', '1200', '', '1075', '0', '0', '2', '82', '0'),
('567', '0', '15', '2023-12-31', '1200', '', '1141.3', '0', '0', '2', '168', '0'),
('568', '0', '15', '2023-12-31', '1200', '', '8400', '0', '0', '2', '152', '0'),
('569', '0', '15', '2023-12-31', '1200', '', '2625', '0', '0', '2', '75', '0'),
('570', '0', '15', '2023-12-31', '1200', '', '1050', '0', '0', '2', '146', '0'),
('571', '0', '15', '2023-12-31', '1200', '', '3150', '0', '0', '2', '134', '0'),
('572', '0', '15', '2023-12-31', '1200', '', '3675', '0', '0', '2', '89', '0'),
('573', '0', '15', '2023-12-31', '1200', '', '37250', '0', '0', '2', '105', '0'),
('574', '0', '15', '2023-12-31', '1200', '', '2342.5', '0', '0', '2', '198', '0'),
('575', '0', '15', '2023-12-31', '1200', '', '5775', '0', '0', '2', '199', '0'),
('576', '0', '15', '2023-12-31', '1200', '', '17955', '0', '0', '2', '74', '0'),
('577', '0', '15', '2023-12-31', '1200', '', '19581.25', '0', '0', '2', '197', '0'),
('578', '0', '15', '2023-12-31', '1200', '', '770', '0', '0', '2', '22', '0'),
('579', '0', '15', '2023-12-31', '1200', '', '600.08', '0', '0', '2', '195', '0'),
('580', '0', '15', '2023-12-31', '1200', '', '525', '0', '0', '2', '234', '0'),
('581', '0', '15', '2023-12-31', '1200', '', '1050', '0', '0', '2', '25', '0'),
('582', '0', '15', '2023-12-31', '1200', '', '3350', '0', '0', '2', '27', '0'),
('583', '0', '15', '2023-12-31', '1200', '', '472.5', '0', '0', '2', '32', '0'),
('584', '0', '15', '2023-12-31', '1200', '', '503.01', '0', '0', '2', '33', '0'),
('585', '0', '15', '2023-12-31', '1200', '', '33780', '0', '0', '2', '36', '0'),
('586', '0', '15', '2023-12-31', '1200', '', '899.85', '0', '0', '2', '207', '0'),
('587', '0', '15', '2023-12-31', '1200', '', '5820', '0', '0', '2', '204', '0'),
('588', '0', '15', '2023-12-31', '1200', '', '-100', '0', '0', '2', '48', '0'),
('589', '0', '15', '2023-12-31', '1200', '', '2636', '0', '0', '2', '151', '0'),
('590', '0', '15', '2023-12-31', '1200', '', '325', '0', '0', '2', '50', '0'),
('591', '0', '15', '2023-12-31', '1200', '', '3937.71', '0', '0', '2', '102', '0'),
('592', '0', '15', '2023-12-31', '1200', '', '262.5', '0', '0', '2', '214', '0'),
('593', '0', '15', '2023-12-31', '1200', '', '1680', '0', '0', '2', '203', '0'),
('594', '0', '15', '2023-12-31', '1200', '', '3502.5', '0', '0', '2', '57', '0'),
('595', '0', '15', '2023-12-31', '1200', '', '12904.5', '0', '0', '2', '106', '0'),
('596', '0', '15', '2023-12-31', '1200', '', '-231.74', '0', '0', '2', '112', '0'),
('597', '0', '15', '2023-12-31', '1200', '', '3167.5', '0', '0', '2', '187', '0'),
('598', '0', '15', '2023-12-31', '1200', '', '892.5', '0', '0', '2', '88', '0'),
('599', '0', '15', '2023-12-31', '1200', '', '1600.2', '0', '0', '2', '181', '0'),
('600', '0', '15', '2023-12-31', '1200', '', '3675', '0', '0', '2', '156', '0'),
('601', '0', '15', '2023-12-31', '1200', '', '42058.16', '0', '0', '2', '69', '0'),
('602', '0', '15', '2023-12-31', '1200', '', '9636', '0', '0', '2', '70', '0'),
('603', '0', '15', '2023-12-31', '1200', '', '499.65', '0', '0', '2', '208', '0'),
('604', '0', '15', '2023-12-31', '1200', '', '1050', '0', '0', '2', '206', '0'),
('605', '0', '15', '2023-12-31', '1200', '', '16682.46', '0', '0', '2', '72', '0'),
('606', '0', '15', '2023-12-31', '20001', '', '35.5', '0', '0', NULL, NULL, '0'),
('607', '0', '15', '2023-12-31', '21076', '', '-14050.62', '0', '0', NULL, NULL, '0'),
('608', '0', '15', '2023-12-31', '000002', '', '37388.93', '0', '0', NULL, NULL, '0'),
('609', '0', '15', '2023-12-31', '24025', '', '90795', '0', '0', NULL, NULL, '0'),
('610', '0', '15', '2023-12-31', '24026', '', '-9537.5', '0', '0', NULL, NULL, '0'),
('611', '0', '15', '2023-12-31', '24008', '', '4660', '0', '0', NULL, NULL, '0'),
('612', '0', '15', '2023-12-31', '24007', '', '4000', '0', '0', NULL, NULL, '0'),
('613', '0', '15', '2023-12-31', '24009', '', '10000', '0', '0', NULL, NULL, '0'),
('614', '0', '15', '2023-12-31', '3590', '', '-428681.97', '0', '0', NULL, NULL, '0'),
('615', '0', '15', '2023-12-31', '3590', '', '28101.24', '0', '0', NULL, NULL, '0');

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) DEFAULT NULL,
  `charge_group` int(11) NOT NULL,
  `rate` double DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(1000) NOT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('7', 'No Sales Group', '0');

### Structure of table `0_icon` ###

DROP TABLE IF EXISTS `0_icon`;

CREATE TABLE `0_icon` (
  `icon_id` int(255) NOT NULL AUTO_INCREMENT,
  `icon_title` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `icon_img` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `icon_img_arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `arabic_icon_title` varchar(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`icon_id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci ;

### Data of table `0_icon` ###

INSERT INTO `0_icon` VALUES
('1', 'Sales Quotation Entry', 'glyphicon glyphicon-pencil', '', 'إدخال خطاب تسعير مبيعات جديد'),
('2', 'Sales Order Entry', 'glyphicon glyphicon-file', '', 'إدخال أمر مبيعات'),
('3', 'Direct Delivery', 'glyphicon glyphicon-random', '', 'التسليم المباشرة'),
('4', 'Direct Invoice', 'glyphicon glyphicon-paste ', '', 'الفاتورة المباشرة'),
('5', 'Delivery Against Sales Orders', 'glyphicon glyphicon-retweet', '', 'التسليم مقابل أوامر المبيعات'),
('6', 'Invoice Against Sales Delivery', 'glyphicon glyphicon-save-file', '', 'فاتورة مقابل تسليم المبيعات'),
('7', 'Invoice Prepaid Orders', 'glyphicon glyphicon-edit', '', 'فاتورة أوامر الدفع المسبق'),
('8', 'Template Delivery', 'glyphicon glyphicon-inbox', '', 'تسليم النموذج'),
('9', 'Template Invoice', 'glyphicon glyphicon-copy', '', 'فاتورة النموذج'),
('10', 'Create and Print Recurrent Invoices', 'glyphicon glyphicon-print', '', 'إنشاء و طباعة الفواتير المتكررة'),
('11', 'Customer Payments', 'glyphicon glyphicon-usd', '', 'مدفوعات العملاء'),
('12', 'Customer Credit Notes', 'glyphicon glyphicon-open-file', '', 'إشعارات ائتمان العميل'),
('13', 'Allocate Customer Payments or Credit Notes', 'glyphicon glyphicon-ok-circle', '', 'تخصيص مدفوعات العميل أو إشعارات الائتمان'),
('14', 'Sales Quotation Inquiry', 'glyphicon glyphicon-refresh', '', 'استعلام عن عروض أسعار المبيعات'),
('15', 'Sales Order Inquiry', 'glyphicon glyphicon-book', '', 'استعلام عن طلب المبيعات'),
('16', 'Customer Transaction Inquiry', 'glyphicon glyphicon-cloud-download', '', 'استعلام عن مدفوعات العملاء'),
('17', 'Customer Allocation Inquiry', 'glyphicon glyphicon-credit-card', '', 'استعلام عن تخصيص العملاء'),
('18', 'Customer and Sales Reports', 'fa fa-files-o', '', 'تقارير العملاء والمبيعات'),
('19', 'Add and Manage Customers', 'ionicons ion-android-person-add', '', 'إضافة و إدارة العملاء'),
('20', 'Customer Branches', 'fa fa-building-o', '', 'فروع العملاء'),
('21', 'Sales Groups', 'fa fa-users', '', 'مجموعات المبيعات'),
('22', 'Recurrent Invoices', 'fa fa-wpforms', '', 'الفواتير المتكررة'),
('23', 'Sales Types', 'fa fa-clone', '', 'أنواع المبيعات'),
('24', 'Sales Persons', 'fa fa-male fa-lg', '', 'مندوبي المبيعات'),
('25', 'Sales Areas', 'fa fa-area-chart', '', 'مناطق المبيعات'),
('26', 'Credit Status Setup', 'fa fa-cogs', '', 'إعداد حالة الآئتمان'),
('27', 'Purchase Order Entry', 'fa fa-shopping-cart', '', 'إدخال أمر الشراء'),
('28', 'Outstanding Purchase Orders Maintenance', 'fa fa-recycle', '', 'صيانة أوامر الشراء المعلقة'),
('29', 'Direct GRN', 'glyphicon glyphicon-list-alt', '', 'GRN المباشر'),
('30', 'Direct Supplier Invoice', 'glyphicon glyphicon-duplicate', '', 'فاتورة المورد المباشرة'),
('31', 'Payments to Suppliers', 'ionicons ion-cash', '', 'المدفوعات للموردين'),
('32', 'Supplier Invoices', 'glyphicon glyphicon-duplicate', '', 'فواتير الموردين'),
('33', 'Supplier Credit Notes', 'fa fa-calendar-check-o', '', 'إشعارات ائتمان المورد'),
('34', 'Allocate Supplier Payments or Credit Notes', 'ionicons ion-android-done-all', '', 'تخصيص مدفوعات المورد أو إشعارات الائتمان'),
('35', 'Purchase Orders Inquiry', 'fa fa-check-square-o', '', 'الإستعلام عن أوامر الشراء'),
('36', 'Supplier Transaction Inquiry', 'ionicons ion-archive', '', 'استعلام عن معاملات المورد'),
('37', 'Supplier Allocation Inquiry', 'fa fa-pie-chart', '', 'الإستعلام عن حركات تخصيص الدفعات و الإشعارات الدائنة للمورد '),
('38', 'Supplier and Purchasing Reports', 'ionicons ion-android-cart', '', 'تقارير الموردين و المشتريات'),
('39', 'Suppliers', 'ionicons ion-android-contacts', '', 'الموردين'),
('40', 'Inventory Location Transfers', 'glyphicon glyphicon-map-marker', '', 'التحويلات المخزنية من و إلى مواقع التخزين'),
('41', 'Inventory Adjustments', 'fa fa-sliders', '', 'قيود التعديل مخزنية'),
('42', 'Inventory Item Movements', 'ionicons ion-cube', '', 'حركات بنود المخزون'),
('43', 'Inventory Reports', 'fa fa-clipboard', '', 'تقارير المخزون'),
('44', 'Inventory Item Status', 'fa fa-bar-chart', '', 'حالة بنود المخزون'),
('45', 'Items', 'fa fa-cubes', '', 'البنود المخزنية'),
('46', 'Foreign Item Codes', 'fa fa-barcode', '', 'أكواد البنود المخزنية الأجنبية'),
('47', 'Sales Kits', 'fa fa-dropbox', '', 'أدوات البيع'),
('48', 'Item Categories', 'fa fa-sitemap', '', 'تصنيفات بنود المخزون'),
('49', 'Inventory Locations', 'fa fa-map-o', '', 'مواقع التخزين للمخزون'),
('50', 'Units of Measure', 'ionicons ion-ios-speedometer', '', 'وحدات القياس'),
('51', 'Reorder Levels', 'fa fa-exchange', '', 'مستويات إعادة الطلب'),
('52', 'Sales Pricing', 'glyphicon glyphicon-tags', '', 'التسعير البيعي'),
('53', 'Purchasing Pricing', 'glyphicon glyphicon-gbp', '', 'التسعير الشرائي'),
('54', 'Standard Costs', 'fa fa-money', '', 'التكاليف المعيارية'),
('55', 'Work Order Entry', 'ionicons ion-ios-compose', '', 'إدخال أوامر التشغيل'),
('56', 'Outstanding Work Orders', 'fa fa-hourglass-end', '', 'أوامر التشغيل المتأخرة'),
('57', 'Costed Bill Of Material Inquiry', 'fa fa-file-text-o', '', 'الإستعلام عن تكاليف قائمة تركيبة المواد'),
('58', 'Inventory Item Where Used Inquiry', 'fa fa-file-archive-o', '', 'الإستعلام عن البنود المخزنية التي تم أستخدامها'),
('59', 'fa fa-refresh', 'Work Order Inquiry', '', 'fa fa تحديث'),
('60', 'Manufacturing Reports', 'fa fa-folder-open', '', 'تقارير العمليات التصنيعية'),
('61', 'Work Order Inquiry', 'glyphicon glyphicon-briefcase', '', 'الاستعلام عن أوامر التشغيل'),
('62', 'Bills Of Material', 'fa fa-file-excel-o', '', 'قائمة تركيبة المواد للبنود المخزنية المصنعة'),
('63', 'Work Centres', 'fa fa-hospital-o', '', 'مراكز التكلفة'),
('64', 'Fixed Assets Purchase', 'fa fa-car', '', 'شراء الأصول الثابتة'),
('65', 'Fixed Assets Location Transfers', 'fa fa-home', '', 'تحويلات موقع الأصول الثابتة'),
('66', 'Fixed Assets Disposal', 'glyphicon glyphicon-trash', '', 'التصرف في الأصول الثابتة'),
('67', 'Fixed Assets Sale', 'fa fa-tag', '', 'بيع الأصول الثابتة'),
('68', 'Process Depreciation', 'fa fa-line-chart', '', 'إهلاك العملية'),
('69', 'Fixed Assets Movements', 'fa fa-tasks', '', 'حركات الأصول الثابتة'),
('70', 'Fixed Assets Inquiry', 'fa fa-search', '', 'استعلام عن الأصول الثابتة'),
('71', 'Fixed Assets Reports', 'fa fa-archive', '', 'تقارير الأصول الثابتة'),
('72', 'Fixed Assets', 'fa fa-building', '', 'الأصول'),
('73', 'Fixed Assets Locations', 'fa fa-map-signs', '', 'مواقع الأصول الثابتة'),
('74', 'Fixed Assets Categories', 'glyphicon glyphicon-th-list', '', 'فئات الأصول الثابتة'),
('75', 'Fixed Assets Classes', 'fa fa-sort-amount-asc', '', 'فئات الأصول الثابتة'),
('76', 'Dimension Entry', 'glyphicon glyphicon-blackboard', '', 'إدخال القطاع التحليلي'),
('77', 'Outstanding Dimensions', 'glyphicon glyphicon-thumbs-down', '', 'القطاعات التحليلية المنتهية'),
('78', 'Dimension Inquiry', 'glyphicon glyphicon-zoom-in', '', 'الإستعلام عن القطاعات التحليلية'),
('79', 'Dimension Reports', 'glyphicon glyphicon-copy', '', 'تقارير القطاعات التحليلية'),
('80', 'Dimension Tags', 'ionicons ion-ios-pricetags', '', 'القطاعات التحليلية و الكلمات الدلالية'),
('81', 'Payments', 'fa fa-credit-card', '', 'الدفعات'),
('82', 'Deposits', 'fa fa-check-square-o', '', 'الإيداعات'),
('83', 'Bank Account Transfers', 'fa fa-university', '', 'التحويل بين الحسابات البنكية'),
('84', 'Journal Entry', 'fa fa-pencil-square-o', '', 'إدخال قيود اليومية العامة'),
('85', 'Budget Entry', 'fa fa-repeat', '', 'إدخال الموازنات'),
('86', 'Reconcile Bank Account', 'fa fa-handshake-o', '', 'تسوية الحساب البنكي'),
('87', 'Revenue / Costs Accruals', 'fa fa-area-chart', '', 'الإيرادات / المصروفات المستحقة'),
('88', 'Journal Inquiry', 'fa fa-comments', '', 'الاستعلام عن دفتر اليومية'),
('89', 'GL Inquiry', 'fa fa-share-square-o', '', 'الاستعلام عن الأستاذ العام'),
('90', 'Bank Account Inquiry', 'fa fa-reply-all', '', 'الإستعلام عن الحسابات البنكية'),
('91', 'Tax Inquiry', 'fa fa-calendar-check-o', '', 'الأستعلام عن الضريبة'),
('92', 'Trial Balance', 'glyphicon glyphicon-repeat', '', 'ميزان المراجعة'),
('93', 'Balance Sheet Drilldown', 'glyphicon glyphicon-menu-down', '', 'القائمة المختصرة للميزانية العمومية'),
('94', 'Profit and Loss Drilldown', 'ionicons ion-stats-bars', '', 'القائمة المختصرة للأرباح و الخسائر'),
('95', 'Banking Reports', 'fa fa-print', '', 'التقارير البنكية'),
('96', 'General Ledger Reports', 'ionicons ion-android-clipboard', '', 'تقارير الأستاذ العام'),
('97', 'Bank Accounts', 'icomoon icon-library', '', 'الحسابات البنكية'),
('98', 'Quick Entries', 'icomoon icon-point-right', '', 'الإدخالات السريعة'),
('99', 'Account Tags', 'icomoon icon-tags', '', 'الكلمات الدلالية للحساب'),
('100', 'Currencies', 'icomoon icon-coin', '', 'العملات'),
('101', 'Exchange Rates', 'icomoon icon-loop-3', '', 'معدل تبادل العملات'),
('102', 'GL Accounts', 'icomoon icon-drawer-2', '', 'حسابات GL'),
('103', 'GL Account Groups', 'fi-page-multiple', '', 'مجموعات حساب GL'),
('104', 'GL Account Classes', 'icomoon icon-table-2', '', 'فئات حساب دفتر الأستاذ العام'),
('105', 'Closing GL Transactions', 'icomoon icon-drawer-3', '', 'إغلاق معاملات دفتر الأستاذ العام'),
('106', 'Revaluation of Currency Accounts', 'glyphicon glyphicon-euro', '', 'إعادة تقييم حسابات العملات'),
('107', 'Import CSV Items', 'glyphicon glyphicon-import', '', 'استيراد عناصر CSV'),
('108', 'Company Setup', 'ionicons ion-android-settings', 'إدخال أمر الشراء', 'إعدادات الشركة'),
('109', 'Quick Access', 'glyphicon glyphicon-th', '', 'الوصول السريع'),
('110', 'User Accounts Setup', 'icomoon icon-user-4', '', 'إعدادات حسابات المستخدمين'),
('111', 'Access Setup', 'glyphicon glyphicon-download-alt', '', 'إعدادات الوصول'),
('112', 'Display Setup', 'fa fa-cogs', '', 'إعدادات العرض'),
('113', 'Transaction References', 'fa fa-random', '', 'مراجع المعاملات'),
('114', 'Taxes', 'icomoon icon-file-css', '', 'الضرائب'),
('115', 'Tax Groups', 'icomoon icon-expand', '', 'المجموعات الضريبية'),
('116', 'Item Tax Types', 'icomoon icon-checkbox-partial', '', 'أنواع ضريبة العنصر'),
('117', 'System and General GL Setup', 'icomoon icon-address-book', '', 'النظام وإعداد GL العام'),
('118', 'Fiscal Years', 'fa fa-calendar', '', 'السنوات المالية'),
('119', 'Print Profiles', 'fa fa-clipboard', '', 'طباعة التشكيلات'),
('120', 'Payment Terms', 'icomoon icon-file-powerpoint', '', 'شروط الدفع'),
('121', 'Shipping Company', 'ionicons ion-android-boat', '', 'شركة الشحن'),
('122', 'Points of Sale', 'icomoon icon-stats', '', 'نقاط البيع'),
('123', 'Printers', 'icomoon icon-print', '', 'طابعات'),
('124', 'Void a Transaction', 'icomoon icon-redo', '', 'صفقة باطلة'),
('125', 'View or Print Transactions', 'icomoon icon-profile', '', ' عرض أو طباعة المعاملات'),
('126', 'Attach Documents', 'icomoon icon-attachment', '', 'أرفاق المستندات'),
('127', 'System Diagnostics', 'icomoon icon-laptop', '', 'تشخيصات النظام'),
('128', 'Backup and Restore', 'fi-archive', '', 'النسخ الاحتياطي واستعادة'),
('129', 'Create/Update Companies', 'glyphicon glyphicon-transfer', '', 'إنشاء و تحديث الشركات'),
('130', 'Install/Activate Themes', 'icomoon icon-indent-increase', '', 'تثبيت / تنشيط السمات'),
('131', 'Install/Activate Chart of Accounts', 'icomoon icon-bars', '', 'تثبيت / تنشيط مخطط الحسابات'),
('132', 'Software Upgrade', 'icomoon icon-loop-2', '', 'تحديث البرنامج'),
('133', 'Install/Update Languages', 'fa fa-language', '', 'تثبيت / تحديث اللغات'),
('134', 'Install/Activate Extensions', 'fa fa-usb', '', 'تثبيت أو تفعيل الأمتدادات '),
('137', 'Import CSV Customer', 'glyphicon glyphicon-import', '', 'استيراد عميل CSV'),
('138', 'Material Requisitions', '', '', 'طلبات المواد'),
('139', 'Purchase Requisitions', '', '', 'طلبات الشراء'),
('140', 'Supplier RFQ', '', '', 'المورد RFQ'),
('141', 'Material Requisition Dashboard', '', '', 'لوحة معلومات طلب المواد'),
('142', 'Purchase Requisition Dashboard', '', '', 'لوحة معلومات طلب الشراء'),
('143', 'Comparision Report Dashboard', '', '', 'لوحة معلومات تقرير المقارنة'),
('144', 'Import CSV Supplier', '', '', 'استيراد مورد CSV'),
('145', 'Adjustments and Transfer inquiry', '', '', 'استعلام عن التعديلات والتحويلات'),
('146', 'PDC Management', '', '', 'إدارة PDC'),
('147', 'Attendances', '', '', 'الحضور'),
('148', 'Leave', '', '', 'غادر'),
('149', 'Payroll Allocation', '', '', 'تخصيص الرواتب'),
('150', 'Document Expiration', '', '', 'انتهاء صلاحية المستند'),
('151', 'Employee Advances', '', '', 'سلف الموظف'),
('152', 'Timesheet', '', '', 'ورقة التوقيت'),
('153', 'Leave  Inquiry', '', '', 'استعلام عن الإجازة'),
('154', 'Payroll Dashboard', '', '', 'لوحة تحكم الرواتب'),
('155', 'Employee Document Inquiry', '', '', 'استعلام عن مستندات الموظف'),
('156', 'Employee Reports', '', '', 'تقارير الموظفين'),
('157', 'Employees', '', '', 'الموظفين'),
('158', 'Document Type', '', '', 'نوع الوثيقة'),
('159', 'Departments', '', '', 'الإدارات'),
('160', 'Manage Overtime', '', '', 'إدارة الوقت الإضافي'),
('161', 'Default Settings', '', '', 'الإعدادات الافتراضية'),
('162', 'Designation', '', '', 'تعيين'),
('163', 'Salary Structure', '', '', 'هيكلية الرواتب'),
('164', 'Create Allowance', '', '', 'إنشاء بدل'),
('165', 'Create Deduction', '', '', 'إنشاء خصم'),
('166', 'Overtime And Weekends', '', '', 'العمل الإضافي وعطلات نهاية الأسبوع'),
('167', 'Holidays', '', '', 'العطل'),
('168', 'Transactions', '', '', 'الحركات'),
('169', 'Inquiries and Reports', '', '', 'الإستعلامات و التقارير'),
('170', 'Maintenance', '', '', 'نماذج الأدخال الأساسية'),
('171', 'Pricing and Costs', '', '', 'التسعير البيعي و التكاليفي'),
('172', 'Loyality Point Features', '', '', 'ميزات نقطة الولاء'),
('173', 'Auto Email Reports', '', '', 'تقارير تلقائية بالبريد الإلكتروني'),
('174', 'Auto Email Reports Dashboard', '', '', 'لوحة معلومات تقارير البريد الإلكتروني التلقائي'),
('175', 'Signature', '', '', 'التوقيع'),
('176', 'Signature Dashboard', '', '', 'لوحة التوقيع'),
('177', 'Report Format', '', '', 'شكل التقرير'),
('178', 'Reports Shorctut', '', '', 'اختصار التقارير'),
('179', 'Multiple Company Setup', '', '', 'إعداد شركة متعددة'),
('180', 'Send SMS', '', '', 'أرسل رسالة نصية قصيرة'),
('181', 'Mail sending setup', '', '', 'إعداد إرسال البريد'),
('182', 'Miscellaneous', '', '', 'متنوعة'),
('183', 'Contact Categories', '', '', 'تصنيفات الاتصالات'),
('184', 'Attach Documents (New)', '', '', 'إرفاق المستندات (جديد)'),
('185', 'Document Attachment Inquiry', '', '', 'استعلام عن مرفق الوثيقة'),
('187', 'Reports Shortcut', '', '', 'اختصار التقارير'),
('188', 'Transaction ', '', '', 'عملية تجارية\r\n'),
('189', 'Search Item Hot Key', '', '', 'مفتاح البحث السريع لعنصر البحث'),
('190', 'New Sale', '', '', 'بيع جديد'),
('191', 'Import Attendances', '', '', 'حضور الاستيراد'),
('192', 'check In', '', '', 'تحقق في');

### Structure of table `0_inquiry_type` ###

DROP TABLE IF EXISTS `0_inquiry_type`;

CREATE TABLE `0_inquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inquiry_type` varchar(150) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_inquiry_type` ###

INSERT INTO `0_inquiry_type` VALUES
('1', 'Government', '0'),
('2', 'Residential', '0'),
('3', 'Retail', '0'),
('4', 'Commercial', '0');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `description` varchar(200) NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=591 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', 'EXP-001', 'EXP-001', 'Administration Expenses Non Taxable', '1', '1', '0', '0'),
('2', 'EXP-002', 'EXP-002', 'Agency Fee Taxable', '1', '1', '0', '0'),
('3', 'EXP-003', 'EXP-003', 'Air Tickets Expenses Non Taxable', '1', '1', '0', '0'),
('4', 'EXP-004', 'EXP-004', 'Bad Debts', '1', '1', '0', '0'),
('5', 'EXP-005', 'EXP-005', 'Bank Charges', '1', '1', '0', '0'),
('6', 'EXP-006', 'EXP-006', 'Cafu Expenses Taxable', '1', '1', '0', '0'),
('7', 'EXP-007', 'EXP-007', 'Cafu Expenses  Non Taxable', '1', '1', '0', '0'),
('8', 'EXP-008', 'EXP-008', 'Carriage Inward Non Taxable', '1', '1', '0', '0'),
('9', 'EXP-009', 'EXP-009', 'Carriage Inward  Taxable', '1', '1', '0', '0'),
('10', 'EXP-010', 'EXP-010', 'Carriage Outward Non Taxable', '1', '1', '0', '0'),
('11', 'EXP-011', 'EXP-011', 'Carriage Outward Taxable', '1', '1', '0', '0'),
('12', 'EXP-012', 'EXP-012', 'Commission on contract', '1', '1', '0', '0'),
('13', 'EXP-013', 'EXP-013', 'Commission on Referral', '1', '1', '0', '0'),
('14', 'EXP-014', 'EXP-014', 'Delivery Charges Non Taxable', '1', '1', '0', '0'),
('15', 'EXP-015', 'EXP-015', 'Depreciation Expense', '1', '1', '0', '0'),
('16', 'EXP-016', 'EXP-016', 'DEWA Expense Non Taxable', '1', '1', '0', '0'),
('17', 'EXP-017', 'EXP-017', 'DEWA Expense Taxable', '1', '1', '0', '0'),
('18', 'EXP-018', 'EXP-018', 'Discount Allowed non taxable', '1', '1', '0', '0'),
('19', 'EXP-019', 'EXP-019', 'Ejari Expense Non Taxable', '1', '1', '0', '0'),
('20', 'EXP-021', 'EXP-021', 'Etisalat Expense Non Taxable', '1', '1', '0', '0'),
('21', 'EXP-022', 'EXP-022', 'Etisalat Expense Taxable', '1', '1', '0', '0'),
('22', 'EXP-023', 'EXP-023', 'Exchange Commission Expenses', '1', '1', '0', '0'),
('23', 'EXP-024', 'EXP-024', 'Fuel &amp; Transportation Expense Taxable', '1', '1', '0', '0'),
('24', 'EXP-025', 'EXP-025', 'Fuel &amp; Transportation Expense Non Taxable', '1', '1', '0', '0'),
('25', 'EXP-026', 'EXP-026', 'Fuel Expense - G-56609 (Imran)  Taxable', '1', '1', '0', '0'),
('26', 'EXP-027', 'EXP-027', 'Fuel Expense - G-56609 (Imran) Non Taxable', '1', '1', '0', '0'),
('27', 'EXP-028', 'EXP-028', 'Fuel Expense - P-25757 (Arslan) Non Taxable', '1', '1', '0', '0'),
('28', 'EXP-029', 'EXP-029', 'Fuel Expense - P-25757 (Arslan) Taxable', '1', '1', '0', '0'),
('29', 'EXP-030', 'EXP-030', 'Fuel Expense JAC S -77609  Taxable', '1', '1', '0', '0'),
('30', 'EXP-031', 'EXP-031', 'Fuel Expense JAC S -77609 Non Taxable', '1', '1', '0', '0'),
('31', 'EXP-032', 'EXP-032', 'Fuel Expense P-26138 (Van) Non Taxable', '1', '1', '0', '0'),
('32', 'EXP-033', 'EXP-033', 'Fuel Expense P-26138 (Van) Taxable', '1', '1', '0', '0'),
('33', 'EXP-034', 'EXP-034', 'Fuel Expense R-45327 Non Taxable', '1', '1', '0', '0'),
('34', 'EXP-035', 'EXP-035', 'Fuel Expense R-45327 Taxable', '1', '1', '0', '0'),
('35', 'EXP-036', 'EXP-036', 'General Expense Non Taxable', '1', '1', '0', '0'),
('36', 'EXP-037', 'EXP-037', 'General Expense Taxable', '1', '1', '0', '0'),
('37', 'EXP-038', 'EXP-038', 'IT Services Expense Taxable', '1', '1', '0', '0'),
('38', 'EXP-039', 'EXP-039', 'IT Services Expense Non Taxable', '1', '1', '0', '0'),
('39', 'EXP-040', 'EXP-040', 'Loading Unloading Charges Non Taxable', '1', '1', '0', '0'),
('40', 'EXP-041', 'EXP-041', 'Medical Expenses Non Taxable', '1', '1', '0', '0'),
('41', 'EXP-042', 'EXP-042', 'Membership and Renewal Expense Non Taxable', '1', '1', '0', '0'),
('42', 'EXP-043', 'EXP-043', 'Mobile Expenses Non Taxable', '1', '1', '0', '0'),
('43', 'EXP-044', 'EXP-044', 'Network Charges Expense Non Taxable', '1', '1', '0', '0'),
('44', 'EXP-045', 'EXP-045', 'Office Maintenance Expense Taxable', '1', '1', '0', '0'),
('45', 'EXP-046', 'EXP-046', 'Office Maintenance Non Taxable', '1', '1', '0', '0'),
('46', 'EXP-047', 'EXP-047', 'Office Supplies &amp; Stationery Non Taxable', '1', '1', '0', '0'),
('47', 'EXP-048', 'EXP-048', 'Office Supplies and Stationary Expenses Taxable', '1', '1', '0', '0'),
('48', 'EXP-049', 'EXP-049', 'Parking Fees', '1', '1', '0', '0'),
('49', 'EXP-050', 'EXP-050', 'Post Office Expense Non Taxable', '1', '1', '0', '0'),
('50', 'EXP-051', 'EXP-051', 'Repair Maintenance Vehicle Non Taxable', '1', '1', '0', '0'),
('51', 'EXP-052', 'EXP-052', 'Repair Maintenance Vehicle Taxable', '1', '1', '0', '0'),
('52', 'EXP-053', 'EXP-053', 'Repair Maintenance R-45327 -Vehicles Non Taxable', '1', '1', '0', '0'),
('53', 'EXP-054', 'EXP-054', 'Repair Maintenance R-45327 -Vehicles Taxable', '1', '1', '0', '0'),
('54', 'EXP-055', 'EXP-055', 'Repair Maintenance(P-26138) Vehicles  Non Taxable', '1', '1', '0', '0'),
('55', 'EXP-056', 'EXP-056', 'Repair Maintenance(P-26138) -Vehicles Taxable', '1', '1', '0', '0'),
('56', 'EXP-057', 'EXP-057', 'Repair MaintenanceP-25757 -Vehicle Taxable', '1', '1', '0', '0'),
('57', 'EXP-058', 'EXP-058', 'Repair MaintenanceP-25757 -Vehicles Non Taxable', '1', '1', '0', '0'),
('58', 'EXP-059', 'EXP-059', 'Repair MaintenanceP-56609 -Vehicles Non Taxable', '1', '1', '0', '0'),
('59', 'EXP-060', 'EXP-060', 'Repair MaintenanceP-56609 -Vehicles Taxable', '1', '1', '0', '0'),
('60', 'EXP-061', 'EXP-061', 'Salik Expenses', '1', '1', '0', '0'),
('61', 'EXP-062', 'EXP-062', 'Selling &amp; Marketing Expenses', '1', '1', '0', '0'),
('62', 'EXP-063', 'EXP-063', 'Shipping &amp; Handling Expense', '1', '1', '0', '0'),
('63', 'EXP-064', 'EXP-064', 'Sponsorship Fee', '1', '1', '0', '0'),
('64', 'EXP-065', 'EXP-065', 'Subscription Fees - Taxable', '1', '1', '0', '0'),
('65', 'EXP-066', 'EXP-066', 'Taxi Pick Up Expense', '1', '1', '0', '0'),
('66', 'EXP-067', 'EXP-067', 'Telephone', '1', '1', '0', '0'),
('67', 'EXP-069', 'EXP-069', 'Traffic Fines', '1', '1', '0', '0'),
('68', 'EXP-070', 'EXP-070', 'Transportation Expenses', '1', '1', '0', '0'),
('69', 'EXP-071', 'EXP-071', 'Vehicle Insurance Expense Non Taxable', '1', '1', '0', '0'),
('70', 'EXP-072', 'EXP-072', 'Vehicle Insurance Expense Taxable', '1', '1', '0', '0'),
('71', 'EXP-073', 'EXP-073', 'Vehicle Renewal Expense Taxable', '1', '1', '0', '0'),
('72', 'EXP-074', 'EXP-074', 'Vehicle Renewal Expense Non Taxable', '1', '1', '0', '0'),
('73', 'EXP-075', 'EXP-075', 'Visa &amp; Renewables - Abdulla Nepali MXTS', '1', '1', '0', '0'),
('74', 'EXP-076', 'EXP-076', 'Visa &amp; Renewables - Abid MXTS', '1', '1', '0', '0'),
('75', 'EXP-077', 'EXP-077', 'Visa &amp; Renewables - Afaq Mxts', '1', '1', '0', '0'),
('76', 'EXP-078', 'EXP-078', 'Visa &amp; Renewables - Akbar MXT', '1', '1', '0', '0'),
('77', 'EXP-079', 'EXP-079', 'Visa &amp; Renewables - Arslan MXTS', '1', '1', '0', '0'),
('78', 'EXP-080', 'EXP-080', 'Visa &amp; Renewables - Imran MXTS', '1', '1', '0', '0'),
('79', 'EXP-081', 'EXP-081', 'Visa &amp; Renewables - Shakeel Ahmed MXT', '1', '1', '0', '0'),
('80', 'EXP-082', 'EXP-082', 'Visa &amp; Renewables - Usama MXTS', '1', '1', '0', '0'),
('81', 'EXP-083', 'EXP-083', 'Visa &amp; Renewables -Bir Singh', '1', '1', '0', '0'),
('82', 'EXP-084', 'EXP-084', 'Visa Processing Charges - Taxable', '1', '1', '0', '0'),
('83', 'S-001', 'S-001', 'Electrical Work (Job)', '2', '1', '0', '0'),
('84', 'S-002', 'S-002', 'External Painting (Job)', '2', '1', '0', '0'),
('85', 'S-003', 'S-003', 'External Painting (sqm)', '2', '1', '0', '0'),
('86', 'S-004', 'S-004', 'Internal Painting (Job)', '2', '1', '0', '0'),
('87', 'S-005', 'S-005', 'Internal Painting (sqm)', '2', '1', '0', '0'),
('88', 'S-006', 'S-006', 'Item', '2', '1', '0', '0'),
('89', 'S-007', 'S-007', 'llaza Awning Installation(Job)', '2', '1', '0', '0'),
('90', 'S-008', 'S-008', 'LLAZA AWNING REPAIR', '2', '1', '0', '0'),
('91', 'S-009', 'S-009', 'Maintenance Work (Job)', '2', '1', '0', '0'),
('92', 'S-010', 'S-010', 'Painting  Work (SQM)', '2', '1', '0', '0'),
('93', 'S-011', 'S-011', 'Painting Job', '2', '1', '0', '0'),
('94', 'S-012', 'S-012', 'Stitching Job', '2', '1', '0', '0'),
('95', 'S-013', 'S-013', 'Supply &amp; Apply (Job)', '2', '1', '0', '0'),
('96', 'S-014', 'S-014', 'Supply &amp; Apply (sqm)', '2', '1', '0', '0'),
('97', 'S-015', 'S-015', 'Supply &amp; Installation (Job)', '2', '1', '0', '0'),
('98', 'S-016', 'S-016', 'Supply &amp; Installation (sqm)', '2', '1', '0', '0'),
('99', 'S-017', 'S-017', 'Wallpaper Installation (Job)', '2', '1', '0', '0'),
('100', 'S-018', 'S-018', 'Wallpaper Installation (sqm)', '2', '1', '0', '0'),
('101', 'I-001', 'I-001', 'Ap Berger Royale Play Artistica  Clay  20kg', '2', '1', '0', '0'),
('102', 'I-002', 'I-002', 'Ap Berger Royale Play Artistica Rust - Base Coat 1 LTR', '2', '1', '0', '0'),
('103', 'I-003', 'I-003', 'A P  Berger  Value Super emulsion  off white   20 kg', '2', '1', '0', '0'),
('104', 'I-004', 'I-004', 'A P  Berger Royale Marmorino Fine R4074A (CW 9455) Cement Finish) 20 kg', '2', '1', '0', '0'),
('105', 'I-005', 'I-005', 'A P Berger  Royale play Artistica Clay White  20kg', '2', '1', '0', '0'),
('106', 'I-006', 'I-006', 'A P Berger A R Primer  1 USG', '2', '1', '0', '0'),
('107', 'I-007', 'I-007', 'A P Berger Bariq Almas Silver 4 KG', '2', '1', '0', '0'),
('108', 'I-008', 'I-008', 'A P Berger Marmorino Fine White 20 Kg', '2', '1', '0', '0'),
('109', 'I-009', 'I-009', 'A P Berger Marmorino Smooth A643 20kg', '2', '1', '0', '0'),
('110', 'I-010', 'I-010', 'A P Berger Road Marking Paint White  18 LTR', '2', '1', '0', '0'),
('111', 'I-011', 'I-011', 'A P Berger Robbiathane Matt  RAL 4005 Blaulila 20 Ltr', '2', '1', '0', '0'),
('112', 'I-012', 'I-012', 'A P Berger Royal Matt Emulsion W2 Base�18�Ltr', '2', '1', '0', '0'),
('113', 'I-013', 'I-013', 'A P Berger Royale play Rust Protective Clear Coat ( Ltr)', '2', '1', '0', '0'),
('114', 'I-014', 'I-014', 'A P Berger silicon Sealent G P Clear 280 ml', '2', '1', '0', '0'),
('115', 'I-015', 'I-015', 'A P Berger Tuff AR Primer Clear  23kg', '2', '1', '0', '0'),
('116', 'I-016', 'I-016', 'A P Berger W/Coat Stone Shield  White 23 kg', '2', '1', '0', '0'),
('117', 'I-017', 'I-017', 'A P Royale Luxury Matt�RED GAL', '2', '1', '0', '0'),
('118', 'I-018', 'I-018', 'A Stainless Steel Hanger 1020mm (Pcs)', '2', '1', '0', '0'),
('119', 'I-019', 'I-019', 'ACCESS PANEL 40x40cm', '2', '1', '0', '0'),
('120', 'I-020', 'I-020', 'Acid', '2', '1', '0', '0'),
('121', 'I-021', 'I-021', 'Aluminium Extension Rod 2mtr', '2', '1', '0', '0'),
('122', 'I-022', 'I-022', 'Aluminum Extension Rod 3mtr', '2', '1', '0', '0'),
('123', 'I-023', 'I-023', 'Aluminum Profile 1669 Single 6 Mtr', '2', '1', '0', '0'),
('124', 'I-024', 'I-024', 'Anchor Bolt (As Per Sample)', '2', '1', '0', '0'),
('125', 'I-025', 'I-025', 'Anchore Bolt 6 12mm', '2', '1', '0', '0'),
('126', 'I-026', 'I-026', 'AP Berger Apcolite Advanced DRUM', '2', '1', '0', '0'),
('127', 'I-027', 'I-027', 'AP Berger Bitumen Emulsion 15k', '2', '1', '0', '0'),
('128', 'I-028', 'I-028', 'AP Berger Bitumen Emulsion 15kg', '2', '1', '0', '0'),
('129', 'I-029', 'I-029', 'Ap Berger Royale Play Artistica Concrete 20kg', '2', '1', '0', '0'),
('130', 'I-030', 'I-030', 'Ap Berger Royale Play Artistica Copper Breeze - Base coat 1 LTR', '2', '1', '0', '0'),
('131', 'I-031', 'I-031', 'Ap Berger Royale Play Artistica Copper Breeze - Topcoat  0.5 LTR', '2', '1', '0', '0'),
('132', 'I-032', 'I-032', 'Ap Berger Royale Play Artistica Metallica 0.5kg', '2', '1', '0', '0'),
('133', 'I-033', 'I-033', 'AP Berger Royale Play Artistica Protective Coat / Colour Wash 1 LTR', '2', '1', '0', '0'),
('134', 'I-034', 'I-034', 'AP Berger Royale Play Artistica Rust Protective Coat 1 LTR', '2', '1', '0', '0'),
('135', 'I-035', 'I-035', 'Ap Berger Royale Play Artistica Rust Topcoat 1 LTR', '2', '1', '0', '0'),
('136', 'I-036', 'I-036', 'AP Berger Smart Care Waterproofing Damp block�2K�15kg', '2', '1', '0', '0'),
('137', 'I-037', 'I-037', 'AP Berger Tile Glue General Purpose White 20 Kg', '2', '1', '0', '0'),
('138', 'I-038', 'I-038', 'Ap Berger Wood Primer  Gln', '2', '1', '0', '0'),
('139', 'I-039', 'I-039', 'APBerger Smart Care Waterproofing Damp block 2K 3kg', '2', '1', '0', '0'),
('140', 'I-040', 'I-040', 'Asmaco Spray Paint Black Matt 400 ml', '2', '1', '0', '0'),
('141', 'I-041', 'I-041', 'B Stainless Steel Plate 200mm', '2', '1', '0', '0'),
('142', 'I-042', 'I-042', 'Bandex Cable Ties White 300 x 3.6', '2', '1', '0', '0'),
('143', 'I-043', 'I-043', 'Battery 9V', '2', '1', '0', '0'),
('144', 'I-044', 'I-044', 'BEREGER ROYAL MATT EMULSION W2 Base 1USG', '2', '1', '0', '0'),
('145', 'I-045', 'I-045', 'Berger Acrylic AR Primer (5 USG)', '2', '1', '0', '0'),
('146', 'I-046', 'I-046', 'Berger Acrylic Spray Compond White', '2', '1', '0', '0'),
('147', 'I-047', 'I-047', 'Berger Allinone Hi-Gloss 555N Nobel Green 0.9L', '2', '1', '0', '0'),
('148', 'I-048', 'I-048', 'Berger Epoxy Putty with Hardner (5L)', '2', '1', '0', '0'),
('149', 'I-049', 'I-049', 'Berger Floor Guard Epoxy Topcoat Minerva Grey 295N 20L', '2', '1', '0', '0'),
('150', 'I-050', 'I-050', 'Berger Hi-Gloss Enamel Base W0 1 USG', '2', '1', '0', '0'),
('151', 'I-051', 'I-051', 'Berger royal atmos health shield  WO Base 3.6 Ltr', '2', '1', '0', '0'),
('152', 'I-052', 'I-052', 'BERGER ROYALE ATMOS WO BASE 17.5LTR', '2', '1', '0', '0'),
('153', 'I-053', 'I-053', 'Berger Royale Matt Emulsion Base N 3.6 (Gal)', '2', '1', '0', '0'),
('154', 'I-054', 'I-054', 'BERGER ROYALE MATT EMULSION BASE N(LTR)', '2', '1', '0', '0'),
('155', 'I-055', 'I-055', 'Berger Royale Matt Emulsion Base W0 (Ltr)', '2', '1', '0', '0'),
('156', 'I-056', 'I-056', 'Berger Royale Matt Emulsion Base W0 18Ltr (Drm)', '2', '1', '0', '0'),
('157', 'I-057', 'I-057', 'Berger Royale Matt Emulsion Base W1 (GAL)', '2', '1', '0', '0'),
('158', 'I-058', 'I-058', 'Berger Royale Matt Emulsion Base W1 (Ltr)', '2', '1', '0', '0'),
('159', 'I-059', 'I-059', 'Berger Royale Matt Emulsion Black (Gal)', '2', '1', '0', '0'),
('160', 'I-060', 'I-060', 'Berger Royale Matt Emulsion White (Drm)', '2', '1', '0', '0'),
('161', 'I-061', 'I-061', 'Berger Royale Matt Emulsion White (Gal)', '2', '1', '0', '0'),
('162', 'I-062', 'I-062', 'Berger Royale Matt Emulsion WO Base.�Gal', '2', '1', '0', '0'),
('163', 'I-063', 'I-063', 'Berger Royale Play Bariq Silver 14Kg', '2', '1', '0', '0'),
('164', 'I-064', 'I-064', 'Berger Royale Play Bariq Silver 4 Kg', '2', '1', '0', '0'),
('165', 'I-065', 'I-065', 'Berger Royale play najam silver 1 kg', '2', '1', '0', '0'),
('166', 'I-066', 'I-066', 'Berger Royale Play Najam Silver Base 3.6 LTR', '2', '1', '0', '0'),
('167', 'I-067', 'I-067', 'Berger Royale Silk Emulsion White (Drm)', '2', '1', '0', '0'),
('168', 'I-068', 'I-068', 'Berger Royale smart clean W0 Base 18 ltr', '2', '1', '0', '0'),
('169', 'I-069', 'I-069', 'Berger Royale Smart clean WO Base 1 LTR', '2', '1', '0', '0'),
('170', 'I-070', 'I-070', 'Berger Royale Smart clean WO Base 3.6LTR', '2', '1', '0', '0'),
('171', 'I-071', 'I-071', 'Berger Select All in One Enamel White 000 (1 Ltr)', '2', '1', '0', '0'),
('172', 'I-072', 'I-072', 'Berger Select All in One Enamel White 000 (3.5 Ltr)', '2', '1', '0', '0'),
('173', 'I-073', 'I-073', 'Berger Select All in One Enamel�(Drum)', '2', '1', '0', '0'),
('174', 'I-074', 'I-074', 'Berger Special Value Red Oxide Prime(1USG)', '2', '1', '0', '0'),
('175', 'I-075', 'I-075', 'Berger Special Value Red Oxide Primer(1ltr)', '2', '1', '0', '0'),
('176', 'I-076', 'I-076', 'Berger Tuff Exterior - White (5 Kgs)', '2', '1', '0', '0'),
('177', 'I-077', 'I-077', 'Berger Tuff Exterior Matt - White (27Kg)', '2', '1', '0', '0'),
('178', 'I-078', 'I-078', 'Berger Tuff Exterior W1 Base 27kg', '2', '1', '0', '0'),
('179', 'I-079', 'I-079', 'Berger Tuff Exterior W1 Base Ltr', '2', '1', '0', '0'),
('180', 'I-080', 'I-080', 'Berger Tuff Exterior WO base Drum', '2', '1', '0', '0'),
('181', 'I-081', 'I-081', 'Berger Tuff Exterior Wo Base Ltr', '2', '1', '0', '0'),
('182', 'I-082', 'I-082', 'Berger Tuff Exterior Wo Base-5KG', '2', '1', '0', '0'),
('183', 'I-083', 'I-083', 'Berger Universal Thinner (E55) Clear 1usg', '2', '1', '0', '0'),
('184', 'I-084', 'I-084', 'Berger Universal Thinner E55 Clear 0.9 Ltr', '2', '1', '0', '0'),
('185', 'I-085', 'I-085', 'Berger Value Dry Stucco 20 Kgs', '2', '1', '0', '0'),
('186', 'I-086', 'I-086', 'Berger Value Gypsum Joint Compound 25 Kgs/Drum', '2', '1', '0', '0'),
('187', 'I-087', 'I-087', 'Berger Value Stucco Extra Mix (18 Ltr)', '2', '1', '0', '0'),
('188', 'I-088', 'I-088', 'Berger Value Stucco Extra Mix (3.5 Ltr)', '2', '1', '0', '0'),
('189', 'I-089', 'I-089', 'Bison Kit 650ml / Can', '2', '1', '0', '0'),
('190', 'I-090', 'I-090', 'Bitumen sheet 4mm x 1.3 meter x 10meter', '2', '1', '0', '0'),
('191', 'I-091', 'I-091', 'Black Cat Paint Roller Handle 9&quot; BC9H1.75SG', '2', '1', '0', '0'),
('192', 'I-092', 'I-092', 'Black Cat Sleeve Extra Rough 9&quot; BC9ER1.75', '2', '1', '0', '0'),
('193', 'I-093', 'I-093', 'Blades LB 10', '2', '1', '0', '0'),
('194', 'I-094', 'I-094', 'Boral Joint Compound', '2', '1', '0', '0'),
('195', 'I-095', 'I-095', 'Bosch Grinding Wheel 2608603181', '2', '1', '0', '0'),
('196', 'I-096', 'I-096', 'Bosch SS Cutting Disc 1MM X 4.5 Inch2608603169', '2', '1', '0', '0'),
('197', 'I-097', 'I-097', 'Brass Reducer Bush 1/2 x 3/4', '2', '1', '0', '0'),
('198', 'I-098', 'I-098', 'Brass Reducer Bush 1/2&quot; x 3/8&quot;', '2', '1', '0', '0'),
('199', 'I-099', 'I-099', 'Brighto Acrylic Primer DRM 18 Ltr', '2', '1', '0', '0'),
('200', 'I-100', 'I-100', 'Brighto Acrylic Rock Top Coat  3.6 Ltr', '2', '1', '0', '0'),
('201', 'I-101', 'I-101', 'Brighto Texo Compound 18LTR', '2', '1', '0', '0'),
('202', 'I-102', 'I-102', 'Bubble Sheet', '2', '1', '0', '0'),
('203', 'I-103', 'I-103', 'Cabinet Hydraulic Hinges A Type', '2', '1', '0', '0'),
('204', 'I-104', 'I-104', 'Caparol Capa Ultra Matt  (Gal)', '2', '1', '0', '0'),
('205', 'I-105', 'I-105', 'Caparol Capa Ultra Matt-Tundra 60   (Ltr)', '2', '1', '0', '0'),
('206', 'I-106', 'I-106', 'Caparol Capa Ultra Palazzo 145 (Ltr)', '2', '1', '0', '0'),
('207', 'I-107', 'I-107', 'Caparol CapaPlus Matt White (5 G)', '2', '1', '0', '0'),
('208', 'I-108', 'I-108', 'Cargo Lashing 2x10mtr', '2', '1', '0', '0'),
('209', 'I-109', 'I-109', 'Ceiling Tile 600x600 APS', '2', '1', '0', '0'),
('210', 'I-110', 'I-110', 'Cement OPC / Black', '2', '1', '0', '0'),
('211', 'I-111', 'I-111', 'Cement White  kg', '2', '1', '0', '0'),
('212', 'I-112', 'I-112', 'Connector APS', '2', '1', '0', '0'),
('213', 'I-113', 'I-113', 'Connector stop 10mm', '2', '1', '0', '0'),
('214', 'I-114', 'I-114', 'Connector stop 16mm�', '2', '1', '0', '0'),
('215', 'I-115', 'I-115', 'Corrugated Paper Roll', '2', '1', '0', '0'),
('216', 'I-116', 'I-116', 'Cotton Rags Colour Unstitched', '2', '1', '0', '0'),
('217', 'I-117', 'I-117', 'Cotton Rags White Unstitched', '2', '1', '0', '0'),
('218', 'I-118', 'I-118', 'Cotton Rope 12mm x 40yd', '2', '1', '0', '0'),
('219', 'I-119', 'I-119', 'CP Extension Nipple 1/2&quot; x 10mm Len', '2', '1', '0', '0'),
('220', 'I-120', 'I-120', 'CSK Screw 5/8x6', '2', '1', '0', '0'),
('221', 'I-121', 'I-121', 'CSK self drilling screw 6x1   1000 pkt', '2', '1', '0', '0'),
('222', 'I-122', 'I-122', 'CSK self drilling screw 6x1.25', '2', '1', '0', '0'),
('223', 'I-123', 'I-123', 'CSK self drilling screw 8x.05', '2', '1', '0', '0'),
('224', 'I-124', 'I-124', 'CSK self drilling screw 8x1', '2', '1', '0', '0'),
('225', 'I-125', 'I-125', 'Cusbor Bonded Red Polyester Thread', '2', '1', '0', '0'),
('226', 'I-126', 'I-126', 'Cusbor Polyester HT�T20�250�Gr', '2', '1', '0', '0'),
('227', 'I-127', 'I-127', 'Cut Resistant Gloves Grey Per4mer N10555', '2', '1', '0', '0'),
('228', 'I-128', 'I-128', 'Cutting Disc Metal 4-1/2', '2', '1', '0', '0'),
('229', 'I-129', 'I-129', 'DD Corrugated/Flexible Conduit Black 20mm x 50Mtr', '2', '1', '0', '0'),
('230', 'I-130', 'I-130', 'DD Female Adaptor 20mm Black #DFA2', '2', '1', '0', '0'),
('231', 'I-131', 'I-131', 'DD Female Adaptor 25mm Black #DFA3', '2', '1', '0', '0'),
('232', 'I-132', 'I-132', 'DD Spacer Saddle 20mm #DSB2', '2', '1', '0', '0'),
('233', 'I-133', 'I-133', 'DD Spacer Saddle 25mm #DSB3', '2', '1', '0', '0'),
('234', 'I-134', 'I-134', 'Deer Paint Remover 400ml', '2', '1', '0', '0'),
('235', 'I-135', 'I-135', 'Denim Brush Wood SB-L03', '2', '1', '0', '0'),
('236', 'I-136', 'I-136', 'DEWALT 115MM DIAMOND BLADE TILE DX3121', '2', '1', '0', '0'),
('237', 'I-137', 'I-137', 'Dewalt SDS Plus Drill Bit - 12mm x 150mm x 200mm', '2', '1', '0', '0'),
('238', 'I-138', 'I-138', 'Disposable PE Shoe Cover Blue (100 Pcs/Pkt)', '2', '1', '0', '0'),
('239', 'I-139', 'I-139', 'Door Lock APS', '2', '1', '0', '0'),
('240', 'I-140', 'I-140', 'Dooya Tubular Motor DM45R/SF 50NM + DD2700H Remote', '2', '1', '0', '0'),
('241', 'I-141', 'I-141', 'DQ Steel Nail 1-1/2 (40mm)', '2', '1', '0', '0'),
('242', 'I-142', 'I-142', 'DR Fixit Uniproof 4000 Water Proofing White (20KG)', '2', '1', '0', '0'),
('243', 'I-143', 'I-143', 'Dr. Fixit  Sausage silicon 600 gm White', '2', '1', '0', '0'),
('244', 'I-144', 'I-144', 'Dr.Fixit Raincoat UltraFlex White  18ltr', '2', '1', '0', '0'),
('245', 'I-145', 'I-145', 'Dr.Fixit Silicone Sealant 501 S.S GPS-Clear (280GM)', '2', '1', '0', '0'),
('246', 'I-146', 'I-146', 'Dr.Fixit Silicone Sealant 501 S.S GPS-WH (280GM)', '2', '1', '0', '0'),
('247', 'I-147', 'I-147', 'Ducab Wire 4 mm 100 Yds Roll -�Black', '2', '1', '0', '0'),
('248', 'I-148', 'I-148', 'Ducab Wire 4 mm 100 Yds Roll-�Red', '2', '1', '0', '0'),
('249', 'I-149', 'I-149', 'Duct Tape', '2', '1', '0', '0'),
('250', 'I-150', 'I-150', 'Dunet Bird Net White 5 x 100 meters Roll', '2', '1', '0', '0'),
('251', 'I-151', 'I-151', 'Dunet Comm. 95 Natural 3m�x�50m', '2', '1', '0', '0'),
('252', 'I-152', 'I-152', 'Dunet Commercial 95 Desert Sand Roll 3 x 50 meter', '2', '1', '0', '0'),
('253', 'I-153', 'I-153', 'DUNET Shade Net Green 73% China 3 x 50 Mtr', '2', '1', '0', '0'),
('254', 'I-154', 'I-154', 'DUNET Shade Netting 90% Monofilament Green Vietnam 3 x�50�Mtr', '2', '1', '0', '0'),
('255', 'I-155', 'I-155', 'DUTARP PVC Coated Tarpaulin #FR2219 (72&quot; x 50Y)', '2', '1', '0', '0'),
('256', 'I-156', 'I-156', 'DW00736-AE', '2', '1', '0', '0'),
('257', 'I-157', 'I-157', 'Expansion Plug Green  1.5&quot; x 7mm  25pcs/set', '2', '1', '0', '0'),
('258', 'I-158', 'I-158', 'Expansion Plug Green  1.5&quot; x 7mm  25pcs/set', '2', '1', '0', '0'),
('259', 'I-159', 'I-159', 'extensible hose 1-1/4&quot;(w/o rosete)1.0-80 160pcs/ctn', '2', '1', '0', '0'),
('260', 'I-160', 'I-160', 'Eyelet Die #3 (12mm) Turkey', '2', '1', '0', '0'),
('261', 'I-161', 'I-161', 'Feet Guard Safety Shoes 402 High Ankle #41', '2', '1', '0', '0'),
('262', 'I-162', 'I-162', 'Fevicol Dr. Fixit Crack X Powder (Pkt)', '2', '1', '0', '0'),
('263', 'I-163', 'I-163', 'Fevicol HeatX (3.8L)', '2', '1', '0', '0'),
('264', 'I-164', 'I-164', 'Fevicol HeatX (650ML)', '2', '1', '0', '0'),
('265', 'I-165', 'I-165', 'Fevicol Super Glue (3 Grm)', '2', '1', '0', '0'),
('266', 'I-166', 'I-166', 'Fischer Chemical FIS VS Low', '2', '1', '0', '0'),
('267', 'I-167', 'I-167', 'Fix Bolt 10mm', '2', '1', '0', '0'),
('268', 'I-168', 'I-168', 'Fix Bolt 12mm', '2', '1', '0', '0'),
('269', 'I-169', 'I-169', 'Fix Bolt 6mm Box', '2', '1', '0', '0'),
('270', 'I-170', 'I-170', 'Florence Panle Light  White  595 x 595', '2', '1', '0', '0'),
('271', 'I-171', 'I-171', 'Fuerza pad lock crome plated PC PGL 75', '2', '1', '0', '0'),
('272', 'I-172', 'I-172', 'Garbage Bag (Pkt)', '2', '1', '0', '0'),
('273', 'I-173', 'I-173', 'Gazelle 4.5 In. Metal Cutting Disc (115mm), Ultra Thin GTD115-HD', '2', '1', '0', '0'),
('274', 'I-174', 'I-174', 'Gazelle 8x11 In. Waterproof Sandpaper Sheets, 120 Grit GWP 120', '2', '1', '0', '0'),
('275', 'I-175', 'I-175', 'Gazelle Curved Claw Hammer 20 oz G80167', '2', '1', '0', '0'),
('276', 'I-176', 'I-176', 'Gazelle Long Arm Imperial Hex Key Set G80133', '2', '1', '0', '0'),
('277', 'I-177', 'I-177', 'Gazelle Plastic Snap- off Knife G 80105', '2', '1', '0', '0'),
('278', 'I-178', 'I-178', 'Gazelle Platform Trolley - Steel Bed W/ Folding Hsndle 720 x 490 mm G2501', '2', '1', '0', '0'),
('279', 'I-179', 'I-179', 'Gazelle Voltage Tester G80365', '2', '1', '0', '0'),
('280', 'I-180', 'I-180', 'Gi Nut 10mm Kg', '2', '1', '0', '0'),
('281', 'I-181', 'I-181', 'GIFFEX JUNCTION BOX 100X100X50 IP65', '2', '1', '0', '0'),
('282', 'I-182', 'I-182', 'Gypsum Powder (Bag)', '2', '1', '0', '0'),
('283', 'I-183', 'I-183', 'Gypsum Powder(Pkt)', '2', '1', '0', '0'),
('284', 'I-184', 'I-184', 'Gypsum Screw 4 x 10 (Pkt)', '2', '1', '0', '0'),
('285', 'I-185', 'I-185', 'Gypsum screw 6x1', '2', '1', '0', '0'),
('286', 'I-186', 'I-186', 'gypsum screw 6x1.1/2', '2', '1', '0', '0'),
('287', 'I-187', 'I-187', 'Gypsum Screw 6x1.1/4', '2', '1', '0', '0'),
('288', 'I-188', 'I-188', 'gypsum screw 6x2', '2', '1', '0', '0'),
('289', 'I-189', 'I-189', 'Gypsum screw 8x1', '2', '1', '0', '0'),
('290', 'I-190', 'I-190', 'Gypsum Screw 8x1.1/2', '2', '1', '0', '0'),
('291', 'I-191', 'I-191', 'Gypsum Screw 8x1.1/2 (pkt)', '2', '1', '0', '0'),
('292', 'I-192', 'I-192', 'gypsum screw 8x2', '2', '1', '0', '0'),
('293', 'I-193', 'I-193', 'gypsum screw 8x2.1/2', '2', '1', '0', '0'),
('294', 'I-194', 'I-194', 'gypsum screw 8x3/4', '2', '1', '0', '0'),
('295', 'I-195', 'I-195', 'Gypsum Sheet (4x8 ft)', '2', '1', '0', '0'),
('296', 'I-196', 'I-196', 'Half Round File 6', '2', '1', '0', '0'),
('297', 'I-197', 'I-197', 'Hand Tape', '2', '1', '0', '0'),
('298', 'I-198', 'I-198', 'Hex Head Self Drilling Screw 14x1', '2', '1', '0', '0'),
('299', 'I-199', 'I-199', 'hex head self drilling screw 14x2', '2', '1', '0', '0'),
('300', 'I-200', 'I-200', 'Holder', '2', '1', '0', '0'),
('301', 'I-201', 'I-201', 'Hole Punch 13mm', '2', '1', '0', '0'),
('302', 'I-202', 'I-202', 'hook bolt M10X70MM', '2', '1', '0', '0'),
('303', 'I-203', 'I-203', 'hook bolt M12X90MM', '2', '1', '0', '0'),
('304', 'I-204', 'I-204', 'Industrial  Welding Goggle B/G', '2', '1', '0', '0'),
('305', 'I-205', 'I-205', 'Insulation Tape Black', '2', '1', '0', '0'),
('306', 'I-206', 'I-206', 'Insulation Tape White', '2', '1', '0', '0'),
('307', 'I-207', 'I-207', 'Ispat Leather Safety Shoes Executive ASG1 #42', '2', '1', '0', '0'),
('308', 'I-208', 'I-208', 'Ispat Leather Safety Shoes Executive ASG1 #43', '2', '1', '0', '0'),
('309', 'I-209', 'I-209', 'Italian Stucco White Xpressions (5 Kgs)', '2', '1', '0', '0'),
('310', 'I-210', 'I-210', 'Italian Stucco Xpressions W1 Base (1.4 Kgs)', '2', '1', '0', '0'),
('311', 'I-211', 'I-211', 'Italian Stucco Xpressions W1 Base�(14�Kg)', '2', '1', '0', '0'),
('312', 'I-212', 'I-212', 'Joint Tape', '2', '1', '0', '0'),
('313', 'I-213', 'I-213', 'Jotun Enamel Matt Ral 9016 (Ltr)', '2', '1', '0', '0'),
('314', 'I-214', 'I-214', 'JOTUN FENOMASTIC EML MYHOME RICH MATT BASE A 3.6L 9003', '2', '1', '0', '0'),
('315', 'I-215', 'I-215', 'Jotun fenomastic Matt 0486 1Ltr', '2', '1', '0', '0'),
('316', 'I-216', 'I-216', 'Jotun Fenomastic Matt 18LTR', '2', '1', '0', '0'),
('317', 'I-217', 'I-217', 'Jotun fenomastic Matt 5489 1Ltr', '2', '1', '0', '0'),
('318', 'I-218', 'I-218', 'Jotun fenomastic Matt S055 Y10', '2', '1', '0', '0'),
('319', 'I-219', 'I-219', 'Jotun fenomastic matt S0550 - Y10R', '2', '1', '0', '0'),
('320', 'I-220', 'I-220', 'Jotun Hardtop Coat XP S 4050-Y80R (1USG)', '2', '1', '0', '0'),
('321', 'I-221', 'I-221', 'Jotun Jota Floor Epoxy Paint Ral 9010 (1USG)', '2', '1', '0', '0'),
('322', 'I-222', 'I-222', 'JOTUN JOTASHIELD COLORLAST MATT 10394 16.20�LTR', '2', '1', '0', '0'),
('323', 'I-223', 'I-223', 'Jotun Jotashield eterna 1 Ltr', '2', '1', '0', '0'),
('324', 'I-224', 'I-224', 'Jotun pen guard primer gallon', '2', '1', '0', '0'),
('325', 'I-225', 'I-225', 'Jotun pen guard top coat black', '2', '1', '0', '0'),
('326', 'I-226', 'I-226', 'Jotun Pen Guard Top Coat S4050-Y80 R (1 USG)', '2', '1', '0', '0'),
('327', 'I-227', 'I-227', 'Jubliee Hose Clip # 00', '2', '1', '0', '0'),
('328', 'I-228', 'I-228', 'Kedder 8mm 200mtr', '2', '1', '0', '0'),
('329', 'I-229', 'I-229', 'L Bracket 1-1/2', '2', '1', '0', '0'),
('330', 'I-230', 'I-230', 'LED Spot Light Fitting 7W-D/L MR 16', '2', '1', '0', '0'),
('331', 'I-231', 'I-231', 'LED strip Light D/L - Selex 50 mtr', '2', '1', '0', '0'),
('332', 'I-232', 'I-232', 'Line Dori Red Colour', '2', '1', '0', '0'),
('333', 'I-233', 'I-233', 'Line Dori White', '2', '1', '0', '0'),
('334', 'I-234', 'I-234', 'LLAZA A/S Onyx - 400 1.5M #10002150001', '2', '1', '0', '0'),
('335', 'I-235', 'I-235', 'LLAZA A/S Onyx - 400 2.50M #10002250001', '2', '1', '0', '0'),
('336', 'I-236', 'I-236', 'LLAZA A/S Onyx - 400 3.0M #1000230001', '2', '1', '0', '0'),
('337', 'I-237', 'I-237', 'LLAZA A/S Onyx - 400 3.5M #10002350001', '2', '1', '0', '0'),
('338', 'I-238', 'I-238', 'LLAZA A/S Onyx-400 1.5M #10002150001', '2', '1', '0', '0'),
('339', 'I-239', 'I-239', 'LLAZA A/S Onyx-400 2.5M #10002250001', '2', '1', '0', '0'),
('340', 'I-240', 'I-240', 'LLAZA A/S Onyx-400 3.0 #1000230001', '2', '1', '0', '0'),
('341', 'I-241', 'I-241', 'LLAZA A/S Onyx-400 3.0M #1000230001', '2', '1', '0', '0'),
('342', 'I-242', 'I-242', 'Llaza Arond-350 Support Set #20110000001', '2', '1', '0', '0'),
('343', 'I-243', 'I-243', 'LLAZA Arond-350 Support Set #20110000001', '2', '1', '0', '0'),
('344', 'I-244', 'I-244', 'LLAZA Art 350 Arms 3.00M Grey #10045300909', '2', '1', '0', '0'),
('345', 'I-245', 'I-245', 'LLAZA Art350 Arms 2.5M Grey #10045250909', '2', '1', '0', '0'),
('346', 'I-246', 'I-246', 'LLAZA Awning Complete Pro 350', '2', '1', '0', '0'),
('347', 'I-247', 'I-247', 'Llaza Awning Complete PRO 350 3.00 x 2.5 mtr', '2', '1', '0', '0'),
('348', 'I-248', 'I-248', 'Llaza Awning Complete PRO 350 4.30 x 2.5mtr', '2', '1', '0', '0'),
('349', 'I-249', 'I-249', 'LLAZA Awning Monobloc 350', '2', '1', '0', '0'),
('350', 'I-250', 'I-250', 'LLAZA Awning Storbox�300�Grey', '2', '1', '0', '0'),
('351', 'I-251', 'I-251', 'LLAZA Crank ST 1.70m #13006170001', '2', '1', '0', '0'),
('352', 'I-252', 'I-252', 'LLAZA Front Profile Connectors #19002021001', '2', '1', '0', '0'),
('353', 'I-253', 'I-253', 'LLAZA Gear End Bearing Axis 35MM/80 #12080009000', '2', '1', '0', '0'),
('354', 'I-254', 'I-254', 'LLAZA Idle Side Bearing 80mm #12080003000', '2', '1', '0', '0'),
('355', 'I-255', 'I-255', 'LLAZA MB-9 Gearbox L-130 #21008016001', '2', '1', '0', '0'),
('356', 'I-256', 'I-256', 'LLAZA Onyx-400 Arms Grey #1000240090', '2', '1', '0', '0'),
('357', 'I-257', 'I-257', 'LLAZA P-801 Rolling Tube 80x1.2 7.00 GV #31080700044', '2', '1', '0', '0'),
('358', 'I-258', 'I-258', 'LLAZA ROLLING TUBE 80MM, 7M 31080700044 AWNING PROFILES', '2', '1', '0', '0'),
('359', 'I-259', 'I-259', 'Llaza Slender Stick 5.8mm (11005002001)', '2', '1', '0', '0'),
('360', 'I-260', 'I-260', 'Llaza Splenbox 400 Grey (3 Mtr Projection)', '2', '1', '0', '0'),
('361', 'I-261', 'I-261', 'LLAZA Storbox 300 3 Profiles 6M Grey #39086600909', '2', '1', '0', '0'),
('362', 'I-262', 'I-262', 'LLAZA Storbox 300 Support Set Grey #20001001909', '2', '1', '0', '0'),
('363', 'I-263', 'I-263', 'LLAZA Storbox 3000 Gearbox grey #20051033909', '2', '1', '0', '0'),
('364', 'I-264', 'I-264', 'LLAZA U280 Plastic Caps Kit #14003010001', '2', '1', '0', '0'),
('365', 'I-265', 'I-265', 'LLAZA Universe 280 front profile 6 Mtrs', '2', '1', '0', '0'),
('366', 'I-266', 'I-266', 'Machine Screw M4 x 20mm�CSK��(Pkt)', '2', '1', '0', '0'),
('367', 'I-267', 'I-267', 'Magnetic Ballast 36 W', '2', '1', '0', '0'),
('368', 'I-268', 'I-268', 'Makita SDS plus Drill Bit - 14mm 260mm x 200mm D-00664', '2', '1', '0', '0'),
('369', 'I-269', 'I-269', 'Mal Mal', '2', '1', '0', '0'),
('370', 'I-270', 'I-270', 'Mal Mal 15 Yard', '2', '1', '0', '0'),
('371', 'I-271', 'I-271', 'MAPEI MAPESET WHITE TILE GLUE 20KG', '2', '1', '0', '0'),
('372', 'I-272', 'I-272', 'Masking tape 2 x 30 yard', '2', '1', '0', '0'),
('373', 'I-273', 'I-273', 'Masking Tape 2&quot;', '2', '1', '0', '0'),
('374', 'I-274', 'I-274', 'METAL CUTTING WHEEL 100X3X16 T27 DWA4520IA-AE', '2', '1', '0', '0'),
('375', 'I-275', 'I-275', 'Milano 13A 1 Gang Switched Socket,Single Pole White V4050', '2', '1', '0', '0'),
('376', 'I-276', 'I-276', 'Milano 13A2 gang single poles with Double socket-clad V4060', '2', '1', '0', '0'),
('377', 'I-277', 'I-277', 'Milano 2 Gang 2 Way 210800100035 W/p', '2', '1', '0', '0'),
('378', 'I-278', 'I-278', 'Milano Deluxe Chrome Shattaf Set 140200100224', '2', '1', '0', '0'),
('379', 'I-279', 'I-279', 'Milano Deluxe White Shattaf Set 140200100223', '2', '1', '0', '0'),
('380', 'I-280', 'I-280', 'Milano Eagle Angle Valve 140800300221', '2', '1', '0', '0'),
('381', 'I-281', 'I-281', 'Milano Flat Chisal 12 with guard', '2', '1', '0', '0'),
('382', 'I-282', 'I-282', 'Milano Flat Chisal 12 with guard', '2', '1', '0', '0'),
('383', 'I-283', 'I-283', 'Milano Tarki Shower Mixer + Shower 140100100231', '2', '1', '0', '0'),
('384', 'I-284', 'I-284', 'Milano W/C with tank  trap white ( code 1058)', '2', '1', '0', '0'),
('385', 'I-285', 'I-285', 'Miscellaneous  Cash purchase item Taxable', '2', '1', '0', '0'),
('386', 'I-286', 'I-286', 'MOP', '2', '1', '0', '0'),
('387', 'I-287', 'I-287', 'MS Nut M4', '2', '1', '0', '0'),
('388', 'I-288', 'I-288', 'MTX Tile Drill Bit #728139 Size 3MM', '2', '1', '0', '0'),
('389', 'I-289', 'I-289', 'MTX Tile Drill Bit #728149 Size 4MM', '2', '1', '0', '0'),
('390', 'I-290', 'I-290', 'MTX Tile Drill Bit #728159 Size 5MM', '2', '1', '0', '0'),
('391', 'I-291', 'I-291', 'MTX Tile Drill Bit #728169 Size 6MM', '2', '1', '0', '0'),
('392', 'I-292', 'I-292', 'Multi�Meter', '2', '1', '0', '0'),
('393', 'I-293', 'I-293', 'National S/C Wire Black 2.5MM', '2', '1', '0', '0'),
('394', 'I-294', 'I-294', 'National S/C Wire BLACK 4MM', '2', '1', '0', '0'),
('395', 'I-295', 'I-295', 'National S/C Wire Blue 2.5MM', '2', '1', '0', '0'),
('396', 'I-296', 'I-296', 'National S/C Wire Red 2.5MM', '2', '1', '0', '0'),
('397', 'I-297', 'I-297', 'National S/C Wire RED 4MM', '2', '1', '0', '0'),
('398', 'I-298', 'I-298', 'National S/C Wire Y/G 2.5MM 95mtr', '2', '1', '0', '0'),
('399', 'I-299', 'I-299', 'National S/C Wire Y/G 4MM', '2', '1', '0', '0'),
('400', 'I-300', 'I-300', 'National Steel Putty 1.5kg', '2', '1', '0', '0'),
('401', 'I-301', 'I-301', 'Nut+ Bolt', '2', '1', '0', '0'),
('402', 'I-302', 'I-302', 'Opp tape clear 2x80 yard', '2', '1', '0', '0'),
('403', 'I-303', 'I-303', 'P P Guny Bag 60x100 Cm', '2', '1', '0', '0'),
('404', 'I-304', 'I-304', 'Paint Brush Harris 1.5', '2', '1', '0', '0'),
('405', 'I-305', 'I-305', 'Paint Filter', '2', '1', '0', '0'),
('406', 'I-306', 'I-306', 'Paint Roller Cristin Mini Complete 4&quot;', '2', '1', '0', '0'),
('407', 'I-309', 'I-309', 'Pe Tarpaulin 280 Gsm  MTR', '2', '1', '0', '0'),
('408', 'I-310', 'I-310', 'Plumb Bob', '2', '1', '0', '0'),
('409', 'I-311', 'I-311', 'PP Webbing 2&quot; x 50m Pakistan', '2', '1', '0', '0'),
('410', 'I-312', 'I-312', 'PPR Elbow 20mm x�90', '2', '1', '0', '0'),
('411', 'I-313', 'I-313', 'PPR Elbow Female Elbow 20mm x�1/2&quot;', '2', '1', '0', '0'),
('412', 'I-314', 'I-314', 'PPR Socket 20mm', '2', '1', '0', '0'),
('413', 'I-315', 'I-315', 'Promax W/P Fiber Mesh 1 x 25 Meters�White', '2', '1', '0', '0'),
('414', 'I-316', 'I-316', 'Purchases Cash- Taxable', '2', '1', '0', '0'),
('415', 'I-317', 'I-317', 'PVA Primer White Bergercoat (1 USG)', '2', '1', '0', '0'),
('416', 'I-318', 'I-318', 'PVA Primer White Bergercoat (5 USG)', '2', '1', '0', '0'),
('417', 'I-319', 'I-319', 'PVC Adaptor 50mm', '2', '1', '0', '0'),
('418', 'I-320', 'I-320', 'PVC Bend 2', '2', '1', '0', '0'),
('419', 'I-321', 'I-321', 'PVC Box 3 x 6', '2', '1', '0', '0'),
('420', 'I-322', 'I-322', 'PVC Box 3X3', '2', '1', '0', '0'),
('421', 'I-323', 'I-323', 'PVC Bucket (Nos)', '2', '1', '0', '0'),
('422', 'I-324', 'I-324', 'PVC Curtain Strip 200 x 2 mm (50 Mtr / Roll)', '2', '1', '0', '0'),
('423', 'I-325', 'I-325', 'PVC Elbow 1', '2', '1', '0', '0'),
('424', 'I-326', 'I-326', 'PVC Elbow 3/4', '2', '1', '0', '0'),
('425', 'I-327', 'I-327', 'PVC Female socket 1&quot; PPR Socket 20�x�1/2&quot;', '2', '1', '0', '0'),
('426', 'I-328', 'I-328', 'PVC Female Socket 3/4', '2', '1', '0', '0'),
('427', 'I-329', 'I-329', 'Pvc Junction box 25mm   3 Way', '2', '1', '0', '0'),
('428', 'I-330', 'I-330', 'PVC Made Adaptor 1/2&quot; PPR Male�Plug', '2', '1', '0', '0'),
('429', 'I-331', 'I-331', 'PVC Pipe  3/4', '2', '1', '0', '0'),
('430', 'I-332', 'I-332', 'PVC Pipe 1', '2', '1', '0', '0'),
('431', 'I-333', 'I-333', 'PVC Pipe 1&quot; PPR pipe 20mm x 4�Meter', '2', '1', '0', '0'),
('432', 'I-334', 'I-334', 'PVC Pipe 2&quot;', '2', '1', '0', '0'),
('433', 'I-335', 'I-335', 'PVC Reducer Bush 1 x 1/2', '2', '1', '0', '0'),
('434', 'I-336', 'I-336', 'PVC Solvent Cement (Nos)', '2', '1', '0', '0'),
('435', 'I-337', 'I-337', 'PVC Tee 1', '2', '1', '0', '0'),
('436', 'I-338', 'I-338', 'PVC Tee 1 1/2', '2', '1', '0', '0'),
('437', 'I-339', 'I-339', 'PVC Tee 3/4', '2', '1', '0', '0'),
('438', 'I-340', 'I-340', 'Relite Flexible cable Turkey  1.5mm x 3 Core  Mtr', '2', '1', '0', '0'),
('439', 'I-341', 'I-341', 'Relite LED Ceiling light white  60x60', '2', '1', '0', '0'),
('440', 'I-342', 'I-342', 'ROBUSTLINE GALVANISED ANGLE BRKT 40MMX40MMX15MMX1.�5MM', '2', '1', '0', '0'),
('441', 'I-343', 'I-343', 'Robustline Lever Handle  Narrow White LW-246�', '2', '1', '0', '0'),
('442', 'I-344', 'I-344', 'Round Light APS', '2', '1', '0', '0'),
('443', 'I-345', 'I-345', 'Ruko HSS Drill Bit (214060) 6.0mm', '2', '1', '0', '0'),
('444', 'I-346', 'I-346', 'Ruko HSS Drill Bit (214090) 9.00mm', '2', '1', '0', '0'),
('445', 'I-347', 'I-347', 'Ruko HSS Drill Bit (214105) 10.5mm', '2', '1', '0', '0'),
('446', 'I-348', 'I-348', 'Ruko HSS Drill Bit (214150) 15.0mm', '2', '1', '0', '0'),
('447', 'I-349', 'I-349', 'Ruko HSS Ground Tin Coated Drill Bit 8mm 250080T', '2', '1', '0', '0'),
('448', 'I-350', 'I-350', 'Ruko HSS Ground Tin Coated Drill Bit 9mm 250090T', '2', '1', '0', '0'),
('449', 'I-351', 'I-351', 'Safety Helmet Per4mer 141 Yellow', '2', '1', '0', '0'),
('450', 'I-352', 'I-352', 'Safety Shoes Executive M003 # 40', '2', '1', '0', '0'),
('451', 'I-353', 'I-353', 'Safety Shoes Executive M003 # 40', '2', '1', '0', '0'),
('452', 'I-354', 'I-354', 'Safety Shoes Executive M003 # 41', '2', '1', '0', '0'),
('453', 'I-355', 'I-355', 'Safety Shoes Executive M003 # 43', '2', '1', '0', '0'),
('454', 'I-356', 'I-356', 'Safety Shoes Vaultex M003 43&quot;', '2', '1', '0', '0'),
('455', 'I-357', 'I-357', 'Safety Specticles SP1401 Hook Tinted', '2', '1', '0', '0'),
('456', 'I-358', 'I-358', 'Safety Specticles SP1401 Tinted', '2', '1', '0', '0'),
('457', 'I-359', 'I-359', 'Safety Specticles SP5501 Clear', '2', '1', '0', '0'),
('458', 'I-360', 'I-360', 'Safety Vest Fabric Type Yellow/green Per4mer L', '2', '1', '0', '0'),
('459', 'I-361', 'I-361', 'Safety Vest Net Typr Yellow/green Per4mer VMT01 L', '2', '1', '0', '0'),
('460', 'I-362', 'I-362', 'Sand Paper 120', '2', '1', '0', '0'),
('461', 'I-363', 'I-363', 'Sauleda Acrylic Canvas #2235 ( Colour : Azul Real)', '2', '1', '0', '0'),
('462', 'I-364', 'I-364', 'Sauleda Acrylic Canvas #2687 ( Colour : Vanilla)', '2', '1', '0', '0'),
('463', 'I-365', 'I-365', 'Sauleda Acrylic Canvas 2038 Beige 120CM', '2', '1', '0', '0'),
('464', 'I-366', 'I-366', 'Schneider Flex Outlet SW 13A + Neon +Fuse', '2', '1', '0', '0'),
('465', 'I-367', 'I-367', 'Schneider Switch 1G 1 Way Avatar 16A White', '2', '1', '0', '0'),
('466', 'I-368', 'I-368', 'Schneider Switch Socket 13A double Avatar White', '2', '1', '0', '0'),
('467', 'I-369', 'I-369', 'Schneider Switch Socket 13A Single Avatar White', '2', '1', '0', '0'),
('468', 'I-370', 'I-370', 'Scissors', '2', '1', '0', '0'),
('469', 'I-371', 'I-371', 'Scrapper 2', '2', '1', '0', '0'),
('470', 'I-372', 'I-372', 'Scrapper 3', '2', '1', '0', '0'),
('471', 'I-373', 'I-373', 'Scrapper 4&quot;', '2', '1', '0', '0'),
('472', 'I-374', 'I-374', 'SDS Drill Bit 12mm', '2', '1', '0', '0'),
('473', 'I-375', 'I-375', 'Segmented Diamond Blade 115mm DW 47451 HP', '2', '1', '0', '0'),
('474', 'I-376', 'I-376', 'SEGMENTED DIAMOND BLADE 115MM DW47452HP', '2', '1', '0', '0'),
('475', 'I-377', 'I-377', 'Select Fine Texture White (18 Ltr)', '2', '1', '0', '0'),
('476', 'I-378', 'I-378', 'Select Medium Texture White 5 Usg', '2', '1', '0', '0'),
('477', 'I-379', 'I-379', 'Self bracket white 10x12', '2', '1', '0', '0'),
('478', 'I-380', 'I-380', 'Silicon Dow Corning 799 Clear 310 ml', '2', '1', '0', '0'),
('479', 'I-381', 'I-381', 'Silicone Gun', '2', '1', '0', '0'),
('480', 'I-382', 'I-382', 'Socket Wrench 1/4', '2', '1', '0', '0'),
('481', 'I-383', 'I-383', 'Soft Broom', '2', '1', '0', '0'),
('482', 'I-384', 'I-384', 'Spray Paint White', '2', '1', '0', '0'),
('483', 'I-385', 'I-385', 'Spring Bender', '2', '1', '0', '0'),
('484', 'I-386', 'I-386', 'SS Drill Bit 12mm', '2', '1', '0', '0'),
('485', 'I-387', 'I-387', 'SS Flex Hose 60cm', '2', '1', '0', '0'),
('486', 'I-388', 'I-388', 'SS hose 60cm red and blue line', '2', '1', '0', '0'),
('487', 'I-389', 'I-389', 'Stanley 9 Pcs Hexkey Set 92619-8', '2', '1', '0', '0'),
('488', 'I-390', 'I-390', 'Stanley Combination Wrench 13MM #STMT80223-8B', '2', '1', '0', '0'),
('489', 'I-391', 'I-391', 'Stanley Measuring Tape 5Mtr    STHT 36194', '2', '1', '0', '0'),
('490', 'I-392', 'I-392', 'Stanley Screw Driver 3X50 (Tester) 66119', '2', '1', '0', '0'),
('491', 'I-393', 'I-393', 'Stanley Standard Screwdriver (-) 100mm STHT65187', '2', '1', '0', '0'),
('492', 'I-394', 'I-394', 'STANLEY STANDARD SCREWDRIVER 1X100 MM STHT 60805-8', '2', '1', '0', '0'),
('493', 'I-395', 'I-395', 'Star Drill Bit 2', '2', '1', '0', '0'),
('494', 'I-396', 'I-396', 'Steel Eyelet #3 (12mm) Turkey 500 Pcs/Pkt', '2', '1', '0', '0'),
('495', 'I-397', 'I-397', 'Switch 4  gang', '2', '1', '0', '0'),
('496', 'I-398', 'I-398', 'Switch Two Way  gang', '2', '1', '0', '0'),
('497', 'I-399', 'I-399', 'Synthesis Commercial 95 deep ochere 3x40 Mtr.', '2', '1', '0', '0'),
('498', 'I-400', 'I-400', 'Synthesis Commercial 95 Desert Sand 3m x 40m', '2', '1', '0', '0'),
('499', 'I-401', 'I-401', 'Teflon Tape Stower 1', '2', '1', '0', '0'),
('500', 'I-402', 'I-402', 'Teflon Tape White 1', '2', '1', '0', '0'),
('501', 'I-403', 'I-403', 'Teflon Tape White 1&quot;', '2', '1', '0', '0'),
('502', 'I-404', 'I-404', 'Terminator LED Bulb 5W E27 Day Light #TLEDB-5W', '2', '1', '0', '0'),
('503', 'I-405', 'I-405', 'Terminator Terminal Connector Block 10A #TTB10A', '2', '1', '0', '0'),
('504', 'I-406', 'I-406', 'Terminator Terminal Connector Block 20A #TTB20A', '2', '1', '0', '0'),
('505', 'I-407', 'I-407', 'Terminator Top Plug with Fited TTP -13AB', '2', '1', '0', '0'),
('506', 'I-408', 'I-408', 'Terraco Gypsum Joint Compound (28KG)', '2', '1', '0', '0'),
('507', 'I-409', 'I-409', 'Tester', '2', '1', '0', '0'),
('508', 'I-410', 'I-410', 'Texture Gun', '2', '1', '0', '0'),
('509', 'I-411', 'I-411', 'Thinner Berger Solvalux 7-45 (1�USG)', '2', '1', '0', '0'),
('510', 'I-412', 'I-412', 'Thinner Berger Solvalux 7-45 (5 USG)', '2', '1', '0', '0'),
('511', 'I-413', 'I-413', 'Thinner Berger Universal E55', '2', '1', '0', '0'),
('512', 'I-414', 'I-414', 'Through Bolts (Wedge Achors) 8x60', '2', '1', '0', '0'),
('513', 'I-415', 'I-415', 'Tile Grout APS (Bag)', '2', '1', '0', '0'),
('514', 'I-416', 'I-416', 'Tile Spacer', '2', '1', '0', '0'),
('515', 'I-417', 'I-417', 'Tile Spacer 2mm', '2', '1', '0', '0'),
('516', 'I-418', 'I-418', 'TOA Sand Paper Grit # 120', '2', '1', '0', '0'),
('517', 'I-419', 'I-419', 'TOA Sand paper Grit 220', '2', '1', '0', '0'),
('518', 'I-420', 'I-420', 'Touchwood Wood Stain Mahogany (1 Ltr)', '2', '1', '0', '0'),
('519', 'I-421', 'I-421', 'Tower HD Gross Foam Texture Roller Refil 4', '2', '1', '0', '0'),
('520', 'I-422', 'I-422', 'Trowel 4', '2', '1', '0', '0'),
('521', 'I-423', 'I-423', 'Tube Light Starter-S2', '2', '1', '0', '0'),
('522', 'I-424', 'I-424', 'Tube Rod 2', '2', '1', '0', '0'),
('523', 'I-425', 'I-425', 'Tuff-fix gypsum screw DSF8x3', '2', '1', '0', '0'),
('524', 'I-426', 'I-426', 'Uken Tighter Bit U1575 PH2x 50mm', '2', '1', '0', '0'),
('525', 'I-427', 'I-427', 'Universal Classic Paint Tray 9 UCPT9', '2', '1', '0', '0'),
('526', 'I-428', 'I-428', 'Universal Classic Paint Tray 9 UCPT9', '2', '1', '0', '0'),
('527', 'I-429', 'I-429', 'Universal Mini Paint Roller Handle 4 UPHM', '2', '1', '0', '0'),
('528', 'I-430', 'I-430', 'Universal Paint Brush Single 3 UP1.75', '2', '1', '0', '0'),
('529', 'I-431', 'I-431', 'Universal Sleeve Semi Smooth 9&quot; # UP9SS1.75', '2', '1', '0', '0'),
('530', 'I-432', 'I-432', 'UPVC Bend 1.1/2&quot; (90 Degree)', '2', '1', '0', '0'),
('531', 'I-433', 'I-433', 'UPVC Pipe 2', '2', '1', '0', '0'),
('532', 'I-434', 'I-434', 'UPVC Reducer Brush 2&quot; x  1�1/2&quot;', '2', '1', '0', '0'),
('533', 'I-435', 'I-435', 'Upvc Socket 2', '2', '1', '0', '0'),
('534', 'I-436', 'I-436', 'UPVC Tee 1- 1/2&quot;', '2', '1', '0', '0'),
('535', 'I-437', 'I-437', 'Upvc Tee 2', '2', '1', '0', '0'),
('536', 'I-438', 'I-438', 'UPVC Y 2', '2', '1', '0', '0'),
('537', 'I-439', 'I-439', 'Vaultex  Safety vest fabric ORB Yellow  L', '2', '1', '0', '0'),
('538', 'I-440', 'I-440', 'VERMONT GRIT 120', '2', '1', '0', '0'),
('539', 'I-441', 'I-441', 'W/C Seat Cover', '2', '1', '0', '0'),
('540', 'I-442', 'I-442', 'Water Proof Paper Captain Grit-100', '2', '1', '0', '0'),
('541', 'I-443', 'I-443', 'Water Proof Paper Captain Grit-120', '2', '1', '0', '0'),
('542', 'I-444', 'I-444', 'Water Proof Paper Captain Grit-220', '2', '1', '0', '0'),
('543', 'I-445', 'I-445', 'Water Proof Paper Captain Grit-220', '2', '1', '0', '0'),
('544', 'I-446', 'I-446', 'Water Proof Paper Captain Grit-400', '2', '1', '0', '0'),
('545', 'I-447', 'I-447', 'WD-40 Aerosol 330ml', '2', '1', '0', '0'),
('546', 'I-448', 'I-448', 'Weathercoat stone sheild  primer 18LTR', '2', '1', '0', '0'),
('547', 'I-449', 'I-449', 'Webber Premix SP 33 50kg', '2', '1', '0', '0'),
('548', 'I-450', 'I-450', 'Width 120 cm.', '2', '1', '0', '0'),
('549', 'I-451', 'I-451', 'Wire Puller', '2', '1', '0', '0'),
('550', 'I-452', 'I-452', 'Wood Stick', '2', '1', '0', '0'),
('551', 'I-453', 'I-453', 'Xpert Decor Acrylic Paint Roller Mini Sleeves 4', '2', '1', '0', '0'),
('552', 'I-454', 'I-454', 'Xpert Decor Artist Brush Set (18 Pcs) # AB18', '2', '1', '0', '0'),
('553', 'I-455', 'I-455', 'Xpert Decor blue foam paint roller mini sleeves�4&quot;', '2', '1', '0', '0'),
('554', 'I-456', 'I-456', 'Xpert Decor File Scrapper FS10 10&quot;', '2', '1', '0', '0'),
('555', 'I-457', 'I-457', 'Xpert Decor Plastic Trowel SB-PT-1', '2', '1', '0', '0'),
('556', 'I-458', 'I-458', 'Xpert Decor Sanding Disc with Holes 7 Grit 120', '2', '1', '0', '0'),
('557', 'I-459', 'I-459', 'Xpert Decor Scrapper Set WHSS (50+80+100+120 MM)', '2', '1', '0', '0'),
('558', 'I-460', 'I-460', 'Xpert Decor Sponge for Canvas Effect # SCE', '2', '1', '0', '0'),
('559', 'I-461', 'I-461', 'Xpert Decor Swirl Tool SW', '2', '1', '0', '0'),
('560', 'I-462', 'I-462', 'Xpert Decor velour paint roller mini sleeves 4', '2', '1', '0', '0'),
('561', 'I-463', 'I-463', 'Xpert Decor Yarn Tool # YT1515/SB-P03', '2', '1', '0', '0'),
('562', 'I-464', 'I-464', 'XPERT MASKING TAPE 2 &quot; 30YRD', '2', '1', '0', '0'),
('563', 'I-465', 'I-465', 'Xpert Paint Brush Reg. Blue Handle 2&quot; (1050)', '2', '1', '0', '0'),
('564', 'I-466', 'I-466', 'Xpert Paint Brush Reg. Blue Handle 3&quot; (1070)', '2', '1', '0', '0'),
('565', 'I-467', 'I-467', 'Xpert Paint Brush Reg. Blue Handle 4 (1100)', '2', '1', '0', '0'),
('566', 'I-468', 'I-468', 'Xpert Paint Brush Wooden Handle 4 (2100)', '2', '1', '0', '0'),
('567', 'I-469', 'I-469', 'Xpert Polythene Sheet 200g (0.8KG Yellow)', '2', '1', '0', '0'),
('568', 'I-470', 'I-470', 'Xpert Polythene Sheet 500g (1.3KG Green)', '2', '1', '0', '0'),
('569', 'I-471', 'I-471', 'Xpert SS Decor Trowel 240 x 90mm # SB405-B', '2', '1', '0', '0'),
('570', 'I-472', 'I-472', 'Xpert Stretch Wrapping Film Clear (1.8KG)', '2', '1', '0', '0'),
('571', 'I-473', 'I-473', 'Yato Spray Gun with Metal Cup 1 Ltr (YT-2346)', '2', '1', '0', '0'),
('572', 'I-474', 'I-474', 'Yellow Bucket', '2', '1', '0', '0'),
('573', 'I-475', 'I-475', 'S T G Pvc Trunking 25 X 16 m', '2', '1', '0', '0'),
('574', 'I-476', 'I-476', 'Xpert Decor Plastic Trowel 26x7cm # SB-PT-B', '2', '1', '0', '0'),
('575', 'I-477', 'I-477', '100 x  100 x 50 mm Waterproof Box', '2', '1', '0', '0'),
('576', 'I-478', 'I-478', '13 Amp Single Switch Socket', '2', '1', '0', '0'),
('577', 'I-479', 'I-479', '13A 2 Gang Single Pole Swith Double Socket -Clad', '2', '1', '0', '0'),
('578', 'I-480', 'I-480', '2 meter threaded rod�10mm', '2', '1', '0', '0'),
('579', 'I-481', 'I-481', '20A DP Switch for FCU (Relite)', '2', '1', '0', '0'),
('580', 'I-482', 'I-482', '20MM PVC COMDUIT PIPE DD 1.6 DCH2', '2', '1', '0', '0'),
('581', 'I-483', 'I-483', '20MM PVC COUPLER DD DNC2', '2', '1', '0', '0'),
('582', 'I-484', 'I-484', '20MM PVC SLIP TYPE BEND DD DLB2', '2', '1', '0', '0'),
('583', 'I-485', 'I-485', '25MM 4 WAY PVC J/BOX DD DJF3', '2', '1', '0', '0'),
('584', 'I-486', 'I-486', '25MM PVC CONDUITE DD 1.8 DCH3', '2', '1', '0', '0'),
('585', 'I-487', 'I-487', '25MM PVC COUPLER DD DNC3', '2', '1', '0', '0'),
('586', 'I-488', 'I-488', '2G 1W Switch', '2', '1', '0', '0'),
('587', 'I-489', 'I-489', '3X3 GI BOX INDIA', '2', '1', '0', '0'),
('588', 'I-490', 'I-490', '3X3 PVC SQUARE COVER WHITE', '2', '1', '0', '0'),
('589', 'I-491', 'I-491', '3X6 GI BOX INDIA H/D', '2', '1', '0', '0'),
('590', 'I-492', 'I-492', '56089090 Dunet Bird Net Black 5 x 100 meters Roll', '2', '1', '0', '0');

### Structure of table `0_item_links` ###

DROP TABLE IF EXISTS `0_item_links`;

CREATE TABLE `0_item_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Item` varchar(30) NOT NULL,
  `link_item` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_item_links` ###

INSERT INTO `0_item_links` VALUES
('3', 'EP001', 'I-0013');

### Structure of table `0_item_specs` ###

DROP TABLE IF EXISTS `0_item_specs`;

CREATE TABLE `0_item_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(100) NOT NULL,
  `spec` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ;

### Data of table `0_item_specs` ###


### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###

INSERT INTO `0_item_tax_type_exemptions` VALUES
('1', '2'),
('1', '3'),
('1', '4'),
('1', '5');

### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `tax_code` varchar(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Taxable', '0', '0', 'ER'),
('2', 'Tax Exempt', '1', '0', 'TB');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('Bag', 'Bag', '1', '0'),
('Bale', 'Bale', '0', '0'),
('Can', 'Can', '0', '0'),
('Drum', 'Drm', '1', '0'),
('GLN', 'Gln', '1', '0'),
('Job', 'Job', '-1', '0'),
('Killogram', 'Kgs', '2', '0'),
('Lgth', 'Lgth', '0', '0'),
('Liter', 'Ltr', '0', '0'),
('Meter', 'Mtr', '0', '0'),
('N/A', 'N/A', '-1', '0'),
('NOS', 'Nos', '0', '0'),
('Packet', 'Pkt', '0', '0'),
('Pieces', 'Pcs', '0', '0'),
('PRS', 'Prs', '0', '0'),
('QTY', 'Quantity', '-1', '0'),
('Roll', 'Roll', '0', '0'),
('SQM', 'SQM', '-1', '0'),
('ST', 'ST', '0', '0'),
('yards', 'Yds', '-1', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `source_ref` varchar(60) NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###

INSERT INTO `0_journal` VALUES
('0', '1', '2023-12-31', '01', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '2', '2023-12-31', '01', '', '2023-12-31', '2023-12-31', 'AED', '86768.43', '1'),
('0', '3', '2023-12-31', 'JV-02', '', '2023-12-31', '2023-12-31', 'AED', '484531.36', '1'),
('0', '4', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '5', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '6', '2023-12-31', 'JV-04', '', '2023-12-31', '2023-12-31', 'AED', '7500925.35', '1'),
('0', '7', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '8', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '9', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '10', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '11', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '12', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '13', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '14', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '0', '1'),
('0', '15', '2023-12-31', 'JV-03', '', '2023-12-31', '2023-12-31', 'AED', '452601.83', '1');

### Structure of table `0_language` ###

DROP TABLE IF EXISTS `0_language`;

CREATE TABLE `0_language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_eng` text NOT NULL,
  `language_arb` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_language` ###

INSERT INTO `0_language` VALUES
('1', 'Sales', 'مبيعات'),
('2', 'Purchases', 'المشتريات'),
('3', 'Items and Inventory', 'العناصر والمخزون'),
('4', 'Manufacturing', 'تصنيع'),
('5', 'Fixed Assets', 'أصول ثابتة'),
('6', 'Dimensions', 'الأبعاد'),
('7', 'General Ledger', 'دفتر الأستاذ العام'),
('8', 'System Setup', 'إعداد النظام');

### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) NOT NULL DEFAULT '',
  `stock_id` char(20) NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('1', 'I-001', '0'),
('1', 'I-002', '0'),
('1', 'I-003', '0'),
('1', 'I-004', '0'),
('1', 'I-005', '0'),
('1', 'I-006', '0'),
('1', 'I-007', '0'),
('1', 'I-008', '0'),
('1', 'I-009', '0'),
('1', 'I-010', '0'),
('1', 'I-011', '0'),
('1', 'I-012', '0'),
('1', 'I-013', '0'),
('1', 'I-014', '0'),
('1', 'I-015', '0'),
('1', 'I-016', '0'),
('1', 'I-017', '0'),
('1', 'I-018', '0'),
('1', 'I-019', '0'),
('1', 'I-020', '0'),
('1', 'I-021', '0'),
('1', 'I-022', '0'),
('1', 'I-023', '0'),
('1', 'I-024', '0'),
('1', 'I-025', '0'),
('1', 'I-026', '0'),
('1', 'I-027', '0'),
('1', 'I-028', '0'),
('1', 'I-029', '0'),
('1', 'I-030', '0'),
('1', 'I-031', '0'),
('1', 'I-032', '0'),
('1', 'I-033', '0'),
('1', 'I-034', '0'),
('1', 'I-035', '0'),
('1', 'I-036', '0'),
('1', 'I-037', '0'),
('1', 'I-038', '0'),
('1', 'I-039', '0'),
('1', 'I-040', '0'),
('1', 'I-041', '0'),
('1', 'I-042', '0'),
('1', 'I-043', '0'),
('1', 'I-044', '0'),
('1', 'I-045', '0'),
('1', 'I-046', '0'),
('1', 'I-047', '0'),
('1', 'I-048', '0'),
('1', 'I-049', '0'),
('1', 'I-050', '0'),
('1', 'I-051', '0'),
('1', 'I-052', '0'),
('1', 'I-053', '0'),
('1', 'I-054', '0'),
('1', 'I-055', '0'),
('1', 'I-056', '0'),
('1', 'I-057', '0'),
('1', 'I-058', '0'),
('1', 'I-059', '0'),
('1', 'I-060', '0'),
('1', 'I-061', '0'),
('1', 'I-062', '0'),
('1', 'I-063', '0'),
('1', 'I-064', '0'),
('1', 'I-065', '0'),
('1', 'I-066', '0'),
('1', 'I-067', '0'),
('1', 'I-068', '0'),
('1', 'I-069', '0'),
('1', 'I-070', '0'),
('1', 'I-071', '0'),
('1', 'I-072', '0'),
('1', 'I-073', '0'),
('1', 'I-074', '0'),
('1', 'I-075', '0'),
('1', 'I-076', '0'),
('1', 'I-077', '0'),
('1', 'I-078', '0'),
('1', 'I-079', '0'),
('1', 'I-080', '0'),
('1', 'I-081', '0'),
('1', 'I-082', '0'),
('1', 'I-083', '0'),
('1', 'I-084', '0'),
('1', 'I-085', '0'),
('1', 'I-086', '0'),
('1', 'I-087', '0'),
('1', 'I-088', '0'),
('1', 'I-089', '0'),
('1', 'I-090', '0'),
('1', 'I-091', '0'),
('1', 'I-092', '0'),
('1', 'I-093', '0'),
('1', 'I-094', '0'),
('1', 'I-095', '0'),
('1', 'I-096', '0'),
('1', 'I-097', '0'),
('1', 'I-098', '0'),
('1', 'I-099', '0'),
('1', 'I-100', '0'),
('1', 'I-101', '0'),
('1', 'I-102', '0'),
('1', 'I-103', '0'),
('1', 'I-104', '0'),
('1', 'I-105', '0'),
('1', 'I-106', '0'),
('1', 'I-107', '0'),
('1', 'I-108', '0'),
('1', 'I-109', '0'),
('1', 'I-110', '0'),
('1', 'I-111', '0'),
('1', 'I-112', '0'),
('1', 'I-113', '0'),
('1', 'I-114', '0'),
('1', 'I-115', '0'),
('1', 'I-116', '0'),
('1', 'I-117', '0'),
('1', 'I-118', '0'),
('1', 'I-119', '0'),
('1', 'I-120', '0'),
('1', 'I-121', '0'),
('1', 'I-122', '0'),
('1', 'I-123', '0'),
('1', 'I-124', '0'),
('1', 'I-125', '0'),
('1', 'I-126', '0'),
('1', 'I-127', '0'),
('1', 'I-128', '0'),
('1', 'I-129', '0'),
('1', 'I-130', '0'),
('1', 'I-131', '0'),
('1', 'I-132', '0'),
('1', 'I-133', '0'),
('1', 'I-134', '0'),
('1', 'I-135', '0'),
('1', 'I-136', '0'),
('1', 'I-137', '0'),
('1', 'I-138', '0'),
('1', 'I-139', '0'),
('1', 'I-140', '0'),
('1', 'I-141', '0'),
('1', 'I-142', '0'),
('1', 'I-143', '0'),
('1', 'I-144', '0'),
('1', 'I-145', '0'),
('1', 'I-146', '0'),
('1', 'I-147', '0'),
('1', 'I-148', '0'),
('1', 'I-149', '0'),
('1', 'I-150', '0'),
('1', 'I-151', '0'),
('1', 'I-152', '0'),
('1', 'I-153', '0'),
('1', 'I-154', '0'),
('1', 'I-155', '0'),
('1', 'I-156', '0'),
('1', 'I-157', '0'),
('1', 'I-158', '0'),
('1', 'I-159', '0'),
('1', 'I-160', '0'),
('1', 'I-161', '0'),
('1', 'I-162', '0'),
('1', 'I-163', '0'),
('1', 'I-164', '0'),
('1', 'I-165', '0'),
('1', 'I-166', '0'),
('1', 'I-167', '0'),
('1', 'I-168', '0'),
('1', 'I-169', '0'),
('1', 'I-170', '0'),
('1', 'I-171', '0'),
('1', 'I-172', '0'),
('1', 'I-173', '0'),
('1', 'I-174', '0'),
('1', 'I-175', '0'),
('1', 'I-176', '0'),
('1', 'I-177', '0'),
('1', 'I-178', '0'),
('1', 'I-179', '0'),
('1', 'I-180', '0'),
('1', 'I-181', '0'),
('1', 'I-182', '0'),
('1', 'I-183', '0'),
('1', 'I-184', '0'),
('1', 'I-185', '0'),
('1', 'I-186', '0'),
('1', 'I-187', '0'),
('1', 'I-188', '0'),
('1', 'I-189', '0'),
('1', 'I-190', '0'),
('1', 'I-191', '0'),
('1', 'I-192', '0'),
('1', 'I-193', '0'),
('1', 'I-194', '0'),
('1', 'I-195', '0'),
('1', 'I-196', '0'),
('1', 'I-197', '0'),
('1', 'I-198', '0'),
('1', 'I-199', '0'),
('1', 'I-200', '0'),
('1', 'I-201', '0'),
('1', 'I-202', '0'),
('1', 'I-203', '0'),
('1', 'I-204', '0'),
('1', 'I-205', '0'),
('1', 'I-206', '0'),
('1', 'I-207', '0'),
('1', 'I-208', '0'),
('1', 'I-209', '0'),
('1', 'I-210', '0'),
('1', 'I-211', '0'),
('1', 'I-212', '0'),
('1', 'I-213', '0'),
('1', 'I-214', '0'),
('1', 'I-215', '0'),
('1', 'I-216', '0'),
('1', 'I-217', '0'),
('1', 'I-218', '0'),
('1', 'I-219', '0'),
('1', 'I-220', '0'),
('1', 'I-221', '0'),
('1', 'I-222', '0'),
('1', 'I-223', '0'),
('1', 'I-224', '0'),
('1', 'I-225', '0'),
('1', 'I-226', '0'),
('1', 'I-227', '0'),
('1', 'I-228', '0'),
('1', 'I-229', '0'),
('1', 'I-230', '0'),
('1', 'I-231', '0'),
('1', 'I-232', '0'),
('1', 'I-233', '0'),
('1', 'I-234', '0'),
('1', 'I-235', '0'),
('1', 'I-236', '0'),
('1', 'I-237', '0'),
('1', 'I-238', '0'),
('1', 'I-239', '0'),
('1', 'I-240', '0'),
('1', 'I-241', '0'),
('1', 'I-242', '0'),
('1', 'I-243', '0'),
('1', 'I-244', '0'),
('1', 'I-245', '0'),
('1', 'I-246', '0'),
('1', 'I-247', '0'),
('1', 'I-248', '0'),
('1', 'I-249', '0'),
('1', 'I-250', '0'),
('1', 'I-251', '0'),
('1', 'I-252', '0'),
('1', 'I-253', '0'),
('1', 'I-254', '0'),
('1', 'I-255', '0'),
('1', 'I-256', '0'),
('1', 'I-257', '0'),
('1', 'I-258', '0'),
('1', 'I-259', '0'),
('1', 'I-260', '0'),
('1', 'I-261', '0'),
('1', 'I-262', '0'),
('1', 'I-263', '0'),
('1', 'I-264', '0'),
('1', 'I-265', '0'),
('1', 'I-266', '0'),
('1', 'I-267', '0'),
('1', 'I-268', '0'),
('1', 'I-269', '0'),
('1', 'I-270', '0'),
('1', 'I-271', '0'),
('1', 'I-272', '0'),
('1', 'I-273', '0'),
('1', 'I-274', '0'),
('1', 'I-275', '0'),
('1', 'I-276', '0'),
('1', 'I-277', '0'),
('1', 'I-278', '0'),
('1', 'I-279', '0'),
('1', 'I-280', '0'),
('1', 'I-281', '0'),
('1', 'I-282', '0'),
('1', 'I-283', '0'),
('1', 'I-284', '0'),
('1', 'I-285', '0'),
('1', 'I-286', '0'),
('1', 'I-287', '0'),
('1', 'I-288', '0'),
('1', 'I-289', '0'),
('1', 'I-290', '0'),
('1', 'I-291', '0'),
('1', 'I-292', '0'),
('1', 'I-293', '0'),
('1', 'I-294', '0'),
('1', 'I-295', '0'),
('1', 'I-296', '0'),
('1', 'I-297', '0'),
('1', 'I-298', '0'),
('1', 'I-299', '0'),
('1', 'I-300', '0'),
('1', 'I-301', '0'),
('1', 'I-302', '0'),
('1', 'I-303', '0'),
('1', 'I-304', '0'),
('1', 'I-305', '0'),
('1', 'I-306', '0'),
('1', 'I-307', '0'),
('1', 'I-308', '0'),
('1', 'I-309', '0'),
('1', 'I-310', '0'),
('1', 'I-311', '0'),
('1', 'I-312', '0'),
('1', 'I-313', '0'),
('1', 'I-314', '0'),
('1', 'I-315', '0'),
('1', 'I-316', '0'),
('1', 'I-317', '0'),
('1', 'I-318', '0'),
('1', 'I-319', '0'),
('1', 'I-320', '0'),
('1', 'I-321', '0'),
('1', 'I-322', '0'),
('1', 'I-323', '0'),
('1', 'I-324', '0'),
('1', 'I-325', '0'),
('1', 'I-326', '0'),
('1', 'I-327', '0'),
('1', 'I-328', '0'),
('1', 'I-329', '0'),
('1', 'I-330', '0'),
('1', 'I-331', '0'),
('1', 'I-332', '0'),
('1', 'I-333', '0'),
('1', 'I-334', '0'),
('1', 'I-335', '0'),
('1', 'I-336', '0'),
('1', 'I-337', '0'),
('1', 'I-338', '0'),
('1', 'I-339', '0'),
('1', 'I-340', '0'),
('1', 'I-341', '0'),
('1', 'I-342', '0'),
('1', 'I-343', '0'),
('1', 'I-344', '0'),
('1', 'I-345', '0'),
('1', 'I-346', '0'),
('1', 'I-347', '0'),
('1', 'I-348', '0'),
('1', 'I-349', '0'),
('1', 'I-350', '0'),
('1', 'I-351', '0'),
('1', 'I-352', '0'),
('1', 'I-353', '0'),
('1', 'I-354', '0'),
('1', 'I-355', '0'),
('1', 'I-356', '0'),
('1', 'I-357', '0'),
('1', 'I-358', '0'),
('1', 'I-359', '0'),
('1', 'I-360', '0'),
('1', 'I-361', '0'),
('1', 'I-362', '0'),
('1', 'I-363', '0'),
('1', 'I-364', '0'),
('1', 'I-365', '0'),
('1', 'I-366', '0'),
('1', 'I-367', '0'),
('1', 'I-368', '0'),
('1', 'I-369', '0'),
('1', 'I-370', '0'),
('1', 'I-371', '0'),
('1', 'I-372', '0'),
('1', 'I-373', '0'),
('1', 'I-374', '0'),
('1', 'I-375', '0'),
('1', 'I-376', '0'),
('1', 'I-377', '0'),
('1', 'I-378', '0'),
('1', 'I-379', '0'),
('1', 'I-380', '0'),
('1', 'I-381', '0'),
('1', 'I-382', '0'),
('1', 'I-383', '0'),
('1', 'I-384', '0'),
('1', 'I-385', '0'),
('1', 'I-386', '0'),
('1', 'I-387', '0'),
('1', 'I-388', '0'),
('1', 'I-389', '0'),
('1', 'I-390', '0'),
('1', 'I-391', '0'),
('1', 'I-392', '0'),
('1', 'I-393', '0'),
('1', 'I-394', '0'),
('1', 'I-395', '0'),
('1', 'I-396', '0'),
('1', 'I-397', '0'),
('1', 'I-398', '0'),
('1', 'I-399', '0'),
('1', 'I-400', '0'),
('1', 'I-401', '0'),
('1', 'I-402', '0'),
('1', 'I-403', '0'),
('1', 'I-404', '0'),
('1', 'I-405', '0'),
('1', 'I-406', '0'),
('1', 'I-407', '0'),
('1', 'I-408', '0'),
('1', 'I-409', '0'),
('1', 'I-410', '0'),
('1', 'I-411', '0'),
('1', 'I-412', '0'),
('1', 'I-413', '0'),
('1', 'I-414', '0'),
('1', 'I-415', '0'),
('1', 'I-416', '0'),
('1', 'I-417', '0'),
('1', 'I-418', '0'),
('1', 'I-419', '0'),
('1', 'I-420', '0'),
('1', 'I-421', '0'),
('1', 'I-422', '0'),
('1', 'I-423', '0'),
('1', 'I-424', '0'),
('1', 'I-425', '0'),
('1', 'I-426', '0'),
('1', 'I-427', '0'),
('1', 'I-428', '0'),
('1', 'I-429', '0'),
('1', 'I-430', '0'),
('1', 'I-431', '0'),
('1', 'I-432', '0'),
('1', 'I-433', '0'),
('1', 'I-434', '0'),
('1', 'I-435', '0'),
('1', 'I-436', '0'),
('1', 'I-437', '0'),
('1', 'I-438', '0'),
('1', 'I-439', '0'),
('1', 'I-440', '0'),
('1', 'I-441', '0'),
('1', 'I-442', '0'),
('1', 'I-443', '0'),
('1', 'I-444', '0'),
('1', 'I-445', '0'),
('1', 'I-446', '0'),
('1', 'I-447', '0'),
('1', 'I-448', '0'),
('1', 'I-449', '0'),
('1', 'I-450', '0'),
('1', 'I-451', '0'),
('1', 'I-452', '0'),
('1', 'I-453', '0'),
('1', 'I-454', '0'),
('1', 'I-455', '0'),
('1', 'I-456', '0'),
('1', 'I-457', '0'),
('1', 'I-458', '0'),
('1', 'I-459', '0'),
('1', 'I-460', '0'),
('1', 'I-461', '0'),
('1', 'I-462', '0'),
('1', 'I-463', '0'),
('1', 'I-464', '0'),
('1', 'I-465', '0'),
('1', 'I-466', '0'),
('1', 'I-467', '0'),
('1', 'I-468', '0'),
('1', 'I-469', '0'),
('1', 'I-470', '0'),
('1', 'I-471', '0'),
('1', 'I-472', '0'),
('1', 'I-473', '0'),
('1', 'I-474', '0'),
('1', 'I-475', '0'),
('1', 'I-476', '0'),
('1', 'I-477', '0'),
('1', 'I-478', '0'),
('1', 'I-479', '0'),
('1', 'I-480', '0'),
('1', 'I-481', '0'),
('1', 'I-482', '0'),
('1', 'I-483', '0'),
('1', 'I-484', '0'),
('1', 'I-485', '0'),
('1', 'I-486', '0'),
('1', 'I-487', '0'),
('1', 'I-488', '0'),
('1', 'I-489', '0'),
('1', 'I-490', '0'),
('1', 'I-491', '0'),
('1', 'I-492', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `location_name` varchar(60) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `location_name_arabic` varchar(100) NOT NULL,
  `main_store` int(1) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `excise_tax` tinyint(1) NOT NULL,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Default ', '', '', '', '', '', '', '0', '', '0', '0', '0');

### Structure of table `0_loyality_points` ###

DROP TABLE IF EXISTS `0_loyality_points`;

CREATE TABLE `0_loyality_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `redeem` double NOT NULL,
  `points` double NOT NULL,
  `debtor_no` int(11) NOT NULL,
  `trans_no` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `used` int(1) NOT NULL,
  `cust_name` varchar(100) NOT NULL,
  `country_code` int(5) NOT NULL,
  `cust_phone` varchar(20) NOT NULL,
  `cust_email` varchar(100) NOT NULL,
  `branch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_loyality_points` ###


### Structure of table `0_mail_signature` ###

DROP TABLE IF EXISTS `0_mail_signature`;

CREATE TABLE `0_mail_signature` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `designation` varchar(50) NOT NULL,
  `address` varchar(50) NOT NULL,
  `phone` int(50) NOT NULL,
  `fax` int(50) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `web_link` varchar(100) NOT NULL,
  `fb_link` varchar(100) NOT NULL,
  `twitter_link` varchar(100) NOT NULL,
  `linkedin_link` varchar(100) NOT NULL,
  `google_plus_link` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `signature_type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_mail_signature` ###


### Structure of table `0_maintenance_form` ###

DROP TABLE IF EXISTS `0_maintenance_form`;

CREATE TABLE `0_maintenance_form` (
  `#` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL,
  `Email` varchar(100) NOT NULL,
  `Phone` varchar(100) NOT NULL,
  `Factor` int(11) NOT NULL,
  `Authority` int(11) NOT NULL,
  `Inactive` int(11) NOT NULL,
  `dropdown` varchar(100) NOT NULL,
  PRIMARY KEY (`#`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_maintenance_form` ###


### Structure of table `0_material_req_details` ###

DROP TABLE IF EXISTS `0_material_req_details`;

CREATE TABLE `0_material_req_details` (
  `material_req_detail_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `material_req_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `lpo_id` int(11) NOT NULL,
  `order_quantity` int(11) NOT NULL,
  `estimate_price` double NOT NULL,
  `quantity` double NOT NULL,
  `price` double NOT NULL,
  `purpose` varchar(320) NOT NULL,
  PRIMARY KEY (`material_req_detail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_material_req_details` ###


### Structure of table `0_material_requisition` ###

DROP TABLE IF EXISTS `0_material_requisition`;

CREATE TABLE `0_material_requisition` (
  `material_req_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) NOT NULL,
  `narrative` varchar(240) NOT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed` tinyint(4) NOT NULL,
  `inactive` tinyint(4) NOT NULL,
  `transfered` int(11) NOT NULL,
  `transaction_date` date NOT NULL,
  `user_name` varchar(30) NOT NULL COMMENT 'to username',
  `user_location` varchar(30) NOT NULL COMMENT 'tp locattion',
  `from_user` int(11) NOT NULL,
  `from_location` varchar(30) NOT NULL,
  `stock_moves_id` int(11) NOT NULL,
  `details` varchar(100) NOT NULL,
  PRIMARY KEY (`material_req_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_material_requisition` ###


### Structure of table `0_modules` ###

DROP TABLE IF EXISTS `0_modules`;

CREATE TABLE `0_modules` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `module` varchar(100) NOT NULL COMMENT 'Main Module',
  `submodule` varchar(100) NOT NULL COMMENT 'Sub Module',
  `screen` varchar(100) NOT NULL COMMENT 'Original Screen Name',
  `name` varchar(100) NOT NULL COMMENT 'Change Module Name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_modules` ###


### Structure of table `0_otp_code` ###

DROP TABLE IF EXISTS `0_otp_code`;

CREATE TABLE `0_otp_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL,
  `code` varchar(50) NOT NULL,
  `used` int(1) NOT NULL,
  `cust_phone` varchar(50) NOT NULL,
  `country_code` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_otp_code` ###


### Structure of table `0_overtime` ###

DROP TABLE IF EXISTS `0_overtime`;

CREATE TABLE `0_overtime` (
  `overtime_id` int(11) NOT NULL,
  `overtime_name` varchar(100) NOT NULL,
  `overtime_rate` float NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`overtime_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_overtime` ###


### Structure of table `0_overtime_weekend` ###

DROP TABLE IF EXISTS `0_overtime_weekend`;

CREATE TABLE `0_overtime_weekend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `days` varchar(80) NOT NULL,
  `ot_factor` float NOT NULL,
  `is_weekend` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_overtime_weekend` ###


### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'Due on Presentation', '1', '0', '0'),
('2', 'Cash Only', '0', '0', '0'),
('3', '75% Advance &amp; Balance Upon Completion', '1', '0', '0'),
('4', 'Advance', '1', '0', '0'),
('5', '50 % Advance &amp; Balance Upon Completion', '1', '0', '0'),
('6', '50%adv,30% on 50% of  com. &amp; 20% on com.', '1', '0', '0'),
('7', '100 % Upon Completion', '1', '0', '0'),
('8', 'Customer 60 days', '60', '0', '0'),
('9', '50%adv,25% on 50% of  com. &amp; bal on com.', '1', '0', '0');

### Structure of table `0_payroll_account` ###

DROP TABLE IF EXISTS `0_payroll_account`;

CREATE TABLE `0_payroll_account` (
  `account_id` int(11) NOT NULL,
  `account_code` varchar(15) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_account` ###


### Structure of table `0_payroll_allocations` ###

DROP TABLE IF EXISTS `0_payroll_allocations`;

CREATE TABLE `0_payroll_allocations` (
  `id` int(11) NOT NULL,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_allocations` ###


### Structure of table `0_payroll_allowances` ###

DROP TABLE IF EXISTS `0_payroll_allowances`;

CREATE TABLE `0_payroll_allowances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `allowances` varchar(100) NOT NULL,
  `inactive` int(1) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `payroll_exp` varchar(50) NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_payroll_allowances` ###


### Structure of table `0_payroll_allowances_deductions` ###

DROP TABLE IF EXISTS `0_payroll_allowances_deductions`;

CREATE TABLE `0_payroll_allowances_deductions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(11) NOT NULL,
  `allow_deduct_id` varchar(100) NOT NULL,
  `amount` float NOT NULL,
  `remarks` text NOT NULL,
  `is_allowances` enum('1','2') NOT NULL COMMENT '1=> allownaces, 2=> deductions',
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_payroll_allowances_deductions` ###


### Structure of table `0_payroll_deductions` ###

DROP TABLE IF EXISTS `0_payroll_deductions`;

CREATE TABLE `0_payroll_deductions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `deductions` varchar(100) NOT NULL,
  `inactive` int(1) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `payroll_exp` varchar(15) NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_payroll_deductions` ###


### Structure of table `0_payroll_email` ###

DROP TABLE IF EXISTS `0_payroll_email`;

CREATE TABLE `0_payroll_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(100) NOT NULL,
  `email_text` longtext NOT NULL,
  `subject` varchar(100) NOT NULL,
  `from_user_id` varchar(100) NOT NULL,
  `trans_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `mail_attachment` varchar(200) NOT NULL,
  `read_status` tinyint(11) NOT NULL COMMENT 'read =1 and unread =0',
  `notification_status` int(11) NOT NULL DEFAULT 0,
  `deleted` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  `trash` tinyint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT ;

### Data of table `0_payroll_email` ###


### Structure of table `0_payroll_holidays` ###

DROP TABLE IF EXISTS `0_payroll_holidays`;

CREATE TABLE `0_payroll_holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `holidays` varchar(50) NOT NULL,
  `description` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `inactive` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_payroll_holidays` ###


### Structure of table `0_payroll_structure` ###

DROP TABLE IF EXISTS `0_payroll_structure`;

CREATE TABLE `0_payroll_structure` (
  `salary_scale_id` int(11) NOT NULL,
  `payroll_rule` text NOT NULL,
  KEY `salary_scale_id` (`salary_scale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_structure` ###


### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB AUTO_INCREMENT=1189 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###

INSERT INTO `0_prices` VALUES
('1', 'EXP-001', '1', 'AED', '0'),
('2', 'EXP-002', '1', 'AED', '0'),
('3', 'EXP-003', '1', 'AED', '0'),
('4', 'EXP-004', '1', 'AED', '0'),
('5', 'EXP-005', '1', 'AED', '0'),
('6', 'EXP-006', '1', 'AED', '0'),
('7', 'EXP-007', '1', 'AED', '0'),
('8', 'EXP-008', '1', 'AED', '0'),
('9', 'EXP-009', '1', 'AED', '0'),
('10', 'EXP-010', '1', 'AED', '0'),
('11', 'EXP-011', '1', 'AED', '0'),
('12', 'EXP-012', '1', 'AED', '0'),
('13', 'EXP-013', '1', 'AED', '0'),
('14', 'EXP-014', '1', 'AED', '0'),
('15', 'EXP-015', '1', 'AED', '0'),
('16', 'EXP-016', '1', 'AED', '0'),
('17', 'EXP-017', '1', 'AED', '0'),
('18', 'EXP-018', '1', 'AED', '0'),
('19', 'EXP-019', '1', 'AED', '0'),
('20', 'EXP-020', '1', 'AED', '0'),
('21', 'EXP-021', '1', 'AED', '0'),
('22', 'EXP-022', '1', 'AED', '0'),
('23', 'EXP-023', '1', 'AED', '0'),
('24', 'EXP-024', '1', 'AED', '0'),
('25', 'EXP-025', '1', 'AED', '0'),
('26', 'EXP-026', '1', 'AED', '0'),
('27', 'EXP-027', '1', 'AED', '0'),
('28', 'EXP-028', '1', 'AED', '0'),
('29', 'EXP-029', '1', 'AED', '0'),
('30', 'EXP-030', '1', 'AED', '0'),
('31', 'EXP-031', '1', 'AED', '0'),
('32', 'EXP-032', '1', 'AED', '0'),
('33', 'EXP-033', '1', 'AED', '0'),
('34', 'EXP-034', '1', 'AED', '0'),
('35', 'EXP-035', '1', 'AED', '0'),
('36', 'EXP-036', '1', 'AED', '0'),
('37', 'EXP-037', '1', 'AED', '0'),
('38', 'EXP-038', '1', 'AED', '0'),
('39', 'EXP-039', '1', 'AED', '0'),
('40', 'EXP-040', '1', 'AED', '0'),
('41', 'EXP-041', '1', 'AED', '0'),
('42', 'EXP-042', '1', 'AED', '0'),
('43', 'EXP-043', '1', 'AED', '0'),
('44', 'EXP-044', '1', 'AED', '0'),
('45', 'EXP-045', '1', 'AED', '0'),
('46', 'EXP-046', '1', 'AED', '0'),
('47', 'EXP-047', '1', 'AED', '0'),
('48', 'EXP-048', '1', 'AED', '0'),
('49', 'EXP-049', '1', 'AED', '0'),
('50', 'EXP-050', '1', 'AED', '0'),
('51', 'EXP-051', '1', 'AED', '0'),
('52', 'EXP-052', '1', 'AED', '0'),
('53', 'EXP-053', '1', 'AED', '0'),
('54', 'EXP-054', '1', 'AED', '0'),
('55', 'EXP-055', '1', 'AED', '0'),
('56', 'EXP-056', '1', 'AED', '0'),
('57', 'EXP-057', '1', 'AED', '0'),
('58', 'EXP-058', '1', 'AED', '0'),
('59', 'EXP-059', '1', 'AED', '0'),
('60', 'EXP-060', '1', 'AED', '0'),
('61', 'EXP-061', '1', 'AED', '0'),
('62', 'EXP-062', '1', 'AED', '0'),
('63', 'EXP-063', '1', 'AED', '0'),
('64', 'EXP-064', '1', 'AED', '0'),
('65', 'EXP-065', '1', 'AED', '0'),
('66', 'EXP-066', '1', 'AED', '0'),
('67', 'EXP-067', '1', 'AED', '0'),
('68', 'EXP-068', '1', 'AED', '0'),
('69', 'EXP-069', '1', 'AED', '0'),
('70', 'EXP-070', '1', 'AED', '0'),
('71', 'EXP-071', '1', 'AED', '0'),
('72', 'EXP-072', '1', 'AED', '0'),
('73', 'EXP-073', '1', 'AED', '0'),
('74', 'EXP-074', '1', 'AED', '0'),
('75', 'EXP-075', '1', 'AED', '0'),
('76', 'EXP-076', '1', 'AED', '0'),
('77', 'EXP-077', '1', 'AED', '0'),
('78', 'EXP-078', '1', 'AED', '0'),
('79', 'EXP-079', '1', 'AED', '0'),
('80', 'EXP-080', '1', 'AED', '0'),
('81', 'EXP-081', '1', 'AED', '0'),
('82', 'EXP-082', '1', 'AED', '0'),
('83', 'EXP-083', '1', 'AED', '0'),
('84', 'EXP-084', '1', 'AED', '0'),
('85', 'S-001', '1', 'AED', '0'),
('86', 'S-002', '1', 'AED', '0'),
('87', 'S-003', '1', 'AED', '0'),
('88', 'S-004', '1', 'AED', '0'),
('89', 'S-005', '1', 'AED', '0'),
('90', 'S-006', '1', 'AED', '0'),
('91', 'S-007', '1', 'AED', '0'),
('92', 'S-008', '1', 'AED', '0'),
('93', 'S-009', '1', 'AED', '0'),
('94', 'S-010', '1', 'AED', '0'),
('95', 'S-011', '1', 'AED', '0'),
('96', 'S-012', '1', 'AED', '0'),
('97', 'S-013', '1', 'AED', '0'),
('98', 'S-014', '1', 'AED', '0'),
('99', 'S-015', '1', 'AED', '0'),
('100', 'S-016', '1', 'AED', '0'),
('101', 'S-017', '1', 'AED', '0'),
('102', 'S-018', '1', 'AED', '0'),
('103', 'I-001', '1', 'AED', '0'),
('104', 'I-002', '1', 'AED', '0'),
('105', 'I-003', '1', 'AED', '0'),
('106', 'I-004', '1', 'AED', '0'),
('107', 'I-005', '1', 'AED', '0'),
('108', 'I-006', '1', 'AED', '0'),
('109', 'I-007', '1', 'AED', '0'),
('110', 'I-008', '1', 'AED', '0'),
('111', 'I-009', '1', 'AED', '0'),
('112', 'I-010', '1', 'AED', '0'),
('113', 'I-011', '1', 'AED', '0'),
('114', 'I-012', '1', 'AED', '0'),
('115', 'I-013', '1', 'AED', '0'),
('116', 'I-014', '1', 'AED', '0'),
('117', 'I-015', '1', 'AED', '0'),
('118', 'I-016', '1', 'AED', '0'),
('119', 'I-017', '1', 'AED', '0'),
('120', 'I-018', '1', 'AED', '0'),
('121', 'I-019', '1', 'AED', '0'),
('122', 'I-020', '1', 'AED', '0'),
('123', 'I-021', '1', 'AED', '0'),
('124', 'I-022', '1', 'AED', '0'),
('125', 'I-023', '1', 'AED', '0'),
('126', 'I-024', '1', 'AED', '0'),
('127', 'I-025', '1', 'AED', '0'),
('128', 'I-026', '1', 'AED', '0'),
('129', 'I-027', '1', 'AED', '0'),
('130', 'I-028', '1', 'AED', '0'),
('131', 'I-029', '1', 'AED', '0'),
('132', 'I-030', '1', 'AED', '0'),
('133', 'I-031', '1', 'AED', '0'),
('134', 'I-032', '1', 'AED', '0'),
('135', 'I-033', '1', 'AED', '0'),
('136', 'I-034', '1', 'AED', '0'),
('137', 'I-035', '1', 'AED', '0'),
('138', 'I-036', '1', 'AED', '0'),
('139', 'I-037', '1', 'AED', '0'),
('140', 'I-038', '1', 'AED', '0'),
('141', 'I-039', '1', 'AED', '0'),
('142', 'I-040', '1', 'AED', '0'),
('143', 'I-041', '1', 'AED', '0'),
('144', 'I-042', '1', 'AED', '0'),
('145', 'I-043', '1', 'AED', '0'),
('146', 'I-044', '1', 'AED', '0'),
('147', 'I-045', '1', 'AED', '0'),
('148', 'I-046', '1', 'AED', '0'),
('149', 'I-047', '1', 'AED', '0'),
('150', 'I-048', '1', 'AED', '0'),
('151', 'I-049', '1', 'AED', '0'),
('152', 'I-050', '1', 'AED', '0'),
('153', 'I-051', '1', 'AED', '0'),
('154', 'I-052', '1', 'AED', '0'),
('155', 'I-053', '1', 'AED', '0'),
('156', 'I-054', '1', 'AED', '0'),
('157', 'I-055', '1', 'AED', '0'),
('158', 'I-056', '1', 'AED', '0'),
('159', 'I-057', '1', 'AED', '0'),
('160', 'I-058', '1', 'AED', '0'),
('161', 'I-059', '1', 'AED', '0'),
('162', 'I-060', '1', 'AED', '0'),
('163', 'I-061', '1', 'AED', '0'),
('164', 'I-062', '1', 'AED', '0'),
('165', 'I-063', '1', 'AED', '0'),
('166', 'I-064', '1', 'AED', '0'),
('167', 'I-065', '1', 'AED', '0'),
('168', 'I-066', '1', 'AED', '0'),
('169', 'I-067', '1', 'AED', '0'),
('170', 'I-068', '1', 'AED', '0'),
('171', 'I-069', '1', 'AED', '0'),
('172', 'I-070', '1', 'AED', '0'),
('173', 'I-071', '1', 'AED', '0'),
('174', 'I-072', '1', 'AED', '0'),
('175', 'I-073', '1', 'AED', '0'),
('176', 'I-074', '1', 'AED', '0'),
('177', 'I-075', '1', 'AED', '0'),
('178', 'I-076', '1', 'AED', '0'),
('179', 'I-077', '1', 'AED', '0'),
('180', 'I-078', '1', 'AED', '0'),
('181', 'I-079', '1', 'AED', '0'),
('182', 'I-080', '1', 'AED', '0'),
('183', 'I-081', '1', 'AED', '0'),
('184', 'I-082', '1', 'AED', '0'),
('185', 'I-083', '1', 'AED', '0'),
('186', 'I-084', '1', 'AED', '0'),
('187', 'I-085', '1', 'AED', '0'),
('188', 'I-086', '1', 'AED', '0'),
('189', 'I-087', '1', 'AED', '0'),
('190', 'I-088', '1', 'AED', '0'),
('191', 'I-089', '1', 'AED', '0'),
('192', 'I-090', '1', 'AED', '0'),
('193', 'I-091', '1', 'AED', '0'),
('194', 'I-092', '1', 'AED', '0'),
('195', 'I-093', '1', 'AED', '0'),
('196', 'I-094', '1', 'AED', '0'),
('197', 'I-095', '1', 'AED', '0'),
('198', 'I-096', '1', 'AED', '0'),
('199', 'I-097', '1', 'AED', '0'),
('200', 'I-098', '1', 'AED', '0'),
('201', 'I-099', '1', 'AED', '0'),
('202', 'I-100', '1', 'AED', '0'),
('203', 'I-101', '1', 'AED', '0'),
('204', 'I-102', '1', 'AED', '0'),
('205', 'I-103', '1', 'AED', '0'),
('206', 'I-104', '1', 'AED', '0'),
('207', 'I-105', '1', 'AED', '0'),
('208', 'I-106', '1', 'AED', '0'),
('209', 'I-107', '1', 'AED', '0'),
('210', 'I-108', '1', 'AED', '0'),
('211', 'I-109', '1', 'AED', '0'),
('212', 'I-110', '1', 'AED', '0'),
('213', 'I-111', '1', 'AED', '0'),
('214', 'I-112', '1', 'AED', '0'),
('215', 'I-113', '1', 'AED', '0'),
('216', 'I-114', '1', 'AED', '0'),
('217', 'I-115', '1', 'AED', '0'),
('218', 'I-116', '1', 'AED', '0'),
('219', 'I-117', '1', 'AED', '0'),
('220', 'I-118', '1', 'AED', '0'),
('221', 'I-119', '1', 'AED', '0'),
('222', 'I-120', '1', 'AED', '0'),
('223', 'I-121', '1', 'AED', '0'),
('224', 'I-122', '1', 'AED', '0'),
('225', 'I-123', '1', 'AED', '0'),
('226', 'I-124', '1', 'AED', '0'),
('227', 'I-125', '1', 'AED', '0'),
('228', 'I-126', '1', 'AED', '0'),
('229', 'I-127', '1', 'AED', '0'),
('230', 'I-128', '1', 'AED', '0'),
('231', 'I-129', '1', 'AED', '0'),
('232', 'I-130', '1', 'AED', '0'),
('233', 'I-131', '1', 'AED', '0'),
('234', 'I-132', '1', 'AED', '0'),
('235', 'I-133', '1', 'AED', '0'),
('236', 'I-134', '1', 'AED', '0'),
('237', 'I-135', '1', 'AED', '0'),
('238', 'I-136', '1', 'AED', '0'),
('239', 'I-137', '1', 'AED', '0'),
('240', 'I-138', '1', 'AED', '0'),
('241', 'I-139', '1', 'AED', '0'),
('242', 'I-140', '1', 'AED', '0'),
('243', 'I-141', '1', 'AED', '0'),
('244', 'I-142', '1', 'AED', '0'),
('245', 'I-143', '1', 'AED', '0'),
('246', 'I-144', '1', 'AED', '0'),
('247', 'I-145', '1', 'AED', '0'),
('248', 'I-146', '1', 'AED', '0'),
('249', 'I-147', '1', 'AED', '0'),
('250', 'I-148', '1', 'AED', '0'),
('251', 'I-149', '1', 'AED', '0'),
('252', 'I-150', '1', 'AED', '0'),
('253', 'I-151', '1', 'AED', '0'),
('254', 'I-152', '1', 'AED', '0'),
('255', 'I-153', '1', 'AED', '0'),
('256', 'I-154', '1', 'AED', '0'),
('257', 'I-155', '1', 'AED', '0'),
('258', 'I-156', '1', 'AED', '0'),
('259', 'I-157', '1', 'AED', '0'),
('260', 'I-158', '1', 'AED', '0'),
('261', 'I-159', '1', 'AED', '0'),
('262', 'I-160', '1', 'AED', '0'),
('263', 'I-161', '1', 'AED', '0'),
('264', 'I-162', '1', 'AED', '0'),
('265', 'I-163', '1', 'AED', '0'),
('266', 'I-164', '1', 'AED', '0'),
('267', 'I-165', '1', 'AED', '0'),
('268', 'I-166', '1', 'AED', '0'),
('269', 'I-167', '1', 'AED', '0'),
('270', 'I-168', '1', 'AED', '0'),
('271', 'I-169', '1', 'AED', '0'),
('272', 'I-170', '1', 'AED', '0'),
('273', 'I-171', '1', 'AED', '0'),
('274', 'I-172', '1', 'AED', '0'),
('275', 'I-173', '1', 'AED', '0'),
('276', 'I-174', '1', 'AED', '0'),
('277', 'I-175', '1', 'AED', '0'),
('278', 'I-176', '1', 'AED', '0'),
('279', 'I-177', '1', 'AED', '0'),
('280', 'I-178', '1', 'AED', '0'),
('281', 'I-179', '1', 'AED', '0'),
('282', 'I-180', '1', 'AED', '0'),
('283', 'I-181', '1', 'AED', '0'),
('284', 'I-182', '1', 'AED', '0'),
('285', 'I-183', '1', 'AED', '0'),
('286', 'I-184', '1', 'AED', '0'),
('287', 'I-185', '1', 'AED', '0'),
('288', 'I-186', '1', 'AED', '0'),
('289', 'I-187', '1', 'AED', '0'),
('290', 'I-188', '1', 'AED', '0'),
('291', 'I-189', '1', 'AED', '0'),
('292', 'I-190', '1', 'AED', '0'),
('293', 'I-191', '1', 'AED', '0'),
('294', 'I-192', '1', 'AED', '0'),
('295', 'I-193', '1', 'AED', '0'),
('296', 'I-194', '1', 'AED', '0'),
('297', 'I-195', '1', 'AED', '0'),
('298', 'I-196', '1', 'AED', '0'),
('299', 'I-197', '1', 'AED', '0'),
('300', 'I-198', '1', 'AED', '0'),
('301', 'I-199', '1', 'AED', '0'),
('302', 'I-200', '1', 'AED', '0'),
('303', 'I-201', '1', 'AED', '0'),
('304', 'I-202', '1', 'AED', '0'),
('305', 'I-203', '1', 'AED', '0'),
('306', 'I-204', '1', 'AED', '0'),
('307', 'I-205', '1', 'AED', '0'),
('308', 'I-206', '1', 'AED', '0'),
('309', 'I-207', '1', 'AED', '0'),
('310', 'I-208', '1', 'AED', '0'),
('311', 'I-209', '1', 'AED', '0'),
('312', 'I-210', '1', 'AED', '0'),
('313', 'I-211', '1', 'AED', '0'),
('314', 'I-212', '1', 'AED', '0'),
('315', 'I-213', '1', 'AED', '0'),
('316', 'I-214', '1', 'AED', '0'),
('317', 'I-215', '1', 'AED', '0'),
('318', 'I-216', '1', 'AED', '0'),
('319', 'I-217', '1', 'AED', '0'),
('320', 'I-218', '1', 'AED', '0'),
('321', 'I-219', '1', 'AED', '0'),
('322', 'I-220', '1', 'AED', '0'),
('323', 'I-221', '1', 'AED', '0'),
('324', 'I-222', '1', 'AED', '0'),
('325', 'I-223', '1', 'AED', '0'),
('326', 'I-224', '1', 'AED', '0'),
('327', 'I-225', '1', 'AED', '0'),
('328', 'I-226', '1', 'AED', '0'),
('329', 'I-227', '1', 'AED', '0'),
('330', 'I-228', '1', 'AED', '0'),
('331', 'I-229', '1', 'AED', '0'),
('332', 'I-230', '1', 'AED', '0'),
('333', 'I-231', '1', 'AED', '0'),
('334', 'I-232', '1', 'AED', '0'),
('335', 'I-233', '1', 'AED', '0'),
('336', 'I-234', '1', 'AED', '0'),
('337', 'I-235', '1', 'AED', '0'),
('338', 'I-236', '1', 'AED', '0'),
('339', 'I-237', '1', 'AED', '0'),
('340', 'I-238', '1', 'AED', '0'),
('341', 'I-239', '1', 'AED', '0'),
('342', 'I-240', '1', 'AED', '0'),
('343', 'I-241', '1', 'AED', '0'),
('344', 'I-242', '1', 'AED', '0'),
('345', 'I-243', '1', 'AED', '0'),
('346', 'I-244', '1', 'AED', '0'),
('347', 'I-245', '1', 'AED', '0'),
('348', 'I-246', '1', 'AED', '0'),
('349', 'I-247', '1', 'AED', '0'),
('350', 'I-248', '1', 'AED', '0'),
('351', 'I-249', '1', 'AED', '0'),
('352', 'I-250', '1', 'AED', '0'),
('353', 'I-251', '1', 'AED', '0'),
('354', 'I-252', '1', 'AED', '0'),
('355', 'I-253', '1', 'AED', '0'),
('356', 'I-254', '1', 'AED', '0'),
('357', 'I-255', '1', 'AED', '0'),
('358', 'I-256', '1', 'AED', '0'),
('359', 'I-257', '1', 'AED', '0'),
('360', 'I-258', '1', 'AED', '0'),
('361', 'I-259', '1', 'AED', '0'),
('362', 'I-260', '1', 'AED', '0'),
('363', 'I-261', '1', 'AED', '0'),
('364', 'I-262', '1', 'AED', '0'),
('365', 'I-263', '1', 'AED', '0'),
('366', 'I-264', '1', 'AED', '0'),
('367', 'I-265', '1', 'AED', '0'),
('368', 'I-266', '1', 'AED', '0'),
('369', 'I-267', '1', 'AED', '0'),
('370', 'I-268', '1', 'AED', '0'),
('371', 'I-269', '1', 'AED', '0'),
('372', 'I-270', '1', 'AED', '0'),
('373', 'I-271', '1', 'AED', '0'),
('374', 'I-272', '1', 'AED', '0'),
('375', 'I-273', '1', 'AED', '0'),
('376', 'I-274', '1', 'AED', '0'),
('377', 'I-275', '1', 'AED', '0'),
('378', 'I-276', '1', 'AED', '0'),
('379', 'I-277', '1', 'AED', '0'),
('380', 'I-278', '1', 'AED', '0'),
('381', 'I-279', '1', 'AED', '0'),
('382', 'I-280', '1', 'AED', '0'),
('383', 'I-281', '1', 'AED', '0'),
('384', 'I-282', '1', 'AED', '0'),
('385', 'I-283', '1', 'AED', '0'),
('386', 'I-284', '1', 'AED', '0'),
('387', 'I-285', '1', 'AED', '0'),
('388', 'I-286', '1', 'AED', '0'),
('389', 'I-287', '1', 'AED', '0'),
('390', 'I-288', '1', 'AED', '0'),
('391', 'I-289', '1', 'AED', '0'),
('392', 'I-290', '1', 'AED', '0'),
('393', 'I-291', '1', 'AED', '0'),
('394', 'I-292', '1', 'AED', '0'),
('395', 'I-293', '1', 'AED', '0'),
('396', 'I-294', '1', 'AED', '0'),
('397', 'I-295', '1', 'AED', '0'),
('398', 'I-296', '1', 'AED', '0'),
('399', 'I-297', '1', 'AED', '0'),
('400', 'I-298', '1', 'AED', '0'),
('401', 'I-299', '1', 'AED', '0'),
('402', 'I-300', '1', 'AED', '0'),
('403', 'I-301', '1', 'AED', '0'),
('404', 'I-302', '1', 'AED', '0'),
('405', 'I-303', '1', 'AED', '0'),
('406', 'I-304', '1', 'AED', '0'),
('407', 'I-305', '1', 'AED', '0'),
('408', 'I-306', '1', 'AED', '0'),
('409', 'I-307', '1', 'AED', '0'),
('410', 'I-308', '1', 'AED', '0'),
('411', 'I-309', '1', 'AED', '0'),
('412', 'I-310', '1', 'AED', '0'),
('413', 'I-311', '1', 'AED', '0'),
('414', 'I-312', '1', 'AED', '0'),
('415', 'I-313', '1', 'AED', '0'),
('416', 'I-314', '1', 'AED', '0'),
('417', 'I-315', '1', 'AED', '0'),
('418', 'I-316', '1', 'AED', '0'),
('419', 'I-317', '1', 'AED', '0'),
('420', 'I-318', '1', 'AED', '0'),
('421', 'I-319', '1', 'AED', '0'),
('422', 'I-320', '1', 'AED', '0'),
('423', 'I-321', '1', 'AED', '0'),
('424', 'I-322', '1', 'AED', '0'),
('425', 'I-323', '1', 'AED', '0'),
('426', 'I-324', '1', 'AED', '0'),
('427', 'I-325', '1', 'AED', '0'),
('428', 'I-326', '1', 'AED', '0'),
('429', 'I-327', '1', 'AED', '0'),
('430', 'I-328', '1', 'AED', '0'),
('431', 'I-329', '1', 'AED', '0'),
('432', 'I-330', '1', 'AED', '0'),
('433', 'I-331', '1', 'AED', '0'),
('434', 'I-332', '1', 'AED', '0'),
('435', 'I-333', '1', 'AED', '0'),
('436', 'I-334', '1', 'AED', '0'),
('437', 'I-335', '1', 'AED', '0'),
('438', 'I-336', '1', 'AED', '0'),
('439', 'I-337', '1', 'AED', '0'),
('440', 'I-338', '1', 'AED', '0'),
('441', 'I-339', '1', 'AED', '0'),
('442', 'I-340', '1', 'AED', '0'),
('443', 'I-341', '1', 'AED', '0'),
('444', 'I-342', '1', 'AED', '0'),
('445', 'I-343', '1', 'AED', '0'),
('446', 'I-344', '1', 'AED', '0'),
('447', 'I-345', '1', 'AED', '0'),
('448', 'I-346', '1', 'AED', '0'),
('449', 'I-347', '1', 'AED', '0'),
('450', 'I-348', '1', 'AED', '0'),
('451', 'I-349', '1', 'AED', '0'),
('452', 'I-350', '1', 'AED', '0'),
('453', 'I-351', '1', 'AED', '0'),
('454', 'I-352', '1', 'AED', '0'),
('455', 'I-353', '1', 'AED', '0'),
('456', 'I-354', '1', 'AED', '0'),
('457', 'I-355', '1', 'AED', '0'),
('458', 'I-356', '1', 'AED', '0'),
('459', 'I-357', '1', 'AED', '0'),
('460', 'I-358', '1', 'AED', '0'),
('461', 'I-359', '1', 'AED', '0'),
('462', 'I-360', '1', 'AED', '0'),
('463', 'I-361', '1', 'AED', '0'),
('464', 'I-362', '1', 'AED', '0'),
('465', 'I-363', '1', 'AED', '0'),
('466', 'I-364', '1', 'AED', '0'),
('467', 'I-365', '1', 'AED', '0'),
('468', 'I-366', '1', 'AED', '0'),
('469', 'I-367', '1', 'AED', '0'),
('470', 'I-368', '1', 'AED', '0'),
('471', 'I-369', '1', 'AED', '0'),
('472', 'I-370', '1', 'AED', '0'),
('473', 'I-371', '1', 'AED', '0'),
('474', 'I-372', '1', 'AED', '0'),
('475', 'I-373', '1', 'AED', '0'),
('476', 'I-374', '1', 'AED', '0'),
('477', 'I-375', '1', 'AED', '0'),
('478', 'I-376', '1', 'AED', '0'),
('479', 'I-377', '1', 'AED', '0'),
('480', 'I-378', '1', 'AED', '0'),
('481', 'I-379', '1', 'AED', '0'),
('482', 'I-380', '1', 'AED', '0'),
('483', 'I-381', '1', 'AED', '0'),
('484', 'I-382', '1', 'AED', '0'),
('485', 'I-383', '1', 'AED', '0'),
('486', 'I-384', '1', 'AED', '0'),
('487', 'I-385', '1', 'AED', '0'),
('488', 'I-386', '1', 'AED', '0'),
('489', 'I-387', '1', 'AED', '0'),
('490', 'I-388', '1', 'AED', '0'),
('491', 'I-389', '1', 'AED', '0'),
('492', 'I-390', '1', 'AED', '0'),
('493', 'I-391', '1', 'AED', '0'),
('494', 'I-392', '1', 'AED', '0'),
('495', 'I-393', '1', 'AED', '0'),
('496', 'I-394', '1', 'AED', '0'),
('497', 'I-395', '1', 'AED', '0'),
('498', 'I-396', '1', 'AED', '0'),
('499', 'I-397', '1', 'AED', '0'),
('500', 'I-398', '1', 'AED', '0'),
('501', 'I-399', '1', 'AED', '0'),
('502', 'I-400', '1', 'AED', '0'),
('503', 'I-401', '1', 'AED', '0'),
('504', 'I-402', '1', 'AED', '0'),
('505', 'I-403', '1', 'AED', '0'),
('506', 'I-404', '1', 'AED', '0'),
('507', 'I-405', '1', 'AED', '0'),
('508', 'I-406', '1', 'AED', '0'),
('509', 'I-407', '1', 'AED', '0'),
('510', 'I-408', '1', 'AED', '0'),
('511', 'I-409', '1', 'AED', '0'),
('512', 'I-410', '1', 'AED', '0'),
('513', 'I-411', '1', 'AED', '0'),
('514', 'I-412', '1', 'AED', '0'),
('515', 'I-413', '1', 'AED', '0'),
('516', 'I-414', '1', 'AED', '0'),
('517', 'I-415', '1', 'AED', '0'),
('518', 'I-416', '1', 'AED', '0'),
('519', 'I-417', '1', 'AED', '0'),
('520', 'I-418', '1', 'AED', '0'),
('521', 'I-419', '1', 'AED', '0'),
('522', 'I-420', '1', 'AED', '0'),
('523', 'I-421', '1', 'AED', '0'),
('524', 'I-422', '1', 'AED', '0'),
('525', 'I-423', '1', 'AED', '0'),
('526', 'I-424', '1', 'AED', '0'),
('527', 'I-425', '1', 'AED', '0'),
('528', 'I-426', '1', 'AED', '0'),
('529', 'I-427', '1', 'AED', '0'),
('530', 'I-428', '1', 'AED', '0'),
('531', 'I-429', '1', 'AED', '0'),
('532', 'I-430', '1', 'AED', '0'),
('533', 'I-431', '1', 'AED', '0'),
('534', 'I-432', '1', 'AED', '0'),
('535', 'I-433', '1', 'AED', '0'),
('536', 'I-434', '1', 'AED', '0'),
('537', 'I-435', '1', 'AED', '0'),
('538', 'I-436', '1', 'AED', '0'),
('539', 'I-437', '1', 'AED', '0'),
('540', 'I-438', '1', 'AED', '0'),
('541', 'I-439', '1', 'AED', '0'),
('542', 'I-440', '1', 'AED', '0'),
('543', 'I-441', '1', 'AED', '0'),
('544', 'I-442', '1', 'AED', '0'),
('545', 'I-443', '1', 'AED', '0'),
('546', 'I-444', '1', 'AED', '0'),
('547', 'I-445', '1', 'AED', '0'),
('548', 'I-446', '1', 'AED', '0'),
('549', 'I-447', '1', 'AED', '0'),
('550', 'I-448', '1', 'AED', '0'),
('551', 'I-449', '1', 'AED', '0'),
('552', 'I-450', '1', 'AED', '0'),
('553', 'I-451', '1', 'AED', '0'),
('554', 'I-452', '1', 'AED', '0'),
('555', 'I-453', '1', 'AED', '0'),
('556', 'I-454', '1', 'AED', '0'),
('557', 'I-455', '1', 'AED', '0'),
('558', 'I-456', '1', 'AED', '0'),
('559', 'I-457', '1', 'AED', '0'),
('560', 'I-458', '1', 'AED', '0'),
('561', 'I-459', '1', 'AED', '0'),
('562', 'I-460', '1', 'AED', '0'),
('563', 'I-461', '1', 'AED', '0'),
('564', 'I-462', '1', 'AED', '0'),
('565', 'I-463', '1', 'AED', '0'),
('566', 'I-464', '1', 'AED', '0'),
('567', 'I-465', '1', 'AED', '0'),
('568', 'I-466', '1', 'AED', '0'),
('569', 'I-467', '1', 'AED', '0'),
('570', 'I-468', '1', 'AED', '0'),
('571', 'I-469', '1', 'AED', '0'),
('572', 'I-470', '1', 'AED', '0'),
('573', 'I-471', '1', 'AED', '0'),
('574', 'I-472', '1', 'AED', '0'),
('575', 'I-473', '1', 'AED', '0'),
('576', 'I-474', '1', 'AED', '0'),
('577', 'I-475', '1', 'AED', '0'),
('578', 'I-476', '1', 'AED', '0'),
('579', 'I-477', '1', 'AED', '0'),
('580', 'I-478', '1', 'AED', '0'),
('581', 'I-479', '1', 'AED', '0'),
('582', 'I-480', '1', 'AED', '0'),
('583', 'I-481', '1', 'AED', '0'),
('584', 'I-482', '1', 'AED', '0'),
('585', 'I-483', '1', 'AED', '0'),
('586', 'I-484', '1', 'AED', '0'),
('587', 'I-485', '1', 'AED', '0'),
('588', 'I-486', '1', 'AED', '0'),
('589', 'I-487', '1', 'AED', '0'),
('590', 'I-488', '1', 'AED', '0'),
('591', 'I-489', '1', 'AED', '0'),
('592', 'I-490', '1', 'AED', '0'),
('593', 'I-491', '1', 'AED', '0'),
('594', 'I-492', '1', 'AED', '0');

### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) NOT NULL,
  `report` varchar(5) DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###


### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(60) NOT NULL,
  `queue` varchar(20) NOT NULL,
  `host` varchar(40) NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###


### Structure of table `0_project_module_name` ###

DROP TABLE IF EXISTS `0_project_module_name`;

CREATE TABLE `0_project_module_name` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `placement` int(100) NOT NULL COMMENT 'User Define Serial#',
  `col_name` varchar(100) NOT NULL COMMENT 'Updated Column Name',
  `col_color` varchar(100) NOT NULL COMMENT 'Color Coded',
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_project_module_name` ###


### Structure of table `0_project_task` ###

DROP TABLE IF EXISTS `0_project_task`;

CREATE TABLE `0_project_task` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `task_desc` text NOT NULL,
  `demo` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_project_task` ###


### Structure of table `0_projects` ###

DROP TABLE IF EXISTS `0_projects`;

CREATE TABLE `0_projects` (
  `proj_id` int(11) NOT NULL AUTO_INCREMENT,
  `proj_name` varchar(100) NOT NULL,
  `contact_person` int(11) NOT NULL,
  `opportunity` varchar(200) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `proj_description` varchar(100) DEFAULT NULL,
  `proj_type` tinyint(1) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL,
  `created_date` date NOT NULL,
  `delivery_date` varchar(100) NOT NULL,
  `closed_date` date DEFAULT NULL,
  `begin_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `owner_id` int(11) NOT NULL,
  `attachment` varchar(1000) NOT NULL,
  `deliver` varchar(100) NOT NULL,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `enq_date` date NOT NULL,
  `job_date` date NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `mobile` int(20) NOT NULL,
  `email` varchar(150) NOT NULL,
  `postal_address` varchar(300) NOT NULL,
  `attach_front` varchar(300) NOT NULL,
  `attach_back` varchar(300) NOT NULL,
  `inquiry_type` varchar(100) NOT NULL,
  PRIMARY KEY (`proj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_projects` ###


### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###


### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `long_description` varchar(1000) NOT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `exp_date` date NOT NULL,
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `discount_perc` double NOT NULL,
  `discount` double NOT NULL,
  `charge_amount` double NOT NULL,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `charge_group` int(11) NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `approved` tinyint(1) NOT NULL,
  `dimension_id` int(100) NOT NULL,
  `dimension2_id` int(100) NOT NULL,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_purchase_material_req_details` ###

DROP TABLE IF EXISTS `0_purchase_material_req_details`;

CREATE TABLE `0_purchase_material_req_details` (
  `material_req_detail_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `material_req_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `lpo_id` int(11) NOT NULL,
  `order_quantity` int(11) NOT NULL,
  `estimate_price` double NOT NULL,
  `quantity` double NOT NULL,
  `price` double NOT NULL,
  `purpose` varchar(320) NOT NULL,
  PRIMARY KEY (`material_req_detail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_purchase_material_req_details` ###


### Structure of table `0_purchase_material_requisition` ###

DROP TABLE IF EXISTS `0_purchase_material_requisition`;

CREATE TABLE `0_purchase_material_requisition` (
  `material_req_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) NOT NULL,
  `narrative` varchar(240) NOT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed` tinyint(4) NOT NULL,
  `inactive` tinyint(4) NOT NULL,
  `transfered` int(11) NOT NULL,
  `transaction_date` date NOT NULL,
  `user_name` varchar(30) NOT NULL COMMENT 'to username',
  `user_location` varchar(30) NOT NULL COMMENT 'tp locattion',
  `from_user` int(11) NOT NULL,
  `from_location` varchar(30) NOT NULL,
  `stock_moves_id` int(11) NOT NULL,
  `details` varchar(100) NOT NULL,
  PRIMARY KEY (`material_req_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_purchase_material_requisition` ###


### Structure of table `0_quick_access` ###

DROP TABLE IF EXISTS `0_quick_access`;

CREATE TABLE `0_quick_access` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `active` varchar(255) NOT NULL,
  `user_id` int(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_access` ###

INSERT INTO `0_quick_access` VALUES
('60', 'Sales Quotation Entry', 'sales/sales_order_entry.php?NewQuotation=Yes', 'menu-icon glyphicon glyphicon-pencil bg-light-blue', '1', '27'),
('52', 'Bank Account Transfers', 'gl/bank_transfer.php?', 'menu-icon fa fa-university bg-light-blue', '1', '1'),
('53', 'Journal Inquiry', 'gl/inquiry/journal_inquiry.php?', 'menu-icon fa fa-comments bg-light-blue', '1', '1'),
('51', 'Deposits', 'gl/gl_bank.php?NewDeposit=Yes', 'menu-icon fa fa-check-square-o bg-light-blue', '1', '1'),
('48', 'Payments to Suppliers', 'purchasing/supplier_payment.php?', 'menu-icon ionicons ion-cash bg-light-blue', '1', '1'),
('49', 'Dimension Inquiry', 'dimensions/inquiry/search_dimensions.php?', 'menu-icon glyphicon glyphicon-zoom-in bg-light-blue', '1', '1'),
('6', 'Sales Quotation Entry', 'sales/sales_order_entry.php?NewQuotation=Yes', 'menu-icon glyphicon glyphicon-pencil bg-light-blue', '1', '20'),
('7', 'Direct Invoice', 'sales/sales_order_entry.php?NewInvoice=0', 'menu-icon glyphicon glyphicon-paste  bg-light-blue', '1', '20'),
('8', 'Schedule Against Sales Orders', 'sales/inquiry/schedule_against_so.php?', 'menu-icon  bg-light-blue', '1', '20'),
('9', 'Invoice Against Sales Delivery', 'sales/inquiry/sales_deliveries_view.php?OutstandingOnly=1', 'menu-icon glyphicon glyphicon-save-file bg-light-blue', '1', '20'),
('10', 'Customer Payments', 'sales/customer_payments.php?', 'menu-icon glyphicon glyphicon-usd bg-light-blue', '1', '20'),
('11', 'Sales Quotation Inquiry', 'sales/inquiry/sales_orders_view.php?type=32', 'menu-icon glyphicon glyphicon-refresh bg-light-blue', '1', '20'),
('12', 'Customer Transaction Inquiry', 'sales/inquiry/customer_inquiry.php?', 'menu-icon glyphicon glyphicon-cloud-download bg-light-blue', '1', '20'),
('13', 'Add and Manage Customers', 'sales/manage/customers.php?', 'menu-icon ionicons ion-android-person-add bg-light-blue', '1', '20'),
('14', 'Customer Branches', 'sales/manage/customer_branches.php?', 'menu-icon fa fa-building-o bg-light-blue', '1', '20'),
('15', 'Items', 'inventory/manage/items.php?', 'menu-icon fa fa-cubes bg-light-blue', '1', '20'),
('16', 'Create Enquiry', 'CRM/pages/manage/add_project.php', 'menu-icon  bg-light-blue', '1', '20'),
('17', 'Opportunity Inquiry', 'CRM/pages/manage/projects.php', 'menu-icon  bg-light-blue', '1', '20'),
('50', 'Payments', 'gl/gl_bank.php?NewPayment=Yes', 'menu-icon fa fa-credit-card bg-light-blue', '1', '1'),
('47', 'Direct Supplier Invoice', 'purchasing/po_entry_items.php?NewInvoice=Yes', 'menu-icon glyphicon glyphicon-duplicate bg-light-blue', '1', '1'),
('45', 'Invoice Against Sales Delivery', 'sales/inquiry/sales_deliveries_view.php?OutstandingOnly=1', 'menu-icon glyphicon glyphicon-save-file bg-light-blue', '1', '1'),
('46', 'Customer Payments', 'sales/customer_payments.php?', 'menu-icon glyphicon glyphicon-usd bg-light-blue', '1', '1'),
('43', 'Sales Order Entry', 'sales/sales_order_entry.php?NewOrder=Yes', 'menu-icon glyphicon glyphicon-file bg-light-blue', '1', '1'),
('44', 'Direct Invoice', 'sales/sales_order_entry.php?NewInvoice=0', 'menu-icon glyphicon glyphicon-paste  bg-light-blue', '1', '1'),
('42', 'Sales Quotation Entry', 'sales/sales_order_entry.php?NewQuotation=Yes', 'menu-icon glyphicon glyphicon-pencil bg-light-blue', '1', '1'),
('61', 'Sales Order Entry', 'sales/sales_order_entry.php?NewOrder=Yes', 'menu-icon glyphicon glyphicon-file bg-light-blue', '1', '27'),
('62', 'Schedule Against Sales Orders', 'sales/inquiry/schedule_against_so.php?', 'menu-icon  bg-light-blue', '1', '27'),
('63', 'Sales Quotation Inquiry', 'sales/inquiry/sales_quotation_inquiry.php', 'menu-icon glyphicon glyphicon-refresh bg-light-blue', '1', '27'),
('64', 'Sales Order Inquiry', 'sales/inquiry/sales_orders_view.php?type=30', 'menu-icon glyphicon glyphicon-book bg-light-blue', '1', '27'),
('65', 'Schedule  Inquiry', 'sales/inquiry/schedule_inquiry.php?', 'menu-icon  bg-light-blue', '1', '27'),
('66', 'Purchase Order Entry', 'purchasing/po_entry_items.php?NewOrder=Yes', 'menu-icon fa fa-shopping-cart bg-light-blue', '1', '27'),
('103', 'Dimension Inquiry', 'dimensions/inquiry/search_dimensions.php?', 'menu-icon glyphicon glyphicon-zoom-in bg-light-blue', '1', '22'),
('102', 'Purchase Orders Inquiry', 'purchasing/inquiry/po_search_completed.php?', 'menu-icon fa fa-check-square-o bg-light-blue', '1', '22'),
('98', 'Schedule  Inquiry', 'sales/inquiry/schedule_inquiry.php?', 'menu-icon  bg-light-blue', '1', '22'),
('99', 'Customer Transaction Inquiry', 'sales/inquiry/customer_inquiry.php?', 'menu-icon glyphicon glyphicon-cloud-download bg-light-blue', '1', '22'),
('100', 'Customer Allocation Inquiry', 'sales/inquiry/customer_allocation_inquiry.php?', 'menu-icon glyphicon glyphicon-credit-card bg-light-blue', '1', '22'),
('101', 'Supplier Invoices', 'purchasing/supplier_invoice.php?New=1', 'menu-icon glyphicon glyphicon-duplicate bg-light-blue', '1', '22'),
('97', 'Sales Order Inquiry', 'sales/inquiry/sales_orders_view.php?type=