# MySQL dump of database 'bindhahiwayzerp_mrxpert' on host 'localhost'
# Backup Date and Time: 2024-03-01 12:30
# Built by Wayz Consulting 2.4.3
# http://frontaccounting.com
# Company: Mr Xperts
# User: Company Admin

# Compatibility: 2.4.1

# Comment:
# BackupBeforeUpdatingSupplier Transactions(DubaiCost and Bindhahi Trading)


SET NAMES utf8;


### Structure of table `0_agreement_pricing` ###

DROP TABLE IF EXISTS `0_agreement_pricing`;

CREATE TABLE `0_agreement_pricing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(500) NOT NULL,
  `payment_terms` varchar(100) NOT NULL,
  `price` int(20) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreement_pricing` ###


### Structure of table `0_agreements` ###

DROP TABLE IF EXISTS `0_agreements`;

CREATE TABLE `0_agreements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `dates` date NOT NULL,
  `provider` varchar(150) NOT NULL,
  `provider_representative` varchar(150) NOT NULL,
  `provider_email` varchar(150) NOT NULL,
  `provider_address` varchar(150) NOT NULL,
  `provider_desgination` varchar(150) NOT NULL,
  `client` varchar(150) NOT NULL,
  `client_representative` varchar(150) NOT NULL,
  `client_email` varchar(150) NOT NULL,
  `client_address` varchar(150) NOT NULL,
  `client_designation` varchar(150) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  `reference` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements` ###


### Structure of table `0_agreements_matters` ###

DROP TABLE IF EXISTS `0_agreements_matters`;

CREATE TABLE `0_agreements_matters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agreement_no` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `agreement_matter` mediumtext NOT NULL,
  `template` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements_matters` ###


### Structure of table `0_agreements_modules` ###

DROP TABLE IF EXISTS `0_agreements_modules`;

CREATE TABLE `0_agreements_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) NOT NULL,
  `sections` text NOT NULL,
  `areas` text NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_agreements_modules` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('5', 'Dubai', '0'),
('6', 'Sharjah', '0'),
('7', 'Ras Al Khaima', '0'),
('8', 'Umm Al Quwain', '0'),
('9', 'Default', '0'),
('10', 'Abu Dhabi', '0'),
('11', 'Fujairah', '0'),
('12', 'Ajman', '0');

### Structure of table `0_attach_inquiry` ###

DROP TABLE IF EXISTS `0_attach_inquiry`;

CREATE TABLE `0_attach_inquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `by_user` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted` tinyint(1) NOT NULL,
  `edited` int(11) NOT NULL,
  `notes` text NOT NULL,
  `flagged` tinyint(1) NOT NULL,
  `opportunity_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_attach_inquiry` ###


### Structure of table `0_attach_inquiry_detail` ###

DROP TABLE IF EXISTS `0_attach_inquiry_detail`;

CREATE TABLE `0_attach_inquiry_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `short_description` varchar(200) NOT NULL,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  `attach_id` int(11) NOT NULL,
  `note` text NOT NULL,
  `flagged` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attach_inquiry_detail` ###


### Structure of table `0_attach_inquiry_link_detail` ###

DROP TABLE IF EXISTS `0_attach_inquiry_link_detail`;

CREATE TABLE `0_attach_inquiry_link_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL,
  `trans_type` int(11) NOT NULL,
  `attach_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_attach_inquiry_link_detail` ###


### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `short_description` varchar(200) NOT NULL,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_attendance` ###

DROP TABLE IF EXISTS `0_attendance`;

CREATE TABLE `0_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `overtime_id` int(11) NOT NULL,
  `hours_no` float NOT NULL DEFAULT 0,
  `rate` float NOT NULL DEFAULT 1,
  `att_date` date NOT NULL,
  `is_leave` int(1) NOT NULL,
  `from_leave` date NOT NULL,
  `to_leave` date NOT NULL,
  `reason` varchar(255) NOT NULL,
  `time` varchar(70) NOT NULL,
  `time_out` varchar(50) NOT NULL,
  `in_out` int(11) NOT NULL,
  `leave_type` int(11) NOT NULL,
  `approved` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attendance` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  `notification_status` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=6366 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '1028', '1', '25', '2024-01-12 10:31:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('2', '1028', '2', '25', '2024-01-12 22:29:59', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('3', '1028', '1067', '25', '2024-01-12 10:32:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('4', '1028', '12', '25', '2024-01-12 10:32:58', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('5', '1028', '1205', '25', '2024-01-12 10:33:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('6', '1028', '980', '25', '2024-01-12 10:33:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('7', '1028', '1520', '25', '2024-01-12 10:33:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('8', '1028', '1540', '25', '2024-01-12 10:34:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('9', '1028', '1550', '25', '2024-01-12 10:34:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('10', '1028', '1820', '25', '2024-01-12 10:34:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('11', '1028', '1821', '25', '2024-01-12 10:34:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('12', '1028', '1830', '25', '2024-01-12 10:34:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('13', '1028', '1840', '25', '2024-01-12 10:35:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('14', '1028', '1850', '25', '2024-01-12 10:35:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('15', '1028', '2101', '25', '2024-01-12 10:35:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('16', '1028', '2110', '25', '2024-01-12 10:35:43', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('17', '1028', '2120', '25', '2024-01-12 10:35:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('18', '1028', '2130', '25', '2024-01-12 10:36:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('19', '1028', '2140', '25', '2024-01-12 10:36:11', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('20', '1028', '2160', '25', '2024-01-12 10:36:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('21', '1028', '2210', '25', '2024-01-12 10:36:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('22', '1028', '2230', '25', '2024-01-12 10:36:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('23', '1028', '2240', '25', '2024-01-12 10:36:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('24', '1028', '2320', '25', '2024-01-12 10:37:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('25', '1028', '2340', '25', '2024-01-12 10:37:22', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('26', '1028', '2350', '25', '2024-01-12 10:37:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('27', '1028', '2360', '25', '2024-01-12 10:37:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('28', '1028', '2380', '25', '2024-01-12 10:37:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('29', '1028', '2680', '25', '2024-01-12 10:38:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('30', '1028', '2620', '25', '2024-01-12 10:38:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('31', '1028', '3580', '25', '2024-01-12 10:38:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('32', '1028', '2040', '25', '2024-01-12 10:39:09', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('33', '1028', '2031', '25', '2024-01-12 10:39:28', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('34', '1028', '2032', '25', '2024-01-12 10:39:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('35', '1028', '2033', '25', '2024-01-12 10:39:55', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('36', '1028', '4011', '25', '2024-01-12 10:40:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('37', '1028', '4012', '25', '2024-01-12 10:40:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('38', '1028', '4440', '25', '2024-01-12 10:40:45', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('39', '1028', '10002', '25', '2024-01-12 10:41:13', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('40', '1028', '5440', '25', '2024-01-12 10:41:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('41', '1028', '5450', '25', '2024-01-12 10:42:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('42', '1028', '5460', '25', '2024-01-12 10:42:11', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('43', '1028', '5470', '25', '2024-01-12 10:42:23', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('44', '1028', '5510', '25', '2024-01-12 10:42:40', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('45', '1028', '5520', '25', '2024-01-12 10:42:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('46', '1028', '5530', '25', '2024-01-12 10:43:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('47', '1028', '5540', '25', '2024-01-12 10:43:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('48', '1028', '5550', '25', '2024-01-12 10:43:19', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('49', '1028', '5560', '25', '2024-01-12 10:43:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('50', '1028', '5410', '25', '2024-01-12 10:43:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('51', '1028', '5610', '25', '2024-01-12 10:43:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('52', '1028', '5615', '25', '2024-01-12 10:44:24', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('53', '1028', '5616', '25', '2024-01-12 10:44:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('54', '1028', '5617', '25', '2024-01-12 10:44:37', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('55', '1028', '5618', '25', '2024-01-12 10:44:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('56', '1028', '5619', '25', '2024-01-12 10:44:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('57', '1028', '5700', '25', '2024-01-12 10:45:07', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('58', '1028', '5760', '25', '2024-01-12 10:45:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('59', '1028', '5785', '25', '2024-01-12 10:45:33', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('60', '1028', '5790', '25', '2024-01-12 10:45:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('61', '1028', '5795', '25', '2024-01-12 10:45:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('62', '1028', '5800', '25', '2024-01-12 10:46:03', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('63', '1028', '5810', '25', '2024-01-12 10:46:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('64', '1028', '5820', '25', '2024-01-12 10:46:30', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('65', '1028', '10001', '25', '2024-01-12 10:46:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('66', '1028', '5425', '25', '2024-01-12 20:29:16', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('67', '1028', '5426', '25', '2024-01-12 20:30:30', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('68', '1028', '5428', '25', '2024-01-12 10:48:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('69', '1028', '5430', '25', '2024-01-12 10:49:17', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('70', '1028', '1913', '25', '2024-01-12 10:49:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('71', '1028', '1915', '25', '2024-01-12 20:26:54', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('72', '1028', '1880', '25', '2024-01-12 10:50:15', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('73', '1028', '1882', '25', '2024-01-12 10:50:29', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('74', '1028', '1883', '25', '2024-01-12 10:50:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('75', '1028', '1884', '25', '2024-01-12 10:50:49', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('76', '1028', '1885', '25', '2024-01-12 10:51:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('77', '1028', '1887', '25', '2024-01-12 10:51:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('78', '1028', '1889', '25', '2024-01-12 10:52:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('79', '1028', '1890', '25', '2024-01-12 10:52:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('80', '1028', '1891', '25', '2024-01-12 10:53:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('81', '1028', '1892', '25', '2024-01-12 10:53:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('82', '1028', '1893', '25', '2024-01-12 10:54:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('83', '1028', '1894', '25', '2024-01-12 10:54:39', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('84', '1028', '1895', '25', '2024-01-12 10:54:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('85', '1028', '1896', '25', '2024-01-12 10:54:52', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('86', '1028', '1898', '25', '2024-01-12 10:54:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('87', '1028', '1899', '25', '2024-01-12 10:55:00', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('88', '1028', '1900', '25', '2024-01-12 10:55:05', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('89', '1028', '1901', '25', '2024-01-12 10:58:13', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('90', '1028', '1902', '25', '2024-01-12 10:58:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('91', '1028', '1903', '25', '2024-01-12 10:58:19', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('92', '1028', '1904', '25', '2024-01-12 10:58:21', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('93', '1028', '1906', '25', '2024-01-12 10:58:25', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('94', '1028', '1907', '25', '2024-01-12 10:58:34', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('95', '1028', '1908', '25', '2024-01-12 10:58:38', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('96', '1028', '1909', '25', '2024-01-12 10:58:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('97', '1028', '1910', '25', '2024-01-12 10:58:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('98', '1028', '1911', '25', '2024-01-12 10:58:53', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('99', '1028', '1912', '25', '2024-01-12 10:59:01', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('100', '1028', '1920', '25', '2024-01-12 11:00:38', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('101', '1028', '1921', '25', '2024-01-12 11:00:46', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('102', '1028', '1922', '25', '2024-01-12 11:00:48', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('103', '1028', '1923', '25', '2024-01-12 11:00:52', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('104', '1028', '1924', '25', '2024-01-12 11:00:55', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('105', '1028', '1926', '25', '2024-01-12 11:00:58', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('106', '1028', '1925', '25', '2024-01-12 11:01:02', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('107', '1028', '1927', '25', '2024-01-12 11:01:06', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('108', '1028', '1928', '25', '2024-01-12 11:01:09', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('109', '1028', '1929', '25', '2024-01-12 11:01:12', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('110', '1028', '5422', '25', '2024-01-12 20:28:02', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('111', '1028', '5561', '25', '2024-01-12 11:01:41', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('112', '1028', '5620', '25', '2024-01-12 11:01:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('113', '1028', '5685', '25', '2024-01-12 11:01:56', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('114', '1028', '5765', '25', '2024-01-12 11:02:16', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('115', '1028', '1801', '25', '2024-01-12 11:02:31', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('116', '1028', '3350', '25', '2024-01-12 11:02:47', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('117', '1028', '3581', '25', '2024-01-12 11:02:57', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('118', '1028', '2021', '25', '2024-01-12 11:03:20', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('119', '1028', '2023', '25', '2024-01-12 11:03:26', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('120', '1028', '5020', '25', '2024-01-12 20:40:55', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('121', '1028', '5030', '25', '2024-01-12 20:49:14', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('122', '1028', '5050', '25', '2024-01-12 20:50:41', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('123', '1028', '5100', '25', '2024-01-12 11:07:14', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('124', '1028', '1236', '25', '2024-01-12 11:07:42', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('125', '1028', '1234', '25', '2024-01-12 11:07:51', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('126', '1028', '1235', '25', '2024-01-12 11:07:59', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('127', '1028', '901', '25', '2024-01-12 11:08:08', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('128', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('129', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('130', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('131', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('132', '0', '2', '25', '2024-01-13 10:36:28', 'Bank Account Deleted', '12', '0000-00-00', NULL, '0', '0'),
('133', '1028', '1065', '25', '2024-01-12 12:09:54', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('134', '1028', '1066', '25', '2024-01-12 12:10:01', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('135', '1028', '960', '25', '2024-01-12 12:11:39', 'Account Data Deleted', '13', '2024-01-12', NULL, '0', '0'),
('136', '1028', '960', '25', '2024-01-12 23:37:43', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('137', '1029', '2', '1', '2024-01-12 14:24:33', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('138', '1029', '2', '1', '2024-01-12 23:22:29', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('139', '1029', '15', '1', '2024-01-12 14:25:32', 'Bank Account Deleted', '13', '2024-01-12', '0', '0', '0'),
('140', '1029', '14', '1', '2024-01-12 14:25:35', 'Bank Account Deleted', '13', '2024-01-12', '0', '0', '0'),
('141', '1029', '9', '1', '2024-01-12 14:25:58', 'Account Type Updated', '13', '2024-01-12', '0', '0', '0'),
('142', '1028', '1905', '1', '2024-01-12 16:06:05', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('143', '1028', '5660', '1', '2024-01-12 19:17:31', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('144', '1028', '5040', '1', '2024-01-12 16:09:19', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('145', '1029', '21', '1', '2024-01-12 16:16:37', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('146', '1028', '210101', '1', '2024-01-12 16:15:52', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('147', '1028', '5780', '1', '2024-01-12 16:15:36', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('148', '1028', '5780', '1', '2024-01-12 16:15:36', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('149', '1028', '210101', '1', '2024-01-12 16:15:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('150', '1029', '21', '1', '2024-01-13 00:27:34', 'Bank Account Deleted', '13', '2024-01-12', NULL, '0', '0'),
('151', '1028', '9990', '1', '2024-01-12 16:18:28', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('152', '1028', '21001', '1', '2024-01-12 16:20:36', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('153', '1028', '21002', '1', '2024-01-12 16:21:20', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('154', '1028', '21003', '1', '2024-01-13 00:27:00', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('155', '1028', '21004', '1', '2024-01-12 16:23:06', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('156', '1028', '21005', '1', '2024-01-12 20:20:52', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('157', '1028', '21006', '1', '2024-01-13 00:25:35', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('158', '1028', '21007', '1', '2024-01-12 16:25:10', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('159', '1028', '21008', '1', '2024-01-13 00:24:04', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('160', '1028', '21009', '1', '2024-01-12 16:51:50', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('161', '1028', '21010', '1', '2024-01-18 11:37:49', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('162', '1028', '21011', '1', '2024-01-13 00:34:24', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('163', '1028', '21012', '1', '2024-01-13 00:12:46', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('164', '1028', '21013', '1', '2024-01-12 19:00:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('165', '1028', '21014', '1', '2024-01-12 19:14:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('166', '1028', '21015', '1', '2024-01-12 19:14:53', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('167', '1028', '21016', '1', '2024-01-16 10:29:23', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('168', '1028', '21017', '1', '2024-01-12 19:16:31', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('169', '1028', '21018', '1', '2024-01-12 19:17:15', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('170', '1028', '5660', '1', '2024-01-12 19:17:31', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('171', '1028', '21019', '1', '2024-01-12 19:18:08', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('172', '1028', '21020', '1', '2024-01-12 20:08:43', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('173', '1028', '21021', '1', '2024-01-12 20:10:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('174', '1028', '21022', '1', '2024-01-13 00:36:31', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('175', '1028', '21023', '1', '2024-01-12 20:14:31', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('176', '1028', '21024', '1', '2024-01-12 20:17:44', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('177', '1028', '21025', '1', '2024-01-12 20:18:07', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('178', '1028', '21026', '1', '2024-01-12 20:18:41', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('179', '1028', '21027', '1', '2024-01-12 20:19:19', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('180', '1028', '21005', '1', '2024-01-12 20:20:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('181', '1028', '21028', '1', '2024-01-12 20:21:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('182', '1028', '21029', '1', '2024-01-12 20:22:02', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('183', '1028', '21030', '1', '2024-01-17 10:04:41', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('184', '1028', '21031', '1', '2024-01-17 10:04:26', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('185', '1028', '21032', '1', '2024-01-12 20:24:27', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('186', '1028', '21033', '1', '2024-01-12 20:24:57', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('187', '1028', '21034', '1', '2024-01-17 10:08:15', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('188', '1028', '1915', '1', '2024-01-12 20:26:54', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('189', '1028', '5422', '1', '2024-01-12 20:28:02', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('190', '1028', '5425', '1', '2024-01-12 20:29:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('191', '1028', '5426', '1', '2024-01-12 20:30:30', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('192', '1028', '5421', '1', '2024-01-12 20:31:17', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('193', '1028', '21035', '1', '2024-01-12 20:32:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('194', '1028', '4500', '1', '2024-01-12 20:34:05', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('195', '1028', '5060', '1', '2024-01-12 20:37:39', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('196', '1028', '5020', '1', '2024-01-12 20:40:55', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('197', '1028', '5030', '1', '2024-01-12 20:49:14', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('198', '1028', '5050', '1', '2024-01-12 20:50:41', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('199', '1028', '5070', '1', '2024-01-12 20:51:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('200', '1028', '4009', '1', '2024-01-12 20:51:50', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('201', '1028', '4430', '1', '2024-01-12 22:16:38', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('202', '1028', '4010', '1', '2024-01-12 22:17:52', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('203', '1028', '2034', '1', '2024-01-12 22:21:03', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('204', '1030', '10', '1', '2024-01-12 22:25:27', 'Account Class Added', '13', '2024-01-12', '0', '0', '0'),
('205', '1029', '24', '1', '2024-01-12 22:33:23', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('206', '1028', '2', '1', '2024-01-12 22:29:59', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('207', '1028', '20001', '1', '2024-01-12 22:30:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('208', '1029', '24', '1', '2024-01-12 22:40:05', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('209', '1028', '24001', '1', '2024-01-12 22:35:25', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('210', '1028', '24002', '1', '2024-01-12 22:36:07', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('211', '1028', '24003', '1', '2024-01-12 22:36:42', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('212', '1028', '24004', '1', '2024-01-12 22:37:19', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('213', '1028', '24005', '1', '2024-01-12 22:37:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('214', '1028', '24006', '1', '2024-01-12 22:38:26', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('215', '1029', '24', '1', '2024-01-12 22:49:56', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('216', '1028', '24007', '1', '2024-01-12 22:41:00', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('217', '1028', '24008', '1', '2024-01-12 22:41:48', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('218', '1028', '24009', '1', '2024-01-12 22:42:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('219', '1028', '24010', '1', '2024-01-12 22:43:35', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('220', '1029', '24', '1', '2024-01-12 22:50:41', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('221', '1029', '24', '1', '2024-01-12 22:50:54', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('222', '1029', '24', '1', '2024-01-12 22:51:03', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('223', '1029', '24', '1', '2024-01-12 22:51:12', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('224', '1029', '24', '1', '2024-01-12 23:21:43', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('225', '1028', '3', '1', '2024-02-26 10:55:31', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('226', '1009', '97', '1', '2024-01-15 15:37:31', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('227', '1009', '98', '1', '2024-01-15 15:37:49', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('228', '1028', '24012', '1', '2024-01-12 22:58:15', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('229', '1009', '132', '1', '2024-01-15 15:38:03', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('230', '1009', '99', '1', '2024-01-15 15:38:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('231', '1009', '100', '1', '2024-01-16 10:53:53', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('232', '1028', '24013', '1', '2024-01-12 23:01:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('233', '1009', '101', '1', '2024-01-16 10:57:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('234', '1028', '24014', '1', '2024-01-12 23:03:34', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('235', '1009', '102', '1', '2024-01-16 10:57:33', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('236', '1028', '24015', '1', '2024-01-12 23:05:20', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('237', '1009', '94', '1', '2024-01-16 10:57:53', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('238', '1028', '24016', '1', '2024-01-12 23:07:23', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('239', '1028', '24017', '1', '2024-01-12 23:07:55', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('240', '1028', '24018', '1', '2024-01-12 23:08:28', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('241', '1009', '103', '1', '2024-01-16 10:58:09', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('242', '1009', '104', '1', '2024-01-16 10:58:35', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('243', '1009', '105', '1', '2024-01-16 10:59:00', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('244', '1028', '24019', '1', '2024-01-12 23:11:13', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('245', '1009', '106', '1', '2024-01-16 10:59:14', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('246', '1028', '24021', '1', '2024-01-12 23:13:08', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('247', '1009', '107', '1', '2024-01-16 10:59:30', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('248', '1028', '24022', '1', '2024-01-12 23:14:35', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('249', '1009', '108', '1', '2024-01-16 10:59:51', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('250', '1028', '24023', '1', '2024-01-12 23:15:56', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('251', '1009', '109', '1', '2024-01-16 11:00:08', 'Update Supplier', '13', '2024-01-12', NULL, '0', '0'),
('252', '1028', '24025', '1', '2024-01-12 23:19:39', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('253', '1028', '24026', '1', '2024-01-12 23:20:39', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('254', '1029', '24', '1', '2024-01-12 23:23:19', 'Account Type Updated', '13', '2024-01-12', NULL, '0', '0'),
('255', '1029', '2', '1', '2024-01-12 23:22:29', 'Account Type Updated', '13', '2024-01-12', '0', '0', '0'),
('256', '1029', '24', '1', '2024-01-12 23:24:52', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('257', '1029', '24', '1', '2024-01-12 23:25:32', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('258', '1029', '24', '1', '2024-01-12 23:52:19', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('259', '1028', '24027', '1', '2024-01-12 23:26:44', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('260', '1028', '24028', '1', '2024-01-12 23:27:25', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('261', '1028', '24029', '1', '2024-01-12 23:28:26', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('262', '1028', '24030', '1', '2024-01-12 23:29:29', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('263', '1028', '24031', '1', '2024-01-12 23:30:18', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('264', '1028', '24032', '1', '2024-01-12 23:31:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('265', '1028', '24033', '1', '2024-01-12 23:31:51', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('266', '1028', '24034', '1', '2024-01-12 23:32:22', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('267', '1028', '24035', '1', '2024-01-12 23:32:49', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('268', '1028', '24036', '1', '2024-01-12 23:33:12', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('269', '1028', '24037', '1', '2024-01-12 23:36:24', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('270', '1028', '24038', '1', '2024-01-12 23:37:12', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('271', '1028', '960', '1', '2024-01-12 23:37:43', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('272', '1028', '970', '1', '2024-01-12 23:37:49', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('273', '1028', '4450', '1', '2024-01-12 23:41:46', 'Account Data Updated', '13', '2024-01-12', '0', '0', '0'),
('274', '114', '1', '1', '2024-01-12 23:48:22', 'Account Tag Added', '13', '2024-01-12', '0', '0', '0'),
('275', '1028', '240038', '1', '2024-01-12 23:52:36', 'Account Data Added', '13', '2024-01-12', NULL, '0', '0'),
('276', '1029', '24', '1', '2024-01-13 00:14:51', 'Account Type Added', '13', '2024-01-12', NULL, '0', '0'),
('277', '1028', '240038', '1', '2024-01-12 23:52:44', 'Account Data Updated', '13', '2024-01-12', NULL, '0', '0'),
('278', '1028', '240038', '1', '2024-01-12 23:52:44', 'Account Data Deleted', '13', '2024-01-12', '0', '0', '0'),
('279', '1028', '21036', '1', '2024-01-12 23:53:16', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('280', '1028', '21037', '1', '2024-01-12 23:53:47', 'Account Data Added', '13', '2024-01-12', '0', '0', '0'),
('281', '1028', '21038', '1', '2024-01-13 00:07:07', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('282', '1028', '21039', '1', '2024-01-13 00:07:36', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('283', '1028', '21040', '1', '2024-01-13 00:07:56', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('284', '1028', '21041', '1', '2024-01-13 00:08:28', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('285', '1028', '21042', '1', '2024-01-13 00:09:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('286', '1028', '21043', '1', '2024-01-13 00:10:03', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('287', '1028', '21044', '1', '2024-01-13 00:10:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('288', '1028', '21045', '1', '2024-01-13 00:11:01', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('289', '1028', '21012', '1', '2024-01-13 00:12:46', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('290', '1029', '24', '1', '2024-01-13 00:20:01', 'Account Type Added', '13', '2024-01-13', NULL, '0', '0'),
('291', '1028', '21046', '1', '2024-01-13 00:16:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('292', '1028', '21047', '1', '2024-01-13 00:16:30', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('293', '1028', '21048', '1', '2024-01-13 00:17:05', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('294', '1028', '21049', '1', '2024-01-13 00:17:37', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('295', '1028', '21050', '1', '2024-01-13 00:18:03', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('296', '1029', '24', '1', '2024-01-13 00:20:01', 'Account Type Added', '13', '2024-01-13', '0', '0', '0'),
('297', '1028', '21051', '1', '2024-01-13 00:20:35', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('298', '1028', '21052', '1', '2024-01-13 00:21:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('299', '1028', '21053', '1', '2024-01-13 00:21:27', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('300', '1028', '21054', '1', '2024-01-13 00:21:50', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('301', '1028', '21055', '1', '2024-01-17 09:59:46', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('302', '1028', '21056', '1', '2024-01-13 00:22:34', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('303', '1028', '21057', '1', '2024-01-13 00:23:01', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('304', '1028', '21058', '1', '2024-01-13 00:23:46', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('305', '1028', '21008', '1', '2024-01-13 00:24:04', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('306', '1028', '21006', '1', '2024-01-13 00:25:35', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('307', '1028', '21059', '1', '2024-01-13 00:26:06', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('308', '1028', '21003', '1', '2024-01-13 00:27:00', 'Account Data Deleted', '13', '2024-01-13', '0', '0', '0'),
('309', '1029', '21', '1', '2024-01-13 00:27:34', 'Account Type Added', '13', '2024-01-13', '0', '0', '0'),
('310', '1028', '21060', '1', '2024-01-13 00:28:31', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('311', '1028', '21061', '1', '2024-01-13 00:28:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('312', '1028', '21062', '1', '2024-01-13 00:29:13', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('313', '1028', '21063', '1', '2024-01-17 09:46:28', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('314', '1028', '21064', '1', '2024-01-13 00:29:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('315', '1028', '21065', '1', '2024-01-13 00:30:12', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('316', '1028', '21066', '1', '2024-01-13 00:30:28', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('317', '1028', '21067', '1', '2024-01-17 09:47:01', 'Account Data Added', '13', '2024-01-13', NULL, '0', '0'),
('318', '1028', '21068', '1', '2024-01-13 00:31:07', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('319', '1028', '21069', '1', '2024-01-13 00:31:39', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('320', '1028', '21070', '1', '2024-01-13 00:31:54', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('321', '1028', '21071', '1', '2024-01-13 00:32:12', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('322', '1028', '21072', '1', '2024-01-13 00:32:35', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('323', '1028', '21073', '1', '2024-01-13 00:32:51', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('324', '1028', '21074', '1', '2024-01-13 00:33:46', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('325', '1028', '21011', '1', '2024-01-13 00:34:24', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('326', '1028', '21075', '1', '2024-01-13 00:35:00', 'Account Data Added', '13', '2024-01-13', '0', '0', '0'),
('327', '1028', '21022', '1', '2024-01-13 00:36:31', 'Account Data Updated', '13', '2024-01-13', '0', '0', '0'),
('328', '0', '1', '1', '2024-01-13 10:36:28', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('329', '0', '1', '1', '2024-01-13 10:36:28', 'Voided.\nDocument reentered.', '13', '2024-01-13', '0', '0', '0'),
('330', '0', '2', '1', '2024-01-13 10:36:28', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('331', '0', '3', '1', '2024-02-17 10:10:27', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('332', '1002', '17', '1', '2024-01-15 16:37:53', 'Update Branch', '13', '2024-01-14', NULL, '0', '0'),
('333', '1028', '21076', '1', '2024-01-14 23:14:55', 'Account Data Added', '13', '2024-01-14', '0', '0', '0'),
('334', '0', '4', '1', '2024-01-15 15:46:39', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('335', '1001', '247', '1', '2024-01-15 15:28:37', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('336', '1002', '243', '1', '2024-01-15 15:28:37', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('337', '1001', '249', '1', '2024-01-15 15:34:22', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('338', '1002', '244', '1', '2024-01-15 15:34:22', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('339', '1001', '250', '1', '2024-01-15 15:36:33', 'Create New Customer', '13', '2024-01-15', NULL, '0', '0'),
('340', '1002', '245', '1', '2024-01-15 15:36:03', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('341', '1001', '250', '1', '2024-01-15 15:36:33', 'Update Customer', '13', '2024-01-15', '0', '0', '0'),
('342', '1009', '97', '1', '2024-01-16 10:56:13', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('343', '1009', '98', '1', '2024-01-16 10:52:47', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('344', '1009', '132', '1', '2024-01-15 15:39:16', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('345', '1009', '99', '1', '2024-01-15 15:38:18', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('346', '1009', '99', '1', '2024-01-15 15:38:26', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('347', '1009', '99', '1', '2024-01-15 15:38:38', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('348', '1009', '99', '1', '2024-01-15 15:38:45', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('349', '1009', '99', '1', '2024-01-15 15:38:48', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('350', '1009', '99', '1', '2024-01-15 15:38:57', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('351', '1001', '251', '1', '2024-01-15 15:38:50', 'Create New Customer', '13', '2024-01-15', '0', '0', '0'),
('352', '1002', '246', '1', '2024-01-15 15:38:50', 'Create New Branch', '13', '2024-01-15', '0', '0', '0'),
('353', '1009', '99', '1', '2024-01-15 15:44:38', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('354', '1009', '132', '1', '2024-01-15 15:39:40', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('355', '1009', '132', '1', '2024-01-15 15:44:00', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('356', '1009', '132', '1', '2024-01-15 15:44:29', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('357', '1009', '132', '1', '2024-01-16 10:56:34', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('358', '1009', '99', '1', '2024-01-15 15:48:40', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('359', '0', '4', '1', '2024-01-15 15:46:39', 'Voided.\nDocument reentered.', '13', '2024-01-15', '0', '0', '0'),
('360', '0', '5', '1', '2024-01-16 10:37:32', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('361', '1009', '99', '1', '2024-01-15 15:48:45', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('362', '1009', '99', '1', '2024-01-15 15:48:49', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('363', '1009', '99', '1', '2024-01-15 15:48:53', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('364', '1009', '99', '1', '2024-01-15 15:49:12', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('365', '1009', '99', '1', '2024-01-16 07:57:18', 'Update Supplier', '13', '2024-01-15', NULL, '0', '0'),
('366', '1002', '9', '1', '2024-01-15 15:52:30', 'Delete Branch', '13', '2024-01-15', '0', '0', '0'),
('367', '1001', '10', '1', '2024-01-15 15:52:54', 'Delete Customer', '13', '2024-01-15', '0', '0', '0'),
('368', '1002', '17', '25', '2024-01-15 16:46:25', 'Update Branch', '13', '2024-01-15', NULL, '0', '0'),
('369', '1002', '17', '25', '2024-01-15 16:46:58', 'Update Branch', '13', '2024-01-15', NULL, '0', '0'),
('370', '1002', '17', '25', '2024-01-15 16:46:58', 'Update Branch', '13', '2024-01-15', '0', '0', '0'),
('371', '0', '6', '1', '2024-02-15 16:58:44', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('372', '1009', '99', '1', '2024-01-16 08:01:28', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('373', '1009', '99', '1', '2024-01-16 10:48:49', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('374', '1010', '0', '1', '2024-01-16 09:50:02', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('375', '1011', '607', '1', '2024-01-16 09:55:18', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('376', '1010', '0', '1', '2024-01-16 09:50:39', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('377', '1010', '0', '1', '2024-01-16 09:51:58', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('378', '1010', '0', '1', '2024-01-16 09:52:51', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('379', '1010', '0', '1', '2024-01-16 09:53:30', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('380', '1010', '0', '1', '2024-01-16 09:54:01', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('381', '1010', '0', '1', '2024-01-16 09:55:18', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('382', '1010', '0', '1', '2024-01-16 09:55:42', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('383', '1011', '607', '1', '2024-01-16 09:55:42', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('384', '1010', '0', '1', '2024-01-16 09:56:07', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('385', '1011', '607', '1', '2024-01-16 09:56:07', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('386', '1010', '0', '1', '2024-01-16 09:58:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('387', '1011', '607', '1', '2024-01-16 09:58:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('388', '1010', '0', '1', '2024-01-16 09:58:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('389', '1011', '607', '1', '2024-01-16 09:58:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('390', '1010', '0', '1', '2024-01-16 09:59:16', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('391', '1011', '607', '1', '2024-01-16 09:59:16', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('392', '1010', '0', '1', '2024-01-16 09:59:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('393', '1011', '607', '1', '2024-01-16 09:59:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('394', '1010', '0', '1', '2024-01-16 10:00:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('395', '1011', '607', '1', '2024-01-16 10:00:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('396', '1010', '0', '1', '2024-01-16 10:01:19', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('397', '1011', '607', '1', '2024-01-16 10:01:19', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('398', '1010', '0', '1', '2024-01-16 10:01:35', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('399', '1011', '607', '1', '2024-01-16 10:01:35', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('400', '1010', '0', '1', '2024-01-16 10:02:28', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('401', '1011', '607', '1', '2024-01-16 10:02:28', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('402', '1010', '0', '1', '2024-01-16 10:03:29', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('403', '1011', '607', '1', '2024-01-16 10:03:29', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('404', '1010', '0', '1', '2024-01-16 10:03:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('405', '1011', '607', '1', '2024-01-16 10:03:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('406', '1010', '0', '1', '2024-01-16 10:04:09', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('407', '1011', '607', '1', '2024-01-16 10:04:09', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('408', '1010', '0', '1', '2024-01-16 10:04:38', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('409', '1011', '607', '1', '2024-01-16 10:04:38', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('410', '1010', '0', '1', '2024-01-16 10:05:05', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('411', '1011', '607', '1', '2024-01-16 10:05:05', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('412', '1010', '0', '1', '2024-01-16 10:05:23', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('413', '1011', '607', '1', '2024-01-16 10:05:23', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('414', '1010', '0', '1', '2024-01-16 10:05:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('415', '1011', '607', '1', '2024-01-16 10:05:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('416', '1010', '0', '1', '2024-01-16 10:06:22', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('417', '1011', '607', '1', '2024-01-16 10:06:22', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('418', '1010', '0', '1', '2024-01-16 10:06:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('419', '1011', '607', '1', '2024-01-16 10:06:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('420', '1010', '0', '1', '2024-01-16 10:06:51', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('421', '1011', '607', '1', '2024-01-16 10:06:51', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('422', '1010', '0', '1', '2024-01-16 10:06:59', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('423', '1011', '607', '1', '2024-01-16 10:06:59', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('424', '1010', '0', '1', '2024-01-16 10:07:08', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('425', '1011', '607', '1', '2024-01-16 10:07:08', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('426', '1010', '0', '1', '2024-01-16 10:07:36', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('427', '1011', '607', '1', '2024-01-16 10:07:36', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('428', '1010', '0', '1', '2024-01-16 10:07:46', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('429', '1011', '607', '1', '2024-01-16 10:07:46', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('430', '1010', '0', '1', '2024-01-16 10:08:10', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('431', '1011', '607', '1', '2024-01-16 10:08:10', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('432', '1010', '0', '1', '2024-01-16 10:08:49', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('433', '1011', '607', '1', '2024-01-16 10:08:49', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('434', '1010', '0', '1', '2024-01-16 10:09:15', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('435', '1011', '607', '1', '2024-01-16 10:09:15', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('436', '1010', '0', '1', '2024-01-16 10:09:33', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('437', '1011', '607', '1', '2024-01-16 10:09:33', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('438', '1010', '0', '1', '2024-01-16 10:09:53', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('439', '1011', '607', '1', '2024-01-16 10:09:53', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('440', '1010', '0', '1', '2024-01-16 10:10:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('441', '1011', '607', '1', '2024-01-16 10:11:18', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('442', '1010', '0', '1', '2024-01-16 10:11:18', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('443', '1010', '0', '1', '2024-01-16 10:11:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('444', '1011', '607', '1', '2024-01-16 10:11:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('445', '1010', '0', '1', '2024-01-16 10:11:51', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('446', '1011', '607', '1', '2024-01-16 10:12:03', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('447', '1010', '0', '1', '2024-01-16 10:12:03', 'Delete Item', '13', '2024-01-16', NULL, '0', '0'),
('448', '1010', '0', '1', '2024-01-16 10:12:09', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('449', '1011', '607', '1', '2024-01-16 10:12:09', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('450', '1010', '0', '1', '2024-01-16 10:12:40', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('451', '1011', '607', '1', '2024-01-16 10:12:40', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('452', '1010', '0', '1', '2024-01-16 16:14:07', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('453', '1011', '607', '1', '2024-01-16 16:14:07', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('454', '1028', '21016', '1', '2024-01-16 10:29:23', 'Account Data Deleted', '13', '2024-01-16', '0', '0', '0'),
('455', '0', '5', '1', '2024-01-16 10:37:32', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('456', '0', '7', '1', '2024-01-16 10:41:24', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('457', '0', '7', '1', '2024-01-16 10:41:24', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('458', '0', '8', '1', '2024-01-16 11:00:38', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('459', '1', '2', '1', '2024-02-01 08:09:33', 'Bank Account Created', '13', '0000-00-00', NULL, '0', '0'),
('460', '1009', '99', '1', '2024-01-16 10:50:14', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('461', '1009', '99', '25', '2024-01-16 10:51:43', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('462', '1009', '99', '25', '2024-01-16 10:51:53', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('463', '1009', '99', '25', '2024-01-16 10:52:21', 'Update Supplier', '13', '2024-01-16', NULL, '0', '0'),
('464', '1009', '99', '1', '2024-01-16 10:52:21', 'Update Supplier', '13', '2024-01-16', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('465', '1009', '98', '1', '2024-01-16 10:52:47', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('466', '1009', '89', '1', '2024-01-16 10:53:26', 'Delete Supplier', '13', '2024-01-16', '0', '0', '0'),
('467', '1009', '100', '1', '2024-01-16 10:53:53', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('468', '1009', '97', '1', '2024-01-16 10:56:13', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('469', '1009', '132', '1', '2024-01-16 10:56:34', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('470', '1009', '101', '1', '2024-01-16 10:57:14', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('471', '1009', '102', '1', '2024-01-16 10:57:33', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('472', '1009', '94', '1', '2024-01-16 10:57:53', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('473', '1009', '103', '1', '2024-01-16 10:58:09', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('474', '1009', '104', '1', '2024-01-16 10:58:35', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('475', '1009', '105', '1', '2024-01-16 10:59:00', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('476', '1009', '106', '1', '2024-01-16 10:59:14', 'Delete Supplier', '13', '2024-01-16', '0', '0', '0'),
('477', '1009', '107', '1', '2024-01-16 10:59:30', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('478', '1009', '108', '1', '2024-01-16 10:59:51', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('479', '1009', '109', '1', '2024-01-16 11:00:08', 'Update Supplier', '13', '2024-01-16', '0', '0', '0'),
('480', '0', '8', '1', '2024-01-16 11:00:38', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('481', '0', '9', '1', '2024-01-16 11:05:55', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('482', '0', '9', '1', '2024-01-16 11:05:55', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('483', '0', '10', '1', '2024-01-16 11:16:55', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('484', '0', '10', '1', '2024-01-16 11:16:55', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('485', '0', '11', '1', '2024-01-16 13:04:27', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('486', '0', '11', '1', '2024-01-16 13:04:27', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('487', '0', '12', '1', '2024-01-16 15:18:07', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('488', '0', '12', '1', '2024-01-16 15:18:07', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('489', '0', '13', '1', '2024-01-16 15:22:38', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('490', '3', '20001', '1', '2024-01-16 15:28:55', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('491', '0', '13', '1', '2024-01-16 15:22:38', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('492', '0', '14', '1', '2024-01-16 15:30:17', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('493', '3', '21076', '1', '2024-01-16 15:28:32', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('494', '1', '2', '1', '2024-02-01 08:09:33', 'Bank Account Updated', '13', '0000-00-00', NULL, '0', '0'),
('495', '3', '21076', '1', '2024-01-16 15:28:32', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('496', '3', '20001', '1', '2024-01-16 15:28:55', 'Bank Account Updated', '0', '0000-00-00', '0', '0', '0'),
('497', '0', '14', '1', '2024-01-16 15:30:17', 'Voided.\nDocument reentered.', '13', '2024-01-16', '0', '0', '0'),
('498', '0', '15', '1', '2024-01-22 12:14:18', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('499', '1010', '0', '1', '2024-01-16 16:15:52', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('500', '1011', '607', '1', '2024-01-16 16:15:52', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('501', '1010', '0', '1', '2024-01-16 16:16:12', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('502', '1011', '607', '1', '2024-01-16 16:16:12', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('503', '1010', '0', '1', '2024-01-16 16:16:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('504', '1011', '607', '1', '2024-01-16 16:16:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('505', '1010', '0', '1', '2024-01-16 16:18:01', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('506', '1011', '607', '1', '2024-01-16 16:18:01', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('507', '1010', '0', '1', '2024-01-16 16:18:21', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('508', '1011', '607', '1', '2024-01-16 16:18:21', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('509', '1010', '0', '1', '2024-01-16 16:19:25', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('510', '1011', '607', '1', '2024-01-16 16:19:25', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('511', '1010', '0', '1', '2024-01-16 16:30:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('512', '1011', '607', '1', '2024-01-16 16:30:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('513', '1010', '0', '1', '2024-01-16 16:31:17', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('514', '1011', '607', '1', '2024-01-16 16:31:17', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('515', '1010', '0', '1', '2024-01-16 16:34:24', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('516', '1011', '607', '1', '2024-01-16 16:34:24', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('517', '1010', '0', '1', '2024-01-16 16:34:50', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('518', '1011', '607', '1', '2024-01-16 16:34:50', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('519', '1010', '0', '1', '2024-01-16 16:35:02', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('520', '1011', '607', '1', '2024-01-16 16:35:02', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('521', '1010', '0', '1', '2024-01-16 16:35:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('522', '1011', '607', '1', '2024-01-16 16:35:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('523', '1010', '0', '1', '2024-01-16 16:39:01', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('524', '1011', '607', '1', '2024-01-16 16:39:01', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('525', '1010', '0', '1', '2024-01-16 16:41:00', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('526', '1011', '607', '1', '2024-01-16 16:41:00', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('527', '1010', '0', '1', '2024-01-16 16:41:21', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('528', '1011', '607', '1', '2024-01-16 16:41:21', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('529', '1010', '0', '1', '2024-01-16 16:42:00', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('530', '1011', '607', '1', '2024-01-16 16:42:00', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('531', '1010', '0', '1', '2024-01-16 16:43:28', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('532', '1011', '607', '1', '2024-01-16 16:43:28', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('533', '1010', '0', '1', '2024-01-16 16:44:41', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('534', '1011', '607', '1', '2024-01-16 16:44:41', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('535', '1010', '0', '1', '2024-01-16 16:46:55', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('536', '1011', '607', '1', '2024-01-16 16:46:55', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('537', '1010', '0', '1', '2024-01-16 16:47:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('538', '1011', '607', '1', '2024-01-16 16:47:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('539', '1010', '0', '1', '2024-01-16 16:47:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('540', '1011', '607', '1', '2024-01-16 16:47:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('541', '1010', '0', '1', '2024-01-16 16:48:19', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('542', '1011', '607', '1', '2024-01-16 16:48:19', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('543', '1010', '0', '1', '2024-01-16 16:50:25', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('544', '1011', '607', '1', '2024-01-16 16:50:25', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('545', '1010', '0', '1', '2024-01-16 16:50:31', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('546', '1011', '607', '1', '2024-01-16 16:50:31', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('547', '1010', '0', '1', '2024-01-16 16:50:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('548', '1011', '607', '1', '2024-01-16 16:50:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('549', '1010', '0', '1', '2024-01-16 16:51:27', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('550', '1011', '607', '1', '2024-01-16 16:51:27', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('551', '1010', '0', '1', '2024-01-16 16:56:43', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('552', '1011', '607', '1', '2024-01-16 16:56:43', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('553', '1010', '0', '1', '2024-01-16 16:57:47', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('554', '1011', '607', '1', '2024-01-16 16:57:47', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('555', '1010', '0', '1', '2024-01-16 16:58:15', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('556', '1011', '607', '1', '2024-01-16 16:58:15', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('557', '1010', '0', '1', '2024-01-16 16:58:49', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('558', '1011', '607', '1', '2024-01-16 16:58:49', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('559', '1010', '0', '1', '2024-01-16 16:59:04', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('560', '1011', '607', '1', '2024-01-16 16:59:04', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('561', '1010', '0', '1', '2024-01-16 16:59:39', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('562', '1011', '607', '1', '2024-01-16 16:59:39', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('563', '1010', '0', '1', '2024-01-17 08:44:10', 'Update Item', '13', '2024-01-16', NULL, '0', '0'),
('564', '1011', '607', '1', '2024-01-17 08:44:10', 'Update Item Codes', '13', '2024-01-16', NULL, '0', '0'),
('565', '1010', '0', '1', '2024-01-17 08:48:55', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('566', '1011', '607', '1', '2024-01-17 08:48:55', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('567', '1010', '0', '1', '2024-01-17 08:49:14', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('568', '1011', '607', '1', '2024-01-17 08:49:14', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('569', '1010', '0', '1', '2024-01-17 08:51:58', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('570', '1011', '607', '1', '2024-01-17 08:51:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('571', '1010', '0', '1', '2024-01-17 08:52:20', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('572', '1011', '607', '1', '2024-01-17 08:52:20', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('573', '1010', '0', '1', '2024-01-17 08:52:34', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('574', '1011', '607', '1', '2024-01-17 08:52:34', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('575', '1010', '0', '1', '2024-01-17 08:52:54', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('576', '1011', '607', '1', '2024-01-17 08:52:54', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('577', '1010', '0', '1', '2024-01-17 08:53:12', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('578', '1011', '607', '1', '2024-01-17 08:53:12', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('579', '1010', '0', '1', '2024-01-17 08:53:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('580', '1011', '607', '1', '2024-01-17 08:53:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('581', '1010', '0', '1', '2024-01-17 08:54:01', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('582', '1011', '607', '1', '2024-01-17 08:54:01', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('583', '1010', '0', '1', '2024-01-17 08:54:29', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('584', '1011', '607', '1', '2024-01-17 08:54:29', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('585', '1010', '0', '1', '2024-01-17 08:58:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('586', '1011', '607', '1', '2024-01-17 08:58:19', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('587', '1010', '0', '1', '2024-01-17 08:59:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('588', '1011', '607', '1', '2024-01-17 08:59:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('589', '1010', '0', '1', '2024-01-17 09:00:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('590', '1011', '607', '1', '2024-01-17 09:00:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('591', '1010', '0', '1', '2024-01-17 09:30:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('592', '1011', '607', '1', '2024-01-17 09:07:13', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('593', '1010', '1', '1', '2024-01-17 14:55:30', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('594', '1011', '607', '1', '2024-01-17 09:30:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('595', '1010', '0', '1', '2024-01-17 09:31:22', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('596', '1011', '607', '1', '2024-01-17 09:31:22', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('597', '1010', '0', '1', '2024-01-17 09:31:43', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('598', '1011', '607', '1', '2024-01-17 09:31:43', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('599', '1010', '0', '1', '2024-01-17 09:33:05', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('600', '1011', '607', '1', '2024-01-17 09:33:05', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('601', '1010', '0', '1', '2024-01-17 09:33:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('602', '1011', '607', '1', '2024-01-17 09:33:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('603', '1010', '0', '1', '2024-01-17 09:34:15', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('604', '1011', '607', '1', '2024-01-17 09:34:15', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('605', '1010', '0', '1', '2024-01-17 09:36:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('606', '1011', '607', '1', '2024-01-17 09:37:39', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('607', '1010', '0', '1', '2024-01-17 09:37:00', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('608', '1010', '0', '1', '2024-01-17 09:37:26', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('609', '1010', '0', '1', '2024-01-17 09:37:39', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('610', '1010', '0', '1', '2024-01-17 09:38:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('611', '1011', '607', '1', '2024-01-17 09:38:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('612', '1010', '0', '1', '2024-01-17 09:39:09', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('613', '1011', '607', '1', '2024-01-17 09:39:09', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('614', '1010', '0', '1', '2024-01-17 09:39:45', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('615', '1011', '607', '1', '2024-01-17 09:39:45', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('616', '1010', '0', '1', '2024-01-17 09:50:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('617', '1011', '607', '1', '2024-01-17 09:50:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('618', '1028', '21063', '1', '2024-01-17 09:46:28', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('619', '1028', '21067', '1', '2024-01-17 09:47:01', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('620', '1010', '0', '1', '2024-01-17 09:52:27', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('621', '1011', '607', '1', '2024-02-02 10:31:01', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('622', '1011', '608', '1', '2024-01-17 09:53:12', 'Create Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('623', '1010', '0', '1', '2024-01-17 09:53:12', 'Create New Item', '13', '2024-01-17', NULL, '0', '0'),
('624', '1010', '0', '1', '2024-01-17 09:53:58', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('625', '1011', '608', '1', '2024-01-17 09:53:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('626', '1010', '0', '1', '2024-01-17 09:54:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('627', '1011', '608', '1', '2024-01-17 09:54:19', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('628', '1010', '0', '1', '2024-01-17 09:54:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('629', '1011', '608', '1', '2024-01-17 09:54:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('630', '1010', '0', '1', '2024-01-17 09:54:50', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('631', '1011', '608', '1', '2024-01-17 09:54:50', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('632', '1010', '0', '1', '2024-01-17 09:56:39', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('633', '1011', '608', '1', '2024-01-17 09:56:39', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('634', '1010', '0', '1', '2024-01-17 09:57:32', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('635', '1011', '608', '1', '2024-01-17 09:57:32', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('636', '1010', '0', '1', '2024-01-17 09:58:06', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('637', '1011', '608', '1', '2024-01-17 09:58:06', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('638', '1010', '0', '1', '2024-01-17 10:02:17', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('639', '1011', '608', '1', '2024-01-17 10:02:17', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('640', '1028', '21055', '1', '2024-01-17 09:59:46', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('641', '1028', '21077', '1', '2024-01-17 10:01:36', 'Account Data Added', '13', '2024-01-17', '0', '0', '0'),
('642', '1010', '0', '1', '2024-01-17 10:02:54', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('643', '1011', '608', '1', '2024-01-17 10:02:54', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('644', '1010', '0', '1', '2024-01-17 10:05:09', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('645', '1011', '608', '1', '2024-01-17 10:05:09', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('646', '1028', '21031', '1', '2024-01-17 10:04:26', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('647', '1028', '21030', '1', '2024-01-17 10:04:41', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('648', '1010', '0', '1', '2024-01-17 10:06:43', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('649', '1011', '608', '1', '2024-01-17 10:06:43', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('650', '1010', '0', '1', '2024-01-17 10:07:12', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('651', '1011', '608', '1', '2024-01-17 10:07:12', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('652', '1010', '0', '1', '2024-01-17 10:07:45', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('653', '1011', '608', '1', '2024-01-17 10:07:45', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('654', '1010', '0', '1', '2024-01-17 10:13:26', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('655', '1011', '608', '1', '2024-01-17 10:14:18', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('656', '1028', '21034', '1', '2024-01-17 10:08:15', 'Account Data Updated', '13', '2024-01-17', '0', '0', '0'),
('657', '1010', '0', '1', '2024-01-17 10:14:18', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('658', '1010', '0', '1', '2024-01-17 10:15:24', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('659', '1011', '608', '1', '2024-01-17 10:15:24', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('660', '1010', '0', '1', '2024-01-17 10:15:51', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('661', '1011', '608', '1', '2024-01-17 10:15:51', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('662', '1010', '0', '1', '2024-01-17 10:17:27', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('663', '1011', '608', '1', '2024-01-17 10:17:27', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('664', '1010', '0', '1', '2024-01-17 10:17:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('665', '1011', '608', '1', '2024-01-17 10:17:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('666', '1010', '0', '1', '2024-01-17 10:18:40', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('667', '1011', '608', '1', '2024-01-17 10:20:58', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('668', '1010', '0', '1', '2024-01-17 10:19:35', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('669', '1010', '0', '1', '2024-01-17 10:20:10', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('670', '1010', '0', '1', '2024-01-17 10:20:58', 'Delete Item', '13', '2024-01-17', NULL, '0', '0'),
('671', '1010', '0', '1', '2024-01-17 10:21:38', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('672', '1011', '608', '1', '2024-01-17 10:21:38', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('673', '1010', '0', '1', '2024-01-17 10:21:42', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('674', '1011', '608', '1', '2024-01-17 10:21:42', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('675', '1010', '0', '1', '2024-01-17 10:22:07', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('676', '1011', '608', '1', '2024-01-17 10:22:07', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('677', '1010', '0', '1', '2024-01-17 14:54:19', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('678', '1011', '608', '1', '2024-02-02 14:59:56', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('679', '1011', '609', '25', '2024-01-17 11:57:02', 'Create Foreign Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('680', '1011', '609', '25', '2024-01-17 14:54:19', 'Update Foreign Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('681', '1010', '0', '1', '2024-01-17 14:54:36', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('682', '1011', '609', '1', '2024-01-17 14:54:36', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('683', '1010', '0', '1', '2024-01-18 10:48:46', 'Update Item', '13', '2024-01-17', NULL, '0', '0'),
('684', '1011', '609', '1', '2024-01-17 14:55:30', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('685', '1010', '1', '1', '2024-01-17 14:55:30', 'Update Item', '13', '2024-01-17', '0', '0', '0'),
('686', '1011', '609', '1', '2024-02-02 15:00:14', 'Update Item Codes', '13', '2024-01-17', NULL, '0', '0'),
('687', '1015', '0', '25', '2024-01-18 10:22:08', 'Create Units ', '13', '2024-01-18', '0', '0', '0'),
('688', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('689', '1012', '1', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('690', '1017', '1', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('691', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('692', '1012', '2', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('693', '1017', '2', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('694', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('695', '1012', '3', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('696', '1017', '3', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('697', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('698', '1012', '4', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('699', '1017', '4', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('700', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('701', '1012', '5', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('702', '1017', '5', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('703', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('704', '1012', '6', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('705', '1017', '6', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('706', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('707', '1012', '7', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('708', '1017', '7', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('709', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('710', '1012', '8', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('711', '1017', '8', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('712', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('713', '1012', '9', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('714', '1017', '9', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('715', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('716', '1012', '10', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('717', '1017', '10', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('718', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('719', '1012', '11', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('720', '1017', '11', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('721', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('722', '1012', '12', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('723', '1017', '12', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('724', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('725', '1012', '13', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('726', '1017', '13', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('727', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('728', '1012', '14', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('729', '1017', '14', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('730', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('731', '1012', '15', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('732', '1017', '15', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('733', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('734', '1012', '16', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('735', '1017', '16', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('736', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('737', '1012', '17', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('738', '1017', '17', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('739', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('740', '1012', '18', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('741', '1017', '18', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('742', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('743', '1012', '19', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('744', '1017', '19', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('745', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('746', '1012', '19', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('747', '1017', '20', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('748', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('749', '1012', '20', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('750', '1017', '21', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('751', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('752', '1012', '21', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('753', '1017', '22', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('754', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('755', '1012', '22', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('756', '1017', '23', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('757', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('758', '1012', '23', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('759', '1017', '24', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('760', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('761', '1012', '24', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('762', '1017', '25', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('763', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('764', '1012', '25', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('765', '1017', '26', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('766', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('767', '1012', '26', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('768', '1017', '27', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('769', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('770', '1012', '27', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('771', '1017', '28', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('772', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('773', '1012', '28', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('774', '1017', '29', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('775', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('776', '1012', '29', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('777', '1017', '30', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('778', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('779', '1012', '30', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('780', '1017', '31', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('781', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('782', '1012', '31', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('783', '1017', '32', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('784', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('785', '1012', '32', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('786', '1017', '33', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('787', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('788', '1012', '33', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('789', '1017', '34', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('790', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('791', '1012', '34', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('792', '1017', '35', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('793', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('794', '1012', '35', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('795', '1017', '36', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('796', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('797', '1012', '36', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('798', '1017', '37', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('799', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('800', '1012', '37', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('801', '1017', '38', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('802', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('803', '1012', '38', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('804', '1017', '39', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('805', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('806', '1012', '39', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('807', '1017', '40', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('808', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('809', '1012', '40', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('810', '1017', '41', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('811', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('812', '1012', '41', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('813', '1017', '42', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('814', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('815', '1012', '42', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('816', '1017', '43', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('817', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('818', '1012', '43', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('819', '1017', '44', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('820', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('821', '1012', '44', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('822', '1017', '45', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('823', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('824', '1012', '45', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('825', '1017', '46', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('826', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('827', '1012', '46', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('828', '1017', '47', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('829', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('830', '1012', '47', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('831', '1017', '48', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('832', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('833', '1012', '48', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('834', '1017', '49', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('835', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('836', '1012', '49', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('837', '1017', '50', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('838', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('839', '1012', '50', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('840', '1017', '51', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('841', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('842', '1012', '51', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('843', '1017', '52', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('844', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('845', '1012', '52', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('846', '1017', '53', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('847', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('848', '1012', '53', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('849', '1017', '54', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('850', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('851', '1012', '54', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('852', '1017', '55', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('853', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('854', '1012', '55', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('855', '1017', '56', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('856', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('857', '1012', '56', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('858', '1017', '57', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('859', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('860', '1012', '57', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('861', '1017', '58', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('862', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('863', '1012', '58', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('864', '1017', '59', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('865', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('866', '1012', '59', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('867', '1017', '60', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('868', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('869', '1012', '60', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('870', '1017', '61', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('871', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('872', '1012', '61', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('873', '1017', '62', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('874', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('875', '1012', '62', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('876', '1017', '63', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('877', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('878', '1012', '63', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('879', '1017', '64', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('880', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('881', '1012', '64', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('882', '1017', '65', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('883', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('884', '1012', '65', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('885', '1017', '66', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('886', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('887', '1012', '66', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('888', '1017', '67', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('889', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('890', '1012', '66', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('891', '1017', '68', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('892', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('893', '1012', '67', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('894', '1017', '69', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('895', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('896', '1012', '68', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('897', '1017', '70', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('898', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('899', '1012', '69', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('900', '1017', '71', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('901', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('902', '1012', '70', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('903', '1017', '72', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('904', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('905', '1012', '71', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('906', '1017', '73', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('907', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('908', '1012', '72', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('909', '1017', '74', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('910', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('911', '1012', '73', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('912', '1017', '75', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('913', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('914', '1012', '74', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('915', '1017', '76', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('916', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('917', '1012', '75', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('918', '1017', '77', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('919', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('920', '1012', '76', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('921', '1017', '78', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('922', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('923', '1012', '77', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('924', '1017', '79', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('925', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('926', '1012', '78', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('927', '1017', '80', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('928', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('929', '1012', '79', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('930', '1017', '81', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('931', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('932', '1012', '80', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('933', '1017', '82', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('934', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('935', '1012', '81', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('936', '1017', '83', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('937', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('938', '1012', '82', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('939', '1017', '84', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('940', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('941', '1012', '83', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('942', '1017', '85', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('943', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('944', '1012', '84', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('945', '1017', '86', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('946', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('947', '1012', '85', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('948', '1017', '87', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('949', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('950', '1012', '86', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('951', '1017', '88', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('952', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('953', '1012', '87', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('954', '1017', '89', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('955', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('956', '1012', '88', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('957', '1017', '90', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('958', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('959', '1012', '89', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('960', '1017', '91', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('961', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('962', '1012', '90', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('963', '1017', '92', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('964', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('965', '1012', '91', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('966', '1017', '93', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('967', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('968', '1012', '92', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('969', '1017', '94', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('970', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('971', '1012', '93', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('972', '1017', '95', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('973', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('974', '1012', '94', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('975', '1017', '96', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('976', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('977', '1012', '95', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('978', '1017', '97', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('979', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('980', '1012', '96', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('981', '1017', '98', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('982', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('983', '1012', '97', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('984', '1017', '99', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('985', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('986', '1012', '98', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('987', '1017', '100', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('988', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('989', '1012', '99', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('990', '1017', '101', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('991', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('992', '1012', '100', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('993', '1017', '102', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('994', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('995', '1012', '101', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('996', '1017', '103', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('997', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('998', '1012', '102', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('999', '1017', '104', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1000', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1001', '1012', '103', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1002', '1017', '105', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1003', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1004', '1012', '104', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1005', '1017', '106', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1006', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1007', '1012', '105', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1008', '1017', '107', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1009', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1010', '1012', '106', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1011', '1017', '108', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1012', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1013', '1012', '107', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1014', '1017', '109', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1015', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1016', '1012', '108', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1017', '1017', '110', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1018', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1019', '1012', '109', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1020', '1017', '111', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1021', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1022', '1012', '110', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1023', '1017', '112', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1024', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1025', '1012', '111', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1026', '1017', '113', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1027', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1028', '1012', '112', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1029', '1017', '114', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1030', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1031', '1012', '113', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1032', '1017', '115', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1033', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1034', '1012', '114', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1035', '1017', '116', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1036', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1037', '1012', '115', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1038', '1017', '117', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1039', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1040', '1012', '116', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1041', '1017', '118', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1042', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1043', '1012', '117', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1044', '1017', '119', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1045', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1046', '1012', '118', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1047', '1017', '120', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1048', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1049', '1012', '119', '25', '2024-01-18 10:22:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1050', '1017', '121', '25', '2024-01-18 10:22:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1051', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1052', '1012', '120', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1053', '1017', '122', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1054', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1055', '1012', '121', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1056', '1017', '123', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1057', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1058', '1012', '122', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1059', '1017', '124', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1060', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1061', '1012', '123', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1062', '1017', '125', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1063', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1064', '1012', '124', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1065', '1017', '126', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1066', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1067', '1012', '125', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1068', '1017', '127', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1069', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1070', '1012', '126', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1071', '1017', '128', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1072', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1073', '1012', '127', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1074', '1017', '129', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1075', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1076', '1012', '128', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1077', '1017', '130', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1078', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1079', '1012', '129', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1080', '1017', '131', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1081', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1082', '1012', '130', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1083', '1017', '132', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1084', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1085', '1012', '131', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1086', '1017', '133', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1087', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1088', '1012', '132', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1089', '1017', '134', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1090', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1091', '1012', '133', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1092', '1017', '135', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1093', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1094', '1012', '134', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1095', '1017', '136', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1096', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1097', '1012', '135', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1098', '1017', '137', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1099', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1100', '1012', '136', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1101', '1017', '138', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1102', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1103', '1012', '137', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1104', '1017', '139', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1105', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1106', '1012', '138', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1107', '1017', '140', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1108', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1109', '1012', '139', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1110', '1017', '141', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1111', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1112', '1012', '140', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1113', '1017', '142', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1114', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1115', '1012', '141', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1116', '1017', '143', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1117', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1118', '1012', '142', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1119', '1017', '144', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1120', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1121', '1012', '143', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1122', '1017', '145', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1123', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1124', '1012', '144', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1125', '1017', '146', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1126', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1127', '1012', '145', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1128', '1017', '147', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1129', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1130', '1012', '146', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1131', '1017', '148', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1132', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1133', '1012', '147', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1134', '1017', '149', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1135', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1136', '1012', '148', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1137', '1017', '150', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1138', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1139', '1012', '149', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1140', '1017', '151', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1141', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1142', '1012', '150', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1143', '1017', '152', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1144', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1145', '1012', '151', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1146', '1017', '153', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1147', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1148', '1012', '152', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1149', '1017', '154', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1150', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1151', '1012', '153', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1152', '1017', '155', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1153', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1154', '1012', '154', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1155', '1017', '156', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1156', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1157', '1012', '155', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1158', '1017', '157', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1159', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1160', '1012', '156', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1161', '1017', '158', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1162', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1163', '1012', '157', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1164', '1017', '159', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1165', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1166', '1012', '158', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1167', '1017', '160', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1168', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1169', '1012', '159', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1170', '1017', '161', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1171', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1172', '1012', '160', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1173', '1017', '162', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1174', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1175', '1012', '161', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1176', '1017', '163', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1177', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1178', '1012', '162', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1179', '1017', '164', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1180', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1181', '1012', '163', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1182', '1017', '165', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1183', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1184', '1012', '164', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1185', '1017', '166', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1186', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1187', '1012', '165', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1188', '1017', '167', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1189', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1190', '1012', '166', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1191', '1017', '168', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1192', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1193', '1012', '167', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1194', '1017', '169', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1195', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1196', '1012', '168', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1197', '1017', '170', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1198', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1199', '1012', '169', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1200', '1017', '171', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1201', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1202', '1012', '170', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1203', '1017', '172', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1204', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1205', '1012', '171', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1206', '1017', '173', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1207', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1208', '1012', '172', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1209', '1017', '174', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1210', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1211', '1012', '173', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1212', '1017', '175', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1213', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1214', '1012', '174', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1215', '1017', '176', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1216', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1217', '1012', '175', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1218', '1017', '177', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1219', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1220', '1012', '176', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1221', '1017', '178', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1222', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1223', '1012', '177', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1224', '1017', '179', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1225', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1226', '1012', '178', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1227', '1017', '180', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1228', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1229', '1012', '179', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1230', '1017', '181', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1231', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1232', '1012', '180', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1233', '1017', '182', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1234', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1235', '1012', '181', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1236', '1017', '183', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1237', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1238', '1012', '182', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1239', '1017', '184', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1240', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1241', '1012', '183', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1242', '1017', '185', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1243', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1244', '1012', '184', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1245', '1017', '186', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1246', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1247', '1012', '185', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1248', '1017', '187', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1249', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1250', '1012', '186', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1251', '1017', '188', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1252', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1253', '1012', '187', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1254', '1017', '189', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1255', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1256', '1012', '188', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1257', '1017', '190', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1258', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1259', '1012', '189', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1260', '1017', '191', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1261', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1262', '1012', '190', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1263', '1017', '192', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1264', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1265', '1012', '191', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1266', '1017', '193', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1267', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1268', '1012', '192', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1269', '1017', '194', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1270', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1271', '1012', '193', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1272', '1017', '195', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1273', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1274', '1012', '194', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1275', '1017', '196', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1276', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1277', '1012', '195', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1278', '1017', '197', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1279', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1280', '1012', '196', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1281', '1017', '198', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1282', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1283', '1012', '197', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1284', '1017', '199', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1285', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1286', '1012', '198', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1287', '1017', '200', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1288', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1289', '1012', '199', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1290', '1017', '201', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1291', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1292', '1012', '200', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1293', '1017', '202', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1294', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1295', '1012', '201', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1296', '1017', '203', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1297', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1298', '1012', '202', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1299', '1017', '204', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1300', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1301', '1012', '203', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1302', '1017', '205', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1303', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1304', '1012', '204', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1305', '1017', '206', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1306', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1307', '1012', '205', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1308', '1017', '207', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1309', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1310', '1012', '206', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1311', '1017', '208', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1312', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1313', '1012', '207', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1314', '1017', '209', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1315', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1316', '1012', '208', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1317', '1017', '210', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1318', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1319', '1012', '209', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1320', '1017', '211', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1321', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1322', '1012', '210', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1323', '1017', '212', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1324', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1325', '1012', '211', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1326', '1017', '213', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1327', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1328', '1012', '212', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1329', '1017', '214', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1330', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1331', '1012', '213', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1332', '1017', '215', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1333', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1334', '1012', '214', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1335', '1017', '216', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1336', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1337', '1012', '215', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1338', '1017', '217', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1339', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1340', '1012', '216', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1341', '1017', '218', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1342', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1343', '1012', '217', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1344', '1017', '219', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1345', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1346', '1012', '218', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1347', '1017', '220', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1348', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1349', '1012', '219', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1350', '1017', '221', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1351', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1352', '1012', '220', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1353', '1017', '222', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1354', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1355', '1012', '221', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1356', '1017', '223', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1357', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1358', '1012', '222', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1359', '1017', '224', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1360', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1361', '1012', '223', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1362', '1017', '225', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1363', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1364', '1012', '224', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1365', '1017', '226', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1366', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1367', '1012', '225', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1368', '1017', '227', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1369', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1370', '1012', '226', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1371', '1017', '228', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1372', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1373', '1012', '227', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1374', '1017', '229', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1375', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1376', '1012', '228', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1377', '1017', '230', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1378', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1379', '1012', '229', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1380', '1017', '231', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1381', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1382', '1012', '230', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1383', '1017', '232', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1384', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1385', '1012', '231', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('1386', '1017', '233', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1387', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1388', '1012', '232', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1389', '1017', '234', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1390', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1391', '1012', '233', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1392', '1017', '235', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1393', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1394', '1012', '234', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1395', '1017', '236', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1396', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1397', '1012', '235', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1398', '1017', '237', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1399', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1400', '1012', '236', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1401', '1017', '238', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1402', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1403', '1012', '237', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1404', '1017', '239', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1405', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1406', '1012', '238', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1407', '1017', '240', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1408', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1409', '1012', '239', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1410', '1017', '241', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1411', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1412', '1012', '240', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1413', '1017', '242', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1414', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1415', '1012', '241', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1416', '1017', '243', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1417', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1418', '1012', '242', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1419', '1017', '244', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1420', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1421', '1012', '243', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1422', '1017', '245', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1423', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1424', '1012', '244', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1425', '1017', '246', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1426', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1427', '1012', '245', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1428', '1017', '247', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1429', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1430', '1012', '246', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1431', '1017', '248', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1432', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1433', '1012', '247', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1434', '1017', '249', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1435', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1436', '1012', '248', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1437', '1017', '250', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1438', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1439', '1012', '249', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1440', '1017', '251', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1441', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1442', '1012', '250', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1443', '1017', '252', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1444', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1445', '1012', '251', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1446', '1017', '253', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1447', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1448', '1012', '252', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1449', '1017', '254', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1450', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1451', '1012', '253', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1452', '1017', '255', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1453', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1454', '1012', '254', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1455', '1017', '256', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1456', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1457', '1012', '255', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1458', '1017', '257', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1459', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1460', '1012', '256', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1461', '1017', '258', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1462', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1463', '1012', '257', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1464', '1017', '259', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1465', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1466', '1012', '258', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1467', '1017', '260', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1468', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1469', '1012', '259', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1470', '1017', '261', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1471', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1472', '1012', '260', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1473', '1017', '262', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1474', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1475', '1012', '261', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1476', '1017', '263', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1477', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1478', '1012', '262', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1479', '1017', '264', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1480', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1481', '1012', '263', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1482', '1017', '265', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1483', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1484', '1012', '264', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1485', '1017', '266', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1486', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1487', '1012', '265', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1488', '1017', '267', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1489', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1490', '1012', '266', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1491', '1017', '268', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1492', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1493', '1012', '267', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1494', '1017', '269', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1495', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1496', '1012', '268', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1497', '1017', '270', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1498', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1499', '1012', '269', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1500', '1017', '271', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1501', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1502', '1012', '270', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1503', '1017', '272', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1504', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1505', '1012', '271', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1506', '1017', '273', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1507', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1508', '1012', '272', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1509', '1017', '274', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1510', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1511', '1012', '273', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1512', '1017', '275', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1513', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1514', '1012', '274', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1515', '1017', '276', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1516', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1517', '1012', '275', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1518', '1017', '277', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1519', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1520', '1012', '276', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1521', '1017', '278', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1522', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1523', '1012', '277', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1524', '1017', '279', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1525', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1526', '1012', '278', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1527', '1017', '280', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1528', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1529', '1012', '279', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1530', '1017', '281', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1531', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1532', '1012', '280', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1533', '1017', '282', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1534', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1535', '1012', '281', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1536', '1017', '283', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1537', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1538', '1012', '282', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1539', '1017', '284', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1540', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1541', '1012', '283', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1542', '1017', '285', '25', '2024-01-18 10:22:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1543', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1544', '1012', '284', '25', '2024-01-18 10:22:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1545', '1017', '286', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1546', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1547', '1012', '285', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1548', '1017', '287', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1549', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1550', '1012', '286', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1551', '1017', '288', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1552', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1553', '1012', '287', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1554', '1017', '289', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1555', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1556', '1012', '288', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1557', '1017', '290', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1558', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1559', '1012', '289', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1560', '1017', '291', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1561', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1562', '1012', '290', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1563', '1017', '292', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1564', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1565', '1012', '291', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1566', '1017', '293', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1567', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1568', '1012', '292', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1569', '1017', '294', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1570', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1571', '1012', '293', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1572', '1017', '295', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1573', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1574', '1012', '294', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1575', '1017', '296', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1576', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1577', '1012', '295', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1578', '1017', '297', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1579', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1580', '1012', '296', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1581', '1017', '298', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1582', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1583', '1012', '297', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1584', '1017', '299', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1585', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1586', '1012', '298', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1587', '1017', '300', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1588', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1589', '1012', '299', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1590', '1017', '301', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1591', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1592', '1012', '300', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1593', '1017', '302', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1594', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1595', '1012', '301', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1596', '1017', '303', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1597', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1598', '1012', '302', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1599', '1017', '304', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1600', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1601', '1012', '303', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1602', '1017', '305', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1603', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1604', '1012', '304', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1605', '1017', '306', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1606', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1607', '1012', '305', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1608', '1017', '307', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1609', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1610', '1012', '306', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1611', '1017', '308', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1612', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1613', '1012', '307', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1614', '1017', '309', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1615', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1616', '1012', '308', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1617', '1017', '310', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1618', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1619', '1012', '309', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1620', '1017', '311', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1621', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1622', '1012', '310', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1623', '1017', '312', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1624', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1625', '1012', '311', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1626', '1017', '313', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1627', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1628', '1012', '312', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1629', '1017', '314', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1630', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1631', '1012', '313', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1632', '1017', '315', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1633', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1634', '1012', '314', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1635', '1017', '316', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1636', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1637', '1012', '315', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1638', '1017', '317', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1639', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1640', '1012', '316', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1641', '1017', '318', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1642', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1643', '1012', '317', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1644', '1017', '319', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1645', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1646', '1012', '318', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1647', '1017', '320', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1648', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1649', '1012', '319', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1650', '1017', '321', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1651', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1652', '1012', '320', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1653', '1017', '322', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1654', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1655', '1012', '321', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1656', '1017', '323', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1657', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1658', '1012', '322', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1659', '1017', '324', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1660', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1661', '1012', '323', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1662', '1017', '325', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1663', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1664', '1012', '324', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1665', '1017', '326', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1666', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1667', '1012', '325', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1668', '1017', '327', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1669', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1670', '1012', '326', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1671', '1017', '328', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1672', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1673', '1012', '327', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1674', '1017', '329', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1675', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1676', '1012', '328', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1677', '1017', '330', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1678', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1679', '1012', '329', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1680', '1017', '331', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1681', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1682', '1012', '330', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1683', '1017', '332', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1684', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1685', '1012', '331', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1686', '1017', '333', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1687', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1688', '1012', '332', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1689', '1017', '334', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1690', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1691', '1012', '333', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1692', '1017', '335', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1693', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1694', '1012', '334', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1695', '1017', '336', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1696', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1697', '1012', '335', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1698', '1017', '337', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1699', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1700', '1012', '336', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1701', '1017', '338', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1702', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1703', '1012', '337', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1704', '1017', '339', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1705', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1706', '1012', '338', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1707', '1017', '340', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1708', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1709', '1012', '339', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1710', '1017', '341', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1711', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1712', '1012', '340', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1713', '1017', '342', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1714', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1715', '1012', '341', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1716', '1017', '343', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1717', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1718', '1012', '342', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1719', '1017', '344', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1720', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1721', '1012', '343', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1722', '1017', '345', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1723', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1724', '1012', '344', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1725', '1017', '346', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1726', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1727', '1012', '345', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1728', '1017', '347', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1729', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1730', '1012', '346', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1731', '1017', '348', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1732', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1733', '1012', '347', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1734', '1017', '349', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1735', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1736', '1012', '348', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1737', '1017', '350', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1738', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1739', '1012', '349', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1740', '1017', '351', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1741', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1742', '1012', '350', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1743', '1017', '352', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1744', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1745', '1012', '351', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1746', '1017', '353', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1747', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1748', '1012', '352', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1749', '1017', '354', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1750', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1751', '1012', '353', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1752', '1017', '355', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1753', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1754', '1012', '354', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1755', '1017', '356', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1756', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1757', '1012', '355', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1758', '1017', '357', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1759', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1760', '1012', '356', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1761', '1017', '358', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1762', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1763', '1012', '357', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1764', '1017', '359', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1765', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1766', '1012', '358', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1767', '1017', '360', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1768', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1769', '1012', '359', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1770', '1017', '361', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1771', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1772', '1012', '360', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1773', '1017', '362', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1774', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1775', '1012', '361', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1776', '1017', '363', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1777', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1778', '1012', '362', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1779', '1017', '364', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1780', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1781', '1012', '363', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1782', '1017', '365', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1783', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1784', '1012', '364', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1785', '1017', '366', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1786', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1787', '1012', '365', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1788', '1017', '367', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1789', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1790', '1012', '366', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1791', '1017', '368', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1792', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1793', '1012', '367', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1794', '1017', '369', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1795', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1796', '1012', '368', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1797', '1017', '370', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1798', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1799', '1012', '369', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1800', '1017', '371', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1801', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1802', '1012', '370', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1803', '1017', '372', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1804', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1805', '1012', '371', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1806', '1017', '373', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1807', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1808', '1012', '372', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1809', '1017', '374', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1810', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1811', '1012', '373', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1812', '1017', '375', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1813', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1814', '1012', '374', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1815', '1017', '376', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1816', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1817', '1012', '375', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1818', '1017', '377', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1819', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1820', '1012', '376', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1821', '1017', '378', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1822', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1823', '1012', '377', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1824', '1017', '379', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1825', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1826', '1012', '378', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1827', '1017', '380', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1828', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1829', '1012', '379', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1830', '1017', '381', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1831', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1832', '1012', '380', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1833', '1017', '382', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1834', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1835', '1012', '381', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1836', '1017', '383', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('1837', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1838', '1012', '382', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1839', '1017', '384', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1840', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1841', '1012', '383', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1842', '1017', '385', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1843', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1844', '1012', '384', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1845', '1017', '386', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1846', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1847', '1012', '385', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1848', '1017', '387', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1849', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1850', '1012', '386', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1851', '1017', '388', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1852', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1853', '1012', '387', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1854', '1017', '389', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1855', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1856', '1012', '388', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1857', '1017', '390', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1858', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1859', '1012', '389', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1860', '1017', '391', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1861', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1862', '1012', '390', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1863', '1017', '392', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1864', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1865', '1012', '391', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1866', '1017', '393', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1867', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1868', '1012', '392', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1869', '1017', '394', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1870', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1871', '1012', '393', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1872', '1017', '395', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1873', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1874', '1012', '394', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1875', '1017', '396', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1876', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1877', '1012', '395', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1878', '1017', '397', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1879', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1880', '1012', '396', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1881', '1017', '398', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1882', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1883', '1012', '397', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1884', '1017', '399', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1885', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1886', '1012', '398', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1887', '1017', '400', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1888', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1889', '1012', '399', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1890', '1017', '401', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1891', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1892', '1012', '400', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1893', '1017', '402', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1894', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1895', '1012', '401', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1896', '1017', '403', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1897', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1898', '1012', '402', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1899', '1017', '404', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1900', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1901', '1012', '403', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1902', '1017', '405', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1903', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1904', '1012', '404', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1905', '1017', '406', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1906', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1907', '1012', '405', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1908', '1017', '407', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1909', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1910', '1012', '406', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1911', '1017', '408', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1912', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1913', '1012', '406', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1914', '1017', '409', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1915', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1916', '1012', '406', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1917', '1017', '410', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1918', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1919', '1012', '407', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1920', '1017', '411', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1921', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1922', '1012', '408', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1923', '1017', '412', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1924', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1925', '1012', '409', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1926', '1017', '413', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1927', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1928', '1012', '410', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1929', '1017', '414', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1930', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1931', '1012', '411', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1932', '1017', '415', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1933', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1934', '1012', '412', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1935', '1017', '416', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1936', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1937', '1012', '413', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1938', '1017', '417', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1939', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1940', '1012', '414', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1941', '1017', '418', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1942', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1943', '1012', '415', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1944', '1017', '419', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1945', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1946', '1012', '416', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1947', '1017', '420', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1948', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1949', '1012', '417', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1950', '1017', '421', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1951', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1952', '1012', '418', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1953', '1017', '422', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1954', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1955', '1012', '419', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1956', '1017', '423', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1957', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1958', '1012', '420', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1959', '1017', '424', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1960', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1961', '1012', '421', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1962', '1017', '425', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1963', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1964', '1012', '422', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1965', '1017', '426', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1966', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1967', '1012', '423', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1968', '1017', '427', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1969', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1970', '1012', '424', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1971', '1017', '428', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1972', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1973', '1012', '425', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1974', '1017', '429', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1975', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1976', '1012', '426', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1977', '1017', '430', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1978', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1979', '1012', '427', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1980', '1017', '431', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1981', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1982', '1012', '428', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1983', '1017', '432', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1984', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1985', '1012', '429', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1986', '1017', '433', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1987', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1988', '1012', '430', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1989', '1017', '434', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1990', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1991', '1012', '431', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1992', '1017', '435', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1993', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1994', '1012', '432', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1995', '1017', '436', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1996', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('1997', '1012', '433', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('1998', '1017', '437', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('1999', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2000', '1012', '434', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2001', '1017', '438', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2002', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2003', '1012', '435', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2004', '1017', '439', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2005', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2006', '1012', '436', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2007', '1017', '440', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2008', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2009', '1012', '437', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2010', '1017', '441', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2011', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2012', '1012', '438', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2013', '1017', '442', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2014', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2015', '1012', '439', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2016', '1017', '443', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2017', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2018', '1012', '440', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2019', '1017', '444', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2020', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2021', '1012', '441', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2022', '1017', '445', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2023', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2024', '1012', '442', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2025', '1017', '446', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2026', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2027', '1012', '443', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2028', '1017', '447', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2029', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2030', '1012', '444', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2031', '1017', '448', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2032', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2033', '1012', '445', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2034', '1017', '449', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2035', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2036', '1012', '446', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2037', '1017', '450', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2038', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2039', '1012', '447', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2040', '1017', '451', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2041', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2042', '1012', '448', '25', '2024-01-18 10:22:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2043', '1017', '452', '25', '2024-01-18 10:22:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2044', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2045', '1012', '449', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2046', '1017', '453', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2047', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2048', '1012', '450', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2049', '1017', '454', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2050', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2051', '1012', '451', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2052', '1017', '455', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2053', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2054', '1012', '452', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2055', '1017', '456', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2056', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2057', '1012', '453', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2058', '1017', '457', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2059', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2060', '1012', '454', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2061', '1017', '458', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2062', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2063', '1012', '455', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2064', '1017', '459', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2065', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2066', '1012', '456', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2067', '1017', '460', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2068', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2069', '1012', '457', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2070', '1017', '461', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2071', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2072', '1012', '458', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2073', '1017', '462', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2074', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2075', '1012', '459', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2076', '1017', '463', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2077', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2078', '1012', '460', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2079', '1017', '464', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2080', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2081', '1012', '461', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2082', '1017', '465', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2083', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2084', '1012', '462', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2085', '1017', '466', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2086', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2087', '1012', '463', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2088', '1017', '467', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2089', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2090', '1012', '464', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2091', '1017', '468', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2092', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2093', '1012', '465', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2094', '1017', '469', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2095', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2096', '1012', '466', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2097', '1017', '470', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2098', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2099', '1012', '467', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2100', '1017', '471', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2101', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2102', '1012', '468', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2103', '1017', '472', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2104', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2105', '1012', '469', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2106', '1017', '473', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2107', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2108', '1012', '470', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2109', '1017', '474', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2110', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2111', '1012', '471', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2112', '1017', '475', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2113', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2114', '1012', '472', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2115', '1017', '476', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2116', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2117', '1012', '473', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2118', '1017', '477', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2119', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2120', '1012', '474', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2121', '1017', '478', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2122', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2123', '1012', '475', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2124', '1017', '479', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2125', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2126', '1012', '476', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2127', '1017', '480', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2128', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2129', '1012', '477', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2130', '1017', '481', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2131', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2132', '1012', '478', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2133', '1017', '482', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2134', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2135', '1012', '479', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2136', '1017', '483', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2137', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2138', '1012', '480', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2139', '1017', '484', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2140', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2141', '1012', '481', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2142', '1017', '485', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2143', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2144', '1012', '482', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2145', '1017', '486', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2146', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2147', '1012', '483', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2148', '1017', '487', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2149', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2150', '1012', '484', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2151', '1017', '488', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2152', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2153', '1012', '485', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2154', '1017', '489', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2155', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2156', '1012', '486', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2157', '1017', '490', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2158', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2159', '1012', '487', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2160', '1017', '491', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2161', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2162', '1012', '488', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2163', '1017', '492', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2164', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2165', '1012', '489', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2166', '1017', '493', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2167', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2168', '1012', '490', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2169', '1017', '494', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2170', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2171', '1012', '491', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2172', '1017', '495', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2173', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2174', '1012', '492', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2175', '1017', '496', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2176', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2177', '1012', '493', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2178', '1017', '497', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2179', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2180', '1012', '494', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2181', '1017', '498', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2182', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2183', '1012', '495', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2184', '1017', '499', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2185', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2186', '1012', '496', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2187', '1017', '500', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2188', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2189', '1012', '497', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2190', '1017', '501', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2191', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2192', '1012', '498', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2193', '1017', '502', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2194', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2195', '1012', '499', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2196', '1017', '503', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2197', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2198', '1012', '500', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2199', '1017', '504', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2200', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2201', '1012', '501', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2202', '1017', '505', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2203', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2204', '1012', '502', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2205', '1017', '506', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2206', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2207', '1012', '503', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2208', '1017', '507', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2209', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2210', '1012', '504', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2211', '1017', '508', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2212', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2213', '1012', '505', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2214', '1017', '509', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2215', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2216', '1012', '506', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2217', '1017', '510', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2218', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2219', '1012', '507', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2220', '1017', '511', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2221', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2222', '1012', '508', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2223', '1017', '512', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2224', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2225', '1012', '509', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2226', '1017', '513', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2227', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2228', '1012', '510', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2229', '1017', '514', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2230', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2231', '1012', '511', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2232', '1017', '515', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2233', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2234', '1012', '512', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2235', '1017', '516', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2236', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2237', '1012', '513', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2238', '1017', '517', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2239', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2240', '1012', '514', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2241', '1017', '518', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2242', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2243', '1012', '515', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2244', '1017', '519', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2245', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2246', '1012', '516', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2247', '1017', '520', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2248', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2249', '1012', '517', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2250', '1017', '521', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2251', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2252', '1012', '518', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2253', '1017', '522', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2254', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2255', '1012', '519', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2256', '1017', '523', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2257', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2258', '1012', '520', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2259', '1017', '524', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2260', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2261', '1012', '521', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2262', '1017', '525', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2263', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2264', '1012', '522', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2265', '1017', '526', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2266', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2267', '1012', '523', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2268', '1017', '527', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2269', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2270', '1012', '524', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2271', '1017', '528', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2272', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2273', '1012', '525', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2274', '1017', '529', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2275', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2276', '1012', '526', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2277', '1017', '530', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2278', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2279', '1012', '527', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2280', '1017', '531', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2281', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2282', '1012', '528', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2283', '1017', '532', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2284', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2285', '1012', '529', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2286', '1017', '533', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2287', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('2288', '1012', '530', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2289', '1017', '534', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2290', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2291', '1012', '531', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2292', '1017', '535', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2293', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2294', '1012', '532', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2295', '1017', '536', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2296', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2297', '1012', '533', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2298', '1017', '537', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2299', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2300', '1012', '534', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2301', '1017', '538', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2302', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2303', '1012', '535', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2304', '1017', '539', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2305', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2306', '1012', '536', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2307', '1017', '540', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2308', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2309', '1012', '537', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2310', '1017', '541', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2311', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2312', '1012', '538', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2313', '1017', '542', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2314', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2315', '1012', '539', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2316', '1017', '543', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2317', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2318', '1012', '540', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2319', '1017', '544', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2320', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2321', '1012', '541', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2322', '1017', '545', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2323', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2324', '1012', '542', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2325', '1017', '546', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2326', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2327', '1012', '543', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2328', '1017', '547', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2329', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2330', '1012', '544', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2331', '1017', '548', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2332', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2333', '1012', '545', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2334', '1017', '549', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2335', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2336', '1012', '546', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2337', '1017', '550', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2338', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2339', '1012', '547', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2340', '1017', '551', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2341', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2342', '1012', '548', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2343', '1017', '552', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2344', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2345', '1012', '549', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2346', '1017', '553', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2347', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2348', '1012', '550', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2349', '1017', '554', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2350', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2351', '1012', '551', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2352', '1017', '555', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2353', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2354', '1012', '552', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2355', '1017', '556', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2356', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2357', '1012', '553', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2358', '1017', '557', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2359', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2360', '1012', '554', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2361', '1017', '558', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2362', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2363', '1012', '555', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2364', '1017', '559', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2365', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2366', '1012', '556', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2367', '1017', '560', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2368', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2369', '1012', '557', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2370', '1017', '561', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2371', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2372', '1012', '558', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2373', '1017', '562', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2374', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2375', '1012', '559', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2376', '1017', '563', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2377', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2378', '1012', '560', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2379', '1017', '564', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2380', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2381', '1012', '561', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2382', '1017', '565', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2383', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2384', '1012', '562', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2385', '1017', '566', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2386', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2387', '1012', '563', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2388', '1017', '567', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2389', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2390', '1012', '564', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2391', '1017', '568', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2392', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2393', '1012', '565', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2394', '1017', '569', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2395', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2396', '1012', '566', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2397', '1017', '570', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2398', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2399', '1012', '567', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2400', '1017', '571', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2401', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2402', '1012', '568', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2403', '1017', '572', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2404', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2405', '1012', '569', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2406', '1017', '573', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2407', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2408', '1012', '570', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2409', '1017', '574', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2410', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2411', '1012', '571', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2412', '1017', '575', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2413', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2414', '1012', '572', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2415', '1017', '576', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2416', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2417', '1012', '573', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2418', '1017', '577', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2419', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2420', '1012', '574', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2421', '1017', '578', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2422', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2423', '1012', '575', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2424', '1017', '579', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2425', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2426', '1012', '576', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2427', '1017', '580', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2428', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2429', '1012', '577', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2430', '1017', '581', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2431', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2432', '1012', '578', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2433', '1017', '582', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2434', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2435', '1012', '579', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2436', '1017', '583', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2437', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2438', '1012', '580', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2439', '1017', '584', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2440', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2441', '1012', '581', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2442', '1017', '585', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2443', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2444', '1012', '582', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2445', '1017', '586', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2446', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2447', '1012', '583', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2448', '1017', '587', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2449', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2450', '1012', '584', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2451', '1017', '588', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2452', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2453', '1012', '585', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2454', '1017', '589', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2455', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2456', '1012', '586', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2457', '1017', '590', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2458', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2459', '1012', '587', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2460', '1017', '591', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2461', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2462', '1012', '588', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2463', '1017', '592', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2464', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2465', '1012', '589', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2466', '1017', '593', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2467', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2468', '1012', '590', '25', '2024-01-18 10:22:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2469', '1017', '594', '25', '2024-01-18 10:22:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2470', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2471', '1012', '1', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2472', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2473', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2474', '1012', '2', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2475', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2476', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2477', '1012', '3', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2478', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2479', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2480', '1012', '4', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2481', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2482', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2483', '1012', '5', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2484', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2485', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2486', '1012', '6', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2487', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2488', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2489', '1012', '7', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2490', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2491', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2492', '1012', '8', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2493', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2494', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2495', '1012', '9', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2496', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2497', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2498', '1012', '10', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2499', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2500', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2501', '1012', '11', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2502', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2503', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2504', '1012', '12', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2505', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2506', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2507', '1012', '13', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2508', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2509', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2510', '1012', '14', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2511', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2512', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2513', '1012', '15', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2514', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2515', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2516', '1012', '16', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2517', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2518', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2519', '1012', '17', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2520', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2521', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2522', '1012', '18', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2523', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2524', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2525', '1012', '19', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2526', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2527', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2528', '1012', '19', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2529', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2530', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2531', '1012', '20', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2532', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2533', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2534', '1012', '21', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2535', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2536', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2537', '1012', '22', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2538', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2539', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2540', '1012', '23', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2541', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2542', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2543', '1012', '24', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2544', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2545', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2546', '1012', '25', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2547', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2548', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2549', '1012', '26', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2550', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2551', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2552', '1012', '27', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2553', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2554', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2555', '1012', '28', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2556', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2557', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2558', '1012', '29', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2559', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2560', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2561', '1012', '30', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2562', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2563', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2564', '1012', '31', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2565', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2566', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2567', '1012', '32', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2568', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2569', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2570', '1012', '33', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2571', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2572', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2573', '1012', '34', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2574', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2575', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2576', '1012', '35', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2577', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2578', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2579', '1012', '36', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2580', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2581', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2582', '1012', '37', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2583', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2584', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2585', '1012', '38', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2586', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2587', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2588', '1012', '39', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2589', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2590', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2591', '1012', '40', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2592', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2593', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2594', '1012', '41', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2595', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2596', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2597', '1012', '42', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2598', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2599', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2600', '1012', '43', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2601', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2602', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2603', '1012', '44', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2604', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2605', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2606', '1012', '45', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2607', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2608', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2609', '1012', '46', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2610', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2611', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2612', '1012', '47', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2613', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2614', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2615', '1012', '48', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2616', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2617', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2618', '1012', '49', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2619', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2620', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2621', '1012', '50', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2622', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2623', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2624', '1012', '51', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2625', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2626', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2627', '1012', '52', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2628', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2629', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2630', '1012', '53', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2631', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2632', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2633', '1012', '54', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2634', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2635', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2636', '1012', '55', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2637', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2638', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2639', '1012', '56', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2640', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2641', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2642', '1012', '57', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2643', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2644', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2645', '1012', '58', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2646', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2647', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2648', '1012', '59', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2649', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2650', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2651', '1012', '60', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2652', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2653', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2654', '1012', '61', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2655', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2656', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2657', '1012', '62', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2658', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2659', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2660', '1012', '63', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2661', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2662', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2663', '1012', '64', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2664', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2665', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2666', '1012', '65', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2667', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2668', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2669', '1012', '66', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2670', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2671', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2672', '1012', '66', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2673', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2674', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2675', '1012', '67', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2676', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2677', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2678', '1012', '68', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2679', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2680', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2681', '1012', '69', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2682', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2683', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2684', '1012', '70', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2685', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2686', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2687', '1012', '71', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2688', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2689', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2690', '1012', '72', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2691', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2692', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2693', '1012', '73', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2694', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2695', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2696', '1012', '74', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2697', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2698', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2699', '1012', '75', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2700', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2701', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2702', '1012', '76', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2703', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2704', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2705', '1012', '77', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2706', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2707', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2708', '1012', '78', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2709', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2710', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2711', '1012', '79', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2712', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2713', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2714', '1012', '80', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2715', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2716', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2717', '1012', '81', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2718', '1017', '594', '25', '2024-01-18 10:26:20', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2719', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2720', '1012', '82', '25', '2024-01-18 10:26:20', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2721', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2722', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2723', '1012', '83', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2724', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2725', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2726', '1012', '84', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2727', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2728', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2729', '1012', '85', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2730', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2731', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2732', '1012', '86', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2733', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2734', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2735', '1012', '87', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2736', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2737', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2738', '1012', '88', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2739', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('2740', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2741', '1012', '89', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2742', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2743', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2744', '1012', '90', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2745', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2746', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2747', '1012', '91', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2748', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2749', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2750', '1012', '92', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2751', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2752', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2753', '1012', '93', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2754', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2755', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2756', '1012', '94', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2757', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2758', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2759', '1012', '95', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2760', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2761', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2762', '1012', '96', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2763', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2764', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2765', '1012', '97', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2766', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2767', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2768', '1012', '98', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2769', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2770', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2771', '1012', '99', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2772', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2773', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2774', '1012', '100', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2775', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2776', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2777', '1012', '101', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2778', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2779', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2780', '1012', '102', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2781', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2782', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2783', '1012', '103', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2784', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2785', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2786', '1012', '104', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2787', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2788', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2789', '1012', '105', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2790', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2791', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2792', '1012', '106', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2793', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2794', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2795', '1012', '107', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2796', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2797', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2798', '1012', '108', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2799', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2800', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2801', '1012', '109', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2802', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2803', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2804', '1012', '110', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2805', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2806', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2807', '1012', '111', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2808', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2809', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2810', '1012', '112', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2811', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2812', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2813', '1012', '113', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2814', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2815', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2816', '1012', '114', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2817', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2818', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2819', '1012', '115', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2820', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2821', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2822', '1012', '116', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2823', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2824', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2825', '1012', '117', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2826', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2827', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2828', '1012', '118', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2829', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2830', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2831', '1012', '119', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2832', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2833', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2834', '1012', '120', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2835', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2836', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2837', '1012', '121', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2838', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2839', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2840', '1012', '122', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2841', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2842', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2843', '1012', '123', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2844', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2845', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2846', '1012', '124', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2847', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2848', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2849', '1012', '125', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2850', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2851', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2852', '1012', '126', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2853', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2854', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2855', '1012', '127', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2856', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2857', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2858', '1012', '128', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2859', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2860', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2861', '1012', '129', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2862', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2863', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2864', '1012', '130', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2865', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2866', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2867', '1012', '131', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2868', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2869', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2870', '1012', '132', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2871', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2872', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2873', '1012', '133', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2874', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2875', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2876', '1012', '134', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2877', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2878', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2879', '1012', '135', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2880', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2881', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2882', '1012', '136', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2883', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2884', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2885', '1012', '137', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2886', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2887', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2888', '1012', '138', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2889', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2890', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2891', '1012', '139', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2892', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2893', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2894', '1012', '140', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2895', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2896', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2897', '1012', '141', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2898', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2899', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2900', '1012', '142', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2901', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2902', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2903', '1012', '143', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2904', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2905', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2906', '1012', '144', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2907', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2908', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2909', '1012', '145', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2910', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2911', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2912', '1012', '146', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2913', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2914', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2915', '1012', '147', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2916', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2917', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2918', '1012', '148', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2919', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2920', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2921', '1012', '149', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2922', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2923', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2924', '1012', '150', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2925', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2926', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2927', '1012', '151', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2928', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2929', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2930', '1012', '152', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2931', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2932', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2933', '1012', '153', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2934', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2935', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2936', '1012', '154', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2937', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2938', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2939', '1012', '155', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2940', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2941', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2942', '1012', '156', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2943', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2944', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2945', '1012', '157', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2946', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2947', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2948', '1012', '158', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2949', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2950', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2951', '1012', '159', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2952', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2953', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2954', '1012', '160', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2955', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2956', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2957', '1012', '161', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2958', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2959', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2960', '1012', '162', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2961', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2962', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2963', '1012', '163', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2964', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2965', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2966', '1012', '164', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2967', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2968', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2969', '1012', '165', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2970', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2971', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2972', '1012', '166', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2973', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2974', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2975', '1012', '167', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2976', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2977', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2978', '1012', '168', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2979', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2980', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2981', '1012', '169', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2982', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2983', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2984', '1012', '170', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2985', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2986', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2987', '1012', '171', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2988', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2989', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2990', '1012', '172', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2991', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2992', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2993', '1012', '173', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2994', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2995', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2996', '1012', '174', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('2997', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('2998', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('2999', '1012', '175', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3000', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3001', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3002', '1012', '176', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3003', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3004', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3005', '1012', '177', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3006', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3007', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3008', '1012', '178', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3009', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3010', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3011', '1012', '179', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3012', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3013', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3014', '1012', '180', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3015', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3016', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3017', '1012', '181', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3018', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3019', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3020', '1012', '182', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3021', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3022', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3023', '1012', '183', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3024', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3025', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3026', '1012', '184', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3027', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3028', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3029', '1012', '185', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3030', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3031', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3032', '1012', '186', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3033', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3034', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3035', '1012', '187', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3036', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3037', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3038', '1012', '188', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3039', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3040', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3041', '1012', '189', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3042', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3043', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3044', '1012', '190', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3045', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3046', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3047', '1012', '191', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3048', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3049', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3050', '1012', '192', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3051', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3052', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3053', '1012', '193', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3054', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3055', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3056', '1012', '194', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3057', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3058', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3059', '1012', '195', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3060', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3061', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3062', '1012', '196', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3063', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3064', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3065', '1012', '197', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3066', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3067', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3068', '1012', '198', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3069', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3070', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3071', '1012', '199', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3072', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3073', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3074', '1012', '200', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3075', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3076', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3077', '1012', '201', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3078', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3079', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3080', '1012', '202', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3081', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3082', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3083', '1012', '203', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3084', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3085', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3086', '1012', '204', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3087', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3088', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3089', '1012', '205', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3090', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3091', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3092', '1012', '206', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3093', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3094', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3095', '1012', '207', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3096', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3097', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3098', '1012', '208', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3099', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3100', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3101', '1012', '209', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3102', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3103', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3104', '1012', '210', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3105', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3106', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3107', '1012', '211', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3108', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3109', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3110', '1012', '212', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3111', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3112', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3113', '1012', '213', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3114', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3115', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3116', '1012', '214', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3117', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3118', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3119', '1012', '215', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3120', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3121', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3122', '1012', '216', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3123', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3124', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3125', '1012', '217', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3126', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3127', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3128', '1012', '218', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3129', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3130', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3131', '1012', '219', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3132', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3133', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3134', '1012', '220', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3135', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3136', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3137', '1012', '221', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3138', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3139', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3140', '1012', '222', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3141', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3142', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3143', '1012', '223', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3144', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3145', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3146', '1012', '224', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3147', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3148', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3149', '1012', '225', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3150', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3151', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3152', '1012', '226', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3153', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3154', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3155', '1012', '227', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3156', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3157', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3158', '1012', '228', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3159', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3160', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3161', '1012', '229', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3162', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3163', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3164', '1012', '230', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3165', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3166', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3167', '1012', '231', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3168', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3169', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3170', '1012', '232', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3171', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3172', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3173', '1012', '233', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3174', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3175', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3176', '1012', '234', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3177', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3178', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3179', '1012', '235', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3180', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3181', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3182', '1012', '236', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3183', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3184', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3185', '1012', '237', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3186', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3187', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3188', '1012', '238', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3189', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3190', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('3191', '1012', '239', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3192', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3193', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3194', '1012', '240', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3195', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3196', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3197', '1012', '241', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3198', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3199', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3200', '1012', '242', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3201', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3202', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3203', '1012', '243', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3204', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3205', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3206', '1012', '244', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3207', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3208', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3209', '1012', '245', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3210', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3211', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3212', '1012', '246', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3213', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3214', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3215', '1012', '247', '25', '2024-01-18 10:26:21', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3216', '1017', '594', '25', '2024-01-18 10:26:21', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3217', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3218', '1012', '248', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3219', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3220', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3221', '1012', '249', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3222', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3223', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3224', '1012', '250', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3225', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3226', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3227', '1012', '251', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3228', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3229', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3230', '1012', '252', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3231', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3232', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3233', '1012', '253', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3234', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3235', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3236', '1012', '254', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3237', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3238', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3239', '1012', '255', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3240', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3241', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3242', '1012', '256', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3243', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3244', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3245', '1012', '257', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3246', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3247', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3248', '1012', '258', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3249', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3250', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3251', '1012', '259', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3252', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3253', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3254', '1012', '260', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3255', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3256', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3257', '1012', '261', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3258', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3259', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3260', '1012', '262', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3261', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3262', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3263', '1012', '263', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3264', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3265', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3266', '1012', '264', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3267', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3268', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3269', '1012', '265', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3270', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3271', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3272', '1012', '266', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3273', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3274', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3275', '1012', '267', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3276', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3277', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3278', '1012', '268', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3279', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3280', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3281', '1012', '269', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3282', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3283', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3284', '1012', '270', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3285', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3286', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3287', '1012', '271', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3288', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3289', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3290', '1012', '272', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3291', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3292', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3293', '1012', '273', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3294', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3295', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3296', '1012', '274', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3297', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3298', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3299', '1012', '275', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3300', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3301', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3302', '1012', '276', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3303', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3304', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3305', '1012', '277', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3306', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3307', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3308', '1012', '278', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3309', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3310', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3311', '1012', '279', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3312', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3313', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3314', '1012', '280', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3315', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3316', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3317', '1012', '281', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3318', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3319', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3320', '1012', '282', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3321', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3322', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3323', '1012', '283', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3324', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3325', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3326', '1012', '284', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3327', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3328', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3329', '1012', '285', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3330', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3331', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3332', '1012', '286', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3333', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3334', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3335', '1012', '287', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3336', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3337', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3338', '1012', '288', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3339', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3340', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3341', '1012', '289', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3342', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3343', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3344', '1012', '290', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3345', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3346', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3347', '1012', '291', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3348', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3349', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3350', '1012', '292', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3351', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3352', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3353', '1012', '293', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3354', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3355', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3356', '1012', '294', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3357', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3358', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3359', '1012', '295', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3360', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3361', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3362', '1012', '296', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3363', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3364', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3365', '1012', '297', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3366', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3367', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3368', '1012', '298', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3369', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3370', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3371', '1012', '299', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3372', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3373', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3374', '1012', '300', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3375', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3376', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3377', '1012', '301', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3378', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3379', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3380', '1012', '302', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3381', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3382', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3383', '1012', '303', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3384', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3385', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3386', '1012', '304', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3387', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3388', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3389', '1012', '305', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3390', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3391', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3392', '1012', '306', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3393', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3394', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3395', '1012', '307', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3396', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3397', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3398', '1012', '308', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3399', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3400', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3401', '1012', '309', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3402', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3403', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3404', '1012', '310', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3405', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3406', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3407', '1012', '311', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3408', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3409', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3410', '1012', '312', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3411', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3412', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3413', '1012', '313', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3414', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3415', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3416', '1012', '314', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3417', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3418', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3419', '1012', '315', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3420', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3421', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3422', '1012', '316', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3423', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3424', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3425', '1012', '317', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3426', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3427', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3428', '1012', '318', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3429', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3430', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3431', '1012', '319', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3432', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3433', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3434', '1012', '320', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3435', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3436', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3437', '1012', '321', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3438', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3439', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3440', '1012', '322', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3441', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3442', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3443', '1012', '323', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3444', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3445', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3446', '1012', '324', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3447', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3448', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3449', '1012', '325', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3450', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3451', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3452', '1012', '326', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3453', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3454', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3455', '1012', '327', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3456', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3457', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3458', '1012', '328', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3459', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3460', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3461', '1012', '329', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3462', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3463', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3464', '1012', '330', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3465', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3466', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3467', '1012', '331', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3468', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3469', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3470', '1012', '332', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3471', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3472', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3473', '1012', '333', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3474', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3475', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3476', '1012', '334', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3477', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3478', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3479', '1012', '335', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3480', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3481', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3482', '1012', '336', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3483', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3484', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3485', '1012', '337', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3486', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3487', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3488', '1012', '338', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3489', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3490', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3491', '1012', '339', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3492', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3493', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3494', '1012', '340', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3495', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3496', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3497', '1012', '341', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3498', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3499', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3500', '1012', '342', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3501', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3502', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3503', '1012', '343', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3504', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3505', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3506', '1012', '344', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3507', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3508', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3509', '1012', '345', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3510', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3511', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3512', '1012', '346', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3513', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3514', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3515', '1012', '347', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3516', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3517', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3518', '1012', '348', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3519', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3520', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3521', '1012', '349', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3522', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3523', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3524', '1012', '350', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3525', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3526', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3527', '1012', '351', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3528', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3529', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3530', '1012', '352', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3531', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3532', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3533', '1012', '353', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3534', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3535', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3536', '1012', '354', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3537', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3538', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3539', '1012', '355', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3540', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3541', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3542', '1012', '356', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3543', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3544', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3545', '1012', '357', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3546', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3547', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3548', '1012', '358', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3549', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3550', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3551', '1012', '359', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3552', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3553', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3554', '1012', '360', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3555', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3556', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3557', '1012', '361', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3558', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3559', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3560', '1012', '362', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3561', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3562', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3563', '1012', '363', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3564', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3565', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3566', '1012', '364', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3567', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3568', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3569', '1012', '365', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3570', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3571', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3572', '1012', '366', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3573', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3574', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3575', '1012', '367', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3576', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3577', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3578', '1012', '368', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3579', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3580', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3581', '1012', '369', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3582', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3583', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3584', '1012', '370', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3585', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3586', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3587', '1012', '371', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3588', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3589', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3590', '1012', '372', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3591', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3592', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3593', '1012', '373', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3594', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3595', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3596', '1012', '374', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3597', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3598', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3599', '1012', '375', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3600', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3601', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3602', '1012', '376', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3603', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3604', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3605', '1012', '377', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3606', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3607', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3608', '1012', '378', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3609', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3610', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3611', '1012', '379', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3612', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3613', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3614', '1012', '380', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3615', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3616', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3617', '1012', '381', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3618', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3619', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3620', '1012', '382', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3621', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3622', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3623', '1012', '383', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3624', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3625', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3626', '1012', '384', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3627', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3628', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3629', '1012', '385', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3630', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3631', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3632', '1012', '386', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3633', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3634', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3635', '1012', '387', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3636', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3637', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3638', '1012', '388', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3639', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3640', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3641', '1012', '389', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('3642', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3643', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3644', '1012', '390', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3645', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3646', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3647', '1012', '391', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3648', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3649', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3650', '1012', '392', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3651', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3652', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3653', '1012', '393', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3654', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3655', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3656', '1012', '394', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3657', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3658', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3659', '1012', '395', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3660', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3661', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3662', '1012', '396', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3663', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3664', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3665', '1012', '397', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3666', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3667', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3668', '1012', '398', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3669', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3670', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3671', '1012', '399', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3672', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3673', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3674', '1012', '400', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3675', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3676', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3677', '1012', '401', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3678', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3679', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3680', '1012', '402', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3681', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3682', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3683', '1012', '403', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3684', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3685', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3686', '1012', '404', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3687', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3688', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3689', '1012', '405', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3690', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3691', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3692', '1012', '406', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3693', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3694', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3695', '1012', '406', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3696', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3697', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3698', '1012', '406', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3699', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3700', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3701', '1012', '407', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3702', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3703', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3704', '1012', '408', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3705', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3706', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3707', '1012', '409', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3708', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3709', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3710', '1012', '410', '25', '2024-01-18 10:26:22', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3711', '1017', '594', '25', '2024-01-18 10:26:22', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3712', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3713', '1012', '411', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3714', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3715', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3716', '1012', '412', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3717', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3718', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3719', '1012', '413', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3720', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3721', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3722', '1012', '414', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3723', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3724', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3725', '1012', '415', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3726', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3727', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3728', '1012', '416', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3729', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3730', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3731', '1012', '417', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3732', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3733', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3734', '1012', '418', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3735', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3736', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3737', '1012', '419', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3738', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3739', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3740', '1012', '420', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3741', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3742', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3743', '1012', '421', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3744', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3745', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3746', '1012', '422', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3747', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3748', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3749', '1012', '423', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3750', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3751', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3752', '1012', '424', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3753', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3754', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3755', '1012', '425', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3756', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3757', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3758', '1012', '426', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3759', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3760', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3761', '1012', '427', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3762', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3763', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3764', '1012', '428', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3765', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3766', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3767', '1012', '429', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3768', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3769', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3770', '1012', '430', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3771', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3772', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3773', '1012', '431', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3774', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3775', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3776', '1012', '432', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3777', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3778', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3779', '1012', '433', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3780', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3781', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3782', '1012', '434', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3783', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3784', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3785', '1012', '435', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3786', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3787', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3788', '1012', '436', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3789', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3790', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3791', '1012', '437', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3792', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3793', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3794', '1012', '438', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3795', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3796', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3797', '1012', '439', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3798', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3799', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3800', '1012', '440', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3801', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3802', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3803', '1012', '441', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3804', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3805', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3806', '1012', '442', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3807', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3808', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3809', '1012', '443', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3810', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3811', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3812', '1012', '444', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3813', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3814', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3815', '1012', '445', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3816', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3817', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3818', '1012', '446', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3819', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3820', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3821', '1012', '447', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3822', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3823', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3824', '1012', '448', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3825', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3826', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3827', '1012', '449', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3828', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3829', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3830', '1012', '450', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3831', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3832', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3833', '1012', '451', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3834', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3835', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3836', '1012', '452', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3837', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3838', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3839', '1012', '453', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3840', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3841', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3842', '1012', '454', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3843', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3844', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3845', '1012', '455', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3846', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3847', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3848', '1012', '456', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3849', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3850', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3851', '1012', '457', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3852', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3853', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3854', '1012', '458', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3855', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3856', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3857', '1012', '459', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3858', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3859', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3860', '1012', '460', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3861', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3862', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3863', '1012', '461', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3864', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3865', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3866', '1012', '462', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3867', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3868', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3869', '1012', '463', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3870', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3871', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3872', '1012', '464', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3873', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3874', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3875', '1012', '465', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3876', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3877', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3878', '1012', '466', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3879', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3880', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3881', '1012', '467', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3882', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3883', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3884', '1012', '468', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3885', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3886', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3887', '1012', '469', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3888', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3889', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3890', '1012', '470', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3891', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3892', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3893', '1012', '471', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3894', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3895', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3896', '1012', '472', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3897', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3898', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3899', '1012', '473', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3900', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3901', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3902', '1012', '474', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3903', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3904', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3905', '1012', '475', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3906', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3907', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3908', '1012', '476', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3909', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3910', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3911', '1012', '477', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3912', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3913', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3914', '1012', '478', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3915', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3916', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3917', '1012', '479', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3918', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3919', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3920', '1012', '480', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3921', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3922', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3923', '1012', '481', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3924', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3925', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3926', '1012', '482', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3927', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3928', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3929', '1012', '483', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3930', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3931', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3932', '1012', '484', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3933', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3934', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3935', '1012', '485', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3936', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3937', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3938', '1012', '486', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3939', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3940', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3941', '1012', '487', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3942', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3943', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3944', '1012', '488', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3945', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3946', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3947', '1012', '489', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3948', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3949', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3950', '1012', '490', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3951', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3952', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3953', '1012', '491', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3954', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3955', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3956', '1012', '492', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3957', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3958', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3959', '1012', '493', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3960', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3961', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3962', '1012', '494', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3963', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3964', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3965', '1012', '495', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3966', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3967', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3968', '1012', '496', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3969', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3970', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3971', '1012', '497', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3972', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3973', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3974', '1012', '498', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3975', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3976', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3977', '1012', '499', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3978', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3979', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3980', '1012', '500', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3981', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3982', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3983', '1012', '501', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3984', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3985', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3986', '1012', '502', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3987', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3988', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3989', '1012', '503', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3990', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3991', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3992', '1012', '504', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3993', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3994', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3995', '1012', '505', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3996', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('3997', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('3998', '1012', '506', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('3999', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4000', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4001', '1012', '507', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4002', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4003', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4004', '1012', '508', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4005', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4006', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4007', '1012', '509', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4008', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4009', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4010', '1012', '510', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4011', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4012', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4013', '1012', '511', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4014', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4015', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4016', '1012', '512', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4017', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4018', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4019', '1012', '513', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4020', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4021', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4022', '1012', '514', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4023', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4024', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4025', '1012', '515', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4026', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4027', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4028', '1012', '516', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4029', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4030', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4031', '1012', '517', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4032', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4033', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4034', '1012', '518', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4035', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4036', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4037', '1012', '519', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4038', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4039', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4040', '1012', '520', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4041', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4042', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4043', '1012', '521', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4044', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4045', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4046', '1012', '522', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4047', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4048', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4049', '1012', '523', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4050', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4051', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4052', '1012', '524', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4053', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4054', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4055', '1012', '525', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4056', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4057', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4058', '1012', '526', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4059', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4060', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4061', '1012', '527', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4062', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4063', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4064', '1012', '528', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4065', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4066', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4067', '1012', '529', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4068', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4069', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4070', '1012', '530', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4071', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4072', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4073', '1012', '531', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4074', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4075', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4076', '1012', '532', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4077', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4078', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4079', '1012', '533', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4080', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4081', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4082', '1012', '534', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4083', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4084', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4085', '1012', '535', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4086', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4087', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4088', '1012', '536', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4089', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4090', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4091', '1012', '537', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4092', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('4093', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4094', '1012', '538', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4095', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4096', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4097', '1012', '539', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4098', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4099', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4100', '1012', '540', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4101', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4102', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4103', '1012', '541', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4104', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4105', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4106', '1012', '542', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4107', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4108', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4109', '1012', '543', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4110', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4111', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4112', '1012', '544', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4113', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4114', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4115', '1012', '545', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4116', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4117', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4118', '1012', '546', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4119', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4120', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4121', '1012', '547', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4122', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4123', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4124', '1012', '548', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4125', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4126', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4127', '1012', '549', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4128', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4129', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4130', '1012', '550', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4131', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4132', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4133', '1012', '551', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4134', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4135', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4136', '1012', '552', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4137', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4138', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4139', '1012', '553', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4140', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4141', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4142', '1012', '554', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4143', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4144', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4145', '1012', '555', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4146', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4147', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4148', '1012', '556', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4149', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4150', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4151', '1012', '557', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4152', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4153', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4154', '1012', '558', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4155', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4156', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4157', '1012', '559', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4158', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4159', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4160', '1012', '560', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4161', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4162', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4163', '1012', '561', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4164', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4165', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4166', '1012', '562', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4167', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4168', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4169', '1012', '563', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4170', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4171', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4172', '1012', '564', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4173', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4174', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4175', '1012', '565', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4176', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4177', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4178', '1012', '566', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4179', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4180', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4181', '1012', '567', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4182', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4183', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4184', '1012', '568', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4185', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4186', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4187', '1012', '569', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4188', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4189', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4190', '1012', '570', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4191', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4192', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4193', '1012', '571', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4194', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4195', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4196', '1012', '572', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4197', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4198', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4199', '1012', '573', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4200', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4201', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4202', '1012', '574', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4203', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4204', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4205', '1012', '575', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4206', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4207', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4208', '1012', '576', '25', '2024-01-18 10:26:23', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4209', '1017', '594', '25', '2024-01-18 10:26:23', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4210', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4211', '1012', '577', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4212', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4213', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4214', '1012', '578', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4215', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4216', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4217', '1012', '579', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4218', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4219', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4220', '1012', '580', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4221', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4222', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4223', '1012', '581', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4224', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4225', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4226', '1012', '582', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4227', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4228', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4229', '1012', '583', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4230', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4231', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4232', '1012', '584', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4233', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4234', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4235', '1012', '585', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4236', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4237', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4238', '1012', '586', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4239', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4240', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4241', '1012', '587', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4242', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4243', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4244', '1012', '588', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4245', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4246', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4247', '1012', '589', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4248', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4249', '1010', '0', '25', '2024-01-18 10:48:46', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4250', '1012', '590', '25', '2024-01-18 10:26:24', 'Create Sales Kits', '0', '2024-01-18', NULL, '0', '0'),
('4251', '1017', '594', '25', '2024-01-18 10:26:24', 'Create New Item Sales prices', '0', '2024-01-18', NULL, '0', '0'),
('4252', '1010', '0', '1', '2024-01-18 10:48:58', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4253', '1011', '590', '1', '2024-01-18 10:48:58', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4254', '1010', '0', '1', '2024-01-18 10:50:42', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4255', '1011', '590', '1', '2024-01-18 10:50:43', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4256', '1010', '0', '1', '2024-01-18 10:51:02', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4257', '1011', '590', '1', '2024-01-18 10:51:02', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4258', '1010', '0', '1', '2024-01-18 10:51:18', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4259', '1011', '590', '1', '2024-01-18 10:51:18', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4260', '1010', '0', '1', '2024-01-18 10:51:33', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4261', '1011', '590', '1', '2024-01-18 10:51:33', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4262', '1010', '0', '1', '2024-01-18 10:52:07', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4263', '1011', '590', '1', '2024-01-18 10:52:07', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4264', '1010', '0', '1', '2024-01-18 10:54:09', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4265', '1011', '590', '1', '2024-01-18 10:54:09', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4266', '1028', '27078', '1', '2024-01-18 10:58:36', 'Account Data Added', '13', '2024-01-18', NULL, '0', '0'),
('4267', '1010', '0', '1', '2024-01-18 10:56:43', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4268', '1011', '590', '1', '2024-01-18 10:56:43', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4269', '1010', '0', '1', '2024-01-18 10:56:50', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4270', '1011', '590', '1', '2024-01-18 10:56:51', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4271', '1010', '0', '1', '2024-01-18 10:57:08', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4272', '1011', '590', '1', '2024-01-18 10:57:08', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4273', '1010', '0', '1', '2024-01-18 10:57:28', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4274', '1011', '590', '1', '2024-01-18 10:57:28', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4275', '1010', '0', '1', '2024-01-18 10:58:31', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4276', '1011', '590', '1', '2024-01-18 10:58:31', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4277', '1010', '0', '1', '2024-01-18 10:59:46', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4278', '1011', '590', '1', '2024-01-18 10:59:46', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4279', '1028', '27078', '1', '2024-01-18 10:58:36', 'Account Data Deleted', '13', '2024-01-18', '0', '0', '0'),
('4280', '1028', '21078', '1', '2024-01-18 10:59:21', 'Account Data Added', '13', '2024-01-18', '0', '0', '0'),
('4281', '1010', '0', '1', '2024-01-18 11:02:55', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4282', '1011', '590', '1', '2024-01-18 11:02:56', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4283', '1028', '21079', '1', '2024-01-18 11:02:35', 'Account Data Added', '13', '2024-01-18', '0', '0', '0'),
('4284', '1010', '0', '1', '2024-01-18 11:03:11', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4285', '1011', '590', '1', '2024-01-18 11:03:11', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4286', '1010', '0', '1', '2024-01-18 11:03:37', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4287', '1011', '590', '1', '2024-01-18 11:03:37', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4288', '1010', '0', '1', '2024-01-18 11:04:00', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4289', '1011', '590', '1', '2024-01-18 11:04:00', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4290', '1010', '0', '1', '2024-01-18 11:04:38', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4291', '1011', '590', '1', '2024-01-18 11:04:38', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4292', '1010', '0', '1', '2024-01-18 11:04:54', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4293', '1011', '590', '1', '2024-01-18 11:04:54', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4294', '1010', '0', '1', '2024-01-18 11:05:08', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4295', '1011', '590', '1', '2024-01-18 11:05:08', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4296', '1010', '0', '1', '2024-01-18 11:05:26', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4297', '1011', '590', '1', '2024-01-18 11:05:26', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4298', '1010', '0', '1', '2024-01-18 11:05:42', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4299', '1011', '590', '1', '2024-01-18 11:05:42', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4300', '1010', '0', '1', '2024-01-18 11:05:58', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4301', '1011', '590', '1', '2024-01-18 11:05:58', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4302', '1010', '0', '1', '2024-01-18 11:06:20', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4303', '1011', '590', '1', '2024-01-18 11:06:20', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4304', '1010', '0', '1', '2024-01-18 11:07:03', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4305', '1011', '590', '1', '2024-01-18 11:07:03', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4306', '1010', '0', '1', '2024-01-18 11:07:38', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4307', '1011', '590', '1', '2024-01-18 11:07:38', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4308', '1010', '0', '1', '2024-01-18 11:07:55', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4309', '1011', '590', '1', '2024-01-18 11:07:55', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4310', '1010', '0', '1', '2024-01-18 11:08:15', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4311', '1011', '590', '1', '2024-01-18 11:08:15', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4312', '1010', '0', '1', '2024-01-18 11:08:53', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4313', '1011', '590', '1', '2024-01-18 11:08:53', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4314', '1010', '0', '1', '2024-01-18 11:09:35', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4315', '1011', '590', '1', '2024-01-18 11:09:35', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4316', '1010', '0', '1', '2024-01-18 11:09:56', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4317', '1011', '590', '1', '2024-01-18 11:09:56', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4318', '1010', '0', '1', '2024-01-18 11:10:34', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4319', '1011', '590', '1', '2024-01-18 11:10:34', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4320', '1010', '0', '1', '2024-01-18 11:10:54', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4321', '1011', '590', '1', '2024-01-18 11:10:54', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4322', '1010', '0', '1', '2024-01-18 11:11:30', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4323', '1011', '590', '1', '2024-01-18 11:11:30', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4324', '1010', '0', '1', '2024-01-18 11:11:56', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4325', '1011', '590', '1', '2024-01-18 11:11:56', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4326', '1010', '0', '1', '2024-01-18 11:12:36', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4327', '1011', '590', '1', '2024-01-18 11:12:36', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4328', '1010', '0', '1', '2024-01-18 11:13:34', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4329', '1011', '590', '1', '2024-01-18 11:13:34', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4330', '1010', '0', '1', '2024-01-18 11:14:04', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4331', '1011', '590', '1', '2024-01-18 11:14:04', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4332', '1010', '0', '1', '2024-01-18 11:14:31', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4333', '1011', '590', '1', '2024-01-18 11:14:31', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4334', '1010', '0', '1', '2024-01-18 11:14:59', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4335', '1011', '590', '1', '2024-01-18 11:14:59', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4336', '1010', '0', '1', '2024-01-18 11:15:14', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4337', '1011', '590', '1', '2024-01-18 11:15:14', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4338', '1010', '0', '1', '2024-01-18 11:15:36', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4339', '1011', '590', '1', '2024-01-18 11:15:36', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4340', '1010', '0', '1', '2024-01-18 11:15:54', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4341', '1011', '590', '1', '2024-01-18 11:15:54', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4342', '1010', '0', '1', '2024-01-18 11:16:13', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4343', '1011', '590', '1', '2024-01-18 11:16:13', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4344', '1010', '0', '1', '2024-01-18 11:16:34', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4345', '1011', '590', '1', '2024-01-18 11:16:34', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4346', '1010', '0', '1', '2024-01-18 11:17:03', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4347', '1011', '590', '1', '2024-01-18 11:17:03', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4348', '1010', '0', '1', '2024-01-18 11:17:26', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4349', '1011', '590', '1', '2024-01-18 11:17:26', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4350', '1010', '0', '1', '2024-01-18 11:19:07', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4351', '1011', '590', '1', '2024-01-18 11:19:07', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4352', '1010', '0', '1', '2024-01-18 11:19:33', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4353', '1011', '590', '1', '2024-01-18 11:19:33', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4354', '1010', '0', '1', '2024-01-18 11:20:42', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4355', '1011', '590', '1', '2024-01-18 11:20:42', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4356', '1010', '0', '1', '2024-01-18 11:21:10', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4357', '1011', '590', '1', '2024-01-18 11:21:10', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4358', '1010', '0', '1', '2024-01-18 11:21:43', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4359', '1011', '590', '1', '2024-01-18 11:21:43', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4360', '1010', '0', '1', '2024-01-18 11:22:17', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4361', '1011', '590', '1', '2024-01-18 11:22:17', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4362', '1010', '0', '1', '2024-01-18 11:22:40', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4363', '1011', '590', '1', '2024-01-18 11:22:40', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4364', '1010', '0', '1', '2024-01-18 11:22:59', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4365', '1011', '590', '1', '2024-01-18 11:22:59', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4366', '1010', '0', '1', '2024-01-18 11:23:30', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4367', '1011', '590', '1', '2024-01-18 11:23:30', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4368', '1010', '0', '1', '2024-01-18 11:23:53', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4369', '1011', '590', '1', '2024-01-18 11:23:53', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4370', '1010', '0', '1', '2024-01-18 11:24:44', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4371', '1011', '590', '1', '2024-01-18 11:24:44', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4372', '1010', '0', '1', '2024-01-18 11:25:37', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4373', '1011', '590', '1', '2024-01-18 11:25:37', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4374', '1010', '0', '1', '2024-01-18 11:26:03', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4375', '1011', '590', '1', '2024-01-18 11:26:03', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4376', '1010', '0', '1', '2024-01-18 11:26:27', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4377', '1011', '590', '1', '2024-01-18 11:26:27', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4378', '1010', '0', '1', '2024-01-18 11:27:12', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4379', '1011', '590', '1', '2024-01-18 11:27:12', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4380', '1010', '0', '1', '2024-01-18 11:27:34', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4381', '1011', '590', '1', '2024-01-18 11:27:34', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4382', '1010', '0', '1', '2024-01-18 11:28:19', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4383', '1011', '590', '1', '2024-01-18 11:28:19', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4384', '1010', '0', '1', '2024-01-18 11:29:00', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4385', '1011', '590', '1', '2024-01-18 11:29:00', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4386', '1010', '0', '1', '2024-01-18 11:29:26', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4387', '1011', '590', '1', '2024-01-18 11:29:26', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4388', '1010', '0', '1', '2024-01-18 11:29:53', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4389', '1011', '590', '1', '2024-01-18 11:29:53', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4390', '1010', '0', '1', '2024-01-18 11:30:08', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4391', '1011', '590', '1', '2024-01-18 11:30:08', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4392', '1010', '0', '1', '2024-01-18 11:30:24', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4393', '1011', '590', '1', '2024-01-18 11:30:24', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4394', '1010', '0', '1', '2024-01-18 11:30:49', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4395', '1011', '590', '1', '2024-01-18 11:30:49', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4396', '1010', '0', '1', '2024-01-18 11:32:00', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4397', '1011', '590', '1', '2024-01-18 11:32:00', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4398', '1010', '0', '1', '2024-01-18 11:32:20', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4399', '1011', '590', '1', '2024-01-18 11:32:20', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4400', '1010', '0', '1', '2024-01-18 11:32:38', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4401', '1011', '590', '1', '2024-01-18 11:32:38', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4402', '1010', '0', '1', '2024-01-18 11:32:52', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4403', '1011', '590', '1', '2024-01-18 11:32:52', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4404', '1010', '0', '1', '2024-01-18 11:36:02', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4405', '1011', '590', '1', '2024-01-18 11:32:52', 'Update Item Codes', '13', '2024-01-18', '0', '0', '0'),
('4406', '1011', '591', '1', '2024-01-18 11:38:11', 'Create Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4407', '1010', '0', '1', '2024-01-18 11:38:11', 'Create New Item', '13', '2024-01-18', NULL, '0', '0'),
('4408', '1028', '21010', '1', '2024-02-20 10:25:09', 'Account Data Deleted', '13', '2024-01-18', NULL, '0', '0'),
('4409', '1010', '0', '1', '2024-01-18 11:38:51', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4410', '1011', '591', '1', '2024-01-18 11:38:52', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4411', '1010', '0', '1', '2024-01-18 11:39:29', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4412', '1011', '591', '1', '2024-01-18 11:39:29', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4413', '1010', '0', '1', '2024-01-18 11:39:52', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4414', '1011', '591', '1', '2024-01-18 11:39:52', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4415', '1010', '0', '1', '2024-01-18 11:42:39', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4416', '1011', '591', '1', '2024-01-18 11:42:39', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4417', '1028', '21080', '1', '2024-01-18 11:42:10', 'Account Data Added', '13', '2024-01-18', '0', '0', '0'),
('4418', '1010', '0', '1', '2024-01-18 11:46:40', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4419', '1011', '591', '1', '2024-01-18 11:46:40', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4420', '1010', '0', '1', '2024-01-18 11:47:25', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4421', '1011', '591', '1', '2024-01-18 11:47:25', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4422', '1010', '0', '1', '2024-01-18 11:47:47', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4423', '1011', '591', '1', '2024-01-18 11:47:47', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4424', '1010', '0', '1', '2024-01-18 11:48:05', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4425', '1011', '591', '1', '2024-01-18 11:48:05', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4426', '1010', '0', '1', '2024-01-18 11:48:29', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4427', '1011', '591', '1', '2024-01-18 11:48:29', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4428', '1010', '0', '1', '2024-01-18 11:48:53', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4429', '1011', '591', '1', '2024-01-18 11:48:53', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4430', '1010', '0', '1', '2024-01-18 11:49:50', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4431', '1011', '591', '1', '2024-01-18 11:49:50', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4432', '1010', '0', '1', '2024-01-18 11:50:25', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4433', '1011', '591', '1', '2024-01-18 11:50:25', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4434', '1010', '0', '1', '2024-01-18 11:50:50', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4435', '1011', '591', '1', '2024-01-18 11:50:50', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4436', '1010', '0', '1', '2024-01-18 11:51:12', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4437', '1011', '591', '1', '2024-01-18 11:51:12', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4438', '1010', '0', '1', '2024-01-18 11:51:47', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4439', '1011', '591', '1', '2024-01-18 11:51:47', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4440', '1010', '0', '1', '2024-01-19 09:06:28', 'Update Item', '13', '2024-01-18', NULL, '0', '0'),
('4441', '1011', '591', '1', '2024-01-19 09:06:28', 'Update Item Codes', '13', '2024-01-18', NULL, '0', '0'),
('4442', '3040', '0', '1', '2024-01-18 15:28:47', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4443', '32', '1', '1', '2024-01-18 16:56:07', 'Create New Sales Quotation', '13', '2024-01-02', NULL, '0', '0'),
('4444', '3040', '0', '1', '2024-01-18 15:31:00', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4445', '32', '2', '1', '2024-01-18 16:56:08', 'Create New Sales Quotation', '13', '2024-01-02', NULL, '0', '0'),
('4446', '3040', '0', '1', '2024-01-18 15:31:00', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4447', '3040', '0', '1', '2024-01-18 15:31:59', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4448', '32', '3', '1', '2024-01-18 16:56:10', 'Create New Sales Quotation', '13', '2024-01-02', NULL, '0', '0'),
('4449', '3040', '0', '1', '2024-01-18 16:14:34', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4450', '32', '4', '1', '2024-01-18 16:56:12', 'Create New Sales Quotation', '13', '2024-01-03', NULL, '0', '0'),
('4451', '3040', '0', '1', '2024-01-18 16:17:37', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4452', '32', '5', '1', '2024-01-20 10:30:47', 'Create New Sales Quotation', '13', '2024-01-17', NULL, '0', '0'),
('4453', '3040', '0', '1', '2024-01-18 16:19:17', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4454', '32', '6', '1', '2024-01-20 10:30:48', 'Create New Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4455', '3040', '0', '1', '2024-01-18 16:21:01', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4456', '32', '7', '1', '2024-01-20 10:30:50', 'Create New Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4457', '3040', '0', '1', '2024-01-18 16:21:01', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4458', '3040', '0', '1', '2024-01-18 16:24:27', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4459', '32', '8', '1', '2024-01-20 10:30:50', 'Create New Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4460', '3040', '0', '1', '2024-01-18 16:24:27', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4461', '3040', '0', '1', '2024-01-18 16:28:05', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4462', '32', '9', '1', '2024-01-19 10:24:30', 'Create New Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4463', '1001', '252', '1', '2024-01-18 16:26:31', 'Create New Customer', '13', '2024-01-18', '0', '0', '0'),
('4464', '1002', '247', '1', '2024-01-18 16:26:31', 'Create New Branch', '13', '2024-01-18', '0', '0', '0'),
('4465', '3040', '0', '1', '2024-01-18 16:32:58', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4466', '32', '10', '1', '2024-01-19 11:06:51', 'Create New Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4467', '3040', '0', '1', '2024-01-18 16:33:51', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4468', '32', '11', '1', '2024-01-18 16:56:18', 'Create New Sales Quotation', '13', '2024-01-03', NULL, '0', '0'),
('4469', '3040', '0', '1', '2024-01-18 16:34:39', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4470', '32', '12', '1', '2024-01-18 16:56:19', 'Create New Sales Quotation', '13', '2024-01-04', NULL, '0', '0'),
('4471', '3040', '0', '1', '2024-01-18 16:37:19', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4472', '32', '13', '1', '2024-01-18 16:41:47', 'Create New Sales Quotation', '0', '2024-01-06', NULL, '0', '0'),
('4473', '3040', '0', '1', '2024-01-18 16:41:47', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4474', '32', '14', '1', '2024-01-18 16:42:15', 'Create New Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4475', '3040', '0', '1', '2024-01-18 16:44:32', NULL, '0', '0000-00-00', NULL, '0', '0'),
('4476', '32', '13', '1', '2024-01-18 16:41:47', 'Delete Sales Quotation', '0', '0020-00-18', '0', '0', '0'),
('4477', '32', '14', '1', '2024-01-18 16:56:21', 'Update Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4478', '3040', '0', '1', '2024-01-18 16:46:47', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4479', '32', '15', '1', '2024-01-18 16:56:22', 'Create New Sales Quotation', '13', '2024-01-06', NULL, '0', '0'),
('4480', '3040', '0', '1', '2024-01-18 16:48:37', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4481', '32', '16', '1', '2024-01-18 16:56:23', 'Create New Sales Quotation', '13', '2024-01-08', NULL, '0', '0'),
('4482', '3040', '0', '1', '2024-01-18 16:48:37', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4483', '3040', '0', '1', '2024-01-18 16:49:48', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4484', '32', '17', '1', '2024-01-18 16:56:24', 'Create New Sales Quotation', '13', '2024-01-09', NULL, '0', '0'),
('4485', '3040', '0', '1', '2024-01-18 16:51:36', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4486', '32', '18', '1', '2024-01-18 16:56:26', 'Create New Sales Quotation', '13', '2024-01-09', NULL, '0', '0'),
('4487', '3040', '0', '1', '2024-01-18 16:52:34', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4488', '32', '19', '1', '2024-01-18 16:56:27', 'Create New Sales Quotation', '13', '2024-01-09', NULL, '0', '0'),
('4489', '3040', '0', '1', '2024-01-18 16:53:15', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4490', '32', '20', '1', '2024-01-18 16:56:28', 'Create New Sales Quotation', '13', '2024-01-10', NULL, '0', '0'),
('4491', '3040', '0', '1', '2024-01-19 10:18:36', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4492', '32', '21', '1', '2024-01-18 16:56:29', 'Create New Sales Quotation', '13', '2024-01-10', NULL, '0', '0'),
('4493', '32', '1', '1', '2024-01-26 11:55:18', 'Sales Quotation is approved', '13', '2024-01-18', NULL, '0', '0'),
('4494', '32', '2', '1', '2024-01-18 16:56:08', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4495', '32', '3', '1', '2024-01-18 16:56:10', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4496', '32', '4', '1', '2024-01-18 16:56:12', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4497', '32', '11', '1', '2024-01-18 16:56:18', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4498', '32', '12', '1', '2024-01-18 16:56:19', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4499', '32', '14', '1', '2024-01-19 10:45:33', 'Sales Quotation is approved', '13', '2024-01-18', NULL, '0', '0'),
('4500', '32', '15', '1', '2024-01-18 16:56:22', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4501', '32', '16', '1', '2024-01-18 16:56:23', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4502', '32', '17', '1', '2024-01-18 16:56:24', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4503', '32', '18', '1', '2024-01-18 16:56:26', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4504', '32', '19', '1', '2024-01-18 16:56:27', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4505', '32', '20', '1', '2024-01-18 16:56:28', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4506', '32', '21', '1', '2024-01-18 16:56:29', 'Sales Quotation is approved', '13', '2024-01-18', '0', '0', '0'),
('4507', '18', '1', '1', '2024-01-19 09:45:10', 'Create New Purchase Order', '13', '2024-01-12', NULL, '0', '1485'),
('4508', '18', '2', '1', '2024-01-19 09:42:24', 'Create New Purchase Order', '13', '2024-01-12', NULL, '0', '340'),
('4509', '18', '3', '1', '2024-01-19 09:21:36', 'Create New Purchase Order', '13', '2024-01-16', NULL, '0', '284'),
('4510', '40', '1', '1', '2024-01-19 09:51:38', 'Dimension Created', '13', '2024-01-01', NULL, '0', '0'),
('4511', '1010', '0', '1', '2024-01-19 09:07:10', 'Update Item', '13', '2024-01-19', NULL, '0', '0'),
('4512', '1011', '591', '1', '2024-01-19 09:07:11', 'Update Item Codes', '13', '2024-01-19', NULL, '0', '0'),
('4513', '1010', '0', '1', '2024-01-19 09:07:55', 'Update Item', '13', '2024-01-19', NULL, '0', '0'),
('4514', '1011', '591', '1', '2024-01-19 09:07:55', 'Update Item Codes', '13', '2024-01-19', NULL, '0', '0'),
('4515', '1010', '0', '1', '2024-01-19 09:19:51', 'Update Item', '13', '2024-01-19', NULL, '0', '0'),
('4516', '1011', '591', '1', '2024-01-19 09:07:55', 'Update Item Codes', '13', '2024-01-19', '0', '0', '0'),
('4517', '18', '4', '1', '2024-01-24 17:19:33', 'Create New Purchase Order', '13', '2024-01-17', NULL, '0', '566'),
('4518', '1011', '592', '1', '2024-01-19 09:20:18', 'Create Item Codes', '13', '2024-01-19', NULL, '0', '0'),
('4519', '1010', '0', '1', '2024-01-19 09:20:18', 'Create New Item', '13', '2024-01-19', NULL, '0', '0'),
('4520', '1010', '0', '1', '2024-01-19 09:37:01', 'Update Item', '13', '2024-01-19', NULL, '0', '0'),
('4521', '1011', '592', '1', '2024-01-19 09:20:18', 'Update Item Codes', '13', '2024-01-19', '0', '0', '0'),
('4522', '18', '3', '1', '2024-01-19 09:46:28', 'Update Purchase Order', '13', '2024-01-19', NULL, '0', '316'),
('4523', '18', '5', '1', '2024-01-24 17:23:04', 'Create New Purchase Order', '13', '2024-01-17', NULL, '0', '565'),
('4524', '18', '6', '1', '2024-02-08 17:39:33', 'Create New Purchase Order', '13', '2024-01-17', NULL, '0', '872'),
('4525', '1011', '593', '1', '2024-01-19 09:37:01', 'Create Item Codes', '13', '2024-01-19', '0', '0', '0'),
('4526', '1010', '0', '1', '2024-01-22 09:57:23', 'Create New Item', '13', '2024-01-19', NULL, '0', '0'),
('4527', '18', '7', '1', '2024-01-19 11:34:34', 'Create New Purchase Order', '13', '2024-01-18', NULL, '0', '893'),
('4528', '18', '2', '1', '2024-01-19 09:43:38', 'Update Purchase Order', '13', '2024-01-19', NULL, '0', '0'),
('4529', '18', '2', '1', '2024-01-19 09:46:08', 'Update Purchase Order', '13', '2024-01-19', NULL, '0', '340'),
('4530', '18', '1', '1', '2024-02-06 09:17:42', 'Update Purchase Order', '13', '2024-01-19', NULL, '0', '1485'),
('4531', '18', '2', '1', '2024-01-24 17:17:34', 'Update Purchase Order', '13', '2024-01-19', NULL, '0', '340'),
('4532', '18', '3', '1', '2024-01-24 17:18:00', 'Update Purchase Order', '13', '2024-01-19', NULL, '0', '316'),
('4533', '40', '2', '1', '2024-01-19 09:51:49', 'Dimension Created', '13', '2024-01-01', NULL, '0', '0'),
('4534', '40', '1', '1', '2024-01-19 09:51:38', 'Dimension Updated', '13', '2024-01-01', '0', '0', '0'),
('4535', '40', '2', '1', '2024-01-19 09:51:49', 'Dimension Updated', '13', '2024-01-01', '0', '0', '0'),
('4536', '40', '3', '1', '2024-01-19 09:54:02', 'Dimension Created', '13', '2024-01-03', '0', '0', '0'),
('4537', '40', '4', '1', '2024-01-19 09:54:43', 'Dimension Created', '13', '2024-01-05', '0', '0', '0'),
('4538', '18', '8', '26', '2024-01-19 09:55:12', 'Create New Purchase Order', '13', '2024-01-19', '0', '0', '151'),
('4539', '40', '5', '1', '2024-01-19 09:55:47', 'Dimension Created', '13', '2024-01-05', '0', '0', '0'),
('4540', '40', '6', '1', '2024-01-19 10:00:19', 'Dimension Created', '13', '2024-01-09', '0', '0', '0'),
('4541', '40', '7', '1', '2024-01-19 10:00:55', 'Dimension Created', '13', '2024-01-09', '0', '0', '0'),
('4542', '40', '8', '1', '2024-01-19 10:18:36', 'Dimension Created', '13', '2024-01-19', '0', '0', '0'),
('4543', '3040', '0', '1', '2024-01-19 10:19:50', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4544', '30', '1', '1', '2024-01-19 10:18:36', 'Create New Sales Order against Quotation no 1', '13', '2024-01-10', '0', '0', '0'),
('4545', '40', '9', '1', '2024-01-19 10:19:50', 'Dimension Created', '13', '2024-01-19', '0', '0', '0'),
('4546', '3040', '0', '1', '2024-01-19 10:21:57', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4547', '30', '2', '1', '2024-01-19 10:19:50', 'Create New Sales Order against Quotation no 18', '13', '2024-01-11', '0', '0', '0'),
('4548', '40', '10', '1', '2024-01-19 10:21:57', 'Dimension Created', '13', '2024-01-19', '0', '0', '0'),
('4549', '3040', '0', '1', '2024-01-19 10:21:57', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4550', '3040', '0', '1', '2024-01-19 10:26:34', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4551', '30', '3', '1', '2024-01-19 10:21:57', 'Create New Sales Order against Quotation no 17', '13', '2024-01-11', '0', '0', '0'),
('4552', '32', '9', '1', '2024-01-19 10:24:30', 'Sales Quotation is approved', '13', '2024-01-19', '0', '0', '0'),
('4553', '40', '11', '1', '2024-01-19 10:26:34', 'Dimension Created', '13', '2024-01-19', '0', '0', '0'),
('4554', '3040', '0', '1', '2024-01-19 10:26:34', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4555', '3040', '0', '1', '2024-01-19 10:33:34', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4556', '30', '4', '1', '2024-01-19 10:26:34', 'Create New Sales Order against Quotation no 9', '13', '2024-01-19', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('4557', '3040', '0', '1', '2024-01-19 10:33:34', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4558', '3040', '0', '1', '2024-01-19 10:44:10', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4559', '30', '5', '1', '2024-01-19 10:33:34', 'Create New Sales Order against Quotation no 3', '13', '2024-01-03', '0', '0', '0'),
('4560', '40', '12', '1', '2024-01-19 10:47:26', 'Dimension Created', '13', '2024-01-19', NULL, '0', '0'),
('4561', '3040', '0', '1', '2024-01-19 10:55:44', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4562', '30', '6', '1', '2024-01-19 10:59:02', 'Create New Sales Order against Quotation no 14', '13', '2024-01-09', NULL, '0', '0'),
('4563', '32', '14', '1', '2024-01-19 10:54:05', 'Update Sales Quotation', '13', '2024-01-18', NULL, '0', '0'),
('4564', '30', '6', '1', '2024-01-19 10:59:02', 'Update Sales Order', '13', '2024-01-09', NULL, '0', '0'),
('4565', '40', '12', '1', '2024-01-19 10:49:15', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4566', '30', '6', '1', '2024-01-19 10:59:02', 'Update Sales Order', '13', '2024-01-09', NULL, '0', '0'),
('4567', '40', '12', '1', '2024-01-19 10:50:24', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4568', '30', '6', '1', '2024-01-19 10:59:02', 'Update Sales Order', '13', '2024-01-09', NULL, '0', '0'),
('4569', '40', '12', '1', '2024-01-19 10:52:34', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4570', '40', '12', '1', '2024-01-19 10:55:05', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4571', '32', '14', '1', '2024-01-19 10:54:05', 'Update Sales Quotation', '13', '2024-01-18', '0', '0', '0'),
('4572', '40', '12', '1', '2024-01-19 10:56:01', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4573', '3040', '0', '1', '2024-01-19 10:59:02', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4574', '30', '6', '1', '2024-01-19 10:59:02', 'Delete Sales Order', '13', '0020-00-19', NULL, '0', '0'),
('4575', '40', '12', '1', '2024-01-19 10:56:39', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4576', '40', '12', '1', '2024-01-19 10:56:58', 'Dimension Updated', '13', '2024-01-19', NULL, '0', '0'),
('4577', '40', '12', '1', '2024-01-19 10:57:27', 'Dimension Updated', '13', '2024-01-19', NULL, '0', '0'),
('4578', '40', '12', '1', '2024-01-19 11:05:11', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4579', '3040', '0', '1', '2024-01-19 11:18:47', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4580', '30', '6', '1', '2024-01-19 10:59:02', 'Create New Sales Order against Quotation no 14', '13', '2024-01-09', '0', '0', '0'),
('4581', '40', '12', '1', '2024-01-19 11:10:11', 'Dimension Deleted', '13', '2024-01-19', NULL, '0', '0'),
('4582', '32', '10', '1', '2024-01-19 11:06:51', 'Sales Quotation is approved', '13', '2024-01-19', '0', '0', '0'),
('4583', '40', '12', '1', '2024-01-19 11:29:31', 'Dimension Updated', '13', '2024-01-19', NULL, '0', '0'),
('4584', '3040', '0', '1', '2024-01-19 14:12:00', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4585', '30', '7', '1', '2024-01-19 11:18:47', 'Create New Sales Order against Quotation no 10', '13', '2024-01-19', '0', '0', '0'),
('4586', '40', '12', '1', '2024-01-19 11:34:17', 'Dimension Updated', '13', '2024-01-19', NULL, '0', '0'),
('4587', '40', '12', '1', '2024-01-19 11:34:17', 'Dimension Updated', '13', '2024-01-19', '0', '0', '0'),
('4588', '18', '7', '1', '2024-01-19 11:34:34', 'Update Purchase Order', '13', '2024-01-19', '0', '0', '893'),
('4589', '13', '1', '1', '2024-01-19 11:48:27', 'Created', '13', '2024-01-19', NULL, '0', '0'),
('4590', '13', '1', '1', '2024-01-19 11:48:27', 'Create Sales Delivery Note against Sales order no 4', '13', '2024-01-19', NULL, '0', '0'),
('4591', '13', '1', '1', '2024-01-20 08:04:33', 'Create Sales Delivery Note against Sales order no 4', '13', '2024-01-19', NULL, '0', '0'),
('4592', '13', '2', '1', '2024-01-19 11:52:44', 'Created', '13', '2024-01-11', NULL, '0', '0'),
('4593', '13', '2', '1', '2024-01-19 17:02:54', 'Create Sales Delivery Note against Sales order no 2', '13', '2024-01-19', NULL, '0', '0'),
('4594', '13', '3', '1', '2024-01-19 11:53:17', 'Created', '13', '2024-01-11', NULL, '0', '0'),
('4595', '13', '3', '1', '2024-01-19 11:53:17', 'Create Sales Delivery Note against Sales order no 3', '13', '2024-01-19', NULL, '0', '0'),
('4596', '13', '3', '1', '2024-01-19 11:53:17', 'Create Sales Delivery Note against Sales order no 3', '13', '2024-01-19', '0', '0', '0'),
('4597', '3040', '0', '27', '2024-01-20 10:39:39', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4598', '32', '22', '27', '2024-01-20 09:28:54', 'Create New Sales Quotation', '13', '2024-01-19', NULL, '0', '0'),
('4599', '10', '1', '1', '2024-01-19 17:02:28', 'Created', '13', '2024-01-19', NULL, '0', '0'),
('4600', '10', '1', '1', '2024-01-19 17:02:54', 'Create Sales Invoice against Sales Delivery note 2', '13', '2024-01-19', NULL, '0', '0'),
('4601', '10', '1', '1', '2024-01-19 17:02:54', 'Updated.', '13', '2024-01-11', NULL, '0', '0'),
('4602', '10', '1', '1', '2024-01-19 17:02:54', 'Update Sales Delivery Note', '13', '2024-01-19', NULL, '0', '0'),
('4603', '10', '1', '1', '2024-01-19 17:02:54', 'Create Sales Invoice', '13', '2024-01-19', '0', '0', '0'),
('4604', '13', '2', '1', '2024-01-19 17:02:54', 'Updated.', '13', '2024-01-11', NULL, '0', '0'),
('4605', '13', '2', '1', '2024-01-19 17:02:54', 'Update Sales Delivery Note', '13', '2024-01-19', NULL, '0', '0'),
('4606', '13', '2', '1', '2024-01-19 17:02:54', 'Create Sales Delivery Note', '13', '2024-01-19', '0', '0', '0'),
('4607', '10', '2', '1', '2024-01-19 17:04:41', 'Created', '13', '2024-01-11', NULL, '0', '0'),
('4608', '10', '2', '1', '2024-01-19 17:04:41', 'Create Sales Invoice against Sales Delivery note 3', '13', '2024-01-19', NULL, '0', '0'),
('4609', '10', '2', '1', '2024-01-19 17:04:41', 'Create Sales Invoice against Sales Delivery note 3', '13', '2024-01-19', '0', '0', '0'),
('4610', '10', '3', '1', '2024-01-19 17:27:37', 'Created', '13', '2024-01-19', NULL, '0', '0'),
('4611', '10', '3', '1', '2024-01-19 17:27:37', 'Create Sales Invoice against Sales Delivery note 1', '13', '2024-01-19', NULL, '0', '0'),
('4612', '10', '3', '1', '2024-01-20 08:04:33', 'Create Sales Invoice against Sales Delivery note 1', '13', '2024-01-19', NULL, '0', '0'),
('4613', '10', '3', '1', '2024-01-20 08:04:33', 'Updated.', '13', '2024-01-19', NULL, '0', '0'),
('4614', '10', '3', '1', '2024-01-20 08:04:33', 'Update Sales Delivery Note', '13', '2024-01-20', NULL, '0', '0'),
('4615', '10', '3', '1', '2024-01-20 08:04:33', 'Create Sales Invoice', '13', '2024-01-20', NULL, '0', '0'),
('4616', '10', '3', '1', '2024-01-20 08:04:33', 'Update Sales Delivery Note', '13', '2024-01-20', NULL, '0', '0'),
('4617', '10', '3', '1', '2024-01-20 08:04:33', 'Create Sales Invoice', '13', '2024-01-20', '0', '0', '0'),
('4618', '13', '1', '1', '2024-01-20 08:04:33', 'Updated.', '13', '2024-01-19', NULL, '0', '0'),
('4619', '13', '1', '1', '2024-01-20 08:04:33', 'Update Sales Delivery Note', '13', '2024-01-20', NULL, '0', '0'),
('4620', '13', '1', '1', '2024-01-20 08:04:33', 'Create Sales Delivery Note', '13', '2024-01-20', NULL, '0', '0'),
('4621', '13', '1', '1', '2024-01-20 08:04:33', 'Update Sales Delivery Note', '13', '2024-01-20', NULL, '0', '0'),
('4622', '13', '1', '1', '2024-01-20 08:04:33', 'Create Sales Delivery Note', '13', '2024-01-20', '0', '0', '0'),
('4623', '40', '13', '1', '2024-02-06 16:12:01', 'Dimension Created', '12', '2023-12-06', NULL, '0', '0'),
('4624', '40', '14', '1', '2024-01-20 08:11:21', 'Dimension Created', '13', '2024-01-01', '0', '0', '0'),
('4625', '40', '15', '1', '2024-01-20 08:13:57', 'Dimension Created', '12', '2023-12-30', '0', '0', '0'),
('4626', '40', '16', '1', '2024-01-20 08:27:48', 'Dimension Created', '12', '2023-12-21', '0', '0', '0'),
('4627', '40', '17', '1', '2024-01-20 08:29:05', 'Dimension Created', '12', '2023-12-28', '0', '0', '0'),
('4628', '40', '18', '1', '2024-01-24 17:17:30', 'Dimension Created', '12', '2023-12-21', NULL, '0', '0'),
('4629', '32', '22', '22', '2024-01-20 09:28:54', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4630', '18', '9', '27', '2024-02-06 10:27:08', 'Create New Purchase Order', '13', '2024-01-20', NULL, '0', '225'),
('4631', '32', '5', '22', '2024-01-20 10:30:47', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4632', '32', '6', '22', '2024-01-20 10:30:48', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4633', '32', '7', '22', '2024-01-20 10:30:50', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4634', '32', '8', '22', '2024-01-20 10:30:50', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4635', '40', '19', '27', '2024-02-06 10:27:53', 'Dimension Created', '13', '2024-01-20', NULL, '0', '0'),
('4636', '3040', '0', '27', '2024-01-20 10:45:21', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4637', '30', '8', '27', '2024-01-20 10:39:39', 'Create New Sales Order against Quotation no 22', '13', '2024-01-20', '0', '0', '0'),
('4638', '3040', '0', '26', '2024-01-20 10:50:06', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4639', '32', '23', '26', '2024-01-20 10:49:14', 'Create New Sales Quotation', '13', '2024-01-20', NULL, '0', '0'),
('4640', '13', '4', '1', '2024-01-20 10:46:32', 'Created', '13', '2024-01-20', NULL, '0', '0'),
('4641', '13', '4', '1', '2024-01-20 10:46:32', 'Create Sales Delivery Note against Sales order no 7', '13', '2024-01-20', '0', '0', '0'),
('4642', '13', '5', '1', '2024-01-20 10:46:48', 'Created', '13', '2024-01-20', NULL, '0', '0'),
('4643', '13', '5', '1', '2024-01-20 10:46:48', 'Create Sales Delivery Note against Sales order no 8', '13', '2024-01-20', '0', '0', '0'),
('4644', '10', '4', '1', '2024-01-20 10:47:10', 'Created', '13', '2024-01-20', NULL, '0', '0'),
('4645', '10', '4', '1', '2024-01-20 10:47:10', 'Create Sales Invoice against Sales Delivery note 4', '13', '2024-01-20', '0', '0', '0'),
('4646', '10', '5', '1', '2024-01-20 10:47:21', 'Created', '13', '2024-01-20', NULL, '0', '0'),
('4647', '10', '5', '1', '2024-01-20 10:47:21', 'Create Sales Invoice against Sales Delivery note 5', '13', '2024-01-20', '0', '0', '0'),
('4648', '32', '23', '22', '2024-01-20 10:49:14', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4649', '40', '20', '26', '2024-01-20 10:50:06', 'Dimension Created', '13', '2024-01-20', '0', '0', '0'),
('4650', '3040', '0', '26', '2024-01-20 15:46:48', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4651', '30', '9', '26', '2024-01-20 10:50:06', 'Create New Sales Order against Quotation no 23', '13', '2024-01-20', '0', '0', '0'),
('4652', '13', '6', '1', '2024-01-20 10:51:50', 'Created', '13', '2024-01-20', NULL, '0', '0'),
('4653', '13', '6', '1', '2024-01-20 10:51:50', 'Create Sales Delivery Note against Sales order no 9', '13', '2024-01-20', '0', '0', '0'),
('4654', '10', '6', '1', '2024-01-20 10:51:55', 'Created', '13', '2024-01-20', NULL, '0', '0'),
('4655', '10', '6', '1', '2024-01-20 10:51:55', 'Create Sales Invoice against Sales Delivery note 6', '13', '2024-01-20', '0', '0', '0'),
('4656', '18', '10', '27', '2024-02-06 10:29:05', 'Create New Purchase Order', '13', '2024-01-20', NULL, '0', '3490'),
('4657', '3040', '0', '26', '2024-01-22 08:47:02', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4658', '32', '24', '26', '2024-01-20 16:15:08', 'Create New Sales Quotation', '13', '2024-01-20', NULL, '0', '0'),
('4659', '32', '24', '22', '2024-01-20 16:15:08', 'Sales Quotation is approved', '13', '2024-01-20', '0', '0', '0'),
('4660', '3040', '0', '1', '2024-01-22 08:47:02', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4661', '3040', '0', '1', '2024-01-22 08:48:12', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4662', '32', '25', '1', '2024-01-22 08:47:19', 'Create New Sales Quotation', '13', '2024-01-22', NULL, '0', '0'),
('4663', '32', '25', '1', '2024-01-22 08:47:19', 'Sales Quotation is approved', '13', '2024-01-22', '0', '0', '0'),
('4664', '3040', '0', '1', '2024-01-22 08:48:12', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4665', '3040', '0', '1', '2024-01-22 10:47:42', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4666', '30', '10', '1', '2024-01-22 08:48:12', 'Create New Sales Order against Quotation no 25', '13', '2024-01-22', '0', '0', '0'),
('4667', '13', '7', '1', '2024-01-22 08:49:10', 'Created', '13', '2024-01-22', NULL, '0', '0'),
('4668', '13', '7', '1', '2024-01-22 08:49:10', 'Create Sales Delivery Note against Sales order no 10', '13', '2024-01-22', NULL, '0', '0'),
('4669', '13', '7', '1', '2024-01-23 10:46:54', 'Create Sales Delivery Note against Sales order no 10', '13', '2024-01-22', NULL, '0', '0'),
('4670', '10', '7', '1', '2024-01-22 08:50:10', 'Created', '13', '2024-01-22', NULL, '0', '0'),
('4671', '10', '7', '1', '2024-01-22 08:50:10', 'Create Sales Invoice against Sales Delivery note 7', '13', '2024-01-22', NULL, '0', '0'),
('4672', '10', '7', '1', '2024-01-23 10:46:54', 'Create Sales Invoice against Sales Delivery note 7', '13', '2024-01-22', NULL, '0', '0'),
('4673', '1011', '594', '1', '2024-01-22 09:57:23', 'Create Item Codes', '13', '2024-01-22', '0', '0', '0'),
('4674', '1010', '0', '1', '2024-01-24 13:28:12', 'Create New Item', '13', '2024-01-22', NULL, '0', '0'),
('4675', '40', '21', '1', '2024-01-22 10:19:14', 'Dimension Created', '12', '2023-11-17', NULL, '0', '0'),
('4676', '40', '21', '1', '2024-01-22 10:19:14', 'Dimension Updated', '12', '2023-11-17', '0', '0', '0'),
('4677', '18', '11', '26', '2024-01-22 10:59:44', 'Create New Purchase Order', '13', '2024-01-22', NULL, '0', '2310'),
('4678', '40', '22', '27', '2024-01-22 10:47:42', 'Dimension Created', '13', '2024-01-22', '0', '0', '0'),
('4679', '3040', '0', '27', '2024-01-22 10:55:24', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4680', '30', '11', '27', '2024-01-22 10:47:42', 'Create New Sales Order against Quotation no 5', '13', '2024-01-22', '0', '0', '0'),
('4681', '3040', '0', '1', '2024-01-22 10:55:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4682', '3040', '0', '1', '2024-01-22 10:55:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4683', '3040', '0', '1', '2024-01-22 10:55:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4684', '3040', '0', '1', '2024-01-22 10:55:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4685', '3040', '0', '1', '2024-01-22 10:55:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4686', '3040', '0', '1', '2024-01-22 10:55:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4687', '3040', '0', '1', '2024-01-22 11:00:13', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4688', '32', '26', '1', '2024-01-22 10:56:28', 'Create New Sales Quotation', '13', '2023-07-29', NULL, '0', '0'),
('4689', '32', '26', '1', '2024-01-22 10:56:28', 'Sales Quotation is approved', '13', '2024-01-22', '0', '0', '0'),
('4690', '18', '11', '22', '2024-01-22 11:00:17', 'Update Purchase Order', '13', '2024-01-22', NULL, '0', '2310'),
('4691', '3040', '0', '1', '2024-01-22 11:00:13', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4692', '3040', '0', '1', '2024-01-22 11:00:13', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4693', '3040', '0', '1', '2024-01-22 11:10:56', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4694', '32', '27', '1', '2024-01-22 11:08:35', 'Create New Sales Quotation', '12', '2023-12-20', NULL, '0', '0'),
('4695', '18', '11', '22', '2024-01-23 10:57:27', 'Update Purchase Order', '13', '2024-01-22', NULL, '0', '4620'),
('4696', '32', '27', '1', '2024-01-22 11:08:35', 'Sales Quotation is approved', '12', '2024-01-22', NULL, '0', '0'),
('4697', '40', '23', '1', '2024-02-06 11:19:09', 'Dimension Created', '12', '2023-12-21', NULL, '0', '0'),
('4698', '32', '27', '1', '2024-01-22 11:08:35', 'Update Sales Quotation', '12', '2023-12-20', '0', '0', '0'),
('4699', '3040', '0', '1', '2024-01-22 11:10:56', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4700', '3040', '0', '1', '2024-01-22 11:10:56', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4701', '3040', '0', '1', '2024-01-22 11:51:11', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4702', '30', '12', '1', '2024-01-22 11:10:56', 'Create New Sales Order against Quotation no 27', '13', '2024-01-22', '0', '0', '0'),
('4703', '3040', '0', '1', '2024-01-22 11:52:30', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4704', '30', '13', '1', '2024-01-22 11:51:11', 'Create New Sales Order', '13', '2024-01-02', '0', '0', '0'),
('4705', '13', '8', '1', '2024-01-22 11:51:11', 'Created', '13', '2024-01-02', NULL, '0', '0'),
('4706', '13', '8', '1', '2024-01-22 11:51:11', 'Create Sales Delivery Note', '13', '2024-01-22', '0', '0', '0'),
('4707', '10', '8', '1', '2024-01-22 11:51:11', 'Created', '13', '2024-01-02', NULL, '0', '0'),
('4708', '10', '8', '1', '2024-01-22 11:51:11', 'Create Sales Invoice', '13', '2024-01-22', '0', '0', '0'),
('4709', '3040', '0', '1', '2024-01-22 11:53:46', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4710', '30', '14', '1', '2024-01-22 11:52:30', 'Create New Sales Order', '13', '2024-01-04', '0', '0', '0'),
('4711', '13', '9', '1', '2024-01-22 11:52:30', 'Created', '13', '2024-01-04', NULL, '0', '0'),
('4712', '13', '9', '1', '2024-01-22 11:52:30', 'Create Sales Delivery Note', '13', '2024-01-22', '0', '0', '0'),
('4713', '10', '9', '1', '2024-01-22 11:52:30', 'Created', '13', '2024-01-04', NULL, '0', '0'),
('4714', '10', '9', '1', '2024-01-22 11:52:30', 'Create Sales Invoice', '13', '2024-01-22', '0', '0', '0'),
('4715', '3040', '0', '1', '2024-01-22 11:55:04', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4716', '30', '15', '1', '2024-01-22 11:53:46', 'Create New Sales Order', '13', '2024-01-05', '0', '0', '0'),
('4717', '13', '10', '1', '2024-01-22 11:53:46', 'Created', '13', '2024-01-05', NULL, '0', '0'),
('4718', '13', '10', '1', '2024-01-22 11:53:46', 'Create Sales Delivery Note', '13', '2024-01-22', '0', '0', '0'),
('4719', '10', '10', '1', '2024-01-22 11:53:47', 'Created', '13', '2024-01-05', NULL, '0', '0'),
('4720', '10', '10', '1', '2024-01-22 11:53:47', 'Create Sales Invoice', '13', '2024-01-22', '0', '0', '0'),
('4721', '3040', '0', '1', '2024-01-22 11:57:24', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4722', '30', '16', '1', '2024-01-22 11:55:04', 'Create New Sales Order', '13', '2024-01-05', '0', '0', '0'),
('4723', '13', '11', '1', '2024-01-22 11:55:04', 'Created', '13', '2024-01-05', NULL, '0', '0'),
('4724', '13', '11', '1', '2024-01-22 11:55:04', 'Create Sales Delivery Note', '13', '2024-01-22', '0', '0', '0'),
('4725', '10', '11', '1', '2024-01-22 11:55:04', 'Created', '13', '2024-01-05', NULL, '0', '0'),
('4726', '10', '11', '1', '2024-01-22 11:55:04', 'Create Sales Invoice', '13', '2024-01-22', '0', '0', '0'),
('4727', '3040', '0', '1', '2024-01-22 12:01:11', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4728', '30', '17', '1', '2024-01-22 11:57:24', 'Create New Sales Order', '13', '2024-01-09', '0', '0', '0'),
('4729', '13', '12', '1', '2024-01-22 11:57:24', 'Created', '13', '2024-01-09', NULL, '0', '0'),
('4730', '13', '12', '1', '2024-01-22 11:57:24', 'Create Sales Delivery Note', '13', '2024-01-22', '0', '0', '0'),
('4731', '10', '12', '1', '2024-01-22 11:57:24', 'Created', '13', '2024-01-09', NULL, '0', '0'),
('4732', '10', '12', '1', '2024-01-22 11:57:24', 'Create Sales Invoice', '13', '2024-01-22', '0', '0', '0'),
('4733', '40', '24', '1', '2024-01-22 11:59:59', 'Dimension Created', '12', '2023-12-22', '0', '0', '0'),
('4734', '3040', '0', '1', '2024-01-23 08:35:08', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4735', '30', '18', '1', '2024-01-22 12:01:11', 'Create New Sales Order', '13', '2024-01-09', '0', '0', '0'),
('4736', '13', '13', '1', '2024-01-22 12:01:11', 'Created', '13', '2024-01-09', NULL, '0', '0'),
('4737', '13', '13', '1', '2024-01-22 12:01:11', 'Create Sales Delivery Note', '13', '2024-01-22', '0', '0', '0'),
('4738', '10', '13', '1', '2024-01-22 12:01:11', 'Created', '13', '2024-01-09', NULL, '0', '0'),
('4739', '10', '13', '1', '2024-01-22 12:01:11', 'Create Sales Invoice', '13', '2024-01-22', '0', '0', '0'),
('4740', '0', '15', '1', '2024-01-22 12:14:18', 'Voided.\nDocument reentered.', '13', '2024-01-22', '0', '0', '0'),
('4741', '0', '16', '1', '2024-01-30 15:21:52', 'Journal Entry Added', '13', '2023-12-31', NULL, '0', '0'),
('4742', '40', '25', '26', '2024-01-23 08:35:08', 'Dimension Created', '13', '2024-01-23', '0', '0', '0'),
('4743', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4744', '30', '19', '26', '2024-01-23 08:35:08', 'Create New Sales Order against Quotation no 24', '13', '2024-01-23', '0', '0', '0'),
('4745', '13', '14', '1', '2024-01-23 09:51:53', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4746', '13', '14', '1', '2024-01-23 09:51:53', 'Create Sales Delivery Note against Sales order no 19', '13', '2024-01-23', '0', '0', '0'),
('4747', '10', '14', '1', '2024-01-23 09:52:52', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4748', '10', '14', '1', '2024-01-23 09:52:52', 'Create Sales Invoice against Sales Delivery note 14', '13', '2024-01-23', '0', '0', '0'),
('4749', '13', '15', '1', '2024-01-23 10:27:04', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4750', '13', '15', '1', '2024-01-23 10:27:04', 'Create Sales Delivery Note against Sales order no 1', '13', '2024-01-23', '0', '0', '0'),
('4751', '13', '16', '1', '2024-01-23 10:27:13', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4752', '13', '16', '1', '2024-01-23 10:27:13', 'Create Sales Delivery Note against Sales order no 5', '13', '2024-01-23', NULL, '0', '0'),
('4753', '13', '16', '1', '2024-01-23 10:27:13', 'Create Sales Delivery Note against Sales order no 5', '13', '2024-01-23', '0', '0', '0'),
('4754', '13', '17', '1', '2024-01-23 10:27:20', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4755', '13', '17', '1', '2024-01-23 10:33:42', 'Create Sales Delivery Note against Sales order no 6', '13', '2024-01-23', NULL, '0', '0'),
('4756', '13', '18', '1', '2024-01-23 10:27:31', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4757', '13', '18', '1', '2024-01-23 10:27:31', 'Create Sales Delivery Note against Sales order no 11', '13', '2024-01-23', '0', '0', '0'),
('4758', '13', '19', '1', '2024-01-23 10:27:40', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4759', '13', '19', '1', '2024-01-23 10:27:40', 'Create Sales Delivery Note against Sales order no 12', '13', '2024-01-23', NULL, '0', '0'),
('4760', '13', '19', '1', '2024-01-23 10:27:40', 'Create Sales Delivery Note against Sales order no 12', '13', '2024-01-23', NULL, '0', '0'),
('4761', '13', '19', '1', '2024-01-23 10:27:40', 'Create Sales Delivery Note against Sales order no 12', '13', '2024-01-23', '0', '0', '0'),
('4762', '10', '15', '1', '2024-01-23 10:28:04', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4763', '10', '15', '1', '2024-01-23 10:28:04', 'Create Sales Invoice against Sales Delivery note 15', '13', '2024-01-23', '0', '0', '0'),
('4764', '10', '16', '1', '2024-01-23 10:28:12', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4765', '10', '16', '1', '2024-01-23 10:28:12', 'Create Sales Invoice against Sales Delivery note 16', '13', '2024-01-23', NULL, '0', '0'),
('4766', '10', '16', '1', '2024-01-23 10:28:12', 'Create Sales Invoice against Sales Delivery note 16', '13', '2024-01-23', '0', '0', '0'),
('4767', '10', '17', '1', '2024-01-23 10:28:19', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4768', '10', '17', '1', '2024-01-23 10:33:42', 'Create Sales Invoice against Sales Delivery note 17', '13', '2024-01-23', NULL, '0', '0'),
('4769', '10', '18', '1', '2024-01-23 10:28:25', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4770', '10', '18', '1', '2024-01-23 10:28:25', 'Create Sales Invoice against Sales Delivery note 18', '13', '2024-01-23', '0', '0', '0'),
('4771', '10', '19', '1', '2024-01-23 10:28:30', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4772', '10', '19', '1', '2024-01-23 10:28:30', 'Create Sales Invoice against Sales Delivery note 19', '13', '2024-01-23', NULL, '0', '0'),
('4773', '10', '19', '1', '2024-01-23 10:28:30', 'Create Sales Invoice against Sales Delivery note 19', '13', '2024-01-23', NULL, '0', '0'),
('4774', '10', '19', '1', '2024-01-23 10:28:30', 'Create Sales Invoice against Sales Delivery note 19', '13', '2024-01-23', '0', '0', '0'),
('4775', '40', '26', '26', '2024-01-23 10:33:02', 'Dimension Created', '13', '2024-01-23', '0', '0', '0'),
('4776', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4777', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4778', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4779', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4780', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4781', '3040', '0', '26', '2024-01-23 10:33:02', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4782', '3040', '0', '26', '2024-01-23 11:38:17', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4783', '30', '20', '26', '2024-01-23 10:33:02', 'Create New Sales Order against Quotation no 26', '13', '2024-01-23', '0', '0', '0'),
('4784', '10', '17', '1', '2024-01-23 10:33:42', 'Updated.', '13', '2024-01-23', NULL, '0', '0'),
('4785', '10', '17', '1', '2024-01-23 10:33:42', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4786', '10', '17', '1', '2024-01-23 10:33:42', 'Create Sales Invoice', '13', '2024-01-23', '0', '0', '0'),
('4787', '13', '17', '1', '2024-01-23 10:33:42', 'Updated.', '13', '2024-01-23', NULL, '0', '0'),
('4788', '13', '17', '1', '2024-01-23 10:33:42', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4789', '13', '17', '1', '2024-01-23 10:33:42', 'Create Sales Delivery Note', '13', '2024-01-23', '0', '0', '0'),
('4790', '10', '7', '1', '2024-01-23 10:46:54', 'Updated.', '13', '2024-01-22', NULL, '0', '0'),
('4791', '10', '7', '1', '2024-01-23 10:46:54', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4792', '10', '7', '1', '2024-01-23 10:46:54', 'Create Sales Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4793', '10', '7', '1', '2024-01-23 10:46:54', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4794', '10', '7', '1', '2024-01-23 10:47:51', 'Create Sales Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4795', '13', '7', '1', '2024-01-23 10:46:54', 'Updated.', '13', '2024-01-22', NULL, '0', '0'),
('4796', '13', '7', '1', '2024-01-23 10:46:54', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4797', '13', '7', '1', '2024-01-23 10:46:54', 'Create Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4798', '13', '7', '1', '2024-01-23 10:46:54', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4799', '13', '7', '1', '2024-01-23 10:47:51', 'Create Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4800', '18', '12', '27', '2024-01-23 10:47:06', 'Create New Purchase Order', '13', '2024-01-23', '0', '0', '86'),
('4801', '10', '7', '1', '2024-01-23 10:47:51', 'Updated.', '13', '2024-01-22', NULL, '0', '0'),
('4802', '10', '7', '1', '2024-01-23 10:47:51', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4803', '10', '7', '1', '2024-01-23 10:47:51', 'Create Sales Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4804', '10', '7', '1', '2024-01-23 10:47:51', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4805', '10', '7', '1', '2024-01-23 10:47:51', 'Create Sales Invoice', '13', '2024-01-23', '0', '0', '0'),
('4806', '13', '7', '1', '2024-01-23 10:47:51', 'Updated.', '13', '2024-01-22', NULL, '0', '0'),
('4807', '13', '7', '1', '2024-01-23 10:47:51', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4808', '13', '7', '1', '2024-01-23 10:47:51', 'Create Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4809', '13', '7', '1', '2024-01-23 10:47:51', 'Update Sales Delivery Note', '13', '2024-01-23', NULL, '0', '0'),
('4810', '13', '7', '1', '2024-01-23 10:47:51', 'Create Sales Delivery Note', '13', '2024-01-23', '0', '0', '0'),
('4811', '18', '11', '22', '2024-01-23 10:57:27', 'Update Purchase Order', '13', '2024-01-23', '0', '0', '5040'),
('4812', '1001', '253', '1', '2024-01-23 11:09:53', 'Create New Customer', '13', '2024-01-23', '0', '0', '0'),
('4813', '1002', '248', '1', '2024-01-23 11:09:53', 'Create New Branch', '13', '2024-01-23', '0', '0', '0'),
('4814', '1001', '254', '1', '2024-01-23 11:10:44', 'Create New Customer', '13', '2024-01-23', '0', '0', '0'),
('4815', '1002', '249', '1', '2024-01-23 11:10:44', 'Create New Branch', '13', '2024-01-23', '0', '0', '0'),
('4816', '12', '1', '1', '2024-01-23 11:24:05', 'Created', '13', '2024-01-04', '0', '0', '0'),
('4817', '12', '237', '1', '2024-01-23 11:24:05', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4818', '12', '237', '1', '2024-01-23 11:24:05', 'Create Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4819', '12', '2', '1', '2024-01-23 11:24:48', 'Created', '13', '2024-01-12', '0', '0', '0'),
('4820', '12', '225', '1', '2024-01-23 11:24:48', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4821', '12', '225', '1', '2024-01-23 11:24:48', 'Create Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4822', '12', '3', '1', '2024-01-23 11:28:31', 'Created', '13', '2024-01-23', NULL, '0', '0'),
('4823', '12', '111', '1', '2024-01-23 11:26:36', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4824', '12', '111', '1', '2024-01-23 11:28:31', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4825', '12', '4', '1', '2024-01-23 11:27:48', 'Created', '13', '2024-01-17', '0', '0', '0'),
('4826', '12', '218', '1', '2024-01-23 11:27:48', 'Update Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4827', '12', '0', '1', '2024-01-23 11:28:31', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4828', '12', '0', '1', '2024-02-02 15:34:01', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4829', '12', '3', '1', '2024-01-23 11:28:31', 'Updated.', '13', '2024-01-13', '0', '0', '0'),
('4830', '12', '111', '1', '2024-01-23 11:28:31', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4831', '12', '111', '1', '2024-01-23 11:28:31', 'Create Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4832', '12', '5', '1', '2024-01-23 11:29:49', 'Created', '13', '2024-01-17', '0', '0', '0'),
('4833', '12', '134', '1', '2024-01-23 11:29:49', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4834', '12', '134', '1', '2024-01-23 11:30:29', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4835', '12', '6', '1', '2024-01-23 11:30:29', 'Created', '13', '2024-01-18', '0', '0', '0'),
('4836', '12', '134', '1', '2024-01-23 11:30:29', 'Update Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4837', '12', '7', '1', '2024-01-23 11:30:59', 'Created', '13', '2024-01-22', '0', '0', '0'),
('4838', '12', '89', '1', '2024-01-23 11:30:59', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4839', '12', '89', '1', '2024-01-23 11:30:59', 'Create Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4840', '12', '8', '1', '2024-01-23 11:31:26', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4841', '12', '74', '1', '2024-01-23 11:31:26', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4842', '12', '74', '1', '2024-02-01 15:54:57', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4843', '12', '9', '1', '2024-01-23 11:32:31', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4844', '12', '242', '1', '2024-01-23 11:32:31', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4845', '12', '242', '1', '2024-02-01 15:52:20', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4846', '12', '10', '1', '2024-01-23 11:33:05', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4847', '12', '189', '1', '2024-01-23 11:33:05', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4848', '12', '189', '1', '2024-01-23 11:33:05', 'Create Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4849', '12', '11', '1', '2024-01-23 11:34:22', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4850', '12', '136', '1', '2024-01-23 11:34:22', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4851', '12', '136', '1', '2024-02-13 16:57:34', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4852', '12', '12', '1', '2024-01-23 11:35:05', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4853', '12', '240', '1', '2024-01-23 11:35:05', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4854', '12', '240', '1', '2024-02-01 15:56:21', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4855', '3040', '0', '27', '2024-01-23 17:25:54', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4856', '32', '28', '27', '2024-01-23 11:45:59', 'Create New Sales Quotation', '13', '2024-01-23', NULL, '0', '0'),
('4857', '1001', '255', '1', '2024-01-23 11:43:10', 'Create New Customer', '13', '2024-01-23', NULL, '0', '0'),
('4858', '1002', '250', '1', '2024-01-23 11:43:07', 'Create New Branch', '13', '2024-01-23', '0', '0', '0'),
('4859', '1001', '255', '1', '2024-01-23 11:43:10', 'Update Customer', '13', '2024-01-23', '0', '0', '0'),
('4860', '12', '13', '1', '2024-01-23 11:43:37', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4861', '12', '255', '1', '2024-01-23 11:43:37', 'Update Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4862', '12', '14', '1', '2024-01-23 11:44:13', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4863', '12', '22', '1', '2024-01-23 11:44:13', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4864', '12', '22', '1', '2024-02-01 15:56:21', 'Create Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4865', '32', '28', '22', '2024-01-23 11:45:59', 'Sales Quotation is approved', '13', '2024-01-23', '0', '0', '0'),
('4866', '12', '15', '1', '2024-01-23 11:46:06', 'Created', '13', '2024-01-23', '0', '0', '0'),
('4867', '12', '71', '1', '2024-01-23 11:46:06', 'Update Customer Payment', '13', '2024-01-23', NULL, '0', '0'),
('4868', '12', '71', '1', '2024-01-23 11:46:06', 'Create Customer Payment', '13', '2024-01-23', '0', '0', '0'),
('4869', '3040', '0', '26', '2024-01-24 11:09:22', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4870', '32', '29', '26', '2024-01-23 17:28:21', 'Create New Sales Quotation', '13', '2024-01-23', NULL, '0', '0'),
('4871', '32', '29', '22', '2024-01-23 17:28:21', 'Sales Quotation is approved', '13', '2024-01-23', '0', '0', '0'),
('4872', '1009', '33', '1', '2024-01-24 09:36:36', 'Update Supplier', '13', '2024-01-24', NULL, '0', '0'),
('4873', '1009', '33', '1', '2024-01-24 09:36:36', 'Update Supplier', '13', '2024-01-24', '0', '0', '0'),
('4874', '18', '13', '1', '2024-01-24 09:38:17', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '53'),
('4875', '25', '1', '1', '2024-01-24 09:38:17', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4876', '20', '1', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4877', '18', '14', '1', '2024-01-24 09:43:51', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '53'),
('4878', '25', '2', '1', '2024-01-24 09:43:51', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4879', '20', '2', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4880', '18', '15', '1', '2024-01-24 09:44:51', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '53'),
('4881', '25', '3', '1', '2024-01-24 09:44:51', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4882', '20', '3', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4883', '18', '16', '1', '2024-01-24 09:46:22', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '53'),
('4884', '25', '4', '1', '2024-01-24 09:46:22', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4885', '20', '4', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4886', '18', '17', '1', '2024-01-24 09:57:01', 'Create Auto Purchase Order', '13', '2024-01-24', '0', '0', '53'),
('4887', '25', '5', '1', '2024-01-24 09:57:01', 'Auto Suplier Recive Processed', '13', '2024-01-24', '0', '0', '0'),
('4888', '20', '5', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('4889', '18', '18', '1', '2024-01-24 09:57:51', 'Create Auto Purchase Order', '13', '2024-01-24', '0', '0', '53'),
('4890', '25', '6', '1', '2024-01-24 09:57:51', 'Auto Suplier Recive Processed', '13', '2024-01-24', '0', '0', '0'),
('4891', '20', '6', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('4892', '18', '19', '1', '2024-01-24 09:58:45', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '53'),
('4893', '25', '7', '1', '2024-01-24 09:58:45', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4894', '20', '7', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4895', '18', '20', '1', '2024-01-24 09:59:49', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '437'),
('4896', '25', '8', '1', '2024-01-24 09:59:49', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4897', '20', '8', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4898', '18', '21', '1', '2024-01-24 10:01:04', 'Create Auto Purchase Order', '13', '2024-01-23', '0', '0', '331'),
('4899', '25', '9', '1', '2024-01-24 10:01:04', 'Auto Suplier Recive Processed', '13', '2024-01-23', '0', '0', '0'),
('4900', '20', '9', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('4901', '18', '22', '1', '2024-01-24 10:02:13', 'Create Auto Purchase Order', '13', '2024-01-24', '0', '0', '268'),
('4902', '25', '10', '1', '2024-01-24 10:02:13', 'Auto Suplier Recive Processed', '13', '2024-01-24', '0', '0', '0'),
('4903', '20', '10', '1', '2024-01-24 10:13:21', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('4904', '0', '17', '1', '2024-02-15 11:10:10', 'Journal Entry Added', '13', '2024-01-19', NULL, '0', '0'),
('4905', '0', '18', '1', '2024-01-24 10:13:21', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('4906', '20', '1', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4907', '20', '1', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4908', '20', '2', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4909', '20', '2', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4910', '20', '3', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4911', '20', '3', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4912', '20', '4', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4913', '20', '4', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4914', '20', '5', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4915', '20', '5', '1', '2024-01-25 15:06:11', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4916', '20', '6', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4917', '20', '6', '1', '2024-01-25 15:06:28', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4918', '20', '7', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4919', '20', '7', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4920', '20', '8', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4921', '20', '8', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4922', '20', '9', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4923', '20', '9', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4924', '20', '10', '1', '2024-01-24 10:13:21', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4925', '20', '10', '1', '2024-01-25 15:06:36', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4926', '0', '18', '1', '2024-01-25 15:06:11', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4927', '1001', '256', '1', '2024-01-24 10:39:15', 'Create New Customer', '13', '2024-01-24', NULL, '0', '0'),
('4928', '1002', '251', '1', '2024-01-24 10:39:06', 'Create New Branch', '13', '2024-01-24', '0', '0', '0'),
('4929', '1001', '256', '1', '2024-01-24 10:39:55', 'Update Customer', '13', '2024-01-24', NULL, '0', '0'),
('4930', '1001', '256', '1', '2024-01-24 10:39:55', 'Update Customer', '13', '2024-01-24', '0', '0', '0'),
('4931', '1001', '257', '1', '2024-01-24 10:55:52', 'Create New Customer', '13', '2024-01-24', '0', '0', '0'),
('4932', '1002', '252', '1', '2024-01-24 10:55:52', 'Create New Branch', '13', '2024-01-24', '0', '0', '0'),
('4933', '1001', '258', '1', '2024-01-24 11:04:18', 'Create New Customer', '13', '2024-01-24', NULL, '0', '0'),
('4934', '1002', '253', '1', '2024-01-24 11:04:12', 'Create New Branch', '13', '2024-01-24', '0', '0', '0'),
('4935', '1001', '258', '1', '2024-01-31 09:23:00', 'Update Customer', '13', '2024-01-24', NULL, '0', '0'),
('4936', '3040', '0', '27', '2024-01-24 11:10:39', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4937', '32', '30', '27', '2024-01-24 14:20:53', 'Create New Sales Quotation', '13', '2024-01-24', NULL, '0', '0'),
('4938', '3040', '0', '27', '2024-01-24 11:12:56', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4939', '32', '31', '27', '2024-01-24 14:20:53', 'Create New Sales Quotation', '13', '2024-01-24', NULL, '0', '0'),
('4940', '3040', '0', '27', '2024-01-24 11:53:19', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4941', '32', '32', '27', '2024-01-24 14:20:51', 'Create New Sales Quotation', '13', '2024-01-24', NULL, '0', '0'),
('4942', '3040', '0', '27', '2024-01-24 14:13:55', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('4943', '32', '33', '27', '2024-01-24 14:20:35', 'Create New Sales Quotation', '13', '2024-01-24', NULL, '0', '0'),
('4944', '1009', '136', '1', '2024-01-24 13:25:09', 'Add New Supplier', '13', '2024-01-24', '0', '0', '0'),
('4945', '1011', '595', '1', '2024-01-24 13:28:12', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4946', '1010', '0', '1', '2024-01-24 13:28:48', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4947', '1011', '596', '1', '2024-01-24 13:28:48', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4948', '1010', '0', '1', '2024-01-24 13:29:57', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4949', '1011', '597', '1', '2024-01-24 13:29:57', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4950', '1010', '0', '1', '2024-01-24 13:31:03', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4951', '1011', '598', '1', '2024-01-24 13:31:03', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4952', '1010', '0', '1', '2024-01-24 13:34:13', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4953', '1011', '599', '1', '2024-01-24 13:34:13', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4954', '1010', '0', '1', '2024-01-24 14:32:02', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4955', '40', '27', '26', '2024-01-24 14:13:55', 'Dimension Created', '13', '2024-01-24', '0', '0', '0'),
('4956', '3040', '0', '26', '2024-01-24 15:58:07', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4957', '30', '21', '26', '2024-01-24 14:13:55', 'Create New Sales Order against Quotation no 29', '13', '2024-01-24', '0', '0', '0'),
('4958', '32', '33', '22', '2024-01-24 14:20:35', 'Sales Quotation is approved', '13', '2024-01-24', '0', '0', '0'),
('4959', '32', '32', '22', '2024-01-24 14:20:51', 'Sales Quotation is approved', '13', '2024-01-24', '0', '0', '0'),
('4960', '32', '31', '22', '2024-01-24 14:20:53', 'Sales Quotation is approved', '13', '2024-01-24', '0', '0', '0'),
('4961', '32', '30', '22', '2024-01-24 14:20:53', 'Sales Quotation is approved', '13', '2024-01-24', '0', '0', '0'),
('4962', '18', '23', '26', '2024-01-24 14:25:59', 'Create New Purchase Order', '13', '2024-01-24', '0', '0', '445'),
('4963', '1011', '600', '1', '2024-01-24 14:32:02', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4964', '1010', '0', '1', '2024-01-24 14:42:40', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4965', '18', '24', '26', '2024-01-24 14:41:59', 'Create New Purchase Order', '13', '2024-01-24', '0', '0', '1302'),
('4966', '1011', '601', '1', '2024-01-24 14:42:40', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4967', '1010', '0', '1', '2024-01-24 15:16:04', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4968', '18', '25', '26', '2024-01-24 14:47:53', 'Create New Purchase Order', '13', '2024-01-24', '0', '0', '1302'),
('4969', '1009', '120', '1', '2024-02-03 11:51:20', 'Update Supplier', '13', '2024-01-24', NULL, '0', '0'),
('4970', '1011', '602', '1', '2024-01-24 15:16:04', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4971', '1010', '0', '1', '2024-01-24 15:17:03', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4972', '1011', '603', '1', '2024-01-24 15:17:03', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4973', '1010', '0', '1', '2024-01-24 15:17:49', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4974', '1011', '604', '1', '2024-01-24 15:17:49', 'Create Item Codes', '13', '2024-01-24', '0', '0', '0'),
('4975', '1010', '0', '1', '2024-01-25 10:41:35', 'Create New Item', '13', '2024-01-24', NULL, '0', '0'),
('4976', '18', '26', '26', '2024-01-24 15:20:45', 'Create New Purchase Order', '13', '2024-01-24', '0', '0', '507'),
('4977', '18', '27', '1', '2024-01-24 15:30:19', 'Create Auto Purchase Order', '13', '2024-01-24', '0', '0', '516'),
('4978', '25', '11', '1', '2024-01-24 15:30:19', 'Auto Suplier Recive Processed', '13', '2024-01-24', '0', '0', '0'),
('4979', '20', '11', '1', '2024-01-24 15:33:54', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('4980', '0', '19', '1', '2024-01-24 15:33:54', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('4981', '20', '11', '1', '2024-01-24 15:33:54', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4982', '20', '11', '1', '2024-02-27 10:24:46', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4983', '0', '19', '1', '2024-02-15 11:10:44', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4984', '40', '28', '27', '2024-01-24 16:08:59', 'Dimension Created', '13', '2024-01-24', NULL, '0', '0'),
('4985', '3040', '0', '27', '2024-01-24 15:59:11', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4986', '30', '22', '27', '2024-01-24 15:58:07', 'Create New Sales Order against Quotation no 30', '13', '2024-01-24', '0', '0', '0'),
('4987', '40', '29', '27', '2024-01-24 15:59:11', 'Dimension Created', '13', '2024-01-24', '0', '0', '0'),
('4988', '3040', '0', '27', '2024-01-26 11:24:31', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('4989', '30', '23', '27', '2024-01-24 15:59:11', 'Create New Sales Order against Quotation no 32', '13', '2024-01-24', '0', '0', '0'),
('4990', '40', '28', '1', '2024-02-06 16:34:59', 'Dimension Updated', '13', '2024-01-24', NULL, '0', '0'),
('4991', '18', '28', '1', '2024-01-24 16:09:06', 'Create New Purchase Order', '13', '2024-01-24', '0', '0', '373'),
('4992', '18', '29', '1', '2024-01-24 16:12:37', 'Create New Purchase Order', '13', '2024-01-24', '0', '0', '40'),
('4993', '18', '30', '1', '2024-01-24 16:37:49', 'Create Auto Purchase Order', '13', '2024-01-24', '0', '0', '5272'),
('4994', '25', '12', '1', '2024-01-24 16:37:49', 'Auto Suplier Recive Processed', '13', '2024-01-24', '0', '0', '0'),
('4995', '20', '12', '1', '2024-01-24 16:39:57', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('4996', '0', '20', '1', '2024-01-24 16:39:57', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('4997', '20', '12', '1', '2024-01-24 16:39:57', 'Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4998', '20', '12', '1', '2024-02-20 10:49:57', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('4999', '0', '20', '1', '2024-02-15 14:41:19', 'Update Supplier Allocations', '13', '2024-01-24', NULL, '0', '0'),
('5000', '4', '1', '1', '2024-01-24 16:47:18', 'Bank Account Transferred', '13', '2024-01-03', '0', '0', '20000'),
('5001', '4', '2', '1', '2024-01-24 16:47:59', 'Bank Account Transferred', '13', '2024-01-05', '0', '0', '4200'),
('5002', '4', '3', '1', '2024-01-24 16:48:29', 'Bank Account Transferred', '13', '2024-01-10', '0', '0', '20000'),
('5003', '4', '4', '1', '2024-01-24 16:49:17', 'Bank Account Transferred', '13', '2024-01-19', '0', '0', '1200'),
('5004', '4', '5', '1', '2024-01-24 16:50:39', 'Bank Account Transferred', '13', '2024-01-24', '0', '0', '10000'),
('5005', '13', '20', '1', '2024-01-24 17:12:07', 'Created', '13', '2024-01-24', NULL, '0', '0'),
('5006', '13', '20', '1', '2024-01-24 17:12:07', 'Create Sales Delivery Note against Sales order no 21', '13', '2024-01-24', '0', '0', '0'),
('5007', '13', '21', '1', '2024-01-24 17:12:17', 'Created', '13', '2024-01-24', NULL, '0', '0'),
('5008', '13', '21', '1', '2024-01-24 17:13:16', 'Create Sales Delivery Note against Sales order no 22', '13', '2024-01-24', NULL, '0', '0'),
('5009', '10', '20', '1', '2024-01-24 17:12:41', 'Created', '13', '2024-01-24', NULL, '0', '0');
INSERT INTO `0_audit_trail` VALUES
('5010', '10', '20', '1', '2024-01-24 17:12:41', 'Create Sales Invoice against Sales Delivery note 20', '13', '2024-01-24', '0', '0', '0'),
('5011', '10', '21', '1', '2024-01-24 17:12:59', 'Created', '13', '2024-01-24', NULL, '0', '0'),
('5012', '10', '21', '1', '2024-01-24 17:13:16', 'Create Sales Invoice against Sales Delivery note 21', '13', '2024-01-24', NULL, '0', '0'),
('5013', '10', '21', '1', '2024-01-24 17:13:16', 'Updated.', '13', '2024-01-24', NULL, '0', '0'),
('5014', '10', '21', '1', '2024-01-24 17:13:16', 'Update Sales Delivery Note', '13', '2024-01-24', NULL, '0', '0'),
('5015', '10', '21', '1', '2024-01-24 17:13:16', 'Create Sales Invoice', '13', '2024-01-24', '0', '0', '0'),
('5016', '13', '21', '1', '2024-01-24 17:13:16', 'Updated.', '13', '2024-01-24', NULL, '0', '0'),
('5017', '13', '21', '1', '2024-01-24 17:13:16', 'Update Sales Delivery Note', '13', '2024-01-24', NULL, '0', '0'),
('5018', '13', '21', '1', '2024-01-24 17:13:16', 'Create Sales Delivery Note', '13', '2024-01-24', '0', '0', '0'),
('5019', '40', '18', '1', '2024-01-24 17:17:30', 'Dimension Updated', '12', '2023-12-21', '0', '0', '0'),
('5020', '18', '2', '1', '2024-01-24 17:17:34', 'Update Purchase Order', '13', '2024-01-24', '0', '0', '340'),
('5021', '18', '3', '1', '2024-01-24 17:18:00', 'Update Purchase Order', '13', '2024-01-24', '0', '0', '316'),
('5022', '18', '4', '1', '2024-01-24 17:19:33', 'Update Purchase Order', '13', '2024-01-24', '0', '0', '566'),
('5023', '18', '5', '1', '2024-01-24 17:23:04', 'Update Purchase Order', '13', '2024-01-24', '0', '0', '565'),
('5024', '18', '31', '26', '2024-01-25 08:40:44', 'Create New Purchase Order', '13', '2024-01-25', '0', '0', '141'),
('5025', '1011', '605', '1', '2024-01-25 10:41:35', 'Create Item Codes', '13', '2024-01-25', '0', '0', '0'),
('5026', '1010', '0', '1', '2024-01-25 10:42:31', 'Create New Item', '13', '2024-01-25', NULL, '0', '0'),
('5027', '1011', '606', '1', '2024-01-25 10:42:31', 'Create Item Codes', '13', '2024-01-25', '0', '0', '0'),
('5028', '1010', '0', '1', '2024-02-02 10:31:01', 'Create New Item', '13', '2024-01-25', NULL, '0', '0'),
('5029', '18', '32', '27', '2024-01-25 10:49:05', 'Create New Purchase Order', '13', '2024-01-25', '0', '0', '2326'),
('5030', '18', '33', '27', '2024-01-25 12:12:37', 'Create New Purchase Order', '13', '2024-01-25', '0', '0', '306'),
('5031', '18', '34', '27', '2024-01-25 12:15:12', 'Create New Purchase Order', '13', '2024-01-25', '0', '0', '58'),
('5032', '4', '6', '1', '2024-01-25 15:03:24', 'Bank Account Transferred', '13', '2024-01-19', '0', '0', '10000'),
('5033', '20', '5', '1', '2024-01-25 15:06:11', 'Voided.\nDocument reentered.', '13', '2024-01-25', NULL, '0', '0'),
('5034', '20', '13', '1', '2024-01-25 15:06:11', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('5035', '0', '18', '1', '2024-01-25 15:06:11', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5036', '20', '13', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5037', '0', '18', '1', '2024-01-25 15:06:28', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5038', '20', '5', '1', '2024-01-25 15:06:11', 'Update Supplier Allocations', '13', '2024-01-25', '0', '0', '0'),
('5039', '20', '6', '1', '2024-01-25 15:06:28', 'Voided.\nDocument reentered.', '13', '2024-01-25', NULL, '0', '0'),
('5040', '20', '14', '1', '2024-01-25 15:06:28', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('5041', '0', '18', '1', '2024-01-25 15:06:28', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5042', '20', '14', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5043', '0', '18', '1', '2024-01-25 15:06:36', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5044', '20', '6', '1', '2024-01-25 15:06:28', 'Update Supplier Allocations', '13', '2024-01-25', '0', '0', '0'),
('5045', '20', '10', '1', '2024-01-25 15:06:36', 'Voided.\nDocument reentered.', '13', '2024-01-25', NULL, '0', '0'),
('5046', '20', '15', '1', '2024-01-25 15:06:36', 'Create New Supplier Invoice', '13', '2024-01-23', NULL, '0', '0'),
('5047', '0', '18', '1', '2024-01-25 15:06:36', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5048', '20', '15', '1', '2024-01-25 15:08:07', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5049', '0', '18', '1', '2024-01-25 15:08:07', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5050', '20', '10', '1', '2024-01-25 15:06:36', 'Update Supplier Allocations', '13', '2024-01-25', '0', '0', '0'),
('5051', '20', '15', '1', '2024-01-25 15:08:07', 'Voided.\nDocument reentered.', '13', '2024-01-25', NULL, '0', '0'),
('5052', '20', '16', '1', '2024-01-25 15:08:07', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('5053', '0', '18', '1', '2024-01-25 15:08:07', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5054', '20', '16', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5055', '0', '18', '1', '2024-02-15 11:10:25', 'Update Supplier Allocations', '13', '2024-01-25', NULL, '0', '0'),
('5056', '20', '15', '1', '2024-01-25 15:08:07', 'Update Supplier Allocations', '13', '2024-01-25', '0', '0', '0'),
('5057', '1', '2', '1', '2024-02-01 08:09:33', 'Bank Account Updated', '13', '0000-00-00', NULL, '0', '0'),
('5058', '3040', '0', '1', '2024-01-26 11:25:32', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5059', '32', '34', '1', '2024-01-29 13:01:58', 'Create New Sales Quotation', '13', '2024-01-26', NULL, '0', '0'),
('5060', '3040', '0', '1', '2024-01-29 13:01:58', NULL, '0', '0000-00-00', NULL, '0', '0'),
('5061', '32', '34', '1', '2024-01-29 13:01:58', 'Delete Sales Quotation', '13', '0020-00-26', NULL, '0', '0'),
('5062', '32', '1', '25', '2024-01-26 12:00:10', 'Update Sales Quotation', '13', '2024-01-02', NULL, '0', '0'),
('5063', '32', '1', '25', '2024-01-26 12:02:05', 'Update Sales Quotation', '13', '2024-01-02', NULL, '0', '0'),
('5064', '32', '1', '25', '2024-01-26 12:02:05', 'Update Sales Quotation', '13', '2024-01-02', '0', '0', '0'),
('5065', '18', '35', '26', '2024-01-27 11:18:53', 'Create New Purchase Order', '13', '2024-01-27', NULL, '0', '0'),
('5066', '18', '35', '22', '2024-01-27 11:18:53', 'Update Purchase Order', '13', '2024-01-27', '0', '0', '59'),
('5067', '18', '36', '26', '2024-01-27 14:10:07', 'Create New Purchase Order', '13', '2024-01-27', '0', '0', '349'),
('5068', '1', '1', '1', '2024-02-01 08:09:33', 'Bank Payment Processed', '13', '2024-01-27', NULL, '0', '0'),
('5069', '3040', '0', '27', '2024-01-30 09:43:55', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5070', '32', '34', '27', '2024-01-30 10:19:00', 'Create New Sales Quotation', '13', '2024-01-29', NULL, '0', '0'),
('5071', '4', '7', '1', '2024-01-29 17:38:02', 'Bank Account Transferred', '13', '2024-01-10', '0', '0', '20000'),
('5072', '18', '37', '26', '2024-01-30 08:57:29', 'Create New Purchase Order', '13', '2024-01-30', NULL, '0', '0'),
('5073', '18', '37', '22', '2024-01-30 08:57:29', 'Update Purchase Order', '13', '2024-01-30', '0', '0', '746'),
('5074', '18', '38', '26', '2024-01-30 09:10:12', 'Create New Purchase Order', '13', '2024-01-30', '0', '0', '173'),
('5075', '40', '30', '26', '2024-01-30 09:43:55', 'Dimension Created', '13', '2024-01-30', '0', '0', '0'),
('5076', '3040', '0', '26', '2024-01-30 10:18:10', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5077', '30', '24', '26', '2024-01-30 09:43:55', 'Create New Sales Order against Quotation no 21', '13', '2024-01-30', '0', '0', '0'),
('5078', '40', '31', '27', '2024-01-30 10:18:10', 'Dimension Created', '13', '2024-01-30', '0', '0', '0'),
('5079', '3040', '0', '27', '2024-01-30 10:18:59', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5080', '30', '25', '27', '2024-01-30 10:18:10', 'Create New Sales Order against Quotation no 31', '13', '2024-01-30', '0', '0', '0'),
('5081', '40', '32', '27', '2024-01-30 10:18:59', 'Dimension Created', '13', '2024-01-30', '0', '0', '0'),
('5082', '3040', '0', '27', '2024-01-30 10:54:04', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5083', '30', '26', '27', '2024-01-30 10:18:59', 'Create New Sales Order against Quotation no 33', '13', '2024-01-30', '0', '0', '0'),
('5084', '32', '34', '22', '2024-01-30 10:19:00', 'Sales Quotation is approved', '13', '2024-01-30', '0', '0', '0'),
('5085', '13', '22', '1', '2024-01-30 10:20:34', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5086', '13', '22', '1', '2024-01-30 10:20:34', 'Create Sales Delivery Note against Sales order no 26', '13', '2024-01-30', '0', '0', '0'),
('5087', '10', '22', '1', '2024-01-30 10:20:48', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5088', '10', '22', '1', '2024-01-30 10:20:48', 'Create Sales Invoice against Sales Delivery note 22', '13', '2024-01-30', '0', '0', '0'),
('5089', '40', '33', '27', '2024-01-30 10:54:04', 'Dimension Created', '13', '2024-01-30', '0', '0', '0'),
('5090', '3040', '0', '27', '2024-01-30 10:55:07', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5091', '30', '27', '27', '2024-01-30 10:54:04', 'Create New Sales Order against Quotation no 34', '13', '2024-01-30', '0', '0', '0'),
('5092', '40', '34', '26', '2024-01-30 10:55:07', 'Dimension Created', '13', '2024-01-30', '0', '0', '0'),
('5093', '3040', '0', '26', '2024-01-30 16:27:08', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5094', '30', '28', '26', '2024-01-30 10:55:07', 'Create New Sales Order against Quotation no 20', '13', '2024-01-30', '0', '0', '0'),
('5095', '13', '23', '1', '2024-01-30 11:31:18', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5096', '13', '23', '1', '2024-01-30 11:31:18', 'Create Sales Delivery Note against Sales order no 24', '13', '2024-01-30', '0', '0', '0'),
('5097', '10', '23', '1', '2024-01-30 11:31:35', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5098', '10', '23', '1', '2024-01-30 11:31:35', 'Create Sales Invoice against Sales Delivery note 23', '13', '2024-01-30', '0', '0', '0'),
('5099', '13', '24', '1', '2024-01-30 11:53:35', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5100', '13', '24', '1', '2024-01-30 11:53:35', 'Create Sales Delivery Note against Sales order no 28', '13', '2024-01-30', '0', '0', '0'),
('5101', '10', '24', '1', '2024-01-30 11:53:40', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5102', '10', '24', '1', '2024-01-30 11:53:40', 'Create Sales Invoice against Sales Delivery note 24', '13', '2024-01-30', '0', '0', '0'),
('5103', '13', '25', '1', '2024-01-30 11:53:56', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5104', '13', '25', '1', '2024-01-30 11:53:56', 'Create Sales Delivery Note against Sales order no 25', '13', '2024-01-30', '0', '0', '0'),
('5105', '10', '25', '1', '2024-01-30 11:54:00', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5106', '10', '25', '1', '2024-01-30 11:54:00', 'Create Sales Invoice against Sales Delivery note 25', '13', '2024-01-30', '0', '0', '0'),
('5107', '13', '26', '1', '2024-01-30 15:09:28', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5108', '13', '26', '1', '2024-01-30 15:09:28', 'Create Sales Delivery Note against Sales order no 27', '13', '2024-01-30', '0', '0', '0'),
('5109', '10', '26', '1', '2024-01-30 15:10:14', 'Created', '13', '2024-01-30', NULL, '0', '0'),
('5110', '10', '26', '1', '2024-01-30 15:10:14', 'Create Sales Invoice against Sales Delivery note 26', '13', '2024-01-30', '0', '0', '0'),
('5111', '0', '16', '1', '2024-01-30 15:21:52', 'Voided.\nDocument reentered.', '13', '2024-01-30', '0', '0', '0'),
('5112', '0', '21', '1', '2024-01-30 15:21:52', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('5113', '40', '35', '1', '2024-02-03 15:54:04', 'Dimension Created', '12', '2023-09-11', NULL, '0', '0'),
('5114', '3040', '0', '26', '2024-01-30 16:27:08', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5115', '3040', '0', '26', '2024-01-31 09:22:53', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5116', '32', '35', '26', '2024-01-31 09:11:07', 'Create New Sales Quotation', '13', '2024-01-30', NULL, '0', '0'),
('5117', '32', '35', '22', '2024-01-31 09:11:07', 'Sales Quotation is approved', '13', '2024-01-31', '0', '0', '0'),
('5118', '1001', '259', '1', '2024-01-31 09:13:48', 'Create New Customer', '13', '2024-01-31', '0', '0', '0'),
('5119', '1002', '254', '1', '2024-01-31 09:28:46', 'Create New Branch', '13', '2024-01-31', NULL, '0', '0'),
('5120', '3040', '0', '26', '2024-01-31 09:43:11', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5121', '32', '36', '26', '2024-01-31 09:40:34', 'Create New Sales Quotation', '13', '2024-01-31', NULL, '0', '0'),
('5122', '1001', '258', '1', '2024-01-31 09:23:04', 'Update Customer', '13', '2024-01-31', NULL, '0', '0'),
('5123', '1001', '258', '1', '2024-01-31 09:23:04', 'Update Customer', '13', '2024-01-31', '0', '0', '0'),
('5124', '1002', '254', '1', '2024-01-31 09:28:46', 'Update Branch', '13', '2024-01-31', '0', '0', '0'),
('5125', '32', '36', '22', '2024-01-31 09:40:34', 'Sales Quotation is approved', '13', '2024-01-31', '0', '0', '0'),
('5126', '3040', '0', '27', '2024-02-01 12:23:38', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5127', '32', '37', '27', '2024-01-31 12:13:23', 'Create New Sales Quotation', '13', '2024-01-31', NULL, '0', '0'),
('5128', '32', '37', '22', '2024-01-31 12:13:23', 'Sales Quotation is approved', '13', '2024-01-31', '0', '0', '0'),
('5129', '1', '2', '1', '2024-02-20 10:09:13', 'Bank Payment Processed', '13', '2024-01-27', NULL, '0', '0'),
('5130', '1', '0', '1', '2024-02-20 10:09:13', 'Update Bank Payment', '13', '2024-02-01', NULL, '0', '0'),
('5131', '1', '1', '1', '2024-02-01 08:09:33', 'Voided.\nDocument reentered.', '13', '2024-02-01', '0', '0', '0'),
('5132', '18', '39', '26', '2024-02-01 09:58:46', 'Create New Purchase Order', '13', '2024-02-01', '0', '0', '373'),
('5133', '0', '22', '1', '2024-02-15 14:42:07', 'Journal Entry Added', '13', '2024-01-31', NULL, '0', '0'),
('5134', '18', '40', '26', '2024-02-01 12:03:26', 'Create New Purchase Order', '13', '2024-02-01', NULL, '0', '132'),
('5135', '40', '36', '1', '2024-02-01 11:50:07', 'Dimension Created', '12', '2023-12-13', '0', '0', '0'),
('5136', '40', '37', '1', '2024-02-06 09:17:32', 'Dimension Created', '12', '2023-12-21', NULL, '0', '0'),
('5137', '18', '40', '22', '2024-02-01 12:03:26', 'Update Purchase Order', '13', '2024-02-01', '0', '0', '132'),
('5138', '3040', '0', '26', '2024-02-01 12:23:38', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5139', '3040', '0', '26', '2024-02-01 12:23:38', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5140', '3040', '0', '26', '2024-02-01 12:23:38', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5141', '3040', '0', '26', '2024-02-01 13:38:01', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5142', '32', '38', '26', '2024-02-01 12:28:00', 'Create New Sales Quotation', '13', '2024-02-01', NULL, '0', '0'),
('5143', '32', '38', '22', '2024-02-01 12:28:00', 'Sales Quotation is approved', '13', '2024-02-01', '0', '0', '0'),
('5144', '40', '38', '26', '2024-02-01 13:38:01', 'Dimension Created', '13', '2024-02-01', '0', '0', '0'),
('5145', '3040', '0', '26', '2024-02-01 13:38:01', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5146', '3040', '0', '26', '2024-02-01 13:38:01', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5147', '3040', '0', '26', '2024-02-01 13:38:01', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5148', '3040', '0', '26', '2024-02-02 11:29:59', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5149', '30', '29', '26', '2024-02-01 13:38:01', 'Create New Sales Order against Quotation no 38', '13', '2024-02-01', '0', '0', '0'),
('5150', '1001', '260', '1', '2024-02-01 15:23:04', 'Create New Customer', '13', '2024-02-01', '0', '0', '0'),
('5151', '1002', '255', '1', '2024-02-01 15:23:04', 'Create New Branch', '13', '2024-02-01', '0', '0', '0'),
('5152', '12', '16', '1', '2024-02-01 15:51:21', 'Created', '13', '2024-01-23', '0', '0', '0'),
('5153', '12', '246', '1', '2024-02-01 15:51:21', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5154', '12', '246', '1', '2024-02-01 15:51:21', 'Create Customer Payment', '13', '2024-02-01', '0', '0', '0'),
('5155', '12', '17', '1', '2024-02-01 15:51:52', 'Created', '13', '2024-01-23', '0', '0', '0'),
('5156', '12', '213', '1', '2024-02-01 15:51:52', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5157', '12', '213', '1', '2024-02-01 15:51:52', 'Create Customer Payment', '13', '2024-02-01', '0', '0', '0'),
('5158', '12', '18', '1', '2024-02-01 15:52:20', 'Created', '13', '2024-01-23', '0', '0', '0'),
('5159', '12', '242', '1', '2024-02-01 15:52:20', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5160', '12', '242', '1', '2024-02-01 15:52:20', 'Create Customer Payment', '13', '2024-02-01', '0', '0', '0'),
('5161', '12', '19', '1', '2024-02-01 15:52:48', 'Created', '13', '2024-01-24', '0', '0', '0'),
('5162', '12', '75', '1', '2024-02-01 15:52:48', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5163', '12', '75', '1', '2024-02-01 15:52:48', 'Create Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5164', '12', '75', '1', '2024-02-01 15:52:48', 'Create Customer Payment', '13', '2024-02-01', '0', '0', '0'),
('5165', '12', '20', '1', '2024-02-01 15:53:49', 'Created', '13', '2024-01-24', '0', '0', '0'),
('5166', '12', '32', '1', '2024-02-01 15:53:49', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5167', '12', '32', '1', '2024-02-13 15:58:42', 'Create Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5168', '12', '21', '1', '2024-02-01 15:54:57', 'Created', '13', '2024-01-31', '0', '0', '0'),
('5169', '12', '74', '1', '2024-02-01 15:54:57', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5170', '12', '74', '1', '2024-02-01 15:54:57', 'Create Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5171', '12', '74', '1', '2024-02-13 15:58:42', 'Create Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5172', '12', '22', '1', '2024-02-01 15:56:21', 'Created', '13', '2024-02-01', '0', '0', '0'),
('5173', '12', '240', '1', '2024-02-20 09:42:37', 'Update Customer Payment', '13', '2024-02-01', NULL, '0', '0'),
('5174', '4', '8', '1', '2024-02-01 17:20:54', 'Bank Account Transferred', '13', '2024-02-01', '0', '0', '10000'),
('5175', '4', '9', '1', '2024-02-01 17:33:16', 'Bank Account Transferred', '13', '2024-02-01', '0', '0', '10000'),
('5176', '18', '41', '26', '2024-02-02 09:08:26', 'Create New Purchase Order', '13', '2024-02-02', '0', '0', '1838'),
('5177', '1011', '607', '1', '2024-02-02 14:58:04', 'Create Item Codes', '13', '2024-02-02', NULL, '0', '0'),
('5178', '1010', '0', '1', '2024-02-02 14:58:04', 'Create New Item', '13', '2024-02-02', NULL, '0', '0'),
('5179', '18', '42', '26', '2024-02-02 10:58:24', 'Create New Purchase Order', '13', '2024-02-02', '0', '0', '32'),
('5180', '1001', '261', '1', '2024-02-02 11:16:21', 'Create New Customer', '13', '2024-02-02', '0', '0', '0'),
('5181', '1002', '256', '1', '2024-02-02 11:16:21', 'Create New Branch', '13', '2024-02-02', '0', '0', '0'),
('5182', '3040', '0', '26', '2024-02-02 11:29:59', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5183', '3040', '0', '26', '2024-02-02 11:29:59', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5184', '3040', '0', '26', '2024-02-02 11:29:59', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5185', '3040', '0', '26', '2024-02-02 11:29:59', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5186', '3040', '0', '26', '2024-02-02 14:56:35', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5187', '32', '39', '26', '2024-02-02 11:42:40', 'Create New Sales Quotation', '13', '2024-02-02', NULL, '0', '0'),
('5188', '32', '39', '22', '2024-02-02 11:44:34', 'Update Sales Quotation', '13', '2024-02-02', NULL, '0', '0'),
('5189', '32', '39', '22', '2024-02-02 15:00:25', 'Update Sales Quotation', '13', '2024-02-02', NULL, '0', '0'),
('5190', '1001', '262', '1', '2024-02-02 11:55:47', 'Create New Customer', '13', '2024-02-02', NULL, '0', '0'),
('5191', '1002', '257', '1', '2024-02-02 11:55:35', 'Create New Branch', '13', '2024-02-02', '0', '0', '0'),
('5192', '1001', '262', '1', '2024-02-02 11:55:47', 'Update Customer', '13', '2024-02-02', '0', '0', '0'),
('5193', '18', '43', '26', '2024-03-01 11:33:02', 'Create New Purchase Order', '13', '2024-02-02', NULL, '0', '32'),
('5194', '3040', '0', '26', '2024-02-02 14:56:35', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5195', '3040', '0', '26', '2024-02-02 14:56:35', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5196', '3040', '0', '26', '2024-02-02 14:56:35', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5197', '3040', '0', '26', '2024-02-03 11:51:15', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5198', '32', '40', '26', '2024-02-02 15:11:23', 'Create New Sales Quotation', '13', '2024-02-02', NULL, '0', '0'),
('5199', '1010', '0', '1', '2024-02-02 14:59:56', 'Update Item', '13', '2024-02-02', NULL, '0', '0'),
('5200', '1011', '607', '1', '2024-02-02 14:58:04', 'Update Item Codes', '13', '2024-02-02', '0', '0', '0'),
('5201', '1011', '608', '1', '2024-02-02 14:59:56', 'Create Item Codes', '13', '2024-02-02', '0', '0', '0'),
('5202', '1010', '0', '1', '2024-02-02 15:00:14', 'Create New Item', '13', '2024-02-02', NULL, '0', '0'),
('5203', '1011', '609', '1', '2024-02-02 15:00:14', 'Create Item Codes', '13', '2024-02-02', '0', '0', '0'),
('5204', '1010', '0', '1', '2024-02-02 15:00:54', 'Create New Item', '13', '2024-02-02', NULL, '0', '0'),
('5205', '32', '39', '22', '2024-02-02 15:00:54', 'Update Sales Quotation', '13', '2024-02-02', NULL, '0', '0'),
('5206', '32', '39', '22', '2024-02-12 18:44:06', 'Sales Quotation is approved', '13', '2024-02-02', NULL, '0', '0'),
('5207', '1011', '610', '1', '2024-02-02 15:03:31', 'Create Item Codes', '13', '2024-02-02', NULL, '0', '0'),
('5208', '1010', '0', '1', '2024-02-02 15:01:26', 'Create New Item', '13', '2024-02-02', NULL, '0', '0'),
('5209', '1011', '611', '1', '2024-02-02 15:01:26', 'Create Item Codes', '13', '2024-02-02', '0', '0', '0'),
('5210', '1010', '0', '1', '2024-02-02 15:03:02', 'Create New Item', '13', '2024-02-02', NULL, '0', '0'),
('5211', '1010', '0', '1', '2024-02-02 15:03:31', 'Delete Item', '13', '2024-02-02', NULL, '0', '0'),
('5212', '1010', '0', '1', '2024-02-05 11:01:49', 'Update Item', '13', '2024-02-02', NULL, '0', '0'),
('5213', '1011', '610', '1', '2024-02-02 15:03:31', 'Update Item Codes', '13', '2024-02-02', '0', '0', '0'),
('5214', '32', '40', '22', '2024-02-02 15:11:23', 'Sales Quotation is approved', '13', '2024-02-02', '0', '0', '0'),
('5215', '12', '23', '1', '2024-02-02 15:34:01', 'Created', '13', '2024-02-02', NULL, '0', '0'),
('5216', '12', '244', '1', '2024-02-02 15:28:17', 'Update Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5217', '12', '244', '1', '2024-02-02 15:34:01', 'Create Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5218', '18', '44', '26', '2024-02-02 15:30:36', 'Create New Purchase Order', '13', '2024-02-02', '0', '0', '16'),
('5219', '4', '10', '1', '2024-02-02 15:32:26', 'Bank Account Transferred', '13', '2024-02-02', '0', '0', '250'),
('5220', '12', '0', '1', '2024-02-02 15:34:01', 'Update Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5221', '12', '0', '1', '2024-02-03 11:58:31', 'Update Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5222', '12', '23', '1', '2024-02-03 11:58:31', 'Updated.', '13', '2024-02-02', NULL, '0', '0'),
('5223', '12', '244', '1', '2024-02-02 15:34:01', 'Update Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5224', '12', '244', '1', '2024-02-03 11:58:31', 'Create Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5225', '12', '24', '1', '2024-02-02 15:35:43', 'Created', '13', '2024-02-02', '0', '0', '0'),
('5226', '12', '105', '1', '2024-02-02 15:35:43', 'Update Customer Payment', '13', '2024-02-02', NULL, '0', '0'),
('5227', '12', '105', '1', '2024-02-02 15:35:43', 'Create Customer Payment', '13', '2024-02-02', '0', '0', '0'),
('5228', '18', '45', '26', '2024-02-03 08:26:53', 'Create New Purchase Order', '13', '2024-02-03', '0', '0', '735'),
('5229', '1009', '35', '1', '2024-02-03 11:34:13', 'Update Supplier', '13', '2024-02-03', '0', '0', '0'),
('5230', '1028', '2022', '1', '2024-02-06 16:32:21', 'Account Data Updated', '13', '2024-02-03', NULL, '0', '0'),
('5231', '1028', '5080', '1', '2024-02-03 11:44:45', 'Account Data Added', '13', '2024-02-03', NULL, '0', '0'),
('5232', '1028', '5080', '1', '2024-02-03 11:44:45', 'Account Data Updated', '13', '2024-02-03', '0', '0', '0'),
('5233', '1009', '130', '1', '2024-02-03 11:51:06', 'Update Supplier', '13', '2024-02-03', NULL, '0', '0'),
('5234', '1009', '130', '1', '2024-02-03 11:51:06', 'Update Supplier', '13', '2024-02-03', '0', '0', '0'),
('5235', '3040', '0', '26', '2024-02-03 12:39:57', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5236', '32', '41', '26', '2024-02-03 11:55:53', 'Create New Sales Quotation', '13', '2024-02-03', NULL, '0', '0'),
('5237', '1009', '120', '1', '2024-02-03 11:51:20', 'Update Supplier', '13', '2024-02-03', '0', '0', '0'),
('5238', '32', '41', '22', '2024-02-03 11:55:53', 'Sales Quotation is approved', '13', '2024-02-03', '0', '0', '0'),
('5239', '12', '0', '1', '2024-02-03 11:58:31', 'Update Customer Payment', '13', '2024-02-03', NULL, '0', '0'),
('5240', '12', '0', '1', '2024-02-07 10:26:18', 'Update Customer Payment', '13', '2024-02-03', NULL, '0', '0'),
('5241', '12', '23', '1', '2024-02-03 11:58:31', 'Updated.', '13', '2024-02-02', '0', '0', '0'),
('5242', '12', '244', '1', '2024-02-03 11:58:31', 'Update Customer Payment', '13', '2024-02-03', NULL, '0', '0'),
('5243', '12', '244', '1', '2024-02-03 11:58:31', 'Create Customer Payment', '13', '2024-02-03', '0', '0', '0'),
('5244', '3040', '0', '27', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5245', '32', '42', '27', '2024-02-03 12:41:46', 'Create New Sales Quotation', '13', '2024-02-03', NULL, '0', '0'),
('5246', '32', '42', '22', '2024-02-03 12:41:46', 'Sales Quotation is approved', '13', '2024-02-03', '0', '0', '0'),
('5247', '40', '35', '1', '2024-02-03 15:54:04', 'Dimension Updated', '12', '2024-01-01', NULL, '0', '0'),
('5248', '40', '35', '1', '2024-02-03 15:54:04', 'Dimension Updated', '12', '2023-09-11', '0', '0', '0'),
('5249', '1011', '612', '1', '2024-02-05 11:02:18', 'Create Item Codes', '13', '2024-02-05', NULL, '0', '0'),
('5250', '1010', '0', '1', '2024-02-05 11:02:18', 'Create New Item', '13', '2024-02-05', NULL, '0', '0'),
('5251', '1010', '0', '1', '2024-02-05 12:13:06', 'Update Item', '13', '2024-02-05', NULL, '0', '0'),
('5252', '1011', '612', '1', '2024-02-05 11:02:18', 'Update Item Codes', '13', '2024-02-05', '0', '0', '0'),
('5253', '1011', '613', '22', '2024-02-05 12:13:06', 'Create Item Codes', '13', '2024-02-05', '0', '0', '0'),
('5254', '1010', '0', '22', '2024-02-05 12:29:41', 'Create New Item', '13', '2024-02-05', NULL, '0', '0'),
('5255', '18', '46', '22', '2024-02-05 12:25:30', 'Create New Purchase Order', '13', '2024-02-05', '0', '0', '49'),
('5256', '1011', '614', '22', '2024-02-05 12:33:35', 'Create Item Codes', '13', '2024-02-05', NULL, '0', '0'),
('5257', '1010', '0', '22', '2024-02-05 12:33:35', 'Create New Item', '13', '2024-02-05', NULL, '0', '0'),
('5258', '1010', '0', '22', '2024-02-06 09:55:56', 'Update Item', '13', '2024-02-05', NULL, '0', '0'),
('5259', '1011', '614', '22', '2024-02-05 12:33:35', 'Update Item Codes', '13', '2024-02-05', '0', '0', '0'),
('5260', '18', '47', '22', '2024-02-05 12:34:40', 'Create New Purchase Order', '13', '2024-02-05', '0', '0', '184'),
('5261', '1001', '263', '1', '2024-02-05 16:17:55', 'Create New Customer', '13', '2024-02-05', '0', '0', '0'),
('5262', '1002', '258', '1', '2024-02-05 16:17:55', 'Create New Branch', '13', '2024-02-05', '0', '0', '0'),
('5263', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5264', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5265', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5266', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5267', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5268', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5269', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5270', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5271', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5272', '3040', '0', '26', '2024-02-05 16:45:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5273', '3040', '0', '26', '2024-02-05 17:30:05', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5274', '32', '43', '26', '2024-02-05 16:52:34', 'Create New Sales Quotation', '13', '2024-02-05', NULL, '0', '0'),
('5275', '32', '43', '22', '2024-02-05 16:52:34', 'Sales Quotation is approved', '13', '2024-02-05', '0', '0', '0'),
('5276', '1001', '264', '1', '2024-02-05 17:25:35', 'Create New Customer', '13', '2024-02-05', '0', '0', '0'),
('5277', '1002', '259', '1', '2024-02-05 17:25:35', 'Create New Branch', '13', '2024-02-05', '0', '0', '0'),
('5278', '3040', '0', '26', '2024-02-05 17:30:05', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5279', '3040', '0', '26', '2024-02-06 11:21:01', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5280', '32', '44', '26', '2024-02-05 17:32:23', 'Create New Sales Quotation', '13', '2024-02-05', NULL, '0', '0'),
('5281', '32', '44', '22', '2024-02-05 17:32:23', 'Sales Quotation is approved', '13', '2024-02-05', '0', '0', '0'),
('5282', '18', '48', '26', '2024-02-06 08:59:32', 'Create New Purchase Order', '13', '2024-02-06', '0', '0', '375'),
('5283', '40', '37', '1', '2024-02-06 09:17:32', 'Dimension Updated', '12', '2023-12-21', '0', '0', '0'),
('5284', '18', '1', '1', '2024-02-06 09:17:42', 'Update Purchase Order', '13', '2024-02-06', '0', '0', '1485'),
('5285', '1011', '615', '1', '2024-02-06 10:06:16', 'Create Item Codes', '13', '2024-02-06', NULL, '0', '0'),
('5286', '1010', '0', '1', '2024-02-06 10:06:16', 'Create New Item', '13', '2024-02-06', NULL, '0', '0'),
('5287', '18', '49', '1', '2024-02-06 10:00:58', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '563'),
('5288', '25', '13', '1', '2024-02-06 10:00:58', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5289', '20', '17', '1', '2024-02-22 16:24:26', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5290', '18', '50', '1', '2024-02-06 10:05:54', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '505'),
('5291', '25', '14', '1', '2024-02-06 10:05:54', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5292', '20', '18', '1', '2024-02-17 10:10:27', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5293', '1010', '0', '1', '2024-02-06 15:10:26', 'Update Item', '13', '2024-02-06', NULL, '0', '0'),
('5294', '1011', '615', '1', '2024-02-06 15:10:26', 'Update Item Codes', '13', '2024-02-06', NULL, '0', '0'),
('5295', '18', '51', '1', '2024-02-06 10:07:34', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '173'),
('5296', '25', '15', '1', '2024-02-06 10:07:34', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5297', '20', '19', '1', '2024-02-17 12:01:01', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5298', '18', '52', '1', '2024-02-06 10:08:40', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '92'),
('5299', '25', '16', '1', '2024-02-06 10:08:40', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5300', '20', '20', '1', '2024-02-22 16:26:01', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5301', '18', '53', '1', '2024-02-06 10:10:00', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '124'),
('5302', '25', '17', '1', '2024-02-06 10:10:00', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5303', '20', '21', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5304', '18', '54', '1', '2024-02-06 10:14:57', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '1045'),
('5305', '25', '18', '1', '2024-02-06 10:14:57', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5306', '20', '22', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5307', '18', '55', '1', '2024-02-06 10:16:10', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '232'),
('5308', '25', '19', '1', '2024-02-06 10:16:10', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5309', '20', '23', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5310', '18', '56', '1', '2024-02-06 10:16:57', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '34'),
('5311', '25', '20', '1', '2024-02-06 10:16:57', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5312', '20', '24', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5313', '18', '57', '1', '2024-02-06 10:20:29', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '2019'),
('5314', '25', '21', '1', '2024-02-06 10:20:29', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5315', '20', '25', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5316', '18', '58', '1', '2024-02-06 10:21:15', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '375'),
('5317', '25', '22', '1', '2024-02-06 10:21:15', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5318', '20', '26', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5319', '18', '59', '1', '2024-02-06 10:22:19', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '46'),
('5320', '25', '23', '1', '2024-02-06 10:22:19', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5321', '20', '27', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5322', '18', '60', '1', '2024-02-06 10:25:15', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '42'),
('5323', '25', '24', '1', '2024-02-06 10:25:15', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5324', '20', '28', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5325', '18', '9', '1', '2024-02-06 10:27:08', 'Update Purchase Order', '13', '2024-02-06', '0', '0', '225'),
('5326', '40', '19', '1', '2024-02-06 10:28:15', 'Dimension Updated', '13', '2024-01-20', NULL, '0', '0'),
('5327', '40', '19', '1', '2024-02-06 10:28:38', 'Dimension Updated', '13', '2024-01-20', NULL, '0', '0'),
('5328', '40', '19', '1', '2024-02-06 10:28:57', 'Dimension Updated', '13', '2024-01-20', NULL, '0', '0'),
('5329', '40', '19', '1', '2024-02-06 10:29:33', 'Dimension Updated', '13', '2024-01-20', NULL, '0', '0'),
('5330', '18', '10', '1', '2024-02-06 10:30:18', 'Update Purchase Order', '13', '2024-02-06', NULL, '0', '3490'),
('5331', '40', '19', '1', '2024-02-06 10:30:10', 'Dimension Updated', '13', '2024-01-20', NULL, '0', '0'),
('5332', '40', '19', '1', '2024-02-06 10:42:14', 'Dimension Updated', '13', '2024-01-20', NULL, '0', '0'),
('5333', '18', '10', '1', '2024-02-06 11:19:58', 'Update Purchase Order', '13', '2024-02-06', NULL, '0', '3490'),
('5334', '40', '19', '1', '2024-02-06 10:42:14', 'Dimension Updated', '13', '2024-01-20', '0', '0', '0'),
('5335', '25', '25', '1', '2024-02-06 10:43:33', 'Suplier Recive against Purchase order 1.', '13', '2024-01-31', '0', '0', '0'),
('5336', '25', '26', '1', '2024-02-06 10:45:48', 'Suplier Recive against Purchase order 2.', '13', '2024-01-31', '0', '0', '0'),
('5337', '25', '27', '1', '2024-02-06 10:46:11', 'Suplier Recive against Purchase order 3.', '13', '2024-02-06', '0', '0', '0'),
('5338', '25', '28', '1', '2024-02-06 10:46:31', 'Suplier Recive against Purchase order 3.', '13', '2024-01-31', '0', '0', '0'),
('5339', '25', '29', '1', '2024-02-06 10:46:51', 'Suplier Recive against Purchase order 5.', '13', '2024-01-31', '0', '0', '0'),
('5340', '25', '30', '1', '2024-02-06 10:47:23', 'Suplier Recive against Purchase order 9.', '13', '2024-01-31', '0', '0', '0'),
('5341', '25', '31', '1', '2024-02-06 10:47:44', 'Suplier Recive against Purchase order 12.', '13', '2024-01-31', '0', '0', '0'),
('5342', '25', '32', '1', '2024-02-06 10:47:57', 'Suplier Recive against Purchase order 29.', '13', '2024-01-31', '0', '0', '0'),
('5343', '25', '33', '1', '2024-02-06 10:48:09', 'Suplier Recive against Purchase order 31.', '13', '2024-01-31', '0', '0', '0'),
('5344', '25', '34', '1', '2024-02-06 10:48:53', 'Suplier Recive against Purchase order 33.', '13', '2024-01-31', '0', '0', '0'),
('5345', '25', '35', '1', '2024-02-06 10:49:08', 'Suplier Recive against Purchase order 34.', '13', '2024-01-31', '0', '0', '0'),
('5346', '25', '36', '1', '2024-02-06 10:49:25', 'Suplier Recive against Purchase order 35.', '13', '2024-01-31', '0', '0', '0'),
('5347', '25', '37', '1', '2024-02-06 10:49:43', 'Suplier Recive against Purchase order 36.', '13', '2024-01-31', '0', '0', '0'),
('5348', '20', '29', '1', '2024-02-06 11:00:43', 'Create Supplier Invoice against receival 1.', '13', '2024-02-06', NULL, '0', '0'),
('5349', '20', '29', '1', '2024-02-21 10:08:34', 'Voided.\nDocument reentered.', '13', '2024-02-06', NULL, '0', '0'),
('5350', '20', '30', '1', '2024-02-06 12:44:36', 'Create New Supplier Invoice', '13', '2024-02-06', NULL, '0', '0'),
('5351', '20', '31', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5352', '40', '23', '1', '2024-02-06 11:19:09', 'Dimension Updated', '12', '2023-12-21', '0', '0', '0'),
('5353', '18', '10', '1', '2024-02-06 11:19:58', 'Update Purchase Order', '13', '2024-02-06', '0', '0', '3490'),
('5354', '3040', '0', '26', '2024-02-06 16:00:49', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5355', '32', '45', '26', '2024-02-06 14:22:43', 'Create New Sales Quotation', '13', '2024-02-06', NULL, '0', '0'),
('5356', '18', '61', '26', '2024-02-06 12:36:37', 'Create New Purchase Order', '13', '2024-02-06', '0', '0', '893'),
('5357', '20', '30', '1', '2024-02-21 10:08:34', 'Voided.\nDocument reentered.', '13', '2024-02-06', NULL, '0', '0'),
('5358', '20', '32', '1', '2024-02-06 14:32:56', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5359', '25', '38', '1', '2024-02-06 12:46:38', 'Suplier Recive against Purchase order 10.', '13', '2024-01-31', '0', '0', '0'),
('5360', '32', '45', '22', '2024-02-06 14:22:43', 'Sales Quotation is approved', '13', '2024-02-06', '0', '0', '0'),
('5361', '20', '32', '1', '2024-02-21 10:09:23', 'Voided.\nDocument reentered.', '13', '2024-02-06', NULL, '0', '0'),
('5362', '20', '33', '1', '2024-02-06 14:52:41', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5363', '20', '34', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5364', '20', '35', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5365', '20', '36', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5366', '20', '37', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5367', '20', '38', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5368', '20', '39', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5369', '20', '40', '1', '2024-02-21 10:09:23', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5370', '20', '41', '1', '2024-02-22 16:46:10', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5371', '20', '42', '1', '2024-02-22 17:12:17', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5372', '20', '43', '1', '2024-02-22 17:12:53', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5373', '20', '44', '1', '2024-02-22 17:13:25', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5374', '20', '45', '1', '2024-02-22 17:14:34', 'Create Supplier Invoice against receival 1.', '13', '2024-01-31', NULL, '0', '0'),
('5375', '20', '33', '1', '2024-02-21 10:09:23', 'Voided.\nDocument reentered.', '13', '2024-02-06', NULL, '0', '0'),
('5376', '20', '46', '1', '2024-02-06 14:55:48', 'Create New Supplier Invoice', '13', '2024-02-06', NULL, '0', '0'),
('5377', '20', '46', '1', '2024-02-06 14:55:48', 'Voided.\nDocument reentered.', '13', '2024-02-06', '0', '0', '0'),
('5378', '20', '47', '1', '2024-02-22 17:15:03', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5379', '40', '39', '1', '2024-02-06 15:05:16', 'Dimension Created', '13', '2024-01-01', '0', '0', '0'),
('5380', '18', '62', '1', '2024-02-06 15:45:32', 'Create New Purchase Order', '13', '2024-02-06', NULL, '0', '43785'),
('5381', '1010', '0', '1', '2024-02-06 15:34:36', 'Update Item', '13', '2024-02-06', NULL, '0', '0'),
('5382', '1011', '615', '1', '2024-02-06 15:10:26', 'Update Item Codes', '13', '2024-02-06', '0', '0', '0'),
('5383', '1011', '616', '1', '2024-02-06 15:34:36', 'Create Item Codes', '13', '2024-02-06', '0', '0', '0'),
('5384', '1010', '0', '1', '2024-02-06 15:38:41', 'Create New Item', '13', '2024-02-06', NULL, '0', '0'),
('5385', '1011', '617', '1', '2024-02-06 15:38:41', 'Create Item Codes', '13', '2024-02-06', '0', '0', '0'),
('5386', '1010', '0', '1', '2024-02-06 15:40:28', 'Create New Item', '13', '2024-02-06', NULL, '0', '0'),
('5387', '1011', '618', '1', '2024-02-06 15:40:28', 'Create Item Codes', '13', '2024-02-06', '0', '0', '0'),
('5388', '1010', '0', '1', '2024-02-06 15:41:08', 'Create New Item', '13', '2024-02-06', NULL, '0', '0'),
('5389', '1011', '619', '1', '2024-02-06 15:41:08', 'Create Item Codes', '13', '2024-02-06', '0', '0', '0'),
('5390', '1010', '0', '1', '2024-02-06 15:45:54', 'Create New Item', '13', '2024-02-06', NULL, '0', '0'),
('5391', '18', '62', '1', '2024-02-14 12:05:26', 'Update Purchase Order', '13', '2024-02-06', NULL, '0', '57005'),
('5392', '1010', '0', '1', '2024-02-06 16:22:23', 'Delete Item', '13', '2024-02-06', NULL, '0', '0'),
('5393', '1001', '265', '1', '2024-02-13 15:22:46', 'Create New Customer', '13', '2024-02-06', NULL, '0', '0'),
('5394', '1002', '260', '1', '2024-02-06 15:48:19', 'Create New Branch', '13', '2024-02-06', '0', '0', '0'),
('5395', '3040', '0', '26', '2024-02-06 16:03:47', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5396', '32', '46', '26', '2024-02-06 16:15:17', 'Create New Sales Quotation', '13', '2024-02-06', NULL, '0', '0'),
('5397', '3040', '0', '26', '2024-02-08 08:22:07', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5398', '32', '47', '26', '2024-02-06 16:15:19', 'Create New Sales Quotation', '13', '2024-02-06', NULL, '0', '0'),
('5399', '40', '13', '1', '2024-02-06 16:12:01', 'Dimension Updated', '12', '2023-12-06', '0', '0', '0'),
('5400', '18', '63', '1', '2024-02-06 16:12:06', 'Create Auto Purchase Order', '13', '2024-01-05', '0', '0', '1050'),
('5401', '25', '39', '1', '2024-02-06 16:12:06', 'Auto Suplier Recive Processed', '13', '2024-01-05', '0', '0', '0'),
('5402', '20', '48', '1', '2024-02-21 10:15:07', 'Create New Supplier Invoice', '13', '2024-01-05', NULL, '0', '0'),
('5403', '18', '64', '1', '2024-02-06 16:12:50', 'Create Auto Purchase Order', '13', '2024-01-01', '0', '0', '189'),
('5404', '25', '40', '1', '2024-02-06 16:12:50', 'Auto Suplier Recive Processed', '13', '2024-01-01', '0', '0', '0'),
('5405', '20', '49', '1', '2024-02-15 17:08:02', 'Create New Supplier Invoice', '13', '2024-01-01', NULL, '0', '0'),
('5406', '18', '65', '1', '2024-02-06 16:13:38', 'Create Auto Purchase Order', '13', '2024-01-05', '0', '0', '443'),
('5407', '25', '41', '1', '2024-02-06 16:13:38', 'Auto Suplier Recive Processed', '13', '2024-01-05', '0', '0', '0'),
('5408', '20', '50', '1', '2024-02-21 10:15:35', 'Create New Supplier Invoice', '13', '2024-01-05', NULL, '0', '0'),
('5409', '18', '66', '1', '2024-02-06 16:14:40', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '37'),
('5410', '25', '42', '1', '2024-02-06 16:14:40', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5411', '20', '51', '1', '2024-02-21 10:17:18', 'Create New Supplier Invoice', '13', '2024-01-09', NULL, '0', '0'),
('5412', '32', '46', '22', '2024-02-10 14:14:24', 'Sales Quotation is approved', '13', '2024-02-06', NULL, '0', '0'),
('5413', '32', '47', '22', '2024-02-06 16:15:19', 'Sales Quotation is approved', '13', '2024-02-06', '0', '0', '0'),
('5414', '18', '67', '1', '2024-02-06 16:15:23', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '42'),
('5415', '25', '43', '1', '2024-02-06 16:15:23', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5416', '20', '52', '1', '2024-02-21 10:17:43', 'Create New Supplier Invoice', '13', '2024-01-09', NULL, '0', '0'),
('5417', '18', '68', '1', '2024-02-06 16:16:19', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '263'),
('5418', '25', '44', '1', '2024-02-06 16:16:19', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5419', '20', '53', '1', '2024-02-21 10:18:03', 'Create New Supplier Invoice', '13', '2024-01-09', NULL, '0', '0'),
('5420', '18', '69', '1', '2024-02-06 16:16:53', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '147'),
('5421', '25', '45', '1', '2024-02-06 16:16:53', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5422', '20', '54', '1', '2024-02-21 10:18:35', 'Create New Supplier Invoice', '13', '2024-01-09', NULL, '0', '0'),
('5423', '18', '70', '1', '2024-02-06 16:17:37', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '170'),
('5424', '25', '46', '1', '2024-02-06 16:17:37', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5425', '20', '55', '1', '2024-02-06 16:17:37', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('5426', '18', '71', '1', '2024-02-06 16:18:35', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '100'),
('5427', '25', '47', '1', '2024-02-06 16:18:35', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5428', '20', '56', '1', '2024-02-21 10:18:53', 'Create New Supplier Invoice', '13', '2024-01-09', NULL, '0', '0'),
('5429', '1011', '620', '1', '2024-02-06 16:33:12', 'Create Item Codes', '13', '2024-02-06', NULL, '0', '0'),
('5430', '1010', '0', '1', '2024-02-06 16:33:12', 'Create New Item', '13', '2024-02-06', NULL, '0', '0'),
('5431', '18', '72', '1', '2024-02-06 16:23:05', 'Create Auto Purchase Order', '13', '2024-01-09', '0', '0', '630'),
('5432', '25', '48', '1', '2024-02-06 16:23:05', 'Auto Suplier Recive Processed', '13', '2024-01-09', '0', '0', '0'),
('5433', '20', '57', '1', '2024-02-06 16:23:05', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('5434', '1009', '137', '1', '2024-02-06 16:24:01', 'Add New Supplier', '13', '2024-02-06', '0', '0', '0'),
('5435', '18', '73', '1', '2024-02-06 16:24:47', 'Create Auto Purchase Order', '13', '2024-01-12', '0', '0', '1092'),
('5436', '25', '49', '1', '2024-02-06 16:24:47', 'Auto Suplier Recive Processed', '13', '2024-01-12', '0', '0', '0'),
('5437', '20', '58', '1', '2024-02-06 16:24:47', 'Create New Supplier Invoice', '13', '2024-01-12', '0', '0', '0'),
('5438', '1009', '138', '1', '2024-02-06 16:25:56', 'Add New Supplier', '13', '2024-02-06', '0', '0', '0'),
('5439', '18', '74', '1', '2024-02-06 16:26:38', 'Create Auto Purchase Order', '13', '2024-01-12', '0', '0', '483'),
('5440', '25', '50', '1', '2024-02-06 16:26:38', 'Auto Suplier Recive Processed', '13', '2024-01-12', '0', '0', '0'),
('5441', '20', '59', '1', '2024-02-06 16:26:38', 'Create New Supplier Invoice', '13', '2024-01-12', '0', '0', '0'),
('5442', '18', '75', '1', '2024-02-06 16:28:21', 'Create Auto Purchase Order', '13', '2024-01-16', '0', '0', '12'),
('5443', '25', '51', '1', '2024-02-06 16:28:21', 'Auto Suplier Recive Processed', '13', '2024-01-16', '0', '0', '0'),
('5444', '20', '60', '1', '2024-02-21 10:19:22', 'Create New Supplier Invoice', '13', '2024-01-16', NULL, '0', '0'),
('5445', '18', '76', '1', '2024-02-06 16:29:02', 'Create Auto Purchase Order', '13', '2024-01-16', '0', '0', '16'),
('5446', '25', '52', '1', '2024-02-06 16:29:02', 'Auto Suplier Recive Processed', '13', '2024-01-16', '0', '0', '0'),
('5447', '20', '61', '1', '2024-02-21 10:19:35', 'Create New Supplier Invoice', '13', '2024-01-16', NULL, '0', '0'),
('5448', '18', '77', '1', '2024-02-06 16:29:38', 'Create Auto Purchase Order', '13', '2024-01-16', '0', '0', '21'),
('5449', '25', '53', '1', '2024-02-06 16:29:38', 'Auto Suplier Recive Processed', '13', '2024-01-16', '0', '0', '0'),
('5450', '20', '62', '1', '2024-02-21 10:19:55', 'Create New Supplier Invoice', '13', '2024-01-16', NULL, '0', '0'),
('5451', '1009', '139', '1', '2024-02-06 16:30:24', 'Add New Supplier', '13', '2024-02-06', '0', '0', '0'),
('5452', '18', '78', '1', '2024-02-06 16:31:04', 'Create Auto Purchase Order', '13', '2024-01-16', '0', '0', '21'),
('5453', '25', '54', '1', '2024-02-06 16:31:04', 'Auto Suplier Recive Processed', '13', '2024-01-16', '0', '0', '0'),
('5454', '20', '63', '1', '2024-02-21 10:20:12', 'Create New Supplier Invoice', '13', '2024-01-16', NULL, '0', '0'),
('5455', '1028', '2022', '1', '2024-02-06 16:32:21', 'Account Data Updated', '13', '2024-02-06', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('5456', '1010', '0', '1', '2024-02-08 16:41:49', 'Update Item', '13', '2024-02-06', NULL, '0', '0'),
('5457', '1011', '620', '1', '2024-02-08 16:41:49', 'Update Item Codes', '13', '2024-02-06', NULL, '0', '0'),
('5458', '40', '28', '1', '2024-02-06 16:35:16', 'Dimension Updated', '13', '2024-01-24', NULL, '0', '0'),
('5459', '40', '28', '1', '2024-02-06 16:44:36', 'Dimension Updated', '13', '2024-01-24', NULL, '0', '0'),
('5460', '18', '79', '1', '2024-02-06 16:41:17', 'Create Auto Purchase Order', '13', '2024-01-24', '0', '0', '373'),
('5461', '25', '55', '1', '2024-02-21 09:19:25', 'Auto Suplier Recive Processed', '13', '2024-01-24', NULL, '0', '0'),
('5462', '20', '64', '1', '2024-02-21 09:18:19', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('5463', '40', '28', '1', '2024-02-22 11:39:36', 'Dimension Updated', '13', '2024-01-24', NULL, '0', '0'),
('5464', '12', '25', '1', '2024-02-07 10:26:18', 'Created', '13', '2024-02-07', NULL, '0', '0'),
('5465', '12', '187', '1', '2024-02-07 10:25:44', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5466', '12', '187', '1', '2024-02-07 10:26:18', 'Create Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5467', '12', '0', '1', '2024-02-07 10:26:18', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5468', '12', '0', '1', '2024-02-07 12:13:09', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5469', '12', '25', '1', '2024-02-07 10:26:18', 'Updated.', '13', '2024-02-06', '0', '0', '0'),
('5470', '12', '187', '1', '2024-02-07 10:26:18', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5471', '12', '187', '1', '2024-02-07 10:26:18', 'Create Customer Payment', '13', '2024-02-07', '0', '0', '0'),
('5472', '12', '26', '1', '2024-02-22 11:44:56', 'Created', '13', '2024-02-06', NULL, '0', '0'),
('5473', '12', '198', '1', '2024-02-07 10:26:57', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5474', '12', '198', '1', '2024-02-22 11:44:56', 'Create Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5475', '12', '27', '1', '2024-02-07 11:32:16', 'Created', '13', '2024-02-06', '0', '0', '0'),
('5476', '12', '258', '1', '2024-02-07 11:32:16', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5477', '12', '258', '1', '2024-02-07 11:32:16', 'Create Customer Payment', '13', '2024-02-07', '0', '0', '0'),
('5478', '12', '28', '1', '2024-02-07 12:13:09', 'Created', '13', '2024-02-07', NULL, '0', '0'),
('5479', '12', '230', '1', '2024-02-07 11:32:48', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5480', '12', '230', '1', '2024-02-07 12:13:09', 'Create Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5481', '12', '29', '1', '2024-02-07 11:33:31', 'Created', '13', '2024-02-06', '0', '0', '0'),
('5482', '12', '252', '1', '2024-02-07 11:33:31', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5483', '12', '252', '1', '2024-02-07 11:33:31', 'Create Customer Payment', '13', '2024-02-07', '0', '0', '0'),
('5484', '12', '30', '1', '2024-02-07 11:34:13', 'Created', '13', '2024-02-06', '0', '0', '0'),
('5485', '12', '208', '1', '2024-02-07 11:34:13', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5486', '12', '208', '1', '2024-02-07 11:34:13', 'Create Customer Payment', '13', '2024-02-07', '0', '0', '0'),
('5487', '12', '0', '1', '2024-02-07 12:13:09', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5488', '12', '0', '1', '2024-02-13 16:01:52', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5489', '12', '28', '1', '2024-02-07 12:13:09', 'Updated.', '13', '2024-02-06', '0', '0', '0'),
('5490', '12', '230', '1', '2024-02-07 12:13:09', 'Update Customer Payment', '13', '2024-02-07', NULL, '0', '0'),
('5491', '12', '230', '1', '2024-02-07 12:13:09', 'Create Customer Payment', '13', '2024-02-07', '0', '0', '0'),
('5492', '4', '11', '1', '2024-02-07 12:13:31', 'Bank Account Transferred', '13', '2024-02-06', '0', '0', '8200'),
('5493', '40', '40', '26', '2024-02-17 14:32:22', 'Dimension Created', '13', '2024-02-08', NULL, '0', '0'),
('5494', '3040', '0', '26', '2024-02-08 08:24:21', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5495', '30', '30', '26', '2024-02-17 14:33:03', 'Create New Sales Order against Quotation no 46', '13', '2024-02-08', NULL, '0', '0'),
('5496', '40', '41', '26', '2024-02-08 08:24:21', 'Dimension Created', '13', '2024-02-08', '0', '0', '0'),
('5497', '3040', '0', '26', '2024-02-08 15:29:19', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5498', '30', '31', '26', '2024-02-17 14:31:36', 'Create New Sales Order against Quotation no 47', '13', '2024-02-08', NULL, '0', '0'),
('5499', '40', '42', '1', '2024-02-08 09:10:46', 'Dimension Created', '13', '2024-01-01', '0', '0', '0'),
('5500', '1001', '266', '1', '2024-02-08 15:22:04', 'Create New Customer', '13', '2024-02-08', '0', '0', '0'),
('5501', '1002', '261', '1', '2024-02-08 15:22:04', 'Create New Branch', '13', '2024-02-08', '0', '0', '0'),
('5502', '3040', '0', '26', '2024-02-09 08:55:58', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5503', '32', '48', '26', '2024-02-09 11:28:02', 'Create New Sales Quotation', '13', '2024-02-08', NULL, '0', '0'),
('5504', '1010', '0', '1', '2024-02-08 16:49:06', 'Update Item', '13', '2024-02-08', NULL, '0', '0'),
('5505', '1011', '620', '1', '2024-02-08 16:41:49', 'Update Item Codes', '13', '2024-02-08', '0', '0', '0'),
('5506', '1011', '621', '1', '2024-02-08 16:49:06', 'Create Item Codes', '13', '2024-02-08', '0', '0', '0'),
('5507', '1010', '0', '1', '2024-02-13 11:08:43', 'Create New Item', '13', '2024-02-08', NULL, '0', '0'),
('5508', '18', '6', '1', '2024-02-08 17:39:33', 'Delete Purchase Order', '13', '2024-02-08', '0', '0', '0'),
('5509', '25', '56', '1', '2024-02-08 17:41:49', 'Suplier Recive against Purchase order 4.', '13', '2024-01-31', '0', '0', '0'),
('5510', '25', '57', '1', '2024-02-08 17:42:54', 'Suplier Recive against Purchase order 7.', '13', '2024-01-31', '0', '0', '0'),
('5511', '25', '58', '1', '2024-02-08 17:43:33', 'Suplier Recive against Purchase order 11.', '13', '2024-01-31', '0', '0', '0'),
('5512', '20', '65', '1', '2024-02-08 17:47:09', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5513', '20', '66', '1', '2024-02-08 17:47:19', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5514', '20', '67', '1', '2024-02-08 17:47:28', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5515', '20', '65', '1', '2024-02-08 17:47:09', 'Voided.\nDocument reentered.', '13', '2024-02-08', '0', '0', '0'),
('5516', '20', '68', '1', '2024-03-01 11:39:17', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5517', '20', '66', '1', '2024-02-08 17:47:19', 'Voided.\nDocument reentered.', '13', '2024-02-08', '0', '0', '0'),
('5518', '20', '69', '1', '2024-03-01 11:39:36', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5519', '20', '67', '1', '2024-02-08 17:47:28', 'Voided.\nDocument reentered.', '13', '2024-02-08', '0', '0', '0'),
('5520', '20', '70', '1', '2024-03-01 11:40:52', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5521', '18', '80', '1', '2024-02-08 17:51:40', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '512'),
('5522', '25', '59', '1', '2024-02-08 17:51:40', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5523', '20', '71', '1', '2024-02-08 17:52:55', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5524', '20', '71', '1', '2024-02-08 17:52:55', 'Voided.\nDocument reentered.', '13', '2024-02-08', '0', '0', '0'),
('5525', '20', '72', '1', '2024-03-01 11:41:10', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5526', '18', '81', '1', '2024-02-08 17:56:55', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '701'),
('5527', '25', '60', '1', '2024-02-08 17:56:55', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5528', '20', '73', '1', '2024-03-01 11:41:39', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5529', '40', '43', '26', '2024-02-09 08:55:58', 'Dimension Created', '13', '2024-02-09', '0', '0', '0'),
('5530', '3040', '0', '26', '2024-02-09 10:37:45', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5531', '30', '32', '26', '2024-02-09 08:55:58', 'Create New Sales Order against Quotation no 45', '13', '2024-02-09', '0', '0', '0'),
('5532', '18', '82', '26', '2024-02-09 08:57:50', 'Create New Purchase Order', '13', '2024-02-09', '0', '0', '76'),
('5533', '3040', '0', '26', '2024-02-09 16:33:53', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5534', '32', '49', '26', '2024-02-09 11:27:27', 'Create New Sales Quotation', '13', '2024-02-09', NULL, '0', '0'),
('5535', '1001', '87', '1', '2024-02-09 10:40:11', 'Update Customer', '13', '2024-02-09', '0', '0', '0'),
('5536', '1002', '84', '1', '2024-02-09 10:42:19', 'Update Branch', '13', '2024-02-09', '0', '0', '0'),
('5537', '32', '49', '22', '2024-02-09 11:27:27', 'Sales Quotation is approved', '13', '2024-02-09', '0', '0', '0'),
('5538', '32', '48', '22', '2024-02-09 11:28:02', 'Sales Quotation is approved', '13', '2024-02-09', '0', '0', '0'),
('5539', '1001', '267', '1', '2024-02-09 16:07:16', 'Create New Customer', '13', '2024-02-09', '0', '0', '0'),
('5540', '1002', '262', '1', '2024-02-09 16:07:16', 'Create New Branch', '13', '2024-02-09', '0', '0', '0'),
('5541', '1001', '268', '1', '2024-02-09 16:08:34', 'Create New Customer', '13', '2024-02-09', '0', '0', '0'),
('5542', '1002', '263', '1', '2024-02-09 16:08:34', 'Create New Branch', '13', '2024-02-09', '0', '0', '0'),
('5543', '3040', '0', '26', '2024-02-09 16:36:44', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5544', '32', '50', '26', '2024-02-10 10:32:35', 'Create New Sales Quotation', '13', '2024-02-09', NULL, '0', '0'),
('5545', '3040', '0', '26', '2024-02-09 16:37:50', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5546', '32', '51', '26', '2024-02-10 10:32:37', 'Create New Sales Quotation', '13', '2024-02-09', NULL, '0', '0'),
('5547', '40', '44', '26', '2024-02-09 16:37:50', 'Dimension Created', '13', '2024-02-09', '0', '0', '0'),
('5548', '3040', '0', '26', '2024-02-09 16:42:07', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5549', '30', '33', '26', '2024-02-09 16:37:50', 'Create New Sales Order against Quotation no 49', '13', '2024-02-09', '0', '0', '0'),
('5550', '13', '27', '1', '2024-02-09 16:39:13', 'Created', '13', '2024-02-09', NULL, '0', '0'),
('5551', '13', '27', '1', '2024-02-09 16:39:13', 'Create Sales Delivery Note against Sales order no 33', '13', '2024-02-09', '0', '0', '0'),
('5552', '10', '27', '1', '2024-02-09 16:39:22', 'Created', '13', '2024-02-09', NULL, '0', '0'),
('5553', '10', '27', '1', '2024-02-09 16:40:21', 'Create Sales Invoice against Sales Delivery note 27', '13', '2024-02-09', NULL, '0', '0'),
('5554', '10', '27', '1', '2024-02-09 16:40:21', 'Voided.\n', '13', '2024-02-09', '0', '0', '0'),
('5555', '40', '45', '1', '2024-02-09 16:42:07', 'Dimension Created', '13', '2024-02-09', '0', '0', '0'),
('5556', '3040', '0', '1', '2024-02-10 08:48:59', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5557', '30', '34', '1', '2024-02-09 16:42:07', 'Create New Sales Order', '13', '2024-02-06', '0', '0', '0'),
('5558', '13', '28', '1', '2024-02-09 16:42:07', 'Created', '13', '2024-02-06', NULL, '0', '0'),
('5559', '13', '28', '1', '2024-02-09 16:42:07', 'Create Sales Delivery Note', '13', '2024-02-09', '0', '0', '0'),
('5560', '10', '28', '1', '2024-02-09 16:42:07', 'Created', '13', '2024-02-06', NULL, '0', '0'),
('5561', '10', '28', '1', '2024-02-09 16:42:07', 'Create Sales Invoice', '13', '2024-02-09', '0', '0', '0'),
('5562', '10', '29', '1', '2024-02-09 16:42:29', 'Created', '13', '2024-02-09', NULL, '0', '0'),
('5563', '10', '29', '1', '2024-02-09 16:42:29', 'Create Sales Invoice against Sales Delivery note 27', '13', '2024-02-09', '0', '0', '0'),
('5564', '3040', '0', '26', '2024-02-10 10:27:06', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5565', '32', '52', '26', '2024-02-10 10:32:01', 'Create New Sales Quotation', '13', '2024-02-10', NULL, '0', '0'),
('5566', '3040', '0', '26', '2024-02-10 14:10:34', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5567', '32', '53', '26', '2024-02-10 10:31:40', 'Create New Sales Quotation', '13', '2024-02-10', NULL, '0', '0'),
('5568', '32', '53', '22', '2024-02-10 10:31:40', 'Sales Quotation is approved', '13', '2024-02-10', '0', '0', '0'),
('5569', '32', '52', '22', '2024-02-10 10:32:01', 'Sales Quotation is approved', '13', '2024-02-10', '0', '0', '0'),
('5570', '32', '50', '22', '2024-02-10 10:32:35', 'Sales Quotation is approved', '13', '2024-02-10', '0', '0', '0'),
('5571', '32', '51', '22', '2024-02-10 10:32:37', 'Sales Quotation is approved', '13', '2024-02-10', '0', '0', '0'),
('5572', '40', '46', '26', '2024-02-10 14:10:34', 'Dimension Created', '13', '2024-02-10', '0', '0', '0'),
('5573', '3040', '0', '26', '2024-02-12 10:37:22', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5574', '30', '35', '26', '2024-02-10 14:10:34', 'Create New Sales Order against Quotation no 51', '13', '2024-02-10', '0', '0', '0'),
('5575', '32', '46', '22', '2024-02-10 14:14:24', 'Update Sales Quotation', '13', '2024-02-06', '0', '0', '0'),
('5576', '13', '29', '1', '2024-02-10 14:22:47', 'Created', '13', '2024-02-10', NULL, '0', '0'),
('5577', '13', '29', '1', '2024-02-10 14:22:47', 'Create Sales Delivery Note against Sales order no 32', '13', '2024-02-10', '0', '0', '0'),
('5578', '10', '30', '1', '2024-02-10 14:26:17', 'Created', '13', '2024-02-10', NULL, '0', '0'),
('5579', '10', '30', '1', '2024-02-10 14:26:17', 'Create Sales Invoice against Sales Delivery note 29', '13', '2024-02-10', '0', '0', '0'),
('5580', '13', '30', '1', '2024-02-10 14:26:39', 'Created', '13', '2024-02-10', NULL, '0', '0'),
('5581', '13', '30', '1', '2024-02-10 14:26:39', 'Create Sales Delivery Note against Sales order no 35', '13', '2024-02-10', '0', '0', '0'),
('5582', '10', '31', '1', '2024-02-10 14:30:40', 'Created', '13', '2024-02-10', NULL, '0', '0'),
('5583', '10', '31', '1', '2024-02-10 14:30:40', 'Create Sales Invoice against Sales Delivery note 30', '13', '2024-02-10', '0', '0', '0'),
('5584', '1001', '269', '1', '2024-02-12 10:11:04', 'Create New Customer', '13', '2024-02-12', '0', '0', '0'),
('5585', '1002', '264', '1', '2024-02-12 10:11:04', 'Create New Branch', '13', '2024-02-12', '0', '0', '0'),
('5586', '13', '31', '1', '2024-02-12 10:24:37', 'Created', '13', '2024-02-12', NULL, '0', '0'),
('5587', '13', '31', '1', '2024-02-12 10:24:37', 'Create Sales Delivery Note against Sales order no 29', '13', '2024-02-12', NULL, '0', '0'),
('5588', '13', '31', '1', '2024-02-12 10:24:37', 'Create Sales Delivery Note against Sales order no 29', '13', '2024-02-12', NULL, '0', '0'),
('5589', '13', '31', '1', '2024-02-12 10:24:37', 'Create Sales Delivery Note against Sales order no 29', '13', '2024-02-12', NULL, '0', '0'),
('5590', '13', '31', '1', '2024-02-12 10:24:37', 'Create Sales Delivery Note against Sales order no 29', '13', '2024-02-12', '0', '0', '0'),
('5591', '10', '32', '1', '2024-02-12 10:24:49', 'Created', '13', '2024-02-12', NULL, '0', '0'),
('5592', '10', '32', '1', '2024-02-12 10:24:49', 'Create Sales Invoice against Sales Delivery note 31', '13', '2024-02-12', NULL, '0', '0'),
('5593', '10', '32', '1', '2024-02-12 10:24:49', 'Create Sales Invoice against Sales Delivery note 31', '13', '2024-02-12', NULL, '0', '0'),
('5594', '10', '32', '1', '2024-02-12 10:24:49', 'Create Sales Invoice against Sales Delivery note 31', '13', '2024-02-12', NULL, '0', '0'),
('5595', '10', '32', '1', '2024-02-12 10:24:49', 'Create Sales Invoice against Sales Delivery note 31', '13', '2024-02-12', '0', '0', '0'),
('5596', '3040', '0', '26', '2024-02-13 10:24:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5597', '32', '54', '26', '2024-02-12 11:37:39', 'Create New Sales Quotation', '13', '2024-02-12', NULL, '0', '0'),
('5598', '11', '1', '1', '2024-02-12 10:46:56', 'Created', '13', '2024-02-06', NULL, '0', '0'),
('5599', '11', '1', '1', '2024-02-12 10:46:56', 'Create Customer Credit Note ', '13', '2024-02-12', '0', '0', '0'),
('5600', '1001', '270', '1', '2024-02-12 11:12:38', 'Create New Customer', '13', '2024-02-12', '0', '0', '0'),
('5601', '1002', '265', '1', '2024-02-12 11:12:38', 'Create New Branch', '13', '2024-02-12', '0', '0', '0'),
('5602', '18', '83', '1', '2024-02-12 11:31:43', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '276'),
('5603', '25', '61', '1', '2024-02-12 11:31:43', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5604', '20', '74', '1', '2024-03-01 11:41:59', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5605', '18', '84', '1', '2024-02-12 11:33:27', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '213'),
('5606', '25', '62', '1', '2024-02-12 11:33:27', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5607', '20', '75', '1', '2024-03-01 11:42:15', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5608', '32', '54', '22', '2024-02-12 11:38:46', 'Update Sales Quotation', '13', '2024-02-12', NULL, '0', '0'),
('5609', '18', '85', '1', '2024-02-12 11:37:54', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '512'),
('5610', '25', '63', '1', '2024-02-12 11:37:54', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5611', '20', '76', '1', '2024-03-01 11:42:31', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5612', '32', '54', '22', '2024-02-12 11:38:46', 'Sales Quotation is approved', '13', '2024-02-12', '0', '0', '0'),
('5613', '32', '39', '22', '2024-02-12 18:44:06', 'Update Sales Quotation', '13', '2024-02-02', '0', '0', '0'),
('5614', '1001', '271', '1', '2024-02-13 08:27:59', 'Create New Customer', '13', '2024-02-13', '0', '0', '0'),
('5615', '1002', '266', '1', '2024-02-13 08:27:59', 'Create New Branch', '13', '2024-02-13', '0', '0', '0'),
('5616', '3040', '0', '26', '2024-02-13 10:24:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5617', '3040', '0', '26', '2024-02-13 10:24:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5618', '3040', '0', '26', '2024-02-13 10:57:10', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5619', '32', '55', '26', '2024-02-13 11:07:05', 'Create New Sales Quotation', '13', '2024-02-13', NULL, '0', '0'),
('5620', '3040', '0', '26', '2024-02-13 11:58:23', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5621', '32', '56', '26', '2024-02-13 11:07:07', 'Create New Sales Quotation', '13', '2024-02-13', NULL, '0', '0'),
('5622', '1028', '21081', '1', '2024-02-13 11:07:05', 'Account Data Added', '13', '2024-02-13', '0', '0', '0'),
('5623', '32', '55', '22', '2024-02-13 11:07:05', 'Sales Quotation is approved', '13', '2024-02-13', '0', '0', '0'),
('5624', '32', '56', '22', '2024-02-13 11:07:07', 'Sales Quotation is approved', '13', '2024-02-13', '0', '0', '0'),
('5625', '1011', '622', '1', '2024-02-13 11:08:43', 'Create Item Codes', '13', '2024-02-13', '0', '0', '0'),
('5626', '1010', '0', '1', '2024-02-16 14:51:03', 'Create New Item', '13', '2024-02-13', NULL, '0', '0'),
('5627', '18', '86', '1', '2024-02-13 11:57:20', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '433'),
('5628', '25', '64', '1', '2024-02-13 11:57:20', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5629', '20', '77', '1', '2024-03-01 11:42:54', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5630', '40', '47', '26', '2024-02-13 11:58:23', 'Dimension Created', '13', '2024-02-13', '0', '0', '0'),
('5631', '3040', '0', '26', '2024-02-14 12:28:38', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5632', '30', '36', '26', '2024-02-13 11:58:23', 'Create New Sales Order against Quotation no 50', '13', '2024-02-13', '0', '0', '0'),
('5633', '18', '87', '1', '2024-02-13 12:05:29', 'Create Auto Purchase Order', '13', '2024-02-13', '0', '0', '9371'),
('5634', '25', '65', '1', '2024-02-13 12:05:29', 'Auto Suplier Recive Processed', '13', '2024-02-13', '0', '0', '0'),
('5635', '20', '78', '1', '2024-02-13 16:06:37', 'Create New Supplier Invoice', '13', '2024-02-13', NULL, '0', '0'),
('5636', '18', '88', '1', '2024-02-13 12:06:30', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '788'),
('5637', '25', '66', '1', '2024-02-13 12:06:30', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5638', '20', '79', '1', '2024-03-01 11:43:09', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5639', '18', '89', '1', '2024-02-13 12:08:20', 'Create Auto Purchase Order', '13', '2024-01-30', '0', '0', '2032'),
('5640', '25', '67', '1', '2024-02-13 12:08:20', 'Auto Suplier Recive Processed', '13', '2024-01-30', '0', '0', '0'),
('5641', '20', '80', '1', '2024-03-01 11:43:37', 'Create New Supplier Invoice', '13', '2024-01-30', NULL, '0', '0'),
('5642', '18', '90', '1', '2024-02-13 12:10:37', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '17'),
('5643', '25', '68', '1', '2024-02-13 12:10:37', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5644', '20', '81', '1', '2024-03-01 11:43:49', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5645', '18', '91', '1', '2024-02-13 12:11:34', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '54'),
('5646', '25', '69', '1', '2024-02-13 12:11:34', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5647', '20', '82', '1', '2024-03-01 11:44:10', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5648', '18', '92', '1', '2024-02-13 12:16:49', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '1721'),
('5649', '25', '70', '1', '2024-02-13 12:16:49', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5650', '20', '83', '1', '2024-03-01 11:44:23', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5651', '1001', '265', '1', '2024-02-13 15:22:46', 'Update Customer', '13', '2024-02-13', '0', '0', '0'),
('5652', '13', '32', '1', '2024-02-13 15:38:15', 'Created', '13', '2024-02-13', NULL, '0', '0'),
('5653', '13', '32', '1', '2024-02-13 15:38:15', 'Create Sales Delivery Note against Sales order no 36', '13', '2024-02-13', '0', '0', '0'),
('5654', '10', '33', '1', '2024-02-13 15:38:56', 'Created', '13', '2024-02-13', NULL, '0', '0'),
('5655', '10', '33', '1', '2024-02-13 15:38:56', 'Create Sales Invoice against Sales Delivery note 32', '13', '2024-02-13', '0', '0', '0'),
('5656', '0', '23', '1', '2024-02-15 14:42:23', 'Journal Entry Added', '13', '2024-02-13', NULL, '0', '0'),
('5657', '12', '31', '1', '2024-02-13 15:57:47', 'Created', '13', '2024-02-13', '0', '0', '0'),
('5658', '12', '265', '1', '2024-02-13 15:57:47', 'Update Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5659', '12', '32', '1', '2024-02-13 15:58:42', 'Created', '13', '2024-02-13', '0', '0', '0'),
('5660', '12', '74', '1', '2024-02-13 15:58:42', 'Update Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5661', '12', '33', '1', '2024-02-13 15:59:11', 'Created', '13', '2024-02-13', '0', '0', '0'),
('5662', '12', '85', '1', '2024-02-13 15:59:11', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5663', '12', '85', '1', '2024-02-13 15:59:11', 'Create Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5664', '12', '34', '1', '2024-02-13 16:01:52', 'Created', '13', '2024-02-13', NULL, '0', '0'),
('5665', '12', '204', '1', '2024-02-13 16:01:52', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5666', '11', '204', '1', '2024-02-13 16:01:16', 'Create Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5667', '12', '0', '1', '2024-02-13 16:01:52', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5668', '12', '0', '1', '2024-02-22 11:44:56', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5669', '12', '34', '1', '2024-02-13 16:01:52', 'Updated.', '13', '2024-02-13', '0', '0', '0'),
('5670', '12', '204', '1', '2024-02-13 16:01:52', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5671', '12', '204', '1', '2024-02-13 16:01:52', 'Create Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5672', '20', '78', '1', '2024-02-13 16:06:37', 'Voided.\nDocument reentered.', '13', '2024-02-13', '0', '0', '0'),
('5673', '20', '84', '1', '2024-03-01 11:44:35', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5674', '12', '35', '1', '2024-02-13 16:07:25', 'Created', '13', '2024-02-13', '0', '0', '0'),
('5675', '12', '267', '1', '2024-02-13 16:07:25', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5676', '12', '267', '1', '2024-02-13 16:07:25', 'Create Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5677', '0', '24', '1', '2024-02-15 14:42:53', 'Journal Entry Added', '13', '2024-02-13', NULL, '0', '0'),
('5678', '12', '136', '1', '2024-02-13 16:57:34', 'Update Customer Payment', '13', '2024-02-13', NULL, '0', '0'),
('5679', '12', '136', '1', '2024-02-13 16:57:34', 'Create Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5680', '0', '136', '1', '2024-02-13 16:58:07', 'Create Customer Payment', '13', '2024-02-13', '0', '0', '0'),
('5681', '18', '93', '1', '2024-02-14 11:49:44', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '1194'),
('5682', '25', '71', '1', '2024-02-14 11:49:44', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5683', '20', '85', '1', '2024-03-01 11:44:45', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5684', '18', '94', '1', '2024-02-14 11:50:33', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '512'),
('5685', '25', '72', '1', '2024-02-14 11:50:33', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5686', '20', '86', '1', '2024-02-22 11:40:34', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5687', '18', '95', '1', '2024-02-14 11:51:12', 'Create Auto Purchase Order', '13', '2024-01-31', '0', '0', '134'),
('5688', '25', '73', '1', '2024-02-14 11:51:12', 'Auto Suplier Recive Processed', '13', '2024-01-31', '0', '0', '0'),
('5689', '20', '87', '1', '2024-03-01 11:44:55', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('5690', '25', '74', '1', '2024-02-14 12:07:43', 'Suplier Recive against Purchase order 62.', '13', '2024-02-14', NULL, '0', '0'),
('5691', '18', '62', '1', '2024-02-14 16:21:50', 'Update Purchase Order', '13', '2024-02-14', NULL, '0', '57005'),
('5692', '25', '74', '1', '2024-02-14 12:07:43', 'Voided.\n', '13', '2024-02-14', '0', '0', '0'),
('5693', '1001', '272', '1', '2024-02-14 12:10:03', 'Create New Customer', '13', '2024-02-14', '0', '0', '0'),
('5694', '1002', '267', '1', '2024-02-14 12:10:03', 'Create New Branch', '13', '2024-02-14', '0', '0', '0'),
('5695', '3040', '0', '26', '2024-02-14 14:22:49', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5696', '32', '57', '26', '2024-02-14 15:24:36', 'Create New Sales Quotation', '13', '2024-02-14', NULL, '0', '0'),
('5697', '3040', '0', '26', '2024-02-14 14:22:49', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5698', '3040', '0', '26', '2024-02-15 13:56:41', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5699', '32', '58', '26', '2024-02-18 18:24:51', 'Create New Sales Quotation', '13', '2024-02-14', NULL, '0', '0'),
('5700', '32', '57', '22', '2024-02-14 15:24:36', 'Sales Quotation is approved', '13', '2024-02-14', '0', '0', '0'),
('5701', '18', '96', '1', '2024-02-14 16:21:26', 'Create New Purchase Order', '13', '2024-02-14', '0', '0', '57005'),
('5702', '18', '62', '1', '2024-02-14 16:21:50', 'Delete Purchase Order', '13', '2024-02-14', '0', '0', '0'),
('5703', '25', '75', '1', '2024-02-14 16:22:42', 'Suplier Recive against Purchase order 96.', '13', '2024-02-14', '0', '0', '0'),
('5704', '20', '88', '1', '2024-03-01 11:45:05', 'Create Supplier Invoice against receival 1.', '13', '2024-02-14', NULL, '0', '0'),
('5705', '25', '76', '1', '2024-02-14 16:42:35', 'Suplier Recive against Purchase order 26.', '13', '2024-02-05', '0', '0', '0'),
('5706', '25', '77', '1', '2024-02-14 16:42:54', 'Suplier Recive against Purchase order 28.', '13', '2024-02-08', '0', '0', '0'),
('5707', '25', '78', '1', '2024-02-14 16:43:14', 'Suplier Recive against Purchase order 37.', '13', '2024-02-08', '0', '0', '0'),
('5708', '25', '79', '1', '2024-02-14 16:44:21', 'Suplier Recive against Purchase order 32.', '13', '2024-02-08', '0', '0', '0'),
('5709', '20', '89', '1', '2024-02-15 17:23:17', 'Create Supplier Invoice against receival 1.', '13', '2024-02-14', NULL, '0', '0'),
('5710', '20', '90', '1', '2024-02-21 09:20:38', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5711', '20', '91', '1', '2024-02-22 11:48:47', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5712', '20', '92', '1', '2024-02-22 11:51:50', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5713', '25', '80', '1', '2024-02-15 10:11:14', 'Suplier Recive against Purchase order 82.', '13', '2024-02-15', '0', '0', '0'),
('5714', '20', '93', '1', '2024-02-22 11:40:49', 'Create Supplier Invoice against receival 1.', '13', '2024-02-15', NULL, '0', '0'),
('5715', '21', '1', '1', '2024-02-15 10:59:34', 'Supplier Credit', '13', '2024-02-15', '0', '0', '0'),
('5716', '0', '25', '1', '2024-02-15 11:09:33', 'Journal Entry Added', '13', '2024-01-10', NULL, '0', '0'),
('5717', '0', '25', '1', '2024-02-15 11:09:33', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5718', '0', '26', '1', '2024-02-15 11:09:33', 'Journal Entry Added', '13', '2024-01-10', '0', '0', '0'),
('5719', '0', '17', '1', '2024-02-17 10:10:27', 'Voided.\nDocument reentered.', '13', '2024-02-15', NULL, '0', '0'),
('5720', '0', '27', '1', '2024-02-15 11:10:10', 'Journal Entry Added', '13', '2024-01-19', '0', '0', '0'),
('5721', '0', '18', '1', '2024-02-15 11:10:25', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5722', '0', '28', '1', '2024-02-20 11:02:13', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('5723', '0', '19', '1', '2024-02-15 11:10:44', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5724', '0', '29', '1', '2024-02-20 11:02:32', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('5725', '3040', '0', '26', '2024-02-16 14:21:21', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5726', '32', '59', '26', '2024-02-15 16:01:33', 'Create New Sales Quotation', '13', '2024-02-15', NULL, '0', '0'),
('5727', '0', '20', '1', '2024-02-15 14:41:19', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5728', '0', '30', '1', '2024-02-20 11:02:49', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('5729', '0', '22', '1', '2024-02-15 14:42:07', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5730', '0', '31', '1', '2024-02-15 14:42:07', 'Journal Entry Added', '13', '2024-01-31', '0', '0', '0'),
('5731', '0', '23', '1', '2024-02-15 14:42:23', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5732', '0', '32', '1', '2024-02-15 14:42:23', 'Journal Entry Added', '13', '2024-02-13', '0', '0', '0'),
('5733', '0', '24', '1', '2024-02-15 14:42:53', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5734', '0', '33', '1', '2024-02-15 14:42:53', 'Journal Entry Added', '13', '2024-02-13', '0', '0', '0'),
('5735', '40', '48', '1', '2024-02-15 14:47:09', 'Dimension Created', '12', '2023-11-09', '0', '0', '0'),
('5736', '32', '59', '22', '2024-02-15 16:01:33', 'Sales Quotation is approved', '13', '2024-02-15', '0', '0', '0'),
('5737', '0', '34', '1', '2024-02-15 16:19:34', 'Journal Entry Added', '13', '2024-02-03', '0', '0', '0'),
('5738', '0', '35', '1', '2024-02-15 16:20:49', 'Journal Entry Added', '13', '2024-02-15', '0', '0', '0'),
('5739', '0', '36', '1', '2024-02-15 16:37:17', 'Journal Entry Added', '13', '2024-02-03', '0', '0', '0'),
('5740', '0', '37', '1', '2024-02-15 16:38:33', 'Journal Entry Added', '13', '2024-02-06', '0', '0', '0'),
('5741', '0', '38', '1', '2024-02-15 16:41:13', 'Journal Entry Added', '13', '2024-02-06', '0', '0', '0'),
('5742', '0', '197', '1', '2024-02-15 16:41:55', 'Create Customer Payment', '13', '2024-02-15', NULL, '0', '0'),
('5743', '0', '197', '1', '2024-02-15 16:41:55', 'Create Customer Payment', '13', '2024-02-15', '0', '0', '0'),
('5744', '4', '12', '1', '2024-02-15 16:47:59', 'Bank Account Transferred', '13', '2024-02-13', '0', '0', '500'),
('5745', '0', '39', '1', '2024-02-15 16:49:22', 'Journal Entry Added', '13', '2024-02-13', '0', '0', '0'),
('5746', '0', '6', '1', '2024-02-15 16:58:44', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5747', '0', '40', '1', '2024-02-15 16:58:44', 'Journal Entry Added', '12', '2023-12-31', '0', '0', '0'),
('5748', '20', '49', '1', '2024-02-15 17:08:02', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5749', '20', '94', '1', '2024-02-21 10:16:31', 'Create New Supplier Invoice', '13', '2024-01-05', NULL, '0', '0'),
('5750', '18', '97', '1', '2024-02-15 17:10:17', 'Create Auto Purchase Order', '12', '2023-12-31', '0', '0', '1575'),
('5751', '25', '81', '1', '2024-02-15 17:10:17', 'Auto Suplier Recive Processed', '12', '2023-12-31', '0', '0', '0'),
('5752', '20', '95', '1', '2024-02-15 17:10:17', 'Create New Supplier Invoice', '12', '2023-12-31', '0', '0', '0'),
('5753', '1009', '140', '1', '2024-02-15 17:16:04', 'Add New Supplier', '13', '2024-02-15', NULL, '0', '0'),
('5754', '1009', '140', '1', '2024-02-15 17:18:22', 'Update Supplier', '13', '2024-02-15', NULL, '0', '0'),
('5755', '1009', '141', '1', '2024-02-15 17:17:57', 'Add New Supplier', '13', '2024-02-15', '0', '0', '0'),
('5756', '1009', '140', '1', '2024-02-15 17:18:22', 'Update Supplier', '13', '2024-02-15', '0', '0', '0'),
('5757', '1009', '142', '1', '2024-02-15 17:19:16', 'Add New Supplier', '13', '2024-02-15', NULL, '0', '0'),
('5758', '1009', '142', '1', '2024-02-15 17:19:16', 'Update Supplier', '13', '2024-02-15', '0', '0', '0'),
('5759', '20', '89', '1', '2024-02-15 17:23:17', 'Voided.\nDocument reentered.', '13', '2024-02-15', '0', '0', '0'),
('5760', '20', '96', '1', '2024-02-21 10:33:59', 'Create New Supplier Invoice', '13', '2024-02-05', NULL, '0', '0'),
('5761', '0', '41', '1', '2024-02-16 10:35:32', 'Journal Entry Added', '13', '2024-02-15', '0', '0', '0'),
('5762', '1001', '273', '1', '2024-02-16 11:59:35', 'Create New Customer', '13', '2024-02-16', '0', '0', '0'),
('5763', '1002', '268', '1', '2024-02-16 11:59:35', 'Create New Branch', '13', '2024-02-16', '0', '0', '0'),
('5764', '40', '49', '26', '2024-02-16 14:21:21', 'Dimension Created', '13', '2024-02-16', '0', '0', '0'),
('5765', '3040', '0', '26', '2024-02-16 16:21:41', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5766', '30', '37', '26', '2024-02-16 14:21:21', 'Create New Sales Order against Quotation no 59', '13', '2024-02-16', '0', '0', '0'),
('5767', '1011', '623', '1', '2024-02-16 14:51:03', 'Create Item Codes', '13', '2024-02-16', '0', '0', '0'),
('5768', '1010', '0', '1', '2024-02-19 09:00:28', 'Create New Item', '13', '2024-02-16', NULL, '0', '0'),
('5769', '18', '98', '26', '2024-02-16 14:53:58', 'Create New Purchase Order', '13', '2024-02-16', '0', '0', '566'),
('5770', '3040', '0', '26', '2024-02-16 18:08:00', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5771', '32', '60', '26', '2024-02-16 19:46:59', 'Create New Sales Quotation', '13', '2024-02-16', NULL, '0', '0'),
('5772', '40', '50', '26', '2024-02-17 14:27:23', 'Dimension Created', '13', '2024-02-16', NULL, '0', '0'),
('5773', '3040', '0', '26', '2024-02-16 19:59:52', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5774', '30', '38', '26', '2024-02-19 09:25:11', 'Create New Sales Order against Quotation no 46', '13', '2024-02-16', NULL, '0', '0'),
('5775', '32', '60', '22', '2024-02-16 19:46:59', 'Sales Quotation is approved', '13', '2024-02-16', '0', '0', '0'),
('5776', '3040', '0', '26', '2024-02-16 19:59:52', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5777', '3040', '0', '26', '2024-02-17 14:27:10', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5778', '32', '61', '26', '2024-02-18 18:24:53', 'Create New Sales Quotation', '13', '2024-02-16', NULL, '0', '0'),
('5779', '18', '99', '1', '2024-02-17 10:06:58', 'Create Auto Purchase Order', '13', '2024-01-01', '0', '0', '272'),
('5780', '25', '82', '1', '2024-02-17 10:06:58', 'Auto Suplier Recive Processed', '13', '2024-01-01', '0', '0', '0'),
('5781', '20', '97', '1', '2024-02-17 10:10:27', 'Create New Supplier Invoice', '13', '2024-01-01', NULL, '0', '0'),
('5782', '0', '42', '1', '2024-02-17 10:10:27', 'Journal Entry Added', '13', '2024-01-31', NULL, '0', '0'),
('5783', '0', '17', '1', '2024-02-17 10:10:27', 'Supplier Allocations', '13', '2024-02-17', '0', '0', '0'),
('5784', '0', '3', '1', '2024-02-27 11:12:38', 'Update Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5785', '20', '18', '1', '2024-02-22 16:25:07', 'Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5786', '20', '97', '1', '2024-02-17 10:10:27', 'Update Supplier Allocations', '13', '2024-02-17', '0', '0', '0'),
('5787', '0', '42', '1', '2024-02-20 11:05:01', 'Update Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5788', '18', '100', '1', '2024-02-17 11:59:29', 'Create Auto Purchase Order', '13', '2024-02-17', '0', '0', '282'),
('5789', '25', '83', '1', '2024-02-17 11:59:29', 'Auto Suplier Recive Processed', '13', '2024-02-17', '0', '0', '0'),
('5790', '20', '98', '1', '2024-02-17 12:01:01', 'Create New Supplier Invoice', '13', '2024-02-17', NULL, '0', '0'),
('5791', '0', '43', '1', '2024-02-17 12:01:01', 'Journal Entry Added', '13', '2024-02-17', NULL, '0', '0'),
('5792', '20', '19', '1', '2024-02-22 16:25:35', 'Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5793', '20', '98', '1', '2024-02-17 12:03:59', 'Update Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5794', '0', '43', '1', '2024-02-17 12:03:59', 'Update Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5795', '20', '98', '1', '2024-02-17 12:03:59', 'Voided.\nDocument reentered.', '13', '2024-02-17', NULL, '0', '0'),
('5796', '20', '99', '1', '2024-02-17 12:03:59', 'Create New Supplier Invoice', '13', '2024-02-17', NULL, '0', '0'),
('5797', '0', '43', '1', '2024-02-17 12:03:59', 'Update Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5798', '20', '99', '1', '2024-02-17 12:03:59', 'Update Supplier Allocations', '13', '2024-02-17', '0', '0', '0'),
('5799', '0', '43', '1', '2024-02-20 11:05:31', 'Update Supplier Allocations', '13', '2024-02-17', NULL, '0', '0'),
('5800', '20', '98', '1', '2024-02-17 12:03:59', 'Update Supplier Allocations', '13', '2024-02-17', '0', '0', '0'),
('5801', '3040', '0', '1', '2024-02-19 09:06:12', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5802', '30', '38', '1', '2024-02-19 09:25:11', 'Delete Sales Order', '13', '0020-00-17', NULL, '0', '0'),
('5803', '40', '50', '1', '2024-02-17 14:28:25', 'Dimension Deleted', '13', '2024-02-17', NULL, '0', '0'),
('5804', '40', '50', '1', '2024-02-29 23:05:50', 'Dimension Updated', '13', '2024-02-16', NULL, '0', '0'),
('5805', '30', '31', '1', '2024-02-17 14:35:52', 'Update Sales Order', '13', '2024-02-08', NULL, '0', '0'),
('5806', '40', '40', '1', '2024-02-17 14:32:22', 'Dimension Updated', '13', '2024-02-08', '0', '0', '0'),
('5807', '30', '30', '1', '2024-02-17 14:33:03', 'Update Sales Order', '13', '2024-02-08', '0', '0', '0'),
('5808', '30', '31', '1', '2024-02-17 14:35:52', 'Update Sales Order', '13', '2024-02-08', '0', '0', '0'),
('5809', '32', '58', '22', '2024-02-18 18:24:51', 'Sales Quotation is approved', '13', '2024-02-18', '0', '0', '0'),
('5810', '32', '61', '22', '2024-02-18 18:24:53', 'Sales Quotation is approved', '13', '2024-02-18', '0', '0', '0'),
('5811', '1011', '624', '1', '2024-02-20 10:41:23', 'Create Item Codes', '13', '2024-02-19', NULL, '0', '0'),
('5812', '1010', '0', '1', '2024-02-20 10:41:23', 'Create New Item', '13', '2024-02-19', NULL, '0', '0'),
('5813', '1001', '274', '1', '2024-02-19 09:02:21', 'Create New Customer', '13', '2024-02-19', '0', '0', '0'),
('5814', '1002', '269', '1', '2024-02-19 09:02:21', 'Create New Branch', '13', '2024-02-19', '0', '0', '0'),
('5815', '18', '101', '26', '2024-02-19 09:03:32', 'Create New Purchase Order', '13', '2024-02-19', '0', '0', '59'),
('5816', '3040', '0', '26', '2024-02-19 09:25:11', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5817', '32', '62', '26', '2024-02-19 09:09:49', 'Create New Sales Quotation', '13', '2024-02-19', NULL, '0', '0'),
('5818', '32', '62', '22', '2024-02-19 09:09:49', 'Sales Quotation is approved', '13', '2024-02-19', '0', '0', '0'),
('5819', '40', '51', '26', '2024-03-01 11:19:48', 'Dimension Created', '13', '2024-02-19', NULL, '0', '0'),
('5820', '3040', '0', '26', '2024-02-19 14:47:29', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5821', '30', '38', '26', '2024-02-19 09:25:11', 'Create New Sales Order against Quotation no 62', '13', '2024-02-19', '0', '0', '0'),
('5822', '18', '102', '26', '2024-02-19 09:39:37', 'Create New Purchase Order', '13', '2024-02-19', '0', '0', '467'),
('5823', '3040', '0', '26', '2024-02-19 14:47:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5824', '3040', '0', '26', '2024-02-19 14:47:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5825', '3040', '0', '26', '2024-02-19 14:47:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5826', '3040', '0', '26', '2024-02-19 14:47:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5827', '3040', '0', '26', '2024-02-19 14:47:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5828', '3040', '0', '26', '2024-02-19 14:47:29', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5829', '3040', '0', '26', '2024-02-19 14:59:32', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5830', '32', '63', '26', '2024-02-20 09:57:56', 'Create New Sales Quotation', '13', '2024-02-19', NULL, '0', '0'),
('5831', '40', '52', '26', '2024-02-19 14:59:32', 'Dimension Created', '13', '2024-02-19', '0', '0', '0'),
('5832', '3040', '0', '26', '2024-02-19 15:21:27', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5833', '30', '39', '26', '2024-02-19 14:59:32', 'Create New Sales Order against Quotation no 60', '13', '2024-02-19', '0', '0', '0'),
('5834', '13', '33', '1', '2024-02-19 15:15:44', 'Created', '13', '2024-02-19', NULL, '0', '0'),
('5835', '13', '33', '1', '2024-02-19 15:15:44', 'Create Sales Delivery Note against Sales order no 39', '13', '2024-02-19', '0', '0', '0'),
('5836', '10', '34', '1', '2024-02-19 15:15:49', 'Created', '13', '2024-02-19', NULL, '0', '0'),
('5837', '10', '34', '1', '2024-02-20 10:09:13', 'Create Sales Invoice against Sales Delivery note 33', '13', '2024-02-19', NULL, '0', '0'),
('5838', '40', '53', '26', '2024-02-19 15:21:27', 'Dimension Created', '13', '2024-02-19', '0', '0', '0'),
('5839', '3040', '0', '26', '2024-02-20 14:56:31', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('5840', '30', '40', '26', '2024-02-19 15:21:27', 'Create New Sales Order against Quotation no 57', '13', '2024-02-19', '0', '0', '0'),
('5841', '13', '34', '1', '2024-02-19 16:36:51', 'Created', '13', '2024-02-19', NULL, '0', '0'),
('5842', '13', '34', '1', '2024-02-19 16:36:51', 'Create Sales Delivery Note against Sales order no 37', '13', '2024-02-19', '0', '0', '0'),
('5843', '10', '35', '1', '2024-02-19 16:36:58', 'Created', '13', '2024-02-19', NULL, '0', '0'),
('5844', '10', '35', '1', '2024-02-19 16:36:58', 'Create Sales Invoice against Sales Delivery note 34', '13', '2024-02-19', '0', '0', '0'),
('5845', '12', '36', '1', '2024-02-20 09:37:17', 'Created', '13', '2024-02-19', '0', '0', '0'),
('5846', '12', '234', '1', '2024-02-20 09:37:17', 'Update Customer Payment', '13', '2024-02-20', NULL, '0', '0'),
('5847', '12', '234', '1', '2024-02-20 09:37:17', 'Create Customer Payment', '13', '2024-02-20', '0', '0', '0'),
('5848', '12', '240', '1', '2024-02-20 09:42:37', 'Update Customer Payment', '13', '2024-02-20', NULL, '0', '0'),
('5849', '12', '240', '1', '2024-02-20 09:43:13', 'Create Customer Payment', '13', '2024-02-20', NULL, '0', '0'),
('5850', '12', '37', '1', '2024-02-20 09:43:13', 'Created', '13', '2024-02-19', '0', '0', '0'),
('5851', '12', '240', '1', '2024-02-20 09:43:13', 'Update Customer Payment', '13', '2024-02-20', NULL, '0', '0'),
('5852', '12', '240', '1', '2024-02-20 09:43:13', 'Create Customer Payment', '13', '2024-02-20', NULL, '0', '0'),
('5853', '12', '240', '1', '2024-02-20 09:43:13', 'Create Customer Payment', '13', '2024-02-20', '0', '0', '0'),
('5854', '32', '63', '22', '2024-02-20 09:57:56', 'Sales Quotation is approved', '13', '2024-02-20', '0', '0', '0'),
('5855', '10', '34', '1', '2024-02-20 10:09:13', 'Updated.', '13', '2024-02-19', NULL, '0', '0'),
('5856', '10', '34', '1', '2024-02-20 10:09:13', 'Update Sales Delivery Note', '13', '2024-02-20', NULL, '0', '0'),
('5857', '10', '34', '1', '2024-02-20 10:09:13', 'Create Sales Invoice', '13', '2024-02-20', '0', '0', '0'),
('5858', '1', '3', '1', '2024-02-26 10:57:48', 'Bank Payment Processed', '0', '2024-01-27', NULL, '0', '0'),
('5859', '1', '0', '1', '2024-02-20 10:20:47', 'Update Bank Payment', '13', '2024-02-20', NULL, '0', '0'),
('5860', '1', '2', '1', '2024-02-20 10:09:13', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5861', '1', '4', '1', '2024-02-26 10:57:18', 'Bank Payment Processed', '0', '2024-01-01', NULL, '0', '0'),
('5862', '0', '44', '1', '2024-02-20 10:13:48', 'Journal Entry Added', '13', '2024-01-05', '0', '0', '0'),
('5863', '1', '5', '1', '2024-02-20 10:14:34', 'Bank Payment Processed', '13', '2024-01-09', '0', '0', '0'),
('5864', '1', '6', '1', '2024-02-20 10:16:34', 'Bank Payment Processed', '13', '2024-01-16', '0', '0', '0'),
('5865', '1', '7', '1', '2024-02-20 10:20:47', 'Bank Payment Processed', '13', '2024-01-27', NULL, '0', '0'),
('5866', '1', '8', '1', '2024-02-20 10:18:59', 'Bank Payment Processed', '13', '2024-01-27', '0', '0', '0'),
('5867', '1', '9', '1', '2024-02-20 10:20:47', 'Bank Payment Processed', '13', '2024-01-27', '0', '0', '0'),
('5868', '1', '0', '1', '2024-02-20 10:20:47', 'Update Bank Payment', '13', '2024-02-20', '0', '0', '0'),
('5869', '1', '7', '1', '2024-02-20 10:20:47', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5870', '1028', '21010', '1', '2024-02-20 10:26:16', 'Account Data Added', '13', '2024-02-20', NULL, '0', '0'),
('5871', '1028', '21010', '1', '2024-02-20 10:26:16', 'Account Data Deleted', '13', '2024-02-20', '0', '0', '0'),
('5872', '0', '45', '1', '2024-02-20 10:28:07', 'Journal Entry Added', '13', '2024-01-31', '0', '0', '0'),
('5873', '0', '46', '1', '2024-02-20 10:30:09', 'Journal Entry Added', '13', '2024-02-01', '0', '0', '0'),
('5874', '1010', '0', '1', '2024-02-20 10:41:34', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5875', '1011', '624', '1', '2024-02-20 10:41:34', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5876', '1010', '0', '1', '2024-02-20 10:42:26', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5877', '1011', '624', '1', '2024-02-20 10:42:26', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5878', '1010', '0', '1', '2024-02-20 10:43:22', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5879', '1011', '624', '1', '2024-02-20 10:43:23', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5880', '1010', '0', '1', '2024-02-20 10:43:37', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5881', '1011', '624', '1', '2024-02-20 10:43:37', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5882', '1010', '0', '1', '2024-02-20 10:43:47', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5883', '1011', '624', '1', '2024-02-20 10:43:47', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5884', '1010', '0', '1', '2024-02-20 10:43:59', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5885', '1011', '624', '1', '2024-02-20 10:43:59', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5886', '1010', '0', '1', '2024-02-20 10:47:40', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5887', '1011', '624', '1', '2024-02-20 10:47:40', 'Update Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5888', '1010', '0', '1', '2024-02-20 16:28:18', 'Update Item', '13', '2024-02-20', NULL, '0', '0'),
('5889', '1011', '624', '1', '2024-02-20 10:47:40', 'Update Item Codes', '13', '2024-02-20', '0', '0', '0'),
('5890', '20', '12', '1', '2024-02-20 10:49:57', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5891', '20', '100', '1', '2024-02-24 16:34:24', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('5892', '0', '28', '1', '2024-02-20 11:02:13', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5893', '0', '47', '1', '2024-02-21 10:09:23', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('5894', '0', '29', '1', '2024-02-20 11:02:32', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5895', '0', '48', '1', '2024-02-27 10:24:46', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('5896', '0', '30', '1', '2024-02-20 11:02:49', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5897', '0', '49', '1', '2024-02-24 16:34:24', 'Journal Entry Added', '13', '2024-01-24', NULL, '0', '0'),
('5898', '0', '42', '1', '2024-02-20 11:05:01', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5899', '0', '50', '1', '2024-02-20 11:05:01', 'Journal Entry Added', '13', '2024-01-31', '0', '0', '0'),
('5900', '0', '43', '1', '2024-02-20 11:05:31', 'Voided.\nDocument reentered.', '13', '2024-02-20', '0', '0', '0'),
('5901', '0', '51', '1', '2024-02-20 11:05:31', 'Journal Entry Added', '13', '2024-02-17', '0', '0', '0'),
('5902', '40', '54', '1', '2024-02-20 11:27:47', 'Dimension Created', '12', '2023-09-19', '0', '0', '0'),
('5903', '1001', '275', '1', '2024-02-20 14:41:21', 'Create New Customer', '13', '2024-02-20', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('5904', '1002', '270', '1', '2024-02-20 14:41:21', 'Create New Branch', '13', '2024-02-20', '0', '0', '0'),
('5905', '1001', '276', '1', '2024-02-20 14:49:05', 'Create New Customer', '13', '2024-02-20', '0', '0', '0'),
('5906', '1002', '271', '1', '2024-02-20 14:49:05', 'Create New Branch', '13', '2024-02-20', '0', '0', '0'),
('5907', '3040', '0', '26', '2024-02-20 16:48:04', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5908', '32', '64', '26', '2024-02-21 10:25:32', 'Create New Sales Quotation', '13', '2024-02-20', NULL, '0', '0'),
('5909', '18', '103', '22', '2024-02-20 16:30:50', 'Create New Purchase Order', '13', '2024-02-20', NULL, '0', '0'),
('5910', '1011', '625', '22', '2024-02-21 10:12:54', 'Create Item Codes', '13', '2024-02-20', NULL, '0', '0'),
('5911', '1010', '0', '22', '2024-02-21 10:12:54', 'Create New Item', '13', '2024-02-20', NULL, '0', '0'),
('5912', '18', '103', '22', '2024-02-20 16:30:50', 'Update Purchase Order', '13', '2024-02-20', '0', '0', '131'),
('5913', '3040', '0', '26', '2024-02-20 16:48:04', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5914', '3040', '0', '26', '2024-02-20 16:52:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5915', '32', '65', '26', '2024-02-20 17:51:21', 'Create New Sales Quotation', '13', '2024-02-20', NULL, '0', '0'),
('5916', '3040', '0', '26', '2024-02-20 16:52:24', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5917', '3040', '0', '26', '2024-02-21 10:20:38', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('5918', '32', '66', '26', '2024-02-20 17:51:22', 'Create New Sales Quotation', '13', '2024-02-20', NULL, '0', '0'),
('5919', '32', '65', '22', '2024-02-20 17:51:21', 'Sales Quotation is approved', '13', '2024-02-20', '0', '0', '0'),
('5920', '32', '66', '22', '2024-02-28 11:08:04', 'Sales Quotation is approved', '13', '2024-02-20', NULL, '0', '0'),
('5921', '20', '64', '1', '2024-02-21 09:18:19', 'Voided.\n', '13', '2024-02-21', '0', '0', '0'),
('5922', '25', '55', '1', '2024-02-21 09:19:25', 'Voided.\n', '13', '2024-02-21', '0', '0', '0'),
('5923', '20', '90', '1', '2024-02-21 09:20:38', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('5924', '20', '101', '1', '2024-02-21 09:21:39', 'Create New Supplier Invoice', '13', '2024-02-08', NULL, '0', '0'),
('5925', '20', '101', '1', '2024-02-21 09:21:39', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('5926', '20', '102', '1', '2024-02-22 11:42:15', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('5927', '25', '84', '1', '2024-02-21 09:22:13', 'Suplier Recive against Purchase order 39.', '13', '2024-02-08', '0', '0', '0'),
('5928', '20', '103', '1', '2024-02-22 11:52:24', 'Create Supplier Invoice against receival 1.', '13', '2024-02-08', NULL, '0', '0'),
('5929', '1009', '143', '1', '2024-02-21 09:29:35', 'Add New Supplier', '13', '2024-02-21', '0', '0', '0'),
('5930', '18', '104', '1', '2024-02-21 09:33:41', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '277'),
('5931', '25', '85', '1', '2024-02-21 09:33:41', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5932', '20', '104', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5933', '18', '105', '1', '2024-02-21 09:35:36', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '437'),
('5934', '25', '86', '1', '2024-02-21 09:35:36', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5935', '20', '105', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5936', '18', '106', '1', '2024-02-21 09:36:33', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5937', '25', '87', '1', '2024-02-21 09:36:33', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5938', '20', '106', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5939', '18', '107', '1', '2024-02-21 09:50:31', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5940', '25', '88', '1', '2024-02-21 09:50:31', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5941', '20', '107', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5942', '18', '108', '1', '2024-02-21 09:53:27', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5943', '25', '89', '1', '2024-02-21 09:53:27', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5944', '20', '108', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5945', '1001', '277', '1', '2024-02-21 09:53:43', 'Create New Customer', '13', '2024-02-21', '0', '0', '0'),
('5946', '1002', '272', '1', '2024-02-21 09:53:43', 'Create New Branch', '13', '2024-02-21', '0', '0', '0'),
('5947', '18', '109', '1', '2024-02-21 09:54:10', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5948', '25', '90', '1', '2024-02-21 09:54:10', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5949', '20', '109', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5950', '18', '110', '1', '2024-02-21 09:54:51', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5951', '25', '91', '1', '2024-02-21 09:54:51', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5952', '20', '110', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5953', '18', '111', '1', '2024-02-21 09:55:28', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5954', '25', '92', '1', '2024-02-21 09:55:28', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5955', '20', '111', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5956', '18', '112', '1', '2024-02-21 09:56:19', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '53'),
('5957', '25', '93', '1', '2024-02-21 09:56:19', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5958', '20', '112', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5959', '18', '113', '1', '2024-02-21 09:57:51', 'Create Auto Purchase Order', '13', '2024-02-21', '0', '0', '296'),
('5960', '25', '94', '1', '2024-02-21 09:57:51', 'Auto Suplier Recive Processed', '13', '2024-02-21', '0', '0', '0'),
('5961', '20', '113', '1', '2024-02-21 10:08:34', 'Create New Supplier Invoice', '13', '2024-02-21', NULL, '0', '0'),
('5962', '0', '52', '1', '2024-02-21 10:08:34', 'Journal Entry Added', '13', '2024-02-21', NULL, '0', '0'),
('5963', '20', '21', '1', '2024-02-22 16:26:33', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5964', '20', '104', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5965', '20', '22', '1', '2024-02-22 16:27:01', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5966', '20', '105', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5967', '20', '23', '1', '2024-02-22 16:27:29', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5968', '20', '106', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5969', '20', '24', '1', '2024-02-22 16:27:55', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5970', '20', '107', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5971', '20', '25', '1', '2024-02-22 16:32:56', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5972', '20', '108', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5973', '20', '26', '1', '2024-02-22 16:33:31', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5974', '20', '109', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5975', '20', '27', '1', '2024-02-22 16:34:06', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5976', '20', '110', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5977', '20', '28', '1', '2024-02-22 16:34:41', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5978', '20', '111', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5979', '20', '29', '1', '2024-02-21 10:08:34', 'Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5980', '20', '112', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5981', '20', '30', '1', '2024-02-21 10:08:34', 'Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5982', '20', '113', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5983', '0', '52', '1', '2024-02-21 10:08:34', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5984', '20', '31', '1', '2024-02-22 16:35:16', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5985', '20', '1', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5986', '20', '32', '1', '2024-02-21 10:09:23', 'Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5987', '20', '2', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5988', '20', '33', '1', '2024-02-21 10:09:23', 'Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5989', '20', '3', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5990', '20', '34', '1', '2024-02-22 16:35:45', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5991', '20', '4', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5992', '20', '35', '1', '2024-02-22 16:36:48', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5993', '20', '7', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5994', '20', '36', '1', '2024-02-22 16:38:35', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5995', '20', '8', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5996', '20', '37', '1', '2024-02-22 16:43:18', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5997', '20', '9', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('5998', '20', '38', '1', '2024-02-22 16:44:04', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('5999', '20', '13', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('6000', '20', '39', '1', '2024-02-22 16:44:27', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('6001', '20', '14', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('6002', '20', '40', '1', '2024-02-22 16:45:13', 'Supplier Allocations', '13', '2024-02-21', NULL, '0', '0'),
('6003', '20', '16', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('6004', '0', '47', '1', '2024-02-21 10:09:23', 'Update Supplier Allocations', '13', '2024-02-21', '0', '0', '0'),
('6005', '1010', '0', '1', '2024-02-21 10:33:42', 'Update Item', '13', '2024-02-21', NULL, '0', '0'),
('6006', '1011', '625', '1', '2024-02-21 10:33:42', 'Update Item Codes', '13', '2024-02-21', NULL, '0', '0'),
('6007', '20', '48', '1', '2024-02-21 10:15:07', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6008', '20', '114', '1', '2024-02-21 10:15:07', 'Create New Supplier Invoice', '13', '2024-01-05', '0', '0', '0'),
('6009', '20', '50', '1', '2024-02-21 10:15:35', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6010', '20', '115', '1', '2024-02-21 10:16:59', 'Create New Supplier Invoice', '13', '2024-01-05', NULL, '0', '0'),
('6011', '20', '94', '1', '2024-02-21 10:16:31', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6012', '20', '116', '1', '2024-02-21 10:16:31', 'Create New Supplier Invoice', '13', '2024-01-05', '0', '0', '0'),
('6013', '20', '115', '1', '2024-02-21 10:16:59', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6014', '20', '117', '1', '2024-02-21 10:16:59', 'Create New Supplier Invoice', '13', '2024-01-05', '0', '0', '0'),
('6015', '20', '51', '1', '2024-02-21 10:17:18', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6016', '20', '118', '1', '2024-02-21 10:17:18', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('6017', '20', '52', '1', '2024-02-21 10:17:43', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6018', '20', '119', '1', '2024-02-21 10:17:43', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('6019', '20', '53', '1', '2024-02-21 10:18:03', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6020', '20', '120', '1', '2024-02-21 10:18:03', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('6021', '20', '54', '1', '2024-02-21 10:18:35', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6022', '20', '121', '1', '2024-02-21 10:18:35', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('6023', '20', '56', '1', '2024-02-21 10:18:53', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6024', '20', '122', '1', '2024-02-21 10:18:53', 'Create New Supplier Invoice', '13', '2024-01-09', '0', '0', '0'),
('6025', '20', '60', '1', '2024-02-21 10:19:22', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6026', '20', '123', '1', '2024-02-21 10:19:22', 'Create New Supplier Invoice', '13', '2024-01-16', '0', '0', '0'),
('6027', '20', '61', '1', '2024-02-21 10:19:35', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6028', '20', '124', '1', '2024-02-21 10:19:35', 'Create New Supplier Invoice', '13', '2024-01-16', '0', '0', '0'),
('6029', '20', '62', '1', '2024-02-21 10:19:55', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6030', '20', '125', '1', '2024-02-21 10:19:55', 'Create New Supplier Invoice', '13', '2024-01-16', '0', '0', '0'),
('6031', '20', '63', '1', '2024-02-21 10:20:12', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6032', '20', '126', '1', '2024-02-21 10:20:12', 'Create New Supplier Invoice', '13', '2024-01-16', '0', '0', '0'),
('6033', '3040', '0', '26', '2024-02-22 11:55:23', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6034', '32', '67', '26', '2024-02-21 10:24:24', 'Create New Sales Quotation', '13', '2024-02-21', NULL, '0', '0'),
('6035', '32', '67', '22', '2024-02-21 10:24:24', 'Sales Quotation is approved', '13', '2024-02-21', '0', '0', '0'),
('6036', '32', '64', '22', '2024-02-21 10:25:32', 'Sales Quotation is approved', '13', '2024-02-21', '0', '0', '0'),
('6037', '1010', '0', '1', '2024-02-22 14:13:22', 'Update Item', '13', '2024-02-21', NULL, '0', '0'),
('6038', '1011', '625', '1', '2024-02-21 10:33:42', 'Update Item Codes', '13', '2024-02-21', '0', '0', '0'),
('6039', '20', '96', '1', '2024-02-21 10:33:59', 'Voided.\nDocument reentered.', '13', '2024-02-21', '0', '0', '0'),
('6040', '20', '127', '1', '2024-02-22 11:53:00', 'Create New Supplier Invoice', '13', '2024-02-05', NULL, '0', '0'),
('6041', '1001', '278', '1', '2024-02-21 16:06:44', 'Create New Customer', '13', '2024-02-21', '0', '0', '0'),
('6042', '1002', '273', '1', '2024-02-21 16:06:44', 'Create New Branch', '13', '2024-02-21', '0', '0', '0'),
('6043', '1002', '274', '1', '2024-02-21 16:07:34', 'Create New Branch', '13', '2024-02-21', NULL, '0', '0'),
('6044', '1002', '274', '1', '2024-02-21 16:07:34', 'Delete Branch', '13', '2024-02-21', '0', '0', '0'),
('6045', '1002', '275', '1', '2024-02-26 11:41:00', 'Update Branch', '13', '2024-02-21', NULL, '0', '0'),
('6046', '18', '114', '26', '2024-03-01 10:50:14', 'Create New Purchase Order', '13', '2024-02-22', NULL, '0', '271'),
('6047', '40', '28', '1', '2024-02-22 11:39:36', 'Dimension Updated', '13', '2024-01-24', '0', '0', '0'),
('6048', '20', '86', '1', '2024-02-22 11:40:34', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6049', '20', '128', '1', '2024-02-22 11:40:34', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6050', '20', '93', '1', '2024-02-22 11:40:49', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6051', '20', '129', '1', '2024-02-22 11:40:49', 'Create New Supplier Invoice', '13', '2024-02-15', '0', '0', '0'),
('6052', '20', '102', '1', '2024-02-22 11:42:15', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6053', '20', '130', '1', '2024-02-22 11:53:26', 'Create New Supplier Invoice', '13', '2024-01-24', NULL, '0', '0'),
('6054', '12', '0', '1', '2024-02-22 11:44:56', 'Update Customer Payment', '13', '2024-02-22', NULL, '0', '0'),
('6055', '12', '0', '1', '2024-02-23 10:14:25', 'Update Customer Payment', '13', '2024-02-22', NULL, '0', '0'),
('6056', '12', '26', '1', '2024-02-22 11:44:56', 'Updated.', '13', '2024-02-06', '0', '0', '0'),
('6057', '12', '198', '1', '2024-02-22 11:44:56', 'Update Customer Payment', '13', '2024-02-22', NULL, '0', '0'),
('6058', '12', '198', '1', '2024-02-22 11:44:56', 'Create Customer Payment', '13', '2024-02-22', '0', '0', '0'),
('6059', '20', '91', '1', '2024-02-22 11:48:47', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6060', '20', '131', '1', '2024-02-22 11:54:00', 'Create New Supplier Invoice', '13', '2024-02-08', NULL, '0', '0'),
('6061', '20', '92', '1', '2024-02-22 11:51:50', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6062', '20', '132', '1', '2024-02-22 11:51:50', 'Create New Supplier Invoice', '13', '2024-02-08', '0', '0', '0'),
('6063', '20', '103', '1', '2024-02-22 11:52:24', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6064', '20', '133', '1', '2024-02-22 11:52:24', 'Create New Supplier Invoice', '13', '2024-02-08', '0', '0', '0'),
('6065', '20', '127', '1', '2024-02-22 11:53:00', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6066', '20', '134', '1', '2024-02-22 11:53:00', 'Create New Supplier Invoice', '13', '2024-02-05', '0', '0', '0'),
('6067', '20', '130', '1', '2024-02-22 11:53:26', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6068', '20', '135', '1', '2024-02-22 11:53:26', 'Create New Supplier Invoice', '13', '2024-01-24', '0', '0', '0'),
('6069', '20', '131', '1', '2024-02-22 11:54:00', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6070', '20', '136', '1', '2024-02-22 11:54:00', 'Create New Supplier Invoice', '13', '2024-02-08', '0', '0', '0'),
('6071', '40', '55', '26', '2024-02-22 11:55:23', 'Dimension Created', '13', '2024-02-22', '0', '0', '0'),
('6072', '3040', '0', '26', '2024-02-22 12:32:42', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6073', '30', '41', '26', '2024-02-22 11:55:23', 'Create New Sales Order against Quotation no 67', '13', '2024-02-22', '0', '0', '0'),
('6074', '3040', '0', '26', '2024-02-22 13:27:03', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6075', '32', '68', '26', '2024-02-22 13:01:25', 'Create New Sales Quotation', '13', '2024-02-22', NULL, '0', '0'),
('6076', '32', '68', '22', '2024-02-22 13:01:25', 'Sales Quotation is approved', '13', '2024-02-22', '0', '0', '0'),
('6077', '40', '56', '26', '2024-02-22 13:27:03', 'Dimension Created', '13', '2024-02-22', '0', '0', '0'),
('6078', '3040', '0', '26', '2024-02-23 08:21:20', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6079', '30', '42', '26', '2024-02-22 13:27:03', 'Create New Sales Order against Quotation no 68', '13', '2024-02-22', '0', '0', '0'),
('6080', '1011', '626', '1', '2024-02-22 14:13:22', 'Create Item Codes', '13', '2024-02-22', '0', '0', '0'),
('6081', '1010', '0', '1', '2024-02-23 14:49:19', 'Create New Item', '13', '2024-02-22', NULL, '0', '0'),
('6082', '18', '115', '26', '2024-02-22 14:16:26', 'Create New Purchase Order', '13', '2024-02-22', '0', '0', '669'),
('6083', '18', '116', '26', '2024-02-22 14:29:14', 'Create New Purchase Order', '13', '2024-02-22', '0', '0', '59'),
('6084', '20', '17', '1', '2024-02-22 16:24:26', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6085', '20', '137', '1', '2024-02-22 16:24:26', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6086', '20', '18', '1', '2024-02-22 16:25:07', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6087', '20', '138', '1', '2024-02-22 16:25:07', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6088', '20', '19', '1', '2024-02-22 16:25:35', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6089', '20', '139', '1', '2024-02-22 16:25:35', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6090', '20', '20', '1', '2024-02-22 16:26:01', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6091', '20', '140', '1', '2024-02-22 16:26:01', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6092', '20', '21', '1', '2024-02-22 16:26:33', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6093', '20', '141', '1', '2024-02-22 16:26:33', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6094', '20', '22', '1', '2024-02-22 16:27:01', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6095', '20', '142', '1', '2024-02-22 16:27:01', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6096', '20', '23', '1', '2024-02-22 16:27:29', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6097', '20', '143', '1', '2024-02-22 16:27:29', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6098', '20', '24', '1', '2024-02-22 16:27:55', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6099', '20', '144', '1', '2024-02-22 16:31:53', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('6100', '20', '144', '1', '2024-02-22 16:31:53', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6101', '20', '145', '1', '2024-02-22 16:31:53', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6102', '20', '25', '1', '2024-02-22 16:32:56', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6103', '20', '146', '1', '2024-02-22 16:32:56', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6104', '20', '26', '1', '2024-02-22 16:33:31', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6105', '20', '147', '1', '2024-02-22 16:33:31', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6106', '20', '27', '1', '2024-02-22 16:34:06', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6107', '20', '148', '1', '2024-02-22 16:34:06', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6108', '20', '28', '1', '2024-02-22 16:34:41', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6109', '20', '149', '1', '2024-02-22 16:34:41', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6110', '20', '31', '1', '2024-02-22 16:35:16', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6111', '20', '150', '1', '2024-02-22 16:35:16', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6112', '20', '34', '1', '2024-02-22 16:35:45', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6113', '20', '151', '1', '2024-02-22 16:35:45', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6114', '20', '35', '1', '2024-02-22 16:36:48', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6115', '20', '152', '1', '2024-02-22 16:38:07', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('6116', '20', '152', '1', '2024-02-22 16:38:07', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6117', '20', '153', '1', '2024-02-22 16:38:07', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6118', '20', '36', '1', '2024-02-22 16:38:35', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6119', '20', '154', '1', '2024-02-22 16:38:35', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6120', '20', '37', '1', '2024-02-22 16:43:18', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6121', '20', '155', '1', '2024-02-22 16:43:18', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6122', '20', '38', '1', '2024-02-22 16:44:04', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6123', '20', '156', '1', '2024-02-22 16:44:04', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6124', '20', '39', '1', '2024-02-22 16:44:27', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6125', '20', '157', '1', '2024-02-22 16:44:27', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6126', '20', '40', '1', '2024-02-22 16:45:13', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6127', '20', '158', '1', '2024-02-22 16:45:13', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6128', '20', '41', '1', '2024-02-24 16:34:16', 'Voided.\nDocument reentered.', '13', '2024-02-22', NULL, '0', '0'),
('6129', '20', '159', '1', '2024-02-22 16:46:10', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6130', '20', '42', '1', '2024-02-24 16:34:24', 'Voided.\nDocument reentered.', '13', '2024-02-22', NULL, '0', '0'),
('6131', '20', '160', '1', '2024-02-22 17:12:17', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6132', '20', '43', '1', '2024-02-27 10:24:19', 'Voided.\nDocument reentered.', '13', '2024-02-22', NULL, '0', '0'),
('6133', '20', '161', '1', '2024-02-22 17:12:53', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6134', '20', '44', '1', '2024-02-27 10:24:46', 'Voided.\nDocument reentered.', '13', '2024-02-22', NULL, '0', '0'),
('6135', '20', '162', '1', '2024-02-22 17:13:25', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6136', '20', '45', '1', '2024-02-27 11:12:38', 'Voided.\nDocument reentered.', '13', '2024-02-22', NULL, '0', '0'),
('6137', '20', '163', '1', '2024-02-22 19:31:35', 'Create New Supplier Invoice', '13', '2024-01-31', NULL, '0', '0'),
('6138', '20', '47', '1', '2024-02-22 17:15:03', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6139', '20', '164', '1', '2024-02-22 17:15:03', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6140', '20', '163', '25', '2024-02-22 19:31:35', 'Voided.\nDocument reentered.', '13', '2024-02-22', '0', '0', '0'),
('6141', '20', '165', '25', '2024-02-22 19:31:35', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6142', '3040', '0', '26', '2024-02-23 08:24:23', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6143', '32', '69', '26', '2024-02-23 09:18:07', 'Create New Sales Quotation', '13', '2024-02-23', NULL, '0', '0'),
('6144', '40', '57', '26', '2024-02-23 08:24:23', 'Dimension Created', '13', '2024-02-23', '0', '0', '0'),
('6145', '3040', '0', '26', '2024-02-23 08:24:23', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6146', '3040', '0', '26', '2024-02-23 08:24:23', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6147', '3040', '0', '26', '2024-02-23 08:24:23', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6148', '3040', '0', '26', '2024-02-23 08:24:23', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6149', '3040', '0', '26', '2024-02-23 08:24:23', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6150', '3040', '0', '26', '2024-02-23 08:24:23', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6151', '3040', '0', '26', '2024-02-24 11:13:40', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6152', '30', '43', '26', '2024-02-23 08:24:23', 'Create New Sales Order against Quotation no 63', '13', '2024-02-23', '0', '0', '0'),
('6153', '32', '69', '22', '2024-02-23 09:18:07', 'Sales Quotation is approved', '13', '2024-02-23', '0', '0', '0'),
('6154', '12', '38', '1', '2024-02-23 09:51:29', 'Created', '13', '2024-02-23', '0', '0', '0'),
('6155', '12', '272', '1', '2024-02-23 09:51:29', 'Update Customer Payment', '13', '2024-02-23', '0', '0', '0'),
('6156', '13', '35', '1', '2024-02-23 09:52:21', 'Created', '13', '2024-02-23', NULL, '0', '0'),
('6157', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', NULL, '0', '0'),
('6158', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', NULL, '0', '0'),
('6159', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', NULL, '0', '0'),
('6160', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', NULL, '0', '0'),
('6161', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', NULL, '0', '0'),
('6162', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', NULL, '0', '0'),
('6163', '13', '35', '1', '2024-02-23 09:52:21', 'Create Sales Delivery Note against Sales order no 43', '13', '2024-02-23', '0', '0', '0'),
('6164', '10', '36', '1', '2024-02-23 09:52:28', 'Created', '13', '2024-02-23', NULL, '0', '0'),
('6165', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', NULL, '0', '0'),
('6166', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', NULL, '0', '0'),
('6167', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', NULL, '0', '0'),
('6168', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', NULL, '0', '0'),
('6169', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', NULL, '0', '0'),
('6170', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', NULL, '0', '0'),
('6171', '10', '36', '1', '2024-02-23 09:52:28', 'Create Sales Invoice against Sales Delivery note 35', '13', '2024-02-23', '0', '0', '0'),
('6172', '12', '39', '1', '2024-02-23 10:14:25', 'Created', '13', '2024-02-23', NULL, '0', '0'),
('6173', '12', '273', '1', '2024-02-23 09:53:52', 'Update Customer Payment', '13', '2024-02-23', NULL, '0', '0'),
('6174', '12', '273', '1', '2024-02-23 10:14:25', 'Create Customer Payment', '13', '2024-02-23', NULL, '0', '0'),
('6175', '12', '0', '1', '2024-02-23 10:14:25', 'Update Customer Payment', '13', '2024-02-23', NULL, '0', '0'),
('6176', '12', '0', '1', '2024-02-23 10:14:25', 'Update Customer Payment', '13', '2024-02-23', '0', '0', '0'),
('6177', '12', '39', '1', '2024-02-23 10:14:25', 'Updated.', '13', '2024-02-23', '0', '0', '0'),
('6178', '12', '273', '1', '2024-02-23 10:14:25', 'Update Customer Payment', '13', '2024-02-23', NULL, '0', '0'),
('6179', '12', '273', '1', '2024-02-23 10:14:25', 'Create Customer Payment', '13', '2024-02-23', '0', '0', '0'),
('6180', '18', '117', '1', '2024-02-23 11:09:54', 'Create Auto Purchase Order', '13', '2024-02-22', '0', '0', '630'),
('6181', '25', '95', '1', '2024-02-23 11:09:54', 'Auto Suplier Recive Processed', '13', '2024-02-22', '0', '0', '0'),
('6182', '20', '166', '1', '2024-02-23 11:09:54', 'Create New Supplier Invoice', '13', '2024-02-22', '0', '0', '0'),
('6183', '0', '53', '1', '2024-02-23 11:35:24', 'Journal Entry Added', '13', '2024-01-01', '0', '0', '0'),
('6184', '18', '118', '26', '2024-02-23 14:42:34', 'Create New Purchase Order', '13', '2024-02-23', NULL, '0', '90'),
('6185', '18', '118', '22', '2024-02-23 14:42:34', 'Update Purchase Order', '13', '2024-02-23', '0', '0', '90'),
('6186', '1011', '627', '1', '2024-02-23 15:44:34', 'Create Item Codes', '13', '2024-02-23', NULL, '0', '0'),
('6187', '1010', '0', '1', '2024-02-23 15:44:34', 'Create New Item', '13', '2024-02-23', NULL, '0', '0'),
('6188', '1010', '0', '22', '2024-02-23 15:46:02', 'Update Item', '13', '2024-02-23', NULL, '0', '0'),
('6189', '1011', '627', '22', '2024-02-23 15:44:34', 'Update Item Codes', '13', '2024-02-23', '0', '0', '0'),
('6190', '1011', '628', '22', '2024-02-23 15:46:02', 'Create Item Codes', '13', '2024-02-23', '0', '0', '0'),
('6191', '1010', '0', '22', '2024-02-24 14:45:48', 'Create New Item', '13', '2024-02-23', NULL, '0', '0'),
('6192', '18', '119', '22', '2024-02-23 15:49:19', 'Create New Purchase Order', '13', '2024-02-23', '0', '0', '2363'),
('6193', '40', '58', '26', '2024-02-24 11:13:40', 'Dimension Created', '13', '2024-02-24', '0', '0', '0'),
('6194', '3040', '0', '26', '2024-02-24 12:29:08', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6195', '30', '44', '26', '2024-02-24 11:13:40', 'Create New Sales Order against Quotation no 69', '13', '2024-02-24', '0', '0', '0'),
('6196', '13', '36', '1', '2024-02-24 11:22:39', 'Created', '13', '2024-02-24', NULL, '0', '0'),
('6197', '13', '36', '1', '2024-02-24 11:22:39', 'Create Sales Delivery Note against Sales order no 44', '13', '2024-02-24', '0', '0', '0'),
('6198', '10', '37', '1', '2024-02-24 11:22:44', 'Created', '13', '2024-02-24', NULL, '0', '0'),
('6199', '10', '37', '1', '2024-02-24 11:22:44', 'Create Sales Invoice against Sales Delivery note 36', '13', '2024-02-24', '0', '0', '0'),
('6200', '3040', '0', '26', '2024-02-24 17:14:27', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6201', '32', '70', '26', '2024-02-24 17:15:09', 'Create New Sales Quotation', '13', '2024-02-24', NULL, '0', '0'),
('6202', '1011', '629', '22', '2024-02-24 14:47:18', 'Create Item Codes', '13', '2024-02-24', NULL, '0', '0'),
('6203', '1010', '0', '22', '2024-02-24 14:47:18', 'Create New Item', '13', '2024-02-24', NULL, '0', '0'),
('6204', '1010', '0', '22', '2024-02-29 08:49:53', 'Update Item', '13', '2024-02-24', NULL, '0', '0'),
('6205', '1011', '629', '22', '2024-02-24 14:47:18', 'Update Item Codes', '13', '2024-02-24', '0', '0', '0'),
('6206', '18', '120', '22', '2024-02-24 14:51:39', 'Create New Purchase Order', '13', '2024-02-24', '0', '0', '2649'),
('6207', '18', '121', '1', '2024-02-24 16:26:19', 'Create Auto Purchase Order', '13', '2024-02-24', '0', '0', '5743'),
('6208', '25', '96', '1', '2024-02-24 16:26:19', 'Auto Suplier Recive Processed', '13', '2024-02-24', '0', '0', '0'),
('6209', '20', '167', '1', '2024-02-24 16:34:16', 'Create New Supplier Invoice', '13', '2024-02-24', NULL, '0', '0'),
('6210', '0', '54', '1', '2024-02-24 16:34:16', 'Journal Entry Added', '13', '2024-02-24', NULL, '0', '0'),
('6211', '20', '41', '1', '2024-02-24 16:34:16', 'Supplier Allocations', '13', '2024-02-24', '0', '0', '0'),
('6212', '20', '167', '1', '2024-02-24 16:34:16', 'Update Supplier Allocations', '13', '2024-02-24', '0', '0', '0'),
('6213', '0', '54', '1', '2024-02-24 16:34:16', 'Update Supplier Allocations', '13', '2024-02-24', '0', '0', '0'),
('6214', '20', '42', '1', '2024-02-24 16:34:24', 'Supplier Allocations', '13', '2024-02-24', '0', '0', '0'),
('6215', '20', '100', '1', '2024-02-24 16:34:24', 'Update Supplier Allocations', '13', '2024-02-24', '0', '0', '0'),
('6216', '0', '49', '1', '2024-02-24 16:34:24', 'Update Supplier Allocations', '13', '2024-02-24', '0', '0', '0'),
('6217', '3040', '0', '26', '2024-02-24 17:15:55', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6218', '32', '71', '26', '2024-02-24 17:15:10', 'Create New Sales Quotation', '13', '2024-02-24', NULL, '0', '0'),
('6219', '32', '70', '22', '2024-02-24 17:15:09', 'Sales Quotation is approved', '13', '2024-02-24', '0', '0', '0'),
('6220', '32', '71', '22', '2024-02-24 17:15:10', 'Sales Quotation is approved', '13', '2024-02-24', '0', '0', '0'),
('6221', '40', '59', '26', '2024-02-24 17:15:55', 'Dimension Created', '13', '2024-02-24', '0', '0', '0'),
('6222', '3040', '0', '26', '2024-02-24 17:16:26', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6223', '30', '45', '26', '2024-02-24 17:15:55', 'Create New Sales Order against Quotation no 70', '13', '2024-02-24', '0', '0', '0'),
('6224', '40', '60', '26', '2024-02-24 17:16:26', 'Dimension Created', '13', '2024-02-24', '0', '0', '0'),
('6225', '3040', '0', '26', '2024-02-26 08:50:47', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6226', '30', '46', '26', '2024-02-24 17:16:26', 'Create New Sales Order against Quotation no 71', '13', '2024-02-24', '0', '0', '0'),
('6227', '13', '37', '1', '2024-02-24 17:17:51', 'Created', '13', '2024-02-24', NULL, '0', '0'),
('6228', '13', '37', '1', '2024-02-24 17:17:51', 'Create Sales Delivery Note against Sales order no 45', '13', '2024-02-24', '0', '0', '0'),
('6229', '10', '38', '1', '2024-02-24 17:17:55', 'Created', '13', '2024-02-24', NULL, '0', '0'),
('6230', '10', '38', '1', '2024-02-24 17:17:55', 'Create Sales Invoice against Sales Delivery note 37', '13', '2024-02-24', '0', '0', '0'),
('6231', '13', '38', '1', '2024-02-24 17:18:08', 'Created', '13', '2024-02-24', NULL, '0', '0'),
('6232', '13', '38', '1', '2024-02-24 17:18:08', 'Create Sales Delivery Note against Sales order no 46', '13', '2024-02-24', '0', '0', '0'),
('6233', '10', '39', '1', '2024-02-24 17:18:11', 'Created', '13', '2024-02-24', NULL, '0', '0'),
('6234', '10', '39', '1', '2024-02-24 17:18:11', 'Create Sales Invoice against Sales Delivery note 38', '13', '2024-02-24', '0', '0', '0'),
('6235', '18', '122', '26', '2024-02-26 08:34:38', 'Create New Purchase Order', '13', '2024-02-26', NULL, '0', '76'),
('6236', '18', '122', '22', '2024-02-26 08:34:38', 'Update Purchase Order', '13', '2024-02-26', '0', '0', '76'),
('6237', '3040', '0', '26', '2024-02-26 11:46:28', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6238', '32', '72', '26', '2024-02-26 08:56:41', 'Create New Sales Quotation', '13', '2024-02-26', NULL, '0', '0'),
('6239', '32', '72', '22', '2024-02-26 08:56:41', 'Sales Quotation is approved', '13', '2024-02-26', '0', '0', '0'),
('6240', '1028', '3', '1', '2024-02-26 11:16:13', 'Account Data Added', '13', '2024-02-26', NULL, '0', '0'),
('6241', '1028', '4', '1', '2024-02-26 11:16:20', 'Account Data Added', '13', '2024-02-26', NULL, '0', '0'),
('6242', '1', '4', '1', '2024-02-26 10:57:18', 'Bank Account Created', '0', '0000-00-00', '0', '0', '0'),
('6243', '1', '3', '1', '2024-02-26 11:16:06', 'Bank Account Created', '0', '0000-00-00', NULL, '0', '0'),
('6244', '1', '3', '1', '2024-02-26 11:16:08', 'Bank Account Deleted', '0', '0000-00-00', NULL, '0', '0'),
('6245', '1', '3', '1', '2024-02-26 11:16:08', 'Bank Account Deleted', '0', '0000-00-00', '0', '0', '0'),
('6246', '1028', '3', '1', '2024-02-26 11:16:13', 'Account Data Deleted', '13', '2024-02-26', '0', '0', '0'),
('6247', '1028', '4', '1', '2024-02-26 11:16:20', 'Account Data Deleted', '13', '2024-02-26', '0', '0', '0'),
('6248', '1001', '279', '1', '2024-02-26 11:41:00', 'Create New Customer', '13', '2024-02-26', '0', '0', '0'),
('6249', '1002', '275', '1', '2024-02-26 11:41:00', 'Create New Branch', '13', '2024-02-26', '0', '0', '0'),
('6250', '3040', '0', '26', '2024-02-28 08:47:57', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6251', '32', '73', '26', '2024-02-26 12:12:51', 'Create New Sales Quotation', '13', '2024-02-26', NULL, '0', '0'),
('6252', '32', '73', '22', '2024-02-28 09:04:28', 'Sales Quotation is approved', '13', '2024-02-26', NULL, '0', '0'),
('6253', '18', '123', '26', '2024-02-26 17:48:14', 'Create New Purchase Order', '13', '2024-02-26', '0', '0', '25'),
('6254', '18', '124', '1', '2024-02-27 10:19:33', 'Create Auto Purchase Order', '13', '2024-02-27', '0', '0', '472'),
('6255', '25', '97', '1', '2024-02-27 10:19:33', 'Auto Suplier Recive Processed', '13', '2024-02-27', '0', '0', '0'),
('6256', '20', '168', '1', '2024-02-27 10:24:19', 'Create New Supplier Invoice', '13', '2024-02-27', NULL, '0', '0'),
('6257', '0', '55', '1', '2024-02-27 10:24:19', 'Journal Entry Added', '13', '2024-02-27', NULL, '0', '0'),
('6258', '20', '43', '1', '2024-02-27 10:24:19', 'Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6259', '20', '168', '1', '2024-02-27 10:24:19', 'Update Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6260', '0', '55', '1', '2024-02-27 10:24:19', 'Update Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6261', '20', '44', '1', '2024-02-27 10:24:46', 'Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6262', '20', '11', '1', '2024-02-27 10:24:46', 'Update Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6263', '0', '48', '1', '2024-02-27 10:24:46', 'Update Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6264', '18', '125', '1', '2024-02-27 11:12:10', 'Create Auto Purchase Order', '13', '2024-02-27', '0', '0', '1418'),
('6265', '25', '98', '1', '2024-02-27 11:12:10', 'Auto Suplier Recive Processed', '13', '2024-02-27', '0', '0', '0'),
('6266', '20', '169', '1', '2024-02-27 11:12:38', 'Create New Supplier Invoice', '13', '2024-02-27', NULL, '0', '0'),
('6267', '20', '45', '1', '2024-02-27 11:12:38', 'Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6268', '20', '169', '1', '2024-02-27 11:12:38', 'Update Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6269', '0', '3', '1', '2024-02-27 11:12:38', 'Update Supplier Allocations', '13', '2024-02-27', '0', '0', '0'),
('6270', '1002', '74', '1', '2024-02-27 14:50:15', 'Update Branch', '13', '2024-02-27', '0', '0', '0'),
('6271', '1001', '75', '1', '2024-02-27 14:52:52', 'Update Customer', '13', '2024-02-27', '0', '0', '0'),
('6272', '20992', '2', '25', '2024-02-27 20:40:02', 'Access updated', '0', '0000-00-00', '0', '0', '0'),
('6273', '20992', '29', '25', '2024-02-27 20:40:16', 'Access updated', '0', '0000-00-00', '0', '0', '0'),
('6274', '3040', '0', '26', '2024-02-28 09:27:21', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6275', '32', '74', '26', '2024-02-28 09:06:05', 'Create New Sales Quotation', '13', '2024-02-28', NULL, '0', '0'),
('6276', '32', '73', '22', '2024-02-28 09:05:23', 'Update Sales Quotation', '13', '2024-02-26', NULL, '0', '0'),
('6277', '32', '73', '22', '2024-02-28 09:05:23', 'Update Sales Quotation', '13', '2024-02-26', '0', '0', '0'),
('6278', '32', '74', '22', '2024-02-28 09:06:05', 'Sales Quotation is approved', '13', '2024-02-28', '0', '0', '0'),
('6279', '40', '61', '26', '2024-02-28 09:27:21', 'Dimension Created', '13', '2024-02-28', '0', '0', '0'),
('6280', '3040', '0', '26', '2024-02-28 09:27:54', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6281', '30', '47', '26', '2024-02-28 09:27:21', 'Create New Sales Order against Quotation no 73', '13', '2024-02-28', '0', '0', '0'),
('6282', '40', '62', '26', '2024-02-28 09:27:54', 'Dimension Created', '13', '2024-02-28', '0', '0', '0'),
('6283', '3040', '0', '26', '2024-02-28 17:48:20', 'Deal Created', '0', '0000-00-00', NULL, '0', '0'),
('6284', '30', '48', '26', '2024-02-28 09:27:54', 'Create New Sales Order against Quotation no 74', '13', '2024-02-28', '0', '0', '0'),
('6285', '1001', '280', '1', '2024-02-28 10:54:53', 'Create New Customer', '13', '2024-02-28', '0', '0', '0'),
('6286', '1002', '276', '1', '2024-02-28 10:54:53', 'Create New Branch', '13', '2024-02-28', '0', '0', '0'),
('6287', '32', '66', '22', '2024-02-28 11:13:25', 'Update Sales Quotation', '13', '2024-02-20', NULL, '0', '0'),
('6288', '32', '66', '22', '2024-02-28 17:33:02', 'Update Sales Quotation', '13', '2024-02-20', NULL, '0', '0'),
('6289', '32', '66', '22', '2024-02-28 17:33:02', 'Update Sales Quotation', '13', '2024-02-20', '0', '0', '0'),
('6290', '3040', '0', '22', '2024-02-29 09:26:53', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6291', '32', '75', '22', '2024-02-28 17:49:35', 'Create New Sales Quotation', '13', '2024-02-28', NULL, '0', '0'),
('6292', '32', '75', '22', '2024-02-28 17:49:43', 'Update Sales Quotation', '13', '2024-02-28', NULL, '0', '0'),
('6293', '32', '75', '22', '2024-02-28 18:00:23', 'Sales Quotation is approved', '13', '2024-02-28', NULL, '0', '0'),
('6294', '32', '75', '22', '2024-02-29 19:12:49', 'Update Sales Quotation', '13', '2024-02-28', NULL, '0', '0'),
('6295', '1011', '630', '1', '2024-02-29 08:49:53', 'Create Item Codes', '13', '2024-02-29', '0', '0', '0'),
('6296', '1010', '0', '1', '2024-02-29 08:49:53', 'Create New Item', '13', '2024-02-29', '0', '0', '0'),
('6297', '18', '126', '26', '2024-02-29 08:52:50', 'Create New Purchase Order', '13', '2024-02-29', '0', '0', '341'),
('6298', '3040', '0', '26', '2024-02-29 19:10:35', 'Proposal Created', '0', '0000-00-00', NULL, '0', '0'),
('6299', '32', '76', '26', '2024-02-29 09:35:20', 'Create New Sales Quotation', '13', '2024-02-29', NULL, '0', '0'),
('6300', '32', '76', '22', '2024-02-29 09:35:20', 'Sales Quotation is approved', '13', '2024-02-29', '0', '0', '0'),
('6301', '0', '56', '1', '2024-02-29 09:39:31', 'Journal Entry Added', '13', '2024-02-28', '0', '0', '0'),
('6302', '0', '57', '1', '2024-02-29 09:40:30', 'Journal Entry Added', '13', '2024-02-28', '0', '0', '0'),
('6303', '0', '58', '1', '2024-02-29 09:41:15', 'Journal Entry Added', '13', '2024-02-28', '0', '0', '0'),
('6304', '0', '59', '1', '2024-02-29 09:42:24', 'Journal Entry Added', '13', '2024-02-29', '0', '0', '0'),
('6305', '4', '13', '1', '2024-02-29 10:04:52', 'Bank Account Transferred', '13', '2024-02-13', '0', '0', '50'),
('6306', '4', '14', '1', '2024-02-29 10:05:22', 'Bank Account Transferred', '13', '2024-02-29', '0', '0', '300'),
('6307', '3040', '0', '22', '2024-02-29 19:10:35', 'Proposal Created', '0', '0000-00-00', '0', '0', '0'),
('6308', '32', '77', '22', '2024-02-29 19:13:04', 'Create New Sales Quotation', '13', '2024-02-29', NULL, '0', '0'),
('6309', '32', '75', '22', '2024-02-29 19:15:55', 'Update Sales Quotation', '13', '2024-02-28', NULL, '0', '0'),
('6310', '32', '77', '22', '2024-02-29 19:16:21', 'Sales Quotation is approved', '13', '2024-02-29', NULL, '0', '0'),
('6311', '32', '75', '22', '2024-02-29 19:15:55', 'Update Sales Quotation', '13', '2024-02-28', '0', '0', '0'),
('6312', '32', '77', '22', '2024-02-29 19:16:21', 'Update Sales Quotation', '13', '2024-02-29', '0', '0', '0'),
('6313', '40', '50', '1', '2024-02-29 23:05:50', 'Dimension Deleted', '13', '2024-02-29', '0', '0', '0'),
('6314', '12', '40', '1', '2024-03-01 08:29:25', 'Created', '13', '2024-02-29', '0', '0', '0'),
('6315', '12', '199', '1', '2024-03-01 08:29:25', 'Update Customer Payment', '13', '2024-03-01', NULL, '0', '0'),
('6316', '12', '199', '1', '2024-03-01 08:29:25', 'Create Customer Payment', '13', '2024-03-01', '0', '0', '0'),
('6317', '40', '63', '1', '2024-03-01 09:03:15', 'Dimension Created', '12', '2023-07-28', '0', '0', '0'),
('6318', '18', '127', '26', '2024-03-01 11:42:45', 'Create New Purchase Order', '13', '2024-03-01', NULL, '0', '2595'),
('6319', '18', '128', '26', '2024-03-01 11:29:09', 'Create New Purchase Order', '13', '2024-03-01', NULL, '0', '2712'),
('6320', '18', '114', '1', '2024-03-01 10:50:14', 'Delete Purchase Order', '13', '2024-03-01', '0', '0', '0'),
('6321', '18', '129', '1', '2024-03-01 11:06:02', 'Create New Purchase Order', '13', '2024-03-21', '0', '0', '271'),
('6322', '40', '51', '1', '2024-03-01 11:20:09', 'Dimension Updated', '13', '2024-02-19', NULL, '0', '0'),
('6323', '18', '130', '1', '2024-03-01 11:19:55', 'Create New Purchase Order', '13', '2024-03-01', '0', '0', '271'),
('6324', '40', '51', '1', '2024-03-01 11:20:09', 'Dimension Updated', '13', '2024-02-19', '0', '0', '0'),
('6325', '18', '128', '1', '2024-03-01 11:32:31', 'Update Purchase Order', '13', '2024-03-01', NULL, '0', '2712'),
('6326', '18', '128', '22', '2024-03-01 11:32:31', 'Delete Purchase Order', '13', '2024-03-01', '0', '0', '0'),
('6327', '18', '43', '22', '2024-03-01 11:33:02', 'Delete Purchase Order', '13', '2024-03-01', '0', '0', '0'),
('6328', '20', '68', '25', '2024-03-01 11:39:17', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6329', '20', '170', '25', '2024-03-01 11:39:17', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6330', '20', '69', '25', '2024-03-01 11:39:36', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6331', '20', '171', '25', '2024-03-01 11:39:36', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6332', '20', '70', '25', '2024-03-01 11:40:52', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6333', '20', '172', '25', '2024-03-01 11:40:52', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6334', '20', '72', '25', '2024-03-01 11:41:10', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6335', '20', '173', '25', '2024-03-01 11:41:10', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6336', '20', '73', '25', '2024-03-01 11:41:39', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6337', '20', '174', '25', '2024-03-01 11:41:39', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6338', '20', '74', '25', '2024-03-01 11:41:59', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6339', '20', '175', '25', '2024-03-01 11:42:00', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6340', '20', '75', '25', '2024-03-01 11:42:15', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6341', '20', '176', '25', '2024-03-01 11:42:15', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6342', '20', '76', '25', '2024-03-01 11:42:31', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6343', '20', '177', '25', '2024-03-01 11:42:31', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6344', '18', '127', '1', '2024-03-01 11:55:57', 'Update Purchase Order', '13', '2024-03-01', NULL, '0', '501'),
('6345', '20', '77', '25', '2024-03-01 11:42:54', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0');
INSERT INTO `0_audit_trail` VALUES
('6346', '20', '178', '25', '2024-03-01 11:42:54', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6347', '20', '79', '25', '2024-03-01 11:43:09', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6348', '20', '179', '25', '2024-03-01 11:43:09', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6349', '20', '80', '25', '2024-03-01 11:43:37', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6350', '20', '180', '25', '2024-03-01 11:43:37', 'Create New Supplier Invoice', '13', '2024-01-30', '0', '0', '0'),
('6351', '20', '81', '25', '2024-03-01 11:43:49', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6352', '20', '181', '25', '2024-03-01 11:43:49', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6353', '20', '82', '25', '2024-03-01 11:44:10', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6354', '20', '182', '25', '2024-03-01 11:44:10', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6355', '20', '83', '25', '2024-03-01 11:44:23', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6356', '20', '183', '25', '2024-03-01 11:44:23', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6357', '20', '84', '25', '2024-03-01 11:44:35', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6358', '20', '184', '25', '2024-03-01 11:44:35', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6359', '20', '85', '25', '2024-03-01 11:44:45', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6360', '20', '185', '25', '2024-03-01 11:44:45', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6361', '20', '87', '25', '2024-03-01 11:44:55', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6362', '20', '186', '25', '2024-03-01 11:44:55', 'Create New Supplier Invoice', '13', '2024-01-31', '0', '0', '0'),
('6363', '20', '88', '25', '2024-03-01 11:45:05', 'Voided.\nDocument reentered.', '13', '2024-03-01', '0', '0', '0'),
('6364', '20', '187', '25', '2024-03-01 11:45:05', 'Create New Supplier Invoice', '13', '2024-02-14', '0', '0', '0'),
('6365', '18', '127', '1', '2024-03-01 11:55:57', 'Update Purchase Order', '13', '2024-03-01', '0', '0', '2712');

### Structure of table `0_auto_email` ###

DROP TABLE IF EXISTS `0_auto_email`;

CREATE TABLE `0_auto_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rep_name` varchar(100) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `email` varchar(50) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `email_body` longtext NOT NULL,
  `time` varchar(50) NOT NULL,
  `date` varchar(11) NOT NULL,
  `weekend` varchar(15) NOT NULL,
  `cur_time` time NOT NULL,
  `cur_date` date NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_auto_email` ###

INSERT INTO `0_auto_email` VALUES
('1', 'Purchase Summary Report', '206', 'kamran@mrxpert.ae', 'Purchase Report', 'Daily Purchase report', '18-00', 'Daily', '', '11:26:46', '2023-08-15', '0', '0'),
('2', 'Customer Balance', '101', 'kamran@mrxpert.ae', 'Customer Balance', 'Daily Customer Balance report', '11-30', 'Daily', '', '11:26:46', '2023-08-15', '0', '0');

### Structure of table `0_auto_mail` ###

DROP TABLE IF EXISTS `0_auto_mail`;

CREATE TABLE `0_auto_mail` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `hours` varchar(50) NOT NULL,
  `minutes` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `days` varchar(50) DEFAULT NULL,
  `inactive` tinyint(10) NOT NULL DEFAULT 0,
  `deleted` tinyint(11) NOT NULL DEFAULT 0,
  `rep_id` int(100) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_auto_mail` ###


### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `bank_account_arabic` varchar(100) NOT NULL,
  `iban` varchar(1000) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('000002', '1', 'Mister Xpert Technical Services', '0201010203111050870595', 'Habib Bank AG Zurich', NULL, 'AED', '1', '6', '5690', '0000-00-00 00:00:00', '0', '', 'AE100290120311105870595', '0', '0'),
('20001', '3', 'cash in hand', '', 'cash in hand', NULL, 'AED', '0', '7', '5690', '0000-00-00 00:00:00', '0', '', '', '0', '0'),
('21076', '3', 'Petty cash office', '', 'Petty cash office', NULL, 'AED', '0', '8', '5690', '0000-00-00 00:00:00', '0', '', '', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `emp_id` int(11) NOT NULL,
  `reconciled` date DEFAULT NULL,
  `approved` int(11) NOT NULL,
  `alloc` double NOT NULL,
  `refund` int(11) NOT NULL,
  `invoice` int(11) NOT NULL,
  `pdcStatus` tinyint(1) NOT NULL,
  `pdcDate` date NOT NULL,
  `party_name` varchar(200) NOT NULL,
  `transfered` tinyint(1) NOT NULL,
  `previous_bank` int(11) NOT NULL,
  `bounce_cheque` tinyint(1) NOT NULL,
  `transfered_from_bank` varchar(255) NOT NULL,
  `advance_salary` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '0', '9', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('2', '0', '10', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('3', '0', '11', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('4', '0', '12', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('5', '0', '13', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('6', '0', '14', '7', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('7', '0', '14', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('8', '0', '15', '7', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('9', '0', '15', '8', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('10', '0', '15', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('11', '0', '16', '7', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('12', '0', '16', '8', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('13', '0', '16', '6', 'JV-03', '2023-12-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('14', '12', '1', '7', 'RV-00818', '2024-01-04', '4200', '0', '0', '2', '237', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('15', '12', '2', '6', 'RV-00819', '2024-01-12', '1200', '0', '0', '2', '225', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('16', '12', '3', '6', 'RV-00820', '2024-01-23', '0', '0', '0', '2', '111', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('17', '12', '4', '6', 'RV-00821', '2024-01-17', '45675', '0', '0', '2', '218', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('18', '12', '3', '6', 'RV-00820', '2024-01-13', '2498', '0', '0', '2', '111', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('19', '12', '5', '6', 'RV-00822', '2024-01-17', '11865', '0', '0', '2', '134', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('20', '12', '6', '6', 'RV-00823', '2024-01-18', '11865', '0', '0', '2', '134', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('21', '12', '7', '6', 'RV-00824', '2024-01-22', '3675', '0', '0', '2', '89', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('22', '12', '8', '6', 'RV-00825', '2024-01-23', '9713', '0', '0', '2', '74', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('23', '12', '9', '6', 'RV-00826', '2024-01-23', '2415', '0', '0', '2', '242', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('24', '12', '10', '6', 'RV-00827', '2024-01-23', '2016', '0', '0', '2', '189', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('25', '12', '11', '6', 'RV-00828', '2024-01-23', '2730', '0', '0', '2', '136', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('26', '12', '12', '6', 'RV-00829', '2024-01-23', '12560.25', '0', '0', '2', '240', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('27', '12', '13', '6', 'RV-00830', '2024-01-23', '225', '0', '0', '2', '255', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('28', '12', '14', '6', 'RV-00831', '2024-01-23', '420', '0', '0', '2', '22', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('29', '12', '15', '6', 'RV-00832', '2024-01-23', '985', '0', '0', '2', '71', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('30', '0', '17', '7', 'JV-1218', '2024-01-19', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('31', '4', '1', '6', 'CV-01247', '2024-01-03', '-20000', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('32', '4', '1', '8', 'CV-01247', '2024-01-03', '20000', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('33', '4', '2', '7', 'CV-01248', '2024-01-05', '-4200', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('34', '4', '2', '6', 'CV-01248', '2024-01-05', '4200', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('35', '4', '3', '6', 'CV-01249', '2024-01-10', '0', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('36', '4', '3', '8', 'CV-01249', '2024-01-10', '0', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('37', '4', '4', '7', 'CV-01250', '2024-01-19', '-1200', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('38', '4', '4', '6', 'CV-01250', '2024-01-19', '1200', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('39', '4', '5', '6', 'CV-01251', '2024-01-24', '0', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('40', '4', '5', '8', 'CV-01251', '2024-01-24', '0', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('41', '4', '6', '6', 'CV-01251', '2024-01-19', '-10000', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('42', '4', '6', '8', 'CV-01251', '2024-01-19', '10000', '0', '0', '0', 'From Habib Bank AG Zurich To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('43', '1', '1', '8', 'BP-01', '2024-01-27', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('44', '4', '7', '6', 'CV-01249', '2024-01-10', '-20000', '0', '0', '0', 'From Mister Xpert Technical Services To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('45', '4', '7', '8', 'CV-01249', '2024-01-10', '20000', '0', '0', '0', 'From Mister Xpert Technical Services To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('46', '0', '21', '7', 'JV-03', '2023-12-31', '35.5', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('47', '0', '21', '8', 'JV-03', '2023-12-31', '-13641.12', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('48', '0', '21', '6', 'JV-03', '2023-12-31', '37388.93', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('49', '1', '2', '8', 'BP-01', '2024-01-27', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('50', '0', '22', '6', 'JV-1222', '2024-01-31', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('51', '12', '16', '6', 'RV-00833', '2024-01-23', '1785', '0', '0', '2', '246', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('52', '12', '17', '6', 'RV-00834', '2024-01-23', '1365', '0', '0', '2', '213', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('53', '12', '18', '6', 'RV-00835', '2024-01-23', '2415', '0', '0', '2', '242', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('54', '12', '19', '6', 'RV-00836', '2024-01-24', '5250', '0', '0', '2', '75', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('55', '12', '20', '6', 'RV-00837', '2024-01-24', '3675', '0', '0', '2', '32', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('56', '12', '21', '6', 'RV-00838', '2024-01-31', '11642.4', '0', '0', '2', '74', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('57', '12', '22', '6', 'RV-00839', '2024-02-01', '3933.56', '0', '0', '2', '240', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('58', '4', '8', '6', 'CV-01252', '2024-02-01', '0', '0', '0', '0', 'From Mister Xpert Technical Services To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('59', '4', '8', '8', 'CV-01252', '2024-02-01', '0', '0', '0', '0', 'From Mister Xpert Technical Services To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('60', '4', '9', '6', 'CV-01252', '2024-02-01', '-10000', '0', '0', '0', 'From Mister Xpert Technical Services To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('61', '4', '9', '8', 'CV-01252', '2024-02-01', '10000', '0', '0', '0', 'From Mister Xpert Technical Services To Petty cash office', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('62', '12', '23', '7', 'RV-00840', '2024-02-02', '0', '0', '0', '2', '244', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('63', '4', '10', '7', 'CV-01253', '2024-02-02', '-250', '0', '0', '0', 'From cash in hand To Mister Xpert Technical Services', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('64', '4', '10', '6', 'CV-01253', '2024-02-02', '250', '0', '0', '0', 'From cash in hand To Mister Xpert Technical Services', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('65', '12', '23', '7', 'RV-00840', '2024-02-02', '0', '0', '0', '2', '244', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('66', '12', '24', '6', 'RV-00841', '2024-02-02', '14647', '0', '0', '2', '105', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('67', '12', '23', '7', 'RV-00840', '2024-02-02', '240', '0', '0', '2', '244', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('68', '12', '25', '7', 'RV-00842', '2024-02-07', '0', '0', '0', '2', '187', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('69', '12', '25', '7', 'RV-00842', '2024-02-06', '3160', '0', '0', '2', '187', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('70', '12', '26', '7', 'RV-00843', '2024-02-06', '0', '0', '0', '2', '198', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('71', '12', '27', '7', 'RV-00844', '2024-02-06', '682.5', '0', '0', '2', '258', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('72', '12', '28', '7', 'RV-00845', '2024-02-07', '0', '0', '0', '2', '230', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('73', '12', '29', '7', 'RV-00846', '2024-02-06', '500', '0', '0', '2', '252', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('74', '12', '30', '7', 'RV-00847', '2024-02-06', '500', '0', '0', '2', '208', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('75', '12', '28', '7', 'RV-00845', '2024-02-06', '1000', '0', '0', '2', '230', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('76', '4', '11', '7', 'CV-01254', '2024-02-06', '-8200', '0', '0', '0', 'From cash in hand To Mister Xpert Technical Services', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('77', '4', '11', '6', 'CV-01254', '2024-02-06', '8200', '0', '0', '0', 'From cash in hand To Mister Xpert Technical Services', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('78', '12', '31', '7', 'RV-00848', '2024-02-13', '500', '0', '0', '2', '265', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('79', '12', '32', '6', 'RV-00849', '2024-02-13', '4567.5', '0', '0', '2', '74', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('80', '12', '33', '6', 'RV-00850', '2024-02-13', '630', '0', '0', '2', '85', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('81', '12', '34', '6', 'RV-00851', '2024-02-13', '0', '0', '0', '2', '204', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('82', '12', '34', '6', 'RV-00851', '2024-02-13', '1410', '0', '0', '2', '204', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('83', '12', '35', '7', 'RV-00852', '2024-02-13', '500', '0', '0', '2', '267', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('84', '0', '25', '8', 'JV-1225', '2024-01-10', '0', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('85', '0', '26', '8', 'JV-05', '2024-01-10', '-5000', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('86', '0', '27', '7', 'JV-06', '2024-01-19', '1200', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('87', '0', '31', '6', 'JV-010', '2024-01-31', '-29927.25', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('88', '0', '34', '6', 'JV-013', '2024-02-03', '-14163', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('89', '0', '35', '8', 'JV-014', '2024-02-15', '-700', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('90', '4', '12', '7', 'CV-01255', '2024-02-13', '-500', '0', '0', '0', 'From cash in hand To Mister Xpert Technical Services', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('91', '4', '12', '6', 'CV-01255', '2024-02-13', '500', '0', '0', '0', 'From cash in hand To Mister Xpert Technical Services', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('92', '0', '39', '7', 'JV-018', '2024-02-13', '50', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('93', '0', '41', '6', 'JV-019', '2024-02-15', '-4514.5', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('94', '12', '36', '6', 'RV-00853', '2024-02-19', '525', '0', '0', '2', '234', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('95', '12', '37', '6', 'RV-00854', '2024-02-19', '5498.44', '0', '0', '2', '240', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('96', '1', '3', '8', 'BP-05', '2024-01-27', '-34.5', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('97', '1', '4', '6', 'BP-01', '2024-01-01', '-7200', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('98', '0', '44', '8', 'JV-022', '2024-01-05', '-300', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('99', '1', '5', '8', 'BP-02', '2024-01-09', '-52', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('100', '1', '6', '8', 'BP-03', '2024-01-16', '-735.75', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('101', '1', '7', '8', 'BP-04', '2024-01-27', '0', '0', '0', '0', 'PDC-1714', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('102', '1', '8', '8', 'BP-06', '2024-01-27', '-27', '0', '0', '0', 'PDC-1715', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('103', '1', '9', '8', 'BP-04', '2024-01-27', '-928.25', '0', '0', '0', 'PDC-1716', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('104', '12', '26', '7', 'RV-00843', '2024-02-06', '2342.5', '0', '0', '2', '198', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('105', '12', '38', '6', 'RV-00855', '2024-02-23', '3135', '0', '0', '2', '272', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('106', '12', '39', '6', 'RV-00856', '2024-02-23', '0', '0', '0', '2', '273', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('107', '12', '39', '6', 'RV-00856', '2024-02-23', '3633', '0', '0', '2', '273', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('108', '0', '59', '7', 'JV-032', '2024-02-29', '300', '0', '0', '0', NULL, '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('109', '4', '13', '7', 'CV-01256', '2024-02-13', '-50', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('110', '4', '13', '6', 'CV-01256', '2024-02-13', '50', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('111', '4', '14', '7', 'CV-01257', '2024-02-29', '-300', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('112', '4', '14', '6', 'CV-01257', '2024-02-29', '300', '0', '0', '0', 'From cash in hand To Habib Bank AG Zurich', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', '', '0', '0', '0', '', '0'),
('113', '12', '40', '6', 'RV-00857', '2024-02-29', '5775', '0', '0', '2', '199', '0', NULL, '0', '0', '0', '0', '0', '0000-00-00', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', '0', '0', '0', '', '0');

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###


### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `memo_` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_buyer_header` ###

DROP TABLE IF EXISTS `0_buyer_header`;

CREATE TABLE `0_buyer_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_id` int(11) NOT NULL,
  `header_name` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_buyer_header` ###


### Structure of table `0_buyer_header_master` ###

DROP TABLE IF EXISTS `0_buyer_header_master`;

CREATE TABLE `0_buyer_header_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_buyer_header_master` ###


### Structure of table `0_charge_group` ###

DROP TABLE IF EXISTS `0_charge_group`;

CREATE TABLE `0_charge_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(250) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_charge_group` ###

INSERT INTO `0_charge_group` VALUES
('1', 'Test Group', '0'),
('2', 'Test Group - 1', '0'),
('3', 'Test Group - 2', '0');

### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `name_arabic` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '', '0'),
('10', 'Current Assets', '1', '', '0'),
('2', 'Liabilities', '2', '', '0'),
('3', 'Income', '4', '', '0'),
('4', 'Admin and General Expense', '6', '', '0'),
('5', 'Equity', '3', '', '0'),
('6', 'Cost of goods sold', '5', '', '0'),
('7', 'Non Current Assets', '1', '', '0'),
('8', 'Bank Borrowings', '2', '', '0'),
('9', 'FIxed Assets', '1', '', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `account_name_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('000002', '', 'Habib Bank AG Zurich', '24-01', '', '0'),
('0003', '', 'Loans &amp; Advances (Asset)', '01', '', '1'),
('1060', '', 'Opening Account', '01', '', '0'),
('1200', '', 'Sundry Debtors', '01', '', '0'),
('1510', '', 'Inventory', '2', '', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '', '0'),
('1881', '', 'Fuel &amp; Transportation Expense', '21', '', '0'),
('1886', '', 'Repair Maintenance Expenses-Vehicles', '21', '', '0'),
('1888', '', 'Traffic Fines and Payments', '21', '', '0'),
('1897', '', 'General Expense', '21', '', '0'),
('1905', '', 'Paid Leaves', '16', '', '0'),
('1914', '', 'PENALITIES TO EMPLOYEES', '20', '', '0'),
('1915', '', 'Purchase Discount', '20', '', '0'),
('20001', '', 'Cash In Hand', '24-01', '', '0'),
('2022', '', 'Purchases Credit- Taxable', '10', '', '0'),
('2034', '', 'Discount Received', '20', '', '0'),
('2100', '', 'Sundry Creditors', '4', '', '0'),
('21001', '', 'Commission on contract', '21', '', '0'),
('21002', '', 'Commission on Referral', '21', '', '0'),
('21004', '', 'Membership and Renewal Expense', '21', '', '0'),
('21005', '', 'Office Maintenance Expense Taxable', '21', '', '0'),
('21006', '', 'Office Supplies and Stationary Expenses Taxable', '21', '', '0'),
('21007', '', 'Rental Expense', '21', '', '0'),
('21009', '', 'Selling &amp; Marketing Expenses', '21', '', '0'),
('210101', '', 'Electricity Expense', '21', '', '0'),
('21011', '', 'Vehicle Insurance &amp; Registration Expenses taxable', '21', '', '0'),
('21013', '', 'AGENCY FEE TAXABLE', '21', '', '0'),
('21014', '', 'Air Tickets Expenses', '21', '', '0'),
('21015', '', 'Bad Debts', '21', '', '0'),
('21017', '', 'Carriage Inward', '21', '', '0'),
('21018', '', 'Delivery Charges Non Taxable', '21', '', '0'),
('21019', '', 'Ejari Expense', '21', '', '0'),
('21020', '', 'Employee&#039;s Accommodation Expense', '21', '', '0'),
('21021', '', 'Exchange Commission Expenses', '21', '', '0'),
('21022', '', 'Fuel Expense - P-25757 (Arslan) Non Taxable', '21-11', '', '0'),
('21023', '', 'IT Services Expense', '21', '', '0'),
('21024', '', 'Loading Unloading Charges', '21', '', '0'),
('21025', '', 'Medical Expenses', '21', '', '0'),
('21026', '', 'Network Charges Expense', '21', '', '0'),
('21027', '', 'Office Maintenance Non Taxable', '21', '', '0'),
('21028', '', 'Post Office Expense Non Taxable', '21', '', '0'),
('21029', '', 'PRINTING &amp; STATIONARY', '21', '', '0'),
('21030', '', 'Sponsorship Fee Taxable', '21', '', '0'),
('21031', '', 'Sponsorship Fee Non Taxable', '21', '', '0'),
('21032', '', 'Subscription Fees - Taxable', '21', '', '0'),
('21033', '', 'Trade License&#039;s Expenses', '21', '', '0'),
('21034', '', 'Vehicle Renewal Expense Non Taxable', '21', '', '0'),
('21035', '', 'Administration Expenses', '21', '', '0'),
('21036', '', 'Visa Processing Charges - Taxable', '24-08', '', '0'),
('21037', '', 'Visa &amp; Renewables - Abdulla Nepali  MXTS', '24-08', '', '0'),
('21038', '', 'Visa &amp; Renewables - Abid MXTS', '24-08', '', '0'),
('21039', '', 'Visa &amp; Renewables - Afaq Mxts', '24-08', '', '0'),
('21040', '', 'Visa &amp; Renewables - Akbar MXT', '24-08', '', '0'),
('21041', '', 'Visa &amp; Renewables - Arslan MXTS', '24-08', '', '0'),
('21042', '', 'Visa &amp; Renewables Exp-Bir Singh', '24-08', '', '0'),
('21043', '', 'Visa &amp; Renewables - Imran MXTS', '24-08', '', '0'),
('21044', '', 'Visa &amp; Renewables - Shakeel Ahmed MXT', '24-08', '', '0'),
('21045', '', 'Visa &amp; Renewables - Usama MXTS', '24-08', '', '0'),
('21046', '', 'DEWA Expense Taxable', '24-09', '', '0'),
('21047', '', 'Dewa Expense Non Taxable', '24-09', '', '0'),
('21048', '', 'Etisalat Expense Taxable', '24-09', '', '0'),
('21049', '', 'Etisalat Expense Non Taxable', '24-09', '', '0'),
('2105', '', 'Deferred Income', '4', '', '0'),
('21050', '', 'Mobile Expenses', '24-09', '', '0'),
('21051', '', 'Repair MaintenanceP-25757 -Vehicles', '24-10', '', '0'),
('21052', '', 'Repair MaintenanceP-25757 -Vehicles Taxable', '24-10', '', '0'),
('21053', '', 'Repair Maintenance(P-26138) -Vehicles', '24-10', '', '0'),
('21054', '', 'Repair Maintenance(P-26138) -Vehicles Taxable', '24-10', '', '0'),
('21055', '', 'Repair MaintenanceP-56609 -Vehicles Non Taxable', '24-10', '', '0'),
('21056', '', 'Repair Maintenance R-45327 -Vehicles', '24-10', '', '0'),
('21057', '', 'Repair Maintenance R-45327 -Vehicles Taxable', '24-10', '', '0'),
('21058', '', 'Repair Maintenance Vehicle Taxable', '24-10', '', '0'),
('21059', '', 'Office Supplies &amp; Stationery Non Taxable', '21', '', '0'),
('21060', '', 'Salik Expenses', '21-11', '', '0'),
('21061', '', 'Cafu Expenses Taxable', '21-11', '', '0'),
('21062', '', 'Carriage Outward Non Taxable', '21-11', '', '0'),
('21063', '', 'Fuel Expense - G-56609 (Imran) Taxable', '21-11', '', '0'),
('21064', '', 'Fuel Expense - G-56609 (Imran) Non Taxable', '21-11', '', '0'),
('21065', '', 'Fuel Expense JAC S -77609 Non Taxable', '21-11', '', '0'),
('21066', '', 'Fuel Expense JAC S -77609  Taxable', '21-11', '', '0'),
('21067', '', 'Fuel Expense - P-25757 (Arslan) Taxable', '21-11', '', '0'),
('21068', '', 'Fuel Expense P-26138 (Van) Non Taxable', '21-11', '', '0'),
('21069', '', 'Fuel Expense P-26138 (Van) Taxable', '21-11', '', '0'),
('21070', '', 'Fuel Expense R-45327 Non Taxable', '21-11', '', '0'),
('21071', '', 'Fuel Expense R-45327 Taxable', '21-11', '', '0'),
('21072', '', 'Parking Fees', '21-11', '', '0'),
('21073', '', 'Taxi Pick Up Expense', '21-11', '', '0'),
('21074', '', 'Transportation Expenses', '21-11', '', '0'),
('21075', '', 'Vehicle Insurance &amp; Registration Expenses Non Taxable', '21', '', '0'),
('21076', '', 'Petty Cash ', '24-01', '', '0'),
('21077', '', 'Repair MaintenanceP-56609 -Vehicles Taxable', '24-10', '', '0'),
('21078', '', 'Cafu Expenses  Non Taxable', '21-11', '', '0'),
('21079', '', 'Carriage Outward Taxable', '21-11', '', '0'),
('21080', '', 'Vehicle Renewal Expense Taxable', '21', '', '0'),
('21081', '', 'Repair &amp; Maintenance Expense JAC S -77609 Non Taxable', '24-10', '', '0'),
('2150', '', 'VAT', '4', '', '0'),
('2390', '', 'Duties and Taxes', '4', '', '0'),
('2391', '', 'Excise Tax 100%', '4', '', '0'),
('24001', '', 'Advance to Abid Hussain', '24-02', '', '0'),
('24002', '', 'Advance to Akbar (driver)', '24-02', '', '0'),
('24003', '', 'Advance to Arslan Nadeem', '24-02', '', '0'),
('24004', '', 'Advance to Ghulam Abass', '24-02', '', '0'),
('24005', '', 'Advance to Muhammad Adeel', '24-02', '', '0'),
('24006', '', 'Advance to Mustafa Saidu', '24-02', '', '0'),
('24007', '', 'DEWA Security', '24-03', '', '0'),
('24008', '', 'Employee&#039;s Accommodation Rental Security', '24-03', '', '0'),
('24009', '', 'Rental Security', '24-03', '', '0'),
('24010', '', 'Development Planning Account', '24-03', '', '0'),
('24012', '', 'Advance to AFAQ MAHMOOD MAHMOOD AHMAD ', '24-02', '', '0'),
('24013', '', 'Advance to Bir Singh', '24-02', '', '0'),
('24014', '', 'Advance to Durgalal Nepali', '24-02', '', '0'),
('24015', '', 'Advance to Imran Qasim', '24-02', '', '0'),
('24016', '', 'Advance to Muhammad Akhtar', '24-02', '', '0'),
('24017', '', 'Advance to Muhammad Usama', '24-02', '', '0'),
('24018', '', 'Advance to Muhammad Ibrar', '24-02', '', '0'),
('24019', '', 'Advance to Shahid Farooq', '24-02', '', '0'),
('24021', '', 'Advance to Shakeel Ahmed', '24-02', '', '0'),
('24022', '', 'Advance to Tauheed Ahmed', '24-02', '', '0'),
('24023', '', 'Advance to Zeeshan Ali', '24-02', '', '0'),
('24025', '', 'Prepaid Employees Accommodation Expense', '24-04', '', '0'),
('24026', '', 'Prepaid Rent', '24-04', '', '0'),
('24027', '', 'Vehicle 26138', '24-05', '', '0'),
('24028', '', 'Vehicle 60936', '24-05', '', '0'),
('24029', '', 'Vehicle G-56609', '24-05', '', '0'),
('24030', '', 'Vehicle Mitsubishi Lancer R 45327', '24-05', '', '0'),
('24031', '', 'vehicle P25757', '24-05', '', '0'),
('24032', '', 'Accumulated Depreciation Vehicle 26138', '24-07', '', '0'),
('24033', '', 'Accumulated Depreciation Vehicle 60936', '24-07', '', '0'),
('24034', '', 'Accumulated Depreciation Vehicle G-56609', '24-07', '', '0'),
('24035', '', 'Accumulated Depreciation Vehicle P25757', '24-07', '', '0'),
('24036', '', 'Other Tools', '24-06', '', '0'),
('24037', '', 'Loan From Directors', '4', '', '0'),
('24038', '', 'Director Expenses', '6', '', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '', '0'),
('4010', '', 'Sales Paint job', '8', '', '0'),
('4430', '', 'Shipping &amp; Handling Expense', '21', '', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '', '1'),
('4500', '', 'Discount Received ', '9', '', '1'),
('4510', '', 'Discounts Allowed Taxable', '16', '', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '', '0'),
('5020', '', 'Miscellaneous  Cash purchase item Taxable', '10', '', '0'),
('5030', '', 'Purchase Expenses Bindhahi', '10', '', '0'),
('5040', '', 'Purchase price Variance', '10', '', '0'),
('5050', '', 'Purchases', '10', '', '0'),
('5060', '', 'Discounts Received', '10', '', '1'),
('5070', '', 'Unregistered Purchases', '10', '', '0'),
('5080', '', ' Purchase Expenses Dubai Coast', '10', '', '0'),
('5420', '', 'Overtime', '16', '', '0'),
('5421', '', 'Discount Allowed Non-Taxable', '16', '', '0'),
('5422', '', 'Site Maintenance Expense Non Taxable', '16', '', '0'),
('5423', '', 'Basic Salary', '16', '', '0'),
('5424', '', 'Home Allowance', '16', '', '0'),
('5425', '', 'Outside Labour', '16', '', '0'),
('5426', '', 'Meals and Entertainment Expense', '16', '', '0'),
('5427', '', 'Rewards and Benefits', '16', '', '0'),
('5429', '', 'Unpaid Leaves', '16', '', '0'),
('5660', '', 'Depreciation Expense', '21', '', '0'),
('5690', '', 'Bank Charges', '21', '', '0'),
('5780', '', 'Telephone', '21', '', '0'),
('9990', '', 'Year Profit/Loss', '12', '', '1');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `name_arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('01', 'Current Assets', '1', '', '', '0'),
('10', 'Purchase Account ', '6', '', '', '0'),
('11', 'Payroll Expenses', '4', '', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '', '0'),
('13', 'Short term loan', '8', '', '', '0'),
('16', 'Direct Expenses', '4', '', '', '0'),
('19', 'Direct Income', '3', '', '', '0'),
('2', 'Inventory Assets', '1', '01', '', '0'),
('20', 'Indirect Income', '4', '', '', '0'),
('21', 'Indirect Expenses', '4', '', '', '0'),
('21-11', 'Fuel And Transportation Expense', '4', '21', '', '0'),
('24-01', 'Cash and Bank', '1', '01', '', '0'),
('24-02', 'Loans and Advances (Assets)', '1', '01', '', '0'),
('24-03', 'Deposits and Securities', '1', '01', '', '0'),
('24-04', 'Prepayments', '1', '01', '', '0'),
('24-05', 'Vehicles', '1', '3', '', '0'),
('24-06', 'Machinery and Tools', '1', '3', '', '0'),
('24-07', 'Accumulated Depriciation', '1', '3', '', '0'),
('24-08', 'VISA EXPENSES', '4', '21', '', '0'),
('24-09', 'Utility Expenses', '4', '21', '', '0'),
('24-10', 'Repair and Maintenance Vehicles', '4', '21', '', '0'),
('3', 'Fixed Assets', '1', '', '', '0'),
('4', 'Current Liabilities', '2', '', '', '0'),
('5', 'Long Term Liabilities', '2', '', '', '0'),
('6', 'Capital Account', '5', '', '', '0'),
('7', 'Retained Earnings', '2', '', '', '0'),
('8', 'Sales Account', '3', '', '', '0'),
('9', 'Other Income', '3', '', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###

INSERT INTO `0_comments` VALUES
('13', '3', '2024-01-11', 'Sales Quotation # 259'),
('10', '1', '2024-01-11', 'Sales Quotation # 260 '),
('13', '2', '2024-01-11', 'Sales Quotation # 260 '),
('10', '2', '2024-01-11', 'Sales Quotation # 259\nso-154'),
('10', '3', '2024-01-19', 'Sales Quotation # 268\n'),
('13', '1', '2024-01-19', 'Sales Quotation # 268\n'),
('13', '5', '2024-01-20', 'Sales Quotation # 270'),
('10', '5', '2024-01-20', 'Sales Quotation # 270'),
('13', '9', '2024-01-04', 'Sales Quotation # 246'),
('10', '9', '2024-01-04', 'Sales Quotation # 246'),
('13', '12', '2024-01-09', 'Sales Quotation # 219'),
('10', '12', '2024-01-09', 'Sales Quotation # 219'),
('13', '13', '2024-01-09', 'Sales Quotation # 236'),
('10', '13', '2024-01-09', 'Sales Quotation # 236'),
('10', '14', '2024-01-23', 'LPO NUMBER B202311-21611'),
('10', '7', '2024-01-22', 'Sales Quotation # 238 OLD QUOTE'),
('13', '7', '2024-01-22', 'Sales Quotation # 238 OLD QUOTE'),
('12', '1', '2024-01-04', 'CASH RECEIVED THROUGH ARSLAN'),
('12', '2', '2024-01-12', '18-Dec-23	AANI#: 176319  transfer from  WAJAHAT AHMAD		1,200.00\n'),
('12', '4', '2024-01-17', 'chq no.008972 dated 16/1/24  rv no. 1029\nADVANCE RECEIPT'),
('12', '3', '2024-01-13', 'CHQ NO.007072 DATED 9/1/24'),
('12', '5', '2024-01-17', 'CHEQUE NO:000116 HBAGZ DATE:16.01.2024.'),
('12', '6', '2024-01-18', 'CHEQUE NO:002635 HBAGZ DATE:18-01-2024.'),
('12', '7', '2024-01-22', 'chq noo.762216 dated 19/1/24'),
('12', '8', '2024-01-23', 'SQ-225	Hammer fil contracting	18500		SO-138 Hammer F I L Contracting LLC.	INV30942-Jan-24	FTS - Msg# 6422135 Ref  B/O  /006/004 HAMMER F I L CONTRACTING LOFFICE 401 BUSINESS DIAMOND CENTER 2		9,713.00\n'),
('12', '9', '2024-01-23', '3-Jan-24	AANI#: 204622  transfer from  HERMAN SINGH THOMAS		2,415.00\n'),
('12', '10', '2024-01-23', '8-Jan-24	IPI # IPI24010604RMLN6 From AL GHUSSUN ALUM IND LLC Sharjah Head Office		2,016.00\n'),
('12', '11', '2024-01-23', '8-Jan-24	FTS - Msg# 6439229 Ref  B/O  /009/004 MEHERZ KREATION LLC       FLEXI DESK FLEXI DESK SHAMS FREE ZON		2,730.00	\n'),
('12', '12', '2024-01-23', 'HBZ Jan9 DERCD105XXX595 Amount 12,560.25 AED Credited/AANI#: 217924  transfer from  Brian Howarth,'),
('12', '13', '2024-01-23', '10-Jan-24	IPI # IPI24010904SEGUK From JEAN PAUL SCHMIDT		225.00\nJEAN PAUL PAYMENT OF BINDHAHI RECEIVED IN MR XPERT A/C'),
('12', '14', '2024-01-23', '16-Jan-24	FTS - Msg# 6468219 Ref  B/O  KOA REAL ESTATE DEVELOPMENT LLC P O BOX 393942 BUSINESS BAY AE   393942		420.00\n'),
('12', '15', '2024-01-23', '18-Jan-24	FTS - Msg# 6478159 Ref  B/O  /009/004 WONDERWALL CONTRACTING LLC405 405 CAPITAL GOLDEN TOWER BUSINES		985.00\n'),
('20', '1', '2024-01-23', 'Adbullah Kamran	056-4122933\n'),
('20', '2', '2024-01-23', 'Unknown- Shoaib	056-5366303\n'),
('20', '3', '2024-01-23', 'Adeel	056-6815339\n'),
('20', '4', '2024-01-23', 'Akbar Khan	056-4118929\n'),
('20', '5', '2024-01-24', 'Akhter 	056-4119377\n'),
('20', '6', '2024-01-24', 'Ibrar	056-4119771\n'),
('20', '7', '2024-01-23', 'Abdullah Nepali	056-4118922\n'),
('20', '8', '2024-01-23', 'land	04-2271155\n'),
('20', '9', '2024-01-23', 'Shakeel	050-4848203\n'),
('20', '10', '2024-01-24', 'Imran	056-4031782\n'),
('0', '17', '2024-01-19', 'BASIC SALARY RETURN OF DECEMBER SALARY.'),
('0', '18', '2024-01-24', 'ETISALAT EXPENSES PAID BY SIR KAMRAN.'),
('20', '11', '2024-01-24', 'S-77609	ARSLAN	196\nP-25757	SHAKEEL	112\nG-56609	IMRAN	\nP-26138	AKBAR	76\nR-45327	ABDULLAH	176\n		-44\n'),
('0', '19', '2024-01-24', 'SALIK EXPENSES PAID BY SIR KAMRAN FOR THE MONTH OF DECEMBER 2023.'),
('20', '12', '2024-01-24', 'CAFU FUEL EXPENSES FOR THE MONTH OF DECEMBER 2023.'),
('0', '20', '2024-01-24', 'CAFU EXPENSES FOR THE MONTH OF DECEMBER 2023. PAID BY SIR KAMRAN.'),
('4', '1', '2024-01-03', 'chq no.000605 dated 3/1/24'),
('13', '20', '2024-01-24', 'Sales Quotation # 29'),
('4', '6', '2024-01-19', 'chq no.000610 dated 19/1/24'),
('20', '13', '2024-01-23', 'Akhter 	056-4119377\n'),
('20', '14', '2024-01-23', 'Ibrar	056-4119771\n'),
('20', '15', '2024-01-23', 'Imran	056-4031782\n'),
('20', '16', '2024-01-24', 'Imran	056-4031782\n'),
('1', '1', '2024-01-27', 'COMMISSION ON REFERRAL FOR SHAKIR ALI. JULY2023 TO DECMBER 2023.'),
('4', '7', '2024-01-10', 'CHQ NO.000607 DATED 10/1/24'),
('13', '22', '2024-01-30', 'Sales Quotation # SQ-279'),
('10', '22', '2024-01-30', 'Sales Quotation # SQ-279'),
('13', '23', '2024-01-30', 'Sales Quotation # SQ-263\nLPO 8170000327'),
('10', '23', '2024-01-30', 'Sales Quotation # SQ-263\nLPO 8170000327'),
('13', '24', '2024-01-30', 'Sales Quotation # SQ-262\nLPO 8170000319'),
('10', '24', '2024-01-30', 'Sales Quotation # SQ-262\nLPO 8170000319'),
('13', '25', '2024-01-30', 'Sales Quotation # SQ-277'),
('10', '25', '2024-01-30', 'Sales Quotation # SQ-277'),
('13', '26', '2024-01-30', 'Sales Quotation # SQ-280'),
('10', '26', '2024-01-30', 'Sales Quotation # SQ-280'),
('1', '2', '2024-01-27', 'COMMISSION ON REFERRAL FOR SHAKIR ALI. JULY2023 TO DECMBER 2023.'),
('0', '22', '2024-01-31', 'CHQ NO.000611 DATED 31/1//24'),
('12', '16', '2024-01-23', '20-Jan-24	FTS - Msg# 6484523 Ref  B/O  THE COOL BOX STUDIO DMCC           BBZ 405 MAZAYA BUSINESS AVENUE AL  K	1,785.00\n'),
('12', '17', '2024-01-23', '22-Jan-24	AANI#: 236230  transfer from  NAVEENARATHINAM BALUSAMY	1,365.00\n'),
('12', '18', '2024-01-23', '23-Jan-24	AANI#: 238497  transfer from  HERMAN SINGH THOMAS	2,415.00\n'),
('12', '19', '2024-01-24', '24-Jan-24	FTS - Msg# 6493814 Ref  B/O  BERGER PAINTS EMIRATES LTD CO LLC PO Box 27524 ACCOUNTS DEPARTMENT AE	5,250.00\n'),
('12', '20', '2024-01-24', '24-Jan-24	AANI#: 240811  transfer from  GOVEAS ERROL EDWIN FREDIE PAUL	3,675.00\n'),
('12', '21', '2024-01-31', '31-Jan-24	FTS - Msg# 6518357 Ref  B/O  /006/004 HAMMER F I L CONTRACTING LOFFICE 401 BUSINESS DIAMOND CENTER 2	11,642.40\n'),
('12', '22', '2024-02-01', 'HBZ Feb1 DERCD105XXX595 Amount 3,933.56 AED Credited/AANI#: 256242  transfer from  Brian Howarth. (SO-171 Mr. Brian Howarth ,Sales Quotation # SQ-284)'),
('4', '9', '2024-02-01', 'CHQ NO.000613 DATED 1/2/24'),
('4', '10', '2024-02-02', 'nirav patel\nand remaining 10 aed added from previous fund'),
('12', '24', '2024-02-02', 'CHQ NO.023628 DATED 31/1/24'),
('12', '23', '2024-02-02', 'cash received through arslan'),
('20', '17', '2024-01-31', 'po-257'),
('20', '18', '2024-01-31', 'PO-258'),
('20', '19', '2024-01-31', 'po-259'),
('20', '20', '2024-01-31', 'PO-260'),
('20', '21', '2024-01-31', 'po-261'),
('20', '22', '2024-01-31', 'PO-264'),
('20', '23', '2024-01-31', 'PO-266'),
('20', '24', '2024-01-31', 'PO-267'),
('20', '25', '2024-01-31', 'PO-268'),
('20', '26', '2024-01-31', 'PO-272'),
('20', '27', '2024-01-31', 'PO-275'),
('20', '28', '2024-01-31', 'PO-274'),
('20', '30', '2024-02-06', 'po-276'),
('20', '31', '2024-01-31', 'po-277'),
('20', '32', '2024-01-31', 'po-276'),
('20', '33', '2024-01-31', 'po-276'),
('20', '34', '2024-01-31', 'po-278'),
('20', '35', '2024-01-31', 'po-278'),
('20', '36', '2024-01-31', 'po-280'),
('20', '37', '2024-01-31', 'po-284'),
('20', '38', '2024-01-31', 'po-287'),
('20', '39', '2024-01-31', 'po-293'),
('20', '40', '2024-01-31', 'po-294'),
('20', '41', '2024-01-31', 'po-296'),
('20', '42', '2024-01-31', 'po-297'),
('20', '43', '2024-01-31', 'po-298'),
('20', '44', '2024-01-31', 'po-299'),
('20', '45', '2024-01-31', 'po-285'),
('20', '46', '2024-02-06', 'po-276'),
('20', '47', '2024-01-31', 'po-276'),
('20', '48', '2024-01-05', 'dar5926'),
('20', '49', '2024-01-01', 'dar 5925'),
('20', '50', '2024-01-05', 'DAR 5924'),
('20', '51', '2024-01-09', 'DAR 5930'),
('20', '52', '2024-01-09', 'DAR 5929 ( BRIAN HOWARTH)'),
('20', '53', '2024-01-09', 'DAR 5928'),
('20', '54', '2024-01-09', 'DAR 5928'),
('20', '55', '2024-01-09', 'VEHICLE RENEWAL TEST EXPENSE'),
('20', '56', '2024-01-09', 'dar 5927'),
('20', '58', '2024-01-12', 'Abdullah mr xpert  lancer 45327 , invoice under dubai coast name'),
('20', '60', '2024-01-16', 'DAR 5934'),
('20', '61', '2024-01-16', 'DAR 5933'),
('20', '62', '2024-01-16', 'DAR 5933'),
('20', '63', '2024-01-16', 'DAR 5932'),
('20', '64', '2024-01-24', '225 SO-164 Aevolve Beauty Saloon'),
('12', '25', '2024-02-06', 'cash received through arslan , 7.50 aed discount'),
('12', '27', '2024-02-06', 'cash received through arslan'),
('12', '29', '2024-02-06', 'cash received through arslan advance'),
('12', '30', '2024-02-06', 'CASH RECEIVED THROUGH ARSLAN'),
('12', '28', '2024-02-06', 'cash received through arslan'),
('4', '11', '2024-02-06', 'cash deposit'),
('20', '65', '2024-02-08', 'PO-279'),
('20', '66', '2024-02-08', 'PO-282'),
('20', '67', '2024-02-08', 'PO-286'),
('20', '68', '2024-01-31', 'PO-279'),
('20', '69', '2024-01-31', 'PO-282'),
('20', '70', '2024-01-31', 'PO-286'),
('20', '73', '2024-01-30', '128	SO-72 CARELINE COSMETIC AND CARE LLC OLD SITE OF 2023'),
('13', '27', '2024-02-09', 'Sales Quotation # SQ-295'),
('10', '27', '2024-02-09', 'Sales Quotation # SQ-295'),
('10', '29', '2024-02-09', 'Sales Quotation # SQ-295'),
('13', '29', '2024-02-10', 'Sales Quotation # SQ-291'),
('10', '30', '2024-02-10', 'Sales Quotation # SQ-291'),
('13', '30', '2024-02-10', 'Sales Quotation # SQ-297'),
('10', '31', '2024-02-10', 'Sales Quotation # SQ-297'),
('13', '31', '2024-02-12', 'Sales Quotation # SQ-284'),
('10', '32', '2024-02-12', 'Sales Quotation # SQ-284'),
('11', '1', '2024-02-06', 'against invoice of 2023 INV3072 , NOT ADJUSTED AGAINST INVOICE AS THERE IN ONLY JOURNAL ENTRY IN WAYZ'),
('20', '74', '2024-01-30', '121	SO-65 JAMTS Tech LLC ( 29/9/23- old site of 2023)'),
('20', '75', '2024-01-30', '124	SO-68 Al Hai Motors \n\n(12/9/23)'),
('20', '76', '2024-01-30', 'Stock 2023 Onwards'),
('20', '77', '2024-01-30', '30/10/23'),
('20', '78', '2024-02-13', '2/10/23'),
('20', '79', '2024-01-30', 'Stock 2023 Onwards'),
('20', '80', '2024-01-30', '11/9/23'),
('20', '81', '2024-01-31', '4/12/23'),
('20', '82', '2024-01-31', '6/12/23'),
('20', '83', '2024-01-31', '1/12/23'),
('13', '32', '2024-02-13', 'Sales Quotation # SQ-296'),
('10', '33', '2024-02-13', 'Sales Quotation # SQ-296'),
('0', '23', '2024-02-13', 'Arslan car service agreement fee , invoice under bdt name, adjustment entry'),
('12', '31', '2024-02-13', '50% advance SO-172 Al Hayyat al jameela technical Services LLC (site 234)'),
('12', '32', '2024-02-13', '5-Feb-24	FTS - Msg# 6535477 Ref  B/O  /006/004 HAMMER F I L CONTRACTING LOFFICE 401 BUSINESS DIAMOND CENTER 2		4,567.50\n'),
('12', '33', '2024-02-13', '5-Feb-24	FTS - Msg# 6535768 Ref  B/O  /009/004 AEVOLVE SALONS DMCC       GF 04 GF 04 AL SEEF 3 CLUSTER U JLT		630.00\n'),
('12', '34', '2024-02-13', '7-Feb-24	Web Transfer From DERCDAEDXXX285 (Quotation No.: SQ-187)		1,410.00\n'),
('20', '84', '2024-01-31', '2/10/23'),
('12', '35', '2024-02-13', '10-Feb-24	AANI#: 274140  transfer from  FRANCESCA  LAVERDA		500.00\n240	SO-177 Ms. Francesca'),
('0', '24', '2024-02-13', 'remaining payment adjusted as discount'),
('20', '85', '2024-01-31', '13/1/24'),
('20', '86', '2024-01-31', 'SO-146 Unitra International LLC 2023-206 6/1/24'),
('20', '87', '2024-01-31', 'Stock 2023 Onwards 9/1/24'),
('20', '91', '2024-02-08', 'dar 214, po 300'),
('20', '92', '2024-02-08', 'DAR5958 DATED 8/2/24'),
('20', '93', '2024-02-15', 'PO-314 , SITE 236 PAVIIMENTO'),
('21', '1', '2024-02-15', 'CN3625 (INV DATE 28/10/23)'),
('0', '25', '2024-01-10', ', monthly deduction 500aed '),
('0', '26', '2024-02-15', ', monthly deduction 500aed '),
('0', '27', '2024-02-15', 'BASIC SALARY RETURN OF DECEMBER SALARY.'),
('0', '28', '2024-02-15', 'ETISALAT EXPENSES PAID BY SIR KAMRAN.'),
('0', '29', '2024-02-15', 'SALIK EXPENSES PAID BY SIR KAMRAN FOR THE MONTH OF DECEMBER 2023.'),
('0', '30', '2024-02-15', 'CAFU EXPENSES FOR THE MONTH OF DECEMBER 2023. PAID BY SIR KAMRAN.'),
('0', '31', '2024-02-15', 'CHQ NO.000611 DATED 31/1//24'),
('0', '32', '2024-02-15', 'Arslan car service agreement fee , invoice under bdt name, adjustment entry'),
('0', '33', '2024-02-15', 'remaining payment adjusted as discount'),
('0', '34', '2024-02-03', 'CHQ NO.000615 DATED 3/2/24'),
('0', '35', '2024-02-15', 'With the approval of sir kamran'),
('0', '36', '2024-02-03', 'SALARY RETURN OF SEPT 2023 WAS NOT RECEIVED FROM HIS SIDE, THAT CHARGED BACK TO HIS ACCOUNT'),
('0', '37', '2024-02-06', '21-Nov-23	FTS - Msg# 6289162 Ref  B/O  ZBOONI DMCC MATANIA AVENUE JLT  DUBAI UAE		14,207.86	\nPAYMENT OF JEAN PAUL RECEIVED IN BDT BANK THROUGH ZBOONI.'),
('0', '38', '2024-02-06', '03-Jan-24	FTS - Msg# 6424143 Ref  B/O  ZBOONI DMCC MATANIA AVENUE JLT  DUBAI UAE		4,438.67	\nJEAN PAUL PAYMENT RECEIVED THROUGH BDT BANK FROM ZBOONI.'),
('0', '39', '2024-02-13', 'sept 2023 salary return back amount '),
('20', '94', '2024-01-05', 'dar 5925'),
('20', '95', '2023-12-31', 'from   jan24 to 28th jan 2025'),
('0', '41', '2024-02-15', 'ZEESHAN LEAVE SALARY FOR THE MONTH OF FEBRUARY, MARCH AND APRIL 2024 (18D DAYS) CHEQUE NO:000616 HBAGZ DATE:15.02.2024.'),
('20', '97', '2024-01-01', 'for the month period 26/11/23 to 25/12/23'),
('0', '42', '2024-01-31', 'paid by sir kamran'),
('20', '98', '2024-02-17', 'for the motnh of jan 24'),
('0', '43', '2024-02-17', 'paid by sir kamran jan 2024 bill'),
('20', '99', '2024-02-17', 'for the month of jan 24'),
('13', '33', '2024-02-19', 'Sales Quotation # SQ-306'),
('13', '34', '2024-02-19', 'Sales Quotation # SQ-305'),
('10', '35', '2024-02-19', 'Sales Quotation # SQ-305'),
('12', '36', '2024-02-19', '13-Feb-24	AANI#: 279428  transfer from  MUBEEN JAVED		525.00\n'),
('12', '37', '2024-02-19', '15-Feb-24	AANI#: 282675  transfer from  Brian Howarth		5,498.44\n'),
('10', '34', '2024-02-19', 'Sales Quotation # SQ-306'),
('1', '3', '2024-01-27', 'COMMISSION ON REFERRAL FOR SHAKIR ALI. JULY2023 TO DECMBER 2023.'),
('1', '4', '2024-01-01', 'CHEQUE NO:000565 DATE:01.01.2024 EMPLOYEES ACCOMODATION RENT 3RD INSTALLMENT'),
('0', '44', '2024-01-05', 'DAR 5924\nPDC PV (1687)'),
('1', '5', '2024-01-09', 'DAR 5928'),
('1', '6', '2024-01-16', 'DAR 5931'),
('1', '7', '2024-01-27', 'COMMISSION ON REFERRAL FOR SHAKIR ALI. JULY2023 TO DECMBER 2023. , PV 1826 Previous voucher'),
('1', '8', '2024-01-27', 'COMMSSION FOR ASHRAF THODENGAL. JULY TO DEC 2023. pv-1827 previous voucher'),
('1', '9', '2024-01-27', 'COMMISSION FOR SALMAN. JULY TO DECEMBER 2023. pv -1828 previous voucher'),
('0', '45', '2024-01-31', 'accodomadation expense for the month of jan 2024'),
('0', '46', '2024-02-01', 'accodomadation expense for the month of feb 2024'),
('20', '100', '2024-01-24', 'CAFU FUEL EXPENSES FOR THE MONTH OF DECEMBER 2023.'),
('0', '47', '2024-02-20', 'ETISALAT EXPENSES PAID BY SIR KAMRAN.'),
('0', '48', '2024-02-20', 'SALIK EXPENSES PAID BY SIR KAMRAN FOR THE MONTH OF DECEMBER 2023.'),
('0', '49', '2024-02-20', 'CAFU EXPENSES FOR THE MONTH OF DECEMBER 2023. PAID BY SIR KAMRAN.'),
('0', '50', '2024-02-20', 'paid by sir kamran'),
('0', '51', '2024-02-20', 'paid by sir kamran jan 2024 bill'),
('20', '103', '2024-02-08', 'dar 5963, po302'),
('20', '105', '2024-02-21', 'land	04-2271155\n'),
('20', '106', '2024-02-21', 'Abdullah Nepali	056-4118922\n'),
('20', '107', '2024-02-21', 'Ibrar	056-4119771\n'),
('20', '108', '2024-02-21', 'Akhter 	056-4119377\n'),
('20', '109', '2024-02-21', 'Akbar Khan	056-4118929\n'),
('20', '110', '2024-02-21', 'Adeel	056-6815339\n'),
('20', '111', '2024-02-21', 'Unknown- Shoaib	056-5366303\n'),
('20', '112', '2024-02-21', 'Adbullah Kamran	056-4122933\n'),
('20', '113', '2024-02-21', 'Imran	056-4031782\n'),
('0', '52', '2024-02-21', 'etisalat expenses paid by sir kamran.\n\n'),
('20', '114', '2024-01-05', 'dar5926'),
('20', '115', '2024-01-05', 'DAR 5924'),
('20', '116', '2024-01-05', 'dar 5925'),
('20', '117', '2024-01-05', 'DAR 5924'),
('20', '118', '2024-01-09', 'DAR 5930'),
('20', '119', '2024-01-09', 'DAR 5929 ( BRIAN HOWARTH)'),
('20', '120', '2024-01-09', 'DAR 5928'),
('20', '121', '2024-01-09', 'DAR 5928'),
('20', '122', '2024-01-09', 'dar 5927'),
('20', '123', '2024-01-16', 'DAR 5934'),
('20', '124', '2024-01-16', 'DAR 5933'),
('20', '125', '2024-01-16', 'DAR 5933'),
('20', '126', '2024-01-16', 'DAR 5932'),
('20', '128', '2024-01-31', 'SO-146 Unitra International LLC 2023-206 6/1/24'),
('20', '129', '2024-02-15', 'PO-314 , SITE 236 PAVIIMENTO'),
('12', '26', '2024-02-06', 'cash received through arslan'),
('20', '131', '2024-02-08', 'dar 214, po 300'),
('20', '132', '2024-02-08', 'DAR5958 DATED 8/2/24'),
('20', '133', '2024-02-08', 'dar 5963, po302'),
('20', '136', '2024-02-08', 'dar 214, po 300'),
('20', '137', '2024-01-31', 'po-257'),
('20', '138', '2024-01-31', 'PO-258'),
('20', '139', '2024-01-31', 'po-259'),
('20', '140', '2024-01-31', 'PO-260'),
('20', '141', '2024-01-31', 'po-261'),
('20', '142', '2024-01-31', 'PO-264'),
('20', '143', '2024-01-31', 'PO-266'),
('20', '144', '2024-01-31', 'PO-267'),
('20', '145', '2024-01-31', 'PO-267'),
('20', '146', '2024-01-31', 'PO-268'),
('20', '147', '2024-01-31', 'PO-272'),
('20', '148', '2024-01-31', 'PO-275'),
('20', '149', '2024-01-31', 'PO-274'),
('20', '150', '2024-01-31', 'po-277'),
('20', '151', '2024-01-31', 'po-278'),
('20', '152', '2024-01-31', 'po-278'),
('20', '153', '2024-01-31', 'po-278'),
('20', '154', '2024-01-31', 'po-280'),
('20', '155', '2024-01-31', 'po-284'),
('20', '156', '2024-01-31', 'po-287'),
('20', '157', '2024-01-31', 'po-293'),
('20', '158', '2024-01-31', 'po-294'),
('20', '159', '2024-01-31', 'po-296'),
('20', '160', '2024-01-31', 'po-297'),
('20', '161', '2024-01-31', 'po-298'),
('20', '162', '2024-01-31', 'po-299'),
('20', '163', '2024-01-31', 'po-285'),
('20', '164', '2024-01-31', 'po-276'),
('20', '165', '2024-01-31', 'po-285'),
('12', '38', '2024-02-23', 'HBZ Feb22 DERCD105XXX595 Amount 3,135.00 AED Credited/AANI#: 294105  transfer from  GABRIELE ANDREOZZI,'),
('13', '35', '2024-02-23', 'Sales Quotation # SQ-309'),
('10', '36', '2024-02-23', 'Sales Quotation # SQ-309'),
('12', '39', '2024-02-23', 'HBZ Feb22 DERCD105XXX595 Amount 3,633.00 AED Credited/IPI # IPI240222053K0XX From ROCK REPUBLIC LLC 474476 DIP1  Dubai,'),
('20', '166', '2024-02-22', 'ADS PUBLISHED ON WEEKLY NEWS PAPER. JAN 04,11,18,25-2024'),
('0', '53', '2024-01-01', 'medical insurance of employees has been paid by dxbcoast JV-26644'),
('13', '36', '2024-02-24', 'Sales Quotation # SQ-315'),
('10', '37', '2024-02-24', 'Sales Quotation # SQ-315'),
('20', '167', '2024-02-24', 'CAFU EXPENSES FOR THE MONTH OF JANUARY 2024'),
('13', '37', '2024-02-24', 'Sales Quotation # SQ-316'),
('10', '38', '2024-02-24', 'Sales Quotation # SQ-316'),
('13', '38', '2024-02-24', 'Sales Quotation # SQ-317'),
('10', '39', '2024-02-24', 'Sales Quotation # SQ-317'),
('20', '168', '2024-02-27', 'S-77609	ARSLAN	232\nP-25757	SHAKEEL	88\nG-56609	IMRAN	0\nP-26138	AKBAR	44\nR-45327	ABDULLAH	108\n	TOTAL	472\n'),
('0', '56', '2024-02-28', '9007913056 DATED 1/11/23 CHARGED TO AKBAR'),
('0', '57', '2024-02-28', '70033128269 ( 25/1/24 ) - R45327 CHARGED TO IMRAN QASIM'),
('0', '58', '2024-02-28', 'charged to shakeel  ticket no 7033027387 dated 1/1/24 ( P 25757)'),
('0', '59', '2024-02-29', 'salary return from jan 2024 salary'),
('4', '14', '2024-02-29', 'afaq basic salary return'),
('12', '40', '2024-02-29', 'chq no.000078 dated 29/2/24'),
('20', '170', '2024-01-31', 'PO-279'),
('20', '171', '2024-01-31', 'PO-282'),
('20', '172', '2024-01-31', 'PO-286'),
('20', '174', '2024-01-30', '128	SO-72 CARELINE COSMETIC AND CARE LLC OLD SITE OF 2023'),
('20', '175', '2024-01-30', '121	SO-65 JAMTS Tech LLC ( 29/9/23- old site of 2023)'),
('20', '176', '2024-01-30', '124	SO-68 Al Hai Motors \n\n(12/9/23)'),
('20', '177', '2024-01-30', 'Stock 2023 Onwards'),
('20', '178', '2024-01-30', '30/10/23'),
('20', '179', '2024-01-30', 'Stock 2023 Onwards'),
('20', '180', '2024-01-30', '11/9/23'),
('20', '181', '2024-01-31', '4/12/23'),
('20', '182', '2024-01-31', '6/12/23'),
('20', '183', '2024-01-31', '1/12/23'),
('20', '184', '2024-01-31', '2/10/23'),
('20', '185', '2024-01-31', '13/1/24'),
('20', '186', '2024-01-31', 'Stock 2023 Onwards 9/1/24');

### Structure of table `0_company_header` ###

DROP TABLE IF EXISTS `0_company_header`;

CREATE TABLE `0_company_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coy_name` varchar(255) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `postal_address` varchar(255) NOT NULL,
  `domicile` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `fax` varchar(255) NOT NULL,
  `gst_no` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `pic` varchar(255) NOT NULL,
  `del_coy_logo` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_company_header` ###

INSERT INTO `0_company_header` VALUES
('1', 'Company 1', '1', 'Company 1', 'Company 1', '(654) 6-455-6456', 'Company 1', 'Company Test', 'sindh_branch@gmail.com', '', '0'),
('2', 'WayZ Consulting Dubai', '2', 'Ehome Smart Technology Teneral Trading L.L.', 'domicile-ehome', '(971) 1-234-56777', 'fax - ehome', 'GST NO EHOMES', 'ehome@ehome.com', 'wayz_logo.jpg', '0'),
('3', '3 EXPO SHARJAH', '3', 'abu-dhabhi\r\nabu-dhabhi', '3 EXPO SHARJAH', '3 EXPO SHARJAH', '3 EXPO SHARJAH', '3 EXPO SHARJAH', 'expo@gmail.com', 'theonedolce-and-gabbana-the-one-EDP-perfume-women_v3.png', '0'),
('4', 'Company 4', '4', 'Company 4', 'Company 4', '(222) 2-222-4444', '2332323', '33232', 'Company_4@gmail.com', '', '0'),
('5', 'XYZ INC', '7', 'XYZZ', 'Abu Dhabi.', '(314) 2-089-451_', '3142089451', '100212275000003', 'raza789j@gmail.com', 'PP-100X100.png', '0');

### Structure of table `0_complaint` ###

DROP TABLE IF EXISTS `0_complaint`;

CREATE TABLE `0_complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) NOT NULL,
  `complaint_date` date NOT NULL,
  `debtor_no` int(11) NOT NULL,
  `sales_order` int(11) NOT NULL,
  `complaint_type` int(11) NOT NULL,
  `cust_memo` varchar(1000) NOT NULL,
  `user_id` int(11) NOT NULL,
  `responsible_person_name` varchar(1000) NOT NULL,
  `responsible_person_comment` varchar(1000) NOT NULL,
  `decision` varchar(1000) NOT NULL,
  `status` int(11) NOT NULL,
  `close_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_complaint` ###


### Structure of table `0_complaint_types` ###

DROP TABLE IF EXISTS `0_complaint_types`;

CREATE TABLE `0_complaint_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(500) NOT NULL,
  `order_compulsory` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_complaint_types` ###


### Structure of table `0_contact_person` ###

DROP TABLE IF EXISTS `0_contact_person`;

CREATE TABLE `0_contact_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `contact` varchar(100) NOT NULL,
  `contract_type` int(11) NOT NULL,
  `authority` int(11) NOT NULL,
  `sales_type` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_contact_person` ###


### Structure of table `0_countries` ###

DROP TABLE IF EXISTS `0_countries`;

CREATE TABLE `0_countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortname` varchar(3) NOT NULL,
  `name` varchar(150) NOT NULL,
  `phonecode` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_countries` ###

INSERT INTO `0_countries` VALUES
('1', 'AF', 'Afghanistan', '93'),
('2', 'AL', 'Albania', '355'),
('3', 'DZ', 'Algeria', '213'),
('4', 'AS', 'American Samoa', '1684'),
('5', 'AD', 'Andorra', '376'),
('6', 'AO', 'Angola', '244'),
('7', 'AI', 'Anguilla', '1264'),
('8', 'AQ', 'Antarctica', '0'),
('9', 'AG', 'Antigua And Barbuda', '1268'),
('10', 'AR', 'Argentina', '54'),
('11', 'AM', 'Armenia', '374'),
('12', 'AW', 'Aruba', '297'),
('13', 'AU', 'Australia', '61'),
('14', 'AT', 'Austria', '43'),
('15', 'AZ', 'Azerbaijan', '994'),
('16', 'BS', 'Bahamas The', '1242'),
('17', 'BH', 'Bahrain', '973'),
('18', 'BD', 'Bangladesh', '880'),
('19', 'BB', 'Barbados', '1246'),
('20', 'BY', 'Belarus', '375'),
('21', 'BE', 'Belgium', '32'),
('22', 'BZ', 'Belize', '501'),
('23', 'BJ', 'Benin', '229'),
('24', 'BM', 'Bermuda', '1441'),
('25', 'BT', 'Bhutan', '975'),
('26', 'BO', 'Bolivia', '591'),
('27', 'BA', 'Bosnia and Herzegovina', '387'),
('28', 'BW', 'Botswana', '267'),
('29', 'BV', 'Bouvet Island', '0'),
('30', 'BR', 'Brazil', '55'),
('31', 'IO', 'British Indian Ocean Territory', '246'),
('32', 'BN', 'Brunei', '673'),
('33', 'BG', 'Bulgaria', '359'),
('34', 'BF', 'Burkina Faso', '226'),
('35', 'BI', 'Burundi', '257'),
('36', 'KH', 'Cambodia', '855'),
('37', 'CM', 'Cameroon', '237'),
('38', 'CA', 'Canada', '1'),
('39', 'CV', 'Cape Verde', '238'),
('40', 'KY', 'Cayman Islands', '1345'),
('41', 'CF', 'Central African Republic', '236'),
('42', 'TD', 'Chad', '235'),
('43', 'CL', 'Chile', '56'),
('44', 'CN', 'China', '86'),
('45', 'CX', 'Christmas Island', '61'),
('46', 'CC', 'Cocos (Keeling) Islands', '672'),
('47', 'CO', 'Colombia', '57'),
('48', 'KM', 'Comoros', '269'),
('49', 'CG', 'Republic Of The Congo', '242'),
('50', 'CD', 'Democratic Republic Of The Congo', '242'),
('51', 'CK', 'Cook Islands', '682'),
('52', 'CR', 'Costa Rica', '506'),
('53', 'CI', 'Cote D&#039;Ivoire (Ivory Coast)', '225'),
('54', 'HR', 'Croatia (Hrvatska)', '385'),
('55', 'CU', 'Cuba', '53'),
('56', 'CY', 'Cyprus', '357'),
('57', 'CZ', 'Czech Republic', '420'),
('58', 'DK', 'Denmark', '45'),
('59', 'DJ', 'Djibouti', '253'),
('60', 'DM', 'Dominica', '1767'),
('61', 'DO', 'Dominican Republic', '1809'),
('62', 'TP', 'East Timor', '670'),
('63', 'EC', 'Ecuador', '593'),
('64', 'EG', 'Egypt', '20'),
('65', 'SV', 'El Salvador', '503'),
('66', 'GQ', 'Equatorial Guinea', '240'),
('67', 'ER', 'Eritrea', '291'),
('68', 'EE', 'Estonia', '372'),
('69', 'ET', 'Ethiopia', '251'),
('70', 'XA', 'External Territories of Australia', '61'),
('71', 'FK', 'Falkland Islands', '500'),
('72', 'FO', 'Faroe Islands', '298'),
('73', 'FJ', 'Fiji Islands', '679'),
('74', 'FI', 'Finland', '358'),
('75', 'FR', 'France', '33'),
('76', 'GF', 'French Guiana', '594'),
('77', 'PF', 'French Polynesia', '689'),
('78', 'TF', 'French Southern Territories', '0'),
('79', 'GA', 'Gabon', '241'),
('80', 'GM', 'Gambia The', '220'),
('81', 'GE', 'Georgia', '995'),
('82', 'DE', 'Germany', '49'),
('83', 'GH', 'Ghana', '233'),
('84', 'GI', 'Gibraltar', '350'),
('85', 'GR', 'Greece', '30'),
('86', 'GL', 'Greenland', '299'),
('87', 'GD', 'Grenada', '1473'),
('88', 'GP', 'Guadeloupe', '590'),
('89', 'GU', 'Guam', '1671'),
('90', 'GT', 'Guatemala', '502'),
('91', 'XU', 'Guernsey and Alderney', '44'),
('92', 'GN', 'Guinea', '224'),
('93', 'GW', 'Guinea-Bissau', '245'),
('94', 'GY', 'Guyana', '592'),
('95', 'HT', 'Haiti', '509'),
('96', 'HM', 'Heard and McDonald Islands', '0'),
('97', 'HN', 'Honduras', '504'),
('98', 'HK', 'Hong Kong S.A.R.', '852'),
('99', 'HU', 'Hungary', '36'),
('100', 'IS', 'Iceland', '354'),
('101', 'IN', 'India', '91'),
('102', 'ID', 'Indonesia', '62'),
('103', 'IR', 'Iran', '98'),
('104', 'IQ', 'Iraq', '964'),
('105', 'IE', 'Ireland', '353'),
('106', 'IL', 'Israel', '972'),
('107', 'IT', 'Italy', '39'),
('108', 'JM', 'Jamaica', '1876'),
('109', 'JP', 'Japan', '81'),
('110', 'XJ', 'Jersey', '44'),
('111', 'JO', 'Jordan', '962'),
('112', 'KZ', 'Kazakhstan', '7'),
('113', 'KE', 'Kenya', '254'),
('114', 'KI', 'Kiribati', '686'),
('115', 'KP', 'Korea North', '850'),
('116', 'KR', 'Korea South', '82'),
('117', 'KW', 'Kuwait', '965'),
('118', 'KG', 'Kyrgyzstan', '996'),
('119', 'LA', 'Laos', '856'),
('120', 'LV', 'Latvia', '371'),
('121', 'LB', 'Lebanon', '961'),
('122', 'LS', 'Lesotho', '266'),
('123', 'LR', 'Liberia', '231'),
('124', 'LY', 'Libya', '218'),
('125', 'LI', 'Liechtenstein', '423'),
('126', 'LT', 'Lithuania', '370'),
('127', 'LU', 'Luxembourg', '352'),
('128', 'MO', 'Macau S.A.R.', '853'),
('129', 'MK', 'Macedonia', '389'),
('130', 'MG', 'Madagascar', '261'),
('131', 'MW', 'Malawi', '265'),
('132', 'MY', 'Malaysia', '60'),
('133', 'MV', 'Maldives', '960'),
('134', 'ML', 'Mali', '223'),
('135', 'MT', 'Malta', '356'),
('136', 'XM', 'Man (Isle of)', '44'),
('137', 'MH', 'Marshall Islands', '692'),
('138', 'MQ', 'Martinique', '596'),
('139', 'MR', 'Mauritania', '222'),
('140', 'MU', 'Mauritius', '230'),
('141', 'YT', 'Mayotte', '269'),
('142', 'MX', 'Mexico', '52'),
('143', 'FM', 'Micronesia', '691'),
('144', 'MD', 'Moldova', '373'),
('145', 'MC', 'Monaco', '377'),
('146', 'MN', 'Mongolia', '976'),
('147', 'MS', 'Montserrat', '1664'),
('148', 'MA', 'Morocco', '212'),
('149', 'MZ', 'Mozambique', '258'),
('150', 'MM', 'Myanmar', '95'),
('151', 'NA', 'Namibia', '264'),
('152', 'NR', 'Nauru', '674'),
('153', 'NP', 'Nepal', '977'),
('154', 'AN', 'Netherlands Antilles', '599'),
('155', 'NL', 'Netherlands The', '31'),
('156', 'NC', 'New Caledonia', '687'),
('157', 'NZ', 'New Zealand', '64'),
('158', 'NI', 'Nicaragua', '505'),
('159', 'NE', 'Niger', '227'),
('160', 'NG', 'Nigeria', '234'),
('161', 'NU', 'Niue', '683'),
('162', 'NF', 'Norfolk Island', '672'),
('163', 'MP', 'Northern Mariana Islands', '1670'),
('164', 'NO', 'Norway', '47'),
('165', 'OM', 'Oman', '968'),
('166', 'PK', 'Pakistan', '92'),
('167', 'PW', 'Palau', '680'),
('168', 'PS', 'Palestinian Territory Occupied', '970'),
('169', 'PA', 'Panama', '507'),
('170', 'PG', 'Papua new Guinea', '675'),
('171', 'PY', 'Paraguay', '595'),
('172', 'PE', 'Peru', '51'),
('173', 'PH', 'Philippines', '63'),
('174', 'PN', 'Pitcairn Island', '0'),
('175', 'PL', 'Poland', '48'),
('176', 'PT', 'Portugal', '351'),
('177', 'PR', 'Puerto Rico', '1787'),
('178', 'QA', 'Qatar', '974'),
('179', 'RE', 'Reunion', '262'),
('180', 'RO', 'Romania', '40'),
('181', 'RU', 'Russia', '70'),
('182', 'RW', 'Rwanda', '250'),
('183', 'SH', 'Saint Helena', '290'),
('184', 'KN', 'Saint Kitts And Nevis', '1869'),
('185', 'LC', 'Saint Lucia', '1758'),
('186', 'PM', 'Saint Pierre and Miquelon', '508'),
('187', 'VC', 'Saint Vincent And The Grenadines', '1784'),
('188', 'WS', 'Samoa', '684'),
('189', 'SM', 'San Marino', '378'),
('190', 'ST', 'Sao Tome and Principe', '239'),
('191', 'SA', 'Saudi Arabia', '966'),
('192', 'SN', 'Senegal', '221'),
('193', 'RS', 'Serbia', '381'),
('194', 'SC', 'Seychelles', '248'),
('195', 'SL', 'Sierra Leone', '232'),
('196', 'SG', 'Singapore', '65'),
('197', 'SK', 'Slovakia', '421'),
('198', 'SI', 'Slovenia', '386'),
('199', 'XG', 'Smaller Territories of the UK', '44'),
('200', 'SB', 'Solomon Islands', '677'),
('201', 'SO', 'Somalia', '252'),
('202', 'ZA', 'South Africa', '27'),
('203', 'GS', 'South Georgia', '0'),
('204', 'SS', 'South Sudan', '211'),
('205', 'ES', 'Spain', '34'),
('206', 'LK', 'Sri Lanka', '94'),
('207', 'SD', 'Sudan', '249'),
('208', 'SR', 'Suriname', '597'),
('209', 'SJ', 'Svalbard And Jan Mayen Islands', '47'),
('210', 'SZ', 'Swaziland', '268'),
('211', 'SE', 'Sweden', '46'),
('212', 'CH', 'Switzerland', '41'),
('213', 'SY', 'Syria', '963'),
('214', 'TW', 'Taiwan', '886'),
('215', 'TJ', 'Tajikistan', '992'),
('216', 'TZ', 'Tanzania', '255'),
('217', 'TH', 'Thailand', '66'),
('218', 'TG', 'Togo', '228'),
('219', 'TK', 'Tokelau', '690'),
('220', 'TO', 'Tonga', '676'),
('221', 'TT', 'Trinidad And Tobago', '1868'),
('222', 'TN', 'Tunisia', '216'),
('223', 'TR', 'Turkey', '90'),
('224', 'TM', 'Turkmenistan', '7370'),
('225', 'TC', 'Turks And Caicos Islands', '1649'),
('226', 'TV', 'Tuvalu', '688'),
('227', 'UG', 'Uganda', '256'),
('228', 'UA', 'Ukraine', '380'),
('229', 'AE', 'United Arab Emirates', '971'),
('230', 'GB', 'United Kingdom', '44'),
('231', 'US', 'United States', '1'),
('232', 'UM', 'United States Minor Outlying Islands', '1'),
('233', 'UY', 'Uruguay', '598'),
('234', 'UZ', 'Uzbekistan', '998'),
('235', 'VU', 'Vanuatu', '678'),
('236', 'VA', 'Vatican City State (Holy See)', '39'),
('237', 'VE', 'Venezuela', '58'),
('238', 'VN', 'Vietnam', '84'),
('239', 'VG', 'Virgin Islands (British)', '1284'),
('240', 'VI', 'Virgin Islands (US)', '1340'),
('241', 'WF', 'Wallis And Futuna Islands', '681'),
('242', 'EH', 'Western Sahara', '212'),
('243', 'YE', 'Yemen', '967'),
('244', 'YU', 'Yugoslavia', '38'),
('245', 'ZM', 'Zambia', '260'),
('246', 'ZW', 'Zimbabwe', '263');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('6', 'Active', '0', '0'),
('7', 'Inactive', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` tinytext NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_comments` ###

DROP TABLE IF EXISTS `0_crm_comments`;

CREATE TABLE `0_crm_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL,
  `branch_code` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `comment` varchar(5000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_crm_comments` ###


### Structure of table `0_crm_contact_form` ###

DROP TABLE IF EXISTS `0_crm_contact_form`;

CREATE TABLE `0_crm_contact_form` (
  `cust_id` int(11) NOT NULL AUTO_INCREMENT,
  `cont_per` varchar(100) NOT NULL,
  `comp_name` varchar(100) NOT NULL,
  `desg` varchar(100) NOT NULL,
  `user` int(11) NOT NULL,
  `trans_date` varchar(100) NOT NULL,
  `web` varchar(200) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `sec_phone` varchar(100) NOT NULL,
  `email_addr` varchar(100) NOT NULL,
  `mobile` varchar(100) NOT NULL,
  `mobile_1` varchar(100) NOT NULL,
  `fax` varchar(100) NOT NULL,
  `postal_address` varchar(200) NOT NULL,
  `attach_front` varchar(300) NOT NULL,
  `attach_back` varchar(300) NOT NULL,
  PRIMARY KEY (`cust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_crm_contact_form` ###


### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `entity_id` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=704 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'supplier', 'general', '1'),
('4', '3', 'cust_branch', 'general', '2'),
('5', '3', 'customer', 'general', '3'),
('6', '4', 'cust_branch', 'general', '3'),
('7', '4', 'customer', 'general', '4'),
('8', '5', 'cust_branch', 'general', '4'),
('9', '5', 'customer', 'general', '5'),
('10', '6', 'cust_branch', 'general', '5'),
('11', '6', 'customer', 'general', '6'),
('12', '7', 'cust_branch', 'general', '6'),
('13', '7', 'customer', 'general', '7'),
('14', '8', 'cust_branch', 'general', '7'),
('15', '8', 'customer', 'general', '8'),
('16', '9', 'cust_branch', 'general', '8'),
('17', '9', 'customer', 'general', '9'),
('20', '11', 'cust_branch', 'general', '10'),
('21', '11', 'customer', 'general', '11'),
('22', '12', 'cust_branch', 'general', '11'),
('23', '12', 'customer', 'general', '12'),
('24', '13', 'cust_branch', 'general', '12'),
('25', '13', 'customer', 'general', '13'),
('26', '14', 'cust_branch', 'general', '13'),
('27', '14', 'customer', 'general', '14'),
('28', '15', 'cust_branch', 'general', '14'),
('29', '15', 'customer', 'general', '15'),
('30', '16', 'cust_branch', 'general', '15'),
('31', '16', 'customer', 'general', '16'),
('32', '17', 'cust_branch', 'general', '16'),
('33', '17', 'customer', 'general', '17'),
('34', '18', 'cust_branch', 'general', '17'),
('35', '18', 'customer', 'general', '18'),
('36', '19', 'cust_branch', 'general', '18'),
('37', '19', 'customer', 'general', '19'),
('38', '20', 'cust_branch', 'general', '19'),
('39', '20', 'customer', 'general', '20'),
('40', '21', 'cust_branch', 'general', '20'),
('41', '21', 'customer', 'general', '21'),
('42', '22', 'cust_branch', 'general', '21'),
('43', '22', 'customer', 'general', '22'),
('44', '23', 'cust_branch', 'general', '22'),
('45', '23', 'customer', 'general', '23'),
('46', '24', 'cust_branch', 'general', '23'),
('47', '24', 'customer', 'general', '24'),
('48', '25', 'cust_branch', 'general', '24'),
('49', '25', 'customer', 'general', '25'),
('50', '26', 'cust_branch', 'general', '25'),
('51', '26', 'customer', 'general', '26'),
('52', '27', 'cust_branch', 'general', '26'),
('53', '27', 'customer', 'general', '27'),
('54', '28', 'cust_branch', 'general', '27'),
('55', '28', 'customer', 'general', '28'),
('56', '29', 'cust_branch', 'general', '28'),
('57', '29', 'customer', 'general', '29'),
('58', '30', 'cust_branch', 'general', '29'),
('59', '30', 'customer', 'general', '30'),
('60', '31', 'cust_branch', 'general', '30'),
('61', '31', 'customer', 'general', '31'),
('62', '32', 'cust_branch', 'general', '31'),
('63', '32', 'customer', 'general', '32'),
('64', '33', 'cust_branch', 'general', '32'),
('65', '33', 'customer', 'general', '33'),
('66', '34', 'cust_branch', 'general', '33'),
('67', '34', 'customer', 'general', '34'),
('68', '35', 'cust_branch', 'general', '34'),
('69', '35', 'customer', 'general', '35'),
('70', '36', 'cust_branch', 'general', '35'),
('71', '36', 'customer', 'general', '36'),
('72', '37', 'cust_branch', 'general', '36'),
('73', '37', 'customer', 'general', '37'),
('74', '38', 'cust_branch', 'general', '37'),
('75', '38', 'customer', 'general', '38'),
('76', '39', 'cust_branch', 'general', '38'),
('77', '39', 'customer', 'general', '39'),
('78', '40', 'cust_branch', 'general', '39'),
('79', '40', 'customer', 'general', '40'),
('80', '41', 'cust_branch', 'general', '40'),
('81', '41', 'customer', 'general', '41'),
('82', '42', 'cust_branch', 'general', '41'),
('83', '42', 'customer', 'general', '42'),
('84', '43', 'cust_branch', 'general', '42'),
('85', '43', 'customer', 'general', '43'),
('86', '44', 'cust_branch', 'general', '43'),
('87', '44', 'customer', 'general', '44'),
('88', '45', 'cust_branch', 'general', '44'),
('89', '45', 'customer', 'general', '45'),
('90', '46', 'cust_branch', 'general', '45'),
('91', '46', 'customer', 'general', '46'),
('92', '47', 'cust_branch', 'general', '46'),
('93', '47', 'customer', 'general', '47'),
('94', '48', 'cust_branch', 'general', '47'),
('95', '48', 'customer', 'general', '48'),
('96', '49', 'cust_branch', 'general', '48'),
('97', '49', 'customer', 'general', '49'),
('98', '50', 'cust_branch', 'general', '49'),
('99', '50', 'customer', 'general', '50'),
('100', '51', 'cust_branch', 'general', '50'),
('101', '51', 'customer', 'general', '51'),
('102', '52', 'cust_branch', 'general', '51'),
('103', '52', 'customer', 'general', '52'),
('104', '53', 'cust_branch', 'general', '52'),
('105', '53', 'customer', 'general', '53'),
('106', '54', 'cust_branch', 'general', '53'),
('107', '54', 'customer', 'general', '54'),
('108', '55', 'cust_branch', 'general', '54'),
('109', '55', 'customer', 'general', '55'),
('110', '56', 'cust_branch', 'general', '55'),
('111', '56', 'customer', 'general', '56'),
('112', '57', 'cust_branch', 'general', '56'),
('114', '58', 'cust_branch', 'general', '57'),
('115', '58', 'customer', 'general', '58'),
('116', '59', 'cust_branch', 'general', '58'),
('117', '59', 'customer', 'general', '59'),
('118', '60', 'cust_branch', 'general', '59'),
('119', '60', 'customer', 'general', '60'),
('120', '61', 'cust_branch', 'general', '60'),
('121', '61', 'customer', 'general', '61'),
('122', '62', 'cust_branch', 'general', '61'),
('123', '62', 'customer', 'general', '62'),
('124', '63', 'cust_branch', 'general', '62'),
('125', '63', 'customer', 'general', '63'),
('126', '64', 'cust_branch', 'general', '63'),
('127', '64', 'customer', 'general', '64'),
('128', '65', 'cust_branch', 'general', '64'),
('129', '65', 'customer', 'general', '65'),
('130', '66', 'cust_branch', 'general', '65'),
('131', '66', 'customer', 'general', '66'),
('132', '67', 'cust_branch', 'general', '66'),
('133', '67', 'customer', 'general', '67'),
('134', '68', 'cust_branch', 'general', '67'),
('135', '68', 'customer', 'general', '68'),
('136', '69', 'cust_branch', 'general', '68'),
('137', '69', 'customer', 'general', '69'),
('138', '70', 'cust_branch', 'general', '69'),
('139', '70', 'customer', 'general', '70'),
('140', '71', 'cust_branch', 'general', '70'),
('141', '71', 'customer', 'general', '71'),
('142', '72', 'cust_branch', 'general', '71'),
('143', '72', 'customer', 'general', '72'),
('144', '73', 'supplier', 'general', '2'),
('145', '74', 'supplier', 'general', '3'),
('146', '75', 'supplier', 'general', '4'),
('147', '76', 'supplier', 'general', '5'),
('148', '77', 'supplier', 'general', '6'),
('149', '78', 'supplier', 'general', '7'),
('150', '79', 'supplier', 'general', '8'),
('151', '80', 'supplier', 'general', '9'),
('152', '81', 'supplier', 'general', '10'),
('153', '82', 'supplier', 'general', '11'),
('154', '83', 'supplier', 'general', '12'),
('155', '84', 'supplier', 'general', '13'),
('156', '85', 'supplier', 'general', '14'),
('157', '86', 'supplier', 'general', '15'),
('158', '87', 'supplier', 'general', '16'),
('159', '88', 'supplier', 'general', '17'),
('160', '89', 'supplier', 'general', '18'),
('161', '90', 'supplier', 'general', '19'),
('162', '91', 'supplier', 'general', '20'),
('163', '92', 'supplier', 'general', '21'),
('164', '93', 'supplier', 'general', '22'),
('165', '94', 'supplier', 'general', '23'),
('166', '95', 'supplier', 'general', '24'),
('167', '96', 'supplier', 'general', '25'),
('168', '97', 'supplier', 'general', '26'),
('169', '98', 'supplier', 'general', '27'),
('170', '99', 'supplier', 'general', '28'),
('171', '100', 'supplier', 'general', '29'),
('172', '101', 'supplier', 'general', '30'),
('173', '102', 'supplier', 'general', '31'),
('174', '103', 'supplier', 'general', '32'),
('175', '104', 'supplier', 'general', '33'),
('176', '105', 'supplier', 'general', '34'),
('177', '106', 'cust_branch', 'general', '72'),
('178', '106', 'customer', 'general', '73'),
('179', '107', 'supplier', 'general', '35'),
('180', '108', 'cust_branch', 'general', '73'),
('181', '108', 'customer', 'general', '74'),
('182', '109', 'supplier', 'general', '36'),
('183', '110', 'cust_branch', 'general', '74'),
('184', '110', 'customer', 'general', '75'),
('185', '111', 'cust_branch', 'general', '75'),
('186', '111', 'customer', 'general', '78'),
('187', '112', 'cust_branch', 'general', '76'),
('188', '112', 'customer', 'general', '79'),
('189', '113', 'supplier', 'general', '37'),
('190', '114', 'supplier', 'general', '38'),
('191', '115', 'supplier', 'general', '39'),
('192', '116', 'supplier', 'general', '40'),
('193', '117', 'supplier', 'general', '41'),
('194', '118', 'supplier', 'general', '42'),
('195', '119', 'supplier', 'general', '43'),
('196', '120', 'cust_branch', 'general', '77'),
('197', '120', 'customer', 'general', '80'),
('198', '121', 'supplier', 'general', '44'),
('199', '122', 'supplier', 'general', '45'),
('200', '123', 'cust_branch', 'general', '78'),
('201', '123', 'customer', 'general', '81'),
('202', '124', 'supplier', 'general', '46'),
('203', '125', 'supplier', 'general', '47'),
('204', '126', 'cust_branch', 'general', '79'),
('205', '126', 'customer', 'general', '82'),
('206', '127', 'supplier', 'general', '48'),
('207', '128', 'supplier', 'general', '49'),
('208', '129', 'supplier', 'general', '50'),
('209', '130', 'supplier', 'general', '51'),
('210', '131', 'supplier', 'general', '52'),
('211', '132', 'supplier', 'general', '53'),
('212', '133', 'cust_branch', 'general', '80'),
('213', '133', 'customer', 'general', '83'),
('214', '134', 'supplier', 'general', '54'),
('215', '135', 'supplier', 'general', '55'),
('216', '136', 'cust_branch', 'general', '81'),
('217', '136', 'customer', 'general', '84'),
('218', '137', 'supplier', 'general', '56'),
('219', '138', 'cust_branch', 'general', '82'),
('220', '138', 'customer', 'general', '85'),
('221', '139', 'supplier', 'general', '57'),
('222', '140', 'supplier', 'general', '58'),
('223', '141', 'cust_branch', 'general', '83'),
('224', '141', 'customer', 'general', '86'),
('225', '142', 'supplier', 'general', '59'),
('226', '143', 'cust_branch', 'general', '84'),
('228', '144', 'supplier', 'general', '60'),
('229', '145', 'supplier', 'general', '61'),
('230', '146', 'cust_branch', 'general', '85'),
('231', '146', 'customer', 'general', '88'),
('232', '147', 'supplier', 'general', '62'),
('233', '148', 'cust_branch', 'general', '86'),
('234', '148', 'customer', 'general', '89'),
('235', '149', 'cust_branch', 'general', '87'),
('236', '149', 'customer', 'general', '90'),
('237', '150', 'cust_branch', 'general', '88'),
('238', '150', 'customer', 'general', '91'),
('239', '151', 'cust_branch', 'general', '89'),
('240', '151', 'customer', 'general', '92'),
('241', '152', 'supplier', 'general', '63'),
('242', '153', 'supplier', 'general', '64'),
('243', '154', 'cust_branch', 'general', '90'),
('244', '154', 'customer', 'general', '93'),
('245', '155', 'supplier', 'general', '65'),
('246', '156', 'supplier', 'general', '66'),
('247', '157', 'supplier', 'general', '67'),
('248', '158', 'supplier', 'general', '68'),
('249', '159', 'supplier', 'general', '69'),
('250', '160', 'supplier', 'general', '70'),
('251', '161', 'supplier', 'general', '71'),
('252', '162', 'supplier', 'general', '72'),
('253', '163', 'supplier', 'general', '73'),
('254', '164', 'supplier', 'general', '74'),
('255', '165', 'supplier', 'general', '75'),
('256', '166', 'supplier', 'general', '76'),
('257', '167', 'supplier', 'general', '77'),
('258', '168', 'supplier', 'general', '78'),
('259', '169', 'supplier', 'general', '79'),
('260', '170', 'supplier', 'general', '80'),
('261', '171', 'supplier', 'general', '81'),
('262', '172', 'supplier', 'general', '82'),
('263', '173', 'cust_branch', 'general', '91'),
('264', '173', 'customer', 'general', '94'),
('265', '174', 'cust_branch', 'general', '92'),
('266', '174', 'customer', 'general', '95'),
('267', '175', 'supplier', 'general', '83'),
('268', '176', 'cust_branch', 'general', '93'),
('269', '176', 'customer', 'general', '96'),
('270', '177', 'cust_branch', 'general', '94'),
('271', '177', 'customer', 'general', '97'),
('272', '178', 'cust_branch', 'general', '95'),
('273', '178', 'customer', 'general', '98'),
('274', '179', 'cust_branch', 'general', '96'),
('275', '179', 'customer', 'general', '99'),
('276', '180', 'supplier', 'general', '84'),
('277', '181', 'supplier', 'general', '85'),
('278', '182', 'supplier', 'general', '86'),
('279', '183', 'cust_branch', 'general', '97'),
('280', '183', 'customer', 'general', '100'),
('281', '184', 'cust_branch', 'general', '98'),
('282', '184', 'customer', 'general', '101'),
('283', '185', 'cust_branch', 'general', '99'),
('284', '185', 'customer', 'general', '102'),
('285', '186', 'supplier', 'general', '87'),
('286', '187', 'cust_branch', 'general', '100'),
('287', '187', 'customer', 'general', '103'),
('288', '188', 'cust_branch', 'general', '101'),
('289', '188', 'customer', 'general', '104'),
('290', '189', 'cust_branch', 'general', '102'),
('291', '189', 'customer', 'general', '105'),
('292', '57', 'customer', 'general', '57'),
('293', '190', 'supplier', 'general', '88'),
('294', '191', 'supplier', 'general', '89'),
('295', '192', 'cust_branch', 'general', '103'),
('297', '192', 'customer', 'general', '106'),
('298', '193', 'cust_branch', 'general', '104'),
('299', '193', 'customer', 'general', '107'),
('300', '194', 'cust_branch', 'general', '105'),
('301', '194', 'customer', 'general', '108'),
('302', '195', 'cust_branch', 'general', '106'),
('303', '195', 'customer', 'general', '109'),
('304', '196', 'supplier', 'general', '90'),
('305', '197', 'cust_branch', 'general', '107'),
('306', '197', 'customer', 'general', '110'),
('307', '198', 'cust_branch', 'general', '108'),
('308', '198', 'customer', 'general', '111'),
('309', '199', 'cust_branch', 'general', '109'),
('310', '199', 'customer', 'general', '112'),
('311', '200', 'cust_branch', 'general', '110'),
('312', '200', 'customer', 'general', '113'),
('313', '201', 'supplier', 'general', '91'),
('314', '202', 'supplier', 'general', '92'),
('315', '203', 'supplier', 'general', '93'),
('316', '204', 'cust_branch', 'general', '111'),
('317', '204', 'customer', 'general', '114'),
('318', '205', 'cust_branch', 'general', '112'),
('319', '205', 'customer', 'general', '115'),
('321', '206', 'customer', 'general', '116'),
('322', '207', 'supplier', 'general', '94'),
('323', '208', 'cust_branch', 'general', '114'),
('324', '208', 'customer', 'general', '117'),
('325', '209', 'cust_branch', 'general', '115'),
('326', '209', 'customer', 'general', '118'),
('327', '210', 'cust_branch', 'general', '116'),
('328', '210', 'customer', 'general', '119'),
('329', '211', 'supplier', 'general', '95'),
('330', '212', 'supplier', 'general', '96'),
('331', '213', 'supplier', 'general', '97'),
('332', '214', 'supplier', 'general', '98'),
('333', '215', 'cust_branch', 'general', '117'),
('334', '215', 'customer', 'general', '120'),
('335', '216', 'cust_branch', 'general', '118'),
('336', '216', 'customer', 'general', '121'),
('337', '217', 'supplier', 'general', '99'),
('338', '218', 'supplier', 'general', '100'),
('339', '219', 'supplier', 'general', '101'),
('340', '220', 'supplier', 'general', '102'),
('341', '221', 'supplier', 'general', '103'),
('342', '222', 'supplier', 'general', '104'),
('343', '223', 'supplier', 'general', '105'),
('344', '224', 'supplier', 'general', '106'),
('345', '225', 'supplier', 'general', '107'),
('346', '226', 'supplier', 'general', '108'),
('347', '227', 'supplier', 'general', '109'),
('348', '228', 'supplier', 'general', '110'),
('349', '229', 'cust_branch', 'general', '119'),
('350', '229', 'customer', 'general', '123'),
('352', '231', 'supplier', 'general', '111'),
('353', '232', 'supplier', 'general', '112'),
('354', '233', 'cust_branch', 'general', '121'),
('355', '233', 'customer', 'general', '124'),
('356', '234', 'cust_branch', 'general', '122'),
('357', '234', 'customer', 'general', '125'),
('358', '235', 'supplier', 'general', '113'),
('359', '236', 'cust_branch', 'general', '123'),
('360', '236', 'customer', 'general', '126'),
('361', '237', 'supplier', 'general', '114'),
('363', '206', 'cust_branch', 'general', '113'),
('364', '239', 'cust_branch', 'general', '125'),
('365', '239', 'customer', 'general', '127'),
('366', '240', 'cust_branch', 'general', '126'),
('367', '240', 'customer', 'general', '128'),
('368', '241', 'cust_branch', 'general', '127'),
('369', '241', 'customer', 'general', '130'),
('370', '242', 'cust_branch', 'general', '128'),
('371', '242', 'customer', 'general', '131'),
('372', '243', 'cust_branch', 'general', '129'),
('373', '243', 'customer', 'general', '132'),
('374', '244', 'cust_branch', 'general', '130'),
('375', '244', 'customer', 'general', '133'),
('376', '245', 'cust_branch', 'general', '131'),
('377', '245', 'customer', 'general', '134'),
('378', '246', 'cust_branch', 'general', '132'),
('379', '246', 'customer', 'general', '135'),
('380', '247', 'cust_branch', 'general', '133'),
('381', '247', 'customer', 'general', '136'),
('382', '248', 'supplier', 'general', '115'),
('383', '249', 'cust_branch', 'general', '134'),
('384', '249', 'customer', 'general', '137'),
('385', '250', 'cust_branch', 'general', '135'),
('386', '250', 'customer', 'general', '138'),
('387', '251', 'cust_branch', 'general', '136'),
('388', '251', 'customer', 'general', '139'),
('391', '253', 'supplier', 'general', '116'),
('392', '254', 'cust_branch', 'general', '138'),
('393', '254', 'customer', 'general', '141'),
('394', '255', 'supplier', 'general', '117'),
('395', '256', 'cust_branch', 'general', '139'),
('396', '256', 'customer', 'general', '142'),
('397', '257', 'supplier', 'general', '118'),
('398', '258', 'supplier', 'general', '119'),
('399', '259', 'cust_branch', 'general', '140'),
('400', '259', 'customer', 'general', '143'),
('401', '260', 'cust_branch', 'general', '141'),
('402', '260', 'customer', 'general', '144'),
('403', '261', 'cust_branch', 'general', '142'),
('404', '261', 'customer', 'general', '145'),
('405', '262', 'supplier', 'general', '120'),
('406', '263', 'supplier', 'general', '121'),
('407', '264', 'supplier', 'general', '122'),
('408', '265', 'supplier', 'general', '123'),
('409', '266', 'cust_branch', 'general', '143'),
('410', '266', 'customer', 'general', '146'),
('411', '267', 'supplier', 'general', '124'),
('412', '268', 'cust_branch', 'general', '144'),
('413', '268', 'customer', 'general', '147'),
('414', '269', 'supplier', 'general', '125'),
('415', '270', 'supplier', 'general', '126'),
('416', '271', 'supplier', 'general', '127'),
('417', '272', 'supplier', 'general', '128'),
('418', '273', 'supplier', 'general', '129'),
('419', '274', 'cust_branch', 'general', '145'),
('420', '274', 'customer', 'general', '148'),
('421', '275', 'cust_branch', 'general', '146'),
('422', '275', 'customer', 'general', '149'),
('423', '276', 'cust_branch', 'general', '147'),
('424', '276', 'customer', 'general', '150'),
('425', '277', 'cust_branch', 'general', '148'),
('426', '277', 'customer', 'general', '151'),
('427', '278', 'cust_branch', 'general', '149'),
('428', '278', 'customer', 'general', '152'),
('429', '279', 'cust_branch', 'general', '150'),
('430', '279', 'customer', 'general', '153'),
('431', '280', 'cust_branch', 'general', '151'),
('432', '280', 'customer', 'general', '154'),
('433', '281', 'cust_branch', 'general', '152'),
('434', '281', 'customer', 'general', '155'),
('435', '282', 'cust_branch', 'general', '153'),
('436', '282', 'customer', 'general', '156'),
('437', '283', 'cust_branch', 'general', '154'),
('438', '283', 'customer', 'general', '157'),
('439', '284', 'cust_branch', 'general', '155'),
('440', '284', 'customer', 'general', '158'),
('441', '285', 'supplier', 'general', '130'),
('442', '286', 'cust_branch', 'general', '156'),
('443', '286', 'customer', 'general', '159'),
('444', '287', 'cust_branch', 'general', '157'),
('445', '287', 'customer', 'general', '160'),
('446', '288', 'cust_branch', 'general', '158'),
('447', '288', 'customer', 'general', '161'),
('448', '289', 'cust_branch', 'general', '159'),
('449', '289', 'customer', 'general', '162'),
('450', '290', 'cust_branch', 'general', '160'),
('451', '290', 'customer', 'general', '163'),
('452', '291', 'cust_branch', 'general', '161'),
('453', '291', 'customer', 'general', '164'),
('454', '292', 'cust_branch', 'general', '162'),
('455', '292', 'customer', 'general', '165'),
('456', '293', 'cust_branch', 'general', '163'),
('457', '293', 'customer', 'general', '166'),
('458', '294', 'cust_branch', 'general', '164'),
('459', '294', 'customer', 'general', '167'),
('460', '295', 'cust_branch', 'general', '165'),
('461', '295', 'customer', 'general', '168'),
('462', '296', 'cust_branch', 'general', '166'),
('463', '296', 'customer', 'general', '169'),
('464', '297', 'cust_branch', 'general', '167'),
('465', '297', 'customer', 'general', '170'),
('466', '298', 'cust_branch', 'general', '168'),
('467', '298', 'customer', 'general', '171'),
('468', '299', 'cust_branch', 'general', '169'),
('469', '299', 'customer', 'general', '172'),
('470', '300', 'cust_branch', 'general', '170'),
('471', '300', 'customer', 'general', '173'),
('472', '301', 'cust_branch', 'general', '171'),
('473', '301', 'customer', 'general', '174'),
('474', '302', 'cust_branch', 'general', '172'),
('475', '302', 'customer', 'general', '175'),
('476', '303', 'cust_branch', 'general', '173'),
('477', '303', 'customer', 'general', '176'),
('478', '304', 'cust_branch', 'general', '174'),
('479', '304', 'customer', 'general', '177'),
('480', '305', 'cust_branch', 'general', '175'),
('481', '305', 'customer', 'general', '179'),
('482', '306', 'cust_branch', 'general', '176'),
('483', '306', 'customer', 'general', '180'),
('484', '307', 'cust_branch', 'general', '177'),
('485', '307', 'customer', 'general', '181'),
('486', '308', 'cust_branch', 'general', '178'),
('487', '308', 'customer', 'general', '182'),
('488', '309', 'cust_branch', 'general', '179'),
('489', '309', 'customer', 'general', '183'),
('490', '310', 'cust_branch', 'general', '180'),
('491', '310', 'customer', 'general', '184'),
('492', '311', 'cust_branch', 'general', '181'),
('493', '311', 'customer', 'general', '185'),
('494', '312', 'cust_branch', 'general', '182'),
('495', '312', 'customer', 'general', '186'),
('496', '313', 'cust_branch', 'general', '183'),
('497', '313', 'customer', 'general', '187'),
('498', '314', 'cust_branch', 'general', '184'),
('499', '314', 'customer', 'general', '188'),
('500', '315', 'cust_branch', 'general', '185'),
('501', '315', 'customer', 'general', '189'),
('502', '316', 'cust_branch', 'general', '186'),
('503', '316', 'customer', 'general', '190'),
('504', '317', 'cust_branch', 'general', '187'),
('505', '317', 'customer', 'general', '191'),
('506', '318', 'cust_branch', 'general', '188'),
('507', '318', 'customer', 'general', '192'),
('508', '319', 'cust_branch', 'general', '189'),
('509', '319', 'customer', 'general', '193'),
('510', '320', 'cust_branch', 'general', '190'),
('511', '320', 'customer', 'general', '194'),
('512', '321', 'cust_branch', 'general', '191'),
('513', '321', 'customer', 'general', '195'),
('514', '322', 'cust_branch', 'general', '192'),
('515', '322', 'customer', 'general', '196'),
('516', '323', 'cust_branch', 'general', '193'),
('517', '323', 'customer', 'general', '197'),
('518', '324', 'cust_branch', 'general', '194'),
('519', '324', 'customer', 'general', '198'),
('520', '325', 'cust_branch', 'general', '195'),
('521', '325', 'customer', 'general', '199'),
('522', '326', 'cust_branch', 'general', '196'),
('523', '326', 'customer', 'general', '200'),
('524', '327', 'cust_branch', 'general', '197'),
('525', '327', 'customer', 'general', '201'),
('526', '328', 'cust_branch', 'general', '198'),
('527', '328', 'customer', 'general', '202'),
('528', '329', 'cust_branch', 'general', '199'),
('529', '329', 'customer', 'general', '203'),
('530', '330', 'cust_branch', 'general', '200'),
('531', '330', 'customer', 'general', '204'),
('532', '331', 'cust_branch', 'general', '201'),
('533', '331', 'customer', 'general', '205'),
('534', '332', 'cust_branch', 'general', '202'),
('535', '332', 'customer', 'general', '206'),
('536', '333', 'cust_branch', 'general', '203'),
('537', '333', 'customer', 'general', '207'),
('538', '334', 'supplier', 'general', '131'),
('539', '335', 'cust_branch', 'general', '204'),
('540', '335', 'customer', 'general', '208'),
('541', '336', 'cust_branch', 'general', '205'),
('542', '336', 'customer', 'general', '209'),
('543', '337', 'cust_branch', 'general', '206'),
('546', '337', 'customer', 'general', '210'),
('547', '338', 'cust_branch', 'general', '207'),
('549', '338', 'customer', 'general', '211'),
('550', '339', 'cust_branch', 'general', '208'),
('551', '339', 'customer', 'general', '212'),
('552', '340', 'cust_branch', 'general', '209'),
('553', '340', 'customer', 'general', '213'),
('554', '341', 'cust_branch', 'general', '210'),
('555', '341', 'customer', 'general', '214'),
('556', '342', 'cust_branch', 'general', '211'),
('557', '342', 'customer', 'general', '215'),
('558', '343', 'cust_branch', 'general', '212'),
('559', '343', 'customer', 'general', '216'),
('560', '344', 'cust_branch', 'general', '213'),
('561', '344', 'customer', 'general', '217'),
('562', '345', 'cust_branch', 'general', '214'),
('563', '345', 'customer', 'general', '218'),
('564', '346', 'cust_branch', 'general', '215'),
('565', '346', 'customer', 'general', '219'),
('566', '347', 'cust_branch', 'general', '216'),
('567', '347', 'customer', 'general', '220'),
('568', '348', 'cust_branch', 'general', '217'),
('569', '348', 'customer', 'general', '221'),
('570', '349', 'cust_branch', 'general', '218'),
('571', '349', 'customer', 'general', '222'),
('572', '350', 'cust_branch', 'general', '219'),
('573', '350', 'customer', 'general', '223'),
('574', '351', 'cust_branch', 'general', '220'),
('575', '351', 'customer', 'general', '224'),
('576', '352', 'cust_branch', 'general', '221'),
('577', '352', 'customer', 'general', '225'),
('578', '353', 'cust_branch', 'general', '222'),
('579', '353', 'customer', 'general', '226'),
('580', '354', 'cust_branch', 'general', '223'),
('581', '354', 'customer', 'general', '227'),
('582', '355', 'supplier', 'general', '132'),
('583', '356', 'cust_branch', 'general', '224'),
('584', '356', 'customer', 'general', '228'),
('585', '357', 'cust_branch', 'general', '225'),
('586', '357', 'customer', 'general', '229'),
('587', '358', 'cust_branch', 'general', '226'),
('588', '358', 'customer', 'general', '230'),
('589', '359', 'cust_branch', 'general', '227'),
('590', '359', 'customer', 'general', '231'),
('591', '360', 'cust_branch', 'general', '228'),
('592', '361', 'cust_branch', 'general', '229'),
('593', '361', 'customer', 'general', '232'),
('594', '362', 'cust_branch', 'general', '230'),
('595', '362', 'customer', 'general', '233'),
('596', '363', 'cust_branch', 'general', '231'),
('597', '363', 'customer', 'general', '234'),
('598', '364', 'cust_branch', 'general', '232'),
('599', '364', 'customer', 'general', '235'),
('600', '365', 'cust_branch', 'general', '233'),
('601', '365', 'customer', 'general', '236'),
('602', '366', 'cust_branch', 'general', '234'),
('603', '366', 'customer', 'general', '237'),
('604', '367', 'cust_branch', 'general', '235'),
('605', '367', 'customer', 'general', '238'),
('606', '368', 'cust_branch', 'general', '236'),
('607', '368', 'customer', 'general', '239'),
('608', '369', 'cust_branch', 'general', '237'),
('609', '369', 'customer', 'general', '240'),
('610', '370', 'cust_branch', 'general', '238'),
('611', '370', 'customer', 'general', '241'),
('612', '371', 'cust_branch', 'general', '239'),
('613', '371', 'customer', 'general', '242'),
('614', '372', 'cust_branch', 'general', '240'),
('615', '372', 'customer', 'general', '243'),
('616', '373', 'supplier', 'general', '133'),
('617', '374', 'supplier', 'general', '134'),
('618', '375', 'cust_branch', 'general', '241'),
('619', '375', 'customer', 'general', '244'),
('620', '376', 'supplier', 'general', '135'),
('621', '377', 'cust_branch', 'general', '242'),
('622', '377', 'customer', 'general', '245'),
('623', '378', 'cust_branch', 'general', '243'),
('624', '378', 'customer', 'general', '246'),
('625', '379', 'cust_branch', 'general', '244'),
('626', '379', 'customer', 'general', '247'),
('627', '380', 'cust_branch', 'general', '245'),
('628', '380', 'customer', 'general', '249'),
('629', '381', 'cust_branch', 'general', '246'),
('630', '381', 'customer', 'general', '250'),
('631', '382', 'cust_branch', 'general', '247'),
('632', '382', 'customer', 'general', '251'),
('633', '383', 'cust_branch', 'general', '248'),
('634', '383', 'customer', 'general', '252'),
('635', '384', 'cust_branch', 'general', '249'),
('636', '384', 'customer', 'general', '253'),
('637', '385', 'cust_branch', 'general', '250'),
('638', '385', 'customer', 'general', '254'),
('639', '386', 'cust_branch', 'general', '251'),
('640', '386', 'customer', 'general', '255'),
('641', '387', 'cust_branch', 'general', '252'),
('643', '387', 'customer', 'general', '256'),
('644', '388', 'cust_branch', 'general', '253'),
('645', '388', 'customer', 'general', '257'),
('646', '389', 'cust_branch', 'general', '254'),
('648', '390', 'supplier', 'general', '136'),
('649', '391', 'cust_branch', 'general', '255'),
('650', '391', 'customer', 'general', '259'),
('651', '389', 'customer', 'general', '258'),
('652', '392', 'cust_branch', 'general', '256'),
('653', '392', 'customer', 'general', '260'),
('654', '393', 'cust_branch', 'general', '257'),
('655', '393', 'customer', 'general', '261'),
('656', '394', 'cust_branch', 'general', '258'),
('658', '394', 'customer', 'general', '262'),
('659', '395', 'cust_branch', 'general', '259'),
('660', '395', 'customer', 'general', '263'),
('661', '396', 'cust_branch', 'general', '260'),
('662', '396', 'customer', 'general', '264'),
('663', '397', 'cust_branch', 'general', '261'),
('664', '397', 'customer', 'general', '265'),
('665', '398', 'supplier', 'general', '137'),
('666', '399', 'supplier', 'general', '138'),
('667', '400', 'supplier', 'general', '139'),
('668', '401', 'cust_branch', 'general', '262'),
('669', '401', 'customer', 'general', '266'),
('670', '143', 'customer', 'general', '87'),
('671', '402', 'cust_branch', 'general', '263'),
('672', '402', 'customer', 'general', '267'),
('673', '403', 'cust_branch', 'general', '264'),
('674', '403', 'customer', 'general', '268'),
('675', '404', 'cust_branch', 'general', '265'),
('676', '404', 'customer', 'general', '269'),
('677', '405', 'cust_branch', 'general', '266'),
('678', '405', 'customer', 'general', '270'),
('679', '406', 'cust_branch', 'general', '267'),
('680', '406', 'customer', 'general', '271'),
('681', '407', 'cust_branch', 'general', '268'),
('682', '407', 'customer', 'general', '272'),
('683', '408', 'supplier', 'general', '140'),
('684', '409', 'supplier', 'general', '141'),
('685', '410', 'supplier', 'general', '142'),
('686', '411', 'cust_branch', 'general', '269'),
('687', '411', 'customer', 'general', '273'),
('688', '412', 'cust_branch', 'general', '270'),
('689', '412', 'customer', 'general', '274'),
('690', '413', 'cust_branch', 'general', '271'),
('691', '413', 'customer', 'general', '275'),
('692', '414', 'cust_branch', 'general', '272'),
('693', '414', 'customer', 'general', '276'),
('694', '415', 'supplier', 'general', '143'),
('695', '416', 'cust_branch', 'general', '273'),
('696', '416', 'customer', 'general', '277'),
('698', '417', 'customer', 'general', '278'),
('699', '418', 'cust_branch', 'general', '275'),
('700', '419', 'cust_branch', 'general', '276'),
('701', '419', 'customer', 'general', '279'),
('702', '420', 'cust_branch', 'general', '277'),
('703', '420', 'customer', 'general', '280');

### Structure of table `0_crm_opportunity` ###

DROP TABLE IF EXISTS `0_crm_opportunity`;

CREATE TABLE `0_crm_opportunity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cont_per_id` int(11) NOT NULL COMMENT 'This id relate to the contact Person Table Contact Form',
  `oppr_list` varchar(200) NOT NULL,
  `remarks` varchar(200) NOT NULL,
  `status` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `trans_date` varchar(100) NOT NULL,
  `attach` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_crm_opportunity` ###


### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `name` varchar(60) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=421 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'A. A. A. Shuhail Alqahta', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'A. W. Building Material', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'A. M &amp; COMMUNICATION', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'Antique Style', 'Antique Style', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'A.Purgos', 'Arnesto Purgos', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'B.P.EMIRATES LTD CO ', 'BERGER PAINTS EMIRATES LTD CO (LLC)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'B.C.LLC', 'BIC Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'Bindhahi Trading LLC', 'Bindhahi Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'C.B.DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'C. E. Interior Decorat LLC', 'Core Elements Interior Decoration LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'Decortser Portal', 'Decortser Portal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'D.G.Contracting Co LLC', 'Discovery  General Contracting Co LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'Dr. Laya', 'Dr. Laya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'Dr. Rehmina', 'Dr. Rehmina', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'I. Abdul Rahim Shaaban Mohamed', 'Ismail Abdul Rahim Shaaban Mohamed', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'Jalal Merchant', 'Jalal Merchant', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'KOA R.E.DEVELOPMENT LLC', 'KOA REAL ESTATE DEVELOPMENT LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'Mr. AD', 'Mr. AD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'Mr. Alaa', 'Mr. Alaa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'Mr . Amit', 'Mr . Amit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'Mr Ashok', 'Mr Ashok', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('31', 'Mr.Dinesh', 'Mr.Dinesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('33', 'Mr. Haresh', 'Mr. Haresh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'Mr Hasan', 'Mr Hasan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'Mr. Ibrahim', 'Mr. Ibrahim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'Mr. James', 'Mr. James', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('41', 'Mr.Neeraj', 'Mr.Neeraj', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('42', 'Mr. Prabhat', 'Mr. Prabhat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'Mr.Rajesh', 'Mr.Rajesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'Mr. Saqlain', 'Mr. Saqlain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('49', 'Ms. Ahiliya', 'Ms. Ahiliya', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'Ms. Loulwa', 'Ms. Loulwa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('53', 'Ms. Roda', 'Ms. Roda', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'Ms.Swarn', 'Ms.Swarn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'Ms. Thanuja', 'Ms. Thanuja', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('56', 'Ms. Yogitha', 'Ms. Yogitha', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', NULL, 'Dubai', '(971) 5-037-42446__', NULL, NULL, 'lh@koa.ae', NULL, '', '0'),
('58', 'NATURAL TRENDY TIL&amp;FLOOR M', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'QEXPRESS', 'QEXPRESS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'R. H. REAL ESTATE BROKERS', 'RIGHT HOMES REAL ESTATE BROKERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('68', 'Sajith Ansar', 'Sajith Ansar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('69', 'Sustainable Builders', 'Sustainable Builders', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'Techforce Technical Services', 'Techforce Technical Services', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'Al Anfaal Garage EST.', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('74', 'Fine Tools Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('75', 'F. C. I. Decoration LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('76', 'Hidayath Trading Company LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'H. G. T. EST (Branch)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'JIHAN BLDG. MAT. &amp; PAINTS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('79', 'K.A.N. Technical Services LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('80', 'N. A. S.BUILDING MATERIALS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'P. B. Materials Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'Q. A.H. Aljadeed Gen.Trdg .LLc', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'R. A.B. Technical Services LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('84', 'Risala Furniture LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'R.A.B. Materials  Tradinf LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'S. ALJAZEERA AUTO REPAIRING', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'Spectrum Tent Manufacturing', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'Y. E. R. &amp; REPAIRING LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('89', 'AAFOQ Islamic Finance', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('90', 'A. Business Center (Tasheel)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('91', 'BALGHANI STORES LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('92', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'Emirates Driving Institute', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'Glare Technologies', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('95', 'Lex Consortia FZ LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('96', 'N. A. M. Trading (L.L.C) Br', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('97', 'SHADMAN TENTS IND LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('98', 'Souq.Com FZ LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('99', 'SUPER GENERAL COMPANY LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('100', 'The Excelerate Enterprises DMC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('101', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('102', 'D. E. &amp; WATER AUTHORITY', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('103', 'D. I. I. &amp;RE INSURANCE CO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('104', 'E.T G. Company (Etisalat)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('105', 'Purchase Bills to Come', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('106', 'Cash Customer', 'Cash Customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('107', 'Bindhahi Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('108', 'HAMMER BUILDING MAINTENANCE LL', 'HAMMER BUILDING MAINTENANCE LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('109', 'Emirates Telecommunications Gr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('110', 'BERGER PAINTS EMIRATES LTD CO', 'BERGER PAINTS EMIRATES LTD CO (LLC)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('111', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('112', 'Naga Lakshmi', 'Naga Lakshmi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('113', 'Good Steam Auto Center', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('114', 'NOOR TAKAFUL GENERAL (PJSC)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('115', 'Al Sharq Media LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('116', 'Modern Seal Insulation Contrac', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('117', 'Alanas Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('118', 'Chittagong Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('119', 'Emirates Post Group', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('120', 'Abdelaziz Abdelrahman Abdelazi', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('121', 'Broadway Building Materials LL', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('122', 'RTA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('123', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('124', 'Big Foot Koncepts LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('125', 'ROYAL GRAND BUILDING MATERIALS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('126', 'ADSS MARKETING &amp; COMMUNICA', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('127', 'He BEI Gao Yang Qi Chang Texti', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('128', 'EPIC TRAVEL LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('129', 'Saif Al Burhan Traders LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('130', 'SAFINAT AL BAHAR BUILDING MATE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('131', 'Arabian Business Center (Tashe', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('132', 'Fine Tools Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('133', 'AFRICA INTERNET GENERAL TRADIN', 'AFRICA INTERNET GENERAL TRADING LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('134', 'Al Anfaal Garage EST.', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('135', 'CAFU APP TECHNOLOGIES FZE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('136', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('137', 'Fine Tools Equipment Repairing', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('138', '&quot;Aevolve Beauty Saloon &amp;q', '&quot;Aevolve Beauty Saloon &quot;', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('139', 'Mega City Building Materilas T', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('140', 'YASMAC EQUIPMENT RENTAL &amp; ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('141', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('142', 'Ghulam Mustafa Construction Eq', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('143', 'Vijaya Chikermane', 'Vijaya Chikermane', NULL, NULL, '(054) 7-450-777____', NULL, NULL, NULL, NULL, '', '0'),
('144', 'Team One Glass &amp; Aluminum ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('145', 'Bawabt Al Hemreya Car Seat Uph', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('146', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('147', 'Al Barsha Tyres &amp; Battery ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('148', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('149', 'Angel Cakes', 'Angel Cakes', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('150', 'AQS Management Consultancy', 'AQS Management Consultancy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('151', 'Naresh Mohnani', 'Naresh Mohnani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('152', 'ARABIAN SAND WASHING LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('153', 'Smooth Solution Building Mater', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('154', 'Luigi Dsouza', 'Luigi Dsouza', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('155', 'Jumeirah Carpenter BR', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('156', 'Mega Fix Tyres &amp; Auto Care', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('157', 'IN Focus Glass and Aluminium W', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('158', 'Shades General Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('159', 'Progress Profiles Middle East ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('160', 'Nasser Al Matrooshi Trading (L', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('161', 'O.U.N Building Materials LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('162', 'MOHD AL QAMA CERAMICS TRADING ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('163', 'Al Burhan Prints LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('164', 'Wayz Consulting', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('165', 'MAS PAINTS &amp; CHEMICALS IND', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('166', 'GULF PAINTS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('167', 'NAJRAN GENERAL TRADING', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('168', 'Jai Electricals LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('169', 'DUKE STEEL TRADING CO (L.L.C)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('170', 'BAB AL SAFA CAR ACCESSORIES AN', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('171', 'SALAHALDIN CAR ACCESSORIES FIX', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('172', 'Al Aksa Technical &amp;Cleanin', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('173', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('174', 'Ms. Alita', 'Ms. Alita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('175', 'Ish Stars Technical Services', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('176', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('177', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('178', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('179', 'Mr Tahir', 'Mr Tahir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('180', 'Led Corner Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('181', 'RUI KANG TRADING FZCO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('182', 'Tools R Us LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('183', 'salim lokhand.', 'Salim Lokhandwala', NULL, 'Dubai Hills\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('184', 'Bridge Forth &amp; Signature', 'Bridge Forth &amp; Signature Contracting Co. LLC', NULL, 'PO BOX 99856\nDUBAI', '044-413-886__', NULL, NULL, NULL, NULL, '', '0'),
('185', 'nour', 'Ms. Nour', NULL, 'Springs 11, street 2, villa 36\nDubai', '971-503-40686', NULL, NULL, NULL, NULL, '', '0'),
('186', 'Al Anas Garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('187', 'Milad Interior Design', 'Milad Interior Design', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('188', 'Majid Al Falasi', 'Majid Al Falasi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('189', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', NULL, NULL, '971-543-03879', NULL, NULL, NULL, NULL, '', '0'),
('190', 'Miscellaneous Supplier', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('191', 'Advance to Abdullah Nepali', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('192', 'Clear View Interiors', 'Clear View Interiors', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, 'Mr. Taha Ahmed', '0'),
('193', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', NULL, 'Dubai', '971-553-75555', NULL, NULL, NULL, NULL, '', '0'),
('194', 'Suzena', 'Suzena', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('195', 'Akhil Vinayak', 'Akhil Vinayak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('196', 'Hussain General Trading EST. ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('197', 'Fatma Al Rais', 'Ms. Fatma Al Rais', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('198', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('199', 'PAVIMENTO GENERAL TRDG LLC', 'PAVIMENTO GENERAL TRADING L.L.C', NULL, 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '971-568-19654', NULL, NULL, NULL, NULL, '', '0'),
('200', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', NULL, 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '971-555-80234', NULL, NULL, NULL, NULL, '', '0'),
('201', 'Al fly Trading FZCO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('202', 'Otaly Trading FZCO ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('203', 'Grand al khail auto garage LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('204', 'Yogesh', 'Yogesh', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('205', 'I 2 D Interiors', 'I 2 D Interiors', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('206', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('207', 'Imran Qasim (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('208', 'The international school of ch', 'The international school of choueifat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('209', 'RALTS CONTRACTING', 'RALTS CONTRACTING', NULL, NULL, '042-383-353__', NULL, NULL, NULL, NULL, '', '0'),
('210', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('211', 'Star brothers auto repairing', '', NULL, NULL, '050-829-2384_', NULL, NULL, NULL, NULL, '', '0'),
('212', 'Johns Paints Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('213', 'Muhammed Adeel ( Employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('214', 'Abid Hussain ( Employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('215', 'Colart Publishing &amp; Adv. L', 'Colart Publishing &amp; Advertising LLC', NULL, 'PO Box 49652\nDUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('216', 'Ms. Arpita', 'Ms. Arpita', NULL, NULL, '971-557-92060', NULL, NULL, NULL, NULL, '', '0'),
('217', 'AKBAR ALI KHAN  ALI KHAN (empl', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('218', 'ARSLAN NADEEM NADEEM MAZHAR (e', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('219', 'BIR SINGH (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('220', 'DURGALAL NEPALI (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('221', 'MUHAMMAD AKHTAR (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('222', 'MUHAMMAD IBRAR (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('223', 'MUHAMMAD USAMA (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('224', 'SHAHID FAROOQ  (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('225', 'SHAKEEL AHMED ( employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('226', 'TAUHEED AHMED (employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('227', 'ZEESHAN ALI  ( employee)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('228', 'Mr. Jamal Al Ali', '', NULL, 'ajman', NULL, NULL, NULL, NULL, NULL, '', '0'),
('229', 'Turnkey fitout solutions', 'Turnkey fitout solutions', NULL, 'po box # 47862\nDubai', '(045) 8-065-53_____', NULL, NULL, NULL, NULL, '', '0'),
('230', 'horeb parmar', 'horeb parmar', NULL, NULL, '(054) 7-929-474____', NULL, NULL, NULL, NULL, '', '0'),
('231', 'Latif Musa Air Condition Rpr &amp;', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('232', 'TIAN FA STONE MATERIAL TRADING', '', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('233', 'kalyan chakravarthy', 'kalyan chakravarthy', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('234', 'Harun Sultan', 'Harun Sultan', NULL, 'Ajman', NULL, NULL, NULL, NULL, NULL, '', '0'),
('235', 'Al Zujaj Al Azraq Aluminium &amp;a', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('236', 'VERVE INTERIOR  DECORATION L.L', 'VERVE INTERIOR  DECORATION L.L.C', NULL, 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '042-400-119__', NULL, NULL, NULL, NULL, '', '0'),
('237', 'Royal Hammer Trading LLC', '', NULL, NULL, '04_-399-1753_', NULL, NULL, NULL, NULL, '', '0'),
('238', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('239', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('240', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', NULL, 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '(971) 5-662-54662__', NULL, NULL, NULL, NULL, '', '0'),
('241', 'Kitchenscape Domestic Kitchens', 'Kitchenscape Domestic Kitchens LLC', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('242', 'GREEN TERRA TECHNICAL SERVICES', 'GREEN TERRA TECHNICAL SERVICES LLC', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('243', 'Ms. Serena', 'Ms. Serena', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('244', 'Highrise Owners Association Ma', 'Highrise Owners Association Management (HOAM)', NULL, 'dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('245', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', NULL, 'Po Box # 60288\nDIP\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('246', 'Beenish Haider', 'Beenish Haider', NULL, NULL, '055-117-5311_', NULL, NULL, NULL, NULL, '', '0'),
('247', 'Meherz Kreation LLC', 'Meherz Kreation LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('248', 'Pioneer Insurance Broker LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('249', 'WASL PROPERTIES', 'WASL PROPERTIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('250', 'Modern Seal Insulation Soln', 'Modern Seal Insulation Solutions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('251', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('252', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('253', 'Shandong Hele( Middle East) In', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('254', 'Mr. Rajiv', 'Mr. Rajiv', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('255', 'shaikh saeed mohammed Hasher A', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('256', 'Fincirc International Manageme', 'Fincirc International Management', NULL, 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '045-126-800__', NULL, NULL, NULL, NULL, '', '0'),
('257', 'faqihi Enterprises LLC (BR)', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('258', 'Laspinas Building Materials Tr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('259', 'Ms. Shweta', 'Ms. Shweta', NULL, 'Dubai', '971-505-54754', NULL, NULL, NULL, NULL, '', '0'),
('260', 'Pooja Shah Mulani', 'Pooja Shah Mulani', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('261', 'MXTS office Jebel Ali								', 'Mr Xpert technical Services New Office Jebel Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('262', 'Panache Building Materials Tra', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('263', 'Mohd. Al Qama General Trading ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('264', 'Technos Multiline LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('265', 'Ibrahim Abbas Ali Trading LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('266', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', NULL, 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '(065) 7-743-111____', NULL, NULL, NULL, NULL, '', '0'),
('267', 'DUBAI ELECTRICITY &amp; WATER ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('268', 'Sanqour advertising service', 'Sanqour advertising service', NULL, 'Al Zahiya, Abu Dhabi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('269', 'Al Dhaw Al Wahaj Electrical &amp;a', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('270', 'Romana Water Industries LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('271', 'Faizal system fixing contracti', '', NULL, NULL, '(050) 9-275-773____', NULL, NULL, NULL, NULL, '', '0'),
('272', 'Noor Al Fajr Elect. Devices Tr', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('273', 'Mohd.AL Qama Building Materila', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('274', 'EL TEAM', 'EL TEAM LTD FZE - Sharjah', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('275', 'Wool Craft  Trading', 'Wool Craft  Trading', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('276', 'Afaq Al Waseqh Electromech', 'Afaq Al Waseqh Electromechanical Services LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('277', 'MR. YU', 'MR. YU', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('278', 'Astro properties', 'Astro properties', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('279', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', NULL, 'P.O. Box – 48746,\nDubai, UAE\n', '971-433-26233', NULL, NULL, 'info@bfmatech.com ', NULL, '', '0'),
('280', 'Mr. Hadisfer', 'Mr. Hadisfer', NULL, 'Villa 47 Hattan One Arabian Ranches', '052-815-4488_', NULL, NULL, NULL, NULL, '', '0'),
('281', 'JAMTS Tech LLC', 'JAMTS Tech LLC', NULL, 'PO Box 71893', '(055) 2-975-999____', NULL, NULL, NULL, NULL, '', '0'),
('282', 'Sofitel Dubai The Palm', 'Sofitel Dubai The Palm', NULL, 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '971-445-55471', NULL, NULL, NULL, NULL, '', '0'),
('283', 'Rahul Ranbhare', 'Rahul Ranbhare', NULL, 'G05, Fortunato 1, JVC', '971-558-12606', NULL, NULL, NULL, NULL, '', '0'),
('284', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', NULL, 'Villa 349 Hayat townhouses', '971-565-65944', NULL, NULL, NULL, NULL, '', '0'),
('285', 'Dubai Coast Trading  [LLC]', '', NULL, NULL, '042-212-766__', NULL, '042270025', NULL, NULL, '', '0'),
('286', 'HOAM Highrise Owners ', 'HOAM Highrise Owners Association Management', NULL, '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '971-433-95558', NULL, NULL, NULL, NULL, '', '0'),
('287', 'Al Hai Motors', 'Al Hai Motors', NULL, 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '055-555-6656_', NULL, NULL, NULL, NULL, '', '0'),
('288', 'Noma Design House', 'Noma Design House', NULL, 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '971-523-29615', NULL, NULL, NULL, NULL, '', '0'),
('289', 'Ms. Nissreen', 'Ms. Nissreen', NULL, 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('290', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', NULL, 'Villa 127 Picadilly Green Damac Hills', '054-582-2614_', NULL, NULL, NULL, NULL, '', '0'),
('291', 'La Stella productions', 'La Stella productions', NULL, 'Al Qouz Dubai\n', '055-984-3848_', NULL, NULL, NULL, NULL, '', '0'),
('292', 'Mr. Habib Nahra', 'Mr. Habib Nahra', NULL, NULL, '058-591-2469_', NULL, NULL, NULL, NULL, '', '0'),
('293', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', NULL, 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '(050) 8-771-798____', NULL, NULL, NULL, NULL, '', '0'),
('294', 'One Laundry', 'One Laundry', NULL, '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '043-247-680__', NULL, NULL, NULL, NULL, '', '0'),
('295', 'ALI FARHAN TECHNICAL SERVICES ', 'ALI FARHAN TECHNICAL SERVICES LLC', NULL, 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '055-427-0717_', '(050) 78-558-05___', NULL, NULL, NULL, '', '0'),
('296', 'Mr. Hisham', 'Mr. Hisham', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('297', 'Mrs.Sumeira', 'Mrs.Sumeira', NULL, 'Villa F 41 Golf Course Villas', '052-176-4340_', NULL, NULL, NULL, NULL, '', '0'),
('298', 'Dinesh Sanghvi', 'Dinesh Sanghvi', NULL, NULL, '971-504-54946', NULL, NULL, NULL, NULL, '', '0'),
('299', 'Unitra International LLC', 'Unitra International LLC', NULL, 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '971-470-24700', NULL, NULL, 'Murad.Alashhab@mezzan.com ', NULL, '', '0'),
('300', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('301', 'GDM Interiors LLC', 'GDM Interiors LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('302', 'Vishesh Singhania ', 'Vishesh Singhania ', NULL, NULL, '052-749-3357_', NULL, NULL, NULL, NULL, '', '0'),
('303', 'Imperial Avenue', 'Imperial Avenue', NULL, 'Dubai -UAE', '971-559-39446', NULL, NULL, NULL, NULL, '', '0'),
('304', 'Shaul Nagawkar ', 'Shaul Nagawkar ', NULL, 'Apt 705 Tower F Executive Tower - Business Bay', '971-554-03407', NULL, NULL, NULL, NULL, '', '0'),
('305', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', NULL, ' Al Ain Road', '050-753-5444_', NULL, NULL, NULL, NULL, '', '0'),
('306', 'ABDULLA DARWISH GHULOOM AHMED ', 'ABDULLA DARWISH GHULOOM AHMED BAQER', NULL, 'Villa 32 Al Warqa', '971-505-54500', NULL, NULL, NULL, NULL, '', '0'),
('307', 'Rabia Ahmed ', 'Rabia Ahmed ', NULL, NULL, '971-585-06107', NULL, NULL, NULL, NULL, '', '0'),
('308', 'Kakul Technical Services', 'Kakul Technical Services', NULL, 'DUBAI', '056-822-5649_', NULL, NULL, NULL, NULL, '', '0'),
('309', 'Riham AlAli', 'Riham AlAli', NULL, 'Villa 102,Al Barsha,dubai', '971-521-38404', NULL, NULL, NULL, NULL, '', '0'),
('310', 'Blacksmith Coffee', 'Blacksmith Coffee', NULL, 'dubai', '050-899-1223_', NULL, NULL, NULL, NULL, '', '0'),
('311', 'Sangeet Jain', 'Sangeet Jain', NULL, 'Villa 33 Al Naseem Mudon', '971-567-33689', NULL, NULL, NULL, NULL, '', '0'),
('312', 'Stone House Real Estate Broker', 'Stone House Real Estate Brokerage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('313', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', NULL, '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '971-553-47587', NULL, NULL, NULL, NULL, '', '0'),
('314', 'Warriors Aluminum and Glass', 'Warriors Aluminum and Glass Cont. LLC ', NULL, 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '971-554-15254', NULL, NULL, 'info@warriorslandscape.ae ', NULL, '', '0'),
('315', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', NULL, 'PO Box 2748 Sharjah', '065-344-379__', NULL, NULL, NULL, NULL, '', '0'),
('316', 'High Power Services', 'High Power Services', NULL, 'PO Box 57467 Dubai.\n', '056-505-8126_', NULL, NULL, NULL, NULL, '', '0'),
('317', 'Ms. Charu', 'Ms. Charu', NULL, 'Karama,DUBAI', '971-506-34851', NULL, NULL, NULL, NULL, '', '0'),
('318', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', NULL, 'Villa 1, Ary Building Dubai Marina', '050-928-8744_', NULL, NULL, NULL, NULL, '', '0'),
('319', 'Star Revive Medical Center', 'Star Revive Medical Center', NULL, 'jumeirah', '(043) 3-344-61_____', NULL, NULL, NULL, NULL, '', '0'),
('320', 'Phoenix Middle East', 'Phoenix Middle East', NULL, 'DIP 2 ,Dubai', '050-106-4845_', NULL, NULL, NULL, NULL, '', '0'),
('321', 'MENAWATT TECHNICAL SERVICES ', 'MENAWATT TECHNICAL SERVICES EST.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('322', 'Mond Trading Services', 'Mond Trading Services', NULL, 'warehouse 141', '056-787-8070_', NULL, NULL, NULL, NULL, '', '0'),
('323', 'Jean Paul Schmidt', 'Jean Paul Schmidt', NULL, 'Emaar South Villa 213', '971-566-89875', NULL, NULL, NULL, NULL, '', '0'),
('324', 'Frederic de Melker', 'Frederic de Melker', NULL, 'City Walk Building 10, app 309', '971-551-09783', NULL, NULL, NULL, NULL, '', '0'),
('325', 'GULFLINE CONST. METALIC PARTS ', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', NULL, 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '971-652-82233', NULL, NULL, NULL, NULL, '', '0'),
('326', 'Abu Dhabi Entertainment ', 'Abu Dhabi Entertainment Company ', NULL, 'P.O. Box 862, Abu Dhabi, UAE', '971-240-34200', '(971) 56-651-8131_', NULL, 'mohammed.ashif@adecmanagement.ae', NULL, '', '0'),
('327', 'Mrs. Marie', 'Mrs. Marie', NULL, 'Villa 205, Maeen 4, The Lakes', '056-992-3062_', NULL, NULL, NULL, NULL, '', '0'),
('328', 'Best Choice Trading LLC', 'Best Choice Trading LLC', NULL, NULL, '043-396-669__', NULL, NULL, NULL, NULL, '', '0'),
('329', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', NULL, 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '971-568-51047', NULL, NULL, NULL, NULL, '', '0'),
('330', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', NULL, 'Jumeirh Park Dubai', '055-815-7066_', NULL, NULL, NULL, NULL, '', '0'),
('331', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', NULL, '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '971-545-81932', NULL, NULL, NULL, NULL, '', '0'),
('332', 'Yashin Lalloo', 'Yashin Lalloo', NULL, 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('333', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', NULL, 'Al Qouz Villa 7', '050-657-6567_', NULL, NULL, NULL, NULL, '', '0'),
('334', 'Suitecase Holidays FZE LLC', '', NULL, NULL, '052-729-2815_', NULL, NULL, NULL, NULL, '', '0'),
('335', 'Waht Alhams Technical services', 'Waht Alhams Technical services EST', NULL, NULL, '(050) 4-213-305____', NULL, NULL, NULL, NULL, '', '0'),
('336', 'Mrs. Anna', 'Mrs. Anna', NULL, 'Villa 17 Trixis, Damac Hills 2 Akoya', '052-765-5584_', NULL, NULL, NULL, NULL, '', '0'),
('337', 'Aztec Shipping LLC', 'Aztec Shipping LLC', NULL, 'NAVEEN BNI GLADITOR', '(052) 6-866-960____', NULL, NULL, 'naveen@groupe-global.net', NULL, '', '0'),
('338', 'priyanka chugh', 'priyanka chugh', NULL, 'palm jumeirah', '(054) 4-766-556____', NULL, NULL, 'priyaankachugh@gmail.com', NULL, '', '0'),
('339', 'InsideOut Casa Technical ', 'InsideOut Casa Technical Services', NULL, NULL, '050-367-7125_', NULL, NULL, NULL, NULL, '', '0'),
('340', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', NULL, NULL, '971-526-86696', NULL, NULL, 'naveen@groupe-global.net', NULL, '', '0'),
('341', 'Ms.Priya Motiani', 'Ms.Priya Motiani', NULL, NULL, '971-554-25544', NULL, NULL, NULL, NULL, '', '0'),
('342', 'Mr. Dipak Main', 'Mr. Dipak Main', NULL, 'Villa 118 Trixis Damac 2', '971-504-95174', NULL, NULL, NULL, NULL, '', '0'),
('343', 'Design Evolution Technical Ser', 'Design Evolution Technical Service Co.', NULL, 'AL Awir', '(___) _-___-_______', '(052) 69-372-90___', NULL, NULL, NULL, '', '0'),
('344', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', NULL, 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '043-342-121__', NULL, NULL, NULL, NULL, '', '0'),
('345', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', NULL, 'PO Box 81456 Dubai UAE', '042-978-870__', NULL, NULL, NULL, NULL, '', '0'),
('346', 'English Language Private Schoo', 'English Language Private School', NULL, ' Oud Metha', '971-567-83590', NULL, NULL, NULL, NULL, '', '0'),
('347', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', NULL, 'P.O BOX 31671,DUBAI - UAE', '048-326-4400_', '(037) 05-452-4____', NULL, NULL, NULL, '', '0'),
('348', 'Mr. Chari', 'Mr. Chari', NULL, 'Villa 240 Pacifica Damac 2', '(971) 5-087-73932__', NULL, NULL, NULL, NULL, '', '0'),
('349', 'Mr. Prabhu', 'Mr. Prabhu', NULL, NULL, '(971) 5-453-46262__', NULL, NULL, NULL, NULL, '', '0'),
('350', 'Kings Speciality Restaurant LL', 'Kings Speciality Restaurant LLC', NULL, 'downtown', '(050) 9-605-266____', NULL, NULL, NULL, NULL, '', '0'),
('351', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', NULL, 'La Quinta Dubai.', '(056) 1-743-039____', NULL, NULL, NULL, NULL, '', '0'),
('352', 'Al Ghussun Advertising', 'Al Ghussun Advertising', NULL, 'PO Box 2748 Sharjah UAE', '(065) 3-443-76_____', NULL, NULL, NULL, NULL, '', '0'),
('353', 'Al Ameemi Intl Trdg LLC', 'Al Ameemi International Trading L.L.C', NULL, '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '043-351-222__', NULL, NULL, NULL, NULL, '', '0'),
('354', 'Mr. Sanjiv Soori', 'Mr. Sanjiv Soori', NULL, 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '055-726-5338_', NULL, NULL, NULL, NULL, '', '0'),
('355', 'AFAQ MAHMOOD MAHMOOD AHMAD (Em', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('356', 'IBECE ENEGY', 'IBECE ENEGY', NULL, NULL, '043-540-789__', '(056) 24-809-11___', NULL, 'mohannad.ashhab@ibecegroup.com ', NULL, '', '0'),
('357', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', NULL, 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '971-551-03723', NULL, NULL, NULL, NULL, '', '0'),
('358', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', NULL, 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('359', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', NULL, 'Villa 3704 Greens Community West', '050-561-9411_', NULL, NULL, NULL, NULL, '', '0'),
('360', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('361', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', NULL, 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '050-326-3650_', '(043) 70-988-1____', NULL, NULL, NULL, '', '0'),
('362', 'Mr. Antonio', 'Mr. Antonio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('363', 'Mobeen Javed', 'Mobeen Javed', NULL, NULL, '971-522-36939', NULL, NULL, NULL, NULL, '', '0'),
('364', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('365', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', NULL, '14B Street Umm Ramool Rashidiya, Dubai ', '054-781-5935_', NULL, NULL, NULL, NULL, '', '0'),
('366', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', NULL, NULL, '971-567-84790', NULL, NULL, NULL, NULL, '', '0'),
('367', 'Suntac General Trading LLC', 'Suntac General Trading LLC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('368', 'Wasl LLC', 'Wasl LLC', NULL, 'DUBAI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('369', 'Mr. Brian Howarth', 'Mr. Brian Howarth', NULL, 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '(050) 1-005-462____', NULL, NULL, NULL, NULL, '', '0'),
('370', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', NULL, NULL, '971-528-61907', NULL, NULL, NULL, NULL, '', '0'),
('371', 'Hermen Thomas ', 'Hermen Thomas ', NULL, 'G 003 \nNew bridge hills 3 \nUptown motor city', '(971) 5-019-71488__', NULL, NULL, NULL, NULL, '', '0'),
('372', 'Deepak Panchariya', 'Deepak Panchariya', NULL, 'Gardenia, Wasl gate, TH 80', '971-566-83851', NULL, NULL, NULL, NULL, '', '0'),
('373', 'SERVICE FIRST GENERAL TRADING ', '', NULL, NULL, '052-496-17360', '(048) 89-569-1____', NULL, NULL, NULL, '', '0'),
('374', 'Hi Tech Pack and Trans LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('375', 'Nirav Patel', 'Nirav Patel', NULL, NULL, '971-554-09938', NULL, NULL, '‎nirav.patel@fincirc.com', NULL, '', '0'),
('376', 'Grand City Auto Services', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('377', 'Atlas Advertising', 'Atlas Advertising', NULL, NULL, '065-423-775__', NULL, NULL, NULL, NULL, '', '0'),
('378', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', NULL, 'Meadows 6 Dubai', '050-474-0506_', NULL, NULL, NULL, NULL, '', '0'),
('379', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', NULL, 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', NULL, NULL, NULL, NULL, NULL, '', '0'),
('380', 'HAMMER BUILDING MAINTENANCE LL', 'HAMMER BUILDING MAINTENANCE LLC', NULL, 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('381', 'Discovery  General Contracting', 'Discovery  General Contracting Co LLC', NULL, 'ABU DHAHBI', NULL, NULL, NULL, NULL, NULL, '', '0'),
('382', 'BIC Contracting LLC', 'BIC Contracting LLC', NULL, 'PO Box # 10869 Dubai', '(971) 4-285-7551___', '(050) 54-609-49___', NULL, NULL, NULL, '', '0'),
('383', 'Right Choice Metal  Products L', 'Right Choice Metal  Products LLC', NULL, 'villa 190\ndeema 4\nlakes', NULL, NULL, NULL, NULL, NULL, '', '0'),
('384', 'Vanita Fernandes', 'Vanita Fernandes', NULL, NULL, '(971) 5-065-2329___', NULL, NULL, NULL, NULL, '', '0'),
('385', 'Sagar Deshpande', 'Sagar Deshpande', NULL, NULL, '(971) 5-535-06133__', NULL, NULL, NULL, NULL, '', '0'),
('386', 'Bindhahi Trading LLC (SALES)', 'Bindhahi Trading LLC (SALES)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('387', 'Shahana Rishmath P K', 'J L T BUILDING MAINTENANCE L L C', NULL, 'Shop : S12, Building No: 003, Al warsan First,\nInternational City, Dubai', NULL, '(971) 50-947-7940_', NULL, NULL, NULL, '', '0'),
('388', 'Yogi fixies technical services', 'Yogi fixies technical services LLC', NULL, NULL, '971-586-54828', NULL, NULL, NULL, NULL, '', '0'),
('389', 'RKG INTERNATIONAL FZE ', 'RKG INTERNATIONAL FZE ', NULL, '509 Al Shoula Residence same building Baqer mohebi supermarket \nAl Rolla Street Bur Dubai', '(971) 5-653-4105___', NULL, NULL, NULL, NULL, '', '0'),
('390', 'AL DANUBE BUILDING MATERIALS ', '', NULL, NULL, '048-871-234__', '(048) 08-552-4____', NULL, 'info@aldanube.com', NULL, '', '0'),
('391', 'Al Sadarah  automatic Doors &amp;a', 'Al Sadarah  automatic Doors &amp; Barrier Tr.', NULL, 'po box  28916\nshop no 4\nSharjah UAE', '050-677-0770_', NULL, NULL, NULL, NULL, '', '0'),
('392', 'Designex Technical Services LL', 'Designex Technical Services LLC.', NULL, 'Office 605 Zone B Aspect Tower, Al Saada,\nBusiness Bay, Dubai', '(971) 5-021-06600__', NULL, NULL, NULL, NULL, '', '0'),
('393', 'Oasis Investment Co. LLC', 'Oasis Investment Co. LLC', NULL, 'P.O. Box 93, Dubai, UAE. Mr. Alvin Dominic', '971-428-21000', '(971) 54-582-0659_', NULL, 'alvin.dominic@alshirawi.ae', NULL, '', '0'),
('394', 'Mr. Sooraj Vengasseri', 'DAMAC Properties Co. LLC', NULL, ' P.O.Box:2195, Dubai, United Arab Emirates.', '(971) 4-376-3707___', NULL, NULL, NULL, NULL, '', '0'),
('395', 'Urban Scapes Technical Service', 'Urban Scapes Technical Services', NULL, 'dubai', '052-513-4968_', NULL, NULL, NULL, NULL, '', '0'),
('396', 'EVOLVE INTERIORS LLC', 'EVOLVE INTERIORS LLC', NULL, 'Dubai, UAE ', '971-436-97106', '(971) 56-681-3138_', NULL, NULL, NULL, '', '0'),
('397', 'Al Hayyat al jameela technical', 'Al Hayyat al jameela technical Services LLC', NULL, 'ASPIN Commercial Tower 103A, Shaikh Zayed\nRoad, Dubai, Duba', '971-554-51940', NULL, NULL, NULL, NULL, '', '0'),
('398', 'Oriental Insurance / Armab Ins', '', NULL, 'PO BOX 478\ndubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('399', 'SMART PRINT SOLUTIONS LLC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('400', 'Al Azrar Building Material Tra', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('401', 'A &amp; F AUTO REPAIR L L C', 'A &amp; F AUTO REPAIR L L C', NULL, 'Suit No. S4, 37th 318th Road, Al Quoz 2,\nIndustrial Area, Dubai', '971-555-53540', NULL, '100020666200003', NULL, NULL, '', '0'),
('402', 'Ms. Francesca', 'Ms. Francesca', NULL, 'Loft 1503\ndubai', '050-885-7327_', NULL, NULL, NULL, NULL, '', '0'),
('403', 'BVA Ports and Marine Contracti', 'BVA Ports and Marine Contracting L.L.C', NULL, 'Al Sharif Building - 1, Al Naif, Dubai, Dubai,\nUnited Arab Emirates', '971-529-85825', NULL, NULL, NULL, NULL, '', '0'),
('404', 'Abo Hassan', 'Abo Hassan', NULL, NULL, '050-259-5837_', NULL, NULL, NULL, NULL, '', '0'),
('405', 'Mr. Mahinder Kumar Jangid', 'Mr. Mahinder Kumar Jangid', NULL, 'Apartment B112, Building B, Jumeirah Heights Dubai', '050-203-2600_', NULL, NULL, NULL, NULL, '', '0'),
('406', 'Zakia khan design services', 'Zakia khan design services', NULL, 'dubai', '055-596-1771_', NULL, NULL, NULL, NULL, '', '0'),
('407', 'Mr. Gabriele Apartment', 'Mr. Gabriele Apartment', NULL, 'East 4802, ABR', '058-580-1058_', NULL, NULL, NULL, NULL, '', '0'),
('408', 'BUSTAN AL MADINAH BLDG MAT&amp;amp', '', NULL, NULL, '050-587-0386_', '(050) 17-220-35___', NULL, NULL, NULL, '', '0'),
('409', 'KAGALWALA TRADING LLC', '', NULL, NULL, '(042) 2-125-18_____', NULL, NULL, 'kagaltrading5@gmail.com', NULL, '', '0'),
('410', 'AL SHERAA BUILDING MATERIALS C', '', NULL, NULL, '(042) 2-730-89_____', NULL, NULL, NULL, NULL, '', '0'),
('411', 'ROCK REPUBLIC L.L.C', 'ROCK REPUBLIC L.L.C', NULL, 'Street 77, Dubai Investment Park 1, Dubai', '971-454-62978', NULL, NULL, NULL, NULL, '', '0'),
('412', 'Pakistan Association Dubai', 'Pakistan Association Dubai', NULL, 'Street 11b, Oud Metha Road,\nBur Dubai ,\nUnited Arab Emirates', '040-305-000__', NULL, NULL, NULL, NULL, '', '0'),
('413', 'Astra Polymers', 'Astra Polymers  DUBAI, JEBEL ALI OFFICE', NULL, 'Plots No. S10129 / S10130 Jafza South\nJebel Ali Free Zone Authority\nDubai, United Arab Emirates\nP.O. Box 261246 (License No. 4654)\n', '971-488-60207', '(050) 60-090-17___', NULL, NULL, NULL, '', '0'),
('414', 'Mohammad Hisham Khalid &amp; T', 'Mohammad Hisham Khalid &amp; Thani Al Shirawi', NULL, NULL, '056-682-9342_', NULL, NULL, NULL, NULL, '', '0'),
('415', 'AIR1 TRAVEL TOURISM &amp;CARGO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('416', 'Ayesha Azeem', 'Ayesha Azeem', NULL, 'Pacifica\nVilla 167', '056-682-2689_', NULL, NULL, NULL, NULL, '', '0'),
('417', 'Mr. Borja Barbadillo', 'Mr. Borja Barbadillo', NULL, 'Villa 273 Zulal, The Lakes Dubai', '052-987-8488_', NULL, NULL, NULL, NULL, '', '0'),
('418', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('419', 'Krizia Lee Abelido', 'Krizia Lee Abelido', NULL, 'Apartment 2102 Residence side, ontario tower business bay', '052-129-5782_', NULL, NULL, NULL, NULL, '', '0'),
('420', 'Ms Anu', 'Ms Anu', NULL, 'Apartment 2804\nMarina Arcade  Tower\nDubai', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_cron_record` ###

DROP TABLE IF EXISTS `0_cron_record`;

CREATE TABLE `0_cron_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pdf_name` varchar(50) NOT NULL,
  `rep_id` int(11) NOT NULL,
  `time` varchar(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cron_record` ###


### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `CurrencyName_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('UAE Dirhams', 'AED', 'AED', 'United Arab Emirates', 'Fils', '1', '', '0'),
('UK Pounds', 'GBP', '£', 'United Kingdom', 'Pence', '1', '', '0'),
('Indian Rupees', 'INR', '₹', 'India', 'Paisas', '1', '', '0'),
('Jordanian Dinar', 'JOD', 'JOD', 'Jordan', 'Cents', '1', 'دينار أردني', '0'),
('Omani Riyal', 'OMR', 'OMR', 'Oman', 'bz', '1', '', '0'),
('Pak Rupee(s)', 'PKR', 'Rs.', 'Pakistan', 'Paisa', '1', '', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###

INSERT INTO `0_cust_allocations` VALUES
('1', '237', '4200', '0000-00-00', '1', '12', '9', '10', '15'),
('2', '225', '1200', '0000-00-00', '2', '12', '12', '10', '16'),
('5', '134', '11865', '0000-00-00', '5', '12', '1', '10', '9'),
('8', '242', '2415', '0000-00-00', '9', '12', '16', '10', '3'),
('9', '189', '2016', '0000-00-00', '10', '12', '17', '10', '7'),
('11', '240', '12560.25', '0000-00-00', '12', '12', '15', '10', '8'),
('13', '71', '985', '0000-00-00', '15', '12', '18', '10', '22'),
('14', '246', '1785', '0000-00-00', '16', '12', '6', '10', '20'),
('15', '213', '1365', '0000-00-00', '17', '12', '3', '10', '11'),
('16', '242', '2415', '0000-00-00', '18', '12', '16', '10', '3'),
('17', '75', '2625', '0000-00-00', '19', '12', '10', '10', '4'),
('18', '75', '2625', '0000-00-00', '19', '12', '11', '10', '5'),
('19', '32', '3675', '0000-00-00', '20', '12', '7', '10', '6'),
('20', '74', '6392.4', '0000-00-00', '21', '12', '19', '10', '23'),
('21', '74', '5250', '0000-00-00', '21', '12', '26', '10', '33'),
('24', '105', '14647', '0000-00-00', '24', '12', '21', '0', '0'),
('25', '244', '240', '2024-02-02', '23', '12', '2', '10', '10'),
('27', '187', '3160', '2024-02-07', '25', '12', '21', '0', '0'),
('29', '258', '682.5', '0000-00-00', '27', '12', '25', '10', '31'),
('31', '252', '500', '0000-00-00', '29', '12', '4', '10', '12'),
('32', '208', '499.65', '0000-00-00', '30', '12', '21', '0', '0'),
('34', '85', '630', '0000-00-00', '33', '12', '21', '10', '28'),
('35', '204', '4410', '2024-02-06', '1', '11', '21', '0', '0'),
('36', '204', '1410', '2024-02-13', '34', '12', '21', '0', '0'),
('37', '267', '500', '0000-00-00', '35', '12', '33', '10', '47'),
('38', '136', '2730', '2024-01-23', '11', '12', '21', '0', '0'),
('40', '197', '14207.86', '2024-02-06', '37', '0', '21', '0', '0'),
('41', '197', '4438.67', '2024-02-06', '38', '0', '21', '0', '0'),
('42', '234', '525', '0000-00-00', '36', '12', '21', '0', '0'),
('43', '240', '3933.56', '2024-02-01', '22', '12', '15', '10', '8'),
('44', '240', '253.69', '0000-00-00', '37', '12', '15', '10', '8'),
('45', '240', '5244.75', '0000-00-00', '37', '12', '32', '10', '38'),
('46', '198', '2342.5', '2024-02-06', '26', '12', '21', '0', '0'),
('48', '273', '3633', '2024-02-23', '39', '12', '36', '10', '57'),
('49', '199', '5775', '0000-00-00', '40', '12', '21', '0', '0');

### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` bigint(100) NOT NULL DEFAULT 0,
  `br_name` varchar(60) NOT NULL DEFAULT '',
  `branch_ref` varchar(30) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `CustName_arabic` varchar(100) NOT NULL,
  `cust_ref_arabic` varchar(100) NOT NULL,
  `br_name_arabic` varchar(100) NOT NULL,
  `br_ref_arabic` varchar(100) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `cust_gcc` tinyint(1) NOT NULL,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=278 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'A. A. A. Shuhail Alqahta', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('2', '3', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'A. M &amp; COMMUNICATION', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('3', '4', 'Al Furjan Contracting LLC', 'Al Furjan Contracting LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('4', '5', 'Antique Style', 'Antique Style', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('5', '6', 'Arnesto Purgos', 'A.Purgos', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('6', '7', 'Auto Lighting Trading LLC', 'Auto Lighting Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('7', '8', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'B.P.EMIRATES LTD CO ', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('8', '9', 'BIC Contracting LLC', 'B.C.LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('10', '11', 'CAESARS BLUEWATERS DUBAI L.L.C', 'C.B.DUBAI L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('11', '12', 'Core Elements Interior Decoration LLC', 'C. E. Interior Decorat LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('12', '13', 'DAO FENG TRADING - FZCO', 'DAO FENG TRADING - FZCO', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('13', '14', 'Decortser Portal', 'Decortser Portal', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('14', '15', 'Discovery  General Contracting Co LLC', 'D.G.Contracting Co LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('15', '16', 'Dr. Laya', 'Dr. Laya', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('16', '17', 'Dr. Rehmina', 'Dr. Rehmina', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('17', '18', 'Dubai Coast Trading LLC', 'Dubai Coast Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('18', '19', 'Ismail Abdul Rahim Shaaban Mohamed', 'I. Abdul Rahim Shaaban Mohamed', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('19', '20', 'Jalal Merchant', 'Jalal Merchant', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('20', '21', 'Jumeirah Beach Resort LLC', 'Jumeirah Beach Resort LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('21', '22', 'KOA REAL ESTATE DEVELOPMENT LLC', 'KOA R.E.DEVELOPMENT LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('22', '23', 'Massar Aluminum &amp; Glass', 'Massar Aluminum &amp; Glass', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('23', '24', 'Mr. Abdul Rehman', 'Mr. Abdul Rehman', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('24', '25', 'Mr. AD', 'Mr. AD', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('25', '26', 'Mr. Alaa', 'Mr. Alaa', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('26', '27', 'Mr . Amit', 'Mr . Amit', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('27', '28', 'Mr Ashok', 'Mr Ashok', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('28', '29', 'Mr. Atik Munsi', 'Mr. Atik Munsi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('29', '30', 'MR.CHANDRAJITH', 'MR.CHANDRAJITH', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('30', '31', 'Mr.Dinesh', 'Mr.Dinesh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('31', '32', 'Mr. Errol Edwin', 'Mr. Errol Edwin', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('32', '33', 'Mr. Haresh', 'Mr. Haresh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('33', '34', 'Mr Hasan', 'Mr Hasan', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('34', '35', 'Mr. Ibrahim', 'Mr. Ibrahim', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('35', '36', 'Mr. Jamal Al Ali', 'Mr. Jamal Al Ali', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('36', '37', 'Mr. James', 'Mr. James', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('37', '38', 'MR. Kamran Ahmad Riaz', 'MR. Kamran Ahmad Riaz', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('38', '39', 'Mr. Mohamed samir', 'Mr. Mohamed samir', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('39', '40', 'Mr. Murtaza  (Satwa)', 'Mr. Murtaza  (Satwa)', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('40', '41', 'Mr.Neeraj', 'Mr.Neeraj', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('41', '42', 'Mr. Prabhat', 'Mr. Prabhat', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('42', '43', 'Mr. Pradeep Kumar', 'Mr. Pradeep Kumar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('43', '44', 'Mr.Rajesh', 'Mr.Rajesh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('44', '45', 'Mr. Rashid Al Dalal', 'Mr. Rashid Al Dalal', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('45', '46', 'MR. Rashid Mahmood', 'MR. Rashid Mahmood', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('46', '47', 'Mr. Saqlain', 'Mr. Saqlain', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('47', '48', 'Mr. Vivek Suresh', 'Mr. Vivek Suresh', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('48', '49', 'Ms. Ahiliya', 'Ms. Ahiliya', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('49', '50', 'Ms. Aparna Varma', 'Ms. Aparna Varma', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('50', '51', 'Ms Asma Kachwala', 'Ms Asma Kachwala', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('51', '52', 'Ms. Loulwa', 'Ms. Loulwa', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('52', '53', 'Ms. Roda', 'Ms. Roda', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('53', '54', 'Ms.Swarn', 'Ms.Swarn', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('54', '55', 'Ms. Thanuja', 'Ms. Thanuja', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('55', '56', 'Ms. Yogitha', 'Ms. Yogitha', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('56', '57', 'NASAB BUSINESS CENTER L.L.C', 'NASAB BUSINESS CENTER L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('57', '58', 'NATURAL TRENDY TIL&amp;FLOOR MAT.TR.LLC', 'NATURAL TRENDY TIL&amp;FLOOR M', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('58', '59', 'NOA Restaurant LLC', 'NOA Restaurant LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('59', '60', 'Original Wings &amp; Rings', 'Original Wings &amp; Rings', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('60', '61', 'Praveen Chaturvedi', 'Praveen Chaturvedi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('61', '62', 'Private Residences Dubai LLC', 'Private Residences Dubai LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('62', '63', 'QEXPRESS', 'QEXPRESS', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('63', '64', 'Q-Tech General Trading LLC', 'Q-Tech General Trading LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('64', '65', 'RIGHT HOMES REAL ESTATE BROKERS', 'R. H. REAL ESTATE BROKERS', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('65', '66', 'Rina &amp; rakesh Rachwani', 'Rina &amp; rakesh Rachwani', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('66', '67', 'RIVA FURNITURE LLC', 'RIVA FURNITURE LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('67', '68', 'Sajith Ansar', 'Sajith Ansar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('68', '69', 'Sustainable Builders', 'Sustainable Builders', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('69', '70', 'Techforce Technical Services', 'Techforce Technical Services', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('70', '71', 'Wonderwall Contracting L.L.C', 'Wonderwall Contracting L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('71', '72', 'Yosco Contracting LLC', 'Yosco Contracting LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('72', '73', 'Cash Customer', 'Cash Customer', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('73', '74', 'Hammer F I L Contracting LLC.', 'Hammer F I L Contracting LLC.', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('74', '75', 'BERGER PAINTS EMIRATES LTD CO (LLC)', 'BERGER PAINTS EMIRATES LTD CO', '', '5', '1', '001', '1', '', '4510', '1200', '5421', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('75', '78', 'CAESARS BLUEWATERS DUBAI L.L.C', 'CAESARS BLUEWATERS DUBAI L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('76', '79', 'Naga Lakshmi', 'Naga Lakshmi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('77', '80', 'Abdelaziz Abdelrahman Abdelaziz Shuhail Alqahtani', 'Abdelaziz Abdelrahman Abdelazi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('78', '81', 'Mr. Sachan Kumar', 'Mr. Sachan Kumar', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('79', '82', 'ADSS MARKETING &amp; COMMUNICATIONS FZ-LLC', 'ADSS MARKETING &amp; COMMUNICA', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('80', '83', 'AFRICA INTERNET GENERAL TRADING LLC', 'AFRICA INTERNET GENERAL TRADIN', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('81', '84', 'Al Baraa Building Contracting', 'Al Baraa Building Contracting', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('82', '85', 'Aevolve Beauty Saloon ', 'Aevolve Beauty Saloon &amp;a', '', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('83', '86', 'Mr. Aseem Doshi', 'Mr. Aseem Doshi', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('84', '87', 'Vijaya Chikermane', 'Vijaya Chikermane', '', '5', '3', '001', '1', '', '4510', '1200', '5421', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('85', '88', 'Primec Electromechanical LLC', 'Primec Electromechanical LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('86', '89', 'Clear Channel Advertising LLC', 'Clear Channel Advertising LLC', 'AL QUOZ IND 4 , DUBAI', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('87', '90', 'Angel Cakes', 'Angel Cakes', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('88', '91', 'AQS Management Consultancy', 'AQS Management Consultancy', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('89', '92', 'Naresh Mohnani', 'Naresh Mohnani', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('90', '93', 'Luigi Dsouza', 'Luigi Dsouza', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('91', '94', 'DESIGNSMITH INTERIORWORKS LLC', 'DESIGNSMITH INTERIORWORKS LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('92', '95', 'Ms. Alita', 'Ms. Alita', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('93', '96', 'Mr. Khan ( Hanguly)', 'Mr. Khan ( Hanguly)', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('94', '97', 'HATCH CONTRACTING LLC', 'HATCH CONTRACTING LLC', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('95', '98', 'THE PAD FITNESS L.L.C', 'THE PAD FITNESS L.L.C', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('96', '99', 'Mr Tahir', 'Mr Tahir', '', '10', '1', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('97', '100', 'Salim Lokhandwala', 'salim lokhand.', 'Dubai Hills\nDubai', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai Hills\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('98', '101', 'Bridge Forth &amp; Signature Contracting Co. LLC', 'Bridge Forth &amp; Signature', 'PO BOX 99856\nDUBAI', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'PO BOX 99856\nDUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('99', '102', 'Ms. Nour', 'nour', 'Springs 11, street 2, villa 36\nDubai', '5', '1', '001', '1', '', '4510', '1200', '4500', '1', 'Springs 11, street 2, villa 36\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('100', '103', 'Milad Interior Design', 'Milad Interior Design', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('101', '104', 'Majid Al Falasi', 'Majid Al Falasi', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('102', '105', 'EGY BUILD CONSTRUCTION LLC', 'EGY BUILD CONSTRUCTION LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('103', '106', 'NEW CLEARVIEW DECORATION DESIGN &amp; IMPLEMENTATION', 'NEW CLEARVIEW DECORATION DESIG', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('104', '107', 'Fadhel  Al Suwaidi', 'Fadhel  Al Suwaidi', 'Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('105', '108', 'Suzena', 'Suzena', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('106', '109', 'Akhil Vinayak', 'Akhil Vinayak', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('107', '110', 'Ms. Fatma Al Rais', 'Fatma Al Rais', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('108', '111', 'TAO Fit-Out Interior', 'TAO Fit-Out Interior', 'dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('109', '112', 'PAVIMENTO GENERAL TRADING L.L.C', 'PAVIMENTO GENERAL TRDG LLC', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Gulf Tower, Oud Mehta, Oud Mehta, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('110', '113', 'Loiter Electronics Trading ', 'Loiter Electronics Trading ', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Bldg 1 Sky Hub RC Campus, Dubai Al Ain Road,\nAl Lisaili, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('111', '114', 'Yogesh', 'Yogesh', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('112', '115', 'I 2 D Interiors', 'I 2 D Interiors', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('113', '116', 'JACOBS GARDEN HOTEL L.L.C', 'JACOBS GARDEN HOTEL L.L.C', 'po box 83010\nBur Dubai', '5', '2', '001', '1', '', '4510', '1200', '4510', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('114', '117', 'The international school of choueifat', 'The international school of ch', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('115', '118', 'RATLS CONTRACTING', 'RATLS CONTRACTING', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('116', '119', 'Mr. Salem Villa Lantana 1', 'Mr. Salem Villa Lantana 1', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('117', '120', 'Colart Publishing &amp; Advertising LLC', 'Colart Publishing &amp; Adv. L', 'PO Box 49652\nDUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 49652\nDUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('118', '121', 'Ms. Arpita', 'Ms. Arpita', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('119', '123', 'Turnkey fitout solutions', 'Turnkey fitout solutions', 'po box # 47862\nDubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'po box # 47862\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('121', '124', 'kalyan chakravarthy', 'kalyan chakravarthy', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('122', '125', 'Harun Sultan', 'Harun Sultan', 'Ajman', '12', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Ajman', '0', '', NULL, '', '', '', '', '0', '0'),
('123', '126', 'VERVE INTERIOR  DECORATION L.L.C', 'VERVE INTERIOR  DECORATION L.L', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'M04 Al Reemas Building\n13A Street, Al Qouz First, \nShaikh Zayed Road\n Dubai 128279\nUnited Arab Emirates\n', '0', '', NULL, '', '', '', '', '0', '0'),
('125', '127', 'Mr. Mohammed Zaal', 'Mr. Mohammed Zaal', 'Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('126', '128', 'H L N TECHNICAL SERVICES L.L.C', 'H L N TECHNICAL SERVICES L.L.C', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('127', '130', 'Kitchenscape Domestic Kitchens LLC', 'Kitchenscape Domestic Kitchens', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('128', '131', 'GREEN TERRA TECHNICAL SERVICES LLC', 'GREEN TERRA TECHNICAL SERVICES', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('129', '132', 'Ms. Serena', 'Ms. Serena', 'dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('130', '133', 'Highrise Owners Association Management (HOAM)', 'Highrise Owners Association Ma', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('131', '134', 'CHAMPION NEON LLC', 'CHAMPION NEON LLC', 'Po Box # 60288\nDIP\nDubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Po Box # 60288\nDIP\nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('132', '135', 'Beenish Haider', 'Beenish Haider', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('133', '136', 'Meherz Kreation LLC', 'Meherz Kreation LLC', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('134', '137', 'WASL PROPERTIES', 'WASL PROPERTIES', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('135', '138', 'Modern Seal Insulation Solutions', 'Modern Seal Insulation Soln', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('136', '139', 'Hotpack Packaging Ind. LLC', 'Hotpack Packaging Ind. LLC', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('138', '141', 'Mr. Rajiv', 'Mr. Rajiv', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('139', '142', 'Fincirc International Management', 'Fincirc International Manageme', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Opal Tower 1707/7, Burj Khalifa Street&#039;\nBusiness Bay \nDubai', '0', '', NULL, '', '', '', '', '0', '0'),
('140', '143', 'Ms. Shweta', 'Ms. Shweta', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('141', '144', 'Pooja Shah Mulani', 'Pooja Shah Mulani', 'Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('142', '145', 'Mr Xpert technical Services New Office Jebel Ali', 'MXTS office Jebel Ali								', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('143', '146', 'CASSIA GENERAL TRADNG LLC', 'CASSIA GENERAL TRADNG LLC', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PARK LANE TOWER, BUSINESS\nBAY OFFICE NO.711\ndubai', '0', '', NULL, '', '', '', '', '0', '0'),
('144', '147', 'Sanqour advertising service', 'Sanqour advertising service', 'Al Zahiya, Abu Dhabi', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Zahiya, Abu Dhabi', '0', '', NULL, '', '', '', '', '0', '0'),
('145', '148', 'EL TEAM LTD FZE - Sharjah', 'EL TEAM', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('146', '149', 'Wool Craft  Trading', 'Wool Craft  Trading', '', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('147', '150', 'Afaq Al Waseqh Electromechanical Services LLC', 'Afaq Al Waseqh Electromech', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('148', '151', 'MR. YU', 'MR. YU', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('149', '152', 'Astro properties', 'Astro properties', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('150', '153', 'BFMA Technical Works LLC', 'BFMA Technical Works LLC', 'P.O. Box – 48746,\nDubai, UAE\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box – 48746,\nDubai, UAE\n', '0', '', NULL, '', '', '', '', '0', '0'),
('151', '154', 'Mr. Hadisfer', 'Mr. Hadisfer', 'Villa 47 Hattan One Arabian Ranches', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 47 Hattan One Arabian Ranches', '0', '', NULL, '', '', '', '', '0', '0'),
('152', '155', 'JAMTS Tech LLC', 'JAMTS Tech LLC', 'PO Box 71893', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 71893', '0', 'Mr. Inaam', NULL, '', '', '', '', '0', '0'),
('153', '156', 'Sofitel Dubai The Palm', 'Sofitel Dubai The Palm', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Palm Jumeirah, East Crescent Road,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('154', '157', 'Rahul Ranbhare', 'Rahul Ranbhare', 'G05, Fortunato 1, JVC', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'G05, Fortunato 1, JVC', '0', '', NULL, '', '', '', '', '0', '0'),
('155', '158', 'MR. HITESH BHUPTA', 'MR. HITESH BHUPTA', 'Villa 349 Hayat townhouses', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 349 Hayat townhouses', '0', '', NULL, '', '', '', '', '0', '0'),
('156', '159', 'HOAM Highrise Owners Association Management', 'HOAM Highrise Owners ', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '1004, IT Plaza, Dubai Silicon Oasis\nP.O. Box 342180, Dubai, U.A.E.\n', '0', '', NULL, '', '', '', '', '0', '0'),
('157', '160', 'Al Hai Motors', 'Al Hai Motors', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Salah Al Din Street\nDubai\nUnited Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('158', '161', 'Noma Design House', 'Noma Design House', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'EXECUTIVE CENTRE - ONE CENTRAL DUBAI\nDUBAI - UAE - POBOX 9573', '0', '', NULL, '', '', '', '', '0', '0'),
('159', '162', 'Ms. Nissreen', 'Ms. Nissreen', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 149,\nSadiyat Island, Abu Dhabi\nUnited Arab Emirates.', '0', '', NULL, '', '', '', '', '0', '0'),
('160', '163', 'Mr. Gurpreet Sabharwal', 'Mr. Gurpreet Sabharwal', 'Villa 127 Picadilly Green Damac Hills', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 127 Picadilly Green Damac Hills', '0', '', NULL, '', '', '', '', '0', '0'),
('161', '164', 'La Stella productions', 'La Stella productions', 'Al Qouz Dubai\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Al Qouz Dubai\n', '0', '', NULL, '', '', '', '', '0', '0'),
('162', '165', 'Mr. Habib Nahra', 'Mr. Habib Nahra', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('163', '166', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE COSMETIC AND CARE LLC', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '8', '3', '001', '1', '', '4510', '1200', '4500', '1', 'CARELINE,MAIN BLOCK 6,UMMA AL THOUB, UAQ-UAE-7100', '0', '', NULL, '', '', '', '', '0', '0'),
('164', '167', 'One Laundry', 'One Laundry', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '57 Street​Warehouse 14, Dubai Investment Park 2, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('165', '168', 'ALI FARHAN TECHNICAL SERVICES LLC', 'ALI FARHAN TECHNICAL SERVICES ', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO BOX:191102\nOFFICE-2303,REGAL TOWER\nBUSINESS BAY-DUBAI-UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('166', '169', 'Mr. Hisham', 'Mr. Hisham', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('167', '170', 'Mrs.Sumeira', 'Mrs.Sumeira', 'Villa F 41 Golf Course Villas', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa F 41 Golf Course Villas', '0', '', NULL, '', '', '', '', '0', '0'),
('168', '171', 'Dinesh Sanghvi', 'Dinesh Sanghvi', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('169', '172', 'Unitra International LLC', 'Unitra International LLC', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Mezzan Holding Co. (Dubai, UAE)\nPost Box: 97108, Street 12\nBlock 28B Umm Ramool', '0', '', NULL, '', '', '', '', '0', '0'),
('170', '173', 'Mrs. Safinaz Basyoni', 'Mrs. Safinaz Basyoni', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('171', '174', 'GDM Interiors LLC', 'GDM Interiors LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('172', '175', 'Vishesh Singhania ', 'Vishesh Singhania ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('173', '176', 'Imperial Avenue', 'Imperial Avenue', 'Dubai -UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai -UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('174', '177', 'Shaul Nagawkar ', 'Shaul Nagawkar ', 'Apt 705 Tower F Executive Tower - Business Bay', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Apt 705 Tower F Executive Tower - Business Bay', '0', '', NULL, '', '', '', '', '0', '0'),
('175', '179', 'Mr. Ahmed Sharif', 'Mr. Ahmed Sharif', ' Al Ain Road', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', ' Al Ain Road', '0', '', NULL, '', '', '', '', '0', '0'),
('176', '180', 'ABDULLA DARWISH GHULOOM AHMED BAQER', 'ABDULLA DARWISH GHULOOM AHMED ', 'Villa 32 Al Warqa', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 32 Al Warqa', '0', '', NULL, '', '', '', '', '0', '0'),
('177', '181', 'Rabia Ahmed ', 'Rabia Ahmed ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('178', '182', 'Kakul Technical Services', 'Kakul Technical Services', 'DUBAI', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('179', '183', 'Riham AlAli', 'Riham AlAli', 'Villa 102,Al Barsha,dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 102,Al Barsha,dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('180', '184', 'Blacksmith Coffee', 'Blacksmith Coffee', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('181', '185', 'Sangeet Jain', 'Sangeet Jain', 'Villa 33 Al Naseem Mudon', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 33 Al Naseem Mudon', '0', '', NULL, '', '', '', '', '0', '0'),
('182', '186', 'Stone House Real Estate Brokerage', 'Stone House Real Estate Broker', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('183', '187', 'Mr. PRAVEEN CHATURVEDI', 'Mr. PRAVEEN CHATURVEDI', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '710 Al shoula residence\nBaqer mohebi supermarket same building Rolla street bur dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('184', '188', 'Warriors Aluminum and Glass Cont. LLC ', 'Warriors Aluminum and Glass', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Green Space Business Centre, Ras Al Khor 3, Dubai, UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('185', '189', 'Al Ghussun Aluminum Ind. LLC', 'Al Ghussun Aluminum Ind. LLC', 'PO Box 2748 Sharjah', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 2748 Sharjah', '0', '', NULL, '', '', '', '', '0', '0'),
('186', '190', 'High Power Services', 'High Power Services', 'PO Box 57467 Dubai.\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 57467 Dubai.\n', '0', '', NULL, '', '', '', '', '0', '0'),
('187', '191', 'Ms. Charu', 'Ms. Charu', 'Karama,DUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Karama,DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('188', '192', 'Mr. Abdul Qayyum', 'Mr. Abdul Qayyum', 'Villa 1, Ary Building Dubai Marina', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 1, Ary Building Dubai Marina', '0', '', NULL, '', '', '', '', '0', '0'),
('189', '193', 'Star Revive Medical Center', 'Star Revive Medical Center', 'jumeirah', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'jumeirah', '0', '', NULL, '', '', '', '', '0', '0'),
('190', '194', 'Phoenix Middle East', 'Phoenix Middle East', 'DIP 2 ,Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'DIP 2 ,Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('191', '195', 'MENAWATT TECHNICAL SERVICES EST.', 'MENAWATT TECHNICAL SERVICES ', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('192', '196', 'Mond Trading Services', 'Mond Trading Services', 'warehouse 141', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'warehouse 141', '0', '', NULL, '', '', '', '', '0', '0'),
('193', '197', 'Jean Paul Schmidt', 'Jean Paul Schmidt', 'Emaar South Villa 213', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Emaar South Villa 213', '0', '', NULL, '', '', '', '', '0', '0'),
('194', '198', 'Frederic de Melker', 'Frederic de Melker', 'City Walk Building 10, app 309', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'City Walk Building 10, app 309', '0', '', NULL, '', '', '', '', '0', '0'),
('195', '199', 'GULFLINE CONST. METALIC PARTS IND. L.L.C.', 'GULFLINE CONST. METALIC PARTS ', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'PLOT NO. 1224, AL SAJAA INDUSTRIAL AREA, BEHIND AL FAYED STREET PO BOX – 3453, SHARJAH,', '0', '', NULL, '', '', '', '', '0', '0'),
('196', '200', 'Abu Dhabi Entertainment Company ', 'Abu Dhabi Entertainment ', 'P.O. Box 862, Abu Dhabi, UAE', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box 862, Abu Dhabi, UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('197', '201', 'Mrs. Marie', 'Mrs. Marie', 'Villa 205, Maeen 4, The Lakes', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 205, Maeen 4, The Lakes', '0', '', NULL, '', '', '', '', '0', '0'),
('198', '202', 'Best Choice Trading LLC', 'Best Choice Trading LLC', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', 'Mr. Mozim Ahamed 052 644 7971', NULL, '', '', '', '', '0', '0'),
('199', '203', 'Ms. Selma Brahimi', 'Ms. Selma Brahimi', 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'belgravia 3 , district 15 JVC, apartment AG03 , Dubai\nMag 218 tower, aprt 2509', '0', '', NULL, '', '', '', '', '0', '0'),
('200', '204', 'Mr. Siddharth Ramchandani', 'Mr. Siddharth Ramchandani', 'Jumeirh Park Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Jumeirh Park Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('201', '205', 'Mr. Amit Gandhi', 'Mr. Amit Gandhi', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '400, 4th floor, Al Shera Tower, Cluster E, JLT, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('202', '206', 'Yashin Lalloo', 'Yashin Lalloo', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Belgravia 3 , district 15 JVC, apartment AG03 , Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('203', '207', 'Mr. Mohamed Alawi', 'Mr. Mohamed Alawi', 'Al Qouz Villa 7', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Qouz Villa 7', '0', '', NULL, '', '', '', '', '0', '0'),
('204', '208', 'Waht Alhams Technical services EST', 'Waht Alhams Technical services', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('205', '209', 'Mrs. Anna', 'Mrs. Anna', 'Villa 17 Trixis, Damac Hills 2 Akoya', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 17 Trixis, Damac Hills 2 Akoya', '0', '', NULL, '', '', '', '', '0', '0'),
('206', '210', 'Aztec Shipping LLC', 'Aztec Shipping LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('207', '211', 'priyanka chugh', 'priyanka chugh', 'palm jumeirah', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'palm jumeirah', '0', '', NULL, '', '', '', '', '0', '0'),
('208', '212', 'InsideOut Casa Technical Services', 'InsideOut Casa Technical ', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('209', '213', 'Mr.Naveen Balusamy', 'Mr.Naveen Balusamy', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('210', '214', 'Ms.Priya Motiani', 'Ms.Priya Motiani', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('211', '215', 'Mr. Dipak Main', 'Mr. Dipak Main', 'Villa 118 Trixis Damac 2', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 118 Trixis Damac 2', '0', '', NULL, '', '', '', '', '0', '0'),
('212', '216', 'Design Evolution Technical Service Co.', 'Design Evolution Technical Ser', 'AL Awir', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'AL Awir', '0', '', NULL, '', '', '', '', '0', '0'),
('213', '217', 'J&amp;D Gulf Contracting LLC', 'J&amp;D Gulf Contracting LLC', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Suite 329, Sultan Business Center Next to Lamcy Plaza Mall - Oud Metha - Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('214', '218', 'Blue Crown Furniture LLC', 'Blue Crown Furniture LLC', 'PO Box 81456 Dubai UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 81456 Dubai UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('215', '219', 'English Language Private School', 'English Language Private Schoo', ' Oud Metha', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', ' Oud Metha', '0', '', NULL, '', '', '', '', '0', '0'),
('216', '220', 'MARMUM DAIRY FARM LLC', 'MARMUM DAIRY FARM LLC', 'P.O BOX 31671,DUBAI - UAE', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'P.O BOX 31671,DUBAI - UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('217', '221', 'Mr. Chari', 'Mr. Chari', 'Villa 240 Pacifica Damac 2', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 240 Pacifica Damac 2', '0', '', NULL, '', '', '', '', '0', '0'),
('218', '222', 'Mr. Prabhu', 'Mr. Prabhu', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('219', '223', 'Kings Speciality Restaurant LLC', 'Kings Speciality Restaurant LL', 'downtown', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'downtown', '0', '', NULL, '', '', '', '', '0', '0'),
('220', '224', 'Mrs. Denise Villa 86', 'Mrs. Denise Villa 86', 'La Quinta Dubai.', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'La Quinta Dubai.', '0', '', NULL, '', '', '', '', '0', '0'),
('221', '225', 'Al Ghussun Advertising', 'Al Ghussun Advertising', 'PO Box 2748 Sharjah UAE', '6', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box 2748 Sharjah UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('222', '226', 'Al Ameemi International Trading L.L.C', 'Al Ameemi Intl Trdg LLC', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '80 Al Wasl Compound,\n17 A Street , Al Quoz Industrial Area 3,\nDubai, UAE.\nPost Box: 54173', '0', '', NULL, '', '', '', '', '0', '0'),
('223', '227', 'Mr. Sanjiv Soori', 'Mr. Sanjiv Soori', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 12 Carmen Village West Victory Heights Sports CIty Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('224', '228', 'IBECE ENEGY', 'IBECE ENEGY', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('225', '229', 'ECO SENSE CONTRACTING L.L.C', 'ECO SENSE CONTRACTING L.L.C', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'KHALEEJ CENTRE, KHALID BIN AL WALEED,\nMANKHOOL, DUBAI, Dubai, United Arab\nEmirates, 242643', '0', '', NULL, '', '', '', '', '0', '0'),
('226', '230', 'Hi Tech Pack and Trans LLC', 'Hi Tech Pack and Trans LLC', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'WARE HOUSE NO:96, INDUSTRIAL AREA 1,\nJEBEL ALI, DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('227', '231', 'Mrs. Zsuzsanna', 'Mrs. Zsuzsanna', 'Villa 3704 Greens Community West', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Villa 3704 Greens Community West', '0', '', NULL, '', '', '', '', '0', '0'),
('228', '231', 'Mrs. Zsuzsanna', ' 0505619411', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('229', '232', 'Al Haaj Bundoo Khan', 'Al Haaj Bundoo Khan', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Al Menhali Building, 10th St - Oud Metha - Dubai ', '0', '', NULL, '', '', '', '', '0', '0'),
('230', '233', 'Mr. Antonio', 'Mr. Antonio', '', '10', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('231', '234', 'Mobeen Javed', 'Mobeen Javed', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('232', '235', 'Inkas Auto Services LLC', 'Inkas Auto Services LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('233', '236', 'Three Lines Shipping LLC', 'Three Lines Shipping LLC', '14B Street Umm Ramool Rashidiya, Dubai ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '14B Street Umm Ramool Rashidiya, Dubai ', '0', '', NULL, '', '', '', '', '0', '0'),
('234', '237', 'VESPRA SERVICES LLC', 'VESPRA SERVICES LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('235', '238', 'Suntac General Trading LLC', 'Suntac General Trading LLC', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('236', '239', 'Wasl LLC', 'Wasl LLC', 'DUBAI', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'DUBAI', '0', '', NULL, '', '', '', '', '0', '0'),
('237', '240', 'Mr. Brian Howarth', 'Mr. Brian Howarth', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Villa E59 \nWhispering pines\nJumeirah Golf Estate ', '0', '', NULL, '', '', '', '', '0', '0'),
('238', '241', 'Mr. Mian Nasir Karimi ', 'Mr. Mian Nasir Karimi ', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('239', '242', 'Hermen Thomas ', 'Hermen Thomas ', 'G 003 \nNew bridge hills 3 \nUptown motor city', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'G 003 \nNew bridge hills 3 \nUptown motor city', '0', '', NULL, '', '', '', '', '0', '0'),
('240', '243', 'Deepak Panchariya', 'Deepak Panchariya', 'Gardenia, Wasl gate, TH 80', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Gardenia, Wasl gate, TH 80', '0', '', NULL, '', '', '', '', '0', '0'),
('241', '244', 'Nirav Patel', 'Nirav Patel', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('242', '245', 'Atlas Advertising', 'Atlas Advertising', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('243', '246', 'Mr. Martin Pfeiffer', 'Mr. Martin Pfeiffer', 'Meadows 6 Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Meadows 6 Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('244', '247', 'H L N TECHNICAL SERVICES LLC', 'H L N TECHNICAL SERVICES LLC', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'W/H 125, Al Habtoor w/h, Al Qusais, Dubai,\nDubai, United Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('245', '249', 'HAMMER BUILDING MAINTENANCE LLC', 'HAMMER BUILDING MAINTENANCE LL', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'SULTAN MOHAMMED ABDULLAH, 1, AL\nWARQA 1, DUBAI, Dubai, United Arab\n', '0', '', NULL, '', '', '', '', '0', '0'),
('246', '250', 'Discovery  General Contracting Co LLC', 'Discovery  General Contracting', 'ABU DHAHBI', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'ABU DHAHBI', '0', '', NULL, '', '', '', '', '0', '0'),
('247', '251', 'BIC Contracting LLC', 'BIC Contracting LLC', 'PO Box # 10869 Dubai', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', 'PO Box # 10869 Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('248', '252', 'Right Choice Metal  Products LLC', 'Right Choice Metal  Products L', 'villa 190\ndeema 4\nlakes', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'villa 190\ndeema 4\nlakes', '0', '', NULL, '', '', '', '', '0', '0'),
('249', '253', 'Vanita Fernandes', 'Vanita Fernandes', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('250', '254', 'Sagar Deshpande', 'Sagar Deshpande', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('251', '255', 'Bindhahi Trading LLC (SALES)', 'Bindhahi Trading LLC (SALES)', '', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('252', '256', 'J L T BUILDING MAINTENANCE L L C', 'J L T BUILDING MAINTENANCE L L', 'Shop : S12, Building No: 003, Al warsan First,\nInternational City, Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', 'Shop : S12, Building No: 003, Al warsan First,\nInternational City, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('253', '257', 'Yogi fixies technical services LLC', 'Yogi fixies technical services', '', '10', '2', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('254', '258', 'RKG INTERNATIONAL FZE ', 'RKG INTERNATIONAL FZE ', '509 Al Shoula Residence same building Baqer mohebi supermarket \nAl Rolla Street Bur Dubai', '5', '2', '001', '1', '', '4510', '1200', '4500', '1', '509 Al Shoula Residence same building Baqer mohebi supermarket \nAl Rolla Street Bur Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('255', '259', 'Al Sadarah  automatic Doors &amp; Barrier Tr.', 'Al Sadarah  automatic Doors &amp;a', 'po box  28916\nshop no 4\nSharjah UAE', '6', '3', '001', '1', '', '4510', '1200', '4500', '1', 'po box  28916\nshop no 4\nSharjah UAE', '0', '', NULL, '', '', '', '', '0', '0'),
('256', '260', 'Designex Technical Services LLC.', 'Designex Technical Services LL', 'Office 605 Zone B Aspect Tower, Al Saada,\nBusiness Bay, Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Office 605 Zone B Aspect Tower, Al Saada,\nBusiness Bay, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('257', '261', 'Oasis Investment Co. LLC', 'Oasis Investment Co. LLC', 'P.O. Box 93, Dubai, UAE. Mr. Alvin Dominic', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'P.O. Box 93, Dubai, UAE. Mr. Alvin Dominic', '0', '', NULL, '', '', '', '', '0', '0'),
('258', '262', 'DAMAC Properties Co. LLC', 'DAMAC Properties Co. LLC', ' P.O.Box:2195, Dubai, United Arab Emirates.', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', ' P.O.Box:2195, Dubai, United Arab Emirates.', '0', '', NULL, '', '', '', '', '0', '0'),
('259', '263', 'Urban Scapes Technical Services', 'Urban Scapes Technical Service', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('260', '264', 'EVOLVE INTERIORS LLC', 'EVOLVE INTERIORS LLC', 'Dubai, UAE ', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Dubai, UAE ', '0', '', NULL, '', '', '', '', '0', '0');
INSERT INTO `0_cust_branch` VALUES
('261', '265', 'Al Hayyat al jameela technical Services LLC', 'Al Hayyat al jameela technical', 'ASPIN Commercial Tower 103A, Shaikh Zayed\nRoad, Dubai, Duba', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'ASPIN Commercial Tower 103A, Shaikh Zayed\nRoad, Dubai, Duba', '0', '', NULL, '', '', '', '', '0', '0'),
('262', '266', 'A &amp; F AUTO REPAIR L L C', 'A &amp; F AUTO REPAIR L L C', 'Suit No. S4, 37th 318th Road, Al Quoz 2,\nIndustrial Area, Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Suit No. S4, 37th 318th Road, Al Quoz 2,\nIndustrial Area, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('263', '267', 'Ms. Francesca', 'Ms. Francesca', 'Loft 1503\ndubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Loft 1503\ndubai', '0', '', NULL, '', '', '', '', '0', '0'),
('264', '268', 'BVA Ports and Marine Contracting L.L.C', 'BVA Ports and Marine Contracti', 'Al Sharif Building - 1, Al Naif, Dubai, Dubai,\nUnited Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Al Sharif Building - 1, Al Naif, Dubai, Dubai,\nUnited Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('265', '269', 'Abo Hassan', 'Abo Hassan', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('266', '270', 'Mr. Mahinder Kumar Jangid', 'Mr. Mahinder Kumar Jangid', 'Apartment B112, Building B, Jumeirah Heights Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Apartment B112, Building B, Jumeirah Heights Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('267', '271', 'Zakia khan design services', 'Zakia khan design services', 'dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('268', '272', 'Mr. Gabriele Apartment', 'Mr. Gabriele Apartment', 'East 4802, ABR', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'East 4802, ABR', '0', '', NULL, '', '', '', '', '0', '0'),
('269', '273', 'ROCK REPUBLIC L.L.C', 'ROCK REPUBLIC L.L.C', 'Street 77, Dubai Investment Park 1, Dubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Street 77, Dubai Investment Park 1, Dubai', '0', '', NULL, '', '', '', '', '0', '0'),
('270', '274', 'Pakistan Association Dubai', 'Pakistan Association Dubai', 'Street 11b, Oud Metha Road,\nBur Dubai ,\nUnited Arab Emirates', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Street 11b, Oud Metha Road,\nBur Dubai ,\nUnited Arab Emirates', '0', '', NULL, '', '', '', '', '0', '0'),
('271', '275', 'Astra Polymers  DUBAI, JEBEL ALI OFFICE', 'Astra Polymers', 'Plots No. S10129 / S10130 Jafza South\nJebel Ali Free Zone Authority\nDubai, United Arab Emirates\nP.O. Box 261246 (License No. 4654)\n', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Plots No. S10129 / S10130 Jafza South\nJebel Ali Free Zone Authority\nDubai, United Arab Emirates\nP.O. Box 261246 (License No. 4654)\n', '0', '', NULL, '', '', '', '', '0', '0'),
('272', '276', 'Mohammad Hisham Khalid &amp; Thani Al Shirawi', 'Mohammad Hisham Khalid &amp; T', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', ' Mr. Prayag Raj', NULL, '', '', '', '', '0', '0'),
('273', '277', 'Ayesha Azeem', 'Ayesha Azeem', 'Pacifica\nVilla 167', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Pacifica\nVilla 167', '0', '', NULL, '', '', '', '', '0', '0'),
('275', '278', 'Mr. Borja Barbadillo', 'Mr. Borja Barbadillo', '', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '', '', '', '', '0', '0'),
('276', '279', 'Krizia Lee Abelido', 'Krizia Lee Abelido', 'Apartment 2102 Residence side, ontario tower business bay', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Apartment 2102 Residence side, ontario tower business bay', '0', '', NULL, '', '', '', '', '0', '0'),
('277', '280', 'Ms Anu', 'Ms Anu', 'Apartment 2804\nMarina Arcade  Tower\nDubai', '5', '3', '001', '1', '', '4510', '1200', '4500', '1', 'Apartment 2804\nMarina Arcade  Tower\nDubai', '0', '', NULL, '', '', '', '', '0', '0');

### Structure of table `0_dashboard` ###

DROP TABLE IF EXISTS `0_dashboard`;

CREATE TABLE `0_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard` ###

INSERT INTO `0_dashboard` VALUES
('1', 'Bank Information', '1', '0'),
('2', 'Prev. Year Revenue Comparison', '1', '0'),
('3', 'Prev. Year Expense Comparison', '1', '0'),
('4', 'Prev. Year COGS Comparison', '1', '0'),
('5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('6', 'Expense Break Down for Fiscal Year', '1', '0'),
('7', 'COGS Break Down for Fiscal Year', '1', '0'),
('8', 'Top 10 Customers', '2', '0'),
('9', 'Top 10 Selling Items', '2', '0'),
('10', 'Prev. Year Revenue Comparison', '2', '0'),
('11', 'Sales Aging', '2', '0'),
('12', 'Top 10 Open Quotations', '2', '0'),
('13', 'Top 10 Overdue Orders', '2', '0'),
('14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('15', 'Top 10 Purchase Items', '3', '0'),
('16', 'Supplier Aging', '3', '0'),
('17', 'Overdue Purchase Orders', '3', '0'),
('18', 'Overdue Invoices', '3', '0'),
('19', 'Top 10 Vendors', '3', '0'),
('20', 'Top 10 Selling Items', '4', '0'),
('21', 'Top 10 Purchase Items', '4', '0'),
('22', 'Inventory Value Locations', '4', '0'),
('23', 'Standard Rated Graph', '5', '0'),
('24', 'Zero Rated Graph', '5', '0'),
('25', 'Exempt Graph', '5', '0'),
('26', 'Excise Graph', '5', '0'),
('27', 'Total Sales', '6', '0'),
('28', 'Receivable', '7', '0'),
('29', 'Payable', '8', '0'),
('30', 'Profit', '9', '0');

### Structure of table `0_dashboard_language` ###

DROP TABLE IF EXISTS `0_dashboard_language`;

CREATE TABLE `0_dashboard_language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `deleted` tinyint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard_language` ###

INSERT INTO `0_dashboard_language` VALUES
('89', '002', '1', '5', '0'),
('90', '002', '3', '5', '0'),
('91', '002', '1', '3', '0'),
('133', '002', '3', '1', '0'),
('143', '002', '4', '1', '0'),
('148', '002', '2', '1', '0'),
('162', '002', '5', '1', '0'),
('165', '002', '5', '5', '0'),
('172', '002', '1', '1', '0'),
('173', '002', '5', '27', '0'),
('174', '002', '1', '25', '0');

### Structure of table `0_dashboard_reminders` ###

DROP TABLE IF EXISTS `0_dashboard_reminders`;

CREATE TABLE `0_dashboard_reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `next_date` date NOT NULL,
  `description` text DEFAULT NULL,
  `frequency` varchar(20) NOT NULL,
  `param` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_dashboard_reminders` ###


### Structure of table `0_dashboard_tables` ###

DROP TABLE IF EXISTS `0_dashboard_tables`;

CREATE TABLE `0_dashboard_tables` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(11) NOT NULL,
  `widget_id` int(11) NOT NULL,
  `widget_name` varchar(50) NOT NULL,
  `dashboard_id` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1340 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_dashboard_tables` ###

INSERT INTO `0_dashboard_tables` VALUES
('9', '2', '1', 'Bank Information', '1', '0'),
('10', '2', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('11', '2', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('12', '2', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('18', '2', '8', 'Top 10 Customers', '2', '0'),
('19', '2', '9', 'Top 10 Selling Items', '2', '0'),
('20', '2', '10', 'Prev. Year Revenue Comparison', '2', '0'),
('21', '2', '11', 'Sales Aging', '2', '0'),
('22', '2', '12', 'Top 10 Open Quotations', '2', '0'),
('23', '2', '13', 'Top 10 Overdue Orders', '2', '0'),
('24', '2', '14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('30', '2', '20', 'Top 10 Selling Items', '4', '0'),
('31', '2', '21', 'Top 10 Purchase Items', '4', '0'),
('32', '2', '15', 'Top 10 Purchase Items', '3', '0'),
('33', '2', '16', 'Supplier Aging', '3', '0'),
('34', '2', '17', 'Overdue Purchase Orders', '3', '0'),
('35', '2', '18', 'Overdue Invoices', '3', '0'),
('36', '2', '19', 'Top 10 Vendors', '3', '0'),
('731', '5', '1', 'Bank Information', '1', '0'),
('732', '5', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('733', '5', '3', 'Prev. Year Expense Comparison', '1', '0'),
('734', '5', '4', 'Prev. Year COGS Comparison', '1', '0'),
('735', '5', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('736', '5', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('737', '5', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('738', '5', '15', 'Top 10 Purchase Items', '3', '0'),
('739', '5', '16', 'Supplier Aging', '3', '0'),
('740', '5', '17', 'Overdue Purchase Orders', '3', '0'),
('741', '5', '18', 'Overdue Invoices', '3', '0'),
('742', '5', '19', 'Top 10 Vendors', '3', '0'),
('743', '3', '1', 'Bank Information', '1', '0'),
('744', '3', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('745', '3', '3', 'Prev. Year Expense Comparison', '1', '0'),
('746', '3', '4', 'Prev. Year COGS Comparison', '1', '0'),
('747', '3', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('748', '3', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('749', '3', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('1114', '1', '15', 'Top 10 Purchase Items', '3', '0'),
('1115', '1', '16', 'Supplier Aging', '3', '0'),
('1116', '1', '17', 'Overdue Purchase Orders', '3', '0'),
('1117', '1', '18', 'Overdue Invoices', '3', '0'),
('1118', '1', '19', 'Top 10 Vendors', '3', '0'),
('1187', '1', '20', 'Top 10 Selling Items', '4', '0'),
('1188', '1', '21', 'Top 10 Purchase Items', '4', '0'),
('1189', '1', '22', 'Inventory Value Locations', '4', '0'),
('1225', '1', '8', 'Top 10 Customers', '2', '0'),
('1226', '1', '9', 'Top 10 Selling Items', '2', '0'),
('1227', '1', '10', 'Prev. Year Revenue Comparison', '2', '0'),
('1228', '1', '11', 'Sales Aging', '2', '0'),
('1229', '1', '12', 'Top 10 Open Quotations', '2', '0'),
('1230', '1', '13', 'Top 10 Overdue Orders', '2', '0'),
('1231', '1', '14', 'Top 10 Uninvoiced Deliveres', '2', '0'),
('1236', '1', '23', 'Standard Rated Graph', '5', '0'),
('1237', '1', '24', 'Zero Rated Graph', '5', '0'),
('1238', '1', '25', 'Exempt Graph', '5', '0'),
('1239', '1', '26', 'Excise Graph', '5', '0'),
('1321', '2', '22', 'Total Sales', '6', '0'),
('1322', '2', '23', 'Receivable', '7', '0'),
('1323', '2', '24', 'Payable', '8', '0'),
('1324', '2', '25', 'Profit', '9', '0'),
('1332', '1', '1', 'Bank Information', '1', '0'),
('1333', '1', '2', 'Prev. Year Revenue Comparison', '1', '0'),
('1334', '1', '3', 'Prev. Year Expense Comparison', '1', '0'),
('1335', '1', '4', 'Prev. Year COGS Comparison', '1', '0'),
('1336', '1', '5', 'Revenue Break Down for Fiscal Year', '1', '0'),
('1337', '1', '6', 'Expense Break Down for Fiscal Year', '1', '0'),
('1338', '1', '7', 'COGS Break Down for Fiscal Year', '1', '0'),
('1339', '25', '1', 'Bank Information', '1', '0');

### Structure of table `0_dashboard_widgets` ###

DROP TABLE IF EXISTS `0_dashboard_widgets`;

CREATE TABLE `0_dashboard_widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `app` varchar(50) NOT NULL,
  `column_id` int(11) NOT NULL,
  `sort_no` int(11) NOT NULL,
  `collapsed` tinyint(4) NOT NULL,
  `widget` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `param` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

### Data of table `0_dashboard_widgets` ###

INSERT INTO `0_dashboard_widgets` VALUES
('1', '1', 'AP', '1', '1', '0', 'weeklysales', 'Top 10 Sales Weeks', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;desc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;}'),
('2', '1', 'AP', '1', '0', '0', 'weeklysales', 'Weekly Sales', '{&quot;top&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;Week End&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('3', '1', 'AP', '2', '1', '0', 'weeklysales', 'Lowest weeks sales', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('6', '1', 'AP', '2', '0', '0', 'dailysales', 'Daily Sales', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;}'),
('7', '1', 'orders', '1', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('9', '1', 'orders', '1', '1', '0', 'salesinvoices', 'Overdue invoices', '{&quot;data_filter&quot;:&quot;&quot;}'),
('10', '1', 'AP', '1', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('11', '1', 'AP', '2', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('12', '1', 'GL', '2', '1', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('13', '1', 'GL', '2', '0', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('14', '1', 'stock', '1', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('15', '1', 'stock', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('16', '1', 'manuf', '1', '0', '0', 'items', 'Top 10 items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('17', '1', 'manuf', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('18', '1', 'orders', '2', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('19', '1', 'GL', '2', '2', '0', 'bankbalances', 'Bank Balances', '{&quot;data_filter&quot;:&quot;&quot;}'),
('20', '1', 'GL', '1', '1', '0', 'dailybankbalances', 'Daily Current Account Balance', '{&quot;days_past&quot;:&quot;&quot;,&quot;days_future&quot;:&quot;&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('21', '1', 'GL', '1', '0', '0', 'banktransactions', 'Current Account Transactions', '{&quot;days_past&quot;:&quot;15&quot;,&quot;days_future&quot;:&quot;15&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('22', '2', 'AP', '1', '1', '0', 'weeklysales', 'Top 10 Sales Weeks', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;desc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;}'),
('23', '2', 'AP', '1', '0', '0', 'weeklysales', 'Weekly Sales', '{&quot;top&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;Week End&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('24', '2', 'AP', '2', '1', '0', 'weeklysales', 'Lowest weeks sales', '{&quot;top&quot;:&quot;10&quot;,&quot;orderby&quot;:&quot;Gross Sales&quot;,&quot;orderby_seq&quot;:&quot;asc&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('25', '2', 'AP', '2', '0', '0', 'dailysales', 'Daily Sales', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;dm.payment_terms = -1&quot;,&quot;graph_type&quot;:&quot;LineChart&quot;}'),
('26', '2', 'orders', '1', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;10&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('27', '2', 'orders', '1', '1', '0', 'salesinvoices', 'Overdue invoices', '{&quot;data_filter&quot;:&quot;&quot;}'),
('28', '2', 'AP', '1', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;Table&quot;}'),
('29', '2', 'AP', '2', '0', '0', 'suppliers', 'Top 10 Suppliers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('30', '2', 'GL', '2', '1', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('31', '2', 'GL', '2', '0', '0', 'glreturn', 'Return', '{&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('32', '2', 'stock', '1', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('33', '2', 'stock', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;stock&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('34', '2', 'manuf', '1', '0', '0', 'items', 'Top 10 items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;Table&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('35', '2', 'manuf', '2', '0', '0', 'items', 'Top 10 Items', '{&quot;top&quot;:&quot;&quot;,&quot;item_type&quot;:&quot;manuf&quot;,&quot;graph_type&quot;:&quot;PieChart&quot;,&quot;data_filter&quot;:&quot;&quot;}'),
('36', '2', 'orders', '2', '0', '0', 'customers', 'Top 10 Customers', '{&quot;top&quot;:&quot;&quot;,&quot;data_filter&quot;:&quot;&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('37', '2', 'GL', '2', '2', '0', 'bankbalances', 'Bank Balances', '{&quot;data_filter&quot;:&quot;&quot;}'),
('38', '2', 'GL', '1', '1', '0', 'dailybankbalances', 'Daily Current Account Balance', '{&quot;days_past&quot;:&quot;&quot;,&quot;days_future&quot;:&quot;&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;graph_type&quot;:&quot;ColumnChart&quot;}'),
('39', '2', 'GL', '1', '0', '0', 'banktransactions', 'Current Account Transactions', '{&quot;days_past&quot;:&quot;15&quot;,&quot;days_future&quot;:&quot;15&quot;,&quot;bank_act&quot;:&quot;0&quot;,&quot;data_filter&quot;:&quot;&quot;}');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` bigint(11) unsigned NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `notification_status` int(11) NOT NULL,
  `refund` int(11) NOT NULL,
  `cons_full_name` varchar(255) NOT NULL,
  `cons_address` varchar(255) NOT NULL,
  `cons_phone1` varchar(255) NOT NULL,
  `cons_phone2` varchar(255) NOT NULL,
  `country` varchar(50) NOT NULL,
  `amount_recived` double NOT NULL,
  `schedule_id` int(11) NOT NULL,
  `master_order` int(11) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `deliver_to` varchar(100) NOT NULL,
  `technician` int(11) NOT NULL,
  `pdcStatus` int(11) NOT NULL,
  `pdcDate` date NOT NULL,
  `party_name` varchar(200) NOT NULL,
  `draft` int(11) NOT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###

INSERT INTO `0_debtor_trans` VALUES
('4', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('4', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('5', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('6', '0', '1', '18', '17', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('6', '0', '1', '128', '126', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('6', '0', '1', '230', '226', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('6', '0', '1', '249', '245', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('6', '0', '1', '250', '246', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('6', '0', '1', '251', '247', '2023-12-31', '0000-00-00', 'JV-04', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('7', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '25', '24', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '27', '26', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '32', '31', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '33', '32', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '36', '35', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '48', '47', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '50', '49', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '57', '56', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '69', '68', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '70', '69', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '72', '71', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '74', '73', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '75', '74', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '80', '77', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '82', '79', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '88', '85', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '89', '86', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '102', '99', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '105', '102', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '106', '103', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '111', '108', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '112', '109', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '134', '131', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '136', '133', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '146', '143', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '151', '148', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '152', '149', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '156', '153', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '168', '165', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '181', '177', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '187', '183', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '195', '191', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '197', '193', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '198', '194', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '199', '195', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '203', '199', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '204', '200', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '206', '202', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '207', '203', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '208', '204', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '214', '210', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('8', '0', '1', '234', '231', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '', '', '', '', '0', '0', '0', '', '', '0', '0', '0000-00-00', '', '0'),
('9', '0', '1', '22', '21', '2023-12-31', '0000-00-00', 'JV-03', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', NULL, '0', '0', NULL, '0', '0', '0', '', '',