<?php

function add_dimension($reference, $name, $type_, $date_, $due_date, $memo_, $project_amount=null, $profit_margin=null, $exclude_from_sales=null)
{
	global $Refs;

	begin_transaction();

	$date = date2sql($date_);
	$duedate = date2sql($due_date);

	$sql = "INSERT INTO ".TB_PREF."dimensions (reference, name, type_, date_, due_date, project_amount, profit_margin, exclude_from_sales)
		VALUES (".db_escape($reference).", ".db_escape($name).", ".db_escape($type_).", '$date', '$duedate', ".db_escape($project_amount).", ".db_escape($profit_margin).", ".db_escape($exclude_from_sales).")";
	db_query($sql, "could not add dimension");
	$id = db_insert_id();

	add_comments(ST_DIMENSION, $id, $date_, $memo_);
	add_audit_trail(ST_DIMENSION, $id, $date_, 'Dimension Created');

	$Refs->save(ST_DIMENSION, $id, $reference);

	commit_transaction();

    // if($exclude_from_sales){
		$hr_dim = add_dimension_in_hr($name, $id);
		if(db_query($hr_dim, null, true)){
			update_dimension_reference_in_hr();
	    } 
// 	}

	return $id;
}

function update_dimension($id, $name, $type_, $date_, $due_date, $memo_, $project_amount=null, $profit_margin=null, $exclude_from_sales=null)
{
	begin_transaction();

	$date = date2sql($date_);
	$duedate = date2sql($due_date);

	$sql = "UPDATE ".TB_PREF."dimensions SET name=".db_escape($name).",
		type_ = ".db_escape($type_).",
		date_='$date',
		due_date='$duedate',
		project_amount = ".db_escape($project_amount).",
		profit_margin = ".db_escape($profit_margin).",
		exclude_from_sales = ".db_escape($exclude_from_sales)."  
		WHERE id = ".db_escape($id);

	db_query($sql, "could not update dimension");

	update_comments(ST_DIMENSION, $id, null, $memo_);
	add_audit_trail(ST_DIMENSION, $id, $date_, 'Dimension Updated');

	commit_transaction();

    if(!dimension_exist_in_hr($id)){
		$hr_dim = add_dimension_in_hr($name, $id);
		if(db_query($hr_dim, null, true)){
			update_dimension_reference_in_hr();
	    } 
	} 

	return $id;
}

function delete_dimension($id)
{
	begin_transaction();

	// delete the actual dimension
	$sql="DELETE FROM ".TB_PREF."dimensions WHERE id=".db_escape($id);
	db_query($sql,"The dimension could not be deleted");

 	$sql = " UPDATE ".TB_PREF."payroll_department SET deleted = 1 WHERE dimension_id = ".$id;
	db_query($sql, null, true);

	delete_comments(ST_DIMENSION, $id);
	add_audit_trail(ST_DIMENSION, $id, $date_, 'Dimension Deleted');


	commit_transaction();
}

//--------------------------------------------------------------------------------------

function get_dimension($id, $allow_null=false)
{
    $sql = "SELECT * FROM ".TB_PREF."dimensions	WHERE 1 ";
    if($id)
    	$sql .= " AND id=".db_escape($id);

	$result = db_query($sql, "The dimension could not be retrieved");

	if (!$allow_null && db_num_rows($result) == 0)
		display_db_error("Could not find dimension $id", $sql);

	return db_fetch($result);
}

//--------------------------------------------------------------------------------------

function get_dimension_string($id, $html=false, $space=' ')
{
	if ($id <= 0)
	{
		if ($html)
			$dim = "&nbsp;";
		else
			$dim = "";
	}
	else
	{
		$row = get_dimension($id, true);
		$dim = $row['reference'] . $space . $row['name'];
	}

	return $dim;
}

//--------------------------------------------------------------------------------------

function get_dimensions()
{
	$sql = "SELECT * FROM ".TB_PREF."dimensions ORDER BY date_";

	return db_query($sql, "The dimensions could not be retrieved");
}
//---------------------------------------------------------------------
function dimensions1_count()
{
        	$sql = "SELECT count(id) as total FROM ".TB_PREF."dimensions where type_='1'";
            $res = db_query($sql, "The dimensions could not be retrieved");
            $row =db_fetch($res);
         
          return $row['total']; 
    
}

//--------------------------------------------------------------------------------------

function dimension_has_deposits($id)
{
	return dimension_has_payments($id);
}

//--------------------------------------------------------------------------------------

function dimension_has_payments($id)
{
	$sql = "SELECT COUNT(*) FROM ".TB_PREF."gl_trans WHERE dimension_id = ".db_escape($id)
	 . " OR dimension2_id = ".db_escape($id);
	$res = db_query($sql, "Transactions could not be calculated");
	$row = db_fetch_row($res);
	return ($row[0] > 0);
}

function dimension_is_closed($id)
{
	$result = get_dimension($id);
	return ($result['closed'] == '1');
}

//--------------------------------------------------------------------------------------

function close_dimension($id)
{
	$sql = "UPDATE ".TB_PREF."dimensions SET closed='1' WHERE id = ".db_escape($id);
	db_query($sql, "could not close dimension");
}

//--------------------------------------------------------------------------------------

function reopen_dimension($id)
{
	$sql = "UPDATE ".TB_PREF."dimensions SET closed='0' WHERE id = ".db_escape($id);
	db_query($sql, "could not reopen dimension");
}

//--------------------------------------------------------------------------------------

function get_dimension_balance_all($id, $from, $to, $group_by=array('account'), $gl_account=null) 
{
	$from = date2sql($from);
	$to = date2sql($to);
	$sql = "SELECT account, coa.account_name, sum(amount) AS amt, type_no, dimension_id, type, type_no, tran_date   
		FROM "
		.TB_PREF."gl_trans trans,"
		.TB_PREF."chart_master coa
		WHERE
			trans.account = coa.account_code
		AND	(dimension_id = ".db_escape($id)." OR dimension2_id = ".db_escape($id).")
		AND	tran_date >= '$from' AND tran_date <= '$to' ";
	
	if($gl_account)
		$sql .= " AND trans.account = ".db_escape($gl_account);
		
		$sql .= " GROUP BY ".implode(",", $group_by)." ORDER BY counter ";
	return db_query($sql, "Transactions could not be calculated");
}

//--------------------------------------------------------------------------------------

function get_dimension_balance($id, $from, $to) 
{
	$id = db_escape($id);
	$sql = "SELECT SUM(amount)
			FROM ".TB_PREF."gl_trans 
			WHERE
				tran_date >= '" .	date2sql($from) . "' 
			AND	tran_date <= '" . date2sql($to) . "' 
			AND (dimension_id = $id OR dimension2_id = $id)";
	$res = db_query($sql, "Sum of transactions could not be calculated");
	$row = db_fetch_row($res);

	return $row[0];
}

//--------------------------------------------------------------------------------------

function get_sql_for_search_dimensions($dim, $from, $to, $order='', $type = -1, $open=false, $overdue = false, $dimension_id=null)
{
	$sql = "SELECT dim.id,
		dim.reference,
		dim.name,
		dim.date_,
		dim.due_date,
		dim.closed
		FROM ".TB_PREF."dimensions as dim WHERE id > 0";

	if ($order)
	{
		$sql .= " AND reference LIKE ".db_escape("%". $order . "%");
	} else {

		if ($dim == 1)
			$sql .= " AND type_=1";

		if ($open)
			$sql .= " AND closed=0";

		if ($type > 0)
			$sql .= " AND type_=".db_escape($type);

		if ($overdue)
		{
			$today = date2sql(Today());

			$sql .= " AND due_date < '$today'";
		}
		if($dimension_id)
			$sql .= " AND id = ".db_escape($dimension_id);

		$sql .= " AND date_ >= '" . date2sql($from) . "'
			AND date_ <= '" . date2sql($to) . "'";
	}
	return $sql;
}


function add_dimension_in_hr($name, $dimension_id){
	$sql = " SELECT pattern FROM ".TB_PREF."reflines WHERE trans_type = ".db_escape(ST_DIMENSION);
	$reference = db_fetch(db_query($sql, null, true))['pattern'];
	$sql = " INSERT INTO ".TB_PREF."dimensions (reference, name, type_, date_, due_date, dimension_id) VALUES (".db_escape($reference).", ".db_escape($name).", ".db_escape(1).", ".db_escape(date('Y-m-d')).", ".db_escape(date('2028-m-d')).", ".db_escape($dimension_id).") ";
	return $sql;
}

function update_dimension_reference_in_hr(){
	$sql = " UPDATE ".TB_PREF."reflines  SET pattern = (pattern+1) WHERE trans_type =".db_escape(ST_DIMENSION);
	db_query($sql, null, true);
}

//----------------------------------------------------------------------------------------------------
 function get_invoices_against_dimension($dimension_id=null){
 	$sql = " SELECT reference FROM ".TB_PREF."debtor_trans WHERE type = ".db_escape(ST_SALESINVOICE)." AND dimension_id = ".db_escape($dimension_id);
 	$result = db_query($sql);
 	$string = '';
 	while($row = db_fetch($result)){
 		$string .= $row['reference'].',';
 	}
 	return trim($string, ',');
 }

function get_last_attendance_on_project($dimension_id=null){
	$sql = " SELECT att_ot_date FROM ".TB_PREF."payroll_transaction WHERE dimension_id = ".db_escape($dimension_id)."
				AND doc_type = ".db_escape(107)." AND deleted = 0 ";
	return db_fetch(db_query($sql, null, true))['att_ot_date'];
}

function get_dimension_gl_amount($dimension_id, $type=null, $trans_no=null){
		$sql = " SELECT SUM(amount) as amount FROM  ".TB_PREF."gl_trans 
				 WHERE dimension_id = ".db_escape($dimension_id)."
				 AND amount > 0 AND type =  ".db_escape($type);
		if(in_array($type, array(ST_BANKPAYMENT, ST_SUPPINVOICE, ST_SUPPAYMENT)))
			$sql .= " AND approve_status = 1 ";
		else
			$sql .= " AND approve_status = 0 ";				 
		if($trans_no)
			$sql .= " AND type_no = ".db_escape($trans_no);		 
		return db_fetch(db_query($sql))['amount'];
}

function get_tax_by_dimension($dimension_id){
		$sql = " SELECT SUM(tax.amount) as tax_amount FROM ".TB_PREF."trans_tax_details as tax 
					LEFT JOIN ".TB_PREF."debtor_trans as dt 
					ON dt.trans_no = tax.trans_no AND tax.trans_type = dt.type 
					WHERE dt.dimension_id = ".db_escape($dimension_id)." AND dt.type = ".db_escape(ST_SALESINVOICE);
		return db_fetch(db_query($sql))['tax_amount'];
}
function get_dimension_incurred_amount($dimension_id){
     $gross_salary = get_salary_allocation_on_site($dimension_id);
	 $supp_inv_amount = get_supp_trans_sum_by_dimension($dimension_id, ST_SUPPINVOICE);
	 $supp_credit_amount = get_supp_trans_sum_by_dimension($dimension_id, ST_SUPPCREDIT);
	 return ($supp_inv_amount - $supp_credit_amount) + $gross_salary;
}



function dimension_order_total($dimension_id=null){
  	$sql = "SELECT SUM((d.unit_price*d.quantity) - d.discount_percent) as amount FROM ".TB_PREF."sales_orders as so
  	        LEFT JOIN ".TB_PREF."sales_order_details as d ON so.order_no = d.order_no AND so.trans_type = d.trans_type 
             WHERE so.trans_type = ".db_escape(ST_SALESORDER)." AND so.dimension_id = ".db_escape($dimension_id)." AND so.total != 0 ";
    $result = db_query($sql);
    return db_fetch($result);
}



function dimension_exist_in_hr($dimension_id=null){
	$sql = " SELECT COUNT(*) as exist FROM ".TB_PREF."dimensions
			 WHERE dimension_id = ".db_escape($dimension_id);
	$result = db_query($sql, null, true);
	return db_fetch($result)['exist'];
}

function get_debtor_trans_sum_by_dimension($dimension_id=null, $trans_type=null){
	$sql = "SELECT SUM(trans.ov_amount + trans.ov_freight + trans.ov_freight_tax - trans.ov_discount) as total_amount 
			FROM  ".TB_PREF."debtor_trans as trans 
			WHERE trans.dimension_id = ".db_escape($dimension_id)."
			AND trans.type = ".db_escape($trans_type);
	$result  = db_query($sql);
	return db_fetch($result)['total_amount'];

}

function get_debtor_trans_sum_by_dimension_with_vat($dimension_id=null, $trans_type=null){
	$sql = "SELECT SUM(trans.ov_amount + trans.ov_freight + trans.ov_freight_tax + trans.ov_gst - trans.ov_discount) as total_amount 
			FROM  ".TB_PREF."debtor_trans as trans 
			WHERE trans.dimension_id = ".db_escape($dimension_id)."
			AND trans.type = ".db_escape($trans_type);
	$result  = db_query($sql);
	return db_fetch($result)['total_amount'];

}

function get_supp_trans_sum_by_dimension($dimension_id=null, $trans_type=null){
	$sql = "SELECT SUM(trans.ov_amount - trans.ov_discount) as total_amount 
			FROM  ".TB_PREF."supp_trans as trans 
			WHERE trans.dimension_id = ".db_escape($dimension_id)."
			AND trans.type = ".db_escape($trans_type)."
			AND (IF(trans.type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), trans.approve_status = 1, trans.approve_status = 0 )) ";
	$result  = db_query($sql);
	return db_fetch($result)['total_amount'];

}

function get_salary_allocation_on_site($dimension_id=null){
    $sql = " SELECT pt.*, emp.working_hrs FROM ".TB_PREF."payroll_transaction as pt 
             LEFT JOIN ".TB_PREF."payroll_employee as emp
             ON emp.employee_id = pt.eid  
             WHERE pt.dimension_id = ".db_escape($dimension_id)."
				AND pt.doc_type = ".db_escape(107)." AND pt.deleted = 0  AND pt.technician_id !=0 ";
	 $result = db_query($sql, null, true);
	 $gross_salary = 0;
	 while ($row = db_fetch($result)){
		$time = get_time_format(date('H:I:s', strtotime($row['timein'])), date('H:I:s', strtotime($row['timeout'])));
		$hours = $time['hour'];
		$minutes = $time['minutes']/60;
		
		if($row['over_time']==0){
            if($row['ovh_salary']){
               $gross_salary += ($row['ovh_salary']*$hours);
            }else{
                if($hours >= 1 && $hours <= 4){
                   $gross_salary += $row['ovh_salary_slap_1'];
            }
                if($hours > 4){
                    $gross_salary += $row['ovh_salary_slap_2'];
                }   
            } 
		}else{
            $OvTime = explode(".", $row["hrs"]);
               
            $permonth_ov = $row['ov_salary'] * 12;	
             
            $perday_ov = $permonth_ov / 365;
            $perhour_ov = $perday_ov / $row['working_hrs'];
            if($row['ot_factor_id'])
                $gross_salary += $row['hrs'] * $row['ov_salary'] ;
		}
		
	 }
	 
	 return $gross_salary;
}

