<?php

if(isset($_GET['outstanding_only'])){
	$page_security = 'SA_DIMTRANSVIEW';
}else{

	$page_security = 'SA_DIMTRANSVIEWINQUIRY';
}
$path_to_root="../..";

include($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/sales/includes/db/custalloc_db.inc");

GLOBAL $Ajax;

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

if (isset($_GET['outstanding_only']) && $_GET['outstanding_only'])
{
	$outstanding_only = 1;
	page(_($help_context = "Search Outstanding Dimensions"), false, false, "", $js);
}
else
{
	$outstanding_only = 0;
	page(_($help_context = "Search Dimensions"), false, false, "", $js);
}
//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders'))
{
	$Ajax->activate('dim_table');
} elseif (get_post('_OrderNumber_changed'))
{
	$disable = get_post('OrderNumber') !== '';

	$Ajax->addDisable(true, 'FromDate', $disable);
	$Ajax->addDisable(true, 'ToDate', $disable);
	$Ajax->addDisable(true, 'type_', $disable);
	$Ajax->addDisable(true, 'OverdueOnly', $disable);
	$Ajax->addDisable(true, 'OpenOnly', $disable);

	if ($disable) {
		set_focus('OrderNumber');
	} else
		set_focus('type_');

	$Ajax->activate('dim_table');
}

//--------------------------------------------------------------------------------------

if (isset($_GET["stock_id"]))
	$_POST['SelectedStockItem'] = $_GET["stock_id"];

//--------------------------------------------------------------------------------------

start_form(false, false, $_SERVER['PHP_SELF'] ."?outstanding_only=$outstanding_only");

start_table(TABLESTYLE_NOBORDER);
start_row();

ref_cells(_("Reference:"), 'OrderNumber', '',null, '', true);
dimensions_list_cells(_("Dimension :"), 'dimension_id', null, _("Select Dimension"), ' ', false, 1, false);
hidden('type_', 1);
date_cells(_("From:"), 'FromDate', '', null, null, -1);
date_cells(_("To:"), 'ToDate');

// start_table(TABLESTYLE_NOBORDER);
// start_row();

check_cells( _("Only Overdue:"), 'OverdueOnly', null);

if (!$outstanding_only)
{
   	check_cells( _("Only Open:"), 'OpenOnly', null);
}
else
	$_POST['OpenOnly'] = 1;

submit_cells('SearchOrders', _("Search"), '', '', 'default');

//--- PRINT BUTTONS ---------------------------------------------------------------------------------

$trans_type = DIMINQ;
// echo  "<td>". print_dim_dashboard_print(0, check_value('OpenOnly'), check_value('OverdueOnly'),  _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, false, '', '',$_POST['FromDate'], $_POST['ToDate'], $_POST['OrderNumber'],
//   $_POST["type_"])."</td>";

 echo  "<td>". print_dim_dashboard_print(1, check_value('OpenOnly'), check_value('OverdueOnly'),  _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, false, '', '',$_POST['FromDate'], $_POST['ToDate'], $_POST['OrderNumber'],
  $_POST["type_"], $_POST['dimension_id'])."</td>";
 


//--- PRINT BUTTONS ---------------------------------------------------------------------------------


end_row();
end_table();

$dim = get_company_pref('use_dimension');

function view_link($row) 
{
	if(!$_SESSION['wa_current_user']->can_access_page('SA_DIMTRANSINTERNALVIEW')){
		return  '<a href="#">'.$row["id"].'</a>';

	}else{
	return get_dimensions_trans_view_str(ST_DIMENSION, $row["id"]);
}
}

function sum_dimension($row) 
{
	$balance =  get_dimension_balance($row['id'], $_POST['FromDate'], $_POST['ToDate']); 
	return number_format2($balance, 2);
}

function partial_paid($row){
	$payment = get_allocation_by_dimension($row['id']);
	if(!$payment)
		$payment = get_dimension_gl_amount($row['id'], ST_CUSTPAYMENT);

    $sales_invoicing = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_SALESINVOICE);
    $credit_amount = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_CUSTCREDIT);
    
    $invoice_amount = ($sales_invoicing-$credit_amount);

	$bank_deposit = get_dimension_gl_amount($row['id'], ST_BANKDEPOSIT);
	$payment += $bank_deposit;
	if($payment==0) return false;		
	if(user_numeric($invoice_amount) > user_numeric($payment))
	    return true;
	else 
	    return false;
}

function fully_paid($row){
    
        $payment = get_allocation_by_dimension($row['id']);
		if(!$payment)
			$payment = get_dimension_gl_amount($row['id'], ST_CUSTPAYMENT);

        $sales_invoicing = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_CUSTCREDIT);
        $invoice_amount = ($sales_invoicing-$credit_amount);

		$bank_deposit = get_dimension_gl_amount($row['id'], ST_BANKDEPOSIT);
		$payment += $bank_deposit;		
		if($payment==0)
			return false;
		elseif(user_numeric($invoice_amount) == user_numeric($payment))
			return true;
		else 
			return false;
 }

function edit_link($row)
{
	if(!$_SESSION['wa_current_user']->can_access_page('SA_DIMTEDIT'))
		return '';
	
	return pager_link(_("Edit"),
			"/dimensions/dimension_entry.php?trans_no=" . $row["id"], ICON_EDIT);
}

function attach($row){
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".ST_DIMENSION."&trans_no=".$row["id"], ICON_ATTACH);
}

function show_last_activity($row){
		$activity =  get_last_attendance_on_project($row['id']);
		if(!$activity)
			return 'N/A';
		else
			return sql2date($activity);
}

function show_sales_gross($row){
        $amount = dimension_order_total($row['id'])['amount'];
        $tax = $amount * 0.05;
		return number_format2($amount + $tax, 2);
}

function show_sales_net($row){
    $sales_invoicing = get_debtor_trans_sum_by_dimension($row['id'], ST_SALESINVOICE);
    $credit_amount = get_debtor_trans_sum_by_dimension($row['id'], ST_CUSTCREDIT);
    $amount = ($sales_invoicing-$credit_amount);
	return number_format2($amount, 2);
}

function show_incurred_cost($row){
        $supp_inv_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPINVOICE);
        $supp_credit_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPCREDIT);
        $gross_salary = get_salary_allocation_on_site($row['id']);
		$bank_payment = get_dimension_gl_amount($row['id'], ST_BANKPAYMENT);
		$cost_incr = $supp_inv_amount + $supp_credit_amount + $gross_salary + $bank_payment; 
		return 	number_format2($cost_incr, 2);
}

function show_cost_reveneue($row){
        $supp_inv_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPINVOICE);
        $supp_credit_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPCREDIT);
        $gross_salary = get_salary_allocation_on_site($row['id']);
		$bank_payment = get_dimension_gl_amount($row['id'], ST_BANKPAYMENT);
		$cost_incr = $supp_inv_amount + $supp_credit_amount + $gross_salary + $bank_payment; 
		
        $sales_invoicing = get_debtor_trans_sum_by_dimension($row['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension($row['id'], ST_CUSTCREDIT);
		
		$cost_revenue = $cost_incr/($sales_invoicing-$credit_amount)*100;
		
		return number_format2(abs($cost_revenue), 2)."%";
}

function show_profit_revenue($row){
        $supp_inv_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPINVOICE);
        $supp_credit_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPCREDIT);
        $gross_salary = get_salary_allocation_on_site($row['id']);
        $bank_payment = get_dimension_gl_amount($row['id'], ST_BANKPAYMENT);
        $cost_incr = $supp_inv_amount + $supp_credit_amount + $gross_salary + $bank_payment; 
		
        $sales_invoicing = get_debtor_trans_sum_by_dimension($row['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension($row['id'], ST_CUSTCREDIT);
		
		$profit_revenue = ($sales_invoicing - $credit_amount) - $cost_incr;
		return number_format2($profit_revenue, 2);
}

function show_profit($row){
		$bank_payment = get_dimension_gl_amount($row['id'], ST_BANKPAYMENT);
		$sales_invoicing = get_debtor_trans_sum_by_dimension($row['id'], ST_SALESINVOICE);
		$credit_amount = get_debtor_trans_sum_by_dimension($row['id'], ST_CUSTCREDIT);
		
		$supp_inv_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPINVOICE);
		$supp_credit_amount = get_supp_trans_sum_by_dimension($row['id'], ST_SUPPCREDIT);
		$gross_salary = get_salary_allocation_on_site($row['id']);
		
 
        $cost_incr = $supp_inv_amount + $supp_credit_amount + $gross_salary + $bank_payment;
        $profit_revenue = ($sales_invoicing - $credit_amount) - $cost_incr;
 
		$profit = $profit_revenue/($sales_invoicing - $credit_amount)*100;
		return number_format2($profit, 2)."%";
}

function show_advance_received($row){
		$payment = get_allocation_by_dimension($row['id']);
		if(!$payment)
			$payment = get_dimension_gl_amount($row['id'], ST_CUSTPAYMENT);
		$bank_deposit = get_dimension_gl_amount($row['id'], ST_BANKDEPOSIT);
		return number_format2($payment + $bank_deposit, 2);
}

function show_total_receivable($row){
        $sales_invoicing = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_CUSTCREDIT);
        
        
        $total_receivable = ($sales_invoicing-$credit_amount);
        
        return number_format2($total_receivable, 2);
}

function show_payment_status($row){
	        $payment = get_allocation_by_dimension($row['id']);
		if(!$payment)
			$payment = get_dimension_gl_amount($row['id'], ST_CUSTPAYMENT);
		$bank_deposit = get_dimension_gl_amount($row['id'], ST_BANKDEPOSIT);

		$payment += $bank_deposit;		

        $sales_invoicing = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_CUSTCREDIT);
        
        $invoice_amount = ($sales_invoicing-$credit_amount);

		if(user_numeric($payment)==0)
			$payment_status = 'Pending';
		elseif(user_numeric($invoice_amount) == user_numeric($payment))
			$payment_status = 'Fully Paid';
		elseif(user_numeric($invoice_amount) > user_numeric($payment))
			$payment_status = 'Partially Paid';
		elseif(user_numeric($payment) > user_numeric($invoice_amount))
			$payment_status = 'Advance Payment';
		return $payment_status;
}

function show_quotations($row){
    global $trans_type, $path_to_root;
    $description = '';
    // Find In Quotation
    $sql = " SELECT * FROM ".TB_PREF."sales_orders 
             WHERE trans_type = ".ST_SALESQUOTE."
             AND dimension_id = ".db_escape($row["id"]);
    $quote_result = db_query($sql);
    if($quote_result->num_rows){
	    while($quote=db_fetch($quote_result)){
	        $description .= print_document_link($quote['order_no'],  $quote['reference'], true, $quote['trans_type'], false)."&nbsp&nbsp&nbsp"; 
	    }
	    $description = rtrim($description, ",");
    }

	if($description)
		return $description;

    // Find In Sales Order
    $sql = " SELECT quote_id FROM ".TB_PREF."sales_orders 
             WHERE trans_type = ".ST_SALESORDER."
             AND dimension_id = ".db_escape($row["id"]);
    $quote_id = db_fetch(db_query($sql))['quote_id'];
    if($quote_id){
	    $sql = " SELECT * FROM ".TB_PREF."sales_orders 
         WHERE trans_type = ".ST_SALESQUOTE."
         AND order_no = ".db_escape($quote_id);
        $so_result = db_query($sql);
	    while($quote=db_fetch($so_result)){
	        $description .= print_document_link($quote['order_no'],  $quote['reference'], true, $quote['trans_type'], false)."&nbsp&nbsp&nbsp"; 
	    }
	    $description = rtrim($description, ",");
    }
 
 	if($description)
		return $description;
    
  
    return 'N/A';
}


function show_invoices($row){
    global $trans_type, $path_to_root;
    $sql = " SELECT * FROM ".TB_PREF."debtor_trans 
             WHERE type = ".ST_SALESINVOICE."
             AND ov_amount != 0 
             AND dimension_id = ".db_escape($row["id"]);
    $result = db_query($sql);
    $description = '';
    while($inv=db_fetch($result)){
         $description .= print_document_link($inv['trans_no']."-".$inv['type'], $inv['reference'], true, $inv['type'], false)."&nbsp&nbsp&nbsp";  
    }
 
    
    if(!$description)
        $description = 'N/A';
    
    return $description;
}

function profit_margin_less($row){
 		$incurred_cost = get_dimension_incurred_amount($row['id']);
		$bank_payment = get_dimension_gl_amount($row['id'], ST_BANKPAYMENT);
		$incurred_cost += $bank_payment;		
        
        $sales_invoicing = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_SALESINVOICE);
        $credit_amount = get_debtor_trans_sum_by_dimension_with_vat($row['id'], ST_CUSTCREDIT);
        $gross_sale_ex_vat = ($sales_invoicing-$credit_amount);
        
		$profit = (100 - (($incurred_cost/$gross_sale_ex_vat)*100));
		if($profit<50)
			return true;
		else 
			return false;
}


function comment($row){
	return pager_link(_("Notes to Opporunity"), $path_to_root.'/admin/followup.php?trans_no='.$row['id']."&type=40", ICON_COMMENT);
}

function last_comment($row){
	$sql = " SELECT comment FROM ".TB_PREF."followup  WHERE trans_no = ".db_escape($row['id'])." AND type = ".db_escape(ST_DIMENSION)." ORDER BY id DESC LIMIT 1 ";
	$last_comment = db_fetch(db_query($sql))['comment'];
	return $last_comment ? $last_comment : 'N/A';
}

$sql = get_sql_for_search_dimensions($dim, $_POST['FromDate'], $_POST['ToDate'],
	$_POST['OrderNumber'], $_POST['type_'], check_value('OpenOnly'), check_value('OverdueOnly'), $_POST['dimension_id']);

$cols = array(
	_("#") => array('fun'=>'view_link'), 
	_("Site Code"), 
	_("Site Name"), 
	_("Date") =>'date',
	_("Last Activity Date") => array('fun'=>'show_last_activity'), 
	_("Sales Order Amount") => array('fun'=>'show_sales_gross'),
	_("Sales (Net)") => array('fun'=>'show_sales_net'),
    _("Sales (Gross)") => array('insert'=>true, 'fun'=>'show_total_receivable'),
	_("Cost Incurred to date") => array('fun'=>'show_incurred_cost'),
	_("Cost to Revenue") => array('fun'=>'show_cost_reveneue'),
	_("Profit to Revenue") => array('fun'=>'show_profit_revenue'),
	_("Profit") => array('fun'=>'show_profit'),
	_("Advance Received") => array('fun'=>'show_advance_received'),
	_("Payment Status") => array('fun'=>'show_payment_status'),
    _("Quotations") => array('fun'=>'show_quotations'),
    _("Invoices") => array('fun'=>'show_invoices'),
    _('Last Comment') => array('fun'=>'last_comment','align'=>'center'),
    _('Notes') => array('fun'=>'comment','align'=>'center'),
	array('insert'=>true, 'fun'=>'edit_link'),
	array('insert'=>true, 'fun'=>'attach')

);

if ($outstanding_only) {
	$cols[_("Closed")] = 'skip';
}

$table =& new_db_pager('dim_tbl', $sql, $cols);
$table->set_marker('profit_margin_less', _("Red Highlited records have profit below 50%"), 'bg-red');
$table->set_marker_sec('partial_paid', _("Orange Highlighted records are Partialy Paid"), 'bg-orange');
$table->set_marker_trice('fully_paid', _("Green Highlighted records are Fully Paid"), 'bg-green');
$table->fixed_header = true;
$table->width = "80%";

display_db_pager($table);

end_form();
end_page();

if (get_post('FromDate')  || get_post('ToDate') || get_post('OrderNumber') || get_post('type_'))
{
	$Ajax->activate('_page_body');
}