<?php
$page_security = 'SS_TASK_DASHBOARD';
$path_to_root = "../";
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/includes/ui.inc");
include_once($path_to_root ."/includes/types.inc");
 

page(_($help_context = "Task Dashboard"));
// include($path_to_root . "/extra/task_Dashboard.html");
$user_id=$_SESSION["wa_current_user"]->user;
$access=$_SESSION["wa_current_user"]->access;
// display_error($user_id);
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
   
    <link rel="stylesheet" href="assets/extra-libs/taskboard/css/lobilist.css">
    <link rel="stylesheet" href="assets/extra-libs/taskboard/css/jquery-ui.min.css">
    <link rel="stylesheet" type="text/css" href=assets/libs/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <!-- Custom CSS -->
    <link href="dist/css/style.min.css" rel="stylesheet">

</head>

<body>
   <div id="outputt" style="background-color: red;"></div>
    <div id="main-wrapper">
        
        <div class="page-wrapper" style="width:100%;">
           
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card" style="width:100%; padding: 2%;">
                            <div class="card-body">
                                <h4 class="card-title">Basic Sample Taskboard</h4>
                                <div id="todo-lists-basic-demo"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card" style="width:100%; padding: 2%;">
                            <div class="card-body">
                                <h4 class="card-title">Custom Control Taskboard</h4>
                                <div id="todo-lists-demo-controls"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
          
        </div>
        
    </div>

    
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <script src="assets/libs/jquery/dist/jquery.min.js"></script>
    <script src="assets/extra-libs/taskboard/js/jquery.ui.touch-punch-improved.js"></script>
    <script src="assets/extra-libs/taskboard/js/jquery-ui.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="assets/libs/popper.js/dist/umd/popper.min.js"></script>
    <script src="assets/libs/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- apps -->
    <script src="dist/js/app.min.js"></script>
    <script src="dist/js/app.init.light-sidebar.js"></script>
    <script src="dist/js/app-style-switcher.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/libs/perfect-scrollbar/dist/perfect-scrollbar.jquery.min.js"></script>
    <!-- <script src="assets/extra-libs/sparkline/sparkline.js"></script> -->
    <!--Wave Effects -->
    <script src="dist/js/waves.js"></script>
    <!--Menu sidebar -->
    <!-- <script src="dist/js/sidebarmenu.js"></script> -->
    <!--Custom JavaScript -->
    <script src="dist/js/custom.min.js"></script>
    <!--This page JavaScript -->
    <!-- <script src="assets/extra-libs/taskboard/js/lobilist.js"></script> -->
<script type="text/javascript">
$(function() {

    var LIST_COUNTER = 0;
    /**
     * List class
     *
     * @class
     * @param {Object} $lobiList - jQuery element
     * @param {Object} options - Options for <code>List</code> 'class'
     * @constructor
     */
    var List = function($lobiList, options) {
        this.$lobiList = $lobiList;
        this.$options = options;
        this.$globalOptions = $lobiList.$options;
        this.$items = {};

        this._init();
    };

    List.prototype = {
        $lobiList: null,
        $el: null,
        $elWrapper: null,
        $options: {},
        $items: {},
        $globalOptions: {},
        $ul: null,
        $header: null,
        $title: null,
        $description: null,
        $dueDate: null,
        $form: null,
        $footer: null,
        $body: null,

        eventsSuppressed: false,

        _init: function() {
            var me = this;
            me.suppressEvents();
            if (!me.$options.id) {
                me.$options.id = 'lobilist-list-' + (LIST_COUNTER++);
            }
            var $wrapper = $('<div class="lobilist-wrapper"></div>');
            var $div = $('<div id="' + me.$options.id + '" class="lobilist"></div>').appendTo($wrapper);

            if (me.$options.defaultStyle) {
                $div.addClass(me.$options.defaultStyle);
            }
            me.$el = $div;
            me.$elWrapper = $wrapper;
            me.$header = me._createHeader();
            me.$title = me._createTitle();
            me.$body = me._createBody();
            me.$ul = me._createList();
            if (me.$options.items) {
                me._createItems(me.$options.items);
            }
            me.$form = me._createForm();
            me.$body.append(me.$ul, me.$form);
            me.$footer = me._createFooter();
            if (me.$globalOptions.sortable) {
                me._enableSorting();
            }
            me.resumeEvents();
        },
        
        addItem: function(item, errorCallback) {
            var me = this;
            if (me._triggerEvent('beforeItemAdd', [me, item]) === false) {
                return me;
            }

            item = me._processItemData(item);
            if (me.$globalOptions.actions.insert) {
                $.ajax(me.$globalOptions.actions.insert, {
                        data: item,
                        method: 'POST'


                    })

// $.ajax({
            
//             url     : "db/task_db.php",
//             type    : "POST",
//             async   : false,
//             data    :{
//                 Submit:'add_task',
//                 title : title,
//                 description:description,
//                 dueDate:dueDate,
//                 user_id:user_id,

//             },
//             success :function(result){
//                 if(result == 1)
//                 {
//                 alert('Success');
//                 }
//             }
//             });


                    //res is JSON object of format {"success": Boolean, "id": Number, "msg": String}
                    .done(function(res) {
                        if (res.success) {

                            item.id = res.id;
                            me._addItemToList(item);
                        } else {
                            if (errorCallback && typeof errorCallback === 'function') {
                                errorCallback(res)
                            }
                        }
                    });
            } else {
                item.id = me.$lobiList.getNextId();
                me._addItemToList(item);
            }

            return me;
        },

        updateItem: function(item, errorCallback) {
            var me = this;
            if (me._triggerEvent('beforeItemUpdate', [me, item]) === false) {
                return me
            }
            if (me.$globalOptions.actions.update) {
                $.ajax(me.$globalOptions.actions.update, {
                        data: item,
                        method: 'POST'
                    })
                    //res is JSON object of format {"id": Number, "success": Boolean, "msg": String}
                    .done(function(res) {
                        if (res.success) {
                            me._updateItemInList(item);
                        } else {
                            if (errorCallback && typeof errorCallback === 'function') {
                                errorCallback(res)
                            }
                        }
                    });
            } else {
                me._updateItemInList(item);
            }
            return me;
        },

        deleteItem: function(item, errorCallback) {
            var me = this;
            if (me._triggerEvent('beforeItemDelete', [me, item]) === false) {
                return me
            }
            if (me.$globalOptions.actions.delete) {
                return me._sendAjax(me.$globalOptions.actions.delete, {
                        data: item,
                        method: 'POST'
                    })
                    //res is JSON object of format
                    .done(function(res) {
                        if (res.success) {
                            me._removeItemFromList(item);
                        } else {
                            if (errorCallback && typeof errorCallback === 'function') {
                                errorCallback(res)
                            }
                        }
                    });
            } else {
                me._removeItemFromList(item);
            }
            return me;
        },

        saveOrUpdateItem: function(item, errorCallback) {
            var me = this;
            if (item.id) {
                me.updateItem(item, errorCallback);
            } else {
                me.addItem(item, errorCallback);
            }
            return me;
        },

        startTitleEditing: function() {
            var me = this;
            var input = me._createInput();
            me.$title.attr('data-old-title', me.$title.html());
            input.val(me.$title.html());
            input.insertAfter(me.$title);
            me.$title.addClass('hide');
            me.$header.addClass('title-editing');
            input[0].focus();
            input[0].select();
            return me;
        },

        finishTitleEditing: function() {
            var me = this;
            var $input = me.$header.find('input');
            var oldTitle = me.$title.attr('data-old-title');
            me.$title.html($input.val()).removeClass('hide').removeAttr('data-old-title');
            $input.remove();
            me.$header.removeClass('title-editing');
            console.log(oldTitle, $input.val());
            me._triggerEvent('titleChange', [me, oldTitle, $input.val()]);
            return me;
        },

        cancelTitleEditing: function() {
            var me = this;
            var $input = me.$header.find('input');
            if ($input.length === 0) {
                return me;
            }
            me.$title.html(me.$title.attr('data-old-title')).removeClass('hide');
            $input.remove();
            me.$header.removeClass('title-editing');
            return me;
        },

        remove: function() {
            var me = this;
            me.$lobiList.$lists.splice(me.$el.index(), 1);
            me.$elWrapper.remove();

            return me;
        },

        editItem: function(id) {
            var me = this;
            var $item = me.$lobiList.$el.find('li[data-id=' + id + ']');
            var $form = $item.closest('.lobilist').find('.lobilist-add-todo-form');
            var $footer = $item.closest('.lobilist').find('.lobilist-footer');

            $form.removeClass('hide');
            $footer.addClass('hide');
            $form[0].id.value = $item.attr('data-id');
            $form[0].title.value = $item.find('.lobilist-item-title').html();
            $form[0].description.value = $item.find('.lobilist-item-description').html() || '';
            $form[0].dueDate.value = $item.find('.lobilist-item-duedate').html() || '';
            return me;
        },

       
        suppressEvents: function() {
            this.eventsSuppressed = true;
            return this;
        },

       
        resumeEvents: function() {
            this.eventsSuppressed = false;
            return this;
        },

        _processItemData: function(item) {
            var me = this;
            return $.extend({}, me.$globalOptions.itemOptions, item);
        },

        _createHeader: function() {
            var me = this;
            var $header = $('<div>', {
                'class': 'lobilist-header'
            });
            var $actions = $('<div>', {
                'class': 'lobilist-actions'
            }).appendTo($header);
            if (me.$options.controls && me.$options.controls.length > 0) {
                if (me.$options.controls.indexOf('styleChange') > -1) {
                    $actions.append(me._createDropdownForStyleChange());
                }

                if (me.$options.controls.indexOf('edit') > -1) {
                    $actions.append(me._createEditTitleButton());
                    $actions.append(me._createFinishTitleEditing());
                    $actions.append(me._createCancelTitleEditing());
                }
                if (me.$options.controls.indexOf('add') > -1) {
                    $actions.append(me._createAddNewButton());
                }
                if (me.$options.controls.indexOf('remove') > -1) {
                    $actions.append(me._createCloseButton());
                }
            }
            me.$el.append($header);
            return $header;
        },

        _createTitle: function() {
            var me = this;
            var $title = $('<div>', {
                'class': 'lobilist-title',
                'id': 'header_title',
                html: me.$options.title
            }).appendTo(me.$header);
            if (me.$options.controls && me.$options.controls.indexOf('edit') > -1) {
                $title.on('dblclick', function() {
                    me.startTitleEditing();
                });
            }
            return $title;
        },

        _createBody: function() {
            var me = this;
            return $('<div>', {
                'class': 'lobilist-body'
            }).appendTo(me.$el);

        },

        _createForm: function() {
            var me = this;
            var $form = $('<form>', {
                'class': 'lobilist-add-todo-form hide'
            });
            $('<input type="hidden" name="id" autocomplete="off">').appendTo($form);
            $('<div class="form-group">').append(
                $('<input>', {
                    'type': 'text',
                    name: 'title',
                    'class': 'form-control',
                    'id': 'title',
                    placeholder: 'TODO title'
                })
            ).appendTo($form);
            $('<div class="form-group">').append(
                $('<textarea>', {
                    rows: '2',
                    name: 'description',
                    'id': 'description',
                    'class': 'form-control',
                    'placeholder': 'TODO description'
                })
            ).appendTo($form);
            $('<div class="form-group">').append(
                $('<input>', {
                    'type': 'text',
                    name: 'dueDate',
                    'id': 'dueDate',
                    'class': 'datepicker form-control',
                    placeholder: 'Due Date',
                })
            ).appendTo($form);
            var $ft = $('<div class="lobilist-form-footer">');
            $('<button>', {
                'class': 'btn btn-primary btn-sm btn-add-todo',
                'id': 'insert',
                html: 'Add/Update'
            }).appendTo($ft);
            $('<button>', {
                type: 'button',
                'class': 'btn btn-danger btn-sm btn-discard-todo',
                'id': 'cancel',
                html: 'Cancel'
            }).click(function() {
                $form.addClass('hide');
                me.$footer.removeClass('hide');
            }).appendTo($ft);
            $ft.appendTo($form);

            me._formHandler($form);

            me.$el.append($form);
            return $form;
        },

        _formHandler: function($form) {
            var me = this;
            $form.on('submit', function(ev) {
                ev.preventDefault();
                me._submitForm();
            });
        },

        _submitForm: function() {
            var me = this;
            var user_id = <?php echo json_encode($user_id) ?>;
            var title = this.$form[0].title.value;
            var description = this.$form[0].description.value;
            var dueDate = this.$form[0].dueDate.value;
            var header_title = $( "#header_title" ).text()


            // window.alert(title+description+dueDate);
            if (!me.$form[0].title.value) {
                me._showFormError('title', 'Title can not be empty');
                return;
            }

            $.ajax({
            
            url     : "db/task_db.php",
            type    : "POST",
            async   : false,
            data    :{
                Submit:'add_task',
                title : title,
                description:description,
                dueDate:dueDate,
                user_id:user_id,

            },
            success :function(result){

				// $("#p_tag").html(result);
    //     		$('#about')[0].click();


                if(result == 1)
                {

                // alert('Success');
                 $("#p_tag").html('Success Inserted');
        		$('#about')[0].click();
        		// location.reload();

                }
                if(result == 2)
                {

                // alert('Success');
                 $("#p_tag").html(header_title);
        		$('#about')[0].click() 
        		// location.reload();

                // me._resetForm();
                // me.$form.removeClass('hide');
                // $footer.addClass('hide');
            

                }
        		
            }
            });


            me.saveOrUpdateItem({
                id: me.$form[0].id.value,
                title: me.$form[0].title.value,
                description: me.$form[0].description.value,
                dueDate: me.$form[0].dueDate.value
            });
            me.$form.addClass('hide');
            me.$footer.removeClass('hide');
        },

        _createFooter: function() {
            var me = this;
            var $footer = $('<div>', {
                'class': 'lobilist-footer'
            });
            $('<button>', {
                type: 'button',
                'class': 'btn-link btn-show-form',
                'html': 'Add new'
            }).click(function() {
                me._resetForm();
                me.$form.removeClass('hide');
                $footer.addClass('hide');
            }).appendTo($footer);
            me.$el.append($footer);
            return $footer;
        },

        _createList: function() {
            var me = this;
            var $list = $('<ul>', {
                'class': 'lobilist-items'
            });
            me.$el.append($list);
            return $list;
        },

        _createItems: function(items) {
            var me = this;
            for (var i = 0; i < items.length; i++) {
                me._addItem(items[i]);
            }
        },

        /**
         * This method is called when plugin is initialized
         * and initial items are added to the list
         *
         * @type Object
         */
        _addItem: function(item) {
            var me = this;
            if (!item.id) {
                item.id = me.$lobiList.getNextId();
            }
            if (me._triggerEvent('beforeItemAdd', [me, item]) !== false) {
                item = me._processItemData(item);
                me._addItemToList(item);
            }
        },

        _createCheckbox: function() {
            var me = this;
            var $item = $('<input>', {
                'type': 'checkbox'
            });

            $item.change(function() {
                me._onCheckboxChange(this);
            });
            return $('<label>', {
                'class': 'checkbox-inline lobilist-check'
            }).append($item);
        },

        _onCheckboxChange: function(checkbox) {
            var me = this;
            var $this = $(checkbox);
            if ($this.prop('checked')) {
                me._triggerEvent('afterMarkAsDone', [me, $this])
            } else {
                me._triggerEvent('afterMarkAsUndone', [me, $this])
            }

            $this.closest('.lobilist-item').toggleClass('item-done');
        },

        _createDropdownForStyleChange: function() {
            var me = this;
            var $dropdown = $('<div>', {
                'class': 'dropdown'
            }).append(
                $('<button>', {
                    'type': 'button',
                    'data-toggle': 'dropdown',
                    'class': 'btn btn-xs',
                    'html': '<i class="ti-view-grid"></i>'
                })
            );
            var $menu = $('<div>', {
                'class': 'dropdown-menu dropdown-menu-right'
            }).appendTo($dropdown);

            for (var i = 0; i < me.$globalOptions.listStyles.length; i++) {
                var st = me.$globalOptions.listStyles[i];
                $('<div class="' + st + '"></div>')
                    .on('mousedown', function(ev) {
                        ev.stopPropagation()
                    })
                    .click(function() {
                        var classes = me.$el[0].className.split(' ');
                        var oldClass = null;
                        for (var i = 0; i < classes.length; i++) {
                            if (me.$globalOptions.listStyles.indexOf(classes[i]) > -1) {
                                oldClass = classes[i];
                            }
                        }
                        me.$el.removeClass(me.$globalOptions.listStyles.join(" "))
                            .addClass(this.className);

                        me._triggerEvent('styleChange', [me, oldClass, this.className]);

                    })
                    .appendTo($menu);
            }
            return $dropdown;
        },

        _createEditTitleButton: function() {
            var me = this;
            var $btn = $('<button>', {
                'class': 'btn btn-xs',
                html: '<i class="ti-pencil"></i>'
            });
            $btn.click(function() {
                me.startTitleEditing();
            });

            return $btn;
        },

        _createAddNewButton: function() {
            var me = this;
            var $btn = $('<button>', {
                'class': 'btn btn-xs',
                html: '<i class="ti-plus"></i>'
            });
            $btn.click(function() {
                var list = me.$lobiList.addList();
                list.startTitleEditing();
            });
            return $btn;
        },

        _createCloseButton: function() {
            var me = this;
            var $btn = $('<button>', {
                'class': 'btn btn-xs',
                html: '<i class="ti-trash"></i>'
            });
            $btn.click(me._onRemoveListClick);
            return $btn;
        },

        _onRemoveListClick: function() {
            var me = this;
            me._triggerEvent('beforeListRemove', [me]);
            me.remove();
            me._triggerEvent('afterListRemove', [me]);
            return me;
        },

        _createFinishTitleEditing: function() {
            var me = this;
            var $btn = $('<button>', {
                'class': 'btn btn-xs btn-finish-title-editing',
                html: '<i class="ti-check-box"></i>'
            });
            $btn.click(function() {
                me.finishTitleEditing();
            });
            return $btn;
        },

        _createCancelTitleEditing: function() {
            var me = this;
            var $btn = $('<button>', {
                'class': 'btn btn-xs btn-cancel-title-editing',
                html: '<i class="ti-close"></i>'
            });
            $btn.click(function() {
                me.cancelTitleEditing();
            });
            return $btn;
        },

        _createInput: function() {
            var me = this;
            var input = $('<input type="text" class="form-control">');
            input.on('keyup', function(ev) {
                if (ev.which === 13) {
                    me.finishTitleEditing();
                }
            });
            return input;
        },

        _showFormError: function(field, error) {
            var $fGroup = this.$form.find('[name="' + field + '"]').closest('.form-group')
                .addClass('has-error');
            $fGroup.find('.help-block').remove();
            $fGroup.append(
                $('<span class="help-block">' + error + '</span>')
            );
        },

        _resetForm: function() {
            var me = this;
            me.$form[0].reset();
            me.$form[0].id.value = "";
            me.$form.find('.form-group').removeClass('has-error').find('.help-block').remove();
        },

        _enableSorting: function() {
            var me = this;
            me.$el.find('.lobilist-items').sortable({
                connectWith: '.lobilist .lobilist-items',
                items: '.lobilist-item',
                handle: '.drag-handler',
                cursor: 'move',
                placeholder: 'lobilist-item-placeholder',
                forcePlaceholderSize: true,
                opacity: 0.9,
                revert: 70,
                update: function(event, ui) {
                    me._triggerEvent('afterItemReorder', [me, ui.item]);
                }
            });
        },




 // ------------------------------------------  ADDING DATA -------------------------------------------------------------------------

 //   $.ajax({
            
 //            url     : "db/task_db2.php",
 //            type    : "POST",
 //            async   : false,
 //            data    :{
 //                Select:'select_task',
 //                user_id:user_id,

 //            },
 //            success :function(result){
 //            	// if(result == 1)
 //            	// {
 //                // alert(result);
 // $("#p_tag").html('Success Fetch'+result);
 //        $('#about')[0].click();

 //        		// $('#todo-lists-basic-demo').innerHTML(result);
 //        		// $(result).appendTo("#todo-lists-basic-demo");

 //            	// }
 //            }
 //            });


_addItemToList: function(item) {
	// var item = '';
var user_id = <?php echo json_encode($user_id) ?>;
$(function () 
  {

$.ajax({                                      
  url: "db/task_db3.php",
  data    :{Select:'select_task', user_id:user_id, },                        //you can insert url argumnets here to    pass to api.php
  type    : "POST",
  dataType: 'json',                //data format      
                                   //for example "id=5&parent=6"
  success: function(item)          //on recieve of reply
  {

var arrr = JSON.stringify(item);
arrr = $.parseJSON(arrr);
// $('#divID').load('task_dashboard.php');
// if( item != '')
// {
//   	location.reload();
// // window.load();
// }

$.each(arrr, function(i, item) {
    // alert(item.description);
// $("#p_tag").html(item.title);
//         $('#about')[0].click();


$($li).append($('<div>', {
                'id': 'item_title',
                'class': 'lobilist-item-title',
                'html': item.title+''
            }));
        $($li).append($('<div>', {
             	'id': 'item_description',
                'class': 'lobilist-item-description',
                'html': item.description+''
            }));
        $($li).append($('<div>', {
               'id': 'item_duedate',
               'class': 'lobilist-item-duedate',
                'html': item.dueDate+''
            }));


});
  } 
});
 });
            var me = this;
            var $li = $('<li>', {
                'data-id': item.id,
                'class': 'lobilist-item'
            });
            // $li.append($('<div>', {
            //     'id': 'item_title',
            //     'class': 'lobilist-item-title',
            //     'html': item.title
            // }));
            // if (item.description) {
            //     $li.append($('<div>', {
            //     'id': 'item_description',
            //         'class': 'lobilist-item-description',
            //         html: item.description
            //     }));
            // }
            // if (item.dueDate) {
            //     $li.append($('<div>', {
            //     'id': 'item_duedate',
            //         'class': 'lobilist-item-duedate',
            //         html: item.dueDate
            //     }));
            // }
            $li = me._addItemControls($li);
            if (item.done) {
                $li.find('input[type=checkbox]').prop('checked', true);
                $li.addClass('item-done');
            }
            $li.data('lobiListItem', item);
            me.$ul.append($li);
            me.$items[item.id] = item;
            me._triggerEvent('afterItemAdd', [me, item]);

            return $li;
        },
 // ------------------------------------------  ADDING DATA -------------------------------------------------------------------------





        _addItemControls: function($li) {
            var me = this;
            // if (me.$options.useCheckboxes) {
            //     $li.append(me._createCheckbox());
            // }
            var $itemControlsDiv = $('<div>', {
                'class': 'todo-actions'
            }).appendTo($li);

            // if (me.$options.enableTodoEdit) {
            //     $itemControlsDiv.append($('<div>', {
            //         'class': 'edit-todo todo-action',
            //         html: '<i class="ti-pencil"></i>'
            //     }).click(function() {

            //         me.editItem($(this).closest('li').data('id'));
            //     }));
            // }

            if (me.$options.enableTodoRemove) {
                $itemControlsDiv.append($('<div>', {
                    'class': 'delete-todo todo-action',
                    html: '<i class="ti-close"></i>'
                }).click(function() {
                    me._onDeleteItemClick($(this).closest('li').data('lobiListItem'));
                }));
            }

            $li.append($('<div>', {
                'class': 'drag-handler'
            }));
            return $li;
        },

        _onDeleteItemClick: function(item) {
            this.deleteItem(item);
        },

        _updateItemInList: function(item) {
            var me = this;
            var $li = me.$lobiList.$el.find('li[data-id="' + item.id + '"]');
            $li.find('input[type=checkbox]').prop('checked', item.done);
            $li.find('.lobilist-item-title').html(item.title);
            $li.find('.lobilist-item-description').remove();
            $li.find('.lobilist-item-duedate').remove();

            if (item.description) {
                $li.append('<div class="lobilist-item-description">' + item.description + '</div>');
            }
            if (item.dueDate) {
                $li.append('<div class="lobilist-item-duedate">' + item.dueDate + '</div>');
            }
            $li.data('lobiListItem', item);
            $.extend(me.$items[item.id], item);
            me._triggerEvent('afterItemUpdate', [me, item]);
        },

        _triggerEvent: function(type, data) {
            var me = this;
            if (me.eventsSuppressed) {
                return;
            }
            if (me.$options[type] && typeof me.$options[type] === 'function') {
                return me.$options[type].apply(me, data);
            } else {
                return me.$el.trigger(type, data);
            }
        },

        _removeItemFromList: function(item) {
            var me = this;
            me.$lobiList.$el.find('li[data-id=' + item.id + ']').remove();
            me._triggerEvent('afterItemDelete', [me, item]);
        },

        _sendAjax: function(url, params) {
            var me = this;
            return $.ajax(url, me._beforeAjaxSent(params))
        },

        _beforeAjaxSent: function(params) {
            var me = this;
            var eventParams = me._triggerEvent('beforeAjaxSent', [me, params]);
            return $.extend({}, params, eventParams || {});
        }
    };
 
    var LobiList = function($el, options) {
        this.$el = $el;
        this.init(options);
    };

    LobiList.prototype = {
        $el: null,
        $lists: [],
        $options: {},
        _nextId: 1,

        eventsSuppressed: false,

        init: function(options) {
            var me = this;
            me.suppressEvents();

            me.$options = this._processInput(options);
            me.$el.addClass('lobilists');
            if (me.$options.onSingleLine) {
                me.$el.addClass('single-line');
            }

            me._createLists();
            me._handleSortable();
            me._triggerEvent('init', [me]);
            me.resumeEvents();
        },

       
        _processInput: function(options) {
            options = $.extend({}, $.fn.lobiList.DEFAULT_OPTIONS, options);
            if (options.actions.load) {
                $.ajax(options.actions.load, {
                    async: false
                }).done(function(res) {
                    options.lists = res.lists;
                });
            }
            return options;
        },

        _createLists: function() {
            var me = this;
            for (var i = 0; i < me.$options.lists.length; i++) {
                me.addList(me.$options.lists[i]);
            }
            return me;
        },

        _handleSortable: function() {
            var me = this;
            if (me.$options.sortable) {
                me.$el.sortable({
                    items: '.lobilist-wrapper',
                    handle: '.lobilist-header',
                    cursor: 'move',
                    placeholder: 'lobilist-placeholder',
                    forcePlaceholderSize: true,
                    opacity: 0.9,
                    revert: 70,
                    update: function(event, ui) {
                        me._triggerEvent('afterListReorder', [me, ui.item.find('.lobilist').data('lobiList')]);
                    }
                });
            } else {
                me.$el.addClass('no-sortable');
            }
            return me;
        },

     
        addList: function(list) {
            var me = this;
            if (!(list instanceof List)) {
                list = new List(me, me._processListOptions(list));
            }
            if (me._triggerEvent('beforeListAdd', [me, list]) !== false) {
                me.$lists.push(list);
                me.$el.append(list.$elWrapper);
                list.$el.data('lobiList', list);
                me._triggerEvent('afterListAdd', [me, list]);
            }
            return list;
        },

     
        destroy: function() {
            var me = this;
            if (me._triggerEvent('beforeDestroy', [me]) !== false) {
                for (var i = 0; i < me.$lists.length; i++) {
                    me.$lists[i].remove();
                }
                if (me.$options.sortable) {
                    me.$el.sortable("destroy");
                }
                me.$el.removeClass('lobilists');
                if (me.$options.onSingleLine) {
                    me.$el.removeClass('single-line');
                }
                me.$el.removeData('lobiList');
                me._triggerEvent('afterDestroy', [me]);
            }

            return me;
        },

      
        getNextId: function() {
            return this._nextId++;
        },

        _processListOptions: function(listOptions) {
            var me = this;
            listOptions = $.extend({}, me.$options.listsOptions, listOptions);

            for (var i in me.$options) {
                if (me.$options.hasOwnProperty(i) && listOptions[i] === undefined) {
                    listOptions[i] = me.$options[i];
                }
            }
            return listOptions;
        },

        suppressEvents: function() {
            this.eventsSuppressed = true;
            return this;
        },

        resumeEvents: function() {
            this.eventsSuppressed = false;
            return this;
        },

        _triggerEvent: function(type, data) {
            var me = this;
            if (me.eventsSuppressed) {
                return;
            }
            if (me.$options[type] && typeof me.$options[type] === 'function') {
                return me.$options[type].apply(me, data);
            } else {
                return me.$el.trigger(type, data);
            }
        }
    };

    $.fn.lobiList = function(option) {
        var args = arguments;
        var ret;
        return this.each(function() {
            var $this = $(this);
            var data = $this.data('lobiList');
            var options = typeof option === 'object' && option;

            if (!data) {
                $this.data('lobiList', (data = new LobiList($this, options)));
            }
            if (typeof option === 'string') {
                args = Array.prototype.slice.call(args, 1);
                ret = data[option].apply(data, args);
            }
        });
    };
    $.fn.lobiList.DEFAULT_OPTIONS = {
        // Available style for lists
        'listStyles': ['lobilist-default', 'lobilist-danger', 'lobilist-success', 'lobilist-warning', 'lobilist-info', 'lobilist-primary'],
        // Default options for all lists
        listsOptions: {
            id: false,
            title: '',
            items: []
        },
        // Default options for all todo items
        itemOptions: {
            id: false,
            title: '',
            description: '',
            dueDate: '',
            done: false
        },

        lists: [],
        // Urls to communicate to backend for todos
        actions: {
            'load': '',
            'update': '',
            'insert': '',
            'delete': ''
        },
        // Whether to show checkboxes or not
        useCheckboxes: true,
        // Show/hide todo remove button
        enableTodoRemove: true,
        // Show/hide todo edit button
        enableTodoEdit: true,
        // Whether to make lists and todos sortable
        sortable: true,
        // Default action buttons for all lists
        controls: ['edit', 'add', 'remove', 'styleChange'],
        //List style
        defaultStyle: 'lobilist-default',
        // Whether to show lists on single line or not
        onSingleLine: true,

       
        init: null,

        beforeDestroy: null,
               
        afterDestroy: null,
    
        beforeListAdd: null,
      
        afterListAdd: null,
       
        beforeListRemove: null,

        afterListRemove: null,

        beforeItemAdd: null,

        afterItemAdd: null,

        beforeItemUpdate: null,

        afterItemUpdate: null,
        
        beforeItemDelete: null,
        
        afterItemDelete: null,

        afterListReorder: null,

        afterItemReorder: null,
        
        afterMarkAsDone: null,

        afterMarkAsUndone: null,

        beforeAjaxSent: null,
        
        styleChange: null,

        titleChange: null
    };
});
 $(function(){
        $('#insert').click(function(){
        var title = $('#title').val();
        var description = $('#description').val();
        var dueDate = $('#dueDate').val();
   

        window.alert(title);
        
    });
    });

</script>
<script>
function refreshPage(){
    window.location.reload();
} 
</script>

<a id="about" type="button" class="btn btn-info btn-lg" style="display:none;" data-toggle="modal" data-target="#myModal">Open Modal</a>
     <div id="myModal" class="modal fade" role="dialog">
                                   <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content">
                              <div class="modal-header"  style=" background: #2cabe3;"  >
                                <a type="button" class="close" data-dismiss="modal">&times;</a>
                                <h4 class="modal-title">Errors</h4>
                              </div>
                              <div class="modal-body">
                                <p id="p_tag"  style="    color: red;">Some text in the modal.</p>
                              </div>
                              <div class="modal-footer"  style=" background: #2cabe3;" >
                                <a type="button" onClick="refreshPage()" class="btn btn-default" data-dismiss="modal" id "modal_close">Close</a>
                              </div>
                            </div>

                          </div>
                        </div>

    <script src="assets/extra-libs/taskboard/js/lobibox.min.js"></script>


    <!-- <script src="assets/extra-libs/taskboard/js/task-init.js"></script> -->

<!-- _____________________ DATA FETCH __________________________________________________________________________________________-->
    <script type="text/javascript">
   


    	$(function() {
    /**
     * Created by Zura on 4/5/2016.
     */
    $(function() {
        Lobibox.notify.DEFAULTS = $.extend({}, Lobibox.notify.DEFAULTS, {
            size: 'mini',
            // delay: false,
            position: 'right top'
        });

                 var user_id = <?php echo json_encode($user_id) ?>;
            // var title = this.$form[0].title.value;
            // var description = this.$form[0].description.value;
            // var dueDate = this.$form[0].dueDate.value;
 //            $.ajax({
            
 //            url     : "db/task_db2.php",
 //            type    : "POST",
 //            async   : false,
 //            data    :{
 //                Select:'select_task',
 //                user_id:user_id,

 //            },
 //            success :function(result){
 //            	// if(result == 1)
 //            	// {
 //                // alert(result);
 // $("#p_tag").html('Success Fetch'+result);
 //        $('#about')[0].click();

 //        		// $('#todo-lists-basic-demo').innerHTML(result);
 //        		// $(result).appendTo("#todo-lists-basic-demo");

 //            	// }
 //            }
 //            });

        // //Basic example
        		// $('#todo-lists-basic-demo').innerHTML(result);

        $('#todo-lists-basic-demo').lobiList({


            lists: [
            {
                    id: 'todo',
                    title: 'Todo',
                    defaultStyle: 'lobilist-danger',
                    items: [



                    	{
                            title: '',
                            description: '',
                            dueDate: ''
                        }
                        // ,
                        // {
                        //     title: 'Periods pride',
                        //     description: 'Accepted was mollis',
                        //     done: true
                        // },
                        // {
                        //     title: 'Flags better burns pigeon',
                        //     description: 'Rowed cloven frolic thereby, vivamus pining gown intruding strangers prank treacherously darkling.'
                        // },
                        // {
                        //     title: 'Accepted was mollis',
                        //     description: 'Rowed cloven frolic thereby, vivamus pining gown intruding strangers prank treacherously darkling.',
                        //     dueDate: '2015-02-02'
                        // }
                    ]
                },
                {
                    id: 'doing',
                    title: 'Doing',
                    defaultStyle: 'lobilist-primary',
                    items: [{
                            title: 'Composed trays',
                            description: 'Hoary rattle exulting suspendisse elit paradises craft wistful. Bayonets allures prefer traits wrongs flushed. Tent wily matched bold polite slab coinage celerities gales beams.'
                        },
                        {
                            title: 'Chic leafy'
                        },
                        {
                            title: 'Guessed interdum armies chirp writhes most',
                            description: 'Came champlain live leopards twilight whenever warm read wish squirrel rock.',
                            dueDate: '2015-02-04',
                            done: true
                        }
                    ]
                },
                {
                    id: 'Done',
                    title: 'Done',
                    defaultStyle: 'lobilist-success',
                    items: [{
                            title: 'Composed trays',
                            description: 'Hoary rattle exulting suspendisse elit paradises craft wistful. Bayonets allures prefer traits wrongs flushed. Tent wily matched bold polite slab coinage celerities gales beams.'
                        },
                        {
                            title: 'Chic leafy'
                        },
                        {
                            title: 'Guessed interdum armies chirp writhes most',
                            description: 'Came champlain live leopards twilight whenever warm read wish squirrel rock.',
                            dueDate: '2015-02-04',
                            done: true
                        }
                    ]
                }
            ]



        });
        //Custom datepicker
        $('#todo-lists-demo-datepicker').lobiList({
            lists: [{
                title: 'Todo',
                defaultStyle: 'lobilist-info',
                items: [{
                    title: 'Floor cool cinders',
                    description: 'Thunder fulfilled travellers folly, wading, lake.',
                    dueDate: '2015-01-31'
                }]
            }],
            afterListAdd: function(lobilist, list) {
                var $dueDateInput = list.$el.find('form [name=dueDate]');
                $dueDateInput.datepicker();
            }
        });
        // Event handling
        (function() {
            var list;

            $('#todo-lists-initialize-btn').click(function() {
                list = $('#todo-lists-demo-events')
                    .lobiList({
                        init: function() {
                            Lobibox.notify('default', {
                                msg: 'init'
                            });
                        },
                        beforeDestroy: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeDestroy'
                            });
                        },
                        afterDestroy: function() {
                            Lobibox.notify('default', {
                                msg: 'afterDestroy'
                            });
                        },
                        beforeListAdd: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeListAdd'
                            });
                        },
                        afterListAdd: function() {
                            Lobibox.notify('default', {
                                msg: 'afterListAdd'
                            });
                        },
                        beforeListRemove: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeListRemove'
                            });
                        },
                        afterListRemove: function() {
                            Lobibox.notify('default', {
                                msg: 'afterListRemove'
                            });
                        },
                        beforeItemAdd: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeItemAdd'
                            });
                        },
                        afterItemAdd: function() {
                            console.log(arguments);
                            Lobibox.notify('default', {
                                msg: 'afterItemAdd'
                            });
                        },
                        beforeItemUpdate: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeItemUpdate'
                            });
                        },
                        afterItemUpdate: function() {
                            console.log(arguments);
                            Lobibox.notify('default', {
                                msg: 'afterItemUpdate'
                            });
                        },
                        beforeItemDelete: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeItemDelete'
                            });
                        },
                        afterItemDelete: function() {
                            Lobibox.notify('default', {
                                msg: 'afterItemDelete'
                            });
                        },
                        beforeListDrop: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeListDrop'
                            });
                        },
                        afterListReorder: function() {
                            Lobibox.notify('default', {
                                msg: 'afterListReorder'
                            });
                        },
                        beforeItemDrop: function() {
                            Lobibox.notify('default', {
                                msg: 'beforeItemDrop'
                            });
                        },
                        afterItemReorder: function() {
                            Lobibox.notify('default', {
                                msg: 'afterItemReorder'
                            });
                        },
                        afterMarkAsDone: function() {
                            Lobibox.notify('default', {
                                msg: 'afterMarkAsDone'
                            });
                        },
                        afterMarkAsUndone: function() {
                            Lobibox.notify('default', {
                                msg: 'afterMarkAsUndone'
                            });
                        },
                        styleChange: function(list, oldStyle, newStyle) {
                            console.log(arguments);
                            Lobibox.notify('default', {
                                msg: 'styleChange: Old style - "' + oldStyle + '". New style - "' + newStyle + '"'
                            });
                        },
                        titleChange: function(list, oldTitle, newTitle) {
                            console.log(arguments);
                            Lobibox.notify('default', {
                                msg: 'titleChange: Old title - "' + oldTitle + '". New title - "' + newTitle + '"'
                            });
                        },
                        lists: [{
                            title: 'Todo',
                            defaultStyle: 'lobilist-info',
                            items: [{
                                    title: 'Floor cool cinders',
                                    description: 'Thunder fulfilled travellers folly, wading, lake.',
                                    dueDate: '2015-01-31'
                                },
                                {
                                    title: 'Periods pride',
                                    description: 'Accepted was mollis',
                                    done: true
                                },
                                {
                                    title: 'Flags better burns pigeon',
                                    description: 'Rowed cloven frolic thereby, vivamus pining gown intruding strangers prank ' +
                                        'treacherously darkling.'
                                },
                                {
                                    title: 'Accepted was mollis',
                                    description: 'Rowed cloven frolic thereby, vivamus pining gown intruding strangers prank ' +
                                        'treacherously darkling.',
                                    dueDate: '2015-02-02'
                                }
                            ]
                        }]
                    })
                    .data('lobiList');
            });

            $('#todo-lists-destroy-btn').click(function() {
                list.destroy();
            });
        })();
        // Custom controls
        $('#todo-lists-demo-controls').lobiList({
            lists: [{
                    title: 'Todo',
                    defaultStyle: 'lobilist-info',
                    controls: ['edit', 'styleChange'],
                    items: [{
                        title: 'Floor cool cinders',
                        description: 'Thunder fulfilled travellers folly, wading, lake.',
                        dueDate: '2015-01-31'
                    }]
                },
                {
                    title: 'Disabled checkboxes',
                    defaultStyle: 'lobilist-danger',
                    controls: ['edit', 'add', 'remove'],
                    useLobicheck: false,
                    items: [{
                        title: 'Periods pride',
                        description: 'Accepted was mollis',
                        done: true
                    }]
                },
                {
                    title: 'Controls disabled',
                    controls: false,
                    items: [{
                        title: 'Composed trays',
                        description: 'Hoary rattle exulting suspendisse elit paradises craft wistful. ' +
                            'Bayonets allures prefer traits wrongs flushed. Tent wily matched bold polite slab coinage ' +
                            'celerities gales beams.'
                    }]
                },
                {
                    title: 'No edit/remove',
                    enableTodoRemove: false,
                    enableTodoEdit: false,
                    items: [{
                        title: 'Composed trays',
                        description: 'Hoary rattle exulting suspendisse elit paradises craft wistful. ' +
                            'Bayonets allures prefer traits wrongs flushed. Tent wily matched bold polite slab coinage ' +
                            'celerities gales beams.'
                    }]
                }
            ]
        });
        // Disabled drag & drop
        $('#todo-lists-demo-sorting').lobiList({
            sortable: false,
            lists: [{
                    title: 'Todo',
                    defaultStyle: 'lobilist-info',
                    controls: ['edit', 'styleChange'],
                    items: [{
                        title: 'Floor cool cinders',
                        description: 'Thunder fulfilled travellers folly, wading, lake.',
                        dueDate: '2015-01-31'
                    }]
                },
                {
                    title: 'Controls disabled',
                    controls: false,
                    items: [{
                        title: 'Composed trays',
                        description: 'Hoary rattle exulting suspendisse elit paradises craft wistful. Bayonets allures prefer traits wrongs flushed. Tent wily matched bold polite slab coinage celerities gales beams.'
                    }]
                }
            ]
        });

        $('#actions-by-ajax').lobiList({
            actions: {
                load: '../example1/load.json',
                insert: '../example1/insert.php',
                delete: '../example1/delete.php',
                update: '../example1/update.php'
            },
            afterItemAdd: function() {
                console.log(arguments);
            }
        });

        $('.datepicker').datepicker({
            autoclose: true,
            todayHighlight: true
        });
        $('.lobilist').perfectScrollbar();
    });
});

    </script>
</body>
</html>
<?php
end_form();
?>