<?php

$path_to_root = "..";
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
add_access_extensions();

$page_security = isset($_GET['NewPayment']) || 
	@($_SESSION['pay_items']->trans_type==ST_BANKPAYMENT)
 ? 'SA_PAYMENT' : 'SA_DEPOSIT';

set_page_security( @$_SESSION['pay_items']->trans_type,
	array(	ST_BANKPAYMENT  =>'SA_PAYMENT',
			ST_BANKDEPOSIT  => 'SA_DEPOSIT'),
	array(	'NewPayment' => 'SA_PAYMENT',
			'ModifyPayment' => 'SA_MODIFYPAYMENT',
			'AddedID' => 'SA_PAYMENT',
			'UpdatedID' => 'SA_MODIFYPAYMENT',
			'NewDeposit' => 'SA_DEPOSIT',
			'ModifyDeposit' => 'SA_MODIFYDEPOSIT',
			'AddedDep'      => 'SA_DEPOSIT',
			'UpdatedDep'      => 'SA_MODIFYDEPOSIT',
			)
);


include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . '/includes/ui/items_cart.inc');
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/gl/includes/ui/gl_bank_ui.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/gl/includes/gl_ui.inc");
include_once($path_to_root . "/admin/db/attachments_db.inc");

include_once($path_to_root.'/modules/FrontHrm/includes/ui/employee_ui.inc');

include_once($path_to_root.'/modules/FrontHrm/includes/db/employee_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');
$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

if (isset($_GET['NewPayment'])) {
	$_SESSION['page_title'] = _($help_context = "Bank Account Payment Entry");
	create_cart(ST_BANKPAYMENT, 0,0,0,0,0,$_GET['attachment']);
}else if ((isset($_GET['InvoiceNumber'])) && (isset($_GET['Bank_trans_no']))) {
	$_SESSION['page_title'] = _($help_context = "Refund Payment");
	create_cart(ST_BANKPAYMENT,0, $_GET['Bank_trans_no'] ,ST_CUSTPAYMENT,$_GET['InvoiceNumber'],ST_SALESINVOICE);
 
} else if(isset($_GET['NewDeposit'])) {
	$_SESSION['page_title'] = _($help_context = "Bank Account Deposit Entry");
	create_cart(ST_BANKDEPOSIT, 0,0,0,0,0,$_GET['attachment']);
} else if(isset($_GET['ModifyPayment'])) {
	$_SESSION['page_title'] = _($help_context = "Modify Bank Account Entry")." #".$_GET['trans_no'];
	create_cart(ST_BANKPAYMENT, $_GET['trans_no']);
} else if(isset($_GET['ModifyDeposit'])) {
	$_SESSION['page_title'] = _($help_context = "Modify Bank Deposit Entry")." #".$_GET['trans_no'];
	create_cart(ST_BANKDEPOSIT, $_GET['trans_no']);
}
page($_SESSION['page_title'], false, false, '', $js);
// display_error($_SESSION['page_title']);
//-----------------------------------------------------------------------------------------------
check_db_has_bank_accounts(_("There are no bank accounts defined in the system."));

if (isset($_GET['ModifyDeposit']) || isset($_GET['ModifyPayment']))
	check_is_editable($_SESSION['pay_items']->trans_type, $_SESSION['pay_items']->order_id);

//----------------------------------------------------------------------------------------
if (list_updated('PersonDetailID')) {
	$br = get_branch(get_post('PersonDetailID'));
	$_POST['person_id'] = $br['debtor_no'];
	$Ajax->activate('person_id');
}

//--------------------------------------------------------------------------------------------------
function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
  $Ajax->activate('footer');
  set_focus('_code_id_edit');
}

if (isset($_GET['Refund']))
{
	$trans_no = $_GET['Refund'];
	$trans_type = ST_BANKPAYMENT;
	$ret = $_GET['credit_id'];
	$credit_type =11;

 echo '<ol class="rounded-list">';
  echo '<li>';
 	display_notification_centered(sprintf(_("Refund %d has been entered"), $trans_no));
  
  echo '</li><li>';
    display_note(get_customer_trans_view_str(11, $ret, _("&View This Credit Note"), false, '', '', $path_to_root, basename($_SERVER['PHP_SELF'])), 0, 0);
   	br();
   	 echo '</li><li><span>';
	display_note(get_gl_view_str($trans_type, $trans_no, _("&View the GL Postings for this Payment")));
  echo '</span></li><li><span>';
 	display_note(get_gl_view_str(11, $ret, _("View the GL &Journal Entries for this Credit Note")),1);
  echo '</span></li><li><span>';
	display_note(print_document_link($ret."-".$credit_type, _("&Print This Credit Note"), true, 11),1);
	  echo '</span></li></ol>';
	//hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), "filterType=$trans_type&trans_no=$trans_no");

	display_footer_exit();
}

//-----------------------------------------------------------------------------------------------

if (isset($_GET['AddedID']))
{
	$trans_no = $_GET['AddedID'];
	$trans_type = ST_BANKPAYMENT;
	$ret = $_GET['credit_id'];
 echo '<ol class="rounded-list">';
  echo '<li>';

   	display_notification_centered(sprintf(_("Payment %d has been entered"), $trans_no));
    echo '</li><li>';
  	submenu_view(_("&View This Payment"), $trans_type, $trans_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));
    echo '<li>';
    display_note(chq_print_document_link($trans_no."-".$trans_type, _("Print Cheque"), true, $trans_type));
    echo '</li><li>';
    echo '<br>';
  	submenu_print(_("&Print This Payment"), ST_BANKPAYMENT, $trans_no, 'prtopt',null,null,A4);
  echo '</li><li>';
	display_note(get_gl_view_str($trans_type, $trans_no, _("&View the GL Postings for this Payment")));

  echo '</li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter Another &Payment"), "NewPayment=yes");
  echo '</span></li><li><span>';

	hyperlink_params($_SERVER['PHP_SELF'], _("Enter A &Deposit"), "NewDeposit=yes");
  echo '</span></li><li><span>';

	hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), "filterType=$trans_type&trans_no=$trans_no");
 echo '</span></li></ol>';

	display_footer_exit();
}

if (isset($_GET['UpdatedID']))
{
	$trans_no = $_GET['UpdatedID'];
	$trans_type = ST_BANKPAYMENT;
	$ret = $_GET['credit_id'];

   	display_notification_centered(sprintf(_("Payment %d has been modified"), $trans_no));
 echo '<ol class="rounded-list">';
  echo '<li>';
  	submenu_view(_("&View This Payment"), $trans_type, $trans_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));

  echo '</li><li>';
  	submenu_print(_("&Print This Payment"), ST_BANKPAYMENT, $trans_no, 'prtopt',null,null,A4);
  	echo '</li><li>';
	display_note(get_gl_view_str($trans_type, $trans_no, _("&View the GL Postings for this Payment")));
  echo '</li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter Another &Payment"), "NewPayment=yes");
  echo '</span></li><li><span>';

	hyperlink_params($_SERVER['PHP_SELF'], _("Enter A &Deposit"), "NewDeposit=yes");
  echo '</span></li></ol>';

	display_footer_exit();
}

if (isset($_GET['AddedDep']))
{
	$trans_no = $_GET['AddedDep'];
	$trans_type = ST_BANKDEPOSIT;
 echo '<ol class="rounded-list">';
  echo '<li>';
   	display_notification_centered(sprintf(_("Deposit %d has been entered"), $trans_no));
   	echo '</li><li>';
  	    submenu_view(_("&View This Deposit"), $trans_type, $trans_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));

    echo '</li><li>';
  	    submenu_print(_("&Print This Deposit"), ST_BANKDEPOSIT, $trans_no, 'prtopt',null,null,A4);
echo '</li><li>';
	display_note(get_gl_view_str($trans_type, $trans_no, _("View the GL Postings for this Deposit")));
echo '</li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter Another Deposit"), "NewDeposit=yes");
echo '</span></li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter A Payment"), "NewPayment=yes");
echo '</span></li></ol>';

	display_footer_exit();
}
if (isset($_GET['UpdatedDep']))
{
	$trans_no = $_GET['UpdatedDep'];
	$trans_type = ST_BANKDEPOSIT;
 echo '<ol class="rounded-list">';
  echo '<li>';
   	display_notification_centered(sprintf(_("Deposit %d has been modified"), $trans_no));
echo '</li><li>';
  	submenu_view(_("&View This Deposit"), $trans_type, $trans_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));

echo '</li><li>';
  	submenu_print(_("&Print This Deposit"), ST_BANKDEPOSIT, $trans_no, 'prtopt',null,null,A4);

echo '</li><li>';
	display_note(get_gl_view_str($trans_type, $trans_no, _("&View the GL Postings for this Deposit")));
echo '</li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter Another &Deposit"), "NewDeposit=yes");
echo '</span></li><li><span>';

	hyperlink_params($_SERVER['PHP_SELF'], _("Enter A &Payment"), "NewPayment=yes");
echo '</span></li></ol>';
	display_footer_exit();
}

//--------------------------------------------------------------------------------------------------

function create_cart($type, $trans_no,$bank_trans_no = 0, $payment_type=0,$invoice_no = 0, $sales_type = 0,$attachment_id)
{
	global $Refs;

	if (isset($_SESSION['pay_items']))
	{
		unset ($_SESSION['pay_items']);
	}

	$cart = new items_cart($type);
    $cart->order_id = $trans_no;
    if (isset($attachment_id)) {
    	$cart->attachment = $attachment_id;
    }

	if ($trans_no != 0 || $bank_trans_no != 0) {
		if($invoice_no != 0  &&  $sales_type != 0){
        $cart->refund = 1;
    }

		if($trans_no != 0)
			$bank_trans = db_fetch(get_bank_trans($type, $trans_no));
		else
			$bank_trans = db_fetch(get_bank_trans($payment_type, $bank_trans_no));
		
		$_POST['bank_account'] = $bank_trans["bank_act"];
		$_POST['PayType'] = $bank_trans["person_type_id"];
		$_POST['advance_salary'] = $bank_trans["advance_salary"];
		$_POST['check_pdc'] = $bank_trans["pdcStatus"];
		$_POST['ac_payee'] = $bank_trans["ac_payee"];
		$_POST['date_pdc'] = sql2date($bank_trans["pdcDate"]);

		$cart->reference = $bank_trans["ref"];

		if ($bank_trans["person_type_id"] == PT_CUSTOMER)
		{
			if($trans_no != 0)
				$trans = get_customer_trans($trans_no, $type);
			else
				$trans = get_customer_trans($bank_trans_no,$payment_type);

			$_POST['person_id'] = $trans["debtor_no"];
			$_POST['PersonDetailID'] = $trans["branch_code"];
		}
		elseif ($bank_trans["person_type_id"] == PT_SUPPLIER)
		{
			if($trans_no != 0)
			$trans = get_supp_trans($trans_no, $type);
			else
			$trans = get_supp_trans($payment_type, $bank_trans_no);

			$_POST['person_id'] = $trans["supplier_id"];
		}
		elseif ($bank_trans["person_type_id"] == PT_MISC)
			$_POST['person_id'] = $bank_trans["person_id"];
		elseif ($bank_trans["person_type_id"] == PT_QUICKENTRY)
			$_POST['person_id'] = $bank_trans["person_id"];
		else 
			$_POST['person_id'] = $bank_trans["person_id"];


		if($trans_no != 0)
			$cart->memo_ = get_comments_string($type, $trans_no);
		else
			$cart->memo_ = get_comments_string($payment_type, $bank_trans_no);

		if($cart->refund == 1)
            $cart->tran_date = date("d/m/Y") ;
        else
            $cart->tran_date = sql2date($bank_trans['trans_date']);

		$cart->original_amount = $bank_trans['amount'];

		
		if($trans_no != 0)
			$result = get_gl_trans($type, $trans_no);

		else
			$result = get_gl_trans($payment_type, $bank_trans_no);

		if ($result) {
			while ($row = db_fetch($result)) {
				if (is_bank_account($row['account'])) {
					// date exchange rate is currenly not stored in bank transaction,
					// so we have to restore it from original gl amounts
					if($cart->refund != 1)
					$ex_rate = $bank_trans['amount']/$row['amount'];
				else
					$ex_rate = 1;
				} else {
					if($invoice_no != 0  &&  $sales_type != 0){
						$_SESSION['Items'] = new cart(ST_SALESINVOICE, $_GET['InvoiceNumber'], true,1);
					    $_SESSION['Items']->refund = 1;
					    $_SESSION['Items']->against = $_GET['InvoiceNumber'];
					       
		                $_SESSION['Items']->total_refund = $amount;
		                
		                 $cart->invoice_no1 = $invoice_no;
		                 
					  

					}
						if($invoice_no != 0  &&  $sales_type != 0){
							// display_error( $row['account']."=". $row['dimension_id']."=".
							// $row['dimension2_id']."=". $row['ov_amount']."=". $row['memo_']);
							$cart->add_gl_item( $row['account'], $row['dimension_id'],
							$row['dimension2_id'], $row['ov_amount'], $row['memo_']);
						}else{
							$cart->add_gl_item( $row['account'], $row['dimension_id'],
							$row['dimension2_id'], $row['amount'], $row['memo_']);

						}
				}
			}
		}

		// apply exchange rate
		foreach($cart->gl_items as $line_no => $line)
			$cart->gl_items[$line_no]->amount *= $ex_rate;

	} else {
		$cart->reference = $Refs->get_next($cart->trans_type, null, $cart->tran_date);
		$cart->tran_date = new_doc_date();
		if (!is_date_in_fiscalyear($cart->tran_date))
			$cart->tran_date = end_fiscalyear();
	}

	$_POST['memo_'] = $cart->memo_;
	$_POST['ref'] = $cart->reference;
	$_POST['date_'] = $cart->tran_date;

	$_SESSION['pay_items'] = &$cart;
	

}
//-----------------------------------------------------------------------------------------------
 if(isset($_POST['invoice_no']))
 {       
 	
           // display_error(in);
                      $_SESSION['pay_items']->clear_items();
         	$myrow = get_customer_trans($_POST['invoice_no'], ST_SALESINVOICE,$_POST['person_id'],1);
          	if(empty($myrow))
             {

                    $_SESSION['pay_items']->tourist_tax_refund = $_SESSION['pay_items']->invoice_no = 0;
            		display_error(get_customer_name($_POST['person_id'])." has no transaction this invoice No # ".$_POST['invoice_no']);
               
             }
            else
             { 
                     	$alloc_result = get_allocatable_from_cust_transactions($_POST['person_id'], $_POST['invoice_no'], ST_SALESINVOICE);
                   if(db_num_rows($alloc_result )==0)
                   { 

                         global 	$Ajax;
                           $_SESSION['pay_items']->tourist_tax_refund = $_SESSION['pay_items']->invoice_no = 0;
                         $Ajax->activate('_page_body');
                       display_warning("Please first paymint this invoice No # ".$_POST['invoice_no']);
                        
                   }
                   else
                        {
                            
                               $pay_result=check_invoice_payment($myrow['trans_no'],ST_SALESINVOICE);

                              if(db_num_rows($pay_result )==0)
                              {

			                        $_SESSION['pay_items']->invoice_no=$myrow['trans_no'];
			                        $_SESSION['pay_items']->tourist_tax_refund=1;
			                        $_SESSION['pay_items']->add_gl_item(2150, $myrow['dimension_id'],
				                	$myrow['dimension2_id'], $myrow['ov_gst'], $myrow['memo_']);

                              } 
                              else
                              {

                                     $_SESSION['pay_items']->tourist_tax_refund = $_SESSION['pay_items']->invoice_no = 0;
                     
                                    display_notification("already Return VAT Amount  this invoice No # ".$_POST['invoice_no']);


                              }                    
                    
                        }
              }
 }

//-----------------------------------------------------------------------------------------------

function check_trans()
{


	$input_error = 0;

	if (isset($_POST['date_pdc'])){
		if( strtotime(date2sql($_POST['date_'])) > strtotime(date2sql($_POST['date_pdc'])) ){
			display_error(_("PDC Date should be greater than the transaction Date."));
			set_focus('date_pdc');
			$input_error = 1;
		}
	}


	if ($_SESSION['pay_items']->count_gl_items() < 1) {
		display_error(_("You must enter at least one payment line."));
		set_focus('code_id');
		$input_error = 1;
	}

	if ($_SESSION['pay_items']->gl_items_total() == 0.0) {
		display_error(_("The total bank amount cannot be 0."));
		set_focus('code_id');
		$input_error = 1;
	}

	$limit = get_bank_account_limit($_POST['bank_account'], $_POST['date_']);

	$amnt_chg = -$_SESSION['pay_items']->gl_items_total()-$_SESSION['pay_items']->original_amount;

	if ($limit !== null && floatcmp($limit, -$amnt_chg) < 0)
	{
		display_error(sprintf(_("The total bank amount exceeds allowed limit (%s)."), price_format($limit-$_SESSION['pay_items']->original_amount)));
		set_focus('code_id');
		$input_error = 1;
	}
	if ($trans = check_bank_account_history($amnt_chg, $_POST['bank_account'], $_POST['date_'])) {

		display_error(sprintf(_("The bank transaction would result in exceed of authorized overdraft limit for transaction: %s #%s on %s."),
			$systypes_array[$trans['type']], $trans['trans_no'], sql2date($trans['trans_date'])));
		set_focus('amount');
		$input_error = 1;
	}
	if (!check_reference($_POST['ref'], $_SESSION['pay_items']->trans_type, $_SESSION['pay_items']->order_id))
	{
	    global $Refs;
	    $last_ref = $Refs->get_next(ST_BANKPAYMENT, null, $trans['trans_date']);

        $maxref =(int) filter_var(str_replace('-', '', $last_ref), FILTER_SANITIZE_NUMBER_INT);
        $newref = str_replace($maxref, $maxref+1 ,$last_ref);	    
	    $_POST['ref'] = $newref;
		display_error("The Reference has been auto updated, now you can process the document.");
		set_focus('ref');
		$input_error = 1;
	}
	if (!is_date($_POST['date_']))
	{
		display_error(_("The entered date for the payment is invalid."));
		set_focus('date_');
		$input_error = 1;
	}
	elseif (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		$input_error = 1;
	} 

	if (get_post('PayType')==PT_CUSTOMER && (!get_post('person_id') || !get_post('PersonDetailID'))) {
		display_error(_("You have to select Customer and Customer's branch."));
		set_focus('person_id');
		$input_error = 1;
	} elseif (get_post('PayType')==PT_SUPPLIER && (!get_post('person_id'))) {
		display_error(_("You have to select supplier."));
		set_focus('person_id');
		$input_error = 1;
	}
	if (!db_has_currency_rates(get_bank_account_currency($_POST['bank_account']), $_POST['date_'], true))
		$input_error = 1;

	if (isset($_POST['settled_amount']) && in_array(get_post('PayType'), array(PT_SUPPLIER, PT_CUSTOMER)) && (input_num('settled_amount') <= 0)) {
		display_error(_("Settled amount have to be positive number."));
		set_focus('person_id');
		$input_error = 1;
	}
	return $input_error;
}



if (isset($_POST['Process']) && !check_trans())
{
	// display_error($_SESSION['pay_items']->attachment."==".$trans_no."===".$trans_type);exit;
	begin_transaction();
	 if(isset($_SESSION['Items'])){
	 	$ret = $_SESSION['Items']->write(0);
	 }
	$attachment_id = $_SESSION['pay_items']->attachment;
	$_SESSION['pay_items'] = &$_SESSION['pay_items'];
	$new = $_SESSION['pay_items']->order_id == 0;
	$trans_no_old = $_SESSION['pay_items']->order_id;

	add_new_exchange_rate(get_bank_account_currency(get_post('bank_account')), get_post('date_'), input_num('_ex_rate'));
		add_new_exchange_rate(get_bank_account_currency(get_post('bank_account')), get_post('date_'), input_num('_ex_rate'));
	    if($_SESSION['pay_items']->refund  == 1){
	       
	    	$trans = write_bank_transaction(
			$_SESSION['pay_items']->trans_type, $_SESSION['pay_items']->order_id, $_POST['bank_account'],
			$_SESSION['pay_items'], $_POST['date_'],
			$_POST['PayType'], $_POST['person_id'], get_post('PersonDetailID'),
			$_POST['ref'], $_POST['memo_'], true, $_SESSION['Items']->get_items_total_dispatch()+$_SESSION['pay_items']->vat_refund, $_SESSION['pay_items']->refund,$_SESSION['pay_items']->invoice_no1, $_POST['check_pdc'], $_POST['date_pdc'], null, null, $_POST['party_name'], $_POST['ac_payee']);
	    }
		else
		{
			$trans = write_bank_transaction(
			$_SESSION['pay_items']->trans_type, $_SESSION['pay_items']->order_id, $_POST['bank_account'],
			$_SESSION['pay_items'], $_POST['date_'],
			$_POST['PayType'], $_POST['person_id'], get_post('PersonDetailID'),
			$_POST['ref'], $_POST['memo_'], true, input_num('settled_amount', null), null, null, $_POST['check_pdc'], $_POST['date_pdc'] ,$_POST['advance_salary'],$_POST['emp_id'], $_POST['party_name'], $_POST['ac_payee']);
		}

	$trans_type = $trans[0];
   	$trans_no = $trans[1];


	if($_SESSION['pay_items']->line_attachment){
		foreach($_SESSION['pay_items']->line_attachment as $key => $value){
			$attach_id = add_attachment($_SESSION['pay_items']->trans_type, $trans_no, $value->attach_title, $value->file_name, $value->file_name, null, $value->file_type);
			add_attach_inquiry_and_details($trans_no, $_SESSION['pay_items']->trans_type, null, date('Y-m-d H:i:s'), $value->attach_title, $value->file_name);
			$filePath = company_path()."/temp_attachment/".$value->file_name;
			$destinationFilePath = company_path()."/attachments/attachments_inquiry/".$value->file_name;
			rename($filePath, $destinationFilePath) ;
		}
	}

      
     

                  if($_SESSION['pay_items']->tourist_tax_refund)
             {

	   	$sql1="INSERT INTO ".TB_PREF."trans_tax_details (trans_type, trans_no, tran_date, tax_type_id, net_amount, amount, memo )
		VALUES (".db_escape(ST_SALESINVOICE)."," . db_escape($trans_no).",'"
				.date2sql(get_post('date_'))."',".db_escape(1).","
				.db_escape(0).","
				.db_escape(-$_SESSION['pay_items']->gl_items_total()).",".db_escape('Inv No'.$_SESSION['pay_items']->invoice_no).")";
// display_error($sql1);
	       db_query($sql1, "Cannot save trans tax details");
	       
   		add_cust_allocation($_SESSION['pay_items']->gl_items_total(), ST_BANKPAYMENT, get_next_trans_no(ST_BANKPAYMENT)-1, ST_SALESINVOICE, $_SESSION['pay_items']->invoice_no, $_POST['person_id'], $_POST['date_']);
	         

	         }
	new_doc_date($_POST['date_']);

	$refund = $_SESSION['pay_items']->refund;
	$_SESSION['pay_items']->clear_items();
	unset($_SESSION['pay_items']);
	unset($_SESSION['Items']);

	commit_transaction();

	 if($refund)
    	meta_forward($_SERVER['PHP_SELF'], $trans_type==ST_BANKPAYMENT ?
			"Refund=$trans_no&credit_id=$ret" : "Refund=$trans_no&credit_id=$ret");
    else{
		if ($new){
			// display_error($attachment_id);
			if ($attachment_id > 0) {
						link_document($attachment_id , $trans_no, $trans_type);
					}
			meta_forward($_SERVER['PHP_SELF'], $trans_type==ST_BANKPAYMENT ?
			"AddedID=$trans_no" : "AddedDep=$trans_no");
		}
		else{
			relink_document($trans_type,$trans_no_old,$trans_no);
			meta_forward($_SERVER['PHP_SELF'], $trans_type==ST_BANKPAYMENT ?
				"UpdatedID=$trans_no" : "UpdatedDep=$trans_no");
		}
     }
}

//-----------------------------------------------------------------------------------------------

function check_item_data()
{
	if (!check_num('amount', 0))
	{
		display_error( _("The amount entered is not a valid number or is less than zero."));
		set_focus('amount');
		return false;
	}
	if (isset($_POST['_ex_rate']) && input_num('_ex_rate') <= 0)
	{
		display_error( _("The exchange rate cannot be zero or a negative number."));
		set_focus('_ex_rate');
		return false;
	}
     if($_SESSION['pay_items']->tourist_tax_refund==1)
     {
                	$myrow = get_customer_trans($_POST['invoice_no'], ST_SALESINVOICE,$_POST['person_id'],1);
                  //    display_error($_POST['amount']." = ".$myrow['ov_gst']);
                	if($_POST['amount']>$myrow['ov_gst'])
                	{
                		display_error( _("The amount entered is not greater Invoice VAT amount."));
	                 	set_focus('amount');
	                  	return false;
                	}

     }



	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
	$amount = ($_SESSION['pay_items']->trans_type==ST_BANKPAYMENT ? 1:-1) * input_num('amount');
    if($_POST['UpdateItem'] != "" && check_item_data())
    {
    	$_SESSION['pay_items']->update_gl_item($_POST['Index'], $_POST['code_id'], 
    	    $_POST['dimension_id'], $_POST['dimension2_id'], $amount , $_POST['LineMemo']);
    }
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['pay_items']->remove_gl_item($id);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_new_item()
{
	if (!check_item_data())
		return;
	$amount = ($_SESSION['pay_items']->trans_type==ST_BANKPAYMENT ? 1:-1) * input_num('amount');

	$_SESSION['pay_items']->add_gl_item($_POST['code_id'], $_POST['dimension_id'],
		$_POST['dimension2_id'], $amount, $_POST['LineMemo']);
	line_start_focus();
}


 
//--------------------------------------------------------------------------------


function check_attachment_type($check_format){


	if (!in_array(substr($check_format,-4), array('.jpg','.JPG','.png','.PNG','.PDF','.pdf','jpeg','JPEG','.msg','.MSG','.xls','.XLS','.csv','.CSV','XLSX','xlsx'))){
			display_error(_('Files formate not supported'));
			return false;
		}

	return true;
}


function check_attachment_exist($file_name){
	$attachmen_area = company_path()."/attachments/".$file_name;
	if(file_exists($attachmen_area)){
		display_error("File Name Already Exist In Attachment Storage.");
		return false;
	}

	$temp_attachment = company_path()."/temp_attachment/".$file_name;
	if(file_exists($temp_attachment)){
		display_error("File Already Selected.");
		return false;
	}

	return true;
}

function add_attachment_to_order(&$order, $file_name, $file_type, $file_path, $attach_title=null){
	$_SESSION['pay_items']->add_to_attachment_cart(count($_SESSION['pay_items']->line_attachment),  $file_name, $file_type, $file_path, $attach_title);
}

function handle_new_attachment(){

	$file_name = date('d_m_Y_H_i_s')."_".basename($_FILES["attachment"]["name"]);
	if(!check_attachment_type($file_name))
			return;
	
	if(!check_attachment_exist($file_name))
		return false;

	if (!file_exists(company_path()."/temp_attachment")) {
	    mkdir(company_path()."/temp_attachment", 0777, true);
	}
	move_uploaded_file($_FILES['attachment']['tmp_name'], company_path()."/temp_attachment/".$file_name);
	add_attachment_to_order($_SESSION['pay_items'], 
	$file_name, 
	$_FILES['attachment']['type'], 
	$_FILES['attachment']['tmp_name'], 
	$_POST['attach_title']);
	unset($_FILES['attachment']);
	unset($_POST['attach_title']);
	page_modified();
}

function handle_delete_attachment($line_no){
	    $_SESSION['pay_items']->remove_attachment_from_cart($line_no);
}

//--------------------------------------------------------------------------------

function can_add_refund($amount){
	

	$trans_no =  $_SESSION['pay_items']->invoice_no1;
	$sql = " SELECT sum(amt) as amount FROM ".TB_PREF."cust_allocations WHERE trans_no_to =".db_escape($trans_no)." AND trans_type_to = 10  ";
	// display_error($trans_no);
	$result = db_query($sql,"No Amount Fetched");
	$row = db_fetch($result);
	// display_error($sql);
	// display_error($row['amount']);

	if($amount <= $row['amount'])
		return 1;
	else{
		display_error("Amount should not be greater than allocated amount.");
		return 0;
	}
}


if (isset($_POST['Updatee'])) {
	 global 	$Ajax;
	 $Ajax->activate('button_id');
 	 $Ajax->activate('Items2');
}
//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['AddAttachment']))
	handle_new_attachment();

$id = find_submit('del_attach');
if ($id!=-1)
	handle_delete_attachment($id);

if (isset($_POST['CancelItemChanges']))
	line_start_focus();

if (isset($_POST['go']))
{
	display_quick_entries($_SESSION['pay_items'], $_POST['person_id'], input_num('totamount'), 
		$_SESSION['pay_items']->trans_type==ST_BANKPAYMENT ? QE_PAYMENT : QE_DEPOSIT);
	$_POST['totamount'] = price_format(0); $Ajax->activate('totamount');
	line_start_focus();
}
//-----------------------------------------------------------------------------------------------

start_form(true);

display_bank_header($_SESSION['pay_items']);

if($_SESSION['pay_items']->trans_type == ST_BANKPAYMENT)
	add_attachment_view($_SESSION['pay_items']);

if($_SESSION['pay_items']->refund){

start_table(TABLESTYLE2, "width='60%'", 10);
start_row();
echo "<td>";

display_heading( _("Refund Items"));

div_start('Items2');

start_table(TABLESTYLE, "60%'");


	$th = array(_("Item Code"), _("Item Description"), _("Quantity"),
		_("Units"), _("Price"), _("Total"));



table_header($th);
$k = 0;
$has_marked = false;
$show_qoh = true;

$dn_line_cnt = 0;

foreach ($_SESSION['Items']->line_items as $line=>$ln_itm) {
	
	$dec = get_qty_dec($ln_itm->stock_id);

	alt_table_row_color($k);
	view_stock_status_cell($ln_itm->stock_id);
if(isset($_POST['Updatee']) && can_add_refund($_POST['price'.$line]*$_POST['quantity'.$line]) == 1){

		$condition = 1;
		$_SESSION['Items']->update_cart_item($line, $_POST['quantity'.$line], $_POST['price'.$line], 0, "");
		$_SESSION['pay_items']->update_refund_gl_item(0,$_SESSION['Items']->get_refund_total_dispatch());
		$Ajax->activate('items_table');
}
	
		label_cell($ln_itm->item_description);
	

		
		small_qty_cells(null, 'quantity'.$line, qty_format($ln_itm->quantity), null, null, $dec , 1);
	
		label_cell($ln_itm->units);
	


	$line_total = (($ln_itm->qty_dispatched * $ln_itm->price) - ( $ln_itm->discount_percent));
	
	
	text_cells(null, 'price'.$line, $ln_itm->price-$ln_itm->discount_percent, 10, 15);
	
	amount_cell($ln_itm->price*$ln_itm->quantity);

	
	
	end_row();
}



if (!isset($_POST['ChargeFreightCost']) || $_POST['ChargeFreightCost'] == "") {
	if ($_SESSION['Items']->any_already_delivered() == 1) {
		$_POST['ChargeFreightCost'] = price_format(0);
	} else {
		$_POST['ChargeFreightCost'] = price_format($_SESSION['Items']->freight_cost);
	}

	if (!check_num('ChargeFreightCost')) {
		$_POST['ChargeFreightCost'] = price_format(0);
	}
}

$accumulate_shipping = get_company_pref('accumulate_shipping');

$colspan = 5;
start_row();
label_cell(_("Shipping Cost"), "colspan=$colspan align=right");

	small_amount_cells(null, 'ChargeFreightCost', null);


end_row();
$inv_items_total = $_SESSION['Items']->get_refund_total_dispatch();

$display_sub_total = price_format($inv_items_total + input_num('ChargeFreightCost'));

label_row(_("Sub-total"), $display_sub_total, "colspan=$colspan align=right","align=right", 0);

$taxes = $_SESSION['Items']->get_refund_taxes(input_num('ChargeFreightCost'));
$tax_total = display_edit_tax_items($taxes, $colspan, $_SESSION['Items']->tax_included, 0);

$display_total = price_format(($inv_items_total + input_num('ChargeFreightCost') + $tax_total));
 $_SESSION['pay_items']->vat_refund = $tax_total;
label_row(_("Invoice Total"), $display_total, "colspan=$colspan align=right","align=right", 0);

end_table(1);
div_end();

hidden('InvoiceNumber', $_GET['InvoiceNumber']);
echo "</td>";
end_row();
end_table(1);
}//
//pk

start_table(TABLESTYLE2, "width='90%'", 10);
start_row();
echo "<td>";

display_gl_items($_SESSION['pay_items']->trans_type==ST_BANKPAYMENT ?
	_("Payment Items"):_("Deposit Items"), $_SESSION['pay_items']);
echo "</td>";
end_row();
end_table(1);
start_table(TABLESTYLE2, "width='90%'", 10);
start_row();
echo "<td>";
gl_options_controls($_SESSION['pay_items']);
echo "</td>";
end_row();
end_table(1);

if($_SESSION['pay_items']->refund)
{
        div_start('button_id');
    	submit_center_first('Updatee', _("Update"),
      _('Refresh document page'), true);
    	if($_POST['Updatee'] && $condition == 1)
    	submit_center_last('Process', $_SESSION['pay_items']->trans_type==ST_BANKPAYMENT ?
    	_("Refund Payment"):_("Process Deposit"), '', 'default');
    	div_end();
}
else{
submit_center_first('Update', _("Update"), '', null);

submit_center_last('Process', $_SESSION['pay_items']->trans_type==ST_BANKPAYMENT ?
	_("Process Payment"):_("Process Deposit"), '', 'default');
}
end_form();

//------------------------------------------------------------------------------------------------
echo '</br>';

end_page();

