<?php

//----------------------------------------------------------------------------------

// add a bank transaction
// $amount is in $currency
// $date_ is display date (non-sql)

function add_bank_trans($type, $trans_no, $bank_act, $ref, $date_,
	$amount, $person_type_id, $person_id, $currency="", $err_msg="", $rate=0,$refund = 0,$invoice_no = 0, $pdcStatus = null,$pdcDate = null,$advance_salary = 0,$emp_id=0, $party_name=null, $ac_payee=null)
{
	$sqlDate = date2sql($date_);


	// convert $amount to the bank's currency
	if ($currency != "")
	{
    	$bank_account_currency = get_bank_account_currency($bank_act);
    	if ($rate == 0)
    		$to_bank_currency = get_exchange_rate_from_to($currency, $bank_account_currency, $date_);
    	else
    		$to_bank_currency = 1 / $rate;
    	$amount_bank = ($amount / $to_bank_currency);
	}
	else
		$amount_bank = $amount;
	$amount_bank = round2($amount_bank, user_price_dec());	

	$sql = "INSERT INTO ".TB_PREF."bank_trans (type, trans_no, bank_act, ref,
		trans_date, amount, person_type_id, person_id,refund,invoice, pdcStatus, pdcDate,advance_salary,emp_id, party_name, ac_payee) ";

	$sql .= "VALUES ($type, $trans_no, '$bank_act', ".db_escape($ref).", '$sqlDate',
		".db_escape($amount_bank).", ".db_escape($person_type_id)
		.", ". db_escape($person_id).", ". db_escape($refund).", ". db_escape($invoice_no).", ". db_escape($pdcStatus).", ". db_escape($pdcDate)." , ". db_escape($advance_salary).", ". db_escape($emp_id).", ". db_escape($party_name).",". db_escape($ac_payee).")";

	if ($err_msg == "")
		$err_msg = "The bank transaction could not be inserted";

	db_query($sql, $err_msg);
}

//----------------------------------------------------------------------------------------

function exists_bank_trans($type, $type_no)
{
	$sql = "SELECT trans_no
		FROM ".TB_PREF."bank_trans
		WHERE type=".db_escape($type)
		." AND trans_no=".db_escape($type_no);
	$result = db_query($sql, "Cannot retreive a bank transaction");

    return (db_num_rows($result) > 0);
}

//----------------------------------------------------------------------------------------
 
function get_bank_trans($type, $trans_no=null, $person_type_id=null, $person_id=null)
{
	$sql = "SELECT bt.*, act.*,
		IFNULL(abs(dt.ov_amount), IFNULL(ABS(st.ov_amount), bt.amount)) settled_amount,
		IFNULL(abs(dt.ov_amount/bt.amount), IFNULL(ABS(st.ov_amount/bt.amount), 1)) settle_rate,
		IFNULL(debtor.curr_code, IFNULL(supplier.curr_code, act.bank_curr_code)) settle_curr,act.id as acc_id

		FROM ".TB_PREF."bank_trans bt
				 LEFT JOIN ".TB_PREF."debtor_trans dt ON dt.type=bt.type AND dt.trans_no=bt.trans_no
				 LEFT JOIN ".TB_PREF."debtors_master debtor ON debtor.debtor_no = dt.debtor_no
				 LEFT JOIN ".TB_PREF."supp_trans st ON st.type=bt.type AND st.trans_no=bt.trans_no
				 LEFT JOIN ".TB_PREF."suppliers supplier ON supplier.supplier_id = st.supplier_id,
			 ".TB_PREF."bank_accounts act
		WHERE act.id=bt.bank_act ";
	if ($type != null)
		$sql .= " AND bt.type=".db_escape($type);
	if ($trans_no != null)
		$sql .= " AND bt.trans_no = ".db_escape($trans_no);
	if ($person_type_id != null)
		$sql .= " AND bt.person_type_id = ".db_escape($person_type_id);
	if ($person_id != null)
		$sql .= " AND bt.person_id = ".db_escape($person_id);
	$sql .= " ORDER BY trans_date, bt.id";
	
// display_error($sql);
	return db_query($sql, "query for bank transaction");
}

//----------------------------------------------------------------------------------------

function get_bank_trans_for_bank_account($bank_account, $from, $to)
{
	$from = date2sql($from);
	$to = date2sql($to);
	$sql = "SELECT t.* 
		FROM ".TB_PREF."bank_trans t 
			LEFT JOIN ".TB_PREF."voided v ON t.type=v.type AND t.trans_no=v.id
		WHERE t.bank_act = ".db_escape($bank_account) . "
			AND ISNULL(v.date_)
			AND trans_date >= '$from'
			AND trans_date <= '$to'
			AND amount != 0 
			AND (IF(t.type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), t.approve_status = 1, t.approve_status = 0 )) 
			ORDER BY trans_date, t.id ";

	return db_query($sql,"The transactions for '" . $bank_account . "' could not be retrieved");
}

//----------------------------------------------------------------------------------------

function get_balance_before_for_bank_account($bank_account, $from)
{
	$from = date2sql($from);
	$sql = "SELECT SUM(amount)
		FROM ".TB_PREF."bank_trans
		WHERE bank_act=".db_escape($bank_account) . "
			AND trans_date < '$from'";
	$sql .= " AND (IF(type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), approve_status = 1, approve_status = 0 )) ";			
	$before_qty = db_query($sql, "The starting balance on hand could not be calculated");
	$bfw_row = db_fetch_row($before_qty);
	return $bfw_row[0];
}
//----------------------------------------------------------------------------------------

function get_gl_trans_value($account, $type, $trans_no)
{
	$sql = "SELECT SUM(amount)
		FROM ".TB_PREF."gl_trans
		WHERE account=".db_escape($account)
			." AND type=".db_escape($type)
			." AND type_no=".db_escape($trans_no);

	$result = db_query($sql, "query for gl trans value");

	$row = db_fetch_row($result);
	return $row[0];
}

//----------------------------------------------------------------------------------------

function void_bank_trans($type, $type_no, $nested=false)
{

	if (!$nested)
		begin_transaction();

	$sql = "UPDATE ".TB_PREF."bank_trans 
			SET amount=0
			WHERE type=".db_escape($type)." AND trans_no=".db_escape($type_no);

	db_query($sql, "could not void bank transactions for type=$type and trans_no=$type_no");

	void_gl_trans($type, $type_no, true);

	// in case it's a customer trans - probably better to check first
	void_cust_allocations($type, $type_no);
	void_customer_trans($type, $type_no);

	// in case it's a supplier trans - probably better to check first
	void_supp_allocations($type, $type_no);
	void_supp_trans($type, $type_no);

	void_trans_tax_details($type, $type_no);

	if (!$nested)
		commit_transaction();
}

/**
*	Check account history to find transaction which would exceed authorized overdraft for given account.
*	Returns null or transaction in conflict. Running balance is checked on daily basis only, to enable ID change after edition.
*	$delta_amount - tested change in bank balance at $date.
**/
function check_bank_account_history($delta_amount, $bank_account, $date=null, $user=null, $balance_offset = 0)
{
	if ($delta_amount >= 0 && isset($date))
		 return null;	// amount increase is always safe

	$balance = $date ? get_bank_account_limit($bank_account, $date, $user) : 0;

	if (!isset($balance) && isset($date))
		return null;	// unlimited account

	$balance += $balance_offset;
	if (floatcmp($balance, -$delta_amount) < 0)
		return array('amount' => $balance + $delta_amount, 'trans_date'=> date2sql($date));

	$balance += $delta_amount;

	$sql = "SELECT sum(amount) as amount, trans_date
			FROM ".TB_PREF."bank_trans
			WHERE bank_act=".db_escape($bank_account);
	if ($date)
	{
		$date = date2sql($date);
		$sql .= " AND trans_date > '$date'";
	}
	$sql .= " GROUP BY trans_date ORDER BY trans_date ASC";

	$history = db_query($sql, "cannot retrieve cash account history");

	while ($trans = db_fetch($history)) {
		$balance += $trans['amount'];
		if ($balance < 0)
		{
			$trans['amount'] = $balance;
			return $trans;
		}
	}

	return null;
}

/**
*	Check bank transfer, deposit or customer deposit before voiding.
**/
function check_void_bank_trans($type, $type_no)
{
	$moves = get_bank_trans($type, $type_no);
	while ($trans = db_fetch($moves)) {
		if ($trans['amount'] > 0) { // skip transfer input part
			return check_bank_account_history(-$trans['amount'], $trans['bank_act'], sql2date($trans['trans_date'])) == null;
		}
	}
	return true;
}


function get_bank_trans_by_id($id)
{
	$sql = "SELECT bt.*,(bt.amount-bt.alloc) as amt,CONVERT(bt.person_id USING utf8) as emp_person_id
		FROM ".TB_PREF."bank_trans as bt
		WHERE id=".db_escape($id);
	$result = db_query($sql, "Cannot retreive a bank transaction");

    return db_fetch($result);
}

function get_receip_allocation_by_gl_id($counter)
{
	$sql = "SELECT * FROM ".TB_PREF."employee_payment_receipt_allocation
		WHERE gl_id=".db_escape($counter);
	$result = db_query($sql, "Cannot retreive a bank transaction");

    return db_fetch($result);
}

function get_recipt_alloc_form($type_from,$type_no_from)
{
	$sql="SELECT emp_aloc.*,bt.id as bt_id FROM ".TB_PREF."employee_payment_receipt_allocation emp_aloc LEFT JOIN 
	  ".TB_PREF."bank_trans bt on emp_aloc.trans_type_to=bt.type AND emp_aloc.trans_no_to=bt.trans_no AND bt.amount>0  WHERE emp_aloc.trans_type_from=".db_escape($type_from)." AND emp_aloc.trans_no_from=".db_escape($type_no_from);

		$result = db_query($sql, "Cannot fount receipt allocation");
	$row = db_fetch($result);
	// display_error($sql);
  return $row;
}

function get_all_recipt_alloc_form($type_from,$type_no_from)
{
	$sql="SELECT emp_aloc.*,bt.id as bt_id  FROM ".TB_PREF."employee_payment_receipt_allocation emp_aloc LEFT JOIN 
	  ".TB_PREF."bank_trans bt on emp_aloc.trans_type_to=bt.type AND emp_aloc.trans_no_to=bt.trans_no AND bt.amount>0  WHERE emp_aloc.trans_type_from=".db_escape($type_from)." AND emp_aloc.trans_no_from=".db_escape($type_no_from);

		$result = db_query($sql, "Cannot fount receipt allocation");
	// $row = db_fetch($result);
	// display_error($sql);
    return $result;
}

function get_all_recipt_alloc_to($trans_type_to,$trans_no_to)
{
	$sql="SELECT emp_aloc.*,bt.id as bt_id  FROM ".TB_PREF."employee_payment_receipt_allocation emp_aloc LEFT JOIN 
	  ".TB_PREF."bank_trans bt on emp_aloc.trans_type_to=bt.type AND emp_aloc.trans_no_to=bt.trans_no AND bt.amount>0  WHERE emp_aloc.trans_type_to=".db_escape($trans_type_to)." AND emp_aloc.trans_no_to=".db_escape($trans_no_to)." GROUP BY trans_no_from";

		$result = db_query($sql, "Cannot fount receipt allocation");
	// $row = db_fetch($result);
	// display_error($sql);
    return $result;
}
function void_recipt_alloc($type_no,$type)
{
	$sql="DELETE FROM ".TB_PREF."employee_payment_receipt_allocation WHERE trans_type_from=".db_escape($type)." AND trans_no_from=".db_escape($type_no);
	// display_error($sql);
	db_query($sql, "");

}
