<?php

$page_security = 'SA_BANKINQUIRY';
$path_to_root="../..";
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");


include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/banking.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Bank Statement"), isset($_GET['bank_account']), false, "", $js);
if (isset($_GET['bank_account'])) {
	echo '<script src="' . $path_to_root . '/themes/'.user_theme(). '/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>';
}
check_db_has_bank_accounts(_("There are no bank accounts defined in the system."));

//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders'))
{
	$Ajax->activate('trans_tbl');
}
//------------------------------------------------------------------------------------------------

if (isset($_GET['bank_account']))
	$_POST['bank_account'] = $_GET['bank_account'];

 div_start('ext_tbl');
start_form();
start_table(TABLESTYLE_NOBORDER,"",0,0,0,"style='width:50% !important; max-width:50% !important;'");
start_row();
// bank_accounts_list_cells(_("Account:"), 'bank_account', null);
bank_accounts_list_cells_all(_("Account:"), 'bank_account', null);

date_cells(_("From:"), 'TransAfterDate', '', null, -user_transaction_days());
date_cells(_("To:"), 'TransToDate');
if(isset($_POST['TransAfterDate']))
$Ajax->activate('ext_tbl');

// $bank_acc=$_POST['bank_account'];
// $trans_AD=$_POST['TransAfterDate'];
// $trans_TD=$_POST['TransToDate'];

// PRINT BUTTON 
//----------------------------------------------------------------------------------------------------------------------------------------------


// submit_cells('Show',_("Show"),'','', 'default');
submit_cells('SearchOrders', _("Show"),'',_('Refresh Inquiry'), 'default');
$trans_type = BNKINQ;
echo  "<td>". print_bank_dashboard_print(0, $_POST['bank_account'], _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, false,
 '', '', $_POST['TransAfterDate'],$_POST['TransToDate']) ."</td>";

 echo  "<td>". print_bank_dashboard_print(1, $_POST['bank_account'], _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, false,
 '', '', $_POST['TransAfterDate'],$_POST['TransToDate'] ) ."</td>";  
end_row();
end_table();
end_form();
    div_end();

//------------------------------------------------------------------------------------------------

if (!isset($_POST['bank_account']))
	$_POST['bank_account'] = "";

$result = get_bank_trans_for_bank_account($_POST['bank_account'], $_POST['TransAfterDate'], $_POST['TransToDate']);	

div_start('trans_tbl');
$act = get_bank_account($_POST["bank_account"]);
display_heading($act['bank_name']." - ".$act['bank_curr_code']);

start_table(TABLESTYLE4);

$th = array(_("Type"), _("#"), _("Reference"), _("Date"),
	_("Debit"), _("Credit"), _("Balance"), _("Person/Item"), _("Memo"), "", "", "", "");
table_header($th);

$bfw = get_balance_before_for_bank_account($_POST['bank_account'], $_POST['TransAfterDate']);

$credit = $debit = 0;
start_row("class='inquirybg' style='font-weight:bold'");
label_cell(_("Opening Balance")." - ".$_POST['TransAfterDate'], "colspan=5");
display_debit_or_credit_cells($bfw);
label_cell("");
label_cell("", "colspan=5");

// display_error($bfw);


end_row();
$running_total = $bfw;
if ($bfw > 0 ) 
	$debit += $bfw;
else 
	$credit += $bfw;
$j = 1;
$k = 0; //row colour counter
while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);

	$running_total += $myrow["amount"];

	$trandate = sql2date($myrow["trans_date"]);
	label_cell($systypes_array[$myrow["type"]]);
	label_cell(get_trans_view_str($myrow["type"],$myrow["trans_no"],"", false, '', '',$path_to_root));
	label_cell(get_trans_view_str($myrow["type"],$myrow["trans_no"],$myrow['ref'], false, '', '',$path_to_root));
	label_cell($trandate);
	display_debit_or_credit_cells($myrow["amount"]);
	amount_cell($running_total);

	label_cell(payment_person_name($myrow["person_type_id"],$myrow["person_id"]));

	label_cell(get_comments_string($myrow["type"], $myrow["trans_no"]));
	label_cell(get_gl_view_str($myrow["type"], $myrow["trans_no"]));

	label_cell(trans_editor_link($myrow["type"], $myrow["trans_no"]));
	if($myrow["type"] == ST_BANKPAYMENT || $myrow["type"] == ST_BANKDEPOSIT)
		label_cell(print_document_link($myrow['trans_no']."-".$myrow['type'], _("Print Receipt"), true, $myrow["type"], ICON_PRINT));
	
	else
		label_cell("");

    $account_type = get_bank_account($myrow["bank_act"])['account_type'];
	if(in_array($myrow["type"],  array(ST_BANKTRANSFER, ST_BANKPAYMENT, ST_SUPPAYMENT)) && $account_type == 1 && $myrow["amount"]<0)
		label_cell(chq_print_document_link($myrow['trans_no']."-".$myrow['type'], _("Print Cheque"), true, $myrow["type"], ICON_PRINT));
	else
		label_cell("");


	end_row();
 	if ($myrow["amount"] > 0 ) 
 		$debit += $myrow["amount"];
 	else 
 		$credit += $myrow["amount"];

	if ($j == 12)
	{
		$j = 1;
		table_header($th);
	}
	$j++;
}
//end of while loop

start_row("class='inquirybg' style='font-weight:bold'");
label_cell(_("Ending Balance")." - ". $_POST['TransToDate'], "colspan=4");
amount_cell($debit);
amount_cell(-$credit);
//display_debit_or_credit_cells($running_total);
amount_cell($debit+$credit);
label_cell("", "colspan=6");
end_row();
end_table(2);
div_end();
//------------------------------------------------------------------------------------------------

end_page();