<?php


$page_security = 'SA_GLJOURNALINQ';
$path_to_root="../..";

include($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");

include($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");



$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_($help_context = "Transactions Approval Inquiry"), false, false, "", $js);

//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders'))
{
	$Ajax->activate('journal_tbl');
}
//--------------------------------------------------------------------------------------
if (!isset($_POST['filterType']))
	$_POST['filterType'] = -1;


if(isset($_POST['bulk_approve'])){
	$sql = get_sql_for_journal_inquiry_for_approval(get_post('filterType', -1), get_post('FromDate'),
		get_post('ToDate'), get_post('Ref'), get_post('Memo'), check_value('AlsoClosed'), get_post('userid'),null,null,$_POST['EFromDate'],$_POST['EToDate'], $_POST['show_pdc'], $_POST['approval_status']);

	$result = db_query($sql);
	while($trans_row = db_fetch($result)){

		if(isset($_POST['approved_'.$trans_row['trans_no'].'_'.$trans_row['trans_type']])){
			$approve_status = $_POST["approve_status_".$trans_row['trans_no']."_".$trans_row['trans_type']];
			approve_gl_transactions($trans_row['trans_no'], $trans_row['trans_type'], $approve_status, $_SESSION['wa_current_user']->user);
			unset($_POST["approve_status_".$trans_row['trans_no']."_".$trans_row['trans_type']]);
		}

	}
}



div_start('_page_body');
start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();

ref_cells(_("Reference:"), 'Ref', '',null, _('Enter reference fragment or leave empty'));

journal_types_list_cells(_("Type:"), "filterType", null, false, 0, array(ST_BANKPAYMENT => "Bank Payment", ST_SUPPINVOICE => "Supplier Invoice"));
date_cells(_("From:"), 'FromDate', '', null, 0, -1, 0);
date_cells(_("To:"), 'ToDate');
ref_cells(_("Memo:"), 'Memo', '',null, _('Enter memo fragment or leave empty'));

end_row();
start_row(2);

users_list_cells(_("User:"), 'userid', null, false);
if (get_company_pref('use_dimension') && isset($_POST['dimension'])) // display dimension only, when started in dimension mode
	dimensions_list_cells(_('Dimension:'), 'dimension', null, true, null, true);


date_cells2(_("E From"), 'EFromDate', '', null, 0, 0, 0);
date_cells2(_("E To"), 'EToDate', '', null, 0, 0, 0);




trans_approval_list_cells(_("Approval Status"), 'approval_status', null, false);



$trans_type=JOURINQ;
	 
	echo  "<td>". print_journal_inquiry_dashboard_print( 0, get_post('Ref'), _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null,
		 '','', get_post('filterType', -1), get_post('FromDate'), get_post('ToDate'), 
		get_post('Memo'), check_value('AlsoClosed'), get_post('userid'),$_POST['EFromDate'],$_POST['EToDate']   ) ."  "; 
	
	echo  " &nbsp". print_journal_inquiry_dashboard_print( 1, get_post('Ref'), _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','', 
		get_post('filterType', -1), get_post('FromDate'), get_post('ToDate'),  
		get_post('Memo'), check_value('AlsoClosed'), get_post('userid'),$_POST['EFromDate'],$_POST['EToDate']    ) ."</td>"; 

// 	submit_cells('Search', _("Search"), '', '', 'default');
	submit_cells('SearchOrders', _("Search"),'',_('Refresh Inquiry'), 'default');



if (list_updated('userid') || get_post('Ref') || get_post('filterType', -1) )
   {	
$Ajax->activate('_page_body');
$Ajax->activate('journal_tbl');
refresh_pager('_page_body');


}

end_row();


end_table();

echo '<center>'.submit_center('bulk_approve', _("Bulk Approve"), true,_('Bulk Approve'), 'default').'</center>';
br();

function journal_pos($row)
{
	return $row['gl_seq'] ? $row['gl_seq'] : '-';
}

function systype_name($dummy, $type)
{
	global $systypes_array;
	
	return $systypes_array[$type];
}

function view_link($row) 
{
	global $path_to_root;
	return get_trans_view_str($row["trans_type"], $row["trans_no"], "", false, '', '', $path_to_root);
}

function gl_link($row) 
{
	return get_gl_view_str($row["trans_type"], $row["trans_no"]);
}

function edit_link($row)
{

	if(!$_SESSION['wa_current_user']->can_access_page('SA_MODIFYPAYMENT') &&  $row["trans_type"] == ST_BANKPAYMENT)
	{
		return '';
	}

	if(!$_SESSION['wa_current_user']->can_access_page('SA_SUPPLIERINVOICEMODIFY') &&  $row["trans_type"] == ST_SUPPINVOICE)
	{
		return '';
	}

	$ok = true;
	if ($row['trans_type'] == ST_SALESINVOICE)
	{
		$myrow = get_customer_trans($row["trans_no"], $row["trans_type"]);
		if ($myrow['alloc'] != 0 || get_voided_entry(ST_SALESINVOICE, $row["trans_no"]) !== false)
			$ok = false;
	}
	return $ok ? trans_editor_link( $row["trans_type"], $row["trans_no"]) : '';
}

function invoice_supp_reference($row)
{
	return $row['supp_reference'];
}

function prt_link($row){
  	if ($row['trans_type'] == ST_BANKPAYMENT ) 
		return print_document_link($row['trans_no']."-".$row['trans_type'], _("Print Receipt"), true, ST_BANKPAYMENT, ICON_PRINT);
	elseif ($row['trans_type'] == ST_BANKDEPOSIT ) 
		return print_document_link($row['trans_no']."-".$row['trans_type'], _("Print Receipt"), true, ST_BANKDEPOSIT, ICON_PRINT);
  	elseif ($row['trans_type'] == ST_JOURNAL ) 
		return print_document_link($row['trans_no'], _("Print Journal Entry"), true, ST_JOURNAL1, ICON_PRINT);	
  	else
		return '';
}
function get_e_date($row){
	return date('d/m/Y', strtotime($row['stamp']));
}
function get_e_time($row){
	return date('h:i: A', strtotime($row['stamp']));
}
function get_usr_($row){
	return $row['user_id'];
}

function attach($row){
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".$row["trans_type"]."&trans_no=".$row["trans_no"], ICON_ATTACH);
}

function show_pdc_status($row){
	if($row['supp_pdc'] == 1 || $row['cust_pdc']==1)
			return "Yes";
	return "No";
}

function show_memo($row){
	return $row['memo_'];
}

function show_amount($row){
    $amount = $row['amount'];
    if($row['trans_type'] == ST_SUPPINVOICE)
        $amount -= $row['supp_inv_discount'];
    return $amount;
}

function show_approval_status($row){
	global $trans_approval_status;
	return $trans_approval_status[$row['approve_status']];
}

function approval_checkbox($row){

	if($row['approve_status'] == 2 || $row['approve_status'] == 0){

		$first_approval = get_user($_SESSION['wa_current_user']->user)['first_approval'];
		$second_approval = get_user($_SESSION['wa_current_user']->user)['second_approval'];
		
		$value = $row['approve_status'] == 0 ? 2 : $row['approve_status'] == 2 ? : 1;
		$name = "approved_".$row['trans_no']."_".$row['trans_type'];
	
		if($first_approval == 1 && $row['approve_status'] == 0){
			return checkbox(null, $name, null , false, _('Approved this Transaction'))
			. hidden('last['.$row['trans_no'].']', $value, false).
			hidden("approve_status_".$row['trans_no']."_".$row['trans_type'], $value);			
		}

		if($second_approval == 1 && $row['approve_status'] == 2){
			return checkbox(null, $name, null , false, _('Approved this Transaction'))
			. hidden('last['.$row['trans_no'].']', $value, false).
			hidden("approve_status_".$row['trans_no']."_".$row['trans_type'], $value);
		}

	}else{
		return '';
	}

}


$sql = get_sql_for_journal_inquiry_for_approval(get_post('filterType', -1), get_post('FromDate'),
	get_post('ToDate'), get_post('Ref'), get_post('Memo'), check_value('AlsoClosed'), get_post('userid'),null,null,$_POST['EFromDate'],$_POST['EToDate'], $_POST['show_pdc'], $_POST['approval_status']);

$cols = array(
	_("#") => array('fun'=>'journal_pos', 'align'=>'center'), 
	_("Date") =>array('name'=>'tran_date','type'=>'date','ord'=>'desc'),
	_("Type") => array('fun'=>'systype_name'), 
	_("Trans #") => array('fun'=>'view_link'), 
 	_("Counterparty") => array('ord' => ''),
	_("Supplier's Reference") => 'skip',
	_("Reference"), 
	_("PDC") => array('fun'=>'show_pdc_status'),
	_("Amount") => array('fun'=> 'show_amount', 'type'=>'amount'),
	_("Memo") => array('fun'=>'show_memo'),
	_("E Date") => array('fun'=>'get_e_date'),
	_("E Time") => array('fun'=>'get_e_time'),
	_("User")=> array('fun'=>'get_usr_'),
	_("View") => array('insert'=>true, 'fun'=>'gl_link'),
	_("Approval Status") => array('insert'=>true, 'fun'=>'show_approval_status'),
	array('insert'=>true, 'fun'=>'approval_checkbox'),
	array('insert'=>true, 'fun'=>'edit_link'),
	array('insert'=>true, 'fun'=>'prt_link'),
	array('insert'=>true, 'fun'=>'attach'),

);

if (!check_value('AlsoClosed')) {
	$cols[_("#")] = 'skip';
}

if($_POST['filterType'] == ST_SUPPINVOICE) //add the payment column if shown supplier invoices only
{
	$cols[_("Supplier's Reference")] = array('fun'=>'invoice_supp_reference', 'align'=>'center');
}

$table =& new_db_pager('journal_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
div_end();
end_page();