<?php

$page_security = 'SA_PDC_CHEQUE';
$path_to_root = "..";

include($path_to_root . "/includes/db_pager.inc");

include_once($path_to_root . "/includes/ui/allocation_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_($help_context = "PDC Recieve & Issue"), false, false, "", $js);
if(isset($_GET['NewPresentCheq']) || isset($_POST['NewPresentCheq'])){
   
   $_SESSION['present_cheq'] = new items_cart();
   hidden('NewPresentCheq' ,$_GET['NewPresentCheq'] );



}
if ($_GET['Type'] == 'Issue') {
	$_POST['FromBank'] = 4;
	$Ajax->activate('tbl_lines');
}
if ($_GET['Type'] == 'Recieve') {
	$_POST['FromBank'] = 3;
	$Ajax->activate('tbl_lines');
}
//-----------------------------------------------------------------------------------
// Ajax updates
//
global $Ajax;
if (get_post('Search') || list_updated('FromBank') ){
	$Ajax->activate('tbl_lines');
}
//--------------------------------------------------------------------------------------

if(!$_POST['FromBank']  &&  !$_POST['ToBank']){
	$_POST['FromBank']=0;
	$_POST['ToBank']=0;
}

if (!isset($_POST['filterType']))
	$_POST['filterType'] = -1;

start_form();

start_table(TABLESTYLE_NOBORDER,"width='80%'");
start_row();


$myrow2 = get_company_prefs();

$resultBankAccount = get_company_prefs();

// bank_accounts_list_cells(_("From Bank:"), 'FromBank', null, true, true);
// bank_accounts_list_cells(_("To Bank:"), 'ToBank', null, true,false,true );

bank_accounts_list_cells(_("From Bank:"), 'FromBank', null, true, $myrow2["debtors_pdc_act"], $myrow2["creditors_pdc_act"], true);
bank_accounts_list_cells(_("To Bank:"), 'ToBank', null, true, $myrow2["debtors_pdc_act"], $myrow2["creditors_pdc_act"],false,$custBankCurrency, 
	$suppBankCurrency );

ChequeType_cells(_("Cheque type:"), 'checkType', null, "", "", true);


// date_row(_("Date Paid") . ":", 'DatePaid', '', true, 0, 0, 0, null, true);
if (isset($_GET['Type'])) {
	date_cells2(_("From:"), 'FromDate',"","",0,0,0,null,true,0);
}else{
	date_cells(_("From:"), 'FromDate', '', true, 0, 0, 0, null, true);
}


date_cells(_("To:"), 'ToDate', '', true, 0, 0, 0, null, true);


submit_cells('Search', _("Search"), '', '', 'default');
end_row();
end_table();
if(list_updated('FromBank')){
	$Ajax->activate('tbl_lines');
}

function systype_name($dummy, $type){
	global $systypes_array;
	return $systypes_array[$type];
}

function get_bank_name($myrow){
	if(get_post('reverse_trans') == 1)
		$bankAcc = $myrow['previous_bank'];
	else
		$bankAcc = $myrow['bank_act'];

	$sql = "SELECT bank_account_name FROM ".TB_PREF."bank_accounts WHERE id=".db_escape($bankAcc);
	$result = db_query($sql, "could not retreive bank account for");
	return db_fetch($result)['bank_account_name'];
}

function get_bank_transactions($from, $to, $FromBank, $toBank=null, $reverseTrans=0, $checkType=0,$PDC_no=''){
	global $resultBankAccount;
	$pdcStatus = 1;

	if($reverseTrans == 1){
		$transferred = 1;
	}else{
		$transferred = 0;
	}
	if($checkType == 0 || $checkType == 2){
		$transferred = 0;
	}elseif($checkType == 1){
		$transferred = 1;
		$pdcStatus = 0;
	}
	if($checkType == 2){
		$bounce = 1;
	}else{
		$bounce = 0;
	}


	$from = date2sql($from);
	$to = date2sql($to);
	$FromBank = get_account_code($FromBank);

	if($FromBank==$resultBankAccount["debtors_pdc_act"]){
		$transType =ST_CUSTPAYMENT; $transType2 =ST_BANKDEPOSIT;
	}
	elseif($FromBank==$resultBankAccount["creditors_pdc_act"]){
		$transType =ST_SUPPAYMENT;  $transType2 =ST_BANKPAYMENT;
	}

	$sql2 =" SELECT * FROM ".TB_PREF."bank_trans
		WHERE transfered='$transferred' AND pdcStatus='$pdcStatus'  AND (type='$transType' OR type='$transType2') ";
      if ($PDC_no != '') {
      	  $sql2 .= " AND trans_no =  '$PDC_no'";
      }else{
      	if (!$_GET['show']) {
			$sql2 .= " AND pdcDate <= '$to'";
	      if ($from != "") {
	      	  $sql2 .= " AND pdcDate >= '$from'";
	      }
      	}
      }
		$sql2 .= " AND bounce_cheque='$bounce'
		ORDER BY  pdcDate DESC";

    return db_query($sql2,'error');
}

function get_customer_id($trans_no, $type){
	$sql2 =" SELECT debtor_no FROM ".TB_PREF."debtor_trans
		WHERE trans_no = ".db_escape($trans_no)."  AND type = ".db_escape($type)." ";
    $res = db_query($sql2,'error');
    $fetch = db_fetch($res);
    return $fetch['debtor_no'];
}

function get_suuplier_id($trans_no, $type){
	$sql2 =" SELECT supplier_id FROM ".TB_PREF."supp_trans
		WHERE trans_no = ".db_escape($trans_no)."  AND type = ".db_escape($type)." ";
    $res = db_query($sql2,'error');
    $fetch = db_fetch($res);
    return $fetch['supplier_id'];
}


function get_supplier_name1($id){
	$sql = "SELECT supp_name FROM ".TB_PREF."suppliers WHERE supplier_id = ".db_escape($id);
	$result = db_query($sql, "no suppliers found in query get_supplier_name1");
	$myrow = db_fetch($result);
	return $myrow[0];
}

function get_debtor_name1($id){
	$sql = "SELECT name FROM ".TB_PREF."debtors_master WHERE debtor_no = ".db_escape($id);
	$result = db_query($sql, "no customer found in query");
	$myrow = db_fetch($result);
	// display_error($sql);
	return $myrow[0];
}

function get_account_code($id){
	$sql = "SELECT account_code FROM ".TB_PREF."bank_accounts 
	WHERE id = ".db_escape($id);
	$result = db_query($sql, "no bank acc found in get_account_code");
	$myrow = db_fetch($result);
	// display_error($sql);
	return $myrow[0];
}

function get_bankInfo($account_code =null, $id=null){
	$sql = "SELECT * FROM ".TB_PREF."bank_accounts WHERE inactive = 0 ";

	if($account_code!=null){
		$acc_no_flag = strtoupper($account_code);
		$sql .= " AND UPPER(account_code) = ".db_escape($acc_no_flag)." ";
	}
	if($id!=null){
		$sql .= " AND id = ".db_escape($id)." ";
	}
	$result = db_query($sql, "could not get bank get_bankName");
	return db_fetch($result);
}

function bankTransaction($status=null, $myrowTrans_no =null,$transType =null, $fromBank =null,$toBank =null,$transDateTransNo=null,  $prevBank =null, $id =null, $amount =null, $bankAct =null, $clear=0, $bounce=0, $pdcDate =null)
{
	global $Refs;

//____________________________ FOR UPDATE DUE DATE ON TO THE debtor and vendors___________________________
    if($transType ==ST_SUPPAYMENT){
		$supp_id = get_suuplier_id($myrowTrans_no, ST_SUPPAYMENT); // get supplier id
		$name = get_supplier_name1($supp_id); 		  // get supp name
	}
	elseif($transType ==ST_BANKPAYMENT){
		$cust_id = get_customer_id($myrowTrans_no, ST_BANKPAYMENT); // get cusr id
		$name = get_debtor_name1($cust_id);	// get cust name
		if($name == '' || $name == null){
			$supp_id = get_suuplier_id($myrowTrans_no, ST_BANKPAYMENT); // get cusr id
			$name = get_supplier_name1($supp_id);	// get cust name
		}	  
	}elseif($transType ==ST_BANKDEPOSIT){
		$cust_id = get_customer_id($myrowTrans_no, ST_BANKDEPOSIT); // get cusr id
		$name = get_debtor_name1($cust_id);	// get cust name
		if($name == '' || $name == null){
			$supp_id = get_suuplier_id($myrowTrans_no, ST_BANKDEPOSIT); // get cusr id
			$name = get_supplier_name1($supp_id);	// get cust name
		}
	}else{
		$cust_id = get_customer_id($myrowTrans_no, ST_CUSTPAYMENT); // get cusr id
		$name = get_debtor_name1($cust_id); 		  // get cust name
	}
	if($cust_id != null || $cust_id != '')
		$type = SM_CUSTOMER;
	elseif($supp_id != null || $supp_id != '')
		$type = SM_SUPPLIERS;


	// SET DUE DATE ____________________________________________
	if($type == SM_CUSTOMER){
		$sql3 = " UPDATE ".TB_PREF."debtor_trans 
		SET due_date= ".db_escape($pdcDate)."
		WHERE trans_no =".db_escape($myrowTrans_no)."
		AND type=".db_escape($transType)." ";
		db_query($sql3,'error in Query');
	}
	if($type == SM_SUPPLIERS){
		$sql3 = " UPDATE ".TB_PREF."supp_trans  
		SET due_date= ".db_escape($pdcDate)."
		WHERE trans_no =".db_escape($myrowTrans_no)." 
		AND type=".db_escape($transType)." ";
		db_query($sql3,'error in Query');
	}
	// clear cheque____________________________________________
	if($status ==1 ){
		$trans_no =  add_bank_transfer($fromBank, $toBank, $transDateTransNo, $amount ,
		$Refs->get_next(ST_BANKTRANSFER, null,
		$transDateTransNo), null,0, 0, $clear, $bounce, 1 ); // Note: pdc status 1

		/*$sql1 = " UPDATE ".TB_PREF."bank_trans
		SET transfered= 1 ,
		pdcStatus= 0 , 
		bank_act= ".db_escape($toBank)." , 
		trans_date = ".db_escape(date2sql($transDateTransNo)).",
		previous_bank = ".db_escape($toBank).",
		transfered_from_bank = ".db_escape($fromBank)."
		WHERE id =".db_escape($id);
		db_query($sql1,'error in Query');*/
		$sql1 = " UPDATE ".TB_PREF."bank_trans
		SET transfered= 1 ,
		pdcStatus= 0  
		WHERE id =".db_escape($id);
		db_query($sql1,'error in Query');

	}
	return "yes";
}

function bankReverseTransaction( $myrowTrans_no =null,$transType =null, $fromBank =null,$toBank =null,$transDateTransNo=null,  $prevBank =null, $id =null, $amount =null, $bankAct =null, $clear=0, $bounce=0)
{
	global $Refs;
		
	// reverse transaction processing___________________ for bounce cheque

	$trans_no =  add_bank_transfer($toBank,
	$fromBank,
	$transDateTransNo,
	$amount ,
	$Refs->get_next(ST_BANKTRANSFER, null, date2sql($transDateTransNo)), null,0, 0, $clear, $bounce, 1 );

	$sql1 = " UPDATE ".TB_PREF."bank_trans 
		SET transfered= 0 ,
		trans_date = ".db_escape(date2sql($transDateTransNo)).",
		pdcStatus= 1 , 
		bank_act= ".db_escape($fromBank).",
		previous_bank = 0,
		transfered_from_bank = 0,
		bounce_cheque = 1
		WHERE id =".db_escape($id);
	db_query($sql1,'error in Query');

	$sql2 = " UPDATE ".TB_PREF."gl_trans SET account= ".db_escape(get_account_code($fromBank))." 
		WHERE type_no =".db_escape($myrowTrans_no)."  AND type=".db_escape($transType)."
		AND account = ".db_escape(get_account_code($bankAct) )." ";
	db_query($sql2,'error in Query');

	return "yes";
}

function getAllocation( $transNo =null,$transType =null)
{
	global $Refs;
	if($transType == ST_CUSTPAYMENT){
		$sql = " SELECT 
			trans_no_from as payment_no,
			trans_type_from as payment_type, 
			trans_type_to as inv_type, 
			trans_no_to as inv_no

			FROM ".TB_PREF."cust_allocations
			WHERE trans_type_from = ".db_escape($transType)."
			AND trans_no_from = ".db_escape($transNo)." ";
	}
	elseif($transType == ST_SUPPAYMENT){
		$sql = " SELECT 
			trans_no_from as payment_no,
			trans_type_from as payment_type, 
			trans_type_to as inv_type, 
			trans_no_to as inv_no
			FROM ".TB_PREF."supp_allocations
			WHERE trans_type_from = ".db_escape($transType)."
			AND trans_no_from = ".db_escape($transNo)." ";
		}

	$result = db_query($sql,'error in getAllocation Query');
	$ft = db_fetch($result);
	return $ft;
}


function deleteAllocation( $paymentNo =null,$paymentType =null,$invNo =null,$invType =null,$amount =0)
{
	global $Refs;
		
	if($paymentType == ST_CUSTPAYMENT){
		$sql = " SELECT alloc AS total_amount
		FROM ".TB_PREF."debtor_trans
		WHERE trans_no =".db_escape($invNo)."
		AND type =".db_escape($invType)." ";
				
		$res = db_query($sql,'error in deleteAllocation Query');
		$ft = db_fetch($res);
		$leftToAllocate = $ft['total_amount'] - $amount;

		$sql1 = " UPDATE ".TB_PREF."debtor_trans
				SET alloc = '0'
				WHERE trans_no =".db_escape($paymentNo)."
				AND type =".db_escape($paymentType)." ";
		db_query($sql1,'error in deleteAllocation Query');

		$sql2 = " UPDATE ".TB_PREF."debtor_trans
				SET alloc = ".db_escape($leftToAllocate)."
				WHERE trans_no =".db_escape($invNo)."
				AND type =".db_escape($invType)." ";
		db_query($sql2,'error in deleteAllocation Query');

		$sql3 = "UPDATE ".TB_PREF."cust_allocations
				SET amt = '0'
				WHERE trans_no_from =".db_escape($paymentNo)."
				AND trans_type_from =".db_escape($paymentType)." 
				AND trans_no_to =".db_escape($invNo)." 
				AND trans_type_to =".db_escape($invType)." ";
		db_query($sql3,'error in deleteAllocation Query');
	}

	if($paymentType == ST_SUPPAYMENT){
		$sql = " SELECT alloc AS total_amount
			FROM ".TB_PREF."supp_trans
			WHERE trans_no =".db_escape($invNo)."
			AND type =".db_escape($invType)." ";
		
		$res = db_query($sql,'error in deleteAllocation Query');
		$ft = db_fetch($res);

		$leftToAllocate = $ft['total_amount'] +	 $amount;
				

		$sql1 = " UPDATE ".TB_PREF."supp_trans
				SET alloc = '0'
				WHERE trans_no =".db_escape($paymentNo)."
				AND type =".db_escape($paymentType)." ";
		db_query($sql1,'error in deleteAllocation Query');

		$sql2 = " UPDATE ".TB_PREF."supp_trans
				SET alloc = ".db_escape($leftToAllocate)."
				WHERE trans_no =".db_escape($invNo)."
				AND type =".db_escape($invType)." ";
		db_query($sql2,'error in deleteAllocation Query');

		$sql3 = "UPDATE ".TB_PREF."supp_allocations
				SET amt = '0'
				WHERE trans_no_from =".db_escape($paymentNo)."
				AND trans_type_from =".db_escape($paymentType)." 
				AND trans_no_to =".db_escape($invNo)." 
				AND trans_type_to =".db_escape($invType)." ";
		db_query($sql3,'error in deleteAllocation Query');
	}

	return "yes";
}


if(list_updated('FromBank')){
	$Ajax->activate('journal_tbl');
}

if($_POST['Refresh']){
	$Ajax->activate('_page_body');
}

div_start('tbl_lines');
start_table(TABLESTYLE4,"",0,0,0,null,"100%","1px solid #2CABE3;");

$th = array(_("Invoice #"), _("Ref"), _("Person Name"), _("Memo"), _("Date"),_("Clearing Date"), _("Type"), _("Bank Name"),
	_("Amount"), _("Clear"), _("Bounce"));

	$myrow2 = get_company_prefs();
	$bankInfocust = get_bankInfo($myrow2["debtors_pdc_act"]);
	$bankInfosupp = get_bankInfo($myrow2["creditors_pdc_act"]);

	if(get_post('checkType')==1){	//CLEAR
		$th[4] = 'Cleared Date';
		unset($th[5]);
	}
	elseif(get_post('checkType')==2){	//BOUNCE
		$th[4] = 'Bounced Date';
		unset($th[5]);
	}


	table_header($th);
	$k = 0;
	$i=0;
	$j=0;

	$result2 = get_bank_transactions(get_post('FromDate'),get_post('ToDate'),get_post('FromBank'),get_post('ToBank'), $_POST['trans_date'.$myrow["trans_no"]], get_post('checkType'),$_GET['PDC_no']);	
	$array_id=array();
	$array_id2=array();
	while ($myrow = db_fetch($result2)){
		$inpurError = 0;
		$transType = $myrow["type"];
	//___________________________FOR BOUNCE CHEQUE_______________________

		if($_POST['bounce_pdc_cheque'.$myrow["trans_no"]."".$myrow["type"]]==1){
			global $Ajax;
			$status=1; // transfering

		if( strtotime(date2sql($_POST['trans_date'.$myrow["trans_no"]])) > strtotime($myrow['pdcDate']) ){
			display_error(_("Clearing Date should be less than or same as PDC Date "));
			set_focus('pdcDate');
			unset($_POST['bounce_pdc_cheque'.$myrow["trans_no"]."".$myrow["type"]]);
			$Ajax->activate('_page_body');
			$inpurError = 1;
		}
		if($inpurError != 1){
			if($transType == ST_CUSTPAYMENT){
				$getAllocation = getAllocation($myrow['trans_no'] ,$transType) ;	
				$deleteAllocation  = deleteAllocation($getAllocation['payment_no'], $getAllocation['payment_type'], $getAllocation['inv_no'], $getAllocation['inv_type'],  $myrow['amount']);
			}
			if($transType == ST_SUPPAYMENT){
				$getAllocation = getAllocation($myrow['trans_no'] ,$transType) ;	
				$deleteAllocation  = deleteAllocation($getAllocation['payment_no'], $getAllocation['payment_type'], $getAllocation['inv_no'], $getAllocation['inv_type'],  $myrow['amount']);
			}
			$bounceChequeTransaction1 = bankTransaction($status, $myrow['trans_no'] ,$transType , $_POST['FromBank'] ,$_POST['ToBank'] ,	
			$_POST['trans_date'.$myrow["trans_no"]],$_POST['ToBank'] , $myrow['id'] , $myrow["amount"], null, 0, 1, $myrow['pdcDate']) ;								//transaction
			
			$bounceChequeTransaction2 = bankReverseTransaction($myrow['trans_no'],$transType, $_POST['FromBank'] ,$_POST['ToBank'] ,	
			
			$_POST['trans_date'.$myrow["trans_no"]], $myrow['previous_bank'], $myrow['id'] , $myrow["amount"], $myrow['bank_act'], 0, 1   );//reversetransaction

	
			if($bounceChequeTransaction1 =="yes" && $bounceChequeTransaction2 =="yes" ){
				$array_id2[count($array_id)]=$myrow["trans_no"]."".$myrow["type"];
				$Ajax->activate('_page_body');
			}
		}
	}


	//___________________________FOR Clear CHEQUE_______________________

   	if($_POST['clear_pdc_cheque'.$myrow["trans_no"]."".$myrow["type"]]==1){
   		global $Ajax;
		if( strtotime(date2sql($_POST['trans_date'.$myrow["trans_no"]])) > strtotime($myrow['pdcDate']) ){
			display_error(_("Clearing Date should be less than or same as PDC Date "));
			set_focus('pdcDate');
			unset($_POST['clear_pdc_cheque'.$myrow["trans_no"]."".$myrow["type"]]);
			$Ajax->activate('_page_body');
			$inpurError = 1;
		}

		if($inpurError != 1){
			if($_POST['ToBank'] != 0){
				$status=1; // clear
				$clearChequeTransaction = bankTransaction($status, $myrow['trans_no'] ,$transType , $_POST['FromBank'] ,$_POST['ToBank'] ,$_POST['trans_date'.$myrow["trans_no"]],
				$_POST['ToBank'] , $myrow['id'] , $myrow["amount"],null , 1, 0 , $myrow['pdcDate'] ) ;


				if($clearChequeTransaction =="yes"){
				 	$array_id[count($array_id)]=$myrow["trans_no"]."".$myrow["type"];
					$Ajax->activate('_page_body');
				}
 
				// _________ end TRANSACTION HIDE
			} // if toBank  not selected than
			else{
				display_error("There is no bank that have ".$custBankCurrency." Currency");
			}
		
		}
	} // if Cliked clear

	foreach ($array_id as $key => $value) {
		if($myrow["trans_no"]."".$myrow["type"]==$value)
			$lbl=1;
	}
	foreach ($array_id2 as $key => $value) {
		if($myrow["trans_no"]."".$myrow["type"]==$value)
			$lbl2=1;
	}
    if($myrow["type"] ==22){
		$supp_id = get_suuplier_id($myrow["trans_no"], 22); // get supplier id
		$name = get_supplier_name1($supp_id); 		  // get supp name
	}
	elseif($myrow["type"] ==1){
		$cust_id = get_customer_id($myrow["trans_no"], 1); // get cust id
		$name = get_debtor_name1($cust_id);	// get cust name
		if($name == '' || $name == null){
			$cust_id = get_suuplier_id($myrow["trans_no"], 1); // get supp id
			$name = get_supplier_name1($cust_id);	// get supp name
		}	  
	}elseif($myrow["type"] ==2){
		$cust_id = get_customer_id($myrow["trans_no"], 2); // get cust id
		$name = get_debtor_name1($cust_id);	// get cust name
		if($name == '' || $name == null) {
			$cust_id = get_suuplier_id($myrow["trans_no"], 2); // get supp id
			$name = get_supplier_name1($cust_id);	// get supp name
		}	  

	}else{
		$cust_id = get_customer_id($myrow["trans_no"], 12); // get cust id
		$name = get_debtor_name1($cust_id); 		  // get cust name
	}

	$cust_name = get_debtor_name1($cust_id); 		  // get cust name
	$commentss = get_comments($myrow["type"], $myrow["trans_no"]);  // get comment
	
	$commentsss = db_fetch($commentss);	 // fetch comment	
	$bank_name=get_bank_name($myrow);

	if($myrow["type"]==1)
		$trans_Type = "Bank Payment";
	elseif($myrow["type"]==2)
		$trans_Type = "Bank Deposit";
	elseif($myrow["type"]==12)
		$trans_Type = "Customer Payment";
	elseif($myrow["type"]==22)
		$trans_Type = "Supplier Payment";

	label_cell($myrow["trans_no"], "");
	label_cell($myrow["ref"], "style ='width:10%; padding:10px 5px 10px 5px; '");
    label_cell($name, "style ='width:20%; padding:10px 5px 10px 5px; '");
    label_cell($commentsss['memo_'], "style ='width:20%; padding:10px 5px 10px 5px; '");

	if(get_post('checkType')==0){	//UNCLEAR  THEN UPDATE HEADERS

		label_cell(sql2date($myrow["pdcDate"]), "style ='width:10%; padding:10px 5px 10px 5px; '");
		$_POST['trans_date'.$myrow["trans_no"]] = sql2date($myrow["pdcDate"]);
		date_cells(null, 'trans_date'.$myrow["trans_no"],'', null, 0, 0, 0, " ");
	}
	else{
		label_cell(sql2date($myrow["trans_date"]), "style ='width:10%; padding:10px 5px 10px 5px; '");
	}

	label_cell($trans_Type, "style ='width:15%; padding:10px 5px 10px 5px; '");
	label_cell($bank_name, "style ='width:15%; padding:10px 5px 10px 5px; '");
	amount_cell(abs($myrow["amount"]), true);
	if(get_post('checkType') == 1){
  		label_cell("Cleared", " colspan='2' align='center' style ='font-weight: bold; color: white; background: #4CAF50;' ");
    		// label_cell(set_icon(ICON_REMOVE), null, '');
	}
	elseif(get_post('checkType') == 2){
    	label_cell("Bounced", " colspan='2' align='center' style ='font-weight: bold; color: white; background: #f44336;' ");
    		// label_cell(set_icon(ICON_REMOVE), null, '');
	}
	else{

		if($lbl2 == 1){ // clicked on  bounce
    		label_cell("Bounced", " colspan='2' align='center' style ='font-weight: bold; color: white; background: #f44336;' ");
    		// label_cell(set_icon(ICON_ESCAPE), null, '');
    	}
    	else{
   			if($lbl == 1){ // clicked on  clear
    			label_cell("Cleared", " colspan='2' align='center' style ='font-weight: bold; color: white; background: #4CAF50;' ");
    		// label_cell(set_icon(ICON_UPDATE), null, '');
    		}
		    else{
		    	if($myrow["bounce_cheque"] ==1) // already bounce
    				label_cell(set_icon(ICON_ESCAPE), null, '');
    			else
    				check_cells('',"clear_pdc_cheque".$myrow["trans_no"]."".$myrow["type"], check_value("clear_pdc_cheque".$myrow["trans_no"]."".$myrow["type"]), true, 'clear this check', "");
		    }
    	}


		if($lbl == 1){ // clicked on  clear
    		// label_cell(set_icon(ICON_ESCAPE), null, '');
    	}
    	else{
		    if($lbl2 == 1){ // clicked on  bounce
    			// label_cell(set_icon(ICON_REMOVE), null, '');
    		}
    		else{
		    	if($myrow["bounce_cheque"] ==1) // already bounce
    				label_cell("Bounced", null, '');
    			else
					check_cells('',"bounce_pdc_cheque".$myrow["trans_no"]."".$myrow["type"], check_value("bounce_pdc_cheque".$myrow["trans_no"]."".$myrow["type"]), true, 'clear this check', "");
    		}
		}

}


	$lbl = 0;
	$lbl2 = 0;
	end_row();

}// end while

end_table(1);
div_end();
end_form();


end_page();
?>