<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_BANKPAYMENTINVIEW';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");


add_access_extensions();
page(_($help_context = "View Bank Payment"), true);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");

include_once($path_to_root . "/gl/includes/gl_db.inc");


include_once($path_to_root.'/modules/FrontHrm/includes/db/employee_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

if (isset($_GET["trans_no"]) || isset($_POST['trans_no']))
{
    $trans_no = ($_GET["trans_no"])  ? $_GET["trans_no"] :$_POST['trans_no'] ;
}

// get the pay-from bank payment info
$result = get_bank_trans(ST_BANKPAYMENT, $trans_no);

if (db_num_rows($result) != 1)
	display_db_error("duplicate payment bank transaction found", "");

$from_trans = db_fetch($result);

$company_currency = get_company_currency();

$show_currencies = false;

if ($from_trans['bank_curr_code'] != $from_trans['settle_curr'])
{
	$show_currencies = true;
}

display_heading(_("GL Payment") . " #$trans_no",HEAD_COLOR);

echo "<br>";
start_table(TABLESTYLE2, "width='80%'");

if ($show_currencies)
{
	$colspan1 = 1;
	$colspan2 = 7;
}
else
{
	$colspan1 = 3;
	$colspan2 = 5;
}
start_row();

if ($show_currencies)
	label_cells(_("Currency"), $from_trans['bank_curr_code'], "class='tableheader2'");
label_cells(_("Amount"), number_format2(-$from_trans['amount'], user_price_dec()), "class='tableheader2'", "align=right");
label_cells(_("Date"), sql2date($from_trans['trans_date']), "class='tableheader2'",(!$show_currencies)? "colspan='3'": '');
end_row();
start_row();

$bank_row=get_bank_account($from_trans['bank_act']);
// display_error($from_trans['person_id']);
 if($from_trans['person_type_id']==6)
 {
    global $payment_person_types;

// label_cells(_("pay to "),$from_trans['person_id']);
    $advance_salary=($from_trans['advance_salary']) ? 'Advance Salary ' : '';
label_cells(_("To the Order of: "),$from_trans['person_id'] , "class='tableheader2'", "colspan='0'");
label_cells(_(" pay to: "),$payment_person_types[$from_trans['person_type_id']]."  ( ".get_employees($from_trans['person_id'])['name']." ) " .$advance_salary , "class='tableheader2'", "colspan='0'");
// label_cells(_("Employee"),get_employees($from_trans['emp_id'])['name'] , "class='tableheader2'", "colspan='0'");
 }   //get_user($from_trans['person_id'])['user_id']
 elseif ($from_trans['person_type_id']==7) {
      global $payment_person_types;
    label_cells(_(" pay to: "),$payment_person_types[$from_trans['person_type_id']] , "class='tableheader2'", "colspan='3'");
     # code...
 }
else
{ 
  global $payment_person_types;
   label_cells(_(" pay to: "),$payment_person_types[$from_trans['person_type_id']] , "class='tableheader2'", "colspan='0'");
    
    label_cells(_("counter party"), get_counterparty_name(ST_BANKPAYMENT, $from_trans['trans_no']), "class='tableheader2'", "colspan='1'");
}
// label_cells(_("Pay To"), get_counterparty_name(ST_BANKPAYMENT, $from_trans['trans_no']), "class='tableheader2'", "colspan=$colspan1");
if ($show_currencies)
{
	label_cells(_("Settle currency"), $from_trans['settle_curr'], "class='tableheader2'");
	label_cells(_("Settled amount"), number_format2($from_trans['settled_amount'], user_price_dec()), "class='tableheader2'");
}
label_cells(_("Payment Type"), $bank_transfer_types[$from_trans['account_type']], "class='tableheader2'");
end_row();
start_row();
label_cells(_("Reference"), $from_trans['ref'], "class='tableheader2'", "colspan=$colspan2");
end_row();
comments_display_row(ST_BANKPAYMENT, $trans_no);

end_table(1);

$voided = is_voided_display(ST_BANKPAYMENT, $trans_no, _("This payment has been voided."));

$items = get_gl_trans(ST_BANKPAYMENT, $trans_no);

if (db_num_rows($items)==0)
{
	display_note(_("There are no items for this payment."));
}
else
{

	display_heading2(_("Items for this Payment"));
	if ($show_currencies)
		display_heading2(_("Item Amounts are Shown in:") . " " . $company_currency);

    echo "<br>";
    start_table(TABLESTYLE2, "width='80%'");
    $dim = get_company_pref('use_dimension');
    if ($dim == 2)
        $th = array(_("Account Code"), _("Account Description"), _("Dimension")." 1", _("Dimension")." 2",
            _("Amount"), _("Memo"));
    elseif ($dim == 1)
        $th = array(_("Account Code"), _("Account Description"), _("Dimension"),
            _("Amount"), _("Memo"));
    else
        $th = array(_("Account Code"), _("Account Description"),
            _("Amount"), _("Memo"));
	table_header($th);

    $k = 0; //row colour counter
	$total_amount = 0;

    while ($item = db_fetch($items))
    {

		if ($item["account"] != $from_trans["account_code"])
		{
    		alt_table_row_color($k);

        	label_cell($item["account"]);
    		label_cell($item["account_name"]);
            if ($dim >= 1)
                label_cell(get_dimension_string($item['dimension_id'], true));
            if ($dim > 1)
                label_cell(get_dimension_string($item['dimension2_id'], true));
    		amount_cell($item["amount"]);
    		label_cell($item["memo_"]);
    		end_row();
    		$total_amount += $item["amount"];
		}
	}

	label_row(_("Total"), number_format2($total_amount, user_price_dec()),"colspan=".(2+$dim)." align=right", "align=right");

	end_table(1);

	if (!$voided)
		display_allocations_from($from_trans['person_type_id'], $from_trans['person_id'], 1, $trans_no, $from_trans['settled_amount']);
}



//--------------------------------------------------------------------------------------------------------------


//-- show allocate payslip delitail 

 $res = get_all_payroll_alloc_from(ST_BANKPAYMENT,$trans_no);
 // display_error(db_num_rows($res)." asas");
    if( db_num_rows($res)>0 )
   {






   display_heading2(_("Allocated Payslip for this payment "));
   br();

   start_form();



    $id3 = find_submit('_unsettle');
if ($id3 != -1){

// display_error($id3 ." == ".$alloc_row['trans_no_from']."  == ".$_POST['year']);
    global $Ajax;
      // $row2=check_payslip($id3,$_POST['month'],$_POST['year']);
// display_error(ST_PAYSLIP."  == ".$id3);
       $alloc_row = db_fetch(get_all_payroll_alloc_to(ST_PAYSLIP,$id3));
      // echo "<pre>";
      // print_r($alloc_row);

     $sql=" UPDATE ".TB_PREF."bank_trans SET alloc= alloc-".$alloc_row['amt']."  WHERE trans_no=".db_escape($alloc_row['trans_no_from'])." AND type=".db_escape($alloc_row['trans_type_from']) ;
       db_query($sql);

      $sql=" UPDATE ".TB_PREF."emp_payslip_trans SET alloc_amount= alloc_amount-".$alloc_row['amt']."  WHERE id=".db_escape($alloc_row['trans_no_to']) ;
       db_query($sql);
     
     $sql="DELETE FROM ".TB_PREF."payroll_allocations WHERE trans_no_to=".db_escape($alloc_row['trans_no_to'])." AND trans_type_to=".db_escape($alloc_row['trans_type_to']);
      db_query($sql);
     // display_error($sql);
    // add_audit_trail(ST_PAYSLIP, $id3, Today(),'Un settled payslip');



     $Ajax->activate('_page_body');    
    display_notification(_("payslip # ".$id3." has been Un-settled"));

}

   hidden('trans_no',$trans_no);
        start_table(TABLESTYLE2, "width='95%'");
                // $th = array(_("Item Code"), _("Item Description"), _("Quantity"),_("Engineer"), _("Unit"),
                //  _("Price"), _("Discount"), _("Total"), _("Quantity Delivered"),_("Attachments"));
             $th = array( _("#"),_("Payment ID"),_("Emp Name"), _("Basic Salary"), _("Month"), _("Year"), _("Allowance"), _("Deduction"), _("Gross Salary"), _("OverTime Hrs"), _("OT Salary"),
            _("Normal Days"),_("ND Salary") ,_("UPL") ,_("PL") ,_("PL Amount"),_('Total Amount'), _("Left to Allo"), _("This Alloc"),_(""));

                table_header($th);

    while ($row=db_fetch($res)) {



              $result = get_alloc_payslip_by_id($row['trans_no_to']);
                $k = 0;  
            
            while($myrow = db_fetch($result)){


             // print_r($myrow);
                    alt_table_row_color($k);
                      label_cell(viewer_link($myrow['id'],"modules/FrontHrm/view/view_payslip.php?trans_no=".$myrow['emp_id']."&year=".$myrow['year_id']."&month=".$myrow['month_id']));

                       $result=get_all_payroll_alloc_to(ST_PAYSLIP,$myrow['id']) ;
                       $view='';
                       while ($alloc_row=db_fetch($result)) {
                          if($view=='')
                           $view.=viewer_link($alloc_row["trans_no_from"],"gl/view/gl_payment_view.php?trans_no=".$alloc_row["trans_no_from"]);
                          else
                            $view.=' , '.viewer_link($alloc_row["trans_no_from"],"gl/view/gl_payment_view.php?trans_no=".$alloc_row["trans_no_from"]);

                            # code...
                        } 
                       
                        label_cell($view);
                        label_cell(get_employees($myrow['emp_id'])['name']);
                        label_cell($myrow['basic_salary'], "align=right");
                        $item_row=get_item($myrow['item_code']);

                        $month_num = $myrow['month_id'];
                        $month_name = date("F", mktime(0, 0, 0, $month_num, 10));
                        // echo $month_name."\n"; 
                        label_cell($month_name);
                        label_cell(get_selected_years($myrow['year_id']));
                        label_cell($myrow['allowance'], "align=right");
                        label_cell($myrow['deduction'], "align=right");

                        label_cell($myrow['gross_salary'], "align=right");
                
                    label_cell($myrow['overtime_hrs']);
                    label_cell(number_format($myrow['ot_salary'],2), "align=right");
                    label_cell($myrow['normal_days']);
                    label_cell(number_format($myrow['nd_salary'],2), "align=right");
                    label_cell($myrow['upl']);
                      label_cell($myrow['pl']);
                        label_cell($myrow['pl_amount']);
                   label_cell(price_format($myrow['total_salary']));

                        label_cell(price_format($myrow['total_salary']-$myrow['alloc_amount']));
                        // $un_allocated = round((abs($myrow['total_salary']) - $myrow['alloc_amount']), 6);
                
                            label_cell(price_format($myrow['alloc_amount']));
                                $name = "_unsettle" .$myrow['id'];
                               if($myrow['alloc_amount']>0)
                            label_cell(checkbox(null, $name, $value, true,
        _('Set Un settle process payslip'))
        . hidden('last['.$myrow['id'].']', $value, false)."<span style='color:red;'> <strong> Un-settled-payslip </strong></span>");
                            // $is_inv='';
                    
                
                    end_row();
                }

            


        # code...
    }



                end_table();


end_form();



    }












end_page(true, false, false, ST_BANKPAYMENT, $trans_no);
