<?php
	global $path_to_root;
	include_once($path_to_root."/includes/sysnames.inc");

/*
	Security sections groups various areas on both functionality and privilege levels.
	Often analytic inquires are available only for management, and configuration
	for administration or management staff. This is why we have those three
	section type inside near every FA module.

	Section codes 0-99 are reserved for core FA functionalities.
	Every security section can contain up to 256 different areas.
	External modules can extend security roles system by adding rows to 
	$security_sections and $security_areas using section codes >=100.
	Security areas and sections created by extension modules/plugins
	have dynamically assigned 3-byte integer codes. The highest byte is zero
	for sections/areas defined in this file, and extid+1 for those defined 
	by extensions 
*/

// define('SS_SETUP_A', 4<<8); // Setup System
//define('SS_SALES_C',11<<8); // configuration
// define('SS_SALES_A',13<<8); // analytic functions/reports/inquires
// define('SS_SALES_M',14<<8); // Sales of Maintenance
// define('SS_PURCH_C',21<<8);
// define('SS_PURCH_A',23<<8);
// define('SS_PURCH_M',24<<8);
// define('SS_ITEMS_R',32<<8);
// define('SS_ITEMS_M',33<<8);
// define('SS_ITEMS_P',34<<8);
// define('SS_MANUF_A',38<<8);
// define('SS_MANUF_C',39<<8);
// define('SS_ASSETS_A', 42<<8);
// define('SS_ASSETS_C', 43<<8);	
// define('SS_GL_A', 52<<8);
// define('SS_GL_C', 53<<8);
// define('SS_DIM_A', 62<<8);
// define('SS_DIM_C', 63<<8);
// for import transaction

// Payroll Configuration 
/*define('SS_PAYROLL_CONFIG', 72<<11);
define('SS_PAYROLL_MANAGEMENT', 73<<8);
define('SS_PAYROLL_INQUIRY_REPORTS', 74<<8);
define('SS_ATTENDANCE', 75<<12);
define('SS_LEAVE_MANAGEMENT', 76<<13);
define('SS_ALLOW_AND_DEDUCT', 77<<8);
define('SS_LOAN_MANAGEMENT', 78<<8); 
define('SS_EMPLOYEE_MANAGEMENT', 79<<8);


//prem kumar *******
define('SS_LEAVE_MANAGEMENT_SETUP', 80<<13);*/
 


define('SS_SADMIN',	1<<8);	
define('SS_SETUP',	2<<8);	
define('SS_SPEC',	3<<8);	
define('SS_SALES',  12<<8);	
define('SS_PURCH',  22<<8);
define('SS_ITEMS',  31<<8);
define('SS_MANUF',  37<<8);
define('SS_ASSETS',  41<<8);
define('SS_GL',	 51<<8);
define('SS_DIM', 61<<8);
define('SS_CRM',  301<<8);
define('SS_EMAIL', 81<<8); 
define('SS_MODULE', 82<<8);
define('SS_DASHBOARD', 83<<8);
define('SS_IMPORTTRANSACTIONS', 101<<8);
define('SS_ATTACH', 300<<8); 
define('SS_TOPMENU', 302<<8); 
define('SS_TOTALSALES', 304<<8);  	
define('SS_RECEIVABLE', 306<<8); 
define('SS_PAYABLE', 308<<8);
define('SS_PROFIT', 310<<8); 








$security_sections = array(
 	SS_SALES => _("Sales"),
 	SS_PURCH => _("Purchase"),
 	SS_ITEMS => _("Inventory"),
	SS_ASSETS => _("Fixed Assets"),
 	SS_MANUF => _("Manufacturing"),
 	SS_DIM =>   _("Dimensions"),
 	SS_ATTACH =>  _("Attachment"),
	SS_GL => _("Banking & General Ledger"),
 	SS_SADMIN => _("System Administration"),
 	SS_SETUP => _("Company setup"),
 	SS_EMAIL => _("Email"),
 	SS_MODULE => _("Modules"),
 	SS_DASHBOARD => _("Dashboard"),
 	SS_CRM => _("Customer Relationship Management"),
 	SS_TOPMENU => _("Top Menu Bar"),
 	SS_IMPORTTRANSACTIONS => _("Import Transactions"),
	// SS_SETUP_A =>_("System Inquiry & Reports"), // System reports




 	// SS_SPEC => _("Special maintenance"),
 	// SS_SALES_C => _("Sales configuration"),
 	// SS_SALES_A => _("Sales inquires & report"),     // Customer Sales related reports
 	// SS_SALES_M => _("Sales Maintenance"),        // Customer Sales of Maintenance
 // 	SS_PURCH_C => _("Purchase configuration"),
 // 	SS_PURCH_A => _("Purchase inquires & report"),
 // 	SS_PURCH_M => _("Purchase Maintenance"),
 // 	SS_ITEMS_R => _("Inventory Inquiries and Reports"),
 // 	SS_ITEMS_M => _("Inventory Maintenance"),
 // 	SS_ITEMS_P => _("Inventory Pricing and Costs"),
 // 	SS_MANUF_A => _("Manufacturing Inquiries and Reports"),
 // 	SS_MANUF_C => _("Manufacturing Maintenance"),
	// SS_ASSETS_A => _("Fixed Assets Inquiries and Reports"),
	// SS_ASSETS_C => _("Fixed Assets Maintenance"),
	// SS_GL_A => _("Banking & GL Inquiries and Reports"),
	// SS_GL_C => _("Banking & GL Maintenance"),
 // 	SS_DIM_A => _("Dimensions Inquiries and Reports"),
 // 	SS_DIM_C => _("Dimensions Maintenance"),


/*
SS_ATTENDANCE => _("Payroll Attendance"),
SS_LEAVE_MANAGEMENT => _("Leave Management"),
SS_ALLOW_AND_DEDUCT => _("Temp Allow & Deduction"),
SS_LOAN_MANAGEMENT => _("Loan Management"),
SS_PAYROLL_CONFIG => _("Payroll Configuration"),
SS_PAYROLL_MANAGEMENT => _("Payroll Management"),
SS_EMPLOYEE_MANAGEMENT => _("Employee Management"),
SS_PAYROLL_INQUIRY_REPORTS => _("Inquiries And Reports"),

//pk*************
SS_LEAVE_MANAGEMENT_SETUP => _("Leave Management Setup"),


 */	
);

/*
	This table stores security areas available in FA. 
	Key is area identifier used to check user rights, values are
	codes stored for each role in security_roles table and description used
	in roles editor.

	Set of allowed access areas codes is retrieved during user login from
	security_roles table, and cached in user profile.

	Special value 'SA_OPEN' is used for publicly available pages like login/logout.
*/
$security_areas =array(

'SA_ATTACHMENT_HEADING' => array(SS_ATTACH|1, _("<strong>Attachments Transactions</strong>")),
	'SA_ATTACHINQUIRY' => array(SS_ATTACH|21, _("Attach Documents ")),
	'SA_ATTACHINQUIRYDASH' => array(SS_ATTACH|31, _("Document Attachment Inquiry")),
	'SA_ATTACHDOCUMENT' => array(SS_ATTACH|32, _("Allow To Attach Documents")),




//	Top Menu Bar

'SA_TOPMENUHEADING' => array(SS_TOPMENU|1, _("<strong>Top Menu Bar</strong>")),
'SA_QUICKACCESSTOPMENU' => array(SS_TOPMENU|2, _("Quick Access")),
'SA_REPORTQUICKACCESSTOPMENU' => array(SS_TOPMENU|3, _("Report Quick Access")),
'SA_SUPPORTTOPMENU' => array(SS_TOPMENU|4, _("Support")),
'SA_DASHBOARDTOPMENU' => array(SS_TOPMENU|5, _("Dashboards")),
'SA_PDCISSUETOPMENU' => array(SS_TOPMENU|6, _("PDC Issue")),
'SA_PDCRECEIVETOPMENU' => array(SS_TOPMENU|7, _("PDC Receive")),
'SA_EMPDOCEXPTOPMENU' => array(SS_TOPMENU|8, _("Employee Document Expire")),
'SA_CELENDERTOPMENU' => array(SS_TOPMENU|9, _("Calender")),
'SA_NOTIFICATIONTIME' => array(SS_TOPMENU|13, _("Notification Time")),
'SS_ITEMHOTKEYTOPMENU' => array(SS_TOPMENU|10, _("Hot Key Arrangement")),
'SS_SQUAREBOXTOPMENU' => array(SS_TOPMENU|11, _("Square Box")),
'SS_CHANGEPASSWORDTOPMENU' => array(SS_TOPMENU|12, _("Change Password")),


//
//	Site administration
//
	// 'SA_SYSTEM_ADMIN_HEADING' => array(SS_SADMIN|1, _("<strong>System Administration</strong>")),
	// 'SA_SYSTEM_ADMIN_BOLD_HEADING' => array(SS_SADMIN|2, _("<b>Sys</b>")),
	// 'SA_CREATECOMPANY' =>array(SS_SADMIN|3, _("Install/update companies")),
	// 'SA_CREATELANGUAGE' => array(SS_SADMIN|4, _("Install/update languages")),
	// 'SA_CREATEMODULES' => array(SS_SADMIN|5, _("Install/upgrade modules")),
	// 'SA_SOFTWAREUPGRADE' => array(SS_SADMIN|6, _("Software upgrades")),
//
//	Company setup
//
	'SA_COMPANY_SETUP_HEADING' => array(SS_SETUP|1, _("<strong>Company Setup</strong>")),
	'SA_COMP_MAIN_COMP_SET' => array(SS_SETUP|2, _("<b>Company Setup</b>")),
	'SA_MULTISETUPCOMPANY' => array(SS_SETUP|3, _("Multiple Company parameters")),
	'SA_SETUPCOMPANY' => array(SS_SETUP|4, _("Company parameters")),
	'SA_LOYALITY_FESTURES' => array(SS_SETUP|5, _("Loyality Point Features")),
	'SA_SAGNATURE' => array(SS_SETUP|6, _("Signature")),
	'SA_SAGNATUREDASHBOARD' => array(SS_SETUP|7, _("Signature Dashboard")),
	'SA_REPORT_STYLE' => array(SS_SETUP|8, _("Report Style")),
	// 'SA_CALENDER' => array(SS_SETUP|9, _("Celender")),
	'SA_SECROLES' => array(SS_SETUP|10, _("Access level")),
	'SA_USERS' => array(SS_SETUP|11, _("Users setup")),
	'SA_SETUPDISPLAY' => array(SS_SETUP|39, _("Display Setup")),
	'SA_PRINTERS' => array(SS_SETUP|12, _("Printers configuration")),
	
	//jnz
	'SA_AUTO_EMAIL_REPORT' => array(SS_SETUP|14, _("Auto Email Reports")),
	'SA_AUTO_EMAIL_REPORT_DASHBOARD' => array(SS_SETUP|15, _("Auto Email Reports Dashboard")),
	'SA_TRANSACTIONALSMS' => array(SS_SETUP|53, _("Transactional SMS")),
	//jnz
	
	'SA_FORMSETUP' => array(SS_SETUP|17, _("Forms setup")),
	'QUICK_ACCESS' => array(SS_SETUP|18, _("Quick Access")),
	'SA_REPORTSHORTCUT'  => array(SS_SETUP|19, _("Report Shortcuts")),
	'SA_SENDSMS'  => array(SS_SETUP|20, _("Send SMS")),
	'SA_MAILCONFIG'  => array(SS_SETUP|51, _("Mail Configuration")),
	'SA_SEARCH'  => array(SS_SETUP|21, _("Search Bar")),

	'SA_SYSTEM_MISCELL_HEADING' =>array(SS_SETUP|26, _("<strong>Miscellaneous</strong>")),
	'SA_COMP_MISCELL_MAINT' => array(SS_SETUP|27, _("<b>Miscellaneous</b>")),
	'SA_POSSETUP' => array(SS_SETUP|28, _("Point of sales definitions")),
	'SA_PRINTPROFILE' => array(SS_SETUP|29, _("Print profiles")),
	'SA_PAYTERMS' => array(SS_SETUP|30, _("Payment terms")),
	'SA_SHIPPING' => array(SS_SETUP|31, _("Shipping ways")),
	'SA_CRMCATEGORY' => array(SS_SETUP|32, _("Contact categories")),
//
// Special and common functions
//
   'SA_SYSTEM_MAINTAINANCE_HEADING' =>array(SS_SETUP|33, _("<strong>Maintenance</strong>")),
	'SA_COMP_MAIN_MAINT' => array(SS_SETUP|34, _("<b>Maintenance</b>")),
	'SA_VOIDTRANSACTION' => array(SS_SETUP|35, _("Voiding transactions")),
	'SA_BACKUP' => array(SS_SETUP|36, _("Database backup/restore")),
	'SA_VIEWPRINTTRANSACTION' => array(SS_SETUP|37, _("Common view/print transactions interface")),
	'SA_EDITOTHERSTRANS' => array(SS_SETUP|41, _("Edit other users transactions")),
	'SA_CREATECOMPANY' =>array(SS_SETUP|44, _("Install/update companies")),
	'SA_CREATELANGUAGE' => array(SS_SETUP|45, _("Install/update languages")),
	'SA_CREATEMODULES' => array(SS_SETUP|46, _("Install/upgrade modules")),
	'SA_ACTIVE_THEME' => array(SS_SETUP|50, _("Activate Theme")),
	'SA_CHART_OF_ACCOUNTS' => array(SS_SETUP|49, _("Activate Chart Of Account")),
	'SA_SOFTWAREUPGRADE' => array(SS_SETUP|47, _("Software upgrades")),
	'SA_USER_LISTING' => array(SS_SETUP|25, _("User Listing (Report)")),
	'SA_SYSGLAUDITREP' => array(SS_SETUP|23, _("Audit Trail (Report)")),
	'SA_ACCESSREP' => array(SS_SETUP|24, _("Access Level (Report)")),
	'SA_NEW_SALES_STYLE' => array(SS_SETUP|52, _("POS UI Designs")),
	

	'A' => array(SS_SETUP|48, _("<span>-----</span>")),

	// 'SA_ATTACHDOCUMENT' => array(SS_SETUP|28, _("Attaching documents")),
	// 'SA_FOOTER_CONTENT' => array(SS_SETUP|13, _("Footer Content")),
	// 'SA_INVENTORYMOVETYPE'  => array(SS_SETUP|16, _("Inventory movement types")),
	// 'SA_USER_REPORT' => array(SS_SETUP|22,_("System Report Dashboard")),
	
	'SA_CHGPASSWD' => array(SS_SETUP|40, _("Password changes")),// User Access &  top menu bar




//
// Sales related functionality
//
	
//email box
'SA_EMAIL_HEADING' =>array(SS_EMAIL|4, _("<strong>Email</strong>")),
'SS_EMAIL_INBOX' => array(SS_EMAIL|1, _("Inbox")),
'SS_EMPLOYEE_EMAIL' => array(SS_EMAIL|2, _("Compose Email")),
'SS_TASK_DASHBOARD' => array(SS_EMAIL|3, _("TaskDashboard")),


    //SS_MODULE

	'SA_SALES_HEADING' =>array(SS_MODULE|1, _("<strong>SALES - PURCHASE - INVENTORY</strong>")),
	'SS_SALESMODULE' => array(SS_MODULE|2, _("<b>Sales</b>")),
	'SS_SALES_TRANSACTION' => array(SS_MODULE|3, _("Sales Transactions")),
	'SS_SALES_INQUIRY_REPORT' => array(SS_MODULE|4, _("Sales Inquiry & Reports")),
	'SS_SALES_MAINTENANCE' => array(SS_MODULE|5, _("Sales Maintenance")),


	// 'SA_PURCHASE_HEADING' =>array(SS_MODULE|6, _("<strong>Purchases</strong>")),
	'SS_PURCHASEMODULE' => array(SS_MODULE|7, _("<b>Purchases</b>")),
	'SS_PURCHASE_TRANACTION' => array(SS_MODULE|8, _("Purchases Transaction")),
	'SS_PURCHASE_INQUIRY' => array(SS_MODULE|9, _("Purchases Inquiry & Report")),
	'SS_PURCHASE_MAINTANCE' => array(SS_MODULE|10, _("Purchases Maintanance")),

// 'SA_INVENTORY_HEADING' =>array(SS_MODULE|11, _("<strong>Items and Inventory</strong>")),
	'SS_ITEMSANDINVENTORYMODULE' => array(SS_MODULE|12, _("<b>Items and Inventory</b>")),
	'SS_ITEMSANDINVENTORY_TRANSACTION' => array(SS_MODULE|13, _("Items and Inventory Transaction")),
	'SS_ITEMSANDINVENTORY_INQUIRY' => array(SS_MODULE|14, _("Items and Inventory Inquiry & Report")),
	'SS_ITEMSANDINVENTORY_MAINTANANCE' => array(SS_MODULE|15, _("Maintanance")),
	'SS_ITEMSANDINVENTORY_PRICE_AND_COST' => array(SS_MODULE|16, _("Items and Inventory Pricing And Costs")),

'SA_GEN_LEDGER_HEADING' =>array(SS_MODULE|33, _("<strong>GENERAL LEDGER - DIMENSION</strong>")),
	'SS_GENERALLEDGERMODULE' => array(SS_MODULE|34, _("<b>General Ledger</b>")),
	'SS_GENERALLEDGER_TRANSACTION' => array(SS_MODULE|35, _("General Ledger Transaction")),
	'SS_GENERALLEDGER_INQUIRY' => array(SS_MODULE|36, _("General Ledger Inquiry & Report")),
	'SS_GENERALLEDGER_MAINTANANCE' => array(SS_MODULE|37, _("General Ledger Maintanance")),
// 'SA_DIMENSION_HEADING' =>array(SS_MODULE|27, _("<strong>Dimensions</strong>")),
	'SS_DIMENSIONMODULE' => array(SS_MODULE|29, _("<b>Dimensions</b>")),
	'SS_DIMENSION_TRANSACTION' => array(SS_MODULE|30, _("Dimensions Transaction")),
	'SS_DIMENSION_INQUIRY' => array(SS_MODULE|31, _("Dimensions Inquiry & Report")),
	'SS_DIMENSION_MAINTANANCE' => array(SS_MODULE|32, _("Dimensions Maintanance")),

'SA_MANUFACTURE_HEADING' =>array(SS_MODULE|17, _("<strong>MANUFACTURING - FIXED ASSETS </strong>")),
	'SS_MANUFACTURINGMODULE' => array(SS_MODULE|18, _("<b>Manufacturing</b>")),
	'SS_MANUFACTURING_TRANSACTION' => array(SS_MODULE|19, _("Manufacturing Transaction")),
	'SS_MANUFACTURING_INQUIRY' => array(SS_MODULE|20, _("Manufacturing Inquiry & Report")),
	'SS_MANUFACTURING_MAINTANANCE' => array(SS_MODULE|21, _("Manufacturing Maintanance")),

// 'SS_FIXEDASSESTSMODULEHEADING' =>array(SS_MODULE|22, _("<strong>Fixed Assets</strong>")),
	'SS_FIXEDASSESTSMODULE' => array(SS_MODULE|23, _("<b>Fixed Assets</b>")),
	'SS_FIXED_ASSEST_TRANSACTION' => array(SS_MODULE|24, _("Fixed Assets Transaction")),
	'SS_FIXED_ASSEST_INQUIRY' => array(SS_MODULE|25, _("Fixed Assets Inquiry & Report")),
	'SS_FIXED_ASSEST_MAINTANANCE' => array(SS_MODULE|26, _("Fixed Assets Maintanance")),

// 'SS_FIXEDASSESTSMODULEHEADING' =>array(SS_MODULE|22, _("<strong>Fixed Assets</strong>")),
	'SS_CUSTRELMANAGE' => array(SS_MODULE|44, _("<b>Customer Relationship Management</b>")),
	'SS_CRM_TRANSACTION' => array(SS_MODULE|45, _("CRM - Transaction")),
	'SS_CRM_INQ_AND_REP' => array(SS_MODULE|46, _("CRM - Inquiry & Report")),
	'SS_CRM_MAINTENANCE' => array(SS_MODULE|47, _("CRM - Maintanance")),


	// 'SS_DIMENSIONMODULE' => array(SS_MODULE|28, _("Section & Field")),
	
	'SA_SYS_SETUP_HEADING' =>array(SS_MODULE|38, _("<strong>System Configuration</strong>")),
	'SS_SYSTEM_SETUP' => array(SS_MODULE|39, _("System Setup")),

	'SS_SYSTEM_SETUP_REPORT' => array(SS_MODULE|10, _("System Reports")),
    
   'SA_ATTACH_HRM_HEADING' =>array(SS_MODULE|41, _("<strong>HRM - ATTACHMENTS</strong>")), 

   'SS_ATTACHMODULE' => array(SS_MODULE|40, _("<b>Attachments</b>")),
	'SS_ATTACHTRANS' => array(SS_MODULE|42, _("Attachment Transaction")),
	'SS_ATTACHINQANDREP' => array(SS_MODULE|43, _("Attachment Inquiry and Reports")),
	

    //SS_DASHBOARD
'SA_TOPDASHBOARD_HEADING' =>array(SS_DASHBOARD|4, _("<strong>Top-Menu Dashboard</strong>")),

	'SS_COMPANYDASHMODULE' => array(SS_DASHBOARD|1, _("Company Dashboard")),//
	'SS_SALESDASHMODULE' => array(SS_DASHBOARD|2, _("Sales/Revenue Dashboard")),//
	'SS_SALES_INQ_DASHBOARD' => array(SS_DASHBOARD|6,  _("Sales Quotation Inquiry Dashboard")),
	'SS_PURCHDASHMODULE' => array(SS_DASHBOARD|3, _("Purchase Dashboard")),//
	'SS_ITEMDASHMODULE' => array(SS_DASHBOARD|4, _("Items & Inventory Dashboard")),//
	'SS_VATEXISEDASHBOARD' => array(SS_DASHBOARD|5, _("VAT / Exise Dashboard")),//
	'SS_CRMDASHBOARD' => array(SS_DASHBOARD|7, _("CRM Dashboard")),//
	
	
	
	// 'SA_STEMPLATE' => array(SS_SALES_C|6, _("Sales templates")),
'SA_SALESTRANSACTION_HEADING' =>array(SS_SALES|1, _("<strong>SALES TRANSACTION</strong>")), 	
    
    'SA_SALESQUOTE' => array(SS_SALES|2, _("Sales Quotation Entry")),
    'SA_SALESORDER' => array(SS_SALES|3, _("Sales Orders Entry")),
    'SA_SALESDELIVERY' => array(SS_SALES|4, _("Direct Delivery")),
    'SA_SALESINVOICE' => array(SS_SALES|5, _("Direct Invoice")),
    'SA_SALESORDERDELIVERY' => array(SS_SALES|6, _("Delivery Against Sales Orders")),
    'SA_SALESDELIVERIESVIEW' => array(SS_SALES|7, _("Invoice Against Sales Delivery")),
    'SA_SALESTEMPLATEDELIVERY' => array(SS_SALES|8, _("Template Delivery")),
    'SA_SALESINVOICETEMPLATES' => array(SS_SALES|9, _("Template Invoice")),
    'SA_SALESRECURRENT' => array(SS_SALES|10, _("Create and Print Recurrent Invoices")),
    'SA_SALESPAYMNT' => array(SS_SALES|11, _("Customer Payments")),  
    'SA_SALESINVOICEPREPAID' => array(SS_SALES|12, _("Invoice Prepaid Orders")),
    'SA_SALESCREDIT' => array(SS_SALES|13, _("Customer Credit Notes")),
    'NEW_SALES' => array(SS_SALES|24, _("New Sale")),
    'SA_SALESORDERMODIFY' => array(SS_SALES|18, _("Modify Sales Order Entry")),
    'SA_SALESINVOICEEDIT' => array(SS_SALES|19, _("Modify Sales Invoice")),
    'SA_SALESQUOTEMODIFY' => array(SS_SALES|20, _("Modify Sales Quotation")),
    'SA_SALESDELIVERYMODIFY' => array(SS_SALES|21, _("Modify Direct Delivery")),
    'SA_SALESCREDITMODIFY' => array(SS_SALES|22, _("Modify Customer Credit Notes")),
	'SA_SALESINVOICECUSTOMER' => array(SS_SALES|23, _("Modify Customer Payments")),
	'SA_SALESALLOC' => array(SS_SALES|14, _("Allocate Customer Payments")),
	'SA_SALESNEWQUOTETOSALEORDER'=> array(SS_SALES|15, _("New Sales Quotation To Sales Order")),
	'SAlESDELIVERYNUMBER' => array(SS_SALES|16, _("Issue an Invoice for Delivery Note")),
	'SA_SALESCREDITINV' => array(SS_SALES|17, _("Sales credit notes against invoice")),
	'SA_SALESCREDITNOTEREPORT' => array(SS_SALES|64, _("Credit Note Reports")),	
	'SA_FINALINVOICEPAYMENT' => array(SS_SALES|87, _("Final Payment Invoice")),
	'SA_SCHEDULE' => array(SS_SALES|93, _("Schedule Entry")),
	'SA_JOBCARD' => array(SS_SALES|95, _("Job Card Entry")),


	'SA_DISPATACHITEMSAGAINSTSO' => array(SS_SALES|91, _("Dispatch Items Against Sales Order")),


'SA_SALESTRANSVIEW' => array(SS_SALES|53, _("<b>Sales Transactions Internal View</b>")),
	
	'SA_SALESINVOICETRANSVIEW' => array(SS_SALES|84, _("Sales Invoice Internal View")),
	'SA_CUSTOMERCREDTRANSVIEW' => array(SS_SALES|82, _("Customer Credit Note Internal View")),
	'SA_CUSTPAYMTRANSVIEW' => array(SS_SALES|83, _("Customer Payments Internal View")),
	'SA_DELNOTETRANSVIEW' => array(SS_SALES|85, _("Delivery Note Internal View")),
	'SA_SALESORDERANDQUOTETRANSVIEW' => array(SS_SALES|86, _("Sales Order and Sale Quotation Internal View")),





'SA_SALESINQ_REP_HEADING' =>array(SS_SALES|27, _("<strong>SALES INQUIRY AND REPORT</strong>")), 		
	
//Customer Sales Report	
	'SS_SALES_A' => array(SS_SALES|28, _("<span><b>Sales Report</b></span>")),
    'SA_SALES_SUMMARY' => array(SS_SALES|29, _("Sales Summary")),
    'SA_SALES_BY_CUSTOMER' => array(SS_SALES|30, _("Sales By Customer")),
    'SA_SALES_BY_ITEM' => array(SS_SALES|31, _("Sales By Item")),
    'SA_OPEN_SALES_INVOICE' => array(SS_SALES|32, _("Open Sales Invoice")),//pk
	//'SS_CUST_A' => array(SS_SALES|1002, _("Customer")),
	'SA_CUST' => array(SS_SALES|33, _("<span><b>Customer</b></span>")),

	'SA_CUSTBALANCE' => array(SS_SALES|34, _("Customer Balances")),
	'SA_CUST_AGED' => array(SS_SALES|35, _("Aged Customer Analysis")),
	'SA_CUST_DETAIL_LISTING' => array(SS_SALES|36, _("Customer Detail Listing")),
	'SA_DAILY_CLOSING_REPORT' => array(SS_SALES|37, _("Daily Closing")),
	'SA_PRICE_LISTING' => array(SS_SALES|38, _("price listing")),
	'SA_ORDER_STATUS_LISTING' => array(SS_SALES|39, _("Order Status Listing")),
	'SA_SALESMAN_LISTING' => array(SS_SALES|40, _("Salesman Listing")),
	'SA_PRINT_INVOICE' => array(SS_SALES|41, _("Print Invoices")),
	'SA_SALESCREDITNOTEREPORT' => array(SS_SALES|42, _("Print Credit Notes")),
	'SA_PRINT_DELIVERY' => array(SS_SALES|43, _("Print Delivery")),
	'SA_PRINT_STATEMENTS' => array(SS_SALES|44, _("Print Statements")),
	'SA_PRINT_SALE_ORDERS' => array(SS_SALES|45, _("Print Sales Order")),
	'SA_PRINT_SALE_QUOTATION' => array(SS_SALES|46, _("Print Sales Quotation")),
	'SA_PRINT_RECIPTS' => array(SS_SALES|47, _("Print Customer Payment Receipt")),
	'SA_SALESBULKREP' => array(SS_SALES|88, _("Sale Invoice Recipts")),
	'SA_REFUNDDASHBOARD' => array(SS_SALES|89, _("Refund Dashboard")),
	// 'SA_SALESALLOCVIEW' => array(SS_SALES|90, _("Allocate Customer Payments View")), 
	'SA_SALESCUSTPAMENTREPORT' => array(SS_SALES|65, _("Customer Payment Receipts Report A-5")),


// From Spams
	'SA_OPENSALESINVOICE' => array(SS_SALES|66, _("Open Sales Invoices Report")),
	// 'SA_SALESORDERREPORT' => array(SS_SALES|68, _("Sales Order Entry A-5 (Report)")),	
	'SA_SALESANALYTIC' => array(SS_SALES|61, _("Sales Analytical Reports")),




	// 'SA_MODALS' => array(SS_SALES|48,  _("<span><b>Modals</b></span>")),
	// 'SA_SALESORDERVIEW' => array(SS_SALES|54, _("Sales Order & Quotation Internal View")),
	// 'SA_SALESALLOCVIEW' => array(SS_SALES|49, _("Allocate Customer Payments Internal View")), 
	// 'SA_SALESCREDITVIEW' => array(SS_SALES|51, _("View Credit Note Internal View")),
	// 'SA_SALESDISPATCHVIEW' => array(SS_SALES|52, _("Dispatch Internal View")),



	'SA_SLAES_DASHBOARD' => array(SS_SALES|55,  _("<span><b>Dashboard</b></span>")),
	'SA_SALESQUOTATIONINQUIRY' => array(SS_SALES|56, _("Sales Quotation Inquiry")),
	'SA_SALESORDERINQUIRY' => array(SS_SALES|57, _("Sales Order Inquiry")),
	'SA_SALESCUSTOMERINQUIRY' => array(SS_SALES|58, _("Customer Transaction Inquiry")),
	'SA_SALESALLOCINQUIRY' => array(SS_SALES|59, _("Customer Allocation &Inquiry")),
	'SA_CUSTOMERSALESREP' => array(SS_SALES|26,  _("Customer and Sales Reports")),
	'SA_SCHEDULEINQUIRY' => array(SS_SALES|94, _("Schedule Inquiry")),
	'SA_SCHEDULEAGAINSTSO' => array(SS_SALES|96, _("Schedule Againts SO")),





	'SA_OTHER_REPORT_DASHBOARD' => array(SS_SALES|60, _("<span><b>Inquiries</b></span>")),
	'SA_CUSTTRANSINQUIRIES' => array(SS_SALES|62, _("Customer Transactions Reports")),
	'SA_SALESEQUOTATIONREPORT' => array(SS_SALES|63, _("Sales Quotation & Order Report")),
	'SA_CUSTPAYMREP' => array(SS_SALES|78, _("Customer Balances Reports")),



    // 'SA_CUSTANALYSIS' => array(SS_SALES|5, _("Aged Customer Analysis Reports")),
   
    // 'SA_CUSTBULKREP' => array(SS_SALES|6, _("Customer Detail Listing Reports")),

	
	// 'SA_PRICEREP' => array(SS_SALES|21, _("Sales prices listing Reports")),
	// 'SA_SALESBULKREP' => array(SS_SALES|22, _("Order Status Listing Reports")),
	// 'SA_SALESMANREP' => array(SS_SALES|23, _("Salesman Listing Reports")),
	// 'SA_CUSTSTATREP' => array(SS_SALES|24, _("Print Statements Reports")),
	// 'SA_SALESDISPATCHREPORT' => array(SS_SALES|25, _("Direct Sales Delivery Reports")),
	// 'SA_SALESVATREPORT' => array(SS_SALES|17, _("Print VAT Direct Sales Invoice")),//pk
	// 'SA_DAILYCLOSINGREPORT' => array(SS_SALES|31, _("Daily Closing report")),




//Customer Sales Maintenance
'SA_SALESMAINTANANCE_HEADING' =>array(SS_SALES|69, _("<strong>SALES MAINTANANCE</strong>")), 
	'SA_CUSTOMER' => array(SS_SALES|70,  _("Add and Manage Customer")),
	'SA_CUSTOMERBRANCHES' => array(SS_SALES|71, _("Customer Branches")),
	'SA_SALESGROUP' => array(SS_SALES|72, _("Sales Groups")),
    'SA_SRECURRENT' => array(SS_SALES|73, _("Recurrent Invoices")),
    'SA_SALESTYPES' => array(SS_SALES|74, _("Sales types")),
    'SA_SALESMAN' => array(SS_SALES|75, _("Sales Persons")),
    'SA_TECHNICIAN' => array(SS_SALES|104, _("Technician")),
    'SA_SALESAREA' => array(SS_SALES|76, _("Sales Areas")),
    'SA_CRSTATUS' => array(SS_SALES|77, _("Credit Status")),
    // 'SA_CSVIMPORT_CUSTOMER' => array(SS_SALES|79, _("Import CSV Customer")),



'B' => array(SS_SALES|80, _("<span>-----</span>")),
	'INVOICE_FORM_FIELD' => array(SS_SALES|25, _("Add or Remove Feilds Form Invoice Form")),
	'SA_CSVTRANSACTIONS' => array(SS_SALES|81, _("Import Transactions")),
	'SA_SALESCUSTPAMENT' => array(SS_SALES|50, _("Customer Payment Receipts Internal View")),
	'SA_LOYALITY_DASHBOARD' => array(SS_SALES|67,  _("Loyality Points Dashboard")),
	//codi
	// approved
	'SA_SCHEDULEAPPROVED' => array(SS_SALES|97, _("Schedule Approved")),
	//codi


//
// Purchase related functions
//
'SA_PURCHASETRANSACTION_HEADING' =>array(SS_PURCH|1, _("<strong>PURCHASE TRANSACTION</strong>")), 

		'SA_MATERIALREQENTRIES' => array(SS_PURCH|2, _("Material Requisition Entries")),
		'SA_PURCHASEREQENTRIES' => array(SS_PURCH|3, _("Purchase Requisition Entries")),
		'SA_SUPPLIERQUOTATION' => array(SS_PURCH|4, _("Supplier RFQ")),
		'SA_PURCHASEORDER' => array(SS_PURCH|6, _("Purchase order entry")),
		'SA_SUPPSEARCHPO' => array(SS_PURCH|7, _("Outstanding Purchase Orders Maintenance")),
		'SA_GRN' => array(SS_PURCH|8, _("Direct GRN")),
		'SA_SUPPLIERNEWINVOICE' => array(SS_PURCH|9, _("Direct Supplier Invoice")),
		'SA_SUPPLIERPAYMNT' => array(SS_PURCH|10, _("Payments to Suppliers")),
		'SA_SUPPLIERINVOICE' => array(SS_PURCH|11, _("Supplier invoices")),
		'SA_SUPPLIERCREDIT' => array(SS_PURCH|12, _("Supplier credit notes")),
		'SA_SUPPLIERALLOC' => array(SS_PURCH|13, _("Supplier Payments Allocations")),
		// 'SA_SUPPLIER' => array(SS_PURCH|15, _("Suppliers changes")),	
		'SA_PURCHASEORDERMODIFY' => array(SS_PURCH|18, _("Modify Purchase Order Entry")),
		'SA_SUPPLIERINVOICEMODIFY' => array(SS_PURCH|20, _("Modify Supplier Invoices")),
		'SA_SUPPLIERCREDITMODIFY' => array(SS_PURCH|21, _("Modify Supplier Credit Notes")),
		'SA_MODIFYRECEIEVEPURCHASEORDERITEM' => array(SS_PURCH|19, _("Modify Receive Purchase Order Items")),
		'SA_RECEIEVEPURCHASEORDERITEM' => array(SS_PURCH|16, _("Receive Purchase Order Items")),
		'SA_RFQSEND' => array(SS_PURCH|5, _("Send RFQ")),
		'SA_SUPPLIERCREDITINOICE' => array(SS_PURCH|17, _("Supplier Credit Notes to Invoice")),


		'SA_SUPPLIERTRANSVIEW' => array(SS_PURCH|43, _("<b>Internal Views</b>")),
		'SA_SUPPLIERGRNTRANSVIEW' => array(SS_PURCH|44, _("Supplier GRN Internal View")),
		'SA_PURCHASEORDERTRANSVIEW' => array(SS_PURCH|46, _("Purchase Order Internal View")),
		'SA_SUPPLIERINVOICETRANSVIEW' => array(SS_PURCH|49, _("Supplier Invoice Internal View")),
		'SA_SUPPLIERCREDITNOTETRANSVIEW' => array(SS_PURCH|50, _("Supplier Credit Note Internal View")),
		'SA_SUPPLIERPAYMENTTRANSVIEW' => array(SS_PURCH|51, _("Supplier Payment Internal View")),
		'SA_SUPPLIECHARGESTRANSVIEW' => array(SS_PURCH|52, _("Supplier Charges Internal View")),


	

		//Supplier Purchase Inquiries and Reports
		'SA_PURCHASEINQANDREPORT_HEADING' =>array(SS_PURCH|23, _("<strong>PURCHASE INQUIRY & REPORTS</strong>")), 
		'SS_PURCHASE' => array(SS_PURCH|24, _("<span><b>Purchase Reports</b></span>")),
		'SA_SUPPLIER_BALANCE_REPORT' => array(SS_PURCH|25, _("Supplier Balances ")),
		'SA_AGED_SUPPLIER_ANALYSES' => array(SS_PURCH|26, _("Aged Supplier Analyses ")),
		'SA_PURCHASE_SUMMARY_REPORTS' => array(SS_PURCH|27, _("Purchase Summary ")),
		'SA_PAYMENT_REPORT' => array(SS_PURCH|28, _("Payments ")),
		'SA_OUTSTANDING_GRNS' => array(SS_PURCH|29, _("Outstanding GRNs ")),
		'SA_SUPPLIER_DETAIL_LISTING' => array(SS_PURCH|30, _("Supplier Detail Listing ")),
		'SA_PRINT_PURCHASE_ORDER' => array(SS_PURCH|31, _("Print Purchase Order ")),
		'SA_PRINT_REMITTANCES' => array(SS_PURCH|32, _("Print Remittances ")),
		'SA_SUPPINVOICEREPORT' => array(SS_PURCH|23, _("Supplier Invoice Report")),//pk


		'SS_PURCH_DASHBOARD' => array(SS_PURCH|33,_("<span><b>Dashboard</b></span>")),
		'SA_SUPPSEARCHCOMPLETE' => array(SS_PURCH|35, _("Purchase Orders Inquiry Dashboard")),
		'SA_MATERIALREQDASHBOARD' => array(SS_PURCH|36, _("Material Requisition Dashboard")),
		'SA_PURCHASEREQDASHBOARD' => array(SS_PURCH|37, _("Purchase Requisition Dashboard")),
		'SA_COMPARISIONDASHBOARD' => array(SS_PURCH|38, _("Comparision Report Dashboard")),
		'SA_SUPPLIERALLOCINQUIRY' => array(SS_PURCH|39, _("Supplier Allocation Inquiry Dashboard")),
		'SA_SUPPTRANSINQUIRY' => array(SS_PURCH|40, _("Supplier Transaction Inquiry Dashboard")),
		'SA_SUPPTRANSVIEW' => array(SS_PURCH|34, _("Supplier & Purchasing Report Dashboard")),
		'SA_SUPPINQDASHREP' => array(SS_PURCH|55, _("Supplier Inquiry Dashboard Report")),






		// 'SS_PURCH_INTERNALVIEW' => array(SS_PURCH|41, _("<span><b>Internal View</b></span>")),
		// 'SA_SUPPVIEWGRN' => array(SS_PURCH|42, _("Purchase Order Delivery ")),
		// 'SA_SUPPPOINTERNALVIEW' => array(SS_PURCH|43, _("Supplier Purchase Order")),
		// 'SA_SUPPDIRECTPURCHASEVIEW' => array(SS_PURCH|44, _("Supplier Invoice ")),

		// 'SA_SUPPBULKREP' => array(SS_PURCH|22, _("Supplier Document Bulk Reports")),
	
		//'SA_SUPPCREDITVIEW' => array(SS_PURCH|8, _("Supplier Credit Note Internal View")),
// Purchase Maintenance
'SA_PURCHASEMAINTANANCE_HEADING' =>array(SS_PURCH|45, _("<strong>PURCHASE MAINTANANCE</strong>")),
	'SA_SUPPLIER' => array(SS_PURCH|48, _("Suppliers")),
    'SA_SUPCHARGE' => array(SS_PURCH|47, _("Supplier Charges")),


'C' => array(SS_PURCH|78, _("<span>-----</span>")),
		
		'SA_GRNDELETE' => array(SS_PURCH|22, _("Deleting GRN items during invoice entry")),
		// 'SA_SUPPLIERALLOCATE' => array(SS_PURCH|14, _("Allocate Supplier Payment or Credit Note")), // No Search Found



// Inventory Transactions
'SA_INVENTORYTRANSACTION_HEADING' =>array(SS_ITEMS|1, _("<strong>INVENTORY TRANSACTION</strong>")),
    'SA_LOCATIONTRANSFER' => array(SS_ITEMS|2, _("Inventory location transfers")),
    'SA_INVENTORYADJUSTMENT' => array(SS_ITEMS|3, _("Inventory adjustments")),
	'SA_INVENTORY_INTERNAL_VIEWS' => array(SS_ITEMS|22, _("<b>Inventory Internal Views</b>")),
	'SA_INVENTORYADJST_INTERNAL_VIEWS' => array(SS_ITEMS|45, _("Inventory Adjustment Internal View")),
	'SA_INVENTORYLOCATION_INTERNAL_VIEWS' => array(SS_ITEMS|46, _("Inventory Location Internal View")),


//Inquiries and Reports
'SA_INVENTORYINQUIRYREPORT_HEADING' =>array(SS_ITEMS|4, _("<strong>INVENTORY INQUIRY AND REPORT</strong>")),

   'SA_INVENTORY' => array(SS_ITEMS|5, _("<span><b>Report</b></span>")),
	'SA_INVENTORY_VALUATION_REPORT' => array(SS_ITEMS|6, _("Inventory valuation ")),
	'SA_INVENTORY_PLANNING_REPORT' => array(SS_ITEMS|7, _("Inventory Planning ")),
	'SA_STOCK_CHECK_SHEET' => array(SS_ITEMS|8, _("Stock Check Sheets ")),
	'SA_INVENTORY_SALE_REPORT' => array(SS_ITEMS|9, _("Inventory Sales ")),
	'SA_GRN_VALUATION_REPORT' => array(SS_ITEMS|10, _("GRN Valuation ")),
	'SA_INVENTORY_PURCHASING_REPORT' => array(SS_ITEMS|11, _("Inventory Purchasing ")),
	'SA_INVENTORY_PURCHASING_SUMMARY_REPORT' => array(SS_ITEMS|12, _("Inventory Purchasing Summary ")),
	'SA_INVENTORY_HISTORY_REPORT' => array(SS_ITEMS|13, _("Inventory History ")),
	'SA_INVENTORY_MOVEMENT_REPORT' => array(SS_ITEMS|14, _("Inventory Movement ")),
	'SA_COSTED_INVENTORY_MOVEMENT_REPORT' => array(SS_ITEMS|15, _("Costed Inventory Movement ")),
	'SA_INVENTORY_SALES_SUMMARY_REPORT' => array(SS_ITEMS|16, _("Item Sales Summary ")),
	'SA_INVENTORYADJSTMENTREPORT' => array(SS_ITEMS|50, _("Print Location and Adjustment Report")),
	'SA_INVENTORYITEMSTATUS' => array(SS_ITEMS|51, _("Inventory Item Status Report")),	
	'SA_INVENTORYITEMMOVEMENT' => array(SS_ITEMS|51, _("Inventory Item Movement Report")),	

	'SA_INVENTORY_DASHBOARD' => array(SS_ITEMS|17, _("<span><b>Dashboards</b></span>")),
	'SA_ADJUST_TRANSFER_DASH' => array(SS_ITEMS|18, _("Inventory Adjustment/Location Transfer Dashboard")),
	'SA_ITEMSMOVEMENTS' => array(SS_ITEMS|19, _("Inventory Item Movements Dashboard")),
	'SA_ITEMSSTATVIEW' => array(SS_ITEMS|21, _("Inventory Item Status Dashboard")),
	'SA_ITEMSTRANSVIEW' => array(SS_ITEMS|20, _("Inventory Reports Dashboard")),
	'SA_LINKITEMS' => array(SS_ITEMS|44, _("Link Items")),




//
// Inventory Maintenance
//
'SA_INVENTORYMAINTANANCE_HEADING' =>array(SS_ITEMS|27, _("<strong>INVENTORY MAINTANANCE</strong>")),

	'SA_ITEM' => array(SS_ITEMS|28, _("Stock items add/edit")),
	'SA_FORITEMCODE' => array(SS_ITEMS|29, _("Foreign item codes entry")),
	'SA_SALESKIT' => array(SS_ITEMS|30, _("Sales kits")),
	'SA_ITEMCATEGORY' => array(SS_ITEMS|31, _("Item categories")),
	'SA_INVENTORYLOCATION' => array(SS_ITEMS|32, _("Inventory locations")),
	'SA_UOM' => array(SS_ITEMS|33, _("Units of measure")),
	'SA_REORDER' => array(SS_ITEMS|34, _("Reorder levels")),
	'SA_SPECIFICATION' => array(SS_ITEMS|35, _("Create Specifications")),
	'SA_SPECIFICATION' => array(SS_ITEMS|36, _("Specifications Dashboard")),
	'SA_SPECVIEW' => array(SS_ITEMS|37,  _("Specification view")),
	'SA_HOTKEYARR' => array(SS_ITEMS|38,  _("Hotkey Arrangement")),



//Pricing and Costs
'SA_INVENTORYPRICINGCOSTS_HEADING' =>array(SS_ITEMS|39, _("<strong>PRICING AND COSTS</strong>")),
	'SA_SALESPRICE' => array(SS_ITEMS|40, _("Sales Pricing")),
	'SA_PURCHASEPRICING' => array(SS_ITEMS|41, _("Purchasing Pricing")),
	'SA_STANDARDCOST' => array(SS_ITEMS|42, _("Standard Costs")),



'D' => array(SS_ITEMS|43, _("<span>-----</span>")),
	// 'SA_INVENTORY_INTERNAL_VIEWS' => array(SS_ITEMS|22, _("<span><b>Internal Views</b></span>")),
	// 'SA_ITEMSINVENTORYLOCATIONS' => array(SS_ITEMS|23, _("Inventory Locations Internal View")),
	// 'SA_ITEMSVIEWADJUSTMENT' => array(SS_ITEMS|24, _("Inventory Adjustment Internal View")),	
	'SA_ITEMSANALYTIC' => array(SS_ITEMS|25, _("Items analytical reports and inquiries")),	
	'SA_ITEMSSPECIFICATION' => array(SS_ITEMS|26, _("Items Specifications")),	



//Manufacturing Transactions
'SA_MANIFACTURETRANSACTION_HEADING' =>array(SS_MANUF|1, _("<strong>MANUFACTURING TRANSACTION</strong>")),
	'SA_WORKORDERENTRY' => array(SS_MANUF|2, _("Work order entry")),
	'SA_MANUFOUTSTANDVIEW' => array(SS_MANUF|3, _("Outstanding Work Orders")),
	
	'SA_MANUFINTERNALVIEW' => array(SS_MANUF|15, _("<b>Internal Views</b>")),

	'SA_WORKORDERINTENALVIEW' => array(SS_MANUF|25, _("Work Order Internal View")),
	'SA_WORKORDERISSUEINTVIEW' => array(SS_MANUF|27, _("Work Order Issue Internal View")),
	'SA_WORKORDERPRODUCTIONINTVIEW' => array(SS_MANUF|26, _("Work Order Production Internal View")),


	

//Manufacturing Inquiries and Reports
'SA_MANIFACTUREINQUIRY_HEADING' =>array(SS_MANUF|4, _("<strong>MANUFACTURING INQUIRY AND REPORT</strong>")),
'SA_MANUF_REPORTS' => array(SS_MANUF|5, _("<span><b>REPORTS</b></span>")),
	'SA_BOMLISTREP' => array(SS_MANUF|6, _("Bill of Material Listing")),
	'SA_WORKORDERLISTINGREP' => array(SS_MANUF|7, _("Work Order Listing")),
	'SA_MANUFORDERREP' => array(SS_MANUF|8, _("Print Work Orders")),

'SA_MANUF_DASHBOARD' => array(SS_MANUF|24, _("<span><b>Dashboards</b></span>")),
	'SA_WORKORDERCOST' => array(SS_MANUF|9, _("Costed Bill Of Material Inquiry")),
	'SA_WORKORDERUSEDINQUIRY' => array(SS_MANUF|10, _("Inventory Item Where Used Inquiry")),
	'SA_MANUFWORKORDER' => array(SS_MANUF|11, _("Work Order Inquiry")),
   'SA_MANUFTRANSVIEW' => array(SS_MANUF|17, _("Manufacturing Reports")),  

// 'SA_MANUF_INTERALVIEW' => array(SS_MANUF|25, _("<span><b>Internal Views</b></span>")),
	// 'SA_MANUFORDERINTVIEW' => array(SS_MANUF|16, _("Work Order Entry Internal View")),

	'SA_MANUFISSUE' => array(SS_MANUF|12, _("Material issues Entry")),
	'SA_MANUFRECEIVE' => array(SS_MANUF|13, _("Final product receive")),
	'SA_MANUFRELEASE' => array(SS_MANUF|14, _("Work order releases")),
	'SA_WORKORDERANALYTIC' => array(SS_MANUF|18, _("Work order analytical reports and inquiries")),
	'SA_MANUFBULKREP' => array(SS_MANUF|19, _("Work Order Bulk Reports")),
	

//
// Manufacturing Maintenance
//
'SA_MANIFACTUREMAINTANANCE_HEADING' =>array(SS_MANUF|20, _("<strong>MANUFACTURING MAINTANANCE</strong>")),
	'SA_BOM' => array(SS_MANUF|21, _("Bill of Materials")),
	'SA_MODIFYBOM' => array(SS_MANUF|22, _("Modify Bill of Materials")),
	'SA_WORKCENTRES' => array(SS_MANUF|23, _("Manufacture work centres")),


//
// Fixed Asset transactions
//
'SA_FIXASSETTRANS_HEADING' =>array(SS_ASSETS|1, _("<strong>FIXED ASSETS TRANSACTION</strong>")),
	'SA_ASSETTRANSFER' => array(SS_ASSETS|3, _("Fixed Assets location transfers")),
	'SA_ASSETDISPOSAL' => array(SS_ASSETS|4, _("Fixed Assets disposals")),
    'SA_DEPRECIATION' => array(SS_ASSETS|5, _("Process Depreciation")),
    'SA_FIXEDASSETPURCH' => array(SS_ASSETS|14, _("Fixed Assets Purchase")),
    'SA_FIXEDASSETSALE' => array(SS_ASSETS|15, _("Fixed Assets Sale")),

//
// Fixed Asset Inquiries and Reports
//
'SA_FIXASSETINQUIRY_HEADING' =>array(SS_ASSETS|7, _("<strong>FIXED ASSETS INQUIRY AND REPORT</strong>")),
	'SA_FIXEDASSETMOVEMENT' => array(SS_ASSETS|2, _("Fixed Assets Movements")),
	'SA_FIXEDASSETINQUIRY' => array(SS_ASSETS|16, _("Fixed Assets Inquiry")),
	'SA_FIXEDASSETREPORT' => array(SS_ASSETS|17, _("Fixed Assets Reports")),
	'SA_ASSETSANALYTIC' => array(SS_ASSETS|8, _("Fixed Assets Valuation Report")),


//
// Fixed Assets Maintenance
//
'SA_FIXASSETMAINTANANCE_HEADING' =>array(SS_ASSETS|9, _("<strong>FIXED ASSETS MAINTANANCE</strong>")),
	'SA_ASSET' => array(SS_ASSETS|10, _("Fixed Assets")),
	'SA_ASSETCATEGORY' => array(SS_ASSETS|11, _("Fixed Assets categories")),
	'SA_ASSETCLASS' => array(SS_ASSETS|12, _("Fixed Assets classes")),
	'SA_ASSETLOCATION' => array(SS_ASSETS|18, _("Fixed Assets Location")),



'E' => array(SS_ASSETS|13, _("<span>-----</span>")),
   'SA_ASSETSSTOCKINQUIRY' => array(SS_ASSETS|6, _("Fixed Assets Stock Inquiry")),


//
// Banking and General Ledger Transactions
//  

'SA_GLTRANSACTION_HEADING' =>array(SS_GL|1, _("<strong>GENERAL LEDGER TRANSACTION</strong>")),
	'SA_PAYMENT' => array(SS_GL|2, _("Bank payments")),
	'SA_DEPOSIT' => array(SS_GL|3, _("Bank deposits")),
	'SA_BANKTRANSFER' => array(SS_GL|4, _("Bank account transfers")),
	'SA_JOURNALENTRY' => array(SS_GL|5, _("journal entries")),
	'SA_BUDGETENTRY' => array(SS_GL|6, _("Budget Entry")),
	'SA_RECONCILE' => array(SS_GL|7, _("Bank reconciliation")),
	'SA_ACCRUALS' => array(SS_GL|8, _("Revenue / Cost Accruals")),			
	'SA_PDC_CHEQUE' => array(SS_GL|15, _("PDC Management")),
	'SA_BANKJOURNAL' => array(SS_GL|9, _("Journal Entries to Bank related Accounts")),	
	'SA_MODIFYPAYMENT' => array(SS_GL|12, _("Modify Bank Payments")),
	'SA_MODIFYDEPOSIT' => array(SS_GL|13, _("Modify Bank Deposits")),
	'SA_MODIFYJOURNALENTRY' => array(SS_GL|77, _("Modify journal Entries")),
	'SA_MODIFYBANKTRANSFER' => array(SS_GL|78, _("Modify Bank Transfer")),


	'SA_BANKTRANSVIEW' => array(SS_GL|10, _("<b>Bank Transactions Internal View</b>")),
	'SA_BANKPAYMENTINVIEW' => array(SS_GL|73, _("Bank Payment Internal View")),
	'SA_BANKDEPOSITINTVIEW' => array(SS_GL|74, _("Bank Deposit Internal View")),
	'SA_BANKTRANSFERINTERNALVIEW' => array(SS_GL|75, _("Bank Transfer Internal View")),
	'SA_JOURNALENTRYINTVIEW' => array(SS_GL|76, _("Journal Entry Internal View")),




//
// Banking and General Ledger Inquiries and Reports

'SA_GLINQUIRY_HEADING' =>array(SS_GL|16, _("<strong>GENERAL LEDGER INQUIRY AND REPORT</strong>")),
	'SA_GENERAL_LEDGER' => array(SS_GL|17, _("<span><b>Reports</b></span>")),
	'SA_BANKSTATEMENTREP' => array(SS_GL|40, _("Bank Statement Reports")),
	'SA_BANKPDCCHECKREP' => array(SS_GL|71, _("PDC Cheque")),
	'SA_BANKSTATERECREP' => array(SS_GL|47, _("Bank Statement w/ Reconcile Reports")),
	'SA_CASHFLOWSUMMARY' => array(SS_GL|171, _("Cash Flow Report (Summary)")),
	'SA_CASHFLOW' => array(SS_GL|172, _("Cash Flow Report")),
	'SA_GLCHARTACCREP' => array(SS_GL|18, _("Chart of Accounts ")),
	'SA_GLJOURNALENTYREP' => array(SS_GL|19, _("List of Journal Entries ")),
	'SA_GLACCTRANSREP' => array(SS_GL|20, _("GL Account Transactions ")),
	'SA_ANNUALEXPREP' => array(SS_GL|21, _("Annual Expense Breakdown ")),
	'SA_ANNUALEXPNEWREP' => array(SS_GL|22, _("Annual Expanse Breakdown New ")),
	'SA_GLBLNCSHEET' => array(SS_GL|23, _("Balance Sheet ")),
	'SA_GLBLNCSHEETGRPLEV' => array(SS_GL|24, _("Balance Sheet By Group Level")),
	'SA_GLPROFITLOSSREP' => array(SS_GL|25, _("Profit and Loss Statement ")),
	'SA_GLPROFITLOSSREPGRPLEV' => array(SS_GL|26, _("Profit and Loss Statement  By Group level ")),
	'SA_GLPROFITLOSSNEWREP' => array(SS_GL|27, _("Profit and Loss Statement New ")),
	'SA_GLTRAILBLNC' => array(SS_GL|28, _("Trial Balance ")),
	'SA_GLTRAILBLNCGRPLEV' => array(SS_GL|29, _("Trial Balance By Group Level ")),   
	'SA_GLTAXREP' => array(SS_GL|30, _("Tax ")),
	// 'SA_GLAUDITREP' => array(SS_GL|31, _("Audit Trail ")),
	// 'SA_GLACCESSLEVEL' => array(SS_GL|32, _("Access Level ")),
	'SA_GLVOID_TRANS' => array(SS_GL|33, _("Void Transaction ")),

	// From Spams
	'SA_GLJOURNLAREP' => array(SS_GL|48, _("GL Journal Entries Reports")),
	'SA_PAYMENT_VOUCHER_REPORT' => array(SS_GL|50, _("Bank Payment Report")),
	'SA_PAYMENT_DEPOSITE_REPORT' => array(SS_GL|51, _("Bank Deposite Report")),
//=========




	//Access Level

	'SA_GENERAL_LEDGER_DASHBOARD' => array(SS_GL|34, _("<span><b>Dashboards</b></span>")),

	'SA_GLJOURNALINQ' => array(SS_GL|35, _("Journal Inquiry")),
	'SA_GLACCOUNTINQUIRY'=> array(SS_GL|36, _("General Ledger Inquiry")),
	'SA_BANKINQUIRY'=> array(SS_GL|37, _("Bank Account Inquiry")),
	'SA_GLTRIALBLNCE' => array(SS_GL|81, _("Trail Balance")),
	'SA_GLBLANCESHEET' => array(SS_GL|38, _("Balance Sheet Drilldown")),
	'SA_GLPROFITLOSS' => array(SS_GL|39, _("Profit & Loss Drilldown")),
	'SA_BANKREP' => array(SS_GL|41, _("Banking Reports")),
	'SA_GLREP' => array(SS_GL|42, _("GL Reports")),
	'SA_JOURNALINQDASHBREP' => array(SS_GL|79, _("Journal Inquiry Dashboard Report")),
	'SA_JOURNALLEDGERINQDASHBREP' => array(SS_GL|79, _("Journal Ledger Inquiry Dashboard Report")),
	'SA_BANKSTATEMENTDASHBREP' => array(SS_GL|80, _("Bank Statement Dashboard Report")),


	// 'SA_BANKKINGREP' => array(SS_GL|72, _("Banking Reports")),



	// 'SA_GENERAL_LEDGER_INTERNAL_VIEW' => array(SS_GL|43,_("<span><b>Internal Views</b></span>")),


    

//
// Banking and General Ledger Maintenance
//

'SA_GLIMAINTANANCE_HEADING' =>array(SS_GL|52, _("<strong>GENERAL LEDGER MAINTANANCE</strong>")),

	'SA_BANKACCOUNT' => array(SS_GL|53, _("Bank accounts")),
	'SA_QUICKENTRY' => array(SS_GL|54, _("Quick Entries")),
	'SA_GLACCOUNTTAGS' => array(SS_GL|55, _("GL Account tags")),
	'SA_CURRENCY' => array(SS_GL|56, _("Currencies")),
	'SA_EXCHANGERATE' => array(SS_GL|57, _("Exchange Rates")),
	'SA_GLACCOUNT' => array(SS_GL|58, _("GL Accounts")),
	'SA_GLACCOUNTGROUP' => array(SS_GL|59, _("GL Account Groups")),
	'SA_GLACCOUNTCLASS' => array(SS_GL|60, _("GL account classes")),
	'SA_GLCLOSE' => array(SS_GL|61, _("Closing GL transactions")),
	'SA_REVACURRENCIES' => array(SS_GL|62, _("Revaluation of Currency Accounts")),
	'SA_ITEMTAXTYPE' => array(SS_GL|63, _("Item tax type definitions")),		
	'SA_TAXRATES' => array(SS_GL|64, _("Tax rates")),
	'SA_TAXGROUPS' => array(SS_GL|65, _("Tax groups")),
	'SA_FISCALYEARS' => array(SS_GL|66, _("Fiscal years maintenance")),
	'SA_GLSETUP' => array(SS_GL|67, _("Company GL setup")),	
	'SA_GLREOPEN' => array(SS_GL|68, _("Reopening GL transactions")), // see below
	'SA_MULTIFISCALYEARS' => array(SS_GL|69, _("Allow entry on non closed Fiscal years")),
	'SA_CSVTRANSACTIONS' => array(SS_IMPORTTRANSACTIONS|101, _("Import Transactions")),



'F' => array(SS_GL|70, _("<span>-----</span>")),

	// 'SA_MODIFYBANKTRANSFER' => array(SS_GL|11, _("Modify Bank Account Transfers")),

	// 'SA_REFUNDDASHBOARD' => array(SS_GL|14, _("Refund Dashboard")),

	// 'SA_BANKPAYMENTINVIEW' => array(SS_GL|44, _("GL Payment Internal View")),
	// 'SA_BANKDEPOSITINTVIEW' => array(SS_GL|45, _("GL Deposit Internal View")),
	// 'SA_GLTRANSVIEW'=> array(SS_GL|46, _("GEN Internl View")),
	'SA_GLANALYTIC' => array(SS_GL|49, _("GL analytical reports and inquiries")),





// Dimensions
//  
'SA_DIMTRANS_HEADING' =>array(SS_DIM|1, _("<strong>DIMENSION TRANSACTION</strong>")),
	'SA_DIMENSION' => array(SS_DIM|2, _("Dimension Entry")),
	'SA_DIMTRANSVIEW' => array(SS_DIM|3, _("Outstanding Dimensions")),
	'SA_DIMTEDIT' => array(SS_DIM|11, _("Modify Dimension Entry")),

//
// Dimensions Inquiries and Reports
//   
'SA_DIMINTERNAL_HEADING' =>array(SS_DIM|4, _("<strong>DIMENSION INQUIRY AND REPORT</strong>")),

	'SA_DIMTRANSVIEWINQUIRY' => array(SS_DIM|5, _("Dimension Inquiry")),
	'SA_DIMENSIONREP' => array(SS_DIM|8, _("Dimension Reports")),
	'SA_DIMTRANSINTERNALVIEW' => array(SS_DIM|6, _("Dimension Inquiry Internal View")),
	'SA_DIMINQUIRYREPORT' => array(SS_DIM|7, _("Search Dimension Dashboard Report")),
	'SA_DIMSUMMREPORT' => array(SS_DIM|12, _("Dimension Summary Report")),
//
// Dimensions Maintenance
//
'SA_DIMMAINTANANCE_HEADING' =>array(SS_DIM|9, _("<strong>DIMENSION MAINTANANCE</strong>")),

	'SA_DIMTAGS' => array(SS_DIM|10, _("Dimension tags")),


'SA_CRM_MODULE_TRANSACTION_HEADING' =>array(SS_CRM|1, _("<strong>CRM - Transaction</strong>")),
	'SA_CRM_CONTACT_FORM' => array(SS_CRM|2, _("Contact Form")),
	'SA_CRM_OPPORTUNITY_FORM' => array(SS_CRM|3, _("Opportunity Form")),
	'SA_COMPLAINTENTRY' => array(SS_CRM|4, _("Complaint Entry")),
	'SA_SUBAGREEMENT' => array(SS_CRM|13, _("Subscription Agreement")),
	'SA_REALESTATEFORM' => array(SS_CRM|15, _("Real Estate Form")),

'SA_CRM_MODULE_INQUIRY_HEADING'=>array(SS_CRM|5,_("<strong>CRM - Inquiry and Reports</strong>")),
	'SA_CLIENTDASHBOARD' => array(SS_CRM|11, _("Client Manager Dashboard")),
	'SA_RETENTIONDASHBOARD' => array(SS_CRM|12, _("Retention Dashboard")),
	'SA_CRM_CONTACT_INQUIRY' => array(SS_CRM|6, _("Contact Person Transaction")),
	'SA_CRM_OPPORTUNITY_INQUIRY' => array(SS_CRM|7, _("Opportunity Inquiry")),
	'SA_COMPLAININQUIRY' => array(SS_CRM|8, _("Complain Inquiry")),
	'SA_REALESTATEINQUIRY' => array(SS_CRM|16, _("Real Estate Inquiry")),
	'SA_DELETE'  => array(SS_CRM|21, _("Delete Buyer And Seller Form")),
	

'SA_CRM_MODULE_MAINTENANCE_HEADING'=>array(SS_CRM|9,_("<strong>CRM - Maintenance</strong>")),
	'SA_COMPLAINTTYPE' => array(SS_CRM|10, _("Complaint Type")),
	'SA_AGREEMENT_PRICING' => array(SS_CRM|14, _("Agreement Pricing")),
	'SA_SOURCERECORD' => array(SS_CRM|17, _("Source Record")),
	'SA_INQUIRYTYPE' => array(SS_CRM|18, _("Inquiry Type")),






);


	// Payroll Attendance--

/*  'SA_ATTENDANCE' => array(SS_ATTENDANCE|1, _("Attendance")),
  'SA_IMPORT_ATTENDANCE' => array(SS_ATTENDANCE|2, _("Import Attendance")),
  'SA_TIME_SHEET' => array(SS_ATTENDANCE|3, _("Time Sheet")),
  'SA_TIME_SHEET_TABLE' => array(SS_ATTENDANCE|4, _("Time Sheet Table")),
  'SA_TIME_SHEET_EDIT' => array(SS_ATTENDANCE|5, _("Time Sheet Edit")),
  'SA_TIME_SHEET_REPORT' => array(SS_ATTENDANCE|6, _("Time Sheet Report")),
  'SA_TIME_SHEET_DIMENSION_REPORT' => array(SS_ATTENDANCE|7, _("Time Sheet Dimension Wise Report")),
  'SA_PAYROLL_PAYMENT' => array(SS_ATTENDANCE|8, _("Payroll Payment")),
  //report 
  'SA_SALARY_REPORT' => array(SS_ATTENDANCE|9, _("Salary Report")),
  'SA_AUDIT_TRAIL_REPORT' => array(SS_ATTENDANCE|10, _("Audit Trail Payroll")),
  'SA_WPS_REPORT' => array(SS_ATTENDANCE|11, _("WPS Report")),
  	//leave Management

  'SA_LEAVE_APPLICATION' => array(SS_LEAVE_MANAGEMENT|1, _("Leave Application")),
  'SA_LEAVE_DASHBOARD' => array(SS_LEAVE_MANAGEMENT|2, _("Leave Dashboard")),
  'SA_LEAVE_FORMULA' => array(SS_LEAVE_MANAGEMENT|3, _("Leave Formula")), 
    'SA_LEAVE_FORMULA_DASHBOARD' => array(SS_LEAVE_MANAGEMENT|4, _("Leave Formula Dashboard")),
  'SA_LEAVE' => array(SS_LEAVE_MANAGEMENT|5, _("Leave ")), 
  'SA_LEAVE_ENTITLEMENT' => array(SS_LEAVE_MANAGEMENT|6, _("Employee Leave Entitlement")),
  'SA_CREATE_LEAVE_GROUP' => array(SS_LEAVE_MANAGEMENT|7, _("Create Leave Group")),
  'SA_LEAVE_GROUP_DASHBOARD' => array(SS_LEAVE_MANAGEMENT|8, _("Leave Group Dashboard")),
  'SA_OPENNING_BALANCE' => array(SS_LEAVE_MANAGEMENT|9, _("Openning Balance")),  
  'SA_VIEW_PAYSLIP' => array(SS_LEAVE_MANAGEMENT|10, _("View Payslip")), 
  'SA_GROUP_EMP_VIEW' => array(SS_LEAVE_MANAGEMENT|11, _("Employee Leave Group View")),
  'SA_LEAVE_MANAGEMENT_REPORT' => array(SS_LEAVE_MANAGEMENT|12, _("Leave Managment Report")),
  'SA_LEAVE_HISTORY_REPORT' => array(SS_LEAVE_MANAGEMENT|13, _("Leave History Report")),
   //Temp allowance and deduction 

  'SA_ADD_ALLOW_AND_DEDUCT' => array(SS_ALLOW_AND_DEDUCT|1, _("Add Temp Allow & Deduct")),
  'SA_ALLOW_AND_DEDUCT_DASHBOARD' => array(SS_ALLOW_AND_DEDUCT|2, _("Temp Allow & Deduct Dashboard")),

//Leave managment System
  'SA_LEAVE_FORMULA' => array(SS_LEAVE_MANAGEMENT_SETUP|1, _("Leave Formula")), 
  'SA_CREATE_LEAVE_GROUP' => array(SS_LEAVE_MANAGEMENT_SETUP|2, _("Create Leave Group")),
  'SA_LEAVE' => array(SS_LEAVE_MANAGEMENT_SETUP|3, _("Leave ")), 





// reports


  //loan Management
'SA_CREATE_LOAN_TYPE'  => array(SS_LOAN_MANAGEMENT|1, _("Create Loan Type")),
  'SA_LOAN' => array(SS_LOAN_MANAGEMENT|2, _("Loan Application")),
  'SA_LOAN_DASHBOARD' => array(SS_LOAN_MANAGEMENT|3, _("Loan Request Dashboard")),

// Payroll Configuration --

  'SA_PR_TITLE' => array(SS_PAYROLL_CONFIG|1, _("Payroll title")),
  'SA_PR_GENDER' => array(SS_PAYROLL_CONFIG|2, _("Payroll Gender")),
  'SA_PR_GRADE' => array(SS_PAYROLL_CONFIG|3, _("Payroll grade")),
  'SA_PR_ALLOWNCE' => array(SS_PAYROLL_CONFIG|4, _("Payroll allownce")),
  'SA_PR_DEDUCTION' => array(SS_PAYROLL_CONFIG|5, _("Payroll deductions")),
    'SA_PR_BANK' => array(SS_PAYROLL_CONFIG|6, _("Payroll bank")),
  'SA_PR_DEPARTMENT' => array(SS_PAYROLL_CONFIG|7, _("Payroll Department")), 	//zaid
  'SA_PR_DOCUMENT' => array(SS_PAYROLL_CONFIG|8, _("Payroll Document")), 	//zaid
  'SA_PR_DESIGNATION' => array(SS_PAYROLL_CONFIG|9, _("Payroll Designation")), 	//zaid
  'SA_PR_WEEKEND' => array(SS_PAYROLL_CONFIG|10, _("Payroll Weekend")), 		//zaid
  'SA_PR_HOLIDAYS' => array(SS_PAYROLL_CONFIG|11, _("Payroll Holidays")), 		

// Payroll management -- 	

  'SA_PR_PAYROLL_DASHBOARD' => array(SS_PAYROLL_MANAGEMENT|1, _("Payroll Dashboard")), 
   'SA_PR_PAYSLIP_REPORT' => array(SS_PAYROLL_MANAGEMENT|2, _("Payslip Report")), 
   'SA_OT_PAYSLIP_VIEW' => array(SS_PAYROLL_MANAGEMENT|3, _("OverTime Payslip View")), 
   'SA_PR_PPAY' => array(SS_PAYROLL_MANAGEMENT|4, _(" Payroll Payment ")),
   'SA_PR_PPAYALLOC' => array(SS_PAYROLL_MANAGEMENT|5, _("Payroll Payment Allocations")),

// employee management


  'ST_PR_IMP_EMPLOYEE' => array(SS_EMPLOYEE_MANAGEMENT|1, _("Payroll Import Employee")), 		
  'SA_PR_IMP_ALL_DED' => array(SS_EMPLOYEE_MANAGEMENT|2, _("Payroll Import Employee Allowance & Deductions ")),
  'ST_PR_EMPLOYEE' => array(SS_EMPLOYEE_MANAGEMENT|3, _("Payroll Employee")),  //zaid
  'SA_PR_ATTACHDOCUMENTS' => array(SS_EMPLOYEE_MANAGEMENT|4, _("Payroll Employee Attachment")), 

//SS_PAYROLL_INQUIRY_REPORTS //zaid

  'ST_PR_EMPLOYEE_DASH' => array(SS_PAYROLL_INQUIRY_REPORTS|1, _("Employee Dashboard")),
  'ST_PR_EXPIRY_DASH' => array(SS_PAYROLL_INQUIRY_REPORTS|2, _("Expiry Dashboard")),*/


if (!@$SysPrefs->allow_gl_reopen)
	unset($security_areas['SA_GLREOPEN']);
/*
	This function should be called whenever we want to extend core access level system
	with new security areas and/or sections i.e.: 
	. on any page with non-standard security areas
	. in security roles editor
	The call should be placed between session.inc inclusion and page() call.
	Up to 155 security sections and 155 security areas for any extension can be installed.
*/
function add_access_extensions()
{
	global $security_areas, $security_sections, $installed_extensions;

	foreach($installed_extensions as $extid => $ext) {
		// display_error($ext['package']);
		$accext = hook_invoke($ext['package'], 'install_access', $dummy);
		if ($accext == null) continue;

		$scode = 100;
		$acode = 100;
		$extsections = $accext[1];
		$extareas = $accext[0];
		$extcode = $extid<<16;
		
		$trans = array();
		foreach($extsections as $code =>$name) {
			$trans[$code] = $scode<<8;
			// reassign section codes
			$security_sections[$trans[$code]|$extcode] = $name;
			$scode++;
		}
		foreach($extareas as $code => $area) {
			$section = $area[0]&0xff00;
			// extension modules:
			// if area belongs to nonstandard section
			// use translated section codes and
			// preserve lower part of area code
			if (isset($trans[$section])) {
				$section = $trans[$section];
			} 
				// otherwise assign next available
				// area code >99
			$area[0] = $extcode | $section | ($acode++);
			$security_areas[$code] = $area;
			// display_error($area[0]);
		}
	}
}

function check_edit_access($name)
{
	global $input_security;

	$access = @$input_security[$name];

	if (!$access)
		$access = @$input_security['']; // default access level

	if (!$access)
		return true; // if constraint is not defined edit access is allowed

	return  user_check_access($access);
}
/*
	Returns POST value or null if edit access to $name control is forbidden.
*/
function access_post($name, $dflt=null)
{
	if (!check_edit_access($name))
		return $dflt;
	else
		return get_post($name, $dflt);
}

/*
	Returns numeric input value or null if edit access to $name control is forbidden.
*/
function access_num($name, $dflt=null)
{
	if (!check_edit_access($name))
		return $dflt;
	else
		return input_num($name, $dflt);
}
