<?php

global $path_to_root;
include_once($path_to_root."/includes/types.inc");

//----------------------------------------------------------------------------------
//	FrontAccounting global system names. They have to be stored separate from
//	sys types defines to enable inclusion after every language change
//	(which happens for multilanguage bulk reports)
//
global $systypes_array, $bank_account_types, $bank_transfer_types, 
	$payment_person_types, $wo_types_array, $wo_cost_types, $class_types,
	$quick_actions, $quick_entry_types, $stock_types, $tag_types, $bank_owner, $stand_labels,$looking_type,$looking_for , 
	$serious_client, $schedule_type, $schedule_status,$frequency_list, $trans_approval_status, $input_security;

$systypes_array = array (
	 ST_JOURNAL => _("Journal Entry"),
	 ST_BANKPAYMENT => _("Bank Payment"),
	 ST_BANKDEPOSIT => _("Bank Deposit"),
	 ST_BANKTRANSFER => _("Funds Transfer"),
	 ST_SALESINVOICE => _("Sales Invoice"),
	 ST_CUSTCREDIT => _("Customer Credit Note"),
	 ST_CUSTPAYMENT => _("Customer Payment"),
	 ST_CUSTDELIVERY => _("Delivery Note"),
	 ST_LOCTRANSFER => _("Location Transfer"),
	 ST_INVADJUST => _("Inventory Adjustment"),
	 ST_PURCHORDER => _("Purchase Order"),
	 ST_SUPPINVOICE => _("Supplier Invoice"),
     ST_SUPPCREDIT => _("Supplier Credit Note"),
     ST_SUPPAYMENT => _("Supplier Payment"),
     ST_SUPPRECEIVE => _("Purchase Order Delivery"),
     ST_WORKORDER => _("Work Order"),
     ST_MANUISSUE => _("Work Order Issue"),
     ST_MANURECEIVE => _("Work Order Production"),
     ST_SALESORDER => _("Sales Order"),
     ST_SALESQUOTE => _("Sales Quotation"),
     ST_COSTUPDATE => _("Cost Update"),
     ST_DIMENSION => _("Dimension"),
     SM_CUSTOMER => _("Customers"),  //system names define for audit trail
     SM_CUSTBRANCH => _("Customer Branch"), //system names define for audit trail
     SM_GROUPS => _("Sales Groups"), //system names define for audit trail
     SM_RECURRINV => _("Recurrent Invoices"), //system names define for audit trail
     SM_SALESTYPES => _("Sales Types"), //system names define for audit trail
     SM_SALESPERSON => _("Sales Person"), //system names define for audit trail
     SM_SALESAREAS => _("Sales Areas"), //system names define for audit trail
     SM_CREDITSTATUS => _("Credit Status"), //system names define for audit trail
     SM_SUPPLIERS => _("Suppliers"), //system names define for audit trail
     SM_ITEMSTOCK => _("Items"), //system names define for audit trail
     SM_ITEMSCODES => _("Foreign Item Codes"), //system names define for audit trail
     SM_SALESKITS => _("Sales Kits"), //system names define for audit trail
     SM_ITEMCATEGORY => _("Item Categories"), //system names define for audit trail
     SM_ITEMLOC => _("Inventory Locations"), //system names define for audit trail
     SM_UNITS => _("Units of Measure"), //system names define for audit trail
     SM_LOCSTOCK => _("Reorder Levels"), //system names define for audit trail
     SM_ITEMPRICE => _("Sales prices"), //system names define for audit trail
     SM_PURDATA => _("Purchasing Data"), //system names define for audit trail
     SM_BOM => _("Bill Of Materials"), //system names define for audit trail
     SM_WORKCENTRE => _("Work Centres"), //system names define for audit trail
     ST_FACLASS => _("Fixed Assets Classes"), //system names define for audit trail
     SM_BUDGET => _("Budget Entry"), //system names define for audit trail
     SM_BANKACC => _("Bank Accounts"), //system names define for audit trail
     SM_QUICK => _("Quick Entries"), //system names define for audit trail
     SM_QUICKLINES => _("Quick Entry Lines"), //system names define for audit trail
     SM_CURRENCY => _("Currency"),
     SM_CURRENCY_EXCHANGE => _("Exchange Rate"),
     SM_GL_ACCOUNT => _("Chart of Accounts"),
     ST_USER => _("User"),
//==============HRM-============================================
     SA_HRMEMP => _("Employee"), //system names define for audit trail
     SA_HRMDOCTYPE => _("HRM Document Type"), //system names define for audit trail
     SA_HRMDEPARTMENT => _("HRM Department"), //system names define for audit trail
     SA_HRMOVERTIME => _("HRM Manage Overtime"), //system names define for audit trail
     SA_HRMDEFSETTING => _("HRM Default Setting"), //system names define for audit trail
     SA_HRMSALSCALE => _("HRM Salary Scales"), //system names define for audit trail
     SA_HRMALLOWDEDACC => _("HRM Allowance and Deduction Amount"), //system names define for audit trail
     SA_HRMALLODEDRULE => _("HRM Allowance and Deduction Rules"), //system names define for audit trail
     SA_HRMSALSTRUCTURE => _("HRM Salary Structure"), //system names define for audit trail
     SA_HRMATTENDANCE => _("HRM Attendance"), //system names define for audit trail
     SA_HRMLEAVE => _("HRM Leave"), //system names define for audit trail
     SA_HRMPAYSLIP => _("HRM Payslip Entry"), //system names define for audit trail
     SA_HRMDOCUMENTEXP => _("HRM Document Expiration"), //system names define for audit trail
     SA_HRMPAYADVICE => _("HRM Payment Advice"), //system names define for audit trail
     SA_HRMEMPDVANCE => _("HRM Employee Advances"), //system names define for audit trail

//=============================================================
    ST_PAYROLL_TITLE => _("Create Titles"), //..................payroll configuration......
    ST_PAYROLL_GRADE => _("Create Grades"), //..................payroll configuration......
    ST_PAYROLL_GENDER => _("Create Genders"), //..................payroll configuration......
    ST_PAYROLL_DEDUCTIONS => _("Create Deductions"), //..................payroll configuration......
    ST_PAYROLL_ALLOWNCE => _("Create Allowances"), //..................payroll configuration......
    ST_PAYROLL_DEPARTMENTS => _("Create Departments"), //..................payroll configuration......
    ST_PAYROLL_DOCUMENT => _("Create Documents"), //..................payroll configuration......
    ST_PAYROLL_BANK => _("Create Banks"), //..................payroll configuration......
    ST_PAYROLL_DESIGNATION => _("Create Designations"), //..................payroll configuration......
	ST_CREATE_HOLIDAYS => _("Create Holidays"),
    ST_PAYROLL_EMPLOYEE => _("Create Employee"),
    ST_PAYROLL_IMP_EMPLOYEE => _("Import_Employee_Information"),
    ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT => _("Import_Employee_Allowances_Deductions"),
    ST_PAYROLL_ATTACH_DOCUMENTS => _("Attach_Documents"),
    ST_ATTENDANCE =>_('Mark Attendance'),
      ST_LEAVE_MANAGEMENT =>_('Leave Management'),
       ST_LOAN_MANAGEMENT =>_('Loan Management'),
        ST_ALLOW_AND_DEDUCT =>_('Temporary Allowances $ Deductions'),
        ST_CREATE_WEEKENDS => _('Create Weekends'),

        SM_BUDGETENTRY => _("Budget Entry"),
        SM_RECONCILE => _("Reconcile"),
        SM_ACCURALS => _("Accurals"),
    SM_ACCOUNT_CLASS => _("GL Account Class"),
	SM_ACCOUNT_TYPE => _("GL Account Group"),
    SM_TAG_ACCOUNT   => _("Account Tag"),
     SM_ATTACHDOC   => _("Attachment"),
      SM_SENDSMS   => _("Send Message "),
	SM_TAG_DIMENSION => _("Dimension Tag"),
	ST_CUSTRELMANG => _("Customer Relationship Management"),
	ST_ADDOPPORTUNITY => _("Add Opportunity"),
		ST_AGREEMENT => _("Subscription Agreement "),

			ST_REALESTATE => _("Real State form")
	);


	/*Names Define for Standard Form Labels*/
$stand_labels = array (
		SL_CUST => _("Customer")
);

$schedule_type = array(
	SC_INSTALL => _("Installation"),
	SC_MAINATAIN => _("Maintenance"),
	SC_COMPLAIN => _("Complain"),
);

$frequency_list = array(
    _("None"),
	ST_ANNUALLY => _("Annual"),
	ST_SEMIANNUALLY => _("Semi Annual"),
	ST_QUARTERLY => _("Quarterly"),
	ST_MONTHLY => _("Monthly"),
);

$schedule_status = array(
	0 => _("Waiting to process"),
	1 => _("Saved as draft"),
	2 => _("Delivered"),
);


$fa_systypes_array = array (
	ST_INVADJUST => _("Fixed Assets Disposal"),
	ST_COSTUPDATE => _("Fixed Assets Revaluation"),
	);

$type_shortcuts = array(
	ST_JOURNAL => _("GJ"), // general journal
	ST_BANKPAYMENT => _("BP"),
	ST_BANKDEPOSIT => _("BD"),
	ST_BANKTRANSFER => _("BT"),
	ST_SALESINVOICE => _("SI"),
	ST_CUSTCREDIT => _("CN"),
	ST_CUSTPAYMENT => _("CP"),
	ST_CUSTDELIVERY => _("DN"),
	ST_LOCTRANSFER => _("IT"), // inventory transfer
	ST_INVADJUST => _("IA"),
	ST_PURCHORDER => _("PO"),
	ST_SUPPINVOICE => _("PI"), // purchase invoice
	ST_SUPPCREDIT => _("PC"),
	ST_SUPPAYMENT => _("SP"),
	ST_SUPPRECEIVE => _("GRN"),
	ST_WORKORDER => _("WO"),
	ST_MANUISSUE => _("WI"),
	ST_MANURECEIVE => _("WP"),
	ST_SALESORDER => _("SO"),
	ST_SALESQUOTE => _("SQ"),
	ST_COSTUPDATE => _("CU"),
	ST_DIMENSION => _("Dim")
);


//----------------------------------------------------------------------------------
//		Bank transaction types
//
$bank_account_types = array (
	BT_TRANSFER => _("Savings Account"),
		_("Chequing Account"),
		_("Credit Account"),
		_("Cash Account")
	);

$bank_transfer_types = array(
	BT_TRANSFER => _("Transfer"),
			_("Cheque"),
			_("Credit"),
			_("Cash")
	);



$trans_approval_status = array(
		0 => "Unapproved",
		2 => "First Approval",
		1 => "Approved",
);



/*=================================================================================*/
$systypes_array_copy=array();
foreach($systypes_array as $key => $value){
	$systypes_array_copy[$key] = $value;

}

/*====================================================================================================*/
/*Creating a Function To Replace the Transaction Type Array*/
$conn = mysqli_connect($db_connections[0]['host'],$db_connections[0]['dbuser'],$db_connections[0]['dbpassword'],$db_connections[0]['dbname']);

$sql = "SELECT `change_name`,`trans_type` FROM 0_reflines WHERE `change_name` <> ''";
		if($result = mysqli_query($conn , $sql)){
			while($row = mysqli_fetch_assoc($result)){
				$systypes_array[$row['trans_type']] = $row['change_name']; 
			}
		}
/*========================================================*/

$ser = SL_CUST;
foreach ($stand_labels as $scr_name){
 $sql = "SELECT * FROM `0_modules` WHERE submodule != '0' AND screen = '$scr_name'";
	if($result = mysqli_query($conn , $sql)){
		while($row = mysqli_fetch_assoc($result)){
		  	// $stand_labels[$ser] = $row['name']; 
		}
	}
$ser++;
}


/*====================================================================================================*/


//----------------------------------------------------------------------------------
//	Payment types
//
$payment_person_types = array (
	PT_MISC => _("Miscellaneous"),
				_("Work Order"),
				_("Customer"),
				_("Supplier"),
				_("Quick Entry"),								
				_("Employee"),
				_("Payroll")
	);
//----------------------------------------------------------------------------------
//	Manufacturing types
//
$wo_types_array = array (
	WO_ASSEMBLY => _("Assemble"),
	WO_UNASSEMBLY => _("Unassemble"),
	WO_ADVANCED => _("Advanced Manufacture")
	);

$wo_cost_types = array(
	WO_LABOUR => _("Labour Cost"),
	WO_OVERHEAD => _("Overhead Cost"),
	WO_MATERIALS => _("Materials")
);

//----------------------------------------------------------------------------------
//	GL account classes
//
$class_types = array(
	CL_ASSETS => _("Assets"),
	CL_LIABILITIES => _("Liabilities"),
	CL_EQUITY => _("Equity"),
	CL_INCOME => _("Income"),
	CL_COGS => _("Cost of Goods Sold"),
	CL_EXPENSE => _("Expense"),
);

//----------------------------------------------------------------------------------
//	Quick entry types
//
$quick_actions = array(
	'=' => _('Remainder'), // post current base amount to GL account
	'a' => _('Amount'), // post amount to GL account
	'a+' => _('Amount, increase base'), // post amount to GL account and increase base
	'a-' => _('Amount, reduce base'), // post amount to GL account and reduce base
	'%' => _('% amount of base'),	// store acc*amount% to GL account
	'%+' => _('% amount of base, increase base'),	// ditto & increase base amount
	'%-' => _('% amount of base, reduce base'),	// ditto & reduce base amount
	'T' => _('Taxes added'), // post taxes calculated on base amount
	'T+' => _('Taxes added, increase base'), // ditto & increase base amount
	'T-' => _('Taxes added, reduce base'), // ditto & reduce base amount
	't' => _('Taxes included'), // post taxes calculated on base amount
	't+' => _('Taxes included, increase base'), // ditto & increase base amount
	't-' => _('Taxes included, reduce base') // ditto & reduce base amount
);


$crm_status = array( // This array is also defiened in edit_celender.php 
		'1' =>_("Prospect"),
		'2' =>_("Proposal"),
		'3' =>_("Deal"),
		'4' =>_("Dead")
	);

$quick_entry_types = array(
	QE_DEPOSIT => _("Bank Deposit"),
	QE_PAYMENT => _("Bank Payment"),
	QE_JOURNAL => _("Journal Entry"),
	QE_SUPPINV => _("Supplier Invoice/Credit")
);

//----------------------------------------------------------------------------------
// depreciation methods
$depreciation_methods = array(
  'D' => _("Declining balance"),
  'S' => _("Straight line"),
  'N' => _("Sum of the Year Digits"),
  'O' => _("One-time"),
);

//----------------------------------------------------------------------------------
// Types of stock items
$stock_types = array(
	'M' => _("Manufactured"),
	'B' => _("Purchased"),
	'D' => _("Service")
);

//----------------------------------------------------------------------------------

$tag_types = array (
	TAG_ACCOUNT   => _("Account"),
	TAG_DIMENSION => _("Dimension")
);

//----------------------------------------------------------------------------------
// crm contacts categories
$sys_crm_cats = array (
	'cust_branch' => _("Customer branch"),
	'supplier' => _("Supplier"),
	'shipper' => _("Shipper"),
	'company' => _("Company internal")
);
//----------------------------------------------------------------------------------

$pterm_types = array(
	PTT_PRE => _("Prepayment"),
	PTT_CASH => _("Cash"),
	PTT_DAYS => _("After No. of Days"),
	PTT_FOLLOWING => _("Day In Following Month")
);

$tax_algorithms = array( 
	TCA_LINES => _("Sum per line taxes"), 
	TCA_TOTALS => _("Taxes from totals")
);
//----------------------------------------------------------------------------------

$bank_owner_types = array(
	BO_UNKNOWN => _("Unknown"),
	BO_COMPANY => _("Company"),
	BO_CUSTBRANCH => _("Customer"),
	BO_SUPPLIER => _("Supplier")
);

// This month array is for use with the last 3 dateformats. 
$tmonths = array("", _("Jan"),_("Feb"),_("Mar"),_("Apr"),_("May"),_("Jun"),_("Jul"),_("Aug"),_("Sep"),_("Oct"),_("Nov"),_("Dec"));

//
//	FA supported db backend language settings.
//
$supported_collations = array(
  'utf8_xx' => _('Unicode (multilanguage)'),
  'utf8_is' => _('Icelandic'),
  'utf8_lv' => _('Latvian'),
  'utf8_ro' => _('Romanian'),
  'utf8_sl' => _('Slovenian'),
  'utf8_pl' => _('Polish'),
  'utf8_et' => _('Estonian'),
  'utf8_es' => _('Spanish'), // or 'spanish2',
  'utf8_sw' => _('Swedish'),
  'utf8_tr' => _('Turkish'),
  'utf8_cs' => _('Czech'),
  'utf8_da' => _('Danish'),
  'utf8_lt' => _('Lithuanian'),
  'utf8_sk' => _('Slovak'),
  'utf8_sp' => _('Spanish (alternative)'),
  'utf8_fa' => _('Persian'),
  'utf8_hu' => _('Hungarian'),
  'utf8_fr' => _('French'),
  'utf8_it' => _('Italian'),
);


$looking_for = array(
	ST_TOWHOUSE => "Town House",
	ST_VILLA => "Villa",
	ST_APARTMENT => "Apartment",
);

$looking_type = array(
	ST_PURCHASETYPE => "Purchase",
	ST_RENTTYPE => "Rent",
);

$serious_client = array(
	ST_SLOW => "Slow",
	ST_MEDIUM => "Medium",
	ST_HOT => "Hot",
);


$property_type = array(
	ST_READY => "Ready",
	ST_OFFPLAN => "Off-Plan",
);

$availability_type = array(
	ST_VACANT => "Vacant",
	ST_RENTED => "Rented",
	ST_NOPREFERNCE => "No Preference",
	ST_OWNEROCCUPIED => "Owner Occupied",
);


$payment_pref = array(
	ST_CASHBUYER => "Cash Buyer",
	ST_FINANCEAPPROVED => "Finance Approved",
);

$offer_type = array(
	ST_SALE => "Sale",
	ST_RENT => "Rent",
);

$financial_status = array(
	ST_MORTGAGEPENDING => "Mortgage Pending",
	ST_CASHPAID => "Cash Paid",
);

// $input_security = array(
//                     'ref' => true,
//                     'reference' => true,
//                     );

