<?php

//----------------------------------------------------------------------------------
//	FrontAccounting system transaction types
//
define('ST_JOURNAL', 0);


define('ST_BANKPAYMENT', 1);
define('ST_BANKDEPOSIT', 2);
define('ST_BANKTRANSFER', 4);


define('ST_SPECIFICATION', 5);

define('ST_SALESINVOICE', 10);
define('ST_CUSTCREDIT', 11);
define('ST_CUSTPAYMENT', 12);
define('ST_CUSTDELIVERY', 13);

define('ST_LOCTRANSFER', 16);
define('ST_INVADJUST', 17);

define('ST_PURCHORDER', 18);
define('ST_SUPPINVOICE', 20);
define('ST_SUPPCREDIT', 21);
define('ST_SUPPAYMENT', 22);
define('ST_SUPPRECEIVE', 25);

define('ST_WORKORDER', 26);
define('ST_MANUISSUE', 28);
define('ST_MANURECEIVE', 29);
//----------------------------------------
  // bar code and QR code 
define('ST_BAR_CODE', 3033);
define('ST_QR_CODE', 3034);


define('ST_CUSTRELMANG', 3035);
define('ST_ADDOPPORTUNITY', 3036);
define('ST_ATTACHVIEW', 3038);



define('ST_CONT_OPPORTUNIT', 3037);
define('ST_CONTACT_PERSON', 3039);
define('ST_OPPORTUNITY', 3040);
define('ST_OPPORTUNITY_COMMENT', 3041);
define('ST_CMRNOTES', 3042);
define('ST_REALESTATE', 3043);

define('SM_COMPLAINTTYPES', 4001);
define('ST_COMPLAINT', 4002);


define('ST_AGREEMENT', 4003);
define('SA_AGREEMENT_PRICING', 4004);


// define('CRM_PROSPECT', 3042);
// define('CRM_PROPOSAL', 3043);
// define('CRM_DEAL', 3044);
// define('CRM_DEAD', 3045);
// define('ST_UPDATE_CONTACT_PERSON', 3040);





//...............payroll configuration......
define('ST_CREATE_HOLIDAYS', 116);  
define('ST_CREATE_WEEKENDS', 117);  
define('ST_PAYROLL_BANK', 95);

define('ST_USER', 118);



define('ST_PAYROLL_DEDUCTIONS', 101);
define('ST_PAYROLL_ALLOWNCE', 102);
define('ST_PAYROLL_DEPARTMENTS', 93);
define('ST_PAYROLL_DOCUMENT', 94);


define('ST_PAYROLL_DESIGNATION', 96);
define('ST_PAYROLL_TITLE', 97);
define('ST_PAYROLL_GRADE', 98);
define('ST_PAYROLL_GENDER', 100);


define('ST_PAYROLL_EMPLOYEE', 99);
define('ST_PAYROLL_IMP_EMPLOYEE', 104);
define('ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT', 105);


define('ST_PAYROLL_ATTACH_DOCUMENTS', 106);

//frequency Types
define('ST_ANNUALLY', 1);
define('ST_SEMIANNUALLY', 2);
define('ST_QUARTERLY', 4);
define('ST_MONTHLY', 12);


//--------------------------------------
define('ST_ATTENDANCE', 107);
// define('ST_TIMESHEET',108);
define('ST_LEAVE_MANAGEMENT', 109);
define('ST_LOAN_MANAGEMENT', 110);
define('ST_ALLOW_AND_DEDUCT', 111);
// define('ST_PAYSLIP', 113);
define('ST_PAYROLL_GENERATE',112);
//
//	Depreciation period types
//
define('FA_MONTHLY', 0);
define('FA_YEARLY', 1);

define('ST_SALESORDER', 30);
define('ST_SALESQUOTE', 32);
define('ST_COSTUPDATE', 35);
define('ST_DIMENSION', 40);

define('ST_SCHEDULE', 31);


// Don't include these defines in the $systypes_array.
// They are used for documents only.
define ('ST_STATEMENT', 91);
define ('ST_CHEQUE', 92);
define('ST_CHARGES',915);

//all form Maintenance types for audit trails

define('SM_CUSTOMER', 1001);
define('SM_CUSTBRANCH', 1002);
define('SM_GROUPS', 1003);
define('SM_RECURRINV', 1004);
define('SM_SALESTYPES', 1005);
define('SM_SALESPERSON', 1006);
define('SM_SALESAREAS', 1007);
define('SM_TECHNICIAN', 10071);
define('SM_CREDITSTATUS', 1008);
define('SM_SUPPLIERS', 1009);
define('SM_ITEMSTOCK', 1010);
define('SM_ITEMSCODES', 1011);
define('SM_SALESKITS', 1012);
define('SM_ITEMCATEGORY', 1013);
define('SM_ITEMLOC', 1014);
define('SM_UNITS', 1015);
define('SM_LOCSTOCK', 1016);
define('SM_ITEMPRICE', 1017);
define('SM_PURDATA', 1018);
define('SM_BOM', 1019);
define('SM_WORKCENTRE', 1020);
define('ST_FACLASS', 1021);
define('SM_BUDGET', 1022);
define('SM_BANKACC', 1023);
define('SM_QUICK', 1024);
define('SM_QUICKLINES', 1025);
define('SM_CURRENCY', 1026);
define('SM_CURRENCY_EXCHANGE', 1027);
define('SM_GL_ACCOUNT', 1028);
define('SM_ACCOUNT_TYPE', 1029);
define('SM_ACCOUNT_CLASS', 1030);
define('SM_ATTACHDOC', 1031);
define('SM_SENDSMS', 1032);
//=====================HRM===============================
define('SA_HRMEMP', 2001);
define('SA_HRMDOCTYPE', 2002);
define('SA_HRMDEPARTMENT', 2003);
define('SA_HRMOVERTIME', 2004);
define('SA_HRMDEFSETTING', 2005);
// define('SA_HRMDEFSETTING', 2006);
define('SA_HRMSALSCALE', 2007);
define('SA_HRMALLOWDEDACC', 2008);
define('SA_HRMALLODEDRULE', 2009);
define('SA_HRMSALSTRUCTURE', 2010);
define('SA_HRMATTENDANCE', 2011);
define('SA_HRMLEAVE', 2012);
define('SA_HRMPAYSLIP', 2013);
define('SA_HRMDOCUMENTEXP', 2014);
define('SA_HRMPAYADVICE', 2015);
define('SA_HRMEMPDVANCE', 2016);

define('ST_BUYER', 1);
define('ST_SELLER', 2);

define('ST_TOWHOUSE', 1);
define('ST_VILLA', 2);
define('ST_APARTMENT', 3);




define('ST_READY', 1);
define('ST_OFFPLAN', 2);

define('ST_VACANT', 1);
define('ST_RENTED', 2);
define('ST_NOPREFERNCE', 3);
define('ST_OWNEROCCUPIED', 4);


define('ST_CASHBUYER', 1);
define('ST_FINANCEAPPROVED', 2);

define('ST_SALE', 1);
define('ST_RENT', 2);

define('ST_MORTGAGEPENDING', 1);
define('ST_CASHPAID', 2);



define('ST_PURCHASETYPE', 1);
define('ST_RENTTYPE', 2);



define('ST_SLOW', 1);
define('ST_MEDIUM', 2);
define('ST_HOT', 3);


//=======================================================


define('SUPINQ', 33);                                                                                         
define('PURINQ', 34); 
define('SUPPALLOC', 351); 
define('ITEMSTAT', 36);
define('ITEMMOV', 37); 
define('JOURINQ', 38);
define('BANKINQ', 39);
define('BNKINQ', 41);
define('TAXINQ', 42);
define('DIMINQ', 43);


//Schedule Types
define('SC_INSTALL', 1);
define('SC_MAINATAIN', 2);
define('SC_COMPLAIN', 3);



// document inheritance
$document_child_types = array(
		ST_SALESQUOTE => ST_SALESORDER,
		ST_SALESORDER => ST_CUSTDELIVERY,
		ST_CUSTDELIVERY => ST_SALESINVOICE,
		ST_SALESINVOICE => ST_CUSTCREDIT,

		ST_PURCHORDER => ST_SUPPRECEIVE,
		ST_SUPPRECEIVE => ST_SUPPINVOICE,
		ST_SUPPINVOICE => ST_SUPPCREDIT,
);

function get_child_type($type)
{
	global $document_child_types;
	return isset($document_child_types[$type]) ? $document_child_types[$type] : 0;
}

function get_parent_type($type)
{
	global $document_child_types;
	$child = array_search($type, $document_child_types);
	return $child ? $child : 0;
}

//----------------------------------------------------------------------------------
//		Bank transaction types
//
define('BT_TRANSFER', 0);
define('BT_CHEQUE', 1);
define('BT_CREDIT', 2);
define('BT_CASH', 3);

include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_db.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/dimensions/includes/dimensions_db.inc");
//----------------------------------------------------------------------------------
//	Payment types
//
define('PT_MISC', 0);
define('PT_WORKORDER', 1);
define('PT_CUSTOMER', 2);
define('PT_SUPPLIER', 3);
define('PT_QUICKENTRY', 4);
define('PT_DIMESION', 5);

function payment_person_currency($type, $person_id)  {
	switch ($type)
	{
		case PT_MISC :
		case PT_QUICKENTRY :
		case PT_WORKORDER :
			return get_company_currency();

		case PT_CUSTOMER :
			return get_customer_currency($person_id);

		case PT_SUPPLIER :
			return get_supplier_currency($person_id);

		default :
			return get_company_currency();
	}
}

function payment_person_name($type, $person_id, $full=true) {
	global $payment_person_types;

	switch ($type)
	{
		case PT_MISC :
			return $person_id;
		case PT_QUICKENTRY :
			$qe = get_quick_entry($person_id);
			return ($full ? $payment_person_types[$type] . " ":"") . $qe["description"];
		case PT_WORKORDER :
			global $wo_cost_types;
			return get_trans_view_str(ST_WORKORDER, $person_id, _('Work Order').' '.$person_id);
		case PT_CUSTOMER :
			return ($full ?$payment_person_types[$type] . " ":"") . sprintf("[%05s] %s", $person_id, get_customer_name($person_id));
		case PT_SUPPLIER :
			return ($full ? $payment_person_types[$type] . " ":"") . sprintf("[%05s] %s", $person_id, get_supplier_name($person_id));
		default :
			return '';
	}
}

function payment_person_has_items($type) {
	switch ($type)
	{
		case PT_MISC :
			return true;
		case PT_QUICKENTRY :
			return db_has_quick_entries();
		case PT_WORKORDER : // 070305 changed to open workorders JH
			return db_has_open_workorders();
		case PT_CUSTOMER :
			return db_has_customers();
		case PT_SUPPLIER :
			return db_has_suppliers();
		default :
			display_db_error("Invalid type sent to has_items", "");
			return false;
	}
}
//----------------------------------------------------------------------------------
//	Payment terms categories
//
define('PM_ANY', 0);
define('PM_CASH', 1);
define('PM_CREDIT', 2);

//----------------------------------------------------------------------------------
//	Manufacturing types
//
define('WO_ASSEMBLY', 0);
define('WO_UNASSEMBLY', 1);
define('WO_ADVANCED', 2);

define('WO_LABOUR', 0);
define('WO_OVERHEAD', 1);
define('WO_MATERIALS', 2);

//----------------------------------------------------------------------------------
//	GL account classes
//
define('CL_NONE', 0); // for backward compatibility
define('CL_ASSETS', 1);
define('CL_LIABILITIES', 2);
define('CL_EQUITY', 3);
define('CL_INCOME', 4);
define('CL_COGS', 5);
define('CL_EXPENSE', 6);

function get_class_type_convert($ctype)
{
	global $SysPrefs;

	if (isset($SysPrefs->use_oldstyle_convert) && $SysPrefs->use_oldstyle_convert == 1)
		return (($ctype >= CL_INCOME || $ctype == CL_NONE) ? -1 : 1);
	else	
		return ((($ctype >= CL_LIABILITIES && $ctype <= CL_INCOME) || $ctype == CL_NONE) ? -1 : 1);
}
//----------------------------------------------------------------------------------
//	Quick entry types
//
define('QE_PAYMENT', '1');
define('QE_DEPOSIT', '2');
define('QE_JOURNAL', '3');
define('QE_SUPPINV', '4');

//----------------------------------------------------------------------------------
//	Special option values for various list selectors.
//
define('ANY_TEXT', '');
define('ANY_NUMERIC', -1);
define('ALL_TEXT', '');
define('ALL_NUMERIC', -1);

//----------------------------------------------------------------------------------
// Special class values for tables (start_table())
define('TABLESTYLE',  1);
define('TABLESTYLE2', 2);
define('TABLESTYLE_NOBORDER', 3);
define('TABLESTYLE3',  4);
define('TABLESTYLE4', 5);

#use for internal view heading
define('HEAD_COLOR',"style='font-size: 40px; color: #3fd1ff;'");



//----------------------------------------------------------------------------------
define('TAG_ACCOUNT',   1);
define('TAG_DIMENSION', 2);
define('SM_TAG_ACCOUNT',   114);
define('SM_TAG_DIMENSION', 115);
define('SM_BUDGETENTRY', 120);
define('SM_RECONCILE', 121);
define('SM_ACCURALS', 122);

//----------------------------------------------------------------------------------
// Payment term types

define('PTT_PRE', 1);
define('PTT_CASH', 2);
define('PTT_DAYS', 3);
define('PTT_FOLLOWING', 4);

//----------------------------------------------------------------------------------
// Tax calculation algorithms used in als and purchase (depends on supplier's invoicing software)

define('TCA_TOTALS', 1); // taxes are calculated from respective net totals for all lines
define('TCA_LINES', 2); // taxes calculated for every line, then summed
//
//	Bank account owner types
//
define('BO_UNKNOWN', 0);
define('BO_COMPANY', 1);
define('BO_CUSTBRANCH', 2);
define('BO_SUPPLIER', 3);

include_once($path_to_root . '/includes/sysnames.inc');

// tax register type
define('TR_OUTPUT', 0); // sales
define('TR_INPUT', 1);	// purchase
//---------------------------------------------------------------------------------
// Constants optionally redefined locally
//
defined('ICON_EDIT2') || define('ICON_EDIT2', 'edit.gif');
// defined('ICON_DELETE') || define('ICON_DELETE', 'delete.gif');
defined('ICON_EDIT') || define('ICON_EDIT', 'edit2.gif');
defined('ICON_DELETE') || define('ICON_DELETE', 'delete2.png');
defined('ICON_ADD')	|| define('ICON_ADD', 'ok.gif');
defined('ICON_UPDATE') || define('ICON_UPDATE', 'ok_1.png');
defined('ICON_OK') || define('ICON_OK', 'ok.gif');
defined('ICON_CANCEL') || define('ICON_CANCEL','cancel.png');
defined('ICON_GL') || define('ICON_GL', 'gl.png');
defined('ICON_PRINT') || define('ICON_PRINT', 'pdf.gif');
defined('ICON_PDF') || define('ICON_PDF', 'print.png');
defined('ICON_DOC') || define('ICON_DOC', 'invoice.gif');
defined('ICON_CREDIT') || define('ICON_CREDIT', 'credit.gif');
defined('ICON_RECEIVE') || define('ICON_RECEIVE', 'receive.gif');
defined('ICON_DOWN') || define('ICON_DOWN', 'download.gif');
defined('ICON_MONEY') || define('ICON_MONEY', 'money.png');
defined('ICON_REMOVE') || define('ICON_REMOVE', 'remove.png');
defined('ICON_REPORT') || define('ICON_REPORT', 'report.png');
defined('ICON_VIEW') || define('ICON_VIEW', 'view.gif');
defined('ICON_SUBMIT') || define('ICON_SUBMIT', 'ok.gif');
defined('ICON_ESCAPE') || define('ICON_ESCAPE', 'escape.png');
defined('ICON_ALLOC') || define('ICON_ALLOC', 'alloc.png');
defined('ICON_CLOSED') || define('ICON_CLOSED', 'closed.png');
defined('ICON_PRINT') || define('ICON_CLOSED', 'print.png');
defined('ICON_REFUND') || define('ICON_REFUND', 'refund.png');
defined('ICON_BAR_CODE') || define('ICON_BAR_CODE', 'foriegn_item_code.png');
defined('ICON_QR_CODE') || define('ICON_QR_CODE', 'qrcode2.png');
defined('ICON_REMOVE1') || define('ICON_REMOVE1', 'remove1.png');
defined('ICON_ADD_BTN') || define('ICON_ADD_BTN', 'addd.jpg');
defined('ICON_SEND') || define('ICON_SEND', 'rfq.png');
defined('ICON_SEND') || define('ICON_SEND', 'rfq.png');
defined('ICON_ATTACH') || define('ICON_ATTACH', 'attachment.png');
defined('ICON_COMMENT') || define('ICON_COMMENT', 'comment.png');
defined('ICON_REMINDER') || define('ICON_REMINDER', 'reminder.png');
