<?php

include_once($path_to_root . "/includes/prefs/sysprefs.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");

class attendance_cart
{
	var $trans_type;
	var $line_items=array();
	var $employee_detail;
	var $gl_items;

	var	$order_id;

	var $from_loc;
	var $to_loc;
	var $tran_date;
	var $doc_date;
	var $event_date;
	var $transfer_type;
	var $increase;
	var $memo_;
	var $branch_id;
	var $reference;
	var $original_amount;
	var $currency;
	var $rate;
	var $source_ref;
	var $vat_category;

	var $tax_info;	// tax info for the GL transaction

	var $fixed_asset;

	function __construct($type, $trans_no=0)
	{
		$this->trans_type = $type;
		$this->order_id = $trans_no;
		$this->clear_items();
		if (in_array($type, array(ST_LOCTRANSFER, ST_INVADJUST, ST_COSTUPDATE, ST_MANUISSUE, ST_MANURECEIVE, ST_JOURNAL)))
			$this->currency = get_company_pref('curr_default');
		$this->rate = 1;
	}

	// --------------- line item functions
	function add_loan($line_no,$month,$year,$ded_amount)
	{
			$this->line_items[$line_no] = new add_loan_line_item($month,$year, $ded_amount);
			return true;
	}
	function update_loan_item($line_no,$month,$year,$ded_amount)
	{

		$this->line_items[$line_no]->month = $month;
		$this->line_items[$line_no]->year = $year;
		$this->line_items[$line_no]->ded_amount = $ded_amount;


	}

	function add_to_attendance($line_no,$hr,$dim,$ot = 0,$ot_factor=0,$attn_date)
	{
	
		if (isset($hr) && $hr != "" && isset($hr))
		{
			$this->line_items[$line_no] = new line_item1($attn_date,$hr, $dim,$ot,$ot_factor);
			return true;
		}
		else
		{
			// shouldn't come here under normal circumstances
			display_error(" Enter Hours ", "", true);
		}

		return false;
	}
	function add_to_employee($line_no,$emp_id,$department_id,$designation_id)
	{
			$this->line_items[$line_no] = new employee_line_item($emp_id,$department_id,$designation_id);
			return true;
		
		
	}
	function add_to_leaveformula($line_no,$allowances)
	{
	

			$this->line_items[$line_no] = new employee_class($employee_id, $name,$department,$designation,$id,$allowances);
				return true;
		
	}
	function add_present_cheq($line_no,$employee_id,$name,$department,$designation,$id=null)
	{
        
		$this->line_items[$line_no] = new employee_class($employee_id,$name,$department,$designation,$id);
		return true;
	}
	function remove_grn_from_trans($id)
	{
		 // cancel tax overrides after cart change
	    unset($this->line_items[$id]);
	}
function import_to_attendance($line_no,$eid,$at_date, $hr, $dim, $ot = 0 ,$remarks,$ot_factor=0)
	{
	
$attn_date = null;
		if (isset($hr) && $hr != "" && isset($hr))
		{																	
			$this->line_items[$line_no] = new line_item1($attn_date,$hr, $dim,$ot,$ot_factor,$eid,$remarks,$at_date);
			return true;
		}
		else
		{
			// shouldn't come here under normal circumstances
			display_error(" Enter Hours ", "", true);
		}

		return false;
	}

	function update_attendance_item($line_no, $hr,$dim,$ot=0, $ot_factor=0,$attn_date)
	{

		$this->line_items[$line_no]->hrs = $hr;
		$this->line_items[$line_no]->dim = $dim;
		$this->line_items[$line_no]->ot = $ot;
		$this->line_items[$line_no]->ot_factor = $ot_factor;
		$this->line_items[$line_no]->attn_date = $attn_date;
	

	}
	function update_employee_item($line_no, $emp_id,$department_id,$designation_id)
	{

		$this->line_items[$line_no]->emp_id = $emp_id;
		$this->line_items[$line_no]->department_id = $department_id;
		$this->line_items[$line_no]->designation_id = $designation_id;
	}
	function update_leaveformula_item($line_no,$allowances)
	{
		$this->line_items[$line_no]->allowances = $allowances;
	
	}
	function remove_from_attendance($line_no)
	{

		array_splice($this->line_items, $line_no, 1);
	}

	function count_items()
	{
		return count($this->line_items);
	}
	// ------------ common functions

	function clear_items()
	{
    	unset($this->line_items);
		$this->line_items = array();

    	unset($this->gl_items);
		$this->gl_items = array();

	}
}

//--------------------------------------------------------------------------------------------

class employee_line_item
{
	var $emp_id;
	var $department_id;
	var $designation_id;
	

	function __construct($emp_id=null,$department_id=null,$designation_id=null)
	{
		
		$this->emp_id = $emp_id;
		$this->department_id = $department_id;
		$this->designation_id = $designation_id;
		
	}
}

class add_loan_line_item
{
	var $month;
	var $year;
	var $ded_amount;


	function __construct($month,$year,$ded_amount)
	{
		
		$this->month = $month;
		$this->year = $year;
		$this->ded_amount = $ded_amount;
		
	}
}

class line_item1
{
	var $eid;
	var $hr;
	var $dim;
	var $ot;
	var $ot_factor;
	var $remarks;
	var $at_date;
	var $attn_date;

	function __construct($attn_date=null,$hr, $dim, $ot=null,$ot_factor=null,$eid=null,$remarks=null,$at_date=null)
	{
		
		$this->hrs = $hr;
		$this->dim = $dim;
		$this->ot = $ot;
		$this->ot_factor = $ot_factor;
		$this->eid = $eid;
		$this->remarks = $remarks;
		$this->at_date = $at_date;
		$this->attn_date=$attn_date;
	}
}

//---------------------------------------------------------------------------------------
class employee_class
{

	var $employee_id;
	var $name;
	var $department;
	var $designation;
	var $id;
	var $allowances;

	

	function __construct($employee_id=null, $name=null,$department=null,$designation=null,$id=null,$allowances=null)
	{
		$this->employee_id = $employee_id;
		$this->name = $name;
		$this->department = $department;
		$this->designation = $designation;
		$this->id = $id;
		$this->allowances = $allowances;
		
	}
}
